/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2ResidenceTeleportZone;
import com.l2jserver.util.Rnd;
import java.util.concurrent.ScheduledFuture;

public class L2ResidenceHallTeleportZone
extends L2ResidenceTeleportZone {
    private int _id;
    private ScheduledFuture<?> _teleTask;

    public L2ResidenceHallTeleportZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("residenceZoneId")) {
            this._id = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    public int getResidenceZoneId() {
        return this._id;
    }

    public synchronized void checkTeleporTask() {
        if (this._teleTask == null || this._teleTask.isDone()) {
            this._teleTask = ThreadPoolManager.getInstance().scheduleGeneral(new TeleportTask(), 30000L);
        }
    }

    class TeleportTask
    implements Runnable {
        TeleportTask() {
        }

        @Override
        public void run() {
            Location loc;
            int index = 0;
            if (L2ResidenceHallTeleportZone.this.getSpawns().size() > 1) {
                index = Rnd.get(L2ResidenceHallTeleportZone.this.getSpawns().size());
            }
            if ((loc = L2ResidenceHallTeleportZone.this.getSpawns().get(index)) == null) {
                throw new NullPointerException();
            }
            for (L2PcInstance pc : L2ResidenceHallTeleportZone.this.getAllPlayers()) {
                if (pc == null) continue;
                pc.teleToLocation(loc, false);
            }
        }
    }
}

