/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrainerHealersInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TransformManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2VillageMasterInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillDone;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class RequestAcquireSkill
extends L2GameClientPacket {
    private static final String _C__7C_REQUESTACQUIRESKILL = "[C] 7C RequestAcquireSkill";
    private static Logger _log = Logger.getLogger(RequestAcquireSkill.class.getName());
    private int _id;
    private int _level;
    private int _skillType;
    private int _subType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = this.readD();
        if (this._skillType == AcquireSkillList.SkillType.SubPledge.ordinal()) {
            this._subType = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._level < 1 || this._level > 1000 || this._id < 1 || this._id > 32000) {
            Util.handleIllegalPlayerAction(activeChar, "Wrong Packet Data in Aquired Skill", Config.DEFAULT_PUNISH);
            _log.warning("Recived Wrong Packet Data in Aquired Skill - id: " + this._id + " level: " + this._level + " for " + activeChar);
            return;
        }
        L2Npc trainer = activeChar.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(activeChar) && !activeChar.isGM()) {
            return;
        }
        AcquireSkillList.SkillType skillType = AcquireSkillList.SkillType.values()[this._skillType];
        if (activeChar.getSkillLevel(this._id) >= this._level && skillType != AcquireSkillList.SkillType.SubPledge) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        if (skill == null) {
            _log.warning("Player " + activeChar.getName() + " is trying to learn a null skill id: " + this._id + " level: " + this._level + "!");
            return;
        }
        if (skillType != AcquireSkillList.SkillType.Transfer && this._level > 1 && activeChar.getKnownSkill(this._id) == null || activeChar.getKnownSkill(this._id) != null && activeChar.getKnownSkill(this._id).getLevel() != this._level - 1) {
            activeChar.sendPacket(SystemMessageId.PREVIOUS_LEVEL_SKILL_NOT_LEARNED);
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!", 0);
            return;
        }
        switch (skillType) {
            case ClassTransform: {
                if (trainer instanceof L2TransformManagerInstance) {
                    if (!L2TransformManagerInstance.canTransform(activeChar)) {
                        activeChar.sendPacket(SystemMessageId.NOT_COMPLETED_QUEST_FOR_SKILL_ACQUISITION);
                        Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without required quests!", 0);
                        return;
                    }
                    L2SkillLearn s = SkillTreesData.getInstance().getTransformSkill(this._id, this._level);
                    if (s != null && s.getPreReqSkillIdLvl() != null && activeChar.getKnownSkill(s.getPreReqSkillIdLvl()[0]) == null) {
                        activeChar.sendPacket(SystemMessageId.YOU_MUST_LEARN_ONYX_BEAST_SKILL);
                        return;
                    }
                    if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                    this.giveSkill(activeChar, trainer, skill);
                    break;
                }
                L2SkillLearn s = SkillTreesData.getInstance().getClassSkill(this._id, this._level, activeChar.getLearningClass());
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case Fishing: {
                L2SkillLearn s = SkillTreesData.getInstance().getFishingSkill(this._id, this._level);
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case Pledge: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                L2Clan clan = activeChar.getClan();
                int itemId = -1;
                int itemCount = -1;
                int repCost = 100000000;
                L2SkillLearn s = SkillTreesData.getInstance().getPledgeSkill(this._id, this._level);
                if (s == null) break;
                repCost = s.getLevelUpSp();
                if (clan.getReputationScore() >= repCost) {
                    if (Config.LIFE_CRYSTAL_NEEDED && s.getItemsIdCount() != null) {
                        for (int[] itemIdCount : s.getItemsIdCount()) {
                            itemId = itemIdCount[0];
                            itemCount = itemIdCount[1];
                            if (itemId <= 0 || itemCount <= 0) continue;
                            if (!activeChar.destroyItemByItemId("Consume", itemId, itemCount, trainer, false)) {
                                activeChar.sendPacket(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL);
                                L2VillageMasterInstance.showPledgeSkillList(activeChar);
                                return;
                            }
                            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                            sm.addItemName(itemId);
                            sm.addItemNumber(itemCount);
                            activeChar.sendPacket(sm);
                        }
                    }
                    clan.takeReputationScore(repCost, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addNumber(repCost);
                    activeChar.sendPacket(cr);
                    clan.addNewSkill(skill);
                    clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                    activeChar.sendPacket(new AcquireSkillDone());
                    L2VillageMasterInstance.showPledgeSkillList(activeChar);
                } else {
                    activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                    L2VillageMasterInstance.showPledgeSkillList(activeChar);
                }
                return;
            }
            case SubPledge: {
                if (!activeChar.isClanLeader()) {
                    return;
                }
                L2Clan clan = activeChar.getClan();
                if (clan.getHasFort() == 0 && clan.getHasCastle() == 0) {
                    return;
                }
                if (!(trainer instanceof L2SquadTrainer)) break;
                int itemId = -1;
                int itemCount = -1;
                int rep = 100000000;
                L2SkillLearn s = SkillTreesData.getInstance().getSubPledgeSkill(this._id, this._level);
                if (s == null) break;
                if (!clan.isLearnableSubPledgeSkill(skill, this._subType)) {
                    activeChar.sendPacket(SystemMessageId.SQUAD_SKILL_ALREADY_ACQUIRED);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " without knowing it's previous level!", 0);
                    return;
                }
                rep = s.getLevelUpSp();
                if (clan.getReputationScore() < rep) {
                    activeChar.sendPacket(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE);
                    return;
                }
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    itemId = itemIdCount[0];
                    itemCount = itemIdCount[1];
                    if (!activeChar.destroyItemByItemId("SubSkills", itemId, itemCount, trainer, false)) {
                        activeChar.sendPacket(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(itemId);
                    sm.addItemNumber(itemCount);
                    activeChar.sendPacket(sm);
                }
                if (rep > 0) {
                    clan.takeReputationScore(rep, true);
                    SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                    cr.addNumber(rep);
                    activeChar.sendPacket(cr);
                }
                clan.addNewSkill(skill, this._subType);
                clan.broadcastToOnlineMembers(new PledgeSkillList(clan));
                activeChar.sendPacket(new AcquireSkillDone());
                ((L2SquadTrainer)((Object)trainer)).showSubUnitSkillList(activeChar);
                return;
            }
            case Transfer: {
                L2SkillLearn s = SkillTreesData.getInstance().getTransferSkill(this._id, this._level, activeChar.getClassId());
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            case SubClass: {
                if (activeChar.isSubClassActive()) {
                    activeChar.sendPacket(SystemMessageId.SKILL_NOT_FOR_SUBCLASS);
                    Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is requesting skill Id: " + this._id + " level " + this._level + " while Sub-Class is active!", 0);
                    return;
                }
                L2SkillLearn s = SkillTreesData.getInstance().getSubClassSkill(this._id, this._level);
                QuestState st = activeChar.getQuestState("SubClassSkills");
                if (st == null) {
                    Quest subClassSkilllsQuest = QuestManager.getInstance().getQuest("SubClassSkills");
                    if (subClassSkilllsQuest != null) {
                        st = subClassSkilllsQuest.newQuestState(activeChar);
                    } else {
                        _log.warning("Null SubClassSkills quest, for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                        return;
                    }
                }
                for (String varName : L2TransformManagerInstance._questVarNames) {
                    for (int i = 1; i <= Config.MAX_SUBCLASS; ++i) {
                        String itemOID = st.getGlobalQuestVar(varName + i);
                        if (itemOID.isEmpty() || itemOID.endsWith(";") || itemOID.equals("0")) continue;
                        if (Util.isDigit(itemOID)) {
                            int itemObjId = Integer.parseInt(itemOID);
                            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(itemObjId);
                            if (item != null) {
                                if (!Util.contains(s.getItemsIdCount()[0], item.getItemId())) continue;
                                if (this.checkPlayerSkill(activeChar, trainer, s)) {
                                    this.giveSkill(activeChar, trainer, skill);
                                    st.saveGlobalQuestVar(varName + i, skill.getId() + ";");
                                }
                                return;
                            }
                            _log.warning("Inexistent item for object Id " + itemObjId + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                            continue;
                        }
                        _log.warning("Invalid item object Id " + itemOID + ", for Sub-Class skill Id: " + this._id + " level: " + this._level + " for player " + activeChar.getName() + "!");
                    }
                }
                activeChar.sendPacket(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL);
                this.showSkillList(trainer, activeChar);
                break;
            }
            case Collect: {
                L2SkillLearn s = SkillTreesData.getInstance().getCollectSkill(this._id, this._level);
                if (!this.checkPlayerSkill(activeChar, trainer, s)) break;
                this.giveSkill(activeChar, trainer, skill);
                break;
            }
            default: {
                _log.warning("Recived Wrong Packet Data in Aquired Skill, unknown skill type:" + this._skillType);
            }
        }
    }

    private boolean checkPlayerSkill(L2PcInstance player, L2Npc trainer, L2SkillLearn s) {
        if (s != null && s.getSkillId() == this._id && s.getSkillLevel() == this._level) {
            if (s.getGetLevel() > player.getLevel()) {
                player.sendPacket(SystemMessageId.YOU_DONT_MEET_SKILL_LEVEL_REQUIREMENTS);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + ", level " + player.getLevel() + " is requesting skill Id: " + this._id + " level " + this._level + " without having minimum required level, " + s.getGetLevel() + "!", 0);
                return false;
            }
            int levelUpSp = s.getCalculatedLevelUpSp(player.getClassId(), player.getLearningClass());
            if (levelUpSp > 0 && levelUpSp > player.getSp()) {
                player.sendPacket(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL);
                this.showSkillList(trainer, player);
                return false;
            }
            if (!Config.DIVINE_SP_BOOK_NEEDED && this._id == 1405) {
                return true;
            }
            if (s.getItemsIdCount() != null) {
                long reqItemCount = 0L;
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    reqItemCount = player.getInventory().getInventoryItemCount(itemIdCount[0], -1);
                    if (reqItemCount >= (long)itemIdCount[1]) continue;
                    player.sendPacket(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL);
                    this.showSkillList(trainer, player);
                    return false;
                }
                for (int[] itemIdCount : s.getItemsIdCount()) {
                    if (player.destroyItemByItemId("SkillLearn", itemIdCount[0], itemIdCount[1], trainer, true)) continue;
                    Util.handleIllegalPlayerAction(player, "Somehow player " + player.getName() + ", level " + player.getLevel() + " lose required item Id: " + itemIdCount[0] + " to learn skill while learning skill Id: " + this._id + " level " + this._level + "!", 0);
                }
            }
            if (levelUpSp > 0) {
                player.setSp(player.getSp() - levelUpSp);
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(13, player.getSp());
                player.sendPacket(su);
            }
            return true;
        }
        return false;
    }

    private void giveSkill(L2PcInstance player, L2Npc trainer, L2Skill skill) {
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.LEARNED_SKILL_S1);
        sm.addSkillName(skill);
        player.sendPacket(sm);
        player.sendPacket(new AcquireSkillDone());
        player.addSkill(skill, true);
        player.sendSkillList();
        player.updateShortCuts(this._id, this._level);
        this.showSkillList(trainer, player);
        if (this._id >= 1368 && this._id <= 1372) {
            player.sendPacket(new ExStorageMaxCount(player));
        }
    }

    private void showSkillList(L2Npc trainer, L2PcInstance player) {
        if (trainer instanceof L2TrainerHealersInstance && this._skillType == AcquireSkillList.SkillType.Transfer.ordinal()) {
            L2TrainerHealersInstance.showTransferSkillList(player);
        } else if (trainer instanceof L2FishermanInstance) {
            L2FishermanInstance.showFishSkillList(player);
        } else if (trainer instanceof L2TransformManagerInstance && this._skillType == AcquireSkillList.SkillType.ClassTransform.ordinal()) {
            L2TransformManagerInstance.showTransformSkillList(player);
        } else if (trainer instanceof L2TransformManagerInstance && this._skillType == AcquireSkillList.SkillType.SubClass.ordinal()) {
            L2TransformManagerInstance.showSubClassSkillList(player);
        } else {
            L2NpcInstance.showSkillList(player, trainer, player.getLearningClass());
        }
    }

    @Override
    public String getType() {
        return _C__7C_REQUESTACQUIRESKILL;
    }
}

