/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestAllyInfo
extends L2GameClientPacket {
    private static final String _C__2E_REQUESTALLYINFO = "[C] 2E RequestAllyInfo";

    @Override
    public void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.getAllyId() == 0) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.NO_CURRENT_ALLIANCES);
            this.sendPacket(sm);
            return;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_INFO_HEAD);
        this.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_NAME_S1);
        sm.addString(activeChar.getClan().getAllyName());
        this.sendPacket(sm);
        int clanCount = 0;
        int totalMembers = 0;
        int onlineMembers = 0;
        for (L2Clan clan : ClanTable.getInstance().getClanAllies(activeChar.getAllyId())) {
            ++clanCount;
            totalMembers += clan.getMembersCount();
            onlineMembers += clan.getOnlineMembersCount();
        }
        sm = SystemMessage.getSystemMessage(SystemMessageId.CONNECTION_S1_TOTAL_S2);
        sm.addNumber(onlineMembers);
        sm.addNumber(totalMembers);
        this.sendPacket(sm);
        L2Clan leaderClan = ClanTable.getInstance().getClan(activeChar.getAllyId());
        sm = SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_LEADER_S2_OF_S1);
        sm.addString(leaderClan.getName());
        sm.addString(leaderClan.getLeaderName());
        this.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_CLAN_TOTAL_S1);
        sm.addNumber(clanCount);
        this.sendPacket(sm);
        sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_HEAD);
        for (L2Clan clan : ClanTable.getInstance().getClanAllies(activeChar.getAllyId())) {
            this.sendPacket(sm);
            sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_NAME_S1);
            sm.addString(clan.getName());
            this.sendPacket(sm);
            sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_LEADER_S1);
            sm.addString(clan.getLeaderName());
            this.sendPacket(sm);
            sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_LEVEL_S1);
            sm.addNumber(clan.getLevel());
            this.sendPacket(sm);
            sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_SEPARATOR);
        }
        sm = SystemMessage.getSystemMessage(SystemMessageId.CLAN_INFO_FOOT);
        this.sendPacket(sm);
    }

    @Override
    public String getType() {
        return _C__2E_REQUESTALLYINFO;
    }
}

