/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendAddRequest;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestFriendInvite
extends L2GameClientPacket {
    private static final String _C__77_REQUESTFRIENDINVITE = "[C] 77 RequestFriendInvite";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        SystemMessage sm;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PcInstance friend = L2World.getInstance().getPlayer(this._name);
        if (friend == null || !friend.isOnline() || friend.getAppearance().getInvisible()) {
            activeChar.sendPacket(SystemMessageId.THE_USER_YOU_REQUESTED_IS_NOT_IN_GAME);
            return;
        }
        if (friend == activeChar) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_ADD_YOURSELF_TO_OWN_FRIEND_LIST);
            return;
        }
        if (BlockList.isBlocked(activeChar, friend)) {
            SystemMessage sm2 = SystemMessage.getSystemMessage(SystemMessageId.BLOCKED_C1);
            sm2.addCharName(friend);
            activeChar.sendPacket(sm2);
            return;
        }
        if (BlockList.isBlocked(friend, activeChar)) {
            activeChar.sendMessage("You are in target's block list.");
            return;
        }
        if (activeChar.isInOlympiadMode() || friend.isInOlympiadMode()) {
            activeChar.sendPacket(SystemMessageId.A_USER_CURRENTLY_PARTICIPATING_IN_THE_OLYMPIAD_CANNOT_SEND_PARTY_AND_FRIEND_INVITATIONS);
            return;
        }
        if (activeChar.getFriendList().contains(friend.getObjectId())) {
            SystemMessage sm3 = SystemMessage.getSystemMessage(SystemMessageId.S1_ALREADY_IN_FRIENDS_LIST);
            sm3.addString(this._name);
            activeChar.sendPacket(sm3);
            return;
        }
        if (!friend.isProcessingRequest()) {
            activeChar.onTransactionRequest(friend);
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_REQUESTED_C1_TO_BE_FRIEND);
            sm.addString(this._name);
            FriendAddRequest ajf = new FriendAddRequest(activeChar.getName());
            friend.sendPacket(ajf);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(this._name);
        }
        activeChar.sendPacket(sm);
    }

    @Override
    public String getType() {
        return _C__77_REQUESTFRIENDINVITE;
    }
}

