/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.HennaTable;
import com.l2jserver.gameserver.datatables.HennaTreeTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.L2Henna;
import com.l2jserver.gameserver.model.item.instance.L2HennaInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.util.Util;

public final class RequestHennaEquip
extends L2GameClientPacket {
    private static final String _C__6F_REQUESTHENNAEQUIP = "[C] 6F RequestHennaEquip";
    private int _symbolId;

    @Override
    protected void readImpl() {
        this._symbolId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("HennaEquip")) {
            return;
        }
        L2Henna template = HennaTable.getInstance().getTemplate(this._symbolId);
        if (template == null) {
            return;
        }
        L2HennaInstance henna = new L2HennaInstance(template);
        long _count = 0L;
        boolean cheater = true;
        for (L2HennaInstance h : HennaTreeTable.getInstance().getAvailableHenna(activeChar.getClassId())) {
            if (h.getSymbolId() != henna.getSymbolId()) continue;
            cheater = false;
            break;
        }
        try {
            _count = activeChar.getInventory().getItemByItemId(henna.getItemIdDye()).getCount();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (activeChar.getHennaEmptySlots() == 0) {
            activeChar.sendPacket(SystemMessageId.SYMBOLS_FULL);
            return;
        }
        if (!cheater && _count >= (long)henna.getAmountDyeRequire() && activeChar.getAdena() >= (long)henna.getPrice() && activeChar.addHenna(henna)) {
            activeChar.destroyItemByItemId("Henna", henna.getItemIdDye(), henna.getAmountDyeRequire(), activeChar, true);
            activeChar.getInventory().reduceAdena("Henna", henna.getPrice(), activeChar, activeChar.getLastFolkNPC());
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(activeChar.getInventory().getAdenaInstance());
            activeChar.sendPacket(iu);
            activeChar.sendPacket(SystemMessageId.SYMBOL_ADDED);
        } else {
            activeChar.sendPacket(SystemMessageId.CANT_DRAW_SYMBOL);
            if (!activeChar.isGM() && cheater) {
                Util.handleIllegalPlayerAction(activeChar, "Exploit attempt: Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tryed to add a forbidden henna.", Config.DEFAULT_PUNISH);
            }
        }
    }

    @Override
    public String getType() {
        return _C__6F_REQUESTHENNAEQUIP;
    }
}

