/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExShowDominionRegistry;

public final class RequestJoinDominionWar
extends L2GameClientPacket {
    private static final String _C__D0_57_REQUESTJOINDOMINIONWAR = "[C] D0:57 RequestJoinDominionWar";
    private int _territoryId;
    private int _isClan;
    private int _isJoining;

    @Override
    protected void readImpl() {
        this._territoryId = this.readD();
        this._isClan = this.readD();
        this._isJoining = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        int castleId = this._territoryId - 80;
        if (TerritoryWarManager.getInstance().getIsRegistrationOver()) {
            activeChar.sendPacket(SystemMessageId.NOT_TERRITORY_REGISTRATION_PERIOD);
            return;
        }
        if (clan != null && TerritoryWarManager.getInstance().getTerritory(castleId).getOwnerClan() == clan) {
            activeChar.sendPacket(SystemMessageId.THE_TERRITORY_OWNER_CLAN_CANNOT_PARTICIPATE_AS_MERCENARIES);
            return;
        }
        if (this._isClan == 1) {
            if ((activeChar.getClanPrivileges() & 0x40000) != 262144) {
                activeChar.sendPacket(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT);
                return;
            }
            if (clan == null) {
                return;
            }
            if (this._isJoining == 1) {
                if (System.currentTimeMillis() < clan.getDissolvingExpiryTime()) {
                    activeChar.sendPacket(SystemMessageId.CANT_PARTICIPATE_IN_SIEGE_WHILE_DISSOLUTION_IN_PROGRESS);
                    return;
                }
                if (TerritoryWarManager.getInstance().checkIsRegistered(-1, clan)) {
                    activeChar.sendPacket(SystemMessageId.YOU_ALREADY_REQUESTED_TW_REGISTRATION);
                    return;
                }
                TerritoryWarManager.getInstance().registerClan(castleId, clan);
            } else {
                TerritoryWarManager.getInstance().removeClan(castleId, clan);
            }
        } else {
            if (activeChar.getLevel() < 40 || activeChar.getClassId().level() < 2) {
                return;
            }
            if (this._isJoining == 1) {
                if (TerritoryWarManager.getInstance().checkIsRegistered(-1, activeChar.getObjectId())) {
                    activeChar.sendPacket(SystemMessageId.YOU_ALREADY_REQUESTED_TW_REGISTRATION);
                    return;
                }
                if (clan != null && TerritoryWarManager.getInstance().checkIsRegistered(-1, clan)) {
                    activeChar.sendPacket(SystemMessageId.YOU_ALREADY_REQUESTED_TW_REGISTRATION);
                    return;
                }
                TerritoryWarManager.getInstance().registerMerc(castleId, activeChar);
            } else {
                TerritoryWarManager.getInstance().removeMerc(castleId, activeChar);
            }
        }
        activeChar.sendPacket(new ExShowDominionRegistry(castleId, activeChar));
    }

    @Override
    public String getType() {
        return _C__D0_57_REQUESTJOINDOMINIONWAR;
    }
}

