/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.MailManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExChangePostState;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestPostAttachment
extends L2GameClientPacket {
    private static final String _C__D0_6A_REQUESTPOSTATTACHMENT = "[C] D0:6A RequestPostAttachment";
    private int _msgId;

    @Override
    protected void readImpl() {
        this._msgId = this.readD();
    }

    @Override
    public void runImpl() {
        if (!Config.ALLOW_MAIL || !Config.ALLOW_ATTACHMENTS) {
            return;
        }
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("getattach")) {
            return;
        }
        if (!activeChar.getAccessLevel().allowTransaction()) {
            activeChar.sendMessage("Transactions are disabled for your Access Level");
            return;
        }
        if (!activeChar.isInsideZone((byte)1)) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_NOT_IN_PEACE_ZONE);
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_DURING_EXCHANGE);
            return;
        }
        if (activeChar.isEnchanting()) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_DURING_ENCHANT);
            return;
        }
        if (activeChar.getPrivateStoreType() > 0) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_PRIVATE_STORE);
            return;
        }
        Message msg = MailManager.getInstance().getMessage(this._msgId);
        if (msg == null) {
            return;
        }
        if (msg.getReceiverId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get not own attachment!", Config.DEFAULT_PUNISH);
            return;
        }
        if (!msg.hasAttachments()) {
            return;
        }
        Mail attachments = msg.getAttachments();
        if (attachments == null) {
            return;
        }
        int weight = 0;
        int slots = 0;
        for (L2ItemInstance item : attachments.getItems()) {
            if (item == null) continue;
            if (item.getOwnerId() != msg.getSenderId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get wrong item (ownerId != senderId) from attachment!", Config.DEFAULT_PUNISH);
                return;
            }
            if (!item.getLocation().equals((Object)L2ItemInstance.ItemLocation.MAIL)) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get wrong item (Location != MAIL) from attachment!", Config.DEFAULT_PUNISH);
                return;
            }
            if (item.getLocationSlot() != msg.getId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get items from different attachment!", Config.DEFAULT_PUNISH);
                return;
            }
            weight = (int)((long)weight + item.getCount() * (long)item.getItem().getWeight());
            if (!item.isStackable()) {
                slots = (int)((long)slots + item.getCount());
                continue;
            }
            if (activeChar.getInventory().getItemByItemId(item.getItemId()) != null) continue;
            ++slots;
        }
        if (!activeChar.getInventory().validateCapacity(slots)) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_INVENTORY_FULL);
            return;
        }
        if (!activeChar.getInventory().validateWeight(weight)) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_INVENTORY_FULL);
            return;
        }
        long adena = msg.getReqAdena();
        if (adena > 0L && !activeChar.reduceAdena("PayMail", adena, null, true)) {
            activeChar.sendPacket(SystemMessageId.CANT_RECEIVE_NO_ADENA);
            return;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (L2ItemInstance item : attachments.getItems()) {
            if (item == null) continue;
            if (item.getOwnerId() != msg.getSenderId()) {
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " tried to get items with owner != sender !", Config.DEFAULT_PUNISH);
                return;
            }
            long count = item.getCount();
            L2ItemInstance newItem = attachments.transferItem(((ItemContainer)attachments).getName(), item.getObjectId(), item.getCount(), activeChar.getInventory(), activeChar, null);
            if (newItem == null) {
                return;
            }
            if (playerIU != null) {
                if (newItem.getCount() > count) {
                    playerIU.addModifiedItem(newItem);
                } else {
                    playerIU.addNewItem(newItem);
                }
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_ACQUIRED_S2_S1);
            sm.addItemName(item.getItemId());
            sm.addItemNumber(count);
            activeChar.sendPacket(sm);
        }
        if (playerIU != null) {
            activeChar.sendPacket(playerIU);
        } else {
            activeChar.sendPacket(new ItemList(activeChar, false));
        }
        msg.removeAttachments();
        StatusUpdate su = new StatusUpdate(activeChar);
        su.addAttribute(14, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
        L2PcInstance sender = L2World.getInstance().getPlayer(msg.getSenderId());
        if (adena > 0L) {
            if (sender != null) {
                sender.addAdena("PayMail", adena, activeChar, false);
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PAYMENT_OF_S1_ADENA_COMPLETED_BY_S2);
                sm.addItemNumber(adena);
                sm.addCharName(activeChar);
                sender.sendPacket(sm);
            } else {
                L2ItemInstance paidAdena = ItemTable.getInstance().createItem("PayMail", 57, adena, activeChar, null);
                paidAdena.setOwnerId(msg.getSenderId());
                paidAdena.setLocation(L2ItemInstance.ItemLocation.INVENTORY);
                paidAdena.updateDatabase(true);
                L2World.getInstance().removeObject(paidAdena);
            }
        } else if (sender != null) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_ACQUIRED_ATTACHED_ITEM);
            sm.addCharName(activeChar);
            sender.sendPacket(sm);
        }
        activeChar.sendPacket(new ExChangePostState(true, this._msgId, 1));
        activeChar.sendPacket(SystemMessageId.MAIL_SUCCESSFULLY_RECEIVED);
    }

    @Override
    public String getType() {
        return _C__D0_6A_REQUESTPOSTATTACHMENT;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

