/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2PremiumItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExGetPremiumItemList;
import com.l2jserver.gameserver.util.Util;

public final class RequestWithDrawPremiumItem
extends L2GameClientPacket {
    private static final String _C__D0_52_REQUESTWITHDRAWPREMIUMITEM = "[C] D0:52 RequestWithDrawPremiumItem";
    private int _itemNum;
    private int _charId;
    private long _itemCount;

    @Override
    protected void readImpl() {
        this._itemNum = this.readD();
        this._charId = this.readD();
        this._itemCount = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._itemCount <= 0L) {
            return;
        }
        if (activeChar.getObjectId() != this._charId) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestWithDrawPremiumItem] Incorrect owner, Player: " + activeChar.getName(), Config.DEFAULT_PUNISH);
            return;
        }
        if (activeChar.getPremiumItemList().isEmpty()) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestWithDrawPremiumItem] Player: " + activeChar.getName() + " try to get item with empty list!", Config.DEFAULT_PUNISH);
            return;
        }
        if (activeChar.getWeightPenalty() >= 3 || !activeChar.isInventoryUnder80(false)) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_RECEIVE_THE_VITAMIN_ITEM);
            return;
        }
        if (activeChar.isProcessingTransaction()) {
            activeChar.sendPacket(SystemMessageId.YOU_CANNOT_RECEIVE_A_VITAMIN_ITEM_DURING_AN_EXCHANGE);
            return;
        }
        L2PremiumItem _item = activeChar.getPremiumItemList().get(this._itemNum);
        if (_item == null) {
            return;
        }
        if (_item.getCount() < this._itemCount) {
            return;
        }
        long itemsLeft = _item.getCount() - this._itemCount;
        activeChar.addItem("PremiumItem", _item.getItemId(), this._itemCount, activeChar.getTarget(), true);
        if (itemsLeft > 0L) {
            _item.updateCount(itemsLeft);
            activeChar.updatePremiumItem(this._itemNum, itemsLeft);
        } else {
            activeChar.getPremiumItemList().remove(this._itemNum);
            activeChar.deletePremiumItem(this._itemNum);
        }
        if (activeChar.getPremiumItemList().isEmpty()) {
            activeChar.sendPacket(SystemMessageId.THERE_ARE_NO_MORE_VITAMIN_ITEMS_TO_BE_FOUND);
        } else {
            activeChar.sendPacket(new ExGetPremiumItemList(activeChar));
        }
    }

    @Override
    public String getType() {
        return _C__D0_52_REQUESTWITHDRAWPREMIUMITEM;
    }
}

