/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SendTradeRequest;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class TradeRequest
extends L2GameClientPacket {
    private static final String _C__1A_TRADEREQUEST = "[C] 15 TradeRequest";
    private static Logger _log = Logger.getLogger(TradeRequest.class.getName());
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disabled for your current Access Level.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2Object target = L2World.getInstance().findObject(this._objectId);
        if (target == null || !player.getKnownList().knowsObject(target) || !(target instanceof L2PcInstance)) {
            player.sendPacket(SystemMessageId.INCORRECT_TARGET);
            return;
        }
        if (target.getObjectId() == player.getObjectId()) {
            player.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
            return;
        }
        L2PcInstance partner = (L2PcInstance)target;
        if (partner.getInstanceId() != player.getInstanceId() && player.getInstanceId() != -1) {
            return;
        }
        if (partner.isInOlympiadMode() || player.isInOlympiadMode()) {
            player.sendMessage("A user currently participating in the Olympiad cannot accept or request a trade.");
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TRADE && player.getKarma() > 0) {
            player.sendMessage("You cannot trade while you are in a chaotic state.");
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TRADE && partner.getKarma() > 0) {
            player.sendMessage("You cannot request a trade while your target is in a chaotic state.");
            return;
        }
        if (Config.JAIL_DISABLE_TRANSACTION && (player.isInJail() || partner.isInJail())) {
            player.sendMessage("You cannot trade while you are in in Jail.");
            return;
        }
        if (player.getPrivateStoreType() != 0 || partner.getPrivateStoreType() != 0) {
            player.sendPacket(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE);
            return;
        }
        if (player.isProcessingTransaction()) {
            if (Config.DEBUG) {
                _log.fine("Already trading with someone else.");
            }
            player.sendPacket(SystemMessageId.ALREADY_TRADING);
            return;
        }
        if (partner.isProcessingRequest() || partner.isProcessingTransaction()) {
            if (Config.DEBUG) {
                _log.info("Transaction already in progress.");
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(partner.getName());
            player.sendPacket(sm);
            return;
        }
        if (partner.getTradeRefusal()) {
            player.sendMessage("That person is in trade refusal mode.");
            return;
        }
        if (BlockList.isBlocked(partner, player)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addCharName(partner);
            player.sendPacket(sm);
            return;
        }
        if (Util.calculateDistance(player, partner, true) > 150.0) {
            player.sendPacket(SystemMessageId.TARGET_TOO_FAR);
            return;
        }
        player.onTransactionRequest(partner);
        partner.sendPacket(new SendTradeRequest(player.getObjectId()));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.REQUEST_C1_FOR_TRADE);
        sm.addString(partner.getName());
        player.sendPacket(sm);
    }

    @Override
    public String getType() {
        return _C__1A_TRADEREQUEST;
    }
}

