/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.communityserver.readpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.InitWorldInfo;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netcon.BaseReadPacket;

public final class RequestWorldInfo
extends BaseReadPacket {
    public static final byte SERVER_LOAD = 0;
    public static final byte PLAYER_DATA_UPDATE = 1;
    public static final byte CLAN_DATA_UPDATE = 2;
    private static Logger _log = Logger.getLogger(WorldInfo.class.getName());
    private final CommunityServerThread _cst;
    private static final int MAX_ARRAY = 10;
    private final int _type;

    public RequestWorldInfo(byte[] data, CommunityServerThread cst, int type) {
        super(data);
        this._cst = cst;
        this._type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        switch (this._type) {
            case 0: {
                L2Clan[] clans = new L2Clan[10];
                int i = 0;
                int j = 0;
                for (L2Clan c : ClanTable.getInstance().getClans()) {
                    clans[i++] = c;
                    if (i < 10) continue;
                    i = 0;
                    ++j;
                    this._cst.sendPacket(new InitWorldInfo(null, clans, 2, -1), false);
                }
                if (i != 0) {
                    ++j;
                    this._cst.sendPacket(new InitWorldInfo(null, clans, 2, i), false);
                }
                _log.info("Transfering " + ClanTable.getInstance().getClans().length + " Clan data to CB server.");
                Connection con = null;
                StatsSet[] charDatList = new StatsSet[10];
                try {
                    con = L2DatabaseFactory.getInstance().getConnection();
                    PreparedStatement statement = con.prepareStatement("SELECT account_name, charId, char_name, level, clanid, accesslevel, online FROM characters");
                    ResultSet charList = statement.executeQuery();
                    i = 0;
                    int charNumber = 0;
                    while (charList.next()) {
                        ++charNumber;
                        StatsSet charDat = new StatsSet();
                        charDat.set("account_name", charList.getString("account_name"));
                        charDat.set("charId", charList.getInt("charId"));
                        charDat.set("char_name", charList.getString("char_name"));
                        charDat.set("level", charList.getInt("level"));
                        charDat.set("clanid", charList.getInt("clanid"));
                        charDat.set("accesslevel", charList.getInt("accesslevel"));
                        charDat.set("online", charList.getInt("online"));
                        charDatList[i++] = charDat;
                        if (i < 10) continue;
                        i = 0;
                        ++j;
                        this._cst.sendPacket(new InitWorldInfo(charDatList, null, 1, -1), false);
                    }
                    if (i != 0) {
                        ++j;
                        this._cst.sendPacket(new InitWorldInfo(charDatList, null, 1, i), false);
                    }
                    _log.info("Transfering " + charNumber + " character data to CB server.");
                    charList.close();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not restore char info: " + e.getMessage(), e);
                }
                finally {
                    L2DatabaseFactory.close(con);
                }
                this._cst.sendPacket(new InitWorldInfo(null, null, 3, ++j), false);
                this._cst.sendPacket(new InitWorldInfo(null, null, 0, ++j), false);
                break;
            }
            case 1: {
                int playerObjId = super.readD();
                L2PcInstance player = L2World.getInstance().getPlayer(playerObjId);
                if (player == null) break;
                this._cst.sendPacket(new WorldInfo(player, null, 1));
                break;
            }
            case 2: {
                int clanObjId = super.readD();
                L2Clan clan = ClanTable.getInstance().getClan(clanObjId);
                if (clan == null) break;
                this._cst.sendPacket(new WorldInfo(null, clan, 3));
            }
        }
    }
}

