/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ItemInfo;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class InventoryUpdate
extends L2GameServerPacket {
    private static final Logger _log = Logger.getLogger(InventoryUpdate.class.getName());
    private static final String _S__37_INVENTORYUPDATE = "[S] 21 InventoryUpdate";
    private List<ItemInfo> _items;

    public InventoryUpdate() {
        this._items = new FastList();
        if (Config.DEBUG) {
            this.showDebug();
        }
    }

    public InventoryUpdate(List<ItemInfo> items) {
        this._items = items;
        if (Config.DEBUG) {
            this.showDebug();
        }
    }

    public void addItem(L2ItemInstance item) {
        if (item != null) {
            this._items.add(new ItemInfo(item));
        }
    }

    public void addNewItem(L2ItemInstance item) {
        if (item != null) {
            this._items.add(new ItemInfo(item, 1));
        }
    }

    public void addModifiedItem(L2ItemInstance item) {
        if (item != null) {
            this._items.add(new ItemInfo(item, 2));
        }
    }

    public void addRemovedItem(L2ItemInstance item) {
        if (item != null) {
            this._items.add(new ItemInfo(item, 3));
        }
    }

    public void addItems(List<L2ItemInstance> items) {
        if (items != null) {
            for (L2ItemInstance item : items) {
                if (item == null) continue;
                this._items.add(new ItemInfo(item));
            }
        }
    }

    private void showDebug() {
        for (ItemInfo item : this._items) {
            _log.fine("oid:" + Integer.toHexString(item.getObjectId()) + " item:" + item.getItem().getName() + " last change:" + item.getChange());
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(33);
        int count = this._items.size();
        this.writeH(count);
        for (ItemInfo item : this._items) {
            this.writeH(item.getChange());
            this.writeD(item.getObjectId());
            this.writeD(item.getItem().getItemId());
            this.writeD(item.getLocation());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(item.getCustomType1());
            this.writeH(item.getEquipped());
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchant());
            this.writeH(item.getCustomType2());
            this.writeD(item.getAugmentationBonus());
            this.writeD(item.getMana());
            this.writeD(item.getTime());
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
        this._items.clear();
        this._items = null;
    }

    @Override
    public String getType() {
        return _S__37_INVENTORYUPDATE;
    }
}

