/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.ExQuestItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class ItemList
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(ItemList.class.getName());
    private static final String _S__11_ITEMLIST = "[S] 11 ItemList";
    private PcInventory _inventory;
    private L2ItemInstance[] _items;
    private boolean _showWindow;
    private int length;
    private FastList<L2ItemInstance> questItems;

    public ItemList(L2PcInstance cha, boolean showWindow) {
        this._inventory = cha.getInventory();
        this._items = cha.getInventory().getItems();
        this._showWindow = showWindow;
        this.questItems = FastList.newInstance();
        for (int i = 0; i < this._items.length; ++i) {
            if (this._items[i] != null && this._items[i].isQuestItem()) {
                this.questItems.add((Object)this._items[i]);
                this._items[i] = null;
                continue;
            }
            ++this.length;
        }
    }

    private void showDebug() {
        for (L2ItemInstance temp : this._items) {
            _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(17);
        this.writeH(this._showWindow ? 1 : 0);
        this.writeH(this.length);
        for (L2ItemInstance temp : this._items) {
            if (temp == null || temp.getItem() == null) continue;
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getLocationSlot());
            this.writeQ(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(temp.getCustomType1());
            this.writeH(temp.isEquipped() ? 1 : 0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(temp.getCustomType2());
            if (temp.isAugmented()) {
                this.writeD(temp.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(temp.getMana());
            this.writeD(temp.isTimeLimitedItem() ? (int)(temp.getRemainingTime() / 1000L) : -9999);
            this.writeH(temp.getAttackElementType());
            this.writeH(temp.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(temp.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
        if (this._inventory.hasInventoryBlock()) {
            this.writeH(this._inventory.getBlockItems().length);
            this.writeC(this._inventory.getBlockMode());
            for (int i : this._inventory.getBlockItems()) {
                this.writeD(i);
            }
        } else {
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__11_ITEMLIST;
    }

    @Override
    public void runImpl() {
        ((L2GameClient)this.getClient()).sendPacket(new ExQuestItemList(this.questItems, ((L2GameClient)this.getClient()).getActiveChar().getInventory()));
    }
}

