/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.item.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;

public class PetItemList
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(PetItemList.class.getName());
    private static final String _S__cb_PETITEMLIST = "[S] b3 PetItemList";
    private L2PetInstance _activeChar;

    public PetItemList(L2PetInstance character) {
        this._activeChar = character;
        if (Config.DEBUG) {
            L2ItemInstance[] items;
            for (L2ItemInstance temp : items = this._activeChar.getInventory().getItems()) {
                _log.fine("item:" + temp.getItem().getName() + " type1:" + temp.getItem().getType1() + " type2:" + temp.getItem().getType2());
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(179);
        L2ItemInstance[] items = this._activeChar.getInventory().getItems();
        int count = items.length;
        this.writeH(count);
        for (L2ItemInstance temp : items) {
            this.writeD(temp.getObjectId());
            this.writeD(temp.getItemId());
            this.writeD(temp.getLocationSlot());
            this.writeQ(temp.getCount());
            this.writeH(temp.getItem().getType2());
            this.writeH(temp.getCustomType1());
            this.writeH(temp.isEquipped() ? 1 : 0);
            this.writeD(temp.getItem().getBodyPart());
            this.writeH(temp.getEnchantLevel());
            this.writeH(temp.getCustomType2());
            if (temp.isAugmented()) {
                this.writeD(temp.getAugmentation().getAugmentationId());
            } else {
                this.writeD(0);
            }
            this.writeD(temp.getMana());
            this.writeD(temp.isTimeLimitedItem() ? (int)(temp.getRemainingTime() / 1000L) : -9999);
            this.writeH(temp.getAttackElementType());
            this.writeH(temp.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(temp.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__cb_PETITEMLIST;
    }
}

