/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.EngineInterface;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class FaenorInterface
implements EngineInterface {
    protected static final Logger _log = Logger.getLogger(FaenorInterface.class.getName());

    public static FaenorInterface getInstance() {
        return SingletonHolder._instance;
    }

    private FaenorInterface() {
    }

    public List<?> getAllPlayers() {
        return null;
    }

    @Override
    public void addQuestDrop(int npcID, int itemID, int min, int max, int chance, String questID, String[] states) {
        L2NpcTemplate npc = npcTable.getTemplate(npcID);
        if (npc == null) {
            throw new NullPointerException();
        }
        L2DropData drop = new L2DropData();
        drop.setItemId(itemID);
        drop.setMinDrop(min);
        drop.setMaxDrop(max);
        drop.setChance(chance);
        drop.setQuestID(questID);
        drop.addStates(states);
        this.addDrop(npc, drop, false);
    }

    public void addDrop(int npcID, int itemID, int min, int max, boolean sweep, int chance) throws NullPointerException {
        L2NpcTemplate npc = npcTable.getTemplate(npcID);
        if (npc == null) {
            if (Config.DEBUG) {
                _log.warning("Npc doesnt Exist");
            }
            throw new NullPointerException();
        }
        L2DropData drop = new L2DropData();
        drop.setItemId(itemID);
        drop.setMinDrop(min);
        drop.setMaxDrop(max);
        drop.setChance(chance);
        this.addDrop(npc, drop, sweep);
    }

    public void addDrop(L2NpcTemplate npc, L2DropData drop, boolean sweep) {
        if (sweep) {
            this.addDrop(npc, drop, -1);
        } else {
            int maxCategory = -1;
            for (L2DropCategory cat : npc.getDropData()) {
                if (maxCategory >= cat.getCategoryType()) continue;
                maxCategory = cat.getCategoryType();
            }
            npc.addDropData(drop, ++maxCategory);
        }
    }

    public void addDrop(L2NpcTemplate npc, L2DropData drop, int category) {
        npc.addDropData(drop, category);
    }

    public List<L2DropData> getQuestDrops(int npcID) {
        L2NpcTemplate npc = npcTable.getTemplate(npcID);
        if (npc == null) {
            return null;
        }
        FastList questDrops = new FastList();
        for (L2DropCategory cat : npc.getDropData()) {
            for (L2DropData drop : cat.getAllDrops()) {
                if (drop.getQuestID() == null) continue;
                questDrops.add(drop);
            }
        }
        return questDrops;
    }

    @Override
    public void addEventDrop(int[] items, int[] count, double chance, DateRange range) {
        EventDroplist.getInstance().addGlobalDrop(items, count, (int)(chance * 1000000.0), range);
    }

    @Override
    public void onPlayerLogin(String[] message, DateRange validDateRange) {
        Announcements.getInstance().addEventAnnouncement(validDateRange, message);
    }

    private static class SingletonHolder {
        protected static final FaenorInterface _instance = new FaenorInterface();

        private SingletonHolder() {
        }
    }
}

