/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager.tasks;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.taskmanager.Task;
import com.l2jserver.gameserver.taskmanager.TaskManager;
import com.l2jserver.gameserver.taskmanager.TaskTypes;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TaskDailySkillReuseClean
extends Task {
    private static final Logger _log = Logger.getLogger(TaskDailySkillReuseClean.class.getName());
    private static final String NAME = "daily_skill_clearn";
    private static final int[] _daily_skills = new int[]{2510};

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTimeElapsed(TaskManager.ExecutedTask task) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            for (int skill_id : _daily_skills) {
                PreparedStatement statement = con.prepareStatement("DELETE FROM character_skills_save WHERE skill_id=?;");
                statement.setInt(1, skill_id);
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not reset daily skill reuse: " + e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        _log.config("Daily skill reuse cleared");
    }

    @Override
    public void initializate() {
        super.initializate();
        TaskManager.addUniqueTask(NAME, TaskTypes.TYPE_GLOBAL_TASK, "1", "06:30:00", "");
    }
}

