/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import gnu.trove.procedure.TObjectProcedure;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Broadcast {
    private static Logger _log = Logger.getLogger(Broadcast.class.getName());

    public static void toPlayersTargettingMyself(L2Character character, L2GameServerPacket mov) {
        if (Config.DEBUG) {
            _log.fine("players to notify:" + character.getKnownList().getKnownPlayers().size() + " packet:" + mov.getType());
        }
        Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player.getTarget() != character) continue;
            player.sendPacket(mov);
        }
    }

    public static void toKnownPlayers(L2Character character, L2GameServerPacket mov) {
        if (Config.DEBUG) {
            _log.fine("players to notify:" + character.getKnownList().getKnownPlayers().size() + " packet:" + mov.getType());
        }
        Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            try {
                player.sendPacket(mov);
                if (!(mov instanceof CharInfo) || !(character instanceof L2PcInstance)) continue;
                int relation = ((L2PcInstance)character).getRelation(player);
                Integer oldrelation = character.getKnownList().getKnownRelations().get(player.getObjectId());
                if (oldrelation == null || oldrelation == relation) continue;
                player.sendPacket(new RelationChanged((L2PcInstance)character, relation, character.isAutoAttackable(player)));
                if (((L2PcInstance)character).getPet() == null) continue;
                player.sendPacket(new RelationChanged(((L2PcInstance)character).getPet(), relation, character.isAutoAttackable(player)));
            }
            catch (NullPointerException e) {
                _log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static void toKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, int radius) {
        if (radius < 0) {
            radius = 1500;
        }
        Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (!character.isInsideRadius(player, radius, false, false)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toSelfAndKnownPlayers(L2Character character, L2GameServerPacket mov) {
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Broadcast.toKnownPlayers(character, mov);
    }

    public static void toSelfAndKnownPlayersInRadius(L2Character character, L2GameServerPacket mov, long radiusSq) {
        if (radiusSq < 0L) {
            radiusSq = 360000L;
        }
        if (character instanceof L2PcInstance) {
            character.sendPacket(mov);
        }
        Collection<L2PcInstance> plrs = character.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !(character.getDistanceSq(player) <= (double)radiusSq)) continue;
            player.sendPacket(mov);
        }
    }

    public static void toAllOnlinePlayers(L2GameServerPacket mov) {
        if (Config.DEBUG) {
            _log.fine("Players to notify: " + L2World.getInstance().getAllPlayersCount() + " (with packet " + mov.getType() + ")");
        }
        L2World.getInstance().forEachPlayer(new ForEachPlayerBroadcast(mov));
    }

    public static void announceToOnlinePlayers(String text, boolean isCritical) {
        CreatureSay cs = isCritical ? new CreatureSay(0, 18, "", text) : new CreatureSay(0, 10, "", text);
        Broadcast.toAllOnlinePlayers(cs);
    }

    public static void announceToOnlinePlayers(String text) {
        Broadcast.toAllOnlinePlayers(new CreatureSay(0, 10, "", text));
    }

    public static void announceToOnlinePlayers(SystemMessage message) {
        Broadcast.toAllOnlinePlayers(message);
    }

    public static void toPlayersInInstance(L2GameServerPacket mov, int instanceId) {
        L2World.getInstance().forEachPlayer(new ForEachPlayerInInstanceBroadcast(mov, instanceId));
    }

    private static final class ForEachPlayerInInstanceBroadcast
    implements TObjectProcedure<L2PcInstance> {
        L2GameServerPacket _packet;
        int _instanceId;

        private ForEachPlayerInInstanceBroadcast(L2GameServerPacket packet, int instanceId) {
            this._packet = packet;
            this._instanceId = instanceId;
        }

        public final boolean execute(L2PcInstance onlinePlayer) {
            if (onlinePlayer != null && onlinePlayer.isOnline() && onlinePlayer.getInstanceId() == this._instanceId) {
                onlinePlayer.sendPacket(this._packet);
            }
            return true;
        }
    }

    private static final class ForEachPlayerBroadcast
    implements TObjectProcedure<L2PcInstance> {
        L2GameServerPacket _packet;

        private ForEachPlayerBroadcast(L2GameServerPacket packet) {
            this._packet = packet;
        }

        public final boolean execute(L2PcInstance onlinePlayer) {
            if (onlinePlayer != null && onlinePlayer.isOnline()) {
                onlinePlayer.sendPacket(this._packet);
            }
            return true;
        }
    }
}

