/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.util.FloodProtectorConfig;
import com.l2jserver.util.StringUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FloodProtectorAction {
    private static final Logger _log = Logger.getLogger(FloodProtectorAction.class.getName());
    private final L2GameClient _client;
    private final FloodProtectorConfig _config;
    private volatile int _nextGameTick = GameTimeController.getGameTicks();
    private AtomicInteger _count = new AtomicInteger(0);
    private boolean _logged;
    private volatile boolean _punishmentInProgress;

    public FloodProtectorAction(L2GameClient client, FloodProtectorConfig config) {
        this._client = client;
        this._config = config;
    }

    public boolean tryPerformAction(String command) {
        int curTick = GameTimeController.getGameTicks();
        if (curTick < this._nextGameTick || this._punishmentInProgress) {
            if (this._config.LOG_FLOODING && !this._logged && _log.isLoggable(Level.WARNING)) {
                this.log(" called command ", command, " ~", String.valueOf((this._config.FLOOD_PROTECTION_INTERVAL - (this._nextGameTick - curTick)) * 100), " ms after previous command");
                this._logged = true;
            }
            this._count.incrementAndGet();
            if (!this._punishmentInProgress && this._config.PUNISHMENT_LIMIT > 0 && this._count.get() >= this._config.PUNISHMENT_LIMIT && this._config.PUNISHMENT_TYPE != null) {
                this._punishmentInProgress = true;
                if ("kick".equals(this._config.PUNISHMENT_TYPE)) {
                    this.kickPlayer();
                } else if ("ban".equals(this._config.PUNISHMENT_TYPE)) {
                    this.banAccount();
                } else if ("jail".equals(this._config.PUNISHMENT_TYPE)) {
                    this.jailChar();
                }
                this._punishmentInProgress = false;
            }
            return false;
        }
        if (this._count.get() > 0 && this._config.LOG_FLOODING && _log.isLoggable(Level.WARNING)) {
            this.log(" issued ", String.valueOf(this._count), " extra requests within ~", String.valueOf(this._config.FLOOD_PROTECTION_INTERVAL * 100), " ms");
        }
        this._nextGameTick = curTick + this._config.FLOOD_PROTECTION_INTERVAL;
        this._logged = false;
        this._count.set(0);
        return true;
    }

    private void kickPlayer() {
        if (this._client.getActiveChar() != null) {
            this._client.getActiveChar().logout(false);
        } else {
            this._client.closeNow();
        }
        if (_log.isLoggable(Level.WARNING)) {
            this.log("kicked for flooding");
        }
    }

    private void banAccount() {
        if (this._client.getActiveChar() != null) {
            this._client.getActiveChar().setPunishLevel(L2PcInstance.PunishLevel.ACC, this._config.PUNISHMENT_TIME);
            if (_log.isLoggable(Level.WARNING)) {
                this.log(" banned for flooding ", this._config.PUNISHMENT_TIME <= 0 ? "forever" : "for " + this._config.PUNISHMENT_TIME + " mins");
            }
            this._client.getActiveChar().logout();
        } else {
            this.log(" unable to ban account: no active player");
        }
    }

    private void jailChar() {
        if (this._client.getActiveChar() != null) {
            this._client.getActiveChar().setPunishLevel(L2PcInstance.PunishLevel.JAIL, this._config.PUNISHMENT_TIME);
            if (_log.isLoggable(Level.WARNING)) {
                this.log(" jailed for flooding ", this._config.PUNISHMENT_TIME <= 0 ? "forever" : "for " + this._config.PUNISHMENT_TIME + " mins");
            }
        } else {
            this.log(" unable to jail: no active player");
        }
    }

    private void log(String ... lines) {
        StringBuilder output = StringUtil.startAppend(100, this._config.FLOOD_PROTECTOR_TYPE, ": ");
        String address = null;
        try {
            if (!this._client.isDetached()) {
                address = this._client.getConnection().getInetAddress().getHostAddress();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        switch (this._client.getState()) {
            case IN_GAME: {
                if (this._client.getActiveChar() == null) break;
                StringUtil.append(output, this._client.getActiveChar().getName());
                StringUtil.append(output, "(", String.valueOf(this._client.getActiveChar().getObjectId()), ") ");
                break;
            }
            case AUTHED: {
                if (this._client.getAccountName() == null) break;
                StringUtil.append(output, this._client.getAccountName(), " ");
                break;
            }
            case CONNECTED: {
                if (address == null) break;
                StringUtil.append(output, address);
                break;
            }
            default: {
                throw new IllegalStateException("Missing state on switch");
            }
        }
        StringUtil.append(output, lines);
        _log.warning(output.toString());
    }
}

