/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.ngl;

import com.l2jserver.tools.ngl.LocalizationParser;
import com.l2jserver.util.osnative.WinConsole;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.Locale;
import java.util.Scanner;

public class ConsoleLocalizator
extends LocalizationParser {
    private WinConsole _wcon;
    private Pointer _stdout;
    private static PrintStream _out;
    Scanner _scn = new Scanner(System.in);
    String _baseName = "NGLConsole";

    public ConsoleLocalizator(String dir, String baseName) {
        this(dir, baseName, Locale.getDefault());
    }

    public ConsoleLocalizator(String dir, String baseName, Locale locale) {
        super(dir, baseName, locale);
        this.loadConsole();
    }

    public ConsoleLocalizator(String dir, String baseName, String locale) {
        super(dir, baseName, locale);
        this.loadConsole();
    }

    private void loadConsole() {
        if (Platform.isWindows()) {
            try {
                this._wcon = WinConsole.INSTANCE;
                if (this._wcon.GetConsoleOutputCP() != 0) {
                    this._wcon.SetConsoleOutputCP(65001);
                    this._stdout = this._wcon.GetStdHandle(-11);
                } else {
                    this._wcon = null;
                }
            }
            catch (Exception e) {
                this._wcon = null;
            }
        }
        if (this._wcon == null) {
            try {
                _out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                _out = new PrintStream(System.out, true);
                this.directPrint("Your system doesn't support UTF-8 encoding\n");
            }
        }
    }

    public void print(String id, Object ... args) {
        String msg = this.getStringFromId(id);
        msg = msg == null ? this.formatText("Untranslated id: %s", id) : this.formatText(msg, args);
        this.directPrint(msg);
    }

    public void println() {
        this.directPrint("\n");
    }

    public void println(String id, Object ... args) {
        String msg = this.getStringFromId(id);
        msg = msg == null ? this.formatText("Untranslated id: %s\n", id) : this.formatText(msg + "\n", args);
        this.directPrint(msg);
    }

    public String inputString(String id, Object ... args) {
        this.print(id, args);
        this.directPrint(": ");
        String ret = this._scn.next();
        return ret;
    }

    public String getString(String id, Object ... args) {
        String msg = this.getStringFromId(id);
        if (msg == null) {
            return this.formatText("Untranslated id: %s", id);
        }
        return this.formatText(msg, args);
    }

    private String formatText(String text, Object ... args) {
        Formatter form = new Formatter();
        return form.format(text, args).toString();
    }

    private void directPrint(String message) {
        if (this._wcon == null) {
            _out.print(message);
        } else {
            this._wcon.WriteConsoleW(this._stdout, message.toCharArray(), message.length(), new IntByReference(), null);
        }
    }
}

