/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.network.gameserverpackets;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.network.loginserverpackets.PlayerAuthResponse;
import com.l2jserver.util.network.BaseRecievePacket;
import java.util.logging.Logger;

public class PlayerAuthRequest
extends BaseRecievePacket {
    private static Logger _log = Logger.getLogger(PlayerAuthRequest.class.getName());

    public PlayerAuthRequest(byte[] decrypt, GameServerThread server) {
        super(decrypt);
        PlayerAuthResponse authResponse;
        SessionKey key;
        String account = this.readS();
        int playKey1 = this.readD();
        int playKey2 = this.readD();
        int loginKey1 = this.readD();
        int loginKey2 = this.readD();
        SessionKey sessionKey = new SessionKey(loginKey1, loginKey2, playKey1, playKey2);
        if (Config.DEBUG) {
            _log.info("auth request received for Player " + account);
        }
        if ((key = LoginController.getInstance().getKeyForAccount(account)) != null && key.equals(sessionKey)) {
            if (Config.DEBUG) {
                _log.info("auth request: OK");
            }
            LoginController.getInstance().removeAuthedLoginClient(account);
            authResponse = new PlayerAuthResponse(account, true);
        } else {
            if (Config.DEBUG) {
                _log.info("auth request: NO");
                _log.info("session key from self: " + key);
                _log.info("session key sent: " + sessionKey);
            }
            authResponse = new PlayerAuthResponse(account, false);
        }
        server.sendPacket(authResponse);
    }
}

