-- Information about category:
-- Only one drop will be given per category, except in the cases when category is -1.
-- Category -1 is used for SPOIL/SWEEP drops only!  Do NOT change this.
-- In general, category 0 is for adena and 1 seal stone color (each seal stone color should be in a different category).
-- In general, category 1 is for full drops and parts of equipable items.  However, you can change this.
-- In general, category 2 is for all other items.  However, you can change this.
-- In general, more categories are only used for RBs who have 1 item per category (i.e. do not really drop categorized),
-- You can create more categories as you see fit.  Just make sure the "category" number is non-negative!!
-- Also, it is NOT a problem if category numbers are skipped (so you can have -1, 1, 5, 10 as your categories).
--
-- If you wish to allow more than one item to be given from the same category, you can
-- split them up over several categories.
-- In addition, RBs and Grandbosses (mainly) may have the exact same item repeated in multiple categories.
-- This allows mobs to give 1 copy of the drop to each of several people (if they are lucky enough to get the drops).
-- Calculation for each drop, when in categories, is equivallent in chance as when outside of categories.
-- First, the sum of chances for each category is calculated as category chance.  If the category is selected
-- for drops (i.e. its chance is successful), then exactly 1 item from that category will be selected, with 
-- such a chance that the overall probability is maintained unchanged. 
--
-- Category Explanation (non-RaidBoss & non-GrandBoss)
--   -1 is sweep
--    0 is adena and one of the seal stones (your choice)
--    1 is any item that is in weapon.sql, any item in armor.sql, and some of the items from etcitem. Before dropping the column, I had those marked in etcitem.sql. However, you can recognize them easily. If they are parts unique for crafting equipable items, it's category 1.
--    2 is almost all of the other items except:
--    3 and 4 are used for the other two seal stones (1 category each).
--
-- Category Explanation (RaidBoss & their minions)
--    0 is full armor and armor mats
--    1 is full weapon and weapon mats
--    2 is anything else (scrolls,arrows,etc)
--
-- Category Explanation (GrandBoss)
--    0+ is defined catagories
--    Any other mobs within this range (minions, etc) use the default drop categories (most often 2)

DROP TABLE IF EXISTS `droplist`;
CREATE TABLE `droplist` (
  `mobId` smallint(5) unsigned NOT NULL DEFAULT '0',
  `itemId` smallint(5) unsigned NOT NULL DEFAULT '0',
  `min` int(8) unsigned NOT NULL DEFAULT '0',
  `max` int(8) unsigned NOT NULL DEFAULT '0',
  `category` smallint(3) NOT NULL DEFAULT '0',
  `chance` decimal(30,15) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`mobId`,`itemId`,`category`),
  KEY `key_mobId` (`mobId`)
) ENGINE=MyISAM DEFAULT CHARSET=UTF8;

INSERT INTO `droplist` VALUES
(20003,1871,1,1,-1,56617),-- [charcoal]
(20003,116,1,1,-1,452932),-- [magic_ring]
(20003,1786,1,1,-1,45293),-- [rp_broad_sword]
(20003,57,30,42,0,700000),-- [adena]
(20003,112,1,1,1,102689.2683),-- [apprentice's_earing]
(20003,118,1,1,1,76513.51329),-- [necklace_of_magic]
(20003,116,1,1,1,156087.21841),-- [magic_ring]
(20003,1864,1,1,2,19511.058856),-- [stem]
(20003,1865,1,1,2,9755.529428),-- [varnish]
(20003,1866,1,1,2,6503.663956),-- [suede]
(20003,1873,1,1,2,3902.184976),-- [silver_nugget]
(20003,1868,1,1,2,19511.058856),-- [thread]
(20003,1788,1,1,2,7804.503928),-- [rp_bow]
(20004,1866,1,1,-1,51827),-- [suede]
(20004,2006,1,1,-1,5553),-- [willow_staff_head]
(20004,2005,1,1,-1,5553),-- [broad_sword_blade]
(20004,57,41,58,0,700000),-- [adena]
(20004,1122,1,1,1,6514.326819),-- [cotton_shoes]
(20004,1129,1,1,1,6514.326819),-- [crude_leather_shoes]
(20004,1119,1,1,1,6514.346362),-- [short_leather_gloves]
(20004,1871,1,1,2,15309),-- [charcoal]
(20004,1866,1,1,2,10205.989794),-- [suede]
(20004,1666,1,1,2,5103.010206),-- [rp_wooden_arrow]
(20005,1060,1,1,-1,216259),-- [lesser_healing_potion]
(20005,1866,1,1,-1,64878),-- [suede]
(20005,1666,1,1,-1,32439),-- [rp_wooden_arrow]
(20005,57,51,72,0,700000),-- [adena]
(20005,19,1,1,1,11732.93531),-- [small_shield]
(20005,42,1,1,1,8213.06469),-- [leather_cap]
(20005,1870,1,1,2,14372.907594),-- [coal]
(20005,1865,1,1,2,14372.907594),-- [varnish]
(20005,1789,1,1,2,2656.750109),-- [rp_cedar_staff]
(20005,17,10,30,2,71864.434703),-- [wooden_arrow]
(20006,1060,1,1,-1,285245),-- [lesser_healing_potion]
(20006,113,1,1,-1,41407),-- [mage_earing]
(20006,2006,1,1,-1,9169),-- [willow_staff_head]
(20006,57,69,94,0,700000),-- [adena]
(20006,14,1,1,1,789.869388),-- [bow]
(20006,2007,1,1,1,2708.130612),-- [bow_shaft]
(20006,1866,1,1,2,16851.42),-- [suede]
(20006,1871,1,1,2,25277.13),-- [charcoal]
(20006,2136,1,1,2,7434.45),-- [rp_cokes]
(20007,1866,1,1,-1,99228),-- [suede]
(20007,1122,1,1,-1,63337),-- [cotton_shoes]
(20007,1875,1,1,-1,9923),-- [stone_of_purity]
(20007,57,80,108,0,700000),-- [adena]
(20007,22,1,1,1,4702.317224),-- [leather_shirt]
(20007,29,1,1,1,7515.682776),-- [leather_pants]
(20007,1864,1,1,2,58620.9312),-- [stem]
(20007,1869,1,1,2,29310.528),-- [iron_ore]
(20007,1796,1,1,2,36868.5408),-- [rp_leather_tunic]
(20008,1793,1,1,-1,16388),-- [rp_sword_of_reflexion]
(20008,1871,1,1,-1,222882),-- [charcoal]
(20008,1870,1,1,-1,222882),-- [coal]
(20008,57,114,168,0,700000),-- [adena]
(20008,2371,1,1,1,675.404192),-- [fist_of_butcher]
(20008,255,1,1,1,316.595808),-- [fox's_nail]
(20008,1870,1,1,2,43890.42816),-- [coal]
(20008,1865,1,1,2,43890.42816),-- [varnish]
(20008,1792,1,1,2,3227.14368),-- [rp_short_spear]
(20009,1870,1,1,-1,222882),-- [coal]
(20009,43,1,1,-1,14567),-- [wooden_helmet]
(20009,1831,1,1,-1,594351),-- [antidote]
(20009,57,114,168,0,700000),-- [adena]
(20009,2371,1,1,1,675.404192),-- [fist_of_butcher]
(20009,255,1,1,1,316.595808),-- [fox's_nail]
(20009,1866,1,1,2,29260.278432),-- [suede]
(20009,1871,1,1,2,43890.417648),-- [charcoal]
(20009,736,1,1,2,21945.30392),-- [scroll_of_escape]
(20010,1833,1,1,-1,617635),-- [bandage]
(20010,1896,1,1,-1,98141),-- [necklace_of_anguish_chain]
(20010,1792,1,1,-1,17030),-- [rp_short_spear]
(20010,57,116,177,0,700000),-- [adena]
(20010,271,1,1,1,658),-- [hunting_bow]
(20010,1871,1,1,2,45609.893496),-- [charcoal]
(20010,1866,1,1,2,30406.595664),-- [suede]
(20010,1798,1,1,2,44715.51084),-- [rp_leather_helmet]
(20011,1792,1,1,-1,17541),-- [rp_short_spear]
(20011,1921,1,1,-1,153911),-- [leather_shoes_texture]
(20011,1867,1,1,-1,318082),-- [animal_skin]
(20011,57,120,182,0,700000),-- [adena]
(20011,271,1,1,1,678),-- [hunting_bow]
(20011,1867,1,1,2,62637.833517),-- [animal_skin]
(20011,1872,1,1,2,62637.833517),-- [animal_bone]
(20011,1799,1,1,2,69597.332966),-- [rp_leather_gloves]
(20012,1865,1,1,-1,242317),-- [varnish]
(20012,734,1,1,-1,40386),-- [quick_step_potion]
(20012,1897,1,1,-1,57694),-- [necklace_of_wisdom_chain]
(20012,57,120,187,0,700000),-- [adena]
(20012,1101,1,1,1,917.695683),-- [tunic_of_devotion]
(20012,1104,1,1,1,1465.304317),-- [hose_of_devotion]
(20012,1865,1,1,2,35788.225837),-- [varnish]
(20012,1870,1,1,2,35788.225837),-- [coal]
(20012,1800,1,1,2,11254.203324),-- [rp_piece_bone_breastplate]
(20012,6035,1,1,2,2982.345002),-- [potion_of_acumen2]
(20013,1866,1,1,-1,143423),-- [suede]
(20013,1896,1,1,-1,91159),-- [necklace_of_anguish_chain]
(20013,1922,1,1,-1,54881),-- [leather_tunic_pattern]
(20013,57,113,160,0,700000),-- [adena]
(20013,9,1,1,1,203.6982),-- [cedar_staff]
(20013,2008,1,1,1,1648.6036),-- [cedar_staff_head]
(20013,154,1,1,1,203.6982),-- [dwarven_mace]
(20013,1870,1,1,2,42365.00815),-- [coal]
(20013,1865,1,1,2,42365.00815),-- [varnish]
(20013,1792,1,1,2,3114.9837),-- [rp_short_spear]
(20014,2254,1,1,-1,10085),-- [rp_composition_bow]
(20014,1867,1,1,-1,328104),-- [animal_skin]
(20014,57,120,193,0,700000),-- [adena]
(20014,2,1,1,1,69.237785),-- [long_sword]
(20014,120,1,1,1,69.237785),-- [sword_of_reflexion]
(20014,2012,1,1,1,757.286645),-- [sword_of_reflexion_blade]
(20014,121,1,1,1,69.237785),-- [sword_of_watershadow]
(20014,1867,1,1,2,64611.193477),-- [animal_skin]
(20014,1872,1,1,2,64611.193477),-- [animal_bone]
(20014,1800,1,1,2,15238.613046),-- [rp_piece_bone_breastplate]
(20015,1798,1,1,-1,237113),-- [rp_leather_helmet]
(20015,1871,1,1,-1,241855),-- [charcoal]
(20015,1864,1,1,-1,483710),-- [stem]
(20015,57,127,180,0,700000),-- [adena]
(20015,9,1,1,1,228.962325),-- [cedar_staff]
(20015,2008,1,1,1,1853.07535),-- [cedar_staff_head]
(20015,154,1,1,1,228.962325),-- [dwarven_mace]
(20015,1864,1,1,2,95253.418299),-- [stem]
(20015,1869,1,1,2,47626.803936),-- [iron_ore]
(20015,1798,1,1,2,46692.777765),-- [rp_leather_helmet]
(20016,1865,1,1,-1,241855),-- [varnish]
(20016,37,1,1,-1,23711),-- [leather_shoes]
(20016,1833,1,1,-1,644946),-- [bandage]
(20016,57,127,180,0,700000),-- [adena]
(20016,271,1,1,1,687),-- [hunting_bow]
(20016,1871,1,1,2,47626.567758),-- [charcoal]
(20016,1866,1,1,2,31751.045172),-- [suede]
(20016,736,1,1,2,23813.38707),-- [scroll_of_escape]
(20017,1870,1,1,-1,251000),-- [coal]
(20017,1897,1,1,-1,59762),-- [necklace_of_wisdom_chain]
(20017,57,122,197,0,700000),-- [adena]
(20017,2,1,1,1,70.601016),-- [long_sword]
(20017,120,1,1,1,70.601016),-- [sword_of_reflexion]
(20017,2012,1,1,1,772.196952),-- [sword_of_reflexion_blade]
(20017,121,1,1,1,70.601016),-- [sword_of_watershadow]
(20017,1870,1,1,2,37070.571302),-- [coal]
(20017,1865,1,1,2,37070.571302),-- [varnish]
(20017,1817,1,1,2,7414.130868),-- [rp_cord]
(20017,5268,1,1,2,1482.726528),-- [rp_adv_comp_soulshot_d]
(20019,1864,1,1,-1,445764),-- [stem]
(20019,1923,1,1,-1,91345),-- [leather_hose_pattern]
(20019,1792,1,1,-1,16388),-- [rp_short_spear]
(20019,57,114,168,0,700000),-- [adena]
(20019,429,1,1,1,1075.736025),-- [leather_tunic]
(20019,1922,1,1,1,8397.233676),-- [leather_tunic_pattern]
(20019,464,1,1,1,1723.39947),-- [leather_hose]
(20019,1923,1,1,1,13490.630829),-- [leather_hose_pattern]
(20019,1871,1,1,2,43890.464944),-- [charcoal]
(20019,1866,1,1,2,29260.335422),-- [suede]
(20019,1793,1,1,2,3227.199634),-- [rp_sword_of_reflexion]
(20020,1831,1,1,-1,668170),-- [antidote]
(20020,1799,1,1,-1,371205),-- [rp_leather_gloves]
(20020,1896,1,1,-1,106171),-- [necklace_of_anguish_chain]
(20020,57,128,189,0,700000),-- [adena]
(20020,37,1,1,1,4837.383828),-- [leather_shoes]
(20020,1921,1,1,1,31833.190836),-- [leather_shoes_texture]
(20020,49,1,1,1,4837.425336),-- [gloves]
(20020,1865,1,1,2,49341.52597),-- [varnish]
(20020,1870,1,1,2,49341.52597),-- [coal]
(20020,1794,1,1,2,3627.94806),-- [rp_bow_of_forest]
(20021,1792,1,1,-1,16388),-- [rp_short_spear]
(20021,1921,1,1,-1,143795),-- [leather_shoes_texture]
(20021,1793,1,1,-1,16388),-- [rp_sword_of_reflexion]
(20021,57,114,168,0,700000),-- [adena]
(20021,9,1,1,1,211.02975),-- [cedar_staff]
(20021,2008,1,1,1,1707.9405),-- [cedar_staff_head]
(20021,154,1,1,1,211.02975),-- [dwarven_mace]
(20021,1865,1,1,2,32917.863649),-- [varnish]
(20021,1870,1,1,2,32917.863649),-- [coal]
(20021,1798,1,1,2,32272.388478),-- [rp_leather_helmet]
(20021,1060,1,1,2,73150.884224),-- [lesser_healing_potion]
(20022,1872,1,1,-1,252599),-- [animal_bone]
(20022,1831,1,1,-1,505199),-- [antidote]
(20022,1921,1,1,-1,122225),-- [leather_shoes_texture]
(20022,57,97,143,0,700000),-- [adena]
(20022,20,1,1,1,5229.661794),-- [buckler]
(20022,43,1,1,1,3657.338206),-- [wooden_helmet]
(20022,1864,1,1,2,74614.166671),-- [stem]
(20022,1869,1,1,2,37306.99974),-- [iron_ore]
(20022,1799,1,1,2,55269.833589),-- [rp_leather_gloves]
(20023,1868,1,1,-1,463226),-- [thread]
(20023,1922,1,1,-1,59085),-- [leather_tunic_pattern]
(20023,1831,1,1,-1,617635),-- [antidote]
(20023,57,116,177,0,700000),-- [adena]
(20023,429,1,1,1,1117.87305),-- [leather_tunic]
(20023,1922,1,1,1,8726.156792),-- [leather_tunic_pattern]
(20023,464,1,1,1,1790.90574),-- [leather_hose]
(20023,1923,1,1,1,14019.064418),-- [leather_hose_pattern]
(20023,1868,1,1,2,68414.79603),-- [thread]
(20023,1873,1,1,2,13682.959206),-- [silver_nugget]
(20023,1803,1,1,2,28745.708796),-- [rp_necklace_of_wisdom]
(20023,735,1,1,2,2850.535968),-- [swift_attack_potion]
(20024,1864,1,1,-1,501999),-- [stem]
(20024,734,1,1,-1,41833),-- [quick_step_potion]
(20024,1897,1,1,-1,59762),-- [necklace_of_wisdom_chain]
(20024,57,122,197,0,700000),-- [adena]
(20024,2,1,1,1,70.601016),-- [long_sword]
(20024,120,1,1,1,70.601016),-- [sword_of_reflexion]
(20024,2012,1,1,1,772.196952),-- [sword_of_reflexion_blade]
(20024,121,1,1,1,70.601016),-- [sword_of_watershadow]
(20024,1864,1,1,2,98855.505408),-- [stem]
(20024,1869,1,1,2,49427.752704),-- [iron_ore]
(20024,1801,1,1,2,24900.741888),-- [rp_piece_bone_gaiters]
(20025,1799,1,1,-1,349993),-- [rp_leather_gloves]
(20025,1869,1,1,-1,236245),-- [iron_ore]
(20025,1866,1,1,-1,157497),-- [suede]
(20025,57,119,180,0,700000),-- [adena]
(20025,429,1,1,1,1140.2706),-- [leather_tunic]
(20025,1922,1,1,1,8900.992864),-- [leather_tunic_pattern]
(20025,464,1,1,1,1826.78808),-- [leather_hose]
(20025,1923,1,1,1,14299.948456),-- [leather_hose_pattern]
(20025,1866,1,1,2,31014.738216),-- [suede]
(20025,1871,1,1,2,46522.107324),-- [charcoal]
(20025,736,1,1,2,23261.15446),-- [scroll_of_escape]
(20026,1866,1,1,-1,173586),-- [suede]
(20026,1923,1,1,-1,106713),-- [leather_hose_pattern]
(20026,1865,1,1,-1,260379),-- [varnish]
(20026,57,131,199,0,700000),-- [adena]
(20026,37,1,1,1,5026.879494),-- [leather_shoes]
(20026,1921,1,1,1,33080.197878),-- [leather_shoes_texture]
(20026,49,1,1,1,5026.922628),-- [gloves]
(20026,1870,1,1,2,51274.9464),-- [coal]
(20026,1865,1,1,2,51274.9464),-- [varnish]
(20026,1792,1,1,2,3770.1072),-- [rp_short_spear]
(20027,1800,1,1,-1,74706),-- [rp_piece_bone_breastplate]
(20027,1924,1,1,-1,76634),-- [leather_helmet_design]
(20027,1801,1,1,-1,119680),-- [rp_piece_bone_gaiters]
(20027,57,118,183,0,700000),-- [adena]
(20027,176,1,1,1,133.5),-- [apprentice's_staff]
(20027,2501,1,1,1,133.5),-- [bone_club]
(20027,1865,1,1,2,35086.53225),-- [varnish]
(20027,1870,1,1,2,35086.53225),-- [coal]
(20027,1800,1,1,2,11033.47421),-- [rp_piece_bone_breastplate]
(20027,5158,1,1,2,1403.46129),-- [rp_comp_spiritshot_d]
(20028,1801,1,1,-1,119680),-- [rp_piece_bone_gaiters]
(20028,1868,1,1,-1,475131),-- [thread]
(20028,734,1,1,-1,39594),-- [quick_step_potion]
(20028,57,118,183,0,700000),-- [adena]
(20028,845,1,1,1,1025.902512),-- [cat'seye_earing]
(20028,908,1,1,1,769.432728),-- [necklace_of_wisdom]
(20028,1897,1,1,1,8353.810992),-- [necklace_of_wisdom_chain]
(20028,877,1,1,1,1538.853768),-- [ring_of_wisdom]
(20028,1869,1,1,2,46782.1875),-- [iron_ore]
(20028,1864,1,1,2,93564.375),-- [stem]
(20028,1817,1,1,2,9356.4375),-- [rp_cord]
(20029,1864,1,1,-1,534142),-- [stem]
(20029,2013,1,1,-1,5764),-- [bow_of_forest_shaft]
(20029,1897,1,1,-1,63588),-- [necklace_of_wisdom_chain]
(20029,57,132,206,0,700000),-- [adena]
(20029,15,1,1,1,150.26895),-- [short_spear]
(20029,2011,1,1,1,1799.73105),-- [short_spear_edge]
(20029,1870,1,1,2,39444.234295),-- [coal]
(20029,1865,1,1,2,39444.234295),-- [varnish]
(20029,2139,1,1,2,7888.86453),-- [rp_steel_mold]
(20029,5268,1,1,2,1577.66688),-- [rp_adv_comp_soulshot_d]
(20030,1831,1,1,-1,617635),-- [antidote]
(20030,1798,1,1,-1,227072),-- [rp_leather_helmet]
(20030,1794,1,1,-1,17030),-- [rp_bow_of_forest]
(20030,57,116,177,0,700000),-- [adena]
(20030,216,1,1,1,328.91945),-- [dirk]
(20030,2009,1,1,1,2426.08055),-- [dirk_blade]
(20030,1870,1,1,2,45610.20298),-- [coal]
(20030,1865,1,1,2,45610.20298),-- [varnish]
(20030,1793,1,1,2,3353.59404),-- [rp_sword_of_reflexion]
(20031,1865,1,1,-1,205065),-- [varnish]
(20031,24,1,1,-1,2629),-- [bone_breastplate]
(20031,1924,1,1,-1,66150),-- [leather_helmet_design]
(20031,57,100,161,0,700000),-- [adena]
(20031,24,1,1,1,388.37335),-- [bone_breastplate]
(20031,390,1,1,1,388.37335),-- [tights_shirt]
(20031,31,1,1,1,620.12665),-- [bone_gaiters]
(20031,412,1,1,1,620.12665),-- [tights_pants]
(20031,1865,1,1,2,30286.636218),-- [varnish]
(20031,1870,1,1,2,30286.636218),-- [coal]
(20031,2140,1,1,2,6057.340812),-- [rp_high_grade_suede]
(20031,5273,1,1,2,1211.386752),-- [rp_adv_comp_spiritshot_d]
(20032,734,1,1,-1,41013),-- [quick_step_potion]
(20032,1868,1,1,-1,492156),-- [thread]
(20032,1800,1,1,-1,77383),-- [rp_piece_bone_breastplate]
(20032,57,120,193,0,700000),-- [adena]
(20032,24,1,1,1,465.971),-- [bone_breastplate]
(20032,390,1,1,1,465.971),-- [tights_shirt]
(20032,31,1,1,1,744.029),-- [bone_gaiters]
(20032,412,1,1,1,744.029),-- [tights_pants]
(20032,1870,1,1,2,48458.587905),-- [coal]
(20032,1865,1,1,2,48458.587905),-- [varnish]
(20032,2141,1,1,2,9691.82419),-- [rp_silver_mold]
(20033,2139,1,1,-1,41013),-- [rp_steel_mold]
(20033,1924,1,1,-1,66150),-- [leather_helmet_design]
(20033,1925,1,1,-1,134469),-- [leather_gloves_lining]
(20033,57,100,161,0,700000),-- [adena]
(20033,845,1,1,1,885.551886),-- [cat'seye_earing]
(20033,908,1,1,1,664.168959),-- [necklace_of_wisdom]
(20033,1897,1,1,1,7210.951326),-- [necklace_of_wisdom_chain]
(20033,877,1,1,1,1328.327829),-- [ring_of_wisdom]
(20033,1870,1,1,2,30286.636218),-- [coal]
(20033,1865,1,1,2,30286.636218),-- [varnish]
(20033,2142,1,1,2,6057.340812),-- [rp_varnish_of_purity]
(20033,5158,1,1,2,1211.386752),-- [rp_comp_spiritshot_d]
(20034,1868,1,1,-1,501999),-- [thread]
(20034,2254,1,1,-1,10287),-- [rp_composition_bow]
(20034,1873,1,1,-1,100400),-- [silver_nugget]
(20034,57,122,197,0,700000),-- [adena]
(20034,256,1,1,1,282),-- [cestus]
(20034,1873,1,1,2,14828.241164),-- [silver_nugget]
(20034,1868,1,1,2,74141.404766),-- [thread]
(20034,2143,1,1,2,7414.120582),-- [rp_synthesis_cokes]
(20034,6035,1,1,2,3089.233488),-- [potion_of_acumen2]
(20035,2140,1,1,-1,49216),-- [rp_high_grade_suede]
(20035,1925,1,1,-1,161363),-- [leather_gloves_lining]
(20035,1868,1,1,-1,492156),-- [thread]
(20035,57,120,193,0,700000),-- [adena]
(20035,38,1,1,1,1860.220285),-- [low_boots]
(20035,50,1,1,1,1860.220285),-- [leather_gloves]
(20035,1925,1,1,1,31776.55943),-- [leather_gloves_lining]
(20035,1868,1,1,2,72687.902048),-- [thread]
(20035,1873,1,1,2,14537.56122),-- [silver_nugget]
(20035,1817,1,1,2,7268.828584),-- [rp_cord]
(20035,5268,1,1,2,1453.708148),-- [rp_adv_comp_soulshot_d]
(20036,1873,1,1,-1,103328),-- [silver_nugget]
(20036,2175,1,1,-1,210017),-- [rp_boots]
(20036,735,1,1,-1,21527),-- [swift_attack_potion]
(20036,57,124,204,0,700000),-- [adena]
(20036,845,1,1,1,1115.519766),-- [cat'seye_earing]
(20036,908,1,1,1,836.646179),-- [necklace_of_wisdom]
(20036,1897,1,1,1,9083.554406),-- [necklace_of_wisdom_chain]
(20036,877,1,1,1,1673.279649),-- [ring_of_wisdom]
(20036,1864,1,1,2,76303.90936),-- [stem]
(20036,1869,1,1,2,38151.95468),-- [iron_ore]
(20036,1878,1,1,2,15260.781872),-- [braided_hemp]
(20036,2173,1,1,2,10339.354088),-- [rp_hard_leather_shirt]
(20038,2174,1,1,-1,121122),-- [rp_hard_leather_gaiters]
(20038,1868,1,1,-1,557163),-- [thread]
(20038,2011,1,1,-1,6355),-- [short_spear_edge]
(20038,57,133,220,0,700000),-- [adena]
(20038,217,1,1,1,156.5),-- [shining_knife]
(20038,218,1,1,1,156.5),-- [throw_knife]
(20038,1869,1,1,2,20572.111932),-- [iron_ore]
(20038,1870,1,1,2,20572.111932),-- [coal]
(20038,1871,1,1,2,20572.111932),-- [charcoal]
(20038,1872,1,1,2,27429.482576),-- [animal_bone]
(20038,1867,1,1,2,27429.482576),-- [animal_skin]
(20038,2174,1,1,2,8944.443762),-- [rp_hard_leather_gaiters]
(20038,5273,1,1,2,822.833741),-- [rp_adv_comp_spiritshot_d]
(20038,1831,1,1,2,54858.421549),-- [antidote]
(20039,1872,1,1,-1,337674),-- [animal_bone]
(20039,2011,1,1,-1,5777),-- [short_spear_edge]
(20039,1801,1,1,-1,127585),-- [rp_piece_bone_gaiters]
(20039,57,121,200,0,700000),-- [adena]
(20039,945,1,1,1,2833.69248),-- [skeleton_buckler]
(20039,102,1,1,1,1367.637272),-- [round_shield]
(20039,44,1,1,1,956.638184),-- [leather_helmet]
(20039,1924,1,1,1,12066.032064),-- [leather_helmet_design]
(20039,1864,1,1,2,42747.3024),-- [stem]
(20039,1865,1,1,2,21373.6512),-- [varnish]
(20039,1866,1,1,2,14249.1008),-- [suede]
(20039,1873,1,1,2,8549.40095),-- [silver_nugget]
(20039,1868,1,1,2,42747.3024),-- [thread]
(20039,2175,1,1,2,17376.955825),-- [rp_boots]
(20039,735,1,1,2,1781.286425),-- [swift_attack_potion]
(20040,2175,1,1,-1,171583),-- [rp_boots]
(20040,2140,1,1,-1,42209),-- [rp_high_grade_suede]
(20040,2012,1,1,-1,4397),-- [sword_of_reflexion_blade]
(20040,57,101,167,0,700000),-- [adena]
(20040,945,1,1,1,2361.35556),-- [skeleton_buckler]
(20040,102,1,1,1,1139.671259),-- [round_shield]
(20040,44,1,1,1,797.179973),-- [leather_helmet]
(20040,1924,1,1,1,10054.793208),-- [leather_helmet_design]
(20040,1868,1,1,2,62339.799824),-- [thread]
(20040,1873,1,1,2,12467.929032),-- [silver_nugget]
(20040,2252,1,1,2,1277.447308),-- [rp_iron_hammer]
(20040,5158,1,1,2,1246.823836),-- [rp_comp_spiritshot_d]
(20041,1880,1,1,-1,23726),-- [steel]
(20041,2012,1,1,-1,4943),-- [sword_of_reflexion_blade]
(20041,1817,1,1,-1,47452),-- [rp_cord]
(20041,57,114,187,0,700000),-- [adena]
(20041,217,1,1,1,133.5),-- [shining_knife]
(20041,218,1,1,1,133.5),-- [throw_knife]
(20041,1866,1,1,2,31147.6736),-- [suede]
(20041,1871,1,1,2,46721.5104),-- [charcoal]
(20041,2253,1,1,2,1914.816),-- [rp_sword_breaker]
(20042,734,1,1,-1,43053),-- [quick_step_potion]
(20042,2013,1,1,-1,5575),-- [bow_of_forest_shaft]
(20042,57,124,204,0,700000),-- [adena]
(20042,309,1,1,1,145.5),-- [tears_of_eva]
(20042,310,1,1,1,145.5),-- [relic_of_saints]
(20042,1867,1,1,2,40695.344685),-- [animal_skin]
(20042,1872,1,1,2,40695.344685),-- [animal_bone]
(20042,1882,1,1,2,6782.60277),-- [leather]
(20042,2254,1,1,2,1250.901),-- [rp_composition_bow]
(20042,5268,1,1,2,1220.80686),-- [rp_adv_comp_soulshot_d]
(20043,1817,1,1,-1,58608),-- [rp_cord]
(20043,1924,1,1,-1,94529),-- [leather_helmet_design]
(20043,1864,1,1,-1,586082),-- [stem]
(20043,57,137,234,0,700000),-- [adena]
(20043,2,1,1,1,82.439601),-- [long_sword]
(20043,120,1,1,1,82.439601),-- [sword_of_reflexion]
(20043,2012,1,1,1,901.681197),-- [sword_of_reflexion_blade]
(20043,121,1,1,1,82.439601),-- [sword_of_watershadow]
(20043,1864,1,1,2,43279.866706),-- [stem]
(20043,1865,1,1,2,21639.836262),-- [varnish]
(20043,1866,1,1,2,14426.557508),-- [suede]
(20043,1873,1,1,2,8656.051014),-- [silver_nugget]
(20043,1868,1,1,2,43279.866706),-- [thread]
(20043,2143,1,1,2,4327.928416),-- [rp_synthesis_cokes]
(20043,5158,1,1,2,865.663356),-- [rp_comp_spiritshot_d]
(20043,1831,1,1,2,57706.230032),-- [antidote]
(20044,1865,1,1,-1,266401),-- [varnish]
(20044,2142,1,1,-1,53280),-- [rp_varnish_of_purity]
(20044,1872,1,1,-1,355202),-- [animal_bone]
(20044,57,125,213,0,700000),-- [adena]
(20044,309,1,1,1,150),-- [tears_of_eva]
(20044,310,1,1,1,150),-- [relic_of_saints]
(20044,1872,1,1,2,52460.391984),-- [animal_bone]
(20044,1867,1,1,2,52460.391984),-- [animal_skin]
(20044,1881,1,1,2,5245.991984),-- [coarse_bone_powder]
(20044,2144,1,1,2,7869.224048),-- [rp_compound_braid]
(20045,734,1,1,-1,44835),-- [quick_step_potion]
(20045,1925,1,1,-1,176402),-- [leather_gloves_lining]
(20045,57,126,215,0,700000),-- [adena]
(20045,217,1,1,1,151.5),-- [shining_knife]
(20045,218,1,1,1,151.5),-- [throw_knife]
(20045,1871,1,1,2,39731.163947),-- [charcoal]
(20045,1866,1,1,2,26487.413811),-- [suede]
(20045,2150,1,1,2,18653.09614),-- [rp_blue_diamond_necklace]
(20045,5268,1,1,2,1589.326102),-- [rp_adv_comp_soulshot_d]
(20046,2139,1,1,-1,48936),-- [rp_steel_mold]
(20046,735,1,1,-1,20390),-- [swift_attack_potion]
(20046,1897,1,1,-1,58257),-- [necklace_of_wisdom_chain]
(20046,57,115,195,0,700000),-- [adena]
(20046,845,1,1,1,1056.623412),-- [cat'seye_earing]
(20046,908,1,1,1,792.473578),-- [necklace_of_wisdom]
(20046,1897,1,1,1,8603.967892),-- [necklace_of_wisdom_chain]
(20046,877,1,1,1,1584.935118),-- [ring_of_wisdom]
(20046,1867,1,1,2,48183.04145),-- [animal_skin]
(20046,1872,1,1,2,48183.04145),-- [animal_bone]
(20046,1882,1,1,2,8030.52594),-- [leather]
(20046,2173,1,1,2,9793.39116),-- [rp_hard_leather_shirt]
(20047,1869,1,1,-1,222001),-- [iron_ore]
(20047,38,1,1,-1,8522),-- [low_boots]
(20047,2139,1,1,-1,44400),-- [rp_steel_mold]
(20047,57,104,177,0,700000),-- [adena]
(20047,24,1,1,1,420.33665),-- [bone_breastplate]
(20047,390,1,1,1,420.33665),-- [tights_shirt]
(20047,31,1,1,1,671.16335),-- [bone_gaiters]
(20047,412,1,1,1,671.16335),-- [tights_pants]
(20047,1864,1,1,2,43716.99248),-- [stem]
(20047,1869,1,1,2,21858.49624),-- [iron_ore]
(20047,1878,1,1,2,8743.36316),-- [braided_hemp]
(20047,2174,1,1,2,9503.70554),-- [rp_hard_leather_gaiters]
(20047,5273,1,1,2,874.30098),-- [rp_adv_comp_spiritshot_d]
(20047,734,1,1,2,3643.1416),-- [quick_step_potion]
(20048,2144,1,1,-1,45937),-- [rp_compound_braid]
(20048,50,1,1,-1,8817),-- [leather_gloves]
(20048,1924,1,1,-1,74091),-- [leather_helmet_design]
(20048,57,106,184,0,700000),-- [adena]
(20048,256,1,1,1,258),-- [cestus]
(20048,1868,1,1,2,90460.027138),-- [thread]
(20048,1873,1,1,2,18091.981908),-- [silver_nugget]
(20048,2142,1,1,2,9045.990954),-- [rp_varnish_of_purity]
(20049,1882,1,1,-1,61249),-- [leather]
(20049,1924,1,1,-1,88910),-- [leather_helmet_design]
(20049,2140,1,1,-1,55124),-- [rp_high_grade_suede]
(20049,57,127,221,0,700000),-- [adena]
(20049,256,1,1,1,310),-- [cestus]
(20049,1872,1,1,2,43420.565404),-- [animal_bone]
(20049,1867,1,1,2,43420.565404),-- [animal_skin]
(20049,1881,1,1,2,4342.09614),-- [coarse_bone_powder]
(20049,2143,1,1,2,6513.045211),-- [rp_synthesis_cokes]
(20049,5158,1,1,2,1302.727841),-- [rp_comp_spiritshot_d]
(20050,735,1,1,-1,25265),-- [swift_attack_potion]
(20050,1866,1,1,-1,202121),-- [suede]
(20050,1925,1,1,-1,198808),-- [leather_gloves_lining]
(20050,57,140,243,0,700000),-- [adena]
(20050,15,1,1,1,170.613054),-- [short_spear]
(20050,2011,1,1,1,2043.386946),-- [short_spear_edge]
(20050,1866,1,1,2,29851.800528),-- [suede]
(20050,1871,1,1,2,44777.599296),-- [charcoal]
(20050,2144,1,1,2,8955.601056),-- [rp_compound_braid]
(20050,1831,1,1,2,119406.99912),-- [antidote]
(20051,2254,1,1,-1,11407),-- [rp_composition_bow]
(20051,1925,1,1,-1,182506),-- [leather_gloves_lining]
(20051,1867,1,1,-1,371096),-- [animal_skin]
(20051,57,129,223,0,700000),-- [adena]
(20051,272,1,1,1,156.6041),-- [bow_of_forest]
(20051,2013,1,1,1,1774.3959),-- [bow_of_forest_shaft]
(20051,1872,1,1,2,43846.562656),-- [animal_bone]
(20051,1867,1,1,2,43846.562656),-- [animal_skin]
(20051,1881,1,1,2,4384.623616),-- [coarse_bone_powder]
(20051,2150,1,1,2,15438.90752),-- [rp_blue_diamond_necklace]
(20051,5268,1,1,2,1315.343552),-- [rp_adv_comp_soulshot_d]
(20052,1866,1,1,-1,193642),-- [suede]
(20052,1868,1,1,-1,580926),-- [thread]
(20052,1869,1,1,-1,290463),-- [iron_ore]
(20052,57,132,236,0,700000),-- [adena]
(20052,219,1,1,1,91.30743),-- [sword_breaker]
(20052,2015,1,1,1,1046.69257),-- [sword_breaker_edge]
(20052,1869,1,1,2,34319.45224),-- [iron_ore]
(20052,1864,1,1,2,68639.013616),-- [stem]
(20052,1880,1,1,2,3431.999792),-- [steel]
(20052,1804,1,1,2,1372.821744),-- [rp_soulshot_d]
(20052,5158,1,1,2,1372.712608),-- [rp_comp_spiritshot_d]
(20053,2015,1,1,-1,4292),-- [sword_breaker_edge]
(20053,1926,1,1,-1,35553),-- [piece_bone_breastplate_fragment]
(20053,1898,1,1,-1,36155),-- [blue_diamond_necklace_gem]
(20053,57,160,286,0,700000),-- [adena]
(20053,39,1,1,1,1459.212084),-- [boots]
(20053,1930,1,1,1,17772.555141),-- [boots_lining]
(20053,51,1,1,1,1459.232775),-- [bracer]
(20053,1864,1,1,2,83174.087694),-- [stem]
(20053,1869,1,1,2,41587.043847),-- [iron_ore]
(20053,1878,1,1,2,16634.75594),-- [braided_hemp]
(20053,2151,1,1,2,11584.116331),-- [rp_necklace_of_devotion]
(20053,5437,1,1,2,1016.996188),-- [rp_heavy_sword]
(20054,1880,1,1,-1,34172),-- [steel]
(20054,3032,1,1,-1,13669),-- [rp_spiritshot_d]
(20054,1804,1,1,-1,13669),-- [rp_soulshot_d]
(20054,57,156,278,0,700000),-- [adena]
(20054,39,1,1,1,1416.686112),-- [boots]
(20054,1930,1,1,1,17254.607688),-- [boots_lining]
(20054,51,1,1,1,1416.7062),-- [bracer]
(20054,1867,1,1,2,53834.08194),-- [animal_skin]
(20054,1872,1,1,2,53834.08194),-- [animal_bone]
(20054,1882,1,1,2,8972.301132),-- [leather]
(20054,2176,1,1,2,19318.416228),-- [rp_leather_boots]
(20054,5268,1,1,2,1615.11876),-- [rp_adv_comp_soulshot_d]
(20055,2176,1,1,-1,163503),-- [rp_leather_boots]
(20055,1928,1,1,-1,49777),-- [piece_bone_gaiters_fragment]
(20055,1926,1,1,-1,34517),-- [piece_bone_breastplate_fragment]
(20055,57,156,278,0,700000),-- [adena]
(20055,219,1,1,1,107.35443),-- [sword_breaker]
(20055,2015,1,1,1,1230.64557),-- [sword_breaker_edge]
(20055,1869,1,1,2,40375.716636),-- [iron_ore]
(20055,1864,1,1,2,80751.433272),-- [stem]
(20055,1880,1,1,2,4037.515092),-- [steel]
(20055,2177,1,1,2,12899.597661),-- [rp_bone_helmet]
(20055,735,1,1,2,3364.737339),-- [swift_attack_potion]
(20056,1926,1,1,-1,34201),-- [piece_bone_breastplate_fragment]
(20056,5163,1,1,-1,13543),-- [rp_comp_bspiritshot_d]
(20056,2151,1,1,-1,94314),-- [rp_necklace_of_devotion]
(20056,57,154,276,0,700000),-- [adena]
(20056,27,1,1,1,352.163077),-- [hard_leather_shirt]
(20056,1927,1,1,1,3989.348954),-- [hard_leather_shirt_pattern]
(20056,33,1,1,1,565.042096),-- [hard_leather_gaiters]
(20056,1929,1,1,1,6452.445873),-- [hard_leather_gaiters_material]
(20056,1868,1,1,2,100013.252364),-- [thread]
(20056,1873,1,1,2,20002.702302),-- [silver_nugget]
(20056,2256,1,1,2,1222.650828),-- [rp_assassin_knife]
(20056,734,1,1,2,8334.394506),-- [quick_step_potion]
(20057,2176,1,1,-1,147276),-- [rp_leather_boots]
(20057,2258,1,1,-1,7526),-- [rp_temptation_of_abyss]
(20057,1927,1,1,-1,24556),-- [hard_leather_shirt_pattern]
(20057,57,140,251,0,700000),-- [adena]
(20057,1102,1,1,1,640.425264),-- [tunic_of_magicpower]
(20057,1105,1,1,1,1027.574736),-- [hose_of_magicpower]
(20057,1870,1,1,2,45460.579741),-- [coal]
(20057,1865,1,1,2,45460.579741),-- [varnish]
(20057,2257,1,1,2,1111.477393),-- [rp_trident]
(20057,5273,1,1,2,1818.363125),-- [rp_adv_comp_spiritshot_d]
(20058,1873,1,1,-1,144850),-- [silver_nugget]
(20058,1926,1,1,-1,36578),-- [piece_bone_breastplate_fragment]
(20058,1865,1,1,-1,362125),-- [varnish]
(20058,57,164,295,0,700000),-- [adena]
(20058,16,1,1,1,228),-- [long_spear]
(20058,1865,1,1,2,53483.196944),-- [varnish]
(20058,1870,1,1,2,53483.196944),-- [coal]
(20058,1879,1,1,2,8913.90522),-- [cokes]
(20058,2258,1,1,2,1307.700892),-- [rp_temptation_of_abyss]
(20059,2177,1,1,-1,115695),-- [rp_bone_helmet]
(20059,32,1,1,-1,4734),-- [piece_bone_gaiters]
(20059,1879,1,1,-1,60354),-- [cokes]
(20059,57,164,295,0,700000),-- [adena]
(20059,625,1,1,1,2160.640404),-- [bone_shield]
(20059,1148,1,1,1,1506.359596),-- [hard_leather_helmet]
(20059,1870,1,1,2,53483.147405),-- [coal]
(20059,1865,1,1,2,53483.147405),-- [varnish]
(20059,3032,1,1,2,2139.352595),-- [rp_spiritshot_d]
(20059,5158,1,1,2,2139.352595),-- [rp_comp_spiritshot_d]
(20060,1869,1,1,-1,369368),-- [iron_ore]
(20060,1928,1,1,-1,53805),-- [piece_bone_gaiters_fragment]
(20060,57,168,301,0,700000),-- [adena]
(20060,87,1,1,1,58.02444),-- [iron_hammer]
(20060,2014,1,1,1,626.927481),-- [iron_hammer_head]
(20060,155,1,1,1,58.02444),-- [buzdygan]
(20060,177,1,1,1,58.023639),-- [mage_staff]
(20060,1870,1,1,2,43642.188839),-- [coal]
(20060,1865,1,1,2,43642.188839),-- [varnish]
(20060,3953,1,1,2,1745.709363),-- [rp_blessed_spiritshot_d]
(20060,6666,1,1,2,43642.188839),-- [key_of_treasure_box2]
(20060,735,1,1,2,3636.72412),-- [swift_attack_potion]
(20061,1880,1,1,-1,38571),-- [steel]
(20061,1927,1,1,-1,30770),-- [hard_leather_shirt_pattern]
(20061,2176,1,1,-1,184549),-- [rp_leather_boots]
(20061,57,177,312,0,700000),-- [adena]
(20061,273,1,1,1,121.177056),-- [composition_bow]
(20061,2016,1,1,1,1334.822944),-- [composition_bow_shaft]
(20061,1866,1,1,2,30381.9065),-- [suede]
(20061,1871,1,1,2,45572.984215),-- [charcoal]
(20061,2257,1,1,2,1114.21068),-- [rp_trident]
(20061,5268,1,1,2,1822.91439),-- [rp_adv_comp_soulshot_d]
(20061,6666,1,1,2,45572.984215),-- [key_of_treasure_box2]
(20062,2257,1,1,-1,9246),-- [rp_trident]
(20062,27,1,1,-1,2663),-- [hard_leather_shirt]
(20062,1929,1,1,-1,48793),-- [hard_leather_gaiters_material]
(20062,57,173,305,0,700000),-- [adena]
(20062,219,1,1,1,118.828035),-- [sword_breaker]
(20062,2015,1,1,1,1362.171965),-- [sword_breaker_edge]
(20062,1872,1,1,2,59572.137482),-- [animal_bone]
(20062,1867,1,1,2,59572.137482),-- [animal_skin]
(20062,1881,1,1,2,5957.145399),-- [coarse_bone_powder]
(20062,2258,1,1,2,1092.391089),-- [rp_temptation_of_abyss]
(20062,6666,1,1,2,44679.188548),-- [key_of_treasure_box2]
(20063,2176,1,1,-1,196828),-- [rp_leather_boots]
(20063,34,1,1,-1,3486),-- [bronze_gaiters]
(20063,2177,1,1,-1,131428),-- [rp_bone_helmet]
(20063,57,183,337,0,700000),-- [adena]
(20063,273,1,1,1,129.249978),-- [composition_bow]
(20063,2016,1,1,1,1423.750022),-- [composition_bow_shaft]
(20063,1867,1,1,2,54005.375768),-- [animal_skin]
(20063,1872,1,1,2,54005.375768),-- [animal_bone]
(20063,1882,1,1,2,9000.842586),-- [leather]
(20063,1804,1,1,2,1620.154868),-- [rp_soulshot_d]
(20063,6666,1,1,2,40504.031826),-- [key_of_treasure_box2]
(20063,8294,1,1,2,990.219184),-- [rp_iron_sword]
(20064,1873,1,1,-1,162950),-- [silver_nugget]
(20064,1926,1,1,-1,41149),-- [piece_bone_breastplate_fragment]
(20064,1930,1,1,-1,104455),-- [boots_lining]
(20064,57,181,334,0,700000),-- [adena]
(20064,27,1,1,1,423.718001),-- [hard_leather_shirt]
(20064,1927,1,1,1,4799.932402),-- [hard_leather_shirt_pattern]
(20064,33,1,1,1,679.851248),-- [hard_leather_gaiters]
(20064,1929,1,1,1,7763.498349),-- [hard_leather_gaiters_material]
(20064,1866,1,1,2,32088.633729),-- [suede]
(20064,1871,1,1,2,48132.893994),-- [charcoal]
(20064,2179,1,1,2,23030.110152),-- [rp_excellence_leather_gloves]
(20064,5273,1,1,2,1925.288592),-- [rp_adv_comp_spiritshot_d]
(20064,734,1,1,2,8022.073533),-- [quick_step_potion]
(20066,1865,1,1,-1,445204),-- [varnish]
(20066,347,1,1,-1,1387),-- [ring_breastplate]
(20066,1873,1,1,-1,178082),-- [silver_nugget]
(20066,57,196,367,0,700000),-- [adena]
(20066,347,1,1,1,389.044172),-- [ring_breastplate]
(20066,376,1,1,1,622.955828),-- [iron_plate_gaiters]
(20066,1868,1,1,2,99945.297768),-- [thread]
(20066,1873,1,1,2,19989.005894),-- [silver_nugget]
(20066,5549,1,1,2,4997.318548),-- [iron_thread]
(20066,2178,1,1,2,7995.682847),-- [rp_dark_hose]
(20066,8294,1,1,2,1221.694943),-- [rp_iron_sword]
(20067,2180,1,1,-1,31555),-- [rp_scale_mail]
(20067,2020,1,1,-1,7347),-- [temptation_of_abyss_piece]
(20067,1869,1,1,-1,419687),-- [iron_ore]
(20067,57,185,346,0,700000),-- [adena]
(20067,847,1,1,1,568.9424),-- [red_cresent_earing]
(20067,910,1,1,1,426.7068),-- [necklace_of_devotion]
(20067,1899,1,1,1,9200.92615),-- [necklace_of_devotion_chain]
(20067,890,1,1,1,853.42465),-- [ring_of_devotion]
(20067,1864,1,1,2,117770.806104),-- [stem]
(20067,1869,1,1,2,58885.403052),-- [iron_ore]
(20067,1878,1,1,2,23554.243076),-- [braided_hemp]
(20067,2180,1,1,2,4427.547768),-- [rp_scale_mail]
(20068,2261,1,1,-1,7002),-- [rp_conjure_staff]
(20068,391,1,1,-1,1871),-- [puma_skin_shirt]
(20068,1899,1,1,-1,70456),-- [necklace_of_devotion_chain]
(20068,57,196,374,0,700000),-- [adena]
(20068,101,1,1,1,32.150125),-- [scroll_of_wisdom]
(20068,312,1,1,1,32.150125),-- [branch_of_life]
(20068,313,1,1,1,32.150125),-- [temptation_of_abyss]
(20068,2020,1,1,1,886.40153),-- [temptation_of_abyss_piece]
(20068,314,1,1,1,32.148095),-- [proof_of_revenge]
(20068,1864,1,1,2,126533.87649),-- [stem]
(20068,1869,1,1,2,63267.04629),-- [iron_ore]
(20068,1878,1,1,2,25306.73208),-- [braided_hemp]
(20068,2262,1,1,2,982.34514),-- [rp_elven_bow]
(20070,1872,1,1,-1,621523),-- [animal_bone]
(20070,2182,1,1,-1,55959),-- [rp_scale_gaiters]
(20070,2152,1,1,-1,82067),-- [rp_enchanted_necklace]
(20070,57,201,388,0,700000),-- [adena]
(20070,40,1,1,1,812.471808),-- [leather_boots]
(20070,1931,1,1,1,8549.528192),-- [leather_boots_lining]
(20070,604,1,1,1,812.471808),-- [excellence_leather_gloves]
(20070,1934,1,1,1,8549.528192),-- [excellence_leather_gloves_lining]
(20070,1872,1,1,2,69763.43844),-- [animal_bone]
(20070,1867,1,1,2,69763.43844),-- [animal_skin]
(20070,1881,1,1,2,6976.343844),-- [coarse_bone_powder]
(20070,1875,1,1,2,3488.247324),-- [stone_of_purity]
(20070,2263,1,1,2,812.531952),-- [rp_dwarven_trident]
(20072,2263,1,1,-1,7608),-- [rp_dwarven_trident]
(20072,3953,1,1,-1,19599),-- [rp_blessed_spiritshot_d]
(20072,1931,1,1,-1,64050),-- [leather_boots_lining]
(20072,57,210,411,0,700000),-- [adena]
(20072,626,1,1,1,1084.75878),-- [bronze_shield]
(20072,45,1,1,1,760.678815),-- [bone_helmet]
(20072,1932,1,1,1,14549.562405),-- [bone_helmet_design]
(20072,1866,1,1,2,26189.970019),-- [suede]
(20072,1871,1,1,2,39285.011773),-- [charcoal]
(20072,5220,1,1,2,1571.368694),-- [reinforcing_agent]
(20072,1885,1,1,2,3273.703694),-- [high_grade_suede]
(20072,2262,1,1,2,610.003375),-- [rp_elven_bow]
(20072,6666,1,1,2,39285.011773),-- [key_of_treasure_box2]
(20072,6035,1,1,2,3273.930672),-- [potion_of_acumen2]
(20074,1869,1,1,-1,507790),-- [iron_ore]
(20074,1061,1,1,-1,307751),-- [healing_potion]
(20074,1900,1,1,-1,55557),-- [enchanted_necklace_chain]
(20074,57,215,426,0,700000),-- [adena]
(20074,1123,1,1,1,1084),-- [blue_buckskin_boots]
(20074,605,1,1,1,1084),-- [leather_gauntlet]
(20074,1869,1,1,2,46247.94342),-- [iron_ore]
(20074,1864,1,1,2,92495.88684),-- [stem]
(20074,1880,1,1,2,4624.83948),-- [steel]
(20074,5550,1,1,2,616.58508),-- [reinforcing_plate]
(20074,737,1,1,2,4624.83948),-- [scroll_of_resurrection]
(20074,6387,1,1,2,1849.9057),-- [blessed_scroll_of_resurrection_pet]
(20075,1061,1,1,-1,282105),-- [healing_potion]
(20075,348,1,1,-1,908),-- [scale_mail]
(20075,2153,1,1,-1,72391),-- [rp_tiger'seye_earing]
(20075,57,197,391,0,700000),-- [adena]
(20075,848,1,1,1,387.77028),-- [enchanted_earing]
(20075,911,1,1,1,291.04554),-- [enchanted_necklace]
(20075,1900,1,1,1,6957.75324),-- [enchanted_necklace_chain]
(20075,879,1,1,1,583.43094),-- [enchanted_ring]
(20075,1871,1,1,2,42393.94416),-- [charcoal]
(20075,1866,1,1,2,28262.62944),-- [suede]
(20075,1877,1,1,2,1695.796016),-- [admantite_nugget]
(20075,955,1,1,2,169.636976),-- [scrl_of_ench_wp_d]
(20075,2193,1,1,2,5675.2844),-- [rp_boots_of_power]
(20075,1831,1,1,2,113050.709008),-- [antidote]
(20076,2250,1,1,-1,134666),-- [rp_bone_arrow]
(20076,1880,1,1,-1,53866),-- [steel]
(20076,1900,1,1,-1,58935),-- [enchanted_necklace_chain]
(20076,57,228,452,0,700000),-- [adena]
(20076,1123,1,1,1,1150),-- [blue_buckskin_boots]
(20076,605,1,1,1,1150),-- [leather_gauntlet]
(20076,1869,1,1,2,49059.738825),-- [iron_ore]
(20076,1864,1,1,2,98119.47765),-- [stem]
(20076,1880,1,1,2,4906.0203),-- [steel]
(20076,5550,1,1,2,654.1773),-- [reinforcing_plate]
(20076,956,1,1,2,1635.288525),-- [scrl_of_ench_am_d]
(20076,2274,1,1,2,350.2974),-- [rp_skull_breaker]
(20077,2153,1,1,-1,82578),-- [rp_tiger'seye_earing]
(20077,1933,1,1,-1,62468),-- [dark_hose_fabric]
(20077,2183,1,1,-1,34933),-- [rp_mithril_banded_mail]
(20077,57,224,448,0,700000),-- [adena]
(20077,627,1,1,1,1078.49287),-- [aspis]
(20077,46,1,1,1,755.50713),-- [bronze_helmet]
(20077,1870,1,1,2,72539.884816),-- [coal]
(20077,1865,1,1,2,72539.884816),-- [varnish]
(20077,1874,1,1,2,4836.032376),-- [oriharukon_ore]
(20077,955,1,1,2,290.197992),-- [scrl_of_ench_wp_d]
(20078,2024,1,1,-1,7564),-- [elven_bow_shaft]
(20078,2023,1,1,-1,6580),-- [conjure_staff_head]
(20078,1900,1,1,-1,58094),-- [enchanted_necklace_chain]
(20078,57,224,448,0,700000),-- [adena]
(20078,433,1,1,1,94.332676),-- [elven_tunic]
(20078,434,1,1,1,94.332676),-- [white_tunic]
(20078,1936,1,1,1,2968.270564),-- [white_tunic_pattern]
(20078,435,1,1,1,94.332676),-- [mage's_tunic]
(20078,466,1,1,1,151.133176),-- [elven_hose]
(20078,467,1,1,1,151.133176),-- [dark_hose]
(20078,1933,1,1,1,4267.323908),-- [dark_hose_fabric]
(20078,468,1,1,1,151.141148),-- [mage's_hose]
(20078,1868,1,1,2,116063.493736),-- [thread]
(20078,1873,1,1,2,23212.73434),-- [silver_nugget]
(20078,5549,1,1,2,5803.228076),-- [iron_thread]
(20078,1889,1,1,2,3868.759396),-- [compound_braid]
(20078,736,1,1,2,29015.784452),-- [scroll_of_escape]
(20079,1866,1,1,-1,353985),-- [suede]
(20079,2266,1,1,-1,5491),-- [rp_knife_o'_silenus]
(20079,1881,1,1,-1,70797),-- [coarse_bone_powder]
(20079,57,224,448,0,700000),-- [adena]
(20079,848,1,1,1,442.303424),-- [enchanted_earing]
(20079,911,1,1,1,331.976032),-- [enchanted_necklace]
(20079,1900,1,1,1,7936.240192),-- [enchanted_necklace_chain]
(20079,879,1,1,1,665.480352),-- [enchanted_ring]
(20079,1872,1,1,2,55268.379684),-- [animal_bone]
(20079,1867,1,1,2,55268.379684),-- [animal_skin]
(20079,1881,1,1,2,5526.88206),-- [coarse_bone_powder]
(20079,1875,1,1,2,2763.367544),-- [stone_of_purity]
(20079,2183,1,1,2,2727.06546),-- [rp_mithril_banded_mail]
(20079,2278,1,1,2,296.14858),-- [rp_strengthening_long_bow]
(20079,1061,1,1,2,25121.776988),-- [healing_potion]
(20080,2268,1,1,-1,5950),-- [rp_tome_of_blood]
(20080,2021,1,1,-1,7264),-- [spinebone_sword_blade]
(20080,1878,1,1,-1,230138),-- [braided_hemp]
(20080,57,243,485,0,700000),-- [adena]
(20080,259,1,1,1,127),-- [single-edged_jamadhr]
(20080,1864,1,1,2,104801.321735),-- [stem]
(20080,1869,1,1,2,52400.76974),-- [iron_ore]
(20080,1878,1,1,2,20960.351445),-- [braided_hemp]
(20080,1884,1,1,2,32246.510285),-- [cord]
(20080,737,1,1,2,5240.033425),-- [scroll_of_resurrection]
(20080,6387,1,1,2,2096.01337),-- [blessed_scroll_of_resurrection_pet]
(20081,1061,1,1,-1,583400),-- [healing_potion]
(20081,1933,1,1,-1,113248),-- [dark_hose_fabric]
(20081,57,406,814,0,700000),-- [adena]
(20081,848,1,1,1,801.863652),-- [enchanted_earing]
(20081,911,1,1,1,601.848186),-- [enchanted_necklace]
(20081,1900,1,1,1,14387.821116),-- [enchanted_necklace_chain]
(20081,879,1,1,1,1206.467046),-- [enchanted_ring]
(20081,1874,1,1,2,5009.78334),-- [oriharukon_ore]
(20081,1878,1,1,2,30058.609398),-- [braided_hemp]
(20081,1884,1,1,2,46244.098128),-- [cord]
(20081,1889,1,1,2,5009.78334),-- [compound_braid]
(20081,5220,1,1,2,3005.870004),-- [reinforcing_agent]
(20081,2267,1,1,2,777.073866),-- [rp_gastraphetes]
(20081,2274,1,1,2,536.781924),-- [rp_skull_breaker]
(20082,1884,1,1,-1,357298),-- [cord]
(20082,2275,1,1,-1,4147),-- [rp_heavy_bone_club]
(20082,1901,1,1,-1,80195),-- [tiger'seye_earing_stone]
(20082,57,245,491,0,700000),-- [adena]
(20082,553,1,1,1,225.588736),-- [iron_boots]
(20082,1940,1,1,1,6582.467584),-- [iron_boots_design]
(20082,2422,1,1,1,225.588736),-- [reinforce_leather_boots]
(20082,2423,1,1,1,225.588736),-- [boots_of_knowledge]
(20082,63,1,1,1,225.588736),-- [gauntlet]
(20082,2446,1,1,1,225.588736),-- [reinforce_leather_gloves]
(20082,2447,1,1,1,225.588736),-- [gloves_of_knowledge]
(20082,1875,1,1,2,2572.555764),-- [stone_of_purity]
(20082,1879,1,1,2,6431.289876),-- [cokes]
(20082,1885,1,1,2,3215.678116),-- [high_grade_suede]
(20082,5550,1,1,2,514.524424),-- [reinforcing_plate]
(20082,5549,1,1,2,3858.800468),-- [iron_thread]
(20082,2154,1,1,2,4131.457272),-- [rp_elven_earing]
(20082,2190,1,1,2,2756.295528),-- [rp_mithril_hose]
(20082,1832,1,1,2,42875.398552),-- [advanced_antidote]
(20083,2987,1,1,-1,69132),-- [rp_plate_shield]
(20083,2975,1,1,-1,63577),-- [rp_brigandine_helmet]
(20083,2154,1,1,-1,76237),-- [rp_elven_earing]
(20083,57,301,602,0,700000),-- [adena]
(20083,393,1,1,1,107.856888),-- [mithril_banded_mail]
(20083,1938,1,1,1,4241.629608),-- [mithril_banded_mail_material]
(20083,394,1,1,1,107.856888),-- [reinforce_leather_shirt]
(20083,415,1,1,1,172.393104),-- [mithril_banded_gaiters]
(20083,1939,1,1,1,5541.880752),-- [mithril_banded_gaiters_material]
(20083,416,1,1,1,172.38276),-- [reinforce_leather_gaiters]
(20083,1874,1,1,2,3154.944515),-- [oriharukon_ore]
(20083,1878,1,1,2,18929.66709),-- [braided_hemp]
(20083,1884,1,1,2,29122.575362),-- [cord]
(20083,1889,1,1,2,3154.944515),-- [compound_braid]
(20083,5220,1,1,2,1892.966709),-- [reinforcing_agent]
(20083,2155,1,1,2,7596.138292),-- [rp_elven_ring]
(20083,2286,1,1,2,262.917789),-- [rp_bonebreaker]
(20083,2985,1,1,2,4838.845728),-- [rp_plate_boots]
(20084,1885,1,1,-1,55207),-- [high_grade_suede]
(20084,2978,1,1,-1,88686),-- [rp_elven_mithril_boots]
(20084,1938,1,1,-1,44537),-- [mithril_banded_mail_material]
(20084,57,280,558,0,700000),-- [adena]
(20084,628,1,1,1,858.99538),-- [hoplon]
(20084,47,1,1,1,601.00462),-- [helmet]
(20084,1876,1,1,2,8805.965454),-- [mithril_ore]
(20084,1880,1,1,2,4402.982727),-- [steel]
(20084,1877,1,1,2,1761.157079),-- [admantite_nugget]
(20084,1881,1,1,2,5870.643636),-- [coarse_bone_powder]
(20084,1882,1,1,2,9784.40606),-- [leather]
(20084,2269,1,1,2,314.563073),-- [rp_morning_star]
(20084,2971,1,1,2,2354.451484),-- [rp_mithril_scale_gaiters]
(20084,1341,10,30,2,146764.830487),-- [bone_arrow]
(20085,2278,1,1,-1,5472),-- [rp_strengthening_long_bow]
(20085,2422,1,1,-1,3918),-- [reinforce_leather_boots]
(20085,2155,1,1,-1,122961),-- [rp_elven_ring]
(20085,57,324,645,0,700000),-- [adena]
(20085,553,1,1,1,297.62022),-- [iron_boots]
(20085,1940,1,1,1,8684.27868),-- [iron_boots_design]
(20085,2422,1,1,1,297.62022),-- [reinforce_leather_boots]
(20085,2423,1,1,1,297.62022),-- [boots_of_knowledge]
(20085,63,1,1,1,297.62022),-- [gauntlet]
(20085,2446,1,1,1,297.62022),-- [reinforce_leather_gloves]
(20085,2447,1,1,1,297.62022),-- [gloves_of_knowledge]
(20085,1870,1,1,2,67883.652096),-- [coal]
(20085,1865,1,1,2,67883.652096),-- [varnish]
(20085,1874,1,1,2,4525.517568),-- [oriharukon_ore]
(20085,2270,1,1,2,484.866304),-- [rp_goathead_staff]
(20085,2293,1,1,2,377.200512),-- [rp_glaive]
(20085,2986,1,1,2,6941.111424),-- [rp_sage's_worn_gloves]
(20086,1868,1,3,-1,588224),-- [thread]
(20086,469,1,1,-1,1607),-- [hose_of_knowledge]
(20086,1939,1,1,-1,51667),-- [mithril_banded_gaiters_material]
(20086,57,248,496,0,700000),-- [adena]
(20086,436,1,1,1,267.47631),-- [tunic_of_knowledge]
(20086,469,1,1,1,427.52369),-- [hose_of_knowledge]
(20086,1874,1,1,2,2978.613478),-- [oriharukon_ore]
(20086,1878,1,1,2,17871.56923),-- [braided_hemp]
(20086,1884,1,1,2,27494.709011),-- [cord]
(20086,1889,1,1,2,2978.613478),-- [compound_braid]
(20086,5220,1,1,2,1787.156923),-- [reinforcing_agent]
(20086,2972,1,1,2,2389.220657),-- [rp_brigandine_gaiters]
(20086,8307,1,1,2,319.117223),-- [rp_mace_of_priest]
(20087,2191,1,1,-1,188912),-- [rp_gauntlet_of_repose_of_the_soul]
(20087,1940,1,1,-1,210623),-- [iron_boots_design]
(20087,1866,1,1,-1,940782),-- [suede]
(20087,57,596,1189,0,700000),-- [adena]
(20087,393,1,1,1,213.763927),-- [mithril_banded_mail]
(20087,1938,1,1,1,8406.578557),-- [mithril_banded_mail_material]
(20087,394,1,1,1,213.763927),-- [reinforce_leather_shirt]
(20087,415,1,1,1,341.669666),-- [mithril_banded_gaiters]
(20087,1939,1,1,1,10983.574758),-- [mithril_banded_gaiters_material]
(20087,416,1,1,1,341.649165),-- [reinforce_leather_gaiters]
(20087,1871,1,1,2,93788.817808),-- [charcoal]
(20087,1866,1,1,2,62525.7801),-- [suede]
(20087,1877,1,1,2,3751.694464),-- [admantite_nugget]
(20087,2975,1,1,2,8373.980496),-- [rp_brigandine_helmet]
(20087,2984,1,1,2,9589.796468),-- [rp_slamander_skin_boots]
(20087,3020,1,1,2,520.937424),-- [rp_elven_long_sword]
(20087,2980,1,1,2,12555.35974),-- [rp_brigandine_gauntlet]
(20087,1832,1,1,2,104209.6335),-- [advanced_antidote]
(20088,2149,1,1,-1,112102),-- [rp_metallic_fiber]
(20088,1895,1,1,-1,448410),-- [metallic_fiber]
(20088,1875,1,1,-1,104629),-- [stone_of_purity]
(20088,57,662,1326,0,700000),-- [adena]
(20088,293,1,1,1,112),-- [war_hammer]
(20088,296,1,1,1,112),-- [dwarven_pike]
(20088,1872,1,1,2,185434.842315),-- [animal_bone]
(20088,1867,1,1,2,185434.842315),-- [animal_skin]
(20088,1881,1,1,2,18543.684457),-- [coarse_bone_powder]
(20088,1875,1,1,2,9271.642003),-- [stone_of_purity]
(20088,2270,1,1,2,993.518931),-- [rp_goathead_staff]
(20088,2288,1,1,2,772.469979),-- [rp_ghost_staff]
(20089,1884,1,1,-1,402384),-- [cord]
(20089,2159,1,1,-1,40363),-- [rp_necklace_of_darkness]
(20089,1902,1,1,-1,66249),-- [elven_earing_beads]
(20089,57,276,551,0,700000),-- [adena]
(20089,395,1,1,1,98.256501),-- [manticor_skin_shirt]
(20089,1942,1,1,1,4310.137062),-- [manticor_skin_shirt_texture]
(20089,417,1,1,1,156.919455),-- [manticor_skin_gaiters]
(20089,1943,1,1,1,6711.686982),-- [manticor_skin_gaiters_pattern]
(20089,1875,1,1,2,2816.692902),-- [stone_of_purity]
(20089,1879,1,1,2,7041.719876),-- [cokes]
(20089,1885,1,1,2,3520.859938),-- [high_grade_suede]
(20089,5550,1,1,2,563.343532),-- [reinforcing_plate]
(20089,5549,1,1,2,4225.026974),-- [iron_thread]
(20089,1825,1,1,2,3017.87641),-- [rp_oriharukon]
(20089,2205,1,1,2,1337.031032),-- [rp_chain_gaiters]
(20089,2989,1,1,2,2235.449336),-- [rp_chain_hood]
(20090,2197,1,1,-1,30160),-- [rp_slamander_skin_mail]
(20090,1868,1,7,-1,719317),-- [thread]
(20090,1825,1,1,-1,102760),-- [rp_oriharukon]
(20090,57,608,1214,0,700000),-- [adena]
(20090,352,1,1,1,107.918108),-- [brigandine]
(20090,1941,1,1,1,4929.057129),-- [brigandine_temper]
(20090,2377,1,1,1,172.624777),-- [mithril_scale_gaiters]
(20090,2918,1,1,1,7353.397649),-- [mithril_scale_gaiters_material]
(20090,2378,1,1,1,172.624777),-- [brigandine_gaiters]
(20090,2919,1,1,1,7353.37756),-- [brigandine_gaiters_material]
(20090,1876,1,1,2,18591.570984),-- [mithril_ore]
(20090,1880,1,1,2,9295.785492),-- [steel]
(20090,1877,1,1,2,3718.47126),-- [admantite_nugget]
(20090,1881,1,1,2,12394.24977),-- [coarse_bone_powder]
(20090,1882,1,1,2,20656.952064),-- [leather]
(20090,2158,1,1,2,11504.486742),-- [rp_mithril_ring]
(20090,5472,1,1,2,6639.84678),-- [rp_iron_thread]
(20090,1341,10,30,2,309856.636908),-- [bone_arrow]
(20092,1666,1,1,-1,49062),-- [rp_wooden_arrow]
(20092,1866,1,1,-1,98124),-- [suede]
(20092,2005,1,1,-1,10513),-- [broad_sword_blade]
(20092,57,79,107,0,700000),-- [adena]
(20092,113,1,1,1,9349.784408),-- [mage_earing]
(20092,906,1,1,1,6984.16868),-- [necklace_of_knowledge]
(20092,875,1,1,1,13802.046912),-- [ring_of_knowledge]
(20092,1869,1,1,2,14492.038992),-- [iron_ore]
(20092,1870,1,1,2,14492.038992),-- [coal]
(20092,1871,1,1,2,14492.038992),-- [charcoal]
(20092,1872,1,1,2,19322.718656),-- [animal_bone]
(20092,1867,1,1,2,19322.718656),-- [animal_skin]
(20092,2137,1,1,2,4262.445712),-- [rp_steel]
(20093,1867,1,1,-1,242609),-- [animal_skin]
(20093,2007,1,1,-1,12997),-- [bow_shaft]
(20093,1666,1,1,-1,60652),-- [rp_wooden_arrow]
(20093,57,98,132,0,700000),-- [adena]
(20093,3,1,1,1,1119.771954),-- [broad_sword]
(20093,2005,1,1,1,3839.228046),-- [broad_sword_blade]
(20093,1872,1,1,2,35831.462786),-- [animal_bone]
(20093,1867,1,1,2,35831.462786),-- [animal_skin]
(20093,2138,1,1,2,7904.062642),-- [rp_coarse_bone_powder]
(20093,1060,1,1,2,59719.011786),-- [lesser_healing_potion]
(20095,1864,1,1,-1,297315),-- [stem]
(20095,2006,1,1,-1,10618),-- [willow_staff_head]
(20095,57,80,108,0,700000),-- [adena]
(20095,428,1,1,1,2348.272102),-- [feriotic_tunic]
(20095,1100,1,1,1,2348.272102),-- [cotton_tunic]
(20095,463,1,1,1,3753.227898),-- [feriotic_hose]
(20095,1103,1,1,1,3753.227898),-- [cotton_hose]
(20095,1864,1,1,2,58547.899942),-- [stem]
(20095,1869,1,1,2,29273.949971),-- [iron_ore]
(20095,1789,1,1,2,5411.150087),-- [rp_cedar_staff]
(20096,1799,1,1,-1,298635),-- [rp_leather_gloves]
(20096,1921,1,1,-1,130051),-- [leather_shoes_texture]
(20096,1792,1,1,-1,14822),-- [rp_short_spear]
(20096,57,109,147,0,700000),-- [adena]
(20096,37,1,1,1,3891.653613),-- [leather_shoes]
(20096,1921,1,1,1,25609.659381),-- [leather_shoes_texture]
(20096,49,1,1,1,3891.687006),-- [gloves]
(20096,1869,1,1,2,19847.655828),-- [iron_ore]
(20096,1870,1,1,2,19847.655828),-- [coal]
(20096,1871,1,1,2,19847.655828),-- [charcoal]
(20096,1872,1,1,2,26463.541104),-- [animal_bone]
(20096,1867,1,1,2,26463.541104),-- [animal_skin]
(20096,736,1,1,2,9923.950308),-- [scroll_of_escape]
(20097,1864,1,1,-1,335964),-- [stem]
(20097,1793,1,1,-1,12352),-- [rp_sword_of_reflexion]
(20097,1872,1,1,-1,223976),-- [animal_bone]
(20097,57,91,122,0,700000),-- [adena]
(20097,23,1,1,1,1081.06461),-- [wooden_breastplate]
(20097,30,1,1,1,1731.967695),-- [hard_leather_pants]
(20097,2386,1,1,1,1731.967695),-- [wooden_gaiters]
(20097,1872,1,1,2,44105.829452),-- [animal_bone]
(20097,1867,1,1,2,44105.829452),-- [animal_skin]
(20097,1792,1,1,2,2432.341096),-- [rp_short_spear]
(20098,1867,1,1,-1,292047),-- [animal_skin]
(20098,1870,1,1,-1,219036),-- [coal]
(20098,1896,1,1,-1,92812),-- [necklace_of_anguish_chain]
(20098,57,117,161,0,700000),-- [adena]
(20098,66,1,1,1,207.363975),-- [gladius]
(20098,1333,1,1,1,207.363975),-- [brandish]
(20098,2010,1,1,1,1678.27205),-- [brandish_blade]
(20098,1865,1,1,2,43133.26426),-- [varnish]
(20098,1870,1,1,2,43133.26426),-- [coal]
(20098,1793,1,1,2,3171.47148),-- [rp_sword_of_reflexion]
(20099,2009,1,1,-1,6303),-- [dirk_blade]
(20099,1831,1,1,-1,473949),-- [antidote]
(20099,1896,1,1,-1,75310),-- [necklace_of_anguish_chain]
(20099,57,95,131,0,700000),-- [adena]
(20099,66,1,1,1,168.22935),-- [gladius]
(20099,1333,1,1,1,168.22935),-- [brandish]
(20099,2010,1,1,1,1361.5413),-- [brandish_blade]
(20099,1864,1,1,2,34999.480344),-- [stem]
(20099,1865,1,1,2,17499.740172),-- [varnish]
(20099,1866,1,1,2,11666.493448),-- [suede]
(20099,1873,1,1,2,6999.853088),-- [silver_nugget]
(20099,1868,1,1,2,34999.480344),-- [thread]
(20099,1794,1,1,2,1286.952604),-- [rp_bow_of_forest]
(20100,1833,1,1,-1,502269),-- [bandage]
(20100,1866,1,1,-1,125567),-- [suede]
(20100,1792,1,1,-1,13849),-- [rp_short_spear]
(20100,57,99,140,0,700000),-- [adena]
(20100,271,1,1,1,535),-- [hunting_bow]
(20100,1866,1,1,2,24727.163755),-- [suede]
(20100,1871,1,1,2,37090.687249),-- [charcoal]
(20100,1799,1,1,2,54949.148996),-- [rp_leather_gloves]
(20101,20,1,1,-1,23417),-- [buckler]
(20101,1921,1,1,-1,161654),-- [leather_shoes_texture]
(20101,1793,1,1,-1,18424),-- [rp_sword_of_reflexion]
(20101,57,128,189,0,700000),-- [adena]
(20101,114,1,1,1,2192.993905),-- [earing_of_strength]
(20101,115,1,1,1,2192.993905),-- [earing_of_wisdom]
(20101,907,1,1,1,1644.750895),-- [necklace_of_anguish]
(20101,1896,1,1,1,12544.73764),-- [necklace_of_anguish_chain]
(20101,876,1,1,1,3289.523655),-- [ring_of_anguish]
(20101,1864,1,1,2,49341.773522),-- [stem]
(20101,1865,1,1,2,24670.971962),-- [varnish]
(20101,1866,1,1,2,16447.20104),-- [suede]
(20101,1873,1,1,2,9868.320624),-- [silver_nugget]
(20101,1868,1,1,2,49341.773522),-- [thread]
(20101,1803,1,1,2,20731.95933),-- [rp_necklace_of_wisdom]
(20102,1866,1,1,-1,127538),-- [suede]
(20102,1922,1,1,-1,48803),-- [leather_tunic_pattern]
(20102,1793,1,1,-1,14067),-- [rp_sword_of_reflexion]
(20102,57,98,145,0,700000),-- [adena]
(20102,271,1,1,1,543),-- [hunting_bow]
(20102,1864,1,1,2,75345.199366),-- [stem]
(20102,1869,1,1,2,37672.533756),-- [iron_ore]
(20102,736,1,1,2,18836.266878),-- [scroll_of_escape]
(20103,1803,1,1,-1,198526),-- [rp_necklace_of_wisdom]
(20103,1871,1,1,-1,236245),-- [charcoal]
(20103,1921,1,1,-1,152416),-- [leather_shoes_texture]
(20103,57,119,180,0,700000),-- [adena]
(20103,37,1,1,1,4560.948576),-- [leather_shoes]
(20103,1921,1,1,1,30014.063712),-- [leather_shoes_texture]
(20103,49,1,1,1,4560.987712),-- [gloves]
(20103,1867,1,1,2,46522.183748),-- [animal_skin]
(20103,1872,1,1,2,46522.183748),-- [animal_bone]
(20103,1794,1,1,2,2565.646),-- [rp_bow_of_forest]
(20103,17,10,30,2,174457.986504),-- [wooden_arrow]
(20104,1869,1,1,-1,193011),-- [iron_ore]
(20104,1868,1,1,-1,386022),-- [thread]
(20104,57,97,147,0,700000),-- [adena]
(20104,271,1,1,1,548),-- [hunting_bow]
(20104,1873,1,1,2,11402.500967),-- [silver_nugget]
(20104,1868,1,1,2,57012.504835),-- [thread]
(20104,736,1,1,2,14253.069909),-- [scroll_of_escape]
(20104,17,10,30,2,142530.924289),-- [wooden_arrow]
(20105,734,1,1,-1,39986),-- [quick_step_potion]
(20105,1801,1,1,-1,120865),-- [rp_piece_bone_gaiters]
(20105,1872,1,1,-1,319890),-- [animal_bone]
(20105,57,119,185,0,700000),-- [adena]
(20105,15,1,1,1,135.010872),-- [short_spear]
(20105,2011,1,1,1,1616.989128),-- [short_spear_edge]
(20105,1867,1,1,2,47245.15581),-- [animal_skin]
(20105,1872,1,1,2,47245.15581),-- [animal_bone]
(20105,2140,1,1,2,7086.82041),-- [rp_high_grade_suede]
(20105,735,1,1,2,2952.86797),-- [swift_attack_potion]
(20106,2150,1,1,-1,111533),-- [rp_blue_diamond_necklace]
(20106,1897,1,1,-1,56563),-- [necklace_of_wisdom_chain]
(20106,734,1,1,-1,39594),-- [quick_step_potion]
(20106,57,118,183,0,700000),-- [adena]
(20106,38,1,1,1,1795.866945),-- [low_boots]
(20106,50,1,1,1,1795.866945),-- [leather_gloves]
(20106,1925,1,1,1,30677.26611),-- [leather_gloves_lining]
(20106,1867,1,1,2,46782.15126),-- [animal_skin]
(20106,1872,1,1,2,46782.15126),-- [animal_bone]
(20106,2141,1,1,2,7017.281895),-- [rp_silver_mold]
(20106,5273,1,1,2,1403.415585),-- [rp_adv_comp_spiritshot_d]
(20107,1869,1,1,-1,197971),-- [iron_ore]
(20107,734,1,1,-1,32995),-- [quick_step_potion]
(20107,1897,1,1,-1,47136),-- [necklace_of_wisdom_chain]
(20107,57,98,153,0,700000),-- [adena]
(20107,217,1,1,1,111.5),-- [shining_knife]
(20107,218,1,1,1,111.5),-- [throw_knife]
(20107,1865,1,1,2,29238.818472),-- [varnish]
(20107,1870,1,1,2,29238.818472),-- [coal]
(20107,2142,1,1,2,5847.750342),-- [rp_varnish_of_purity]
(20107,6035,1,1,2,2436.612714),-- [potion_of_acumen2]
(20108,1866,1,1,-1,167333),-- [suede]
(20108,734,1,1,-1,41833),-- [quick_step_potion]
(20108,1800,1,1,-1,78931),-- [rp_piece_bone_breastplate]
(20108,57,122,197,0,700000),-- [adena]
(20108,38,1,1,1,1897.427835),-- [low_boots]
(20108,50,1,1,1,1897.427835),-- [leather_gloves]
(20108,1925,1,1,1,32412.14433),-- [leather_gloves_lining]
(20108,1872,1,1,2,49427.752743),-- [animal_bone]
(20108,1867,1,1,2,49427.752743),-- [animal_skin]
(20108,2144,1,1,2,7414.212123),-- [rp_compound_braid]
(20108,735,1,1,2,3089.282391),-- [swift_attack_potion]
(20109,1865,1,1,-1,401928),-- [varnish]
(20109,845,1,1,-1,11752),-- [cat'seye_earing]
(20109,1924,1,1,-1,129654),-- [leather_helmet_design]
(20109,57,196,315,0,700000),-- [adena]
(20109,24,1,1,1,760.9576),-- [bone_breastplate]
(20109,390,1,1,1,760.9576),-- [tights_shirt]
(20109,31,1,1,1,1215.0424),-- [bone_gaiters]
(20109,412,1,1,1,1215.0424),-- [tights_pants]
(20109,1864,1,1,2,67841.751901),-- [stem]
(20109,1865,1,1,2,33920.987485),-- [varnish]
(20109,1866,1,1,2,22613.842944),-- [suede]
(20109,1873,1,1,2,13568.394994),-- [silver_nugget]
(20109,1868,1,1,2,67841.751901),-- [thread]
(20109,2150,1,1,2,15925.342048),-- [rp_blue_diamond_necklace]
(20109,5273,1,1,2,1356.928727),-- [rp_adv_comp_spiritshot_d]
(20110,734,1,1,-1,64842),-- [quick_step_potion]
(20110,1897,1,1,-1,92631),-- [necklace_of_wisdom_chain]
(20110,1801,1,1,-1,195995),-- [rp_piece_bone_gaiters]
(20110,57,190,305,0,700000),-- [adena]
(20110,24,1,1,1,736.6963),-- [bone_breastplate]
(20110,390,1,1,1,736.6963),-- [tights_shirt]
(20110,31,1,1,1,1176.3037),-- [bone_gaiters]
(20110,412,1,1,1,1176.3037),-- [tights_pants]
(20110,1871,1,1,2,76612.6698),-- [charcoal]
(20110,1866,1,1,2,51075.1132),-- [suede]
(20110,2173,1,1,2,20762.217),-- [rp_hard_leather_shirt]
(20112,1800,1,1,-1,123442),-- [rp_piece_bone_breastplate]
(20112,1924,1,1,-1,126628),-- [leather_helmet_design]
(20112,1801,1,1,-1,197756),-- [rp_piece_bone_gaiters]
(20112,57,188,310,0,700000),-- [adena]
(20112,1101,1,1,1,1486.48986),-- [tunic_of_devotion]
(20112,1104,1,1,1,2373.51014),-- [hose_of_devotion]
(20112,1864,1,1,2,92761.67314),-- [stem]
(20112,1869,1,1,2,46380.83657),-- [iron_ore]
(20112,1878,1,1,2,18552.37063),-- [braided_hemp]
(20112,1800,1,1,2,14585.13024),-- [rp_piece_bone_breastplate]
(20112,734,1,1,2,7729.98942),-- [quick_step_potion]
(20113,1925,1,1,-1,262556),-- [leather_gloves_lining]
(20113,1870,1,1,-1,400397),-- [coal]
(20113,1879,1,1,-1,66733),-- [cokes]
(20113,57,192,316,0,700000),-- [adena]
(20113,24,1,1,1,758.06935),-- [bone_breastplate]
(20113,390,1,1,1,758.06935),-- [tights_shirt]
(20113,31,1,1,1,1210.43065),-- [bone_gaiters]
(20113,412,1,1,1,1210.43065),-- [tights_pants]
(20113,1865,1,1,2,47308.454061),-- [varnish]
(20113,1870,1,1,2,47308.454061),-- [coal]
(20113,1879,1,1,2,7884.806457),-- [cokes]
(20113,1801,1,1,2,23833.039582),-- [rp_piece_bone_gaiters]
(20113,5273,1,1,2,1892.245839),-- [rp_adv_comp_spiritshot_d]
(20114,735,1,1,-1,33735),-- [swift_attack_potion]
(20114,2011,1,1,-1,9235),-- [short_spear_edge]
(20114,1817,1,1,-1,80965),-- [rp_cord]
(20114,57,190,323,0,700000),-- [adena]
(20114,845,1,1,1,1748.194758),-- [cat'seye_earing]
(20114,908,1,1,1,1311.156027),-- [necklace_of_wisdom]
(20114,1897,1,1,1,14235.357078),-- [necklace_of_wisdom_chain]
(20114,877,1,1,1,2622.292137),-- [ring_of_wisdom]
(20114,1866,1,1,2,39859.7892),-- [suede]
(20114,1871,1,1,2,59789.80039),-- [charcoal]
(20114,1817,1,1,2,11957.93676),-- [rp_cord]
(20114,6035,1,1,2,4982.47365),-- [potion_of_acumen2]
(20115,2012,1,1,-1,8603),-- [sword_of_reflexion_blade]
(20115,2139,1,1,-1,82584),-- [rp_steel_mold]
(20115,2013,1,1,-1,8912),-- [bow_of_forest_shaft]
(20115,57,194,330,0,700000),-- [adena]
(20115,38,1,1,1,3121.45142),-- [low_boots]
(20115,50,1,1,1,3121.45142),-- [leather_gloves]
(20115,1925,1,1,1,53321.09716),-- [leather_gloves_lining]
(20115,1869,1,1,2,34848.712),-- [iron_ore]
(20115,1870,1,1,2,34848.712),-- [coal]
(20115,1871,1,1,2,34848.712),-- [charcoal]
(20115,1872,1,1,2,46465.08656),-- [animal_bone]
(20115,1867,1,1,2,46465.08656),-- [animal_skin]
(20115,2139,1,1,2,6969.7424),-- [rp_steel_mold]
(20115,5158,1,1,2,1393.94848),-- [rp_comp_spiritshot_d]
(20117,1868,1,1,-1,505303),-- [thread]
(20117,734,1,1,-1,42109),-- [quick_step_potion]
(20117,1925,1,1,-1,165673),-- [leather_gloves_lining]
(20117,57,117,203,0,700000),-- [adena]
(20117,176,1,1,1,142),-- [apprentice's_staff]
(20117,2501,1,1,1,142),-- [bone_club]
(20117,1867,1,1,2,39802.316208),-- [animal_skin]
(20117,1872,1,1,2,39802.316208),-- [animal_bone]
(20117,1882,1,1,2,6633.735504),-- [leather]
(20117,2173,1,1,2,8089.94496),-- [rp_hard_leather_shirt]
(20117,735,1,1,2,2487.68712),-- [swift_attack_potion]
(20118,1866,1,1,-1,193642),-- [suede]
(20118,846,1,1,-1,4723),-- [coral_earing]
(20118,5549,1,1,-1,29046),-- [iron_thread]
(20118,57,132,236,0,700000),-- [adena]
(20118,87,1,1,1,45.6372),-- [iron_hammer]
(20118,2014,1,1,1,493.08903),-- [iron_hammer_head]
(20118,155,1,1,1,45.6372),-- [buzdygan]
(20118,177,1,1,1,45.63657),-- [mage_staff]
(20118,1868,1,1,2,85798.4332),-- [thread]
(20118,1873,1,1,2,17159.6616),-- [silver_nugget]
(20118,2179,1,1,2,20525.914),-- [rp_excellence_leather_gloves]
(20118,5273,1,1,2,1715.9912),-- [rp_adv_comp_spiritshot_d]
(20120,1787,1,1,-1,30885),-- [rp_willow_staff]
(20120,1864,1,1,-1,77212),-- [stem]
(20120,1874,1,1,-1,2574),-- [oriharukon_ore]
(20120,57,19,29,0,700000),-- [adena]
(20120,13,1,1,1,13530),-- [short_bow]
(20120,1870,1,1,2,9978.249995),-- [coal]
(20120,1865,1,1,2,9978.249995),-- [varnish]
(20120,1786,1,1,2,7982.599996),-- [rp_broad_sword]
(20120,1060,1,1,2,22173.900014),-- [lesser_healing_potion]
(20121,1788,1,1,-1,45293),-- [rp_bow]
(20121,1864,1,1,-1,113233),-- [stem]
(20121,1786,1,1,-1,45293),-- [rp_broad_sword]
(20121,57,30,42,0,700000),-- [adena]
(20121,4,1,1,1,9921),-- [club]
(20121,7,1,1,1,9921),-- [apprentice's_rod]
(20121,1871,1,1,2,14633.216469),-- [charcoal]
(20121,1866,1,1,2,9755.477646),-- [suede]
(20121,1786,1,1,2,11706.551323),-- [rp_broad_sword]
(20121,17,10,30,2,73165.754562),-- [wooden_arrow]
(20130,1666,1,1,-1,25914),-- [rp_wooden_arrow]
(20130,1060,1,1,-1,172757),-- [lesser_healing_potion]
(20130,2005,1,1,-1,5553),-- [broad_sword_blade]
(20130,57,41,58,0,700000),-- [adena]
(20130,1122,1,1,1,6514.326819),-- [cotton_shoes]
(20130,1129,1,1,1,6514.326819),-- [crude_leather_shoes]
(20130,1119,1,1,1,6514.346362),-- [short_leather_gloves]
(20130,1864,1,1,2,30618),-- [stem]
(20130,1869,1,1,2,15309),-- [iron_ore]
(20130,1666,1,1,2,5103),-- [rp_wooden_arrow]
(20131,1789,1,1,-1,17988),-- [rp_cedar_staff]
(20131,2006,1,1,-1,6951),-- [willow_staff_head]
(20131,1666,1,1,-1,32439),-- [rp_wooden_arrow]
(20131,57,51,72,0,700000),-- [adena]
(20131,19,1,1,1,11732.93531),-- [small_shield]
(20131,42,1,1,1,8213.06469),-- [leather_cap]
(20131,1865,1,1,2,19163.735248),-- [varnish]
(20131,1870,1,1,2,19163.735248),-- [coal]
(20131,1797,1,1,2,38714.529504),-- [rp_leather_hose]
(20132,1060,1,1,-1,330759),-- [lesser_healing_potion]
(20132,2006,1,1,-1,10632),-- [willow_staff_head]
(20132,57,80,108,0,700000),-- [adena]
(20132,254,1,1,1,1832),-- [iron_glove]
(20132,1872,1,1,2,29310.335516),-- [animal_bone]
(20132,1867,1,1,2,29310.335516),-- [animal_skin]
(20132,1797,1,1,2,44409.563702),-- [rp_leather_hose]
(20132,734,1,1,2,3663.765266),-- [quick_step_potion]
(20134,947,1,1,-1,832),-- [scrl_of_ench_wp_b]
(20134,356,1,1,-1,233),-- [full_plate_armor]
(20134,1871,1,5,-1,693087),-- [charcoal]
(20134,57,821,1673,0,700000),-- [adena]
(20134,357,1,1,1,9.6201),-- [shrnoen's_breastplate]
(20134,4056,1,1,1,1389.919174),-- [shrnoen's_breastplate_part]
(20134,2376,1,1,1,9.6201),-- [avadon_breastplate]
(20134,4064,1,1,1,1389.919174),-- [avadon_breastplate_part]
(20134,383,1,1,1,15.39216),-- [shrnoen's_gaiters]
(20134,4057,1,1,1,2148.06144),-- [shrnoen's_gaiters_material]
(20134,2379,1,1,1,15.39216),-- [avadon_gaiters]
(20134,4065,1,1,1,2148.075692),-- [avadon_gaiters_material]
(20134,1866,1,1,2,34121.337873),-- [suede]
(20134,1871,1,1,2,51182.053734),-- [charcoal]
(20134,5220,1,1,2,2047.315935),-- [reinforcing_agent]
(20134,1885,1,1,2,4265.155503),-- [high_grade_suede]
(20134,4041,1,1,2,445.031958),-- [mold_hardener]
(20134,947,1,1,2,20.459082),-- [scrl_of_ench_wp_b]
(20134,4993,1,1,2,636.577767),-- [rp_doom_gloves_i]
(20134,4192,1,1,2,39.041184),-- [rp_sword_of_damascus]
(20134,8728,1,1,2,852.993561),-- [general_61_b]
(20134,8738,1,1,2,213.224928),-- [special_61_b]
(20134,8748,1,1,2,21.303723),-- [rare_61_b]
(20134,8758,1,1,2,4.504752),-- [unique_61_b]
(20135,2038,1,1,-1,9877),-- [maingauche_edge]
(20135,5231,1,1,-1,66770),-- [rp_reinforcing_agent]
(20135,1882,1,1,-1,207728),-- [leather]
(20135,57,390,779,0,700000),-- [adena]
(20135,261,1,1,1,44.994933),-- [bich'hwa]
(20135,2039,1,1,1,2446.005067),-- [bich'hwa_edge]
(20135,1867,1,1,2,92039.390346),-- [animal_skin]
(20135,1872,1,1,2,92039.390346),-- [animal_bone]
(20135,1882,1,1,2,15340.003224),-- [leather]
(20135,1894,1,1,2,2422.061632),-- [crafted_leather]
(20135,2296,1,1,2,383.479114),-- [rp_atuba_mace]
(20135,2286,1,1,2,383.479114),-- [rp_bonebreaker]
(20135,2985,1,1,2,7058.196224),-- [rp_plate_boots]
(20136,1914,1,1,-1,257308),-- [earing_of_binding_gemstone]
(20136,4601,1,1,-1,10178),-- [dye_s3c3_c]
(20136,1539,1,3,-1,508898),-- [greater_healing_potion]
(20136,57,1812,3683,0,700000),-- [adena]
(20136,75,1,1,1,9.554158),-- [caliburs]
(20136,2089,1,1,1,860.114248),-- [caliburs_edge]
(20136,76,1,1,1,9.554158),-- [sword_of_delusion]
(20136,2090,1,1,1,860.114248),-- [sword_of_delusion_blade]
(20136,77,1,1,1,9.554158),-- [tsurugi]
(20136,2091,1,1,1,860.114248),-- [tsurugi_blade]
(20136,84,1,1,1,9.554158),-- [homunkulus's_sword]
(20136,2092,1,1,1,860.114248),-- [homunkulus's_sword_blade]
(20136,134,1,1,1,9.554158),-- [sword_of_nightmare]
(20136,2095,1,1,1,860.114248),-- [sword_of_nightmare_blade]
(20136,145,1,1,1,9.554158),-- [deathbreath_sword]
(20136,2096,1,1,1,860.103812),-- [deathbreath_sword_blade]
(20136,1869,1,1,2,172185.330568),-- [iron_ore]
(20136,1864,1,3,2,172185.330568),-- [stem]
(20136,1880,1,1,2,17218.646992),-- [steel]
(20136,5550,1,1,2,2295.79428),-- [reinforcing_plate]
(20136,4043,1,1,2,5739.675592),-- [asofe]
(20136,2169,1,1,2,3047.386816),-- [rp_necklace_of_binding]
(20136,2232,1,1,2,989.717104),-- [rp_drake_leather_mail]
(20136,8725,1,1,2,4782.999696),-- [general_52_c]
(20136,8735,1,1,2,1195.560032),-- [special_52_c]
(20136,8745,1,1,2,119.63196),-- [rare_52_c]
(20136,8755,1,1,2,23.926392),-- [unique_52_c]
(20137,2961,1,1,-1,106305),-- [full_plate_boots_part]
(20137,1877,1,1,-1,78092),-- [admantite_nugget]
(20137,4049,1,1,-1,102402),-- [adamantite_earing_gemstone]
(20137,57,770,1572,0,700000),-- [adena]
(20137,11889,1,1,1,55.00082),-- [great_sword_low]
(20137,4104,1,1,1,550.013594),-- [great_sword_blade]
(20137,11916,1,1,1,55.00082),-- [kshanberk_low]
(20137,4107,1,1,1,541.491074),-- [kshanberk_blade]
(20137,11900,1,1,1,55.00082),-- [sword_of_valhalla_low]
(20137,4108,1,1,1,541.492872),-- [sword_of_valhalla_blade]
(20137,1869,1,1,2,44359.859222),-- [iron_ore]
(20137,1864,1,1,2,88719.565991),-- [stem]
(20137,1880,1,1,2,4435.924941),-- [steel]
(20137,5550,1,1,2,591.51764),-- [reinforcing_plate]
(20137,4043,1,1,2,1478.641647),-- [asofe]
(20137,4952,1,1,2,570.17422),-- [rp_avadon_circlet_i]
(20137,4999,1,1,2,551.727407),-- [rp_doom_boots_i]
(20137,4163,1,1,2,293.776931),-- [rp_blue_wolve's_hose]
(20137,6669,1,1,2,10316.189604),-- [key_of_treasure_box5]
(20137,8727,1,1,2,887.124007),-- [general_58_b]
(20137,8737,1,1,2,221.819115),-- [special_58_b]
(20137,8747,1,1,2,22.105685),-- [rare_58_b]
(20137,8757,1,1,2,4.57359),-- [unique_58_b]
(20143,1872,1,1,-1,284370),-- [animal_bone]
(20143,1867,1,1,-1,284370),-- [animal_skin]
(20143,1792,1,1,-1,15682),-- [rp_short_spear]
(20143,57,114,157,0,700000),-- [adena]
(20143,20,1,1,1,5887.56231),-- [buckler]
(20143,43,1,1,1,4117.43769),-- [wooden_helmet]
(20143,1866,1,1,2,20999.590341),-- [suede]
(20143,1871,1,1,2,31499.505951),-- [charcoal]
(20143,1798,1,1,2,30881.892195),-- [rp_leather_helmet]
(20143,17,10,30,2,157498.011513),-- [wooden_arrow]
(20144,1880,1,1,-1,71999),-- [steel]
(20144,2272,1,1,-1,5143),-- [rp_sword_of_revolution]
(20144,1901,1,1,-1,99446),-- [tiger'seye_earing_stone]
(20144,57,304,607,0,700000),-- [adena]
(20144,393,1,1,1,109.06642),-- [mithril_banded_mail]
(20144,1938,1,1,1,4289.19622),-- [mithril_banded_mail_material]
(20144,394,1,1,1,109.06642),-- [reinforce_leather_shirt]
(20144,415,1,1,1,174.32636),-- [mithril_banded_gaiters]
(20144,1939,1,1,1,5604.02868),-- [mithril_banded_gaiters_material]
(20144,416,1,1,1,174.3159),-- [reinforce_leather_gaiters]
(20144,1875,1,1,2,2552.070594),-- [stone_of_purity]
(20144,1879,1,1,2,6380.176485),-- [cokes]
(20144,1885,1,1,2,3189.999592),-- [high_grade_suede]
(20144,5550,1,1,2,510.449579),-- [reinforcing_plate]
(20144,5549,1,1,2,3828.105891),-- [iron_thread]
(20144,2976,1,1,2,5124.530803),-- [rp_manticor_skin_boots]
(20144,2274,1,1,2,273.398142),-- [rp_skull_breaker]
(20144,2985,1,1,2,3914.274177),-- [rp_plate_boots]
(20144,6667,1,1,2,23925.528843),-- [key_of_treasure_box3]
(20144,1341,10,30,2,127602.465894),-- [bone_arrow]
(20145,2183,1,1,-1,39675),-- [rp_mithril_banded_mail]
(20145,2268,1,1,-1,6236),-- [rp_tome_of_blood]
(20145,2153,1,1,-1,93789),-- [rp_tiger'seye_earing]
(20145,57,254,510,0,700000),-- [adena]
(20145,848,1,1,1,502.355926),-- [enchanted_earing]
(20145,911,1,1,1,377.049143),-- [enchanted_necklace]
(20145,1900,1,1,1,9013.760858),-- [enchanted_necklace_chain]
(20145,879,1,1,1,755.834073),-- [enchanted_ring]
(20145,1868,1,1,2,109850.451315),-- [thread]
(20145,1873,1,1,2,21970.11865),-- [silver_nugget]
(20145,5549,1,1,2,5492.458695),-- [iron_thread]
(20145,1889,1,1,2,3661.63913),-- [compound_braid]
(20145,2268,1,1,2,568.02387),-- [rp_tome_of_blood]
(20145,2276,1,1,2,392.30834),-- [rp_maingauche]
(20146,1915,1,1,-1,130858),-- [ring_of_ages_gemstone]
(20146,1869,1,3,-1,742616),-- [iron_ore]
(20146,1914,1,1,-1,83440),-- [earing_of_binding_gemstone]
(20146,57,587,1194,0,700000),-- [adena]
(20146,103,1,1,1,77.434918),-- [tower_shield]
(20146,1978,1,1,1,4921.495953),-- [tower_shield_fragment]
(20146,107,1,1,1,77.434918),-- [composite_shield]
(20146,4055,1,1,1,4921.495953),-- [composite_shield_fragment]
(20146,517,1,1,1,54.22802),-- [composite_helmet]
(20146,2957,1,1,1,3367.341109),-- [composite_helmet_design]
(20146,1149,1,1,1,54.22802),-- [shining_circlet]
(20146,1983,1,1,1,3367.341109),-- [shining_circlet_pattern]
(20146,1871,1,1,2,47246.417626),-- [charcoal]
(20146,1866,1,1,2,31497.640505),-- [suede]
(20146,1877,1,1,2,1889.849804),-- [admantite_nugget]
(20146,4041,1,1,2,410.870669),-- [mold_hardener]
(20146,4040,1,1,2,944.924902),-- [mold_lubricant]
(20146,2170,1,1,2,1114.345434),-- [rp_nassen's_earing]
(20146,4609,1,1,2,104.982071),-- [dye_m3i3_c]
(20146,3014,1,1,2,1319.737637),-- [rp_full_plate_boots]
(20146,4188,1,1,2,54.431953),-- [rp_hell_knife]
(20146,8725,1,1,2,1312.405282),-- [general_52_c]
(20146,8735,1,1,2,328.058189),-- [special_52_c]
(20146,8745,1,1,2,32.77994),-- [rare_52_c]
(20146,8755,1,1,2,6.555988),-- [unique_52_c]
(20147,1870,1,1,-1,341721),-- [coal]
(20147,1876,1,1,-1,68344),-- [mithril_ore]
(20147,57,156,278,0,700000),-- [adena]
(20147,27,1,1,1,355.418392),-- [hard_leather_shirt]
(20147,1927,1,1,1,4026.225584),-- [hard_leather_shirt_pattern]
(20147,33,1,1,1,570.265216),-- [hard_leather_gaiters]
(20147,1929,1,1,1,6512.090808),-- [hard_leather_gaiters_material]
(20147,1873,1,1,2,20187.870617),-- [silver_nugget]
(20147,1868,1,1,2,100939.353085),-- [thread]
(20147,2255,1,1,2,1234.01334),-- [rp_saber]
(20147,6666,1,1,2,50469.762958),-- [key_of_treasure_box2]
(20153,1831,1,1,-1,537542),-- [antidote]
(20153,30,1,1,-1,10554),-- [hard_leather_pants]
(20153,1867,1,1,-1,268771),-- [animal_skin]
(20153,57,109,147,0,700000),-- [adena]
(20153,429,1,1,1,972.9426),-- [leather_tunic]
(20153,1922,1,1,1,7594.824544),-- [leather_tunic_pattern]
(20153,464,1,1,1,1558.71768),-- [leather_hose]
(20153,1923,1,1,1,12201.515176),-- [leather_hose_pattern]
(20153,1867,1,1,2,52927.092659),-- [animal_skin]
(20153,1872,1,1,2,52927.092659),-- [animal_bone]
(20153,1793,1,1,2,2918.814682),-- [rp_sword_of_reflexion]
(20154,2178,1,1,-1,54675),-- [rp_dark_hose]
(20154,1929,1,1,-1,44093),-- [hard_leather_gaiters_material]
(20154,1898,1,1,-1,35102),-- [blue_diamond_necklace_gem]
(20154,57,156,278,0,700000),-- [adena]
(20154,846,1,1,1,820.594371),-- [coral_earing]
(20154,909,1,1,1,615.447741),-- [blue_diamond_necklace]
(20154,1898,1,1,1,5184.054555),-- [blue_diamond_necklace_gem]
(20154,878,1,1,1,1230.903333),-- [blue_coral_ring]
(20154,1868,1,1,2,100939.3452),-- [thread]
(20154,1873,1,1,2,20187.86904),-- [silver_nugget]
(20154,2256,1,1,2,1233.97398),-- [rp_assassin_knife]
(20154,5158,1,1,2,2018.81178),-- [rp_comp_spiritshot_d]
(20155,1865,1,1,-1,385707),-- [varnish]
(20155,1898,1,1,-1,39621),-- [blue_diamond_necklace_gem]
(20155,1804,1,1,-1,15428),-- [rp_soulshot_d]
(20155,57,177,312,0,700000),-- [adena]
(20155,846,1,1,1,926.265102),-- [coral_earing]
(20155,909,1,1,1,694.701042),-- [blue_diamond_necklace]
(20155,1898,1,1,1,5851.62291),-- [blue_diamond_necklace_gem]
(20155,878,1,1,1,1389.410946),-- [blue_coral_ring]
(20155,1869,1,1,2,32551.95924),-- [iron_ore]
(20155,1864,1,1,2,65103.91848),-- [stem]
(20155,1880,1,1,2,3255.22368),-- [steel]
(20155,3032,1,1,2,1302.03396),-- [rp_spiritshot_d]
(20155,5273,1,1,2,1302.03396),-- [rp_adv_comp_spiritshot_d]
(20155,6666,1,1,2,32551.95924),-- [key_of_treasure_box2]
(20155,735,1,1,2,2712.87144),-- [swift_attack_potion]
(20156,2181,1,1,-1,42851),-- [rp_white_tunic]
(20156,1899,1,1,-1,66888),-- [necklace_of_devotion_chain]
(20156,57,188,353,0,700000),-- [adena]
(20156,847,1,1,1,580.321248),-- [red_cresent_earing]
(20156,910,1,1,1,435.240936),-- [necklace_of_devotion]
(20156,1899,1,1,1,9384.944673),-- [necklace_of_devotion_chain]
(20156,890,1,1,1,870.493143),-- [ring_of_devotion]
(20156,1876,1,1,2,6864.288338),-- [mithril_ore]
(20156,1880,1,1,2,3432.144169),-- [steel]
(20156,1877,1,1,2,1372.838424),-- [admantite_nugget]
(20156,1881,1,1,2,4576.176189),-- [coarse_bone_powder]
(20156,1882,1,1,2,7627.008424),-- [leather]
(20156,2181,1,1,2,3435.608017),-- [rp_white_tunic]
(20156,1061,1,1,2,20800.936439),-- [healing_potion]
(20157,1879,1,1,-1,102726),-- [cokes]
(20157,2024,1,1,-1,8780),-- [elven_bow_shaft]
(20157,2153,1,1,-1,95856),-- [rp_tiger'seye_earing]
(20157,57,261,517,0,700000),-- [adena]
(20157,86,1,1,1,13.597838),-- [tomahawk]
(20157,179,1,1,1,13.597838),-- [mace_of_prayer]
(20157,180,1,1,1,13.597838),-- [mace_of_judgment]
(20157,2022,1,1,1,524.75379),-- [mace_of_judgment_head]
(20157,181,1,1,1,13.597838),-- [mace_of_miracle]
(20157,182,1,1,1,13.597838),-- [doom_hammer]
(20157,183,1,1,1,13.597838),-- [mystic_staff]
(20157,184,1,1,1,13.597838),-- [conjure_staff]
(20157,2023,1,1,1,417.462455),-- [conjure_staff_head]
(20157,185,1,1,1,13.598889),-- [staff_of_mana]
(20157,1864,1,1,2,84203.507106),-- [stem]
(20157,1869,1,1,2,42101.753553),-- [iron_ore]
(20157,1878,1,1,2,16840.616616),-- [braided_hemp]
(20157,1884,1,1,2,25908.836652),-- [cord]
(20157,1829,1,1,2,16840.616616),-- [scroll_of_escape_to_agit]
(20157,2274,1,1,2,300.634434),-- [rp_skull_breaker]
(20157,2282,1,1,2,300.634434),-- [rp_cursed_maingauche]
(20157,1061,1,1,2,25516.400589),-- [healing_potion]
(20158,1876,1,1,-1,136283),-- [mithril_ore]
(20158,1939,1,1,-1,59852),-- [mithril_banded_gaiters_material]
(20158,1901,1,1,-1,94118),-- [tiger'seye_earing_stone]
(20158,57,288,574,0,700000),-- [adena]
(20158,436,1,1,1,309.81069),-- [tunic_of_knowledge]
(20158,469,1,1,1,495.18931),-- [hose_of_knowledge]
(20158,1869,1,1,2,60383.782575),-- [iron_ore]
(20158,1864,1,1,2,120767.373495),-- [stem]
(20158,1880,1,1,2,6038.28243),-- [steel]
(20158,5550,1,1,2,805.142655),-- [reinforcing_plate]
(20158,2271,1,1,2,431.22375),-- [rp_winged_spear]
(20158,2972,1,1,2,3229.195095),-- [rp_brigandine_gaiters]
(20160,2152,1,1,-1,87127),-- [rp_enchanted_necklace]
(20160,2261,1,1,-1,7685),-- [rp_conjure_staff]
(20160,1874,1,1,-1,32992),-- [oriharukon_ore]
(20160,57,212,415,0,700000),-- [adena]
(20160,258,1,1,1,176),-- [bagh-nakh]
(20160,1874,1,1,2,3086.021248),-- [oriharukon_ore]
(20160,1878,1,1,2,18516.190664),-- [braided_hemp]
(20160,1884,1,1,2,28486.437456),-- [cord]
(20160,1889,1,1,2,3086.021248),-- [compound_braid]
(20160,5220,1,1,2,1851.625384),-- [reinforcing_agent]
(20160,2152,1,1,2,8149.704),-- [rp_enchanted_necklace]
(20161,1984,1,1,-1,34800),-- [theca_leather_mail_pattern]
(20161,1806,1,1,-1,3247),-- [rp_soulshot_b]
(20161,1872,1,5,-1,721517),-- [animal_bone]
(20161,57,643,1305,0,700000),-- [adena]
(20161,266,1,1,1,12.713712),-- [great_pata]
(20161,2120,1,1,1,1439.286288),-- [great_pata_blade]
(20161,1867,1,1,2,53281.330256),-- [animal_skin]
(20161,1872,1,1,2,53281.330256),-- [animal_bone]
(20161,1882,1,1,2,8880.17746),-- [leather]
(20161,1894,1,1,2,1402.084376),-- [crafted_leather]
(20161,4042,1,1,2,665.996716),-- [enria]
(20161,1806,1,1,2,79.914296),-- [rp_soulshot_b]
(20161,5165,1,1,2,79.914296),-- [rp_comp_bspiritshot_b]
(20161,4180,1,1,2,4440.155104),-- [rp_silver_arrow]
(20161,3955,1,1,2,79.914296),-- [rp_blessed_spiritshot_b]
(20161,5280,1,1,2,79.914296),-- [rp_adv_comp_bspiritshot_b]
(20161,6669,1,1,2,9293.289236),-- [key_of_treasure_box5]
(20161,8726,1,1,2,924.988064),-- [general_55_c]
(20161,8736,1,1,2,231.247016),-- [special_55_c]
(20161,8746,1,1,2,23.098152),-- [rare_55_c]
(20161,8756,1,1,2,4.64618),-- [unique_55_c]
(20168,1877,1,1,-1,21239),-- [admantite_nugget]
(20168,1061,1,1,-1,321804),-- [healing_potion]
(20168,955,1,1,-1,2124),-- [scrl_of_ench_wp_d]
(20168,57,224,448,0,700000),-- [adena]
(20168,627,1,1,1,1078.49287),-- [aspis]
(20168,46,1,1,1,755.50713),-- [bronze_helmet]
(20168,1865,1,1,2,48359.887005),-- [varnish]
(20168,1870,1,1,2,48359.887005),-- [coal]
(20168,1879,1,1,2,8060.037882),-- [cokes]
(20168,1875,1,1,2,3223.992467),-- [stone_of_purity]
(20168,2184,1,1,2,5079.804336),-- [rp_mithril_banded_gaiters]
(20168,2274,1,1,2,345.391305),-- [rp_skull_breaker]
(20171,1880,1,1,-1,45092),-- [steel]
(20171,2019,1,1,-1,9697),-- [trident_edge]
(20171,1899,1,1,-1,70456),-- [necklace_of_devotion_chain]
(20171,57,196,374,0,700000),-- [adena]
(20171,101,1,1,1,32.150125),-- [scroll_of_wisdom]
(20171,312,1,1,1,32.150125),-- [branch_of_life]
(20171,313,1,1,1,32.150125),-- [temptation_of_abyss]
(20171,2020,1,1,1,886.40153),-- [temptation_of_abyss_piece]
(20171,314,1,1,1,32.148095),-- [proof_of_revenge]
(20171,1875,1,1,2,2811.846308),-- [stone_of_purity]
(20171,1879,1,1,2,7029.61577),-- [cokes]
(20171,5549,1,1,2,4217.769462),-- [iron_thread]
(20171,2263,1,1,2,654.932122),-- [rp_dwarven_trident]
(20171,6666,1,1,2,42177.612166),-- [key_of_treasure_box2]
(20171,1061,1,1,2,25562.224172),-- [healing_potion]
(20176,1873,1,1,-1,287994),-- [silver_nugget]
(20176,2273,1,1,-1,5143),-- [rp_tarbar]
(20176,2154,1,1,-1,77086),-- [rp_elven_earing]
(20176,57,304,607,0,700000),-- [adena]
(20176,553,1,1,1,279.740266),-- [iron_boots]
(20176,1940,1,1,1,8162.558404),-- [iron_boots_design]
(20176,2422,1,1,1,279.740266),-- [reinforce_leather_boots]
(20176,2423,1,1,1,279.740266),-- [boots_of_knowledge]
(20176,63,1,1,1,279.740266),-- [gauntlet]
(20176,2446,1,1,1,279.740266),-- [reinforce_leather_gloves]
(20176,2447,1,1,1,279.740266),-- [gloves_of_knowledge]
(20176,1867,1,1,2,72916.469689),-- [animal_skin]
(20176,1872,1,1,2,72916.469689),-- [animal_bone]
(20176,1882,1,1,2,12152.774702),-- [leather]
(20176,2977,1,1,2,7320.871184),-- [rp_brigandine_boots]
(20176,2286,1,1,2,303.846146),-- [rp_bonebreaker]
(20176,2985,1,1,2,5591.697406),-- [rp_plate_boots]
(20176,2981,1,1,2,7320.871184),-- [rp_elven_mithril_gloves]
(20190,1864,1,3,-1,533484),-- [stem]
(20190,2025,1,1,-1,7389),-- [dwarven_trident_edge]
(20190,1900,1,1,-1,58368),-- [enchanted_necklace_chain]
(20190,57,226,448,0,700000),-- [adena]
(20190,275,1,1,1,39.230345),-- [long_bow]
(20190,276,1,1,1,39.230345),-- [elven_bow]
(20190,2024,1,1,1,1384.53931),-- [elven_bow_shaft]
(20190,1866,1,1,2,38870.431145),-- [suede]
(20190,1871,1,1,2,58305.703435),-- [charcoal]
(20190,5220,1,1,2,2332.2236),-- [reinforcing_agent]
(20190,1885,1,1,2,4858.761355),-- [high_grade_suede]
(20190,2153,1,1,2,9067.880465),-- [rp_tiger'seye_earing]
(20191,2264,1,1,-1,5601),-- [rp_two-handed_sword]
(20191,1900,1,1,-1,59256),-- [enchanted_necklace_chain]
(20191,2153,1,1,-1,84230),-- [rp_tiger'seye_earing]
(20191,57,228,457,0,700000),-- [adena]
(20191,1123,1,1,1,1156),-- [blue_buckskin_boots]
(20191,605,1,1,1,1156),-- [leather_gauntlet]
(20191,1867,1,1,2,56373.602805),-- [animal_skin]
(20191,1872,1,1,2,56373.602805),-- [animal_bone]
(20191,1882,1,1,2,9395.679215),-- [leather]
(20191,2185,1,1,2,8322.823275),-- [rp_iron_boots]
(20191,2274,1,1,2,302.07541),-- [rp_skull_breaker]
(20191,2279,1,1,2,302.07541),-- [rp_hammer_in_flames]
(20191,6667,1,1,2,26425.14108),-- [key_of_treasure_box3]
(20192,2146,1,1,-1,50419),-- [rp_artisan's_frame]
(20192,2447,1,1,-1,3611),-- [gloves_of_knowledge]
(20192,1901,1,1,-1,97496),-- [tiger'seye_earing_stone]
(20192,57,298,595,0,700000),-- [adena]
(20192,223,1,1,1,20.19948),-- [kukuri]
(20192,238,1,1,1,20.19948),-- [dagger_of_mana]
(20192,239,1,1,1,20.19948),-- [mystic_knife]
(20192,241,1,1,1,20.19948),-- [knife_o'_silenus]
(20192,2028,1,1,1,892.20208),-- [knife_o'_silenus_edge]
(20192,1864,1,1,2,107229.801952),-- [stem]
(20192,1869,1,1,2,53614.900976),-- [iron_ore]
(20192,1878,1,1,2,21446.062932),-- [braided_hemp]
(20192,1884,1,1,2,32993.785216),-- [cord]
(20192,2978,1,1,2,7177.399292),-- [rp_elven_mithril_boots]
(20192,6667,1,1,2,33509.31311),-- [key_of_treasure_box3]
(20192,8307,1,1,2,382.736522),-- [rp_mace_of_priest]
(20193,1874,1,1,-1,50678),-- [oriharukon_ore]
(20193,2027,1,1,-1,9958),-- [spike_club_head]
(20193,1882,1,1,-1,168925),-- [leather]
(20193,57,320,642,0,700000),-- [adena]
(20193,628,1,1,1,986.079628),-- [hoplon]
(20193,47,1,1,1,689.920372),-- [helmet]
(20193,1867,1,1,2,76985.489672),-- [animal_skin]
(20193,1872,1,1,2,76985.489672),-- [animal_bone]
(20193,1882,1,1,2,12830.854608),-- [leather]
(20193,1894,1,1,2,2025.886304),-- [crafted_leather]
(20193,2271,1,1,2,412.345336),-- [rp_winged_spear]
(20193,2286,1,1,2,320.753264),-- [rp_bonebreaker]
(20193,1341,10,30,2,192463.181144),-- [bone_arrow]
(20197,2259,1,1,-1,7096),-- [rp_spinebone_sword]
(20197,2020,1,1,-1,8000),-- [temptation_of_abyss_piece]
(20197,1876,1,1,-1,91400),-- [mithril_ore]
(20197,57,197,380,0,700000),-- [adena]
(20197,847,1,1,1,619.503616),-- [red_cresent_earing]
(20197,910,1,1,1,464.627712),-- [necklace_of_devotion]
(20197,1899,1,1,1,10018.601216),-- [necklace_of_devotion_chain]
(20197,890,1,1,1,929.267456),-- [ring_of_devotion]
(20197,1876,1,1,2,6412.072376),-- [mithril_ore]
(20197,1880,1,1,2,3206.036188),-- [steel]
(20197,1877,1,1,2,1282.468508),-- [admantite_nugget]
(20197,1881,1,1,2,4274.804972),-- [coarse_bone_powder]
(20197,1882,1,1,2,7124.629926),-- [leather]
(20197,2178,1,1,2,5129.73895),-- [rp_dark_hose]
(20197,8294,1,1,2,783.880846),-- [rp_iron_sword]
(20197,1341,10,30,2,106868.368234),-- [bone_arrow]
(20198,1832,1,1,-1,575495),-- [advanced_antidote]
(20198,57,220,435,0,700000),-- [adena]
(20198,259,1,1,1,114),-- [single-edged_jamadhr]
(20198,1874,1,1,2,2358.65935),-- [oriharukon_ore]
(20198,1878,1,1,2,14152.00525),-- [braided_hemp]
(20198,1884,1,1,2,21772.31955),-- [cord]
(20198,1889,1,1,2,2358.65935),-- [compound_braid]
(20198,5220,1,1,2,1415.2251),-- [reinforcing_agent]
(20198,2183,1,1,2,2327.6457),-- [rp_mithril_banded_mail]
(20198,2274,1,1,2,252.7293),-- [rp_skull_breaker]
(20198,2982,1,1,2,4512.7564),-- [rp_brigandine_shield]
(20199,1882,1,1,-1,140414),-- [leather]
(20199,1834,1,1,-1,702070),-- [emergency_dressing]
(20199,1900,1,1,-1,69132),-- [enchanted_necklace_chain]
(20199,57,267,533,0,700000),-- [adena]
(20199,1123,1,1,1,1349),-- [blue_buckskin_boots]
(20199,605,1,1,1,1349),-- [leather_gauntlet]
(20199,1867,1,1,2,92076.804567),-- [animal_skin]
(20199,1872,1,1,2,92076.804567),-- [animal_bone]
(20199,1882,1,1,2,15346.245354),-- [leather]
(20199,2250,1,1,2,17264.359134),-- [rp_bone_arrow]
(20199,6035,1,1,2,5754.786378),-- [potion_of_acumen2]
(20200,1877,1,1,-1,22339),-- [admantite_nugget]
(20200,1061,1,1,-1,338473),-- [healing_potion]
(20200,2183,1,1,-1,36742),-- [rp_mithril_banded_mail]
(20200,57,236,471,0,700000),-- [adena]
(20200,433,1,1,1,99.219705),-- [elven_tunic]
(20200,434,1,1,1,99.219705),-- [white_tunic]
(20200,1936,1,1,1,3122.045745),-- [white_tunic_pattern]
(20200,435,1,1,1,99.219705),-- [mage's_tunic]
(20200,466,1,1,1,158.96283),-- [elven_hose]
(20200,467,1,1,1,158.96283),-- [dark_hose]
(20200,1933,1,1,1,4488.398265),-- [dark_hose_fabric]
(20200,468,1,1,1,158.971215),-- [mage's_hose]
(20200,1875,1,1,2,2260.643151),-- [stone_of_purity]
(20200,1879,1,1,2,5651.721894),-- [cokes]
(20200,1885,1,1,2,2825.860947),-- [high_grade_suede]
(20200,5550,1,1,2,452.113428),-- [reinforcing_plate]
(20200,5549,1,1,2,3391.002732),-- [iron_thread]
(20200,955,1,1,2,135.603624),-- [scrl_of_ench_wp_d]
(20200,2188,1,1,2,2422.166526),-- [rp_manticor_skin_gaiters]
(20200,6667,1,1,2,21193.843086),-- [key_of_treasure_box3]
(20200,1834,1,1,2,37678.044612),-- [emergency_dressing]
(20201,1870,1,1,-1,664672),-- [coal]
(20201,466,1,1,-1,2769),-- [elven_hose]
(20201,1933,1,1,-1,78197),-- [dark_hose_fabric]
(20201,57,280,562,0,700000),-- [adena]
(20201,392,1,1,1,472.313303),-- [lion_skin_shirt]
(20201,414,1,1,1,756.686697),-- [lion_skin_gaiters]
(20201,1876,1,1,2,10377.53951),-- [mithril_ore]
(20201,1880,1,1,2,5188.769755),-- [steel]
(20201,1877,1,1,2,2075.49056),-- [admantite_nugget]
(20201,1881,1,1,2,6918.33077),-- [coarse_bone_powder]
(20201,1882,1,1,2,11530.565735),-- [leather]
(20201,737,1,1,2,5188.769755),-- [scroll_of_resurrection]
(20201,6387,1,1,2,2075.533915),-- [blessed_scroll_of_resurrection_pet]
(20202,2198,1,1,-1,13867),-- [rp_sage's_rag]
(20202,1872,1,1,-1,881920),-- [animal_bone]
(20202,2154,1,1,-1,70818),-- [rp_elven_earing]
(20202,57,279,557,0,700000),-- [adena]
(20202,849,1,1,1,355.947735),-- [tiger'seye_earing]
(20202,1901,1,1,1,12143.396694),-- [tiger'seye_earing_stone]
(20202,912,1,1,1,266.817837),-- [near_forest_necklace]
(20202,880,1,1,1,532.837734),-- [black_pearl_ring]
(20202,1874,1,1,2,3349.348063),-- [oriharukon_ore]
(20202,1878,1,1,2,20096.027939),-- [braided_hemp]
(20202,1884,1,1,2,30916.96606),-- [cord]
(20202,1889,1,1,2,3349.348063),-- [compound_braid]
(20202,5220,1,1,2,2009.59675),-- [reinforcing_agent]
(20202,2272,1,1,2,358.886782),-- [rp_sword_of_revolution]
(20202,2274,1,1,2,358.826343),-- [rp_skull_breaker]
(20203,1882,1,1,-1,59453),-- [leather]
(20203,1897,1,1,-1,63700),-- [necklace_of_wisdom_chain]
(20203,57,124,215,0,700000),-- [adena]
(20203,176,1,1,1,150.5),-- [apprentice's_staff]
(20203,2501,1,1,1,150.5),-- [bone_club]
(20203,1867,1,1,2,42147.964968),-- [animal_skin]
(20203,1872,1,1,2,42147.964968),-- [animal_bone]
(20203,1882,1,1,2,7024.625385),-- [leather]
(20203,2174,1,1,2,13743.873882),-- [rp_hard_leather_gaiters]
(20203,5273,1,1,2,1264.570797),-- [rp_adv_comp_spiritshot_d]
(20204,1868,1,1,-1,823680),-- [thread]
(20204,2014,1,1,-1,4734),-- [iron_hammer_head]
(20204,1867,1,1,-1,549120),-- [animal_skin]
(20204,57,188,333,0,700000),-- [adena]
(20204,846,1,1,1,989.082223),-- [coral_earing]
(20204,909,1,1,1,741.814033),-- [blue_diamond_necklace]
(20204,1898,1,1,1,6248.466215),-- [blue_diamond_necklace_gem]
(20204,878,1,1,1,1483.637529),-- [blue_coral_ring]
(20204,1867,1,1,2,64880.682372),-- [animal_skin]
(20204,1872,1,1,2,64880.682372),-- [animal_bone]
(20204,1882,1,1,2,10813.447062),-- [leather]
(20204,3953,1,1,2,1946.551167),-- [rp_blessed_spiritshot_d]
(20204,1831,1,1,2,129761.637027),-- [antidote]
(20205,1871,1,1,-1,407376),-- [charcoal]
(20205,1928,1,1,-1,59341),-- [piece_bone_gaiters_fragment]
(20205,1868,1,1,-1,814752),-- [thread]
(20205,57,181,334,0,700000),-- [adena]
(20205,257,1,1,1,256),-- [viper's_canine]
(20205,1868,1,1,2,120332.806902),-- [thread]
(20205,1873,1,1,2,24066.614621),-- [silver_nugget]
(20205,2255,1,1,2,1471.037778),-- [rp_saber]
(20205,6037,1,1,2,120332.540699),-- [scroll_of_awake]
(20206,2182,1,1,-1,49884),-- [rp_scale_gaiters]
(20206,376,1,1,-1,2072),-- [iron_plate_gaiters]
(20206,1899,1,1,-1,64927),-- [necklace_of_devotion_chain]
(20206,57,183,343,0,700000),-- [adena]
(20206,391,1,1,1,483.983521),-- [puma_skin_shirt]
(20206,413,1,1,1,775.016479),-- [puma_skin_gaiters]
(20206,1869,1,1,2,46641.861084),-- [iron_ore]
(20206,1864,1,1,2,93283.722168),-- [stem]
(20206,1880,1,1,2,4664.107376),-- [steel]
(20206,2182,1,1,2,5599.251457),-- [rp_scale_gaiters]
(20206,6666,1,1,2,46642.057915),-- [key_of_treasure_box2]
(20207,2263,1,1,-1,12768),-- [rp_dwarven_trident]
(20207,2181,1,1,-1,82308),-- [rp_white_tunic]
(20207,2152,1,1,-1,144764),-- [rp_enchanted_necklace]
(20207,57,357,682,0,700000),-- [adena]
(20207,220,1,1,1,293),-- [handiwork_dagger]
(20207,1865,1,1,2,92295.187125),-- [varnish]
(20207,1870,1,1,2,92295.187125),-- [coal]
(20207,1879,1,1,2,15382.56825),-- [cokes]
(20207,1875,1,1,2,6153.11625),-- [stone_of_purity]
(20207,2152,1,1,2,16248.94125),-- [rp_enchanted_necklace]
(20208,1869,1,1,-1,858524),-- [iron_ore]
(20208,1872,1,3,-1,572349),-- [animal_bone]
(20208,1931,1,1,-1,112225),-- [leather_boots_lining]
(20208,57,371,714,0,700000),-- [adena]
(20208,626,1,1,1,1900.693228),-- [bronze_shield]
(20208,45,1,1,1,1332.846619),-- [bone_helmet]
(20208,1932,1,1,1,25493.460153),-- [bone_helmet_design]
(20208,1866,1,1,2,53536.648342),-- [suede]
(20208,1871,1,1,2,80304.972513),-- [charcoal]
(20208,5220,1,1,2,3212.272529),-- [reinforcing_agent]
(20208,1885,1,1,2,6692.138565),-- [high_grade_suede]
(20208,2180,1,1,2,6037.995538),-- [rp_scale_mail]
(20208,6666,1,1,2,80304.972513),-- [key_of_treasure_box2]
(20209,1889,1,1,-1,61967),-- [compound_braid]
(20209,45,1,1,-1,7714),-- [bone_helmet]
(20209,2178,1,1,-1,148721),-- [rp_dark_hose]
(20209,57,398,780,0,700000),-- [adena]
(20209,274,1,1,1,331),-- [strengthening_bow]
(20209,1867,1,1,2,139111.405868),-- [animal_skin]
(20209,1872,1,1,2,139111.405868),-- [animal_bone]
(20209,1882,1,1,2,23185.1072),-- [leather]
(20209,2178,1,1,2,16693.277184),-- [rp_dark_hose]
(20209,1061,1,1,2,63232.80388),-- [healing_potion]
(20210,2183,1,1,-1,62137),-- [rp_mithril_banded_mail]
(20210,377,1,1,-1,2947),-- [scale_gaiters]
(20210,1900,1,1,-1,103336),-- [enchanted_necklace_chain]
(20210,57,400,793,0,700000),-- [adena]
(20210,348,1,1,1,251.775363),-- [scale_mail]
(20210,1935,1,1,1,7208.843866),-- [scale_mail_fragment]
(20210,377,1,1,1,402.609403),-- [scale_gaiters]
(20210,1937,1,1,1,11085.771368),-- [scale_gaiters_fragment]
(20210,1868,1,1,2,172042.475982),-- [thread]
(20210,1873,1,1,2,34408.541284),-- [silver_nugget]
(20210,5549,1,1,2,8602.020102),-- [iron_thread]
(20210,1889,1,1,2,5734.680068),-- [compound_braid]
(20210,2184,1,1,2,9035.934856),-- [rp_mithril_banded_gaiters]
(20210,2274,1,1,2,614.347708),-- [rp_skull_breaker]
(20211,1869,1,3,-1,503685),-- [iron_ore]
(20211,1865,1,3,-1,503685),-- [varnish]
(20211,57,425,850,0,700000),-- [adena]
(20211,86,1,1,1,22.214546),-- [tomahawk]
(20211,179,1,1,1,22.214546),-- [mace_of_prayer]
(20211,180,1,1,1,22.214546),-- [mace_of_judgment]
(20211,2022,1,1,1,857.28093),-- [mace_of_judgment_head]
(20211,181,1,1,1,22.214546),-- [mace_of_miracle]
(20211,182,1,1,1,22.214546),-- [doom_hammer]
(20211,183,1,1,1,22.214546),-- [mystic_staff]
(20211,184,1,1,1,22.214546),-- [conjure_staff]
(20211,2023,1,1,1,682.000985),-- [conjure_staff_head]
(20211,185,1,1,1,22.216263),-- [staff_of_mana]
(20211,1869,1,1,2,91748.128035),-- [iron_ore]
(20211,1864,1,1,2,183496.543317),-- [stem]
(20211,1880,1,1,2,9174.956427),-- [steel]
(20211,5550,1,1,2,1223.384973),-- [reinforcing_plate]
(20211,2264,1,1,2,948.776841),-- [rp_two-handed_sword]
(20211,2280,1,1,2,655.210407),-- [rp_crucifix_of_blood]
(20213,2292,1,1,-1,18643),-- [rp_cyclone_bow]
(20213,1894,1,1,-1,117742),-- [crafted_leather]
(20213,1884,1,5,-1,688339),-- [cord]
(20213,57,1401,2796,0,700000),-- [adena]
(20213,352,1,1,1,251.721176),-- [brigandine]
(20213,1941,1,1,1,11497.125738),-- [brigandine_temper]
(20213,2377,1,1,1,402.650794),-- [mithril_scale_gaiters]
(20213,2918,1,1,1,17151.949178),-- [mithril_scale_gaiters_material]
(20213,2378,1,1,1,402.650794),-- [brigandine_gaiters]
(20213,2919,1,1,1,17151.90232),-- [brigandine_gaiters_material]
(20213,1864,9,27,2,24091.834679),-- [stem]
(20213,1869,2,6,2,43365.144373),-- [iron_ore]
(20213,1878,1,1,2,86730.683869),-- [braided_hemp]
(20213,1884,1,1,2,133431.851731),-- [cord]
(20213,2983,1,1,2,14749.94159),-- [rp_plate_helmet]
(20213,2286,1,1,2,1204.730027),-- [rp_bonebreaker]
(20213,2290,1,1,2,1204.730027),-- [rp_mithril_dagger]
(20213,1341,80,240,2,90344.083704),-- [bone_arrow]
(20214,1877,1,1,-1,87132),-- [admantite_nugget]
(20214,2997,1,1,-1,172880),-- [rp_karmian_gloves]
(20214,1879,1,1,-1,363049),-- [cokes]
(20214,57,883,1766,0,700000),-- [adena]
(20214,851,1,1,1,390.795928),-- [onyxbeast'seye_earing]
(20214,1905,1,1,1,17733.578136),-- [onyxbeast'seye_earing_gemstone]
(20214,914,1,1,1,293.08276),-- [necklace_of_darkness]
(20214,1907,1,1,1,12681.830048),-- [necklace_of_darkness_gem]
(20214,882,1,1,1,586.16552),-- [mithril_ring]
(20214,1906,1,1,1,25058.547608),-- [mithril_ring_wire]
(20214,1865,1,1,2,182306.425014),-- [varnish]
(20214,1870,1,1,2,182306.425014),-- [coal]
(20214,1879,1,1,2,30384.47223),-- [cokes]
(20214,1875,1,1,2,12153.788892),-- [stone_of_purity]
(20214,1805,1,1,2,607.648608),-- [rp_soulshot_c]
(20214,5269,1,1,2,607.240242),-- [rp_adv_comp_soulshot_c]
(20215,1872,1,7,-1,839007),-- [animal_bone]
(20215,2206,1,1,-1,66412),-- [rp_tempered_mithril_shirt]
(20215,4469,1,1,-1,14383),-- [dye_s1c1_d]
(20215,57,1014,2049,0,700000),-- [adena]
(20215,297,1,1,1,91.13338),-- [glaive]
(20215,2055,1,1,1,5225.86662),-- [glaive_edge]
(20215,1866,1,1,2,105327.600752),-- [suede]
(20215,1871,1,1,2,157991.098612),-- [charcoal]
(20215,5220,1,1,2,6319.55924),-- [reinforcing_agent]
(20215,1885,1,1,2,13165.798836),-- [high_grade_suede]
(20215,2212,1,1,2,5662.797004),-- [rp_plate_leather_gaiters]
(20215,2205,1,1,2,4999.681932),-- [rp_chain_gaiters]
(20215,2989,1,1,2,8359.424628),-- [rp_chain_hood]
(20215,2299,1,1,2,690.038996),-- [rp_big_hammer]
(20216,2297,1,1,-1,9822),-- [rp_flamberge]
(20216,2933,1,1,-1,251030),-- [sage's_worn_gloves_lining]
(20216,1905,1,1,-1,218797),-- [onyxbeast'seye_earing_gemstone]
(20216,57,889,1806,0,700000),-- [adena]
(20216,1125,1,1,1,250.323507),-- [assault_boots]
(20216,1957,1,1,1,10505.133471),-- [assault_boots_part]
(20216,2427,1,1,1,250.323507),-- [slamander_skin_boots]
(20216,2931,1,1,1,10505.133471),-- [slamander_skin_boots_lining]
(20216,2428,1,1,1,250.323507),-- [plate_boots]
(20216,2932,1,1,1,10505.133471),-- [plate_boots_design]
(20216,61,1,1,1,250.323507),-- [mithril_glove]
(20216,1949,1,1,1,10505.133471),-- [mithril_glove_design]
(20216,607,1,1,1,250.323507),-- [ogre_power_gauntlet]
(20216,1963,1,1,1,10505.133471),-- [ogre_power_gauntlet_part]
(20216,2451,1,1,1,250.323507),-- [sage's_worn_gloves]
(20216,2933,1,1,1,10505.391603),-- [sage's_worn_gloves_lining]
(20216,1867,1,3,2,125495.644209),-- [animal_skin]
(20216,1872,1,1,2,250991.288418),-- [animal_bone]
(20216,1882,1,1,2,41831.881403),-- [leather]
(20216,1894,1,1,2,6604.944143),-- [crafted_leather]
(20216,2314,1,1,2,822.047144),-- [rp_body_slasher]
(20216,5269,1,1,2,627.194683),-- [rp_adv_comp_soulshot_c]
(20217,1873,1,3,-1,524276),-- [silver_nugget]
(20217,2075,1,1,-1,20560),-- [orcish_glaive_blade]
(20217,2163,1,1,-1,133744),-- [rp_earing_of_protection]
(20217,57,1032,2115,0,700000),-- [adena]
(20217,62,1,1,1,141.768462),-- [mithril_boots]
(20217,1958,1,1,1,6186.891876),-- [mithril_boots_design]
(20217,2429,1,1,1,141.768462),-- [chain_boots]
(20217,2937,1,1,1,6186.891876),-- [chain_boots_part]
(20217,2430,1,1,1,141.768462),-- [karmian_boots]
(20217,2938,1,1,1,6186.891876),-- [karmian_boots_fabric]
(20217,2431,1,1,1,141.768462),-- [plate_leather_boots]
(20217,2939,1,1,1,6186.891876),-- [plate_leather_boots_lining]
(20217,2432,1,1,1,141.768462),-- [dwarven_chain_boots]
(20217,2940,1,1,1,6186.891876),-- [dwarven_chain_boots_part]
(20217,2433,1,1,1,141.768462),-- [boots_of_seal]
(20217,2941,1,1,1,6186.891876),-- [boots_of_seal_pattern]
(20217,2452,1,1,1,141.768462),-- [reinforce_mithril_gloves]
(20217,2942,1,1,1,6186.891876),-- [reinforce_mithril_gloves_design]
(20217,2453,1,1,1,141.768462),-- [chain_gloves]
(20217,2943,1,1,1,6186.891876),-- [chain_gloves_design]
(20217,2454,1,1,1,141.768462),-- [karmian_gloves]
(20217,2944,1,1,1,6186.948834),-- [karmian_gloves_fabric]
(20217,1868,1,1,2,206484.46107),-- [thread]
(20217,1873,1,1,2,41297.00361),-- [silver_nugget]
(20217,5549,1,1,2,10324.18128),-- [iron_thread]
(20217,1889,1,1,2,6882.88035),-- [compound_braid]
(20217,2163,1,1,2,5267.35986),-- [rp_earing_of_protection]
(20217,2225,1,1,2,2244.35091),-- [rp_demon's_hose]
(20217,2321,1,1,2,359.80908),-- [rp_stiletto]
(20217,5279,1,1,2,344.21364),-- [rp_adv_comp_bspiritshot_c]
(20217,8723,1,1,2,4129.72821),-- [general_46_c]
(20217,8733,1,1,2,1032.36243),-- [special_46_c]
(20217,8743,1,1,2,103.31979),-- [rare_46_c]
(20217,8753,1,1,2,20.32977),-- [unique_46_c]
(20218,1876,1,1,-1,545172),-- [mithril_ore]
(20218,2073,1,1,-1,21069),-- [chakram_edge]
(20218,1908,1,1,-1,258131),-- [moonstone_earing_wire]
(20218,57,1078,2190,0,700000),-- [adena]
(20218,631,1,1,1,421.00704),-- [eldarake]
(20218,1964,1,1,1,17349.669162),-- [eldarake_temper]
(20218,2495,1,1,1,421.00704),-- [chain_shield]
(20218,2945,1,1,1,17349.669162),-- [chain_shield_fragment]
(20218,2413,1,1,1,294.704928),-- [chain_hood]
(20218,2936,1,1,1,15757.942668),-- [chain_hood_pattern]
(20218,1864,1,1,2,214713.70785),-- [stem]
(20218,1869,1,1,2,107356.853925),-- [iron_ore]
(20218,1878,1,1,2,42942.74157),-- [braided_hemp]
(20218,1884,1,1,2,66065.82507),-- [cord]
(20218,4039,1,1,2,3578.487255),-- [mold_glue]
(20218,2320,1,1,2,373.90518),-- [rp_cursed_staff]
(20218,2319,1,1,2,373.90518),-- [rp_raid_sword]
(20218,2217,1,1,2,6352.362765),-- [rp_knight_shield]
(20218,8723,1,1,2,4294.095255),-- [general_46_c]
(20218,8733,1,1,2,1073.412),-- [special_46_c]
(20218,8743,1,1,2,107.3412),-- [rare_46_c]
(20218,8753,1,1,2,22.36275),-- [unique_46_c]
(20219,1873,1,3,-1,614037),-- [silver_nugget]
(20219,2060,1,1,-1,24378),-- [stormbringer_blade]
(20219,2164,1,1,-1,236168),-- [rp_ring_of_protection]
(20219,57,1209,2473,0,700000),-- [adena]
(20219,281,1,1,1,82.309065),-- [crystallized_ice_bow]
(20219,2074,1,1,1,5138.690935),-- [crystallized_ice_bow_shaft]
(20219,1870,1,1,2,131910.492938),-- [coal]
(20219,1865,1,1,2,131910.492938),-- [varnish]
(20219,1874,1,1,2,8793.896979),-- [oriharukon_ore]
(20219,4043,1,1,2,4397.094079),-- [asofe]
(20219,4039,1,1,2,4397.094079),-- [mold_glue]
(20219,2230,1,1,2,2556.260441),-- [rp_theca_leather_gaiters]
(20219,2326,1,1,2,459.480462),-- [rp_horn_of_glory]
(20219,8723,1,1,2,5276.454659),-- [general_46_c]
(20219,8733,1,1,2,1319.04087),-- [special_46_c]
(20219,8743,1,1,2,131.904087),-- [rare_46_c]
(20219,8753,1,1,2,26.788468),-- [unique_46_c]
(20220,1895,1,1,-1,883618),-- [metallic_fiber]
(20220,2944,1,1,-1,277992),-- [karmian_gloves_fabric]
(20220,1911,1,1,-1,230023),-- [earing_of_protection_gemstone]
(20220,57,1221,2490,0,700000),-- [adena]
(20220,1126,1,1,1,184.3264),-- [crimson_boots]
(20220,1974,1,1,1,9603.23888),-- [crimson_boots_fabric]
(20220,2434,1,1,1,184.3264),-- [rind_leather_boots]
(20220,2948,1,1,1,9603.23888),-- [rind_leather_boots_lining]
(20220,2455,1,1,1,199.5944),-- [plate_leather_gloves]
(20220,2946,1,1,1,6382.46816),-- [plate_leather_gloves_design]
(20220,2456,1,1,1,184.3264),-- [dwarven_chain_gloves]
(20220,2949,1,1,1,9603.23888),-- [dwarven_chain_gloves_design]
(20220,2457,1,1,1,184.3264),-- [gloves_of_seal]
(20220,2950,1,1,1,9603.23888),-- [gloves_of_seal_pattern]
(20220,2458,1,1,1,184.3264),-- [rind_leather_gloves]
(20220,2951,1,1,1,9603.34992),-- [rind_leather_gloves_design]
(20220,1871,1,1,2,114190.721286),-- [charcoal]
(20220,1866,1,1,2,76127.147524),-- [suede]
(20220,1877,1,1,2,4567.571795),-- [admantite_nugget]
(20220,4041,1,1,2,992.985829),-- [mold_hardener]
(20220,4040,1,1,2,2283.887784),-- [mold_lubricant]
(20220,951,1,1,2,207.644687),-- [scrl_of_ench_wp_c]
(20220,2343,1,1,2,265.516219),-- [rp_mace_of_underworld]
(20220,2345,1,1,2,265.516219),-- [rp_dark_screamer]
(20220,8724,1,1,2,3806.275867),-- [general_49_c]
(20220,8734,1,1,2,951.61991),-- [special_49_c]
(20220,8744,1,1,2,95.161991),-- [rare_49_c]
(20220,8754,1,1,2,18.950889),-- [unique_49_c]
(20221,2352,1,1,-1,9326),-- [rp_widow_maker]
(20221,2073,1,1,-1,34456),-- [chakram_edge]
(20221,951,1,1,-1,8105),-- [scrl_of_ench_wp_c]
(20221,57,1763,3583,0,700000),-- [adena]
(20221,1126,1,1,1,265.68964),-- [crimson_boots]
(20221,1974,1,1,1,13842.190163),-- [crimson_boots_fabric]
(20221,2434,1,1,1,265.68964),-- [rind_leather_boots]
(20221,2948,1,1,1,13842.190163),-- [rind_leather_boots_lining]
(20221,2455,1,1,1,287.697065),-- [plate_leather_gloves]
(20221,2946,1,1,1,9199.743866),-- [plate_leather_gloves_design]
(20221,2456,1,1,1,265.68964),-- [dwarven_chain_gloves]
(20221,2949,1,1,1,13842.190163),-- [dwarven_chain_gloves_design]
(20221,2457,1,1,1,265.68964),-- [gloves_of_seal]
(20221,2950,1,1,1,13842.190163),-- [gloves_of_seal_pattern]
(20221,2458,1,1,1,265.68964),-- [rind_leather_gloves]
(20221,2951,1,1,1,13842.350217),-- [rind_leather_gloves_design]
(20221,1872,1,1,2,188107.597296),-- [animal_bone]
(20221,1867,1,1,2,188107.597296),-- [animal_skin]
(20221,1881,1,1,2,18810.859689),-- [coarse_bone_powder]
(20221,1875,1,1,2,9405.179946),-- [stone_of_purity]
(20221,4041,1,1,2,1227.001635),-- [mold_hardener]
(20221,2334,1,1,2,327.866832),-- [rp_deathbreath_sword]
(20221,2351,1,1,2,295.380027),-- [rp_scorpion]
(20221,3005,1,1,2,5758.161237),-- [rp_demon's_boots]
(20221,6668,1,1,2,50386.034961),-- [key_of_treasure_box4]
(20221,8724,1,1,2,4702.589973),-- [general_49_c]
(20221,8734,1,1,2,1175.522544),-- [special_49_c]
(20221,8744,1,1,2,117.452295),-- [rare_49_c]
(20221,8754,1,1,2,23.490459),-- [unique_49_c]
(20221,1539,1,1,2,31352.26581),-- [greater_healing_potion]
(20222,1876,1,1,-1,679016),-- [mithril_ore]
(20222,2168,1,1,-1,86389),-- [rp_necklace_of_mermaid]
(20222,1895,1,3,-1,485011),-- [metallic_fiber]
(20222,57,1340,2733,0,700000),-- [adena]
(20222,2496,1,1,1,417.505968),-- [dwarven_chain_shield]
(20222,2947,1,1,1,17907.400368),-- [dwarven_chain_shield_fragment]
(20222,632,1,1,1,385.419408),-- [knight_shield]
(20222,1972,1,1,1,20056.27536),-- [knight_shield_fragment]
(20222,500,1,1,1,269.853408),-- [great_helmet]
(20222,1971,1,1,1,15347.545488),-- [great_helmet_material]
(20222,1873,1,1,2,50142.783922),-- [silver_nugget]
(20222,1868,1,1,2,250714.725492),-- [thread]
(20222,1876,1,1,2,25071.391961),-- [mithril_ore]
(20222,1895,1,1,2,35816.216667),-- [metallic_fiber]
(20222,4042,1,1,2,2089.249085),-- [enria]
(20222,3006,1,1,2,5116.544818),-- [rp_demon's_gloves]
(20222,2222,1,1,2,783.317304),-- [rp_composite_armor]
(20222,8724,1,1,2,4178.49817),-- [general_49_c]
(20222,8734,1,1,2,1044.826013),-- [special_49_c]
(20222,8744,1,1,2,104.361719),-- [rare_49_c]
(20222,8754,1,1,2,20.952932),-- [unique_49_c]
(20222,1539,1,1,2,27858.131917),-- [greater_healing_potion]
(20223,734,1,1,-1,49539),-- [quick_step_potion]
(20223,2011,1,1,-1,6781),-- [short_spear_edge]
(20223,1864,1,1,-1,594474),-- [stem]
(20223,57,137,239,0,700000),-- [adena]
(20223,845,1,1,1,1283.606976),-- [cat'seye_earing]
(20223,908,1,1,1,962.712544),-- [necklace_of_wisdom]
(20223,1897,1,1,1,10452.270016),-- [necklace_of_wisdom_chain]
(20223,877,1,1,1,1925.410464),-- [ring_of_wisdom]
(20223,1864,1,1,2,87798.98928),-- [stem]
(20223,1869,1,1,2,43899.49464),-- [iron_ore]
(20223,1878,1,1,2,17559.797856),-- [braided_hemp]
(20223,2175,1,1,2,35690.718224),-- [rp_boots]
(20224,2178,1,1,-1,74717),-- [rp_dark_hose]
(20224,1865,1,1,-1,466983),-- [varnish]
(20224,1898,1,1,-1,47969),-- [blue_diamond_necklace_gem]
(20224,57,212,381,0,700000),-- [adena]
(20224,27,1,1,1,485.692998),-- [hard_leather_shirt]
(20224,1927,1,1,1,5501.993196),-- [hard_leather_shirt_pattern]
(20224,33,1,1,1,779.289504),-- [hard_leather_gaiters]
(20224,1929,1,1,1,8899.024302),-- [hard_leather_gaiters_material]
(20224,1872,1,1,2,73567.598478),-- [animal_bone]
(20224,1867,1,1,2,73567.598478),-- [animal_skin]
(20224,1881,1,1,2,7356.712176),-- [coarse_bone_powder]
(20224,5153,1,1,2,2207.045434),-- [rp_comp_soulshot_d]
(20224,5268,1,1,2,2207.045434),-- [rp_adv_comp_soulshot_d]
(20225,2259,1,1,-1,6517),-- [rp_spinebone_sword]
(20225,1931,1,1,-1,54861),-- [leather_boots_lining]
(20225,2152,1,1,-1,73889),-- [rp_enchanted_necklace]
(20225,57,185,346,0,700000),-- [adena]
(20225,40,1,1,1,731.502336),-- [leather_boots]
(20225,1931,1,1,1,7697.497664),-- [leather_boots_lining]
(20225,604,1,1,1,731.502336),-- [excellence_leather_gloves]
(20225,1934,1,1,1,7697.497664),-- [excellence_leather_gloves_lining]
(20225,1865,1,1,2,39256.835541),-- [varnish]
(20225,1870,1,1,2,39256.835541),-- [coal]
(20225,1879,1,1,2,6542.761302),-- [cokes]
(20225,1875,1,1,2,2617.140218),-- [stone_of_purity]
(20225,2259,1,1,2,609.618933),-- [rp_spinebone_sword]
(20225,5437,1,1,2,959.808465),-- [rp_heavy_sword]
(20226,1868,1,1,-1,884148),-- [thread]
(20226,413,1,1,-1,2937),-- [puma_skin_gaiters]
(20226,1899,1,1,-1,69074),-- [necklace_of_devotion_chain]
(20226,57,192,367,0,700000),-- [adena]
(20226,123,1,1,1,39.373776),-- [saber]
(20226,2017,1,1,1,824.082984),-- [saber_blade]
(20226,5285,1,1,1,39.373776),-- [heavy_sword]
(20226,5531,1,1,1,1041.169464),-- [heavy_sword_edge]
(20226,1866,1,1,2,41351.087969),-- [suede]
(20226,1871,1,1,2,62026.574062),-- [charcoal]
(20226,5220,1,1,2,2481.113907),-- [reinforcing_agent]
(20226,2178,1,1,2,9924.224062),-- [rp_dark_hose]
(20227,2260,1,1,-1,7238),-- [rp_mace_of_judgment]
(20227,1899,1,1,-1,72835),-- [necklace_of_devotion_chain]
(20227,2178,1,1,-1,74583),-- [rp_dark_hose]
(20227,57,201,388,0,700000),-- [adena]
(20227,391,1,1,1,542.799628),-- [puma_skin_shirt]
(20227,413,1,1,1,869.200372),-- [puma_skin_gaiters]
(20227,1867,1,1,2,69763.474464),-- [animal_skin]
(20227,1872,1,1,2,69763.474464),-- [animal_bone]
(20227,1882,1,1,2,11627.19216),-- [leather]
(20227,2181,1,1,2,5237.460912),-- [rp_white_tunic]
(20227,6035,1,1,2,4360.398),-- [potion_of_acumen2]
(20228,2180,1,1,-1,40128),-- [rp_scale_mail]
(20228,1884,1,1,-1,328429),-- [cord]
(20228,1931,1,1,-1,69764),-- [leather_boots_lining]
(20228,57,229,448,0,700000),-- [adena]
(20228,847,1,1,1,723.509376),-- [red_cresent_earing]
(20228,910,1,1,1,542.632032),-- [necklace_of_devotion]
(20228,1899,1,1,1,11700.580476),-- [necklace_of_devotion_chain]
(20228,890,1,1,1,1085.278116),-- [ring_of_devotion]
(20228,1868,1,1,2,99842.559024),-- [thread]
(20228,1873,1,1,2,19968.617808),-- [silver_nugget]
(20228,5549,1,1,2,4992.220704),-- [iron_thread]
(20228,1889,1,1,2,3327.970464),-- [compound_braid]
(20228,2180,1,1,2,3753.573312),-- [rp_scale_mail]
(20228,1831,1,1,2,133123.058688),-- [antidote]
(20229,1061,1,1,-1,357490),-- [healing_potion]
(20229,414,1,1,-1,2458),-- [lion_skin_gaiters]
(20229,1864,1,3,-1,589858),-- [stem]
(20229,57,249,498,0,700000),-- [adena]
(20229,848,1,1,1,491.364384),-- [enchanted_earing]
(20229,911,1,1,1,368.799312),-- [enchanted_necklace]
(20229,1900,1,1,1,8816.539872),-- [enchanted_necklace_chain]
(20229,879,1,1,1,739.296432),-- [enchanted_ring]
(20229,1869,1,1,2,46047.720602),-- [iron_ore]
(20229,1864,1,1,2,92095.441204),-- [stem]
(20229,1880,1,1,2,4604.732994),-- [steel]
(20229,5550,1,1,2,613.925333),-- [reinforcing_plate]
(20229,2265,1,1,2,476.216978),-- [rp_spike_club]
(20229,2274,1,1,2,328.937404),-- [rp_skull_breaker]
(20229,1832,1,1,2,51164.025485),-- [advanced_antidote]
(20230,1834,1,1,-1,745819),-- [emergency_dressing]
(20230,434,1,1,-1,1746),-- [white_tunic]
(20230,1870,1,1,-1,671237),-- [coal]
(20230,57,284,566,0,700000),-- [adena]
(20230,292,1,1,1,148),-- [pike]
(20230,1870,1,1,2,91701.33687),-- [coal]
(20230,1865,1,1,2,91701.33687),-- [varnish]
(20230,1874,1,1,2,6113.422458),-- [oriharukon_ore]
(20230,956,1,1,2,3056.903802),-- [scrl_of_ench_am_d]
(20231,1832,1,1,-1,722627),-- [advanced_antidote]
(20231,2282,1,1,-1,4645),-- [rp_cursed_maingauche]
(20231,1877,1,1,-1,26015),-- [admantite_nugget]
(20231,57,274,550,0,700000),-- [adena]
(20231,1123,1,1,1,1388.5),-- [blue_buckskin_boots]
(20231,605,1,1,1,1388.5),-- [leather_gauntlet]
(20231,1871,1,1,2,59233.240472),-- [charcoal]
(20231,1866,1,1,2,39488.771126),-- [suede]
(20231,1877,1,1,2,2369.38324),-- [admantite_nugget]
(20231,955,1,1,2,236.938324),-- [scrl_of_ench_wp_d]
(20231,2277,1,1,2,423.10415),-- [rp_bich'hwa]
(20231,1832,1,1,2,65814.562688),-- [advanced_antidote]
(20232,2147,1,1,-1,45242),-- [rp_blacksmith's_frame]
(20232,2027,1,1,-1,8298),-- [spike_club_head]
(20232,1901,1,1,-1,87485),-- [tiger'seye_earing_stone]
(20232,57,268,535,0,700000),-- [adena]
(20232,628,1,1,1,821.340788),-- [hoplon]
(20232,47,1,1,1,574.659212),-- [helmet]
(20232,1872,1,1,2,74837.606625),-- [animal_bone]
(20232,1867,1,1,2,74837.606625),-- [animal_skin]
(20232,1881,1,1,2,7483.847115),-- [coarse_bone_powder]
(20232,1875,1,1,2,3741.837105),-- [stone_of_purity]
(20232,2156,1,1,2,4490.34285),-- [rp_elven_necklace]
(20232,2191,1,1,2,7513.75968),-- [rp_gauntlet_of_repose_of_the_soul]
(20233,2280,1,1,-1,5301),-- [rp_crucifix_of_blood]
(20233,955,1,1,-1,2969),-- [scrl_of_ench_wp_d]
(20233,2154,1,1,-1,79458),-- [rp_elven_earing]
(20233,57,313,625,0,700000),-- [adena]
(20233,849,1,1,1,399.38733),-- [tiger'seye_earing]
(20233,1901,1,1,1,13625.367732),-- [tiger'seye_earing_stone]
(20233,912,1,1,1,299.380086),-- [near_forest_necklace]
(20233,880,1,1,1,597.864852),-- [black_pearl_ring]
(20233,1873,1,1,2,22547.825456),-- [silver_nugget]
(20233,1868,1,1,2,112739.12728),-- [thread]
(20233,1876,1,1,2,11273.912728),-- [mithril_ore]
(20233,2273,1,1,2,402.539904),-- [rp_tarbar]
(20233,2274,1,1,2,402.539904),-- [rp_skull_breaker]
(20233,2975,1,1,2,5033.038992),-- [rp_brigandine_helmet]
(20233,1832,1,1,2,62633.015736),-- [advanced_antidote]
(20234,1879,1,1,-1,124798),-- [cokes]
(20234,2971,1,1,-1,40042),-- [rp_mithril_scale_gaiters]
(20234,1938,1,1,-1,50339),-- [mithril_banded_mail_material]
(20234,57,316,631,0,700000),-- [adena]
(20234,293,1,1,1,53.5),-- [war_hammer]
(20234,296,1,1,1,53.5),-- [dwarven_pike]
(20234,1873,1,1,2,31849.943364),-- [silver_nugget]
(20234,1868,1,1,2,159250.163564),-- [thread]
(20234,1876,1,1,2,15925.083368),-- [mithril_ore]
(20234,2979,1,1,2,10659.31184),-- [rp_manticor_skin_gloves]
(20234,2188,1,1,2,5687.497864),-- [rp_manticor_skin_gaiters]
(20235,2074,1,1,-1,8417),-- [crystallized_ice_bow_shaft]
(20235,2340,1,1,-1,2764),-- [rp_paagrio_hammer]
(20235,2163,1,1,-1,60630),-- [rp_earing_of_protection]
(20235,57,470,955,0,700000),-- [adena]
(20235,96,1,1,1,10.618202),-- [scythe]
(20235,2062,1,1,1,734.04772),-- [scythe_edge]
(20235,298,1,1,1,10.618202),-- [orcish_glaive]
(20235,2075,1,1,1,734.04772),-- [orcish_glaive_blade]
(20235,302,1,1,1,10.618202),-- [body_slasher]
(20235,2076,1,1,1,734.049954),-- [body_slasher_blade]
(20235,1870,1,1,2,56163.066915),-- [coal]
(20235,1865,1,1,2,56163.066915),-- [varnish]
(20235,1874,1,1,2,3744.204461),-- [oriharukon_ore]
(20235,4043,1,1,2,1872.164736),-- [asofe]
(20235,4039,1,1,2,1872.164736),-- [mold_glue]
(20235,2216,1,1,2,2320.829215),-- [rp_great_helmet]
(20235,8723,1,1,2,2246.572681),-- [general_46_c]
(20235,8733,1,1,2,561.674423),-- [special_46_c]
(20235,8743,1,1,2,56.129939),-- [rare_46_c]
(20235,8753,1,1,2,11.125979),-- [unique_46_c]
(20236,2219,1,1,-1,76370),-- [rp_crimson_boots]
(20236,3021,1,1,-1,4284),-- [rp_dwarven_warhammer]
(20236,1908,1,1,-1,116435),-- [moonstone_earing_wire]
(20236,57,484,990,0,700000),-- [adena]
(20236,62,1,1,1,66.496124),-- [mithril_boots]
(20236,1958,1,1,1,2901.945352),-- [mithril_boots_design]
(20236,2429,1,1,1,66.496124),-- [chain_boots]
(20236,2937,1,1,1,2901.945352),-- [chain_boots_part]
(20236,2430,1,1,1,66.496124),-- [karmian_boots]
(20236,2938,1,1,1,2901.945352),-- [karmian_boots_fabric]
(20236,2431,1,1,1,66.496124),-- [plate_leather_boots]
(20236,2939,1,1,1,2901.945352),-- [plate_leather_boots_lining]
(20236,2432,1,1,1,66.496124),-- [dwarven_chain_boots]
(20236,2940,1,1,1,2901.945352),-- [dwarven_chain_boots_part]
(20236,2433,1,1,1,66.496124),-- [boots_of_seal]
(20236,2941,1,1,1,2901.945352),-- [boots_of_seal_pattern]
(20236,2452,1,1,1,66.496124),-- [reinforce_mithril_gloves]
(20236,2942,1,1,1,2901.945352),-- [reinforce_mithril_gloves_design]
(20236,2453,1,1,1,66.496124),-- [chain_gloves]
(20236,2943,1,1,1,2901.945352),-- [chain_gloves_design]
(20236,2454,1,1,1,66.496124),-- [karmian_gloves]
(20236,2944,1,1,1,2901.972068),-- [karmian_gloves_fabric]
(20236,1870,1,1,2,58110.63069),-- [coal]
(20236,1865,1,1,2,58110.63069),-- [varnish]
(20236,1874,1,1,2,3874.042046),-- [oriharukon_ore]
(20236,4043,1,1,2,1937.085696),-- [asofe]
(20236,4039,1,1,2,1937.085696),-- [mold_glue]
(20236,2216,1,1,2,2401.30849),-- [rp_great_helmet]
(20236,8723,1,1,2,2324.476966),-- [general_46_c]
(20236,8733,1,1,2,581.151578),-- [special_46_c]
(20236,8743,1,1,2,58.076354),-- [rare_46_c]
(20236,8753,1,1,2,11.511794),-- [unique_46_c]
(20237,2329,1,1,-1,3846),-- [rp_tsurugi]
(20237,3010,1,1,-1,44939),-- [rp_composite_helmet]
(20237,951,1,1,-1,3007),-- [scrl_of_ench_wp_c]
(20237,57,653,1332,0,700000),-- [adena]
(20237,282,1,1,1,16.581576),-- [elemental_bow]
(20237,2085,1,1,1,1267.418424),-- [elemental_bow_shaft]
(20237,285,1,1,1,16.581576),-- [noble_elven_bow]
(20237,2086,1,1,1,1267.418424),-- [noble_elven_bow_shaft]
(20237,1869,1,1,2,61061.755032),-- [iron_ore]
(20237,1864,1,1,2,122123.510064),-- [stem]
(20237,1880,1,1,2,6106.30305),-- [steel]
(20237,5550,1,1,2,814.067451),-- [reinforcing_plate]
(20237,4043,1,1,2,2035.328061),-- [asofe]
(20237,952,1,1,2,814.067451),-- [scrl_of_ench_am_c]
(20237,2230,1,1,2,1183.315437),-- [rp_theca_leather_gaiters]
(20237,8724,1,1,2,2035.328061),-- [general_49_c]
(20237,8734,1,1,2,508.911732),-- [special_49_c]
(20237,8744,1,1,2,51.01872),-- [rare_49_c]
(20237,8754,1,1,2,10.203744),-- [unique_49_c]
(20237,1342,10,30,2,122123.191197),-- [fine_steel_arrow]
(20238,2357,1,1,-1,2599),-- [rp_crystal_dagger]
(20238,1877,1,1,-1,63734),-- [admantite_nugget]
(20238,4041,1,1,-1,13855),-- [mold_hardener]
(20238,57,630,1281,0,700000),-- [adena]
(20238,355,1,1,1,71.23571),-- [dwarven_chain_mail_shirt]
(20238,1968,1,1,1,4252.67124),-- [dwarven_chain_mail_shirt_material]
(20238,382,1,1,1,113.977136),-- [dwarven_chain_gaiters]
(20238,1969,1,1,1,6745.115914),-- [dwarven_chain_gaiters_material]
(20238,1871,1,1,2,58830.987264),-- [charcoal]
(20238,1866,1,1,2,39220.658176),-- [suede]
(20238,1877,1,1,2,2353.224384),-- [admantite_nugget]
(20238,4041,1,1,2,511.608832),-- [mold_hardener]
(20238,4040,1,1,2,1176.675136),-- [mold_lubricant]
(20238,2335,1,1,2,136.840256),-- [rp_war_axe]
(20238,2348,1,1,2,136.840256),-- [rp_heathen's_book]
(20238,6668,1,1,2,21011.084864),-- [key_of_treasure_box4]
(20238,8724,1,1,2,1961.083264),-- [general_49_c]
(20238,8734,1,1,2,490.207872),-- [special_49_c]
(20238,8744,1,1,2,48.970432),-- [rare_49_c]
(20238,8754,1,1,2,9.819264),-- [unique_49_c]
(20239,3007,1,1,-1,61644),-- [rp_theca_leather_boots]
(20239,2079,1,1,-1,11647),-- [bech_de_corbin_blade]
(20239,1867,1,5,-1,753426),-- [animal_skin]
(20239,57,669,1365,0,700000),-- [adena]
(20239,73,1,1,1,8.49744),-- [shamshir]
(20239,2077,1,1,1,623.75256),-- [shamshir_blade]
(20239,74,1,1,1,8.49744),-- [katana]
(20239,2078,1,1,1,623.75256),-- [katana_blade]
(20239,131,1,1,1,8.49744),-- [spirits_sword]
(20239,2080,1,1,1,623.75256),-- [spirits_sword_blade]
(20239,133,1,1,1,8.49744),-- [raid_sword]
(20239,2081,1,1,1,623.75256),-- [raid_sword_blade]
(20239,1872,1,1,2,83456.462368),-- [animal_bone]
(20239,1867,1,1,2,83456.462368),-- [animal_skin]
(20239,1881,1,1,2,8345.627648),-- [coarse_bone_powder]
(20239,1875,1,1,2,4172.813824),-- [stone_of_purity]
(20239,4041,1,1,2,544.280064),-- [mold_hardener]
(20239,3007,1,1,2,2276.012672),-- [rp_theca_leather_boots]
(20239,2351,1,1,2,130.865152),-- [rp_scorpion]
(20239,952,1,1,2,834.63712),-- [scrl_of_ench_am_c]
(20239,8724,1,1,2,2086.406912),-- [general_49_c]
(20239,8734,1,1,2,521.601728),-- [special_49_c]
(20239,8744,1,1,2,52.234528),-- [rare_49_c]
(20239,8754,1,1,2,10.595616),-- [unique_49_c]
(20240,2092,1,1,-1,9934),-- [homunkulus's_sword_blade]
(20240,2353,1,1,-1,2974),-- [rp_samurai_longsword]
(20240,4601,1,1,-1,4051),-- [dye_s3c3_c]
(20240,57,722,1466,0,700000),-- [adena]
(20240,265,1,1,1,22.817308),-- [fist_blade]
(20240,2108,1,1,1,2019.182692),-- [fist_blade_piece]
(20240,1864,1,1,2,137054.470422),-- [stem]
(20240,1869,1,1,2,68527.235211),-- [iron_ore]
(20240,1878,1,1,2,27410.950449),-- [braided_hemp]
(20240,1884,1,1,2,42170.584605),-- [cord]
(20240,4039,1,1,2,2284.175415),-- [mold_glue]
(20240,3022,1,1,2,111.883731),-- [rp_yaksa_mace]
(20240,3019,1,1,2,1827.340332),-- [rp_full_plate_shield]
(20240,8725,1,1,2,1903.432542),-- [general_52_c]
(20240,8735,1,1,2,475.999047),-- [special_52_c]
(20240,8745,1,1,2,47.628087),-- [rare_52_c]
(20240,8755,1,1,2,9.300159),-- [unique_52_c]
(20241,2100,1,1,-1,10217),-- [paradia_staff_head]
(20241,3015,1,1,-1,50627),-- [rp_drake_leather_gloves]
(20241,1539,1,1,-1,402767),-- [greater_healing_potion]
(20241,57,720,1455,0,700000),-- [adena]
(20241,854,1,1,1,110.257488),-- [earing_of_binding]
(20241,1914,1,1,1,7017.33344),-- [earing_of_binding_gemstone]
(20241,917,1,1,1,82.69904),-- [necklace_of_mermaid]
(20241,1916,1,1,1,5315.24976),-- [necklace_of_mermaid_teardrop]
(20241,885,1,1,1,165.326992),-- [ring_of_ages]
(20241,1915,1,1,1,11005.13328),-- [ring_of_ages_gemstone]
(20241,1872,1,1,2,76873.44124),-- [animal_bone]
(20241,1867,1,1,2,76873.44124),-- [animal_skin]
(20241,1881,1,1,2,7687.41204),-- [coarse_bone_powder]
(20241,1875,1,1,2,3843.70602),-- [stone_of_purity]
(20241,4041,1,1,2,501.38987),-- [mold_hardener]
(20241,4604,1,1,2,128.19145),-- [dye_c3c3_c]
(20241,4609,1,1,2,128.19145),-- [dye_m3i3_c]
(20241,3014,1,1,2,1610.45815),-- [rp_full_plate_boots]
(20241,2359,1,1,2,94.06366),-- [rp_eminence_bow]
(20241,8725,1,1,2,1601.45928),-- [general_52_c]
(20241,8735,1,1,2,400.36482),-- [special_52_c]
(20241,8745,1,1,2,40.07044),-- [rare_52_c]
(20241,8755,1,1,2,7.81034),-- [unique_52_c]
(20242,1985,1,1,-1,66727),-- [theca_leather_gaiters_pattern]
(20242,1868,1,9,-1,774035),-- [thread]
(20242,1918,1,1,-1,83806),-- [nassen's_earing_gemstone]
(20242,57,766,1556,0,700000),-- [adena]
(20242,400,1,1,1,37.508306),-- [theca_leather_mail]
(20242,1984,1,1,1,2552.652421),-- [theca_leather_mail_pattern]
(20242,401,1,1,1,17.757597),-- [drake_leather_mail]
(20242,1987,1,1,1,1816.790316),-- [drake_leather_mail_texture]
(20242,420,1,1,1,60.033908),-- [theca_leather_gaiters]
(20242,1985,1,1,1,4106.257452),-- [theca_leather_gaiters_pattern]
(20242,1872,1,1,2,68047.178448),-- [animal_bone]
(20242,1867,1,1,2,68047.178448),-- [animal_skin]
(20242,1881,1,1,2,6804.750186),-- [coarse_bone_powder]
(20242,1875,1,1,2,3402.29424),-- [stone_of_purity]
(20242,4041,1,1,2,443.721264),-- [mold_hardener]
(20242,3034,1,1,2,102.036486),-- [rp_spiritshot_b]
(20242,5270,1,1,2,102.036486),-- [rp_adv_comp_soulshot_b]
(20242,4959,1,1,2,983.334186),-- [rp_avadon_boots_i]
(20242,4941,1,1,2,392.622168),-- [rp_shrnoen's_gaiters_i]
(20242,6669,1,1,2,11868.735282),-- [key_of_treasure_box5]
(20242,8726,1,1,2,1181.424036),-- [general_55_c]
(20242,8736,1,1,2,295.275156),-- [special_55_c]
(20242,8746,1,1,2,29.592198),-- [rare_55_c]
(20242,8756,1,1,2,5.821416),-- [unique_55_c]
(20243,4599,1,1,-1,5751),-- [dye_w2i2_c]
(20243,1873,1,1,-1,690175),-- [silver_nugget]
(20243,1806,1,1,-1,3451),-- [rp_soulshot_b]
(20243,57,682,1388,0,700000),-- [adena]
(20243,203,1,1,1,3.463976),-- [paagrio_axe]
(20243,2112,1,1,1,308.507784),-- [paagrio_axe_blade]
(20243,204,1,1,1,2.703032),-- [deadman's_staff]
(20243,2116,1,1,1,299.73248),-- [deadman's_staff_head]
(20243,205,1,1,1,2.703032),-- [ghoul's_staff]
(20243,2117,1,1,1,299.73248),-- [ghoul's_staff_head]
(20243,206,1,1,1,2.703032),-- [demon's_staff]
(20243,2118,1,1,1,299.73248),-- [demon's_staff_head]
(20243,2503,1,1,1,2.703032),-- [yaksa_mace]
(20243,2969,1,1,1,306.018672),-- [yaksa_mace_head]
(20243,1869,1,1,2,53090.529408),-- [iron_ore]
(20243,1864,1,1,2,106180.889472),-- [stem]
(20243,1880,1,1,2,5309.103744),-- [steel]
(20243,5550,1,1,2,707.85792),-- [reinforcing_plate]
(20243,4043,1,1,2,1769.6448),-- [asofe]
(20243,4144,1,1,2,545.626368),-- [rp_shrnoen's_leather_gaiters]
(20243,4184,1,1,2,61.133184),-- [rp_sprite's_staff]
(20243,5155,1,1,2,106.178688),-- [rp_comp_soulshot_b]
(20243,8726,1,1,2,1228.929408),-- [general_55_c]
(20243,8736,1,1,2,307.190016),-- [special_55_c]
(20243,8746,1,1,2,30.651264),-- [rare_55_c]
(20243,8756,1,1,2,6.265728),-- [unique_55_c]
(20244,3955,1,1,-1,3548),-- [rp_blessed_spiritshot_b]
(20244,2117,1,1,-1,8346),-- [ghoul's_staff_head]
(20244,4592,1,1,-1,5913),-- [dye_c2c2_c]
(20244,57,701,1428,0,700000),-- [adena]
(20244,400,1,1,1,34.38225),-- [theca_leather_mail]
(20244,1984,1,1,1,2339.906625),-- [theca_leather_mail_pattern]
(20244,401,1,1,1,16.277625),-- [drake_leather_mail]
(20244,1987,1,1,1,1665.3735),-- [drake_leather_mail_texture]
(20244,420,1,1,1,55.0305),-- [theca_leather_gaiters]
(20244,1985,1,1,1,3764.0295),-- [theca_leather_gaiters_pattern]
(20244,1872,1,1,2,72778.24202),-- [animal_bone]
(20244,1867,1,1,2,72778.24202),-- [animal_skin]
(20244,1881,1,1,2,7277.84008),-- [coarse_bone_powder]
(20244,1875,1,1,2,3638.92004),-- [stone_of_purity]
(20244,4041,1,1,2,474.59342),-- [mold_hardener]
(20244,4185,1,1,2,62.87688),-- [rp_kshanberk]
(20244,5436,1,1,2,89.07558),-- [rp_berserker_blade]
(20244,8322,1,1,2,62.87688),-- [rp_ice_storm_hammer_i]
(20244,8726,1,1,2,1263.57124),-- [general_55_c]
(20244,8736,1,1,2,315.81342),-- [special_55_c]
(20244,8746,1,1,2,31.59722),-- [rare_55_c]
(20244,8756,1,1,2,6.3512),-- [unique_55_c]
(20245,1895,1,1,-1,526594),-- [metallic_fiber]
(20245,4071,1,1,-1,33383),-- [avadon_robe_fabric]
(20245,4129,1,1,-1,19947),-- [rp_earing_of_black_ore]
(20245,57,727,1485,0,700000),-- [adena]
(20245,12159,1,1,1,621.488992),-- [shrnoen's_shield_low]
(20245,4101,1,1,1,3945.07984),-- [shrnoen's_shield_fragment]
(20245,12171,1,1,1,621.488992),-- [avadon_shield_low]
(20245,4439,1,1,1,4693.284928),-- [avadon_shield_fragment]
(20245,12160,1,1,1,434.83824),-- [shrnoen's_helmet_low]
(20245,4102,1,1,1,3056.481952),-- [shrnoen's_helmet_design]
(20245,12170,1,1,1,434.83824),-- [avadon_circlet_low]
(20245,4072,1,1,1,3056.498816),-- [avadon_circlet_pattern]
(20245,1864,1,1,2,83756.319034),-- [stem]
(20245,1869,1,1,2,41878.159517),-- [iron_ore]
(20245,1878,1,1,2,16751.298423),-- [braided_hemp]
(20245,1884,1,1,2,25771.241657),-- [cord]
(20245,4039,1,1,2,1395.898265),-- [mold_glue]
(20245,4945,1,1,2,322.103741),-- [rp_avadon_gaiters_i]
(20245,4999,1,1,2,520.800729),-- [rp_doom_boots_i]
(20245,8322,1,1,2,48.289599),-- [rp_ice_storm_hammer_i]
(20245,8726,1,1,2,969.426681),-- [general_55_c]
(20245,8736,1,1,2,242.3134),-- [special_55_c]
(20245,8746,1,1,2,24.23134),-- [rare_55_c]
(20245,8756,1,1,2,4.846268),-- [unique_55_c]
(20245,6036,1,1,2,1396.071346),-- [potion_of_acumen3]
(20246,2964,1,1,-1,128620),-- [blessed_gloves_pattern]
(20246,4049,1,1,-1,123897),-- [adamantite_earing_gemstone]
(20246,947,1,1,-1,945),-- [scrl_of_ench_wp_b]
(20246,57,933,1900,0,700000),-- [adena]
(20246,12338,1,1,1,953.195154),-- [adamantite_earing_low]
(20246,4049,1,1,1,6099.582939),-- [adamantite_earing_gemstone]
(20246,12339,1,1,1,715.618071),-- [adamantite_necklace_low]
(20246,4051,1,1,1,4509.92721),-- [adamantite_necklace_chain]
(20246,12340,1,1,1,1435.67097),-- [adamantite_ring_low]
(20246,4050,1,1,1,7205.005656),-- [adamantite_ring_wire]
(20246,1869,1,1,2,58144.104144),-- [iron_ore]
(20246,1864,1,1,2,116288.208288),-- [stem]
(20246,1880,1,1,2,5814.44752),-- [steel]
(20246,5550,1,1,2,775.321512),-- [reinforcing_plate]
(20246,4043,1,1,2,1938.211016),-- [asofe]
(20246,4969,1,1,2,66.975608),-- [rp_hell_knife_i]
(20246,4176,1,1,2,723.188144),-- [rp_doom_boots]
(20246,4157,1,1,2,289.238152),-- [rp_blue_wolve's_gaiters]
(20246,8727,1,1,2,1162.889504),-- [general_58_b]
(20246,8737,1,1,2,290.722376),-- [special_58_b]
(20246,8747,1,1,2,29.127896),-- [rare_58_b]
(20246,8757,1,1,2,5.56584),-- [unique_58_b]
(20248,2250,1,1,-1,141016),-- [rp_bone_arrow]
(20248,955,1,1,-1,2256),-- [scrl_of_ench_wp_d]
(20248,1865,1,1,-1,564065),-- [varnish]
(20248,57,239,476,0,700000),-- [adena]
(20248,86,1,1,1,12.446356),-- [tomahawk]
(20248,179,1,1,1,12.446356),-- [mace_of_prayer]
(20248,180,1,1,1,12.446356),-- [mace_of_judgment]
(20248,2022,1,1,1,480.31698),-- [mace_of_judgment_head]
(20248,181,1,1,1,12.446356),-- [mace_of_miracle]
(20248,182,1,1,1,12.446356),-- [doom_hammer]
(20248,183,1,1,1,12.446356),-- [mystic_staff]
(20248,184,1,1,1,12.446356),-- [conjure_staff]
(20248,2023,1,1,1,382.11121),-- [conjure_staff_head]
(20248,185,1,1,1,12.447318),-- [staff_of_mana]
(20248,1870,1,1,2,51373.471374),-- [coal]
(20248,1865,1,1,2,51373.471374),-- [varnish]
(20248,1874,1,1,2,3424.951548),-- [oriharukon_ore]
(20248,1829,1,1,2,20549.442006),-- [scroll_of_escape_to_agit]
(20248,2274,1,1,2,366.978186),-- [rp_skull_breaker]
(20248,2192,1,1,2,6552.685512),-- [rp_kite_shield]
(20249,1873,1,1,-1,480668),-- [silver_nugget]
(20249,1865,1,3,-1,600835),-- [varnish]
(20249,57,508,1015,0,700000),-- [adena]
(20249,260,1,1,1,172),-- [triple-edged_jamadhr]
(20249,1868,1,1,2,182548.216557),-- [thread]
(20249,1873,1,1,2,36509.73261),-- [silver_nugget]
(20249,5549,1,1,2,9127.209906),-- [iron_thread]
(20249,1889,1,1,2,6084.806604),-- [compound_braid]
(20249,2186,1,1,2,3052.672641),-- [rp_brigandine]
(20249,6667,1,1,2,57046.178145),-- [key_of_treasure_box3]
(20249,1341,20,60,2,152124.183537),-- [bone_arrow]
(20250,1884,1,1,-1,281232),-- [cord]
(20250,2259,1,1,-1,7096),-- [rp_spinebone_sword]
(20250,1899,1,1,-1,71407),-- [necklace_of_devotion_chain]
(20250,57,197,380,0,700000),-- [adena]
(20250,847,1,1,1,619.503616),-- [red_cresent_earing]
(20250,910,1,1,1,464.627712),-- [necklace_of_devotion]
(20250,1899,1,1,1,10018.601216),-- [necklace_of_devotion_chain]
(20250,890,1,1,1,929.267456),-- [ring_of_devotion]
(20250,1870,1,1,2,51296.9085),-- [coal]
(20250,1865,1,1,2,51296.9085),-- [varnish]
(20250,1874,1,1,2,3419.7939),-- [oriharukon_ore]
(20250,2182,1,1,2,6158.124392),-- [rp_scale_gaiters]
(20250,5437,1,1,2,1254.264708),-- [rp_heavy_sword]
(20251,1880,1,1,-1,48038),-- [steel]
(20251,2017,1,1,-1,6384),-- [saber_blade]
(20251,2152,1,1,-1,84573),-- [rp_enchanted_necklace]
(20251,57,206,403,0,700000),-- [adena]
(20251,123,1,1,1,42.796702),-- [saber]
(20251,2017,1,1,1,895.723943),-- [saber_blade]
(20251,5285,1,1,1,42.796702),-- [heavy_sword]
(20251,5531,1,1,1,1131.682653),-- [heavy_sword_edge]
(20251,1871,1,1,2,67400.525075),-- [charcoal]
(20251,1866,1,1,2,44933.642791),-- [suede]
(20251,1877,1,1,2,2696.021003),-- [admantite_nugget]
(20251,2181,1,1,2,6746.811131),-- [rp_white_tunic]
(20252,1865,1,1,-1,502762),-- [varnish]
(20252,1900,1,1,-1,55007),-- [enchanted_necklace_chain]
(20252,1061,1,1,-1,304704),-- [healing_potion]
(20252,57,213,422,0,700000),-- [adena]
(20252,1123,1,1,1,1073),-- [blue_buckskin_boots]
(20252,605,1,1,1,1073),-- [leather_gauntlet]
(20252,1872,1,1,2,45790.07202),-- [animal_bone]
(20252,1867,1,1,2,45790.07202),-- [animal_skin]
(20252,1881,1,1,2,4578.95067),-- [coarse_bone_powder]
(20252,1875,1,1,2,2289.546),-- [stone_of_purity]
(20252,2185,1,1,2,6760.37922),-- [rp_iron_boots]
(20252,2274,1,1,2,245.34888),-- [rp_skull_breaker]
(20252,2187,1,1,2,1533.14784),-- [rp_manticor_skin_shirt]
(20252,6666,1,1,2,34342.48335),-- [key_of_treasure_box2]
(20253,2265,1,1,-1,5545),-- [rp_spike_club]
(20253,2153,1,1,-1,83396),-- [rp_tiger'seye_earing]
(20253,1900,1,1,-1,58669),-- [enchanted_necklace_chain]
(20253,57,226,452,0,700000),-- [adena]
(20253,348,1,1,1,142.941546),-- [scale_mail]
(20253,1935,1,1,1,4092.708972),-- [scale_mail_fragment]
(20253,377,1,1,1,228.575226),-- [scale_gaiters]
(20253,1937,1,1,1,6293.774256),-- [scale_gaiters_fragment]
(20253,1873,1,1,2,23442.52872),-- [silver_nugget]
(20253,1868,1,1,2,117212.955834),-- [thread]
(20253,1876,1,1,2,11721.26436),-- [mithril_ore]
(20253,2266,1,1,2,606.046194),-- [rp_knife_o'_silenus]
(20253,2971,1,1,2,3134.204892),-- [rp_mithril_scale_gaiters]
(20254,2181,1,1,-1,49538),-- [rp_white_tunic]
(20254,2262,1,1,-1,7685),-- [rp_elven_bow]
(20254,1899,1,1,-1,77326),-- [necklace_of_devotion_chain]
(20254,57,212,415,0,700000),-- [adena]
(20254,291,1,1,1,88.181775),-- [trident]
(20254,2019,1,1,1,2986.818225),-- [trident_edge]
(20254,1876,1,1,2,9258.167835),-- [mithril_ore]
(20254,1880,1,1,2,4629.102795),-- [steel]
(20254,1877,1,1,2,1851.618465),-- [admantite_nugget]
(20254,1881,1,1,2,6172.11189),-- [coarse_bone_powder]
(20254,1882,1,1,2,10286.87832),-- [leather]
(20254,2182,1,1,2,5557.120695),-- [rp_scale_gaiters]
(20265,1866,1,1,-1,449035),-- [suede]
(20265,2015,1,1,-1,8214),-- [sword_breaker_edge]
(20265,1872,1,1,-1,898071),-- [animal_bone]
(20265,57,306,549,0,700000),-- [adena]
(20265,219,1,1,1,211.65993),-- [sword_breaker]
(20265,2015,1,1,1,2426.34007),-- [sword_breaker_edge]
(20265,1867,1,1,2,106110.762776),-- [animal_skin]
(20265,1872,1,1,2,106110.762776),-- [animal_bone]
(20265,1882,1,1,2,17685.048784),-- [leather]
(20265,5158,1,1,2,3183.327584),-- [rp_comp_spiritshot_d]
(20265,8294,1,1,2,1946.09808),-- [rp_iron_sword]
(20266,1866,1,1,-1,279792),-- [suede]
(20266,2180,1,1,-1,31555),-- [rp_scale_mail]
(20266,1878,1,1,-1,167875),-- [braided_hemp]
(20266,57,185,346,0,700000),-- [adena]
(20266,432,1,1,1,488.596549),-- [cursed_tunic]
(20266,465,1,1,1,782.403451),-- [cursed_hose]
(20266,1874,1,1,2,3925.7295),-- [oriharukon_ore]
(20266,1878,1,1,2,23554.4385),-- [braided_hemp]
(20266,5220,1,1,2,2355.45),-- [reinforcing_agent]
(20266,2260,1,1,2,914.382),-- [rp_mace_of_judgment]
(20267,2203,1,1,-1,122890),-- [rp_mithril_boots]
(20267,1882,1,1,-1,125348),-- [leather]
(20267,1061,1,1,-1,341857),-- [healing_potion]
(20267,57,239,476,0,700000),-- [adena]
(20267,69,1,1,1,24.885154),-- [bastard_sword]
(20267,125,1,1,1,24.885154),-- [spinebone_sword]
(20267,2021,1,1,1,778.457628),-- [spinebone_sword_blade]
(20267,126,1,1,1,24.885154),-- [artisan's_sword]
(20267,128,1,1,1,24.88691),-- [knight's_sword]
(20267,1873,1,1,2,24659.133856),-- [silver_nugget]
(20267,1868,1,1,2,123295.498968),-- [thread]
(20267,1876,1,1,2,12329.566928),-- [mithril_ore]
(20267,2153,1,1,2,9587.543728),-- [rp_tiger'seye_earing]
(20267,2274,1,1,2,440.25652),-- [rp_skull_breaker]
(20268,1878,1,1,-1,308026),-- [braided_hemp]
(20268,1900,1,1,-1,84252),-- [enchanted_necklace_chain]
(20268,57,324,651,0,700000),-- [adena]
(20268,275,1,1,1,56.606465),-- [long_bow]
(20268,276,1,1,1,56.606465),-- [elven_bow]
(20268,2024,1,1,1,1997.78707),-- [elven_bow_shaft]
(20268,1872,1,1,2,112216.0639),-- [animal_bone]
(20268,1867,1,1,2,112216.0639),-- [animal_skin]
(20268,1881,1,1,2,11221.60639),-- [coarse_bone_powder]
(20268,1875,1,1,2,5610.92523),-- [stone_of_purity]
(20268,956,1,1,2,2805.34058),-- [scrl_of_ench_am_d]
(20269,1879,1,1,-1,111342),-- [cokes]
(20269,2029,1,1,-1,7969),-- [gastraphetes_shaft]
(20269,2154,1,1,-1,71526),-- [rp_elven_earing]
(20269,57,282,563,0,700000),-- [adena]
(20269,157,1,1,1,31.85426),-- [spike_club]
(20269,2027,1,1,1,1551.29148),-- [spike_club_head]
(20269,186,1,1,1,31.85426),-- [staff_of_magicpower]
(20269,1875,1,1,2,2959.9682),-- [stone_of_purity]
(20269,1879,1,1,2,7399.873095),-- [cokes]
(20269,1885,1,1,2,3699.96025),-- [high_grade_suede]
(20269,5550,1,1,2,591.99364),-- [reinforcing_plate]
(20269,5549,1,1,2,4439.904895),-- [iron_thread]
(20269,2275,1,1,2,317.13945),-- [rp_heavy_bone_club]
(20269,2286,1,1,2,246.648215),-- [rp_bonebreaker]
(20269,6667,1,1,2,27749.512255),-- [key_of_treasure_box3]
(20270,2972,1,1,-1,50438),-- [rp_brigandine_gaiters]
(20270,2976,1,1,-1,126263),-- [rp_manticor_skin_boots]
(20270,1901,1,1,-1,130274),-- [tiger'seye_earing_stone]
(20270,57,398,795,0,700000),-- [adena]
(20270,393,1,1,1,142.870754),-- [mithril_banded_mail]
(20270,1938,1,1,1,5618.601014),-- [mithril_banded_mail_material]
(20270,394,1,1,1,142.870754),-- [reinforce_leather_shirt]
(20270,415,1,1,1,228.357532),-- [mithril_banded_gaiters]
(20270,1939,1,1,1,7340.956116),-- [mithril_banded_gaiters_material]
(20270,416,1,1,1,228.34383),-- [reinforce_leather_gaiters]
(20270,1870,1,1,2,100296.588195),-- [coal]
(20270,1865,1,1,2,100296.588195),-- [varnish]
(20270,1874,1,1,2,6686.439213),-- [oriharukon_ore]
(20270,2980,1,1,2,13426.404072),-- [rp_brigandine_gauntlet]
(20270,1341,20,60,2,167160.980325),-- [bone_arrow]
(20271,1882,1,1,-1,170847),-- [leather]
(20271,2271,1,1,-1,5492),-- [rp_winged_spear]
(20271,2155,1,1,-1,123405),-- [rp_elven_ring]
(20271,57,325,650,0,700000),-- [adena]
(20271,849,1,1,1,413.73337),-- [tiger'seye_earing]
(20271,1901,1,1,1,14114.792548),-- [tiger'seye_earing_stone]
(20271,912,1,1,1,310.133854),-- [near_forest_necklace]
(20271,880,1,1,1,619.340228),-- [black_pearl_ring]
(20271,1874,1,1,2,3406.418838),-- [oriharukon_ore]
(20271,1878,1,1,2,20438.513028),-- [braided_hemp]
(20271,1884,1,1,2,31443.890685),-- [cord]
(20271,1889,1,1,2,3406.418838),-- [compound_braid]
(20271,5220,1,1,2,2043.838569),-- [reinforcing_agent]
(20271,2187,1,1,2,2281.069263),-- [rp_manticor_skin_shirt]
(20271,2293,1,1,2,283.900071),-- [rp_glaive]
(20271,2269,1,1,2,364.950708),-- [rp_morning_star]
(20291,1879,1,1,-1,69130),-- [cokes]
(20291,2255,1,1,-1,10141),-- [rp_saber]
(20291,1898,1,1,-1,42607),-- [blue_diamond_necklace_gem]
(20291,57,189,337,0,700000),-- [adena]
(20291,27,1,1,1,431.406745),-- [hard_leather_shirt]
(20291,1927,1,1,1,4887.03149),-- [hard_leather_shirt_pattern]
(20291,33,1,1,1,692.18776),-- [hard_leather_gaiters]
(20291,1929,1,1,1,7904.374005),-- [hard_leather_gaiters_material]
(20291,1864,1,1,2,98016.33842),-- [stem]
(20291,1869,1,1,2,49008.16921),-- [iron_ore]
(20291,1878,1,1,2,19603.267684),-- [braided_hemp]
(20291,2257,1,1,2,1198.167152),-- [rp_trident]
(20291,734,1,1,2,8168.057534),-- [quick_step_potion]
(20292,2150,1,1,-1,144749),-- [rp_blue_diamond_necklace]
(20292,2139,1,1,-1,61663),-- [rp_steel_mold]
(20292,5220,1,1,-1,12333),-- [reinforcing_agent]
(20292,57,142,248,0,700000),-- [adena]
(20292,845,1,1,1,1331.443806),-- [cat'seye_earing]
(20292,908,1,1,1,998.590439),-- [necklace_of_wisdom]
(20292,1897,1,1,1,10841.800046),-- [necklace_of_wisdom_chain]
(20292,877,1,1,1,1997.165709),-- [ring_of_wisdom]
(20292,1871,1,1,2,45536.009457),-- [charcoal]
(20292,1866,1,1,2,30357.366165),-- [suede]
(20292,2252,1,1,2,1866.254031),-- [rp_iron_hammer]
(20292,5158,1,1,2,1821.370347),-- [rp_comp_spiritshot_d]
(20307,2137,1,1,-1,43777),-- [rp_steel]
(20307,1867,1,1,-1,198456),-- [animal_skin]
(20307,1060,1,1,-1,330759),-- [lesser_healing_potion]
(20307,57,80,108,0,700000),-- [adena]
(20307,152,1,1,1,709.063155),-- [heavy_chisel]
(20307,5,1,1,1,457.936155),-- [mace]
(20307,8,1,1,1,457.936155),-- [willow_staff]
(20307,2006,1,1,1,1570.064535),-- [willow_staff_head]
(20307,1864,1,1,2,29310.4816),-- [stem]
(20307,1865,1,1,2,14655.2408),-- [varnish]
(20307,1866,1,1,2,9770.200675),-- [suede]
(20307,1873,1,1,2,5862.04815),-- [silver_nugget]
(20307,1868,1,1,2,29310.4816),-- [thread]
(20307,1802,1,1,2,31516.547175),-- [rp_necklace_of_anguish]
(20308,1868,1,1,-1,475131),-- [thread]
(20308,1924,1,1,-1,76634),-- [leather_helmet_design]
(20308,1897,1,1,-1,56563),-- [necklace_of_wisdom_chain]
(20308,57,118,183,0,700000),-- [adena]
(20308,38,1,1,1,1795.866945),-- [low_boots]
(20308,50,1,1,1,1795.866945),-- [leather_gloves]
(20308,1925,1,1,1,30677.26611),-- [leather_gloves_lining]
(20308,1868,1,1,2,70173.507304),-- [thread]
(20308,1873,1,1,2,14034.682935),-- [silver_nugget]
(20308,2143,1,1,2,7017.387782),-- [rp_synthesis_cokes]
(20308,5158,1,1,2,1403.421979),-- [rp_comp_spiritshot_d]
(20310,735,1,1,-1,19993),-- [swift_attack_potion]
(20310,1872,1,1,-1,319890),-- [animal_bone]
(20310,1800,1,1,-1,75446),-- [rp_piece_bone_breastplate]
(20310,57,119,185,0,700000),-- [adena]
(20310,38,1,1,1,1813.63224),-- [low_boots]
(20310,50,1,1,1,1813.63224),-- [leather_gloves]
(20310,1925,1,1,1,30980.73552),-- [leather_gloves_lining]
(20310,1865,1,1,2,47245.4073),-- [varnish]
(20310,1870,1,1,2,47245.4073),-- [coal]
(20310,2144,1,1,2,9449.1854),-- [rp_compound_braid]
(20311,1060,1,1,-1,172757),-- [lesser_healing_potion]
(20311,2005,1,1,-1,5553),-- [broad_sword_blade]
(20311,57,41,58,0,700000),-- [adena]
(20311,1122,1,1,1,6514.326819),-- [cotton_shoes]
(20311,1129,1,1,1,6514.326819),-- [crude_leather_shoes]
(20311,1119,1,1,1,6514.346362),-- [short_leather_gloves]
(20311,1873,1,1,2,4592.664723),-- [silver_nugget]
(20311,1868,1,1,2,22963.268422),-- [thread]
(20311,1789,1,1,2,2122.281236),-- [rp_cedar_staff]
(20311,1060,1,1,2,25514.785619),-- [lesser_healing_potion]
(20312,1866,1,1,-1,64878),-- [suede]
(20312,2136,1,1,-1,28622),-- [rp_cokes]
(20312,1666,1,1,-1,32439),-- [rp_wooden_arrow]
(20312,57,51,72,0,700000),-- [adena]
(20312,19,1,1,1,11732.93531),-- [small_shield]
(20312,42,1,1,1,8213.06469),-- [leather_cap]
(20312,1869,1,1,2,14372.985256),-- [iron_ore]
(20312,1864,1,1,2,28745.970512),-- [stem]
(20312,1802,1,1,2,30909.610376),-- [rp_necklace_of_anguish]
(20312,734,1,1,2,2395.433856),-- [quick_step_potion]
(20313,1814,1,1,-1,95767),-- [rp_leather]
(20313,22,1,1,-1,19461),-- [leather_shirt]
(20313,2006,1,1,-1,12997),-- [willow_staff_head]
(20313,57,98,132,0,700000),-- [adena]
(20313,428,1,1,1,2874.194224),-- [feriotic_tunic]
(20313,1100,1,1,1,2874.194224),-- [cotton_tunic]
(20313,463,1,1,1,4593.805776),-- [feriotic_hose]
(20313,1103,1,1,1,4593.805776),-- [cotton_hose]
(20313,1864,1,1,2,53747.0829),-- [stem]
(20313,1869,1,1,2,26873.54145),-- [iron_ore]
(20313,1790,1,1,2,4967.432085),-- [rp_dirk]
(20313,6037,1,1,2,53746.943565),-- [scroll_of_awake]
(20314,1874,1,1,-1,57718),-- [oriharukon_ore]
(20314,4472,1,1,-1,4947),-- [dye_c1d1_d]
(20314,1869,1,1,-1,865765),-- [iron_ore]
(20314,57,349,705,0,700000),-- [adena]
(20314,70,1,1,1,15.669267),-- [claymore]
(20314,2047,1,1,1,955.292883),-- [claymore_blade]
(20314,2499,1,1,1,15.669267),-- [elven_long_sword]
(20314,2967,1,1,1,942.368583),-- [elven_long_sword_blade]
(20314,1864,1,1,2,124213.539318),-- [stem]
(20314,1869,1,1,2,62106.769659),-- [iron_ore]
(20314,1878,1,1,2,24842.605348),-- [braided_hemp]
(20314,1884,1,1,2,38219.609703),-- [cord]
(20314,2205,1,1,2,1965.480341),-- [rp_chain_gaiters]
(20314,2299,1,1,2,271.153762),-- [rp_big_hammer]
(20314,2209,1,1,2,4669.841869),-- [rp_eldarake]
(20316,1803,1,1,-1,169394),-- [rp_necklace_of_wisdom]
(20316,1864,1,1,-1,403157),-- [stem]
(20316,1792,1,1,-1,14822),-- [rp_short_spear]
(20316,57,109,147,0,700000),-- [adena]
(20316,23,1,1,1,1297.277532),-- [wooden_breastplate]
(20316,30,1,1,1,2078.361234),-- [hard_leather_pants]
(20316,2386,1,1,1,2078.361234),-- [wooden_gaiters]
(20316,1865,1,1,2,29771.467966),-- [varnish]
(20316,1870,1,1,2,29771.467966),-- [coal]
(20316,1794,1,1,2,2189.097162),-- [rp_bow_of_forest]
(20316,734,1,1,2,4961.966906),-- [quick_step_potion]
(20317,1867,1,1,-1,51475),-- [animal_skin]
(20317,1786,1,1,-1,30885),-- [rp_broad_sword]
(20317,57,19,29,0,700000),-- [adena]
(20317,1,1,1,1,13530),-- [small_sword]
(20317,1869,1,1,2,6652.105863),-- [iron_ore]
(20317,1870,1,1,2,6652.105863),-- [coal]
(20317,1871,1,1,2,6652.105863),-- [charcoal]
(20317,1872,1,1,2,8869.503162),-- [animal_bone]
(20317,1867,1,1,2,8869.503162),-- [animal_skin]
(20317,1787,1,1,2,5321.676087),-- [rp_willow_staff]
(20318,1866,1,1,-1,51314),-- [suede]
(20318,1060,1,1,-1,171046),-- [lesser_healing_potion]
(20318,2005,1,1,-1,5498),-- [broad_sword_blade]
(20318,57,41,58,0,700000),-- [adena]
(20318,3,1,1,1,473.740988),-- [broad_sword]
(20318,2005,1,1,1,1624.259012),-- [broad_sword_blade]
(20318,1866,1,1,2,15157.2),-- [suede]
(20318,1871,1,1,2,22735.8),-- [charcoal]
(20319,1865,1,1,-1,56617),-- [varnish]
(20319,1787,1,1,-1,45293),-- [rp_willow_staff]
(20319,57,30,42,0,700000),-- [adena]
(20319,112,1,1,1,102689.2683),-- [apprentice's_earing]
(20319,118,1,1,1,76513.51329),-- [necklace_of_magic]
(20319,116,1,1,1,156087.21841),-- [magic_ring]
(20319,1864,1,1,2,19511.058856),-- [stem]
(20319,1865,1,1,2,9755.529428),-- [varnish]
(20319,1866,1,1,2,6503.663956),-- [suede]
(20319,1873,1,1,2,3902.184976),-- [silver_nugget]
(20319,1868,1,1,2,19511.058856),-- [thread]
(20319,1787,1,1,2,7804.503928),-- [rp_willow_staff]
(20320,1831,1,1,-1,557587),-- [antidote]
(20320,2010,1,1,-1,8136),-- [brandish_blade]
(20320,1867,1,1,-1,278794),-- [animal_skin]
(20320,57,112,154,0,700000),-- [adena]
(20320,216,1,1,1,296.92293),-- [dirk]
(20320,2009,1,1,1,2190.07707),-- [dirk_blade]
(20320,1867,1,1,2,54901.037487),-- [animal_skin]
(20320,1872,1,1,2,54901.037487),-- [animal_bone]
(20320,1799,1,1,2,61000.925026),-- [rp_leather_gloves]
(20321,1870,1,1,-1,178389),-- [coal]
(20321,2005,1,1,-1,12742),-- [broad_sword_blade]
(20321,1060,1,1,-1,396420),-- [lesser_healing_potion]
(20321,57,96,130,0,700000),-- [adena]
(20321,152,1,1,1,849.98807),-- [heavy_chisel]
(20321,5,1,1,1,548.95007),-- [mace]
(20321,8,1,1,1,548.95007),-- [willow_staff]
(20321,2006,1,1,1,1882.11179),-- [willow_staff_head]
(20321,1864,1,1,2,30110.403165),-- [stem]
(20321,1865,1,1,2,15055.268715),-- [varnish]
(20321,1866,1,1,2,10036.84581),-- [suede]
(20321,1873,1,1,2,6022.05378),-- [silver_nugget]
(20321,1868,1,1,2,30110.403165),-- [thread]
(20321,1791,1,1,2,2782.910655),-- [rp_brandish]
(20321,1833,1,1,2,40147.11471),-- [bandage]
(20322,1796,1,1,-1,156757),-- [rp_leather_tunic]
(20322,1870,1,1,-1,124622),-- [coal]
(20322,2005,1,1,-1,8902),-- [broad_sword_blade]
(20322,57,67,91,0,700000),-- [adena]
(20322,12,1,1,1,767),-- [knife]
(20322,215,1,1,1,767),-- [doomed_dagger]
(20322,1872,1,1,2,24540.844224),-- [animal_bone]
(20322,1867,1,1,2,24540.844224),-- [animal_skin]
(20322,2137,1,1,2,5413.438758),-- [rp_steel]
(20322,17,10,30,2,92027.872794),-- [wooden_arrow]
(20323,1869,1,1,-1,227339),-- [iron_ore]
(20323,1865,1,1,-1,227339),-- [varnish]
(20323,1792,1,1,-1,16716),-- [rp_short_spear]
(20323,57,116,172,0,700000),-- [adena]
(20323,216,1,1,1,322.83056),-- [dirk]
(20323,2009,1,1,1,2381.16944),-- [dirk_blade]
(20323,1871,1,1,2,33576.357012),-- [charcoal]
(20323,1866,1,1,2,22384.238008),-- [suede]
(20323,1792,1,1,2,2468.816538),-- [rp_short_spear]
(20323,6037,1,1,2,67152.588442),-- [scroll_of_awake]
(20324,1791,1,1,-1,33633),-- [rp_brandish]
(20324,1871,1,1,-1,181957),-- [charcoal]
(20324,2006,1,1,-1,12997),-- [willow_staff_head]
(20324,57,98,132,0,700000),-- [adena]
(20324,152,1,1,1,866.854674),-- [heavy_chisel]
(20324,5,1,1,1,559.843074),-- [mace]
(20324,8,1,1,1,559.843074),-- [willow_staff]
(20324,2006,1,1,1,1919.459178),-- [willow_staff_head]
(20324,1869,1,1,2,17915.77177),-- [iron_ore]
(20324,1870,1,1,2,17915.77177),-- [coal]
(20324,1871,1,1,2,17915.77177),-- [charcoal]
(20324,1872,1,1,2,23887.75207),-- [animal_bone]
(20324,1867,1,1,2,23887.75207),-- [animal_skin]
(20324,1795,1,1,2,67607.18055),-- [rp_leather_shoes]
(20325,1787,1,1,-1,45293),-- [rp_willow_staff]
(20325,118,1,1,-1,222026),-- [necklace_of_magic]
(20325,1786,1,1,-1,45293),-- [rp_broad_sword]
(20325,57,30,42,0,700000),-- [adena]
(20325,112,1,1,1,102689.2683),-- [apprentice's_earing]
(20325,118,1,1,1,76513.51329),-- [necklace_of_magic]
(20325,116,1,1,1,156087.21841),-- [magic_ring]
(20325,1865,1,1,2,11706.54543),-- [varnish]
(20325,1870,1,1,2,11706.54543),-- [coal]
(20325,1788,1,1,2,9365.236344),-- [rp_bow]
(20325,6037,1,1,2,23413.09086),-- [scroll_of_awake]
(20325,1060,1,1,2,26014.581936),-- [lesser_healing_potion]
(20326,2135,1,1,-1,36653),-- [rp_braided_hemp]
(20326,2006,1,1,-1,8902),-- [willow_staff_head]
(20326,2007,1,1,-1,8902),-- [bow_shaft]
(20326,57,67,91,0,700000),-- [adena]
(20326,22,1,1,1,3937.19964),-- [leather_shirt]
(20326,29,1,1,1,6292.80036),-- [leather_pants]
(20326,1864,1,1,2,24541.02735),-- [stem]
(20326,1865,1,1,2,12270.47465),-- [varnish]
(20326,1866,1,1,2,8180.34245),-- [suede]
(20326,1873,1,1,2,4908.17425),-- [silver_nugget]
(20326,1868,1,1,2,24541.02735),-- [thread]
(20326,2138,1,1,2,3608.95395),-- [rp_coarse_bone_powder]
(20327,1870,1,1,-1,56617),-- [coal]
(20327,1865,1,1,-1,56617),-- [varnish]
(20327,1872,1,1,-1,75489),-- [animal_bone]
(20327,57,30,42,0,700000),-- [adena]
(20327,112,1,1,1,102689.2683),-- [apprentice's_earing]
(20327,118,1,1,1,76513.51329),-- [necklace_of_magic]
(20327,116,1,1,1,156087.21841),-- [magic_ring]
(20327,1867,1,1,2,26014.58937),-- [animal_skin]
(20327,1872,1,1,2,26014.58937),-- [animal_bone]
(20327,1786,1,1,2,15608.82126),-- [rp_broad_sword]
(20328,1865,1,1,-1,124622),-- [varnish]
(20328,2137,1,1,-1,36653),-- [rp_steel]
(20328,1869,1,1,-1,124622),-- [iron_ore]
(20328,57,67,91,0,700000),-- [adena]
(20328,12,1,1,1,767),-- [knife]
(20328,215,1,1,1,767),-- [doomed_dagger]
(20328,1869,1,1,2,10517.505694),-- [iron_ore]
(20328,1870,1,1,2,10517.505694),-- [coal]
(20328,1871,1,1,2,10517.505694),-- [charcoal]
(20328,1872,1,1,2,14023.283274),-- [animal_bone]
(20328,1867,1,1,2,14023.283274),-- [animal_skin]
(20328,1666,1,1,2,3505.864057),-- [rp_wooden_arrow]
(20328,1060,1,1,2,23372.052313),-- [lesser_healing_potion]
(20329,1869,1,1,-1,287587),-- [iron_ore]
(20329,1880,1,1,-1,28759),-- [steel]
(20329,1898,1,1,-1,29542),-- [blue_diamond_necklace_gem]
(20329,57,131,234,0,700000),-- [adena]
(20329,16,1,1,1,181),-- [long_spear]
(20329,1869,1,1,2,24271.177086),-- [iron_ore]
(20329,1870,1,1,2,24271.177086),-- [coal]
(20329,1871,1,1,2,24271.177086),-- [charcoal]
(20329,1872,1,1,2,32361.569448),-- [animal_bone]
(20329,1867,1,1,2,32361.569448),-- [animal_skin]
(20329,2258,1,1,2,593.404866),-- [rp_temptation_of_abyss]
(20329,5268,1,1,2,970.92498),-- [rp_adv_comp_soulshot_d]
(20330,1866,1,1,-1,111988),-- [suede]
(20330,1896,1,1,-1,71179),-- [necklace_of_anguish_chain]
(20330,1792,1,1,-1,12352),-- [rp_short_spear]
(20330,57,91,122,0,700000),-- [adena]
(20330,37,1,1,1,3243.102948),-- [leather_shoes]
(20330,1921,1,1,1,21341.766276),-- [leather_shoes_texture]
(20330,49,1,1,1,3243.130776),-- [gloves]
(20330,1864,1,1,2,66158.800747),-- [stem]
(20330,1869,1,1,2,33079.466208),-- [iron_ore]
(20330,1798,1,1,2,32430.733045),-- [rp_leather_helmet]
(20331,1871,1,1,-1,148657),-- [charcoal]
(20331,2007,1,1,-1,10618),-- [bow_shaft]
(20331,2005,1,1,-1,10618),-- [broad_sword_blade]
(20331,57,80,108,0,700000),-- [adena]
(20331,113,1,1,1,9443.170561),-- [mage_earing]
(20331,906,1,1,1,7053.926935),-- [necklace_of_knowledge]
(20331,875,1,1,1,13939.902504),-- [ring_of_knowledge]
(20331,1865,1,1,2,21955.431057),-- [varnish]
(20331,1870,1,1,2,21955.431057),-- [coal]
(20331,1796,1,1,2,27616.861783),-- [rp_leather_tunic]
(20331,734,1,1,2,3659.276103),-- [quick_step_potion]
(20333,1792,1,1,-1,17783),-- [rp_short_spear]
(20333,2008,1,1,-1,9411),-- [cedar_staff_head]
(20333,1798,1,1,-1,237113),-- [rp_leather_helmet]
(20333,57,127,180,0,700000),-- [adena]
(20333,2371,1,1,1,732.595676),-- [fist_of_butcher]
(20333,255,1,1,1,343.404324),-- [fox's_nail]
(20333,1868,1,1,2,71439.890148),-- [thread]
(20333,1873,1,1,2,14287.95369),-- [silver_nugget]
(20333,1803,1,1,2,30016.8117),-- [rp_necklace_of_wisdom]
(20333,734,1,1,2,5953.344462),-- [quick_step_potion]
(20335,1867,1,1,-1,324856),-- [animal_skin]
(20335,734,1,1,-1,40607),-- [quick_step_potion]
(20335,1897,1,1,-1,58010),-- [necklace_of_wisdom_chain]
(20335,57,119,191,0,700000),-- [adena]
(20335,2,1,1,1,68.520295),-- [long_sword]
(20335,120,1,1,1,68.520295),-- [sword_of_reflexion]
(20335,2012,1,1,1,749.439115),-- [sword_of_reflexion_blade]
(20335,121,1,1,1,68.520295),-- [sword_of_watershadow]
(20335,1867,1,1,2,47978.755186),-- [animal_skin]
(20335,1872,1,1,2,47978.755186),-- [animal_bone]
(20335,2174,1,1,2,15645.238884),-- [rp_hard_leather_gaiters]
(20335,5158,1,1,2,1439.250744),-- [rp_comp_spiritshot_d]
(20336,1802,1,1,-1,268004),-- [rp_necklace_of_anguish]
(20336,29,1,1,-1,21303),-- [leather_pants]
(20336,1060,1,1,-1,276937),-- [lesser_healing_potion]
(20336,57,67,91,0,700000),-- [adena]
(20336,428,1,1,1,1968.59982),-- [feriotic_tunic]
(20336,1100,1,1,1,1968.59982),-- [cotton_tunic]
(20336,463,1,1,1,3146.40018),-- [feriotic_hose]
(20336,1103,1,1,1,3146.40018),-- [cotton_hose]
(20336,1864,1,1,2,24540.973407),-- [stem]
(20336,1865,1,1,2,12270.448349),-- [varnish]
(20336,1866,1,1,2,8180.324469),-- [suede]
(20336,1873,1,1,2,4908.225365),-- [silver_nugget]
(20336,1868,1,1,2,24540.973407),-- [thread]
(20336,1789,1,1,2,2268.055003),-- [rp_cedar_staff]
(20338,3032,1,1,-1,12654),-- [rp_spiritshot_d]
(20338,1927,1,1,-1,25237),-- [hard_leather_shirt_pattern]
(20338,1898,1,1,-1,32496),-- [blue_diamond_necklace_gem]
(20338,57,144,257,0,700000),-- [adena]
(20338,16,1,1,1,199),-- [long_spear]
(20338,1868,1,1,2,93443.755485),-- [thread]
(20338,1873,1,1,2,18688.751097),-- [silver_nugget]
(20338,3032,1,1,2,1868.898969),-- [rp_spiritshot_d]
(20338,1831,1,1,2,124591.594449),-- [antidote]
(20340,1792,1,1,-1,13068),-- [rp_short_spear]
(20340,57,95,131,0,700000),-- [adena]
(20340,2371,1,1,1,538.553141),-- [fist_of_butcher]
(20340,255,1,1,1,252.446859),-- [fox's_nail]
(20340,1870,1,1,2,34999.37811),-- [coal]
(20340,1865,1,1,2,34999.37811),-- [varnish]
(20340,1803,1,1,2,29411.24378),-- [rp_necklace_of_wisdom]
(20341,2141,1,1,-1,48936),-- [rp_silver_mold]
(20341,2143,1,1,-1,48936),-- [rp_synthesis_cokes]
(20341,1897,1,1,-1,58257),-- [necklace_of_wisdom_chain]
(20341,57,115,195,0,700000),-- [adena]
(20341,945,1,1,1,2737.6128),-- [skeleton_buckler]
(20341,102,1,1,1,1321.26592),-- [round_shield]
(20341,44,1,1,1,924.20224),-- [leather_helmet]
(20341,1924,1,1,1,11656.91904),-- [leather_helmet_design]
(20341,1866,1,1,2,32122.168108),-- [suede]
(20341,1871,1,1,2,48183.371641),-- [charcoal]
(20341,2175,1,1,2,39173.460251),-- [rp_boots]
(20342,1870,1,1,-1,213277),-- [coal]
(20342,429,1,1,-1,6970),-- [leather_tunic]
(20342,1793,1,1,-1,15682),-- [rp_sword_of_reflexion]
(20342,57,114,157,0,700000),-- [adena]
(20342,2371,1,1,1,646.127599),-- [fist_of_butcher]
(20342,255,1,1,1,302.872401),-- [fox's_nail]
(20342,1869,1,1,2,41999.100858),-- [iron_ore]
(20342,1864,1,1,2,83998.348713),-- [stem]
(20342,736,1,1,2,20999.550429),-- [scroll_of_escape]
(20343,1060,1,1,-1,404348),-- [lesser_healing_potion]
(20343,1795,1,1,-1,686629),-- [rp_leather_shoes]
(20343,2005,1,1,-1,12997),-- [broad_sword_blade]
(20343,57,98,132,0,700000),-- [adena]
(20343,113,1,1,1,11558.475515),-- [mage_earing]
(20343,906,1,1,1,8634.032525),-- [necklace_of_knowledge]
(20343,875,1,1,1,17062.49196),-- [ring_of_knowledge]
(20343,1869,1,1,2,35831.395795),-- [iron_ore]
(20343,1864,1,1,2,71662.79159),-- [stem]
(20343,1797,1,1,2,72386.812615),-- [rp_leather_hose]
(20345,2174,1,1,-1,96576),-- [rp_hard_leather_gaiters]
(20345,1925,1,1,-1,145655),-- [leather_gloves_lining]
(20345,5220,1,1,-1,8885),-- [reinforcing_agent]
(20345,57,110,171,0,700000),-- [adena]
(20345,24,1,1,1,420.5292),-- [bone_breastplate]
(20345,390,1,1,1,420.5292),-- [tights_shirt]
(20345,31,1,1,1,671.4708),-- [bone_gaiters]
(20345,412,1,1,1,671.4708),-- [tights_pants]
(20345,1866,1,1,2,17496.46539),-- [suede]
(20345,1871,1,1,2,26244.7596),-- [charcoal]
(20345,1800,1,1,2,8253.09846),-- [rp_piece_bone_breastplate]
(20345,5268,1,1,2,1049.81499),-- [rp_adv_comp_soulshot_d]
(20345,1831,1,1,2,69985.86156),-- [antidote]
(20346,1869,1,1,-1,201546),-- [iron_ore]
(20346,1803,1,1,-1,169366),-- [rp_necklace_of_wisdom]
(20346,1831,1,1,-1,537455),-- [antidote]
(20346,57,106,150,0,700000),-- [adena]
(20346,20,1,1,1,5563.90821),-- [buckler]
(20346,43,1,1,1,3891.09179),-- [wooden_helmet]
(20346,1866,1,1,2,26459.358156),-- [suede]
(20346,1871,1,1,2,39689.037234),-- [charcoal]
(20346,736,1,1,2,19844.60461),-- [scroll_of_escape]
(20348,1794,1,1,-1,14192),-- [rp_bow_of_forest]
(20348,1831,1,1,-1,514696),-- [antidote]
(20348,1896,1,1,-1,81784),-- [necklace_of_anguish_chain]
(20348,57,97,147,0,700000),-- [adena]
(20348,66,1,1,1,182.6943),-- [gladius]
(20348,1333,1,1,1,182.6943),-- [brandish]
(20348,2010,1,1,1,1478.6114),-- [brandish_blade]
(20348,1871,1,1,2,38008.369432),-- [charcoal]
(20348,1866,1,1,2,25338.95284),-- [suede]
(20348,1799,1,1,2,56308.677728),-- [rp_leather_gloves]
(20349,2009,1,1,-1,6357),-- [dirk_blade]
(20349,1794,1,1,-1,13182),-- [rp_bow_of_forest]
(20349,1921,1,1,-1,115664),-- [leather_shoes_texture]
(20349,57,94,133,0,700000),-- [adena]
(20349,23,1,1,1,1153.849158),-- [wooden_breastplate]
(20349,30,1,1,1,1848.575421),-- [hard_leather_pants]
(20349,2386,1,1,1,1848.575421),-- [wooden_gaiters]
(20349,1872,1,1,2,47072.526003),-- [animal_bone]
(20349,1867,1,1,2,47072.526003),-- [animal_skin]
(20349,1792,1,1,2,2595.947994),-- [rp_short_spear]
(20350,1866,1,1,-1,134620),-- [suede]
(20350,2150,1,1,-1,94803),-- [rp_blue_diamond_necklace]
(20350,1800,1,1,-1,63500),-- [rp_piece_bone_breastplate]
(20350,57,100,156,0,700000),-- [adena]
(20350,845,1,1,1,872.03469),-- [cat'seye_earing]
(20350,908,1,1,1,654.030985),-- [necklace_of_wisdom]
(20350,1897,1,1,1,7100.88229),-- [necklace_of_wisdom_chain]
(20350,877,1,1,1,1308.052035),-- [ring_of_wisdom]
(20350,1873,1,1,2,11929.468554),-- [silver_nugget]
(20350,1868,1,1,2,59647.252221),-- [thread]
(20350,2150,1,1,2,14001.682419),-- [rp_blue_diamond_necklace]
(20350,734,1,1,2,4970.596806),-- [quick_step_potion]
(20351,2173,1,1,-1,62245),-- [rp_hard_leather_shirt]
(20351,735,1,1,-1,19140),-- [swift_attack_potion]
(20351,1897,1,1,-1,54686),-- [necklace_of_wisdom_chain]
(20351,57,106,184,0,700000),-- [adena]
(20351,272,1,1,1,129.1923),-- [bow_of_forest]
(20351,2013,1,1,1,1463.8077),-- [bow_of_forest_shaft]
(20351,1864,1,1,2,67845.117483),-- [stem]
(20351,1869,1,1,2,33922.617105),-- [iron_ore]
(20351,1878,1,1,2,13569.046842),-- [braided_hemp]
(20351,2253,1,1,2,1390.21857),-- [rp_sword_breaker]
(20352,1878,1,1,-1,135435),-- [braided_hemp]
(20352,26,1,1,-1,1791),-- [bronze_breastplate]
(20352,57,154,276,0,700000),-- [adena]
(20352,68,1,1,1,106.5),-- [falchion]
(20352,5284,1,1,1,106.5),-- [zweihander]
(20352,1864,1,1,2,80010.969147),-- [stem]
(20352,1869,1,1,2,40005.414964),-- [iron_ore]
(20352,1878,1,1,2,16002.249517),-- [braided_hemp]
(20352,5163,1,1,2,1600.183186),-- [rp_comp_bspiritshot_d]
(20352,5273,1,1,2,1600.183186),-- [rp_adv_comp_spiritshot_d]
(20353,1878,1,1,-1,116185),-- [braided_hemp]
(20353,2256,1,1,-1,7102),-- [rp_assassin_knife]
(20353,1864,1,1,-1,580926),-- [stem]
(20353,57,132,236,0,700000),-- [adena]
(20353,16,1,1,1,183),-- [long_spear]
(20353,1864,1,1,2,68638.548303),-- [stem]
(20353,1869,1,1,2,34319.214436),-- [iron_ore]
(20353,1878,1,1,2,13727.757433),-- [braided_hemp]
(20353,3953,1,1,2,1372.739914),-- [rp_blessed_spiritshot_d]
(20353,5273,1,1,2,1372.739914),-- [rp_adv_comp_spiritshot_d]
(20356,1899,1,1,-1,66888),-- [necklace_of_devotion_chain]
(20356,1868,1,1,-1,856162),-- [thread]
(20356,1873,1,1,-1,171232),-- [silver_nugget]
(20356,57,188,353,0,700000),-- [adena]
(20356,220,1,1,1,153),-- [handiwork_dagger]
(20356,1868,1,1,2,120126.36384),-- [thread]
(20356,1873,1,1,2,24025.272768),-- [silver_nugget]
(20356,5549,1,1,2,6006.318192),-- [iron_thread]
(20356,2178,1,1,2,9610.0452),-- [rp_dark_hose]
(20357,1898,1,1,-1,37198),-- [blue_diamond_necklace_gem]
(20357,1804,1,1,-1,14485),-- [rp_soulshot_d]
(20357,1926,1,1,-1,36578),-- [piece_bone_breastplate_fragment]
(20357,57,164,295,0,700000),-- [adena]
(20357,68,1,1,1,114),-- [falchion]
(20357,5284,1,1,1,114),-- [zweihander]
(20357,1869,1,1,2,53483.185212),-- [iron_ore]
(20357,1864,1,1,2,106966.370424),-- [stem]
(20357,1880,1,1,2,5348.33766),-- [steel]
(20357,2176,1,1,2,25590.106704),-- [rp_leather_boots]
(20358,2140,1,1,-1,50651),-- [rp_high_grade_suede]
(20358,1924,1,1,-1,81695),-- [leather_helmet_design]
(20358,2141,1,1,-1,50651),-- [rp_silver_mold]
(20358,57,121,200,0,700000),-- [adena]
(20358,217,1,1,1,142.5),-- [shining_knife]
(20358,218,1,1,1,142.5),-- [throw_knife]
(20358,1871,1,1,2,49871.999886),-- [charcoal]
(20358,1866,1,1,2,33247.999924),-- [suede]
(20358,1800,1,1,2,15683.00019),-- [rp_piece_bone_breastplate]
(20359,1872,1,1,-1,348237),-- [animal_bone]
(20359,44,1,1,-1,6680),-- [leather_helmet]
(20359,1924,1,1,-1,84251),-- [leather_helmet_design]
(20359,57,122,208,0,700000),-- [adena]
(20359,176,1,1,1,147),-- [apprentice's_staff]
(20359,2501,1,1,1,147),-- [bone_club]
(20359,1870,1,1,2,38574.067424),-- [coal]
(20359,1865,1,1,2,38574.067424),-- [varnish]
(20359,2252,1,1,2,1580.876768),-- [rp_iron_hammer]
(20359,5268,1,1,2,1542.988384),-- [rp_adv_comp_soulshot_d]
(20360,2175,1,1,-1,193143),-- [rp_boots]
(20360,908,1,1,-1,5210),-- [necklace_of_wisdom]
(20360,1801,1,1,-1,119680),-- [rp_piece_bone_gaiters]
(20360,57,118,183,0,700000),-- [adena]
(20360,945,1,1,1,2658.14964),-- [skeleton_buckler]
(20360,102,1,1,1,1282.914271),-- [round_shield]
(20360,44,1,1,1,897.375937),-- [leather_helmet]
(20360,1924,1,1,1,11318.560152),-- [leather_helmet_design]
(20360,1872,1,1,2,46781.949852),-- [animal_bone]
(20360,1867,1,1,2,46781.949852),-- [animal_skin]
(20360,2173,1,1,2,9508.569712),-- [rp_hard_leather_shirt]
(20360,5273,1,1,2,1403.530584),-- [rp_adv_comp_spiritshot_d]
(20361,1790,1,1,-1,28303),-- [rp_dirk]
(20361,42,1,1,-1,43748),-- [leather_cap]
(20361,2005,1,1,-1,10937),-- [broad_sword_blade]
(20361,57,82,111,0,700000),-- [adena]
(20361,14,1,1,1,942.288438),-- [bow]
(20361,2007,1,1,1,3230.711562),-- [bow_shaft]
(20361,1864,1,1,2,45228.43336),-- [stem]
(20361,1869,1,1,2,22614.21668),-- [iron_ore]
(20361,1802,1,1,2,48632.82204),-- [rp_necklace_of_anguish]
(20361,735,1,1,2,1884.52792),-- [swift_attack_potion]
(20362,1799,1,1,-1,263305),-- [rp_leather_gloves]
(20362,1867,1,1,-1,236975),-- [animal_skin]
(20362,1792,1,1,-1,13068),-- [rp_short_spear]
(20362,57,95,131,0,700000),-- [adena]
(20362,37,1,1,1,3431.316663),-- [leather_shoes]
(20362,1921,1,1,1,22580.337231),-- [leather_shoes_texture]
(20362,49,1,1,1,3431.346106),-- [gloves]
(20362,1869,1,1,2,26249.586141),-- [iron_ore]
(20362,1864,1,1,2,52499.033271),-- [stem]
(20362,1792,1,1,2,1930.167735),-- [rp_short_spear]
(20362,1060,1,1,2,58332.212853),-- [lesser_healing_potion]
(20363,1867,1,1,-1,198456),-- [animal_skin]
(20363,2005,1,1,-1,10632),-- [broad_sword_blade]
(20363,2006,1,1,-1,10632),-- [willow_staff_head]
(20363,57,80,108,0,700000),-- [adena]
(20363,254,1,1,1,1832),-- [iron_glove]
(20363,1869,1,1,2,21982.72725),-- [iron_ore]
(20363,1864,1,1,2,43965.4545),-- [stem]
(20363,1814,1,1,2,11569.8648),-- [rp_leather]
(20363,735,1,1,2,1831.95345),-- [swift_attack_potion]
(20364,1867,1,1,-1,303119),-- [animal_skin]
(20364,2008,1,1,-1,8846),-- [cedar_staff_head]
(20364,1896,1,1,-1,96330),-- [necklace_of_anguish_chain]
(20364,57,116,172,0,700000),-- [adena]
(20364,2371,1,1,1,689.021212),-- [fist_of_butcher]
(20364,255,1,1,1,322.978788),-- [fox's_nail]
(20364,1870,1,1,2,44768.15956),-- [coal]
(20364,1865,1,1,2,44768.15956),-- [varnish]
(20364,1793,1,1,2,3291.68088),-- [rp_sword_of_reflexion]
(20365,1866,1,1,-1,83081),-- [suede]
(20365,1864,1,1,-1,249244),-- [stem]
(20365,1871,1,1,-1,124622),-- [charcoal]
(20365,57,67,91,0,700000),-- [adena]
(20365,22,1,1,1,3937.19964),-- [leather_shirt]
(20365,29,1,1,1,6292.80036),-- [leather_pants]
(20365,1871,1,1,2,24541),-- [charcoal]
(20365,1866,1,1,2,16360.650306),-- [suede]
(20365,1666,1,1,2,8180.349694),-- [rp_wooden_arrow]
(20367,1864,1,1,-1,459366),-- [stem]
(20367,1831,1,1,-1,612488),-- [antidote]
(20367,1896,1,1,-1,97323),-- [necklace_of_anguish_chain]
(20367,57,106,184,0,700000),-- [adena]
(20367,945,1,1,1,2569.8024),-- [skeleton_buckler]
(20367,102,1,1,1,1240.27486),-- [round_shield]
(20367,44,1,1,1,867.55042),-- [leather_helmet]
(20367,1924,1,1,1,10942.37232),-- [leather_helmet_design]
(20367,1864,1,1,2,54275.848704),-- [stem]
(20367,1869,1,1,2,27137.924352),-- [iron_ore]
(20367,1878,1,1,2,10855.188864),-- [braided_hemp]
(20367,5153,1,1,2,1085.528448),-- [rp_comp_soulshot_d]
(20367,735,1,1,2,2261.509632),-- [swift_attack_potion]
(20368,1873,1,1,-1,80618),-- [silver_nugget]
(20368,1833,1,1,-1,537455),-- [bandage]
(20368,1793,1,1,-1,14820),-- [rp_sword_of_reflexion]
(20368,57,106,150,0,700000),-- [adena]
(20368,271,1,1,1,572),-- [hunting_bow]
(20368,1866,1,1,2,26459.498633),-- [suede]
(20368,1871,1,1,2,39689.213416),-- [charcoal]
(20368,1793,1,1,2,2918.287951),-- [rp_sword_of_reflexion]
(20369,2143,1,1,-1,48728),-- [rp_synthesis_cokes]
(20369,390,1,1,-1,3124),-- [tights_shirt]
(20369,1897,1,1,-1,58010),-- [necklace_of_wisdom_chain]
(20369,57,119,191,0,700000),-- [adena]
(20369,1101,1,1,1,922.701996),-- [tunic_of_devotion]
(20369,1104,1,1,1,1473.298004),-- [hose_of_devotion]
(20369,1868,1,1,2,95957.48532),-- [thread]
(20369,1873,1,1,2,19191.497064),-- [silver_nugget]
(20369,2175,1,1,2,39007.017616),-- [rp_boots]
(20370,1864,1,1,-1,418191),-- [stem]
(20370,1922,1,1,-1,53341),-- [leather_tunic_pattern]
(20370,1794,1,1,-1,15375),-- [rp_bow_of_forest]
(20370,57,112,154,0,700000),-- [adena]
(20370,23,1,1,1,1345.562706),-- [wooden_breastplate]
(20370,30,1,1,1,2155.718647),-- [hard_leather_pants]
(20370,2386,1,1,1,2155.718647),-- [wooden_gaiters]
(20370,1864,1,1,2,82351.61649),-- [stem]
(20370,1869,1,1,2,41175.808245),-- [iron_ore]
(20370,1793,1,1,2,3027.575265),-- [rp_sword_of_reflexion]
(20371,1869,1,1,-1,196871),-- [iron_ore]
(20371,114,1,1,-1,14583),-- [earing_of_strength]
(20371,1896,1,1,-1,83420),-- [necklace_of_anguish_chain]
(20371,57,99,150,0,700000),-- [adena]
(20371,429,1,1,1,950.19645),-- [leather_tunic]
(20371,1922,1,1,1,7417.267288),-- [leather_tunic_pattern]
(20371,464,1,1,1,1522.27686),-- [leather_hose]
(20371,1923,1,1,1,11916.259402),-- [leather_hose_pattern]
(20371,1866,1,1,2,25845.756946),-- [suede]
(20371,1871,1,1,2,38768.635419),-- [charcoal]
(20371,1803,1,1,2,32578.607635),-- [rp_necklace_of_wisdom]
(20372,1870,1,1,-1,151631),-- [coal]
(20372,1864,1,1,-1,303261),-- [stem]
(20372,57,81,110,0,700000),-- [adena]
(20372,3,1,1,1,933.030392),-- [broad_sword]
(20372,2005,1,1,1,3198.969608),-- [broad_sword_blade]
(20372,1869,1,1,2,29859.483108),-- [iron_ore]
(20372,1864,1,1,2,59718.966216),-- [stem]
(20372,1814,1,1,2,15715.550676),-- [rp_leather]
(20373,1793,1,1,-1,12352),-- [rp_sword_of_reflexion]
(20373,1871,1,1,-1,167982),-- [charcoal]
(20373,1869,1,1,-1,167982),-- [iron_ore]
(20373,57,91,122,0,700000),-- [adena]
(20373,2371,1,1,1,508.595697),-- [fist_of_butcher]
(20373,255,1,1,1,238.404303),-- [fox's_nail]
(20373,1869,1,1,2,33079.61244),-- [iron_ore]
(20373,1864,1,1,2,66159.373126),-- [stem]
(20373,1799,1,1,2,49007.014434),-- [rp_leather_gloves]
(20374,2255,1,1,-1,9821),-- [rp_saber]
(20374,1871,1,1,-1,401688),-- [charcoal]
(20374,1898,1,1,-1,41262),-- [blue_diamond_necklace_gem]
(20374,57,182,327,0,700000),-- [adena]
(20374,257,1,1,1,252),-- [viper's_canine]
(20374,1873,1,1,2,23730.43641),-- [silver_nugget]
(20374,1868,1,1,2,118652.476308),-- [thread]
(20374,5273,1,1,2,2373.043641),-- [rp_adv_comp_spiritshot_d]
(20374,5158,1,1,2,2373.043641),-- [rp_comp_spiritshot_d]
(20375,2257,1,1,-1,7102),-- [rp_trident]
(20375,2014,1,1,-1,3339),-- [iron_hammer_head]
(20375,1804,1,1,-1,11619),-- [rp_soulshot_d]
(20375,57,132,236,0,700000),-- [adena]
(20375,16,1,1,1,183),-- [long_spear]
(20375,1865,1,1,2,34319.298816),-- [varnish]
(20375,1870,1,1,2,34319.298816),-- [coal]
(20375,1879,1,1,2,5719.883136),-- [cokes]
(20375,5158,1,1,2,1372.759616),-- [rp_comp_spiritshot_d]
(20378,1831,1,1,-1,537455),-- [antidote]
(20378,49,1,1,-1,19759),-- [gloves]
(20378,1896,1,1,-1,85401),-- [necklace_of_anguish_chain]
(20378,57,106,150,0,700000),-- [adena]
(20378,114,1,1,1,1763.923339),-- [earing_of_strength]
(20378,115,1,1,1,1763.923339),-- [earing_of_wisdom]
(20378,907,1,1,1,1322.946901),-- [necklace_of_anguish]
(20378,1896,1,1,1,10090.295032),-- [necklace_of_anguish_chain]
(20378,876,1,1,1,2645.911389),-- [ring_of_anguish]
(20378,1866,1,1,2,26459.358156),-- [suede]
(20378,1871,1,1,2,39689.037234),-- [charcoal]
(20378,736,1,1,2,19844.60461),-- [scroll_of_escape]
(20379,1792,1,1,-1,18424),-- [rp_short_spear]
(20379,1871,1,1,-1,250564),-- [charcoal]
(20379,1872,1,1,-1,334085),-- [animal_bone]
(20379,57,128,189,0,700000),-- [adena]
(20379,114,1,1,1,2192.993905),-- [earing_of_strength]
(20379,115,1,1,1,2192.993905),-- [earing_of_wisdom]
(20379,907,1,1,1,1644.750895),-- [necklace_of_anguish]
(20379,1896,1,1,1,12544.73764),-- [necklace_of_anguish_chain]
(20379,876,1,1,1,3289.523655),-- [ring_of_anguish]
(20379,1872,1,1,2,65788.941098),-- [animal_bone]
(20379,1867,1,1,2,65788.941098),-- [animal_skin]
(20379,1794,1,1,2,3628.117804),-- [rp_bow_of_forest]
(20380,1869,1,1,-1,267071),-- [iron_ore]
(20380,1873,1,1,-1,106828),-- [silver_nugget]
(20380,1866,1,1,-1,178047),-- [suede]
(20380,57,132,206,0,700000),-- [adena]
(20380,176,1,1,1,150.5),-- [apprentice's_staff]
(20380,2501,1,1,1,150.5),-- [bone_club]
(20380,1871,1,1,2,52592.26824),-- [charcoal]
(20380,1866,1,1,2,35061.47532),-- [suede]
(20380,2174,1,1,2,22866.25644),-- [rp_hard_leather_gaiters]
(20381,1867,1,1,-1,198210),-- [animal_skin]
(20381,2006,1,1,-1,10618),-- [willow_staff_head]
(20381,1875,1,1,-1,9910),-- [stone_of_purity]
(20381,57,80,108,0,700000),-- [adena]
(20381,99,1,1,1,1830),-- [apprentice's_spellbook]
(20381,1865,1,1,2,29273.970726),-- [varnish]
(20381,1870,1,1,2,29273.970726),-- [coal]
(20381,2136,1,1,2,8610.058548),-- [rp_cokes]
(20382,1870,1,1,-1,167982),-- [coal]
(20382,2008,1,1,-1,6536),-- [cedar_staff_head]
(20382,1831,1,1,-1,447952),-- [antidote]
(20382,57,91,122,0,700000),-- [adena]
(20382,20,1,1,1,4637.08056),-- [buckler]
(20382,43,1,1,1,3242.91944),-- [wooden_helmet]
(20382,1866,1,1,2,22052.91146),-- [suede]
(20382,1871,1,1,2,33079.36719),-- [charcoal]
(20382,1803,1,1,2,27797.72135),-- [rp_necklace_of_wisdom]
(20385,1060,1,1,-1,285245),-- [lesser_healing_potion]
(20385,2005,1,1,-1,9169),-- [broad_sword_blade]
(20385,57,69,94,0,700000),-- [adena]
(20385,14,1,1,1,789.869388),-- [bow]
(20385,2007,1,1,1,2708.130612),-- [bow_shaft]
(20385,1873,1,1,2,10110.924824),-- [silver_nugget]
(20385,1868,1,1,2,50554.689458),-- [thread]
(20385,1790,1,1,2,4672.385718),-- [rp_dirk]
(20386,1060,1,1,-1,404348),-- [lesser_healing_potion]
(20386,1796,1,1,-1,228876),-- [rp_leather_tunic]
(20386,1666,1,1,-1,60652),-- [rp_wooden_arrow]
(20386,57,98,132,0,700000),-- [adena]
(20386,3,1,1,1,1119.771954),-- [broad_sword]
(20386,2005,1,1,1,3839.228046),-- [broad_sword_blade]
(20386,1869,1,1,2,26873.64),-- [iron_ore]
(20386,1864,1,1,2,53747.28),-- [stem]
(20386,1666,1,1,2,8957.88),-- [rp_wooden_arrow]
(20386,17,10,30,2,134368.2),-- [wooden_arrow]
(20387,1833,1,1,-1,568739),-- [bandage]
(20387,1794,1,1,-1,15682),-- [rp_bow_of_forest]
(20387,1896,1,1,-1,90372),-- [necklace_of_anguish_chain]
(20387,57,114,157,0,700000),-- [adena]
(20387,66,1,1,1,201.91485),-- [gladius]
(20387,1333,1,1,1,201.91485),-- [brandish]
(20387,2010,1,1,1,1634.1703),-- [brandish_blade]
(20387,1869,1,1,2,41999.291874),-- [iron_ore]
(20387,1864,1,1,2,83998.583748),-- [stem]
(20387,1794,1,1,2,3088.124378),-- [rp_bow_of_forest]
(20388,1833,1,1,-1,537542),-- [bandage]
(20388,1880,1,1,-1,20158),-- [steel]
(20388,57,109,147,0,700000),-- [adena]
(20388,37,1,1,1,3891.653613),-- [leather_shoes]
(20388,1921,1,1,1,25609.659381),-- [leather_shoes_texture]
(20388,49,1,1,1,3891.687006),-- [gloves]
(20388,1869,1,1,2,29771.46667),-- [iron_ore]
(20388,1864,1,1,2,59542.93334),-- [stem]
(20388,736,1,1,2,14885.733335),-- [scroll_of_escape]
(20388,735,1,1,2,2480.866655),-- [swift_attack_potion]
(20389,734,1,1,-1,32995),-- [quick_step_potion]
(20389,2011,1,1,-1,4516),-- [short_spear_edge]
(20389,1872,1,1,-1,263962),-- [animal_bone]
(20389,57,98,153,0,700000),-- [adena]
(20389,945,1,1,1,2215.09728),-- [skeleton_buckler]
(20389,102,1,1,1,1069.081992),-- [round_shield]
(20389,44,1,1,1,747.804024),-- [leather_helmet]
(20389,1924,1,1,1,9432.016704),-- [leather_helmet_design]
(20389,1867,1,1,2,38985.053753),-- [animal_skin]
(20389,1872,1,1,2,38985.053753),-- [animal_bone]
(20389,2175,1,1,2,23771.41189),-- [rp_boots]
(20389,5158,1,1,2,1169.480604),-- [rp_comp_spiritshot_d]
(20390,1881,1,1,-1,28140),-- [coarse_bone_powder]
(20390,1897,1,1,-1,50249),-- [necklace_of_wisdom_chain]
(20390,1873,1,1,-1,84419),-- [silver_nugget]
(20390,57,101,167,0,700000),-- [adena]
(20390,2,1,1,1,59.336423),-- [long_sword]
(20390,120,1,1,1,59.336423),-- [sword_of_reflexion]
(20390,2012,1,1,1,648.990731),-- [sword_of_reflexion_blade]
(20390,121,1,1,1,59.336423),-- [sword_of_watershadow]
(20390,1868,1,1,2,49871.97819),-- [thread]
(20390,1873,1,1,2,9974.395638),-- [silver_nugget]
(20390,1801,1,1,2,12562.174206),-- [rp_piece_bone_gaiters]
(20390,5158,1,1,2,997.44732),-- [rp_comp_spiritshot_d]
(20390,734,1,1,2,4156.004646),-- [quick_step_potion]
(20392,1798,1,1,-1,227072),-- [rp_leather_helmet]
(20392,1833,1,1,-1,617635),-- [bandage]
(20392,1831,1,1,-1,617635),-- [antidote]
(20392,57,116,177,0,700000),-- [adena]
(20392,23,1,1,1,1490.418228),-- [wooden_breastplate]
(20392,30,1,1,1,2387.790886),-- [hard_leather_pants]
(20392,2386,1,1,1,2387.790886),-- [wooden_gaiters]
(20392,1869,1,1,2,34207.459451),-- [iron_ore]
(20392,1864,1,1,2,68415.114645),-- [stem]
(20392,736,1,1,2,17103.827597),-- [scroll_of_escape]
(20392,1060,1,1,2,76016.598307),-- [lesser_healing_potion]
(20393,2252,1,1,-1,9736),-- [rp_iron_hammer]
(20393,1897,1,1,-1,56563),-- [necklace_of_wisdom_chain]
(20393,57,118,183,0,700000),-- [adena]
(20393,217,1,1,1,133.5),-- [shining_knife]
(20393,218,1,1,1,133.5),-- [throw_knife]
(20393,1867,1,1,2,62376.36144),-- [animal_skin]
(20393,1872,1,1,2,62376.36144),-- [animal_bone]
(20393,2252,1,1,2,1917.27712),-- [rp_iron_hammer]
(20400,1803,1,1,-1,175710),-- [rp_necklace_of_wisdom]
(20400,1923,1,1,-1,85695),-- [leather_hose_pattern]
(20400,1921,1,1,-1,134900),-- [leather_shoes_texture]
(20400,57,112,154,0,700000),-- [adena]
(20400,114,1,1,1,1830.019062),-- [earing_of_strength]
(20400,115,1,1,1,1830.019062),-- [earing_of_wisdom]
(20400,907,1,1,1,1372.518858),-- [necklace_of_anguish]
(20400,1896,1,1,1,10468.387056),-- [necklace_of_anguish_chain]
(20400,876,1,1,1,2745.055962),-- [ring_of_anguish]
(20400,1864,1,1,2,82351.173385),-- [stem]
(20400,1869,1,1,2,41175.66864),-- [iron_ore]
(20400,1798,1,1,2,40368.157975),-- [rp_leather_helmet]
(20401,2151,1,1,-1,105333),-- [rp_necklace_of_devotion]
(20401,1873,1,1,-1,151258),-- [silver_nugget]
(20401,1866,1,1,-1,252096),-- [suede]
(20401,57,173,305,0,700000),-- [adena]
(20401,87,1,1,1,59.4008),-- [iron_hammer]
(20401,2014,1,1,1,641.79842),-- [iron_hammer_head]
(20401,155,1,1,1,59.4008),-- [buzdygan]
(20401,177,1,1,1,59.39998),-- [mage_staff]
(20401,1866,1,1,2,37232.78645),-- [suede]
(20401,1871,1,1,2,55849.22845),-- [charcoal]
(20401,5153,1,1,2,2233.99255),-- [rp_comp_soulshot_d]
(20401,5158,1,1,2,2233.99255),-- [rp_comp_spiritshot_d]
(20402,2179,1,1,-1,194917),-- [rp_excellence_leather_gloves]
(20402,1880,1,1,-1,40738),-- [steel]
(20402,1871,1,1,-1,407376),-- [charcoal]
(20402,57,181,334,0,700000),-- [adena]
(20402,25,1,1,1,327.716196),-- [piece_bone_breastplate]
(20402,1926,1,1,1,4051.787503),-- [piece_bone_breastplate_fragment]
(20402,26,1,1,1,212.127426),-- [bronze_breastplate]
(20402,32,1,1,1,524.352693),-- [piece_bone_gaiters]
(20402,1928,1,1,1,5843.074468),-- [piece_bone_gaiters_fragment]
(20402,34,1,1,1,339.941714),-- [bronze_gaiters]
(20402,1866,1,1,2,40110.92374),-- [suede]
(20402,1871,1,1,2,60166.38561),-- [charcoal]
(20402,2256,1,1,2,1471.08522),-- [rp_assassin_knife]
(20402,5158,1,1,2,2406.60543),-- [rp_comp_spiritshot_d]
(20403,1868,1,1,-1,475131),-- [thread]
(20403,2012,1,1,-1,4949),-- [sword_of_reflexion_blade]
(20403,734,1,1,-1,39594),-- [quick_step_potion]
(20403,57,118,183,0,700000),-- [adena]
(20403,38,1,1,1,1795.866945),-- [low_boots]
(20403,50,1,1,1,1795.866945),-- [leather_gloves]
(20403,1925,1,1,1,30677.26611),-- [leather_gloves_lining]
(20403,1867,1,1,2,37425.875256),-- [animal_skin]
(20403,1872,1,1,2,37425.875256),-- [animal_bone]
(20403,2253,1,1,2,1150.400328),-- [rp_sword_breaker]
(20403,5268,1,1,2,1122.746856),-- [rp_adv_comp_soulshot_d]
(20403,735,1,1,2,2339.102304),-- [swift_attack_potion]
(20404,2253,1,1,-1,8276),-- [rp_sword_breaker]
(20404,735,1,1,-1,16828),-- [swift_attack_potion]
(20404,1897,1,1,-1,48079),-- [necklace_of_wisdom_chain]
(20404,57,100,156,0,700000),-- [adena]
(20404,1101,1,1,1,764.810586),-- [tunic_of_devotion]
(20404,1104,1,1,1,1221.189414),-- [hose_of_devotion]
(20404,1866,1,1,2,19882.56029),-- [suede]
(20404,1871,1,1,2,29823.813728),-- [charcoal]
(20404,2254,1,1,2,1222.272562),-- [rp_composition_bow]
(20404,6035,1,1,2,2485.35342),-- [potion_of_acumen2]
(20410,1868,1,1,-1,472491),-- [thread]
(20410,2009,1,1,-1,8377),-- [dirk_blade]
(20410,1792,1,1,-1,17371),-- [rp_short_spear]
(20410,57,119,180,0,700000),-- [adena]
(20410,9,1,1,1,223.71135),-- [cedar_staff]
(20410,2008,1,1,1,1810.5773),-- [cedar_staff_head]
(20410,154,1,1,1,223.71135),-- [dwarven_mace]
(20410,1867,1,1,2,62029.60084),-- [animal_skin]
(20410,1872,1,1,2,62029.60084),-- [animal_bone]
(20410,1793,1,1,2,3420.79832),-- [rp_sword_of_reflexion]
(20411,735,1,1,-1,21105),-- [swift_attack_potion]
(20411,2141,1,1,-1,50651),-- [rp_silver_mold]
(20411,1897,1,1,-1,60299),-- [necklace_of_wisdom_chain]
(20411,57,121,200,0,700000),-- [adena]
(20411,217,1,1,1,142.5),-- [shining_knife]
(20411,218,1,1,1,142.5),-- [throw_knife]
(20411,1864,1,1,2,59846.45251),-- [stem]
(20411,1869,1,1,2,29923.14247),-- [iron_ore]
(20411,1878,1,1,2,11969.35753),-- [braided_hemp]
(20411,1817,1,1,2,5984.59498),-- [rp_cord]
(20411,6037,1,1,2,59846.45251),-- [scroll_of_awake]
(20415,2144,1,1,-1,45114),-- [rp_compound_braid]
(20415,1865,1,1,-1,225572),-- [varnish]
(20415,735,1,1,-1,18798),-- [swift_attack_potion]
(20415,57,110,177,0,700000),-- [adena]
(20415,309,1,1,1,127),-- [tears_of_eva]
(20415,310,1,1,1,127),-- [relic_of_saints]
(20415,1864,1,1,2,44420.332616),-- [stem]
(20415,1865,1,1,2,22210.166308),-- [varnish]
(20415,1866,1,1,2,14806.822756),-- [suede]
(20415,1873,1,1,2,8884.120784),-- [silver_nugget]
(20415,1868,1,1,2,44420.332616),-- [thread]
(20415,2253,1,1,2,910.22492),-- [rp_sword_breaker]
(20416,2254,1,1,-1,9514),-- [rp_composition_bow]
(20416,102,1,1,-1,8488),-- [round_shield]
(20416,1924,1,1,-1,74887),-- [leather_helmet_design]
(20416,57,111,183,0,700000),-- [adena]
(20416,1101,1,1,1,879.185583),-- [tunic_of_devotion]
(20416,1104,1,1,1,1403.814417),-- [hose_of_devotion]
(20416,1866,1,1,2,22858.0191),-- [suede]
(20416,1871,1,1,2,34287.094024),-- [charcoal]
(20416,2139,1,1,2,6857.40573),-- [rp_steel_mold]
(20416,5268,1,1,2,1371.481146),-- [rp_adv_comp_soulshot_d]
(20418,1872,1,1,-1,334331),-- [animal_bone]
(20418,1800,1,1,-1,78852),-- [rp_piece_bone_breastplate]
(20418,1925,1,1,-1,164425),-- [leather_gloves_lining]
(20418,57,120,198,0,700000),-- [adena]
(20418,845,1,1,1,1082.867838),-- [cat'seye_earing]
(20418,908,1,1,1,812.157047),-- [necklace_of_wisdom]
(20418,1897,1,1,1,8817.673358),-- [necklace_of_wisdom_chain]
(20418,877,1,1,1,1624.301757),-- [ring_of_wisdom]
(20418,1867,1,1,2,49378.310415),-- [animal_skin]
(20418,1872,1,1,2,49378.310415),-- [animal_bone]
(20418,1882,1,1,2,8229.661206),-- [leather]
(20418,2140,1,1,2,7406.717964),-- [rp_high_grade_suede]
(20420,1868,1,1,-1,580926),-- [thread]
(20420,1866,1,1,-1,193642),-- [suede]
(20420,1804,1,1,-1,11619),-- [rp_soulshot_d]
(20420,57,132,236,0,700000),-- [adena]
(20420,1102,1,1,1,604.334152),-- [tunic_of_magicpower]
(20420,1105,1,1,1,969.665848),-- [hose_of_magicpower]
(20420,1864,1,1,2,57198.813617),-- [stem]
(20420,1865,1,1,2,28599.319485),-- [varnish]
(20420,1866,1,1,2,19066.21299),-- [suede]
(20420,1873,1,1,2,11439.727794),-- [silver_nugget]
(20420,1868,1,1,2,57198.813617),-- [thread]
(20420,5163,1,1,2,1144.112497),-- [rp_comp_bspiritshot_d]
(20421,1866,1,1,-1,205204),-- [suede]
(20421,1929,1,1,-1,39717),-- [hard_leather_gaiters_material]
(20421,1898,1,1,-1,31619),-- [blue_diamond_necklace_gem]
(20421,57,140,251,0,700000),-- [adena]
(20421,273,1,1,1,96.708612),-- [composition_bow]
(20421,2016,1,1,1,1065.291388),-- [composition_bow_shaft]
(20421,1869,1,1,2,30307.070768),-- [iron_ore]
(20421,1870,1,1,2,30307.070768),-- [coal]
(20421,1871,1,1,2,30307.070768),-- [charcoal]
(20421,1872,1,1,2,40409.37004),-- [animal_bone]
(20421,1867,1,1,2,40409.37004),-- [animal_skin]
(20421,5278,1,1,2,1212.047616),-- [rp_adv_comp_bspiritshot_d]
(20422,1869,1,1,-1,248908),-- [iron_ore]
(20422,2013,1,1,-1,5372),-- [bow_of_forest_shaft]
(20422,1864,1,1,-1,497816),-- [stem]
(20422,57,121,195,0,700000),-- [adena]
(20422,176,1,1,1,140),-- [apprentice's_staff]
(20422,2501,1,1,1,140),-- [bone_club]
(20422,1869,1,1,2,36761.673864),-- [iron_ore]
(20422,1864,1,1,2,73523.234466),-- [stem]
(20422,2254,1,1,2,1506.611124),-- [rp_composition_bow]
(20422,5273,1,1,2,1470.480546),-- [rp_adv_comp_spiritshot_d]
(20423,1792,1,1,-1,14067),-- [rp_short_spear]
(20423,1921,1,1,-1,123424),-- [leather_shoes_texture]
(20423,1793,1,1,-1,14067),-- [rp_sword_of_reflexion]
(20423,57,98,145,0,700000),-- [adena]
(20423,271,1,1,1,543),-- [hunting_bow]
(20423,1872,1,1,2,75345.5),-- [animal_bone]
(20423,1867,1,1,2,75345.5),-- [animal_skin]
(20424,2142,1,1,-1,45599),-- [rp_varnish_of_purity]
(20424,1880,1,1,-1,22799),-- [steel]
(20424,1870,1,1,-1,227995),-- [coal]
(20424,57,107,182,0,700000),-- [adena]
(20424,2,1,1,1,64.143606),-- [long_sword]
(20424,120,1,1,1,64.143606),-- [sword_of_reflexion]
(20424,2012,1,1,1,701.569182),-- [sword_of_reflexion_blade]
(20424,121,1,1,1,64.143606),-- [sword_of_watershadow]
(20424,1870,1,1,2,44897.4846),-- [coal]
(20424,1865,1,1,2,44897.4846),-- [varnish]
(20424,2253,1,1,2,1840.0308),-- [rp_sword_breaker]
(20425,1869,1,1,-1,177731),-- [iron_ore]
(20425,1831,1,1,-1,473949),-- [antidote]
(20425,57,95,131,0,700000),-- [adena]
(20425,66,1,1,1,168.22935),-- [gladius]
(20425,1333,1,1,1,168.22935),-- [brandish]
(20425,2010,1,1,1,1361.5413),-- [brandish_blade]
(20425,1871,1,1,2,34999.299401),-- [charcoal]
(20425,1866,1,1,2,23332.902995),-- [suede]
(20425,1799,1,1,2,51850.797604),-- [rp_leather_gloves]
(20426,1796,1,1,-1,224389),-- [rp_leather_tunic]
(20426,2005,1,1,-1,12742),-- [broad_sword_blade]
(20426,57,96,130,0,700000),-- [adena]
(20426,113,1,1,1,11331.990825),-- [mage_earing]
(20426,906,1,1,1,8464.851375),-- [necklace_of_knowledge]
(20426,875,1,1,1,16728.1578),-- [ring_of_knowledge]
(20426,1873,1,1,2,10538.69033),-- [silver_nugget]
(20426,1868,1,1,2,52693.71071),-- [thread]
(20426,2137,1,1,2,7749.13225),-- [rp_steel]
(20426,1060,1,1,2,58548.46671),-- [lesser_healing_potion]
(20427,1866,1,1,-1,99105),-- [suede]
(20427,1060,1,1,-1,330350),-- [lesser_healing_potion]
(20427,1666,1,1,-1,49552),-- [rp_wooden_arrow]
(20427,57,80,108,0,700000),-- [adena]
(20427,254,1,1,1,1830),-- [iron_glove]
(20427,1864,1,1,2,58548.013776),-- [stem]
(20427,1869,1,1,2,29273.958672),-- [iron_ore]
(20427,2138,1,1,2,8610.027552),-- [rp_coarse_bone_powder]
(20428,1831,1,1,-1,594351),-- [antidote]
(20428,1864,1,1,-1,445764),-- [stem]
(20428,1896,1,1,-1,94441),-- [necklace_of_anguish_chain]
(20428,57,114,168,0,700000),-- [adena]
(20428,114,1,1,1,1950.676353),-- [earing_of_strength]
(20428,115,1,1,1,1950.676353),-- [earing_of_wisdom]
(20428,907,1,1,1,1463.012127),-- [necklace_of_anguish]
(20428,1896,1,1,1,11158.591464),-- [necklace_of_anguish_chain]
(20428,876,1,1,1,2926.043703),-- [ring_of_anguish]
(20428,1864,1,1,2,37620.446542),-- [stem]
(20428,1865,1,1,2,18810.223271),-- [varnish]
(20428,1866,1,1,2,12540.212895),-- [suede]
(20428,1873,1,1,2,7524.127737),-- [silver_nugget]
(20428,1868,1,1,2,37620.446542),-- [thread]
(20428,1799,1,1,2,27867.075719),-- [rp_leather_gloves]
(20428,1833,1,1,2,50160.467294),-- [bandage]
(20429,2009,1,1,-1,6586),-- [dirk_blade]
(20429,1792,1,1,-1,13657),-- [rp_short_spear]
(20429,1921,1,1,-1,119829),-- [leather_shoes_texture]
(20429,57,95,140,0,700000),-- [adena]
(20429,429,1,1,1,896.468475),-- [leather_tunic]
(20429,1922,1,1,1,6997.864804),-- [leather_tunic_pattern]
(20429,464,1,1,1,1436.20113),-- [leather_hose]
(20429,1923,1,1,1,11242.465591),-- [leather_hose_pattern]
(20429,1868,1,1,2,73151.06274),-- [thread]
(20429,1873,1,1,2,14630.212548),-- [silver_nugget]
(20429,1803,1,1,2,30735.724712),-- [rp_necklace_of_wisdom]
(20432,1871,1,1,-1,15920),-- [charcoal]
(20432,1873,1,1,-1,6368),-- [silver_nugget]
(20432,57,8,12,0,700000),-- [adena]
(20432,11,1,1,1,5579),-- [bone_dagger]
(20432,1864,1,1,2,4702.406639),-- [stem]
(20432,1865,1,1,2,2351.21727),-- [varnish]
(20432,1866,1,1,2,1567.47818),-- [suede]
(20432,1873,1,1,2,940.486908),-- [silver_nugget]
(20432,1868,1,1,2,4702.406639),-- [thread]
(20432,1787,1,1,2,1880.973816),-- [rp_willow_staff]
(20432,17,10,30,2,11756.030548),-- [wooden_arrow]
(20433,1864,1,1,-1,430270),-- [stem]
(20433,1865,1,1,-1,215135),-- [varnish]
(20433,1921,1,1,-1,138797),-- [leather_shoes_texture]
(20433,57,113,160,0,700000),-- [adena]
(20433,429,1,1,1,1038.348675),-- [leather_tunic]
(20433,1922,1,1,1,8105.386692),-- [leather_tunic_pattern]
(20433,464,1,1,1,1663.50249),-- [leather_hose]
(20433,1923,1,1,1,13021.762143),-- [leather_hose_pattern]
(20433,1870,1,1,2,31773.902352),-- [coal]
(20433,1865,1,1,2,31773.902352),-- [varnish]
(20433,1794,1,1,2,2336.324412),-- [rp_bow_of_forest]
(20433,735,1,1,2,2647.870884),-- [swift_attack_potion]
(20435,1871,1,1,-1,194922),-- [charcoal]
(20435,1793,1,1,-1,14332),-- [rp_sword_of_reflexion]
(20435,1833,1,1,-1,519792),-- [bandage]
(20435,57,98,149,0,700000),-- [adena]
(20435,216,1,1,1,276.86541),-- [dirk]
(20435,2009,1,1,1,2042.13459),-- [dirk_blade]
(20435,1872,1,1,2,51179.286523),-- [animal_bone]
(20435,1867,1,1,2,51179.286523),-- [animal_skin]
(20435,1794,1,1,2,2822.426954),-- [rp_bow_of_forest]
(20436,1869,1,1,-1,378144),-- [iron_ore]
(20436,2016,1,1,-1,4431),-- [composition_bow_shaft]
(20436,1898,1,1,-1,38844),-- [blue_diamond_necklace_gem]
(20436,57,173,305,0,700000),-- [adena]
(20436,16,1,1,1,238),-- [long_spear]
(20436,1870,1,1,2,74465.184164),-- [coal]
(20436,1865,1,1,2,74465.184164),-- [varnish]
(20436,5158,1,1,2,2978.631672),-- [rp_comp_spiritshot_d]
(20437,2258,1,1,-1,8355),-- [rp_temptation_of_abyss]
(20437,2016,1,1,-1,4004),-- [composition_bow_shaft]
(20437,1804,1,1,-1,13669),-- [rp_soulshot_d]
(20437,57,156,278,0,700000),-- [adena]
(20437,39,1,1,1,1416.686112),-- [boots]
(20437,1930,1,1,1,17254.607688),-- [boots_lining]
(20437,51,1,1,1,1416.7062),-- [bracer]
(20437,1871,1,1,2,50469.751278),-- [charcoal]
(20437,1866,1,1,2,33646.500852),-- [suede]
(20437,5268,1,1,2,2018.748114),-- [rp_adv_comp_soulshot_d]
(20437,5437,1,1,2,1233.999756),-- [rp_heavy_sword]
(20438,1865,1,1,-1,450915),-- [varnish]
(20438,1869,1,1,-1,450915),-- [iron_ore]
(20438,1899,1,1,-1,70456),-- [necklace_of_devotion_chain]
(20438,57,196,374,0,700000),-- [adena]
(20438,291,1,1,1,80.352954),-- [trident]
(20438,2019,1,1,1,2721.647046),-- [trident_edge]
(20438,1875,1,1,2,3374.22699),-- [stone_of_purity]
(20438,1879,1,1,2,8435.53183),-- [cokes]
(20438,5549,1,1,2,5061.30484),-- [iron_thread]
(20438,2180,1,1,2,3805.53149),-- [rp_scale_mail]
(20438,6666,1,1,2,50613.40485),-- [key_of_treasure_box2]
(20439,2255,1,1,-1,9765),-- [rp_saber]
(20439,2015,1,1,-1,4871),-- [sword_breaker_edge]
(20439,2151,1,1,-1,111250),-- [rp_necklace_of_devotion]
(20439,57,177,327,0,700000),-- [adena]
(20439,25,1,1,1,321.277308),-- [piece_bone_breastplate]
(20439,1926,1,1,1,3972.178969),-- [piece_bone_breastplate_fragment]
(20439,26,1,1,1,207.959598),-- [bronze_breastplate]
(20439,32,1,1,1,514.050339),-- [piece_bone_gaiters]
(20439,1928,1,1,1,5728.271164),-- [piece_bone_gaiters_fragment]
(20439,34,1,1,1,333.262622),-- [bronze_gaiters]
(20439,1873,1,1,2,31459.53048),-- [silver_nugget]
(20439,1868,1,1,2,157297.46172),-- [thread]
(20439,2257,1,1,2,1923.0078),-- [rp_trident]
(20442,1786,1,1,-1,44845),-- [rp_broad_sword]
(20442,1864,1,1,-1,112112),-- [stem]
(20442,5549,1,1,-1,5606),-- [iron_thread]
(20442,57,30,42,0,700000),-- [adena]
(20442,4,1,1,1,9822.5),-- [club]
(20442,7,1,1,1,9822.5),-- [apprentice's_rod]
(20442,1868,1,1,2,28976.533208),-- [thread]
(20442,1873,1,1,2,5795.25912),-- [silver_nugget]
(20442,1787,1,1,2,11590.637044),-- [rp_willow_staff]
(20442,17,10,30,2,72441.570628),-- [wooden_arrow]
(20446,1870,1,1,-1,77741),-- [coal]
(20446,2007,1,1,-1,5553),-- [bow_shaft]
(20446,1869,1,1,-1,77741),-- [iron_ore]
(20446,57,41,58,0,700000),-- [adena]
(20446,22,1,1,1,2455.842708),-- [leather_shirt]
(20446,29,1,1,1,3925.157292),-- [leather_pants]
(20446,1869,1,1,2,15308.750172),-- [iron_ore]
(20446,1864,1,1,2,30617.500344),-- [stem]
(20446,1791,1,1,2,2829.749484),-- [rp_brandish]
(20447,1797,1,1,-1,259314),-- [rp_leather_hose]
(20447,2138,1,1,-1,37753),-- [rp_coarse_bone_powder]
(20447,1060,1,1,-1,285245),-- [lesser_healing_potion]
(20447,57,69,94,0,700000),-- [adena]
(20447,14,1,1,1,789.869388),-- [bow]
(20447,2007,1,1,1,2708.130612),-- [bow_shaft]
(20447,1873,1,1,2,10110.924824),-- [silver_nugget]
(20447,1868,1,1,2,50554.689458),-- [thread]
(20447,1791,1,1,2,4672.385718),-- [rp_brandish]
(20448,1666,1,1,-1,32439),-- [rp_wooden_arrow]
(20448,2006,1,1,-1,6951),-- [willow_staff_head]
(20448,1789,1,1,-1,17988),-- [rp_cedar_staff]
(20448,57,51,72,0,700000),-- [adena]
(20448,3,1,1,1,598.837512),-- [broad_sword]
(20448,2005,1,1,1,2053.162488),-- [broad_sword_blade]
(20448,1866,1,1,2,19164),-- [suede]
(20448,1871,1,1,2,28746),-- [charcoal]
(20449,1873,1,1,-1,92414),-- [silver_nugget]
(20449,115,1,1,-1,17114),-- [earing_of_wisdom]
(20449,1896,1,1,-1,97896),-- [necklace_of_anguish_chain]
(20449,57,116,177,0,700000),-- [adena]
(20449,429,1,1,1,1115.08425),-- [leather_tunic]
(20449,1922,1,1,1,8704.38732),-- [leather_tunic_pattern]
(20449,464,1,1,1,1786.4379),-- [leather_hose]
(20449,1923,1,1,1,13984.09053),-- [leather_hose_pattern]
(20449,1873,1,1,2,18198.408555),-- [silver_nugget]
(20449,1868,1,1,2,90992.350365),-- [thread]
(20449,1798,1,1,2,44604.24108),-- [rp_leather_helmet]
(20450,1870,1,1,-1,124035),-- [coal]
(20450,1666,1,1,-1,41345),-- [rp_wooden_arrow]
(20450,57,67,90,0,700000),-- [adena]
(20450,152,1,1,1,590.996927),-- [heavy_chisel]
(20450,5,1,1,1,381.685127),-- [mace]
(20450,8,1,1,1,381.685127),-- [willow_staff]
(20450,2006,1,1,1,1308.632819),-- [willow_staff_head]
(20450,1869,1,1,2,24425.32266),-- [iron_ore]
(20450,1864,1,1,2,48850.72578),-- [stem]
(20450,2135,1,1,2,7183.95156),-- [rp_braided_hemp]
(20455,1869,1,1,-1,189449),-- [iron_ore]
(20455,1794,1,1,-1,13930),-- [rp_bow_of_forest]
(20455,1896,1,1,-1,80275),-- [necklace_of_anguish_chain]
(20455,57,97,143,0,700000),-- [adena]
(20455,20,1,1,1,5229.661794),-- [buckler]
(20455,43,1,1,1,3657.338206),-- [wooden_helmet]
(20455,1868,1,1,2,74613.77445),-- [thread]
(20455,1873,1,1,2,14922.75489),-- [silver_nugget]
(20455,736,1,1,2,18653.47066),-- [scroll_of_escape]
(20456,1872,1,1,-1,51475),-- [animal_bone]
(20456,1788,1,1,-1,30885),-- [rp_bow]
(20456,1868,1,1,-1,77212),-- [thread]
(20456,57,19,29,0,700000),-- [adena]
(20456,308,1,1,1,13530),-- [buffalo_horn]
(20456,1868,1,1,2,19956.305542),-- [thread]
(20456,1873,1,1,2,3991.22838),-- [silver_nugget]
(20456,1788,1,1,2,7982.538581),-- [rp_bow]
(20456,17,10,30,2,49890.927497),-- [wooden_arrow]
(20457,1866,1,1,-1,195744),-- [suede]
(20457,2013,1,1,-1,6337),-- [bow_of_forest_shaft]
(20457,1864,1,1,-1,587232),-- [stem]
(20457,57,138,234,0,700000),-- [adena]
(20457,15,1,1,1,165.218784),-- [short_spear]
(20457,2011,1,1,1,1978.781216),-- [short_spear_edge]
(20457,1869,1,1,2,34691.766272),-- [iron_ore]
(20457,1864,1,1,2,69383.532544),-- [stem]
(20457,1880,1,1,2,3469.198698),-- [steel]
(20457,2254,1,1,2,1421.800936),-- [rp_composition_bow]
(20457,5273,1,1,2,1387.70155),-- [rp_adv_comp_spiritshot_d]
(20458,2256,1,1,-1,10153),-- [rp_assassin_knife]
(20458,2176,1,1,-1,198681),-- [rp_leather_boots]
(20458,1898,1,1,-1,42655),-- [blue_diamond_necklace_gem]
(20458,57,188,339,0,700000),-- [adena]
(20458,846,1,1,1,997.234861),-- [coral_earing]
(20458,909,1,1,1,747.928531),-- [blue_diamond_necklace]
(20458,1898,1,1,1,6299.970005),-- [blue_diamond_necklace_gem]
(20458,878,1,1,1,1495.866603),-- [blue_coral_ring]
(20458,1869,1,1,2,35044.738992),-- [iron_ore]
(20458,1864,1,1,2,70089.477984),-- [stem]
(20458,1880,1,1,2,3504.429696),-- [steel]
(20458,1804,1,1,2,1401.830816),-- [rp_soulshot_d]
(20458,5437,1,1,2,856.80536),-- [rp_heavy_sword]
(20458,5268,1,1,2,1401.830816),-- [rp_adv_comp_soulshot_d]
(20458,6666,1,1,2,35044.886336),-- [key_of_treasure_box2]
(20460,1833,1,1,-1,629988),-- [bandage]
(20460,1866,1,1,-1,157497),-- [suede]
(20460,1792,1,1,-1,17371),-- [rp_short_spear]
(20460,57,119,180,0,700000),-- [adena]
(20460,66,1,1,1,223.71135),-- [gladius]
(20460,1333,1,1,1,223.71135),-- [brandish]
(20460,2010,1,1,1,1810.5773),-- [brandish_blade]
(20460,1867,1,1,2,62029.689849),-- [animal_skin]
(20460,1872,1,1,2,62029.689849),-- [animal_bone]
(20460,1799,1,1,2,68921.620302),-- [rp_leather_gloves]
(20461,1803,1,1,-1,165438),-- [rp_necklace_of_wisdom]
(20461,2010,1,1,-1,7660),-- [brandish_blade]
(20461,1896,1,1,-1,83420),-- [necklace_of_anguish_chain]
(20461,57,99,150,0,700000),-- [adena]
(20461,66,1,1,1,186.360075),-- [gladius]
(20461,1333,1,1,1,186.360075),-- [brandish]
(20461,2010,1,1,1,1508.27985),-- [brandish_blade]
(20461,1867,1,1,2,51691.284512),-- [animal_skin]
(20461,1872,1,1,2,51691.284512),-- [animal_bone]
(20461,1803,1,1,2,32578.430976),-- [rp_necklace_of_wisdom]
(20462,1865,1,1,-1,209166),-- [varnish]
(20462,1872,1,1,-1,278888),-- [animal_bone]
(20462,1800,1,1,-1,65776),-- [rp_piece_bone_breastplate]
(20462,57,102,164,0,700000),-- [adena]
(20462,256,1,1,1,235),-- [cestus]
(20462,1867,1,1,2,54919.581544),-- [animal_skin]
(20462,1872,1,1,2,54919.581544),-- [animal_bone]
(20462,1800,1,1,2,12952.836912),-- [rp_piece_bone_breastplate]
(20463,2010,1,1,-1,7185),-- [brandish_blade]
(20463,1921,1,1,-1,119134),-- [leather_shoes_texture]
(20463,1799,1,1,-1,273567),-- [rp_leather_gloves]
(20463,57,97,137,0,700000),-- [adena]
(20463,271,1,1,1,524),-- [hunting_bow]
(20463,1864,1,1,2,72726.49462),-- [stem]
(20463,1869,1,1,2,36363.31968),-- [iron_ore]
(20463,1798,1,1,2,35650.1857),-- [rp_leather_helmet]
(20464,464,1,1,-1,9305),-- [leather_hose]
(20464,1874,1,1,-1,11849),-- [oriharukon_ore]
(20464,1870,1,1,-1,177731),-- [coal]
(20464,57,95,131,0,700000),-- [adena]
(20464,9,1,1,1,168.22935),-- [cedar_staff]
(20464,2008,1,1,1,1361.5413),-- [cedar_staff_head]
(20464,154,1,1,1,168.22935),-- [dwarven_mace]
(20464,1870,1,1,2,34999.37811),-- [coal]
(20464,1865,1,1,2,34999.37811),-- [varnish]
(20464,1803,1,1,2,29411.24378),-- [rp_necklace_of_wisdom]
(20466,1868,1,1,-1,501999),-- [thread]
(20466,1897,1,1,-1,59762),-- [necklace_of_wisdom_chain]
(20466,734,1,1,-1,41833),-- [quick_step_potion]
(20466,57,122,197,0,700000),-- [adena]
(20466,24,1,1,1,475.2134),-- [bone_breastplate]
(20466,390,1,1,1,475.2134),-- [tights_shirt]
(20466,31,1,1,1,758.7866),-- [bone_gaiters]
(20466,412,1,1,1,758.7866),-- [tights_pants]
(20466,1867,1,1,2,49427.823354),-- [animal_skin]
(20466,1872,1,1,2,49427.823354),-- [animal_bone]
(20466,1801,1,1,2,18675.557866),-- [rp_piece_bone_gaiters]
(20466,5158,1,1,2,1482.795426),-- [rp_comp_spiritshot_d]
(20468,1814,1,1,-1,40916),-- [rp_leather]
(20468,1790,1,1,-1,14370),-- [rp_dirk]
(20468,2005,1,1,-1,5553),-- [broad_sword_blade]
(20468,57,41,58,0,700000),-- [adena]
(20468,99,1,1,1,957),-- [apprentice's_spellbook]
(20468,1869,1,1,2,15308.847872),-- [iron_ore]
(20468,1864,1,1,2,30617.79944),-- [stem]
(20468,1795,1,1,2,57769.352688),-- [rp_leather_shoes]
(20469,1864,1,1,-1,256721),-- [stem]
(20469,2007,1,1,-1,9169),-- [bow_shaft]
(20469,1666,1,1,-1,42787),-- [rp_wooden_arrow]
(20469,57,69,94,0,700000),-- [adena]
(20469,14,1,1,1,789.869388),-- [bow]
(20469,2007,1,1,1,2708.130612),-- [bow_shaft]
(20469,1873,1,1,2,7583.157568),-- [silver_nugget]
(20469,1868,1,1,2,37915.452658),-- [thread]
(20469,1795,1,1,2,71538.564624),-- [rp_leather_shoes]
(20469,1833,1,1,2,50553.82515),-- [bandage]
(20470,1791,1,1,-1,17988),-- [rp_brandish]
(20470,1060,1,1,-1,216259),-- [lesser_healing_potion]
(20470,2006,1,1,-1,6951),-- [willow_staff_head]
(20470,57,51,72,0,700000),-- [adena]
(20470,19,1,1,1,11732.93531),-- [small_shield]
(20470,42,1,1,1,8213.06469),-- [leather_cap]
(20470,1869,1,1,2,14372.956064),-- [iron_ore]
(20470,1864,1,1,2,28745.960672),-- [stem]
(20470,2135,1,1,2,4227.357152),-- [rp_braided_hemp]
(20470,735,1,1,2,1197.726112),-- [swift_attack_potion]
(20471,1797,1,1,-1,367589),-- [rp_leather_hose]
(20471,428,1,1,-1,19461),-- [feriotic_tunic]
(20471,1869,1,1,-1,181957),-- [iron_ore]
(20471,57,98,132,0,700000),-- [adena]
(20471,3,1,1,1,1119.771954),-- [broad_sword]
(20471,2005,1,1,1,3839.228046),-- [broad_sword_blade]
(20471,1869,1,1,2,35831.4),-- [iron_ore]
(20471,1864,1,1,2,71662.8),-- [stem]
(20471,1666,1,1,2,11943.8),-- [rp_wooden_arrow]
(20472,1867,1,1,-1,284370),-- [animal_skin]
(20472,1864,1,1,-1,426554),-- [stem]
(20472,1922,1,1,-1,54407),-- [leather_tunic_pattern]
(20472,57,114,157,0,700000),-- [adena]
(20472,66,1,1,1,201.91485),-- [gladius]
(20472,1333,1,1,1,201.91485),-- [brandish]
(20472,2010,1,1,1,1634.1703),-- [brandish_blade]
(20472,1869,1,1,2,41999.100858),-- [iron_ore]
(20472,1864,1,1,2,83998.348713),-- [stem]
(20472,736,1,1,2,20999.550429),-- [scroll_of_escape]
(20473,23,1,1,-1,6588),-- [wooden_breastplate]
(20473,1831,1,1,-1,537542),-- [antidote]
(20473,1896,1,1,-1,85415),-- [necklace_of_anguish_chain]
(20473,57,109,147,0,700000),-- [adena]
(20473,9,1,1,1,190.81845),-- [cedar_staff]
(20473,2008,1,1,1,1544.3631),-- [cedar_staff_head]
(20473,154,1,1,1,190.81845),-- [dwarven_mace]
(20473,1869,1,1,2,39695.424795),-- [iron_ore]
(20473,1864,1,1,2,79390.84959),-- [stem]
(20473,1792,1,1,2,2918.725615),-- [rp_short_spear]
(20474,1866,1,1,-1,154409),-- [suede]
(20474,1799,1,1,-1,343131),-- [rp_leather_gloves]
(20474,1792,1,1,-1,17030),-- [rp_short_spear]
(20474,57,116,177,0,700000),-- [adena]
(20474,216,1,1,1,328.91945),-- [dirk]
(20474,2009,1,1,1,2426.08055),-- [dirk_blade]
(20474,1869,1,1,2,22805.004222),-- [iron_ore]
(20474,1870,1,1,2,22805.004222),-- [coal]
(20474,1871,1,1,2,22805.004222),-- [charcoal]
(20474,1872,1,1,2,30406.672296),-- [animal_bone]
(20474,1867,1,1,2,30406.672296),-- [animal_skin]
(20474,736,1,1,2,11402.642742),-- [scroll_of_escape]
(20475,426,1,1,-1,68329),-- [tunic]
(20475,1786,1,1,-1,30885),-- [rp_broad_sword]
(20475,1873,1,1,-1,15442),-- [silver_nugget]
(20475,57,19,29,0,700000),-- [adena]
(20475,253,1,1,1,13530),-- [spike_glove]
(20475,1868,1,1,2,26608.75),-- [thread]
(20475,1873,1,1,2,5321.75),-- [silver_nugget]
(20475,1786,1,1,2,10643.5),-- [rp_broad_sword]
(20476,1866,1,1,-1,158377),-- [suede]
(20476,945,1,1,-1,17997),-- [skeleton_buckler]
(20476,5549,1,1,-1,23757),-- [iron_thread]
(20476,57,118,183,0,700000),-- [adena]
(20476,2,1,1,1,66.798319),-- [long_sword]
(20476,120,1,1,1,66.798319),-- [sword_of_reflexion]
(20476,2012,1,1,1,730.605043),-- [sword_of_reflexion_blade]
(20476,121,1,1,1,66.798319),-- [sword_of_watershadow]
(20476,1868,1,1,2,70173.35463),-- [thread]
(20476,1873,1,1,2,14034.690255),-- [silver_nugget]
(20476,1800,1,1,2,11033.57307),-- [rp_piece_bone_breastplate]
(20476,5273,1,1,2,1403.382045),-- [rp_adv_comp_spiritshot_d]
(20477,1872,1,1,-1,102628),-- [animal_bone]
(20477,906,1,1,-1,18547),-- [necklace_of_knowledge]
(20477,1060,1,1,-1,171046),-- [lesser_healing_potion]
(20477,57,41,58,0,700000),-- [adena]
(20477,12,1,1,1,473.5),-- [knife]
(20477,215,1,1,1,473.5),-- [doomed_dagger]
(20477,1866,1,1,2,7578.695835),-- [suede]
(20477,1871,1,1,2,11368.075533),-- [charcoal]
(20477,1796,1,1,2,14299.445292),-- [rp_leather_tunic]
(20477,1833,1,1,2,30314.78334),-- [bandage]
(20478,1801,1,1,-1,136366),-- [rp_piece_bone_gaiters]
(20478,735,1,1,-1,22557),-- [swift_attack_potion]
(20478,1897,1,1,-1,64449),-- [necklace_of_wisdom_chain]
(20478,57,132,212,0,700000),-- [adena]
(20478,217,1,1,1,152.5),-- [shining_knife]
(20478,218,1,1,1,152.5),-- [throw_knife]
(20478,1869,1,1,2,26652.16661),-- [iron_ore]
(20478,1864,1,1,2,53304.33322),-- [stem]
(20478,1817,1,1,2,5330.390945),-- [rp_cord]
(20478,6037,1,1,2,53304.33322),-- [scroll_of_awake]
(20478,735,1,1,2,2220.97857),-- [swift_attack_potion]
(20478,1831,1,1,2,71072.797435),-- [antidote]
(20479,1793,1,1,-1,17199),-- [rp_sword_of_reflexion]
(20479,1922,1,1,-1,59670),-- [leather_tunic_pattern]
(20479,1792,1,1,-1,17199),-- [rp_short_spear]
(20479,57,118,179,0,700000),-- [adena]
(20479,9,1,1,1,221.432625),-- [cedar_staff]
(20479,2008,1,1,1,1792.13475),-- [cedar_staff_head]
(20479,154,1,1,1,221.432625),-- [dwarven_mace]
(20479,1872,1,1,2,46061.6742),-- [animal_bone]
(20479,1867,1,1,2,46061.6742),-- [animal_skin]
(20479,1792,1,1,2,2540.116413),-- [rp_short_spear]
(20479,1833,1,1,2,92123.535187),-- [bandage]
(20480,1864,1,1,-1,356778),-- [stem]
(20480,2007,1,1,-1,12742),-- [bow_shaft]
(20480,2005,1,1,-1,12742),-- [broad_sword_blade]
(20480,57,96,130,0,700000),-- [adena]
(20480,22,1,1,1,5635.622124),-- [leather_shirt]
(20480,29,1,1,1,9007.377876),-- [leather_pants]
(20480,1864,1,1,2,70257.73112),-- [stem]
(20480,1869,1,1,2,35128.86556),-- [iron_ore]
(20480,1789,1,1,2,6493.40332),-- [rp_cedar_staff]
(20481,1788,1,1,-1,12736),-- [rp_bow]
(20481,1786,1,1,-1,12736),-- [rp_broad_sword]
(20481,1868,1,1,-1,31839),-- [thread]
(20481,57,8,12,0,700000),-- [adena]
(20481,426,1,1,1,14565.04902),-- [tunic]
(20481,462,1,1,1,23180.95098),-- [hose]
(20481,1868,1,1,2,8229.25348),-- [thread]
(20481,1873,1,1,2,1645.8372),-- [silver_nugget]
(20481,1786,1,1,2,3291.70814),-- [rp_broad_sword]
(20481,17,10,30,2,20573.20118),-- [wooden_arrow]
(20483,1868,1,1,-1,490926),-- [thread]
(20483,1833,1,1,-1,654568),-- [bandage]
(20483,57,120,192,0,700000),-- [adena]
(20483,845,1,1,1,1060.046598),-- [cat'seye_earing]
(20483,908,1,1,1,795.040987),-- [necklace_of_wisdom]
(20483,1897,1,1,1,8631.842518),-- [necklace_of_wisdom_chain]
(20483,877,1,1,1,1590.069897),-- [ring_of_wisdom]
(20483,1864,1,1,2,41432.064125),-- [stem]
(20483,1865,1,1,2,20715.966738),-- [varnish]
(20483,1866,1,1,2,13810.644492),-- [suede]
(20483,1873,1,1,2,8286.412825),-- [silver_nugget]
(20483,1868,1,1,2,41432.064125),-- [thread]
(20483,2139,1,1,2,4143.141088),-- [rp_steel_mold]
(20483,5268,1,1,2,828.706607),-- [rp_adv_comp_soulshot_d]
(20487,2136,1,1,-1,58227),-- [rp_cokes]
(20487,1060,1,1,-1,439936),-- [lesser_healing_potion]
(20487,1897,1,1,-1,47136),-- [necklace_of_wisdom_chain]
(20487,57,98,153,0,700000),-- [adena]
(20487,217,1,1,1,111.5),-- [shining_knife]
(20487,218,1,1,1,111.5),-- [throw_knife]
(20487,1870,1,1,2,38985.22495),-- [coal]
(20487,1865,1,1,2,38985.22495),-- [varnish]
(20487,1800,1,1,2,12259.5501),-- [rp_piece_bone_breastplate]
(20488,734,1,1,-1,34178),-- [quick_step_potion]
(20488,412,1,1,-1,4198),-- [tights_pants]
(20488,1800,1,1,-1,64486),-- [rp_piece_bone_breastplate]
(20488,57,100,161,0,700000),-- [adena]
(20488,256,1,1,1,231),-- [cestus]
(20488,1869,1,1,2,40382.1875),-- [iron_ore]
(20488,1864,1,1,2,80764.375),-- [stem]
(20488,2140,1,1,2,8076.4375),-- [rp_high_grade_suede]
(20489,1060,1,1,-1,433160),-- [lesser_healing_potion]
(20489,1872,1,1,-1,259896),-- [animal_bone]
(20489,1896,1,1,-1,82594),-- [necklace_of_anguish_chain]
(20489,57,98,149,0,700000),-- [adena]
(20489,429,1,1,1,940.78425),-- [leather_tunic]
(20489,1922,1,1,1,7343.79532),-- [leather_tunic_pattern]
(20489,464,1,1,1,1507.1979),-- [leather_hose]
(20489,1923,1,1,1,11798.22253),-- [leather_hose_pattern]
(20489,1868,1,1,2,76769.632706),-- [thread]
(20489,1873,1,1,2,15353.907552),-- [silver_nugget]
(20489,1793,1,1,2,2822.459742),-- [rp_sword_of_reflexion]
(20491,1794,1,1,-1,14476),-- [rp_bow_of_forest]
(20491,876,1,1,-1,21875),-- [ring_of_anguish]
(20491,1803,1,1,-1,165438),-- [rp_necklace_of_wisdom]
(20491,57,99,150,0,700000),-- [adena]
(20491,37,1,1,1,3800.868174),-- [leather_shoes]
(20491,1921,1,1,1,25012.231038),-- [leather_shoes_texture]
(20491,49,1,1,1,3800.900788),-- [gloves]
(20491,1866,1,1,2,25845.774035),-- [suede]
(20491,1871,1,1,2,38768.62732),-- [charcoal]
(20491,1794,1,1,2,2850.598645),-- [rp_bow_of_forest]
(20492,1879,1,1,-1,47461),-- [cokes]
(20492,25,1,1,-1,2327),-- [piece_bone_breastplate]
(20492,1865,1,1,-1,284768),-- [varnish]
(20492,57,130,231,0,700000),-- [adena]
(20492,27,1,1,1,296.171659),-- [hard_leather_shirt]
(20492,1927,1,1,1,3355.070918),-- [hard_leather_shirt_pattern]
(20492,33,1,1,1,475.204432),-- [hard_leather_gaiters]
(20492,1929,1,1,1,5426.552991),-- [hard_leather_gaiters_material]
(20492,1865,1,1,2,33646.376214),-- [varnish]
(20492,1870,1,1,2,33646.376214),-- [coal]
(20492,1879,1,1,2,5607.729369),-- [cokes]
(20492,5278,1,1,2,1345.837032),-- [rp_adv_comp_bspiritshot_d]
(20492,5437,1,1,2,822.681171),-- [rp_heavy_sword]
(20494,1881,1,1,-1,99048),-- [coarse_bone_powder]
(20494,2179,1,1,-1,355437),-- [rp_excellence_leather_gloves]
(20494,1804,1,1,-1,29714),-- [rp_soulshot_d]
(20494,57,330,609,0,700000),-- [adena]
(20494,257,1,1,1,467),-- [viper's_canine]
(20494,1871,1,1,2,87772.020798),-- [charcoal]
(20494,1866,1,1,2,58514.733618),-- [suede]
(20494,2258,1,1,2,2146.00155),-- [rp_temptation_of_abyss]
(20494,5268,1,1,2,3510.84261),-- [rp_adv_comp_soulshot_d]
(20494,735,1,1,2,7314.401424),-- [swift_attack_potion]
(20495,2267,1,1,-1,11668),-- [rp_gastraphetes]
(20495,1936,1,1,-1,92328),-- [white_tunic_pattern]
(20495,1900,1,1,-1,123441),-- [enchanted_necklace_chain]
(20495,57,476,952,0,700000),-- [adena]
(20495,69,1,1,1,49.770308),-- [bastard_sword]
(20495,125,1,1,1,49.770308),-- [spinebone_sword]
(20495,2021,1,1,1,1556.915256),-- [spinebone_sword_blade]
(20495,126,1,1,1,49.770308),-- [artisan's_sword]
(20495,128,1,1,1,49.77382),-- [knight's_sword]
(20495,1875,1,1,2,4566.991248),-- [stone_of_purity]
(20495,1879,1,1,2,11417.438544),-- [cokes]
(20495,1885,1,1,2,5708.679696),-- [high_grade_suede]
(20495,5550,1,1,2,913.41408),-- [reinforcing_plate]
(20495,5549,1,1,2,6850.447296),-- [iron_thread]
(20495,955,1,1,2,274.024224),-- [scrl_of_ench_wp_d]
(20495,2274,1,1,2,489.317664),-- [rp_skull_breaker]
(20495,2975,1,1,2,6116.4708),-- [rp_brigandine_helmet]
(20495,6667,1,1,2,42815.216448),-- [key_of_treasure_box3]
(20496,1885,1,1,-1,74420),-- [high_grade_suede]
(20496,465,1,1,-1,5934),-- [cursed_hose]
(20496,2152,1,1,-1,157224),-- [rp_enchanted_necklace]
(20496,57,386,743,0,700000),-- [adena]
(20496,274,1,1,1,318),-- [strengthening_bow]
(20496,1876,1,1,2,14319.932005),-- [mithril_ore]
(20496,1880,1,1,2,7160.027259),-- [steel]
(20496,1877,1,1,2,2863.986401),-- [admantite_nugget]
(20496,1881,1,1,2,9546.580499),-- [coarse_bone_powder]
(20496,1882,1,1,2,15911.008336),-- [leather]
(20496,2260,1,1,2,1111.805475),-- [rp_mace_of_judgment]
(20496,6666,1,1,2,71599.660025),-- [key_of_treasure_box2]
(20497,2259,1,1,-1,14293),-- [rp_spinebone_sword]
(20497,2018,1,1,-1,12232),-- [assassin_knife_edge]
(20497,1899,1,1,-1,143825),-- [necklace_of_devotion_chain]
(20497,57,395,773,0,700000),-- [adena]
(20497,391,1,1,1,1071.760172),-- [puma_skin_shirt]
(20497,413,1,1,1,1716.239828),-- [puma_skin_gaiters]
(20497,1874,1,1,2,5740.05696),-- [oriharukon_ore]
(20497,1878,1,1,2,34440.134388),-- [braided_hemp]
(20497,1884,1,1,2,52984.790232),-- [cord]
(20497,1889,1,1,2,5740.05696),-- [compound_braid]
(20497,5220,1,1,2,3444.034176),-- [reinforcing_agent]
(20497,2261,1,1,2,1336.927284),-- [rp_conjure_staff]
(20498,2262,1,1,-1,13331),-- [rp_elven_bow]
(20498,3953,1,1,-1,34341),-- [rp_blessed_spiritshot_d]
(20498,1885,1,1,-1,71544),-- [high_grade_suede]
(20498,57,371,714,0,700000),-- [adena]
(20498,626,1,1,1,1900.693228),-- [bronze_shield]
(20498,45,1,1,1,1332.846619),-- [bone_helmet]
(20498,1932,1,1,1,25493.460153),-- [bone_helmet_design]
(20498,1875,1,1,2,5353.64103),-- [stone_of_purity]
(20498,1879,1,1,2,13384.120464),-- [cokes]
(20498,1885,1,1,2,6692.060232),-- [high_grade_suede]
(20498,5550,1,1,2,1070.728206),-- [reinforcing_plate]
(20498,5549,1,1,2,8030.479434),-- [iron_thread]
(20498,2261,1,1,2,1246.970634),-- [rp_conjure_staff]
(20499,1870,1,1,-1,822258),-- [coal]
(20499,2017,1,1,-1,10927),-- [saber_blade]
(20499,1880,1,1,-1,82226),-- [steel]
(20499,57,357,682,0,700000),-- [adena]
(20499,40,1,1,1,1433.150976),-- [leather_boots]
(20499,1931,1,1,1,15080.849024),-- [leather_boots_lining]
(20499,604,1,1,1,1433.150976),-- [excellence_leather_gloves]
(20499,1934,1,1,1,15080.849024),-- [excellence_leather_gloves_lining]
(20499,1876,1,1,2,15382.46241),-- [mithril_ore]
(20499,1880,1,1,2,7691.26257),-- [steel]
(20499,1877,1,1,2,3076.46739),-- [admantite_nugget]
(20499,1881,1,1,2,10254.97494),-- [coarse_bone_powder]
(20499,1882,1,1,2,17091.66672),-- [leather]
(20499,2182,1,1,2,9233.16597),-- [rp_scale_gaiters]
(20500,1867,1,3,-1,520412),-- [animal_skin]
(20500,1932,1,1,-1,123908),-- [bone_helmet_design]
(20500,1931,1,1,-1,102042),-- [leather_boots_lining]
(20500,57,344,644,0,700000),-- [adena]
(20500,847,1,1,1,1058.232864),-- [red_cresent_earing]
(20500,910,1,1,1,793.674648),-- [necklace_of_devotion]
(20500,1899,1,1,1,17113.722639),-- [necklace_of_devotion_chain]
(20500,890,1,1,1,1587.369849),-- [ring_of_devotion]
(20500,1874,1,1,2,7301.729204),-- [oriharukon_ore]
(20500,1878,1,1,2,43810.489612),-- [braided_hemp]
(20500,5220,1,1,2,4381.0604),-- [reinforcing_agent]
(20500,2262,1,1,2,1700.720784),-- [rp_elven_bow]
(20501,1870,1,1,-1,944489),-- [coal]
(20501,1933,1,1,-1,111116),-- [dark_hose_fabric]
(20501,2153,1,1,-1,146888),-- [rp_tiger'seye_earing]
(20501,57,400,793,0,700000),-- [adena]
(20501,433,1,1,1,167.79194),-- [elven_tunic]
(20501,434,1,1,1,167.79194),-- [white_tunic]
(20501,1936,1,1,1,5279.73866),-- [white_tunic_pattern]
(20501,435,1,1,1,167.79194),-- [mage's_tunic]
(20501,466,1,1,1,268.82444),-- [elven_hose]
(20501,467,1,1,1,268.82444),-- [dark_hose]
(20501,1933,1,1,1,7590.39802),-- [dark_hose_fabric]
(20501,468,1,1,1,268.83862),-- [mage's_hose]
(20501,1875,1,1,2,4915.479114),-- [stone_of_purity]
(20501,1879,1,1,2,12288.714282),-- [cokes]
(20501,1885,1,1,2,6144.340644),-- [high_grade_suede]
(20501,5550,1,1,2,983.089224),-- [reinforcing_plate]
(20501,5549,1,1,2,7373.235168),-- [iron_thread]
(20501,2264,1,1,2,762.49134),-- [rp_two-handed_sword]
(20501,2274,1,1,2,526.650228),-- [rp_skull_breaker]
(20502,1871,1,1,-1,233906),-- [charcoal]
(20502,1896,1,1,-1,99113),-- [necklace_of_anguish_chain]
(20502,1923,1,1,-1,95863),-- [leather_hose_pattern]
(20502,57,118,179,0,700000),-- [adena]
(20502,23,1,1,1,1505.165424),-- [wooden_breastplate]
(20502,30,1,1,1,2411.417288),-- [hard_leather_pants]
(20502,2386,1,1,1,2411.417288),-- [wooden_gaiters]
(20502,1868,1,1,2,92122.987782),-- [thread]
(20502,1873,1,1,2,18424.535274),-- [silver_nugget]
(20502,1798,1,1,2,45158.476944),-- [rp_leather_helmet]
(20504,2010,1,1,-1,7372),-- [brandish_blade]
(20504,1792,1,1,-1,13930),-- [rp_short_spear]
(20504,1921,1,1,-1,122225),-- [leather_shoes_texture]
(20504,57,97,143,0,700000),-- [adena]
(20504,20,1,1,1,5229.661794),-- [buckler]
(20504,43,1,1,1,3657.338206),-- [wooden_helmet]
(20504,1870,1,1,2,37306.96039),-- [coal]
(20504,1865,1,1,2,37306.96039),-- [varnish]
(20504,1792,1,1,2,2743.07922),-- [rp_short_spear]
(20505,734,1,1,-1,45036),-- [quick_step_potion]
(20505,1800,1,1,-1,84973),-- [rp_piece_bone_breastplate]
(20505,1869,1,1,-1,270215),-- [iron_ore]
(20505,57,125,217,0,700000),-- [adena]
(20505,217,1,1,1,152),-- [shining_knife]
(20505,218,1,1,1,152),-- [throw_knife]
(20505,1864,1,1,2,63853.898514),-- [stem]
(20505,1869,1,1,2,31926.89115),-- [iron_ore]
(20505,1878,1,1,2,12770.75646),-- [braided_hemp]
(20505,1817,1,1,2,6385.37823),-- [rp_cord]
(20505,5273,1,1,2,1277.075646),-- [rp_adv_comp_spiritshot_d]
(20506,2150,1,1,-1,115530),-- [rp_blue_diamond_necklace]
(20506,1924,1,1,-1,79380),-- [leather_helmet_design]
(20506,1864,1,1,-1,492156),-- [stem]
(20506,57,120,193,0,700000),-- [adena]
(20506,24,1,1,1,465.971),-- [bone_breastplate]
(20506,390,1,1,1,465.971),-- [tights_shirt]
(20506,31,1,1,1,744.029),-- [bone_gaiters]
(20506,412,1,1,1,744.029),-- [tights_pants]
(20506,1864,1,1,2,72687.660136),-- [stem]
(20506,1869,1,1,2,36343.830068),-- [iron_ore]
(20506,2141,1,1,2,7268.718912),-- [rp_silver_mold]
(20506,5273,1,1,2,1453.790884),-- [rp_adv_comp_spiritshot_d]
(20507,3032,1,1,-1,13942),-- [rp_spiritshot_d]
(20507,1866,1,1,-1,232371),-- [suede]
(20507,1898,1,1,-1,35804),-- [blue_diamond_necklace_gem]
(20507,57,159,283,0,700000),-- [adena]
(20507,273,1,1,1,109.525416),-- [composition_bow]
(20507,2016,1,1,1,1206.474584),-- [composition_bow_shaft]
(20507,1864,1,1,2,82366.143021),-- [stem]
(20507,1869,1,1,2,41182.999852),-- [iron_ore]
(20507,1878,1,1,2,16473.285931),-- [braided_hemp]
(20507,1804,1,1,2,1647.285598),-- [rp_soulshot_d]
(20507,5273,1,1,2,1647.285598),-- [rp_adv_comp_spiritshot_d]
(20508,1866,1,1,-1,167333),-- [suede]
(20508,1800,1,1,-1,78931),-- [rp_piece_bone_breastplate]
(20508,57,122,197,0,700000),-- [adena]
(20508,1101,1,1,1,950.429268),-- [tunic_of_devotion]
(20508,1104,1,1,1,1517.570732),-- [hose_of_devotion]
(20508,1867,1,1,2,65903.681388),-- [animal_skin]
(20508,1872,1,1,2,65903.681388),-- [animal_bone]
(20508,2142,1,1,2,9885.637224),-- [rp_varnish_of_purity]
(20509,1060,1,1,-1,330759),-- [lesser_healing_potion]
(20509,1129,1,1,-1,63337),-- [crude_leather_shoes]
(20509,2005,1,1,-1,10632),-- [broad_sword_blade]
(20509,57,80,108,0,700000),-- [adena]
(20509,428,1,1,1,2351.158612),-- [feriotic_tunic]
(20509,1100,1,1,1,2351.158612),-- [cotton_tunic]
(20509,463,1,1,1,3757.841388),-- [feriotic_hose]
(20509,1103,1,1,1,3757.841388),-- [cotton_hose]
(20509,1864,1,1,2,43965.66228),-- [stem]
(20509,1869,1,1,2,21982.739976),-- [iron_ore]
(20509,2136,1,1,2,6465.533208),-- [rp_cokes]
(20509,17,10,30,2,109914.064536),-- [wooden_arrow]
(20510,1798,1,1,-1,202966),-- [rp_leather_helmet]
(20510,1923,1,1,-1,84846),-- [leather_hose_pattern]
(20510,1792,1,1,-1,15222),-- [rp_short_spear]
(20510,57,110,152,0,700000),-- [adena]
(20510,23,1,1,1,1332.242658),-- [wooden_breastplate]
(20510,30,1,1,1,2134.378671),-- [hard_leather_pants]
(20510,2386,1,1,1,2134.378671),-- [wooden_gaiters]
(20510,1868,1,1,2,81536.099801),-- [thread]
(20510,1873,1,1,2,16307.199792),-- [silver_nugget]
(20510,1792,1,1,2,2997.700407),-- [rp_short_spear]
(20511,734,1,1,-1,40780),-- [quick_step_potion]
(20511,2144,1,1,-1,48936),-- [rp_compound_braid]
(20511,1897,1,1,-1,58257),-- [necklace_of_wisdom_chain]
(20511,57,115,195,0,700000),-- [adena]
(20511,176,1,1,1,137.5),-- [apprentice's_staff]
(20511,2501,1,1,1,137.5),-- [bone_club]
(20511,1869,1,1,2,20649.965745),-- [iron_ore]
(20511,1870,1,1,2,20649.965745),-- [coal]
(20511,1871,1,1,2,20649.965745),-- [charcoal]
(20511,1872,1,1,2,27533.28766),-- [animal_bone]
(20511,1867,1,1,2,27533.28766),-- [animal_skin]
(20511,1800,1,1,2,6493.728274),-- [rp_piece_bone_breastplate]
(20511,735,1,1,2,1720.799171),-- [swift_attack_potion]
(20514,1872,1,1,-1,308818),-- [animal_bone]
(20514,1870,1,1,-1,231613),-- [coal]
(20514,57,116,177,0,700000),-- [adena]
(20514,20,1,1,1,6393.63963),-- [buckler]
(20514,43,1,1,1,4471.36037),-- [wooden_helmet]
(20514,1870,1,1,2,34207.532928),-- [coal]
(20514,1865,1,1,2,34207.532928),-- [varnish]
(20514,1799,1,1,2,50677.720254),-- [rp_leather_gloves]
(20514,734,1,1,2,5701.21389),-- [quick_step_potion]
(20515,735,1,1,-1,19797),-- [swift_attack_potion]
(20515,2013,1,1,-1,5127),-- [bow_of_forest_shaft]
(20515,1865,1,1,-1,237565),-- [varnish]
(20515,57,118,183,0,700000),-- [adena]
(20515,15,1,1,1,133.700835),-- [short_spear]
(20515,2011,1,1,1,1601.299165),-- [short_spear_edge]
(20515,1870,1,1,2,35086.782348),-- [coal]
(20515,1865,1,1,2,35086.782348),-- [varnish]
(20515,1801,1,1,2,17675.931879),-- [rp_piece_bone_gaiters]
(20515,5158,1,1,2,1403.503425),-- [rp_comp_spiritshot_d]
(20517,1831,1,1,-1,473949),-- [antidote]
(20517,1921,1,1,-1,114665),-- [leather_shoes_texture]
(20517,1869,1,1,-1,177731),-- [iron_ore]
(20517,57,95,131,0,700000),-- [adena]
(20517,271,1,1,1,505),-- [hunting_bow]
(20517,1869,1,1,2,26249.44017),-- [iron_ore]
(20517,1864,1,1,2,52498.88034),-- [stem]
(20517,1793,1,1,2,1930.17237),-- [rp_sword_of_reflexion]
(20517,1833,1,1,2,69998.50712),-- [bandage]
(20518,1866,1,1,-1,123105),-- [suede]
(20518,1864,1,1,-1,369315),-- [stem]
(20518,1831,1,1,-1,492420),-- [antidote]
(20518,57,97,137,0,700000),-- [adena]
(20518,271,1,1,1,524),-- [hunting_bow]
(20518,1870,1,1,2,36363.249932),-- [coal]
(20518,1865,1,1,2,36363.249932),-- [varnish]
(20518,1799,1,1,2,53871.500136),-- [rp_leather_gloves]
(20521,2143,1,1,-1,50113),-- [rp_synthesis_cokes]
(20521,1897,1,1,-1,59658),-- [necklace_of_wisdom_chain]
(20521,1896,1,1,-1,106171),-- [necklace_of_anguish_chain]
(20521,57,128,189,0,700000),-- [adena]
(20521,9,1,1,1,237.18555),-- [cedar_staff]
(20521,2008,1,1,1,1919.6289),-- [cedar_staff_head]
(20521,154,1,1,1,237.18555),-- [dwarven_mace]
(20521,1866,1,1,2,24670.861524),-- [suede]
(20521,1871,1,1,2,37006.362852),-- [charcoal]
(20521,1793,1,1,2,2721.02496),-- [rp_sword_of_reflexion]
(20521,734,1,1,2,6167.750664),-- [quick_step_potion]
(20525,1867,1,1,-1,51475),-- [animal_skin]
(20525,1872,1,1,-1,51475),-- [animal_bone]
(20525,5549,1,1,-1,3861),-- [iron_thread]
(20525,57,19,29,0,700000),-- [adena]
(20525,1,1,1,1,13530),-- [small_sword]
(20525,1868,1,1,2,19956.368608),-- [thread]
(20525,1873,1,1,2,3991.25208),-- [silver_nugget]
(20525,1787,1,1,2,7982.558264),-- [rp_willow_staff]
(20525,1060,1,1,2,22173.821048),-- [lesser_healing_potion]
(20526,1833,1,1,-1,694345),-- [bandage]
(20526,1921,1,1,-1,167987),-- [leather_shoes_texture]
(20526,5220,1,1,-1,10415),-- [reinforcing_agent]
(20526,57,131,199,0,700000),-- [adena]
(20526,114,1,1,1,2278.848137),-- [earing_of_strength]
(20526,115,1,1,1,2278.848137),-- [earing_of_wisdom]
(20526,907,1,1,1,1709.141783),-- [necklace_of_anguish]
(20526,1896,1,1,1,13035.855656),-- [necklace_of_anguish_chain]
(20526,876,1,1,1,3418.306287),-- [ring_of_anguish]
(20526,1866,1,1,2,34183.209412),-- [suede]
(20526,1871,1,1,2,51274.814118),-- [charcoal]
(20526,1803,1,1,2,43087.97647),-- [rp_necklace_of_wisdom]
(20528,1833,1,1,-1,568013),-- [bandage]
(20528,1922,1,1,-1,54338),-- [leather_tunic_pattern]
(20528,57,112,158,0,700000),-- [adena]
(20528,216,1,1,1,302.53426),-- [dirk]
(20528,2009,1,1,1,2231.46574),-- [dirk_blade]
(20528,1865,1,1,2,41945.73894),-- [varnish]
(20528,1870,1,1,2,41945.73894),-- [coal]
(20528,1803,1,1,2,35248.52212),-- [rp_necklace_of_wisdom]
(20529,1867,1,1,-1,21226),-- [animal_skin]
(20529,1121,1,1,-1,636783),-- [apprentice's_shoes]
(20529,1786,1,1,-1,12736),-- [rp_broad_sword]
(20529,57,8,12,0,700000),-- [adena]
(20529,1121,1,1,1,164584.052902),-- [apprentice's_shoes]
(20529,35,1,1,1,29389.982366),-- [cloth_shoes]
(20529,36,1,1,1,29389.982366),-- [leather_sandals]
(20529,48,1,1,1,29389.982366),-- [short_gloves]
(20529,1868,1,1,2,10972.5),-- [thread]
(20529,1873,1,1,2,2194.5),-- [silver_nugget]
(20529,1788,1,1,2,4389),-- [rp_bow]
(20530,1867,1,1,-1,21226),-- [animal_skin]
(20530,1787,1,1,-1,12736),-- [rp_willow_staff]
(20530,1868,1,1,-1,31839),-- [thread]
(20530,57,8,12,0,700000),-- [adena]
(20530,426,1,1,1,14565.04902),-- [tunic]
(20530,462,1,1,1,23180.95098),-- [hose]
(20530,1868,1,1,2,8229.08812),-- [thread]
(20530,1873,1,1,2,1645.8087),-- [silver_nugget]
(20530,1786,1,1,2,3291.63971),-- [rp_broad_sword]
(20530,1060,1,1,2,9143.46347),-- [lesser_healing_potion]
(20531,1872,1,1,-1,21226),-- [animal_bone]
(20531,1873,1,1,-1,6368),-- [silver_nugget]
(20531,1788,1,1,-1,12736),-- [rp_bow]
(20531,57,8,12,0,700000),-- [adena]
(20531,426,1,1,1,14565.04902),-- [tunic]
(20531,462,1,1,1,23180.95098),-- [hose]
(20531,1868,1,1,2,10972.5),-- [thread]
(20531,1873,1,1,2,2194.5),-- [silver_nugget]
(20531,1787,1,1,2,4389),-- [rp_willow_staff]
(20532,1787,1,1,-1,14332),-- [rp_willow_staff]
(20532,35,1,1,-1,127969),-- [cloth_shoes]
(20532,1786,1,1,-1,14332),-- [rp_broad_sword]
(20532,57,8,13,0,700000),-- [adena]
(20532,18,1,1,1,61739.96472),-- [leather_shield]
(20532,41,1,1,1,44100.03528),-- [cloth_cap]
(20532,1868,1,1,2,12348.125),-- [thread]
(20532,1873,1,1,2,2469.625),-- [silver_nugget]
(20532,1786,1,1,2,4939.25),-- [rp_broad_sword]
(20533,1872,1,1,-1,23887),-- [animal_bone]
(20533,5549,1,1,-1,1792),-- [iron_thread]
(20533,57,8,13,0,700000),-- [adena]
(20533,13,1,1,1,6279),-- [short_bow]
(20533,1868,1,1,2,9261.136016),-- [thread]
(20533,1873,1,1,2,1852.21716),-- [silver_nugget]
(20533,1787,1,1,2,3704.459428),-- [rp_willow_staff]
(20533,1060,1,1,2,10290.187396),-- [lesser_healing_potion]
(20534,1786,1,1,-1,14332),-- [rp_broad_sword]
(20534,1868,1,1,-1,35831),-- [thread]
(20534,57,8,13,0,700000),-- [adena]
(20534,21,1,1,1,16390.98586),-- [shirt]
(20534,28,1,1,1,26087.01414),-- [pants]
(20534,1868,1,1,2,12348.125),-- [thread]
(20534,1873,1,1,2,2469.625),-- [silver_nugget]
(20534,1788,1,1,2,4939.25),-- [rp_bow]
(20535,1867,1,1,-1,23887),-- [animal_skin]
(20535,36,1,1,-1,127969),-- [leather_sandals]
(20535,1787,1,1,-1,14332),-- [rp_willow_staff]
(20535,57,8,13,0,700000),-- [adena]
(20535,21,1,1,1,16390.98586),-- [shirt]
(20535,28,1,1,1,26087.01414),-- [pants]
(20535,1870,1,1,2,4630.50819),-- [coal]
(20535,1865,1,1,2,4630.50819),-- [varnish]
(20535,1786,1,1,2,3704.406552),-- [rp_broad_sword]
(20535,17,10,30,2,23152.577068),-- [wooden_arrow]
(20536,1871,1,1,-1,27106),-- [charcoal]
(20536,18,1,1,-1,180709),-- [leather_shield]
(20536,1788,1,1,-1,21685),-- [rp_bow]
(20536,57,13,20,0,700000),-- [adena]
(20536,13,1,1,1,9500),-- [short_bow]
(20536,1869,1,1,2,9341.319526),-- [iron_ore]
(20536,1864,1,1,2,18682.639052),-- [stem]
(20536,1787,1,1,2,7473.041422),-- [rp_willow_staff]
(20537,1788,1,1,-1,21685),-- [rp_bow]
(20537,1867,1,1,-1,36142),-- [animal_skin]
(20537,1864,1,1,-1,54213),-- [stem]
(20537,57,13,20,0,700000),-- [adena]
(20537,308,1,1,1,9500),-- [buffalo_horn]
(20537,1869,1,1,2,7005.899932),-- [iron_ore]
(20537,1864,1,1,2,14011.757673),-- [stem]
(20537,1788,1,1,2,5604.694631),-- [rp_bow]
(20537,1060,1,1,2,15568.647764),-- [lesser_healing_potion]
(20538,1865,1,1,-1,27106),-- [varnish]
(20538,1786,1,1,-1,21685),-- [rp_broad_sword]
(20538,1869,1,1,-1,27106),-- [iron_ore]
(20538,57,13,20,0,700000),-- [adena]
(20538,1,1,1,1,9500),-- [small_sword]
(20538,1869,1,1,2,9341.319526),-- [iron_ore]
(20538,1864,1,1,2,18682.639052),-- [stem]
(20538,1786,1,1,2,7473.041422),-- [rp_broad_sword]
(20539,41,1,1,-1,129078),-- [cloth_cap]
(20539,1786,1,1,-1,21685),-- [rp_broad_sword]
(20539,1787,1,1,-1,21685),-- [rp_willow_staff]
(20539,57,13,20,0,700000),-- [adena]
(20539,253,1,1,1,9500),-- [spike_glove]
(20539,1869,1,1,2,7006.000308),-- [iron_ore]
(20539,1864,1,1,2,14012.062269),-- [stem]
(20539,1787,1,1,2,5604.812577),-- [rp_willow_staff]
(20539,17,10,30,2,35030.124846),-- [wooden_arrow]
(20540,1873,1,1,-1,69008),-- [silver_nugget]
(20540,1831,1,1,-1,460056),-- [antidote]
(20540,1896,1,1,-1,73102),-- [necklace_of_anguish_chain]
(20540,57,92,127,0,700000),-- [adena]
(20540,23,1,1,1,1110.321144),-- [wooden_breastplate]
(20540,30,1,1,1,1778.839428),-- [hard_leather_pants]
(20540,2386,1,1,1,1778.839428),-- [wooden_gaiters]
(20540,1873,1,1,2,13589.375913),-- [silver_nugget]
(20540,1868,1,1,2,67946.879565),-- [thread]
(20540,736,1,1,2,16986.744522),-- [scroll_of_escape]
(20541,2173,1,1,-1,55023),-- [rp_hard_leather_shirt]
(20541,1925,1,1,-1,133138),-- [leather_gloves_lining]
(20541,1897,1,1,-1,48342),-- [necklace_of_wisdom_chain]
(20541,57,99,159,0,700000),-- [adena]
(20541,272,1,1,1,114.2699),-- [bow_of_forest]
(20541,2013,1,1,1,1294.7301),-- [bow_of_forest_shaft]
(20541,1864,1,1,2,29986.73072),-- [stem]
(20541,1865,1,1,2,14993.36536),-- [varnish]
(20541,1866,1,1,2,9995.609259),-- [suede]
(20541,1873,1,1,2,5997.346144),-- [silver_nugget]
(20541,1868,1,1,2,29986.73072),-- [thread]
(20541,2143,1,1,2,2998.673072),-- [rp_synthesis_cokes]
(20541,5158,1,1,2,599.715203),-- [rp_comp_spiritshot_d]
(20541,734,1,1,2,2498.829522),-- [quick_step_potion]
(20542,1878,1,1,-1,90559),-- [braided_hemp]
(20542,734,1,1,-1,37733),-- [quick_step_potion]
(20542,1869,1,1,-1,226397),-- [iron_ore]
(20542,57,106,181,0,700000),-- [adena]
(20542,272,1,1,1,127.4081),-- [bow_of_forest]
(20542,2013,1,1,1,1443.5919),-- [bow_of_forest_shaft]
(20542,1864,1,1,2,53499.46836),-- [stem]
(20542,1869,1,1,2,26749.73418),-- [iron_ore]
(20542,1878,1,1,2,10699.93587),-- [braided_hemp]
(20542,1801,1,1,2,13475.9313),-- [rp_piece_bone_gaiters]
(20542,5158,1,1,2,1069.93029),-- [rp_comp_spiritshot_d]
(20543,2252,1,1,-1,9320),-- [rp_iron_hammer]
(20543,908,1,1,-1,4987),-- [necklace_of_wisdom]
(20543,1882,1,1,-1,50535),-- [leather]
(20543,57,105,183,0,700000),-- [adena]
(20543,309,1,1,1,128),-- [tears_of_eva]
(20543,310,1,1,1,128),-- [relic_of_saints]
(20543,1867,1,1,2,35825.538606),-- [animal_skin]
(20543,1872,1,1,2,35825.538606),-- [animal_bone]
(20543,1882,1,1,2,5970.900312),-- [leather]
(20543,2139,1,1,2,5373.782934),-- [rp_steel_mold]
(20543,6037,1,1,2,53738.239542),-- [scroll_of_awake]
(20544,1870,1,1,-1,27106),-- [coal]
(20544,1872,1,1,-1,36142),-- [animal_bone]
(20544,1788,1,1,-1,21685),-- [rp_bow]
(20544,57,13,20,0,700000),-- [adena]
(20544,21,1,1,1,24799.8649),-- [shirt]
(20544,28,1,1,1,39470.1351),-- [pants]
(20544,1869,1,1,2,9341.319526),-- [iron_ore]
(20544,1864,1,1,2,18682.639052),-- [stem]
(20544,1788,1,1,2,7473.041422),-- [rp_bow]
(20545,21,1,1,-1,28176),-- [shirt]
(20545,1786,1,1,-1,12736),-- [rp_broad_sword]
(20545,1873,1,1,-1,6368),-- [silver_nugget]
(20545,57,8,12,0,700000),-- [adena]
(20545,18,1,1,1,54861.301984),-- [leather_shield]
(20545,41,1,1,1,39186.698016),-- [cloth_cap]
(20545,1868,1,1,2,6583.31885),-- [thread]
(20545,1873,1,1,2,1316.6772),-- [silver_nugget]
(20545,1788,1,1,2,2633.320825),-- [rp_bow]
(20545,6037,1,1,2,6583.31885),-- [scroll_of_awake]
(20545,17,10,30,2,16458.364275),-- [wooden_arrow]
(20546,2279,1,1,-1,4867),-- [rp_hammer_in_flames]
(20546,2979,1,1,-1,91220),-- [rp_manticor_skin_gloves]
(20546,1877,1,1,-1,27257),-- [admantite_nugget]
(20546,57,288,574,0,700000),-- [adena]
(20546,849,1,1,1,366.707265),-- [tiger'seye_earing]
(20546,1901,1,1,1,12510.465306),-- [tiger'seye_earing_stone]
(20546,912,1,1,1,274.883163),-- [near_forest_necklace]
(20546,880,1,1,1,548.944266),-- [black_pearl_ring]
(20546,1876,1,1,2,9057.60408),-- [mithril_ore]
(20546,1880,1,1,2,4528.80204),-- [steel]
(20546,1877,1,1,2,1811.5361),-- [admantite_nugget]
(20546,1881,1,1,2,6038.40272),-- [coarse_bone_powder]
(20546,1882,1,1,2,10064.01727),-- [leather]
(20546,2276,1,1,2,323.48586),-- [rp_maingauche]
(20546,2274,1,1,2,323.48586),-- [rp_skull_breaker]
(20546,2976,1,1,2,6062.66607),-- [rp_manticor_skin_boots]
(20547,2151,1,1,-1,105333),-- [rp_necklace_of_devotion]
(20547,1804,1,1,-1,15126),-- [rp_soulshot_d]
(20547,1898,1,1,-1,38844),-- [blue_diamond_necklace_gem]
(20547,57,173,305,0,700000),-- [adena]
(20547,39,1,1,1,1567.677996),-- [boots]
(20547,1930,1,1,1,19093.621779),-- [boots_lining]
(20547,51,1,1,1,1567.700225),-- [bracer]
(20547,1870,1,1,2,44679.094416),-- [coal]
(20547,1865,1,1,2,44679.094416),-- [varnish]
(20547,5163,1,1,2,1787.147716),-- [rp_comp_bspiritshot_d]
(20547,5268,1,1,2,1787.147716),-- [rp_adv_comp_soulshot_d]
(20547,734,1,1,2,7446.515736),-- [quick_step_potion]
(20548,1865,1,1,-1,385707),-- [varnish]
(20548,1930,1,1,-1,98899),-- [boots_lining]
(20548,1804,1,1,-1,15428),-- [rp_soulshot_d]
(20548,57,177,312,0,700000),-- [adena]
(20548,625,1,1,1,2301.462072),-- [bone_shield]
(20548,1148,1,1,1,1604.537928),-- [hard_leather_helmet]
(20548,1869,1,1,2,56965.863183),-- [iron_ore]
(20548,1864,1,1,2,113931.905239),-- [stem]
(20548,1880,1,1,2,5696.568431),-- [steel]
(20548,5268,1,1,2,2278.663147),-- [rp_adv_comp_soulshot_d]
(20549,1880,1,1,-1,140167),-- [steel]
(20549,1938,1,1,-1,94230),-- [mithril_banded_mail_material]
(20549,1901,1,1,-1,193601),-- [tiger'seye_earing_stone]
(20549,57,592,1181,0,700000),-- [adena]
(20549,83,1,1,1,45.0906),-- [sword_of_magic]
(20549,144,1,1,1,45.0906),-- [sword_of_occult]
(20549,124,1,1,1,33.40344),-- [two-handed_sword]
(20549,2026,1,1,1,1494.606795),-- [two-handed_sword_edge]
(20549,127,1,1,1,33.40344),-- [crimson_sword]
(20549,130,1,1,1,33.405125),-- [elven_sword]
(20549,1871,1,1,2,124209.598502),-- [charcoal]
(20549,1866,1,1,2,82806.564841),-- [suede]
(20549,1877,1,1,2,4968.224734),-- [admantite_nugget]
(20549,2277,1,1,2,887.076377),-- [rp_bich'hwa]
(20549,6667,1,1,2,77630.874684),-- [key_of_treasure_box3]
(20549,1341,20,60,2,207016.660862),-- [bone_arrow]
(20550,2276,1,1,-1,5536),-- [rp_maingauche]
(20550,394,1,1,-1,1325),-- [reinforce_leather_shirt]
(20550,2154,1,1,-1,82984),-- [rp_elven_earing]
(20550,57,327,655,0,700000),-- [adena]
(20550,393,1,1,1,117.40802),-- [mithril_banded_mail]
(20550,1938,1,1,1,4617.24182),-- [mithril_banded_mail_material]
(20550,394,1,1,1,117.40802),-- [reinforce_leather_shirt]
(20550,415,1,1,1,187.65916),-- [mithril_banded_gaiters]
(20550,1939,1,1,1,6032.63508),-- [mithril_banded_gaiters_material]
(20550,416,1,1,1,187.6479),-- [reinforce_leather_gaiters]
(20550,1868,1,1,2,117742.435811),-- [thread]
(20550,1873,1,1,2,23548.518392),-- [silver_nugget]
(20550,5549,1,1,2,5887.129598),-- [iron_thread]
(20550,1889,1,1,2,3924.805115),-- [compound_braid]
(20550,2272,1,1,2,420.509257),-- [rp_sword_of_revolution]
(20550,2274,1,1,2,420.509257),-- [rp_skull_breaker]
(20550,2148,1,1,2,4205.09257),-- [rp_crafted_leather]
(20551,1874,1,1,-1,52310),-- [oriharukon_ore]
(20551,2034,1,1,-1,8290),-- [sword_of_revolution_blade]
(20551,1902,1,1,-1,79498),-- [elven_earing_beads]
(20551,57,332,662,0,700000),-- [adena]
(20551,850,1,1,1,188.03786),-- [elven_earing]
(20551,1902,1,1,1,6848.930925),-- [elven_earing_beads]
(20551,913,1,1,1,141.128575),-- [elven_necklace]
(20551,1904,1,1,1,6308.810455),-- [elven_necklace_beads]
(20551,881,1,1,1,282.25715),-- [elven_ring]
(20551,1903,1,1,1,11275.835035),-- [elven_ring_piece]
(20551,1872,1,1,2,77257.841813),-- [animal_bone]
(20551,1867,1,1,2,77257.841813),-- [animal_skin]
(20551,1881,1,1,2,7725.80127),-- [coarse_bone_powder]
(20551,1875,1,1,2,3862.900635),-- [stone_of_purity]
(20551,2145,1,1,2,4138.88314),-- [rp_mithirl_alloy]
(20551,2288,1,1,2,321.951108),-- [rp_ghost_staff]
(20551,2287,1,1,2,321.780221),-- [rp_atuba_hammer]
(20552,1902,1,1,-1,170992),-- [elven_earing_beads]
(20552,1825,1,1,-1,120549),-- [rp_oriharukon]
(20552,1903,1,1,-1,281516),-- [elven_ring_piece]
(20552,57,714,1424,0,700000),-- [adena]
(20552,129,1,1,1,81.2308),-- [sword_of_revolution]
(20552,2034,1,1,1,4608.7692),-- [sword_of_revolution_blade]
(20552,1864,1,3,2,145400.811275),-- [stem]
(20552,1869,1,1,2,145400.811275),-- [iron_ore]
(20552,1878,1,1,2,58160.32451),-- [braided_hemp]
(20552,1884,1,1,2,89477.457255),-- [cord]
(20552,2285,1,1,2,807.870585),-- [rp_claymore]
(20552,2208,1,1,2,14867.7251),-- [rp_ogre_power_gauntlet]
(20553,2145,1,1,-1,62124),-- [rp_mithirl_alloy]
(20553,1904,1,1,-1,81170),-- [elven_necklace_beads]
(20553,1865,1,1,-1,869731),-- [varnish]
(20553,57,368,733,0,700000),-- [adena]
(20553,318,1,1,1,41.858726),-- [crucifix_of_blood]
(20553,2042,1,1,1,2077.141274),-- [crucifix_of_blood_piece]
(20553,1865,1,1,2,74930.706489),-- [varnish]
(20553,1870,1,1,2,74930.706489),-- [coal]
(20553,1879,1,1,2,12488.36337),-- [cokes]
(20553,1875,1,1,2,4995.345348),-- [stone_of_purity]
(20553,2285,1,1,2,416.278779),-- [rp_claymore]
(20553,2208,1,1,2,7661.599525),-- [rp_ogre_power_gauntlet]
(20554,1941,1,1,-1,40488),-- [brigandine_temper]
(20554,2146,1,1,-1,72720),-- [rp_artisan's_frame]
(20554,1902,1,1,-1,103148),-- [elven_earing_beads]
(20554,57,425,848,0,700000),-- [adena]
(20554,224,1,1,1,24.49914),-- [maingauche]
(20554,2038,1,1,1,1390.00086),-- [maingauche_edge]
(20554,1660,1,1,1,24.49914),-- [cursed_maingauche]
(20554,2044,1,1,1,1390.00086),-- [cursed_maingauche_edge]
(20554,1869,1,1,2,75180.860924),-- [iron_ore]
(20554,1864,1,1,2,150361.472222),-- [stem]
(20554,1880,1,1,2,7517.986242),-- [steel]
(20554,5550,1,1,2,1002.498016),-- [reinforcing_plate]
(20554,5473,1,1,2,5369.954512),-- [rp_reinforcing_plate]
(20554,2208,1,1,2,7687.23267),-- [rp_ogre_power_gauntlet]
(20554,6036,1,1,2,2505.995414),-- [potion_of_acumen3]
(20555,1903,1,1,-1,152869),-- [elven_ring_piece]
(20555,2296,1,1,-1,5091),-- [rp_atuba_mace]
(20555,1878,1,1,-1,366579),-- [braided_hemp]
(20555,57,383,764,0,700000),-- [adena]
(20555,395,1,1,1,137.708965),-- [manticor_skin_shirt]
(20555,1942,1,1,1,6040.76583),-- [manticor_skin_shirt_texture]
(20555,417,1,1,1,219.926575),-- [manticor_skin_gaiters]
(20555,1943,1,1,1,9406.59863),-- [manticor_skin_gaiters_pattern]
(20555,1869,1,1,2,78955.380156),-- [iron_ore]
(20555,1864,1,1,2,157910.500785),-- [stem]
(20555,1880,1,1,2,7895.589921),-- [steel]
(20555,5550,1,1,2,1052.641512),-- [reinforcing_plate]
(20555,5473,1,1,2,5639.781237),-- [rp_reinforcing_plate]
(20555,2208,1,1,2,8073.106389),-- [rp_ogre_power_gauntlet]
(20556,2305,1,1,-1,4246),-- [rp_crystal_staff]
(20556,1957,1,1,-1,108518),-- [assault_boots_part]
(20556,1874,1,1,-1,64821),-- [oriharukon_ore]
(20556,57,394,788,0,700000),-- [adena]
(20556,438,1,1,1,133.188891),-- [sage's_rag]
(20556,1953,1,1,1,7819.811109),-- [sage's_rag_lining]
(20556,1870,1,1,2,81375.725358),-- [coal]
(20556,1865,1,1,2,81375.725358),-- [varnish]
(20556,1874,1,1,2,5424.977848),-- [oriharukon_ore]
(20556,2160,1,1,2,5250.115032),-- [rp_moonstone_earing]
(20556,2205,1,1,2,2575.172257),-- [rp_chain_gaiters]
(20556,5154,1,1,2,271.284147),-- [rp_comp_soulshot_c]
(20557,2055,1,1,-1,8505),-- [glaive_edge]
(20557,3954,1,1,-1,3429),-- [rp_blessed_spiritshot_c]
(20557,4469,1,1,-1,5878),-- [dye_s1c1_d]
(20557,57,414,837,0,700000),-- [adena]
(20557,297,1,1,1,37.24522),-- [glaive]
(20557,2055,1,1,1,2135.75478),-- [glaive_edge]
(20557,1871,1,1,2,73789.958951),-- [charcoal]
(20557,1866,1,1,2,49193.253063),-- [suede]
(20557,1877,1,1,2,2951.585661),-- [admantite_nugget]
(20557,2297,1,1,2,322.18739),-- [rp_flamberge]
(20557,5154,1,1,2,246.00515),-- [rp_comp_soulshot_c]
(20557,2994,1,1,2,5856.350987),-- [rp_boots_of_seal]
(20557,6668,1,1,2,26353.658798),-- [key_of_treasure_box4]
(20558,2932,1,1,-1,118674),-- [plate_boots_design]
(20558,2310,1,1,-1,4643),-- [rp_darkelven_dagger]
(20558,1905,1,1,-1,103435),-- [onyxbeast'seye_earing_gemstone]
(20558,57,420,854,0,700000),-- [adena]
(20558,851,1,1,1,190.763013),-- [onyxbeast'seye_earing]
(20558,1905,1,1,1,8656.463781),-- [onyxbeast'seye_earing_gemstone]
(20558,914,1,1,1,143.065335),-- [necklace_of_darkness]
(20558,1907,1,1,1,6190.504908),-- [necklace_of_darkness_gem]
(20558,882,1,1,1,286.13067),-- [mithril_ring]
(20558,1906,1,1,1,12232.072293),-- [mithril_ring_wire]
(20558,1875,1,1,2,4449.576105),-- [stone_of_purity]
(20558,1879,1,1,2,11124.02291),-- [cokes]
(20558,1885,1,1,2,5562.011455),-- [high_grade_suede]
(20558,5550,1,1,2,889.94828),-- [reinforcing_plate]
(20558,5549,1,1,2,6674.446805),-- [iron_thread]
(20558,2988,1,1,2,2816.130915),-- [rp_tempered_mithril_gaiters]
(20558,2303,1,1,2,291.415085),-- [rp_skull_graver]
(20558,1342,10,30,2,133487.448445),-- [fine_steel_arrow]
(20559,2164,1,1,-1,96165),-- [rp_ring_of_protection]
(20559,1873,1,1,-1,500056),-- [silver_nugget]
(20559,2163,1,1,-1,63783),-- [rp_earing_of_protection]
(20559,57,492,1009,0,700000),-- [adena]
(20559,71,1,1,1,16.754325),-- [flamberge]
(20559,2059,1,1,1,1096.923506),-- [flamberge_blade]
(20559,72,1,1,1,16.754325),-- [stormbringer]
(20559,2060,1,1,1,1172.567844),-- [stormbringer_blade]
(20559,1895,1,1,2,21101.178213),-- [metallic_fiber]
(20559,2164,1,1,2,5681.076912),-- [rp_ring_of_protection]
(20559,5154,1,1,2,246.186135),-- [rp_comp_soulshot_c]
(20559,2219,1,1,2,4587.203421),-- [rp_crimson_boots]
(20559,8723,1,1,2,2954.162826),-- [general_46_c]
(20559,8733,1,1,2,738.558405),-- [special_46_c]
(20559,8743,1,1,2,73.838142),-- [rare_46_c]
(20559,8753,1,1,2,14.795946),-- [unique_46_c]
(20560,2165,1,1,-1,44638),-- [rp_necklace_of_protection]
(20560,2320,1,1,-1,4059),-- [rp_cursed_staff]
(20560,1908,1,1,-1,110326),-- [moonstone_earing_wire]
(20560,57,461,936,0,700000),-- [adena]
(20560,852,1,1,1,153.844505),-- [moonstone_earing]
(20560,1908,1,1,1,8690.69005),-- [moonstone_earing_wire]
(20560,915,1,1,1,115.433245),-- [aquastone_necklace]
(20560,1910,1,1,1,6910.66439),-- [aquastone_necklace_chain]
(20560,883,1,1,1,230.86649),-- [aquastone_ring]
(20560,1909,1,1,1,12393.50132),-- [aquastone_ring_wire]
(20560,1864,1,1,2,84710.585259),-- [stem]
(20560,1865,1,1,2,42355.424115),-- [varnish]
(20560,1866,1,1,2,28236.774096),-- [suede]
(20560,1873,1,1,2,16942.169646),-- [silver_nugget]
(20560,1868,1,1,2,84710.585259),-- [thread]
(20560,2323,1,1,2,147.526731),-- [rp_elemental_bow]
(20560,2225,1,1,2,920.661471),-- [rp_demon's_hose]
(20560,2321,1,1,2,147.526731),-- [rp_stiletto]
(20560,3003,1,1,2,2630.761884),-- [rp_gloves_of_seal]
(20560,8723,1,1,2,1694.322153),-- [general_46_c]
(20560,8733,1,1,2,423.646281),-- [special_46_c]
(20560,8743,1,1,2,42.338331),-- [rare_46_c]
(20560,8753,1,1,2,8.678043),-- [unique_46_c]
(20561,1880,1,1,-1,137957),-- [steel]
(20561,2940,1,1,-1,124006),-- [dwarven_chain_boots_part]
(20561,2164,1,1,-1,106120),-- [rp_ring_of_protection]
(20561,57,543,1111,0,700000),-- [adena]
(20561,96,1,1,1,12.329282),-- [scythe]
(20561,2062,1,1,1,852.33652),-- [scythe_edge]
(20561,298,1,1,1,12.329282),-- [orcish_glaive]
(20561,2075,1,1,1,852.33652),-- [orcish_glaive_blade]
(20561,302,1,1,1,12.329282),-- [body_slasher]
(20561,2076,1,1,1,852.339114),-- [body_slasher_blade]
(20561,1866,1,1,2,36222.406578),-- [suede]
(20561,1871,1,1,2,54333.46539),-- [charcoal]
(20561,5220,1,1,2,2173.223034),-- [reinforcing_agent]
(20561,1885,1,1,2,4527.90918),-- [high_grade_suede]
(20561,4041,1,1,2,472.43979),-- [mold_hardener]
(20561,6037,1,1,2,108667.219734),-- [scroll_of_awake]
(20561,6668,1,1,2,19404.70587),-- [key_of_treasure_box4]
(20561,8723,1,1,2,2173.223034),-- [general_46_c]
(20561,8733,1,1,2,543.23352),-- [special_46_c]
(20561,8743,1,1,2,54.323352),-- [rare_46_c]
(20561,8753,1,1,2,10.980252),-- [unique_46_c]
(20561,1832,1,1,2,60370.870266),-- [advanced_antidote]
(20562,1867,1,3,-1,885212),-- [animal_skin]
(20562,2346,1,1,-1,3088),-- [rp_fist_blade]
(20562,440,1,1,-1,440),-- [robe_of_seal]
(20562,57,524,1069,0,700000),-- [adena]
(20562,853,1,1,1,130.303378),-- [earing_of_protection]
(20562,1911,1,1,1,7293.4976),-- [earing_of_protection_gemstone]
(20562,916,1,1,1,97.763904),-- [necklace_of_protection]
(20562,1913,1,1,1,5962.967722),-- [necklace_of_protection_gemstone]
(20562,884,1,1,1,195.527808),-- [ring_of_protection]
(20562,1912,1,1,1,10566.939588),-- [ring_of_protection_gemstone]
(20562,1869,1,1,2,45255.831726),-- [iron_ore]
(20562,1864,1,1,2,90511.663452),-- [stem]
(20562,1880,1,1,2,4525.559262),-- [steel]
(20562,5550,1,1,2,603.503544),-- [reinforcing_plate]
(20562,4043,1,1,2,1508.519754),-- [asofe]
(20562,2166,1,1,2,1534.104096),-- [rp_earing_of_binding]
(20562,2230,1,1,2,877.040808),-- [rp_theca_leather_gaiters]
(20562,2226,1,1,2,1847.09385),-- [rp_mithril_gauntlet]
(20562,8724,1,1,2,1508.519754),-- [general_49_c]
(20562,8734,1,1,2,377.070162),-- [special_49_c]
(20562,8744,1,1,2,37.778748),-- [rare_49_c]
(20562,8754,1,1,2,7.651392),-- [unique_49_c]
(20562,1342,10,30,2,90511.663452),-- [fine_steel_arrow]
(20563,1825,1,1,-1,77898),-- [rp_oriharukon]
(20563,1941,1,1,-1,43371),-- [brigandine_temper]
(20563,1864,1,5,-1,727049),-- [stem]
(20563,57,455,909,0,700000),-- [adena]
(20563,1124,1,1,1,122.767366),-- [boots_of_power]
(20563,1948,1,1,1,4761.357634),-- [boots_of_power_pattern]
(20563,2424,1,1,1,122.767366),-- [manticor_skin_boots]
(20563,2923,1,1,1,4761.357634),-- [manticor_skin_boots_lining]
(20563,2425,1,1,1,122.767366),-- [brigandine_boots]
(20563,2924,1,1,1,4761.357634),-- [brigandine_boots_design]
(20563,2426,1,1,1,122.767366),-- [elven_mithril_boots]
(20563,2925,1,1,1,4761.357634),-- [elven_mithril_boots_design]
(20563,606,1,1,1,122.767366),-- [gauntlet_of_repose_of_the_soul]
(20563,1946,1,1,1,4761.357634),-- [gauntlet_of_repose_of_the_soul_pattern]
(20563,2448,1,1,1,122.767366),-- [manticor_skin_gloves]
(20563,2926,1,1,1,4761.357634),-- [manticor_skin_gloves_linging]
(20563,2449,1,1,1,122.767366),-- [brigandine_gauntlet]
(20563,2927,1,1,1,4761.357634),-- [brigandine_gauntlet_pattern]
(20563,2450,1,1,1,122.767366),-- [elven_mithril_gloves]
(20563,2928,1,1,1,4761.357634),-- [elven_mithril_gloves_design]
(20563,1870,1,1,2,93956.963796),-- [coal]
(20563,1865,1,1,2,93956.963796),-- [varnish]
(20563,1874,1,1,2,6263.716176),-- [oriharukon_ore]
(20563,2160,1,1,2,6061.818384),-- [rp_moonstone_earing]
(20563,2205,1,1,2,2973.311334),-- [rp_chain_gaiters]
(20563,5154,1,1,2,313.226514),-- [rp_comp_soulshot_c]
(20564,1885,1,1,-1,82647),-- [high_grade_suede]
(20564,2306,1,1,-1,4331),-- [rp_stick_of_faith]
(20564,1864,1,5,-1,661179),-- [stem]
(20564,57,402,804,0,700000),-- [adena]
(20564,630,1,1,1,210.139151),-- [square_shield]
(20564,1956,1,1,1,9421.286455),-- [square_shield_fragment]
(20564,2494,1,1,1,210.139151),-- [plate_shield]
(20564,2934,1,1,1,9421.286455),-- [plate_shield_fragment]
(20564,2412,1,1,1,147.157438),-- [plate_helmet]
(20564,2930,1,1,1,6690.99135),-- [plate_helmet_design]
(20564,1871,1,1,2,71145.919102),-- [charcoal]
(20564,1866,1,1,2,47430.561726),-- [suede]
(20564,1877,1,1,2,2845.824522),-- [admantite_nugget]
(20564,2297,1,1,2,310.64278),-- [rp_flamberge]
(20564,5154,1,1,2,237.1903),-- [rp_comp_soulshot_c]
(20564,2994,1,1,2,5646.506374),-- [rp_boots_of_seal]
(20564,6668,1,1,2,25409.355196),-- [key_of_treasure_box4]
(20565,1865,1,3,-1,572525),-- [varnish]
(20565,3954,1,1,-1,3817),-- [rp_blessed_spiritshot_c]
(20565,4470,1,1,-1,6543),-- [dye_s1d1_d]
(20565,57,461,932,0,700000),-- [adena]
(20565,262,1,1,1,41.46166),-- [scallop_jamadhr]
(20565,2053,1,1,1,2377.53834),-- [scallop_jamadhr_edge]
(20565,1875,1,1,2,5476.173086),-- [stone_of_purity]
(20565,1879,1,1,2,13690.452288),-- [cokes]
(20565,1885,1,1,2,6845.226144),-- [high_grade_suede]
(20565,5550,1,1,2,1095.226788),-- [reinforcing_plate]
(20565,5549,1,1,2,8214.279202),-- [iron_thread]
(20565,2988,1,1,2,3465.947694),-- [rp_tempered_mithril_gaiters]
(20565,2303,1,1,2,358.694798),-- [rp_skull_graver]
(20566,2995,1,1,-1,95820),-- [rp_reinforce_mithril_gloves]
(20566,3000,1,1,-1,77393),-- [rp_dwarven_chain_shield]
(20566,1905,1,1,-1,117445),-- [onyxbeast'seye_earing_gemstone]
(20566,57,477,970,0,700000),-- [adena]
(20566,630,1,1,1,255.812474),-- [square_shield]
(20566,1956,1,1,1,11468.98417),-- [square_shield_fragment]
(20566,2494,1,1,1,255.812474),-- [plate_shield]
(20566,2934,1,1,1,11468.98417),-- [plate_shield_fragment]
(20566,2412,1,1,1,179.141812),-- [plate_helmet]
(20566,2930,1,1,1,8145.2649),-- [plate_helmet_design]
(20566,1895,1,1,2,21652.597538),-- [metallic_fiber]
(20566,2164,1,1,2,5829.535712),-- [rp_ring_of_protection]
(20566,5154,1,1,2,252.61951),-- [rp_comp_soulshot_c]
(20566,2219,1,1,2,4707.076946),-- [rp_crimson_boots]
(20566,8723,1,1,2,3031.361476),-- [general_46_c]
(20566,8733,1,1,2,757.85853),-- [special_46_c]
(20566,8743,1,1,2,75.767692),-- [rare_46_c]
(20566,8753,1,1,2,15.182596),-- [unique_46_c]
(20567,2061,1,1,-1,10331),-- [big_hammer_head]
(20567,3004,1,1,-1,83015),-- [rp_rind_leather_gloves]
(20567,2165,1,1,-1,51209),-- [rp_necklace_of_protection]
(20567,57,526,1078,0,700000),-- [adena]
(20567,263,1,1,1,35.829805),-- [chakram]
(20567,2073,1,1,1,2441.170195),-- [chakram_edge]
(20567,1864,1,1,2,97180.198849),-- [stem]
(20567,1865,1,1,2,48590.250265),-- [varnish]
(20567,1866,1,1,2,32393.299056),-- [suede]
(20567,1873,1,1,2,19436.100106),-- [silver_nugget]
(20567,1868,1,1,2,97180.198849),-- [thread]
(20567,2323,1,1,2,169.243041),-- [rp_elemental_bow]
(20567,2225,1,1,2,1056.185181),-- [rp_demon's_hose]
(20567,2321,1,1,2,169.243041),-- [rp_stiletto]
(20567,3003,1,1,2,3018.016724),-- [rp_gloves_of_seal]
(20567,8723,1,1,2,1943.730683),-- [general_46_c]
(20567,8733,1,1,2,486.008091),-- [special_46_c]
(20567,8743,1,1,2,48.570641),-- [rare_46_c]
(20567,8753,1,1,2,9.955473),-- [unique_46_c]
(20568,1961,1,1,-1,37654),-- [tempered_mithril_shirt_fabric]
(20568,1884,1,1,-1,724122),-- [cord]
(20568,1908,1,1,-1,111430),-- [moonstone_earing_wire]
(20568,57,465,945,0,700000),-- [adena]
(20568,89,1,1,1,3.942464),-- [big_hammer]
(20568,2061,1,1,1,268.608336),-- [big_hammer_head]
(20568,160,1,1,1,3.942464),-- [battle_axe]
(20568,2063,1,1,1,268.608336),-- [battle_axe_head]
(20568,161,1,1,1,3.942464),-- [war_pick]
(20568,2064,1,1,1,268.608336),-- [war_pick_head]
(20568,173,1,1,1,3.942464),-- [skull_graver]
(20568,2065,1,1,1,268.608336),-- [skull_graver_head]
(20568,191,1,1,1,3.942464),-- [heavy_doom_hammer]
(20568,2066,1,1,1,272.557256),-- [heavy_doom_hammer_head]
(20568,192,1,1,1,3.942464),-- [crystal_staff]
(20568,2067,1,1,1,250.458368),-- [crystal_staff_head]
(20568,193,1,1,1,3.942464),-- [stick_of_faith]
(20568,2068,1,1,1,250.458368),-- [stick_of_faith_shaft]
(20568,194,1,1,1,3.942464),-- [heavy_doom_axe]
(20568,2069,1,1,1,272.552952),-- [heavy_doom_axe_blade]
(20568,1864,1,1,2,101113.780967),-- [stem]
(20568,1865,1,1,2,50557.04531),-- [varnish]
(20568,1866,1,1,2,33704.490438),-- [suede]
(20568,1873,1,1,2,20222.818124),-- [silver_nugget]
(20568,1868,1,1,2,101113.780967),-- [thread]
(20568,2324,1,1,2,176.192557),-- [rp_noble_elven_bow]
(20568,2321,1,1,2,176.192557),-- [rp_stiletto]
(20568,8723,1,1,2,2022.343743),-- [general_46_c]
(20568,8733,1,1,2,505.663349),-- [special_46_c]
(20568,8743,1,1,2,50.473439),-- [rare_46_c]
(20568,8753,1,1,2,10.218549),-- [unique_46_c]
(20569,3001,1,1,-1,79425),-- [rp_rind_leather_boots]
(20569,1961,1,1,-1,40920),-- [tempered_mithril_shirt_fabric]
(20569,2213,1,1,-1,19856),-- [rp_dwarven_chain_mail_shirt]
(20569,57,504,1030,0,700000),-- [adena]
(20569,631,1,1,1,197.50464),-- [eldarake]
(20569,1964,1,1,1,8139.151692),-- [eldarake_temper]
(20569,2495,1,1,1,197.50464),-- [chain_shield]
(20569,2945,1,1,1,8139.151692);-- [chain_shield_fragment]

INSERT INTO `droplist` VALUES
(20569,2413,1,1,1,138.253248),-- [chain_hood]
(20569,2936,1,1,1,7392.434088),-- [chain_hood_pattern]
(20569,1865,1,1,2,50362.6134),-- [varnish]
(20569,1870,1,1,2,50362.6134),-- [coal]
(20569,1879,1,1,2,8393.82225),-- [cokes]
(20569,1875,1,1,2,3357.5289),-- [stone_of_purity]
(20569,4040,1,1,2,1007.19465),-- [mold_lubricant]
(20569,2508,1,1,2,41968.9512),-- [cursed_bone]
(20569,2230,1,1,2,975.9849),-- [rp_theca_leather_gaiters]
(20569,2220,1,1,2,1042.72575),-- [rp_rind_leather_mail]
(20569,8723,1,1,2,2014.54935),-- [general_46_c]
(20569,8733,1,1,2,503.67735),-- [special_46_c]
(20569,8743,1,1,2,50.41575),-- [rare_46_c]
(20569,8753,1,1,2,9.9231),-- [unique_46_c]
(20570,3008,1,1,-1,46633),-- [rp_theca_leather_gloves]
(20570,2216,1,1,-1,52993),-- [rp_great_helmet]
(20570,1911,1,1,-1,95383),-- [earing_of_protection_gemstone]
(20570,57,506,1033,0,700000),-- [adena]
(20570,355,1,1,1,57.33637),-- [dwarven_chain_mail_shirt]
(20570,1968,1,1,1,3422.90028),-- [dwarven_chain_mail_shirt_material]
(20570,382,1,1,1,91.738192),-- [dwarven_chain_gaiters]
(20570,1969,1,1,1,5429.025158),-- [dwarven_chain_gaiters_material]
(20570,1866,1,1,2,34436.948304),-- [suede]
(20570,1871,1,1,2,51655.471392),-- [charcoal]
(20570,5220,1,1,2,2066.175792),-- [reinforcing_agent]
(20570,1885,1,1,2,4304.606304),-- [high_grade_suede]
(20570,4041,1,1,2,449.134608),-- [mold_hardener]
(20570,2167,1,1,2,2635.497216),-- [rp_ring_of_ages]
(20570,2343,1,1,2,120.088944),-- [rp_mace_of_underworld]
(20570,8724,1,1,2,1721.862096),-- [general_49_c]
(20570,8734,1,1,2,430.441056),-- [special_49_c]
(20570,8744,1,1,2,43.06368),-- [rare_49_c]
(20570,8754,1,1,2,8.710608),-- [unique_49_c]
(20571,2335,1,1,-1,3525),-- [rp_war_axe]
(20571,2968,1,1,-1,10228),-- [dwarven_warhammer_head]
(20571,951,1,1,-1,2756),-- [scrl_of_ench_wp_c]
(20571,57,599,1219,0,700000),-- [adena]
(20571,73,1,1,1,7.60032),-- [shamshir]
(20571,2077,1,1,1,557.89968),-- [shamshir_blade]
(20571,74,1,1,1,7.60032),-- [katana]
(20571,2078,1,1,1,557.89968),-- [katana_blade]
(20571,131,1,1,1,7.60032),-- [spirits_sword]
(20571,2080,1,1,1,557.89968),-- [spirits_sword_blade]
(20571,133,1,1,1,7.60032),-- [raid_sword]
(20571,2081,1,1,1,557.89968),-- [raid_sword_blade]
(20571,1866,1,1,2,34445.326013),-- [suede]
(20571,1871,1,1,2,51667.910581),-- [charcoal]
(20571,5220,1,1,2,2066.697598),-- [reinforcing_agent]
(20571,1885,1,1,2,4305.646142),-- [high_grade_suede]
(20571,4041,1,1,2,449.295728),-- [mold_hardener]
(20571,2336,1,1,2,120.167782),-- [rp_nirvana_axe]
(20571,2508,1,1,2,43056.618297),-- [cursed_bone]
(20571,2351,1,1,2,108.088253),-- [rp_scorpion]
(20571,6668,1,1,2,18452.814002),-- [key_of_treasure_box4]
(20571,8724,1,1,2,1722.195706),-- [general_49_c]
(20571,8734,1,1,2,430.627365),-- [special_49_c]
(20571,8744,1,1,2,42.984298),-- [rare_49_c]
(20571,8754,1,1,2,8.628235),-- [unique_49_c]
(20572,2950,1,1,-1,139779),-- [gloves_of_seal_pattern]
(20572,4125,1,1,-1,73865),-- [rp_maestro_mold]
(20572,1894,1,1,-1,58315),-- [crafted_leather]
(20572,57,656,1338,0,700000),-- [adena]
(20572,94,1,1,1,33.326689),-- [bech_de_corbin]
(20572,2079,1,1,1,2529.673311),-- [bech_de_corbin_blade]
(20572,1867,1,1,2,75526.054989),-- [animal_skin]
(20572,1872,1,1,2,75526.054989),-- [animal_bone]
(20572,1882,1,1,2,12587.842113),-- [leather]
(20572,1894,1,1,2,1987.396488),-- [crafted_leather]
(20572,4042,1,1,2,944.146357),-- [enria]
(20572,3009,1,1,2,2311.977976),-- [rp_composite_boots]
(20572,2508,1,1,2,47203.659657),-- [cursed_bone]
(20572,2224,1,1,2,769.550782),-- [rp_demon's_tunic]
(20572,8724,1,1,2,1888.292714),-- [general_49_c]
(20572,8734,1,1,2,471.906897),-- [special_49_c]
(20572,8744,1,1,2,47.223946),-- [rare_49_c]
(20572,8754,1,1,2,9.311764),-- [unique_49_c]
(20572,1342,10,30,2,113289.581328),-- [fine_steel_arrow]
(20573,2119,1,1,-1,5433),-- [crystal_dagger_blade]
(20573,4122,1,1,-1,52996),-- [rp_maestro_holder]
(20573,5549,1,1,-1,119240),-- [iron_thread]
(20573,57,472,959,0,700000),-- [adena]
(20573,64,1,1,1,130.58758),-- [composite_boots]
(20573,2956,1,1,1,7251.41242),-- [composite_boots_part]
(20573,608,1,1,1,130.58758),-- [mithril_gauntlet]
(20573,1981,1,1,1,7251.41242),-- [mithril_gauntlet_design]
(20573,1868,1,1,2,75862.170244),-- [thread]
(20573,1873,1,1,2,15172.469662),-- [silver_nugget]
(20573,5549,1,1,2,3793.161932),-- [iron_thread]
(20573,1889,1,1,2,2528.715266),-- [compound_braid]
(20573,4044,1,1,2,1264.446666),-- [thons]
(20573,2231,1,1,2,163.464588),-- [rp_full_plate_armor]
(20573,3014,1,1,2,1059.4927),-- [rp_full_plate_boots]
(20573,3019,1,1,2,1011.41488),-- [rp_full_plate_shield]
(20573,8725,1,1,2,1053.616522),-- [general_52_c]
(20573,8735,1,1,2,263.359614),-- [special_52_c]
(20573,8745,1,1,2,26.353768),-- [rare_52_c]
(20573,8755,1,1,2,5.34198),-- [unique_52_c]
(20573,1342,10,30,2,75861.992178),-- [fine_steel_arrow]
(20574,1867,1,3,-1,836382),-- [animal_skin]
(20574,1539,1,1,-1,278794),-- [greater_healing_potion]
(20574,4601,1,1,-1,2788),-- [dye_s3c3_c]
(20574,57,497,1009,0,700000),-- [adena]
(20574,75,1,1,1,2.616499),-- [caliburs]
(20574,2089,1,1,1,235.550644),-- [caliburs_edge]
(20574,76,1,1,1,2.616499),-- [sword_of_delusion]
(20574,2090,1,1,1,235.550644),-- [sword_of_delusion_blade]
(20574,77,1,1,1,2.616499),-- [tsurugi]
(20574,2091,1,1,1,235.550644),-- [tsurugi_blade]
(20574,84,1,1,1,2.616499),-- [homunkulus's_sword]
(20574,2092,1,1,1,235.550644),-- [homunkulus's_sword_blade]
(20574,134,1,1,1,2.616499),-- [sword_of_nightmare]
(20574,2095,1,1,1,235.550644),-- [sword_of_nightmare_blade]
(20574,145,1,1,1,2.616499),-- [deathbreath_sword]
(20574,2096,1,1,1,235.547786),-- [deathbreath_sword_blade]
(20574,1869,1,1,2,39908.739234),-- [iron_ore]
(20574,1864,1,1,2,79817.338965),-- [stem]
(20574,1880,1,1,2,3990.901824),-- [steel]
(20574,5550,1,1,2,532.064442),-- [reinforcing_plate]
(20574,4043,1,1,2,1330.300608),-- [asofe]
(20574,4122,1,1,2,1773.780645),-- [rp_maestro_holder]
(20574,4609,1,1,2,88.723908),-- [dye_m3i3_c]
(20574,4123,1,1,2,1773.780645),-- [rp_maestro_anvil_lock]
(20574,8725,1,1,2,1108.630341),-- [general_52_c]
(20574,8735,1,1,2,277.192461),-- [special_52_c]
(20574,8745,1,1,2,27.761097),-- [rare_52_c]
(20574,8755,1,1,2,5.58012),-- [unique_52_c]
(20574,1539,1,1,2,8868.20571),-- [greater_healing_potion]
(20575,4598,1,1,-1,4711),-- [dye_m2w2_c]
(20575,1806,1,1,-1,2826),-- [rp_soulshot_b]
(20575,1870,1,3,-1,706598),-- [coal]
(20575,57,558,1137,0,700000),-- [adena]
(20575,135,1,1,1,5.534095),-- [samurai_longsword]
(20575,2115,1,1,1,597.588114),-- [samurai_longsword_blade]
(20575,5286,1,1,1,5.534095),-- [berserker_blade]
(20575,5530,1,1,1,598.343696),-- [berserker_blade_edge]
(20575,1870,1,1,2,40137.885173),-- [coal]
(20575,1865,1,1,2,40137.885173),-- [varnish]
(20575,1874,1,1,2,2675.846801),-- [oriharukon_ore]
(20575,4043,1,1,2,1337.96919),-- [asofe]
(20575,4039,1,1,2,1337.96919),-- [mold_glue]
(20575,4145,1,1,2,176.014838),-- [rp_avadon_leather_mail]
(20575,4184,1,1,2,46.247395),-- [rp_sprite's_staff]
(20575,5165,1,1,2,80.314783),-- [rp_comp_bspiritshot_b]
(20575,4180,1,1,2,4459.805721),-- [rp_silver_arrow]
(20575,8726,1,1,2,929.160534),-- [general_55_c]
(20575,8736,1,1,2,232.244344),-- [special_55_c]
(20575,8746,1,1,2,23.261066),-- [rare_55_c]
(20575,8756,1,1,2,4.395792),-- [unique_55_c]
(20576,2119,1,1,-1,12928),-- [crystal_dagger_blade]
(20576,4145,1,1,-1,12443),-- [rp_avadon_leather_mail]
(20576,4591,1,1,-1,9457),-- [dye_c2s2_c]
(20576,57,1121,2284,0,700000),-- [adena]
(20576,855,1,1,1,107.178066),-- [nassen's_earing]
(20576,1918,1,1,1,7561.673208),-- [nassen's_earing_gemstone]
(20576,119,1,1,1,80.395506),-- [necklace_of_binding]
(20576,1920,1,1,1,5974.304355),-- [necklace_of_binding_chain]
(20576,886,1,1,1,160.767099),-- [ring_of_binding]
(20576,2917,1,1,1,10028.681766),-- [ring_of_binding_gemstone]
(20576,1865,1,1,2,80579.603656),-- [varnish]
(20576,1870,1,1,2,80579.603656),-- [coal]
(20576,1879,1,1,2,13429.995894),-- [cokes]
(20576,1875,1,1,2,5371.924016),-- [stone_of_purity]
(20576,4040,1,1,2,1611.540034),-- [mold_lubricant]
(20576,4187,1,1,2,92.741146),-- [rp_kris]
(20576,5155,1,1,2,161.135418),-- [rp_comp_soulshot_b]
(20576,5275,1,1,2,161.135418),-- [rp_adv_comp_spiritshot_b]
(20576,4178,1,1,2,1478.46857),-- [rp_shrnoen's_shield]
(20576,8726,1,1,2,1865.230744),-- [general_55_c]
(20576,8736,1,1,2,466.307686),-- [special_55_c]
(20576,8746,1,1,2,46.649354),-- [rare_55_c]
(20576,8756,1,1,2,9.664408),-- [unique_55_c]
(20577,351,1,1,-1,904),-- [blast_plate]
(20577,2030,1,1,-1,8256),-- [tome_of_blood_page]
(20577,2154,1,1,-1,75575),-- [rp_elven_earing]
(20577,57,298,595,0,700000),-- [adena]
(20577,849,1,1,1,379.875645),-- [tiger'seye_earing]
(20577,1901,1,1,1,12959.713458),-- [tiger'seye_earing_stone]
(20577,912,1,1,1,284.754159),-- [near_forest_necklace]
(20577,880,1,1,1,568.656738),-- [black_pearl_ring]
(20577,1872,1,1,2,71486.457854),-- [animal_bone]
(20577,1867,1,1,2,71486.457854),-- [animal_skin]
(20577,1881,1,1,2,7148.693846),-- [coarse_bone_powder]
(20577,1875,1,1,2,3574.266822),-- [stone_of_purity]
(20577,2154,1,1,2,5740.358064),-- [rp_elven_earing]
(20577,2274,1,1,2,382.88278),-- [rp_skull_breaker]
(20577,2270,1,1,2,382.88278),-- [rp_goathead_staff]
(20578,1882,1,1,-1,170581),-- [leather]
(20578,1939,1,1,-1,67424),-- [mithril_banded_gaiters_material]
(20578,1901,1,1,-1,106024),-- [tiger'seye_earing_stone]
(20578,57,324,649,0,700000),-- [adena]
(20578,278,1,1,1,54.892406),-- [gastraphetes]
(20578,2029,1,1,1,2434.107594),-- [gastraphetes_shaft]
(20578,1868,1,1,2,136045.376456),-- [thread]
(20578,1873,1,1,2,27208.950842),-- [silver_nugget]
(20578,5549,1,1,2,6802.393272),-- [iron_thread]
(20578,1889,1,1,2,4534.928848),-- [compound_braid]
(20578,2273,1,1,2,485.974126),-- [rp_tarbar]
(20578,6037,1,1,2,136045.376456),-- [scroll_of_awake]
(20579,1943,1,1,-1,63570),-- [manticor_skin_gaiters_pattern]
(20579,1946,1,1,-1,108154),-- [gauntlet_of_repose_of_the_soul_pattern]
(20579,1889,1,1,-1,53356),-- [compound_braid]
(20579,57,338,675,0,700000),-- [adena]
(20579,1124,1,1,1,90.093708),-- [boots_of_power]
(20579,1948,1,1,1,3494.156292),-- [boots_of_power_pattern]
(20579,2424,1,1,1,90.093708),-- [manticor_skin_boots]
(20579,2923,1,1,1,3494.156292),-- [manticor_skin_boots_lining]
(20579,2425,1,1,1,90.093708),-- [brigandine_boots]
(20579,2924,1,1,1,3494.156292),-- [brigandine_boots_design]
(20579,2426,1,1,1,90.093708),-- [elven_mithril_boots]
(20579,2925,1,1,1,3494.156292),-- [elven_mithril_boots_design]
(20579,606,1,1,1,90.093708),-- [gauntlet_of_repose_of_the_soul]
(20579,1946,1,1,1,3494.156292),-- [gauntlet_of_repose_of_the_soul_pattern]
(20579,2448,1,1,1,90.093708),-- [manticor_skin_gloves]
(20579,2926,1,1,1,3494.156292),-- [manticor_skin_gloves_linging]
(20579,2449,1,1,1,90.093708),-- [brigandine_gauntlet]
(20579,2927,1,1,1,3494.156292),-- [brigandine_gauntlet_pattern]
(20579,2450,1,1,1,90.093708),-- [elven_mithril_gloves]
(20579,2928,1,1,1,3494.156292),-- [elven_mithril_gloves_design]
(20579,1868,1,1,2,118204.00097),-- [thread]
(20579,1873,1,1,2,23640.800194),-- [silver_nugget]
(20579,5549,1,1,2,5910.288725),-- [iron_thread]
(20579,1889,1,1,2,3940.074248),-- [compound_braid]
(20579,2146,1,1,2,4221.533459),-- [rp_artisan's_frame]
(20579,2286,1,1,2,328.280403),-- [rp_bonebreaker]
(20579,6668,1,1,2,21108.022001),-- [key_of_treasure_box4]
(20580,2031,1,1,-1,15545),-- [morning_star_head]
(20580,1881,1,1,-1,204752),-- [coarse_bone_powder]
(20580,1868,1,7,-1,767821),-- [thread]
(20580,57,649,1296,0,700000),-- [adena]
(20580,395,1,1,1,230.755092),-- [manticor_skin_shirt]
(20580,1942,1,1,1,10122.343704),-- [manticor_skin_shirt_texture]
(20580,417,1,1,1,368.52486),-- [manticor_skin_gaiters]
(20580,1943,1,1,1,15762.376344),-- [manticor_skin_gaiters_pattern]
(20580,1868,1,1,2,264603.200807),-- [thread]
(20580,1873,1,1,2,52920.569394),-- [silver_nugget]
(20580,5549,1,1,2,13230.319267),-- [iron_thread]
(20580,1889,1,1,2,8820.094899),-- [compound_braid]
(20580,2194,1,1,2,13527.896184),-- [rp_mithril_glove]
(20580,2288,1,1,2,734.919449),-- [rp_ghost_staff]
(20581,2202,1,1,-1,88930),-- [rp_assault_boots]
(20581,2036,1,1,-1,8804),-- [skull_breaker_head]
(20581,1902,1,1,-1,88119),-- [elven_earing_beads]
(20581,57,368,733,0,700000),-- [adena]
(20581,279,1,1,1,41.86512),-- [strengthening_long_bow]
(20581,2040,1,1,1,2601.13488),-- [strengthening_long_bow_shaft]
(20581,1875,1,1,2,3330.25374),-- [stone_of_purity]
(20581,1879,1,1,2,8325.729148),-- [cokes]
(20581,1885,1,1,2,4162.769776),-- [high_grade_suede]
(20581,5550,1,1,2,666.050748),-- [reinforcing_plate]
(20581,5549,1,1,2,4995.475408),-- [iron_thread]
(20581,2287,1,1,2,277.568544),-- [rp_atuba_hammer]
(20581,2293,1,1,2,277.568544),-- [rp_glaive]
(20581,2198,1,1,2,1047.328304),-- [rp_sage's_rag]
(20581,1341,10,30,2,166513.255788),-- [bone_arrow]
(20582,1942,1,1,-1,88686),-- [manticor_skin_shirt_texture]
(20582,1894,1,1,-1,61006),-- [crafted_leather]
(20582,1825,1,1,-1,124192),-- [rp_oriharukon]
(20582,57,726,1449,0,700000),-- [adena]
(20582,629,1,1,1,496.832448),-- [kite_shield]
(20582,1947,1,1,1,21567.794024),-- [kite_shield_fragment]
(20582,2493,1,1,1,496.832448),-- [brigandine_shield]
(20582,2929,1,1,1,21567.794024),-- [brigandine_shield_fragment]
(20582,2411,1,1,1,347.95355),-- [brigandine_helmet]
(20582,2922,1,1,1,5768.793506),-- [brigandine_helmet_design]
(20582,1869,1,1,2,128395.14093),-- [iron_ore]
(20582,1864,1,3,2,85596.76062),-- [stem]
(20582,1880,1,1,2,12839.286236),-- [steel]
(20582,5550,1,1,2,1712.117498),-- [reinforcing_plate]
(20582,2987,1,1,2,12465.600756),-- [rp_plate_shield]
(20582,3020,1,1,2,713.19241),-- [rp_elven_long_sword]
(20582,1341,20,60,2,213991.90155),-- [bone_arrow]
(20583,1944,1,1,-1,46746),-- [mithril_tunic_fabric]
(20583,2157,1,1,-1,75739),-- [rp_onyxbeast'seye_earing]
(20583,1903,1,1,-1,152869),-- [elven_ring_piece]
(20583,57,383,764,0,700000),-- [adena]
(20583,261,1,1,1,44.109846),-- [bich'hwa]
(20583,2039,1,1,1,2397.890154),-- [bich'hwa_edge]
(20583,1870,1,1,2,78955.31538),-- [coal]
(20583,1865,1,1,2,78955.31538),-- [varnish]
(20583,1874,1,1,2,5263.61928),-- [oriharukon_ore]
(20583,2160,1,1,2,5093.95752),-- [rp_moonstone_earing]
(20583,2205,1,1,2,2498.57727),-- [rp_chain_gaiters]
(20583,5154,1,1,2,263.21517),-- [rp_comp_soulshot_c]
(20584,2988,1,1,-1,52906),-- [rp_tempered_mithril_gaiters]
(20584,2211,1,1,-1,28114),-- [rp_plate_leather]
(20584,1805,1,1,-1,4180),-- [rp_soulshot_c]
(20584,57,508,1017,0,700000),-- [adena]
(20584,280,1,1,1,45.401225),-- [cyclone_bow]
(20584,2054,1,1,1,2679.598775),-- [cyclone_bow_shaft]
(20584,1871,1,1,2,89948.031909),-- [charcoal]
(20584,1866,1,1,2,59965.290117),-- [suede]
(20584,1877,1,1,2,3597.905799),-- [admantite_nugget]
(20584,2297,1,1,2,392.73801),-- [rp_flamberge]
(20584,5154,1,1,2,299.87385),-- [rp_comp_soulshot_c]
(20584,2994,1,1,2,7138.738833),-- [rp_boots_of_seal]
(20584,6668,1,1,2,32124.421482),-- [key_of_treasure_box4]
(20585,2204,1,1,-1,24481),-- [rp_chain_mail_shirt]
(20585,2308,1,1,-1,5399),-- [rp_cursed_dagger]
(20585,1905,1,1,-1,120264),-- [onyxbeast'seye_earing_gemstone]
(20585,57,498,1006,0,700000),-- [adena]
(20585,159,1,1,1,8.951877),-- [bonebreaker]
(20585,2048,1,1,1,513.264114),-- [bonebreaker_head]
(20585,187,1,1,1,8.951877),-- [atuba_hammer]
(20585,2049,1,1,1,513.264114),-- [atuba_hammer_head]
(20585,188,1,1,1,8.951877),-- [ghost_staff]
(20585,2050,1,1,1,544.225473),-- [ghost_staff_head]
(20585,189,1,1,1,8.951877),-- [life_stick]
(20585,2051,1,1,1,544.225473),-- [life_stick_shaft]
(20585,190,1,1,1,8.951877),-- [atuba_mace]
(20585,2058,1,1,1,513.261441),-- [atuba_mace_head]
(20585,1875,1,1,2,5912.493115),-- [stone_of_purity]
(20585,1879,1,1,2,14781.25392),-- [cokes]
(20585,1885,1,1,2,7390.62696),-- [high_grade_suede]
(20585,5550,1,1,2,1182.49017),-- [reinforcing_plate]
(20585,5549,1,1,2,8868.760805),-- [iron_thread]
(20585,2988,1,1,2,3742.100835),-- [rp_tempered_mithril_gaiters]
(20585,2303,1,1,2,387.274195),-- [rp_skull_graver]
(20586,3954,1,1,-1,3974),-- [rp_blessed_spiritshot_c]
(20586,2314,1,1,-1,5206),-- [rp_body_slasher]
(20586,1884,1,1,-1,733590),-- [cord]
(20586,57,471,957,0,700000),-- [adena]
(20586,70,1,1,1,21.582811),-- [claymore]
(20586,2047,1,1,1,1315.818139),-- [claymore_blade]
(20586,2499,1,1,1,21.582811),-- [elven_long_sword]
(20586,2967,1,1,1,1298.016239),-- [elven_long_sword_blade]
(20586,1895,1,1,2,21378.974327),-- [metallic_fiber]
(20586,2164,1,1,2,5755.868048),-- [rp_ring_of_protection]
(20586,5154,1,1,2,249.427165),-- [rp_comp_soulshot_c]
(20586,2219,1,1,2,4647.593759),-- [rp_crimson_boots]
(20586,8723,1,1,2,2993.054254),-- [general_46_c]
(20586,8733,1,1,2,748.281495),-- [special_46_c]
(20586,8743,1,1,2,74.810218),-- [rare_46_c]
(20586,8753,1,1,2,14.990734),-- [unique_46_c]
(20587,2062,1,1,-1,8809),-- [scythe_edge]
(20587,1953,1,1,-1,35975),-- [sage's_rag_lining]
(20587,1875,1,1,-1,74876),-- [stone_of_purity]
(20587,57,442,906,0,700000),-- [adena]
(20587,89,1,1,1,3.762928),-- [big_hammer]
(20587,2061,1,1,1,256.376172),-- [big_hammer_head]
(20587,160,1,1,1,3.762928),-- [battle_axe]
(20587,2063,1,1,1,256.376172),-- [battle_axe_head]
(20587,161,1,1,1,3.762928),-- [war_pick]
(20587,2064,1,1,1,256.376172),-- [war_pick_head]
(20587,173,1,1,1,3.762928),-- [skull_graver]
(20587,2065,1,1,1,256.376172),-- [skull_graver_head]
(20587,191,1,1,1,3.762928),-- [heavy_doom_hammer]
(20587,2066,1,1,1,260.145262),-- [heavy_doom_hammer_head]
(20587,192,1,1,1,3.762928),-- [crystal_staff]
(20587,2067,1,1,1,239.052736),-- [crystal_staff_head]
(20587,193,1,1,1,3.762928),-- [stick_of_faith]
(20587,2068,1,1,1,239.052736),-- [stick_of_faith_shaft]
(20587,194,1,1,1,3.762928),-- [heavy_doom_axe]
(20587,2069,1,1,1,260.141154),-- [heavy_doom_axe_blade]
(20587,1864,1,1,2,81664.211306),-- [stem]
(20587,1865,1,1,2,40832.23241),-- [varnish]
(20587,1866,1,1,2,27221.319264),-- [suede]
(20587,1873,1,1,2,16332.892964),-- [silver_nugget]
(20587,1868,1,1,2,81664.211306),-- [thread]
(20587,2323,1,1,2,142.221354),-- [rp_elemental_bow]
(20587,2225,1,1,2,887.552514),-- [rp_demon's_hose]
(20587,2321,1,1,2,142.221354),-- [rp_stiletto]
(20587,3003,1,1,2,2536.154056),-- [rp_gloves_of_seal]
(20587,8723,1,1,2,1633.390702),-- [general_46_c]
(20587,8733,1,1,2,408.411054),-- [special_46_c]
(20587,8743,1,1,2,40.815754),-- [rare_46_c]
(20587,8753,1,1,2,8.365962),-- [unique_46_c]
(20588,1959,1,1,-1,59745),-- [chain_mail_shirt_material]
(20588,2324,1,1,-1,7728),-- [rp_noble_elven_bow]
(20588,57,585,1188,0,700000),-- [adena]
(20588,71,1,1,1,19.824375),-- [flamberge]
(20588,2059,1,1,1,1297.92295),-- [flamberge_blade]
(20588,72,1,1,1,19.824375),-- [stormbringer]
(20588,2060,1,1,1,1387.4283),-- [stormbringer_blade]
(20588,1868,1,1,2,127063.620066),-- [thread]
(20588,1873,1,1,2,25412.65443),-- [silver_nugget]
(20588,5549,1,1,2,6353.120118),-- [iron_thread]
(20588,1889,1,1,2,4235.529384),-- [compound_braid]
(20588,4044,1,1,2,2117.764692),-- [thons]
(20588,3003,1,1,2,3946.063272),-- [rp_gloves_of_seal]
(20588,2214,1,1,2,1576.407396),-- [rp_dwarven_chain_gaiters]
(20588,8723,1,1,2,2541.352422),-- [general_46_c]
(20588,8733,1,1,2,635.294616),-- [special_46_c]
(20588,8743,1,1,2,63.49467),-- [rare_46_c]
(20588,8753,1,1,2,12.698934),-- [unique_46_c]
(20589,1961,1,1,-1,70730),-- [tempered_mithril_shirt_fabric]
(20589,1962,1,1,-1,70730),-- [karmian_tunic_pattern]
(20589,1908,1,1,-1,209311),-- [moonstone_earing_wire]
(20589,57,874,1776,0,700000),-- [adena]
(20589,439,1,1,1,179.491936),-- [karmian_tunic]
(20589,1962,1,1,1,8357.661397),-- [karmian_tunic_pattern]
(20589,471,1,1,1,286.860088),-- [karmian_hose]
(20589,1954,1,1,1,13884.986579),-- [karmian_hose_pattern]
(20589,1868,1,1,2,189933.663237),-- [thread]
(20589,1873,1,1,2,37986.628635),-- [silver_nugget]
(20589,5549,1,1,2,9496.592151),-- [iron_thread]
(20589,1889,1,1,2,6331.234788),-- [compound_braid]
(20589,4044,1,1,2,3165.617394),-- [thons]
(20589,3003,1,1,2,5898.543204),-- [rp_gloves_of_seal]
(20589,2214,1,1,2,2356.400922),-- [rp_dwarven_chain_gaiters]
(20589,8723,1,1,2,3798.792879),-- [general_46_c]
(20589,8733,1,1,2,949.633212),-- [special_46_c]
(20589,8743,1,1,2,94.911315),-- [rare_46_c]
(20589,8753,1,1,2,18.982263),-- [unique_46_c]
(20590,2935,1,1,-1,121583),-- [tempered_mithril_gaiters_fragment]
(20590,2068,1,1,-1,16483),-- [stick_of_faith_shaft]
(20590,2163,1,1,-1,116683),-- [rp_earing_of_protection]
(20590,57,901,1842,0,700000),-- [adena]
(20590,354,1,1,1,139.06922),-- [chain_mail_shirt]
(20590,1959,1,1,1,7278.06059),-- [chain_mail_shirt_material]
(20590,381,1,1,1,222.47484),-- [chain_gaiters]
(20590,1960,1,1,1,14805.39535),-- [chain_gaiters_part]
(20590,1867,1,1,2,131013.650376),-- [animal_skin]
(20590,1872,1,1,2,131013.650376),-- [animal_bone]
(20590,1882,1,1,2,21835.707138),-- [leather]
(20590,1894,1,1,2,3447.774414),-- [crafted_leather]
(20590,4042,1,1,2,1637.537328),-- [enria]
(20590,2230,1,1,2,1904.140728),-- [rp_theca_leather_gaiters]
(20590,2320,1,1,2,342.437256),-- [rp_cursed_staff]
(20590,8723,1,1,2,3930.326568),-- [general_46_c]
(20590,8733,1,1,2,982.581642),-- [special_46_c]
(20590,8743,1,1,2,98.347032),-- [rare_46_c]
(20590,8753,1,1,2,19.847142),-- [unique_46_c]
(20591,2947,1,1,-1,191540),-- [dwarven_chain_shield_fragment]
(20591,951,1,1,-1,4876),-- [scrl_of_ench_wp_c]
(20591,1911,1,1,-1,199446),-- [earing_of_protection_gemstone]
(20591,57,1058,2159,0,700000),-- [adena]
(20591,94,1,1,1,53.767405),-- [bech_de_corbin]
(20591,2079,1,1,1,4081.232595),-- [bech_de_corbin_blade]
(20591,1867,1,1,2,144016.564776),-- [animal_skin]
(20591,1872,1,1,2,144016.564776),-- [animal_bone]
(20591,1882,1,1,2,24002.869338),-- [leather]
(20591,1894,1,1,2,3789.961014),-- [crafted_leather]
(20591,4042,1,1,2,1800.060528),-- [enria]
(20591,2230,1,1,2,2093.123928),-- [rp_theca_leather_gaiters]
(20591,2320,1,1,2,376.423656),-- [rp_cursed_staff]
(20591,8723,1,1,2,4320.405768),-- [general_46_c]
(20591,8733,1,1,2,1080.101442),-- [special_46_c]
(20591,8743,1,1,2,108.107832),-- [rare_46_c]
(20591,8753,1,1,2,21.816942),-- [unique_46_c]
(20592,1880,1,1,-1,368745),-- [steel]
(20592,2951,1,1,-1,310131),-- [rind_leather_gloves_design]
(20592,2166,1,1,-1,124998),-- [rp_earing_of_binding]
(20592,57,1458,2964,0,700000),-- [adena]
(20592,195,1,1,1,36.971484),-- [cursed_staff]
(20592,2082,1,1,1,2879.003028),-- [cursed_staff_head]
(20592,2502,1,1,1,36.971484),-- [dwarven_warhammer]
(20592,2968,1,1,1,2756.054004),-- [dwarven_warhammer_head]
(20592,1871,1,1,2,148529.640306),-- [charcoal]
(20592,1866,1,1,2,99019.85037),-- [suede]
(20592,1877,1,1,2,5941.218072),-- [admantite_nugget]
(20592,4041,1,1,2,1291.62795),-- [mold_hardener]
(20592,4040,1,1,2,2970.609036),-- [mold_lubricant]
(20592,2340,1,1,2,345.425946),-- [rp_paagrio_hammer]
(20592,3006,1,1,2,6062.401176),-- [rp_demon's_gloves]
(20592,8724,1,1,2,4950.924894),-- [general_49_c]
(20592,8734,1,1,2,1237.798848),-- [special_49_c]
(20592,8744,1,1,2,123.888084),-- [rare_49_c]
(20592,8754,1,1,2,24.615318),-- [unique_49_c]
(20593,2083,1,1,-1,26308),-- [stiletto_edge]
(20593,2341,1,1,-1,9208),-- [rp_sage's_staff]
(20593,1912,1,1,-1,426659),-- [ring_of_protection_gemstone]
(20593,57,1563,3187,0,700000),-- [adena]
(20593,398,1,1,1,127.866228),-- [plate_leather]
(20593,1966,1,1,1,8005.832895),-- [plate_leather_fragment]
(20593,399,1,1,1,117.910106),-- [rind_leather_mail]
(20593,1975,1,1,1,7202.472588),-- [rind_leather_mail_design]
(20593,418,1,1,1,204.47077),-- [plate_leather_gaiters]
(20593,1967,1,1,1,11959.606418),-- [plate_leather_gaiters_material]
(20593,419,1,1,1,188.796049),-- [rind_leather_gaiters]
(20593,1976,1,1,1,13334.044946),-- [rind_leather_gaiters_material]
(20593,1871,1,1,2,159483.576359),-- [charcoal]
(20593,1866,1,1,2,106322.481055),-- [suede]
(20593,1877,1,1,2,6379.377908),-- [admantite_nugget]
(20593,4041,1,1,2,1386.884425),-- [mold_hardener]
(20593,4040,1,1,2,3189.688954),-- [mold_lubricant]
(20593,2340,1,1,2,370.900819),-- [rp_paagrio_hammer]
(20593,3006,1,1,2,6509.498164),-- [rp_demon's_gloves]
(20593,8724,1,1,2,5316.051441),-- [general_49_c]
(20593,8734,1,1,2,1329.085472),-- [special_49_c]
(20593,8744,1,1,2,133.024726),-- [rare_49_c]
(20593,8754,1,1,2,26.430677),-- [unique_49_c]
(20594,1978,1,1,-1,173613),-- [tower_shield_fragment]
(20594,1871,1,5,-1,902788),-- [charcoal]
(20594,1895,1,1,-1,773819),-- [metallic_fiber]
(20594,57,1071,2178,0,700000),-- [adena]
(20594,231,1,1,1,16.948312),-- [grace_dagger]
(20594,2106,1,1,1,1526.051688),-- [grace_dagger_edge]
(20594,233,1,1,1,16.948312),-- [dark_screamer]
(20594,2107,1,1,1,1526.051688),-- [dark_screamer_edge]
(20594,1867,1,1,2,114873.23559),-- [animal_skin]
(20594,1872,1,1,2,114873.23559),-- [animal_bone]
(20594,1882,1,1,2,19145.400232),-- [leather]
(20594,1894,1,1,2,3022.855486),-- [crafted_leather]
(20594,4042,1,1,2,1435.932824),-- [enria]
(20594,2234,1,1,2,1284.108788),-- [rp_divine_hose]
(20594,4609,1,1,2,191.587474),-- [dye_m3i3_c]
(20594,2356,1,1,2,140.42333),-- [rp_demon's_staff]
(20594,6669,1,1,2,20036.04563),-- [key_of_treasure_box5]
(20594,8725,1,1,2,2393.314062),-- [general_52_c]
(20594,8735,1,1,2,598.398032),-- [special_52_c]
(20594,8745,1,1,2,59.78419),-- [rare_52_c]
(20594,8755,1,1,2,11.678772),-- [unique_52_c]
(20595,2096,1,1,-1,15374),-- [deathbreath_sword_blade]
(20595,2354,1,1,-1,4602),-- [rp_deadman's_staff]
(20595,1894,1,1,-1,98988),-- [crafted_leather]
(20595,57,1117,2270,0,700000),-- [adena]
(20595,231,1,1,1,17.651288),-- [grace_dagger]
(20595,2106,1,1,1,1589.348712),-- [grace_dagger_edge]
(20595,233,1,1,1,17.651288),-- [dark_screamer]
(20595,2107,1,1,1,1589.348712),-- [dark_screamer_edge]
(20595,1870,1,1,2,106059.604608),-- [coal]
(20595,1865,1,1,2,106059.604608),-- [varnish]
(20595,1874,1,1,2,7070.62446),-- [oriharukon_ore]
(20595,4043,1,1,2,3535.431084),-- [asofe]
(20595,4039,1,1,2,3535.431084),-- [mold_glue]
(20595,4125,1,1,2,4713.74964),-- [rp_maestro_mold]
(20595,3014,1,1,2,2962.554804),-- [rp_full_plate_boots]
(20595,8725,1,1,2,2946.152952),-- [general_52_c]
(20595,8735,1,1,2,736.419384),-- [special_52_c]
(20595,8745,1,1,2,73.68948),-- [rare_52_c]
(20595,8755,1,1,2,14.737896),-- [unique_52_c]
(20596,1875,1,1,-1,199596),-- [stone_of_purity]
(20596,1539,1,1,-1,665319),-- [greater_healing_potion]
(20596,4609,1,1,-1,6653),-- [dye_m3i3_c]
(20596,57,1189,2403,0,700000),-- [adena]
(20596,162,1,1,1,4.683114),-- [war_axe]
(20596,2097,1,1,1,414.443528),-- [war_axe_blade]
(20596,174,1,1,1,4.683114),-- [nirvana_axe]
(20596,2098,1,1,1,414.443528),-- [nirvana_axe_blade]
(20596,196,1,1,1,4.683114),-- [stick_of_eternity]
(20596,2099,1,1,1,436.170558),-- [stick_of_eternity_shaft]
(20596,197,1,1,1,4.683114),-- [paradia_staff]
(20596,2100,1,1,1,436.170558),-- [paradia_staff_head]
(20596,199,1,1,1,4.683114),-- [paagrio_hammer]
(20596,2102,1,1,1,420.525718),-- [paagrio_hammer_head]
(20596,200,1,1,1,4.683114),-- [sage's_staff]
(20596,2103,1,1,1,436.170558),-- [sage's_staff_head]
(20596,201,1,1,1,4.683114),-- [club_of_nature]
(20596,2104,1,1,1,436.170558),-- [club_of_nature_head]
(20596,202,1,1,1,4.683114),-- [mace_of_underworld]
(20596,2105,1,1,1,414.440082),-- [mace_of_underworld_head]
(20596,1873,1,1,2,35374.5169),-- [silver_nugget]
(20596,1868,1,1,2,176872.0131),-- [thread]
(20596,1876,1,1,2,17687.1156),-- [mithril_ore]
(20596,1895,1,1,2,25267.308),-- [metallic_fiber]
(20596,4042,1,1,2,1473.9263),-- [enria]
(20596,4608,1,1,2,196.5616),-- [dye_i3w3_c]
(20596,3017,1,1,2,2470.1622),-- [rp_blessed_gloves]
(20596,5155,1,1,2,176.8483),-- [rp_comp_soulshot_b]
(20596,6669,1,1,2,20566.4002),-- [key_of_treasure_box5]
(20596,8725,1,1,2,2456.4486),-- [general_52_c]
(20596,8735,1,1,2,614.255),-- [special_52_c]
(20596,8745,1,1,2,61.4255),-- [rare_52_c]
(20596,8755,1,1,2,12.8565),-- [unique_52_c]
(20597,3034,1,1,-1,9970),-- [rp_spiritshot_b]
(20597,2113,1,1,-1,24141),-- [scorpion_blade]
(20597,1918,1,1,-1,215903),-- [nassen's_earing_gemstone]
(20597,57,1973,4008,0,700000),-- [adena]
(20597,442,1,1,1,111.55485),-- [divine_tunic]
(20597,1988,1,1,1,8841.906414),-- [divine_tunic_fabric]
(20597,473,1,1,1,178.441758),-- [divine_hose]
(20597,1989,1,1,1,13869.096978),-- [divine_hose_pattern]
(20597,1870,1,1,2,153390.651687),-- [coal]
(20597,1865,1,1,2,153390.651687),-- [varnish]
(20597,1874,1,1,2,10226.110776),-- [oriharukon_ore]
(20597,4043,1,1,2,5113.055388),-- [asofe]
(20597,4039,1,1,2,5113.055388),-- [mold_glue]
(20597,4133,1,1,2,737.602341),-- [rp_shrnoen's_breastplate]
(20597,4959,1,1,2,2955.459129),-- [rp_avadon_boots_i]
(20597,4941,1,1,2,1179.961755),-- [rp_shrnoen's_gaiters_i]
(20597,8726,1,1,2,3550.658097),-- [general_55_c]
(20597,8736,1,1,2,887.748687),-- [special_55_c]
(20597,8746,1,1,2,88.875864),-- [rare_55_c]
(20597,8756,1,1,2,17.169201),-- [unique_55_c]
(20598,4180,1,1,-1,512556),-- [rp_silver_arrow]
(20598,2120,1,1,-1,22159),-- [great_pata_blade]
(20598,1806,1,1,-1,9226),-- [rp_soulshot_b]
(20598,57,1822,3711,0,700000),-- [adena]
(20598,442,1,1,1,103.2274),-- [divine_tunic]
(20598,1988,1,1,1,8181.867576),-- [divine_tunic_fabric]
(20598,473,1,1,1,165.121272),-- [divine_hose]
(20598,1989,1,1,1,12833.783752),-- [divine_hose_pattern]
(20598,1864,1,3,2,141938.691444),-- [stem]
(20598,1869,1,1,2,141938.691444),-- [iron_ore]
(20598,1878,1,1,2,56775.740571),-- [braided_hemp]
(20598,1884,1,1,2,87347.056269),-- [cord]
(20598,4039,1,1,2,4731.201717),-- [mold_glue]
(20598,4178,1,1,2,2604.294891),-- [rp_shrnoen's_shield]
(20598,4184,1,1,2,163.675908),-- [rp_sprite's_staff]
(20598,5160,1,1,2,283.792905),-- [rp_comp_spiritshot_b]
(20598,8726,1,1,2,3285.837852),-- [general_55_c]
(20598,8736,1,1,2,821.459463),-- [special_55_c]
(20598,8746,1,1,2,82.277943),-- [rare_55_c]
(20598,8756,1,1,2,16.279593),-- [unique_55_c]
(20599,2120,1,1,-1,23008),-- [great_pata_blade]
(20599,4146,1,1,-1,30703),-- [rp_tunic_of_shrnoen]
(20599,4590,1,1,-1,15966),-- [dye_s2d2_c]
(20599,57,1893,3856,0,700000),-- [adena]
(20599,2436,1,1,1,119.39733),-- [theca_leather_boots]
(20599,2954,1,1,1,7996.6068),-- [theca_leather_boots_texture]
(20599,2437,1,1,1,91.85982),-- [drake_leather_boots]
(20599,2960,1,1,1,6879.72831),-- [drake_leather_boots_design]
(20599,2438,1,1,1,91.85982),-- [full_plate_boots]
(20599,2961,1,1,1,6879.72831),-- [full_plate_boots_part]
(20599,2460,1,1,1,119.39733),-- [theca_leather_gloves]
(20599,2955,1,1,1,7996.6068),-- [theca_leather_gloves_texture]
(20599,2461,1,1,1,91.85982),-- [drake_leather_gloves]
(20599,2962,1,1,1,6879.72831),-- [drake_leather_gloves_design]
(20599,2462,1,1,1,91.85982),-- [full_plate_gauntlet]
(20599,2963,1,1,1,6879.72831),-- [full_plate_gauntlet_part]
(20599,2463,1,1,1,91.85982),-- [blessed_gloves]
(20599,2964,1,1,1,6879.7794),-- [blessed_gloves_pattern]
(20599,1864,1,3,2,147375.724428),-- [stem]
(20599,1869,1,1,2,147375.724428),-- [iron_ore]
(20599,1878,1,1,2,58950.563877),-- [braided_hemp]
(20599,1884,1,1,2,90692.929203),-- [cord]
(20599,4039,1,1,2,4912.432779),-- [mold_glue]
(20599,4178,1,1,2,2704.053717),-- [rp_shrnoen's_shield]
(20599,4184,1,1,2,169.945596),-- [rp_sprite's_staff]
(20599,5160,1,1,2,294.663735),-- [rp_comp_spiritshot_b]
(20599,8726,1,1,2,3411.703524),-- [general_55_c]
(20599,8736,1,1,2,852.925881),-- [special_55_c]
(20599,8746,1,1,2,85.429641),-- [rare_55_c]
(20599,8756,1,1,2,16.903191),-- [unique_55_c]
(20600,1945,1,1,-1,85765),-- [mithril_hose_design]
(20600,1873,1,1,-1,431910),-- [silver_nugget]
(20600,1825,1,1,-1,77127),-- [rp_oriharukon]
(20600,57,451,900,0,700000),-- [adena]
(20600,629,1,1,1,308.545152),-- [kite_shield]
(20600,1947,1,1,1,13394.129776),-- [kite_shield_fragment]
(20600,2493,1,1,1,308.545152),-- [brigandine_shield]
(20600,2929,1,1,1,13394.129776),-- [brigandine_shield_fragment]
(20600,2411,1,1,1,216.0877),-- [brigandine_helmet]
(20600,2922,1,1,1,3582.562444),-- [brigandine_helmet_design]
(20600,1868,1,1,2,186053.4229),-- [thread]
(20600,1873,1,1,2,37210.68458),-- [silver_nugget]
(20600,5549,1,1,2,9302.54818),-- [iron_thread]
(20600,1889,1,1,2,6201.86274),-- [compound_braid]
(20600,5231,1,1,2,6644.78267),-- [rp_reinforcing_agent]
(20600,2286,1,1,2,516.69893),-- [rp_bonebreaker]
(20601,1880,1,1,-1,97232),-- [steel]
(20601,2304,1,1,-1,4246),-- [rp_heavy_doom_hammer]
(20601,1905,1,1,-1,94584),-- [onyxbeast'seye_earing_gemstone]
(20601,57,394,788,0,700000),-- [adena]
(20601,353,1,1,1,81.160755),-- [half_plate]
(20601,1950,1,1,1,3961.994595),-- [half_plate_temper]
(20601,380,1,1,1,129.859275),-- [plate_gaiters]
(20601,1951,1,1,1,6161.985375),-- [plate_gaiters_part]
(20601,1869,1,1,2,81375.90135),-- [iron_ore]
(20601,1864,1,1,2,162751.8027),-- [stem]
(20601,1880,1,1,2,8137.590135),-- [steel]
(20601,5550,1,1,2,1085.029155),-- [reinforcing_plate]
(20601,2199,1,1,2,3433.483635),-- [rp_karmian_hose]
(20601,5269,1,1,2,271.193025),-- [rp_adv_comp_soulshot_c]
(20602,1889,1,1,-1,87565),-- [compound_braid]
(20602,2999,1,1,-1,88153),-- [rp_plate_leather_gloves]
(20602,1873,1,1,-1,525391),-- [silver_nugget]
(20602,57,529,1069,0,700000),-- [adena]
(20602,280,1,1,1,47.550494),-- [cyclone_bow]
(20602,2054,1,1,1,2806.449506),-- [cyclone_bow_shaft]
(20602,1873,1,1,2,32978.3484),-- [silver_nugget]
(20602,1868,1,1,2,164892.22504),-- [thread]
(20602,1876,1,1,2,16489.29496),-- [mithril_ore]
(20602,1895,1,1,2,23555.92864),-- [metallic_fiber]
(20602,2300,1,1,2,360.10632),-- [rp_scythe]
(20602,2205,1,1,2,2609.14056),-- [rp_chain_gaiters]
(20602,5154,1,1,2,274.84976),-- [rp_comp_soulshot_c]
(20602,2311,1,1,2,360.10632),-- [rp_chakram]
(20603,1952,1,1,-1,34740),-- [slamander_skin_mail_texture]
(20603,2311,1,1,-1,4736),-- [rp_chakram]
(20603,1872,1,3,-1,723055),-- [animal_bone]
(20603,57,429,871,0,700000),-- [adena]
(20603,1125,1,1,1,120.706722),-- [assault_boots]
(20603,1957,1,1,1,5065.605866),-- [assault_boots_part]
(20603,2427,1,1,1,120.706722),-- [slamander_skin_boots]
(20603,2931,1,1,1,5065.605866),-- [slamander_skin_boots_lining]
(20603,2428,1,1,1,120.706722),-- [plate_boots]
(20603,2932,1,1,1,5065.605866),-- [plate_boots_design]
(20603,61,1,1,1,120.706722),-- [mithril_glove]
(20603,1949,1,1,1,5065.605866),-- [mithril_glove_design]
(20603,607,1,1,1,120.706722),-- [ogre_power_gauntlet]
(20603,1963,1,1,1,5065.605866),-- [ogre_power_gauntlet_part]
(20603,2451,1,1,1,120.706722),-- [sage's_worn_gloves]
(20603,2933,1,1,1,5065.730338),-- [sage's_worn_gloves_lining]
(20603,1872,1,1,2,103738.405455),-- [animal_bone]
(20603,1867,1,1,2,103738.405455),-- [animal_skin]
(20603,1881,1,1,2,10373.969175),-- [coarse_bone_powder]
(20603,1875,1,1,2,5186.855958),-- [stone_of_purity]
(20603,2991,1,1,2,6174.987777),-- [rp_karmian_boots]
(20603,5279,1,1,2,259.317072),-- [rp_adv_comp_bspiritshot_c]
(20603,6668,1,1,2,27787.059108),-- [key_of_treasure_box4]
(20604,2323,1,1,-1,4611),-- [rp_elemental_bow]
(20604,2322,1,1,-1,4611),-- [rp_dagger_of_magicflame]
(20604,4553,1,1,-1,5293),-- [dye_s1c1_c]
(20604,57,521,1068,0,700000),-- [adena]
(20604,852,1,1,1,174.744034),-- [moonstone_earing]
(20604,1908,1,1,1,9871.30634),-- [moonstone_earing_wire]
(20604,915,1,1,1,131.114666),-- [aquastone_necklace]
(20604,1910,1,1,1,7849.467052),-- [aquastone_necklace_chain]
(20604,883,1,1,1,262.229332),-- [aquastone_ring]
(20604,1909,1,1,1,14077.138576),-- [aquastone_ring_wire]
(20604,1872,1,1,2,119127.041145),-- [animal_bone]
(20604,1867,1,1,2,119127.041145),-- [animal_skin]
(20604,1881,1,1,2,11912.851825),-- [coarse_bone_powder]
(20604,1875,1,1,2,5956.278202),-- [stone_of_purity]
(20604,2991,1,1,2,7090.990263),-- [rp_karmian_boots]
(20604,5279,1,1,2,297.784368),-- [rp_adv_comp_bspiritshot_c]
(20604,6668,1,1,2,31909.013052),-- [key_of_treasure_box4]
(20605,2059,1,1,-1,8915),-- [flamberge_blade]
(20605,1867,1,3,-1,800154),-- [animal_skin]
(20605,1908,1,1,-1,113658),-- [moonstone_earing_wire]
(20605,57,475,964,0,700000),-- [adena]
(20605,439,1,1,1,97.464224),-- [karmian_tunic]
(20605,1962,1,1,1,4538.214923),-- [karmian_tunic_pattern]
(20605,471,1,1,1,155.765192),-- [karmian_hose]
(20605,1954,1,1,1,7539.555661),-- [karmian_hose_pattern]
(20605,1868,1,1,2,103136.2924),-- [thread]
(20605,1873,1,1,2,20627.202),-- [silver_nugget]
(20605,5549,1,1,2,5156.7652),-- [iron_thread]
(20605,1889,1,1,2,3437.9376),-- [compound_braid]
(20605,4044,1,1,2,1718.9688),-- [thons]
(20605,3003,1,1,2,3202.9808),-- [rp_gloves_of_seal]
(20605,2214,1,1,2,1279.5544),-- [rp_dwarven_chain_gaiters]
(20605,8723,1,1,2,2062.7908),-- [general_46_c]
(20605,8733,1,1,2,515.6624),-- [special_46_c]
(20605,8743,1,1,2,51.538),-- [rare_46_c]
(20605,8753,1,1,2,10.3076),-- [unique_46_c]
(20606,2260,1,1,-1,12244),-- [rp_mace_of_judgment]
(20606,1932,1,1,-1,125162),-- [bone_helmet_design]
(20606,2152,1,1,-1,138824),-- [rp_enchanted_necklace]
(20606,57,340,656,0,700000),-- [adena]
(20606,220,1,1,1,281),-- [handiwork_dagger]
(20606,1869,1,1,2,88508.21265),-- [iron_ore]
(20606,1864,1,1,2,177016.4253),-- [stem]
(20606,1880,1,1,2,8850.95973),-- [steel]
(20606,5550,1,1,2,1179.99873),-- [reinforcing_plate]
(20606,2262,1,1,2,1374.40359),-- [rp_elven_bow]
(20607,626,1,1,-1,9809),-- [bronze_shield]
(20607,2020,1,1,-1,14509),-- [temptation_of_abyss_piece]
(20607,1899,1,1,-1,129508),-- [necklace_of_devotion_chain]
(20607,57,355,696,0,700000),-- [adena]
(20607,101,1,1,1,59.073875),-- [scroll_of_wisdom]
(20607,312,1,1,1,59.073875),-- [branch_of_life]
(20607,313,1,1,1,59.073875),-- [temptation_of_abyss]
(20607,2020,1,1,1,1628.70823),-- [temptation_of_abyss_piece]
(20607,314,1,1,1,59.070145),-- [proof_of_revenge]
(20607,1870,1,1,2,116293.764398),-- [coal]
(20607,1865,1,1,2,116293.764398),-- [varnish]
(20607,1874,1,1,2,7753.030628),-- [oriharukon_ore]
(20607,2262,1,1,2,1805.440576),-- [rp_elven_bow]
(20608,1874,1,1,-1,55672),-- [oriharukon_ore]
(20608,2022,1,1,-1,13008),-- [mace_of_judgment_head]
(20608,2153,1,1,-1,129874),-- [rp_tiger'seye_earing]
(20608,57,354,701,0,700000),-- [adena]
(20608,315,1,1,1,184),-- [divine_tome]
(20608,1872,1,1,2,86922.24825),-- [animal_bone]
(20608,1867,1,1,2,86922.24825),-- [animal_skin]
(20608,1881,1,1,2,8692.224825),-- [coarse_bone_powder]
(20608,1875,1,1,2,4346.207879),-- [stone_of_purity]
(20608,2265,1,1,2,674.184423),-- [rp_spike_club]
(20608,2274,1,1,2,465.685587),-- [rp_skull_breaker]
(20608,2189,1,1,2,2910.200786),-- [rp_mithril_tunic]
(20609,2265,1,1,-1,8969),-- [rp_spike_club]
(20609,433,1,1,-1,2256),-- [elven_tunic]
(20609,1900,1,1,-1,94887),-- [enchanted_necklace_chain]
(20609,57,366,732,0,700000),-- [adena]
(20609,259,1,1,1,191),-- [single-edged_jamadhr]
(20609,1866,1,1,2,52658.392072),-- [suede]
(20609,1871,1,1,2,78987.588108),-- [charcoal]
(20609,5220,1,1,2,3159.573144),-- [reinforcing_agent]
(20609,1885,1,1,2,6582.347356),-- [high_grade_suede]
(20609,956,1,1,2,2632.97762),-- [scrl_of_ench_am_d]
(20609,6667,1,1,2,49367.1217),-- [key_of_treasure_box3]
(20610,2025,1,1,-1,12109),-- [dwarven_trident_edge]
(20610,2267,1,1,-1,9041),-- [rp_gastraphetes]
(20610,1864,1,3,-1,874300),-- [stem]
(20610,57,370,737,0,700000),-- [adena]
(20610,292,1,1,1,193),-- [pike]
(20610,1864,1,1,2,119442.817208),-- [stem]
(20610,1865,1,1,2,59721.408604),-- [varnish]
(20610,1866,1,1,2,39814.117002),-- [suede]
(20610,1873,1,1,2,23888.656682),-- [silver_nugget]
(20610,1868,1,1,2,119442.817208),-- [thread]
(20610,2183,1,1,2,3929.150456),-- [rp_mithril_banded_mail]
(20610,2270,1,1,2,426.57483),-- [rp_goathead_staff]
(20610,1341,20,60,2,99536.45801),-- [bone_arrow]
(20611,2153,1,1,-1,143948),-- [rp_tiger'seye_earing]
(20611,467,1,1,-1,3857),-- [dark_hose]
(20611,1884,1,1,-1,569592),-- [cord]
(20611,57,390,782,0,700000),-- [adena]
(20611,86,1,1,1,20.416164),-- [tomahawk]
(20611,179,1,1,1,20.416164),-- [mace_of_prayer]
(20611,180,1,1,1,20.416164),-- [mace_of_judgment]
(20611,2022,1,1,1,787.87962),-- [mace_of_judgment_head]
(20611,181,1,1,1,20.416164),-- [mace_of_miracle]
(20611,182,1,1,1,20.416164),-- [doom_hammer]
(20611,183,1,1,1,20.416164),-- [mystic_staff]
(20611,184,1,1,1,20.416164),-- [conjure_staff]
(20611,2023,1,1,1,626.78949),-- [conjure_staff_head]
(20611,185,1,1,1,20.417742),-- [staff_of_mana]
(20611,1864,1,1,2,144513.606),-- [stem]
(20611,1869,1,1,2,72256.803),-- [iron_ore]
(20611,1878,1,1,2,28902.803),-- [braided_hemp]
(20611,1884,1,1,2,44465.662),-- [cord]
(20611,1829,1,1,2,28902.803),-- [scroll_of_escape_to_agit]
(20611,2193,1,1,2,9672.85),-- [rp_boots_of_power]
(20611,1834,1,1,2,80285.473),-- [emergency_dressing]
(20612,349,1,1,-1,1496),-- [compound_scale_mail]
(20612,1869,1,3,-1,527615),-- [iron_ore]
(20612,1885,1,1,-1,87936),-- [high_grade_suede]
(20612,57,446,892,0,700000),-- [adena]
(20612,436,1,1,1,479.533068),-- [tunic_of_knowledge]
(20612,469,1,1,1,766.466932),-- [hose_of_knowledge]
(20612,1866,1,1,2,53433.989025),-- [suede]
(20612,1871,1,1,2,80151.10295),-- [charcoal]
(20612,5220,1,1,2,3205.9868),-- [reinforcing_agent]
(20612,1885,1,1,2,6679.218775),-- [high_grade_suede]
(20612,2188,1,1,2,5725.1129),-- [rp_manticor_skin_gaiters]
(20612,2274,1,1,2,572.463525),-- [rp_skull_breaker]
(20612,1832,1,1,2,89057.126025),-- [advanced_antidote]
(20613,40,1,1,-1,9795),-- [leather_boots]
(20613,1934,1,1,-1,103074),-- [excellence_leather_gloves_lining]
(20613,1899,1,1,-1,123206),-- [necklace_of_devotion_chain]
(20613,57,340,656,0,700000),-- [adena]
(20613,432,1,1,1,917.992572),-- [cursed_tunic]
(20613,465,1,1,1,1470.007428),-- [cursed_hose]
(20613,1864,1,1,2,126440.201944),-- [stem]
(20613,1865,1,1,2,63220.100972),-- [varnish]
(20613,1866,1,1,2,42146.577711),-- [suede]
(20613,1873,1,1,2,25288.134151),-- [silver_nugget]
(20613,1868,1,1,2,126440.201944),-- [thread]
(20613,2263,1,1,2,981.690234),-- [rp_dwarven_trident]
(20613,1831,1,3,2,84294.093044),-- [antidote]
(20614,1869,1,1,-1,774589),-- [iron_ore]
(20614,1899,1,1,-1,121030),-- [necklace_of_devotion_chain]
(20614,2152,1,1,-1,136371),-- [rp_enchanted_necklace]
(20614,57,332,650,0,700000),-- [adena]
(20614,220,1,1,1,276),-- [handiwork_dagger]
(20614,1870,1,1,2,86944.667355),-- [coal]
(20614,1865,1,1,2,86944.667355),-- [varnish]
(20614,1874,1,1,2,5796.311157),-- [oriharukon_ore]
(20614,2263,1,1,2,1350.168183),-- [rp_dwarven_trident]
(20614,1834,1,1,2,96605.18595),-- [emergency_dressing]
(20615,2185,1,1,-1,175902),-- [rp_iron_boots]
(20615,392,1,1,-1,2324),-- [lion_skin_shirt]
(20615,1900,1,1,-1,97766),-- [enchanted_necklace_chain]
(20615,57,379,750,0,700000),-- [adena]
(20615,627,1,1,1,1815.325785),-- [aspis]
(20615,46,1,1,1,1271.674215),-- [bronze_helmet]
(20615,1875,1,1,2,4650.55716),-- [stone_of_purity]
(20615,1879,1,1,2,11626.501128),-- [cokes]
(20615,1885,1,1,2,5813.250564),-- [high_grade_suede]
(20615,5550,1,1,2,930.111432),-- [reinforcing_plate]
(20615,5549,1,1,2,6975.943968),-- [iron_thread]
(20615,2266,1,1,2,721.447848),-- [rp_knife_o'_silenus]
(20615,1834,1,1,2,77510.1879),-- [emergency_dressing]
(20616,1874,1,1,-1,61682),-- [oriharukon_ore]
(20616,1937,1,1,-1,79487),-- [scale_gaiters_fragment]
(20616,2153,1,1,-1,143893),-- [rp_tiger'seye_earing]
(20616,57,390,781,0,700000),-- [adena]
(20616,433,1,1,1,164.372203),-- [elven_tunic]
(20616,434,1,1,1,164.372203),-- [white_tunic]
(20616,1936,1,1,1,5172.133267),-- [white_tunic_pattern]
(20616,435,1,1,1,164.372203),-- [mage's_tunic]
(20616,466,1,1,1,263.345578),-- [elven_hose]
(20616,467,1,1,1,263.345578),-- [dark_hose]
(20616,1933,1,1,1,7435.699499),-- [dark_hose_fabric]
(20616,468,1,1,1,263.359469),-- [mage's_hose]
(20616,1872,1,1,2,84267.395842),-- [animal_bone]
(20616,1867,1,1,2,84267.395842),-- [animal_skin]
(20616,1881,1,1,2,8426.833947),-- [coarse_bone_powder]
(20616,1875,1,1,2,4213.29902),-- [stone_of_purity]
(20616,737,1,1,2,6319.94853),-- [scroll_of_resurrection]
(20616,2274,1,1,2,451.525998),-- [rp_skull_breaker]
(20616,2976,1,1,2,8460.568648),-- [rp_manticor_skin_boots]
(20616,6667,1,1,2,39500.032173),-- [key_of_treasure_box3]
(20617,435,1,1,-1,2296),-- [mage's_tunic]
(20617,1875,1,1,-1,58864),-- [stone_of_purity]
(20617,1933,1,1,-1,103877),-- [dark_hose_fabric]
(20617,57,373,744,0,700000),-- [adena]
(20617,392,1,1,1,627.573331),-- [lion_skin_shirt]
(20617,414,1,1,1,1005.426669),-- [lion_skin_gaiters]
(20617,1872,1,1,2,128667.265196),-- [animal_bone]
(20617,1867,1,1,2,128667.265196),-- [animal_skin]
(20617,1881,1,1,2,12866.841228),-- [coarse_bone_powder]
(20617,1875,1,1,2,6433.420614),-- [stone_of_purity]
(20617,2184,1,1,2,10136.207766),-- [rp_mithril_banded_gaiters]
(20618,1885,1,1,-1,81279),-- [high_grade_suede]
(20618,1935,1,1,-1,54489),-- [scale_mail_fragment]
(20618,955,1,1,-1,3901),-- [scrl_of_ench_wp_d]
(20618,57,411,824,0,700000),-- [adena]
(20618,315,1,1,1,215),-- [divine_tome]
(20618,1875,1,1,2,5922.148167),-- [stone_of_purity]
(20618,1879,1,1,2,14805.344411),-- [cokes]
(20618,1885,1,1,2,7402.646199),-- [high_grade_suede]
(20618,5550,1,1,2,1184.440036),-- [reinforcing_plate]
(20618,5549,1,1,2,8883.196244),-- [iron_thread]
(20618,2153,1,1,2,13815.224943),-- [rp_tiger'seye_earing]
(20619,2981,1,1,-1,134055),-- [rp_elven_mithril_gloves]
(20619,2270,1,1,-1,7153),-- [rp_goathead_staff]
(20619,1867,1,3,-1,667594),-- [animal_skin]
(20619,57,423,846,0,700000),-- [adena]
(20619,157,1,1,1,47.73208),-- [spike_club]
(20619,2027,1,1,1,2324.53584),-- [spike_club_head]
(20619,186,1,1,1,47.73208),-- [staff_of_magicpower]
(20619,1872,1,1,2,118318.290624),-- [animal_bone]
(20619,1867,1,1,2,118318.290624),-- [animal_skin]
(20619,1881,1,1,2,11831.93487),-- [coarse_bone_powder]
(20619,1875,1,1,2,5915.967435),-- [stone_of_purity]
(20619,2154,1,1,2,9500.993442),-- [rp_elven_earing]
(20619,2278,1,1,2,633.523005),-- [rp_strengthening_long_bow]
(20620,4051,1,1,-1,204462),-- [adamantite_necklace_chain]
(20620,948,1,1,-1,13180),-- [scrl_of_ench_am_b]
(20620,4039,1,1,-1,175735),-- [mold_glue]
(20620,57,2089,4237,0,700000),-- [adena]
(20620,78,1,1,1,7.771049),-- [great_sword]
(20620,4104,1,1,1,1485.236753),-- [great_sword_blade]
(20620,142,1,1,1,7.771049),-- [kshanberk]
(20620,4107,1,1,1,1462.22505),-- [kshanberk_blade]
(20620,148,1,1,1,7.771049),-- [sword_of_valhalla]
(20620,4108,1,1,1,1462.22505),-- [sword_of_valhalla_blade]
(20620,1894,1,1,2,4967.418016),-- [crafted_leather]
(20620,4039,1,1,2,4719.04816),-- [mold_glue]
(20620,4041,1,1,2,1231.046048),-- [mold_hardener]
(20620,4044,1,1,2,4719.04816),-- [thons]
(20620,4614,1,1,2,195.27312),-- [dye_s4d4_c]
(20620,4402,1,1,2,283.1408),-- [blue_dimension_stone]
(20620,4999,1,1,2,1760.843232),-- [rp_doom_boots_i]
(20620,8728,1,1,2,2359.513632),-- [general_61_b]
(20620,8738,1,1,2,589.873184),-- [special_61_b]
(20620,8748,1,1,2,58.989408),-- [rare_61_b]
(20620,8758,1,1,2,11.80624),-- [unique_61_b]
(20621,4199,1,1,-1,4349),-- [rp_hazard_bow]
(20621,4052,1,1,-1,201691),-- [earing_of_black_ore_piece]
(20621,5230,1,1,-1,7596),-- [rp_mithril_arrow]
(20621,57,2259,4576,0,700000),-- [adena]
(20621,2391,1,1,1,27.888624),-- [blue_wolve's_leather_mail]
(20621,4082,1,1,1,4754.111376),-- [blue_wolve's_leather_mail_texture]
(20621,2392,1,1,1,27.888624),-- [leather_mail_of_doom]
(20621,4083,1,1,1,4754.111376),-- [leather_mail_of_doom_design]
(20621,1873,1,1,2,61190.3327),-- [silver_nugget]
(20621,1868,1,1,2,305951.6635),-- [thread]
(20621,1876,1,1,2,30595.38986),-- [mithril_ore]
(20621,1895,1,1,2,43707.3805),-- [metallic_fiber]
(20621,4042,1,1,2,2549.80208),-- [enria]
(20621,4623,1,1,2,210.99344),-- [dye_w4i4_c]
(20621,5276,1,1,2,203.84112),-- [rp_adv_comp_spiritshot_a]
(20621,8729,1,1,2,2039.75226),-- [general_64_a]
(20621,8739,1,1,2,510.04982),-- [special_64_a]
(20621,8749,1,1,2,50.96028),-- [rare_64_a]
(20621,8759,1,1,2,9.83444),-- [unique_64_a]
(20622,4044,1,1,-1,203292),-- [thons]
(20622,4042,1,1,-1,101646),-- [enria]
(20622,4053,1,1,-1,261413),-- [ring_of_black_ore_gemstone]
(20622,57,2419,4898,0,700000),-- [adena]
(20622,864,1,1,1,84.45667),-- [earing_of_black_ore]
(20622,4052,1,1,1,10629.36916),-- [earing_of_black_ore_piece]
(20622,926,1,1,1,63.349924),-- [necklace_of_black_ore]
(20622,4054,1,1,1,5913.4512),-- [necklace_of_black_ore_beads]
(20622,895,1,1,1,126.670162),-- [ring_of_black_ore]
(20622,4053,1,1,1,12868.702884),-- [ring_of_black_ore_gemstone]
(20622,1867,1,1,2,200165.035026),-- [animal_skin]
(20622,1872,1,1,2,200165.035026),-- [animal_bone]
(20622,1882,1,1,2,33361.07434),-- [leather]
(20622,1894,1,1,2,5267.315262),-- [crafted_leather]
(20622,4042,1,1,2,2502.19816),-- [enria]
(20622,4988,1,1,2,994.294532),-- [rp_blue_wolve's_hose_i]
(20622,4401,1,1,2,300.075644),-- [green_dimension_stone]
(20622,6670,1,1,2,25020.570586),-- [key_of_treasure_box6]
(20622,8729,1,1,2,2001.758528),-- [general_64_a]
(20622,8739,1,1,2,500.439632),-- [special_64_a]
(20622,8749,1,1,2,49.855828),-- [rare_64_a]
(20622,8759,1,1,2,10.347436),-- [unique_64_a]
(20623,4039,1,1,-1,271715),-- [mold_glue]
(20623,4040,1,1,-1,163029),-- [mold_lubricant]
(20623,5230,1,1,-1,10869),-- [rp_mithril_arrow]
(20623,57,3236,6545,0,700000),-- [adena]
(20623,110,1,1,1,123.516382),-- [doom_shield]
(20623,4077,1,1,1,18053.98595),-- [doom_shield_fragment]
(20623,2416,1,1,1,86.466336),-- [blue_wolve's_helmet]
(20623,4088,1,1,1,15167.782498),-- [blue_wolve's_helmet_design]
(20623,2417,1,1,1,86.466336),-- [doom_helmet]
(20623,4089,1,1,1,15167.782498),-- [doom_helmet_pattern]
(20623,1868,1,3,2,218891.932928),-- [thread]
(20623,1873,1,1,2,87556.701409),-- [silver_nugget]
(20623,5549,1,1,2,21889.265055),-- [iron_thread]
(20623,1889,1,1,2,14592.84337),-- [compound_braid]
(20623,4044,1,1,2,7296.421685),-- [thons]
(20623,4177,1,1,2,4217.464494),-- [rp_shrnoen's_gauntlet]
(20623,5332,1,1,2,630.789738),-- [rp_sealed_dark_crystal_leather_mail_i]
(20623,8729,1,1,2,2918.568674),-- [general_64_a]
(20623,8739,1,1,2,729.462763),-- [special_64_a]
(20623,8749,1,1,2,72.838633),-- [rare_64_a]
(20623,8759,1,1,2,14.711251),-- [unique_64_a]
(20624,1877,1,1,-1,332612),-- [admantite_nugget]
(20624,4054,1,1,-1,163784),-- [necklace_of_black_ore_beads]
(20624,4052,1,1,-1,294399),-- [earing_of_black_ore_piece]
(20624,57,3295,6681,0,700000),-- [adena]
(20624,79,1,1,1,8.113194),-- [sword_of_damascus]
(20624,4114,1,1,1,1792.222368),-- [sword_of_damascus_blade]
(20624,7883,1,1,1,8.113194),-- [guardians_sword]
(20624,8330,1,1,1,1789.210284),-- [guardians_sword_blade]
(20624,7889,1,1,1,8.113194),-- [tears_of_wizard]
(20624,8336,1,1,1,1792.227766),-- [tears_of_wizard_blade]
(20624,1873,1,1,2,75575.770128),-- [silver_nugget]
(20624,1868,1,3,2,188939.42532),-- [thread]
(20624,1876,1,1,2,37787.885064),-- [mithril_ore]
(20624,1895,1,1,2,53982.588264),-- [metallic_fiber]
(20624,4042,1,1,2,3149.17362),-- [enria]
(20624,4154,1,1,2,2236.114788),-- [rp_doom_shield]
(20624,4403,1,1,2,377.754276),-- [red_dimension_stone]
(20624,5281,1,1,2,252.080448),-- [rp_adv_comp_bspiritshot_a]
(20624,5340,1,1,2,870.556896),-- [rp_sealed_legging_of_dark_crystal_i]
(20624,8729,1,1,2,2519.338896),-- [general_64_a]
(20624,8739,1,1,2,629.834724),-- [special_64_a]
(20624,8749,1,1,2,63.020112),-- [rare_64_a]
(20624,8759,1,1,2,12.457464),-- [unique_64_a]
(20625,4043,1,1,-1,277527),-- [asofe]
(20625,4044,1,1,-1,277527),-- [thons]
(20625,5230,1,1,-1,11101),-- [rp_mithril_arrow]
(20625,57,3298,6689,0,700000),-- [adena]
(20625,268,1,1,1,24.37197),-- [bellion_cestus]
(20625,4120,1,1,1,5373.62803),-- [bellion_cestus_edge]
(20625,1894,1,1,2,8629.183836),-- [crafted_leather]
(20625,4039,1,1,2,8197.7103),-- [mold_glue]
(20625,4041,1,1,2,2138.528964),-- [mold_hardener]
(20625,4044,1,1,2,8197.7103),-- [thons]
(20625,4192,1,1,2,187.74964),-- [rp_sword_of_damascus]
(20625,5276,1,1,2,327.908412),-- [rp_adv_comp_spiritshot_a]
(20625,8729,1,1,2,3279.08412),-- [general_64_a]
(20625,8739,1,1,2,819.786968),-- [special_64_a]
(20625,8749,1,1,2,81.985072),-- [rare_64_a]
(20625,8759,1,1,2,16.352388),-- [unique_64_a]
(20626,1875,1,1,-1,685963),-- [stone_of_purity]
(20626,4053,1,1,-1,441039),-- [ring_of_black_ore_gemstone]
(20626,5230,1,1,-1,13719),-- [rp_mithril_arrow]
(20626,57,4056,8290,0,700000),-- [adena]
(20626,358,1,1,1,40.93388),-- [blue_wolve's_breastplate]
(20626,4078,1,1,1,7399.831335),-- [blue_wolve's_breastplate_part]
(20626,2381,1,1,1,25.19361),-- [doom_plate_armor]
(20626,4081,1,1,1,4993.038505),-- [doom_plate_armor_temper]
(20626,2380,1,1,1,65.48503),-- [blue_wolve's_gaiters]
(20626,4080,1,1,1,10420.51764),-- [blue_wolve's_gaiters_material]
(20626,1872,1,3,2,168852.683584),-- [animal_bone]
(20626,1867,1,3,2,112568.342644),-- [animal_skin]
(20626,1881,1,1,2,33770.604564),-- [coarse_bone_powder]
(20626,1875,1,1,2,16885.132664),-- [stone_of_purity]
(20626,4041,1,1,2,2202.320112),-- [mold_hardener]
(20626,4615,1,1,2,349.41308),-- [dye_c4s4_c]
(20626,4402,1,1,2,506.479348),-- [blue_dimension_stone]
(20626,5334,1,1,2,498.67692),-- [rp_sealed_tallum_leather_mail_i]
(20626,8730,1,1,2,2814.301856),-- [general_67_a]
(20626,8740,1,1,2,703.575464),-- [special_67_a]
(20626,8750,1,1,2,70.221852),-- [rare_67_a]
(20626,8760,1,1,2,14.247912),-- [unique_67_a]
(20627,1877,1,1,-1,413122),-- [admantite_nugget]
(20627,5478,1,1,-1,86849),-- [sealed_dark_crystal_leather_mail_pattern]
(20627,57,4085,8305,0,700000),-- [adena]
(20627,5291,1,1,1,85.696149),-- [sealed_dark_crystal_boots]
(20627,5496,1,1,1,8942.553851),-- [sealed_dark_crystal_boots_lining]
(20627,5296,1,1,1,85.696149),-- [sealed_tallum_boots]
(20627,5497,1,1,1,8942.553851),-- [sealed_tallum_boots_lining]
(20627,5290,1,1,1,85.696149),-- [sealed_dark_crystal_gloves]
(20627,5508,1,1,1,8942.553851),-- [sealed_dark_crystal_gloves_design]
(20627,5295,1,1,1,85.696149),-- [sealed_tallum_gloves]
(20627,5509,1,1,1,8942.553851),-- [sealed_tallum_gloves_design]
(20627,1871,1,1,2,254229.140691),-- [charcoal]
(20627,1866,1,1,2,169485.766956),-- [suede]
(20627,1877,1,1,2,10169.400951),-- [admantite_nugget]
(20627,4041,1,1,2,2210.568813),-- [mold_hardener]
(20627,4040,1,1,2,5084.455347),-- [mold_lubricant]
(20627,4973,1,1,2,2751.322284),-- [rp_earing_of_black_ore_i]
(20627,3956,1,1,2,338.767587),-- [rp_blessed_spiritshot_a]
(20627,6670,1,1,2,42371.441739),-- [key_of_treasure_box6]
(20627,8730,1,1,2,2824.860834),-- [general_67_a]
(20627,8740,1,1,2,705.97008),-- [special_67_a]
(20627,8750,1,1,2,70.597008),-- [rare_67_a]
(20627,8760,1,1,2,14.70771),-- [unique_67_a]
(20628,1807,1,1,-1,14876),-- [rp_soulshot_a]
(20628,5479,1,1,-1,66016),-- [sealed_tallum_leather_mail_pattern]
(20628,1895,1,7,-1,796908),-- [metallic_fiber]
(20628,57,4416,8967,0,700000),-- [adena]
(20628,5304,1,1,1,41.126553),-- [sealed_tallum_tunic]
(20628,5485,1,1,1,4618.266393),-- [sealed_tallum_tunic_texture]
(20628,5308,1,1,1,25.298091),-- [sealed_dark_crystal_robe]
(20628,5486,1,1,1,3249.729639),-- [sealed_dark_crystal_robe_fabric]
(20628,5305,1,1,1,65.768937),-- [sealed_tallum_hose]
(20628,5489,1,1,1,7248.810387),-- [sealed_tallum_hose_fabric]
(20628,1895,1,1,2,94157.83821),-- [metallic_fiber]
(20628,4040,1,1,2,6591.05616),-- [mold_lubricant]
(20628,4042,1,1,2,5492.588385),-- [enria]
(20628,4043,1,1,2,10985.052015),-- [asofe]
(20628,4988,1,1,2,2182.46397),-- [rp_blue_wolve's_hose_i]
(20628,4401,1,1,2,659.080665),-- [green_dimension_stone]
(20628,8730,1,1,2,3661.684005),-- [general_67_a]
(20628,8740,1,1,2,915.45219),-- [special_67_a]
(20628,8750,1,1,2,91.57017),-- [rare_67_a]
(20628,8760,1,1,2,18.21423),-- [unique_67_a]
(20629,4077,1,1,-1,589396),-- [doom_shield_fragment]
(20629,4078,1,1,-1,191386),-- [blue_wolve's_breastplate_part]
(20629,3035,1,1,-1,17470),-- [rp_spiritshot_a]
(20629,57,5182,10542,0,700000),-- [adena]
(20629,5292,1,1,1,137.97336),-- [sealed_dark_crystal_shield]
(20629,5494,1,1,1,13545.568435),-- [sealed_dark_crystal_shield_fragment]
(20629,5289,1,1,1,96.547535),-- [sealed_dark_crystal_helmet]
(20629,5525,1,1,1,9970.198476),-- [sealed_dark_crystal_helmet_design]
(20629,5294,1,1,1,96.547535),-- [sealed_tallum_bonnet]
(20629,5526,1,1,1,9970.164659),-- [sealed_tallum_bonnet_design]
(20629,1873,1,1,2,154808.395587),-- [silver_nugget]
(20629,1868,3,9,2,129006.754299),-- [thread]
(20629,1876,1,1,2,77403.95577),-- [mithril_ore]
(20629,1895,1,1,2,110577.632868),-- [metallic_fiber]
(20629,4042,1,1,2,6450.410322),-- [enria]
(20629,5006,1,1,2,295.26867),-- [rp_bellion_cestus_i]
(20629,8730,1,1,2,4300.273548),-- [general_67_a]
(20629,8740,1,1,2,1075.068387),-- [special_67_a]
(20629,8750,1,1,2,107.458434),-- [rare_67_a]
(20629,8760,1,1,2,21.782115),-- [unique_67_a]
(20630,2291,1,1,-1,5091),-- [rp_scallop_jamadhr]
(20630,1943,1,1,-1,72792),-- [manticor_skin_gaiters_pattern]
(20630,1902,1,1,-1,92852),-- [elven_earing_beads]
(20630,57,383,764,0,700000),-- [adena]
(20630,629,1,1,1,261.873792),-- [kite_shield]
(20630,1947,1,1,1,11368.098096),-- [kite_shield_fragment]
(20630,2493,1,1,1,261.873792),-- [brigandine_shield]
(20630,2929,1,1,1,11368.098096),-- [brigandine_shield_fragment]
(20630,2411,1,1,1,183.4017),-- [brigandine_helmet]
(20630,2922,1,1,1,3040.654524),-- [brigandine_helmet_design]
(20630,1866,1,1,2,45117.507951),-- [suede]
(20630,1871,1,1,2,67676.195466),-- [charcoal]
(20630,5220,1,1,2,2707.069086),-- [reinforcing_agent]
(20630,1885,1,1,2,5639.705109),-- [high_grade_suede]
(20630,5472,1,1,2,4834.070928),-- [rp_iron_thread]
(20630,2286,1,1,2,376.033509),-- [rp_bonebreaker]
(20630,2987,1,1,2,6570.417951),-- [rp_plate_shield]
(20631,2998,1,1,-1,94276),-- [rp_chain_shield]
(20631,2996,1,1,-1,99513),-- [rp_chain_gloves]
(20631,1873,1,1,-1,501547),-- [silver_nugget]
(20631,57,508,1017,0,700000),-- [adena]
(20631,1125,1,1,1,139.547025),-- [assault_boots]
(20631,1957,1,1,1,5856.262325),-- [assault_boots_part]
(20631,2427,1,1,1,139.547025),-- [slamander_skin_boots]
(20631,2931,1,1,1,5856.262325),-- [slamander_skin_boots_lining]
(20631,2428,1,1,1,139.547025),-- [plate_boots]
(20631,2932,1,1,1,5856.262325),-- [plate_boots_design]
(20631,61,1,1,1,139.547025),-- [mithril_glove]
(20631,1949,1,1,1,5856.262325),-- [mithril_glove_design]
(20631,607,1,1,1,139.547025),-- [ogre_power_gauntlet]
(20631,1963,1,1,1,5856.262325),-- [ogre_power_gauntlet_part]
(20631,2451,1,1,1,139.547025),-- [sage's_worn_gloves]
(20631,2933,1,1,1,5856.406225),-- [sage's_worn_gloves_lining]
(20631,1868,1,1,2,157408.598016),-- [thread]
(20631,1873,1,1,2,31481.568768),-- [silver_nugget]
(20631,5549,1,1,2,7870.580736),-- [iron_thread]
(20631,1889,1,1,2,5246.802432),-- [compound_braid]
(20631,2203,1,1,2,17146.945536),-- [rp_mithril_boots]
(20631,5274,1,1,2,262.453248),-- [rp_adv_comp_spiritshot_c]
(20631,5164,1,1,2,262.453248),-- [rp_comp_bspiritshot_c]
(20631,1342,10,30,2,157408.598016),-- [fine_steel_arrow]
(20632,1951,1,1,-1,63026),-- [plate_gaiters_part]
(20632,1873,1,1,-1,499421),-- [silver_nugget]
(20632,1880,1,1,-1,124855),-- [steel]
(20632,57,503,1016,0,700000),-- [adena]
(20632,353,1,1,1,104.217163),-- [half_plate]
(20632,1950,1,1,1,5087.530747),-- [half_plate_temper]
(20632,380,1,1,1,166.750115),-- [plate_gaiters]
(20632,1951,1,1,1,7912.501975),-- [plate_gaiters_part]
(20632,1869,1,1,2,78370.714305),-- [iron_ore]
(20632,1864,1,1,2,156741.153543),-- [stem]
(20632,1880,1,1,2,7836.933897),-- [steel]
(20632,5550,1,1,2,1044.979533),-- [reinforcing_plate]
(20632,2301,1,1,2,342.183348),-- [rp_battle_axe]
(20632,2205,1,1,2,2480.004072),-- [rp_chain_gaiters]
(20632,5274,1,1,2,261.31365),-- [rp_adv_comp_spiritshot_c]
(20632,6668,1,1,2,27989.717652),-- [key_of_treasure_box4]
(20633,2313,1,1,-1,5351),-- [rp_orcish_glaive]
(20633,2212,1,1,-1,43920),-- [rp_plate_leather_gaiters]
(20633,4469,1,1,-1,7002),-- [dye_s1c1_d]
(20633,57,485,984,0,700000),-- [adena]
(20633,851,1,1,1,219.839927),-- [onyxbeast'seye_earing]
(20633,1905,1,1,1,9975.918999),-- [onyxbeast'seye_earing_gemstone]
(20633,914,1,1,1,164.871965),-- [necklace_of_darkness]
(20633,1907,1,1,1,7134.088132),-- [necklace_of_darkness_gem]
(20633,882,1,1,1,329.74393),-- [mithril_ring]
(20633,1906,1,1,1,14096.537047),-- [mithril_ring_wire]
(20633,1873,1,1,2,35161.574252),-- [silver_nugget]
(20633,1868,1,1,2,175807.87126),-- [thread]
(20633,1876,1,1,2,17580.787126),-- [mithril_ore]
(20633,1895,1,1,2,25115.41018),-- [metallic_fiber]
(20633,2992,1,1,2,6976.473616),-- [rp_plate_leather_boots]
(20633,5159,1,1,2,293.14019),-- [rp_comp_spiritshot_c]
(20633,2211,1,1,2,1970.743376),-- [rp_plate_leather]
(20634,2213,1,1,-1,36467),-- [rp_dwarven_chain_mail_shirt]
(20634,1880,1,1,-1,234850),-- [steel]
(20634,1908,1,1,-1,222396),-- [moonstone_earing_wire]
(20634,57,925,1895,0,700000),-- [adena]
(20634,354,1,1,1,142.811604),-- [chain_mail_shirt]
(20634,1959,1,1,1,7473.914838),-- [chain_mail_shirt_material]
(20634,381,1,1,1,228.461688),-- [chain_gaiters]
(20634,1960,1,1,1,15203.81187),-- [chain_gaiters_part]
(20634,1872,1,1,2,123326.177326),-- [animal_bone]
(20634,1867,1,1,2,123326.177326),-- [animal_skin]
(20634,1881,1,1,2,12332.646614),-- [coarse_bone_powder]
(20634,1875,1,1,2,6166.1789),-- [stone_of_purity]
(20634,2215,1,1,2,1178.36112),-- [rp_robe_of_seal]
(20634,2225,1,1,2,2010.723068),-- [rp_demon's_hose]
(20634,2321,1,1,2,322.316424),-- [rp_stiletto]
(20634,2251,1,1,2,15415.736064),-- [rp_fine_steel_arrow]
(20634,8723,1,1,2,3699.70734),-- [general_46_c]
(20634,8733,1,1,2,925.071242),-- [special_46_c]
(20634,8743,1,1,2,92.42048),-- [rare_46_c]
(20634,8753,1,1,2,18.484096),-- [unique_46_c]
(20635,2215,1,1,-1,15138),-- [rp_robe_of_seal]
(20635,1959,1,1,-1,32009),-- [chain_mail_shirt_material]
(20635,2163,1,1,-1,60630),-- [rp_earing_of_protection]
(20635,57,470,955,0,700000),-- [adena]
(20635,263,1,1,1,31.85193),-- [chakram]
(20635,2073,1,1,1,2170.14807),-- [chakram_edge]
(20635,1866,1,1,2,34038.436182),-- [suede]
(20635,1871,1,1,2,51057.70467),-- [charcoal]
(20635,5220,1,1,2,2042.288028),-- [reinforcing_agent]
(20635,1885,1,1,2,4254.817122),-- [high_grade_suede]
(20635,4041,1,1,2,443.99757),-- [mold_hardener]
(20635,3004,1,1,2,3171.281622),-- [rp_rind_leather_gloves]
(20635,3002,1,1,2,3171.281622),-- [rp_dwarven_chain_gloves]
(20635,8723,1,1,2,2042.288028),-- [general_46_c]
(20635,8733,1,1,2,510.622404),-- [special_46_c]
(20635,8743,1,1,2,51.102558),-- [rare_46_c]
(20635,8753,1,1,2,10.180194),-- [unique_46_c]
(20636,2163,1,1,-1,67491),-- [rp_earing_of_protection]
(20636,2214,1,1,-1,32824),-- [rp_dwarven_chain_gaiters]
(20636,1909,1,1,-1,178638),-- [aquastone_ring_wire]
(20636,57,521,1066,0,700000),-- [adena]
(20636,89,1,1,1,4.43344),-- [big_hammer]
(20636,2061,1,1,1,302.05956),-- [big_hammer_head]
(20636,160,1,1,1,4.43344),-- [battle_axe]
(20636,2063,1,1,1,302.05956),-- [battle_axe_head]
(20636,161,1,1,1,4.43344),-- [war_pick]
(20636,2064,1,1,1,302.05956),-- [war_pick_head]
(20636,173,1,1,1,4.43344),-- [skull_graver]
(20636,2065,1,1,1,302.05956),-- [skull_graver_head]
(20636,191,1,1,1,4.43344),-- [heavy_doom_hammer]
(20636,2066,1,1,1,306.50026),-- [heavy_doom_hammer_head]
(20636,192,1,1,1,4.43344),-- [crystal_staff]
(20636,2067,1,1,1,281.64928),-- [crystal_staff_head]
(20636,193,1,1,1,4.43344),-- [stick_of_faith]
(20636,2068,1,1,1,281.64928),-- [stick_of_faith_shaft]
(20636,194,1,1,1,4.43344),-- [heavy_doom_axe]
(20636,2069,1,1,1,306.49542),-- [heavy_doom_axe_blade]
(20636,1867,1,1,2,75780.012116),-- [animal_skin]
(20636,1872,1,1,2,75780.012116),-- [animal_bone]
(20636,1882,1,1,2,12630.059133),-- [leather]
(20636,1894,1,1,2,1994.237899),-- [crafted_leather]
(20636,4042,1,1,2,947.173048),-- [enria]
(20636,2230,1,1,2,1101.379948),-- [rp_theca_leather_gaiters]
(20636,2320,1,1,2,198.070196),-- [rp_cursed_staff]
(20636,8723,1,1,2,2273.352388),-- [general_46_c]
(20636,8733,1,1,2,568.338097),-- [special_46_c]
(20636,8743,1,1,2,56.885212),-- [rare_46_c]
(20636,8753,1,1,2,11.479847),-- [unique_46_c]
(20637,2337,1,1,-1,3209),-- [rp_stick_of_eternity]
(20637,2338,1,1,-1,3209),-- [rp_paradia_staff]
(20637,440,1,1,-1,457),-- [robe_of_seal]
(20637,57,545,1111,0,700000),-- [adena]
(20637,1126,1,1,1,82.22976),-- [crimson_boots]
(20637,1974,1,1,1,4284.096192),-- [crimson_boots_fabric]
(20637,2434,1,1,1,82.22976),-- [rind_leather_boots]
(20637,2948,1,1,1,4284.096192),-- [rind_leather_boots_lining]
(20637,2455,1,1,1,89.04096),-- [plate_leather_gloves]
(20637,2946,1,1,1,2847.279744),-- [plate_leather_gloves_design]
(20637,2456,1,1,1,82.22976),-- [dwarven_chain_gloves]
(20637,2949,1,1,1,4284.096192),-- [dwarven_chain_gloves_design]
(20637,2457,1,1,1,82.22976),-- [gloves_of_seal]
(20637,2950,1,1,1,4284.096192),-- [gloves_of_seal_pattern]
(20637,2458,1,1,1,82.22976),-- [rind_leather_gloves]
(20637,2951,1,1,1,4284.145728),-- [rind_leather_gloves_design]
(20637,1869,1,1,2,50942.36372),-- [iron_ore]
(20637,1864,1,1,2,101884.919745),-- [stem]
(20637,1880,1,1,2,5094.15945),-- [steel]
(20637,5550,1,1,2,679.22126),-- [reinforcing_plate]
(20637,4043,1,1,2,1698.05315),-- [asofe]
(20637,2222,1,1,2,318.45708),-- [rp_composite_armor]
(20637,6668,1,1,2,18193.783745),-- [key_of_treasure_box4]
(20637,8724,1,1,2,1698.05315),-- [general_49_c]
(20637,8734,1,1,2,424.60944),-- [special_49_c]
(20637,8744,1,1,2,42.499405),-- [rare_49_c]
(20637,8754,1,1,2,8.46142),-- [unique_49_c]
(20637,1539,1,1,2,11320.418435),-- [greater_healing_potion]
(20638,1873,1,1,-1,576200),-- [silver_nugget]
(20638,2946,1,1,-1,80520),-- [plate_leather_gloves_design]
(20638,1911,1,1,-1,107140),-- [earing_of_protection_gemstone]
(20638,57,570,1158,0,700000),-- [adena]
(20638,282,1,1,1,14.444309),-- [elemental_bow]
(20638,2085,1,1,1,1104.055691),-- [elemental_bow_shaft]
(20638,285,1,1,1,14.444309),-- [noble_elven_bow]
(20638,2086,1,1,1,1104.055691),-- [noble_elven_bow_shaft]
(20638,1867,1,1,2,65461.79647),-- [animal_skin]
(20638,1872,1,1,2,65461.79647),-- [animal_bone]
(20638,1882,1,1,2,10910.24963),-- [leather]
(20638,1894,1,1,2,1722.694575),-- [crafted_leather]
(20638,4042,1,1,2,818.261255),-- [enria]
(20638,2338,1,1,2,114.248925),-- [rp_paradia_staff]
(20638,2351,1,1,2,102.74936),-- [rp_scorpion]
(20638,3005,1,1,2,2003.91121),-- [rp_demon's_boots]
(20638,952,1,1,2,654.579135),-- [scrl_of_ench_am_c]
(20638,8724,1,1,2,1636.52251),-- [general_49_c]
(20638,8734,1,1,2,409.2053),-- [special_49_c]
(20638,8744,1,1,2,40.92053),-- [rare_49_c]
(20638,8754,1,1,2,8.06463),-- [unique_49_c]
(20639,2342,1,1,-1,7048),-- [rp_club_of_nature]
(20639,2334,1,1,-1,7048),-- [rp_deathbreath_sword]
(20639,951,1,1,-1,5510),-- [scrl_of_ench_wp_c]
(20639,57,1196,2440,0,700000),-- [adena]
(20639,227,1,1,1,30.383318),-- [stiletto]
(20639,2083,1,1,1,2230.616682),-- [stiletto_edge]
(20639,242,1,1,1,30.383318),-- [dagger_of_magicflame]
(20639,2084,1,1,1,2230.616682),-- [dagger_of_magicflame_blade]
(20639,1868,1,1,2,223801.838579),-- [thread]
(20639,1873,1,1,2,44760.29966),-- [silver_nugget]
(20639,5549,1,1,2,11190.074915),-- [iron_thread]
(20639,1889,1,1,2,7459.936517),-- [compound_braid]
(20639,4044,1,1,2,3730.138398),-- [thons]
(20639,4132,1,1,2,4337.196134),-- [rp_composite_shield]
(20639,2328,1,1,2,260.313435),-- [rp_sword_of_delusion]
(20639,6668,1,1,2,39964.747713),-- [key_of_treasure_box4]
(20639,8724,1,1,2,3730.138398),-- [general_49_c]
(20639,8734,1,1,2,932.36446),-- [special_49_c]
(20639,8744,1,1,2,93.236446),-- [rare_49_c]
(20639,8754,1,1,2,18.715345),-- [unique_49_c]
(20640,1868,1,7,-1,728055),-- [thread]
(20640,1539,1,1,-1,323580),-- [greater_healing_potion]
(20640,1870,1,3,-1,728055),-- [coal]
(20640,57,576,1171,0,700000),-- [adena]
(20640,283,1,1,1,18.22008),-- [akat_long_bow]
(20640,2109,1,1,1,1687.77992),-- [akat_long_bow_shaft]
(20640,1865,1,1,2,46319.687274),-- [varnish]
(20640,1870,1,1,2,46319.687274),-- [coal]
(20640,1879,1,1,2,7719.927852),-- [cokes]
(20640,1875,1,1,2,3087.923076),-- [stone_of_purity]
(20640,4040,1,1,2,926.44902),-- [mold_lubricant]
(20640,2233,1,1,2,432.943686),-- [rp_divine_tunic]
(20640,3014,1,1,2,1293.904416),-- [rp_full_plate_boots]
(20640,2970,1,1,2,1642.494378),-- [rp_ring_of_binding]
(20640,6669,1,1,2,10772.042652),-- [key_of_treasure_box5]
(20640,8725,1,1,2,1286.694696),-- [general_52_c]
(20640,8735,1,1,2,321.673674),-- [special_52_c]
(20640,8745,1,1,2,32.203416),-- [rare_52_c]
(20640,8755,1,1,2,6.368586),-- [unique_52_c]
(20641,2097,1,1,-1,9668),-- [war_axe_blade]
(20641,2355,1,1,-1,2944),-- [rp_ghoul's_staff]
(20641,4042,1,1,-1,30082),-- [enria]
(20641,57,715,1452,0,700000),-- [adena]
(20641,854,1,1,1,109.796841),-- [earing_of_binding]
(20641,1914,1,1,1,6988.01558),-- [earing_of_binding_gemstone]
(20641,917,1,1,1,82.35353),-- [necklace_of_mermaid]
(20641,1916,1,1,1,5293.04307),-- [necklace_of_mermaid_teardrop]
(20641,885,1,1,1,164.636269),-- [ring_of_ages]
(20641,1915,1,1,1,10959.15471),-- [ring_of_ages_gemstone]
(20641,1867,1,1,2,82934.40647),-- [animal_skin]
(20641,1872,1,1,2,82934.40647),-- [animal_bone]
(20641,1882,1,1,2,13822.369724),-- [leather]
(20641,1894,1,1,2,2182.449726),-- [crafted_leather]
(20641,4042,1,1,2,1036.762386),-- [enria]
(20641,4124,1,1,2,2764.51157),-- [rp_craftsman_mold]
(20641,4609,1,1,2,138.27261),-- [dye_m3i3_c]
(20641,2353,1,1,2,101.399914),-- [rp_samurai_longsword]
(20641,8725,1,1,2,1727.749184),-- [general_52_c]
(20641,8735,1,1,2,431.937296),-- [special_52_c]
(20641,8745,1,1,2,43.26898),-- [rare_52_c]
(20641,8755,1,1,2,8.46567),-- [unique_52_c]
(20642,2103,1,1,-1,9533),-- [sage's_staff_head]
(20642,2358,1,1,-1,2759),-- [rp_great_pata]
(20642,4602,1,1,-1,3758),-- [dye_s3d3_c]
(20642,57,672,1357,0,700000),-- [adena]
(20642,283,1,1,1,21.16776),-- [akat_long_bow]
(20642,2109,1,1,1,1960.83224),-- [akat_long_bow_shaft]
(20642,1873,1,1,2,18648.809658),-- [silver_nugget]
(20642,1868,1,1,2,93244.04829),-- [thread]
(20642,1876,1,1,2,9324.241698),-- [mithril_ore]
(20642,1895,1,1,2,13320.624936),-- [metallic_fiber]
(20642,4042,1,1,2,777.156084),-- [enria]
(20642,4606,1,1,2,103.751316),-- [dye_d3c3_c]
(20642,3017,1,1,2,1302.437904),-- [rp_blessed_gloves]
(20642,5155,1,1,2,93.310932),-- [rp_comp_soulshot_b]
(20642,3015,1,1,2,1302.437904),-- [rp_drake_leather_gloves]
(20642,8725,1,1,2,1294.933878),-- [general_52_c]
(20642,8735,1,1,2,323.651904),-- [special_52_c]
(20642,8745,1,1,2,32.299938),-- [rare_52_c]
(20642,8755,1,1,2,6.52524),-- [unique_52_c]
(20642,1342,10,30,2,93244.04829),-- [fine_steel_arrow]
(20643,3955,1,1,-1,3483),-- [rp_blessed_spiritshot_b]
(20643,2114,1,1,-1,8434),-- [widow_maker_head]
(20643,1918,1,1,-1,75426),-- [nassen's_earing_gemstone]
(20643,57,689,1400,0,700000),-- [adena]
(20643,2497,1,1,1,111.328191),-- [full_plate_shield]
(20643,2966,1,1,1,8796.905481),-- [full_plate_shield_fragment]
(20643,2414,1,1,1,77.928279),-- [full_plate_helmet]
(20643,2959,1,1,1,5560.838049),-- [full_plate_helmet_design]
(20643,1894,1,1,2,1880.22975),-- [crafted_leather]
(20643,4039,1,1,2,1786.228796),-- [mold_glue]
(20643,4041,1,1,2,465.959906),-- [mold_hardener]
(20643,4044,1,1,2,1786.228796),-- [thons]
(20643,4126,1,1,2,884.266258),-- [rp_adamantite_earing]
(20643,5270,1,1,2,107.167829),-- [rp_adv_comp_soulshot_b]
(20643,5275,1,1,2,107.167829),-- [rp_adv_comp_spiritshot_b]
(20643,6669,1,1,2,12461.994247),-- [key_of_treasure_box5]
(20643,8726,1,1,2,1240.42496),-- [general_55_c]
(20643,8736,1,1,2,310.10624),-- [special_55_c]
(20643,8746,1,1,2,31.010624),-- [rare_55_c]
(20643,8756,1,1,2,6.214765),-- [unique_55_c]
(20644,1865,1,3,-1,854261),-- [varnish]
(20644,1987,1,1,-1,26066),-- [drake_leather_mail_texture]
(20644,1806,1,1,-1,3417),-- [rp_soulshot_b]
(20644,57,675,1374,0,700000),-- [adena]
(20644,442,1,1,1,38.23255),-- [divine_tunic]
(20644,1988,1,1,1,3030.335562),-- [divine_tunic_fabric]
(20644,473,1,1,1,61.156314),-- [divine_hose]
(20644,1989,1,1,1,4753.275574),-- [divine_hose_pattern]
(20644,1864,1,1,2,97052.069108),-- [stem]
(20644,1869,1,1,2,48526.034554),-- [iron_ore]
(20644,1878,1,1,2,19410.493394),-- [braided_hemp]
(20644,1884,1,1,2,29862.129203),-- [cord]
(20644,4039,1,1,2,1617.507961),-- [mold_glue]
(20644,4147,1,1,2,498.720017),-- [rp_hose_of_shrnoen]
(20644,4184,1,1,2,55.899611),-- [rp_sprite's_staff]
(20644,5160,1,1,2,97.078328),-- [rp_comp_spiritshot_b]
(20644,4142,1,1,2,373.194556),-- [rp_avadon_gaiters]
(20644,8726,1,1,2,1123.363357),-- [general_55_c]
(20644,8736,1,1,2,280.890572),-- [special_55_c]
(20644,8746,1,1,2,28.049271),-- [rare_55_c]
(20644,8756,1,1,2,5.570068),-- [unique_55_c]
(20645,2121,1,1,-1,17683),-- [eminence_bow_shaft]
(20645,1885,1,1,-1,320445),-- [high_grade_suede]
(20645,1920,1,1,-1,131577),-- [necklace_of_binding_chain]
(20645,57,1520,3096,0,700000),-- [adena]
(20645,286,1,1,1,30.126185),-- [eminence_bow]
(20645,2121,1,1,1,3264.873815),-- [eminence_bow_shaft]
(20645,1870,1,1,2,118317.975663),-- [coal]
(20645,1865,1,1,2,118317.975663),-- [varnish]
(20645,1874,1,1,2,7887.985356),-- [oriharukon_ore]
(20645,4043,1,1,2,3943.992678),-- [asofe]
(20645,4039,1,1,2,3943.992678),-- [mold_glue]
(20645,4189,1,1,2,136.382019),-- [rp_arthro_nail]
(20645,5275,1,1,2,236.670498),-- [rp_adv_comp_spiritshot_b]
(20645,4179,1,1,2,1520.827089),-- [rp_shrnoen's_helmet]
(20645,8726,1,1,2,2738.726253),-- [general_55_c]
(20645,8736,1,1,2,684.746016),-- [special_55_c]
(20645,8746,1,1,2,68.577726),-- [rare_55_c]
(20645,8756,1,1,2,13.148361),-- [unique_55_c]
(20646,4044,1,1,-1,96583),-- [thons]
(20646,2122,1,1,-1,13225),-- [orcish_poleaxe_blade]
(20646,3034,1,1,-1,5795),-- [rp_spiritshot_b]
(20646,57,1145,2333,0,700000),-- [adena]
(20646,301,1,1,1,9.696768),-- [scorpion]
(20646,2113,1,1,1,863.5542),-- [scorpion_blade]
(20646,303,1,1,1,9.696768),-- [widow_maker]
(20646,2114,1,1,1,863.5542),-- [widow_maker_head]
(20646,299,1,1,1,7.565328),-- [orcish_poleaxe]
(20646,2122,1,1,1,813.932736),-- [orcish_poleaxe_blade]
(20646,1864,1,1,2,178306.774196),-- [stem]
(20646,1869,1,1,2,89153.387098),-- [iron_ore]
(20646,1878,1,1,2,35661.500432),-- [braided_hemp]
(20646,1884,1,1,2,54863.734824),-- [cord]
(20646,4039,1,1,2,2971.91303),-- [mold_glue]
(20646,4190,1,1,2,102.642924),-- [rp_dark_elven_long_bow]
(20646,4186,1,1,2,102.642924),-- [rp_sword_of_valhalla]
(20646,5165,1,1,2,178.35118),-- [rp_comp_bspiritshot_b]
(20646,8726,1,1,2,2063.77794),-- [general_55_c]
(20646,8736,1,1,2,515.762494),-- [special_55_c]
(20646,8746,1,1,2,51.685444),-- [rare_55_c]
(20646,8756,1,1,2,9.827514),-- [unique_55_c]
(20647,2960,1,1,-1,158666),-- [drake_leather_boots_design]
(20647,4049,1,1,-1,152841),-- [adamantite_earing_gemstone]
(20647,947,1,1,-1,1166),-- [scrl_of_ench_wp_b]
(20647,57,1150,2348,0,700000),-- [adena]
(20647,554,1,1,1,53.916544),-- [shrnoen's_boots]
(20647,4097,1,1,1,5600.083456),-- [shrnoen's_boots_design]
(20647,600,1,1,1,53.916544),-- [avadon_boots]
(20647,4098,1,1,1,5600.083456),-- [avadon_boots_design]
(20647,612,1,1,1,53.916544),-- [shrnoen's_gauntlet]
(20647,4100,1,1,1,5600.083456),-- [shrnoen's_gauntlet_part]
(20647,2464,1,1,1,53.916544),-- [avadon_gloves]
(20647,4073,1,1,1,5600.083456),-- [avadon_gloves_part]
(20647,1865,1,1,2,71726.827744),-- [varnish]
(20647,1870,1,1,2,71726.827744),-- [coal]
(20647,1879,1,1,2,11954.526276),-- [cokes]
(20647,1875,1,1,2,4781.744528),-- [stone_of_purity]
(20647,4040,1,1,2,1434.457376),-- [mold_lubricant]
(20647,4946,1,1,2,459.732372),-- [rp_shrnoen's_leather_shirts_i]
(20647,5280,1,1,2,143.51172),-- [rp_adv_comp_bspiritshot_b]
(20647,4176,1,1,2,892.082048),-- [rp_doom_boots]
(20647,8727,1,1,2,1434.457376),-- [general_58_b]
(20647,8737,1,1,2,358.614344),-- [special_58_b]
(20647,8747,1,1,2,35.795452),-- [rare_58_b]
(20647,8757,1,1,2,7.42302),-- [unique_58_b]
(20648,4191,1,1,-1,3620),-- [rp_great_axe]
(20648,2963,1,1,-1,171074),-- [full_plate_gauntlet_part]
(20648,1868,1,13,-1,897647),-- [thread]
(20648,57,1239,2531,0,700000),-- [adena]
(20648,554,1,1,1,58.131456),-- [shrnoen's_boots]
(20648,4097,1,1,1,6037.868544),-- [shrnoen's_boots_design]
(20648,600,1,1,1,58.131456),-- [avadon_boots]
(20648,4098,1,1,1,6037.868544),-- [avadon_boots_design]
(20648,612,1,1,1,58.131456),-- [shrnoen's_gauntlet]
(20648,4100,1,1,1,6037.868544),-- [shrnoen's_gauntlet_part]
(20648,2464,1,1,1,58.131456),-- [avadon_gloves]
(20648,4073,1,1,1,6037.868544),-- [avadon_gloves_part]
(20648,1873,1,1,2,30934.28802),-- [silver_nugget]
(20648,1868,1,1,2,154671.193297),-- [thread]
(20648,1876,1,1,2,15467.14401),-- [mithril_ore]
(20648,1895,1,1,2,22095.778984),-- [metallic_fiber]
(20648,4042,1,1,2,1288.805266),-- [enria]
(20648,4961,1,1,2,1419.11725),-- [rp_shrnoen's_shield_i]
(20648,4999,1,1,2,961.791291),-- [rp_doom_boots_i]
(20648,6669,1,1,2,17985.028216),-- [key_of_treasure_box5]
(20648,8727,1,1,2,1546.714401),-- [general_58_b]
(20648,8737,1,1,2,386.740301),-- [special_58_b]
(20648,8747,1,1,2,38.748071),-- [rare_58_b]
(20648,8757,1,1,2,7.650893),-- [unique_58_b]
(20649,2112,1,1,-1,16014),-- [paagrio_axe_blade]
(20649,4133,1,1,-1,15899),-- [rp_shrnoen's_breastplate]
(20649,5549,1,1,-1,330694),-- [iron_thread]
(20649,57,1306,2660,0,700000),-- [adena]
(20649,78,1,1,1,4.87334),-- [great_sword]
(20649,4104,1,1,1,931.41398),-- [great_sword_blade]
(20649,142,1,1,1,4.87334),-- [kshanberk]
(20649,4107,1,1,1,916.983),-- [kshanberk_blade]
(20649,148,1,1,1,4.87334),-- [sword_of_valhalla]
(20649,4108,1,1,1,916.983),-- [sword_of_valhalla_blade]
(20649,1868,1,1,2,150280.240366),-- [thread]
(20649,1873,1,1,2,30055.935682),-- [silver_nugget]
(20649,5549,1,1,2,7513.913676),-- [iron_thread]
(20649,1889,1,1,2,5009.275784),-- [compound_braid]
(20649,4044,1,1,2,2504.637892),-- [thons]
(20649,4970,1,1,2,86.541224),-- [rp_arthro_nail_i]
(20649,4194,1,1,2,57.319512),-- [rp_deadman's_glory]
(20649,8311,1,1,2,57.319512),-- [rp_bone_of_kaim_vanul]
(20649,8727,1,1,2,1502.670344),-- [general_58_b]
(20649,8737,1,1,2,375.667586),-- [special_58_b]
(20649,8747,1,1,2,37.651052),-- [rare_58_b]
(20649,8757,1,1,2,7.586406),-- [unique_58_b]
(20649,1832,1,1,2,83489.240964),-- [advanced_antidote]
(20650,4049,1,1,-1,188177),-- [adamantite_earing_gemstone]
(20650,4195,1,1,-1,2739),-- [rp_art_of_battle_axe]
(20650,4613,1,1,-1,4948),-- [dye_s4c4_c]
(20650,57,1417,2887,0,700000),-- [adena]
(20650,856,1,1,1,75.817654),-- [adamantite_earing]
(20650,4049,1,1,1,9263.677808),-- [adamantite_earing_gemstone]
(20650,918,1,1,1,56.870066),-- [adamantite_necklace]
(20650,4051,1,1,1,6849.416552),-- [adamantite_necklace_chain]
(20650,887,1,1,1,113.71283),-- [adamantite_ring]
(20650,4050,1,1,1,10942.50509),-- [adamantite_ring_wire]
(20650,1867,1,1,2,117746.485692),-- [animal_skin]
(20650,1872,1,1,2,117746.485692),-- [animal_bone]
(20650,1882,1,1,2,19624.414282),-- [leather]
(20650,1894,1,1,2,3098.702882),-- [crafted_leather]
(20650,4042,1,1,2,1471.738675),-- [enria]
(20650,948,1,1,2,220.694804),-- [scrl_of_ench_am_b]
(20650,4167,1,1,2,1098.458229),-- [rp_blue_wolve's_boots]
(20650,4168,1,1,2,1098.458229),-- [rp_doom_gloves]
(20650,8728,1,1,2,1471.738675),-- [general_61_b]
(20650,8738,1,1,2,368.000666),-- [special_61_b]
(20650,8748,1,1,2,36.694471),-- [rare_61_b]
(20650,8758,1,1,2,7.127703),-- [unique_61_b]
(20651,4050,1,1,-1,206850),-- [adamantite_ring_wire]
(20651,4196,1,1,-1,2549),-- [rp_staff_of_evil_sprit]
(20651,57,1320,2684,0,700000),-- [adena]
(20651,78,1,1,1,4.920671),-- [great_sword]
(20651,4104,1,1,1,940.460087),-- [great_sword_blade]
(20651,142,1,1,1,4.920671),-- [kshanberk]
(20651,4107,1,1,1,925.88895),-- [kshanberk_blade]
(20651,148,1,1,1,4.920671),-- [sword_of_valhalla]
(20651,4108,1,1,1,925.88895),-- [sword_of_valhalla_blade]
(20651,1867,1,1,2,109573.022592),-- [animal_skin]
(20651,1872,1,1,2,109573.022592),-- [animal_bone]
(20651,1882,1,1,2,18262.170432),-- [leather]
(20651,1894,1,1,2,2883.604032),-- [crafted_leather]
(20651,4042,1,1,2,1369.5768),-- [enria]
(20651,948,1,1,2,205.375104),-- [scrl_of_ench_am_b]
(20651,4167,1,1,2,1022.207904),-- [rp_blue_wolve's_boots]
(20651,4168,1,1,2,1022.207904),-- [rp_doom_gloves]
(20651,8728,1,1,2,1369.5768),-- [general_61_b]
(20651,8738,1,1,2,342.455616),-- [special_61_b]
(20651,8748,1,1,2,34.147296),-- [rare_61_b]
(20651,8758,1,1,2,6.632928),-- [unique_61_b]
(20652,4042,1,1,-1,58802),-- [enria]
(20652,4043,1,1,-1,117603),-- [asofe]
(20652,4129,1,1,-1,38183),-- [rp_earing_of_black_ore]
(20652,57,1398,2835,0,700000),-- [adena]
(20652,2384,1,1,1,29.021255),-- [shrnoen's_leather_shirts]
(20652,4066,1,1,1,4095.94146),-- [shrnoen's_leather_shirts_fabric]
(20652,2390,1,1,1,17.851935),-- [avadon_leather_mail]
(20652,4068,1,1,1,3146.698365),-- [avadon_leather_mail_lining]
(20652,2388,1,1,1,46.43943),-- [shrnoen's_leather_gaiters]
(20652,4067,1,1,1,6219.047555),-- [shrnoen's_leather_gaiters_texture]
(20652,1869,1,1,2,86845.277172),-- [iron_ore]
(20652,1864,1,1,2,173690.554344),-- [stem]
(20652,1880,1,1,2,8684.472236),-- [steel]
(20652,5550,1,1,2,1157.892644),-- [reinforcing_plate]
(20652,4043,1,1,2,2894.73161),-- [asofe]
(20652,4615,1,1,2,119.839392),-- [dye_c4s4_c]
(20652,4998,1,1,2,1080.218964),-- [rp_blue_wolve's_gloves_i]
(20652,4173,1,1,2,1080.218964),-- [rp_blue_wolve's_gloves]
(20652,8728,1,1,2,1447.504508),-- [general_61_b]
(20652,8738,1,1,2,361.737424),-- [special_61_b]
(20652,8748,1,1,2,36.06278),-- [rare_61_b]
(20652,8758,1,1,2,7.489962),-- [unique_61_b]
(20654,4064,1,1,-1,119042),-- [avadon_breastplate_part]
(20654,4052,1,1,-1,232857),-- [earing_of_black_ore_piece]
(20654,5230,1,1,-1,8769),-- [rp_mithril_arrow]
(20654,57,2608,5284,0,700000),-- [adena]
(20654,2398,1,1,1,26.155129),-- [blue_wolve's_tunic]
(20654,4084,1,1,1,4221.905376),-- [blue_wolve's_tunic_fabric]
(20654,2399,1,1,1,26.155129),-- [tunic_of_doom]
(20654,4085,1,1,1,4221.905376),-- [tunic_of_doom_pattern]
(20654,2403,1,1,1,41.880176),-- [blue_wolve's_hose]
(20654,4086,1,1,1,5700.539338),-- [blue_wolve's_hose_pattern]
(20654,2404,1,1,1,41.880176),-- [hose_of_doom]
(20654,4087,1,1,1,5700.5793),-- [hose_of_doom_pattern]
(20654,1894,1,1,2,6197.111536),-- [crafted_leather]
(20654,4039,1,1,2,5887.22996),-- [mold_glue]
(20654,4041,1,1,2,1535.801632),-- [mold_hardener]
(20654,4044,1,1,2,5887.22996),-- [thons]
(20654,4624,1,1,2,243.612504),-- [dye_w4m4_c]
(20654,5276,1,1,2,235.494976),-- [rp_adv_comp_spiritshot_a]
(20654,8729,1,1,2,2354.891984),-- [general_64_a]
(20654,8739,1,1,2,588.73744),-- [special_64_a]
(20654,8749,1,1,2,58.873744),-- [rare_64_a]
(20654,8759,1,1,2,11.786304),-- [unique_64_a]
(20654,6036,1,1,2,5887.22996),-- [potion_of_acumen3]
(20655,4067,1,1,-1,212287),-- [shrnoen's_leather_gaiters_texture]
(20655,4160,1,1,-1,16800),-- [rp_leather_mail_of_doom]
(20655,4053,1,1,-1,254190),-- [ring_of_black_ore_gemstone]
(20655,57,2352,4762,0,700000),-- [adena]
(20655,110,1,1,1,89.858003),-- [doom_shield]
(20655,4077,1,1,1,13134.250675),-- [doom_shield_fragment]
(20655,2416,1,1,1,62.904144),-- [blue_wolve's_helmet]
(20655,4088,1,1,1,11034.541517),-- [blue_wolve's_helmet_design]
(20655,2417,1,1,1,62.904144),-- [doom_helmet]
(20655,4089,1,1,1,11034.541517),-- [doom_helmet_pattern]
(20655,1870,1,1,2,134746.353792),-- [coal]
(20655,1865,1,1,2,134746.353792),-- [varnish]
(20655,1874,1,1,2,8983.17216),-- [oriharukon_ore]
(20655,4043,1,1,2,4491.381312),-- [asofe]
(20655,4039,1,1,2,4491.381312),-- [mold_glue]
(20655,4989,1,1,2,892.378944),-- [rp_hose_of_doom_i]
(20655,5276,1,1,2,179.786304),-- [rp_adv_comp_spiritshot_a]
(20655,6670,1,1,2,22457.725632),-- [key_of_treasure_box6]
(20655,8729,1,1,2,1796.634432),-- [general_64_a]
(20655,8739,1,1,2,449.260992),-- [special_64_a]
(20655,8749,1,1,2,45.04896),-- [rare_64_a]
(20655,8759,1,1,2,9.009792),-- [unique_64_a]
(20655,1343,20,60,2,96247.512576),-- [silver_arrow]
(20656,4069,1,1,-1,134666),-- [tunic_of_shrnoen_fabric]
(20656,4040,1,1,-1,114237),-- [mold_lubricant]
(20656,57,2265,4587,0,700000),-- [adena]
(20656,2398,1,1,1,22.713768),-- [blue_wolve's_tunic]
(20656,4084,1,1,1,3666.408192),-- [blue_wolve's_tunic_fabric]
(20656,2399,1,1,1,22.713768),-- [tunic_of_doom]
(20656,4085,1,1,1,3666.408192),-- [tunic_of_doom_pattern]
(20656,2403,1,1,1,36.369792),-- [blue_wolve's_hose]
(20656,4086,1,1,1,4950.490896),-- [blue_wolve's_hose_pattern]
(20656,2404,1,1,1,36.369792),-- [hose_of_doom]
(20656,4087,1,1,1,4950.5256),-- [hose_of_doom_pattern]
(20656,1895,1,1,2,48205.247259),-- [metallic_fiber]
(20656,4040,1,1,2,3374.407044),-- [mold_lubricant]
(20656,4042,1,1,2,2812.00587),-- [enria]
(20656,4043,1,1,2,5623.919331),-- [asofe]
(20656,4990,1,1,2,1394.359401),-- [rp_blue_wolve's_helmet_i]
(20656,6670,1,1,2,28119.689064),-- [key_of_treasure_box6]
(20656,8729,1,1,2,2249.604696),-- [general_64_a]
(20656,8739,1,1,2,562.401174),-- [special_64_a]
(20656,8749,1,1,2,56.277081),-- [rare_64_a]
(20656,8759,1,1,2,11.08908),-- [unique_64_a]
(20657,1920,1,1,-1,144429),-- [necklace_of_binding_chain]
(20657,1914,1,1,-1,237131),-- [earing_of_binding_gemstone]
(20657,1877,1,1,-1,168837),-- [admantite_nugget]
(20657,57,1676,3389,0,700000),-- [adena]
(20657,2398,1,1,1,16.785307),-- [blue_wolve's_tunic]
(20657,4084,1,1,1,2709.448608),-- [blue_wolve's_tunic_fabric]
(20657,2399,1,1,1,16.785307),-- [tunic_of_doom]
(20657,4085,1,1,1,2709.448608),-- [tunic_of_doom_pattern]
(20657,2403,1,1,1,26.877008),-- [blue_wolve's_hose]
(20657,4086,1,1,1,3658.376254),-- [blue_wolve's_hose_pattern]
(20657,2404,1,1,1,26.877008),-- [hose_of_doom]
(20657,4087,1,1,1,3658.4019),-- [hose_of_doom_pattern]
(20657,1871,1,1,2,103899.577968),-- [charcoal]
(20657,1866,1,1,2,69266.385312),-- [suede]
(20657,1877,1,1,2,4155.931522),-- [admantite_nugget]
(20657,4041,1,1,2,903.495422),-- [mold_hardener]
(20657,4040,1,1,2,2078.057898),-- [mold_lubricant]
(20657,4960,1,1,2,2001.952736),-- [rp_shrnoen's_gauntlet_i]
(20657,5276,1,1,2,138.574048),-- [rp_adv_comp_spiritshot_a]
(20657,8300,1,1,2,56.756392),-- [rp_inferno_master_i]
(20657,8729,1,1,2,1385.371932),-- [general_64_a]
(20657,8739,1,1,2,346.250846),-- [special_64_a]
(20657,8749,1,1,2,34.643512),-- [rare_64_a]
(20657,8759,1,1,2,7.002412),-- [unique_64_a]
(20658,2220,1,1,-1,84264),-- [rp_rind_leather_mail]
(20658,1960,1,1,-1,223012),-- [chain_gaiters_part]
(20658,4054,1,1,-1,80165),-- [necklace_of_black_ore_beads]
(20658,57,1613,3270,0,700000),-- [adena]
(20658,864,1,1,1,56.362295),-- [earing_of_black_ore]
(20658,4052,1,1,1,7093.52666),-- [earing_of_black_ore_piece]
(20658,926,1,1,1,42.276674),-- [necklace_of_black_ore]
(20658,4054,1,1,1,3946.3512),-- [necklace_of_black_ore_beads]
(20658,895,1,1,1,84.533537),-- [ring_of_black_ore]
(20658,4053,1,1,1,8587.949634),-- [ring_of_black_ore_gemstone]
(20658,1866,1,1,2,66789.15416),-- [suede]
(20658,1871,1,1,2,100183.73124),-- [charcoal]
(20658,5220,1,1,2,4007.32576),-- [reinforcing_agent]
(20658,1885,1,1,2,8348.79108),-- [high_grade_suede]
(20658,4041,1,1,2,871.17054),-- [mold_hardener]
(20658,4155,1,1,2,311.2372),-- [rp_blue_wolve's_breastplate]
(20658,730,1,1,2,83.38808),-- [scrl_of_ench_am_a]
(20658,8729,1,1,2,1335.67738),-- [general_64_a]
(20658,8739,1,1,2,333.84594),-- [special_64_a]
(20658,8749,1,1,2,33.47268),-- [rare_64_a]
(20658,8759,1,1,2,6.75326),-- [unique_64_a]
(20658,1832,1,1,2,111315.45268),-- [advanced_antidote]
(20659,2062,1,1,-1,10273),-- [scythe_edge]
(20659,1885,1,1,-1,109145),-- [high_grade_suede]
(20659,2163,1,1,-1,66824),-- [rp_earing_of_protection]
(20659,57,518,1052,0,700000),-- [adena]
(20659,631,1,1,1,202.2864),-- [eldarake]
(20659,1964,1,1,1,8336.20767),-- [eldarake_temper]
(20659,2495,1,1,1,202.2864),-- [chain_shield]
(20659,2945,1,1,1,8336.20767),-- [chain_shield_fragment]
(20659,2413,1,1,1,141.60048),-- [chain_hood]
(20659,2936,1,1,1,7571.41138),-- [chain_hood_pattern]
(20659,1868,1,1,2,95232.000732),-- [thread]
(20659,1873,1,1,2,19046.425789),-- [silver_nugget]
(20659,5549,1,1,2,4761.574394),-- [iron_thread]
(20659,1889,1,1,2,3174.425667),-- [compound_braid]
(20659,4044,1,1,2,1587.148727),-- [thons]
(20659,3021,1,1,2,165.907622),-- [rp_dwarven_warhammer]
(20659,2225,1,1,2,1035.191762),-- [rp_demon's_hose]
(20659,2321,1,1,2,165.907622),-- [rp_stiletto]
(20659,2215,1,1,2,606.575703),-- [rp_robe_of_seal]
(20659,8723,1,1,2,1904.604115),-- [general_46_c]
(20659,8733,1,1,2,476.183082),-- [special_46_c]
(20659,8743,1,1,2,47.567023),-- [rare_46_c]
(20659,8753,1,1,2,9.487762),-- [unique_46_c]
(20660,2330,1,1,-1,3761),-- [rp_homunkulus's_sword]
(20660,2084,1,1,-1,10746),-- [dagger_of_magicflame_blade]
(20660,1908,1,1,-1,153154),-- [moonstone_earing_wire]
(20660,57,637,1303,0,700000),-- [adena]
(20660,439,1,1,1,131.332864),-- [karmian_tunic]
(20660,1962,1,1,1,6115.236328),-- [karmian_tunic_pattern]
(20660,471,1,1,1,209.893312),-- [karmian_hose]
(20660,1954,1,1,1,10159.537496),-- [karmian_hose_pattern]
(20660,1869,1,1,2,76436.092936),-- [iron_ore]
(20660,1864,1,1,2,152871.93754),-- [stem]
(20660,1880,1,1,2,7643.65896),-- [steel]
(20660,5550,1,1,2,1019.154528),-- [reinforcing_plate]
(20660,4043,1,1,2,2547.88632),-- [asofe]
(20660,2163,1,1,2,3899.805728),-- [rp_earing_of_protection]
(20660,8723,1,1,2,3057.463584),-- [general_46_c]
(20660,8733,1,1,2,764.365896),-- [special_46_c]
(20660,8743,1,1,2,76.486256),-- [rare_46_c]
(20660,8753,1,1,2,15.148252),-- [unique_46_c]
(20661,2223,1,1,-1,59150),-- [rp_tower_shield]
(20661,2347,1,1,-1,3549),-- [rp_akat_long_bow]
(20661,2166,1,1,-1,51732),-- [rp_earing_of_binding]
(20661,57,602,1229,0,700000),-- [adena]
(20661,2496,1,1,1,187.671942),-- [dwarven_chain_shield]
(20661,2947,1,1,1,8049.505542),-- [dwarven_chain_shield_fragment]
(20661,632,1,1,1,173.248802),-- [knight_shield]
(20661,1972,1,1,1,9015.44034),-- [knight_shield_fragment]
(20661,500,1,1,1,121.301052),-- [great_helmet]
(20661,1971,1,1,1,6898.832322),-- [great_helmet_material]
(20661,1873,1,1,2,19319.157744),-- [silver_nugget]
(20661,1868,1,1,2,96595.322192),-- [thread]
(20661,1876,1,1,2,9659.46224),-- [mithril_ore]
(20661,1895,1,1,2,13799.431712),-- [metallic_fiber]
(20661,4042,1,1,2,804.994064),-- [enria]
(20661,2223,1,1,2,1871.9436),-- [rp_tower_shield]
(20661,2230,1,1,2,936.088432),-- [rp_theca_leather_gaiters]
(20661,3005,1,1,2,1971.314064),-- [rp_demon's_boots]
(20661,6668,1,1,2,17249.173008),-- [key_of_treasure_box4]
(20661,8724,1,1,2,1609.988128),-- [general_49_c]
(20661,8734,1,1,2,402.3804),-- [special_49_c]
(20661,8744,1,1,2,40.354672),-- [rare_49_c]
(20661,8754,1,1,2,8.16424),-- [unique_49_c]
(20661,1343,10,30,2,68996.225504),-- [silver_arrow]
(20662,951,1,1,-1,2897),-- [scrl_of_ench_wp_c]
(20662,1873,1,1,-1,637338),-- [silver_nugget]
(20662,1911,1,1,-1,118508),-- [earing_of_protection_gemstone]
(20662,57,630,1281,0,700000),-- [adena]
(20662,73,1,1,1,7.98672),-- [shamshir]
(20662,2077,1,1,1,586.26328),-- [shamshir_blade]
(20662,74,1,1,1,7.98672),-- [katana]
(20662,2078,1,1,1,586.26328),-- [katana_blade]
(20662,131,1,1,1,7.98672),-- [spirits_sword]
(20662,2080,1,1,1,586.26328),-- [spirits_sword_blade]
(20662,133,1,1,1,7.98672),-- [raid_sword]
(20662,2081,1,1,1,586.26328),-- [raid_sword_blade]
(20662,1871,1,1,2,58831.182362),-- [charcoal]
(20662,1866,1,1,2,39220.660784),-- [suede]
(20662,1877,1,1,2,2353.308474),-- [admantite_nugget]
(20662,4041,1,1,2,511.613736),-- [mold_hardener]
(20662,4040,1,1,2,1176.558644),-- [mold_lubricant]
(20662,2340,1,1,2,136.889176),-- [rp_paagrio_hammer]
(20662,3006,1,1,2,2401.29616),-- [rp_demon's_gloves]
(20662,8724,1,1,2,1960.994802),-- [general_49_c]
(20662,8734,1,1,2,490.200904),-- [special_49_c]
(20662,8744,1,1,2,48.943616),-- [rare_49_c]
(20662,8754,1,1,2,9.750486),-- [unique_49_c]
(20662,1343,10,30,2,84044.600856),-- [silver_arrow]
(20663,1981,1,1,-1,82154),-- [mithril_gauntlet_design]
(20663,4123,1,1,-1,62072),-- [rp_maestro_anvil_lock]
(20663,951,1,1,-1,2539),-- [scrl_of_ench_wp_c]
(20663,57,551,1124,0,700000),-- [adena]
(20663,853,1,1,1,137.053122),-- [earing_of_protection]
(20663,1911,1,1,1,7671.3024),-- [earing_of_protection_gemstone]
(20663,916,1,1,1,102.828096),-- [necklace_of_protection]
(20663,1913,1,1,1,6271.850778),-- [necklace_of_protection_gemstone]
(20663,884,1,1,1,205.656192),-- [ring_of_protection]
(20663,1912,1,1,1,11114.309412),-- [ring_of_protection_gemstone]
(20663,1871,1,1,2,56254.98765),-- [charcoal]
(20663,1866,1,1,2,37503.35925),-- [suede]
(20663,1877,1,1,2,2250.2118),-- [admantite_nugget]
(20663,4041,1,1,2,489.19875),-- [mold_hardener]
(20663,4040,1,1,2,1125.1059),-- [mold_lubricant]
(20663,2340,1,1,2,130.82865),-- [rp_paagrio_hammer]
(20663,3006,1,1,2,2296.1094),-- [rp_demon's_gloves]
(20663,8724,1,1,2,1875.14235),-- [general_49_c]
(20663,8734,1,1,2,468.8112),-- [special_49_c]
(20663,8744,1,1,2,46.9221),-- [rare_49_c]
(20663,8754,1,1,2,9.32295),-- [unique_49_c]
(20664,2098,1,1,-1,7876),-- [nirvana_axe_blade]
(20664,1865,1,3,-1,735264),-- [varnish]
(20664,1867,1,5,-1,653568),-- [animal_skin]
(20664,57,582,1182,0,700000),-- [adena]
(20664,64,1,1,1,161.04976),-- [composite_boots]
(20664,2956,1,1,1,8942.95024),-- [composite_boots_part]
(20664,608,1,1,1,161.04976),-- [mithril_gauntlet]
(20664,1981,1,1,1,8942.95024),-- [mithril_gauntlet_design]
(20664,1867,1,1,2,57916.315041),-- [animal_skin]
(20664,1872,1,1,2,57916.315041),-- [animal_bone]
(20664,1882,1,1,2,9652.694199),-- [leather]
(20664,1894,1,1,2,1524.093837),-- [crafted_leather]
(20664,4042,1,1,2,723.910857),-- [enria]
(20664,2234,1,1,2,647.33904),-- [rp_divine_hose]
(20664,4609,1,1,2,96.501468),-- [dye_m3i3_c]
(20664,2356,1,1,2,70.877631),-- [rp_demon's_staff]
(20664,6669,1,1,2,10101.635811),-- [key_of_treasure_box5]
(20664,8725,1,1,2,1206.568044),-- [general_52_c]
(20664,8735,1,1,2,301.642011),-- [special_52_c]
(20664,8745,1,1,2,30.119247),-- [rare_52_c]
(20664,8755,1,1,2,5.99388),-- [unique_52_c]
(20664,1539,1,1,2,9652.993893),-- [greater_healing_potion]
(20665,2104,1,1,-1,10174),-- [club_of_nature_head]
(20665,2359,1,1,-1,2944),-- [rp_eminence_bow]
(20665,4043,1,1,-1,60164),-- [asofe]
(20665,57,715,1452,0,700000),-- [adena]
(20665,162,1,1,1,2.824002),-- [war_axe]
(20665,2097,1,1,1,249.916904),-- [war_axe_blade]
(20665,174,1,1,1,2.824002),-- [nirvana_axe]
(20665,2098,1,1,1,249.916904),-- [nirvana_axe_blade]
(20665,196,1,1,1,2.824002),-- [stick_of_eternity]
(20665,2099,1,1,1,263.018694),-- [stick_of_eternity_shaft]
(20665,197,1,1,1,2.824002),-- [paradia_staff]
(20665,2100,1,1,1,263.018694),-- [paradia_staff_head]
(20665,199,1,1,1,2.824002),-- [paagrio_hammer]
(20665,2102,1,1,1,253.584574),-- [paagrio_hammer_head]
(20665,200,1,1,1,2.824002),-- [sage's_staff]
(20665,2103,1,1,1,263.018694),-- [sage's_staff_head]
(20665,201,1,1,1,2.824002),-- [club_of_nature]
(20665,2104,1,1,1,263.018694),-- [club_of_nature_head]
(20665,202,1,1,1,2.824002),-- [mace_of_underworld]
(20665,2105,1,1,1,249.914826),-- [mace_of_underworld_head]
(20665,1870,1,1,2,67855.338432),-- [coal]
(20665,1865,1,1,2,67855.338432),-- [varnish]
(20665,1874,1,1,2,4523.67909),-- [oriharukon_ore]
(20665,4043,1,1,2,2261.915586),-- [asofe]
(20665,4039,1,1,2,2261.915586),-- [mold_glue]
(20665,4125,1,1,2,3015.78606),-- [rp_maestro_mold]
(20665,3014,1,1,2,1895.397966),-- [rp_full_plate_boots]
(20665,8725,1,1,2,1884.904308),-- [general_52_c]
(20665,8735,1,1,2,471.150036),-- [special_52_c]
(20665,8745,1,1,2,47.14542),-- [rare_52_c]
(20665,8755,1,1,2,9.429084),-- [unique_52_c]
(20666,1977,1,1,-1,27780),-- [composite_armor_temper]
(20666,1884,1,3,-1,577821),-- [cord]
(20666,4606,1,1,-1,4173),-- [dye_d3c3_c]
(20666,57,746,1507,0,700000),-- [adena]
(20666,64,1,1,1,205.66394),-- [composite_boots]
(20666,2956,1,1,1,11420.33606),-- [composite_boots_part]
(20666,608,1,1,1,205.66394),-- [mithril_gauntlet]
(20666,1981,1,1,1,11420.33606),-- [mithril_gauntlet_design]
(20666,1870,1,1,2,59737.700113),-- [coal]
(20666,1865,1,1,2,59737.700113),-- [varnish]
(20666,1874,1,1,2,3982.452642),-- [oriharukon_ore]
(20666,4043,1,1,2,1991.226321),-- [asofe]
(20666,4039,1,1,2,1991.226321),-- [mold_glue]
(20666,4607,1,1,2,132.800449),-- [dye_i3m3_c]
(20666,4609,1,1,2,132.800449),-- [dye_m3i3_c]
(20666,3955,1,1,2,119.533411),-- [rp_blessed_spiritshot_b]
(20666,5280,1,1,2,119.533411),-- [rp_adv_comp_bspiritshot_b]
(20666,8725,1,1,2,1659.420302),-- [general_52_c]
(20666,8735,1,1,2,414.790041),-- [special_52_c]
(20666,8745,1,1,2,41.492011),-- [rare_52_c]
(20666,8755,1,1,2,8.324416),-- [unique_52_c]
(20667,1988,1,1,-1,37181),-- [divine_tunic_fabric]
(20667,4141,1,1,-1,9303),-- [rp_avadon_breastplate]
(20667,4604,1,1,-1,4300),-- [dye_c3c3_c]
(20667,57,766,1556,0,700000),-- [adena]
(20667,301,1,1,1,6.47584),-- [scorpion]
(20667,2113,1,1,1,576.711625),-- [scorpion_blade]
(20667,303,1,1,1,6.47584),-- [widow_maker]
(20667,2114,1,1,1,576.711625),-- [widow_maker_head]
(20667,299,1,1,1,5.05239),-- [orcish_poleaxe]
(20667,2122,1,1,1,543.57268),-- [orcish_poleaxe_blade]
(20667,1875,1,1,2,3664.03052),-- [stone_of_purity]
(20667,1879,1,1,2,9160.0763),-- [cokes]
(20667,1885,1,1,2,4580.03815),-- [high_grade_suede]
(20667,5550,1,1,2,732.811485),-- [reinforcing_plate]
(20667,5549,1,1,2,5496.04578),-- [iron_thread]
(20667,4127,1,1,2,1360.397515),-- [rp_adamantite_ring]
(20667,4184,1,1,2,63.307465),-- [rp_sprite's_staff]
(20667,5155,1,1,2,109.93383),-- [rp_comp_soulshot_b]
(20667,5165,1,1,2,109.93383),-- [rp_comp_bspiritshot_b]
(20667,8726,1,1,2,1272.22983),-- [general_55_c]
(20667,8736,1,1,2,318.07091),-- [special_55_c]
(20667,8746,1,1,2,31.80171),-- [rare_55_c]
(20667,8756,1,1,2,6.322675),-- [unique_55_c]
(20668,4147,1,1,-1,17733),-- [rp_hose_of_shrnoen]
(20668,2917,1,1,-1,99106),-- [ring_of_binding_gemstone]
(20668,1806,1,1,-1,3451),-- [rp_soulshot_b]
(20668,57,682,1388,0,700000),-- [adena]
(20668,203,1,1,1,3.463976),-- [paagrio_axe]
(20668,2112,1,1,1,308.507784),-- [paagrio_axe_blade]
(20668,204,1,1,1,2.703032),-- [deadman's_staff]
(20668,2116,1,1,1,299.73248),-- [deadman's_staff_head]
(20668,205,1,1,1,2.703032),-- [ghoul's_staff]
(20668,2117,1,1,1,299.73248),-- [ghoul's_staff_head]
(20668,206,1,1,1,2.703032),-- [demon's_staff]
(20668,2118,1,1,1,299.73248),-- [demon's_staff_head]
(20668,2503,1,1,1,2.703032),-- [yaksa_mace]
(20668,2969,1,1,1,306.018672),-- [yaksa_mace_head]
(20668,1866,1,1,2,35393.71655),-- [suede]
(20668,1871,1,1,2,53090.574825),-- [charcoal]
(20668,5220,1,1,2,2123.64266),-- [reinforcing_agent]
(20668,1885,1,1,2,4424.189985),-- [high_grade_suede]
(20668,4041,1,1,2,461.682825),-- [mold_hardener]
(20668,4148,1,1,2,232.85728),-- [rp_avadon_robe]
(20668,4936,1,1,2,974.10651),-- [rp_avadon_shield_i]
(20668,8309,1,1,2,61.16437),-- [rp_spell_breaker]
(20668,8726,1,1,2,1228.99083),-- [general_55_c]
(20668,8736,1,1,2,307.19854),-- [special_55_c]
(20668,8746,1,1,2,30.68052),-- [rare_55_c]
(20668,8756,1,1,2,6.195105),-- [unique_55_c]
(20669,4057,1,1,-1,60231),-- [shrnoen's_gaiters_material]
(20669,4198,1,1,-1,1644),-- [rp_bellion_cestus]
(20669,4589,1,1,-1,7177),-- [dye_s2c2_c]
(20669,57,851,1734,0,700000),-- [adena]
(20669,286,1,1,1,16.868835),-- [eminence_bow]
(20669,2121,1,1,1,1828.131165),-- [eminence_bow_shaft]
(20669,1871,1,1,2,56789.027286),-- [charcoal]
(20669,1866,1,1,2,37859.351524),-- [suede]
(20669,1877,1,1,2,2271.615714),-- [admantite_nugget]
(20669,4041,1,1,2,493.765183),-- [mold_hardener]
(20669,4040,1,1,2,1135.807857),-- [mold_lubricant]
(20669,4191,1,1,2,65.433275),-- [rp_great_axe]
(20669,4186,1,1,2,65.433275),-- [rp_sword_of_valhalla]
(20669,5160,1,1,2,113.569406),-- [rp_comp_spiritshot_b]
(20669,5275,1,1,2,113.569406),-- [rp_adv_comp_spiritshot_b]
(20669,6669,1,1,2,13206.710835),-- [key_of_treasure_box5]
(20669,8726,1,1,2,1314.582944),-- [general_55_c]
(20669,8736,1,1,2,328.645736),-- [special_55_c]
(20669,8746,1,1,2,32.887333),-- [rare_55_c]
(20669,8756,1,1,2,6.600226),-- [unique_55_c]
(20670,4065,1,1,-1,62421),-- [avadon_gaiters_material]
(20670,948,1,1,-1,5579),-- [scrl_of_ench_am_b]
(20670,4129,1,1,-1,24151),-- [rp_earing_of_black_ore]
(20670,57,884,1793,0,700000),-- [adena]
(20670,12159,1,1,1,752.464554),-- [shrnoen's_shield_low]
(20670,4101,1,1,1,4776.48483),-- [shrnoen's_shield_fragment]
(20670,12171,1,1,1,752.464554),-- [avadon_shield_low]
(20670,4439,1,1,1,5682.370236),-- [avadon_shield_fragment]
(20670,12160,1,1,1,526.47813),-- [shrnoen's_helmet_low]
(20670,4102,1,1,1,3700.619574),-- [shrnoen's_helmet_design]
(20670,12170,1,1,1,526.47813),-- [avadon_circlet_low]
(20670,4072,1,1,1,3700.639992),-- [avadon_circlet_pattern]
(20670,1869,1,1,2,54930.624519),-- [iron_ore]
(20670,1864,1,1,2,109861.249038),-- [stem]
(20670,1880,1,1,2,5493.009909),-- [steel]
(20670,5550,1,1,2,732.448026),-- [reinforcing_plate]
(20670,4043,1,1,2,1830.944922),-- [asofe]
(20670,4616,1,1,2,75.836919),-- [dye_c4c4_c]
(20670,4168,1,1,2,683.232843),-- [rp_doom_gloves]
(20670,4164,1,1,2,363.772011),-- [rp_hose_of_doom]
(20670,8728,1,1,2,915.472461),-- [general_61_b]
(20670,8738,1,1,2,228.911901),-- [special_61_b]
(20670,8748,1,1,2,22.943733),-- [rare_61_b]
(20670,8758,1,1,2,4.553718),-- [unique_61_b]
(20671,2098,1,1,-1,12502),-- [nirvana_axe_blade]
(20671,947,1,1,-1,934),-- [scrl_of_ench_wp_b]
(20671,4052,1,1,-1,82640),-- [earing_of_black_ore_piece]
(20671,57,926,1875,0,700000),-- [adena]
(20671,358,1,1,1,9.28572),-- [blue_wolve's_breastplate]
(20671,4078,1,1,1,1678.628115),-- [blue_wolve's_breastplate_part]
(20671,2381,1,1,1,5.71509),-- [doom_plate_armor]
(20671,4081,1,1,1,1132.654845),-- [doom_plate_armor_temper]
(20671,2380,1,1,1,14.85507),-- [blue_wolve's_gaiters]
(20671,4080,1,1,1,2363.86116),-- [blue_wolve's_gaiters_material]
(20671,1869,1,1,2,57456.624701),-- [iron_ore]
(20671,1864,1,1,2,114913.249402),-- [stem]
(20671,1880,1,1,2,5745.607511),-- [steel]
(20671,5550,1,1,2,766.129854),-- [reinforcing_plate]
(20671,4043,1,1,2,1915.141438),-- [asofe]
(20671,4616,1,1,2,79.324301),-- [dye_c4c4_c]
(20671,4168,1,1,2,714.651497),-- [rp_doom_gloves]
(20671,4164,1,1,2,380.500169),-- [rp_hose_of_doom]
(20671,8728,1,1,2,957.570719),-- [general_61_b]
(20671,8738,1,1,2,239.438479),-- [special_61_b]
(20671,8748,1,1,2,23.998807),-- [rare_61_b]
(20671,8758,1,1,2,4.763122),-- [unique_61_b]
(20672,4070,1,1,-1,84802),-- [hose_of_shrnoen_fabric]
(20672,4154,1,1,-1,28035),-- [rp_doom_shield]
(20672,4052,1,1,-1,83872),-- [earing_of_black_ore_piece]
(20672,57,940,1902,0,700000),-- [adena]
(20672,601,1,1,1,28.27034),-- [doom_boots]
(20672,4099,1,1,1,3926.72966),-- [doom_boots_part]
(20672,2439,1,1,1,28.27034),-- [blue_wolve's_boots]
(20672,4090,1,1,1,3926.72966),-- [blue_wolve's_boots_design]
(20672,2475,1,1,1,28.27034),-- [doom_gloves]
(20672,4091,1,1,1,3926.72966),-- [doom_gloves_part]
(20672,2487,1,1,1,28.27034),-- [blue_wolve's_gloves]
(20672,4096,1,1,1,3926.72966),-- [blue_wolve's_gloves_fabric]
(20672,1868,1,1,2,127227.524824),-- [thread]
(20672,1873,1,1,2,25445.438128),-- [silver_nugget]
(20672,5549,1,1,2,6361.359532),-- [iron_thread]
(20672,1889,1,1,2,4240.962052),-- [compound_braid]
(20672,4044,1,1,2,2120.39748),-- [thons]
(20672,4991,1,1,2,525.671432),-- [rp_doom_helmet_i]
(20672,5276,1,1,2,84.882736),-- [rp_adv_comp_spiritshot_a]
(20672,8729,1,1,2,848.158992),-- [general_64_a]
(20672,8739,1,1,2,212.039748),-- [special_64_a]
(20672,8749,1,1,2,21.220684),-- [rare_64_a]
(20672,8759,1,1,2,4.344392),-- [unique_64_a]
(20673,4052,1,1,-1,87623),-- [earing_of_black_ore_piece]
(20673,4041,1,1,-1,21521),-- [mold_hardener]
(20673,5230,1,1,-1,3300),-- [rp_mithril_arrow]
(20673,57,983,1987,0,700000),-- [adena]
(20673,79,1,1,1,2.415321),-- [sword_of_damascus]
(20673,4114,1,1,1,533.549712),-- [sword_of_damascus_blade]
(20673,7883,1,1,1,2.415321),-- [guardians_sword]
(20673,8330,1,1,1,532.653006),-- [guardians_sword_blade]
(20673,7889,1,1,1,2.415321),-- [tears_of_wizard]
(20673,8336,1,1,1,533.551319),-- [tears_of_wizard_blade]
(20673,1872,1,1,2,88612.199847),-- [animal_bone]
(20673,1867,1,1,2,88612.199847),-- [animal_skin]
(20673,1881,1,1,2,8861.187342),-- [coarse_bone_powder]
(20673,1875,1,1,2,4430.593671),-- [stone_of_purity]
(20673,4041,1,1,2,577.77579),-- [mold_hardener]
(20673,4150,1,1,2,1280.573121),-- [rp_avadon_gloves]
(20673,6037,1,1,2,132918.136557),-- [scroll_of_awake]
(20673,8729,1,1,2,886.249305),-- [general_64_a]
(20673,8739,1,1,2,221.643933),-- [special_64_a]
(20673,8749,1,1,2,22.197036),-- [rare_64_a]
(20673,8759,1,1,2,4.243551),-- [unique_64_a]
(20674,2089,1,1,-1,19453),-- [caliburs_edge]
(20674,4124,1,1,-1,158653),-- [rp_craftsman_mold]
(20674,4053,1,1,-1,153008),-- [ring_of_black_ore_gemstone]
(20674,57,1415,2868,0,700000),-- [adena]
(20674,601,1,1,1,42.600293),-- [doom_boots]
(20674,4099,1,1,1,5917.149707),-- [doom_boots_part]
(20674,2439,1,1,1,42.600293),-- [blue_wolve's_boots]
(20674,4090,1,1,1,5917.149707),-- [blue_wolve's_boots_design]
(20674,2475,1,1,1,42.600293),-- [doom_gloves]
(20674,4091,1,1,1,5917.149707),-- [doom_gloves_part]
(20674,2487,1,1,1,42.600293),-- [blue_wolve's_gloves]
(20674,4096,1,1,1,5917.149707),-- [blue_wolve's_gloves_fabric]
(20674,1872,1,1,2,117158.902704),-- [animal_bone]
(20674,1867,1,1,2,117158.902704),-- [animal_skin]
(20674,1881,1,1,2,11715.839322),-- [coarse_bone_powder]
(20674,1875,1,1,2,5858.047032),-- [stone_of_purity]
(20674,4041,1,1,2,763.971258),-- [mold_hardener]
(20674,4157,1,1,2,437.137272),-- [rp_blue_wolve's_gaiters]
(20674,5276,1,1,2,117.18132),-- [rp_adv_comp_spiritshot_a]
(20674,8316,1,1,2,32.606976),-- [rp_dragon_flame_head_i]
(20674,8729,1,1,2,1171.558458),-- [general_64_a]
(20674,8739,1,1,2,292.9533),-- [special_64_a]
(20674,8749,1,1,2,29.29533),-- [rare_64_a]
(20674,8759,1,1,2,5.604324),-- [unique_64_a]
(20675,4042,1,1,-1,25482),-- [enria]
(20675,1539,1,1,-1,339759),-- [greater_healing_potion]
(20675,4602,1,1,-1,3398),-- [dye_s3d3_c]
(20675,57,605,1229,0,700000),-- [adena]
(20675,60,1,1,1,51.530472),-- [composite_armor]
(20675,1977,1,1,1,4676.469528),-- [composite_armor_temper]
(20675,1872,1,1,2,70251.79075),-- [animal_bone]
(20675,1867,1,1,2,70251.79075),-- [animal_skin]
(20675,1881,1,1,2,7025.117625),-- [coarse_bone_powder]
(20675,1875,1,1,2,3512.635625),-- [stone_of_purity]
(20675,4041,1,1,2,458.10975),-- [mold_hardener]
(20675,2353,1,1,2,85.876375),-- [rp_samurai_longsword]
(20675,4184,1,1,2,60.681875),-- [rp_sprite's_staff]
(20675,5155,1,1,2,105.38675),-- [rp_comp_soulshot_b]
(20675,8725,1,1,2,1463.585375),-- [general_52_c]
(20675,8735,1,1,2,365.93475),-- [special_52_c]
(20675,8745,1,1,2,36.56275),-- [rare_52_c]
(20675,8755,1,1,2,7.527625),-- [unique_52_c]
(20676,5478,1,1,-1,21536),-- [sealed_dark_crystal_leather_mail_pattern]
(20676,1807,1,1,-1,3415),-- [rp_soulshot_a]
(20676,5479,1,1,-1,15155),-- [sealed_tallum_leather_mail_pattern]
(20676,57,1015,2058,0,700000),-- [adena]
(20676,12341,1,1,1,585.074805),-- [earing_of_black_ore_low]
(20676,4052,1,1,1,4463.954738),-- [earing_of_black_ore_piece]
(20676,12342,1,1,1,438.560274),-- [necklace_of_black_ore_low]
(20676,4054,1,1,1,2483.436264),-- [necklace_of_black_ore_beads]
(20676,12343,1,1,1,875.58144),-- [ring_of_black_ore_low]
(20676,4053,1,1,1,5404.392479),-- [ring_of_black_ore_gemstone]
(20676,1867,1,1,2,100868.629675),-- [animal_skin]
(20676,1872,1,1,2,100868.629675),-- [animal_bone]
(20676,1882,1,1,2,16811.475992),-- [leather]
(20676,1894,1,1,2,2654.455487),-- [crafted_leather]
(20676,4042,1,1,2,1260.815444),-- [enria]
(20676,8729,1,1,2,1008.742866),-- [general_64_a]
(20676,8739,1,1,2,252.072578),-- [special_64_a]
(20676,8749,1,1,2,25.116747),-- [rare_64_a]
(20676,8759,1,1,2,4.978094),-- [unique_64_a]
(20676,6036,1,1,2,2522.083442),-- [potion_of_acumen3]
(20677,3035,1,1,-1,3845),-- [rp_spiritshot_a]
(20677,5482,1,1,-1,38058),-- [sealed_legging_of_dark_crystal_design]
(20677,5230,1,1,-1,3845),-- [rp_mithril_arrow]
(20677,57,1142,2317,0,700000),-- [adena]
(20677,11944,1,1,1,139.117392),-- [hazard_bow_low]
(20677,4121,1,1,1,1854.882608),-- [hazard_bow_shaft]
(20677,1869,1,1,2,85174.1275),-- [iron_ore]
(20677,1864,1,1,2,170348.5245),-- [stem]
(20677,1880,1,1,2,8517.5475),-- [steel]
(20677,5550,1,1,2,1135.673),-- [reinforcing_plate]
(20677,4043,1,1,2,2839.1825),-- [asofe]
(20677,8316,1,1,2,31.5315),-- [rp_dragon_flame_head_i]
(20677,8729,1,1,2,1135.673),-- [general_64_a]
(20677,8739,1,1,2,283.7835),-- [special_64_a]
(20677,8749,1,1,2,28.2975),-- [rare_64_a]
(20677,8759,1,1,2,5.6595),-- [unique_64_a]
(20678,1989,1,1,-1,49499),-- [divine_hose_pattern]
(20678,4142,1,1,-1,12634),-- [rp_avadon_gaiters]
(20678,1918,1,1,-1,71130),-- [nassen's_earing_gemstone]
(20678,57,650,1321,0,700000),-- [adena]
(20678,266,1,1,1,12.862564),-- [great_pata]
(20678,2120,1,1,1,1456.137436),-- [great_pata_blade]
(20678,1895,1,1,2,15750.9734),-- [metallic_fiber]
(20678,4040,1,1,2,1102.5614),-- [mold_lubricant]
(20678,4042,1,1,2,918.81614),-- [enria]
(20678,4043,1,1,2,1837.60982),-- [asofe]
(20678,4128,1,1,2,682.28988),-- [rp_adamantite_necklace]
(20678,5280,1,1,2,110.25614),-- [rp_adv_comp_bspiritshot_b]
(20678,4134,1,1,2,424.06726),-- [rp_shrnoen's_gaiters]
(20678,8726,1,1,2,1276.10982),-- [general_55_c]
(20678,8736,1,1,2,319.02184),-- [special_55_c]
(20678,8746,1,1,2,31.8932),-- [rare_55_c]
(20678,8756,1,1,2,6.4011),-- [unique_55_c]
(20679,4148,1,1,-1,7419),-- [rp_avadon_robe]
(20679,1806,1,1,-1,3383),-- [rp_soulshot_b]
(20679,1920,1,1,-1,57882),-- [necklace_of_binding_chain]
(20679,57,668,1361,0,700000),-- [adena]
(20679,203,1,1,1,3.395966),-- [paagrio_axe]
(20679,2112,1,1,1,302.450694),-- [paagrio_axe_blade]
(20679,204,1,1,1,2.649962),-- [deadman's_staff]
(20679,2116,1,1,1,293.84768),-- [deadman's_staff_head]
(20679,205,1,1,1,2.649962),-- [ghoul's_staff]
(20679,2117,1,1,1,293.84768),-- [ghoul's_staff_head]
(20679,206,1,1,1,2.649962),-- [demon's_staff]
(20679,2118,1,1,1,293.84768),-- [demon's_staff_head]
(20679,2503,1,1,1,2.649962),-- [yaksa_mace]
(20679,2969,1,1,1,300.010452),-- [yaksa_mace_head]
(20679,1869,1,1,2,48045.55767),-- [iron_ore]
(20679,1870,1,1,2,48045.55767),-- [coal]
(20679,1871,1,1,2,48045.55767),-- [charcoal]
(20679,1872,1,1,2,64060.651974),-- [animal_bone]
(20679,1867,1,1,2,64060.651974),-- [animal_skin]
(20679,4149,1,1,2,617.655984),-- [rp_avadon_circlet]
(20679,4186,1,1,2,55.226358),-- [rp_sword_of_valhalla]
(20679,5160,1,1,2,96.1653),-- [rp_comp_spiritshot_b]
(20679,4143,1,1,2,308.003718),-- [rp_shrnoen's_leather_shirts]
(20679,8726,1,1,2,1112.220384),-- [general_55_c]
(20679,8736,1,1,2,278.055096),-- [special_55_c]
(20679,8746,1,1,2,27.750558),-- [rare_55_c]
(20679,8756,1,1,2,4.945644),-- [unique_55_c]
(20680,1873,1,1,-1,716613),-- [silver_nugget]
(20680,1876,1,1,-1,358306),-- [mithril_ore]
(20680,3034,1,1,-1,3583),-- [rp_spiritshot_b]
(20680,57,708,1442,0,700000),-- [adena]
(20680,301,1,1,1,5.996288),-- [scorpion]
(20680,2113,1,1,1,534.0047),-- [scorpion_blade]
(20680,303,1,1,1,5.996288),-- [widow_maker]
(20680,2114,1,1,1,534.0047),-- [widow_maker_head]
(20680,299,1,1,1,4.678248),-- [orcish_poleaxe]
(20680,2122,1,1,1,503.319776),-- [orcish_poleaxe_blade]
(20680,1874,1,1,2,3674.942988),-- [oriharukon_ore]
(20680,1878,1,1,2,22049.589604),-- [braided_hemp]
(20680,1884,1,1,2,33922.456056),-- [cord]
(20680,1889,1,1,2,3674.942988),-- [compound_braid]
(20680,5220,1,1,2,2204.952128),-- [reinforcing_agent]
(20680,4441,1,1,2,1011.468496),-- [rp_avadon_shield]
(20680,5280,1,1,2,110.274936),-- [rp_adv_comp_bspiritshot_b]
(20680,8311,1,1,2,42.087584),-- [rp_bone_of_kaim_vanul]
(20680,8726,1,1,2,1276.019024),-- [general_55_c]
(20680,8736,1,1,2,319.004756),-- [special_55_c]
(20680,8746,1,1,2,31.907308),-- [rare_55_c]
(20680,8756,1,1,2,6.354132),-- [unique_55_c]
(20681,1873,1,1,-1,494213),-- [silver_nugget]
(20681,2063,1,1,-1,9550),-- [battle_axe_head]
(20681,1908,1,1,-1,117001),-- [moonstone_earing_wire]
(20681,57,489,993,0,700000),-- [adena]
(20681,71,1,1,1,16.565175),-- [flamberge]
(20681,2059,1,1,1,1084.539654),-- [flamberge_blade]
(20681,72,1,1,1,16.565175),-- [stormbringer]
(20681,2060,1,1,1,1159.329996),-- [stormbringer_blade]
(20681,1866,1,1,2,32440.80671),-- [suede]
(20681,1871,1,1,2,48661.11865),-- [charcoal]
(20681,5220,1,1,2,1946.40818),-- [reinforcing_agent]
(20681,1885,1,1,2,4055.077985),-- [high_grade_suede]
(20681,4041,1,1,2,423.160035),-- [mold_hardener]
(20681,4440,1,1,2,169.574825),-- [rp_knuckle_dust]
(20681,2225,1,1,2,1057.85438),-- [rp_demon's_hose]
(20681,2321,1,1,2,169.574825),-- [rp_stiletto]
(20681,8723,1,1,2,1946.40818),-- [general_46_c]
(20681,8733,1,1,2,486.602045),-- [special_46_c]
(20681,8743,1,1,2,48.63278),-- [rare_46_c]
(20681,8753,1,1,2,9.781405),-- [unique_46_c]
(20682,951,1,1,-1,2236),-- [scrl_of_ench_wp_c]
(20682,1876,1,1,-1,245912),-- [mithril_ore]
(20682,4039,1,1,-1,40985),-- [mold_glue]
(20682,57,484,990,0,700000),-- [adena]
(20682,397,1,1,1,99.843328),-- [tempered_mithril_shirt]
(20682,1961,1,1,1,4648.992856),-- [tempered_mithril_shirt_fabric]
(20682,2387,1,1,1,159.567424),-- [tempered_mithril_gaiters]
(20682,2935,1,1,1,7723.596392),-- [tempered_mithril_gaiters_fragment]
(20682,1870,1,1,2,58110.629145),-- [coal]
(20682,1865,1,1,2,58110.629145),-- [varnish]
(20682,1874,1,1,2,3874.041943),-- [oriharukon_ore]
(20682,4043,1,1,2,1936.957398),-- [asofe]
(20682,4039,1,1,2,1936.957398),-- [mold_glue]
(20682,2323,1,1,2,202.418024),-- [rp_elemental_bow]
(20682,8723,1,1,2,2324.374307),-- [general_46_c]
(20682,8733,1,1,2,581.06179),-- [special_46_c]
(20682,8743,1,1,2,58.106179),-- [rare_46_c]
(20682,8753,1,1,2,11.824671),-- [unique_46_c]
(20683,2336,1,1,-1,3717),-- [rp_nirvana_axe]
(20683,1974,1,1,-1,134435),-- [crimson_boots_fabric]
(20683,1889,1,1,-1,106562),-- [compound_braid]
(20683,57,631,1287,0,700000),-- [adena]
(20683,227,1,1,1,16.024815),-- [stiletto]
(20683,2083,1,1,1,1176.475185),-- [stiletto_edge]
(20683,242,1,1,1,16.024815),-- [dagger_of_magicflame]
(20683,2084,1,1,1,1176.475185),-- [dagger_of_magicflame_blade]
(20683,1868,1,1,2,118037.87411),-- [thread]
(20683,1873,1,1,2,23607.574822),-- [silver_nugget]
(20683,5549,1,1,2,5901.933786),-- [iron_thread]
(20683,1889,1,1,2,3934.622524),-- [compound_braid]
(20683,4044,1,1,2,1967.311262),-- [thons]
(20683,2224,1,1,2,801.930644),-- [rp_demon's_tunic]
(20683,2230,1,1,2,1143.737148),-- [rp_theca_leather_gaiters]
(20683,3005,1,1,2,2408.998372),-- [rp_demon's_boots]
(20683,8724,1,1,2,1967.311262),-- [general_49_c]
(20683,8734,1,1,2,491.867896),-- [special_49_c]
(20683,8744,1,1,2,49.218854),-- [rare_49_c]
(20683,8754,1,1,2,9.61932),-- [unique_49_c]
(20684,1876,1,1,-1,334736),-- [mithril_ore]
(20684,2078,1,1,-1,11121),-- [katana_blade]
(20684,1966,1,1,-1,61106),-- [plate_leather_fragment]
(20684,57,662,1345,0,700000),-- [adena]
(20684,398,1,1,1,54.051228),-- [plate_leather]
(20684,1966,1,1,1,3384.201645),-- [plate_leather_fragment]
(20684,399,1,1,1,49.842606),-- [rind_leather_mail]
(20684,1975,1,1,1,3044.607588),-- [rind_leather_mail_design]
(20684,418,1,1,1,86.43327),-- [plate_leather_gaiters]
(20684,1967,1,1,1,5055.528918),-- [plate_leather_gaiters_material]
(20684,419,1,1,1,79.807299),-- [rind_leather_gaiters]
(20684,1976,1,1,1,5636.527446),-- [rind_leather_gaiters_material]
(20684,1871,1,1,2,61797.572675),-- [charcoal]
(20684,1866,1,1,2,41198.333175),-- [suede]
(20684,1877,1,1,2,2471.879575),-- [admantite_nugget]
(20684,4041,1,1,2,537.365125),-- [mold_hardener]
(20684,4040,1,1,2,1236.0127),-- [mold_lubricant]
(20684,2341,1,1,2,143.78345),-- [rp_sage's_staff]
(20684,6668,1,1,2,22070.61375),-- [key_of_treasure_box4]
(20684,8724,1,1,2,2059.92395),-- [general_49_c]
(20684,8734,1,1,2,514.908075),-- [special_49_c]
(20684,8744,1,1,2,51.476225),-- [rare_49_c]
(20684,8754,1,1,2,10.353575),-- [unique_49_c]
(20684,1539,1,1,2,13732.777725),-- [greater_healing_potion]
(20685,2090,1,1,-1,7611),-- [sword_of_delusion_blade]
(20685,1970,1,1,-1,31188),-- [robe_of_seal_fabric]
(20685,2166,1,1,-1,47343),-- [rp_earing_of_binding]
(20685,57,551,1124,0,700000),-- [adena]
(20685,195,1,1,1,14.001112),-- [cursed_staff]
(20685,2082,1,1,1,1090.279304),-- [cursed_staff_head]
(20685,2502,1,1,1,14.001112),-- [dwarven_warhammer]
(20685,2968,1,1,1,1043.718472),-- [dwarven_warhammer_head]
(20685,1872,1,1,2,75007.060317),-- [animal_bone]
(20685,1867,1,1,2,75007.060317),-- [animal_skin]
(20685,1881,1,1,2,7500.722472),-- [coarse_bone_powder]
(20685,1875,1,1,2,3750.361236),-- [stone_of_purity]
(20685,4041,1,1,2,489.098925),-- [mold_hardener]
(20685,2351,1,1,2,117.712548),-- [rp_scorpion]
(20685,2330,1,1,2,130.864788),-- [rp_homunkulus's_sword]
(20685,8724,1,1,2,1875.180618),-- [general_49_c]
(20685,8734,1,1,2,468.712953),-- [special_49_c]
(20685,8744,1,1,2,46.854855),-- [rare_49_c]
(20685,8754,1,1,2,9.370971),-- [unique_49_c]
(20686,2231,1,1,-1,12559),-- [rp_full_plate_armor]
(20686,1880,1,1,-1,291368),-- [steel]
(20686,2169,1,1,-1,51570),-- [rp_necklace_of_binding]
(20686,57,1152,2343,0,700000),-- [adena]
(20686,326,1,1,1,36.468759),-- [heathen's_book]
(20686,2110,1,1,1,3396.531241),-- [heathen's_book_page]
(20686,1871,1,1,2,100409.59008),-- [charcoal]
(20686,1866,1,1,2,66939.72672),-- [suede]
(20686,1877,1,1,2,4016.312256),-- [admantite_nugget]
(20686,4041,1,1,2,873.11136),-- [mold_hardener]
(20686,4040,1,1,2,2008.245312),-- [mold_lubricant]
(20686,2354,1,1,2,163.741824),-- [rp_deadman's_staff]
(20686,4609,1,1,2,223.138368),-- [dye_m3i3_c]
(20686,2358,1,1,2,163.741824),-- [rp_great_pata]
(20686,8725,1,1,2,2789.140416),-- [general_52_c]
(20686,8735,1,1,2,697.240512),-- [special_52_c]
(20686,8745,1,1,2,69.741888),-- [rare_52_c]
(20686,8755,1,1,2,14.26944),-- [unique_52_c]
(20745,848,1,1,-1,6478),-- [enchanted_earing]
(20745,1832,1,3,-1,590229),-- [advanced_antidote]
(20745,1901,1,1,-1,146742),-- [tiger'seye_earing_stone]
(20745,57,449,895,0,700000),-- [adena]
(20745,393,1,1,1,160.930318),-- [mithril_banded_mail]
(20745,1938,1,1,1,6328.819738),-- [mithril_banded_mail_material]
(20745,394,1,1,1,160.930318),-- [reinforce_leather_shirt]
(20745,415,1,1,1,257.223044),-- [mithril_banded_gaiters]
(20745,1939,1,1,1,8268.888972),-- [mithril_banded_gaiters_material]
(20745,416,1,1,1,257.20761),-- [reinforce_leather_gaiters]
(20745,1867,1,1,2,150633.733232),-- [animal_skin]
(20745,1872,1,1,2,150633.733232),-- [animal_bone]
(20745,1882,1,1,2,25105.734278),-- [leather]
(20745,2156,1,1,2,9037.876058),-- [rp_elven_necklace]
(20745,2272,1,1,2,806.9232),-- [rp_sword_of_revolution]
(20746,2153,1,1,-1,129445),-- [rp_tiger'seye_earing]
(20746,1900,1,1,-1,91065),-- [enchanted_necklace_chain]
(20746,1061,1,1,-1,504445),-- [healing_potion]
(20746,57,352,702,0,700000),-- [adena]
(20746,259,1,1,1,184),-- [single-edged_jamadhr]
(20746,1865,1,1,2,75806.272725),-- [varnish]
(20746,1870,1,1,2,75806.272725),-- [coal]
(20746,1879,1,1,2,12634.46769),-- [cokes]
(20746,1875,1,1,2,5053.751515),-- [stone_of_purity]
(20746,2184,1,1,2,7962.81912),-- [rp_mithril_banded_gaiters]
(20746,2272,1,1,2,541.416225),-- [rp_sword_of_revolution]
(20747,2024,1,1,-1,16676),-- [elven_bow_shaft]
(20747,2203,1,1,-1,255050),-- [rp_mithril_boots]
(20747,1900,1,1,-1,128083),-- [enchanted_necklace_chain]
(20747,57,493,989,0,700000),-- [adena]
(20747,627,1,1,1,2378.09442),-- [aspis]
(20747,46,1,1,1,1665.90558),-- [bronze_helmet]
(20747,1872,1,1,2,121853.866008),-- [animal_bone]
(20747,1867,1,1,2,121853.866008),-- [animal_skin]
(20747,1881,1,1,2,12185.467392),-- [coarse_bone_powder]
(20747,1875,1,1,2,6092.733696),-- [stone_of_purity]
(20747,2183,1,1,2,6012.481104),-- [rp_mithril_banded_mail]
(20747,2274,1,1,2,652.792896),-- [rp_skull_breaker]
(20747,2282,1,1,2,652.792896),-- [rp_cursed_maingauche]
(20748,1866,1,1,-1,734952),-- [suede]
(20748,1871,1,3,-1,551214),-- [charcoal]
(20748,1061,1,1,-1,668138),-- [healing_potion]
(20748,57,467,925,0,700000),-- [adena]
(20748,275,1,1,1,81.061745),-- [long_bow]
(20748,276,1,1,1,81.061745),-- [elven_bow]
(20748,2024,1,1,1,2860.87651),-- [elven_bow_shaft]
(20748,1866,1,1,2,57374.698598),-- [suede]
(20748,1871,1,1,2,86062.24418),-- [charcoal]
(20748,5220,1,1,2,3442.411254),-- [reinforcing_agent]
(20748,1885,1,1,2,7171.788254),-- [high_grade_suede]
(20748,956,1,1,2,2868.872328),-- [scrl_of_ench_am_d]
(20748,2190,1,1,2,6147.190994),-- [rp_mithril_hose]
(20748,1831,1,1,2,229498.794392),-- [antidote]
(20749,2025,1,1,-1,16214),-- [dwarven_trident_edge]
(20749,1871,1,3,-1,585341),-- [charcoal]
(20749,2153,1,1,-1,182066),-- [rp_tiger'seye_earing]
(20749,57,493,989,0,700000),-- [adena]
(20749,627,1,1,1,2378.09442),-- [aspis]
(20749,46,1,1,1,1665.90558),-- [bronze_helmet]
(20749,1871,1,1,2,159932.96268),-- [charcoal]
(20749,1866,1,1,2,106622.071704),-- [suede]
(20749,1877,1,1,2,6397.434408),-- [admantite_nugget]
(20749,2184,1,1,2,16799.531208),-- [rp_mithril_banded_gaiters]
(20750,1933,1,1,-1,134288),-- [dark_hose_fabric]
(20750,2183,1,1,-1,75095),-- [rp_mithril_banded_mail]
(20750,1935,1,1,-1,63768),-- [scale_mail_fragment]
(20750,57,484,958,0,700000),-- [adena]
(20750,222,1,1,1,252),-- [poniard_dagger]
(20750,1867,1,3,2,55445.058376),-- [animal_skin]
(20750,1872,1,1,2,166334.709391),-- [animal_bone]
(20750,1882,1,1,2,27722.529188),-- [leather]
(20750,1829,1,1,2,49900.459391),-- [scroll_of_escape_to_agit]
(20750,1831,1,3,2,166334.243654),-- [antidote]
(20751,2161,1,1,-1,423261),-- [rp_aquastone_ring]
(20751,1949,1,1,-1,486561),-- [mithril_glove_design]
(20751,1894,1,1,-1,152968),-- [crafted_leather]
(20751,57,1716,3517,0,700000),-- [adena]
(20751,62,1,1,1,235.770525),-- [mithril_boots]
(20751,1958,1,1,1,10289.21895),-- [mithril_boots_design]
(20751,2429,1,1,1,235.770525),-- [chain_boots]
(20751,2937,1,1,1,10289.21895),-- [chain_boots_part]
(20751,2430,1,1,1,235.770525),-- [karmian_boots]
(20751,2938,1,1,1,10289.21895),-- [karmian_boots_fabric]
(20751,2431,1,1,1,235.770525),-- [plate_leather_boots]
(20751,2939,1,1,1,10289.21895),-- [plate_leather_boots_lining]
(20751,2432,1,1,1,235.770525),-- [dwarven_chain_boots]
(20751,2940,1,1,1,10289.21895),-- [dwarven_chain_boots_part]
(20751,2433,1,1,1,235.770525),-- [boots_of_seal]
(20751,2941,1,1,1,10289.21895),-- [boots_of_seal_pattern]
(20751,2452,1,1,1,235.770525),-- [reinforce_mithril_gloves]
(20751,2942,1,1,1,10289.21895),-- [reinforce_mithril_gloves_design]
(20751,2453,1,1,1,235.770525),-- [chain_gloves]
(20751,2943,1,1,1,10289.21895),-- [chain_gloves_design]
(20751,2454,1,1,1,235.770525),-- [karmian_gloves]
(20751,2944,1,1,1,10289.313675),-- [karmian_gloves_fabric]
(20751,1894,1,1,2,9036.767322),-- [crafted_leather]
(20751,2216,1,1,2,10642.50075),-- [rp_great_helmet]
(20751,2225,1,1,2,5598.890242),-- [rp_demon's_hose]
(20751,2321,1,1,2,897.374876),-- [rp_stiletto]
(20751,8723,1,1,2,10301.940726),-- [general_46_c]
(20751,8733,1,1,2,2575.495022),-- [special_46_c]
(20751,8743,1,1,2,257.545566),-- [rare_46_c]
(20751,8753,1,1,2,51.485496),-- [unique_46_c]
(20752,1805,1,1,-1,7711),-- [rp_soulshot_c]
(20752,1905,1,1,-1,225036),-- [onyxbeast'seye_earing_gemstone]
(20752,5549,1,1,-1,231337),-- [iron_thread]
(20752,57,932,1883,0,700000),-- [adena]
(20752,353,1,1,1,193.097417),-- [half_plate]
(20752,1950,1,1,1,9426.365273),-- [half_plate_temper]
(20752,380,1,1,1,308.960785),-- [plate_gaiters]
(20752,1951,1,1,1,14660.576525),-- [plate_gaiters_part]
(20752,1868,1,1,2,331904.637384),-- [thread]
(20752,1873,1,1,2,66380.839891),-- [silver_nugget]
(20752,5549,1,1,2,16595.319455),-- [iron_thread]
(20752,1889,1,1,2,11063.400327),-- [compound_braid]
(20752,2160,1,1,2,10706.488192),-- [rp_moonstone_earing]
(20752,5159,1,1,2,553.104327),-- [rp_comp_spiritshot_c]
(20752,2312,1,1,2,725.210424),-- [rp_crystallized_ice_bow]
(20753,1874,1,1,-1,250765),-- [oriharukon_ore]
(20753,1875,1,1,-1,250765),-- [stone_of_purity]
(20753,4601,1,1,-1,8359),-- [dye_s3c3_c]
(20753,57,1488,3024,0,700000),-- [adena]
(20753,75,1,1,1,7.845835),-- [caliburs]
(20753,2089,1,1,1,706.32226),-- [caliburs_edge]
(20753,76,1,1,1,7.845835),-- [sword_of_delusion]
(20753,2090,1,1,1,706.32226),-- [sword_of_delusion_blade]
(20753,77,1,1,1,7.845835),-- [tsurugi]
(20753,2091,1,1,1,706.32226),-- [tsurugi_blade]
(20753,84,1,1,1,7.845835),-- [homunkulus's_sword]
(20753,2092,1,1,1,706.32226),-- [homunkulus's_sword_blade]
(20753,134,1,1,1,7.845835),-- [sword_of_nightmare]
(20753,2095,1,1,1,706.32226),-- [sword_of_nightmare_blade]
(20753,145,1,1,1,7.845835),-- [deathbreath_sword]
(20753,2096,1,1,1,706.31369),-- [deathbreath_sword_blade]
(20753,1868,1,3,2,119654.817944),-- [thread]
(20753,1873,1,1,2,47861.751712),-- [silver_nugget]
(20753,5549,1,1,2,11965.437928),-- [iron_thread]
(20753,1889,1,1,2,7977.10484),-- [compound_braid]
(20753,4044,1,1,2,3988.333088),-- [thons]
(20753,2355,1,1,2,195.20548),-- [rp_ghoul's_staff]
(20753,4609,1,1,2,265.830384),-- [dye_m3i3_c]
(20753,3019,1,1,2,3190.841936),-- [rp_full_plate_shield]
(20753,8725,1,1,2,3323.757128),-- [general_52_c]
(20753,8735,1,1,2,830.829616),-- [special_52_c]
(20753,8745,1,1,2,82.907496),-- [rare_52_c]
(20753,8755,1,1,2,16.669232),-- [unique_52_c]
(20753,1342,10,30,2,239310.513216),-- [fine_steel_arrow]
(20754,1869,1,9,-1,826759),-- [iron_ore]
(20754,1911,1,1,-1,307460),-- [earing_of_protection_gemstone]
(20754,1967,1,1,-1,225459),-- [plate_leather_gaiters_material]
(20754,57,1634,3323,0,700000),-- [adena]
(20754,94,1,1,1,82.894125),-- [bech_de_corbin]
(20754,2079,1,1,1,6292.105875),-- [bech_de_corbin_blade]
(20754,1869,1,1,2,166508.151876),-- [iron_ore]
(20754,1864,1,3,2,166508.151876),-- [stem]
(20754,1880,1,1,2,16650.739221),-- [steel]
(20754,5550,1,1,2,2220.123885),-- [reinforcing_plate]
(20754,4043,1,1,2,5550.119796),-- [asofe]
(20754,2167,1,1,2,8495.344878),-- [rp_ring_of_ages]
(20754,3009,1,1,2,6796.351869),-- [rp_composite_boots]
(20754,8724,1,1,2,5550.119796),-- [general_49_c]
(20754,8734,1,1,2,1387.529949),-- [special_49_c]
(20754,8744,1,1,2,138.639045),-- [rare_49_c]
(20754,8754,1,1,2,27.727809),-- [unique_49_c]
(20755,2184,1,1,-1,83948),-- [rp_mithril_banded_gaiters]
(20755,1900,1,1,-1,87438),-- [enchanted_necklace_chain]
(20755,1061,1,1,-1,484352),-- [healing_potion]
(20755,57,337,674,0,700000),-- [adena]
(20755,222,1,1,1,176),-- [poniard_dagger]
(20755,1876,1,1,2,10918.05411),-- [mithril_ore]
(20755,1880,1,1,2,5459.148138),-- [steel]
(20755,1877,1,1,2,2183.610822),-- [admantite_nugget]
(20755,1881,1,1,2,7278.783462),-- [coarse_bone_powder]
(20755,1882,1,1,2,12131.30577),-- [leather]
(20755,1829,1,1,2,21836.350386),-- [scroll_of_escape_to_agit]
(20755,2274,1,1,2,389.88726),-- [rp_skull_breaker]
(20755,1341,10,30,2,181968.860052),-- [bone_arrow]
(20756,1932,1,1,-1,123147),-- [bone_helmet_design]
(20756,2262,1,1,-1,12047),-- [rp_elven_bow]
(20756,1899,1,1,-1,121223),-- [necklace_of_devotion_chain]
(20756,57,333,651,0,700000),-- [adena]
(20756,274,1,1,1,276),-- [strengthening_bow]
(20756,1873,1,1,2,34833.58923),-- [silver_nugget]
(20756,1868,1,1,2,174167.94615),-- [thread]
(20756,1876,1,1,2,17416.794615),-- [mithril_ore]
(20756,2152,1,1,2,15331.609997),-- [rp_enchanted_necklace]
(20756,6035,1,1,2,7257.060008),-- [potion_of_acumen2]
(20757,1868,1,3,-1,572349),-- [thread]
(20757,847,1,1,-1,5530),-- [red_cresent_earing]
(20757,2180,1,1,-1,43034),-- [rp_scale_mail]
(20757,57,247,476,0,700000),-- [adena]
(20757,291,1,1,1,101.975412),-- [trident]
(20757,2019,1,1,1,3454.024588),-- [trident_edge]
(20757,1875,1,1,2,3569.092446),-- [stone_of_purity]
(20757,1879,1,1,2,8922.714892),-- [cokes]
(20757,1885,1,1,2,4461.357446),-- [high_grade_suede]
(20757,5550,1,1,2,713.812),-- [reinforcing_plate]
(20757,5549,1,1,2,5353.622446),-- [iron_thread]
(20757,2152,1,1,2,9425.40077),-- [rp_enchanted_necklace]
(20758,2946,1,1,-1,117499),-- [plate_leather_gloves_design]
(20758,2167,1,1,-1,107248),-- [rp_ring_of_ages]
(20758,57,830,1692,0,700000),-- [adena]
(20758,853,1,1,1,206.286364),-- [earing_of_protection]
(20758,1911,1,1,1,11546.5088),-- [earing_of_protection_gemstone]
(20758,916,1,1,1,154.772352),-- [necklace_of_protection]
(20758,1913,1,1,1,9440.115436),-- [necklace_of_protection_gemstone]
(20758,884,1,1,1,309.544704),-- [ring_of_protection]
(20758,1912,1,1,1,16728.772344),-- [ring_of_protection_gemstone]
(20758,1872,1,1,2,124182.965169),-- [animal_bone]
(20758,1867,1,1,2,124182.965169),-- [animal_skin]
(20758,1881,1,1,2,12418.269215),-- [coarse_bone_powder]
(20758,1875,1,1,2,6209.271117),-- [stone_of_purity]
(20758,4041,1,1,2,809.774354),-- [mold_hardener]
(20758,952,1,1,2,1241.963431),-- [scrl_of_ench_am_c]
(20758,8724,1,1,2,3104.499049),-- [general_49_c]
(20758,8734,1,1,2,776.193017),-- [special_49_c]
(20758,8744,1,1,2,77.537396),-- [rare_49_c]
(20758,8754,1,1,2,15.562083),-- [unique_49_c]
(20759,2166,1,1,-1,66974),-- [rp_earing_of_binding]
(20759,1912,1,1,-1,212904),-- [ring_of_protection_gemstone]
(20759,2167,1,1,-1,100803),-- [rp_ring_of_ages]
(20759,57,781,1588,0,700000),-- [adena]
(20759,398,1,1,1,63.804132),-- [plate_leather]
(20759,1966,1,1,1,3994.840755),-- [plate_leather_fragment]
(20759,399,1,1,1,58.836114),-- [rind_leather_mail]
(20759,1975,1,1,1,3593.970972),-- [rind_leather_mail_design]
(20759,418,1,1,1,102.02913),-- [plate_leather_gaiters]
(20759,1967,1,1,1,5967.739242),-- [plate_leather_gaiters_material]
(20759,419,1,1,1,94.207581),-- [rind_leather_gaiters]
(20759,1976,1,1,1,6653.572074),-- [rind_leather_gaiters_material]
(20759,1870,1,1,2,79582.602096),-- [coal]
(20759,1865,1,1,2,79582.602096),-- [varnish]
(20759,1874,1,1,2,5305.542058),-- [oriharukon_ore]
(20759,4043,1,1,2,2652.6829),-- [asofe]
(20759,4039,1,1,2,2652.6829),-- [mold_glue]
(20759,2168,1,1,2,2025.028162),-- [rp_necklace_of_mermaid]
(20759,952,1,1,2,1061.07316),-- [scrl_of_ench_am_c]
(20759,8724,1,1,2,2652.6829),-- [general_49_c]
(20759,8734,1,1,2,663.258854),-- [special_49_c]
(20759,8744,1,1,2,66.273008),-- [rare_49_c]
(20759,8754,1,1,2,13.571866),-- [unique_49_c]
(20760,1911,1,1,-1,152522),-- [earing_of_protection_gemstone]
(20760,951,1,1,-1,3728),-- [scrl_of_ench_wp_c]
(20760,1871,1,5,-1,683553),-- [charcoal]
(20760,57,809,1651,0,700000),-- [adena]
(20760,398,1,1,1,66.225264),-- [plate_leather]
(20760,1966,1,1,1,4146.43026),-- [plate_leather_fragment]
(20760,399,1,1,1,61.068728),-- [rind_leather_mail]
(20760,1975,1,1,1,3730.348944),-- [rind_leather_mail_design]
(20760,418,1,1,1,105.90076),-- [plate_leather_gaiters]
(20760,1967,1,1,1,6194.192984),-- [plate_leather_gaiters_material]
(20760,419,1,1,1,97.782412),-- [rind_leather_gaiters]
(20760,1976,1,1,1,6906.050648),-- [rind_leather_gaiters_material]
(20760,1871,1,1,2,75716.574312),-- [charcoal]
(20760,1866,1,1,2,50477.716208),-- [suede]
(20760,1877,1,1,2,3028.62514),-- [admantite_nugget]
(20760,4041,1,1,2,658.420268),-- [mold_hardener]
(20760,4040,1,1,2,1514.380128),-- [mold_lubricant]
(20760,951,1,1,2,137.683204),-- [scrl_of_ench_wp_c]
(20760,2343,1,1,2,176.056148),-- [rp_mace_of_underworld]
(20760,2327,1,1,2,176.056148),-- [rp_caliburs]
(20760,8724,1,1,2,2523.831764),-- [general_49_c]
(20760,8734,1,1,2,630.99172),-- [special_49_c]
(20760,8744,1,1,2,63.099172),-- [rare_49_c]
(20760,8754,1,1,2,12.565788),-- [unique_49_c]
(20761,1875,1,1,-1,553373),-- [stone_of_purity]
(20761,1874,1,1,-1,553373),-- [oriharukon_ore]
(20761,1807,1,1,-1,11067),-- [rp_soulshot_a]
(20761,57,3285,6671,0,700000),-- [adena]
(20761,5287,1,1,1,22.945393),-- [sealed_dark_crystal_breastplate]
(20761,5520,1,1,1,2635.436141),-- [sealed_dark_crystal_breastplate_pattern]
(20761,5293,1,1,1,14.124871),-- [sealed_tallum_plate_armor]
(20761,5521,1,1,1,1859.668652),-- [sealed_tallum_plate_armor_pattern]
(20761,5288,1,1,1,36.717787),-- [sealed_dark_crystal_gaiters]
(20761,5524,1,1,1,4028.107156),-- [sealed_dark_crystal_gaiters_pattern]
(20761,1868,1,3,2,204322.463928),-- [thread]
(20761,1873,1,1,2,81728.852832),-- [silver_nugget]
(20761,5549,1,1,2,20432.213208),-- [iron_thread]
(20761,1889,1,1,2,13621.364856),-- [compound_braid]
(20761,4044,1,1,2,6810.848352),-- [thons]
(20761,4989,1,1,2,1353.276144),-- [rp_hose_of_doom_i]
(20761,4403,1,1,2,408.504888),-- [red_dimension_stone]
(20761,5338,1,1,2,264.482856),-- [rp_sealed_majestic_leather_mail_i]
(20761,8730,1,1,2,2270.172168),-- [general_67_a]
(20761,8740,1,1,2,567.46008),-- [special_67_a]
(20761,8750,1,1,2,56.746008),-- [rare_67_a]
(20761,8760,1,1,2,11.61468),-- [unique_67_a]
(20762,5478,1,1,-1,49132),-- [sealed_dark_crystal_leather_mail_pattern]
(20762,1807,1,1,-1,7790),-- [rp_soulshot_a]
(20762,57,2311,4698,0,700000),-- [adena]
(20762,5297,1,1,1,21.538242),-- [sealed_dark_crystal_leather_mail]
(20762,5478,1,1,1,2418.616002),-- [sealed_dark_crystal_leather_mail_pattern]
(20762,5301,1,1,1,13.248774),-- [sealed_tallum_leather_mail]
(20762,5479,1,1,1,1701.904446),-- [sealed_tallum_leather_mail_pattern]
(20762,5298,1,1,1,34.443618),-- [sealed_legging_of_dark_crystal]
(20762,5482,1,1,1,3796.248918),-- [sealed_legging_of_dark_crystal_design]
(20762,1872,1,1,2,209195.749232),-- [animal_bone]
(20762,1867,1,1,2,209195.749232),-- [animal_skin]
(20762,1881,1,1,2,20919.665679),-- [coarse_bone_powder]
(20762,1875,1,1,2,10459.60595),-- [stone_of_purity]
(20762,4041,1,1,2,1364.513453),-- [mold_hardener]
(20762,1807,1,1,2,209.192119),-- [rp_soulshot_a]
(20762,5336,1,1,2,202.839213),-- [rp_sealed_leather_mail_of_nightmare_i]
(20762,8730,1,1,2,1743.418918),-- [general_67_a]
(20762,8740,1,1,2,435.62784),-- [special_67_a]
(20762,8750,1,1,2,43.562784),-- [rare_67_a]
(20762,8760,1,1,2,9.07558),-- [unique_67_a]
(20763,1941,1,1,-1,60607),-- [brigandine_temper]
(20763,1873,1,1,-1,609587),-- [silver_nugget]
(20763,1902,1,1,-1,154404),-- [elven_earing_beads]
(20763,57,636,1270,0,700000),-- [adena]
(20763,129,1,1,1,73.3502),-- [sword_of_revolution]
(20763,2034,1,1,1,4161.6498),-- [sword_of_revolution_blade]
(20763,1872,1,1,2,175060.96524),-- [animal_bone]
(20763,1867,1,1,2,175060.96524),-- [animal_skin]
(20763,1881,1,1,2,17506.25298),-- [coarse_bone_powder]
(20763,1875,1,1,2,8752.93092),-- [stone_of_purity]
(20763,2146,1,1,2,9378.36378),-- [rp_artisan's_frame]
(20763,2196,1,1,2,5380.52184),-- [rp_plate_gaiters]
(20764,1902,1,1,-1,137744),-- [elven_earing_beads]
(20764,1825,1,1,-1,97110),-- [rp_oriharukon]
(20764,1903,1,1,-1,226779),-- [elven_ring_piece]
(20764,57,575,1146,0,700000),-- [adena]
(20764,437,1,1,1,204.293711),-- [mithril_tunic]
(20764,1944,1,1,1,8961.584082),-- [mithril_tunic_fabric]
(20764,470,1,1,1,326.265005),-- [mithril_hose]
(20764,1945,1,1,1,13954.857202),-- [mithril_hose_design]
(20764,1872,1,1,2,156172.667152),-- [animal_bone]
(20764,1867,1,1,2,156172.667152),-- [animal_skin]
(20764,1881,1,1,2,15617.337216),-- [coarse_bone_powder]
(20764,1875,1,1,2,7808.668608),-- [stone_of_purity]
(20764,2149,1,1,2,8366.329936),-- [rp_metallic_fiber]
(20764,5473,1,1,2,8366.329936),-- [rp_reinforcing_plate]
(20765,2145,1,1,-1,84024),-- [rp_mithirl_alloy]
(20765,1904,1,1,-1,109784),-- [elven_necklace_beads]
(20765,1873,1,1,-1,470534),-- [silver_nugget]
(20765,57,497,993,0,700000),-- [adena]
(20765,850,1,1,1,281.910384),-- [elven_earing]
(20765,1902,1,1,1,10268.06382),-- [elven_earing_beads]
(20765,913,1,1,1,211.58298),-- [elven_necklace]
(20765,1904,1,1,1,9458.303652),-- [elven_necklace_beads]
(20765,881,1,1,1,423.16596),-- [elven_ring]
(20765,1903,1,1,1,16904.973204),-- [elven_ring_piece]
(20765,1873,1,1,2,40538.354184),-- [silver_nugget]
(20765,1868,1,1,2,202691.77092),-- [thread]
(20765,1876,1,1,2,20269.177092),-- [mithril_ore]
(20765,1895,1,1,2,28955.922669),-- [metallic_fiber]
(20765,2145,1,1,2,7238.902608),-- [rp_mithirl_alloy]
(20765,2158,1,1,2,12542.872527),-- [rp_mithril_ring]
(20766,1869,1,3,-1,525817),-- [iron_ore]
(20766,1901,1,1,-1,145253),-- [tiger'seye_earing_stone]
(20766,2154,1,1,-1,112595),-- [rp_elven_earing]
(20766,57,443,889,0,700000),-- [adena]
(20766,553,1,1,1,408.595324),-- [iron_boots]
(20766,1940,1,1,1,11922.428056),-- [iron_boots_design]
(20766,2422,1,1,1,408.595324),-- [reinforce_leather_boots]
(20766,2423,1,1,1,408.595324),-- [boots_of_knowledge]
(20766,63,1,1,1,408.595324),-- [gauntlet]
(20766,2446,1,1,1,408.595324),-- [reinforce_leather_gloves]
(20766,2447,1,1,1,408.595324),-- [gloves_of_knowledge]
(20766,1864,1,1,2,159755.92243),-- [stem]
(20766,1869,1,1,2,79878.132346),-- [iron_ore]
(20766,1878,1,1,2,31951.184486),-- [braided_hemp]
(20766,1884,1,1,2,49155.66844),-- [cord]
(20766,2155,1,1,2,12821.476782),-- [rp_elven_ring]
(20766,2195,1,1,2,2042.961878),-- [rp_half_plate]
(20766,6035,1,1,2,6656.653638),-- [potion_of_acumen2]
(20767,2076,1,1,-1,15046),-- [body_slasher_blade]
(20767,2220,1,1,-1,39718),-- [rp_rind_leather_mail]
(20767,1879,1,1,-1,319728),-- [cokes]
(20767,57,759,1541,0,700000),-- [adena]
(20767,281,1,1,1,51.42543),-- [crystallized_ice_bow]
(20767,2074,1,1,1,3210.57457),-- [crystallized_ice_bow_shaft]
(20767,1865,1,1,2,75554.064168),-- [varnish]
(20767,1870,1,1,2,75554.064168),-- [coal]
(20767,1879,1,1,2,12592.285266),-- [cokes]
(20767,1875,1,1,2,5037.019878),-- [stone_of_purity]
(20767,4040,1,1,2,1511.123592),-- [mold_lubricant]
(20767,2225,1,1,2,1642.456662),-- [rp_demon's_hose]
(20767,2321,1,1,2,263.194998),-- [rp_stiletto]
(20767,2322,1,1,2,263.194998),-- [rp_dagger_of_magicflame]
(20767,8723,1,1,2,3022.247184),-- [general_46_c]
(20767,8733,1,1,2,755.561796),-- [special_46_c]
(20767,8743,1,1,2,75.626694),-- [rare_46_c]
(20767,8753,1,1,2,15.160596),-- [unique_46_c]
(20768,1908,1,1,-1,174999),-- [moonstone_earing_wire]
(20768,2163,1,1,-1,94285),-- [rp_earing_of_protection]
(20768,1909,1,1,-1,249560),-- [aquastone_ring_wire]
(20768,57,727,1491,0,700000),-- [adena]
(20768,631,1,1,1,285.42048),-- [eldarake]
(20768,1964,1,1,1,11762.156994),-- [eldarake_temper]
(20768,2495,1,1,1,285.42048),-- [chain_shield]
(20768,2945,1,1,1,11762.156994),-- [chain_shield_fragment]
(20768,2413,1,1,1,199.794336),-- [chain_hood]
(20768,2936,1,1,1,10683.050716),-- [chain_hood_pattern]
(20768,1865,1,1,2,72782.4462),-- [varnish]
(20768,1870,1,1,2,72782.4462),-- [coal]
(20768,1879,1,1,2,12130.323912),-- [cokes]
(20768,1875,1,1,2,4852.079292),-- [stone_of_purity]
(20768,2163,1,1,2,3713.400372),-- [rp_earing_of_protection]
(20768,2315,1,1,2,253.626276),-- [rp_shamshir]
(20768,2319,1,1,2,253.626276),-- [rp_raid_sword]
(20768,8723,1,1,2,2911.297848),-- [general_46_c]
(20768,8733,1,1,2,727.950144),-- [special_46_c]
(20768,8743,1,1,2,72.89556),-- [rare_46_c]
(20768,8753,1,1,2,14.579112),-- [unique_46_c]
(20768,1832,1,1,2,80869.328808),-- [advanced_antidote]
(20769,5220,1,1,-1,58852),-- [reinforcing_agent]
(20769,1885,1,1,-1,122609),-- [high_grade_suede]
(20769,4469,1,1,-1,8407),-- [dye_s1c1_d]
(20769,57,582,1182,0,700000),-- [adena]
(20769,70,1,1,1,26.635317),-- [claymore]
(20769,2047,1,1,1,1623.849333),-- [claymore_blade]
(20769,2499,1,1,1,26.635317),-- [elven_long_sword]
(20769,2967,1,1,1,1601.880033),-- [elven_long_sword_blade]
(20769,1866,1,1,2,70364.177896),-- [suede]
(20769,1871,1,1,2,105546.466832),-- [charcoal]
(20769,5220,1,1,2,4221.946668),-- [reinforcing_agent]
(20769,1885,1,1,2,8795.47224),-- [high_grade_suede]
(20769,2161,1,1,2,10247.185132),-- [rp_aquastone_ring]
(20769,5269,1,1,2,351.778892),-- [rp_adv_comp_soulshot_c]
(20769,2297,1,1,2,460.97234),-- [rp_flamberge]
(20770,1905,1,1,-1,167101),-- [onyxbeast'seye_earing_gemstone]
(20770,1805,1,1,-1,5726),-- [rp_soulshot_c]
(20770,1906,1,1,-1,236124),-- [mithril_ring_wire]
(20770,57,696,1393,0,700000),-- [adena]
(20770,159,1,1,1,12.438186),-- [bonebreaker]
(20770,2048,1,1,1,713.154852),-- [bonebreaker_head]
(20770,187,1,1,1,12.438186),-- [atuba_hammer]
(20770,2049,1,1,1,713.154852),-- [atuba_hammer_head]
(20770,188,1,1,1,12.438186),-- [ghost_staff]
(20770,2050,1,1,1,756.174114),-- [ghost_staff_head]
(20770,189,1,1,1,12.438186),-- [life_stick]
(20770,2051,1,1,1,756.174114),-- [life_stick_shaft]
(20770,190,1,1,1,12.438186),-- [atuba_mace]
(20770,2058,1,1,1,713.151138),-- [atuba_mace_head]
(20770,1867,1,1,2,164304.797622),-- [animal_skin]
(20770,1872,1,1,2,164304.797622),-- [animal_bone]
(20770,1882,1,1,2,27384.012378),-- [leather]
(20770,1894,1,1,2,4323.848535),-- [crafted_leather]
(20770,1805,1,1,2,410.865072),-- [rp_soulshot_c]
(20770,2298,1,1,2,538.175376),-- [rp_stormbringer]
(20770,5269,1,1,2,410.503395),-- [rp_adv_comp_soulshot_c]
(20771,1875,1,1,-1,357372),-- [stone_of_purity]
(20771,948,1,1,-1,13401),-- [scrl_of_ench_am_b]
(20771,4042,1,1,-1,89343),-- [enria]
(20771,57,2128,4304,0,700000),-- [adena]
(20771,171,1,1,1,5.230248),-- [deadman's_glory]
(20771,4116,1,1,1,1152.969252),-- [deadman's_glory_stone]
(20771,175,1,1,1,5.230248),-- [art_of_battle_axe]
(20771,4117,1,1,1,1152.969252),-- [art_of_battle_axe_blade]
(20771,210,1,1,1,5.230248),-- [staff_of_evil_sprit]
(20771,4118,1,1,1,1092.370752),-- [staff_of_evil_sprit_head]
(20771,1895,1,1,2,45241.35158),-- [metallic_fiber]
(20771,4040,1,1,2,3166.88589),-- [mold_lubricant]
(20771,4042,1,1,2,2639.10272),-- [enria]
(20771,4043,1,1,2,5278.14315),-- [asofe]
(20771,4953,1,1,2,3050.9642),-- [rp_avadon_gloves_i]
(20771,5276,1,1,2,211.10081),-- [rp_adv_comp_spiritshot_a]
(20771,8729,1,1,2,2111.25726),-- [general_64_a]
(20771,8739,1,1,2,527.84546),-- [special_64_a]
(20771,8749,1,1,2,52.75963),-- [rare_64_a]
(20771,8759,1,1,2,10.5893),-- [unique_64_a]
(20772,1875,1,1,-1,344772),-- [stone_of_purity]
(20772,1986,1,1,-1,54648),-- [full_plate_armor_temper]
(20772,4613,1,1,-1,7133),-- [dye_s4c4_c]
(20772,57,2049,4156,0,700000),-- [adena]
(20772,300,1,1,1,22.864152),-- [great_axe]
(20772,4113,1,1,1,3930.135848),-- [great_axe_head]
(20772,1872,1,1,2,169733.487288),-- [animal_bone]
(20772,1867,1,1,2,169733.487288),-- [animal_skin]
(20772,1881,1,1,2,16973.385864),-- [coarse_bone_powder]
(20772,1875,1,1,2,8486.507256),-- [stone_of_purity]
(20772,4041,1,1,2,1107.000312),-- [mold_hardener]
(20772,4618,1,1,2,175.649496),-- [dye_d4c4_c]
(20772,4999,1,1,2,1583.444928),-- [rp_doom_boots_i]
(20772,4163,1,1,2,842.96904),-- [rp_blue_wolve's_hose]
(20772,8728,1,1,2,2121.533976),-- [general_61_b]
(20772,8738,1,1,2,530.290656),-- [special_61_b]
(20772,8748,1,1,2,53.103336),-- [rare_61_b]
(20772,8758,1,1,2,11.14056),-- [unique_61_b]
(20773,5478,1,1,-1,29805),-- [sealed_dark_crystal_leather_mail_pattern]
(20773,1807,1,1,-1,4726),-- [rp_soulshot_a]
(20773,5479,1,1,-1,20973),-- [sealed_tallum_leather_mail_pattern]
(20773,57,1748,3569,0,700000),-- [adena]
(20773,6324,1,1,1,43.406603),-- [sealed_phoenix's_earing]
(20773,6341,1,1,1,6032.61631),-- [sealed_phoenix's_earing_gemstone]
(20773,6323,1,1,1,32.550157),-- [sealed_phoenix's_necklace]
(20773,6343,1,1,1,4663.438168),-- [sealed_phoenix's_necklace_beads]
(20773,6325,1,1,1,65.100314),-- [sealed_phoenix's_ring]
(20773,6345,1,1,1,8343.888448),-- [sealed_phoenix's_ring_gemstone]
(20773,1868,1,1,2,237949.17195),-- [thread]
(20773,1873,1,1,2,47589.83439),-- [silver_nugget]
(20773,5549,1,1,2,11897.302739),-- [iron_thread]
(20773,1889,1,1,2,7931.639065),-- [compound_braid]
(20773,4044,1,1,2,3965.663674),-- [thons]
(20773,4157,1,1,2,591.950583),-- [rp_blue_wolve's_gaiters]
(20773,730,1,1,2,99.126006),-- [scrl_of_ench_am_a]
(20773,8730,1,1,2,1321.991797),-- [general_67_a]
(20773,8740,1,1,2,330.42002),-- [special_67_a]
(20773,8750,1,1,2,33.042002),-- [rare_67_a]
(20773,8760,1,1,2,6.857774),-- [unique_67_a]
(20774,1807,1,1,-1,6216),-- [rp_soulshot_a]
(20774,5478,1,1,-1,39204),-- [sealed_dark_crystal_leather_mail_pattern]
(20774,1889,1,1,-1,310807),-- [compound_braid]
(20774,57,1844,3751,0,700000),-- [adena]
(20774,5291,1,1,1,38.682273),-- [sealed_dark_crystal_boots]
(20774,5496,1,1,1,4036.567727),-- [sealed_dark_crystal_boots_lining]
(20774,5296,1,1,1,38.682273),-- [sealed_tallum_boots]
(20774,5497,1,1,1,4036.567727),-- [sealed_tallum_boots_lining]
(20774,5290,1,1,1,38.682273),-- [sealed_dark_crystal_gloves]
(20774,5508,1,1,1,4036.567727),-- [sealed_dark_crystal_gloves_design]
(20774,5295,1,1,1,38.682273),-- [sealed_tallum_gloves]
(20774,5509,1,1,1,4036.567727),-- [sealed_tallum_gloves_design]
(20774,1873,1,1,2,55084.610222),-- [silver_nugget]
(20774,1868,1,1,2,275423.452944),-- [thread]
(20774,1876,1,1,2,27542.506028),-- [mithril_ore]
(20774,1895,1,1,2,39346.379778),-- [metallic_fiber]
(20774,4042,1,1,2,2295.275808),-- [enria]
(20774,5271,1,1,2,183.638138),-- [rp_adv_comp_soulshot_a]
(20774,8730,1,1,2,1530.183872),-- [general_67_a]
(20774,8740,1,1,2,382.545968),-- [special_67_a]
(20774,8750,1,1,2,38.17423),-- [rare_67_a]
(20774,8760,1,1,2,7.233012),-- [unique_67_a]
(20775,2253,1,1,-1,9985),-- [rp_sword_breaker]
(20775,1897,1,1,-1,58010),-- [necklace_of_wisdom_chain]
(20775,1800,1,1,-1,76617),-- [rp_piece_bone_breastplate]
(20775,57,119,191,0,700000),-- [adena]
(20775,15,1,1,1,137.091519),-- [short_spear]
(20775,2011,1,1,1,1641.908481),-- [short_spear_edge]
(20775,1873,1,1,2,19191.51927),-- [silver_nugget]
(20775,1868,1,1,2,95957.721095),-- [thread]
(20775,2144,1,1,2,9595.759635),-- [rp_compound_braid]
(20776,1865,1,1,-1,297237),-- [varnish]
(20776,1866,1,1,-1,198158),-- [suede]
(20776,1897,1,1,-1,70771),-- [necklace_of_wisdom_chain]
(20776,57,137,239,0,700000),-- [adena]
(20776,1101,1,1,1,1125.650223),-- [tunic_of_devotion]
(20776,1104,1,1,1,1797.349777),-- [hose_of_devotion]
(20776,1869,1,1,2,19510.9902),-- [iron_ore]
(20776,1870,1,1,2,19510.9902),-- [coal]
(20776,1871,1,1,2,19510.9902),-- [charcoal]
(20776,1872,1,1,2,26014.6536),-- [animal_bone]
(20776,1867,1,1,2,26014.6536),-- [animal_skin]
(20776,2140,1,1,2,3902.2656),-- [rp_high_grade_suede]
(20776,5158,1,1,2,780.4869),-- [rp_comp_spiritshot_d]
(20776,735,1,1,2,1625.8314),-- [swift_attack_potion]
(20776,1831,1,1,2,52029.1383),-- [antidote]
(20777,1831,1,1,-1,594351),-- [antidote]
(20777,1896,1,1,-1,94441),-- [necklace_of_anguish_chain]
(20777,1792,1,1,-1,16388),-- [rp_short_spear]
(20777,57,114,168,0,700000),-- [adena]
(20777,37,1,1,1,4303.043343),-- [leather_shoes]
(20777,1921,1,1,1,28316.876391),-- [leather_shoes_texture]
(20777,49,1,1,1,4303.080266),-- [gloves]
(20777,1868,1,1,2,87781.424965),-- [thread]
(20777,1873,1,1,2,17556.26328),-- [silver_nugget]
(20777,1794,1,1,2,3227.311755),-- [rp_bow_of_forest]
(20778,2290,1,1,-1,5412),-- [rp_mithril_dagger]
(20778,1903,1,1,-1,162485),-- [elven_ring_piece]
(20778,1902,1,1,-1,98693),-- [elven_earing_beads]
(20778,57,412,821,0,700000),-- [adena]
(20778,352,1,1,1,73.069944),-- [brigandine]
(20778,1941,1,1,1,3337.400322),-- [brigandine_temper]
(20778,2377,1,1,1,116.881986),-- [mithril_scale_gaiters]
(20778,2918,1,1,1,4978.889682),-- [mithril_scale_gaiters_material]
(20778,2378,1,1,1,116.881986),-- [brigandine_gaiters]
(20778,2919,1,1,1,4978.87608),-- [brigandine_gaiters_material]
(20778,1871,1,1,2,83922.320522),-- [charcoal]
(20778,1866,1,1,2,55948.264595),-- [suede]
(20778,1877,1,1,2,3356.941698),-- [admantite_nugget]
(20778,2289,1,1,2,466.165532),-- [rp_life_stick]
(20778,2288,1,1,2,466.165532),-- [rp_ghost_staff]
(20778,2202,1,1,2,8581.142121),-- [rp_assault_boots]
(20779,2158,1,1,-1,107640),-- [rp_mithril_ring]
(20779,1904,1,1,-1,81170),-- [elven_necklace_beads]
(20779,1866,1,1,-1,579821),-- [suede]
(20779,57,368,733,0,700000),-- [adena]
(20779,318,1,1,1,41.858726),-- [crucifix_of_blood]
(20779,2042,1,1,1,2077.141274),-- [crucifix_of_blood_piece]
(20779,1871,1,1,2,89916.679179),-- [charcoal]
(20779,1866,1,1,2,59944.452786),-- [suede]
(20779,1877,1,1,2,3596.685702),-- [admantite_nugget]
(20779,2290,1,1,2,499.513938),-- [rp_mithril_dagger]
(20779,2286,1,1,2,499.668395),-- [rp_bonebreaker]
(20780,2980,1,1,-1,95429),-- [rp_brigandine_gauntlet]
(20780,1901,1,1,-1,98461),-- [tiger'seye_earing_stone]
(20780,1877,1,1,-1,28514),-- [admantite_nugget]
(20780,57,301,601,0,700000),-- [adena]
(20780,157,1,1,1,33.984452),-- [spike_club]
(20780,2027,1,1,1,1655.031096),-- [spike_club_head]
(20780,186,1,1,1,33.984452),-- [staff_of_magicpower]
(20780,1871,1,1,2,94755.45226),-- [charcoal]
(20780,1866,1,1,2,63170.246545),-- [suede]
(20780,1877,1,1,2,3790.211495),-- [admantite_nugget]
(20780,2186,1,1,2,3169.0897),-- [rp_brigandine]
(20781,2192,1,1,-1,90034),-- [rp_kite_shield]
(20781,1938,1,1,-1,47453),-- [mithril_banded_mail_material]
(20781,1901,1,1,-1,97496),-- [tiger'seye_earing_stone]
(20781,57,298,595,0,700000),-- [adena]
(20781,436,1,1,1,320.586714),-- [tunic_of_knowledge]
(20781,469,1,1,1,512.413286),-- [hose_of_knowledge]
(20781,1875,1,1,2,3127.529982),-- [stone_of_purity]
(20781,1879,1,1,2,7818.876878),-- [cokes]
(20781,1885,1,1,2,3909.438439),-- [high_grade_suede]
(20781,5550,1,1,2,625.516381),-- [reinforcing_plate]
(20781,5549,1,1,2,4691.346896),-- [iron_thread]
(20781,2187,1,1,2,2094.366128),-- [rp_manticor_skin_shirt]
(20781,2273,1,1,2,335.111042),-- [rp_tarbar]
(20781,6667,1,1,2,29320.814254),-- [key_of_treasure_box3]
(20782,1801,1,1,-1,126448),-- [rp_piece_bone_gaiters]
(20782,1924,1,1,-1,80968),-- [leather_helmet_design]
(20782,1800,1,1,-1,78931),-- [rp_piece_bone_breastplate]
(20782,57,122,197,0,700000),-- [adena]
(20782,256,1,1,1,282),-- [cestus]
(20782,1872,1,1,2,49427.50289),-- [animal_bone]
(20782,1867,1,1,2,49427.50289),-- [animal_skin]
(20782,2150,1,1,2,17404.03373),-- [rp_blue_diamond_necklace]
(20782,5268,1,1,2,1482.96049),-- [rp_adv_comp_soulshot_d]
(20783,2203,1,1,-1,70587),-- [rp_mithril_boots]
(20783,1935,1,1,-1,18100),-- [scale_mail_fragment]
(20783,1900,1,1,-1,35448),-- [enchanted_necklace_chain]
(20783,57,137,273,0,700000),-- [adena]
(20783,316,1,1,1,15.435576),-- [blood_of_saints]
(20783,317,1,1,1,15.435576),-- [tome_of_blood]
(20783,2030,1,1,1,671.128848),-- [tome_of_blood_page]
(20783,1874,1,1,2,1435.544052),-- [oriharukon_ore]
(20783,1878,1,1,2,8613.23233),-- [braided_hemp]
(20783,1884,1,1,2,13251.10206),-- [cord]
(20783,1889,1,1,2,1435.544052),-- [compound_braid]
(20783,5220,1,1,2,861.307242),-- [reinforcing_agent]
(20783,2153,1,1,2,3348.83522),-- [rp_tiger'seye_earing]
(20783,2977,1,1,2,2882.601624),-- [rp_brigandine_boots]
(20783,8307,1,1,2,153.83342),-- [rp_mace_of_priest]
(20784,2021,1,1,-1,4623),-- [spinebone_sword_blade]
(20784,2184,1,1,-1,38461),-- [rp_mithril_banded_gaiters]
(20784,2153,1,1,-1,56945),-- [rp_tiger'seye_earing]
(20784,57,154,309,0,700000),-- [adena]
(20784,83,1,1,1,11.7744),-- [sword_of_magic]
(20784,144,1,1,1,11.7744),-- [sword_of_occult]
(20784,124,1,1,1,8.72256),-- [two-handed_sword]
(20784,2026,1,1,1,390.28308),-- [two-handed_sword_edge]
(20784,127,1,1,1,8.72256),-- [crimson_sword]
(20784,130,1,1,1,8.723),-- [elven_sword]
(20784,1875,1,1,2,2163.132496),-- [stone_of_purity]
(20784,1879,1,1,2,5407.842272),-- [cokes]
(20784,1885,1,1,2,2703.921136),-- [high_grade_suede]
(20784,5550,1,1,2,432.630912),-- [reinforcing_plate]
(20784,5549,1,1,2,3244.709776),-- [iron_thread]
(20784,2250,1,1,2,8111.763408),-- [rp_bone_arrow]
(20785,2022,1,1,-1,5500),-- [mace_of_judgment_head]
(20785,1933,1,1,-1,41540),-- [dark_hose_fabric]
(20785,1875,1,1,-1,23539),-- [stone_of_purity]
(20785,57,149,298,0,700000),-- [adena]
(20785,1124,1,1,1,39.7463),-- [boots_of_power]
(20785,1948,1,1,1,1541.5037),-- [boots_of_power_pattern]
(20785,2424,1,1,1,39.7463),-- [manticor_skin_boots]
(20785,2923,1,1,1,1541.5037),-- [manticor_skin_boots_lining]
(20785,2425,1,1,1,39.7463),-- [brigandine_boots]
(20785,2924,1,1,1,1541.5037),-- [brigandine_boots_design]
(20785,2426,1,1,1,39.7463),-- [elven_mithril_boots]
(20785,2925,1,1,1,1541.5037),-- [elven_mithril_boots_design]
(20785,606,1,1,1,39.7463),-- [gauntlet_of_repose_of_the_soul]
(20785,1946,1,1,1,1541.5037),-- [gauntlet_of_repose_of_the_soul_pattern]
(20785,2448,1,1,1,39.7463),-- [manticor_skin_gloves]
(20785,2926,1,1,1,1541.5037),-- [manticor_skin_gloves_linging]
(20785,2449,1,1,1,39.7463),-- [brigandine_gauntlet]
(20785,2927,1,1,1,1541.5037),-- [brigandine_gauntlet_pattern]
(20785,2450,1,1,1,39.7463),-- [elven_mithril_gloves]
(20785,2928,1,1,1,1541.5037),-- [elven_mithril_gloves_design]
(20785,1875,1,1,2,1352.00395),-- [stone_of_purity]
(20785,1879,1,1,2,3380.009875),-- [cokes]
(20785,1885,1,1,2,1690.052725),-- [high_grade_suede]
(20785,5550,1,1,2,270.381675),-- [reinforcing_plate]
(20785,5549,1,1,2,2028.005925),-- [iron_thread]
(20785,2185,1,1,2,3992.16775),-- [rp_iron_boots]
(20785,2982,1,1,2,2586.737375),-- [rp_brigandine_shield]
(20785,6667,1,1,2,12675.060925),-- [key_of_treasure_box3]
(20785,1341,10,30,2,67600.5798),-- [bone_arrow]
(20786,2026,1,1,-1,4711),-- [two-handed_sword_edge]
(20786,2155,1,1,-1,62822),-- [rp_elven_ring]
(20786,5550,1,1,-1,5218),-- [reinforcing_plate]
(20786,57,166,330,0,700000),-- [adena]
(20786,395,1,1,1,58.81275),-- [manticor_skin_shirt]
(20786,1942,1,1,1,2579.8905),-- [manticor_skin_shirt_texture]
(20786,417,1,1,1,93.92625),-- [manticor_skin_gaiters]
(20786,1943,1,1,1,4017.3705),-- [manticor_skin_gaiters_pattern]
(20786,1875,1,1,2,1685.957287),-- [stone_of_purity]
(20786,1879,1,1,2,4214.885927),-- [cokes]
(20786,1885,1,1,2,2107.450254),-- [high_grade_suede]
(20786,5550,1,1,2,337.185625),-- [reinforcing_plate]
(20786,5549,1,1,2,2528.92864),-- [iron_thread]
(20786,2278,1,1,2,180.644009),-- [rp_strengthening_long_bow]
(20786,2286,1,1,2,140.502516),-- [rp_bonebreaker]
(20786,2977,1,1,2,3385.445742),-- [rp_brigandine_boots]
(20787,1870,1,1,-1,476736),-- [coal]
(20787,2029,1,1,-1,5687),-- [gastraphetes_shaft]
(20787,5549,1,1,-1,47674),-- [iron_thread]
(20787,57,199,397,0,700000),-- [adena]
(20787,850,1,1,1,114.249236),-- [elven_earing]
(20787,1902,1,1,1,4161.316905),-- [elven_earing_beads]
(20787,913,1,1,1,85.747795),-- [elven_necklace]
(20787,1904,1,1,1,3833.147083),-- [elven_necklace_beads]
(20787,881,1,1,1,171.49559),-- [elven_ring]
(20787,1903,1,1,1,6851.043391),-- [elven_ring_piece]
(20787,1875,1,1,2,1825.447782),-- [stone_of_purity]
(20787,1879,1,1,2,4563.688148),-- [cokes]
(20787,1885,1,1,2,2281.844074),-- [high_grade_suede]
(20787,5550,1,1,2,365.034602),-- [reinforcing_plate]
(20787,5549,1,1,2,2738.240366),-- [iron_thread]
(20787,2188,1,1,2,1955.827096),-- [rp_manticor_skin_gaiters]
(20787,5473,1,1,2,1955.827096),-- [rp_reinforcing_plate]
(20787,1832,1,1,2,30424.954016),-- [advanced_antidote]
(20787,1341,10,30,2,91275.13682),-- [bone_arrow]
(20788,2186,1,1,-1,28093),-- [rp_brigandine]
(20788,1901,1,1,-1,116020),-- [tiger'seye_earing_stone]
(20788,57,355,708,0,700000),-- [adena]
(20788,260,1,1,1,120),-- [triple-edged_jamadhr]
(20788,1874,1,1,2,3721.759626),-- [oriharukon_ore]
(20788,1878,1,1,2,22330.557756),-- [braided_hemp]
(20788,1884,1,1,2,34354.730995),-- [cord]
(20788,1889,1,1,2,3721.759626),-- [compound_braid]
(20788,5220,1,1,2,2233.041863),-- [reinforcing_agent]
(20788,2189,1,1,2,2492.233601),-- [rp_mithril_tunic]
(20788,2293,1,1,2,310.181417),-- [rp_glaive]
(20788,2275,1,1,2,398.735116),-- [rp_heavy_bone_club]
(20789,2030,1,1,-1,9246),-- [tome_of_blood_page]
(20789,2188,1,1,-1,56469),-- [rp_manticor_skin_gaiters]
(20789,2154,1,1,-1,84644),-- [rp_elven_earing]
(20789,57,333,668,0,700000),-- [adena]
(20789,393,1,1,1,119.754095),-- [mithril_banded_mail]
(20789,1938,1,1,1,4709.504645),-- [mithril_banded_mail_material]
(20789,394,1,1,1,119.754095),-- [reinforce_leather_shirt]
(20789,415,1,1,1,191.40901),-- [mithril_banded_gaiters]
(20789,1939,1,1,1,6153.18063),-- [mithril_banded_gaiters_material]
(20789,416,1,1,1,191.397525),-- [reinforce_leather_gaiters]
(20789,1874,1,1,2,3502.836657),-- [oriharukon_ore]
(20789,1878,1,1,2,21016.771461),-- [braided_hemp]
(20789,1884,1,1,2,32333.590125),-- [cord]
(20789,1889,1,1,2,3502.836657),-- [compound_braid]
(20789,5220,1,1,2,2101.652298),-- [reinforcing_agent]
(20789,2275,1,1,2,375.20631),-- [rp_heavy_bone_club]
(20789,1661,1,1,2,10508.509971),-- [key_of_thief]
(20789,1341,10,30,2,175139.596521),-- [bone_arrow]
(20790,2039,1,1,-1,10243),-- [bich'hwa_edge]
(20790,1868,1,5,-1,674568),-- [thread]
(20790,1902,1,1,-1,102518),-- [elven_earing_beads]
(20790,57,428,853,0,700000),-- [adena]
(20790,224,1,1,1,24.35192),-- [maingauche]
(20790,2038,1,1,1,1381.64808),-- [maingauche_edge]
(20790,1660,1,1,1,24.35192),-- [cursed_maingauche]
(20790,2044,1,1,1,1381.64808),-- [cursed_maingauche_edge]
(20790,1874,1,1,2,3486.998377),-- [oriharukon_ore]
(20790,1878,1,1,2,20921.154519),-- [braided_hemp]
(20790,1884,1,1,2,32186.412997),-- [cord]
(20790,1889,1,1,2,3486.998377),-- [compound_braid]
(20790,5220,1,1,2,2092.14331),-- [reinforcing_agent]
(20790,2147,1,1,2,3736.049791),-- [rp_blacksmith's_frame]
(20790,2984,1,1,2,5347.919457),-- [rp_slamander_skin_boots]
(20790,2289,1,1,2,290.559983),-- [rp_life_stick]
(20790,6667,1,1,2,32689.530283),-- [key_of_treasure_box3]
(20790,1341,10,30,2,174343.232906),-- [bone_arrow]
(20791,2196,1,1,-1,71256),-- [rp_plate_gaiters]
(20791,2041,1,1,-1,19395),-- [hammer_in_flames_head]
(20791,1825,1,1,-1,124190),-- [rp_oriharukon]
(20791,57,735,1467,0,700000),-- [adena]
(20791,352,1,1,1,130.421416),-- [brigandine]
(20791,1941,1,1,1,5956.874358),-- [brigandine_temper]
(20791,2377,1,1,1,208.620854),-- [mithril_scale_gaiters]
(20791,2918,1,1,1,8886.743398),-- [mithril_scale_gaiters_material]
(20791,2378,1,1,1,208.620854),-- [brigandine_gaiters]
(20791,2919,1,1,1,8886.71912),-- [brigandine_gaiters_material]
(20791,1876,1,1,2,25678.72309),-- [mithril_ore]
(20791,1880,1,1,2,12839.4079),-- [steel]
(20791,1877,1,1,2,5135.76316),-- [admantite_nugget]
(20791,1881,1,1,2,17119.17963),-- [coarse_bone_powder]
(20791,1882,1,1,2,28531.96605),-- [leather]
(20791,2198,1,1,2,2691.64943),-- [rp_sage's_rag]
(20791,3020,1,1,2,713.31074),-- [rp_elven_long_sword]
(20792,2035,1,1,-1,16376),-- [tarbar_head]
(20792,2202,1,1,-1,165409),-- [rp_assault_boots]
(20792,1903,1,1,-1,269842),-- [elven_ring_piece]
(20792,57,684,1363,0,700000),-- [adena]
(20792,88,1,1,1,15.571536),-- [morning_star]
(20792,2031,1,1,1,846.382452),-- [morning_star_head]
(20792,90,1,1,1,15.571536),-- [goathead_staff]
(20792,2032,1,1,1,772.62522),-- [goathead_staff_head]
(20792,158,1,1,1,15.571536),-- [tarbar]
(20792,2035,1,1,1,846.382452),-- [tarbar_head]
(20792,169,1,1,1,15.571536),-- [skull_breaker]
(20792,2036,1,1,1,846.382452),-- [skull_breaker_head]
(20792,172,1,1,1,15.571536),-- [heavy_bone_club]
(20792,2037,1,1,1,846.369744),-- [heavy_bone_club_head]
(20792,1876,1,1,2,23892.20854),-- [mithril_ore]
(20792,1880,1,1,2,11946.1474),-- [steel]
(20792,1877,1,1,2,4778.45896),-- [admantite_nugget]
(20792,1881,1,1,2,15928.16778),-- [coarse_bone_powder]
(20792,1882,1,1,2,26546.9463),-- [leather]
(20792,2198,1,1,2,2504.38658),-- [rp_sage's_rag]
(20792,3020,1,1,2,663.68444),-- [rp_elven_long_sword]
(20793,2037,1,1,-1,17953),-- [heavy_bone_club_head]
(20793,1877,1,1,-1,70938),-- [admantite_nugget]
(20793,1881,1,1,-1,236461),-- [coarse_bone_powder]
(20793,57,740,1478,0,700000),-- [adena]
(20793,93,1,1,1,42.67558),-- [winged_spear]
(20793,2033,1,1,1,2556.32442),-- [winged_spear_blade]
(20793,294,1,1,1,42.67558),-- [hammer_in_flames]
(20793,2041,1,1,1,2556.32442),-- [hammer_in_flames_head]
(20793,1876,1,1,2,22918.530082),-- [mithril_ore]
(20793,1880,1,1,2,11459.501788),-- [steel]
(20793,1877,1,1,2,4583.895414),-- [admantite_nugget]
(20793,1881,1,1,2,15279.177886),-- [coarse_bone_powder]
(20793,1882,1,1,2,25464.980814),-- [leather]
(20793,2147,1,1,2,8185.290778),-- [rp_blacksmith's_frame]
(20793,2205,1,1,2,3626.490546),-- [rp_chain_gaiters]
(20793,1341,10,30,2,381976.132692),-- [bone_arrow]
(20794,2991,1,1,-1,132768),-- [rp_karmian_boots]
(20794,1952,1,1,-1,53584),-- [slamander_skin_mail_texture]
(20794,1866,1,3,-1,557627),-- [suede]
(20794,57,678,1356,0,700000),-- [adena]
(20794,225,1,1,1,60.562565),-- [mithril_dagger]
(20794,2052,1,1,1,3642.437435),-- [mithril_dagger_blade]
(20794,1866,1,1,2,80004.198474),-- [suede]
(20794,1871,1,1,2,120006.40714),-- [charcoal]
(20794,5220,1,1,2,4800.212514),-- [reinforcing_agent]
(20794,1885,1,1,2,10000.497452),-- [high_grade_suede]
(20794,2206,1,1,2,3166.437544),-- [rp_tempered_mithril_shirt]
(20794,4556,1,1,2,479.955594),-- [dye_c1c1_c]
(20794,5274,1,1,2,400.291282),-- [rp_adv_comp_spiritshot_c]
(20795,2161,1,1,-1,153276),-- [rp_aquastone_ring]
(20795,2047,1,1,-1,13879),-- [claymore_blade]
(20795,4469,1,1,-1,9021),-- [dye_s1c1_d]
(20795,57,636,1285,0,700000),-- [adena]
(20795,851,1,1,1,283.234762),-- [onyxbeast'seye_earing]
(20795,1905,1,1,1,12852.656394),-- [onyxbeast'seye_earing_gemstone]
(20795,914,1,1,1,212.41579),-- [necklace_of_darkness]
(20795,1907,1,1,1,9191.331992),-- [necklace_of_darkness_gem]
(20795,882,1,1,1,424.83158),-- [mithril_ring]
(20795,1906,1,1,1,18161.529482),-- [mithril_ring_wire]
(20795,1867,1,1,2,151004.48972),-- [animal_skin]
(20795,1872,1,1,2,151004.48972),-- [animal_bone]
(20795,1882,1,1,2,25167.544542),-- [leather]
(20795,1894,1,1,2,3973.966052),-- [crafted_leather]
(20795,2304,1,1,2,494.510352),-- [rp_heavy_doom_hammer]
(20795,736,1,1,2,56626.878028),-- [scroll_of_escape]
(20795,2303,1,1,2,494.121586),-- [rp_skull_graver]
(20796,2199,1,1,-1,71642),-- [rp_karmian_hose]
(20796,2930,1,1,-1,136873),-- [plate_helmet_design]
(20796,1905,1,1,-1,165167),-- [onyxbeast'seye_earing_gemstone]
(20796,57,671,1364,0,700000),-- [adena]
(20796,396,1,1,1,232.565589),-- [slamander_skin_mail]
(20796,1952,1,1,1,13654.434411),-- [slamander_skin_mail_texture]
(20796,1868,1,1,2,170522.522904),-- [thread]
(20796,1873,1,1,2,34104.451554),-- [silver_nugget]
(20796,5549,1,1,2,8526.179172),-- [iron_thread]
(20796,1889,1,1,2,5684.207826),-- [compound_braid]
(20796,2998,1,1,2,6410.674986),-- [rp_chain_shield]
(20796,737,1,1,2,8526.179172),-- [scroll_of_resurrection]
(20796,4557,1,1,2,340.962324),-- [dye_d1s1_c]
(20796,3033,1,1,2,284.223648),-- [rp_spiritshot_c]
(20796,3954,1,1,2,284.223648),-- [rp_blessed_spiritshot_c]
(20796,6668,1,1,2,30450.374766),-- [key_of_treasure_box4]
(20797,4440,1,1,-1,8981),-- [rp_knuckle_dust]
(20797,1908,1,1,-1,244093),-- [moonstone_earing_wire]
(20797,2163,1,1,-1,131511),-- [rp_earing_of_protection]
(20797,57,1015,2079,0,700000),-- [adena]
(20797,397,1,1,1,209.313728),-- [tempered_mithril_shirt]
(20797,1961,1,1,1,9746.249906),-- [tempered_mithril_shirt_fabric]
(20797,2387,1,1,1,334.520624),-- [tempered_mithril_gaiters]
(20797,2935,1,1,1,16191.915742),-- [tempered_mithril_gaiters_fragment]
(20797,1869,1,1,2,110747.736582),-- [iron_ore]
(20797,1864,1,1,2,221495.473164),-- [stem]
(20797,1880,1,1,2,11074.702548),-- [steel]
(20797,5550,1,1,2,1476.603303),-- [reinforcing_plate]
(20797,2220,1,1,2,2292.948399),-- [rp_rind_leather_mail]
(20797,2225,1,1,2,2407.435821),-- [rp_demon's_hose]
(20797,2321,1,1,2,385.772835),-- [rp_stiletto]
(20797,8723,1,1,2,4429.809909),-- [general_46_c]
(20797,8733,1,1,2,1107.541365),-- [special_46_c]
(20797,8743,1,1,2,110.576361),-- [rare_46_c]
(20797,8753,1,1,2,22.399713),-- [unique_46_c]
(20798,4042,1,1,-1,34793),-- [enria]
(20798,4043,1,1,-1,69587),-- [asofe]
(20798,1908,1,1,-1,197690),-- [moonstone_earing_wire]
(20798,57,826,1677,0,700000),-- [adena]
(20798,71,1,1,1,27.97965),-- [flamberge]
(20798,2059,1,1,1,1831.857492),-- [flamberge_blade]
(20798,72,1,1,1,27.97965),-- [stormbringer]
(20798,2060,1,1,1,1958.183208),-- [stormbringer_blade]
(20798,1869,1,1,2,89694.045238),-- [iron_ore]
(20798,1864,1,1,2,179388.090476),-- [stem]
(20798,1880,1,1,2,8969.346932),-- [steel]
(20798,5550,1,1,2,1195.893727),-- [reinforcing_plate]
(20798,2220,1,1,2,1857.047591),-- [rp_rind_leather_mail]
(20798,2225,1,1,2,1949.770389),-- [rp_demon's_hose]
(20798,2321,1,1,2,312.435515),-- [rp_stiletto]
(20798,8723,1,1,2,3587.681181),-- [general_46_c]
(20798,8733,1,1,2,896.992285),-- [special_46_c]
(20798,8743,1,1,2,89.555249),-- [rare_46_c]
(20798,8753,1,1,2,18.141417),-- [unique_46_c]
(20799,2317,1,1,-1,7323),-- [rp_bech_de_corbin]
(20799,2065,1,1,-1,16244),-- [skull_graver_head]
(20799,2164,1,1,-1,161662),-- [rp_ring_of_protection]
(20799,57,828,1693,0,700000),-- [adena]
(20799,354,1,1,1,127.798696),-- [chain_mail_shirt]
(20799,1959,1,1,1,6688.228012),-- [chain_mail_shirt_material]
(20799,381,1,1,1,204.444912),-- [chain_gaiters]
(20799,1960,1,1,1,13605.52838),-- [chain_gaiters_part]
(20799,1871,1,1,2,90295.964824),-- [charcoal]
(20799,1866,1,1,2,60197.364344),-- [suede]
(20799,1877,1,1,2,3611.766704),-- [admantite_nugget]
(20799,4041,1,1,2,785.223504),-- [mold_hardener]
(20799,4040,1,1,2,1805.883352),-- [mold_lubricant]
(20799,2230,1,1,2,1749.84264),-- [rp_theca_leather_gaiters]
(20799,2326,1,1,2,314.677584),-- [rp_horn_of_glory]
(20799,8723,1,1,2,3611.766704),-- [general_46_c]
(20799,8733,1,1,2,903.023368),-- [special_46_c]
(20799,8743,1,1,2,90.351352),-- [rare_46_c]
(20799,8753,1,1,2,18.135624),-- [unique_46_c]
(20800,2223,1,1,-1,76282),-- [rp_tower_shield]
(20800,1966,1,1,-1,71854),-- [plate_leather_fragment]
(20800,1911,1,1,-1,146379),-- [earing_of_protection_gemstone]
(20800,57,777,1585,0,700000),-- [adena]
(20800,355,1,1,1,87.99518),-- [dwarven_chain_mail_shirt]
(20800,1968,1,1,1,5253.18792),-- [dwarven_chain_mail_shirt_material]
(20800,382,1,1,1,140.792288),-- [dwarven_chain_gaiters]
(20800,1969,1,1,1,8332.024612),-- [dwarven_chain_gaiters_material]
(20800,1872,1,1,2,105697.749824),-- [animal_bone]
(20800,1867,1,1,2,105697.749824),-- [animal_skin]
(20800,1881,1,1,2,10569.728034),-- [coarse_bone_powder]
(20800,1875,1,1,2,5284.981388),-- [stone_of_purity]
(20800,4041,1,1,2,689.437254),-- [mold_hardener]
(20800,2226,1,1,2,3235.683728),-- [rp_mithril_gauntlet]
(20800,2333,1,1,2,184.27247),-- [rp_sword_of_nightmare]
(20800,8724,1,1,2,2642.490694),-- [general_49_c]
(20800,8734,1,1,2,660.563988),-- [special_49_c]
(20800,8744,1,1,2,65.962502),-- [rare_49_c]
(20800,8754,1,1,2,13.380294),-- [unique_49_c]
(20801,2946,1,1,-1,132781),-- [plate_leather_gloves_design]
(20801,2330,1,1,-1,5524),-- [rp_homunkulus's_sword]
(20801,951,1,1,-1,4319),-- [scrl_of_ench_wp_c]
(20801,57,939,1909,0,700000),-- [adena]
(20801,4233,1,1,1,47.634132),-- [knuckle_dust]
(20801,4438,1,1,1,3753.365868),-- [knuckle_dust_edge]
(20801,1873,1,1,2,30071.557296),-- [silver_nugget]
(20801,1868,1,1,2,150357.519144),-- [thread]
(20801,1876,1,1,2,15035.778648),-- [mithril_ore]
(20801,1895,1,1,2,21479.645592),-- [metallic_fiber]
(20801,4042,1,1,2,1253.003832),-- [enria]
(20801,2347,1,1,2,174.837744),-- [rp_akat_long_bow]
(20801,2351,1,1,2,157.193568),-- [rp_scorpion]
(20801,3010,1,1,2,2042.981712),-- [rp_composite_helmet]
(20801,6668,1,1,2,26849.623824),-- [key_of_treasure_box4]
(20801,8724,1,1,2,2506.007664),-- [general_49_c]
(20801,8734,1,1,2,626.368248),-- [special_49_c]
(20801,8744,1,1,2,62.556624),-- [rare_49_c]
(20801,8754,1,1,2,12.564792),-- [unique_49_c]
(20801,1539,1,1,2,16706.361312),-- [greater_healing_potion]
(20802,2333,1,1,-1,5213),-- [rp_sword_of_nightmare]
(20802,1975,1,1,-1,73621),-- [rind_leather_mail_design]
(20802,4039,1,1,-1,74713),-- [mold_glue]
(20802,57,885,1804,0,700000),-- [adena]
(20802,325,1,1,1,44.93792),-- [horn_of_glory]
(20802,2088,1,1,1,3499.06208),-- [horn_of_glory_fragment]
(20802,1894,1,1,2,3167.794125),-- [crafted_leather]
(20802,4039,1,1,2,3009.373875),-- [mold_glue]
(20802,4041,1,1,2,784.974375),-- [mold_hardener]
(20802,4044,1,1,2,3009.373875),-- [thons]
(20802,737,1,1,2,9028.121625),-- [scroll_of_resurrection]
(20802,2334,1,1,2,209.937375),-- [rp_deathbreath_sword]
(20802,8724,1,1,2,3009.373875),-- [general_49_c]
(20802,8734,1,1,2,752.394375),-- [special_49_c]
(20802,8744,1,1,2,75.137625),-- [rare_49_c]
(20802,8754,1,1,2,15.06825),-- [unique_49_c]
(20802,1342,10,30,2,180563.450625),-- [fine_steel_arrow]
(20803,4044,1,1,-1,140295),-- [thons]
(20803,4042,1,1,-1,70147),-- [enria]
(20803,4043,1,1,-1,140295),-- [asofe]
(20803,57,1665,3384,0,700000),-- [adena]
(20803,231,1,1,1,26.339632),-- [grace_dagger]
(20803,2106,1,1,1,2371.660368),-- [grace_dagger_edge]
(20803,233,1,1,1,26.339632),-- [dark_screamer]
(20803,2107,1,1,1,2371.660368),-- [dark_screamer_edge]
(20803,1895,1,1,2,45208.083492),-- [metallic_fiber]
(20803,4040,1,1,2,3164.556486),-- [mold_lubricant]
(20803,4042,1,1,2,2637.141546),-- [enria]
(20803,4043,1,1,2,5274.283092),-- [asofe]
(20803,2356,1,1,2,258.092406),-- [rp_demon's_staff]
(20803,3014,1,1,2,4419.790674),-- [rp_full_plate_boots]
(20803,2360,1,1,2,258.092406),-- [rp_orcish_poleaxe]
(20803,8725,1,1,2,4395.258192),-- [general_52_c]
(20803,8735,1,1,2,1098.814548),-- [special_52_c]
(20803,8745,1,1,2,109.894824),-- [rare_52_c]
(20803,8755,1,1,2,21.992334),-- [unique_52_c]
(20804,2160,1,1,-1,132104),-- [rp_moonstone_earing]
(20804,1953,1,1,-1,65586),-- [sage's_rag_lining]
(20804,4470,1,1,-1,11701),-- [dye_s1d1_d]
(20804,57,830,1660,0,700000),-- [adena]
(20804,630,1,1,1,433.844237),-- [square_shield]
(20804,1956,1,1,1,19450.782085),-- [square_shield_fragment]
(20804,2494,1,1,1,433.844237),-- [plate_shield]
(20804,2934,1,1,1,19450.782085),-- [plate_shield_fragment]
(20804,2412,1,1,1,303.814906),-- [plate_helmet]
(20804,2930,1,1,1,13813.93245),-- [plate_helmet_design]
(20804,1864,1,3,2,128526.768747),-- [stem]
(20804,1869,1,1,2,128526.768747),-- [iron_ore]
(20804,1878,1,1,2,51410.626969),-- [braided_hemp]
(20804,1884,1,1,2,79093.551017),-- [cord]
(20804,2207,1,1,2,3391.109878),-- [rp_karmian_tunic]
(20804,2298,1,1,2,561.292706),-- [rp_stormbringer]
(20804,5274,1,1,2,428.418536),-- [rp_adv_comp_spiritshot_c]
(20804,735,1,1,2,10710.4634),-- [swift_attack_potion]
(20805,2162,1,1,-1,107039),-- [rp_aquastone_necklace]
(20805,2053,1,1,-1,18321),-- [scallop_jamadhr_edge]
(20805,1905,1,1,-1,215536),-- [onyxbeast'seye_earing_gemstone]
(20805,57,892,1803,0,700000),-- [adena]
(20805,159,1,1,1,16.045059),-- [bonebreaker]
(20805,2048,1,1,1,919.958238),-- [bonebreaker_head]
(20805,187,1,1,1,16.045059),-- [atuba_hammer]
(20805,2049,1,1,1,919.958238),-- [atuba_hammer_head]
(20805,188,1,1,1,16.045059),-- [ghost_staff]
(20805,2050,1,1,1,975.452391),-- [ghost_staff_head]
(20805,189,1,1,1,16.045059),-- [life_stick]
(20805,2051,1,1,1,975.452391),-- [life_stick_shaft]
(20805,190,1,1,1,16.045059),-- [atuba_mace]
(20805,2058,1,1,1,919.953447),-- [atuba_mace_head]
(20805,1895,1,1,2,63578.441477),-- [metallic_fiber]
(20805,2305,1,1,2,971.716607),-- [rp_crystal_staff]
(20805,2205,1,1,2,7041.871309),-- [rp_chain_gaiters]
(20805,5164,1,1,2,741.729002),-- [rp_comp_bspiritshot_c]
(20805,6668,1,1,2,79473.241605),-- [key_of_treasure_box4]
(20806,2204,1,1,-1,42364),-- [rp_chain_mail_shirt]
(20806,2934,1,1,-1,242834),-- [plate_shield_fragment]
(20806,1805,1,1,-1,7131),-- [rp_soulshot_c]
(20806,57,846,1718,0,700000),-- [adena]
(20806,70,1,1,1,38.730464),-- [claymore]
(20806,2047,1,1,1,2361.242336),-- [claymore_blade]
(20806,2499,1,1,1,38.730464),-- [elven_long_sword]
(20806,2967,1,1,1,2329.296736),-- [elven_long_sword_blade]
(20806,1865,1,1,2,153470.305536),-- [varnish]
(20806,1870,1,1,2,153470.305536),-- [coal]
(20806,1879,1,1,2,25578.384256),-- [cokes]
(20806,1875,1,1,2,10231.282856),-- [stone_of_purity]
(20806,2999,1,1,2,10300.003864),-- [rp_plate_leather_gloves]
(20806,5159,1,1,2,511.511008),-- [rp_comp_spiritshot_c]
(20806,2300,1,1,2,670.206944),-- [rp_scythe]
(20807,2164,1,1,-1,172878),-- [rp_ring_of_protection]
(20807,1910,1,1,-1,169233),-- [aquastone_necklace_chain]
(20807,1908,1,1,-1,212824),-- [moonstone_earing_wire]
(20807,57,885,1813,0,700000),-- [adena]
(20807,439,1,1,1,182.50336),-- [karmian_tunic]
(20807,1962,1,1,1,8497.88197),-- [karmian_tunic_pattern]
(20807,471,1,1,1,291.67288),-- [karmian_hose]
(20807,1954,1,1,1,14117.94179),-- [karmian_hose_pattern]
(20807,1866,1,1,2,54469.790136),-- [suede]
(20807,1871,1,1,2,81704.603376),-- [charcoal]
(20807,5220,1,1,2,3268.21032),-- [reinforcing_agent]
(20807,1885,1,1,2,6808.744224),-- [high_grade_suede]
(20807,2221,1,1,2,2705.397336),-- [rp_rind_leather_gaiters]
(20807,737,1,1,2,8170.5258),-- [scroll_of_resurrection]
(20807,2225,1,1,2,1776.158568),-- [rp_demon's_hose]
(20807,2321,1,1,2,284.76144),-- [rp_stiletto]
(20807,2316,1,1,2,284.76144),-- [rp_katana]
(20807,8723,1,1,2,3268.21032),-- [general_46_c]
(20807,8733,1,1,2,816.970752),-- [special_46_c]
(20807,8743,1,1,2,81.664344),-- [rare_46_c]
(20807,8753,1,1,2,16.201944),-- [unique_46_c]
(20808,1954,1,1,-1,148174),-- [karmian_hose_pattern]
(20808,2163,1,1,-1,142201),-- [rp_earing_of_protection]
(20808,1908,1,1,-1,263934),-- [moonstone_earing_wire]
(20808,57,1102,2239,0,700000),-- [adena]
(20808,439,1,1,1,226.33104),-- [karmian_tunic]
(20808,1962,1,1,1,10538.624955),-- [karmian_tunic_pattern]
(20808,471,1,1,1,361.71732),-- [karmian_hose]
(20808,1954,1,1,1,17508.326685),-- [karmian_hose_pattern]
(20808,1894,1,1,2,4621.920054),-- [crafted_leather]
(20808,4039,1,1,2,4390.830931),-- [mold_glue]
(20808,4041,1,1,2,1145.401253),-- [mold_hardener]
(20808,4044,1,1,2,4390.830931),-- [thons]
(20808,2324,1,1,2,458.944787),-- [rp_noble_elven_bow]
(20808,6668,1,1,2,47044.695743),-- [key_of_treasure_box4]
(20808,8723,1,1,2,5269.024636),-- [general_46_c]
(20808,8733,1,1,2,1317.256159),-- [special_46_c]
(20808,8743,1,1,2,131.746255),-- [rare_46_c]
(20808,8753,1,1,2,26.349251),-- [unique_46_c]
(20809,4439,1,1,-1,340912),-- [avadon_shield_fragment]
(20809,4973,1,1,-1,53498),-- [rp_earing_of_black_ore_i]
(20809,4049,1,1,-1,259282),-- [adamantite_earing_gemstone]
(20809,57,1955,3974,0,700000),-- [adena]
(20809,357,1,1,1,22.8717),-- [shrnoen's_breastplate]
(20809,4056,1,1,1,3304.520158),-- [shrnoen's_breastplate_part]
(20809,2376,1,1,1,22.8717),-- [avadon_breastplate]
(20809,4064,1,1,1,3304.520158),-- [avadon_breastplate_part]
(20809,383,1,1,1,36.59472),-- [shrnoen's_gaiters]
(20809,4057,1,1,1,5106.99648),-- [shrnoen's_gaiters_material]
(20809,2379,1,1,1,36.59472),-- [avadon_gaiters]
(20809,4065,1,1,1,5107.030364),-- [avadon_gaiters_material]
(20809,1868,1,1,2,243358.145793),-- [thread]
(20809,1873,1,1,2,48671.757603),-- [silver_nugget]
(20809,5549,1,1,2,12167.859123),-- [iron_thread]
(20809,1889,1,1,2,8111.906082),-- [compound_braid]
(20809,4044,1,1,2,4055.953041),-- [thons]
(20809,4158,1,1,2,258.494355),-- [rp_doom_plate_armor]
(20809,4999,1,1,2,1513.396143),-- [rp_doom_boots_i]
(20809,4981,1,1,2,377.947647),-- [rp_blue_wolve's_breastplate_i]
(20809,8728,1,1,2,2028.137076),-- [general_61_b]
(20809,8738,1,1,2,507.034269),-- [special_61_b]
(20809,8748,1,1,2,50.735538),-- [rare_61_b]
(20809,8758,1,1,2,9.63333),-- [unique_61_b]
(20810,4109,1,1,-1,27849),-- [kris_edge]
(20810,4974,1,1,-1,80247),-- [rp_ring_of_black_ore_i]
(20810,947,1,1,-1,1977),-- [scrl_of_ench_wp_b]
(20810,57,1955,3974,0,700000),-- [adena]
(20810,91,1,1,1,10.92896),-- [heavy_war_axe]
(20810,4105,1,1,1,2088.70585),-- [heavy_war_axe_head]
(20810,92,1,1,1,10.92896),-- [sprite's_staff]
(20810,4106,1,1,1,2054.43623),-- [sprite's_staff_head]
(20810,1874,1,1,2,8849.375712),-- [oriharukon_ore]
(20810,1878,1,1,2,53096.577024),-- [braided_hemp]
(20810,1884,1,1,2,81687.078816),-- [cord]
(20810,1889,1,1,2,8849.375712),-- [compound_braid]
(20810,5220,1,1,2,5309.593152),-- [reinforcing_agent]
(20810,4159,1,1,2,376.00608),-- [rp_blue_wolve's_leather_mail]
(20810,8728,1,1,2,2212.303584),-- [general_61_b]
(20810,8738,1,1,2,553.035552),-- [special_61_b]
(20810,8748,1,1,2,55.351968),-- [rare_61_b]
(20810,8758,1,1,2,11.29632),-- [unique_61_b]
(20811,947,1,1,-1,2337),-- [scrl_of_ench_wp_b]
(20811,1875,1,1,-1,389481),-- [stone_of_purity]
(20811,4040,1,1,-1,116844),-- [mold_lubricant]
(20811,57,2315,4695,0,700000),-- [adena]
(20811,78,1,1,1,8.610736),-- [great_sword]
(20811,4104,1,1,1,1645.721392),-- [great_sword_blade]
(20811,142,1,1,1,8.610736),-- [kshanberk]
(20811,4107,1,1,1,1620.2232),-- [kshanberk_blade]
(20811,148,1,1,1,8.610736),-- [sword_of_valhalla]
(20811,4108,1,1,1,1620.2232),-- [sword_of_valhalla_blade]
(20811,1865,1,1,2,132746.29155),-- [varnish]
(20811,1870,1,1,2,132746.29155),-- [coal]
(20811,1879,1,1,2,22124.327562),-- [cokes]
(20811,1875,1,1,2,8849.861496),-- [stone_of_purity]
(20811,4040,1,1,2,2655.08892),-- [mold_lubricant]
(20811,4619,1,1,2,182.985858),-- [dye_i4m4_c]
(20811,4401,1,1,2,265.508892),-- [green_dimension_stone]
(20811,4167,1,1,2,1651.113036),-- [rp_blue_wolve's_boots]
(20811,6670,1,1,2,22124.327562),-- [key_of_treasure_box6]
(20811,8728,1,1,2,2212.465374),-- [general_61_b]
(20811,8738,1,1,2,553.197888),-- [special_61_b]
(20811,8748,1,1,2,55.45026),-- [rare_61_b]
(20811,8758,1,1,2,11.090052),-- [unique_61_b]
(20812,1875,1,1,-1,384494),-- [stone_of_purity]
(20812,4617,1,1,-1,7955),-- [dye_d4s4_c]
(20812,4613,1,1,-1,7955),-- [dye_s4c4_c]
(20812,57,2285,4635,0,700000),-- [adena]
(20812,284,1,1,1,25.50048),-- [dark_elven_long_bow]
(20812,4112,1,1,1,4822.49952),-- [dark_elven_long_bow_shaft]
(20812,1872,1,1,2,227147.342492),-- [animal_bone]
(20812,1867,1,1,2,227147.342492),-- [animal_skin]
(20812,1881,1,1,2,22714.931736),-- [coarse_bone_powder]
(20812,1875,1,1,2,11357.465868),-- [stone_of_purity]
(20812,4041,1,1,2,1481.151),-- [mold_hardener]
(20812,4620,1,1,2,235.009292),-- [dye_i4w4_c]
(20812,8728,1,1,2,2839.366467),-- [general_61_b]
(20812,8738,1,1,2,709.965046),-- [special_61_b]
(20812,8748,1,1,2,71.095248),-- [rare_61_b]
(20812,8758,1,1,2,13.330359),-- [unique_61_b]
(20813,4982,1,1,-1,26129),-- [rp_blue_wolve's_gaiters_i]
(20813,4052,1,1,-1,185940),-- [earing_of_black_ore_piece]
(20813,5230,1,1,-1,7003),-- [rp_mithril_arrow]
(20813,57,2083,4219,0,700000),-- [adena]
(20813,2398,1,1,1,20.885095),-- [blue_wolve's_tunic]
(20813,4084,1,1,1,3371.22768),-- [blue_wolve's_tunic_fabric]
(20813,2399,1,1,1,20.885095),-- [tunic_of_doom]
(20813,4085,1,1,1,3371.22768),-- [tunic_of_doom_pattern]
(20813,2403,1,1,1,33.44168),-- [blue_wolve's_hose]
(20813,4086,1,1,1,4551.92959),-- [blue_wolve's_hose_pattern]
(20813,2404,1,1,1,33.44168),-- [hose_of_doom]
(20813,4087,1,1,1,4551.9615),-- [hose_of_doom_pattern]
(20813,1872,1,1,2,206843.26846),-- [animal_bone]
(20813,1867,1,1,2,206843.26846),-- [animal_skin]
(20813,1881,1,1,2,20684.50668),-- [coarse_bone_powder]
(20813,1875,1,1,2,10342.25334),-- [stone_of_purity]
(20813,4041,1,1,2,1348.755),-- [mold_hardener]
(20813,4620,1,1,2,214.00246),-- [dye_i4w4_c]
(20813,8728,1,1,2,2585.563335),-- [general_61_b]
(20813,8738,1,1,2,646.50323),-- [special_61_b]
(20813,8748,1,1,2,64.74024),-- [rare_61_b]
(20813,8758,1,1,2,12.138795),-- [unique_61_b]
(20814,948,1,1,-1,15160),-- [scrl_of_ench_am_b]
(20814,4053,1,1,-1,259927),-- [ring_of_black_ore_gemstone]
(20814,5230,1,1,-1,8085),-- [rp_mithril_arrow]
(20814,57,2405,4872,0,700000),-- [adena]
(20814,601,1,1,1,72.368139),-- [doom_boots]
(20814,4099,1,1,1,10051.881861),-- [doom_boots_part]
(20814,2439,1,1,1,72.368139),-- [blue_wolve's_boots]
(20814,4090,1,1,1,10051.881861),-- [blue_wolve's_boots_design]
(20814,2475,1,1,1,72.368139),-- [doom_gloves]
(20814,4091,1,1,1,10051.881861),-- [doom_gloves_part]
(20814,2487,1,1,1,72.368139),-- [blue_wolve's_gloves]
(20814,4096,1,1,1,10051.881861),-- [blue_wolve's_gloves_fabric]
(20814,1871,1,1,2,162840.379804),-- [charcoal]
(20814,1866,1,1,2,108560.157567),-- [suede]
(20814,1877,1,1,2,6513.649621),-- [admantite_nugget]
(20814,4041,1,1,2,1415.886045),-- [mold_hardener]
(20814,4040,1,1,2,3256.681357),-- [mold_lubricant]
(20814,4975,1,1,2,1323.788898),-- [rp_necklace_of_black_ore_i]
(20814,5276,1,1,2,217.188599),-- [rp_adv_comp_spiritshot_a]
(20814,8729,1,1,2,2171.312176),-- [general_64_a]
(20814,8739,1,1,2,542.828044),-- [special_64_a]
(20814,8749,1,1,2,54.225423),-- [rare_64_a]
(20814,8759,1,1,2,10.902466),-- [unique_64_a]
(20815,4984,1,1,-1,21315),-- [rp_blue_wolve's_leather_mail_i]
(20815,4054,1,1,-1,148200),-- [necklace_of_black_ore_beads]
(20815,4052,1,1,-1,266388),-- [earing_of_black_ore_piece]
(20815,57,2984,6042,0,700000),-- [adena]
(20815,2391,1,1,1,36.831996),-- [blue_wolve's_leather_mail]
(20815,4082,1,1,1,6278.668004),-- [blue_wolve's_leather_mail_texture]
(20815,2392,1,1,1,36.831996),-- [leather_mail_of_doom]
(20815,4083,1,1,1,6278.668004),-- [leather_mail_of_doom_design]
(20815,1870,1,1,2,202046.298342),-- [coal]
(20815,1865,1,1,2,202046.298342),-- [varnish]
(20815,1874,1,1,2,13469.971767),-- [oriharukon_ore]
(20815,4043,1,1,2,6734.751729),-- [asofe]
(20815,4039,1,1,2,6734.751729),-- [mold_glue]
(20815,5000,1,1,2,154.073661),-- [rp_sword_of_damascus_i]
(20815,6670,1,1,2,33674.226954),-- [key_of_treasure_box6]
(20815,8729,1,1,2,2694.181677),-- [general_64_a]
(20815,8739,1,1,2,673.428342),-- [special_64_a]
(20815,8749,1,1,2,67.436496),-- [rare_64_a]
(20815,8759,1,1,2,13.580961),-- [unique_64_a]
(20816,947,1,1,-1,2511),-- [scrl_of_ench_wp_b]
(20816,4039,1,1,-1,209252),-- [mold_glue]
(20816,5230,1,1,-1,8370),-- [rp_mithril_arrow]
(20816,57,2490,5041,0,700000),-- [adena]
(20816,2391,1,1,1,30.731724),-- [blue_wolve's_leather_mail]
(20816,4082,1,1,1,5238.768276),-- [blue_wolve's_leather_mail_texture]
(20816,2392,1,1,1,30.731724),-- [leather_mail_of_doom]
(20816,4083,1,1,1,5238.768276),-- [leather_mail_of_doom_design]
(20816,1864,1,3,2,154524.632885),-- [stem]
(20816,1869,1,1,2,154524.632885),-- [iron_ore]
(20816,1878,1,1,2,61809.853154),-- [braided_hemp]
(20816,1884,1,1,2,95092.337207),-- [cord]
(20816,4039,1,1,2,5150.742034),-- [mold_glue]
(20816,5001,1,1,2,118.118877),-- [rp_lancia_i]
(20816,4402,1,1,2,308.816823),-- [blue_dimension_stone]
(20816,5276,1,1,2,205.877882),-- [rp_adv_comp_spiritshot_a]
(20816,8729,1,1,2,2060.201939),-- [general_64_a]
(20816,8739,1,1,2,515.169078),-- [special_64_a]
(20816,8749,1,1,2,51.706657),-- [rare_64_a]
(20816,8759,1,1,2,10.910579),-- [unique_64_a]
(20817,4040,1,1,-1,121827),-- [mold_lubricant]
(20817,4053,1,1,-1,261096),-- [ring_of_black_ore_gemstone]
(20817,5230,1,1,-1,8122),-- [rp_mithril_arrow]
(20817,57,2418,4891,0,700000),-- [adena]
(20817,268,1,1,1,17.829735),-- [bellion_cestus]
(20817,4120,1,1,1,3931.170265),-- [bellion_cestus_edge]
(20817,1865,1,1,2,163572.416002),-- [varnish]
(20817,1870,1,1,2,163572.416002),-- [coal]
(20817,1879,1,1,2,27262.006858),-- [cokes]
(20817,1875,1,1,2,10904.877714),-- [stone_of_purity]
(20817,4040,1,1,2,3271.350858),-- [mold_lubricant]
(20817,4174,1,1,2,3151.772432),-- [rp_shrnoen's_boots]
(20817,4402,1,1,2,327.247542),-- [blue_dimension_stone]
(20817,8729,1,1,2,2180.900572),-- [general_64_a]
(20817,8739,1,1,2,545.41257),-- [special_64_a]
(20817,8749,1,1,2,54.35383),-- [rare_64_a]
(20817,8759,1,1,2,11.24562),-- [unique_64_a]
(20818,4620,1,1,-1,8386),-- [dye_i4w4_c]
(20818,4105,1,1,-1,34790),-- [heavy_war_axe_head]
(20818,4077,1,1,-1,273487),-- [doom_shield_fragment]
(20818,57,2414,4882,0,700000),-- [adena]
(20818,287,1,1,1,17.79384),-- [hazard_bow]
(20818,4121,1,1,1,3910.20616),-- [hazard_bow_shaft]
(20818,1866,1,1,2,92093.780216),-- [suede]
(20818,1871,1,1,2,138140.670324),-- [charcoal]
(20818,5220,1,1,2,5525.636983),-- [reinforcing_agent]
(20818,1885,1,1,2,11511.722527),-- [high_grade_suede]
(20818,4041,1,1,2,1201.335975),-- [mold_hardener]
(20818,4958,1,1,2,2661.753719),-- [rp_shrnoen's_boots_i]
(20818,4401,1,1,2,276.370837),-- [green_dimension_stone]
(20818,5276,1,1,2,184.077724),-- [rp_adv_comp_spiritshot_a]
(20818,5416,1,1,2,298.236423),-- [rp_sealed_dark_crystal_breastplate_i]
(20818,8729,1,1,2,1841.794244),-- [general_64_a]
(20818,8739,1,1,2,460.448561),-- [special_64_a]
(20818,8749,1,1,2,46.019431),-- [rare_64_a]
(20818,8759,1,1,2,9.153036),-- [unique_64_a]
(20819,4053,1,1,-1,259498),-- [ring_of_black_ore_gemstone]
(20819,5230,1,1,-1,8072),-- [rp_mithril_arrow]
(20819,4078,1,1,-1,88433),-- [blue_wolve's_breastplate_part]
(20819,57,2399,4864,0,700000),-- [adena]
(20819,171,1,1,1,5.907392),-- [deadman's_glory]
(20819,4116,1,1,1,1302.240608),-- [deadman's_glory_stone]
(20819,175,1,1,1,5.907392),-- [art_of_battle_axe]
(20819,4117,1,1,1,1302.240608),-- [art_of_battle_axe_blade]
(20819,210,1,1,1,5.907392),-- [staff_of_evil_sprit]
(20819,4118,1,1,1,1233.796608),-- [staff_of_evil_sprit_head]
(20819,1874,1,1,2,9934.89608),-- [oriharukon_ore]
(20819,1878,1,1,2,59609.918088),-- [braided_hemp]
(20819,1884,1,1,2,91707.413528),-- [cord]
(20819,1889,1,1,2,9934.89608),-- [compound_braid]
(20819,5220,1,1,2,5960.937648),-- [reinforcing_agent]
(20819,4159,1,1,2,422.093168),-- [rp_blue_wolve's_leather_mail]
(20819,4402,1,1,2,298.064936),-- [blue_dimension_stone]
(20819,730,1,1,2,124.208768),-- [scrl_of_ench_am_a]
(20819,8729,1,1,2,1986.979216),-- [general_64_a]
(20819,8739,1,1,2,496.835072),-- [special_64_a]
(20819,8749,1,1,2,49.6474),-- [rare_64_a]
(20819,8759,1,1,2,10.110016),-- [unique_64_a]
(20820,4080,1,1,-1,214391),-- [blue_wolve's_gaiters_material]
(20820,5230,1,1,-1,13897),-- [rp_mithril_arrow]
(20820,4054,1,1,-1,205291),-- [necklace_of_black_ore_beads]
(20820,57,4130,8374,0,700000),-- [adena]
(20820,864,1,1,1,144.335385),-- [earing_of_black_ore]
(20820,4052,1,1,1,18165.45798),-- [earing_of_black_ore_piece]
(20820,926,1,1,1,108.264222),-- [necklace_of_black_ore]
(20820,4054,1,1,1,10106.0136),-- [necklace_of_black_ore_beads]
(20820,895,1,1,1,216.477711),-- [ring_of_black_ore]
(20820,4053,1,1,1,21992.451102),-- [ring_of_black_ore_gemstone]
(20820,1867,1,3,2,171038.026143),-- [animal_skin]
(20820,1872,1,3,2,114025.350762),-- [animal_bone]
(20820,1882,1,1,2,57012.675381),-- [leather]
(20820,1894,1,1,2,9002.077521),-- [crafted_leather]
(20820,4042,1,1,2,4275.887358),-- [enria]
(20820,4160,1,1,2,726.633201),-- [rp_leather_mail_of_doom]
(20820,5276,1,1,2,342.157794),-- [rp_adv_comp_spiritshot_a]
(20820,5424,1,1,2,887.584806),-- [rp_sealed_dark_crystal_gaiters_i]
(20820,8729,1,1,2,3420.854562),-- [general_64_a]
(20820,8739,1,1,2,855.032796),-- [special_64_a]
(20820,8749,1,1,2,85.358604),-- [rare_64_a]
(20820,8759,1,1,2,17.361072),-- [unique_64_a]
(20821,4084,1,1,-1,142125),-- [blue_wolve's_tunic_fabric]
(20821,4080,1,1,-1,168217),-- [blue_wolve's_gaiters_material]
(20821,1894,1,1,-1,286943),-- [crafted_leather]
(20821,57,3240,6570,0,700000),-- [adena]
(20821,97,1,1,1,23.935716),-- [lancia]
(20821,4115,1,1,1,5268.064284),-- [lancia_blade]
(20821,1867,1,3,2,146401.197624),-- [animal_skin]
(20821,1872,1,3,2,97600.695624),-- [animal_bone]
(20821,1882,1,1,2,48800.502),-- [leather]
(20821,1894,1,1,2,7705.391112),-- [crafted_leather]
(20821,4042,1,1,2,3660.114744),-- [enria]
(20821,4195,1,1,2,167.756544),-- [rp_art_of_battle_axe]
(20821,5276,1,1,2,292.648824),-- [rp_adv_comp_spiritshot_a]
(20821,8729,1,1,2,2928.03012),-- [general_64_a]
(20821,8739,1,1,2,732.084624),-- [special_64_a]
(20821,8749,1,1,2,73.085112),-- [rare_64_a]
(20821,8759,1,1,2,14.493672),-- [unique_64_a]
(20822,1894,1,1,-1,288329),-- [crafted_leather]
(20822,1889,1,1,-1,547825),-- [compound_braid]
(20822,4077,1,1,-1,369652),-- [doom_shield_fragment]
(20822,57,3255,6602,0,700000),-- [adena]
(20822,97,1,1,1,24.053314),-- [lancia]
(20822,4115,1,1,1,5293.946686),-- [lancia_blade]
(20822,1868,1,3,2,202273.626555),-- [thread]
(20822,1873,1,1,2,80909.450622),-- [silver_nugget]
(20822,5549,1,1,2,20227.181975),-- [iron_thread]
(20822,1889,1,1,2,13484.908437),-- [compound_braid]
(20822,4044,1,1,2,6742.273538),-- [thons]
(20822,4196,1,1,2,154.301147),-- [rp_staff_of_evil_sprit]
(20822,4402,1,1,2,404.72432),-- [blue_dimension_stone]
(20822,6670,1,1,2,33712.090412),-- [key_of_treasure_box6]
(20822,8729,1,1,2,2696.837143),-- [general_64_a]
(20822,8739,1,1,2,674.299626),-- [special_64_a]
(20822,8749,1,1,2,67.574507),-- [rare_64_a]
(20822,8759,1,1,2,13.731718),-- [unique_64_a]
(20823,4088,1,1,-1,343233),-- [blue_wolve's_helmet_design]
(20823,4089,1,1,-1,343233),-- [doom_helmet_pattern]
(20823,5416,1,1,-1,19615),-- [rp_sealed_dark_crystal_breastplate_i]
(20823,57,3580,7317,0,700000),-- [adena]
(20823,2398,1,1,1,36.11531),-- [blue_wolve's_tunic]
(20823,4084,1,1,1,5829.65664),-- [blue_wolve's_tunic_fabric]
(20823,2399,1,1,1,36.11531),-- [tunic_of_doom]
(20823,4085,1,1,1,5829.65664),-- [tunic_of_doom_pattern]
(20823,2403,1,1,1,57.82864),-- [blue_wolve's_hose]
(20823,4086,1,1,1,7871.37182),-- [blue_wolve's_hose_pattern]
(20823,2404,1,1,1,57.82864),-- [hose_of_doom]
(20823,4087,1,1,1,7871.427),-- [hose_of_doom_pattern]
(20823,1869,1,1,2,223555.158436),-- [iron_ore]
(20823,1864,1,3,2,223555.158436),-- [stem]
(20823,1880,1,1,2,22355.467452),-- [steel]
(20823,5550,1,1,2,2980.92256),-- [reinforcing_plate]
(20823,4043,1,1,2,7451.822484),-- [asofe]
(20823,4616,1,1,2,308.254492),-- [dye_c4c4_c]
(20823,4402,1,1,2,447.138384),-- [blue_dimension_stone]
(20823,8316,1,1,2,82.749636),-- [rp_dragon_flame_head_i]
(20823,8730,1,1,2,2483.940828),-- [general_67_a]
(20823,8740,1,1,2,620.864228),-- [special_67_a]
(20823,8750,1,1,2,61.941248),-- [rare_67_a]
(20823,8760,1,1,2,12.581816),-- [unique_67_a]
(20824,4081,1,1,-1,84768),-- [doom_plate_armor_temper]
(20824,5424,1,1,-1,29760),-- [rp_sealed_dark_crystal_gaiters_i]
(20824,4078,1,1,-1,125629),-- [blue_wolve's_breastplate_part]
(20824,57,3391,6929,0,700000),-- [adena]
(20824,864,1,1,1,119.10308),-- [earing_of_black_ore]
(20824,4052,1,1,1,14989.82384),-- [earing_of_black_ore_piece]
(20824,926,1,1,1,89.337776),-- [necklace_of_black_ore]
(20824,4054,1,1,1,8339.3088),-- [necklace_of_black_ore_beads]
(20824,895,1,1,1,178.633688),-- [ring_of_black_ore]
(20824,4053,1,1,1,18147.792816),-- [ring_of_black_ore_gemstone]
(20824,1870,1,1,2,211706.202438),-- [coal]
(20824,1865,1,1,2,211706.202438),-- [varnish]
(20824,1874,1,1,2,14113.931742),-- [oriharukon_ore]
(20824,4043,1,1,2,7056.73473),-- [asofe]
(20824,4039,1,1,2,7056.73473),-- [mold_glue]
(20824,4617,1,1,2,292.162224),-- [dye_d4s4_c]
(20824,5276,1,1,2,282.454302),-- [rp_adv_comp_spiritshot_a]
(20824,8730,1,1,2,2352.090816),-- [general_67_a]
(20824,8740,1,1,2,588.022704),-- [special_67_a]
(20824,8750,1,1,2,58.709814),-- [rare_67_a]
(20824,8760,1,1,2,11.55705),-- [unique_67_a]
(20824,6036,1,1,2,7057.197012),-- [potion_of_acumen3]
(20825,1876,1,3,-1,901136),-- [mithril_ore]
(20825,1807,1,1,-1,12015),-- [rp_soulshot_a]
(20825,57,3565,7246,0,700000),-- [adena]
(20825,5292,1,1,1,94.89672),-- [sealed_dark_crystal_shield]
(20825,5494,1,1,1,9316.508745),-- [sealed_dark_crystal_shield_fragment]
(20825,5289,1,1,1,66.404445),-- [sealed_dark_crystal_helmet]
(20825,5525,1,1,1,6857.404452),-- [sealed_dark_crystal_helmet_design]
(20825,5294,1,1,1,66.404445),-- [sealed_tallum_bonnet]
(20825,5526,1,1,1,6857.381193),-- [sealed_tallum_bonnet_design]
(20825,1871,1,1,2,241983.002954),-- [charcoal]
(20825,1866,1,1,2,161321.860029),-- [suede]
(20825,1877,1,1,2,9679.337151),-- [admantite_nugget]
(20825,4041,1,1,2,2104.407382),-- [mold_hardener]
(20825,4040,1,1,2,4839.455665),-- [mold_lubricant]
(20825,4975,1,1,2,1967.29302),-- [rp_necklace_of_black_ore_i]
(20825,4402,1,1,2,484.158477),-- [blue_dimension_stone]
(20825,8730,1,1,2,2688.633794),-- [general_67_a]
(20825,8740,1,1,2,672.371359),-- [special_67_a]
(20825,8750,1,1,2,67.279718),-- [rare_67_a]
(20825,8760,1,1,2,13.200451),-- [unique_67_a]
(20826,5478,1,1,-1,68984),-- [sealed_dark_crystal_leather_mail_pattern]
(20826,4041,1,1,-1,71335),-- [mold_hardener]
(20826,57,3245,6597,0,700000),-- [adena]
(20826,5287,1,1,1,22.675824),-- [sealed_dark_crystal_breastplate]
(20826,5520,1,1,1,2604.474288),-- [sealed_dark_crystal_breastplate_pattern]
(20826,5293,1,1,1,13.958928),-- [sealed_tallum_plate_armor]
(20826,5521,1,1,1,1837.820736),-- [sealed_tallum_plate_armor_pattern]
(20826,5288,1,1,1,36.286416),-- [sealed_dark_crystal_gaiters]
(20826,5524,1,1,1,3980.783808),-- [sealed_dark_crystal_gaiters_pattern]
(20826,1872,1,3,2,134622.2047),-- [animal_bone]
(20826,1867,1,1,2,269243.924205),-- [animal_skin]
(20826,1881,1,1,2,26924.44094),-- [coarse_bone_powder]
(20826,1875,1,1,2,13462.22047),-- [stone_of_purity]
(20826,4041,1,1,2,1755.920705),-- [mold_hardener]
(20826,4980,1,1,2,2389.585375),-- [rp_doom_shield_i]
(20826,3956,1,1,2,269.283225),-- [rp_blessed_spiritshot_a]
(20826,6670,1,1,2,33655.551175),-- [key_of_treasure_box6]
(20826,8730,1,1,2,2243.54168),-- [general_67_a]
(20826,8740,1,1,2,560.88542),-- [special_67_a]
(20826,8750,1,1,2,56.28262),-- [rare_67_a]
(20826,8760,1,1,2,11.159485),-- [unique_67_a]
(20827,4117,1,1,-1,43680),-- [art_of_battle_axe_blade]
(20827,4118,1,1,-1,41384),-- [staff_of_evil_sprit_head]
(20827,3035,1,1,-1,13328),-- [rp_spiritshot_a]
(20827,57,3956,8034,0,700000),-- [adena]
(20827,5297,1,1,1,36.849111),-- [sealed_dark_crystal_leather_mail]
(20827,5478,1,1,1,4137.935191),-- [sealed_dark_crystal_leather_mail_pattern]
(20827,5301,1,1,1,22.666917),-- [sealed_tallum_leather_mail]
(20827,5479,1,1,1,2911.735593),-- [sealed_tallum_leather_mail_pattern]
(20827,5298,1,1,1,58.928519),-- [sealed_legging_of_dark_crystal]
(20827,5482,1,1,1,6494.884669),-- [sealed_legging_of_dark_crystal_design]
(20827,1873,1,1,2,98421.399072),-- [silver_nugget]
(20827,1868,1,3,2,246053.972032),-- [thread]
(20827,1876,1,1,2,49210.699536),-- [mithril_ore]
(20827,1895,1,1,2,70300.863808),-- [metallic_fiber]
(20827,4042,1,1,2,4100.77304),-- [enria]
(20827,4990,1,1,2,2033.547024),-- [rp_blue_wolve's_helmet_i]
(20827,4402,1,1,2,491.903024),-- [blue_dimension_stone]
(20827,5420,1,1,2,239.073408),-- [rp_sealed_armor_of_nightmare_i]
(20827,8730,1,1,2,2734.164928),-- [general_67_a]
(20827,8740,1,1,2,683.541232),-- [special_67_a]
(20827,8750,1,1,2,68.306688),-- [rare_67_a]
(20827,8760,1,1,2,13.756208),-- [unique_67_a]
(20828,4120,1,1,-1,49809),-- [bellion_cestus_edge]
(20828,4121,1,1,-1,49642),-- [hazard_bow_shaft]
(20828,5479,1,1,-1,67447),-- [sealed_tallum_leather_mail_pattern]
(20828,57,4508,9172,0,700000),-- [adena]
(20828,5304,1,1,1,42.01926),-- [sealed_tallum_tunic]
(20828,5485,1,1,1,4718.51206),-- [sealed_tallum_tunic_texture]
(20828,5308,1,1,1,25.84722),-- [sealed_dark_crystal_robe]
(20828,5486,1,1,1,3320.26938),-- [sealed_dark_crystal_robe_fabric]
(20828,5305,1,1,1,67.19654),-- [sealed_tallum_hose]
(20828,5489,1,1,1,7406.15554),-- [sealed_tallum_hose_fabric]
(20828,1864,3,9,2,112232.24376),-- [stem]
(20828,1869,2,6,2,84174.084064),-- [iron_ore]
(20828,1878,1,1,2,134678.692512),-- [braided_hemp]
(20828,1884,2,6,2,41439.597696),-- [cord]
(20828,4039,1,1,2,11223.421888),-- [mold_glue]
(20828,4177,1,1,2,6487.479152),-- [rp_shrnoen's_gauntlet]
(20828,8730,1,1,2,3741.272304),-- [general_67_a]
(20828,8740,1,1,2,935.416832),-- [special_67_a]
(20828,8750,1,1,2,93.620688),-- [rare_67_a]
(20828,8760,1,1,2,18.171104),-- [unique_67_a]
(20829,1894,1,1,-1,428952),-- [crafted_leather]
(20829,5550,1,1,-1,163002),-- [reinforcing_plate]
(20829,5479,1,1,-1,72338),-- [sealed_tallum_leather_mail_pattern]
(20829,57,6033,12296,0,700000),-- [adena]
(20829,5287,1,1,1,42.242263),-- [sealed_dark_crystal_breastplate]
(20829,5520,1,1,1,4851.814331),-- [sealed_dark_crystal_breastplate_pattern]
(20829,5293,1,1,1,26.003761),-- [sealed_tallum_plate_armor]
(20829,5521,1,1,1,3423.633332),-- [sealed_tallum_plate_armor_pattern]
(20829,5288,1,1,1,67.597117),-- [sealed_dark_crystal_gaiters]
(20829,5524,1,1,1,7415.709196),-- [sealed_dark_crystal_gaiters_pattern]
(20829,1871,1,3,2,205177.152999),-- [charcoal]
(20829,1866,1,3,2,91189.972587),-- [suede]
(20829,1877,1,1,2,16414.370063),-- [admantite_nugget]
(20829,4041,1,1,2,3568.42402),-- [mold_hardener]
(20829,4040,1,1,2,8206.994817),-- [mold_lubricant]
(20829,4129,1,1,2,4441.128146),-- [rp_earing_of_black_ore]
(20829,6671,1,1,2,45594.796079),-- [key_of_treasure_box7]
(20829,8730,1,1,2,4559.441565),-- [general_67_a]
(20829,8740,1,1,2,1139.765284),-- [special_67_a]
(20829,8750,1,1,2,114.1287),-- [rare_67_a]
(20829,8760,1,1,2,22.82574),-- [unique_67_a]
(20832,5231,1,1,-1,77593),-- [rp_reinforcing_agent]
(20832,1902,1,1,-1,110061),-- [elven_earing_beads]
(20832,1825,1,1,-1,77593),-- [rp_oriharukon]
(20832,57,430,872,0,700000),-- [adena]
(20832,1125,1,1,1,120.896793),-- [assault_boots]
(20832,1957,1,1,1,5073.582429),-- [assault_boots_part]
(20832,2427,1,1,1,120.896793),-- [slamander_skin_boots]
(20832,2931,1,1,1,5073.582429),-- [slamander_skin_boots_lining]
(20832,2428,1,1,1,120.896793),-- [plate_boots]
(20832,2932,1,1,1,5073.582429),-- [plate_boots_design]
(20832,61,1,1,1,120.896793),-- [mithril_glove]
(20832,1949,1,1,1,5073.582429),-- [mithril_glove_design]
(20832,607,1,1,1,120.896793),-- [ogre_power_gauntlet]
(20832,1963,1,1,1,5073.582429),-- [ogre_power_gauntlet_part]
(20832,2451,1,1,1,120.896793),-- [sage's_worn_gloves]
(20832,2933,1,1,1,5073.707097),-- [sage's_worn_gloves_lining]
(20832,1865,1,1,2,77927.242414),-- [varnish]
(20832,1870,1,1,2,77927.242414),-- [coal]
(20832,1879,1,1,2,12987.844002),-- [cokes]
(20832,1875,1,1,2,5195.06624),-- [stone_of_purity]
(20832,2162,1,1,2,3764.639004),-- [rp_aquastone_necklace]
(20832,5159,1,1,2,259.753312),-- [rp_comp_spiritshot_c]
(20832,2312,1,1,2,340.212614),-- [rp_crystallized_ice_bow]
(20833,1874,1,1,-1,80465),-- [oriharukon_ore]
(20833,1875,1,1,-1,80465),-- [stone_of_purity]
(20833,1905,1,1,-1,117410),-- [onyxbeast'seye_earing_gemstone]
(20833,57,475,974,0,700000),-- [adena]
(20833,281,1,1,1,32.34978),-- [crystallized_ice_bow]
(20833,2074,1,1,1,2019.65022),-- [crystallized_ice_bow_shaft]
(20833,1872,1,1,2,69143.4744),-- [animal_bone]
(20833,1867,1,1,2,69143.4744),-- [animal_skin]
(20833,1881,1,1,2,6914.34744),-- [coarse_bone_powder]
(20833,1875,1,1,2,3457.17372),-- [stone_of_purity]
(20833,2209,1,1,2,3899.03976),-- [rp_eldarake]
(20833,2205,1,1,2,1641.01476),-- [rp_chain_gaiters]
(20833,2299,1,1,2,226.50936),-- [rp_big_hammer]
(20833,8723,1,1,2,2074.2414),-- [general_46_c]
(20833,8733,1,1,2,518.52108),-- [special_46_c]
(20833,8743,1,1,2,51.8364),-- [rare_46_c]
(20833,8753,1,1,2,10.36728),-- [unique_46_c]
(20834,1878,1,1,-1,714983),-- [braided_hemp]
(20834,1885,1,1,-1,148955),-- [high_grade_suede]
(20834,1805,1,1,-1,5958),-- [rp_soulshot_c]
(20834,57,720,1455,0,700000),-- [adena]
(20834,353,1,1,1,149.199147),-- [half_plate]
(20834,1950,1,1,1,7283.399643),-- [half_plate_temper]
(20834,380,1,1,1,238.722435),-- [plate_gaiters]
(20834,1951,1,1,1,11327.678775),-- [plate_gaiters_part]
(20834,1864,1,3,2,112197.458058),-- [stem]
(20834,1869,1,1,2,112197.458058),-- [iron_ore]
(20834,1878,1,1,2,44879.216118),-- [braided_hemp]
(20834,1884,1,1,2,69044.768724),-- [cord]
(20834,2306,1,1,2,489.855396),-- [rp_stick_of_faith]
(20834,5274,1,1,2,374.184312),-- [rp_adv_comp_spiritshot_c]
(20834,2996,1,1,2,8904.732678),-- [rp_chain_gloves]
(20834,6668,1,1,2,40070.326656),-- [key_of_treasure_box4]
(20835,1871,1,3,-1,495145),-- [charcoal]
(20835,1879,1,1,-1,165048),-- [cokes]
(20835,1906,1,1,-1,136122),-- [mithril_ring_wire]
(20835,57,392,796,0,700000),-- [adena]
(20835,439,1,1,1,80.415296),-- [karmian_tunic]
(20835,1962,1,1,1,3744.367742),-- [karmian_tunic_pattern]
(20835,471,1,1,1,128.517968),-- [karmian_hose]
(20835,1954,1,1,1,6220.698994),-- [karmian_hose_pattern]
(20835,1865,1,1,2,33430.627448),-- [varnish]
(20835,1870,1,1,2,33430.627448),-- [coal]
(20835,1879,1,1,2,5571.743839),-- [cokes]
(20835,1875,1,1,2,2228.713977),-- [stone_of_purity]
(20835,4040,1,1,2,668.589531),-- [mold_lubricant]
(20835,3000,1,1,2,2142.972076),-- [rp_dwarven_chain_shield]
(20835,2303,1,1,2,145.999632),-- [rp_skull_graver]
(20835,2990,1,1,2,2653.230925),-- [rp_chain_boots]
(20835,3033,1,1,2,111.472692),-- [rp_spiritshot_c]
(20835,3954,1,1,2,111.472692),-- [rp_blessed_spiritshot_c]
(20835,8723,1,1,2,1337.261269),-- [general_46_c]
(20835,8733,1,1,2,334.335869),-- [special_46_c]
(20835,8743,1,1,2,33.458249),-- [rare_46_c]
(20835,8753,1,1,2,6.494353),-- [unique_46_c]
(20836,1874,1,1,-1,139288),-- [oriharukon_ore]
(20836,1875,1,1,-1,139288),-- [stone_of_purity]
(20836,57,822,1686,0,700000),-- [adena]
(20836,96,1,1,1,18.669784),-- [scythe]
(20836,2062,1,1,1,1290.66224),-- [scythe_edge]
(20836,298,1,1,1,18.669784),-- [orcish_glaive]
(20836,2075,1,1,1,1290.66224),-- [orcish_glaive_blade]
(20836,302,1,1,1,18.669784),-- [body_slasher]
(20836,2076,1,1,1,1290.666168),-- [body_slasher_blade]
(20836,1872,1,1,2,131658.865024),-- [animal_bone]
(20836,1867,1,1,2,131658.865024),-- [animal_skin]
(20836,1881,1,1,2,13166.008472),-- [coarse_bone_powder]
(20836,1875,1,1,2,6583.004236),-- [stone_of_purity]
(20836,2251,1,1,2,16457.358128),-- [rp_fine_steel_arrow]
(20836,2319,1,1,2,343.954272),-- [rp_raid_sword]
(20836,8723,1,1,2,3949.680572),-- [general_46_c]
(20836,8733,1,1,2,987.343912),-- [special_46_c]
(20836,8743,1,1,2,98.795376),-- [rare_46_c]
(20836,8753,1,1,2,20.124984),-- [unique_46_c]
(20837,2214,1,1,-1,50878),-- [rp_dwarven_chain_gaiters]
(20837,1960,1,1,-1,112350),-- [chain_gaiters_part]
(20837,1895,1,1,-1,585827),-- [metallic_fiber]
(20837,57,811,1647,0,700000),-- [adena]
(20837,62,1,1,1,110.887439),-- [mithril_boots]
(20837,1958,1,1,1,4839.218722),-- [mithril_boots_design]
(20837,2429,1,1,1,110.887439),-- [chain_boots]
(20837,2937,1,1,1,4839.218722),-- [chain_boots_part]
(20837,2430,1,1,1,110.887439),-- [karmian_boots]
(20837,2938,1,1,1,4839.218722),-- [karmian_boots_fabric]
(20837,2431,1,1,1,110.887439),-- [plate_leather_boots]
(20837,2939,1,1,1,4839.218722),-- [plate_leather_boots_lining]
(20837,2432,1,1,1,110.887439),-- [dwarven_chain_boots]
(20837,2940,1,1,1,4839.218722),-- [dwarven_chain_boots_part]
(20837,2433,1,1,1,110.887439),-- [boots_of_seal]
(20837,2941,1,1,1,4839.218722),-- [boots_of_seal_pattern]
(20837,2452,1,1,1,110.887439),-- [reinforce_mithril_gloves]
(20837,2942,1,1,1,4839.218722),-- [reinforce_mithril_gloves_design]
(20837,2453,1,1,1,110.887439),-- [chain_gloves]
(20837,2943,1,1,1,4839.218722),-- [chain_gloves_design]
(20837,2454,1,1,1,110.887439),-- [karmian_gloves]
(20837,2944,1,1,1,4839.263273),-- [karmian_gloves_fabric]
(20837,1873,1,1,2,35238.148158),-- [silver_nugget]
(20837,1868,1,1,2,176190.74079),-- [thread]
(20837,1876,1,1,2,17619.074079),-- [mithril_ore]
(20837,1895,1,1,2,25170.180804),-- [metallic_fiber]
(20837,4042,1,1,2,1468.234305),-- [enria]
(20837,2225,1,1,2,1915.133862),-- [rp_demon's_hose]
(20837,2321,1,1,2,307.03023),-- [rp_stiletto]
(20837,8723,1,1,2,3523.762332),-- [general_46_c]
(20837,8733,1,1,2,880.940583),-- [special_46_c]
(20837,8743,1,1,2,88.172784),-- [rare_46_c]
(20837,8753,1,1,2,17.582073),-- [unique_46_c]
(20838,2216,1,1,-1,79419),-- [rp_great_helmet]
(20838,1964,1,1,-1,155308),-- [eldarake_temper]
(20838,1866,1,3,-1,640646),-- [suede]
(20838,57,760,1544,0,700000),-- [adena]
(20838,852,1,1,1,253.796192),-- [moonstone_earing]
(20838,1908,1,1,1,14336.96992),-- [moonstone_earing_wire]
(20838,915,1,1,1,190.429408),-- [aquastone_necklace]
(20838,1910,1,1,1,11400.474176),-- [aquastone_necklace_chain]
(20838,883,1,1,1,380.858816),-- [aquastone_ring]
(20838,1909,1,1,1,20445.471488),-- [aquastone_ring_wire]
(20838,1866,1,1,2,60555.95695),-- [suede]
(20838,1871,1,1,2,90833.935425),-- [charcoal]
(20838,5220,1,1,2,3633.281),-- [reinforcing_agent]
(20838,1885,1,1,2,7569.4512),-- [high_grade_suede]
(20838,4041,1,1,2,789.8739),-- [mold_hardener]
(20838,3004,1,1,2,5641.832375),-- [rp_rind_leather_gloves]
(20838,8723,1,1,2,3633.281),-- [general_46_c]
(20838,8733,1,1,2,908.32025),-- [special_46_c]
(20838,8743,1,1,2,90.832025),-- [rare_46_c]
(20838,8753,1,1,2,18.235875),-- [unique_46_c]
(20839,2320,1,1,-1,4006),-- [rp_cursed_staff]
(20839,2066,1,1,-1,9017),-- [heavy_doom_hammer_head]
(20839,1908,1,1,-1,108867),-- [moonstone_earing_wire]
(20839,57,453,926,0,700000),-- [adena]
(20839,631,1,1,1,177.5616),-- [eldarake]
(20839,1964,1,1,1,7317.30048),-- [eldarake_temper]
(20839,2495,1,1,1,177.5616),-- [chain_shield]
(20839,2945,1,1,1,7317.30048),-- [chain_shield_fragment]
(20839,2413,1,1,1,124.29312),-- [chain_hood]
(20839,2936,1,1,1,6645.98272),-- [chain_hood_pattern]
(20839,1867,1,1,2,60370.846201),-- [animal_skin]
(20839,1872,1,1,2,60370.846201),-- [animal_bone]
(20839,1882,1,1,2,10061.782255),-- [leather]
(20839,1894,1,1,2,1588.694426),-- [crafted_leather]
(20839,4042,1,1,2,754.652753),-- [enria]
(20839,2230,1,1,2,877.552908),-- [rp_theca_leather_gaiters]
(20839,2326,1,1,2,157.709143),-- [rp_horn_of_glory]
(20839,6668,1,1,2,16170.759649),-- [key_of_treasure_box4]
(20839,8723,1,1,2,1811.136073),-- [general_46_c]
(20839,8733,1,1,2,452.822186),-- [special_46_c]
(20839,8743,1,1,2,45.343287),-- [rare_46_c]
(20839,8753,1,1,2,8.854918),-- [unique_46_c]
(20840,2328,1,1,-1,2759),-- [rp_sword_of_delusion]
(20840,1967,1,1,-1,64698),-- [plate_leather_gaiters_material]
(20840,2166,1,1,-1,40211),-- [rp_earing_of_binding]
(20840,57,468,955,0,700000),-- [adena]
(20840,227,1,1,1,11.89263),-- [stiletto]
(20840,2083,1,1,1,873.10737),-- [stiletto_edge]
(20840,242,1,1,1,11.89263),-- [dagger_of_magicflame]
(20840,2084,1,1,1,873.10737),-- [dagger_of_magicflame_blade]
(20840,1868,1,1,2,95562.358226),-- [thread]
(20840,1873,1,1,2,19112.446148),-- [silver_nugget]
(20840,5549,1,1,2,4778.17528),-- [iron_thread]
(20840,1889,1,1,2,3185.365196),-- [compound_braid]
(20840,4044,1,1,2,1592.682598),-- [thons]
(20840,2229,1,1,2,579.168898),-- [rp_theca_leather_mail]
(20840,952,1,1,2,637.047542),-- [scrl_of_ench_am_c]
(20840,8724,1,1,2,1592.682598),-- [general_49_c]
(20840,8734,1,1,2,398.138778),-- [special_49_c]
(20840,8744,1,1,2,39.775632),-- [rare_49_c]
(20840,8754,1,1,2,8.159104),-- [unique_49_c]
(20841,4438,1,1,-1,8698),-- [knuckle_dust_edge]
(20841,951,1,1,-1,2217),-- [scrl_of_ench_wp_c]
(20841,1911,1,1,-1,90711),-- [earing_of_protection_gemstone]
(20841,57,482,980,0,700000),-- [adena]
(20841,282,1,1,1,12.229558),-- [elemental_bow]
(20841,2085,1,1,1,934.770442),-- [elemental_bow_shaft]
(20841,285,1,1,1,12.229558),-- [noble_elven_bow]
(20841,2086,1,1,1,934.770442),-- [noble_elven_bow_shaft]
(20841,1869,1,1,2,45031.6002),-- [iron_ore]
(20841,1864,1,1,2,90063.05598),-- [stem]
(20841,1880,1,1,2,4503.16002),-- [steel]
(20841,5550,1,1,2,600.35394),-- [reinforcing_plate]
(20841,4043,1,1,2,1501.10148),-- [asofe]
(20841,2348,1,1,2,104.7045),-- [rp_heathen's_book]
(20841,2351,1,1,2,94.16184),-- [rp_scorpion]
(20841,952,1,1,2,600.35394),-- [scrl_of_ench_am_c]
(20841,8724,1,1,2,1501.10148),-- [general_49_c]
(20841,8734,1,1,2,375.20316),-- [special_49_c]
(20841,8744,1,1,2,37.5492),-- [rare_49_c]
(20841,8754,1,1,2,7.65426),-- [unique_49_c]
(20842,2335,1,1,-1,2707),-- [rp_war_axe]
(20842,1976,1,1,-1,70772),-- [rind_leather_gaiters_material]
(20842,2167,1,1,-1,59380),-- [rp_ring_of_ages]
(20842,57,459,937,0,700000),-- [adena]
(20842,853,1,1,1,114.213622),-- [earing_of_protection]
(20842,1911,1,1,1,6392.9024),-- [earing_of_protection_gemstone]
(20842,916,1,1,1,85.692096),-- [necklace_of_protection]
(20842,1913,1,1,1,5226.665278),-- [necklace_of_protection_gemstone]
(20842,884,1,1,1,171.384192),-- [ring_of_protection]
(20842,1912,1,1,1,9262.142412),-- [ring_of_protection_gemstone]
(20842,1870,1,1,2,51567.29048),-- [coal]
(20842,1865,1,1,2,51567.29048),-- [varnish]
(20842,1874,1,1,2,3437.856998),-- [oriharukon_ore]
(20842,4043,1,1,2,1718.87205),-- [asofe]
(20842,4039,1,1,2,1718.87205),-- [mold_glue]
(20842,952,1,1,2,687.54882),-- [scrl_of_ench_am_c]
(20842,8724,1,1,2,1718.87205),-- [general_49_c]
(20842,8734,1,1,2,429.689788),-- [special_49_c]
(20842,8744,1,1,2,43.014138),-- [rare_49_c]
(20842,8754,1,1,2,8.693146),-- [unique_49_c]
(20843,4601,1,1,-1,3273),-- [dye_s3c3_c]
(20843,1539,1,1,-1,327301),-- [greater_healing_potion]
(20843,1914,1,1,-1,82745),-- [earing_of_binding_gemstone]
(20843,57,583,1184,0,700000),-- [adena]
(20843,283,1,1,1,18.43368),-- [akat_long_bow]
(20843,2109,1,1,1,1707.56632),-- [akat_long_bow_shaft]
(20843,1871,1,1,2,50756.73014),-- [charcoal]
(20843,1866,1,1,2,33837.75913),-- [suede]
(20843,1877,1,1,2,2030.26189),-- [admantite_nugget]
(20843,4041,1,1,2,441.405015),-- [mold_hardener]
(20843,4040,1,1,2,1015.130945),-- [mold_lubricant]
(20843,2357,1,1,2,82.757725),-- [rp_crystal_dagger]
(20843,3014,1,1,2,1417.76328),-- [rp_full_plate_boots]
(20843,4188,1,1,2,58.433355),-- [rp_hell_knife]
(20843,8725,1,1,2,1409.89901),-- [general_52_c]
(20843,8735,1,1,2,352.520475),-- [special_52_c]
(20843,8745,1,1,2,35.206325),-- [rare_52_c]
(20843,8755,1,1,2,7.13271),-- [unique_52_c]
(20844,4603,1,1,-1,2922),-- [dye_c3s3_c]
(20844,1539,1,1,-1,292227),-- [greater_healing_potion]
(20844,4041,1,1,-1,11435),-- [mold_hardener]
(20844,57,521,1058,0,700000),-- [adena]
(20844,854,1,1,1,79.994376),-- [earing_of_binding]
(20844,1914,1,1,1,5091.23888),-- [earing_of_binding_gemstone]
(20844,917,1,1,1,60.00008),-- [necklace_of_mermaid]
(20844,1916,1,1,1,3856.33752),-- [necklace_of_mermaid_teardrop]
(20844,885,1,1,1,119.948584),-- [ring_of_ages]
(20844,1915,1,1,1,7984.48056),-- [ring_of_ages_gemstone]
(20844,1872,1,1,2,60423.448572),-- [animal_bone]
(20844,1867,1,1,2,60423.448572),-- [animal_skin]
(20844,1881,1,1,2,6042.318419),-- [coarse_bone_powder]
(20844,1875,1,1,2,3021.225305),-- [stone_of_purity]
(20844,4041,1,1,2,394.061371),-- [mold_hardener]
(20844,4601,1,1,2,100.729542),-- [dye_s3c3_c]
(20844,4609,1,1,2,100.729542),-- [dye_m3i3_c]
(20844,2355,1,1,2,73.894769),-- [rp_ghoul's_staff]
(20844,8725,1,1,2,1258.854893),-- [general_52_c]
(20844,8735,1,1,2,314.746771),-- [special_52_c]
(20844,8745,1,1,2,31.461458),-- [rare_52_c]
(20844,8755,1,1,2,6.080786),-- [unique_52_c]
(20845,2100,1,1,-1,10102),-- [paradia_staff_head]
(20845,2354,1,1,-1,2923),-- [rp_deadman's_staff]
(20845,4042,1,1,-1,29868),-- [enria]
(20845,57,712,1439,0,700000),-- [adena]
(20845,75,1,1,1,3.738902),-- [caliburs]
(20845,2089,1,1,1,336.595112),-- [caliburs_edge]
(20845,76,1,1,1,3.738902),-- [sword_of_delusion]
(20845,2090,1,1,1,336.595112),-- [sword_of_delusion_blade]
(20845,77,1,1,1,3.738902),-- [tsurugi]
(20845,2091,1,1,1,336.595112),-- [tsurugi_blade]
(20845,84,1,1,1,3.738902),-- [homunkulus's_sword]
(20845,2092,1,1,1,336.595112),-- [homunkulus's_sword_blade]
(20845,134,1,1,1,3.738902),-- [sword_of_nightmare]
(20845,2095,1,1,1,336.595112),-- [sword_of_nightmare_blade]
(20845,145,1,1,1,3.738902),-- [deathbreath_sword]
(20845,2096,1,1,1,336.591028),-- [deathbreath_sword_blade]
(20845,1873,1,1,2,21173.94517),-- [silver_nugget]
(20845,1868,1,1,2,105869.38383),-- [thread]
(20845,1876,1,1,2,10586.88708),-- [mithril_ore]
(20845,1895,1,1,2,15124.1244),-- [metallic_fiber]
(20845,4042,1,1,2,882.24059),-- [enria]
(20845,4608,1,1,2,117.65488),-- [dye_i3w3_c]
(20845,3017,1,1,2,1478.55246),-- [rp_blessed_gloves]
(20845,5155,1,1,2,105.85519),-- [rp_comp_soulshot_b]
(20845,6669,1,1,2,12310.32586),-- [key_of_treasure_box5]
(20845,8725,1,1,2,1470.34398),-- [general_52_c]
(20845,8735,1,1,2,367.6715),-- [special_52_c]
(20845,8745,1,1,2,36.76715),-- [rare_52_c]
(20845,8755,1,1,2,7.69545),-- [unique_52_c]
(20846,2955,1,1,-1,100037),-- [theca_leather_gloves_texture]
(20846,4042,1,1,-1,26343),-- [enria]
(20846,1918,1,1,-1,68453),-- [nassen's_earing_gemstone]
(20846,57,626,1271,0,700000),-- [adena]
(20846,400,1,1,1,30.636222),-- [theca_leather_mail]
(20846,1984,1,1,1,2084.968227),-- [theca_leather_mail_pattern]
(20846,401,1,1,1,14.504139),-- [drake_leather_mail]
(20846,1987,1,1,1,1483.927092),-- [drake_leather_mail_texture]
(20846,420,1,1,1,49.034796),-- [theca_leather_gaiters]
(20846,1985,1,1,1,3353.929524),-- [theca_leather_gaiters_pattern]
(20846,1870,1,1,2,48633.326469),-- [coal]
(20846,1865,1,1,2,48633.326469),-- [varnish]
(20846,1874,1,1,2,3242.243112),-- [oriharukon_ore]
(20846,4043,1,1,2,1621.121556),-- [asofe]
(20846,4039,1,1,2,1621.121556),-- [mold_glue]
(20846,4133,1,1,2,233.860767),-- [rp_shrnoen's_breastplate]
(20846,4959,1,1,2,937.044123),-- [rp_avadon_boots_i]
(20846,4941,1,1,2,374.113185),-- [rp_shrnoen's_gaiters_i]
(20846,8726,1,1,2,1125.755139),-- [general_55_c]
(20846,8736,1,1,2,281.465469),-- [special_55_c]
(20846,8746,1,1,2,28.178568),-- [rare_55_c]
(20846,8756,1,1,2,5.443587),-- [unique_55_c]
(20847,1985,1,1,-1,52100),-- [theca_leather_gaiters_pattern]
(20847,4937,1,1,-1,24933),-- [rp_adamantite_earing_i]
(20847,1806,1,1,-1,3022),-- [rp_soulshot_b]
(20847,57,597,1215,0,700000),-- [adena]
(20847,2436,1,1,1,37.663092),-- [theca_leather_boots]
(20847,2954,1,1,1,2522.47632),-- [theca_leather_boots_texture]
(20847,2437,1,1,1,28.976568),-- [drake_leather_boots]
(20847,2960,1,1,1,2170.164444),-- [drake_leather_boots_design]
(20847,2438,1,1,1,28.976568),-- [full_plate_boots]
(20847,2961,1,1,1,2170.164444),-- [full_plate_boots_part]
(20847,2460,1,1,1,37.663092),-- [theca_leather_gloves]
(20847,2955,1,1,1,2522.47632),-- [theca_leather_gloves_texture]
(20847,2461,1,1,1,28.976568),-- [drake_leather_gloves]
(20847,2962,1,1,1,2170.164444),-- [drake_leather_gloves_design]
(20847,2462,1,1,1,28.976568),-- [full_plate_gauntlet]
(20847,2963,1,1,1,2170.164444),-- [full_plate_gauntlet_part]
(20847,2463,1,1,1,28.976568),-- [blessed_gloves]
(20847,2964,1,1,1,2170.18056),-- [blessed_gloves_pattern]
(20847,1864,1,1,2,92979.551623),-- [stem]
(20847,1869,1,1,2,46489.680511),-- [iron_ore]
(20847,1878,1,1,2,18595.986565),-- [braided_hemp]
(20847,1884,1,1,2,28609.019499),-- [cord]
(20847,4039,1,1,2,1549.58613),-- [mold_glue]
(20847,4178,1,1,2,852.939475),-- [rp_shrnoen's_shield]
(20847,4184,1,1,2,53.558881),-- [rp_sprite's_staff]
(20847,5160,1,1,2,93.013288),-- [rp_comp_spiritshot_b]
(20847,8726,1,1,2,1076.133246),-- [general_55_c]
(20847,8736,1,1,2,269.128612),-- [special_55_c]
(20847,8746,1,1,2,26.874741),-- [rare_55_c]
(20847,8756,1,1,2,5.527429),-- [unique_55_c]
(20848,1895,1,1,-1,555409),-- [metallic_fiber]
(20848,1871,1,5,-1,647978),-- [charcoal]
(20848,1908,1,1,-1,184085),-- [moonstone_earing_wire]
(20848,57,766,1566,0,700000),-- [adena]
(20848,96,1,1,1,17.372215),-- [scythe]
(20848,2062,1,1,1,1200.9599),-- [scythe_edge]
(20848,298,1,1,1,17.372215),-- [orcish_glaive]
(20848,2075,1,1,1,1200.9599),-- [orcish_glaive_blade]
(20848,302,1,1,1,17.372215),-- [body_slasher]
(20848,2076,1,1,1,1200.963555),-- [body_slasher_blade]
(20848,1864,1,3,2,91873.219761),-- [stem]
(20848,1865,1,1,2,91873.219761),-- [varnish]
(20848,1866,1,1,2,61248.813174),-- [suede]
(20848,1873,1,1,2,36749.097),-- [silver_nugget]
(20848,1868,1,1,2,183745.962261),-- [thread]
(20848,2164,1,1,2,7067.280888),-- [rp_ring_of_protection]
(20848,8723,1,1,2,3674.9097),-- [general_46_c]
(20848,8733,1,1,2,918.727425),-- [special_46_c]
(20848,8743,1,1,2,92.111373),-- [rare_46_c]
(20848,8753,1,1,2,17.658657),-- [unique_46_c]
(20849,4469,1,1,-1,8784),-- [dye_s1c1_d]
(20849,1956,1,1,-1,174488),-- [square_shield_fragment]
(20849,1805,1,1,-1,5124),-- [rp_soulshot_c]
(20849,57,623,1246,0,700000),-- [adena]
(20849,438,1,1,1,210.560031),-- [sage's_rag]
(20849,1953,1,1,1,12362.439969),-- [sage's_rag_lining]
(20849,1869,1,1,2,85770.187359),-- [iron_ore]
(20849,1870,1,1,2,85770.187359),-- [coal]
(20849,1871,1,1,2,85770.187359),-- [charcoal]
(20849,1872,1,1,2,114360.413559),-- [animal_bone]
(20849,1867,1,1,2,114360.413559),-- [animal_skin]
(20849,2211,1,1,2,1923.208515),-- [rp_plate_leather]
(20849,2205,1,1,2,2714.106525),-- [rp_chain_gaiters]
(20849,5274,1,1,2,285.902262),-- [rp_adv_comp_spiritshot_c]
(20849,5279,1,1,2,286.393503),-- [rp_adv_comp_bspiritshot_c]
(20859,5479,1,1,-1,99083),-- [sealed_tallum_leather_mail_pattern]
(20859,3035,1,1,-1,22327),-- [rp_spiritshot_a]
(20859,57,8257,16860,0,700000),-- [adena]
(20859,5287,1,1,1,57.858582),-- [sealed_dark_crystal_breastplate]
(20859,5520,1,1,1,6645.455934),-- [sealed_dark_crystal_breastplate_pattern]
(20859,5293,1,1,1,35.616954),-- [sealed_tallum_plate_armor]
(20859,5521,1,1,1,4689.298248),-- [sealed_tallum_plate_armor_pattern]
(20859,5288,1,1,1,92.586738),-- [sealed_dark_crystal_gaiters]
(20859,5524,1,1,1,10157.183544),-- [sealed_dark_crystal_gaiters_pattern]
(20859,1872,4,12,2,103046.67411),-- [animal_bone]
(20859,1867,7,21,2,54958.3053),-- [animal_skin]
(20859,1881,1,1,2,82437.45795),-- [coarse_bone_powder]
(20859,1875,1,1,2,41218.728975),-- [stone_of_purity]
(20859,4041,1,1,2,5376.278565),-- [mold_hardener]
(20859,3035,1,1,2,824.404245),-- [rp_spiritshot_a]
(20859,8730,1,1,2,6869.639835),-- [general_67_a]
(20859,8740,1,1,2,1717.335795),-- [special_67_a]
(20859,8750,1,1,2,171.763245),-- [rare_67_a]
(20859,8760,1,1,2,34.41198),-- [unique_67_a]
(20860,5482,1,1,-1,310640),-- [sealed_legging_of_dark_crystal_design]
(20860,5156,1,1,-1,31381),-- [rp_comp_soulshot_a]
(20860,5485,1,1,-1,197912),-- [sealed_tallum_tunic_texture]
(20860,57,11622,23663,0,700000),-- [adena]
(20860,5287,1,1,1,81.321761),-- [sealed_dark_crystal_breastplate]
(20860,5520,1,1,1,9340.363357),-- [sealed_dark_crystal_breastplate_pattern]
(20860,5293,1,1,1,50.060567),-- [sealed_tallum_plate_armor]
(20860,5521,1,1,1,6590.932204),-- [sealed_tallum_plate_armor_pattern]
(20860,5288,1,1,1,130.133099),-- [sealed_dark_crystal_gaiters]
(20860,5524,1,1,1,14276.189012),-- [sealed_dark_crystal_gaiters_pattern]
(20860,1873,2,6,2,86900.8238),-- [silver_nugget]
(20860,1868,15,45,2,57934.13984),-- [thread]
(20860,1876,1,1,2,173802.03356),-- [mithril_ore]
(20860,1895,3,9,2,41381.47332),-- [metallic_fiber]
(20860,4042,1,1,2,14483.53496),-- [enria]
(20860,5271,1,1,2,1158.65192),-- [rp_adv_comp_soulshot_a]
(20860,8731,1,1,2,8046.49408),-- [general_70_a]
(20860,8741,1,1,2,2011.62352),-- [special_70_a]
(20860,8751,1,1,2,201.08516),-- [rare_70_a]
(20860,8761,1,1,2,40.13984),-- [unique_70_a]
(20919,1865,1,1,-1,121597),-- [varnish]
(20919,734,1,1,-1,20266),-- [quick_step_potion]
(20919,5220,1,1,-1,4864),-- [reinforcing_agent]
(20919,57,56,98,0,700000),-- [adena]
(20919,24,1,1,1,230.2898),-- [bone_breastplate]
(20919,390,1,1,1,230.2898),-- [tights_shirt]
(20919,31,1,1,1,367.7102),-- [bone_gaiters]
(20919,412,1,1,1,367.7102),-- [tights_pants]
(20919,1872,1,1,2,23945.309388),-- [animal_bone]
(20919,1867,1,1,2,23945.309388),-- [animal_skin]
(20919,1881,1,1,2,2394.509388),-- [coarse_bone_powder]
(20919,2141,1,1,2,3591.871836),-- [rp_silver_mold]
(20920,2014,1,1,-1,3010),-- [iron_hammer_head]
(20920,5163,1,1,-1,10474),-- [rp_comp_bspiritshot_d]
(20920,1898,1,1,-1,26897),-- [blue_diamond_necklace_gem]
(20920,57,119,213,0,700000),-- [adena]
(20920,273,1,1,1,82.310514),-- [composition_bow]
(20920,2016,1,1,1,906.689486),-- [composition_bow_shaft]
(20920,1865,1,1,2,25780.999642),-- [varnish]
(20920,1870,1,1,2,25780.999642),-- [coal]
(20920,1879,1,1,2,4296.775744),-- [cokes]
(20920,1060,1,1,2,57290.91855),-- [lesser_healing_potion]
(20920,735,1,1,2,2148.387872),-- [swift_attack_potion]
(20921,1864,1,1,-1,366638),-- [stem]
(20921,1928,1,1,-1,26703),-- [piece_bone_gaiters_fragment]
(20921,1804,1,1,-1,7333),-- [rp_soulshot_d]
(20921,57,81,150,0,700000),-- [adena]
(20921,39,1,1,1,759.966624),-- [boots]
(20921,1930,1,1,1,9256.055976),-- [boots_lining]
(20921,51,1,1,1,759.9774),-- [bracer]
(20921,1880,1,1,2,2165.957945),-- [steel]
(20921,1881,1,1,2,2887.933129),-- [coarse_bone_powder]
(20921,1882,1,1,2,4813.211084),-- [leather]
(20921,3032,1,1,2,866.383178),-- [rp_spiritshot_d]
(20921,6666,1,1,2,21659.514664),-- [key_of_treasure_box2]
(20922,1870,1,1,-1,198933),-- [coal]
(20922,1932,1,1,-1,31577),-- [bone_helmet_design]
(20922,1899,1,1,-1,31083),-- [necklace_of_devotion_chain]
(20922,57,86,165,0,700000),-- [adena]
(20922,123,1,1,1,17.72225),-- [saber]
(20922,2017,1,1,1,370.922125),-- [saber_blade]
(20922,5285,1,1,1,17.72225),-- [heavy_sword]
(20922,5531,1,1,1,468.633375),-- [heavy_sword_edge]
(20922,1874,1,1,2,1488.638052),-- [oriharukon_ore]
(20922,1878,1,1,2,8931.70575),-- [braided_hemp]
(20922,5220,1,1,2,893.170575),-- [reinforcing_agent]
(20922,2259,1,1,2,346.727898),-- [rp_spinebone_sword]
(20922,1060,1,1,2,49620.757725),-- [lesser_healing_potion]
(20923,2263,1,1,-1,4453),-- [rp_dwarven_trident]
(20923,2019,1,1,-1,6166),-- [trident_edge]
(20923,2152,1,1,-1,50483),-- [rp_enchanted_necklace]
(20923,57,123,241,0,700000),-- [adena]
(20923,432,1,1,1,334.060111),-- [cursed_tunic]
(20923,465,1,1,1,534.939889),-- [cursed_hose]
(20923,1875,1,1,2,1788.05016),-- [stone_of_purity]
(20923,1879,1,1,2,4470.1254),-- [cokes]
(20923,1885,1,1,2,2235.069584),-- [high_grade_suede]
(20923,5550,1,1,2,357.610032),-- [reinforcing_plate]
(20923,5549,1,1,2,2682.07524),-- [iron_thread]
(20923,735,1,1,2,2235.069584),-- [swift_attack_potion]
(20924,2250,1,1,-1,86656),-- [rp_bone_arrow]
(20924,1937,1,1,-1,29779),-- [scale_gaiters_fragment]
(20924,1900,1,1,-1,37924),-- [enchanted_necklace_chain]
(20924,57,146,292,0,700000),-- [adena]
(20924,259,1,1,1,76),-- [single-edged_jamadhr]
(20924,1876,1,1,2,4735.320325),-- [mithril_ore]
(20924,1880,1,1,2,2367.643666),-- [steel]
(20924,1877,1,1,2,947.064065),-- [admantite_nugget]
(20924,1881,1,1,2,3156.869219),-- [coarse_bone_powder]
(20924,1882,1,1,2,5261.459696),-- [leather]
(20924,2183,1,1,2,1557.665516),-- [rp_mithril_banded_mail]
(20924,2274,1,1,2,169.122118),-- [rp_skull_breaker]
(20924,6667,1,1,2,14797.855395),-- [key_of_treasure_box3]
(20925,2016,1,1,-1,2190),-- [composition_bow_shaft]
(20925,2258,1,1,-1,4570),-- [rp_temptation_of_abyss]
(20925,1874,1,1,-1,12461),-- [oriharukon_ore]
(20925,57,83,153,0,700000),-- [adena]
(20925,846,1,1,1,448.917695),-- [coral_earing]
(20925,909,1,1,1,336.689345),-- [blue_diamond_necklace]
(20925,1898,1,1,1,2836.009975),-- [blue_diamond_necklace_gem]
(20925,878,1,1,1,673.382985),-- [blue_coral_ring]
(20925,1872,1,1,2,24538.382522),-- [animal_bone]
(20925,1867,1,1,2,24538.382522),-- [animal_skin]
(20925,1881,1,1,2,2453.810168),-- [coarse_bone_powder]
(20925,5273,1,1,2,736.180496),-- [rp_adv_comp_spiritshot_d]
(20925,8294,1,1,2,450.002498),-- [rp_iron_sword]
(20925,1060,1,1,2,40897.241794),-- [lesser_healing_potion]
(20926,2018,1,1,-1,2844),-- [assassin_knife_edge]
(20926,1869,1,1,-1,214041),-- [iron_ore]
(20926,1875,1,1,-1,14269),-- [stone_of_purity]
(20926,57,94,177,0,700000),-- [adena]
(20926,156,1,1,1,25.333308),-- [hand_axe]
(20926,167,1,1,1,25.333308),-- [scalpel]
(20926,178,1,1,1,25.333384),-- [bone_staff]
(20926,1875,1,1,2,1144.0568),-- [stone_of_purity]
(20926,1879,1,1,2,2860.142),-- [cokes]
(20926,5549,1,1,2,1716.0852),-- [iron_thread]
(20926,2178,1,1,2,2745.73632),-- [rp_dark_hose]
(20926,5437,1,1,2,419.58578),-- [rp_heavy_sword]
(20926,1834,1,1,2,19067.490475),-- [emergency_dressing]
(20926,1831,1,1,2,45761.903425),-- [antidote]
(20927,1866,1,1,-1,200876),-- [suede]
(20927,1932,1,1,-1,47828),-- [bone_helmet_design]
(20927,1899,1,1,-1,47080),-- [necklace_of_devotion_chain]
(20927,57,130,251,0,700000),-- [adena]
(20927,220,1,1,1,107),-- [handiwork_dagger]
(20927,1876,1,1,2,5636.799558),-- [mithril_ore]
(20927,1880,1,1,2,2818.399779),-- [steel]
(20927,1877,1,1,2,1127.355089),-- [admantite_nugget]
(20927,1881,1,1,2,3757.866372),-- [coarse_bone_powder]
(20927,1882,1,1,2,6263.11062),-- [leather]
(20927,2178,1,1,2,4509.468582),-- [rp_dark_hose]
(20928,2183,1,1,-1,19597),-- [rp_mithril_banded_mail]
(20928,2025,1,1,-1,4126),-- [dwarven_trident_edge]
(20928,2153,1,1,-1,46326),-- [rp_tiger'seye_earing]
(20928,57,126,251,0,700000),-- [adena]
(20928,348,1,1,1,79.403112),-- [scale_mail]
(20928,1935,1,1,1,2273.473584),-- [scale_mail_fragment]
(20928,377,1,1,1,126.972072),-- [scale_gaiters]
(20928,1937,1,1,1,3496.151232),-- [scale_gaiters_fragment]
(20928,1872,1,1,2,27129.856536),-- [animal_bone]
(20928,1867,1,1,2,27129.856536),-- [animal_skin]
(20928,1881,1,1,2,2712.994248),-- [coarse_bone_powder]
(20928,1875,1,1,2,1356.454152),-- [stone_of_purity]
(20928,2184,1,1,2,2137.341336),-- [rp_mithril_banded_gaiters]
(20928,2274,1,1,2,145.331304),-- [rp_skull_breaker]
(20928,2978,1,1,2,2723.909136),-- [rp_elven_mithril_boots]
(20928,1832,1,1,2,22608.256752),-- [advanced_antidote]
(20929,1871,1,1,-1,279467),-- [charcoal]
(20929,1900,1,1,-1,30576),-- [enchanted_necklace_chain]
(20929,956,1,1,-1,9316),-- [scrl_of_ench_am_d]
(20929,57,118,236,0,700000),-- [adena]
(20929,315,1,1,1,62),-- [divine_tome]
(20929,1865,1,1,2,21816.784359),-- [varnish]
(20929,1870,1,1,2,21816.784359),-- [coal]
(20929,1879,1,1,2,3636.182493),-- [cokes]
(20929,1875,1,1,2,1454.431584),-- [stone_of_purity]
(20929,2250,1,1,2,5454.221973),-- [rp_bone_arrow]
(20929,6387,1,1,2,872.679657),-- [blessed_scroll_of_resurrection_pet]
(20929,1060,1,1,2,48481.915575),-- [lesser_healing_potion]
(20930,2028,1,1,-1,5182),-- [knife_o'_silenus_edge]
(20930,2156,1,1,-1,34888),-- [rp_elven_necklace]
(20930,2154,1,1,-1,46692),-- [rp_elven_earing]
(20930,57,184,367,0,700000),-- [adena]
(20930,83,1,1,1,14.02224),-- [sword_of_magic]
(20930,144,1,1,1,14.02224),-- [sword_of_occult]
(20930,124,1,1,1,10.387776),-- [two-handed_sword]
(20930,2026,1,1,1,464.791668),-- [two-handed_sword_edge]
(20930,127,1,1,1,10.387776),-- [crimson_sword]
(20930,130,1,1,1,10.3883),-- [elven_sword]
(20930,1869,1,1,2,33124.743108),-- [iron_ore]
(20930,1864,1,1,2,66249.486216),-- [stem]
(20930,1880,1,1,2,3312.431766),-- [steel]
(20930,5550,1,1,2,441.615024),-- [reinforcing_plate]
(20930,2279,1,1,2,236.65545),-- [rp_hammer_in_flames]
(20930,8317,1,1,2,236.65545),-- [rp_giants_hammer]
(20930,735,1,1,2,2760.412986),-- [swift_attack_potion]
(20931,2271,1,1,-1,3460),-- [rp_winged_spear]
(20931,1940,1,1,-1,72301),-- [iron_boots_design]
(20931,1901,1,1,-1,66909),-- [tiger'seye_earing_stone]
(20931,57,204,409,0,700000),-- [adena]
(20931,293,1,1,1,34.5),-- [war_hammer]
(20931,296,1,1,1,34.5),-- [dwarven_pike]
(20931,1865,1,1,2,36794.475256),-- [varnish]
(20931,1870,1,1,2,36794.475256),-- [coal]
(20931,1879,1,1,2,6132.440347),-- [cokes]
(20931,1875,1,1,2,2452.926091),-- [stone_of_purity]
(20931,2276,1,1,2,262.834363),-- [rp_maingauche]
(20931,2286,1,1,2,204.445263),-- [rp_bonebreaker]
(20931,2197,1,1,2,771.403424),-- [rp_slamander_skin_mail]
(20932,1825,1,1,-1,37742),-- [rp_oriharukon]
(20932,2032,1,1,-1,4883),-- [goathead_staff_head]
(20932,5220,1,1,-1,21136),-- [reinforcing_agent]
(20932,57,223,446,0,700000),-- [adena]
(20932,850,1,1,1,126.629928),-- [elven_earing]
(20932,1902,1,1,1,4612.26069),-- [elven_earing_beads]
(20932,913,1,1,1,95.03991),-- [elven_necklace]
(20932,1904,1,1,1,4248.528534),-- [elven_necklace_beads]
(20932,881,1,1,1,190.07982),-- [elven_ring]
(20932,1903,1,1,1,7593.461118),-- [elven_ring_piece]
(20932,1866,1,1,2,26013.137496),-- [suede]
(20932,1871,1,1,2,39019.706244),-- [charcoal]
(20932,5220,1,1,2,1560.80127),-- [reinforcing_agent]
(20932,1885,1,1,2,3251.642187),-- [high_grade_suede]
(20932,2201,1,1,2,3788.401581),-- [rp_square_shield]
(20932,2159,1,1,2,2408.581647),-- [rp_necklace_of_darkness]
(20932,1060,1,1,2,86710.729575),-- [lesser_healing_potion]
(20933,1879,1,1,-1,101112),-- [cokes]
(20933,1894,1,1,-1,21287),-- [crafted_leather]
(20933,1880,1,1,-1,60667),-- [steel]
(20933,57,253,505,0,700000),-- [adena]
(20933,261,1,1,1,29.207871),-- [bich'hwa]
(20933,2039,1,1,1,1587.792129),-- [bich'hwa_edge]
(20933,1865,1,1,2,52266.939944),-- [varnish]
(20933,1870,1,1,2,52266.939944),-- [coal]
(20933,1879,1,1,2,8711.176688),-- [cokes]
(20933,1875,1,1,2,3484.494712),-- [stone_of_purity]
(20933,2159,1,1,2,3226.33948),-- [rp_necklace_of_darkness]
(20933,2298,1,1,2,228.109232),-- [rp_stormbringer]
(20934,1868,1,1,-1,654152),-- [thread]
(20934,2028,1,1,-1,3886),-- [knife_o'_silenus_edge]
(20934,1938,1,1,-1,21988),-- [mithril_banded_mail_material]
(20934,57,138,276,0,700000),-- [adena]
(20934,436,1,1,1,148.555188),-- [tunic_of_knowledge]
(20934,469,1,1,1,237.444812),-- [hose_of_knowledge]
(20934,1867,1,1,2,46374.15549),-- [animal_skin]
(20934,1872,1,1,2,46374.15549),-- [animal_bone]
(20934,1882,1,1,2,7728.99153),-- [leather]
(20934,2190,1,1,2,2484.281865),-- [rp_mithril_hose]
(20934,3020,1,1,2,193.415625),-- [rp_elven_long_sword]
(20935,1872,1,1,-1,475451),-- [animal_bone]
(20935,2040,1,1,-1,4126),-- [strengthening_long_bow_shaft]
(20935,1825,1,1,-1,25471),-- [rp_oriharukon]
(20935,57,151,301,0,700000),-- [adena]
(20935,629,1,1,1,101.89584),-- [kite_shield]
(20935,1947,1,1,1,4423.35942),-- [kite_shield_fragment]
(20935,2493,1,1,1,101.89584),-- [brigandine_shield]
(20935,2929,1,1,1,4423.35942),-- [brigandine_shield_fragment]
(20935,2411,1,1,1,71.362125),-- [brigandine_helmet]
(20935,2922,1,1,1,1183.127355),-- [brigandine_helmet_design]
(20935,1868,1,1,2,52665.454213),-- [thread]
(20935,1873,1,1,2,10533.105304),-- [silver_nugget]
(20935,5549,1,1,2,2633.276326),-- [iron_thread]
(20935,1889,1,1,2,1755.541653),-- [compound_braid]
(20935,2148,1,1,2,1880.921991),-- [rp_crafted_leather]
(20935,2984,1,1,2,2692.495759),-- [rp_slamander_skin_boots]
(20935,2288,1,1,2,146.204754),-- [rp_ghost_staff]
(20936,1874,1,1,-1,45199),-- [oriharukon_ore]
(20936,1875,1,1,-1,45199),-- [stone_of_purity]
(20936,1902,1,1,-1,68692),-- [elven_earing_beads]
(20936,57,283,565,0,700000),-- [adena]
(20936,437,1,1,1,101.881109),-- [mithril_tunic]
(20936,1944,1,1,1,4469.134758),-- [mithril_tunic_fabric]
(20936,470,1,1,1,162.708095),-- [mithril_hose]
(20936,1945,1,1,1,6959.276038),-- [mithril_hose_design]
(20936,1865,1,1,2,58411.514883),-- [varnish]
(20936,1870,1,1,2,58411.514883),-- [coal]
(20936,1879,1,1,2,9735.274866),-- [cokes]
(20936,1875,1,1,2,3894.136809),-- [stone_of_purity]
(20936,2159,1,1,2,3605.632485),-- [rp_necklace_of_darkness]
(20936,2298,1,1,2,254.926074),-- [rp_stormbringer]
(20937,4480,1,1,-1,5103),-- [dye_w1m1_d]
(20937,2054,1,1,-1,7601),-- [cyclone_bow_shaft]
(20937,1805,1,1,-1,2977),-- [rp_soulshot_c]
(20937,57,360,727,0,700000),-- [adena]
(20937,1125,1,1,1,99.391617),-- [assault_boots]
(20937,1957,1,1,1,4171.091301),-- [assault_boots_part]
(20937,2427,1,1,1,99.391617),-- [slamander_skin_boots]
(20937,2931,1,1,1,4171.091301),-- [slamander_skin_boots_lining]
(20937,2428,1,1,1,99.391617),-- [plate_boots]
(20937,2932,1,1,1,4171.091301),-- [plate_boots_design]
(20937,61,1,1,1,99.391617),-- [mithril_glove]
(20937,1949,1,1,1,4171.091301),-- [mithril_glove_design]
(20937,607,1,1,1,99.391617),-- [ogre_power_gauntlet]
(20937,1963,1,1,1,4171.091301),-- [ogre_power_gauntlet_part]
(20937,2451,1,1,1,99.391617),-- [sage's_worn_gloves]
(20937,2933,1,1,1,4171.193793),-- [sage's_worn_gloves_lining]
(20937,1866,1,1,2,42709.985513),-- [suede]
(20937,1871,1,1,2,64065.036868),-- [charcoal]
(20937,5220,1,1,2,2562.629602),-- [reinforcing_agent]
(20937,1885,1,1,2,5338.792138),-- [high_grade_suede]
(20937,2307,1,1,2,279.749239),-- [rp_heavy_doom_axe]
(20937,2205,1,1,2,2027.390903),-- [rp_chain_gaiters]
(20937,5164,1,1,2,213.415737),-- [rp_comp_bspiritshot_c]
(20938,2323,1,1,-1,3431),-- [rp_elemental_bow]
(20938,2070,1,1,-1,7819),-- [cursed_dagger_blade]
(20938,1908,1,1,-1,93255),-- [moonstone_earing_wire]
(20938,57,388,794,0,700000),-- [adena]
(20938,281,1,1,1,26.406375),-- [crystallized_ice_bow]
(20938,2074,1,1,1,1648.593625),-- [crystallized_ice_bow_shaft]
(20938,1867,1,1,2,56414.7238),-- [animal_skin]
(20938,1872,1,1,2,56414.7238),-- [animal_bone]
(20938,1882,1,1,2,9402.496075),-- [leather]
(20938,1894,1,1,2,1484.5714),-- [crafted_leather]
(20938,2315,1,1,2,147.421275),-- [rp_shamshir]
(20938,2321,1,1,2,147.421275),-- [rp_stiletto]
(20938,2317,1,1,2,147.421275),-- [rp_bech_de_corbin]
(20938,8723,1,1,2,1692.50235),-- [general_46_c]
(20938,8733,1,1,2,423.062425),-- [special_46_c]
(20938,8743,1,1,2,42.318875),-- [rare_46_c]
(20938,8753,1,1,2,8.33745),-- [unique_46_c]
(20939,2067,1,1,-1,7925),-- [crystal_staff_head]
(20939,1873,1,1,-1,439855),-- [silver_nugget]
(20939,1868,1,5,-1,733092),-- [thread]
(20939,57,433,886,0,700000),-- [adena]
(20939,397,1,1,1,89.299392),-- [tempered_mithril_shirt]
(20939,1961,1,1,1,4158.036834),-- [tempered_mithril_shirt_fabric]
(20939,2387,1,1,1,142.716336),-- [tempered_mithril_gaiters]
(20939,2935,1,1,1,6907.947438),-- [tempered_mithril_gaiters_fragment]
(20939,1868,1,1,2,94492.38564),-- [thread]
(20939,1873,1,1,2,18898.477128),-- [silver_nugget]
(20939,5549,1,1,2,4724.556084),-- [iron_thread]
(20939,1889,1,1,2,3149.78832),-- [compound_braid]
(20939,4044,1,1,2,1574.89416),-- [thons]
(20939,2225,1,1,2,1027.093896),-- [rp_demon's_hose]
(20939,2343,1,1,2,109.838124),-- [rp_mace_of_underworld]
(20939,8723,1,1,2,1889.872992),-- [general_46_c]
(20939,8733,1,1,2,472.468248),-- [special_46_c]
(20939,8743,1,1,2,47.272104),-- [rare_46_c]
(20939,8753,1,1,2,9.353304),-- [unique_46_c]
(20940,1970,1,1,-1,36908),-- [robe_of_seal_fabric]
(20940,5550,1,1,-1,22037),-- [reinforcing_plate]
(20940,4589,1,1,-1,5509),-- [dye_s2c2_c]
(20940,57,653,1328,0,700000),-- [adena]
(20940,4233,1,1,1,33.134608),-- [knuckle_dust]
(20940,4438,1,1,1,2610.865392),-- [knuckle_dust_edge]
(20940,1869,1,1,2,61024.781804),-- [iron_ore]
(20940,1864,1,1,2,122049.563608),-- [stem]
(20940,1880,1,1,2,6102.538064),-- [steel]
(20940,5550,1,1,2,813.618512),-- [reinforcing_plate]
(20940,4043,1,1,2,2034.245892),-- [asofe]
(20940,2350,1,1,2,127.75168),-- [rp_paagrio_axe]
(20940,3005,1,1,2,2490.758536),-- [rp_demon's_boots]
(20940,4132,1,1,2,2365.202588),-- [rp_composite_shield]
(20940,8724,1,1,2,2034.245892),-- [general_49_c]
(20940,8734,1,1,2,508.611376),-- [special_49_c]
(20940,8744,1,1,2,50.90106),-- [rare_49_c]
(20940,8754,1,1,2,9.780988),-- [unique_49_c]
(20941,2233,1,1,-1,12171),-- [rp_divine_tunic]
(20941,2109,1,1,-1,7302),-- [akat_long_bow_shaft]
(20941,4601,1,1,-1,2894),-- [dye_s3c3_c]
(20941,57,515,1047,0,700000),-- [adena]
(20941,60,1,1,1,43.890273),-- [composite_armor]
(20941,1977,1,1,1,3983.109727),-- [composite_armor_temper]
(20941,1870,1,1,2,44877.48583),-- [coal]
(20941,1865,1,1,2,44877.48583),-- [varnish]
(20941,1874,1,1,2,2991.80543),-- [oriharukon_ore]
(20941,4043,1,1,2,1495.902715),-- [asofe]
(20941,4039,1,1,2,1495.902715),-- [mold_glue]
(20941,3013,1,1,2,1253.578),-- [rp_drake_leather_boots]
(20941,3014,1,1,2,1253.578),-- [rp_full_plate_boots]
(20941,8725,1,1,2,1246.602445),-- [general_52_c]
(20941,8735,1,1,2,311.675885),-- [special_52_c]
(20941,8745,1,1,2,31.13726),-- [rare_52_c]
(20941,8755,1,1,2,6.26789),-- [unique_52_c]
(20942,2301,1,1,-1,2863),-- [rp_battle_axe]
(20942,2931,1,1,-1,73162),-- [slamander_skin_boots_lining]
(20942,1905,1,1,-1,63768),-- [onyxbeast'seye_earing_gemstone]
(20942,57,259,526,0,700000),-- [adena]
(20942,225,1,1,1,23.731105),-- [mithril_dagger]
(20942,2052,1,1,1,1427.268895),-- [mithril_dagger_blade]
(20942,1871,1,1,2,41147.300372),-- [charcoal]
(20942,1866,1,1,2,27431.55799),-- [suede]
(20942,1877,1,1,2,1645.900802),-- [admantite_nugget]
(20942,2225,1,1,2,894.528816),-- [rp_demon's_hose]
(20942,8723,1,1,2,1645.900802),-- [general_46_c]
(20942,8733,1,1,2,411.456894),-- [special_46_c]
(20942,8743,1,1,2,41.153012),-- [rare_46_c]
(20942,8753,1,1,2,8.201312),-- [unique_46_c]
(20943,1874,1,1,-1,62887),-- [oriharukon_ore]
(20943,1875,1,1,-1,62887),-- [stone_of_purity]
(20943,2163,1,1,-1,48128),-- [rp_earing_of_protection]
(20943,57,373,758,0,700000),-- [adena]
(20943,263,1,1,1,25.28482),-- [chakram]
(20943,2073,1,1,1,1722.71518),-- [chakram_edge]
(20943,1872,1,1,2,59442.614958),-- [animal_bone]
(20943,1867,1,1,2,59442.614958),-- [animal_skin]
(20943,1881,1,1,2,5944.287784),-- [coarse_bone_powder]
(20943,1875,1,1,2,2972.143892),-- [stone_of_purity]
(20943,4041,1,1,2,387.619509),-- [mold_hardener]
(20943,2225,1,1,2,969.114493),-- [rp_demon's_hose]
(20943,8723,1,1,2,1783.260047),-- [general_46_c]
(20943,8733,1,1,2,445.847872),-- [special_46_c]
(20943,8743,1,1,2,44.558499),-- [rare_46_c]
(20943,8753,1,1,2,8.937988),-- [unique_46_c]
(20944,2947,1,1,-1,57031),-- [dwarven_chain_shield_fragment]
(20944,2329,1,1,-1,1857),-- [rp_tsurugi]
(20944,1911,1,1,-1,59386),-- [earing_of_protection_gemstone]
(20944,57,315,643,0,700000),-- [adena]
(20944,853,1,1,1,78.35292),-- [earing_of_protection]
(20944,1911,1,1,1,4385.664),-- [earing_of_protection_gemstone]
(20944,916,1,1,1,58.78656),-- [necklace_of_protection]
(20944,1913,1,1,1,3585.60108),-- [necklace_of_protection_gemstone]
(20944,884,1,1,1,117.57312),-- [ring_of_protection]
(20944,1912,1,1,1,6354.02232),-- [ring_of_protection_gemstone]
(20944,1873,1,1,2,14150.763066),-- [silver_nugget]
(20944,1868,1,1,2,70753.81533),-- [thread]
(20944,1876,1,1,2,7075.381533),-- [mithril_ore]
(20944,1895,1,1,2,10107.732591),-- [metallic_fiber]
(20944,4042,1,1,2,589.641195),-- [enria]
(20944,2328,1,1,2,82.268241),-- [rp_sword_of_delusion]
(20944,8724,1,1,2,1179.28239),-- [general_49_c]
(20944,8734,1,1,2,294.768463),-- [special_49_c]
(20944,8744,1,1,2,29.508127),-- [rare_49_c]
(20944,8754,1,1,2,5.839064),-- [unique_49_c]
(20945,1868,1,3,-1,897692),-- [thread]
(20945,1876,1,1,-1,179538),-- [mithril_ore]
(20945,4601,1,1,-1,1995),-- [dye_s3c3_c]
(20945,57,355,722,0,700000),-- [adena]
(20945,64,1,1,1,98.312175),-- [composite_boots]
(20945,2956,1,1,1,5459.187825),-- [composite_boots_part]
(20945,608,1,1,1,98.312175),-- [mithril_gauntlet]
(20945,1981,1,1,1,5459.187825),-- [mithril_gauntlet_design]
(20945,1873,1,1,2,13499.220456),-- [silver_nugget]
(20945,1868,1,1,2,67495.899996),-- [thread]
(20945,1876,1,1,2,6749.610228),-- [mithril_ore]
(20945,1895,1,1,2,9642.271428),-- [metallic_fiber]
(20945,4042,1,1,2,562.450662),-- [enria]
(20945,2170,1,1,2,795.98754),-- [rp_nassen's_earing]
(20945,2970,1,1,2,1196.712144),-- [rp_ring_of_binding]
(20945,8725,1,1,2,937.485198),-- [general_52_c]
(20945,8735,1,1,2,234.346014),-- [special_52_c]
(20945,8745,1,1,2,23.464944),-- [rare_52_c]
(20945,8755,1,1,2,4.55139),-- [unique_52_c]
(20946,1539,1,1,-1,307481),-- [greater_healing_potion]
(20946,1914,1,1,-1,77734),-- [earing_of_binding_gemstone]
(20946,2169,1,1,-1,24490),-- [rp_necklace_of_binding]
(20946,57,550,1111,0,700000),-- [adena]
(20946,103,1,1,1,72.138022),-- [tower_shield]
(20946,1978,1,1,1,4584.843537),-- [tower_shield_fragment]
(20946,107,1,1,1,72.138022),-- [composite_shield]
(20946,4055,1,1,1,4584.843537),-- [composite_shield_fragment]
(20946,517,1,1,1,50.51858),-- [composite_helmet]
(20946,2957,1,1,1,3136.999861),-- [composite_helmet_design]
(20946,1149,1,1,1,50.51858),-- [shining_circlet]
(20946,1983,1,1,1,3136.999861),-- [shining_circlet_pattern]
(20946,1864,1,1,2,104035.737255),-- [stem]
(20946,1869,1,1,2,52017.759267),-- [iron_ore]
(20946,1878,1,1,2,20807.147451),-- [braided_hemp]
(20946,1884,1,1,2,32010.911955),-- [cord]
(20946,4039,1,1,2,1734.020088),-- [mold_glue]
(20946,2233,1,1,2,486.216783),-- [rp_divine_tunic]
(20946,4180,1,1,2,5779.702425),-- [rp_silver_arrow]
(20946,8725,1,1,2,1444.870926),-- [general_52_c]
(20946,8735,1,1,2,361.327092),-- [special_52_c]
(20946,8745,1,1,2,36.088965),-- [rare_52_c]
(20946,8755,1,1,2,7.217793),-- [unique_52_c]
(20947,4967,1,1,-1,1726),-- [rp_sword_of_valhalla_i]
(20947,4938,1,1,-1,37080),-- [rp_adamantite_ring_i]
(20947,1806,1,1,-1,2996),-- [rp_soulshot_b]
(20947,57,592,1205,0,700000),-- [adena]
(20947,356,1,1,1,30.932675),-- [full_plate_armor]
(20947,1986,1,1,1,2922.067325),-- [full_plate_armor_temper]
(20947,1869,1,1,2,46093.153575),-- [iron_ore]
(20947,1864,1,1,2,92186.454675),-- [stem]
(20947,1880,1,1,2,4609.2711),-- [steel]
(20947,5550,1,1,2,614.58915),-- [reinforcing_plate]
(20947,4043,1,1,2,1536.472875),-- [asofe]
(20947,4179,1,1,2,592.4604),-- [rp_shrnoen's_helmet]
(20947,4184,1,1,2,53.109),-- [rp_sprite's_staff]
(20947,4144,1,1,2,473.702775),-- [rp_shrnoen's_leather_gaiters]
(20947,8726,1,1,2,1066.9008),-- [general_55_c]
(20947,8736,1,1,2,266.7252),-- [special_55_c]
(20947,8746,1,1,2,26.702025),-- [rare_55_c]
(20947,8756,1,1,2,5.458425),-- [unique_55_c]
(20948,4049,1,1,-1,78274),-- [adamantite_earing_gemstone]
(20948,4129,1,1,-1,16150),-- [rp_earing_of_black_ore]
(20948,4050,1,1,-1,92459),-- [adamantite_ring_wire]
(20948,57,589,1202,0,700000),-- [adena]
(20948,11889,1,1,1,42.03066),-- [great_sword_low]
(20948,4104,1,1,1,420.310722),-- [great_sword_blade]
(20948,11916,1,1,1,42.03066),-- [kshanberk_low]
(20948,4107,1,1,1,413.797962),-- [kshanberk_blade]
(20948,11900,1,1,1,42.03066),-- [sword_of_valhalla_low]
(20948,4108,1,1,1,413.799336),-- [sword_of_valhalla_blade]
(20948,1865,1,1,2,36733.092399),-- [varnish]
(20948,1870,1,1,2,36733.092399),-- [coal]
(20948,1879,1,1,2,6122.16801),-- [cokes]
(20948,1875,1,1,2,2448.867204),-- [stone_of_purity]
(20948,4040,1,1,2,734.677029),-- [mold_lubricant]
(20948,948,1,1,2,91.845171),-- [scrl_of_ench_am_b]
(20948,4176,1,1,2,456.864363),-- [rp_doom_boots]
(20948,4158,1,1,2,78.013575),-- [rp_doom_plate_armor]
(20948,8727,1,1,2,734.677029),-- [general_58_b]
(20948,8737,1,1,2,183.690342),-- [special_58_b]
(20948,8747,1,1,2,18.385902),-- [rare_58_b]
(20948,8757,1,1,2,3.626577),-- [unique_58_b]
(20949,947,1,1,-1,706),-- [scrl_of_ench_wp_b]
(20949,4041,1,1,-1,15347),-- [mold_hardener]
(20949,1866,1,3,-1,588296),-- [suede]
(20949,57,697,1420,0,700000),-- [adena]
(20949,11918,1,1,1,74.601684),-- [heavy_war_axe_low]
(20949,4105,1,1,1,746.018469),-- [heavy_war_axe_head]
(20949,11908,1,1,1,74.601684),-- [sprite's_staff_low]
(20949,4106,1,1,1,733.778163),-- [sprite's_staff_head]
(20949,1866,1,1,2,28962.20029),-- [suede]
(20949,1871,1,1,2,43443.300435),-- [charcoal]
(20949,5220,1,1,2,1737.748142),-- [reinforcing_agent]
(20949,1885,1,1,2,3620.295192),-- [high_grade_suede]
(20949,4041,1,1,2,377.799378),-- [mold_hardener]
(20949,4129,1,1,2,470.193336),-- [rp_earing_of_black_ore]
(20949,4993,1,1,2,540.335346),-- [rp_doom_gloves_i]
(20949,4165,1,1,2,359.014219),-- [rp_blue_wolve's_helmet]
(20949,8727,1,1,2,868.874071),-- [general_58_b]
(20949,8737,1,1,2,217.198362),-- [special_58_b]
(20949,8747,1,1,2,21.687587),-- [rare_58_b]
(20949,8757,1,1,2,4.353642),-- [unique_58_b]
(20950,4056,1,1,-1,34524),-- [shrnoen's_breastplate_part]
(20950,4049,1,1,-1,100049),-- [adamantite_earing_gemstone]
(20950,947,1,1,-1,763),-- [scrl_of_ench_wp_b]
(20950,57,754,1534,0,700000),-- [adena]
(20950,11890,1,1,1,161.225658),-- [great_axe_low]
(20950,4113,1,1,1,1449.774342),-- [great_axe_head]
(20950,1869,1,1,2,51220.563425),-- [iron_ore]
(20950,1864,1,1,2,102440.964015),-- [stem]
(20950,1880,1,1,2,5121.974925),-- [steel]
(20950,5550,1,1,2,682.92999),-- [reinforcing_plate]
(20950,4043,1,1,2,1707.324975),-- [asofe]
(20950,4159,1,1,2,145.085985),-- [rp_blue_wolve's_leather_mail]
(20950,4990,1,1,2,423.371),-- [rp_blue_wolve's_helmet_i]
(20950,8728,1,1,2,853.743905),-- [general_61_b]
(20950,8738,1,1,2,213.476685),-- [special_61_b]
(20950,8748,1,1,2,21.331385),-- [rare_61_b]
(20950,8758,1,1,2,4.23371),-- [unique_61_b]
(20951,1918,1,1,-1,43851),-- [nassen's_earing_gemstone]
(20951,1806,1,1,-1,2025),-- [rp_soulshot_b]
(20951,1920,1,1,-1,34646),-- [necklace_of_binding_chain]
(20951,57,401,814,0,700000),-- [adena]
(20951,266,1,1,1,7.932936),-- [great_pata]
(20951,2120,1,1,1,898.067064),-- [great_pata_blade]
(20951,1867,1,1,2,41539.858702),-- [animal_skin]
(20951,1872,1,1,2,41539.858702),-- [animal_bone]
(20951,1882,1,1,2,6923.325236),-- [leather]
(20951,1894,1,1,2,1093.190774),-- [crafted_leather]
(20951,4042,1,1,2,519.291114),-- [enria]
(20951,1806,1,1,2,62.303808),-- [rp_soulshot_b]
(20951,5270,1,1,2,62.303808),-- [rp_adv_comp_soulshot_b]
(20951,5436,1,1,2,50.807272),-- [rp_berserker_blade]
(20951,8726,1,1,2,721.222206),-- [general_55_c]
(20951,8736,1,1,2,180.32873),-- [special_55_c]
(20951,8746,1,1,2,17.986516),-- [rare_55_c]
(20951,8756,1,1,2,3.523132),-- [unique_55_c]
(20952,3034,1,1,-1,3670),-- [rp_spiritshot_b]
(20952,1984,1,1,-1,39333),-- [theca_leather_mail_pattern]
(20952,4044,1,1,-1,61163),-- [thons]
(20952,57,725,1477,0,700000),-- [adena]
(20952,286,1,1,1,14.372796),-- [eminence_bow]
(20952,2121,1,1,1,1557.627204),-- [eminence_bow_shaft]
(20952,1868,1,1,2,112917.336858),-- [thread]
(20952,1873,1,1,2,22583.49724),-- [silver_nugget]
(20952,5549,1,1,2,5645.87431),-- [iron_thread]
(20952,1889,1,1,2,3763.866426),-- [compound_braid]
(20952,4044,1,1,2,1882.007884),-- [thons]
(20952,4128,1,1,2,698.771218),-- [rp_adamantite_necklace]
(20952,5275,1,1,2,112.902552),-- [rp_adv_comp_spiritshot_b]
(20952,4187,1,1,2,65.113112),-- [rp_kris]
(20952,8726,1,1,2,1306.891842),-- [general_55_c]
(20952,8736,1,1,2,326.760296),-- [special_55_c]
(20952,8746,1,1,2,32.705898),-- [rare_55_c]
(20952,8756,1,1,2,6.272364),-- [unique_55_c]
(20953,4948,1,1,-1,7508),-- [rp_avadon_leather_mail_i]
(20953,2962,1,1,-1,93209),-- [drake_leather_gloves_design]
(20953,1864,1,7,-1,855888),-- [stem]
(20953,57,675,1379,0,700000),-- [adena]
(20953,12338,1,1,1,690.734994),-- [adamantite_earing_low]
(20953,4049,1,1,1,4420.076379),-- [adamantite_earing_gemstone]
(20953,12339,1,1,1,518.574231),-- [adamantite_necklace_low]
(20953,4051,1,1,1,3268.12881),-- [adamantite_necklace_chain]
(20953,12340,1,1,1,1040.36217),-- [adamantite_ring_low]
(20953,4050,1,1,1,5221.123416),-- [adamantite_ring_wire]
(20953,1864,1,1,2,84271.931253),-- [stem]
(20953,1869,1,1,2,42135.87924),-- [iron_ore]
(20953,1878,1,1,2,16854.351696),-- [braided_hemp]
(20953,1884,1,1,2,25929.77184),-- [cord]
(20953,4039,1,1,2,1404.471717),-- [mold_glue]
(20953,4962,1,1,2,541.643355),-- [rp_shrnoen's_helmet_i]
(20953,4999,1,1,2,524.020509),-- [rp_doom_boots_i]
(20953,8311,1,1,2,32.135778),-- [rp_bone_of_kaim_vanul]
(20953,8727,1,1,2,842.786694),-- [general_58_b]
(20953,8737,1,1,2,210.610287),-- [special_58_b]
(20953,8747,1,1,2,21.078306),-- [rare_58_b]
(20953,8757,1,1,2,4.319325),-- [unique_58_b]
(20954,4613,1,1,-1,2805),-- [dye_s4c4_c]
(20954,4049,1,1,-1,106679),-- [adamantite_earing_gemstone]
(20954,1869,1,5,-1,677943),-- [iron_ore]
(20954,57,804,1635,0,700000),-- [adena]
(20954,11915,1,1,1,85.937856),-- [kris_low]
(20954,4109,1,1,1,846.062144),-- [kris_edge]
(20954,11919,1,1,1,85.937856),-- [hell_knife_low]
(20954,4110,1,1,1,846.062144),-- [hell_knife_edge]
(20954,1869,1,1,2,54614.611875),-- [iron_ore]
(20954,1864,1,1,2,109229.050125),-- [stem]
(20954,1880,1,1,2,5461.374375),-- [steel]
(20954,5550,1,1,2,728.18325),-- [reinforcing_plate]
(20954,4043,1,1,2,1820.458125),-- [asofe]
(20954,4159,1,1,2,154.699875),-- [rp_blue_wolve's_leather_mail]
(20954,4990,1,1,2,451.425),-- [rp_blue_wolve's_helmet_i]
(20954,8728,1,1,2,910.315875),-- [general_61_b]
(20954,8738,1,1,2,227.622375),-- [special_61_b]
(20954,8748,1,1,2,22.744875),-- [rare_61_b]
(20954,8758,1,1,2,4.51425),-- [unique_61_b]
(20955,5230,1,1,-1,3164),-- [rp_mithril_arrow]
(20955,4052,1,1,-1,84007),-- [earing_of_black_ore_piece]
(20955,57,941,1906,0,700000),-- [adena]
(20955,12194,1,1,1,191.508928),-- [blue_wolve's_leather_mail_low]
(20955,4082,1,1,1,1979.991072),-- [blue_wolve's_leather_mail_texture]
(20955,12186,1,1,1,191.508928),-- [leather_mail_of_doom_low]
(20955,4083,1,1,1,1979.991072),-- [leather_mail_of_doom_design]
(20955,1870,1,1,2,63717.00321),-- [coal]
(20955,1865,1,1,2,63717.00321),-- [varnish]
(20955,1874,1,1,2,4247.800214),-- [oriharukon_ore]
(20955,4043,1,1,2,2123.900107),-- [asofe]
(20955,4039,1,1,2,2123.900107),-- [mold_glue]
(20955,1830,1,1,2,25486.801284),-- [scroll_of_escape_to_castle]
(20955,5276,1,1,2,85.034047),-- [rp_adv_comp_spiritshot_a]
(20955,8729,1,1,2,849.527525),-- [general_64_a]
(20955,8739,1,1,2,212.341234),-- [special_64_a]
(20955,8749,1,1,2,21.299159),-- [rare_64_a]
(20955,8759,1,1,2,4.389903),-- [unique_64_a]
(20956,4987,1,1,-1,9891),-- [rp_tunic_of_doom_i]
(20956,4106,1,1,-1,13417),-- [sprite's_staff_head]
(20956,1884,1,3,-1,733439),-- [cord]
(20956,57,946,1914,0,700000),-- [adena]
(20956,11939,1,1,1,114.995952),-- [demon's_sword_low]
(20956,4119,1,1,1,1541.004048),-- [demon's_sword_edge]
(20956,1874,1,1,2,3911.681418),-- [oriharukon_ore]
(20956,1878,1,1,2,23469.967654),-- [braided_hemp]
(20956,1884,1,1,2,36107.670434),-- [cord]
(20956,1889,1,1,2,3911.681418),-- [compound_braid]
(20956,5220,1,1,2,2346.98468),-- [reinforcing_agent]
(20956,4175,1,1,2,1130.58917),-- [rp_avadon_boots]
(20956,2508,1,1,2,48895.836444),-- [cursed_bone]
(20956,3956,1,1,2,78.192538),-- [rp_blessed_spiritshot_a]
(20956,8729,1,1,2,782.287942),-- [general_64_a]
(20956,8739,1,1,2,195.541772),-- [special_64_a]
(20956,8749,1,1,2,19.578348),-- [rare_64_a]
(20956,8759,1,1,2,3.988182),-- [unique_64_a]
(20957,4053,1,1,-1,107147),-- [ring_of_black_ore_gemstone]
(20957,1877,1,1,-1,99989),-- [admantite_nugget]
(20957,4052,1,1,-1,88502),-- [earing_of_black_ore_piece]
(20957,57,990,2008,0,700000),-- [adena]
(20957,12183,1,1,1,624.694206),-- [doom_shield_low]
(20957,4077,1,1,1,5535.988494),-- [doom_shield_fragment]
(20957,12202,1,1,1,437.17812),-- [blue_wolve's_helmet_low]
(20957,4088,1,1,1,4650.98053),-- [blue_wolve's_helmet_design]
(20957,12185,1,1,1,437.17812),-- [doom_helmet_low]
(20957,4089,1,1,1,4650.98053),-- [doom_helmet_pattern]
(20957,1871,1,1,2,61532.00592),-- [charcoal]
(20957,1866,1,1,2,41021.33728),-- [suede]
(20957,1877,1,1,2,2461.33888),-- [admantite_nugget]
(20957,4041,1,1,2,535.1192),-- [mold_hardener]
(20957,4040,1,1,2,1230.66944),-- [mold_lubricant]
(20957,1830,1,1,2,24612.76048),-- [scroll_of_escape_to_castle]
(20957,5276,1,1,2,82.10048),-- [rp_adv_comp_spiritshot_a]
(20957,8729,1,1,2,820.37648),-- [general_64_a]
(20957,8739,1,1,2,205.04176),-- [special_64_a]
(20957,8749,1,1,2,20.52512),-- [rare_64_a]
(20957,8759,1,1,2,4.1888),-- [unique_64_a]
(20957,1344,10,30,2,76914.53616),-- [mithril_arrow]
(20958,5478,1,1,-1,15776),-- [sealed_dark_crystal_leather_mail_pattern]
(20958,1807,1,1,-1,2501),-- [rp_soulshot_a]
(20958,57,742,1509,0,700000),-- [adena]
(20958,12225,1,1,1,383.207895),-- [sealed_dark_crystal_shield_low]
(20958,5494,1,1,1,1939.59099),-- [sealed_dark_crystal_shield_fragment]
(20958,12226,1,1,1,268.46784),-- [sealed_dark_crystal_helmet_low]
(20958,5525,1,1,1,1427.62986),-- [sealed_dark_crystal_helmet_design]
(20958,12234,1,1,1,268.46784),-- [sealed_tallum_bonnet_low]
(20958,5526,1,1,1,1427.635575),-- [sealed_tallum_bonnet_design]
(20958,1872,1,1,2,73888.48786),-- [animal_bone]
(20958,1867,1,1,2,73888.48786),-- [animal_skin]
(20958,1881,1,1,2,7388.768684),-- [coarse_bone_powder]
(20958,1875,1,1,2,3694.464444),-- [stone_of_purity]
(20958,4041,1,1,2,481.893632),-- [mold_hardener]
(20958,5156,1,1,2,73.854044),-- [rp_comp_soulshot_a]
(20958,8730,1,1,2,615.663972),-- [general_67_a]
(20958,8740,1,1,2,153.956044),-- [special_67_a]
(20958,8750,1,1,2,15.379584),-- [rare_67_a]
(20958,8760,1,1,2,3.043876),-- [unique_67_a]
(20959,4054,1,1,-1,59502),-- [necklace_of_black_ore_beads]
(20959,5478,1,1,-1,25403),-- [sealed_dark_crystal_leather_mail_pattern]
(20959,1807,1,1,-1,4028),-- [rp_soulshot_a]
(20959,57,1195,2431,0,700000),-- [adena]
(20959,12232,1,1,1,216.001044),-- [sealed_tallum_tunic_low]
(20959,5485,1,1,1,1250.548992),-- [sealed_tallum_tunic_texture]
(20959,12223,1,1,1,132.780816),-- [sealed_dark_crystal_robe_low]
(20959,5486,1,1,1,879.972156),-- [sealed_dark_crystal_robe_fabric]
(20959,12235,1,1,1,345.851604),-- [sealed_tallum_hose_low]
(20959,5489,1,1,1,1962.845388),-- [sealed_tallum_hose_fabric]
(20959,1871,1,1,2,81120.798288),-- [charcoal]
(20959,1866,1,1,2,54080.532192),-- [suede]
(20959,1877,1,1,2,3244.763004),-- [admantite_nugget]
(20959,4041,1,1,2,705.358288),-- [mold_hardener]
(20959,4040,1,1,2,1622.381502),-- [mold_lubricant]
(20959,4953,1,1,2,1563.075115),-- [rp_avadon_gloves_i]
(20959,5281,1,1,2,108.130047),-- [rp_adv_comp_bspiritshot_a]
(20959,8730,1,1,2,901.370923),-- [general_67_a]
(20959,8740,1,1,2,225.306831),-- [special_67_a]
(20959,8750,1,1,2,22.545043),-- [rare_67_a]
(20959,8760,1,1,2,4.738767),-- [unique_67_a]
(20960,4052,1,1,-1,58175),-- [earing_of_black_ore_piece]
(20960,5230,1,1,-1,2191),-- [rp_mithril_arrow]
(20960,4053,1,1,-1,70431),-- [ring_of_black_ore_gemstone]
(20960,57,652,1319,0,700000),-- [adena]
(20960,11932,1,1,1,79.271942),-- [lancia_low]
(20960,4115,1,1,1,1058.728058),-- [lancia_blade]
(20960,1873,1,1,2,16178.77374),-- [silver_nugget]
(20960,1868,1,1,2,80893.516758),-- [thread]
(20960,1876,1,1,2,8089.38687),-- [mithril_ore]
(20960,1895,1,1,2,11556.191541),-- [metallic_fiber]
(20960,4042,1,1,2,674.144901),-- [enria]
(20960,5230,1,1,2,53.847126),-- [rp_mithril_arrow]
(20960,5276,1,1,2,53.847126),-- [rp_adv_comp_spiritshot_a]
(20960,8729,1,1,2,539.351115),-- [general_64_a]
(20960,8739,1,1,2,134.793786),-- [special_64_a]
(20960,8749,1,1,2,13.549767),-- [rare_64_a]
(20960,8759,1,1,2,2.639565),-- [unique_64_a]
(20960,1343,10,30,2,57780.957705),-- [silver_arrow]
(20961,1884,1,3,-1,744103),-- [cord]
(20961,4053,1,1,-1,103658),-- [ring_of_black_ore_gemstone]
(20961,5230,1,1,-1,3224),-- [rp_mithril_arrow]
(20961,57,958,1943,0,700000),-- [adena]
(20961,12188,1,1,1,474.972605),-- [doom_boots_low]
(20961,4099,1,1,1,4008.777395),-- [doom_boots_part]
(20961,12189,1,1,1,474.972605),-- [blue_wolve's_boots_low]
(20961,4090,1,1,1,4008.777395),-- [blue_wolve's_boots_design]
(20961,12187,1,1,1,474.972605),-- [doom_gloves_low]
(20961,4091,1,1,1,4008.777395),-- [doom_gloves_part]
(20961,12190,1,1,1,474.972605),-- [blue_wolve's_gloves_low]
(20961,4096,1,1,1,4008.777395),-- [blue_wolve's_gloves_fabric]
(20961,1864,1,1,2,119056.63003),-- [stem]
(20961,1869,1,1,2,59528.19391),-- [iron_ore]
(20961,1878,1,1,2,23811.42289),-- [braided_hemp]
(20961,1884,1,1,2,36632.80924),-- [cord]
(20961,4039,1,1,2,1984.18432),-- [mold_glue]
(20961,5230,1,1,2,79.44488);-- [rp_mithril_arrow]

INSERT INTO `droplist` VALUES
(20961,3956,1,1,2,79.44488),-- [rp_blessed_spiritshot_a]
(20961,8326,1,1,2,22.04111),-- [rp_doom_crusher_i]
(20961,8729,1,1,2,793.72217),-- [general_64_a]
(20961,8739,1,1,2,198.36999),-- [special_64_a]
(20961,8749,1,1,2,19.86122),-- [rare_64_a]
(20961,8759,1,1,2,3.87536),-- [unique_64_a]
(20962,4054,1,1,-1,45467),-- [necklace_of_black_ore_beads]
(20962,5230,1,1,-1,3078),-- [rp_mithril_arrow]
(20962,4077,1,1,-1,103839),-- [doom_shield_fragment]
(20962,57,914,1854,0,700000),-- [adena]
(20962,12194,1,1,1,186.3056),-- [blue_wolve's_leather_mail_low]
(20962,4082,1,1,1,1926.1944),-- [blue_wolve's_leather_mail_texture]
(20962,12186,1,1,1,186.3056),-- [leather_mail_of_doom_low]
(20962,4083,1,1,1,1926.1944),-- [leather_mail_of_doom_design]
(20962,1865,1,1,2,56821.062477),-- [varnish]
(20962,1870,1,1,2,56821.062477),-- [coal]
(20962,1879,1,1,2,9470.11249),-- [cokes]
(20962,1875,1,1,2,3788.044996),-- [stone_of_purity]
(20962,4040,1,1,2,1136.387663),-- [mold_lubricant]
(20962,5230,1,1,2,75.698894),-- [rp_mithril_arrow]
(20962,3956,1,1,2,75.698894),-- [rp_blessed_spiritshot_a]
(20962,8326,1,1,2,21.056177),-- [rp_doom_crusher_i]
(20962,8729,1,1,2,757.634835),-- [general_64_a]
(20962,8739,1,1,2,189.376414),-- [special_64_a]
(20962,8749,1,1,2,18.989313),-- [rare_64_a]
(20962,8759,1,1,2,3.87537),-- [unique_64_a]
(20963,4116,1,1,-1,9589),-- [deadman's_glory_stone]
(20963,5479,1,1,-1,12984),-- [sealed_tallum_leather_mail_pattern]
(20963,5478,1,1,-1,18452),-- [sealed_dark_crystal_leather_mail_pattern]
(20963,57,868,1764,0,700000),-- [adena]
(20963,12224,1,1,1,353.041969),-- [sealed_dark_crystal_boots_low]
(20963,5496,1,1,1,1899.708031),-- [sealed_dark_crystal_boots_lining]
(20963,12231,1,1,1,353.041969),-- [sealed_tallum_boots_low]
(20963,5497,1,1,1,1899.708031),-- [sealed_tallum_boots_lining]
(20963,12221,1,1,1,353.041969),-- [sealed_dark_crystal_gloves_low]
(20963,5508,1,1,1,1899.708031),-- [sealed_dark_crystal_gloves_design]
(20963,12229,1,1,1,353.041969),-- [sealed_tallum_gloves_low]
(20963,5509,1,1,1,1899.708031),-- [sealed_tallum_gloves_design]
(20963,1869,1,1,2,64815.97998),-- [iron_ore]
(20963,1864,1,1,2,129632.16502),-- [stem]
(20963,1880,1,1,2,6481.53648),-- [steel]
(20963,5550,1,1,2,864.12284),-- [reinforcing_plate]
(20963,4043,1,1,2,2160.51216),-- [asofe]
(20963,4984,1,1,2,183.5287),-- [rp_blue_wolve's_leather_mail_i]
(20963,8730,1,1,2,720.17072),-- [general_67_a]
(20963,8740,1,1,2,180.04268),-- [special_67_a]
(20963,8750,1,1,2,18.04528),-- [rare_67_a]
(20963,8760,1,1,2,3.89614),-- [unique_67_a]
(20965,4089,1,1,-1,230094),-- [doom_helmet_pattern]
(20965,5482,1,1,-1,80357),-- [sealed_legging_of_dark_crystal_design]
(20965,4043,1,1,-1,202943),-- [asofe]
(20965,57,3002,6130,0,700000),-- [adena]
(20965,12345,1,1,1,1446.571137),-- [sealed_phoenix's_earing_low]
(20965,6341,1,1,1,10362.734767),-- [sealed_phoenix's_earing_gemstone]
(20965,12344,1,1,1,1085.966508),-- [sealed_phoenix's_necklace_low]
(20965,6343,1,1,1,8010.780019),-- [sealed_phoenix's_necklace_beads]
(20965,12346,1,1,1,2171.970427),-- [sealed_phoenix's_ring_low]
(20965,6345,1,1,1,14332.977142),-- [sealed_phoenix's_ring_gemstone]
(20965,1869,1,1,2,224798.068656),-- [iron_ore]
(20965,1864,1,3,2,224798.068656),-- [stem]
(20965,1880,1,1,2,22480.001544),-- [steel]
(20965,5550,1,1,2,2997.073968),-- [reinforcing_plate]
(20965,4043,1,1,2,7493.171616),-- [asofe]
(20965,4161,1,1,2,932.996232),-- [rp_blue_wolve's_tunic]
(20965,8730,1,1,2,2497.723872),-- [general_67_a]
(20965,8740,1,1,2,624.430968),-- [special_67_a]
(20965,8750,1,1,2,62.297088),-- [rare_67_a]
(20965,8760,1,1,2,12.1674),-- [unique_67_a]
(20966,4085,1,1,-1,149386),-- [tunic_of_doom_pattern]
(20966,4044,1,1,-1,286523),-- [thons]
(20966,1894,1,1,-1,301603),-- [crafted_leather]
(20966,57,4242,8646,0,700000),-- [adena]
(20966,12222,1,1,1,768.27439),-- [sealed_dark_crystal_leather_mail_low]
(20966,5478,1,1,1,4447.96352),-- [sealed_dark_crystal_leather_mail_pattern]
(20966,12230,1,1,1,472.27596),-- [sealed_tallum_leather_mail_low]
(20966,5479,1,1,1,3129.89261),-- [sealed_tallum_leather_mail_pattern]
(20966,12228,1,1,1,1230.12799),-- [sealed_legging_of_dark_crystal_low]
(20966,5482,1,1,1,6981.46553),-- [sealed_legging_of_dark_crystal_design]
(20966,1894,1,1,2,11136.12838),-- [crafted_leather]
(20966,4039,1,1,2,10579.07232),-- [mold_glue]
(20966,4041,1,1,2,2759.95957),-- [mold_hardener]
(20966,4044,1,1,2,10579.07232),-- [thons]
(20966,4617,1,1,2,437.58501),-- [dye_d4s4_c]
(20966,6037,1,3,2,317376.44916),-- [scroll_of_awake]
(20966,8731,1,1,2,2938.6312),-- [general_70_a]
(20966,8741,1,1,2,734.6578),-- [special_70_a]
(20966,8751,1,1,2,73.46578),-- [rare_70_a]
(20966,8761,1,1,2,14.97846),-- [unique_70_a]
(20967,5485,1,1,-1,53992),-- [sealed_tallum_tunic_texture]
(20967,5156,1,1,-1,8561),-- [rp_comp_soulshot_a]
(20967,4041,1,1,-1,55832),-- [mold_hardener]
(20967,57,3159,6468,0,700000),-- [adena]
(20967,12345,1,1,1,1525.567818),-- [sealed_phoenix's_earing_low]
(20967,6341,1,1,1,10928.639638),-- [sealed_phoenix's_earing_gemstone]
(20967,12344,1,1,1,1145.270712),-- [sealed_phoenix's_necklace_low]
(20967,6343,1,1,1,8448.245566),-- [sealed_phoenix's_necklace_beads]
(20967,12346,1,1,1,2290.580878),-- [sealed_phoenix's_ring_low]
(20967,6345,1,1,1,15115.695388),-- [sealed_phoenix's_ring_gemstone]
(20967,1867,1,3,2,175609.124592),-- [animal_skin]
(20967,1872,1,3,2,117072.627111),-- [animal_bone]
(20967,1882,1,1,2,58536.497481),-- [leather]
(20967,1894,1,1,2,9242.624226),-- [crafted_leather]
(20967,4042,1,1,2,4390.301685),-- [enria]
(20967,5001,1,1,2,201.214497),-- [rp_lancia_i]
(20967,8732,1,1,2,2194.966917),-- [general_75_s]
(20967,8742,1,1,2,548.833692),-- [special_75_s]
(20967,8752,1,1,2,54.809799),-- [rare_75_s]
(20968,5486,1,1,-1,46360),-- [sealed_dark_crystal_robe_fabric]
(20968,5480,1,1,-1,35156),-- [sealed_leather_mail_of_nightmare_fabric]
(20968,5481,1,1,-1,35156),-- [sealed_majestic_leather_mail_fabric]
(20968,57,3864,7887,0,700000),-- [adena]
(20968,12224,1,1,1,1575.622664),-- [sealed_dark_crystal_boots_low]
(20968,5496,1,1,1,8478.377336),-- [sealed_dark_crystal_boots_lining]
(20968,12231,1,1,1,1575.622664),-- [sealed_tallum_boots_low]
(20968,5497,1,1,1,8478.377336),-- [sealed_tallum_boots_lining]
(20968,12221,1,1,1,1575.622664),-- [sealed_dark_crystal_gloves_low]
(20968,5508,1,1,1,8478.377336),-- [sealed_dark_crystal_gloves_design]
(20968,12229,1,1,1,1575.622664),-- [sealed_tallum_gloves_low]
(20968,5509,1,1,1,8478.377336),-- [sealed_tallum_gloves_design]
(20968,1868,1,3,2,262985.596155),-- [thread]
(20968,1873,1,1,2,105194.238462),-- [silver_nugget]
(20968,5549,1,1,2,26298.343332),-- [iron_thread]
(20968,1889,1,1,2,17532.373077),-- [compound_braid]
(20968,4044,1,1,2,8765.970255),-- [thons]
(20968,5007,1,1,2,200.711088),-- [rp_hazard_bow_i]
(20968,729,1,1,2,29.414556),-- [scrl_of_ench_wp_a]
(20968,8732,1,1,2,2191.384422),-- [general_75_s]
(20968,8742,1,1,2,548.062389),-- [special_75_s]
(20968,8752,1,1,2,54.936009),-- [rare_75_s]
(20968,6036,1,1,2,8765.970255),-- [potion_of_acumen3]
(20969,5161,1,1,-1,13821),-- [rp_comp_spiritshot_a]
(20969,5487,1,1,-1,46678),-- [sealed_robe_of_nightmare_fabric]
(20969,729,1,1,-1,1152),-- [scrl_of_ench_wp_a]
(20969,57,5111,10430,0,700000),-- [adena]
(20969,12267,1,1,1,1301.84632),-- [sealed_boots_of_nightmare_low]
(20969,5502,1,1,1,8080.15368),-- [sealed_boots_of_nightmare_lining]
(20969,12260,1,1,1,1301.84632),-- [sealed_magestic_boots_low]
(20969,5503,1,1,1,8080.15368),-- [sealed_magestic_boots_lining]
(20969,12264,1,1,1,1301.84632),-- [sealed_gloves_of_nightmare_low]
(20969,5514,1,1,1,8080.15368),-- [sealed_gloves_of_nightmare_design]
(20969,12257,1,1,1,1301.84632),-- [sealed_magestic_gloves_low]
(20969,5515,1,1,1,8080.15368),-- [sealed_magestic_gloves_design]
(20969,1894,1,1,2,16786.690002),-- [crafted_leather]
(20969,4039,1,1,2,15947.402502),-- [mold_glue]
(20969,4041,1,1,2,4160.18028),-- [mold_hardener]
(20969,4044,1,1,2,15947.402502),-- [thons]
(20969,4150,1,1,2,9218.129613),-- [rp_avadon_gloves]
(20969,8732,1,1,2,3986.817054),-- [general_75_s]
(20969,8742,1,1,2,996.737835),-- [special_75_s]
(20969,8752,1,1,2,99.640212),-- [rare_75_s]
(20970,5489,1,1,-1,82857),-- [sealed_tallum_hose_fabric]
(20970,1895,1,3,-1,896811),-- [metallic_fiber]
(20970,4042,1,1,-1,104628),-- [enria]
(20970,57,3100,6312,0,700000),-- [adena]
(20970,12224,1,1,1,1262.464917),-- [sealed_dark_crystal_boots_low]
(20970,5496,1,1,1,6793.285083),-- [sealed_dark_crystal_boots_lining]
(20970,12231,1,1,1,1262.464917),-- [sealed_tallum_boots_low]
(20970,5497,1,1,1,6793.285083),-- [sealed_tallum_boots_lining]
(20970,12221,1,1,1,1262.464917),-- [sealed_dark_crystal_gloves_low]
(20970,5508,1,1,1,6793.285083),-- [sealed_dark_crystal_gloves_design]
(20970,12229,1,1,1,1262.464917),-- [sealed_tallum_gloves_low]
(20970,5509,1,1,1,6793.285083),-- [sealed_tallum_gloves_design]
(20970,10581,1,1,2,12010),-- [sb_improve_condition]
(20970,10584,1,1,2,12010),-- [sb_improve_movement]
(20970,10609,1,1,2,12010),-- [sb_chant_of_critical]
(20970,14217,1,1,2,12010),-- [sb_condition_of_paagrio1]
(20971,1877,1,1,-1,266382),-- [admantite_nugget]
(20971,1876,1,3,-1,665954),-- [mithril_ore]
(20971,1895,1,5,-1,634242),-- [metallic_fiber]
(20971,57,3285,6703,0,700000),-- [adena]
(20971,12225,1,1,1,1700.46408),-- [sealed_dark_crystal_shield_low]
(20971,5494,1,1,1,8606.82896),-- [sealed_dark_crystal_shield_fragment]
(20971,12226,1,1,1,1191.31136),-- [sealed_dark_crystal_helmet_low]
(20971,5525,1,1,1,6335.02944),-- [sealed_dark_crystal_helmet_design]
(20971,12234,1,1,1,1191.31136),-- [sealed_tallum_bonnet_low]
(20971,5526,1,1,1,6335.0548),-- [sealed_tallum_bonnet_design]
(20971,12768,1,1,2,19671.5),-- [sb_evasion_counter1]
(20971,12769,1,1,2,19671.5),-- [sb_evasion_chance1]
(20972,4077,1,1,-1,310559),-- [doom_shield_fragment]
(20972,4087,1,1,-1,162002),-- [hose_of_doom_pattern]
(20972,5494,1,1,-1,144990),-- [sealed_dark_crystal_shield_fragment]
(20972,57,3405,6948,0,700000),-- [adena]
(20972,12224,1,1,1,1388.386223),-- [sealed_dark_crystal_boots_low]
(20972,5496,1,1,1,7470.863777),-- [sealed_dark_crystal_boots_lining]
(20972,12231,1,1,1,1388.386223),-- [sealed_tallum_boots_low]
(20972,5497,1,1,1,7470.863777),-- [sealed_tallum_boots_lining]
(20972,12221,1,1,1,1388.386223),-- [sealed_dark_crystal_gloves_low]
(20972,5508,1,1,1,7470.863777),-- [sealed_dark_crystal_gloves_design]
(20972,12229,1,1,1,1388.386223),-- [sealed_tallum_gloves_low]
(20972,5509,1,1,1,7470.863777),-- [sealed_tallum_gloves_design]
(20972,12771,1,1,2,20392.5),-- [sb_shadow_step1]
(20972,12770,1,1,2,20392.5),-- [sb_evasion_haste1]
(20973,4078,1,1,-1,128365),-- [blue_wolve's_breastplate_part]
(20973,5166,1,1,-1,11717),-- [rp_comp_bspiritshot_a]
(20973,5496,1,1,-1,206046),-- [sealed_dark_crystal_boots_lining]
(20973,57,4332,8850,0,700000),-- [adena]
(20973,12345,1,1,1,2088.018),-- [sealed_phoenix's_earing_low]
(20973,6341,1,1,1,14957.838),-- [sealed_phoenix's_earing_gemstone]
(20973,12344,1,1,1,1567.512),-- [sealed_phoenix's_necklace_low]
(20973,6343,1,1,1,11562.966),-- [sealed_phoenix's_necklace_beads]
(20973,12346,1,1,1,3135.078),-- [sealed_phoenix's_ring_low]
(20973,6345,1,1,1,20688.588),-- [sealed_phoenix's_ring_gemstone]
(20973,1872,1,3,2,180263.991168),-- [animal_bone]
(20973,1867,1,3,2,120175.994112),-- [animal_skin]
(20973,1881,1,1,2,36052.94301),-- [coarse_bone_powder]
(20973,1875,1,1,2,18026.471505),-- [stone_of_purity]
(20973,4041,1,1,2,2351.168736),-- [mold_hardener]
(20973,4982,1,1,2,1345.334697),-- [rp_blue_wolve's_gaiters_i]
(20973,4624,1,1,2,372.79923),-- [dye_w4m4_c]
(20973,8314,1,1,2,147.671928),-- [rp_eye_of_soul_i]
(20973,8731,1,1,2,2503.545897),-- [general_70_a]
(20973,8741,1,1,2,625.795989),-- [special_70_a]
(20973,8751,1,1,2,62.615793),-- [rare_70_a]
(20973,8761,1,1,2,12.667935),-- [unique_70_a]
(20974,5230,1,1,-1,6478),-- [rp_mithril_arrow]
(20974,4052,1,1,-1,172021),-- [earing_of_black_ore_piece]
(20974,57,1925,3904,0,700000),-- [adena]
(20974,268,1,1,1,14.22225),-- [bellion_cestus]
(20974,4120,1,1,1,3135.77775),-- [bellion_cestus_edge]
(20974,1871,1,1,2,130472.173904),-- [charcoal]
(20974,1866,1,1,2,86981.525808),-- [suede]
(20974,1877,1,1,2,5218.942064),-- [admantite_nugget]
(20974,4041,1,1,2,1134.532656),-- [mold_hardener]
(20974,4040,1,1,2,2609.356224),-- [mold_lubricant]
(20974,4164,1,1,2,864.045008),-- [rp_hose_of_doom]
(20974,730,1,1,2,108.837984),-- [scrl_of_ench_am_a]
(20974,8729,1,1,2,1739.570816),-- [general_64_a]
(20974,8739,1,1,2,434.892704),-- [special_64_a]
(20974,8749,1,1,2,43.397424),-- [rare_64_a]
(20974,8759,1,1,2,8.725408),-- [unique_64_a]
(20975,5230,1,1,-1,5745),-- [rp_mithril_arrow]
(20975,4078,1,1,-1,62938),-- [blue_wolve's_breastplate_part]
(20975,4053,1,1,-1,184685),-- [ring_of_black_ore_gemstone]
(20975,57,1709,3460,0,700000),-- [adena]
(20975,110,1,1,1,65.287158),-- [doom_shield]
(20975,4077,1,1,1,9542.81055),-- [doom_shield_fragment]
(20975,2416,1,1,1,45.703584),-- [blue_wolve's_helmet]
(20975,4088,1,1,1,8017.247562),-- [blue_wolve's_helmet_design]
(20975,2417,1,1,1,45.703584),-- [doom_helmet]
(20975,4089,1,1,1,8017.247562),-- [doom_helmet_pattern]
(20975,1866,1,1,2,77134.926962),-- [suede]
(20975,1871,1,1,2,115702.390443),-- [charcoal]
(20975,5220,1,1,2,4628.187966),-- [reinforcing_agent]
(20975,1885,1,1,2,9641.930001),-- [high_grade_suede]
(20975,4041,1,1,2,1006.083206),-- [mold_hardener]
(20975,1830,1,1,2,46280.853568),-- [scroll_of_escape_to_castle]
(20975,5276,1,1,2,154.170323),-- [rp_adv_comp_spiritshot_a]
(20975,8729,1,1,2,1542.729322),-- [general_64_a]
(20975,8739,1,1,2,385.554069),-- [special_64_a]
(20975,8749,1,1,2,38.47845),-- [rare_64_a]
(20975,8759,1,1,2,7.69569),-- [unique_64_a]
(20976,4080,1,1,-1,75035),-- [blue_wolve's_gaiters_material]
(20976,5230,1,1,-1,4864),-- [rp_mithril_arrow]
(20976,4054,1,1,-1,71850),-- [necklace_of_black_ore_beads]
(20976,57,1447,2930,0,700000),-- [adena]
(20976,358,1,1,1,14.51284),-- [blue_wolve's_breastplate]
(20976,4078,1,1,1,2623.561905),-- [blue_wolve's_breastplate_part]
(20976,2381,1,1,1,8.93223),-- [doom_plate_armor]
(20976,4081,1,1,1,1770.249215),-- [doom_plate_armor_temper]
(20976,2380,1,1,1,23.21729),-- [blue_wolve's_gaiters]
(20976,4080,1,1,1,3694.52652),-- [blue_wolve's_gaiters_material]
(20976,1867,1,1,2,119724.213714),-- [animal_skin]
(20976,1872,1,1,2,119724.213714),-- [animal_bone]
(20976,1882,1,1,2,19953.969936),-- [leather]
(20976,1894,1,1,2,3150.81351),-- [crafted_leather]
(20976,4042,1,1,2,1496.390106),-- [enria]
(20976,5230,1,1,2,119.805792),-- [rp_mithril_arrow]
(20976,5276,1,1,2,119.805792),-- [rp_adv_comp_spiritshot_a]
(20976,8729,1,1,2,1197.269724),-- [general_64_a]
(20976,8739,1,1,2,299.120382),-- [special_64_a]
(20976,8749,1,1,2,29.951448),-- [rare_64_a]
(20976,8759,1,1,2,5.91147),-- [unique_64_a]
(20976,1343,10,30,2,128276.534412),-- [silver_arrow]
(20977,947,1,1,-1,2297),-- [scrl_of_ench_wp_b]
(20977,1876,1,3,-1,574367),-- [mithril_ore]
(20977,4052,1,1,-1,203352),-- [earing_of_black_ore_piece]
(20977,57,2276,4615,0,700000),-- [adena]
(20977,864,1,1,1,79.54051),-- [earing_of_black_ore]
(20977,4052,1,1,1,10010.64148),-- [earing_of_black_ore_piece]
(20977,926,1,1,1,59.662372),-- [necklace_of_black_ore]
(20977,4054,1,1,1,5569.2336),-- [necklace_of_black_ore_beads]
(20977,895,1,1,1,119.296786),-- [ring_of_black_ore]
(20977,4053,1,1,1,12119.625252),-- [ring_of_black_ore_gemstone]
(20977,1871,1,1,2,154235.660703),-- [charcoal]
(20977,1866,1,1,2,102823.864281),-- [suede]
(20977,1877,1,1,2,6169.491573),-- [admantite_nugget]
(20977,4041,1,1,2,1341.170217),-- [mold_hardener]
(20977,4040,1,1,2,3084.610068),-- [mold_lubricant]
(20977,4164,1,1,2,1021.417431),-- [rp_hose_of_doom]
(20977,730,1,1,2,128.661138),-- [scrl_of_ench_am_a]
(20977,8729,1,1,2,2056.406712),-- [general_64_a]
(20977,8739,1,1,2,514.101678),-- [special_64_a]
(20977,8749,1,1,2,51.301593),-- [rare_64_a]
(20977,8759,1,1,2,10.314606),-- [unique_64_a]
(20978,5230,1,1,-1,8195),-- [rp_mithril_arrow]
(20978,4081,1,1,-1,60581),-- [doom_plate_armor_temper]
(20978,57,2440,4935,0,700000),-- [adena]
(20978,79,1,1,1,5.99697),-- [sword_of_damascus]
(20978,4114,1,1,1,1324.74384),-- [sword_of_damascus_blade]
(20978,7883,1,1,1,5.99697),-- [guardians_sword]
(20978,8330,1,1,1,1322.51742),-- [guardians_sword_blade]
(20978,7889,1,1,1,5.99697),-- [tears_of_wizard]
(20978,8336,1,1,1,1324.74783),-- [tears_of_wizard_blade]
(20978,1868,1,1,2,330107.489394),-- [thread]
(20978,1873,1,1,2,66021.697158),-- [silver_nugget]
(20978,5549,1,1,2,16505.29974),-- [iron_thread]
(20978,1889,1,1,2,11003.699226),-- [compound_braid]
(20978,4044,1,1,2,5501.600514),-- [thons]
(20978,1830,1,1,2,66021.697158),-- [scroll_of_escape_to_castle]
(20978,3956,1,1,2,220.203516),-- [rp_blessed_spiritshot_a]
(20978,8729,1,1,2,2200.540566),-- [general_64_a]
(20978,8739,1,1,2,550.010592),-- [special_64_a]
(20978,8749,1,1,2,54.80178),-- [rare_64_a]
(20978,8759,1,1,2,10.960356),-- [unique_64_a]
(20979,4082,1,1,-1,61486),-- [blue_wolve's_leather_mail_texture]
(20979,5550,1,1,-1,72554),-- [reinforcing_plate]
(20979,57,2160,4369,0,700000),-- [adena]
(20979,171,1,1,1,5.309912),-- [deadman's_glory]
(20979,4116,1,1,1,1170.530588),-- [deadman's_glory_stone]
(20979,175,1,1,1,5.309912),-- [art_of_battle_axe]
(20979,4117,1,1,1,1170.530588),-- [art_of_battle_axe_blade]
(20979,210,1,1,1,5.309912),-- [staff_of_evil_sprit]
(20979,4118,1,1,1,1109.009088),-- [staff_of_evil_sprit_head]
(20979,1869,1,1,2,133945.27398),-- [iron_ore]
(20979,1864,1,3,2,133945.27398),-- [stem]
(20979,1880,1,1,2,13394.72001),-- [steel]
(20979,5550,1,1,2,1785.99477),-- [reinforcing_plate]
(20979,4043,1,1,2,4464.74616),-- [asofe]
(20979,5230,1,1,2,178.64763),-- [rp_mithril_arrow]
(20979,5276,1,1,2,178.64763),-- [rp_adv_comp_spiritshot_a]
(20979,8729,1,1,2,1785.99477),-- [general_64_a]
(20979,8739,1,1,2,446.37831),-- [special_64_a]
(20979,8749,1,1,2,44.78229),-- [rare_64_a]
(20979,8759,1,1,2,9.14907),-- [unique_64_a]
(20979,1343,10,30,2,191350.3914),-- [silver_arrow]
(20980,4041,1,1,-1,55038),-- [mold_hardener]
(20980,4039,1,1,-1,210979),-- [mold_glue]
(20980,4085,1,1,-1,109999),-- [tunic_of_doom_pattern]
(20980,57,2504,5090,0,700000),-- [adena]
(20980,5287,1,1,1,17.495295),-- [sealed_dark_crystal_breastplate]
(20980,5520,1,1,1,2009.454915),-- [sealed_dark_crystal_breastplate_pattern]
(20980,5293,1,1,1,10.769865),-- [sealed_tallum_plate_armor]
(20980,5521,1,1,1,1417.95138),-- [sealed_tallum_plate_armor_pattern]
(20980,5288,1,1,1,27.996405),-- [sealed_dark_crystal_gaiters]
(20980,5524,1,1,1,3071.33214),-- [sealed_dark_crystal_gaiters_pattern]
(20980,1869,2,6,2,42490.85418),-- [iron_ore]
(20980,1870,2,6,2,33992.50803),-- [coal]
(20980,1871,1,1,2,169962.54015),-- [charcoal]
(20980,1872,1,3,2,113308.506195),-- [animal_bone]
(20980,1867,1,3,2,75538.858035),-- [animal_skin]
(20980,4985,1,1,2,481.675215),-- [rp_leather_mail_of_doom_i]
(20980,8314,1,1,2,92.91642),-- [rp_eye_of_soul_i]
(20980,8730,1,1,2,1888.570065),-- [general_67_a]
(20980,8740,1,1,2,472.032945),-- [special_67_a]
(20980,8750,1,1,2,47.33478),-- [rare_67_a]
(20980,8760,1,1,2,9.203985),-- [unique_67_a]
(20981,4083,1,1,-1,67397),-- [leather_mail_of_doom_design]
(20981,5230,1,1,-1,7953),-- [rp_mithril_arrow]
(20981,4085,1,1,-1,103660),-- [tunic_of_doom_pattern]
(20981,57,2351,4805,0,700000),-- [adena]
(20981,358,1,1,1,23.728984),-- [blue_wolve's_breastplate]
(20981,4078,1,1,1,4289.612403),-- [blue_wolve's_breastplate_part]
(20981,2381,1,1,1,14.604498),-- [doom_plate_armor]
(20981,4081,1,1,1,2894.417309),-- [doom_plate_armor_temper]
(20981,2380,1,1,1,37.961054),-- [blue_wolve's_gaiters]
(20981,4080,1,1,1,6040.675752),-- [blue_wolve's_gaiters_material]
(20981,1869,1,1,2,160168.355966),-- [iron_ore]
(20981,1864,1,3,2,160168.355966),-- [stem]
(20981,1880,1,1,2,16016.999701),-- [steel]
(20981,5550,1,1,2,2135.408505),-- [reinforcing_plate]
(20981,4043,1,1,2,5339.136654),-- [asofe]
(20981,1830,1,1,2,64067.178282),-- [scroll_of_escape_to_castle]
(20981,8487,1,1,2,87.385593),-- [rp_hammer_of_destroyer_i]
(20981,8730,1,1,2,1779.712218),-- [general_67_a]
(20981,8740,1,1,2,444.722924),-- [special_67_a]
(20981,8750,1,1,2,44.308188),-- [rare_67_a]
(20981,8760,1,1,2,9.436003),-- [unique_67_a]
(20982,4084,1,1,-1,96257),-- [blue_wolve's_tunic_fabric]
(20982,5418,1,1,-1,8181),-- [rp_sealed_tallum_plate_armor_i]
(20982,4085,1,1,-1,96257),-- [tunic_of_doom_pattern]
(20982,57,2184,4462,0,700000),-- [adena]
(20982,2398,1,1,1,22.025234),-- [blue_wolve's_tunic]
(20982,4084,1,1,1,3555.266496),-- [blue_wolve's_tunic_fabric]
(20982,2399,1,1,1,22.025234),-- [tunic_of_doom]
(20982,4085,1,1,1,3555.266496),-- [tunic_of_doom_pattern]
(20982,2403,1,1,1,35.267296),-- [blue_wolve's_hose]
(20982,4086,1,1,1,4800.424148),-- [blue_wolve's_hose_pattern]
(20982,2404,1,1,1,35.267296),-- [hose_of_doom]
(20982,4087,1,1,1,4800.4578),-- [hose_of_doom_pattern]
(20982,1869,1,1,2,136335.691248),-- [iron_ore]
(20982,1864,1,3,2,136335.691248),-- [stem]
(20982,1880,1,1,2,13633.406716),-- [steel]
(20982,5550,1,1,2,1817.760494),-- [reinforcing_plate]
(20982,4043,1,1,2,4544.604246),-- [asofe]
(20982,1830,1,1,2,54534.438908),-- [scroll_of_escape_to_castle]
(20982,8487,1,1,2,74.302026),-- [rp_hammer_of_destroyer_i]
(20982,8730,1,1,2,1514.868082),-- [general_67_a]
(20982,8740,1,1,2,378.818526),-- [special_67_a]
(20982,8750,1,1,2,37.760046),-- [rare_67_a]
(20982,8760,1,1,2,7.714418),-- [unique_67_a]
(20982,1344,30,90,2,56806.944042),-- [mithril_arrow]
(20983,4080,1,1,-1,136641),-- [blue_wolve's_gaiters_material]
(20983,5549,1,1,-1,664283),-- [iron_thread]
(20983,5478,1,1,-1,55860),-- [sealed_dark_crystal_leather_mail_pattern]
(20983,57,3280,6679,0,700000),-- [adena]
(20983,5297,1,1,1,30.608253),-- [sealed_dark_crystal_leather_mail]
(20983,5478,1,1,1,3437.124093),-- [sealed_dark_crystal_leather_mail_pattern]
(20983,5301,1,1,1,18.827991),-- [sealed_tallum_leather_mail]
(20983,5479,1,1,1,2418.596739),-- [sealed_tallum_leather_mail_pattern]
(20983,5298,1,1,1,48.948237),-- [sealed_legging_of_dark_crystal]
(20983,5482,1,1,1,5394.894687),-- [sealed_legging_of_dark_crystal_design]
(20983,1867,1,3,2,148650.69776),-- [animal_skin]
(20983,1872,1,3,2,99100.56912),-- [animal_bone]
(20983,1882,1,1,2,49550.12864),-- [leather]
(20983,1894,1,1,2,7823.75376),-- [crafted_leather]
(20983,4042,1,1,2,3716.19728),-- [enria]
(20983,4199,1,1,2,170.26464),-- [rp_hazard_bow]
(20983,730,1,1,2,185.85664),-- [scrl_of_ench_am_a]
(20983,8731,1,1,2,2064.69264),-- [general_70_a]
(20983,8741,1,1,2,516.0952),-- [special_70_a]
(20983,8751,1,1,2,51.76544),-- [rare_70_a]
(20983,8761,1,1,2,9.97888),-- [unique_70_a]
(20984,5478,1,1,-1,51267),-- [sealed_dark_crystal_leather_mail_pattern]
(20984,4041,1,1,-1,53015),-- [mold_hardener]
(20984,57,3006,6139,0,700000),-- [adena]
(20984,5304,1,1,1,28.091952),-- [sealed_tallum_tunic]
(20984,5485,1,1,1,3154.558512),-- [sealed_tallum_tunic_texture]
(20984,5308,1,1,1,17.280144),-- [sealed_dark_crystal_robe]
(20984,5486,1,1,1,2219.764176),-- [sealed_dark_crystal_robe_fabric]
(20984,5305,1,1,1,44.924208),-- [sealed_tallum_hose]
(20984,5489,1,1,1,4951.381008),-- [sealed_tallum_hose_fabric]
(20984,1870,1,1,2,187591.547868),-- [coal]
(20984,1865,1,1,2,187591.547868),-- [varnish]
(20984,1874,1,1,2,12506.022528),-- [oriharukon_ore]
(20984,4043,1,1,2,6253.011264),-- [asofe]
(20984,4039,1,1,2,6253.011264),-- [mold_glue]
(20984,5156,1,1,2,250.05592),-- [rp_comp_soulshot_a]
(20984,729,1,1,2,20.972432),-- [scrl_of_ench_wp_a]
(20984,5420,1,1,2,182.298832),-- [rp_sealed_armor_of_nightmare_i]
(20984,8730,1,1,2,2084.337088),-- [general_67_a]
(20984,8740,1,1,2,521.084272),-- [special_67_a]
(20984,8750,1,1,2,52.027764),-- [rare_67_a]
(20984,8760,1,1,2,10.0829),-- [unique_67_a]
(20985,1807,1,1,-1,8655),-- [rp_soulshot_a]
(20985,5479,1,1,-1,38410),-- [sealed_tallum_leather_mail_pattern]
(20985,3035,1,1,-1,8655),-- [rp_spiritshot_a]
(20985,57,3201,6536,0,700000),-- [adena]
(20985,6324,1,1,1,79.494664),-- [sealed_phoenix's_earing]
(20985,6341,1,1,1,11048.10728),-- [sealed_phoenix's_earing_gemstone]
(20985,6323,1,1,1,59.612216),-- [sealed_phoenix's_necklace]
(20985,6343,1,1,1,8540.600384),-- [sealed_phoenix's_necklace_beads]
(20985,6325,1,1,1,119.224432),-- [sealed_phoenix's_ring]
(20985,6345,1,1,1,15280.961024),-- [sealed_phoenix's_ring_gemstone]
(20985,1871,1,3,2,72629.206225),-- [charcoal]
(20985,1866,1,1,2,145258.41245),-- [suede]
(20985,1877,1,1,2,8715.48985),-- [admantite_nugget]
(20985,4041,1,1,2,1894.525975),-- [mold_hardener]
(20985,4040,1,1,2,4357.744925),-- [mold_lubricant]
(20985,5161,1,1,2,290.4915),-- [rp_comp_spiritshot_a]
(20985,8730,1,1,2,2421.134925),-- [general_67_a]
(20985,8740,1,1,2,605.190625),-- [special_67_a]
(20985,8750,1,1,2,60.705275),-- [rare_67_a]
(20985,8760,1,1,2,12.290025),-- [unique_67_a]
(20985,1344,20,60,2,136179.808225),-- [mithril_arrow]
(20986,1984,1,1,-1,95413),-- [theca_leather_mail_pattern]
(20986,4043,1,1,-1,148367),-- [asofe]
(20986,1806,1,1,-1,8902),-- [rp_soulshot_b]
(20986,57,1758,3581,0,700000),-- [adena]
(20986,2497,1,1,1,284.530887),-- [full_plate_shield]
(20986,2966,1,1,1,22482.996417),-- [full_plate_shield_fragment]
(20986,2414,1,1,1,199.167903),-- [full_plate_helmet]
(20986,2959,1,1,1,14212.304793),-- [full_plate_helmet_design]
(20986,1894,1,1,2,5242.291475),-- [crafted_leather]
(20986,4039,1,1,2,4980.167415),-- [mold_glue]
(20986,4041,1,1,2,1299.16091),-- [mold_hardener]
(20986,4044,1,1,2,4980.167415),-- [thons]
(20986,4180,1,1,2,16600.55805),-- [rp_silver_arrow]
(20986,4184,1,1,2,172.11852),-- [rp_sprite's_staff]
(20986,5436,1,1,2,243.720735),-- [rp_berserker_blade]
(20986,8726,1,1,2,3458.45908),-- [general_55_c]
(20986,8736,1,1,2,864.61477),-- [special_55_c]
(20986,8746,1,1,2,86.476655),-- [rare_55_c]
(20986,8756,1,1,2,17.264975),-- [unique_55_c]
(20987,1918,1,1,-1,174977),-- [nassen's_earing_gemstone]
(20987,4039,1,1,-1,134674),-- [mold_glue]
(20987,1864,1,17,-1,897829),-- [stem]
(20987,57,1599,3249,0,700000),-- [adena]
(20987,301,1,1,1,13.521856),-- [scorpion]
(20987,2113,1,1,1,1204.200775),-- [scorpion_blade]
(20987,303,1,1,1,13.521856),-- [widow_maker]
(20987,2114,1,1,1,1204.200775),-- [widow_maker_head]
(20987,299,1,1,1,10.549626),-- [orcish_poleaxe]
(20987,2122,1,1,1,1135.005112),-- [orcish_poleaxe_blade]
(20987,1864,1,3,2,124314.583522),-- [stem]
(20987,1869,1,1,2,124314.583522),-- [iron_ore]
(20987,1878,1,1,2,49725.756723),-- [braided_hemp]
(20987,1884,1,1,2,76501.370651),-- [cord]
(20987,4039,1,1,2,4143.717203),-- [mold_glue]
(20987,3034,1,1,2,248.461992),-- [rp_spiritshot_b]
(20987,5270,1,1,2,248.461992),-- [rp_adv_comp_soulshot_b]
(20987,3955,1,1,2,248.461992),-- [rp_blessed_spiritshot_b]
(20987,8726,1,1,2,2877.634645),-- [general_55_c]
(20987,8736,1,1,2,719.312804),-- [special_55_c]
(20987,8746,1,1,2,72.084652),-- [rare_55_c]
(20987,8756,1,1,2,14.570302),-- [unique_55_c]
(20988,1920,1,1,-1,152063),-- [necklace_of_binding_chain]
(20988,1806,1,1,-1,8888),-- [rp_soulshot_b]
(20988,1984,1,1,-1,95264),-- [theca_leather_mail_pattern]
(20988,57,1759,3573,0,700000),-- [adena]
(20988,400,1,1,1,86.136814),-- [theca_leather_mail]
(20988,1984,1,1,1,5862.097499),-- [theca_leather_mail_pattern]
(20988,401,1,1,1,40.779843),-- [drake_leather_mail]
(20988,1987,1,1,1,4172.210004),-- [drake_leather_mail_texture]
(20988,420,1,1,1,137.866252),-- [theca_leather_gaiters]
(20988,1985,1,1,1,9429.909588),-- [theca_leather_gaiters_pattern]
(20988,1865,1,1,2,136739.952216),-- [varnish]
(20988,1870,1,1,2,136739.952216),-- [coal]
(20988,1879,1,1,2,22790.150088),-- [cokes]
(20988,1875,1,1,2,9116.123256),-- [stone_of_purity]
(20988,4040,1,1,2,2734.931808),-- [mold_lubricant]
(20988,3955,1,1,2,273.42996),-- [rp_blessed_spiritshot_b]
(20988,5270,1,1,2,273.42996),-- [rp_adv_comp_soulshot_b]
(20988,4127,1,1,2,3384.525528),-- [rp_adamantite_ring]
(20988,8726,1,1,2,3165.149352),-- [general_55_c]
(20988,8736,1,1,2,791.208312),-- [special_55_c]
(20988,8746,1,1,2,79.026),-- [rare_55_c]
(20988,8756,1,1,2,16.121304),-- [unique_55_c]
(20989,1825,1,1,-1,77195),-- [rp_oriharukon]
(20989,1902,1,1,-1,109496),-- [elven_earing_beads]
(20989,1871,1,3,-1,540365),-- [charcoal]
(20989,57,457,912,0,700000),-- [adena]
(20989,352,1,1,1,81.068852),-- [brigandine]
(20989,1941,1,1,1,3702.742851),-- [brigandine_temper]
(20989,2377,1,1,1,129.676963),-- [mithril_scale_gaiters]
(20989,2918,1,1,1,5523.924731),-- [mithril_scale_gaiters_material]
(20989,2378,1,1,1,129.676963),-- [brigandine_gaiters]
(20989,2919,1,1,1,5523.90964),-- [brigandine_gaiters_material]
(20989,1866,1,1,2,62072.612958),-- [suede]
(20989,1871,1,1,2,93108.829454),-- [charcoal]
(20989,5220,1,1,2,3724.39637),-- [reinforcing_agent]
(20989,1885,1,1,2,7759.054124),-- [high_grade_suede]
(20989,2146,1,1,2,6650.64353),-- [rp_artisan's_frame]
(20989,5473,1,1,2,6650.463564),-- [rp_reinforcing_plate]
(20990,1882,1,1,-1,227993),-- [leather]
(20990,1903,1,1,-1,171137),-- [elven_ring_piece]
(20990,2145,1,1,-1,73283),-- [rp_mithirl_alloy]
(20990,57,434,866,0,700000),-- [adena]
(20990,437,1,1,1,154.167822),-- [mithril_tunic]
(20990,1944,1,1,1,6762.752964),-- [mithril_tunic_fabric]
(20990,470,1,1,1,246.21201),-- [mithril_hose]
(20990,1945,1,1,1,10530.867204),-- [mithril_hose_design]
(20990,1867,1,1,2,101018.567302),-- [animal_skin]
(20990,1872,1,1,2,101018.567302),-- [animal_bone]
(20990,1882,1,1,2,16836.50909),-- [leather]
(20990,1894,1,1,2,2658.370528),-- [crafted_leather]
(20990,2147,1,1,2,5411.752466),-- [rp_blacksmith's_frame]
(20990,2194,1,1,2,7746.596962),-- [rp_mithril_glove]
(20990,1341,10,30,2,252547.63635),-- [bone_arrow]
(20991,2064,1,1,-1,31742),-- [war_pick_head]
(20991,1908,1,1,-1,388880),-- [moonstone_earing_wire]
(20991,1909,1,1,-1,554567),-- [aquastone_ring_wire]
(20991,57,1624,3299,0,700000),-- [adena]
(20991,354,1,1,1,249.723584),-- [chain_mail_shirt]
(20991,1959,1,1,1,13069.055648),-- [chain_mail_shirt_material]
(20991,381,1,1,1,399.493248),-- [chain_gaiters]
(20991,1960,1,1,1,26585.72752),-- [chain_gaiters_part]
(20991,1875,1,1,2,11762.627883),-- [stone_of_purity]
(20991,1879,1,1,2,29406.526596),-- [cokes]
(20991,1885,1,1,2,14703.263298),-- [high_grade_suede]
(20991,5550,1,1,2,2352.508332),-- [reinforcing_plate]
(20991,5549,1,1,2,17643.898713),-- [iron_thread]
(20991,4556,1,1,2,705.735255),-- [dye_c1c1_c]
(20991,3021,1,1,2,614.76999),-- [rp_dwarven_warhammer]
(20991,8723,1,1,2,7057.524996),-- [general_46_c]
(20991,8733,1,1,2,1764.381249),-- [special_46_c]
(20991,8743,1,1,2,176.412258),-- [rare_46_c]
(20991,8753,1,1,2,35.35143),-- [unique_46_c]
(20992,1908,1,1,-1,347561),-- [moonstone_earing_wire]
(20992,2163,1,1,-1,187257),-- [rp_earing_of_protection]
(20992,1909,1,1,-1,495644),-- [aquastone_ring_wire]
(20992,57,1445,2961,0,700000),-- [adena]
(20992,852,1,1,1,484.662831),-- [moonstone_earing]
(20992,1908,1,1,1,27378.64731),-- [moonstone_earing_wire]
(20992,915,1,1,1,363.654219),-- [aquastone_necklace]
(20992,1910,1,1,1,21770.957418),-- [aquastone_necklace_chain]
(20992,883,1,1,1,727.308438),-- [aquastone_ring]
(20992,1909,1,1,1,39043.769784),-- [aquastone_ring_wire]
(20992,1868,1,1,2,346922.71589),-- [thread]
(20992,1873,1,1,2,69384.543178),-- [silver_nugget]
(20992,5549,1,1,2,17346.252806),-- [iron_thread]
(20992,1889,1,1,2,11564.012522),-- [compound_braid]
(20992,2164,1,1,2,13343.055368),-- [rp_ring_of_protection]
(20992,2319,1,1,2,604.247386),-- [rp_raid_sword]
(20992,8723,1,1,2,6938.313904),-- [general_46_c]
(20992,8733,1,1,2,1734.578476),-- [special_46_c]
(20992,8743,1,1,2,173.645066),-- [rare_46_c]
(20992,8753,1,1,2,34.635404),-- [unique_46_c]
(20993,1869,1,9,-1,778937),-- [iron_ore]
(20993,1864,1,17,-1,865485),-- [stem]
(20993,2163,1,1,-1,198708),-- [rp_earing_of_protection]
(20993,57,1533,3142,0,700000),-- [adena]
(20993,62,1,1,1,210.629136),-- [mithril_boots]
(20993,1958,1,1,1,9192.028128),-- [mithril_boots_design]
(20993,2429,1,1,1,210.629136),-- [chain_boots]
(20993,2937,1,1,1,9192.028128),-- [chain_boots_part]
(20993,2430,1,1,1,210.629136),-- [karmian_boots]
(20993,2938,1,1,1,9192.028128),-- [karmian_boots_fabric]
(20993,2431,1,1,1,210.629136),-- [plate_leather_boots]
(20993,2939,1,1,1,9192.028128),-- [plate_leather_boots_lining]
(20993,2432,1,1,1,210.629136),-- [dwarven_chain_boots]
(20993,2940,1,1,1,9192.028128),-- [dwarven_chain_boots_part]
(20993,2433,1,1,1,210.629136),-- [boots_of_seal]
(20993,2941,1,1,1,9192.028128),-- [boots_of_seal_pattern]
(20993,2452,1,1,1,210.629136),-- [reinforce_mithril_gloves]
(20993,2942,1,1,1,9192.028128),-- [reinforce_mithril_gloves_design]
(20993,2453,1,1,1,210.629136),-- [chain_gloves]
(20993,2943,1,1,1,9192.028128),-- [chain_gloves_design]
(20993,2454,1,1,1,210.629136),-- [karmian_gloves]
(20993,2944,1,1,1,9192.112752),-- [karmian_gloves_fabric]
(20993,1869,1,1,2,184068.875197),-- [iron_ore]
(20993,1864,1,3,2,184068.875197),-- [stem]
(20993,1880,1,1,2,18406.846908),-- [steel]
(20993,5550,1,1,2,2454.165031),-- [reinforcing_plate]
(20993,2165,1,1,2,7052.627822),-- [rp_necklace_of_protection]
(20993,2318,1,1,2,641.258743),-- [rp_spirits_sword]
(20993,8723,1,1,2,7362.90121),-- [general_46_c]
(20993,8733,1,1,2,1840.522244),-- [special_46_c]
(20993,8743,1,1,2,183.971001),-- [rare_46_c]
(20993,8753,1,1,2,36.956647),-- [unique_46_c]
(20994,4043,1,1,-1,148005),-- [asofe]
(20994,4044,1,1,-1,148005),-- [thons]
(20994,2169,1,1,-1,78587),-- [rp_necklace_of_binding]
(20994,57,1756,3570,0,700000),-- [adena]
(20994,265,1,1,1,55.568302),-- [fist_blade]
(20994,2108,1,1,1,4917.431698),-- [fist_blade_piece]
(20994,1894,1,1,2,5857.07314),-- [crafted_leather]
(20994,4039,1,1,2,5564.22965),-- [mold_glue]
(20994,4041,1,1,2,1451.54259),-- [mold_hardener]
(20994,4044,1,1,2,5564.22965),-- [thons]
(20994,3015,1,1,2,4662.75565),-- [rp_drake_leather_gloves]
(20994,4186,1,1,2,192.32575),-- [rp_sword_of_valhalla]
(20994,3016,1,1,2,4662.75565),-- [rp_full_plate_gauntlet]
(20994,8725,1,1,2,4636.8298),-- [general_52_c]
(20994,8735,1,1,2,1159.20745),-- [special_52_c]
(20994,8745,1,1,2,115.93769),-- [rare_52_c]
(20994,8755,1,1,2,23.11298),-- [unique_52_c]
(20995,1911,1,1,-1,250980),-- [earing_of_protection_gemstone]
(20995,2166,1,1,-1,114387),-- [rp_earing_of_binding]
(20995,1966,1,1,-1,123199),-- [plate_leather_fragment]
(20995,57,1334,2712,0,700000),-- [adena]
(20995,2496,1,1,1,414.964881),-- [dwarven_chain_shield]
(20995,2947,1,1,1,17798.409681),-- [dwarven_chain_shield_fragment]
(20995,632,1,1,1,383.073611),-- [knight_shield]
(20995,1972,1,1,1,19934.20587),-- [knight_shield_fragment]
(20995,500,1,1,1,268.210986),-- [great_helmet]
(20995,1971,1,1,1,15254.134971),-- [great_helmet_material]
(20995,1870,1,1,2,135920.991656),-- [coal]
(20995,1865,1,1,2,135920.991656),-- [varnish]
(20995,1874,1,1,2,9061.355868),-- [oriharukon_ore]
(20995,4043,1,1,2,4530.677934),-- [asofe]
(20995,4039,1,1,2,4530.677934),-- [mold_glue]
(20995,2222,1,1,2,849.399982),-- [rp_composite_armor]
(20995,8724,1,1,2,4530.677934),-- [general_49_c]
(20995,8734,1,1,2,1132.751188),-- [special_49_c]
(20995,8744,1,1,2,113.405846),-- [rare_49_c]
(20995,8754,1,1,2,22.550442),-- [unique_49_c]
(20995,1539,1,1,2,30204.51956),-- [greater_healing_potion]
(20996,1914,1,1,-1,95679),-- [earing_of_binding_gemstone]
(20996,1864,1,7,-1,851546),-- [stem]
(20996,1869,1,3,-1,851546),-- [iron_ore]
(20996,57,674,1369,0,700000),-- [adena]
(20996,265,1,1,1,21.319992),-- [fist_blade]
(20996,2108,1,1,1,1886.680008),-- [fist_blade_piece]
(20996,1864,1,1,2,128053.300403),-- [stem]
(20996,1869,1,1,2,64026.782373),-- [iron_ore]
(20996,1878,1,1,2,25610.607212),-- [braided_hemp]
(20996,1884,1,1,2,39401.117179),-- [cord]
(20996,4039,1,1,2,2134.305382),-- [mold_glue]
(20996,2169,1,1,2,1133.238441),-- [rp_necklace_of_binding]
(20996,3019,1,1,2,1707.391437),-- [rp_full_plate_shield]
(20996,8725,1,1,2,1778.499704),-- [general_52_c]
(20996,8735,1,1,2,444.624926),-- [special_52_c]
(20996,8745,1,1,2,44.409624),-- [rare_52_c]
(20996,8755,1,1,2,8.723319),-- [unique_52_c]
(20997,4601,1,1,-1,3371),-- [dye_s3c3_c]
(20997,1539,1,1,-1,337056),-- [greater_healing_potion]
(20997,1915,1,1,-1,133634),-- [ring_of_ages_gemstone]
(20997,57,601,1220,0,700000),-- [adena]
(20997,60,1,1,1,51.11631),-- [composite_armor]
(20997,1977,1,1,1,4638.88369),-- [composite_armor_temper]
(20997,1873,1,1,2,22808.54148),-- [silver_nugget]
(20997,1868,1,1,2,114042.877334),-- [thread]
(20997,1876,1,1,2,11404.27074),-- [mithril_ore]
(20997,1895,1,1,2,16291.912448),-- [metallic_fiber]
(20997,4042,1,1,2,950.440862),-- [enria]
(20997,2170,1,1,2,1344.857676),-- [rp_nassen's_earing]
(20997,3012,1,1,2,1063.78684),-- [rp_full_plate_helmet]
(20997,8725,1,1,2,1583.954814),-- [general_52_c]
(20997,8735,1,1,2,395.94622),-- [special_52_c]
(20997,8745,1,1,2,39.594622),-- [rare_52_c]
(20997,8755,1,1,2,7.816964),-- [unique_52_c]
(20998,2169,1,1,-1,29606),-- [rp_necklace_of_binding]
(20998,1916,1,1,-1,71182),-- [necklace_of_mermaid_teardrop]
(20998,2170,1,1,-1,39452),-- [rp_nassen's_earing]
(20998,57,664,1343,0,700000),-- [adena]
(20998,162,1,1,1,2.617434),-- [war_axe]
(20998,2097,1,1,1,231.636168),-- [war_axe_blade]
(20998,174,1,1,1,2.617434),-- [nirvana_axe]
(20998,2098,1,1,1,231.636168),-- [nirvana_axe_blade]
(20998,196,1,1,1,2.617434),-- [stick_of_eternity]
(20998,2099,1,1,1,243.779598),-- [stick_of_eternity_shaft]
(20998,197,1,1,1,2.617434),-- [paradia_staff]
(20998,2100,1,1,1,243.779598),-- [paradia_staff_head]
(20998,199,1,1,1,2.617434),-- [paagrio_hammer]
(20998,2102,1,1,1,235.035558),-- [paagrio_hammer_head]
(20998,200,1,1,1,2.617434),-- [sage's_staff]
(20998,2103,1,1,1,243.779598),-- [sage's_staff_head]
(20998,201,1,1,1,2.617434),-- [club_of_nature]
(20998,2104,1,1,1,243.779598),-- [club_of_nature_head]
(20998,202,1,1,1,2.617434),-- [mace_of_underworld]
(20998,2105,1,1,1,231.634242),-- [mace_of_underworld_head]
(20998,1871,1,1,2,53211.674628),-- [charcoal]
(20998,1866,1,1,2,35474.449752),-- [suede]
(20998,1877,1,1,2,2128.493556),-- [admantite_nugget]
(20998,4041,1,1,2,462.665448),-- [mold_hardener]
(20998,4040,1,1,2,1064.163744),-- [mold_lubricant]
(20998,2231,1,1,2,229.339908),-- [rp_full_plate_armor]
(20998,5155,1,1,2,106.449588),-- [rp_comp_soulshot_b]
(20998,6669,1,1,2,12374.723088),-- [key_of_treasure_box5]
(20998,8725,1,1,2,1478.171268),-- [general_52_c]
(20998,8735,1,1,2,369.5013),-- [special_52_c]
(20998,8745,1,1,2,37.033164),-- [rare_52_c]
(20998,8755,1,1,2,7.47306),-- [unique_52_c]
(20998,1832,1,1,2,59123.861496),-- [advanced_antidote]
(20999,1918,1,1,-1,86067),-- [nassen's_earing_gemstone]
(20999,1868,1,9,-1,794915),-- [thread]
(20999,1873,1,1,-1,794915),-- [silver_nugget]
(20999,57,787,1598,0,700000),-- [adena]
(20999,228,1,1,1,15.564262),-- [crystal_dagger]
(20999,2119,1,1,1,1671.435738),-- [crystal_dagger_blade]
(20999,1868,1,1,2,122294.882784),-- [thread]
(20999,1873,1,1,2,24458.912092),-- [silver_nugget]
(20999,5549,1,1,2,6114.808604),-- [iron_thread]
(20999,1889,1,1,2,4076.431628),-- [compound_braid]
(20999,4044,1,1,2,2038.215814),-- [thons]
(20999,1806,1,1,2,122.321958),-- [rp_soulshot_b]
(20999,5270,1,1,2,122.321958),-- [rp_adv_comp_soulshot_b]
(20999,5280,1,1,2,122.321958),-- [rp_adv_comp_bspiritshot_b]
(20999,8726,1,1,2,1415.485846),-- [general_55_c]
(20999,8736,1,1,2,353.911752),-- [special_55_c]
(20999,8746,1,1,2,35.45564),-- [rare_55_c]
(20999,8756,1,1,2,6.929966),-- [unique_55_c]
(21000,1865,1,3,-1,871346),-- [varnish]
(21000,1986,1,1,-1,18415),-- [full_plate_armor_temper]
(21000,1918,1,1,-1,75474),-- [nassen's_earing_gemstone]
(21000,57,688,1402,0,700000),-- [adena]
(21000,301,1,1,1,5.83392),-- [scorpion]
(21000,2113,1,1,1,519.544875),-- [scorpion_blade]
(21000,303,1,1,1,5.83392),-- [widow_maker]
(21000,2114,1,1,1,519.544875),-- [widow_maker_head]
(21000,299,1,1,1,4.55157),-- [orcish_poleaxe]
(21000,2122,1,1,1,489.69084),-- [orcish_poleaxe_blade]
(21000,1865,1,1,2,49496.61717),-- [varnish]
(21000,1870,1,1,2,49496.61717),-- [coal]
(21000,1879,1,1,2,8249.398344),-- [cokes]
(21000,1875,1,1,2,3299.736627),-- [stone_of_purity]
(21000,4040,1,1,2,989.955054),-- [mold_lubricant]
(21000,4182,1,1,2,57.003606),-- [rp_great_sword]
(21000,5160,1,1,2,99.018216),-- [rp_comp_spiritshot_b]
(21000,5436,1,1,2,80.736183),-- [rp_berserker_blade]
(21000,4146,1,1,2,317.267082),-- [rp_tunic_of_shrnoen]
(21000,8726,1,1,2,1145.74977),-- [general_55_c]
(21000,8736,1,1,2,286.494219),-- [special_55_c]
(21000,8746,1,1,2,28.615356),-- [rare_55_c]
(21000,8756,1,1,2,5.791203),-- [unique_55_c]
(21001,1988,1,1,-1,45373),-- [divine_tunic_fabric]
(21001,1895,1,1,-1,674702),-- [metallic_fiber]
(21001,4042,1,1,-1,39358),-- [enria]
(21001,57,933,1901,0,700000),-- [adena]
(21001,286,1,1,1,18.496289),-- [eminence_bow]
(21001,2121,1,1,1,2004.503711),-- [eminence_bow_shaft]
(21001,1873,1,1,2,24912.121482),-- [silver_nugget]
(21001,1868,1,1,2,124560.988542),-- [thread]
(21001,1876,1,1,2,12456.156024),-- [mithril_ore]
(21001,1895,1,1,2,17794.481382),-- [metallic_fiber]
(21001,4042,1,1,2,1038.013002),-- [enria]
(21001,4939,1,1,2,770.83947),-- [rp_adamantite_necklace_i]
(21001,4966,1,1,2,71.843382),-- [rp_kshanberk_i]
(21001,5165,1,1,2,124.630164),-- [rp_comp_bspiritshot_b]
(21001,4180,1,1,2,6920.023158),-- [rp_silver_arrow]
(21001,4971,1,1,2,71.843382),-- [rp_dark_elven_long_bow_i]
(21001,8726,1,1,2,1441.63179),-- [general_55_c]
(21001,8736,1,1,2,360.360306),-- [special_55_c]
(21001,8746,1,1,2,36.016974),-- [rare_55_c]
(21001,8756,1,1,2,7.050942),-- [unique_55_c]
(21002,1874,1,1,-1,139115),-- [oriharukon_ore]
(21002,2960,1,1,-1,113625),-- [drake_leather_boots_design]
(21002,4613,1,1,-1,2878),-- [dye_s4c4_c]
(21002,57,823,1681,0,700000),-- [adena]
(21002,11896,1,1,1,176.338195),-- [dark_elven_long_bow_low]
(21002,4112,1,1,1,1744.661805),-- [dark_elven_long_bow_shaft]
(21002,1872,1,1,2,68487.411027),-- [animal_bone]
(21002,1867,1,1,2,68487.411027),-- [animal_skin]
(21002,1881,1,1,2,6848.726101),-- [coarse_bone_powder]
(21002,1875,1,1,2,3424.438059),-- [stone_of_purity]
(21002,4041,1,1,2,446.600609),-- [mold_hardener]
(21002,4949,1,1,2,329.287315),-- [rp_tunic_of_shrnoen_i]
(21002,4992,1,1,2,638.922403),-- [rp_blue_wolve's_boots_i]
(21002,8311,1,1,2,39.154437),-- [rp_bone_of_kaim_vanul]
(21002,8727,1,1,2,1027.316416),-- [general_58_b]
(21002,8737,1,1,2,256.829104),-- [special_58_b]
(21002,8747,1,1,2,25.652907),-- [rare_58_b]
(21002,8757,1,1,2,5.250595),-- [unique_58_b]
(21003,2963,1,1,-1,104221),-- [full_plate_gauntlet_part]
(21003,4949,1,1,-1,12269),-- [rp_tunic_of_shrnoen_i]
(21003,4049,1,1,-1,100394),-- [adamantite_earing_gemstone]
(21003,57,755,1542,0,700000),-- [adena]
(21003,12159,1,1,1,645.406589),-- [shrnoen's_shield_low]
(21003,4101,1,1,1,4096.903655),-- [shrnoen's_shield_fragment]
(21003,12171,1,1,1,645.406589),-- [avadon_shield_low]
(21003,4439,1,1,1,4873.902926),-- [avadon_shield_fragment]
(21003,12160,1,1,1,451.572705),-- [shrnoen's_helmet_low]
(21003,4102,1,1,1,3174.108659),-- [shrnoen's_helmet_design]
(21003,12170,1,1,1,451.572705),-- [avadon_circlet_low]
(21003,4072,1,1,1,3174.126172),-- [avadon_circlet_pattern]
(21003,1866,1,1,2,28993.364988),-- [suede]
(21003,1871,1,1,2,43490.047482),-- [charcoal]
(21003,5220,1,1,2,1739.607051),-- [reinforcing_agent]
(21003,1885,1,1,2,3624.23502),-- [high_grade_suede]
(21003,4041,1,1,2,378.136248),-- [mold_hardener]
(21003,4963,1,1,2,50.100477),-- [rp_great_sword_i]
(21003,4999,1,1,2,540.9306),-- [rp_doom_boots_i]
(21003,4993,1,1,2,540.9306),-- [rp_doom_gloves_i]
(21003,8727,1,1,2,869.739129),-- [general_58_b]
(21003,8737,1,1,2,217.402584),-- [special_58_b]
(21003,8747,1,1,2,21.766017),-- [rare_58_b]
(21003,8757,1,1,2,4.378962),-- [unique_58_b]
(21003,1832,1,1,2,48322.360842),-- [advanced_antidote]
(21004,4951,1,1,-1,9324),-- [rp_avadon_robe_i]
(21004,1920,1,1,-1,72742),-- [necklace_of_binding_chain]
(21004,4129,1,1,-1,23007),-- [rp_earing_of_black_ore]
(21004,57,840,1710,0,700000),-- [adena]
(21004,12151,1,1,1,334.38911),-- [shrnoen's_leather_shirts_low]
(21004,4066,1,1,1,2467.60536),-- [shrnoen's_leather_shirts_fabric]
(21004,12165,1,1,1,205.220455),-- [avadon_leather_mail_low]
(21004,4068,1,1,1,1895.738075),-- [avadon_leather_mail_lining]
(21004,12150,1,1,1,535.366095),-- [shrnoen's_leather_gaiters_low]
(21004,4067,1,1,1,3746.680905),-- [shrnoen's_leather_gaiters_texture]
(21004,1873,1,1,2,20931.805038),-- [silver_nugget]
(21004,1868,1,1,2,104659.179444),-- [thread]
(21004,1876,1,1,2,10465.979646),-- [mithril_ore]
(21004,1895,1,1,2,14951.377458),-- [metallic_fiber]
(21004,4042,1,1,2,872.152116),-- [enria]
(21004,4129,1,1,2,566.266434),-- [rp_earing_of_black_ore]
(21004,4167,1,1,2,650.797626),-- [rp_blue_wolve's_boots]
(21004,4197,1,1,2,39.951786),-- [rp_demon's_sword]
(21004,8728,1,1,2,872.152116),-- [general_61_b]
(21004,8738,1,1,2,218.115156),-- [special_61_b]
(21004,8748,1,1,2,21.749814),-- [rare_61_b]
(21004,8758,1,1,2,4.473366),-- [unique_61_b]
(21005,947,1,1,-1,932),-- [scrl_of_ench_wp_b]
(21005,1880,1,1,-1,233106),-- [steel]
(21005,4050,1,1,-1,144427),-- [adamantite_ring_wire]
(21005,57,920,1876,0,700000),-- [adena]
(21005,11889,1,1,1,65.67673),-- [great_sword_low]
(21005,4104,1,1,1,656.773741),-- [great_sword_blade]
(21005,11916,1,1,1,65.67673),-- [kshanberk_low]
(21005,4107,1,1,1,646.596961),-- [kshanberk_blade]
(21005,11900,1,1,1,65.67673),-- [sword_of_valhalla_low]
(21005,4108,1,1,1,646.599108),-- [sword_of_valhalla_blade]
(21005,1873,1,1,2,22951.926277),-- [silver_nugget]
(21005,1868,1,1,2,114759.800526),-- [thread]
(21005,1876,1,1,2,11476.047709),-- [mithril_ore]
(21005,1895,1,1,2,16394.329707),-- [metallic_fiber]
(21005,4042,1,1,2,956.323214),-- [enria]
(21005,4129,1,1,2,620.916611),-- [rp_earing_of_black_ore]
(21005,4167,1,1,2,713.605879),-- [rp_blue_wolve's_boots]
(21005,4197,1,1,2,43.807519),-- [rp_demon's_sword]
(21005,8728,1,1,2,956.323214),-- [general_61_b]
(21005,8738,1,1,2,239.165374),-- [special_61_b]
(21005,8748,1,1,2,23.848881),-- [rare_61_b]
(21005,8758,1,1,2,4.905089),-- [unique_61_b]
(21006,4066,1,1,-1,52315),-- [shrnoen's_leather_shirts_fabric]
(21006,948,1,1,-1,5547),-- [scrl_of_ench_am_b]
(21006,4130,1,1,-1,36022),-- [rp_ring_of_black_ore]
(21006,57,878,1784,0,700000),-- [adena]
(21006,357,1,1,1,10.26675),-- [shrnoen's_breastplate]
(21006,4056,1,1,1,1483.347645),-- [shrnoen's_breastplate_part]
(21006,2376,1,1,1,10.26675),-- [avadon_breastplate]
(21006,4064,1,1,1,1483.347645),-- [avadon_breastplate_part]
(21006,383,1,1,1,16.4268),-- [shrnoen's_gaiters]
(21006,4057,1,1,1,2292.4512),-- [shrnoen's_gaiters_material]
(21006,2379,1,1,1,16.4268),-- [avadon_gaiters]
(21006,4065,1,1,1,2292.46641),-- [avadon_gaiters_material]
(21006,1869,1,1,2,54620.614071),-- [iron_ore]
(21006,1864,1,1,2,109241.401943),-- [stem]
(21006,1880,1,1,2,5462.044027),-- [steel]
(21006,5550,1,1,2,728.22619),-- [reinforcing_plate]
(21006,4043,1,1,2,1820.739276),-- [asofe]
(21006,4193,1,1,2,41.71224),-- [rp_lancia]
(21006,4173,1,1,2,679.388109),-- [rp_blue_wolve's_gloves]
(21006,5003,1,1,2,41.71224),-- [rp_art_of_battle_axe_i]
(21006,8728,1,1,2,910.369638),-- [general_61_b]
(21006,8738,1,1,2,227.505509),-- [special_61_b]
(21006,8748,1,1,2,22.767931),-- [rare_61_b]
(21006,8758,1,1,2,4.518826),-- [unique_61_b]
(21007,4981,1,1,-1,7411),-- [rp_blue_wolve's_breastplate_i]
(21007,4051,1,1,-1,92552),-- [adamantite_necklace_chain]
(21007,948,1,1,-1,5966),-- [scrl_of_ench_am_b]
(21007,57,946,1918,0,700000),-- [adena]
(21007,11918,1,1,1,100.842792),-- [heavy_war_axe_low]
(21007,4105,1,1,1,1008.430122),-- [heavy_war_axe_head]
(21007,11908,1,1,1,100.842792),-- [sprite's_staff_low]
(21007,4106,1,1,1,991.884294),-- [sprite's_staff_head]
(21007,1894,1,1,2,2061.183042),-- [crafted_leather]
(21007,4039,1,1,2,1958.116459),-- [mold_glue]
(21007,4041,1,1,2,510.800066),-- [mold_hardener]
(21007,4044,1,1,2,1958.116459),-- [thons]
(21007,4621,1,1,2,80.99681),-- [dye_m4i4_c]
(21007,4998,1,1,2,730.606088),-- [rp_blue_wolve's_gloves_i]
(21007,4166,1,1,2,485.460697),-- [rp_doom_helmet]
(21007,8728,1,1,2,979.021075),-- [general_61_b]
(21007,8738,1,1,2,244.773846),-- [special_61_b]
(21007,8748,1,1,2,24.447661),-- [rare_61_b]
(21007,8758,1,1,2,4.904394),-- [unique_61_b]
(21007,1832,1,1,2,65270.573403),-- [advanced_antidote]
(21008,4983,1,1,-1,6493),-- [rp_doom_plate_armor_i]
(21008,5230,1,1,-1,4078),-- [rp_mithril_arrow]
(21008,4052,1,1,-1,108272),-- [earing_of_black_ore_piece]
(21008,57,1213,2457,0,700000),-- [adena]
(21008,12188,1,1,1,600.607957),-- [doom_boots_low]
(21008,4099,1,1,1,5069.142043),-- [doom_boots_part]
(21008,12189,1,1,1,600.607957),-- [blue_wolve's_boots_low]
(21008,4090,1,1,1,5069.142043),-- [blue_wolve's_boots_design]
(21008,12187,1,1,1,600.607957),-- [doom_gloves_low]
(21008,4091,1,1,1,5069.142043),-- [doom_gloves_part]
(21008,12190,1,1,1,600.607957),-- [blue_wolve's_gloves_low]
(21008,4096,1,1,1,5069.142043),-- [blue_wolve's_gloves_fabric]
(21008,1867,1,1,2,109494.236229),-- [animal_skin]
(21008,1872,1,1,2,109494.236229),-- [animal_bone]
(21008,1882,1,1,2,18249.160958),-- [leather]
(21008,1894,1,1,2,2881.356877),-- [crafted_leather]
(21008,4042,1,1,2,1368.577644),-- [enria]
(21008,4983,1,1,2,174.355041),-- [rp_doom_plate_armor_i]
(21008,5276,1,1,2,109.42785),-- [rp_adv_comp_spiritshot_a]
(21008,8729,1,1,2,1095.008019),-- [general_64_a]
(21008,8739,1,1,2,273.812798),-- [special_64_a]
(21008,8749,1,1,2,27.478549),-- [rare_64_a]
(21008,8759,1,1,2,5.349806),-- [unique_64_a]
(21009,4104,1,1,-1,18708),-- [great_sword_blade]
(21009,948,1,1,-1,8173),-- [scrl_of_ench_am_b]
(21009,4052,1,1,-1,115743),-- [earing_of_black_ore_piece]
(21009,57,1297,2625,0,700000),-- [adena]
(21009,12204,1,1,1,214.314874),-- [blue_wolve's_breastplate_low]
(21009,4078,1,1,1,2350.979085),-- [blue_wolve's_breastplate_part]
(21009,12184,1,1,1,131.920877),-- [doom_plate_armor_low]
(21009,4081,1,1,1,1586.320568),-- [doom_plate_armor_temper]
(21009,12193,1,1,1,342.806967),-- [blue_wolve's_gaiters_low]
(21009,4080,1,1,1,3310.657629),-- [blue_wolve's_gaiters_material]
(21009,1865,1,1,2,87787.21732),-- [varnish]
(21009,1870,1,1,2,87787.21732),-- [coal]
(21009,1879,1,1,2,14631.236136),-- [cokes]
(21009,1875,1,1,2,5852.414656),-- [stone_of_purity]
(21009,4040,1,1,2,1755.764296),-- [mold_lubricant]
(21009,5004,1,1,2,67.030656),-- [rp_staff_of_evil_sprit_i]
(21009,5281,1,1,2,117.104152),-- [rp_adv_comp_bspiritshot_a]
(21009,8729,1,1,2,1170.443032),-- [general_64_a]
(21009,8739,1,1,2,292.660632),-- [special_64_a]
(21009,8749,1,1,2,29.325912),-- [rare_64_a]
(21009,8759,1,1,2,5.585888),-- [unique_64_a]
(21010,4621,1,1,-1,3620),-- [dye_m4i4_c]
(21010,5230,1,1,-1,3500),-- [rp_mithril_arrow]
(21010,57,1042,2108,0,700000),-- [adena]
(21010,11933,1,1,1,126.65055),-- [bellion_cestus_low]
(21010,4120,1,1,1,1694.34945),-- [bellion_cestus_edge]
(21010,1868,1,1,2,119273.46406),-- [thread]
(21010,1873,1,1,2,23854.75954),-- [silver_nugget]
(21010,5549,1,1,2,5963.64818),-- [iron_thread]
(21010,1889,1,1,2,3975.82106),-- [compound_braid]
(21010,4044,1,1,2,1987.82712),-- [thons]
(21010,4129,1,1,2,645.42658),-- [rp_earing_of_black_ore]
(21010,4624,1,1,2,82.24226),-- [dye_w4m4_c]
(21010,3956,1,1,2,79.57314),-- [rp_blessed_spiritshot_a]
(21010,6670,1,1,2,9939.46924),-- [key_of_treasure_box6]
(21010,8729,1,1,2,795.23094),-- [general_64_a]
(21010,8739,1,1,2,198.84944),-- [special_64_a]
(21010,8749,1,1,2,19.85158),-- [rare_64_a]
(21010,8759,1,1,2,3.83686),-- [unique_64_a]
(21011,1884,1,1,-1,326755),-- [cord]
(21011,1832,1,1,-1,589975),-- [advanced_antidote]
(21011,1900,1,1,-1,58094),-- [enchanted_necklace_chain]
(21011,57,224,448,0,700000),-- [adena]
(21011,627,1,1,1,1078.49287),-- [aspis]
(21011,46,1,1,1,755.50713),-- [bronze_helmet]
(21011,1864,1,1,2,72539.733448),-- [stem]
(21011,1865,1,1,2,36269.866724),-- [varnish]
(21011,1866,1,1,2,24179.82801),-- [suede]
(21011,1873,1,1,2,14507.896806),-- [silver_nugget]
(21011,1868,1,1,2,72539.733448),-- [thread]
(21011,2185,1,1,2,7139.839668),-- [rp_iron_boots]
(21011,2274,1,1,2,259.145302),-- [rp_skull_breaker]
(21011,1061,1,1,2,21981.956594),-- [healing_potion]
(21012,1936,1,1,-1,53457),-- [white_tunic_pattern]
(21012,2185,1,1,-1,128592),-- [rp_iron_boots]
(21012,2153,1,1,-1,101594),-- [rp_tiger'seye_earing]
(21012,57,276,551,0,700000),-- [adena]
(21012,275,1,1,1,48.025665),-- [long_bow]
(21012,276,1,1,1,48.025665),-- [elven_bow]
(21012,2024,1,1,1,1694.94867),-- [elven_bow_shaft]
(21012,1868,1,1,2,101992.861289),-- [thread]
(21012,1873,1,1,2,20398.679367),-- [silver_nugget]
(21012,5549,1,1,2,5099.736785),-- [iron_thread]
(21012,1889,1,1,2,3399.646008),-- [compound_braid]
(21012,2264,1,1,2,527.245037),-- [rp_two-handed_sword]
(21012,2273,1,1,2,364.17128),-- [rp_tarbar]
(21012,1833,1,1,2,135990.660234),-- [bandage]
(21013,1061,1,1,-1,466705),-- [healing_potion]
(21013,2023,1,1,-1,9542),-- [conjure_staff_head]
(21013,1933,1,1,-1,90596),-- [dark_hose_fabric]
(21013,57,324,651,0,700000),-- [adena]
(21013,848,1,1,1,641.472052),-- [enchanted_earing]
(21013,911,1,1,1,481.464386),-- [enchanted_necklace]
(21013,1900,1,1,1,11509.918316),-- [enchanted_necklace_chain]
(21013,879,1,1,1,965.145246),-- [enchanted_ring]
(21013,1871,1,1,2,70135.122772),-- [charcoal]
(21013,1866,1,1,2,46756.805964),-- [suede]
(21013,1877,1,1,2,2805.480744),-- [admantite_nugget]
(21013,737,1,1,2,7013.529512),-- [scroll_of_resurrection]
(21013,2187,1,1,2,3131.046116),-- [rp_manticor_skin_shirt]
(21013,1061,1,1,2,42506.014892),-- [healing_potion]
(21014,2977,1,1,-1,106414),-- [rp_brigandine_boots]
(21014,1958,1,1,-1,71453),-- [mithril_boots_design]
(21014,1865,1,1,-1,794911),-- [varnish]
(21014,57,336,672,0,700000),-- [adena]
(21014,316,1,1,1,37.907312),-- [blood_of_saints]
(21014,317,1,1,1,37.907312),-- [tome_of_blood]
(21014,2030,1,1,1,1648.185376),-- [tome_of_blood_page]
(21014,1865,1,1,2,70441.29989),-- [varnish]
(21014,1870,1,1,2,70441.29989),-- [coal]
(21014,1879,1,1,2,11740.16303),-- [cokes]
(21014,1875,1,1,2,4696.161725),-- [stone_of_purity]
(21014,2189,1,1,2,3144.71525),-- [rp_mithril_tunic]
(21014,2286,1,1,2,391.360215),-- [rp_bonebreaker]
(21015,1940,1,1,-1,121028),-- [iron_boots_design]
(21015,1869,1,1,-1,810885),-- [iron_ore]
(21015,1873,1,1,-1,324354),-- [silver_nugget]
(21015,57,342,683,0,700000),-- [adena]
(21015,83,1,1,1,26.091),-- [sword_of_magic]
(21015,144,1,1,1,26.091),-- [sword_of_occult]
(21015,124,1,1,1,19.3284),-- [two-handed_sword]
(21015,2026,1,1,1,864.831825),-- [two-handed_sword_edge]
(21015,127,1,1,1,19.3284),-- [crimson_sword]
(21015,130,1,1,1,19.329375),-- [elven_sword]
(21015,1873,1,1,2,34491.320064),-- [silver_nugget]
(21015,1868,1,1,2,172456.127616),-- [thread]
(21015,1876,1,1,2,17245.660032),-- [mithril_ore]
(21015,2280,1,1,2,615.933312),-- [rp_crucifix_of_blood]
(21015,2978,1,1,2,11542.958976),-- [rp_elven_mithril_boots]
(21016,1870,1,1,-1,868501),-- [coal]
(21016,1882,1,1,-1,193000),-- [leather]
(21016,1901,1,1,-1,119959),-- [tiger'seye_earing_stone]
(21016,57,367,732,0,700000),-- [adena]
(21016,58,1,1,1,93.563163),-- [mithril_breastplate]
(21016,349,1,1,1,93.563163),-- [compound_scale_mail]
(21016,350,1,1,1,93.563163),-- [dwarven_scale_mail]
(21016,351,1,1,1,84.518562),-- [blast_plate]
(21016,59,1,1,1,135.26424),-- [mithril_gaiters]
(21016,378,1,1,1,135.26424),-- [compound_scale_gaiters]
(21016,379,1,1,1,135.263469),-- [dwarven_scale_gaiters]
(21016,1869,1,1,2,65968.001142),-- [iron_ore]
(21016,1864,1,1,2,131936.002284),-- [stem]
(21016,1880,1,1,2,6596.843124),-- [steel]
(21016,5550,1,1,2,879.55041),-- [reinforcing_plate]
(21016,2191,1,1,2,8830.987185),-- [rp_gauntlet_of_repose_of_the_soul]
(21016,2293,1,1,2,366.443496),-- [rp_glaive]
(21016,2276,1,1,2,471.172359),-- [rp_maingauche]
(21017,1989,1,1,-1,53465),-- [divine_hose_pattern]
(21017,1880,1,1,-1,177397),-- [steel]
(21017,1806,1,1,-1,3548),-- [rp_soulshot_b]
(21017,57,701,1428,0,700000),-- [adena]
(21017,400,1,1,1,34.38225),-- [theca_leather_mail]
(21017,1984,1,1,1,2339.906625),-- [theca_leather_mail_pattern]
(21017,401,1,1,1,16.277625),-- [drake_leather_mail]
(21017,1987,1,1,1,1665.3735),-- [drake_leather_mail_texture]
(21017,420,1,1,1,55.0305),-- [theca_leather_gaiters]
(21017,1985,1,1,1,3764.0295),-- [theca_leather_gaiters_pattern]
(21017,1866,1,1,2,36389.065012),-- [suede]
(21017,1871,1,1,2,54583.597518),-- [charcoal]
(21017,5220,1,1,2,2183.331873),-- [reinforcing_agent]
(21017,1885,1,1,2,4548.583011),-- [high_grade_suede]
(21017,4041,1,1,2,474.593785),-- [mold_hardener]
(21017,4940,1,1,2,262.404758),-- [rp_shrnoen's_breastplate_i]
(21017,5280,1,1,2,109.151559),-- [rp_adv_comp_bspiritshot_b]
(21017,4189,1,1,2,62.844837),-- [rp_arthro_nail]
(21017,8726,1,1,2,1263.511986),-- [general_55_c]
(21017,8736,1,1,2,315.827881),-- [special_55_c]
(21017,8746,1,1,2,31.572765),-- [rare_55_c]
(21017,8756,1,1,2,6.515015),-- [unique_55_c]
(21018,4947,1,1,-1,22992),-- [rp_shrnoen's_leather_gaiters_i]
(21018,2961,1,1,-1,121815),-- [full_plate_boots_part]
(21018,4049,1,1,-1,117342),-- [adamantite_earing_gemstone]
(21018,57,883,1802,0,700000),-- [adena]
(21018,11918,1,1,1,94.522944),-- [heavy_war_axe_low]
(21018,4105,1,1,1,945.231504),-- [heavy_war_axe_head]
(21018,11908,1,1,1,94.522944),-- [sprite's_staff_low]
(21018,4106,1,1,1,929.722608),-- [sprite's_staff_head]
(21018,1872,1,1,2,73423.762488),-- [animal_bone]
(21018,1867,1,1,2,73423.762488),-- [animal_skin]
(21018,1881,1,1,2,7342.424568),-- [coarse_bone_powder]
(21018,1875,1,1,2,3671.131752),-- [stone_of_purity]
(21018,4041,1,1,2,478.843272),-- [mold_hardener]
(21018,4950,1,1,2,565.978896),-- [rp_hose_of_shrnoen_i]
(21018,4999,1,1,2,684.844128),-- [rp_doom_boots_i]
(21018,8309,1,1,2,63.459216),-- [rp_spell_breaker]
(21018,8727,1,1,2,1101.355632),-- [general_58_b]
(21018,8737,1,1,2,275.41944),-- [special_58_b]
(21018,8747,1,1,2,27.541944),-- [rare_58_b]
(21018,8757,1,1,2,5.476176),-- [unique_58_b]
(21019,2964,1,1,-1,134399),-- [blessed_gloves_pattern]
(21019,4950,1,1,-1,25367),-- [rp_hose_of_shrnoen_i]
(21019,4129,1,1,-1,26713),-- [rp_earing_of_black_ore]
(21019,57,973,1988,0,700000),-- [adena]
(21019,11903,1,1,1,208.636155),-- [arthro_nail_low]
(21019,4111,1,1,1,2086.363845),-- [arthro_nail_blade]
(21019,1870,1,1,2,60756.881586),-- [coal]
(21019,1865,1,1,2,60756.881586),-- [varnish]
(21019,1874,1,1,2,4050.520392),-- [oriharukon_ore]
(21019,4043,1,1,2,2025.260196),-- [asofe]
(21019,4039,1,1,2,2025.260196),-- [mold_glue]
(21019,4964,1,1,2,69.98226),-- [rp_heavy_war_axe_i]
(21019,4176,1,1,2,755.676366),-- [rp_doom_boots]
(21019,5003,1,1,2,46.346742),-- [rp_art_of_battle_axe_i]
(21019,8727,1,1,2,1215.182526),-- [general_58_b]
(21019,8737,1,1,2,303.828642),-- [special_58_b]
(21019,8747,1,1,2,30.36966),-- [rare_58_b]
(21019,8757,1,1,2,5.809848),-- [unique_58_b]
(21020,4952,1,1,-1,35974),-- [rp_avadon_circlet_i]
(21020,1987,1,1,-1,42700),-- [drake_leather_mail_texture]
(21020,4050,1,1,-1,173407),-- [adamantite_ring_wire]
(21020,57,1105,2252,0,700000),-- [adena]
(21020,78,1,1,1,4.124809),-- [great_sword]
(21020,4104,1,1,1,788.351473),-- [great_sword_blade]
(21020,142,1,1,1,4.124809),-- [kshanberk]
(21020,4107,1,1,1,776.13705),-- [kshanberk_blade]
(21020,148,1,1,1,4.124809),-- [sword_of_valhalla]
(21020,4108,1,1,1,776.13705),-- [sword_of_valhalla_blade]
(21020,4167,1,1,2,5141.29545),-- [rp_blue_wolve's_boots]
(21020,1832,1,1,2,459293.70455),-- [advanced_antidote]
(21021,4040,1,1,-1,51678),-- [mold_lubricant]
(21021,4613,1,1,-1,3564),-- [dye_s4c4_c]
(21021,947,1,1,-1,1034),-- [scrl_of_ench_wp_b]
(21021,57,1020,2079,0,700000),-- [adena]
(21021,11896,1,1,1,218.380305),-- [dark_elven_long_bow_low]
(21021,4112,1,1,1,2160.619695),-- [dark_elven_long_bow_shaft]
(21021,1869,1,1,2,63603.8396),-- [iron_ore]
(21021,1870,1,1,2,63603.8396),-- [coal]
(21021,1871,1,1,2,63603.8396),-- [charcoal]
(21021,1872,1,1,2,84804.99825),-- [animal_bone]
(21021,1867,1,1,2,84804.99825),-- [animal_skin]
(21021,4130,1,1,2,1032.40235),-- [rp_ring_of_black_ore]
(21021,4998,1,1,2,790.93875),-- [rp_blue_wolve's_gloves_i]
(21021,5001,1,1,2,48.7291),-- [rp_lancia_i]
(21021,8728,1,1,2,1060.03975),-- [general_61_b]
(21021,8738,1,1,2,265.10085),-- [special_61_b]
(21021,8748,1,1,2,26.54645),-- [rare_61_b]
(21021,8758,1,1,2,4.72745),-- [unique_61_b]
(21022,4049,1,1,-1,138069),-- [adamantite_earing_gemstone]
(21022,947,1,1,-1,1053),-- [scrl_of_ench_wp_b]
(21022,4613,1,1,-1,3631),-- [dye_s4c4_c]
(21022,57,1041,2116,0,700000),-- [adena]
(21022,12175,1,1,1,414.009032),-- [tunic_of_shrnoen_low]
(21022,4069,1,1,1,3055.156032),-- [tunic_of_shrnoen_fabric]
(21022,12166,1,1,1,254.084596),-- [avadon_robe_low]
(21022,4071,1,1,1,2347.12394),-- [avadon_robe_fabric]
(21022,12176,1,1,1,662.839764),-- [hose_of_shrnoen_low]
(21022,4070,1,1,1,4638.786636),-- [hose_of_shrnoen_fabric]
(21022,1869,1,1,2,64794.760936),-- [iron_ore]
(21022,1870,1,1,2,64794.760936),-- [coal]
(21022,1871,1,1,2,64794.760936),-- [charcoal]
(21022,1872,1,1,2,86392.891095),-- [animal_bone]
(21022,1867,1,1,2,86392.891095),-- [animal_skin]
(21022,4130,1,1,2,1051.733101),-- [rp_ring_of_black_ore]
(21022,4998,1,1,2,805.748325),-- [rp_blue_wolve's_gloves_i]
(21022,5001,1,1,2,49.641506),-- [rp_lancia_i]
(21022,8728,1,1,2,1079.887985),-- [general_61_b]
(21022,8738,1,1,2,270.064611),-- [special_61_b]
(21022,8748,1,1,2,27.043507),-- [rare_61_b]
(21022,8758,1,1,2,4.815967),-- [unique_61_b]
(21023,2019,1,1,-1,9507),-- [trident_edge]
(21023,2263,1,1,-1,6865),-- [rp_dwarven_trident]
(21023,1866,1,1,-1,294716),-- [suede]
(21023,57,192,367,0,700000),-- [adena]
(21023,156,1,1,1,52.666614),-- [hand_axe]
(21023,167,1,1,1,52.666614),-- [scalpel]
(21023,178,1,1,1,52.666772),-- [bone_staff]
(21023,1864,1,1,2,82701.808816),-- [stem]
(21023,1865,1,1,2,41350.778656),-- [varnish]
(21023,1866,1,1,2,27567.35344),-- [suede]
(21023,1873,1,1,2,16540.412064),-- [silver_nugget]
(21023,1868,1,1,2,82701.808816),-- [thread]
(21023,2260,1,1,2,641.838208),-- [rp_mace_of_judgment]
(21024,2178,1,1,-1,73852),-- [rp_dark_hose]
(21024,1934,1,1,-1,60336),-- [excellence_leather_gloves_lining]
(21024,1899,1,1,-1,72121),-- [necklace_of_devotion_chain]
(21024,57,199,384,0,700000),-- [adena]
(21024,220,1,1,1,164),-- [handiwork_dagger]
(21024,1864,1,1,2,103619.211899),-- [stem]
(21024,1869,1,1,2,51809.711915),-- [iron_ore]
(21024,1878,1,1,2,20723.884766),-- [braided_hemp]
(21024,1884,1,1,2,31882.89964),-- [cord]
(21024,2180,1,1,2,3895.29178),-- [rp_scale_mail]
(21025,1871,1,1,-1,485180),-- [charcoal]
(21025,1868,1,3,-1,485180),-- [thread]
(21025,2152,1,1,-1,85419),-- [rp_enchanted_necklace]
(21025,57,208,407,0,700000),-- [adena]
(21025,291,1,1,1,86.432478),-- [trident]
(21025,2019,1,1,1,2927.567522),-- [trident_edge]
(21025,1864,1,1,2,90765.871725),-- [stem]
(21025,1865,1,1,2,45382.796495),-- [varnish]
(21025,1866,1,1,2,30255.290575),-- [suede]
(21025,1873,1,1,2,18153.174345),-- [silver_nugget]
(21025,1868,1,1,2,90765.871725),-- [thread]
(21025,2180,1,1,2,3411.995135),-- [rp_scale_mail]
(21026,1834,1,1,-1,575495),-- [emergency_dressing]
(21026,2025,1,1,-1,7174),-- [dwarven_trident_edge]
(21026,1900,1,1,-1,56668),-- [enchanted_necklace_chain]
(21026,57,220,435,0,700000),-- [adena]
(21026,275,1,1,1,38.0773),-- [long_bow]
(21026,276,1,1,1,38.0773),-- [elven_bow]
(21026,2024,1,1,1,1343.8454),-- [elven_bow_shaft]
(21026,1872,1,1,2,53911.649475),-- [animal_bone]
(21026,1867,1,1,2,53911.649475),-- [animal_skin]
(21026,1881,1,1,2,5391.10212),-- [coarse_bone_powder]
(21026,1875,1,1,2,2695.55106),-- [stone_of_purity]
(21026,737,1,1,2,4043.32659),-- [scroll_of_resurrection]
(21026,2274,1,1,2,288.75519),-- [rp_skull_breaker]
(21026,2191,1,1,2,5412.96609),-- [rp_gauntlet_of_repose_of_the_soul]
(21034,2302,1,1,-1,3085),-- [rp_war_pick]
(21034,1956,1,1,-1,80198),-- [square_shield_fragment]
(21034,2154,1,1,-1,75647),-- [rp_elven_earing]
(21034,57,299,596,0,700000),-- [adena]
(21034,88,1,1,1,6.8006),-- [morning_star]
(21034,2031,1,1,1,369.64295),-- [morning_star_head]
(21034,90,1,1,1,6.8006),-- [goathead_staff]
(21034,2032,1,1,1,337.43075),-- [goathead_staff_head]
(21034,158,1,1,1,6.8006),-- [tarbar]
(21034,2035,1,1,1,369.64295),-- [tarbar_head]
(21034,169,1,1,1,6.8006),-- [skull_breaker]
(21034,2036,1,1,1,369.64295),-- [skull_breaker_head]
(21034,172,1,1,1,6.8006),-- [heavy_bone_club]
(21034,2037,1,1,1,369.6374),-- [heavy_bone_club_head]
(21034,1874,1,1,2,3043.573712),-- [oriharukon_ore]
(21034,1878,1,1,2,18261.23224),-- [braided_hemp]
(21034,1884,1,1,2,28094.090352),-- [cord]
(21034,1889,1,1,2,3043.573712),-- [compound_braid]
(21034,5220,1,1,2,1826.018208),-- [reinforcing_agent]
(21034,2190,1,1,2,3260.956832),-- [rp_mithril_hose]
(21034,2279,1,1,2,326.179696),-- [rp_hammer_in_flames]
(21034,1341,10,30,2,152176.375248),-- [bone_arrow]
(21035,1952,1,1,-1,72876),-- [slamander_skin_mail_texture]
(21035,1873,1,1,-1,910076),-- [silver_nugget]
(21035,1905,1,1,-1,221322),-- [onyxbeast'seye_earing_gemstone]
(21035,57,916,1852,0,700000),-- [adena]
(21035,396,1,1,1,311.644923),-- [slamander_skin_mail]
(21035,1952,1,1,1,18297.355077),-- [slamander_skin_mail_texture]
(21035,1865,1,1,2,126944.108529),-- [varnish]
(21035,1870,1,1,2,126944.108529),-- [coal]
(21035,1879,1,1,2,21157.526526),-- [cokes]
(21035,1875,1,1,2,8462.800485),-- [stone_of_purity]
(21035,2308,1,1,2,554.380847),-- [rp_cursed_dagger]
(21035,2205,1,1,2,4017.247439),-- [rp_chain_gaiters]
(21035,2989,1,1,2,6716.658411),-- [rp_chain_hood]
(21035,2997,1,1,2,10074.812512),-- [rp_karmian_gloves]
(21035,6668,1,1,2,45337.356722),-- [key_of_treasure_box4]
(21036,2070,1,1,-1,21261),-- [cursed_dagger_blade]
(21036,2316,1,1,-1,9330),-- [rp_katana]
(21036,1895,1,1,-1,765042),-- [metallic_fiber]
(21036,57,1054,2160,0,700000),-- [adena]
(21036,354,1,1,1,162.83088),-- [chain_mail_shirt]
(21036,1959,1,1,1,8521.60536),-- [chain_mail_shirt_material]
(21036,381,1,1,1,260.48736),-- [chain_gaiters]
(21036,1960,1,1,1,17335.0764),-- [chain_gaiters_part]
(21036,1895,1,1,2,60262.116192),-- [metallic_fiber]
(21036,2318,1,1,2,734.903856),-- [rp_spirits_sword]
(21036,8723,1,1,2,8436.676164),-- [general_46_c]
(21036,8733,1,1,2,2109.151092),-- [special_46_c]
(21036,8743,1,1,2,210.936648),-- [rare_46_c]
(21036,8753,1,1,2,42.216048),-- [unique_46_c]
(21037,5231,1,1,-1,247709),-- [rp_reinforcing_agent]
(21037,4040,1,1,-1,69359),-- [mold_lubricant]
(21037,2166,1,1,-1,117557),-- [rp_earing_of_binding]
(21037,57,1369,2792,0,700000),-- [adena]
(21037,1126,1,1,1,206.69324),-- [crimson_boots]
(21037,1974,1,1,1,10768.531033),-- [crimson_boots_fabric]
(21037,2434,1,1,1,206.69324),-- [rind_leather_boots]
(21037,2948,1,1,1,10768.531033),-- [rind_leather_boots_lining]
(21037,2455,1,1,1,223.813915),-- [plate_leather_gloves]
(21037,2946,1,1,1,7156.940206),-- [plate_leather_gloves_design]
(21037,2456,1,1,1,206.69324),-- [dwarven_chain_gloves]
(21037,2949,1,1,1,10768.531033),-- [dwarven_chain_gloves_design]
(21037,2457,1,1,1,206.69324),-- [gloves_of_seal]
(21037,2950,1,1,1,10768.531033),-- [gloves_of_seal_pattern]
(21037,2458,1,1,1,206.69324),-- [rind_leather_gloves]
(21037,2951,1,1,1,10768.655547),-- [rind_leather_gloves_design]
(21037,1895,1,1,2,36584.521984),-- [metallic_fiber]
(21037,4040,1,1,2,2560.929664),-- [mold_lubricant]
(21037,4042,1,1,2,2134.089824),-- [enria]
(21037,4043,1,1,2,4268.179648),-- [asofe]
(21037,2329,1,1,2,297.77616),-- [rp_tsurugi]
(21037,2225,1,1,2,2783.6192),-- [rp_demon's_hose]
(21037,2345,1,1,2,297.77616),-- [rp_dark_screamer]
(21037,2344,1,1,2,297.77616),-- [rp_grace_dagger]
(21037,8724,1,1,2,4268.179648),-- [general_49_c]
(21037,8734,1,1,2,1067.072256),-- [special_49_c]
(21037,8744,1,1,2,106.696288),-- [rare_49_c]
(21037,8754,1,1,2,21.383008),-- [unique_49_c]
(21038,5231,1,1,-1,187644),-- [rp_reinforcing_agent]
(21038,1911,1,1,-1,195390),-- [earing_of_protection_gemstone]
(21038,2166,1,1,-1,89051),-- [rp_earing_of_binding]
(21038,57,1037,2115,0,700000),-- [adena]
(21038,2496,1,1,1,323.055837),-- [dwarven_chain_shield]
(21038,2947,1,1,1,13856.305437),-- [dwarven_chain_shield_fragment]
(21038,632,1,1,1,298.228047),-- [knight_shield]
(21038,1972,1,1,1,15519.05199),-- [knight_shield_fragment]
(21038,500,1,1,1,208.805922),-- [great_helmet]
(21038,1971,1,1,1,11875.552767),-- [great_helmet_material]
(21038,1872,1,1,2,141087.342613),-- [animal_bone]
(21038,1867,1,1,2,141087.342613),-- [animal_skin]
(21038,1881,1,1,2,14108.640775),-- [coarse_bone_powder]
(21038,1875,1,1,2,7054.476198),-- [stone_of_purity]
(21038,4041,1,1,2,920.216813),-- [mold_hardener]
(21038,2224,1,1,2,1437.819294),-- [rp_demon's_tunic]
(21038,952,1,1,2,1411.019888),-- [scrl_of_ench_am_c]
(21038,8724,1,1,2,3527.238099),-- [general_49_c]
(21038,8734,1,1,2,881.88743),-- [special_49_c]
(21038,8744,1,1,2,88.188743),-- [rare_49_c]
(21038,8754,1,1,2,16.827534),-- [unique_49_c]
(21039,1805,1,1,-1,8706),-- [rp_soulshot_c]
(21039,1905,1,1,-1,254068),-- [onyxbeast'seye_earing_gemstone]
(21039,1871,1,5,-1,870607),-- [charcoal]
(21039,57,1033,2097,0,700000),-- [adena]
(21039,70,1,1,1,47.27586),-- [claymore]
(21039,2047,1,1,1,2882.22114),-- [claymore_blade]
(21039,2499,1,1,1,47.27586),-- [elven_long_sword]
(21039,2967,1,1,1,2843.22714),-- [elven_long_sword_blade]
(21039,1871,1,1,2,218589.145338),-- [charcoal]
(21039,1866,1,1,2,145726.225326),-- [suede]
(21039,1877,1,1,2,8743.658286),-- [admantite_nugget]
(21039,2162,1,1,2,10559.971914),-- [rp_aquastone_necklace]
(21039,5159,1,1,2,728.606082),-- [rp_comp_spiritshot_c]
(21039,2312,1,1,2,954.393054),-- [rp_crystallized_ice_bow]
(21040,1875,1,1,-1,277649),-- [stone_of_purity]
(21040,1911,1,1,-1,309761),-- [earing_of_protection_gemstone]
(21040,1967,1,1,-1,227147),-- [plate_leather_gaiters_material]
(21040,57,1644,3353,0,700000),-- [adena]
(21040,195,1,1,1,41.757248),-- [cursed_staff]
(21040,2082,1,1,1,3251.674816),-- [cursed_staff_head]
(21040,2502,1,1,1,41.757248),-- [dwarven_warhammer]
(21040,2968,1,1,1,3112.810688),-- [dwarven_warhammer_head]
(21040,1872,1,1,2,223672.659084),-- [animal_bone]
(21040,1867,1,1,2,223672.659084),-- [animal_skin]
(21040,1881,1,1,2,22367.1177),-- [coarse_bone_powder]
(21040,1875,1,1,2,11183.805864),-- [stone_of_purity]
(21040,4041,1,1,2,1458.864684),-- [mold_hardener]
(21040,2224,1,1,2,2279.445192),-- [rp_demon's_tunic]
(21040,952,1,1,2,2236.958784),-- [scrl_of_ench_am_c]
(21040,8724,1,1,2,5591.902932),-- [general_49_c]
(21040,8734,1,1,2,1398.09924),-- [special_49_c]
(21040,8744,1,1,2,139.809924),-- [rare_49_c]
(21040,8754,1,1,2,26.677512),-- [unique_49_c]
(21058,4617,1,1,-1,8254),-- [dye_d4s4_c]
(21058,4049,1,1,-1,313879),-- [adamantite_earing_gemstone]
(21058,4129,1,1,-1,64763),-- [rp_earing_of_black_ore]
(21058,57,2367,4811,0,700000),-- [adena]
(21058,78,1,1,1,8.819343),-- [great_sword]
(21058,4104,1,1,1,1685.591271),-- [great_sword_blade]
(21058,142,1,1,1,8.819343),-- [kshanberk]
(21058,4107,1,1,1,1659.47535),-- [kshanberk_blade]
(21058,148,1,1,1,8.819343),-- [sword_of_valhalla]
(21058,4108,1,1,1,1659.47535),-- [sword_of_valhalla_blade]
(21058,1895,1,1,2,45911.986758),-- [metallic_fiber]
(21058,4040,1,1,2,3213.826956),-- [mold_lubricant]
(21058,4042,1,1,2,2678.18913),-- [enria]
(21058,4043,1,1,2,5356.37826),-- [asofe]
(21058,4195,1,1,2,122.637402),-- [rp_art_of_battle_axe]
(21058,4999,1,1,2,1998.67716),-- [rp_doom_boots_i]
(21058,4163,1,1,2,1064.196738),-- [rp_blue_wolve's_hose]
(21058,8728,1,1,2,2678.18913),-- [general_61_b]
(21058,8738,1,1,2,669.563226),-- [special_61_b]
(21058,8748,1,1,2,66.9627),-- [rare_61_b]
(21058,8758,1,1,2,13.39254),-- [unique_61_b]
(21059,4129,1,1,-1,55362),-- [rp_earing_of_black_ore]
(21059,4049,1,1,-1,268315),-- [adamantite_earing_gemstone]
(21059,4130,1,1,-1,83043),-- [rp_ring_of_black_ore]
(21059,57,2020,4116,0,700000),-- [adena]
(21059,284,1,1,1,22.618),-- [dark_elven_long_bow]
(21059,4112,1,1,1,4277.382),-- [dark_elven_long_bow_shaft]
(21059,1864,1,3,2,125918.281528),-- [stem]
(21059,1869,1,1,2,125918.281528),-- [iron_ore]
(21059,1878,1,1,2,50367.157308),-- [braided_hemp]
(21059,1884,1,1,2,77488.143382),-- [cord]
(21059,4039,1,1,2,4197.457238),-- [mold_glue]
(21059,4154,1,1,2,1490.134204),-- [rp_doom_shield]
(21059,4198,1,1,2,96.287984),-- [rp_bellion_cestus]
(21059,4194,1,1,2,96.287984),-- [rp_deadman's_glory]
(21059,8728,1,1,2,2098.53449),-- [general_61_b]
(21059,8738,1,1,2,524.536558),-- [special_61_b]
(21059,8748,1,1,2,52.41483),-- [rare_61_b]
(21059,8758,1,1,2,10.482966),-- [unique_61_b]
(21060,4050,1,1,-1,316941),-- [adamantite_ring_wire]
(21060,947,1,1,-1,2046),-- [scrl_of_ench_wp_b]
(21060,1865,1,11,-1,852572),-- [varnish]
(21060,57,2020,4116,0,700000),-- [adena]
(21060,229,1,1,1,11.309397),-- [kris]
(21060,4109,1,1,1,2128.190603),-- [kris_edge]
(21060,243,1,1,1,11.309397),-- [hell_knife]
(21060,4110,1,1,1,2128.190603),-- [hell_knife_edge]
(21060,1865,1,1,2,137365.603308),-- [varnish]
(21060,1870,1,1,2,137365.603308),-- [coal]
(21060,1879,1,1,2,22894.267218),-- [cokes]
(21060,1875,1,1,2,9157.624686),-- [stone_of_purity]
(21060,4040,1,1,2,2747.164104),-- [mold_lubricant]
(21060,4155,1,1,2,426.624228),-- [rp_blue_wolve's_breastplate]
(21060,8728,1,1,2,2289.30342),-- [general_61_b]
(21060,8738,1,1,2,572.531358),-- [special_61_b]
(21060,8748,1,1,2,57.129834),-- [rare_61_b]
(21060,8758,1,1,2,11.508168),-- [unique_61_b]
(21060,1343,20,60,2,98118.640368),-- [silver_arrow]
(21061,5478,1,1,-1,85417),-- [sealed_dark_crystal_leather_mail_pattern]
(21061,1895,1,7,-1,725557),-- [metallic_fiber]
(21061,57,4020,8164,0,700000),-- [adena]
(21061,5287,1,1,1,28.07788),-- [sealed_dark_crystal_breastplate]
(21061,5520,1,1,1,3224.93756),-- [sealed_dark_crystal_breastplate_pattern]
(21061,5293,1,1,1,17.28436),-- [sealed_tallum_plate_armor]
(21061,5521,1,1,1,2275.64432),-- [sealed_tallum_plate_armor_pattern]
(21061,5288,1,1,1,44.93092),-- [sealed_dark_crystal_gaiters]
(21061,5524,1,1,1,4929.12496),-- [sealed_dark_crystal_gaiters_pattern]
(21061,1873,1,1,2,100015.319741),-- [silver_nugget]
(21061,1868,1,3,2,250038.539286),-- [thread]
(21061,1876,1,1,2,50007.899804),-- [mithril_ore]
(21061,1895,1,1,2,71439.719758),-- [metallic_fiber]
(21061,4042,1,1,2,4167.165028),-- [enria]
(21061,5000,1,1,2,190.987066),-- [rp_sword_of_damascus_i]
(21061,730,1,1,2,208.262278),-- [scrl_of_ench_am_a]
(21061,5422,1,1,2,242.812702),-- [rp_sealed_majestic_platte_armor_i]
(21061,8730,1,1,2,2778.42993),-- [general_67_a]
(21061,8740,1,1,2,694.367549),-- [special_67_a]
(21061,8750,1,1,2,69.580715),-- [rare_67_a]
(21061,8760,1,1,2,13.916143),-- [unique_67_a]
(21063,5220,1,1,-1,875838),-- [reinforcing_agent]
(21063,5478,1,1,-1,184123),-- [sealed_dark_crystal_leather_mail_pattern]
(21063,1807,1,1,-1,29195),-- [rp_soulshot_a]
(21063,57,8659,17618,0,700000),-- [adena]
(21063,5287,1,1,1,60.524913),-- [sealed_dark_crystal_breastplate]
(21063,5520,1,1,1,6951.702381),-- [sealed_dark_crystal_breastplate_pattern]
(21063,5293,1,1,1,37.258311),-- [sealed_tallum_plate_armor]
(21063,5521,1,1,1,4905.397932),-- [sealed_tallum_plate_armor_pattern]
(21063,5288,1,1,1,96.853467),-- [sealed_dark_crystal_gaiters]
(21063,5524,1,1,1,10625.262996),-- [sealed_dark_crystal_gaiters_pattern]
(21063,1864,4,12,2,134744.464995),-- [stem]
(21063,1865,2,6,2,107795.649885),-- [varnish]
(21063,1866,3,9,2,59886.51543),-- [suede]
(21063,1873,4,12,2,26948.81511),-- [silver_nugget]
(21063,1868,10,30,2,51331.18767),-- [thread]
(21063,5281,1,1,2,718.526025),-- [rp_adv_comp_bspiritshot_a]
(21063,729,1,1,2,59.97453),-- [scrl_of_ench_wp_a]
(21063,8314,1,1,2,294.42042),-- [rp_eye_of_soul_i]
(21063,8730,1,1,2,5988.495765),-- [general_67_a]
(21063,8740,1,1,2,1497.02658),-- [special_67_a]
(21063,8750,1,1,2,149.54688),-- [rare_67_a]
(21063,8760,1,1,2,30.37671),-- [unique_67_a]
(21064,4119,1,1,-1,39452),-- [demon's_sword_edge]
(21064,5230,1,1,-1,12018),-- [rp_mithril_arrow]
(21064,5479,1,1,-1,53333),-- [sealed_tallum_leather_mail_pattern]
(21064,57,4448,9066,0,700000),-- [adena]
(21064,5287,1,1,1,31.144561),-- [sealed_dark_crystal_breastplate]
(21064,5520,1,1,1,3577.166957),-- [sealed_dark_crystal_breastplate_pattern]
(21064,5293,1,1,1,19.172167),-- [sealed_tallum_plate_armor]
(21064,5521,1,1,1,2524.191404),-- [sealed_tallum_plate_armor_pattern]
(21064,5288,1,1,1,49.838299),-- [sealed_dark_crystal_gaiters]
(21064,5524,1,1,1,5467.486612),-- [sealed_dark_crystal_gaiters_pattern]
(21064,1872,1,3,2,184888.594158),-- [animal_bone]
(21064,1867,1,3,2,123259.370568),-- [animal_skin]
(21064,1881,1,1,2,36977.534154),-- [coarse_bone_powder]
(21064,1875,1,1,2,18488.997924),-- [stone_of_purity]
(21064,4041,1,1,2,2411.427762),-- [mold_hardener]
(21064,4130,1,1,2,4501.978194),-- [rp_ring_of_black_ore]
(21064,4403,1,1,2,554.494494),-- [red_dimension_stone]
(21064,8730,1,1,2,3081.345756),-- [general_67_a]
(21064,8740,1,1,2,770.567286),-- [special_67_a]
(21064,8750,1,1,2,77.102898),-- [rare_67_a]
(21064,8760,1,1,2,15.235902),-- [unique_67_a]
(21064,1344,40,120,2,86667.350904),-- [mithril_arrow]
(21065,4120,1,1,-1,44373),-- [bellion_cestus_edge]
(21065,1807,1,1,-1,13539),-- [rp_soulshot_a]
(21065,57,5007,10224,0,700000),-- [adena]
(21065,5291,1,1,1,105.318486),-- [sealed_dark_crystal_boots]
(21065,5496,1,1,1,10990.181514),-- [sealed_dark_crystal_boots_lining]
(21065,5296,1,1,1,105.318486),-- [sealed_tallum_boots]
(21065,5497,1,1,1,10990.181514),-- [sealed_tallum_boots_lining]
(21065,5290,1,1,1,105.318486),-- [sealed_dark_crystal_gloves]
(21065,5508,1,1,1,10990.181514),-- [sealed_dark_crystal_gloves_design]
(21065,5295,1,1,1,105.318486),-- [sealed_tallum_gloves]
(21065,5509,1,1,1,10990.181514),-- [sealed_tallum_gloves_design]
(21065,1872,1,3,2,227233.97532),-- [animal_bone]
(21065,1867,1,3,2,151489.31688),-- [animal_skin]
(21065,1881,1,1,2,45446.795064),-- [coarse_bone_powder]
(21065,1875,1,1,2,22723.397532),-- [stone_of_purity]
(21065,4041,1,1,2,2963.702544),-- [mold_hardener]
(21065,4164,1,1,2,2257.100208),-- [rp_hose_of_doom]
(21065,4401,1,1,2,681.88956),-- [green_dimension_stone]
(21065,8730,1,1,2,3787.0041),-- [general_67_a]
(21065,8740,1,1,2,946.865436),-- [special_67_a]
(21065,8750,1,1,2,94.732308),-- [rare_67_a]
(21065,8760,1,1,2,19.221048),-- [unique_67_a]
(21066,5230,1,1,-1,13627),-- [rp_mithril_arrow]
(21066,4081,1,1,-1,100730),-- [doom_plate_armor_temper]
(21066,5482,1,1,-1,134892),-- [sealed_legging_of_dark_crystal_design]
(21066,57,5047,10276,0,700000),-- [adena]
(21066,5292,1,1,1,134.52984),-- [sealed_dark_crystal_shield]
(21066,5494,1,1,1,13207.500015),-- [sealed_dark_crystal_shield_fragment]
(21066,5289,1,1,1,94.137915),-- [sealed_dark_crystal_helmet]
(21066,5525,1,1,1,9721.363644),-- [sealed_dark_crystal_helmet_design]
(21066,5294,1,1,1,94.137915),-- [sealed_tallum_bonnet]
(21066,5526,1,1,1,9721.330671),-- [sealed_tallum_bonnet_design]
(21066,1868,3,9,2,104821.254228),-- [thread]
(21066,1873,1,1,2,125785.638128),-- [silver_nugget]
(21066,5549,1,1,2,31446.409532),-- [iron_thread]
(21066,1889,1,1,2,20964.3839),-- [compound_braid]
(21066,4044,1,1,2,10482.025632),-- [thons]
(21066,4613,1,1,2,433.757344),-- [dye_s4c4_c]
(21066,729,1,1,2,34.92678),-- [scrl_of_ench_wp_a]
(21066,6671,1,1,2,34940.418076),-- [key_of_treasure_box7]
(21066,8731,1,1,2,2911.562908),-- [general_70_a]
(21066,8741,1,1,2,727.807568),-- [special_70_a]
(21066,8751,1,1,2,72.847284),-- [rare_70_a]
(21066,8761,1,1,2,14.96862),-- [unique_70_a]
(21068,3035,1,1,-1,32034),-- [rp_spiritshot_a]
(21068,5485,1,1,-1,202033),-- [sealed_tallum_tunic_texture]
(21068,5479,1,1,-1,142164),-- [sealed_tallum_leather_mail_pattern]
(21068,57,11856,24167,0,700000),-- [adena]
(21068,5287,1,1,1,83.016576),-- [sealed_dark_crystal_breastplate]
(21068,5520,1,1,1,9535.024512),-- [sealed_dark_crystal_breastplate_pattern]
(21068,5293,1,1,1,51.103872),-- [sealed_tallum_plate_armor]
(21068,5521,1,1,1,6728.292864),-- [sealed_tallum_plate_armor_pattern]
(21068,5288,1,1,1,132.845184),-- [sealed_dark_crystal_gaiters]
(21068,5524,1,1,1,14573.716992),-- [sealed_dark_crystal_gaiters_pattern]
(21068,1869,18,54,2,22401.583128),-- [iron_ore]
(21068,1870,2,6,2,161291.488716),-- [coal]
(21068,1871,3,9,2,134409.498768),-- [charcoal]
(21068,1872,7,21,2,76805.492292),-- [animal_bone]
(21068,1867,12,36,2,44803.166256),-- [animal_skin]
(21068,4402,1,1,2,1613.126844),-- [blue_dimension_stone]
(21068,729,1,1,2,89.743428),-- [scrl_of_ench_wp_a]
(21068,8731,1,1,2,7467.194376),-- [general_70_a]
(21068,8741,1,1,2,1867.02408),-- [special_70_a]
(21068,8751,1,1,2,186.702408),-- [rare_70_a]
(21068,8761,1,1,2,36.979704),-- [unique_70_a]
(21069,4080,1,1,-1,265874),-- [blue_wolve's_gaiters_material]
(21069,4041,1,1,-1,112395),-- [mold_hardener]
(21069,3035,1,1,-1,17234),-- [rp_spiritshot_a]
(21069,57,6379,13001,0,700000),-- [adena]
(21069,5291,1,1,1,134.057889),-- [sealed_dark_crystal_boots]
(21069,5496,1,1,1,13989.192111),-- [sealed_dark_crystal_boots_lining]
(21069,5296,1,1,1,134.057889),-- [sealed_tallum_boots]
(21069,5497,1,1,1,13989.192111),-- [sealed_tallum_boots_lining]
(21069,5290,1,1,1,134.057889),-- [sealed_dark_crystal_gloves]
(21069,5508,1,1,1,13989.192111),-- [sealed_dark_crystal_gloves_design]
(21069,5295,1,1,1,134.057889),-- [sealed_tallum_gloves]
(21069,5509,1,1,1,13989.192111),-- [sealed_tallum_gloves_design]
(21069,1871,1,3,2,198852.888312),-- [charcoal]
(21069,1866,1,1,2,265137.184416),-- [suede]
(21069,1877,1,1,2,15908.072024),-- [admantite_nugget]
(21069,4041,1,1,2,3458.146874),-- [mold_hardener]
(21069,4040,1,1,2,7954.036012),-- [mold_lubricant]
(21069,4619,1,1,2,548.691312),-- [dye_i4m4_c]
(21069,5422,1,1,2,386.171331),-- [rp_sealed_majestic_platte_armor_i]
(21069,729,1,1,2,44.233267),-- [scrl_of_ench_wp_a]
(21069,8731,1,1,2,3682.295227),-- [general_70_a]
(21069,8741,1,1,2,920.449556),-- [special_70_a]
(21069,8751,1,1,2,91.945555),-- [rare_70_a]
(21069,8761,1,1,2,18.886114),-- [unique_70_a]
(21071,5486,1,1,-1,147834),-- [sealed_dark_crystal_robe_fabric]
(21071,5156,1,1,-1,33312),-- [rp_comp_soulshot_a]
(21071,5489,1,1,-1,329756),-- [sealed_tallum_hose_fabric]
(21071,57,12324,25146,0,700000),-- [adena]
(21071,5297,1,1,1,115.124142),-- [sealed_dark_crystal_leather_mail]
(21071,5478,1,1,1,12927.753902),-- [sealed_dark_crystal_leather_mail_pattern]
(21071,5301,1,1,1,70.816074),-- [sealed_tallum_leather_mail]
(21071,5479,1,1,1,9096.856146),-- [sealed_tallum_leather_mail_pattern]
(21071,5298,1,1,1,184.104718),-- [sealed_legging_of_dark_crystal]
(21071,5482,1,1,1,20291.345018),-- [sealed_legging_of_dark_crystal_design]
(21071,1894,1,1,2,32367.841994),-- [crafted_leather]
(21071,4039,1,1,2,30749.484325),-- [mold_glue]
(21071,4041,1,1,2,8021.549717),-- [mold_hardener]
(21071,4044,1,1,2,30749.484325),-- [thons]
(21071,4403,1,1,2,1844.911675),-- [red_dimension_stone]
(21071,729,1,1,2,102.488717),-- [scrl_of_ench_wp_a]
(21071,8731,1,1,2,8541.568056),-- [general_70_a]
(21071,8741,1,1,2,2135.392014),-- [special_70_a]
(21071,8751,1,1,2,213.585109),-- [rare_70_a]
(21071,8761,1,1,2,42.694068),-- [unique_70_a]
(21072,4083,1,1,-1,119814),-- [leather_mail_of_doom_design]
(21072,5230,1,1,-1,14138),-- [rp_mithril_arrow]
(21072,5161,1,1,-1,14138),-- [rp_comp_spiritshot_a]
(21072,57,5231,10672,0,700000),-- [adena]
(21072,5292,1,1,1,139.5768),-- [sealed_dark_crystal_shield]
(21072,5494,1,1,1,13702.98655),-- [sealed_dark_crystal_shield_fragment]
(21072,5289,1,1,1,97.66955),-- [sealed_dark_crystal_helmet]
(21072,5525,1,1,1,10086.06588),-- [sealed_dark_crystal_helmet_design]
(21072,5294,1,1,1,97.66955),-- [sealed_tallum_bonnet]
(21072,5526,1,1,1,10086.03167),-- [sealed_tallum_bonnet_design]
(21072,1868,3,9,2,118641.414714),-- [thread]
(21072,1873,1,1,2,142369.63003),-- [silver_nugget]
(21072,5549,1,1,2,35592.322974),-- [iron_thread]
(21072,1889,1,1,2,23728.215316),-- [compound_braid]
(21072,4044,1,1,2,11864.107658),-- [thons]
(21072,4984,1,1,2,1008.315588),-- [rp_blue_wolve's_leather_mail_i]
(21072,4403,1,1,2,711.77207),-- [red_dimension_stone]
(21072,8731,1,1,2,3295.453964),-- [general_70_a]
(21072,8741,1,1,2,824.032558),-- [special_70_a]
(21072,8751,1,1,2,82.504696),-- [rare_70_a]
(21072,8761,1,1,2,16.230432),-- [unique_70_a]
(21073,5230,1,1,-1,7723),-- [rp_mithril_arrow]
(21073,4052,1,1,-1,205074),-- [earing_of_black_ore_piece]
(21073,57,2300,4651,0,700000),-- [adena]
(21073,287,1,1,1,16.95579),-- [hazard_bow]
(21073,4121,1,1,1,3726.04421),-- [hazard_bow_shaft]
(21073,1869,1,1,2,155542.380381),-- [iron_ore]
(21073,1864,1,3,2,155542.380381),-- [stem]
(21073,1880,1,1,2,15554.118345),-- [steel]
(21073,5550,1,1,2,2073.882446),-- [reinforcing_plate]
(21073,4043,1,1,2,5184.706115),-- [asofe]
(21073,1830,1,1,2,62216.872357),-- [scroll_of_escape_to_castle]
(21073,5276,1,1,2,207.46804),-- [rp_adv_comp_spiritshot_a]
(21073,8729,1,1,2,2073.882446),-- [general_64_a]
(21073,8739,1,1,2,518.6701),-- [special_64_a]
(21073,8749,1,1,2,51.86701),-- [rare_64_a]
(21073,8759,1,1,2,10.772379),-- [unique_64_a]
(21074,5478,1,1,-1,50828),-- [sealed_dark_crystal_leather_mail_pattern]
(21074,1874,1,1,-1,402961),-- [oriharukon_ore]
(21074,5482,1,1,-1,79779),-- [sealed_legging_of_dark_crystal_design]
(21074,57,2981,6086,0,700000),-- [adena]
(21074,5291,1,1,1,62.689914),-- [sealed_dark_crystal_boots]
(21074,5496,1,1,1,6541.810086),-- [sealed_dark_crystal_boots_lining]
(21074,5296,1,1,1,62.689914),-- [sealed_tallum_boots]
(21074,5497,1,1,1,6541.810086),-- [sealed_tallum_boots_lining]
(21074,5290,1,1,1,62.689914),-- [sealed_dark_crystal_gloves]
(21074,5508,1,1,1,6541.810086),-- [sealed_dark_crystal_gloves_design]
(21074,5295,1,1,1,62.689914),-- [sealed_tallum_gloves]
(21074,5509,1,1,1,6541.810086),-- [sealed_tallum_gloves_design]
(21074,1870,1,1,2,202889.768632),-- [coal]
(21074,1865,1,1,2,202889.768632),-- [varnish]
(21074,1874,1,1,2,13526.100884),-- [oriharukon_ore]
(21074,4043,1,1,2,6763.050442),-- [asofe]
(21074,4039,1,1,2,6763.050442),-- [mold_glue]
(21074,5166,1,1,2,270.41734),-- [rp_comp_bspiritshot_a]
(21074,730,1,1,2,169.228916),-- [scrl_of_ench_am_a]
(21074,8730,1,1,2,2254.495533),-- [general_67_a]
(21074,8740,1,1,2,563.514844),-- [special_67_a]
(21074,8750,1,1,2,56.264253),-- [rare_67_a]
(21074,8760,1,1,2,11.340082),-- [unique_67_a]
(21075,4616,1,1,-1,7536),-- [dye_c4c4_c]
(21075,4052,1,1,-1,193443),-- [earing_of_black_ore_piece]
(21075,4041,1,1,-1,47511),-- [mold_hardener]
(21075,57,2167,4388,0,700000),-- [adena]
(21075,601,1,1,1,65.204056),-- [doom_boots]
(21075,4099,1,1,1,9056.795944),-- [doom_boots_part]
(21075,2439,1,1,1,65.204056),-- [blue_wolve's_boots]
(21075,4090,1,1,1,9056.795944),-- [blue_wolve's_boots_design]
(21075,2475,1,1,1,65.204056),-- [doom_gloves]
(21075,4091,1,1,1,9056.795944),-- [doom_gloves_part]
(21075,2487,1,1,1,65.204056),-- [blue_wolve's_gloves]
(21075,4096,1,1,1,9056.795944),-- [blue_wolve's_gloves_fabric]
(21075,1871,1,1,2,134493.480225),-- [charcoal]
(21075,1866,1,1,2,89662.32015),-- [suede]
(21075,1877,1,1,2,5379.739209),-- [admantite_nugget]
(21075,4041,1,1,2,1169.518792),-- [mold_hardener]
(21075,4040,1,1,2,2689.98769),-- [mold_lubricant]
(21075,5005,1,1,2,102.734385),-- [rp_demon's_sword_i]
(21075,5276,1,1,2,179.253789),-- [rp_adv_comp_spiritshot_a]
(21075,5418,1,1,2,198.619811),-- [rp_sealed_tallum_plate_armor_i]
(21075,8729,1,1,2,1793.246403),-- [general_64_a]
(21075,8739,1,1,2,448.252558),-- [special_64_a]
(21075,8749,1,1,2,44.87249),-- [rare_64_a]
(21075,8759,1,1,2,8.974498),-- [unique_64_a]
(21076,4052,1,1,-1,189765),-- [earing_of_black_ore_piece]
(21076,5230,1,1,-1,7147),-- [rp_mithril_arrow]
(21076,4053,1,1,-1,229743),-- [ring_of_black_ore_gemstone]
(21076,57,2126,4306,0,700000),-- [adena]
(21076,2398,1,1,1,21.314447),-- [blue_wolve's_tunic]
(21076,4084,1,1,1,3440.532768),-- [blue_wolve's_tunic_fabric]
(21076,2399,1,1,1,21.314447),-- [tunic_of_doom]
(21076,4085,1,1,1,3440.532768),-- [tunic_of_doom_pattern]
(21076,2403,1,1,1,34.129168),-- [blue_wolve's_hose]
(21076,4086,1,1,1,4645.507334),-- [blue_wolve's_hose_pattern]
(21076,2404,1,1,1,34.129168),-- [hose_of_doom]
(21076,4087,1,1,1,4645.5399),-- [hose_of_doom_pattern]
(21076,1871,1,1,2,158323.32098),-- [charcoal]
(21076,1866,1,1,2,105549.10784),-- [suede]
(21076,1877,1,1,2,6333.05552),-- [admantite_nugget]
(21076,4041,1,1,2,1376.7512),-- [mold_hardener]
(21076,4040,1,1,2,3166.52776),-- [mold_lubricant]
(21076,1830,1,1,2,63329.53286),-- [scroll_of_escape_to_castle]
(21076,8729,1,1,2,2111.1321),-- [general_64_a]
(21076,8739,1,1,2,527.86822),-- [special_64_a]
(21076,8749,1,1,2,52.8209),-- [rare_64_a]
(21076,8759,1,1,2,9.88262),-- [unique_64_a]
(21077,5230,1,1,-1,6798),-- [rp_mithril_arrow]
(21077,4054,1,1,-1,100424),-- [necklace_of_black_ore_beads]
(21077,4041,1,1,-1,44335),-- [mold_hardener]
(21077,57,2022,4096,0,700000),-- [adena]
(21077,864,1,1,1,70.60721),-- [earing_of_black_ore]
(21077,4052,1,1,1,8886.33308),-- [earing_of_black_ore_piece]
(21077,926,1,1,1,52.961612),-- [necklace_of_black_ore]
(21077,4054,1,1,1,4943.7456),-- [necklace_of_black_ore_beads]
(21077,895,1,1,1,105.898406),-- [ring_of_black_ore]
(21077,4053,1,1,1,10758.454092),-- [ring_of_black_ore_gemstone]
(21077,1872,1,1,2,167336.28288),-- [animal_bone]
(21077,1867,1,1,2,167336.28288),-- [animal_skin]
(21077,1881,1,1,2,16733.718885),-- [coarse_bone_powder]
(21077,1875,1,1,2,8366.63295),-- [stone_of_purity]
(21077,4041,1,1,2,1091.240865),-- [mold_hardener]
(21077,5230,1,1,2,167.151465),-- [rp_mithril_arrow]
(21077,5276,1,1,2,167.151465),-- [rp_adv_comp_spiritshot_a]
(21077,8729,1,1,2,1673.32659),-- [general_64_a]
(21077,8739,1,1,2,418.55814),-- [special_64_a]
(21077,8749,1,1,2,41.67462),-- [rare_64_a]
(21077,8759,1,1,2,8.15373),-- [unique_64_a]
(21077,1343,20,60,2,89644.82553),-- [silver_arrow]
(21078,4040,1,1,-1,135112),-- [mold_lubricant]
(21078,5485,1,1,-1,56808),-- [sealed_tallum_tunic_texture]
(21078,3956,1,1,-1,9007),-- [rp_blessed_spiritshot_a]
(21078,57,2672,5436,0,700000),-- [adena]
(21078,5292,1,1,1,71.13888),-- [sealed_dark_crystal_shield]
(21078,5494,1,1,1,6984.07698),-- [sealed_dark_crystal_shield_fragment]
(21078,5289,1,1,1,49.77978),-- [sealed_dark_crystal_helmet]
(21078,5525,1,1,1,5140.621008),-- [sealed_dark_crystal_helmet_design]
(21078,5294,1,1,1,49.77978),-- [sealed_tallum_bonnet]
(21078,5526,1,1,1,5140.603572),-- [sealed_tallum_bonnet_design]
(21078,1873,1,1,2,79819.857375),-- [silver_nugget]
(21078,1868,1,3,2,199549.836589),-- [thread]
(21078,1876,1,1,2,39910.121839),-- [mithril_ore]
(21078,1895,1,1,2,57014.45977),-- [metallic_fiber]
(21078,4042,1,1,2,3325.682527),-- [enria]
(21078,4175,1,1,2,3844.873759),-- [rp_avadon_boots]
(21078,8730,1,1,2,2217.37922),-- [general_67_a]
(21078,8740,1,1,2,554.344805),-- [special_67_a]
(21078,8750,1,1,2,55.241329),-- [rare_67_a]
(21078,8760,1,1,2,11.202787),-- [unique_67_a]
(21079,1895,1,3,-1,918483),-- [metallic_fiber]
(21079,4042,1,1,-1,107156),-- [enria]
(21079,5478,1,1,-1,54065),-- [sealed_dark_crystal_leather_mail_pattern]
(21079,57,2545,5167,0,700000),-- [adena]
(21079,5304,1,1,1,23.701236),-- [sealed_tallum_tunic]
(21079,5485,1,1,1,2661.507316),-- [sealed_tallum_tunic_texture]
(21079,5308,1,1,1,14.579292),-- [sealed_dark_crystal_robe]
(21079,5486,1,1,1,1872.819468),-- [sealed_dark_crystal_robe_fabric]
(21079,5305,1,1,1,37.902644),-- [sealed_tallum_hose]
(21079,5489,1,1,1,4177.490044),-- [sealed_tallum_hose_fabric]
(21079,1873,1,1,2,69059.696958),-- [silver_nugget]
(21079,1868,1,3,2,172649.076758),-- [thread]
(21079,1876,1,1,2,34529.682842),-- [mithril_ore]
(21079,1895,1,1,2,49328.35497),-- [metallic_fiber]
(21079,4042,1,1,2,2877.445964),-- [enria]
(21079,5161,1,1,2,230.23543),-- [rp_comp_spiritshot_a]
(21079,730,1,1,2,143.772916),-- [scrl_of_ench_am_a]
(21079,8730,1,1,2,1918.407734),-- [general_67_a]
(21079,8740,1,1,2,479.684752),-- [special_67_a]
(21079,8750,1,1,2,48.03473),-- [rare_67_a]
(21079,8760,1,1,2,9.606946),-- [unique_67_a]
(21080,1807,1,1,-1,7923),-- [rp_soulshot_a]
(21080,5479,1,1,-1,35162),-- [sealed_tallum_leather_mail_pattern]
(21080,3035,1,1,-1,7923),-- [rp_spiritshot_a]
(21080,57,2352,4776,0,700000),-- [adena]
(21080,6324,1,1,1,58.217938),-- [sealed_phoenix's_earing]
(21080,6341,1,1,1,8091.08426),-- [sealed_phoenix's_earing_gemstone]
(21080,6323,1,1,1,43.657022),-- [sealed_phoenix's_necklace]
(21080,6343,1,1,1,6254.710928),-- [sealed_phoenix's_necklace_beads]
(21080,6325,1,1,1,87.314044),-- [sealed_phoenix's_ring]
(21080,6345,1,1,1,11191.015808),-- [sealed_phoenix's_ring_gemstone]
(21080,1864,1,3,2,146273.299821),-- [stem]
(21080,1869,1,1,2,146273.299821),-- [iron_ore]
(21080,1878,1,1,2,58509.229293),-- [braided_hemp]
(21080,1884,1,1,2,90014.094333),-- [cord]
(21080,4039,1,1,2,4875.731343),-- [mold_glue]
(21080,5166,1,1,2,194.86611),-- [rp_comp_bspiritshot_a]
(21080,8314,1,1,2,79.759152),-- [rp_eye_of_soul_i]
(21080,8730,1,1,2,1625.092722),-- [general_67_a]
(21080,8740,1,1,2,406.499769),-- [special_67_a]
(21080,8750,1,1,2,40.78593),-- [rare_67_a]
(21080,8760,1,1,2,8.157186),-- [unique_67_a]
(21080,6036,1,1,2,4876.18452),-- [potion_of_acumen3]
(21081,5230,1,1,-1,8037),-- [rp_mithril_arrow]
(21081,4119,1,1,-1,26385),-- [demon's_sword_edge]
(21081,5478,1,1,-1,50689),-- [sealed_dark_crystal_leather_mail_pattern]
(21081,57,2973,6067,0,700000),-- [adena]
(21081,5297,1,1,1,27.776403),-- [sealed_dark_crystal_leather_mail]
(21081,5478,1,1,1,3119.124243),-- [sealed_dark_crystal_leather_mail_pattern]
(21081,5301,1,1,1,17.086041),-- [sealed_tallum_leather_mail]
(21081,5479,1,1,1,2194.830189),-- [sealed_tallum_leather_mail_pattern]
(21081,5298,1,1,1,44.419587),-- [sealed_legging_of_dark_crystal]
(21081,5482,1,1,1,4895.763537),-- [sealed_legging_of_dark_crystal_design]
(21081,1872,1,3,2,148380.202152),-- [animal_bone]
(21081,1867,1,1,2,296759.909446),-- [animal_skin]
(21081,1881,1,1,2,29676.139402),-- [coarse_bone_powder]
(21081,1875,1,1,2,14837.822272),-- [stone_of_purity]
(21081,4041,1,1,2,1935.389638),-- [mold_hardener]
(21081,4985,1,1,2,630.449092),-- [rp_leather_mail_of_doom_i]
(21081,8731,1,1,2,2060.588712),-- [general_70_a]
(21081,8741,1,1,2,515.147178),-- [special_70_a]
(21081,8751,1,1,2,51.465232),-- [rare_70_a]
(21081,8761,1,1,2,10.886876),-- [unique_70_a]
(21082,5482,1,1,-1,76302),-- [sealed_legging_of_dark_crystal_design]
(21082,5486,1,1,-1,34207),-- [sealed_dark_crystal_robe_fabric]
(21082,5156,1,1,-1,7708),-- [rp_comp_soulshot_a]
(21082,57,2853,5815,0,700000),-- [adena]
(21082,5304,1,1,1,26.638269),-- [sealed_tallum_tunic]
(21082,5485,1,1,1,2991.318589),-- [sealed_tallum_tunic_texture]
(21082,5308,1,1,1,16.385943),-- [sealed_dark_crystal_robe]
(21082,5486,1,1,1,2104.897347),-- [sealed_dark_crystal_robe_fabric]
(21082,5305,1,1,1,42.599501),-- [sealed_tallum_hose]
(21082,5489,1,1,1,4695.160351),-- [sealed_tallum_hose_fabric]
(21082,1865,1,1,2,213451.890565),-- [varnish]
(21082,1870,1,1,2,213451.890565),-- [coal]
(21082,1879,1,1,2,35575.234462),-- [cokes]
(21082,1875,1,1,2,14230.287302),-- [stone_of_purity]
(21082,4040,1,1,2,4268.989432),-- [mold_lubricant]
(21082,5281,1,1,2,284.470284),-- [rp_adv_comp_bspiritshot_a]
(21082,8731,1,1,2,1976.294405),-- [general_70_a]
(21082,8741,1,1,2,493.952653),-- [special_70_a]
(21082,8751,1,1,2,49.346886),-- [rare_70_a]
(21082,8761,1,1,2,10.643446),-- [unique_70_a]
(21083,5485,1,1,-1,50785),-- [sealed_tallum_tunic_texture]
(21083,5156,1,1,-1,8052),-- [rp_comp_soulshot_a]
(21083,5486,1,1,-1,35736),-- [sealed_dark_crystal_robe_fabric]
(21083,57,2980,6075,0,700000),-- [adena]
(21083,6324,1,1,1,73.959366),-- [sealed_phoenix's_earing]
(21083,6341,1,1,1,10278.81582),-- [sealed_phoenix's_earing_gemstone]
(21083,6323,1,1,1,55.461354),-- [sealed_phoenix's_necklace]
(21083,6343,1,1,1,7945.909296),-- [sealed_phoenix's_necklace_beads]
(21083,6325,1,1,1,110.922708),-- [sealed_phoenix's_ring]
(21083,6345,1,1,1,14216.931456),-- [sealed_phoenix's_ring_gemstone]
(21083,1866,1,1,2,135145.54431),-- [suede]
(21083,1871,1,1,2,202718.13273),-- [charcoal]
(21083,5220,1,1,2,8108.59302),-- [reinforcing_agent]
(21083,1885,1,1,2,16893.33084),-- [high_grade_suede]
(21083,4041,1,1,2,1762.75359),-- [mold_hardener]
(21083,1807,1,1,2,270.45792),-- [rp_soulshot_a]
(21083,730,1,1,2,169.0362),-- [scrl_of_ench_am_a]
(21083,8731,1,1,2,1877.03676),-- [general_70_a]
(21083,8741,1,1,2,469.25919),-- [special_70_a]
(21083,8751,1,1,2,47.03616),-- [rare_70_a]
(21083,8761,1,1,2,8.81928),-- [unique_70_a]
(21084,4129,1,1,-1,54392),-- [rp_earing_of_black_ore]
(21084,4056,1,1,-1,90964),-- [shrnoen's_breastplate_part]
(21084,57,1988,4041,0,700000),-- [adena]
(21084,78,1,1,1,7.408178),-- [great_sword]
(21084,4104,1,1,1,1415.883266),-- [great_sword_blade]
(21084,142,1,1,1,7.408178),-- [kshanberk]
(21084,4107,1,1,1,1393.9461),-- [kshanberk_blade]
(21084,148,1,1,1,7.408178),-- [sword_of_valhalla]
(21084,4108,1,1,1,1393.9461),-- [sword_of_valhalla_blade]
(21084,1868,1,1,2,228390.933016),-- [thread]
(21084,1873,1,1,2,45678.101277),-- [silver_nugget]
(21084,5549,1,1,2,11419.631977),-- [iron_thread]
(21084,1889,1,1,2,7613.230195),-- [compound_braid]
(21084,4044,1,1,2,3806.401782),-- [thons]
(21084,4196,1,1,2,87.032724),-- [rp_staff_of_evil_sprit]
(21084,4402,1,1,2,228.247585),-- [blue_dimension_stone]
(21084,5002,1,1,2,87.032724),-- [rp_deadman's_glory_i]
(21084,8728,1,1,2,1903.200891),-- [general_61_b]
(21084,8738,1,1,2,475.693565),-- [special_61_b]
(21084,8748,1,1,2,47.782672),-- [rare_61_b]
(21084,8758,1,1,2,9.385882),-- [unique_61_b]
(21084,1832,1,1,2,126884.32571),-- [advanced_antidote]
(21085,5479,1,1,-1,55365),-- [sealed_tallum_leather_mail_pattern]
(21085,5489,1,1,-1,123496),-- [sealed_tallum_hose_fabric]
(21085,1889,1,1,-1,623779),-- [compound_braid]
(21085,57,4617,9411,0,700000),-- [adena]
(21085,5297,1,1,1,43.114242),-- [sealed_dark_crystal_leather_mail]
(21085,5478,1,1,1,4841.472002),-- [sealed_dark_crystal_leather_mail_pattern]
(21085,5301,1,1,1,26.520774),-- [sealed_tallum_leather_mail]
(21085,5479,1,1,1,3406.792446),-- [sealed_tallum_leather_mail_pattern]
(21085,5298,1,1,1,68.947618),-- [sealed_legging_of_dark_crystal]
(21085,5482,1,1,1,7599.152918),-- [sealed_legging_of_dark_crystal_design]
(21085,1868,3,9,2,104690.175148),-- [thread]
(21085,1873,1,1,2,125628.272302),-- [silver_nugget]
(21085,5549,1,1,2,31406.99042),-- [iron_thread]
(21085,1889,1,1,2,20938.097154),-- [compound_braid]
(21085,4044,1,1,2,10468.893266),-- [thons]
(21085,4131,1,1,2,2553.31284),-- [rp_necklace_of_black_ore]
(21085,8730,1,1,2,3489.527548),-- [general_67_a]
(21085,8740,1,1,2,872.537198),-- [special_67_a]
(21085,8750,1,1,2,87.284782),-- [rare_67_a]
(21085,8760,1,1,2,17.394832),-- [unique_67_a]
(21085,6036,1,1,2,10469.51451),-- [potion_of_acumen3]
(21086,1807,1,1,-1,12483),-- [rp_soulshot_a]
(21086,5482,1,1,-1,123574),-- [sealed_legging_of_dark_crystal_design]
(21086,1895,1,5,-1,891673),-- [metallic_fiber]
(21086,57,4617,9427,0,700000),-- [adena]
(21086,5287,1,1,1,32.350949),-- [sealed_dark_crystal_breastplate]
(21086,5520,1,1,1,3715.728913),-- [sealed_dark_crystal_breastplate_pattern]
(21086,5293,1,1,1,19.914803),-- [sealed_tallum_plate_armor]
(21086,5521,1,1,1,2621.966236),-- [sealed_tallum_plate_armor_pattern]
(21086,5288,1,1,1,51.768791),-- [sealed_dark_crystal_gaiters]
(21086,5524,1,1,1,5679.270308),-- [sealed_dark_crystal_gaiters_pattern]
(21086,1895,1,1,2,98770.285188),-- [metallic_fiber]
(21086,4040,1,1,2,6913.954136),-- [mold_lubricant]
(21086,4042,1,1,2,5761.540824),-- [enria]
(21086,4043,1,1,2,11523.213082),-- [asofe]
(21086,4166,1,1,2,2856.980858),-- [rp_doom_helmet]
(21086,4401,1,1,2,691.34284),-- [green_dimension_stone]
(21086,8730,1,1,2,3841.027216),-- [general_67_a]
(21086,8740,1,1,2,960.256804),-- [special_67_a]
(21086,8750,1,1,2,96.078254),-- [rare_67_a]
(21086,8760,1,1,2,19.320798),-- [unique_67_a]
(21087,4082,1,1,-1,146799),-- [blue_wolve's_leather_mail_texture]
(21087,1894,1,1,-1,455851),-- [crafted_leather]
(21087,5494,1,1,-1,272850),-- [sealed_dark_crystal_shield_fragment]
(21087,57,6416,13062,0,700000),-- [adena]
(21087,5287,1,1,1,44.889911),-- [sealed_dark_crystal_breastplate]
(21087,5520,1,1,1,5155.914907),-- [sealed_dark_crystal_breastplate_pattern]
(21087,5293,1,1,1,27.633617),-- [sealed_tallum_plate_armor]
(21087,5521,1,1,1,3638.218804),-- [sealed_tallum_plate_armor_pattern]
(21087,5288,1,1,1,71.833949),-- [sealed_dark_crystal_gaiters]
(21087,5524,1,1,1,7880.508812),-- [sealed_dark_crystal_gaiters_pattern]
(21087,1869,2,6,2,92249.215127),-- [iron_ore]
(21087,1864,5,15,2,73799.494938),-- [stem]
(21087,1880,1,1,2,36899.747469),-- [steel]
(21087,5550,1,1,2,4919.904911),-- [reinforcing_plate]
(21087,4043,1,1,2,12299.915823),-- [asofe]
(21087,4614,1,1,2,508.849787),-- [dye_s4d4_c]
(21087,6037,9,27,2,40999.71941),-- [scroll_of_awake]
(21087,729,1,1,2,41.150194),-- [scrl_of_ench_wp_a]
(21087,6671,1,1,2,40999.71941),-- [key_of_treasure_box7]
(21087,8731,1,1,2,3416.694466),-- [general_70_a]
(21087,8741,1,1,2,854.020071),-- [special_70_a]
(21087,8751,1,1,2,85.371298),-- [rare_70_a]
(21087,8761,1,1,2,17.197096),-- [unique_70_a]
(21088,5338,1,1,-1,12863),-- [rp_sealed_majestic_leather_mail_i]
(21088,4042,1,1,-1,165717),-- [enria]
(21088,5485,1,1,-1,83611),-- [sealed_tallum_tunic_texture]
(21088,57,4907,10001,0,700000),-- [adena]
(21088,5304,1,1,1,45.816636),-- [sealed_tallum_tunic]
(21088,5485,1,1,1,5144.934716),-- [sealed_tallum_tunic_texture]
(21088,5308,1,1,1,28.183092),-- [sealed_dark_crystal_robe]
(21088,5486,1,1,1,3620.329668),-- [sealed_dark_crystal_robe_fabric]
(21088,5305,1,1,1,73.269244),-- [sealed_tallum_hose]
(21088,5489,1,1,1,8075.466644),-- [sealed_tallum_hose_fabric]
(21088,1873,1,1,2,146851.06194),-- [silver_nugget]
(21088,1868,3,9,2,122375.96154),-- [thread]
(21088,1876,1,1,2,73425.76074),-- [mithril_ore]
(21088,1895,1,1,2,104893.68132),-- [metallic_fiber]
(21088,4042,1,1,2,6118.7751),-- [enria]
(21088,4986,1,1,2,1523.3751),-- [rp_blue_wolve's_tunic_i]
(21088,8731,1,1,2,3399.21738),-- [general_70_a]
(21088,8741,1,1,2,849.68946),-- [special_70_a]
(21088,8751,1,1,2,85.0149),-- [rare_70_a]
(21088,8761,1,1,2,17.46252),-- [unique_70_a]
(21089,4116,1,1,-1,50514),-- [deadman's_glory_stone]
(21089,3035,1,1,-1,15413),-- [rp_spiritshot_a]
(21089,5480,1,1,-1,51871),-- [sealed_leather_mail_of_nightmare_fabric]
(21089,57,5702,11635,0,700000),-- [adena]
(21089,5304,1,1,1,53.26575),-- [sealed_tallum_tunic]
(21089,5485,1,1,1,5981.42575),-- [sealed_tallum_tunic_texture]
(21089,5308,1,1,1,32.76525),-- [sealed_dark_crystal_robe]
(21089,5486,1,1,1,4208.94225),-- [sealed_dark_crystal_robe_fabric]
(21089,5305,1,1,1,85.18175),-- [sealed_tallum_hose]
(21089,5489,1,1,1,9388.41925),-- [sealed_tallum_hose_fabric]
(21089,1873,2,6,2,42682.333768),-- [silver_nugget]
(21089,1868,3,9,2,142275.12292),-- [thread]
(21089,1876,1,1,2,85365.073752),-- [mithril_ore]
(21089,1895,1,1,2,121950.10536),-- [metallic_fiber]
(21089,4042,1,1,2,7113.654592),-- [enria]
(21089,4986,1,1,2,1771.10176),-- [rp_blue_wolve's_tunic_i]
(21089,8731,1,1,2,3952.075464),-- [general_70_a]
(21089,8741,1,1,2,987.917312),-- [special_70_a]
(21089,8751,1,1,2,98.710488),-- [rare_70_a]
(21089,8761,1,1,2,19.904584),-- [unique_70_a]
(21090,5230,1,1,-1,11849),-- [rp_mithril_arrow]
(21090,5486,1,1,-1,52583),-- [sealed_dark_crystal_robe_fabric]
(21090,5156,1,1,-1,11849),-- [rp_comp_soulshot_a]
(21090,57,4384,8944,0,700000),-- [adena]
(21090,5287,1,1,1,30.704176),-- [sealed_dark_crystal_breastplate]
(21090,5520,1,1,1,3526.585712),-- [sealed_dark_crystal_breastplate_pattern]
(21090,5293,1,1,1,18.901072),-- [sealed_tallum_plate_armor]
(21090,5521,1,1,1,2488.499264),-- [sealed_tallum_plate_armor_pattern]
(21090,5288,1,1,1,49.133584),-- [sealed_dark_crystal_gaiters]
(21090,5524,1,1,1,5390.176192),-- [sealed_dark_crystal_gaiters_pattern]
(21090,1871,1,3,2,91143.638391),-- [charcoal]
(21090,1866,1,1,2,182286.809659),-- [suede]
(21090,1877,1,1,2,10937.217922),-- [admantite_nugget]
(21090,4041,1,1,2,2377.65607),-- [mold_hardener]
(21090,4040,1,1,2,5468.608961),-- [mold_lubricant]
(21090,4401,1,1,2,547.001033),-- [green_dimension_stone]
(21090,730,1,1,2,227.956024),-- [scrl_of_ench_am_a]
(21090,8731,1,1,2,2531.80666),-- [general_70_a]
(21090,8741,1,1,2,632.951665),-- [special_70_a]
(21090,8751,1,1,2,63.061605),-- [rare_70_a]
(21090,8761,1,1,2,12.612321),-- [unique_70_a]
(21090,1344,20,60,2,170893.679689),-- [mithril_arrow]
(21091,5479,1,1,-1,35349),-- [sealed_tallum_leather_mail_pattern]
(21091,3035,1,1,-1,7965),-- [rp_spiritshot_a]
(21091,5336,1,1,-1,7728),-- [rp_sealed_leather_mail_of_nightmare_i]
(21091,57,2948,6009,0,700000),-- [adena]
(21091,5297,1,1,1,27.528279),-- [sealed_dark_crystal_leather_mail]
(21091,5478,1,1,1,3091.261399),-- [sealed_dark_crystal_leather_mail_pattern]
(21091,5301,1,1,1,16.933413),-- [sealed_tallum_leather_mail]
(21091,5479,1,1,1,2175.223977),-- [sealed_tallum_leather_mail_pattern]
(21091,5298,1,1,1,44.022791),-- [sealed_legging_of_dark_crystal]
(21091,5482,1,1,1,4852.030141),-- [sealed_legging_of_dark_crystal_design]
(21091,1867,1,3,2,210072.547114),-- [animal_skin]
(21091,1872,1,3,2,140048.218698),-- [animal_bone]
(21091,1882,1,1,2,70024.328416),-- [leather]
(21091,1894,1,1,2,11056.31149),-- [crafted_leather]
(21091,4042,1,1,2,5251.912258),-- [enria]
(21091,3035,1,1,2,420.170506),-- [rp_spiritshot_a]
(21091,10306,1,1,2,1260.511518),-- [sb_transform_doll_blader]
(21092,5485,1,1,-1,49077),-- [sealed_tallum_tunic_texture]
(21092,5161,1,1,-1,7782),-- [rp_comp_spiritshot_a]
(21092,5478,1,1,-1,49077),-- [sealed_dark_crystal_leather_mail_pattern]
(21092,57,2880,5870,0,700000),-- [adena]
(21092,5292,1,1,1,76.82232),-- [sealed_dark_crystal_shield]
(21092,5494,1,1,1,7542.050095),-- [sealed_dark_crystal_shield_fragment]
(21092,5289,1,1,1,53.756795),-- [sealed_dark_crystal_helmet]
(21092,5525,1,1,1,5551.316412),-- [sealed_dark_crystal_helmet_design]
(21092,5294,1,1,1,53.756795),-- [sealed_tallum_bonnet]
(21092,5526,1,1,1,5551.297583),-- [sealed_tallum_bonnet_design]
(21092,1868,4,12,2,67340.646289),-- [thread]
(21092,1873,1,1,2,107744.828485),-- [silver_nugget]
(21092,5549,1,1,2,26936.121464),-- [iron_thread]
(21092,1889,1,1,2,17957.528519),-- [compound_braid]
(21092,4044,1,1,2,8978.592945),-- [thons]
(21092,3956,1,1,2,359.075192),-- [rp_blessed_spiritshot_a]
(21092,10306,1,1,2,1077.568205),-- [sb_transform_doll_blader]
(21092,1344,30,90,2,112234.638901),-- [mithril_arrow]
(21093,1800,1,1,-1,83774),-- [rp_piece_bone_breastplate]
(21093,1897,1,1,-1,63429),-- [necklace_of_wisdom_chain]
(21093,1864,1,1,-1,532802),-- [stem]
(21093,57,125,213,0,700000),-- [adena]
(21093,2,1,1,1,74.977705),-- [long_sword]
(21093,120,1,1,1,74.977705),-- [sword_of_reflexion]
(21093,2012,1,1,1,820.066885),-- [sword_of_reflexion_blade]
(21093,121,1,1,1,74.977705),-- [sword_of_watershadow]
(21093,1864,1,1,2,78690.917104),-- [stem]
(21093,1869,1,1,2,39345.458552),-- [iron_ore]
(21093,1878,1,1,2,15738.21414),-- [braided_hemp]
(21093,1801,1,1,2,19821.410204),-- [rp_piece_bone_gaiters]
(21094,1870,1,1,-1,270215),-- [coal]
(21094,734,1,1,-1,45036),-- [quick_step_potion]
(21094,1924,1,1,-1,87166),-- [leather_helmet_design]
(21094,57,125,217,0,700000),-- [adena]
(21094,176,1,1,1,152),-- [apprentice's_staff]
(21094,2501,1,1,1,152),-- [bone_club]
(21094,1865,1,1,2,39908.853285),-- [varnish]
(21094,1870,1,1,2,39908.853285),-- [coal]
(21094,1879,1,1,2,6651.522773),-- [cokes]
(21094,2141,1,1,2,7981.770657),-- [rp_silver_mold]
(21095,1804,1,1,-1,15036),-- [rp_soulshot_d]
(21095,1898,1,1,-1,38613),-- [blue_diamond_necklace_gem]
(21095,2151,1,1,-1,104706),-- [rp_necklace_of_devotion]
(21095,57,171,306,0,700000),-- [adena]
(21095,257,1,1,1,236),-- [viper's_canine]
(21095,1870,1,1,2,55516.67957),-- [coal]
(21095,1865,1,1,2,55516.67957),-- [varnish]
(21095,1804,1,1,2,2220.771702),-- [rp_soulshot_d]
(21095,1831,1,1,2,148043.869158),-- [antidote]
(21096,1926,1,1,-1,37310),-- [piece_bone_breastplate_fragment]
(21096,1866,1,1,-1,246245),-- [suede]
(21096,1871,1,1,-1,369368),-- [charcoal]
(21096,57,168,301,0,700000),-- [adena]
(21096,39,1,1,1,1531.287612),-- [boots]
(21096,1930,1,1,1,18650.403063),-- [boots_lining]
(21096,51,1,1,1,1531.309325),-- [bracer]
(21096,1866,1,1,2,48491.470211),-- [suede]
(21096,1871,1,1,2,72737.127301),-- [charcoal]
(21096,2179,1,1,2,34802.402488),-- [rp_excellence_leather_gloves]
(21097,1927,1,1,-1,33847),-- [hard_leather_shirt_pattern]
(21097,2176,1,1,-1,203004),-- [rp_leather_boots]
(21097,1928,1,1,-1,61803),-- [piece_bone_gaiters_fragment]
(21097,57,194,343,0,700000),-- [adena]
(21097,846,1,1,1,1018.870708),-- [coral_earing]
(21097,909,1,1,1,764.155468),-- [blue_diamond_necklace]
(21097,1898,1,1,1,6436.65314),-- [blue_diamond_necklace_gem]
(21097,878,1,1,1,1528.320684),-- [blue_coral_ring]
(21097,1870,1,1,2,50130.015455),-- [coal]
(21097,1865,1,1,2,50130.015455),-- [varnish]
(21097,2257,1,1,2,1225.641193),-- [rp_trident]
(21097,734,1,1,2,8354.961989),-- [quick_step_potion]
(21097,1831,1,1,2,133680.365908),-- [antidote]
(21098,2177,1,1,-1,127600),-- [rp_bone_helmet]
(21098,1929,1,1,-1,51534),-- [hard_leather_gaiters_material]
(21098,1879,1,1,-1,66565),-- [cokes]
(21098,57,177,327,0,700000),-- [adena]
(21098,16,1,1,1,251),-- [long_spear]
(21098,1865,1,1,2,58986.680208),-- [varnish]
(21098,1870,1,1,2,58986.680208),-- [coal]
(21098,1879,1,1,2,9831.156756),-- [cokes]
(21098,5158,1,1,2,2359.482828),-- [rp_comp_spiritshot_d]
(21099,1875,1,1,-1,28539),-- [stone_of_purity]
(21099,1899,1,1,-1,66888),-- [necklace_of_devotion_chain]
(21099,2152,1,1,-1,75366),-- [rp_enchanted_necklace]
(21099,57,188,353,0,700000),-- [adena]
(21099,626,1,1,1,947.733136),-- [bronze_shield]
(21099,45,1,1,1,664.590628),-- [bone_helmet]
(21099,1932,1,1,1,12711.676236),-- [bone_helmet_design]
(21099,1875,1,1,2,3203.322531),-- [stone_of_purity]
(21099,1879,1,1,2,8008.344804),-- [cokes]
(21099,5549,1,1,2,4804.996622),-- [iron_thread]
(21099,2152,1,1,2,8459.520243),-- [rp_enchanted_necklace]
(21099,8294,1,1,2,1174.8158),-- [rp_iron_sword]
(21100,1897,1,1,-1,63429),-- [necklace_of_wisdom_chain]
(21100,1800,1,1,-1,83774),-- [rp_piece_bone_breastplate]
(21100,1924,1,1,-1,85936),-- [leather_helmet_design]
(21100,57,125,213,0,700000),-- [adena]
(21100,845,1,1,1,1150.453818),-- [cat'seye_earing]
(21100,908,1,1,1,862.846917),-- [necklace_of_wisdom]
(21100,1897,1,1,1,9368.018538),-- [necklace_of_wisdom_chain]
(21100,877,1,1,1,1725.680727),-- [ring_of_wisdom]
(21100,1869,1,1,2,39345.4152),-- [iron_ore]
(21100,1864,1,1,2,78690.96024),-- [stem]
(21100,1880,1,1,2,3934.54152),-- [steel]
(21100,1817,1,1,2,7869.08304),-- [rp_cord]
(21101,1870,1,1,-1,399388),-- [coal]
(21101,1865,1,1,-1,399388),-- [varnish]
(21101,1898,1,1,-1,41026),-- [blue_diamond_necklace_gem]
(21101,57,177,327,0,700000),-- [adena]
(21101,39,1,1,1,1655.762472),-- [boots]
(21101,1930,1,1,1,20166.451578),-- [boots_lining]
(21101,51,1,1,1,1655.78595),-- [bracer]
(21101,1870,1,1,2,47189.363348),-- [coal]
(21101,1865,1,1,2,47189.363348),-- [varnish]
(21101,5163,1,1,2,1887.598116),-- [rp_comp_bspiritshot_d]
(21101,6666,1,1,2,47189.363348),-- [key_of_treasure_box2]
(21101,6035,1,1,2,3932.31184),-- [potion_of_acumen2]
(21102,2153,1,1,-1,84230),-- [rp_tiger'seye_earing]
(21102,1900,1,1,-1,59256),-- [enchanted_necklace_chain]
(21102,2183,1,1,-1,35631),-- [rp_mithril_banded_mail]
(21102,57,228,457,0,700000),-- [adena]
(21102,433,1,1,1,96.214123),-- [elven_tunic]
(21102,434,1,1,1,96.214123),-- [white_tunic]
(21102,1936,1,1,1,3027.472147),-- [white_tunic_pattern]
(21102,435,1,1,1,96.214123),-- [mage's_tunic]
(21102,466,1,1,1,154.147498),-- [elven_hose]
(21102,467,1,1,1,154.147498),-- [dark_hose]
(21102,1933,1,1,1,4352.434859),-- [dark_hose_fabric]
(21102,468,1,1,1,154.155629),-- [mage's_hose]
(21102,1874,1,1,2,3288.45484),-- [oriharukon_ore]
(21102,1878,1,1,2,19730.78932),-- [braided_hemp]
(21102,1884,1,1,2,30355.01876),-- [cord]
(21102,1889,1,1,2,3288.45484),-- [compound_braid]
(21102,5220,1,1,2,1973.08496),-- [reinforcing_agent]
(21102,956,1,1,2,1644.19728),-- [scrl_of_ench_am_d]
(21103,1933,1,1,-1,66361),-- [dark_hose_fabric]
(21103,1879,1,1,-1,94011),-- [cokes]
(21103,955,1,1,-1,2256),-- [scrl_of_ench_wp_d]
(21103,57,239,476,0,700000),-- [adena]
(21103,348,1,1,1,150.355692),-- [scale_mail]
(21103,1935,1,1,1,4304.991144),-- [scale_mail_fragment]
(21103,377,1,1,1,240.431052),-- [scale_gaiters]
(21103,1937,1,1,1,6620.222112),-- [scale_gaiters_fragment]
(21103,1875,1,1,2,2935.62317),-- [stone_of_purity]
(21103,1879,1,1,2,7338.97649),-- [cokes]
(21103,1885,1,1,2,3669.51539),-- [high_grade_suede]
(21103,5550,1,1,2,587.14635),-- [reinforcing_plate]
(21103,5549,1,1,2,4403.40761),-- [iron_thread]
(21103,2185,1,1,2,8668.10427),-- [rp_iron_boots]
(21103,1061,1,1,2,26687.22672),-- [healing_potion]
(21104,1876,1,1,-1,140715),-- [mithril_ore]
(21104,1061,1,1,-1,426409),-- [healing_potion]
(21104,1935,1,1,-1,39306),-- [scale_mail_fragment]
(21104,57,296,595,0,700000),-- [adena]
(21104,1123,1,1,1,1502),-- [blue_buckskin_boots]
(21104,605,1,1,1,1502),-- [leather_gauntlet]
(21104,1876,1,1,2,10985.1025),-- [mithril_ore]
(21104,1880,1,1,2,5492.5147),-- [steel]
(21104,1877,1,1,2,2197.0205),-- [admantite_nugget]
(21104,1881,1,1,2,7323.3773),-- [coarse_bone_powder]
(21104,1882,1,1,2,12205.6532),-- [leather]
(21104,2264,1,1,2,567.987),-- [rp_two-handed_sword]
(21104,6667,1,1,2,34328.3448),-- [key_of_treasure_box3]
(21105,2154,1,1,-1,86586),-- [rp_elven_earing]
(21105,1901,1,1,-1,111700),-- [tiger'seye_earing_stone]
(21105,2155,1,1,-1,129809),-- [rp_elven_ring]
(21105,57,342,683,0,700000),-- [adena]
(21105,393,1,1,1,122.506823),-- [mithril_banded_mail]
(21105,1938,1,1,1,4817.759693),-- [mithril_banded_mail_material]
(21105,394,1,1,1,122.506823),-- [reinforce_leather_shirt]
(21105,415,1,1,1,195.808834),-- [mithril_banded_gaiters]
(21105,1939,1,1,1,6294.620742),-- [mithril_banded_gaiters_material]
(21105,416,1,1,1,195.797085),-- [reinforce_leather_gaiters]
(21105,1874,1,1,2,4777.605589),-- [oriharukon_ore]
(21105,1878,1,1,2,28665.540673),-- [braided_hemp]
(21105,1884,1,1,2,44100.896093),-- [cord]
(21105,1889,1,1,2,4777.605589),-- [compound_braid]
(21105,5220,1,1,2,2866.526209),-- [reinforcing_agent]
(21105,2154,1,1,2,7672.825847),-- [rp_elven_earing]
(21106,1938,1,1,-1,45809),-- [mithril_banded_mail_material]
(21106,1885,1,1,-1,56785),-- [high_grade_suede]
(21106,5550,1,1,-1,9086),-- [reinforcing_plate]
(21106,57,288,574,0,700000),-- [adena]
(21106,628,1,1,1,883.706206),-- [hoplon]
(21106,47,1,1,1,618.293794),-- [helmet]
(21106,1875,1,1,2,3019.186494),-- [stone_of_purity]
(21106,1879,1,1,2,7547.793966),-- [cokes]
(21106,1885,1,1,2,3773.896983),-- [high_grade_suede]
(21106,5550,1,1,2,603.802845),-- [reinforcing_plate]
(21106,5549,1,1,2,4528.779741),-- [iron_thread]
(21106,2186,1,1,2,1514.589048),-- [rp_brigandine]
(21106,8317,1,1,2,323.521182),-- [rp_giants_hammer]
(21106,1341,10,30,2,150957.429741),-- [bone_arrow]
(21107,1939,1,1,-1,126271),-- [mithril_banded_gaiters_material]
(21107,2156,1,1,-1,115008),-- [rp_elven_necklace]
(21107,1940,1,1,-1,214567),-- [iron_boots_design]
(21107,57,607,1211,0,700000),-- [adena]
(21107,260,1,1,1,206),-- [triple-edged_jamadhr]
(21107,1876,1,1,2,25478.533496),-- [mithril_ore]
(21107,1880,1,1,2,12739.266748),-- [steel]
(21107,1877,1,1,2,5095.667616),-- [admantite_nugget]
(21107,1881,1,1,2,16985.656428),-- [coarse_bone_powder]
(21107,1882,1,1,2,28309.42738),-- [leather]
(21107,2188,1,1,2,9099.448332),-- [rp_manticor_skin_gaiters]
(21108,5230,1,1,-1,3610),-- [rp_mithril_arrow]
(21108,4052,1,1,-1,95871),-- [earing_of_black_ore_piece]
(21108,5550,1,1,-1,36105),-- [reinforcing_plate]
(21108,57,1068,2182,0,700000),-- [adena]
(21108,12204,1,1,1,177.511148),-- [blue_wolve's_breastplate_low]
(21108,4078,1,1,1,1947.25167),-- [blue_wolve's_breastplate_part]
(21108,12184,1,1,1,109.266454),-- [doom_plate_armor_low]
(21108,4081,1,1,1,1313.905936),-- [doom_plate_armor_temper]
(21108,12193,1,1,1,283.937634),-- [blue_wolve's_gaiters_low]
(21108,4080,1,1,1,2742.127158),-- [blue_wolve's_gaiters_material]
(21108,1869,1,1,2,72714.84642),-- [iron_ore]
(21108,1864,1,1,2,145429.46286),-- [stem]
(21108,1880,1,1,2,7271.50764),-- [steel]
(21108,5550,1,1,2,969.59568),-- [reinforcing_plate]
(21108,4043,1,1,2,2423.75922),-- [asofe]
(21108,5230,1,1,2,97.05156),-- [rp_mithril_arrow]
(21108,8487,1,1,2,39.78654),-- [rp_hammer_of_destroyer_i]
(21108,8730,1,1,2,807.91974),-- [general_67_a]
(21108,8740,1,1,2,201.92244),-- [special_67_a]
(21108,8750,1,1,2,20.23824),-- [rare_67_a]
(21108,8760,1,1,2,3.90966),-- [unique_67_a]
(21109,1874,1,1,-1,224175),-- [oriharukon_ore]
(21109,4043,1,1,-1,112087),-- [asofe]
(21109,5478,1,1,-1,28276),-- [sealed_dark_crystal_leather_mail_pattern]
(21109,57,1330,2704,0,700000),-- [adena]
(21109,12345,1,1,1,639.16551),-- [sealed_phoenix's_earing_low]
(21109,6341,1,1,1,4578.76041),-- [sealed_phoenix's_earing_gemstone]
(21109,12344,1,1,1,479.83284),-- [sealed_phoenix's_necklace_low]
(21109,6343,1,1,1,3539.55237),-- [sealed_phoenix's_necklace_beads]
(21109,12346,1,1,1,959.68221),-- [sealed_phoenix's_ring_low]
(21109,6345,1,1,1,6333.00666),-- [sealed_phoenix's_ring_gemstone]
(21109,1870,1,1,2,82772.23776),-- [coal]
(21109,1865,1,1,2,82772.23776),-- [varnish]
(21109,1874,1,1,2,5518.149184),-- [oriharukon_ore]
(21109,4043,1,1,2,2759.074592),-- [asofe]
(21109,4039,1,1,2,2759.074592),-- [mold_glue]
(21109,1807,1,1,2,110.377272),-- [rp_soulshot_a]
(21109,6037,1,1,2,165544.47552),-- [scroll_of_awake]
(21109,6670,1,1,2,13795.37296),-- [key_of_treasure_box6]
(21109,8730,1,1,2,919.8106),-- [general_67_a]
(21109,8740,1,1,2,230.041952),-- [special_67_a]
(21109,8750,1,1,2,22.861312),-- [rare_67_a]
(21109,8760,1,1,2,4.286496),-- [unique_67_a]
(21110,1807,1,1,-1,3832),-- [rp_soulshot_a]
(21110,5479,1,1,-1,17005),-- [sealed_tallum_leather_mail_pattern]
(21110,3035,1,1,-1,3832),-- [rp_spiritshot_a]
(21110,57,1137,2310,0,700000),-- [adena]
(21110,12222,1,1,1,205.489715),-- [sealed_dark_crystal_leather_mail_low]
(21110,5478,1,1,1,1189.69312),-- [sealed_dark_crystal_leather_mail_pattern]
(21110,12230,1,1,1,126.31926),-- [sealed_tallum_leather_mail_low]
(21110,5479,1,1,1,837.149785),-- [sealed_tallum_leather_mail_pattern]
(21110,12228,1,1,1,329.021315),-- [sealed_legging_of_dark_crystal_low]
(21110,5482,1,1,1,1867.326805),-- [sealed_legging_of_dark_crystal_design]
(21110,1871,1,1,2,77173.162866),-- [charcoal]
(21110,1866,1,1,2,51448.775244),-- [suede]
(21110,1877,1,1,2,3086.921108),-- [admantite_nugget]
(21110,4041,1,1,2,671.09919),-- [mold_hardener]
(21110,4040,1,1,2,1543.460554),-- [mold_lubricant]
(21110,3956,1,1,2,102.861326),-- [rp_blessed_spiritshot_a]
(21110,8487,1,1,2,42.171792),-- [rp_hammer_of_destroyer_i]
(21110,8730,1,1,2,857.493104),-- [general_67_a]
(21110,8740,1,1,2,214.373276),-- [special_67_a]
(21110,8750,1,1,2,21.491394),-- [rare_67_a]
(21110,8760,1,1,2,4.190146),-- [unique_67_a]
(21111,5482,1,1,-1,39755),-- [sealed_legging_of_dark_crystal_design]
(21111,4041,1,1,-1,26191),-- [mold_hardener]
(21111,5479,1,1,-1,17822),-- [sealed_tallum_leather_mail_pattern]
(21111,57,1191,2424,0,700000),-- [adena]
(21111,12222,1,1,1,215.369462),-- [sealed_dark_crystal_leather_mail_low]
(21111,5478,1,1,1,1246.892416),-- [sealed_dark_crystal_leather_mail_pattern]
(21111,12230,1,1,1,132.392568),-- [sealed_tallum_leather_mail_low]
(21111,5479,1,1,1,877.399138),-- [sealed_tallum_leather_mail_pattern]
(21111,12228,1,1,1,344.840342),-- [sealed_legging_of_dark_crystal_low]
(21111,5482,1,1,1,1957.106074),-- [sealed_legging_of_dark_crystal_design]
(21111,1865,1,1,2,74141.595432),-- [varnish]
(21111,1870,1,1,2,74141.595432),-- [coal]
(21111,1879,1,1,2,12356.932572),-- [cokes]
(21111,1875,1,1,2,4942.668654),-- [stone_of_purity]
(21111,4040,1,1,2,1482.904971),-- [mold_lubricant]
(21111,5166,1,1,2,98.895123),-- [rp_comp_bspiritshot_a]
(21111,8487,1,1,2,40.445235),-- [rp_hammer_of_destroyer_i]
(21111,8730,1,1,2,823.778109),-- [general_67_a]
(21111,8740,1,1,2,205.879293),-- [special_67_a]
(21111,8750,1,1,2,20.614023),-- [rare_67_a]
(21111,8760,1,1,2,4.174992),-- [unique_67_a]
(21111,1344,10,30,2,92677.516164),-- [mithril_arrow]
(21112,5485,1,1,-1,24627),-- [sealed_tallum_tunic_texture]
(21112,3956,1,1,-1,3905),-- [rp_blessed_spiritshot_a]
(21112,5486,1,1,-1,17329),-- [sealed_dark_crystal_robe_fabric]
(21112,57,1445,2946,0,700000),-- [adena]
(21112,12224,1,1,1,588.977907),-- [sealed_dark_crystal_boots_low]
(21112,5496,1,1,1,3169.272093),-- [sealed_dark_crystal_boots_lining]
(21112,12231,1,1,1,588.977907),-- [sealed_tallum_boots_low]
(21112,5497,1,1,1,3169.272093),-- [sealed_tallum_boots_lining]
(21112,12221,1,1,1,588.977907),-- [sealed_dark_crystal_gloves_low]
(21112,5508,1,1,1,3169.272093),-- [sealed_dark_crystal_gloves_design]
(21112,12229,1,1,1,588.977907),-- [sealed_tallum_gloves_low]
(21112,5509,1,1,1,3169.272093),-- [sealed_tallum_gloves_design]
(21112,1873,1,1,2,43253.661907),-- [silver_nugget]
(21112,1868,1,1,2,216268.625064),-- [thread]
(21112,1876,1,1,2,21626.988718),-- [mithril_ore]
(21112,1895,1,1,2,30895.653093),-- [metallic_fiber]
(21112,4042,1,1,2,1802.301648),-- [enria]
(21112,5281,1,1,2,144.196753),-- [rp_adv_comp_bspiritshot_a]
(21112,8730,1,1,2,1201.534432),-- [general_67_a]
(21112,8740,1,1,2,300.383608),-- [special_67_a]
(21112,8750,1,1,2,29.975255),-- [rare_67_a]
(21112,8760,1,1,2,5.679522),-- [unique_67_a]
(21113,5156,1,1,-1,4361),-- [rp_comp_soulshot_a]
(21113,5489,1,1,-1,43172),-- [sealed_tallum_hose_fabric]
(21113,5166,1,1,-1,4361),-- [rp_comp_bspiritshot_a]
(21113,57,1613,3293,0,700000),-- [adena]
(21113,12222,1,1,1,292.377353),-- [sealed_dark_crystal_leather_mail_low]
(21113,5478,1,1,1,1692.733504),-- [sealed_dark_crystal_leather_mail_pattern]
(21113,12230,1,1,1,179.731092),-- [sealed_tallum_leather_mail_low]
(21113,5479,1,1,1,1191.123547),-- [sealed_tallum_leather_mail_pattern]
(21113,12228,1,1,1,468.142073),-- [sealed_legging_of_dark_crystal_low]
(21113,5482,1,1,1,2656.892431),-- [sealed_legging_of_dark_crystal_design]
(21113,1864,1,3,2,109793.118153),-- [stem]
(21113,1869,1,1,2,109793.118153),-- [iron_ore]
(21113,1878,1,1,2,43916.963055),-- [braided_hemp]
(21113,1884,1,1,2,67564.813603),-- [cord]
(21113,4039,1,1,2,3659.628502),-- [mold_glue]
(21113,3035,1,1,2,146.366193),-- [rp_spiritshot_a]
(21113,8730,1,1,2,1219.718275),-- [general_67_a]
(21113,8740,1,1,2,305.047988),-- [special_67_a]
(21113,8750,1,1,2,30.315328),-- [rare_67_a]
(21113,8760,1,1,2,6.157801),-- [unique_67_a]
(21113,1344,10,30,2,137241.752949),-- [mithril_arrow]
(21114,1875,1,1,-1,207673),-- [stone_of_purity]
(21114,5494,1,1,-1,65423),-- [sealed_dark_crystal_shield_fragment]
(21114,5161,1,1,-1,4153),-- [rp_comp_spiritshot_a]
(21114,57,1538,3132,0,700000),-- [adena]
(21114,12227,1,1,1,208.942419),-- [sealed_dark_crystal_breastplate_low]
(21114,5520,1,1,1,1236.21113),-- [sealed_dark_crystal_breastplate_pattern]
(21114,12233,1,1,1,128.658964),-- [sealed_tallum_plate_armor_low]
(21114,5521,1,1,1,872.318608),-- [sealed_tallum_plate_armor_pattern]
(21114,12220,1,1,1,333.399283),-- [sealed_dark_crystal_gaiters_low]
(21114,5524,1,1,1,1889.469596),-- [sealed_dark_crystal_gaiters_pattern]
(21114,1870,1,1,2,104562.90785),-- [coal]
(21114,1865,1,1,2,104562.90785),-- [varnish]
(21114,1874,1,1,2,6970.8842),-- [oriharukon_ore]
(21114,4043,1,1,2,3485.4421),-- [asofe]
(21114,4039,1,1,2,3485.4421),-- [mold_glue]
(21114,5271,1,1,2,139.57395),-- [rp_adv_comp_soulshot_a]
(21114,8731,1,1,2,968.1389),-- [general_70_a]
(21114,8741,1,1,2,242.2123),-- [special_70_a]
(21114,8751,1,1,2,24.1502),-- [rare_70_a]
(21114,8761,1,1,2,4.9721),-- [unique_70_a]
(21114,1344,10,30,2,130703.36845),-- [mithril_arrow]
(21115,5496,1,1,-1,63784),-- [sealed_dark_crystal_boots_lining]
(21115,5166,1,1,-1,3627),-- [rp_comp_bspiritshot_a]
(21115,5497,1,1,-1,63784),-- [sealed_tallum_boots_lining]
(21115,57,1342,2736,0,700000),-- [adena]
(21115,12232,1,1,1,243.15907),-- [sealed_tallum_tunic_low]
(21115,5485,1,1,1,1407.78176),-- [sealed_tallum_tunic_texture]
(21115,12223,1,1,1,149.47548),-- [sealed_dark_crystal_robe_low]
(21115,5486,1,1,1,990.61193),-- [sealed_dark_crystal_robe_fabric]
(21115,12235,1,1,1,389.33587),-- [sealed_tallum_hose_low]
(21115,5489,1,1,1,2209.63589),-- [sealed_tallum_hose_fabric]
(21115,1866,1,1,2,60875.972472),-- [suede]
(21115,1871,1,1,2,91313.958708),-- [charcoal]
(21115,5220,1,1,2,3652.572396),-- [reinforcing_agent]
(21115,1885,1,1,2,7609.45266),-- [high_grade_suede]
(21115,4041,1,1,2,794.045112),-- [mold_hardener]
(21115,5281,1,1,2,121.688028),-- [rp_adv_comp_bspiritshot_a]
(21115,6671,1,1,2,10145.93688),-- [key_of_treasure_box7]
(21115,8731,1,1,2,845.49474),-- [general_70_a]
(21115,8741,1,1,2,211.417584),-- [special_70_a]
(21115,8751,1,1,2,21.07152),-- [rare_70_a]
(21115,8761,1,1,2,4.3899),-- [unique_70_a]
(21116,729,1,1,-1,479),-- [scrl_of_ench_wp_a]
(21116,5480,1,1,-1,19326),-- [sealed_leather_mail_of_nightmare_fabric]
(21116,5481,1,1,-1,19326),-- [sealed_majestic_leather_mail_fabric]
(21116,57,2125,4335,0,700000),-- [adena]
(21116,12345,1,1,1,1023.322155),-- [sealed_phoenix's_earing_low]
(21116,6341,1,1,1,7330.725605),-- [sealed_phoenix's_earing_gemstone]
(21116,12344,1,1,1,768.22602),-- [sealed_phoenix's_necklace_low]
(21116,6343,1,1,1,5666.923985),-- [sealed_phoenix's_necklace_beads]
(21116,12346,1,1,1,1536.478505),-- [sealed_phoenix's_ring_low]
(21116,6345,1,1,1,10139.32373),-- [sealed_phoenix's_ring_gemstone]
(21116,1867,1,1,2,192758.694975),-- [animal_skin]
(21116,1872,1,1,2,192758.694975),-- [animal_bone]
(21116,1882,1,1,2,32126.235435),-- [leather]
(21116,1894,1,1,2,5072.608485),-- [crafted_leather]
(21116,4042,1,1,2,2409.563835),-- [enria]
(21116,729,1,1,2,16.24329),-- [scrl_of_ench_wp_a]
(21116,4987,1,1,2,599.719365),-- [rp_tunic_of_doom_i]
(21116,8731,1,1,2,1338.78906),-- [general_70_a]
(21116,8741,1,1,2,334.697265),-- [special_70_a]
(21116,8751,1,1,2,33.34149),-- [rare_70_a]
(21116,8761,1,1,2,6.411825),-- [unique_70_a]
(21117,734,1,1,-1,43530),-- [quick_step_potion]
(21117,1897,1,1,-1,62185),-- [necklace_of_wisdom_chain]
(21117,1800,1,1,-1,82131),-- [rp_piece_bone_breastplate]
(21117,57,122,208,0,700000),-- [adena]
(21117,38,1,1,1,1974.358375),-- [low_boots]
(21117,50,1,1,1,1974.358375),-- [leather_gloves]
(21117,1925,1,1,1,33726.28325),-- [leather_gloves_lining]
(21117,1868,1,1,2,102863.877013),-- [thread]
(21117,1873,1,1,2,20572.748658),-- [silver_nugget]
(21117,2139,1,1,2,10286.374329),-- [rp_steel_mold]
(21118,1924,1,1,-1,88910),-- [leather_helmet_design]
(21118,1801,1,1,-1,138851),-- [rp_piece_bone_gaiters]
(21118,1925,1,1,-1,180734),-- [leather_gloves_lining]
(21118,57,127,221,0,700000),-- [adena]
(21118,945,1,1,1,3083.9274),-- [skeleton_buckler]
(21118,102,1,1,1,1488.409235),-- [round_shield]
(21118,44,1,1,1,1041.116045),-- [leather_helmet]
(21118,1924,1,1,1,13131.54732),-- [leather_helmet_design]
(21118,1869,1,1,2,32565.57206),-- [iron_ore]
(21118,1864,1,1,2,65131.03394),-- [stem]
(21118,1880,1,1,2,3256.59026),-- [steel]
(21118,2142,1,1,2,6513.07034),-- [rp_varnish_of_purity]
(21118,6035,1,1,2,2713.7334),-- [potion_of_acumen2]
(21119,1868,1,1,-1,683443),-- [thread]
(21119,1873,1,1,-1,136689),-- [silver_nugget]
(21119,1898,1,1,-1,35102),-- [blue_diamond_necklace_gem]
(21119,57,156,278,0,700000),-- [adena]
(21119,27,1,1,1,355.418392),-- [hard_leather_shirt]
(21119,1927,1,1,1,4026.225584),-- [hard_leather_shirt_pattern]
(21119,33,1,1,1,570.265216),-- [hard_leather_gaiters]
(21119,1929,1,1,1,6512.090808),-- [hard_leather_gaiters_material]
(21119,1868,1,1,2,201878.252582),-- [thread]
(21119,1873,1,1,2,40375.747418),-- [silver_nugget]
(21120,1804,1,1,-1,17582),-- [rp_soulshot_d]
(21120,1926,1,1,-1,44399),-- [piece_bone_breastplate_fragment]
(21120,2151,1,1,-1,122437),-- [rp_necklace_of_devotion]
(21120,57,199,358,0,700000),-- [adena]
(21120,87,1,1,1,69.03532),-- [iron_hammer]
(21120,2014,1,1,1,745.894993),-- [iron_hammer_head]
(21120,155,1,1,1,69.03532),-- [buzdygan]
(21120,177,1,1,1,69.034367),-- [mage_staff]
(21120,1867,1,1,2,86557.26612),-- [animal_skin]
(21120,1872,1,1,2,86557.26612),-- [animal_bone]
(21120,1882,1,1,2,14426.305584),-- [leather]
(21120,2255,1,1,2,1587.162176),-- [rp_saber]
(21121,1927,1,1,-1,30770),-- [hard_leather_shirt_pattern]
(21121,1881,1,1,-1,51428),-- [coarse_bone_powder]
(21121,1875,1,1,-1,25714),-- [stone_of_purity]
(21121,57,177,312,0,700000),-- [adena]
(21121,257,1,1,1,242),-- [viper's_canine]
(21121,1872,1,1,2,75954.797064),-- [animal_bone]
(21121,1867,1,1,2,75954.797064),-- [animal_skin]
(21121,1881,1,1,2,7595.511886),-- [coarse_bone_powder]
(21121,2258,1,1,2,1392.893986),-- [rp_temptation_of_abyss]
(21122,1928,1,1,-1,59341),-- [piece_bone_gaiters_fragment]
(21122,2176,1,1,-1,194917),-- [rp_leather_boots]
(21122,1929,1,1,-1,52565),-- [hard_leather_gaiters_material]
(21122,57,181,334,0,700000),-- [adena]
(21122,273,1,1,1,128.001588),-- [composition_bow]
(21122,2016,1,1,1,1409.998412),-- [composition_bow_shaft]
(21122,1873,1,1,2,32088.769028),-- [silver_nugget]
(21122,1868,1,1,2,160444.236624),-- [thread]
(21122,5268,1,1,2,3208.994348),-- [rp_adv_comp_soulshot_d]
(21123,2152,1,1,-1,94359),-- [rp_enchanted_necklace]
(21123,1899,1,1,-1,83743),-- [necklace_of_devotion_chain]
(21123,1874,1,1,-1,35730),-- [oriharukon_ore]
(21123,57,236,442,0,700000),-- [adena]
(21123,220,1,1,1,191),-- [handiwork_dagger]
(21123,1874,1,1,2,5013.3),-- [oriharukon_ore]
(21123,1878,1,1,2,30079.8),-- [braided_hemp]
(21123,5220,1,1,2,3007.98),-- [reinforcing_agent]
(21123,2178,1,1,2,12031.92),-- [rp_dark_hose]
(21124,1865,1,1,-1,253256),-- [varnish]
(21124,735,1,1,-1,21105),-- [swift_attack_potion]
(21124,1897,1,1,-1,60299),-- [necklace_of_wisdom_chain]
(21124,57,121,200,0,700000),-- [adena]
(21124,309,1,1,1,142.5),-- [tears_of_eva]
(21124,310,1,1,1,142.5),-- [relic_of_saints]
(21124,1865,1,1,2,37403.909768),-- [varnish]
(21124,1870,1,1,2,37403.909768),-- [coal]
(21124,1879,1,1,2,6234.015896),-- [cokes]
(21124,1800,1,1,2,11762.164568),-- [rp_piece_bone_breastplate]
(21125,1800,1,1,-1,82944),-- [rp_piece_bone_breastplate]
(21125,1924,1,1,-1,85085),-- [leather_helmet_design]
(21125,1801,1,1,-1,132878),-- [rp_piece_bone_gaiters]
(21125,57,124,211,0,700000),-- [adena]
(21125,15,1,1,1,148.419486),-- [short_spear]
(21125,2011,1,1,1,1777.580514),-- [short_spear_edge]
(21125,1866,1,1,2,25970.50349),-- [suede]
(21125,1871,1,1,2,38955.71563),-- [charcoal]
(21125,2140,1,1,2,7791.17481),-- [rp_high_grade_suede]
(21125,734,1,1,2,6492.60607),-- [quick_step_potion]
(21126,1925,1,1,-1,177190),-- [leather_gloves_lining]
(21126,1864,1,1,-1,540431),-- [stem]
(21126,1865,1,1,-1,270215),-- [varnish]
(21126,57,125,217,0,700000),-- [adena]
(21126,24,1,1,1,511.60535),-- [bone_breastplate]
(21126,390,1,1,1,511.60535),-- [tights_shirt]
(21126,31,1,1,1,816.89465),-- [bone_gaiters]
(21126,412,1,1,1,816.89465),-- [tights_pants]
(21126,1864,1,1,2,53211.71277),-- [stem]
(21126,1865,1,1,2,26605.77302),-- [varnish]
(21126,1866,1,1,2,17737.23759),-- [suede]
(21126,1873,1,1,2,10642.3759),-- [silver_nugget]
(21126,1868,1,1,2,53211.71277),-- [thread]
(21126,2143,1,1,2,5321.18795),-- [rp_synthesis_cokes]
(21127,1898,1,1,-1,35102),-- [blue_diamond_necklace_gem]
(21127,1804,1,1,-1,13669),-- [rp_soulshot_d]
(21127,1926,1,1,-1,34517),-- [piece_bone_breastplate_fragment]
(21127,57,156,278,0,700000),-- [adena]
(21127,25,1,1,1,274.899912),-- [piece_bone_breastplate]
(21127,1926,1,1,1,3398.782366),-- [piece_bone_breastplate_fragment]
(21127,26,1,1,1,177.939972),-- [bronze_breastplate]
(21127,32,1,1,1,439.845546),-- [piece_bone_gaiters]
(21127,1928,1,1,1,4901.377096),-- [piece_bone_gaiters_fragment]
(21127,34,1,1,1,285.155108),-- [bronze_gaiters]
(21127,1868,1,1,2,100939.016913),-- [thread]
(21127,1873,1,1,2,20187.859139),-- [silver_nugget]
(21127,2151,1,1,2,14058.418696),-- [rp_necklace_of_devotion]
(21127,6035,1,1,2,4205.705252),-- [potion_of_acumen2]
(21128,2151,1,1,-1,100871),-- [rp_necklace_of_devotion]
(21128,1927,1,1,-1,28889),-- [hard_leather_shirt_pattern]
(21128,1869,1,1,-1,362125),-- [iron_ore]
(21128,57,164,295,0,700000),-- [adena]
(21128,1102,1,1,1,753.305976),-- [tunic_of_magicpower]
(21128,1105,1,1,1,1208.694024),-- [hose_of_magicpower]
(21128,1869,1,1,2,35655.47904),-- [iron_ore]
(21128,1870,1,1,2,35655.47904),-- [coal]
(21128,1871,1,1,2,35655.47904),-- [charcoal]
(21128,1872,1,1,2,47540.70636),-- [animal_bone]
(21128,1867,1,1,2,47540.70636),-- [animal_skin]
(21128,2256,1,1,2,872.15016),-- [rp_assassin_knife]
(21129,1870,1,1,-1,385707),-- [coal]
(21129,1928,1,1,-1,56185),-- [piece_bone_gaiters_fragment]
(21129,2176,1,1,-1,184549),-- [rp_leather_boots]
(21129,57,177,312,0,700000),-- [adena]
(21129,846,1,1,1,926.265102),-- [coral_earing]
(21129,909,1,1,1,694.701042),-- [blue_diamond_necklace]
(21129,1898,1,1,1,5851.62291),-- [blue_diamond_necklace_gem]
(21129,878,1,1,1,1389.410946),-- [blue_coral_ring]
(21129,1870,1,1,2,56966.137764),-- [coal]
(21129,1865,1,1,2,56966.137764),-- [varnish]
(21129,3032,1,1,2,2278.606804),-- [rp_spiritshot_d]
(21129,6035,1,1,2,4747.117668),-- [potion_of_acumen2]
(21130,1929,1,1,-1,52565),-- [hard_leather_gaiters_material]
(21130,2177,1,1,-1,130152),-- [rp_bone_helmet]
(21130,1930,1,1,-1,104455),-- [boots_lining]
(21130,57,181,334,0,700000),-- [adena]
(21130,39,1,1,1,1688.908752),-- [boots]
(21130,1930,1,1,1,20570.158548),-- [boots_lining]
(21130,51,1,1,1,1688.9327),-- [bracer]
(21130,1871,1,1,2,60166.567296),-- [charcoal]
(21130,1866,1,1,2,40111.044864),-- [suede]
(21130,5273,1,1,2,2406.626624),-- [rp_adv_comp_spiritshot_d]
(21130,734,1,1,2,10027.761216),-- [quick_step_potion]
(21131,1872,1,1,-1,559583),-- [animal_bone]
(21131,1867,1,1,-1,559583),-- [animal_skin]
(21131,1899,1,1,-1,65576),-- [necklace_of_devotion_chain]
(21131,57,185,346,0,700000),-- [adena]
(21131,626,1,1,1,929.141052),-- [bronze_shield]
(21131,45,1,1,1,651.553071),-- [bone_helmet]
(21131,1932,1,1,1,12462.305877),-- [bone_helmet_design]
(21131,1872,1,1,2,62811.194194),-- [animal_bone]
(21131,1867,1,1,2,62811.194194),-- [animal_skin]
(21131,1881,1,1,2,6281.133278),-- [coarse_bone_powder]
(21131,1875,1,1,2,3140.497346),-- [stone_of_purity]
(21131,2180,1,1,2,3541.980988),-- [rp_scale_mail]
(21132,2179,1,1,-1,159246),-- [rp_excellence_leather_gloves]
(21132,1898,1,1,-1,34188),-- [blue_diamond_necklace_gem]
(21132,2255,1,1,-1,8137),-- [rp_saber]
(21132,57,148,273,0,700000),-- [adena]
(21132,68,1,1,1,104.5),-- [falchion]
(21132,5284,1,1,1,104.5),-- [zweihander]
(21132,1873,1,1,2,26216.32528),-- [silver_nugget]
(21132,1868,1,1,2,131081.94624),-- [thread]
(21132,5278,1,1,2,2621.72848),-- [rp_adv_comp_bspiritshot_d]
(21133,1899,1,1,-1,56286),-- [necklace_of_devotion_chain]
(21133,1878,1,1,-1,144093),-- [braided_hemp]
(21133,1864,1,1,-1,720463),-- [stem]
(21133,57,159,297,0,700000),-- [adena]
(21133,156,1,1,1,42.666624),-- [hand_axe]
(21133,167,1,1,1,42.666624),-- [scalpel]
(21133,178,1,1,1,42.666752),-- [bone_staff]
(21133,1864,1,1,2,80869.217263),-- [stem]
(21133,1869,1,1,2,40434.525616),-- [iron_ore]
(21133,1878,1,1,2,16173.909865),-- [braided_hemp]
(21133,2181,1,1,2,4047.503718),-- [rp_white_tunic]
(21133,1061,1,1,2,24505.843538),-- [healing_potion]
(21134,1931,1,1,-1,49119),-- [leather_boots_lining]
(21134,2152,1,1,-1,66155),-- [rp_enchanted_necklace]
(21134,1932,1,1,-1,59645),-- [bone_helmet_design]
(21134,57,163,312,0,700000),-- [adena]
(21134,258,1,1,1,134),-- [bagh-nakh]
(21134,1865,1,1,2,42177.743988),-- [varnish]
(21134,1870,1,1,2,42177.743988),-- [coal]
(21134,1879,1,1,2,7029.671424),-- [cokes]
(21134,1875,1,1,2,2811.88754),-- [stone_of_purity]
(21134,2259,1,1,2,654.95306),-- [rp_spinebone_sword]
(21135,2178,1,1,-1,73236),-- [rp_dark_hose]
(21135,1934,1,1,-1,59833),-- [excellence_leather_gloves_lining]
(21135,5220,1,1,-1,18309),-- [reinforcing_agent]
(21135,57,198,381,0,700000),-- [adena]
(21135,274,1,1,1,163),-- [strengthening_bow]
(21135,1866,1,1,2,34251.808304),-- [suede]
(21135,1871,1,1,2,51377.80522),-- [charcoal]
(21135,5220,1,1,2,2055.093656),-- [reinforcing_agent]
(21135,1885,1,1,2,4281.52242),-- [high_grade_suede]
(21135,2261,1,1,2,797.7704),-- [rp_conjure_staff]
(21136,1882,1,1,-1,89848),-- [leather]
(21136,2017,1,1,-1,5373),-- [saber_blade]
(21136,2180,1,1,-1,30400),-- [rp_scale_mail]
(21136,57,173,339,0,700000),-- [adena]
(21136,220,1,1,1,144),-- [handiwork_dagger]
(21136,1867,1,1,2,60510.58416),-- [animal_skin]
(21136,1872,1,1,2,60510.58416),-- [animal_bone]
(21136,1882,1,1,2,10085.034186),-- [leather]
(21136,2152,1,1,2,7990.057998),-- [rp_enchanted_necklace]
(21136,1834,1,1,2,50425.739496),-- [emergency_dressing]
(21137,1900,1,1,-1,47223),-- [enchanted_necklace_chain]
(21137,2153,1,1,-1,67126),-- [rp_tiger'seye_earing]
(21137,1933,1,1,-1,50779),-- [dark_hose_fabric]
(21137,57,183,362,0,700000),-- [adena]
(21137,315,1,1,1,95),-- [divine_tome]
(21137,1868,1,1,2,78621.401316),-- [thread]
(21137,1873,1,1,2,15724.258983),-- [silver_nugget]
(21137,5549,1,1,2,3931.091346),-- [iron_thread]
(21137,1889,1,1,2,2620.763031),-- [compound_braid]
(21137,737,1,1,2,3931.091346),-- [scroll_of_resurrection]
(21137,6387,1,1,2,1572.393978),-- [blessed_scroll_of_resurrection_pet]
(21138,1869,1,1,-1,460180),-- [iron_ore]
(21138,1864,1,1,-1,920360),-- [stem]
(21138,956,1,1,-1,15339),-- [scrl_of_ench_am_d]
(21138,57,194,388,0,700000),-- [adena]
(21138,292,1,1,1,102),-- [pike]
(21138,1869,1,1,2,41911.791592),-- [iron_ore]
(21138,1864,1,1,2,83823.870141),-- [stem]
(21138,1880,1,1,2,4191.293942),-- [steel]
(21138,5550,1,1,2,558.705279),-- [reinforcing_plate]
(21138,1829,1,1,2,16764.888811),-- [scroll_of_escape_to_agit]
(21138,1341,10,30,2,139706.450235),-- [bone_arrow]
(21139,1898,1,1,-1,96575),-- [blue_diamond_necklace_gem]
(21139,1804,1,1,-1,37606),-- [rp_soulshot_d]
(21139,1926,1,1,-1,94966),-- [piece_bone_breastplate_fragment]
(21139,57,430,759,0,700000),-- [adena]
(21139,27,1,1,1,977.83462),-- [hard_leather_shirt]
(21139,1927,1,1,1,11077.03724),-- [hard_leather_shirt_pattern]
(21139,33,1,1,1,1568.92576),-- [hard_leather_gaiters]
(21139,1929,1,1,1,17916.20238),-- [hard_leather_gaiters_material]
(21139,1870,1,1,2,185139.186064),-- [coal]
(21139,1865,1,1,2,185139.186064),-- [varnish]
(21139,3953,1,1,2,7405.627872),-- [rp_blessed_spiritshot_d]
(21140,2152,1,1,-1,193505),-- [rp_enchanted_necklace]
(21140,1899,1,1,-1,171735),-- [necklace_of_devotion_chain]
(21140,1871,1,3,-1,549553),-- [charcoal]
(21140,57,477,911,0,700000),-- [adena]
(21140,347,1,1,1,960.693069),-- [ring_breastplate]
(21140,376,1,1,1,1538.306931),-- [iron_plate_gaiters]
(21140,1871,1,1,2,154212.99259),-- [charcoal]
(21140,1866,1,1,2,102808.750255),-- [suede]
(21140,1877,1,1,2,6168.47721),-- [admantite_nugget]
(21140,2260,1,1,2,2394.779945),-- [rp_mace_of_judgment]
(21141,1881,1,1,-1,169543),-- [coarse_bone_powder]
(21141,1931,1,1,-1,166219),-- [leather_boots_lining]
(21141,2178,1,1,-1,203452),-- [rp_dark_hose]
(21141,57,545,1067,0,700000),-- [adena]
(21141,432,1,1,1,1480.781988),-- [cursed_tunic]
(21141,465,1,1,1,2371.218012),-- [cursed_hose]
(21141,1872,1,1,2,190305.884826),-- [animal_bone]
(21141,1867,1,1,2,190305.884826),-- [animal_skin]
(21141,1881,1,1,2,19030.631682),-- [coarse_bone_powder]
(21141,1875,1,1,2,9515.099844),-- [stone_of_purity]
(21141,2178,1,1,2,22836.498822),-- [rp_dark_hose]
(21142,1900,1,1,-1,138128),-- [enchanted_necklace_chain]
(21142,2153,1,1,-1,196344),-- [rp_tiger'seye_earing]
(21142,1933,1,1,-1,148528),-- [dark_hose_fabric]
(21142,57,535,1059,0,700000),-- [adena]
(21142,848,1,1,1,1051.697156),-- [enchanted_earing]
(21142,911,1,1,1,789.363658),-- [enchanted_necklace]
(21142,1900,1,1,1,18870.577948),-- [enchanted_necklace_chain]
(21142,879,1,1,1,1582.361238),-- [enchanted_ring]
(21142,1873,1,1,2,68990.39847),-- [silver_nugget]
(21142,1868,1,1,2,344951.543223),-- [thread]
(21142,1876,1,1,2,34495.199235),-- [mithril_ore]
(21142,955,1,1,2,689.859072),-- [scrl_of_ench_wp_d]
(21143,955,1,1,-1,5610),-- [scrl_of_ench_wp_d]
(21143,1875,1,1,-1,93494),-- [stone_of_purity]
(21143,1872,1,3,-1,934937),-- [animal_bone]
(21143,57,593,1182,0,700000),-- [adena]
(21143,1123,1,1,1,2993.5),-- [blue_buckskin_boots]
(21143,605,1,1,1,2993.5),-- [leather_gauntlet]
(21143,1872,1,1,2,170302.636242),-- [animal_bone]
(21143,1867,1,1,2,170302.636242),-- [animal_skin]
(21143,1881,1,1,2,17030.386242),-- [coarse_bone_powder]
(21143,1875,1,1,2,8514.988758),-- [stone_of_purity]
(21143,2250,1,1,2,31931.71875),-- [rp_bone_arrow]
(21143,6035,1,1,2,10643.633766),-- [potion_of_acumen2]
(21144,1901,1,1,-1,229413),-- [tiger'seye_earing_stone]
(21144,2154,1,1,-1,177832),-- [rp_elven_earing]
(21144,1938,1,1,-1,111661),-- [mithril_banded_mail_material]
(21144,57,702,1399,0,700000),-- [adena]
(21144,628,1,1,1,2153.960333),-- [hoplon]
(21144,47,1,1,1,1507.039667),-- [helmet]
(21144,1865,1,1,2,126159.284034),-- [varnish]
(21144,1870,1,1,2,126159.284034),-- [coal]
(21144,1879,1,1,2,21026.397938),-- [cokes]
(21144,1875,1,1,2,8410.678696),-- [stone_of_purity]
(21144,2187,1,1,2,5632.118898),-- [rp_manticor_skin_shirt]
(21144,8317,1,1,2,901.186832),-- [rp_giants_hammer]
(21144,6035,1,1,2,10513.049568),-- [potion_of_acumen2]
(21145,1825,1,1,-1,150797),-- [rp_oriharukon]
(21145,1902,1,1,-1,213897),-- [elven_earing_beads]
(21145,1885,1,1,-1,175930),-- [high_grade_suede]
(21145,57,893,1781,0,700000),-- [adena]
(21145,129,1,1,1,101.61644),-- [sword_of_revolution]
(21145,2034,1,1,1,5765.38356),-- [sword_of_revolution_blade]
(21145,1866,1,1,2,103934.33472),-- [suede]
(21145,1871,1,1,2,155901.97664),-- [charcoal]
(21145,5220,1,1,2,6236.19296),-- [reinforcing_agent]
(21145,1885,1,1,2,12992.02912),-- [high_grade_suede]
(21145,2146,1,1,2,11136.02496),-- [rp_artisan's_frame]
(21145,5473,1,1,2,11136.02496),-- [rp_reinforcing_plate]
(21145,1832,1,1,2,173223.41664),-- [advanced_antidote]
(21146,1894,1,1,-1,79948),-- [crafted_leather]
(21146,1903,1,1,-1,380070),-- [elven_ring_piece]
(21146,2145,1,1,-1,162751),-- [rp_mithirl_alloy]
(21146,57,951,1898,0,700000),-- [adena]
(21146,88,1,1,1,21.934692),-- [morning_star]
(21146,2031,1,1,1,1192.248369),-- [morning_star_head]
(21146,90,1,1,1,21.934692),-- [goathead_staff]
(21146,2032,1,1,1,1088.350965),-- [goathead_staff_head]
(21146,158,1,1,1,21.934692),-- [tarbar]
(21146,2035,1,1,1,1192.248369),-- [tarbar_head]
(21146,169,1,1,1,21.934692),-- [skull_breaker]
(21146,2036,1,1,1,1192.248369),-- [skull_breaker_head]
(21146,172,1,1,1,21.934692),-- [heavy_bone_club]
(21146,2037,1,1,1,1192.230468),-- [heavy_bone_club_head]
(21146,1872,1,1,2,224346.478044),-- [animal_bone]
(21146,1867,1,1,2,224346.478044),-- [animal_skin]
(21146,1881,1,1,2,22434.449076),-- [coarse_bone_powder]
(21146,1875,1,1,2,11217.224538),-- [stone_of_purity]
(21146,1805,1,1,2,560.910909),-- [rp_soulshot_c]
(21146,2990,1,1,2,13354.051659),-- [rp_chain_boots]
(21146,5164,1,1,2,561.40773),-- [rp_comp_bspiritshot_c]
(21147,1905,1,1,-1,273798),-- [onyxbeast'seye_earing_gemstone]
(21147,1805,1,1,-1,9382),-- [rp_soulshot_c]
(21147,1906,1,1,-1,386892),-- [mithril_ring_wire]
(21147,57,1113,2260,0,700000),-- [adena]
(21147,262,1,1,1,101.8973),-- [scallop_jamadhr]
(21147,2053,1,1,1,5843.1027),-- [scallop_jamadhr_edge]
(21147,1868,1,3,2,235563.65775),-- [thread]
(21147,1873,1,1,2,94225.4631),-- [silver_nugget]
(21147,5549,1,1,2,23556.555784),-- [iron_thread]
(21147,1889,1,1,2,15704.24385),-- [compound_braid]
(21147,2199,1,1,2,9939.37079),-- [rp_karmian_hose]
(21147,2301,1,1,2,1028.708726),-- [rp_battle_axe]
(21148,1880,1,1,-1,279242),-- [steel]
(21148,5550,1,1,-1,37232),-- [reinforcing_plate]
(21148,1869,1,5,-1,930808),-- [iron_ore]
(21148,57,1099,2253,0,700000),-- [adena]
(21148,281,1,1,1,74.867985),-- [crystallized_ice_bow]
(21148,2074,1,1,1,4674.132015),-- [crystallized_ice_bow_shaft]
(21148,1869,1,1,2,119976.49755),-- [iron_ore]
(21148,1864,1,3,2,119976.49755),-- [stem]
(21148,1880,1,1,2,11997.826204),-- [steel]
(21148,5550,1,1,2,1599.686634),-- [reinforcing_plate]
(21148,2163,1,1,2,6121.368708),-- [rp_earing_of_protection]
(21148,6037,1,3,2,79984.3317),-- [scroll_of_awake]
(21148,2217,1,1,2,7099.249066),-- [rp_knight_shield]
(21148,8723,1,1,2,4799.059902),-- [general_46_c]
(21148,8733,1,1,2,1199.8532),-- [special_46_c]
(21148,8743,1,1,2,119.98532),-- [rare_46_c]
(21148,8753,1,1,2,23.644166),-- [unique_46_c]
(21149,1908,1,1,-1,305158),-- [moonstone_earing_wire]
(21149,2163,1,1,-1,164412),-- [rp_earing_of_protection]
(21149,1909,1,1,-1,435175),-- [aquastone_ring_wire]
(21149,57,1269,2596,0,700000),-- [adena]
(21149,226,1,1,1,43.194719),-- [cursed_dagger]
(21149,2070,1,1,1,3023.305281),-- [cursed_dagger_blade]
(21149,232,1,1,1,43.194719),-- [darkelven_dagger]
(21149,2072,1,1,1,3023.305281),-- [darkelven_dagger_edge]
(21149,1873,1,1,2,55381.38858),-- [silver_nugget]
(21149,1868,1,1,2,276907.35736),-- [thread]
(21149,1876,1,1,2,27690.90152),-- [mithril_ore]
(21149,1895,1,1,2,39558.1347),-- [metallic_fiber]
(21149,4042,1,1,2,2307.71328),-- [enria]
(21149,2215,1,1,2,1763.94176),-- [rp_robe_of_seal]
(21149,2228,1,1,2,3762.46788),-- [rp_shining_circlet]
(21149,8723,1,1,2,5538.01452),-- [general_46_c]
(21149,8733,1,1,2,1384.71086),-- [special_46_c]
(21149,8743,1,1,2,138.42964),-- [rare_46_c]
(21149,8753,1,1,2,26.9399),-- [unique_46_c]
(21150,2166,1,1,-1,124078),-- [rp_earing_of_binding]
(21150,1911,1,1,-1,272241),-- [earing_of_protection_gemstone]
(21150,951,1,1,-1,6655),-- [scrl_of_ench_wp_c]
(21150,57,1445,2946,0,700000),-- [adena]
(21150,325,1,1,1,73.39184),-- [horn_of_glory]
(21150,2088,1,1,1,5714.60816),-- [horn_of_glory_fragment]
(21150,1871,1,1,2,124753.040586),-- [charcoal]
(21150,1866,1,1,2,83168.693724),-- [suede]
(21150,1877,1,1,2,4990.237038),-- [admantite_nugget]
(21150,4041,1,1,2,1084.896864),-- [mold_hardener]
(21150,4040,1,1,2,2494.878072),-- [mold_lubricant]
(21150,2166,1,1,2,4228.981836),-- [rp_earing_of_binding]
(21150,3014,1,1,2,3484.557924),-- [rp_full_plate_boots]
(21150,2234,1,1,2,1859.136204),-- [rp_divine_hose]
(21150,8724,1,1,2,4158.290418),-- [general_49_c]
(21150,8734,1,1,2,1039.692828),-- [special_49_c]
(21150,8744,1,1,2,103.873104),-- [rare_49_c]
(21150,8754,1,1,2,20.678442),-- [unique_49_c]
(21150,1342,10,30,2,249507.04296),-- [fine_steel_arrow]
(21151,4043,1,1,-1,127207),-- [asofe]
(21151,1869,1,9,-1,763245),-- [iron_ore]
(21151,4601,1,1,-1,8480),-- [dye_s3c3_c]
(21151,57,1509,3068,0,700000),-- [adena]
(21151,231,1,1,1,23.879216),-- [grace_dagger]
(21151,2106,1,1,1,2150.120784),-- [grace_dagger_edge]
(21151,233,1,1,1,23.879216),-- [dark_screamer]
(21151,2107,1,1,1,2150.120784),-- [dark_screamer_edge]
(21151,1869,1,1,2,157815.289722),-- [iron_ore]
(21151,1864,1,3,2,157815.289722),-- [stem]
(21151,1880,1,1,2,15781.459536),-- [steel]
(21151,5550,1,1,2,2104.264041),-- [reinforcing_plate]
(21151,4043,1,1,2,5260.486512),-- [asofe]
(21151,2169,1,1,2,2793.071145),-- [rp_necklace_of_binding]
(21151,8725,1,1,2,4383.854487),-- [general_52_c]
(21151,8735,1,1,2,1096.050417),-- [special_52_c]
(21151,8745,1,1,2,109.709196),-- [rare_52_c]
(21151,8755,1,1,2,21.525222),-- [unique_52_c]
(21152,4600,1,1,-1,13611),-- [dye_w2m2_c]
(21152,1806,1,1,-1,8167),-- [rp_soulshot_b]
(21152,1920,1,1,-1,139722),-- [necklace_of_binding_chain]
(21152,57,1616,3283,0,700000),-- [adena]
(21152,400,1,1,1,79.146848),-- [theca_leather_mail]
(21152,1984,1,1,1,5386.390768),-- [theca_leather_mail_pattern]
(21152,401,1,1,1,37.470576),-- [drake_leather_mail]
(21152,1987,1,1,1,3833.636928),-- [drake_leather_mail_texture]
(21152,420,1,1,1,126.678464),-- [theca_leather_gaiters]
(21152,1985,1,1,1,8664.676416),-- [theca_leather_gaiters_pattern]
(21152,1873,1,1,2,50256.959093),-- [silver_nugget]
(21152,1868,1,1,2,251284.423442),-- [thread]
(21152,1876,1,1,2,25128.293535),-- [mithril_ore]
(21152,1895,1,1,2,35897.615339),-- [metallic_fiber]
(21152,4042,1,1,2,2094.117467),-- [enria]
(21152,1806,1,1,2,251.115525),-- [rp_soulshot_b]
(21152,4959,1,1,2,2420.753661),-- [rp_avadon_boots_i]
(21152,4941,1,1,2,966.515754),-- [rp_shrnoen's_gaiters_i]
(21152,8726,1,1,2,2908.475814),-- [general_55_c]
(21152,8736,1,1,2,726.932942),-- [special_55_c]
(21152,8746,1,1,2,72.544485),-- [rare_55_c]
(21152,8756,1,1,2,15.252943),-- [unique_55_c]
(21153,4129,1,1,-1,52277),-- [rp_earing_of_black_ore]
(21153,4049,1,1,-1,253365),-- [adamantite_earing_gemstone]
(21153,947,1,1,-1,1932),-- [scrl_of_ench_wp_b]
(21153,57,1906,3892,0,700000),-- [adena]
(21153,357,1,1,1,22.3506),-- [shrnoen's_breastplate]
(21153,4056,1,1,1,3229.231244),-- [shrnoen's_breastplate_part]
(21153,2376,1,1,1,22.3506),-- [avadon_breastplate]
(21153,4064,1,1,1,3229.231244),-- [avadon_breastplate_part]
(21153,383,1,1,1,35.76096),-- [shrnoen's_gaiters]
(21153,4057,1,1,1,4990.64064),-- [shrnoen's_gaiters_material]
(21153,2379,1,1,1,35.76096),-- [avadon_gaiters]
(21153,4065,1,1,1,4990.673752),-- [avadon_gaiters_material]
(21153,1894,1,1,2,4551.275414),-- [crafted_leather]
(21153,4039,1,1,2,4323.714376),-- [mold_glue]
(21153,4041,1,1,2,1127.931034),-- [mold_hardener]
(21153,4044,1,1,2,4323.714376),-- [thons]
(21153,947,1,1,2,51.884864),-- [scrl_of_ench_wp_b]
(21153,3955,1,1,2,259.42432),-- [rp_blessed_spiritshot_b]
(21153,5280,1,1,2,259.42432),-- [rp_adv_comp_bspiritshot_b]
(21153,8727,1,1,2,2594.224982),-- [general_58_b]
(21153,8737,1,1,2,648.5608),-- [special_58_b]
(21153,8747,1,1,2,64.85608),-- [rare_58_b]
(21153,8757,1,1,2,12.989434),-- [unique_58_b]
(21154,4613,1,1,-1,7001),-- [dye_s4c4_c]
(21154,4614,1,1,-1,7001),-- [dye_s4d4_c]
(21154,4049,1,1,-1,266232),-- [adamantite_earing_gemstone]
(21154,57,2005,4083,0,700000),-- [adena]
(21154,2397,1,1,1,41.751641),-- [tunic_of_shrnoen]
(21154,4069,1,1,1,5892.656172),-- [tunic_of_shrnoen_fabric]
(21154,2406,1,1,1,25.682817),-- [avadon_robe]
(21154,4071,1,1,1,4527.020643),-- [avadon_robe_fabric]
(21154,2402,1,1,1,66.810426),-- [hose_of_shrnoen]
(21154,4070,1,1,1,8947.078301),-- [hose_of_shrnoen_fabric]
(21154,1872,1,3,2,111058.181145),-- [animal_bone]
(21154,1867,1,3,2,74038.78743),-- [animal_skin]
(21154,1881,1,1,2,22211.55499),-- [coarse_bone_powder]
(21154,1875,1,1,2,11105.777495),-- [stone_of_purity]
(21154,4041,1,1,2,1448.49137),-- [mold_hardener]
(21154,948,1,1,2,416.349875),-- [scrl_of_ench_am_b]
(21154,4162,1,1,2,691.34389),-- [rp_tunic_of_doom]
(21154,5003,1,1,2,127.139035),-- [rp_art_of_battle_axe_i]
(21154,1832,1,1,2,185097.37477),-- [advanced_antidote]
(21155,4050,1,1,-1,317155),-- [adamantite_ring_wire]
(21155,4130,1,1,-1,83099),-- [rp_ring_of_black_ore]
(21155,4051,1,1,-1,198522),-- [adamantite_necklace_chain]
(21155,57,2021,4119,0,700000),-- [adena]
(21155,856,1,1,1,108.180812),-- [adamantite_earing]
(21155,4049,1,1,1,13217.926624),-- [adamantite_earing_gemstone]
(21155,918,1,1,1,81.145348),-- [adamantite_necklace]
(21155,4051,1,1,1,9773.125456),-- [adamantite_necklace_chain]
(21155,887,1,1,1,162.25174),-- [adamantite_ring]
(21155,4050,1,1,1,15613.37002),-- [adamantite_ring_wire]
(21155,1895,1,1,2,43201.079614),-- [metallic_fiber]
(21155,4040,1,1,2,3024.025004),-- [mold_lubricant]
(21155,4042,1,1,2,2520.141239),-- [enria]
(21155,4043,1,1,2,5040.282478),-- [asofe]
(21155,4154,1,1,2,1789.419478),-- [rp_doom_shield]
(21155,6037,1,1,2,302406.834884),-- [scroll_of_awake]
(21155,8728,1,1,2,2520.141239),-- [general_61_b]
(21155,8738,1,1,2,629.945008),-- [special_61_b]
(21155,8748,1,1,2,62.850018),-- [rare_61_b]
(21155,8758,1,1,2,12.281038),-- [unique_61_b]
(21156,4131,1,1,-1,44665),-- [rp_necklace_of_black_ore]
(21156,4056,1,1,-1,99436),-- [shrnoen's_breastplate_part]
(21156,948,1,1,-1,13735),-- [scrl_of_ench_am_b]
(21156,57,2177,4415,0,700000),-- [adena]
(21156,554,1,1,1,101.65376),-- [shrnoen's_boots]
(21156,4097,1,1,1,10558.34624),-- [shrnoen's_boots_design]
(21156,600,1,1,1,101.65376),-- [avadon_boots]
(21156,4098,1,1,1,10558.34624),-- [avadon_boots_design]
(21156,612,1,1,1,101.65376),-- [shrnoen's_gauntlet]
(21156,4100,1,1,1,10558.34624),-- [shrnoen's_gauntlet_part]
(21156,2464,1,1,1,101.65376),-- [avadon_gloves]
(21156,4073,1,1,1,10558.34624),-- [avadon_gloves_part]
(21156,1865,1,1,2,147526.144134),-- [varnish]
(21156,1870,1,1,2,147526.144134),-- [coal]
(21156,1879,1,1,2,24587.617128),-- [cokes]
(21156,1875,1,1,2,9834.958578),-- [stone_of_purity]
(21156,4040,1,1,2,2950.53171),-- [mold_lubricant]
(21156,4160,1,1,2,417.973602),-- [rp_leather_mail_of_doom]
(21156,8728,1,1,2,2458.849986),-- [general_61_b]
(21156,8738,1,1,2,614.822838),-- [special_61_b]
(21156,8748,1,1,2,61.349874),-- [rare_61_b]
(21156,8758,1,1,2,12.358248),-- [unique_61_b]
(21156,1343,20,60,2,105375.249768),-- [silver_arrow]
(21157,5549,1,1,-1,626651),-- [iron_thread]
(21157,1889,1,1,-1,417768),-- [compound_braid]
(21157,4052,1,1,-1,221863),-- [earing_of_black_ore_piece]
(21157,57,2488,5032,0,700000),-- [adena]
(21157,110,1,1,1,94.954836),-- [doom_shield]
(21157,4077,1,1,1,13879.2381),-- [doom_shield_fragment]
(21157,2416,1,1,1,66.472128),-- [blue_wolve's_helmet]
(21157,4088,1,1,1,11660.431404),-- [blue_wolve's_helmet_design]
(21157,2417,1,1,1,66.472128),-- [doom_helmet]
(21157,4089,1,1,1,11660.431404),-- [doom_helmet_pattern]
(21157,1868,1,3,2,154252.604066),-- [thread]
(21157,1873,1,1,2,61701.234672),-- [silver_nugget]
(21157,5549,1,1,2,15425.308668),-- [iron_thread]
(21157,1889,1,1,2,10283.539112),-- [compound_braid]
(21157,4044,1,1,2,5141.769556),-- [thons]
(21157,1830,1,1,2,61701.234672),-- [scroll_of_escape_to_castle]
(21157,8487,1,1,2,84.45745),-- [rp_hammer_of_destroyer_i]
(21157,8729,1,1,2,2056.900868),-- [general_64_a]
(21157,8739,1,1,2,513.98391),-- [special_64_a]
(21157,8749,1,1,2,51.639698),-- [rare_64_a]
(21157,8759,1,1,2,10.134894),-- [unique_64_a]
(21157,1832,1,1,2,171391.192434),-- [advanced_antidote]
(21158,5230,1,1,-1,9462),-- [rp_mithril_arrow]
(21158,4053,1,1,-1,304195),-- [ring_of_black_ore_gemstone]
(21158,57,2798,5718,0,700000),-- [adena]
(21158,2391,1,1,1,34.741224),-- [blue_wolve's_leather_mail]
(21158,4082,1,1,1,5922.258776),-- [blue_wolve's_leather_mail_texture]
(21158,2392,1,1,1,34.741224),-- [leather_mail_of_doom]
(21158,4083,1,1,1,5922.258776),-- [leather_mail_of_doom_design]
(21158,1869,2,6,2,43672.998096),-- [iron_ore]
(21158,1864,1,3,2,174691.992384),-- [stem]
(21158,1880,1,1,2,17469.121392),-- [steel]
(21158,5550,1,1,2,2329.164288),-- [reinforcing_plate]
(21158,4043,1,1,2,5822.91072),-- [asofe]
(21158,1830,1,1,2,69876.8748),-- [scroll_of_escape_to_castle]
(21158,8487,1,1,2,95.36184),-- [rp_hammer_of_destroyer_i]
(21158,8730,1,1,2,1941.099984),-- [general_67_a]
(21158,8740,1,1,2,485.372304),-- [special_67_a]
(21158,8750,1,1,2,48.654),-- [rare_67_a]
(21158,8760,1,1,2,9.7308),-- [unique_67_a]
(21158,1344,30,90,2,72788.719392),-- [mithril_arrow]
(21159,5478,1,1,-1,61665),-- [sealed_dark_crystal_leather_mail_pattern]
(21159,1874,1,1,-1,488878),-- [oriharukon_ore]
(21159,4043,1,1,-1,244439),-- [asofe]
(21159,57,2901,5897,0,700000),-- [adena]
(21159,5304,1,1,1,27.032031),-- [sealed_tallum_tunic]
(21159,5485,1,1,1,3035.535711),-- [sealed_tallum_tunic_texture]
(21159,5308,1,1,1,16.628157),-- [sealed_dark_crystal_robe]
(21159,5486,1,1,1,2136.011553),-- [sealed_dark_crystal_robe_fabric]
(21159,5305,1,1,1,43.229199),-- [sealed_tallum_hose]
(21159,5489,1,1,1,4764.563349),-- [sealed_tallum_hose_fabric]
(21159,1870,1,1,2,166623.321557),-- [coal]
(21159,1865,1,1,2,166623.321557),-- [varnish]
(21159,1874,1,1,2,11108.283101),-- [oriharukon_ore]
(21159,4043,1,1,2,5553.910311),-- [asofe]
(21159,4039,1,1,2,5553.910311),-- [mold_glue]
(21159,3035,1,1,2,221.98992),-- [rp_spiritshot_a]
(21159,5281,1,1,2,221.98992),-- [rp_adv_comp_bspiritshot_a]
(21159,8326,1,1,2,61.509707),-- [rp_doom_crusher_i]
(21159,8730,1,1,2,1851.303437),-- [general_67_a]
(21159,8740,1,1,2,462.941479),-- [special_67_a]
(21159,8750,1,1,2,46.2479),-- [rare_67_a]
(21159,8760,1,1,2,9.24958),-- [unique_67_a]
(21159,1344,20,60,2,104141.02122),-- [mithril_arrow]
(21160,5479,1,1,-1,36206),-- [sealed_tallum_leather_mail_pattern]
(21160,1807,1,1,-1,8158),-- [rp_soulshot_a]
(21160,5482,1,1,-1,80760),-- [sealed_legging_of_dark_crystal_design]
(21160,57,3019,6154,0,700000),-- [adena]
(21160,5304,1,1,1,28.194438),-- [sealed_tallum_tunic]
(21160,5485,1,1,1,3166.067078),-- [sealed_tallum_tunic_texture]
(21160,5308,1,1,1,17.343186),-- [sealed_dark_crystal_robe]
(21160,5486,1,1,1,2227.862394),-- [sealed_dark_crystal_robe_fabric]
(21160,5305,1,1,1,45.088102),-- [sealed_tallum_hose]
(21160,5489,1,1,1,4969.444802),-- [sealed_tallum_hose_fabric]
(21160,1894,1,1,2,7206.497034),-- [crafted_leather]
(21160,4039,1,1,2,6846.237684),-- [mold_glue]
(21160,4041,1,1,2,1786.01302),-- [mold_hardener]
(21160,4044,1,1,2,6846.237684),-- [thons]
(21160,1807,1,1,2,273.797106),-- [rp_soulshot_a]
(21160,6037,1,1,2,410775.134396),-- [scroll_of_awake]
(21160,729,1,1,2,22.707256),-- [scrl_of_ench_wp_a]
(21160,8730,1,1,2,2282.079228),-- [general_67_a]
(21160,8740,1,1,2,570.738146),-- [special_67_a]
(21160,8750,1,1,2,57.204818),-- [rare_67_a]
(21160,8760,1,1,2,11.353628),-- [unique_67_a]
(21161,3035,1,1,-1,8917),-- [rp_spiritshot_a]
(21161,5485,1,1,-1,56237),-- [sealed_tallum_tunic_texture]
(21161,4041,1,1,-1,58154),-- [mold_hardener]
(21161,57,3302,6724,0,700000),-- [adena]
(21161,6324,1,1,1,81.900233),-- [sealed_phoenix's_earing]
(21161,6341,1,1,1,11382.43141),-- [sealed_phoenix's_earing_gemstone]
(21161,6323,1,1,1,61.416127),-- [sealed_phoenix's_necklace]
(21161,6343,1,1,1,8799.045448),-- [sealed_phoenix's_necklace_beads]
(21161,6325,1,1,1,122.832254),-- [sealed_phoenix's_ring]
(21161,6345,1,1,1,15743.374528),-- [sealed_phoenix's_ring_gemstone]
(21161,1871,1,1,2,224482.756764),-- [charcoal]
(21161,1866,1,1,2,149655.171176),-- [suede]
(21161,1877,1,1,2,8979.200342),-- [admantite_nugget]
(21161,4041,1,1,2,1952.017144),-- [mold_hardener]
(21161,4040,1,1,2,4489.796472),-- [mold_lubricant]
(21161,5276,1,1,2,299.162724),-- [rp_adv_comp_spiritshot_a]
(21161,8326,1,1,2,83.231624),-- [rp_doom_crusher_i]
(21161,8731,1,1,2,2078.434988),-- [general_70_a]
(21161,8741,1,1,2,519.805048),-- [special_70_a]
(21161,8751,1,1,2,51.823464),-- [rare_70_a]
(21161,8761,1,1,2,10.600254),-- [unique_70_a]
(21162,5486,1,1,-1,39629),-- [sealed_dark_crystal_robe_fabric]
(21162,3956,1,1,-1,8930),-- [rp_blessed_spiritshot_a]
(21162,5478,1,1,-1,56317),-- [sealed_dark_crystal_leather_mail_pattern]
(21162,57,3305,6737,0,700000),-- [adena]
(21162,5297,1,1,1,30.859074),-- [sealed_dark_crystal_leather_mail]
(21162,5478,1,1,1,3465.289794),-- [sealed_dark_crystal_leather_mail_pattern]
(21162,5301,1,1,1,18.982278),-- [sealed_tallum_leather_mail]
(21162,5479,1,1,1,2438.416062),-- [sealed_tallum_leather_mail_pattern]
(21162,5298,1,1,1,49.349346),-- [sealed_legging_of_dark_crystal]
(21162,5482,1,1,1,5439.103446),-- [sealed_legging_of_dark_crystal_design]
(21162,1873,1,1,2,89921.50128),-- [silver_nugget]
(21162,1868,1,3,2,224803.7532),-- [thread]
(21162,1876,1,1,2,44960.75064),-- [mithril_ore]
(21162,1895,1,1,2,64229.70636),-- [metallic_fiber]
(21162,4042,1,1,2,3746.80224),-- [enria]
(21162,1807,1,1,2,299.67408),-- [rp_soulshot_a]
(21162,8731,1,1,2,2081.50812),-- [general_70_a]
(21162,8741,1,1,2,520.48656),-- [special_70_a]
(21162,8751,1,1,2,52.13628),-- [rare_70_a]
(21162,8761,1,1,2,10.51488),-- [unique_70_a]
(21162,6036,1,1,2,7493.16636),-- [potion_of_acumen3]
(21163,5480,1,1,-1,31860),-- [sealed_leather_mail_of_nightmare_fabric]
(21163,5481,1,1,-1,31860),-- [sealed_majestic_leather_mail_fabric]
(21163,729,1,1,-1,789),-- [scrl_of_ench_wp_a]
(21163,57,3493,7152,0,700000),-- [adena]
(21163,5291,1,1,1,73.638936),-- [sealed_dark_crystal_boots]
(21163,5496,1,1,1,7684.361064),-- [sealed_dark_crystal_boots_lining]
(21163,5296,1,1,1,73.638936),-- [sealed_tallum_boots]
(21163,5497,1,1,1,7684.361064),-- [sealed_tallum_boots_lining]
(21163,5290,1,1,1,73.638936),-- [sealed_dark_crystal_gloves]
(21163,5508,1,1,1,7684.361064),-- [sealed_dark_crystal_gloves_design]
(21163,5295,1,1,1,73.638936),-- [sealed_tallum_gloves]
(21163,5509,1,1,1,7684.361064),-- [sealed_tallum_gloves_design]
(21163,1867,1,3,2,158882.97502),-- [animal_skin]
(21163,1872,1,3,2,105921.76072),-- [animal_bone]
(21163,1882,1,1,2,52960.88036),-- [leather]
(21163,1894,1,1,2,8362.19154),-- [crafted_leather]
(21163,4042,1,1,2,3972.2163),-- [enria]
(21163,729,1,1,2,26.38126),-- [scrl_of_ench_wp_a]
(21163,4987,1,1,2,988.79634),-- [rp_tunic_of_doom_i]
(21163,8731,1,1,2,2206.67552),-- [general_70_a]
(21163,8741,1,1,2,551.66888),-- [special_70_a]
(21163,8751,1,1,2,55.1001),-- [rare_70_a]
(21163,8761,1,1,2,11.35396),-- [unique_70_a]
(21164,5487,1,1,-1,36693),-- [sealed_robe_of_nightmare_fabric]
(21164,5480,1,1,-1,36564),-- [sealed_leather_mail_of_nightmare_fabric]
(21164,5481,1,1,-1,36564),-- [sealed_majestic_leather_mail_fabric]
(21164,57,4018,8199,0,700000),-- [adena]
(21164,6327,1,1,1,66.949245),-- [sealed_majestic_earing]
(21164,6342,1,1,1,11359.619315),-- [sealed_majestic_earing_gemstone]
(21164,6326,1,1,1,50.20312),-- [sealed_majestic_necklace]
(21164,6344,1,1,1,7351.30209),-- [sealed_majestic_necklace_beads]
(21164,6328,1,1,1,100.40624),-- [sealed_majestic_ring]
(21164,6346,1,1,1,16326.51999),-- [sealed_majestic_ring_gemstrone]
(21164,1871,1,3,2,167148.341884),-- [charcoal]
(21164,1866,1,1,2,222864.594701),-- [suede]
(21164,1877,1,1,2,13371.8007),-- [admantite_nugget]
(21164,4041,1,1,2,2906.804526),-- [mold_hardener]
(21164,4040,1,1,2,6685.90035),-- [mold_lubricant]
(21164,729,1,1,2,37.074463),-- [scrl_of_ench_wp_a]
(21164,8732,1,1,2,2786.000096),-- [general_75_s]
(21164,8742,1,1,2,696.500024),-- [special_75_s]
(21164,8752,1,1,2,69.983256),-- [rare_75_s]
(21165,5488,1,1,-1,37883),-- [sealed_majestic_robe_fabric]
(21165,5495,1,1,-1,127745),-- [sealed_shield_of_nightmare_fragment]
(21165,730,1,1,-1,7011),-- [scrl_of_ench_am_a]
(21165,57,4147,8467,0,700000),-- [adena]
(21165,5320,1,1,1,23.520984),-- [sealed_leather_mail_of_nightmare]
(21165,5480,1,1,1,3484.979016),-- [sealed_leather_mail_of_nightmare_fabric]
(21165,5323,1,1,1,23.520984),-- [sealed_majestic_leather_mail]
(21165,5481,1,1,1,3484.979016),-- [sealed_majestic_leather_mail_fabric]
(21165,1895,1,1,2,88748.898255),-- [metallic_fiber]
(21165,4040,1,1,2,6212.613996),-- [mold_lubricant]
(21165,4042,1,1,2,5177.17833),-- [enria]
(21165,4043,1,1,2,10353.931953),-- [asofe]
(21165,730,1,1,2,258.646563),-- [scrl_of_ench_am_a]
(21165,6037,1,3,2,310620.931539),-- [scroll_of_awake]
(21165,729,1,1,2,34.401267),-- [scrl_of_ench_wp_a]
(21165,8732,1,1,2,2588.589165),-- [general_75_s]
(21165,8742,1,1,2,647.253468),-- [special_75_s]
(21165,8752,1,1,2,64.555464),-- [rare_75_s]
(21166,1868,1,3,-1,886728),-- [thread]
(21166,1873,1,1,-1,354691),-- [silver_nugget]
(21166,1898,1,1,-1,91087),-- [blue_diamond_necklace_gem]
(21166,6362,23,42,0,700000),-- [red_sealstone]
(21166,6360,53,109,1,700000),-- [blue_sealstone]
(21166,25,1,1,2,713.295372),-- [piece_bone_breastplate]
(21166,1926,1,1,2,8818.976021),-- [piece_bone_breastplate_fragment]
(21166,26,1,1,2,461.708982),-- [bronze_breastplate]
(21166,32,1,1,2,1141.287351),-- [piece_bone_gaiters]
(21166,1928,1,1,2,12717.827276),-- [piece_bone_gaiters_fragment]
(21166,34,1,1,2,739.904998),-- [bronze_gaiters]
(21166,1868,1,3,3,130962.642108),-- [thread]
(21166,1873,1,1,3,52385.256834),-- [silver_nugget]
(21166,2176,1,1,3,62661.450774),-- [rp_leather_boots]
(21166,6037,1,3,3,87308.650284),-- [scroll_of_awake]
(21167,1804,1,1,-1,39326),-- [rp_soulshot_d]
(21167,1926,1,1,-1,99308),-- [piece_bone_breastplate_fragment]
(21167,2151,1,1,-1,273857),-- [rp_necklace_of_devotion]
(21167,6362,21,39,0,700000),-- [red_sealstone]
(21167,6360,72,143,1,700000),-- [blue_sealstone]
(21167,1102,1,1,2,2045.290996),-- [tunic_of_magicpower]
(21167,1105,1,1,2,3281.709004),-- [hose_of_magicpower]
(21167,1867,1,1,3,193604.579046),-- [animal_skin]
(21167,1872,1,1,3,193604.579046),-- [animal_bone]
(21167,1882,1,1,3,32267.285982),-- [leather]
(21167,735,1,1,3,12100.555926),-- [swift_attack_potion]
(21168,1899,1,1,-1,184636),-- [necklace_of_devotion_chain]
(21168,5549,1,1,-1,118167),-- [iron_thread]
(21168,1889,1,1,-1,78778),-- [compound_braid]
(21168,6362,22,41,0,700000),-- [red_sealstone]
(21168,6360,97,190,1,700000),-- [blue_sealstone]
(21168,847,1,1,2,1601.894656),-- [red_cresent_earing]
(21168,910,1,1,2,1201.420992),-- [necklace_of_devotion]
(21168,1899,1,1,2,25905.811256),-- [necklace_of_devotion_chain]
(21168,890,1,1,2,2402.873096),-- [ring_of_devotion]
(21168,1868,1,3,3,110531.493468),-- [thread]
(21168,1873,1,1,3,44212.518198),-- [silver_nugget]
(21168,5549,1,1,3,11053.228536),-- [iron_thread]
(21168,1889,1,1,3,7368.951006),-- [compound_braid]
(21168,2262,1,1,3,1716.42591),-- [rp_elven_bow]
(21168,6037,1,1,3,221063.382882),-- [scroll_of_awake]
(21169,1061,1,1,-1,881783),-- [healing_potion]
(21169,1900,1,1,-1,159184),-- [enchanted_necklace_chain]
(21169,2153,1,1,-1,226274),-- [rp_tiger'seye_earing]
(21169,6362,24,44,0,700000),-- [red_sealstone]
(21169,6360,128,259,1,700000),-- [blue_sealstone]
(21169,1123,1,1,2,3105.5),-- [blue_buckskin_boots]
(21169,605,1,1,2,3105.5),-- [leather_gauntlet]
(21169,1869,1,1,3,159014.14578),-- [iron_ore]
(21169,1864,1,3,3,159014.14578),-- [stem]
(21169,1880,1,1,3,15901.3785),-- [steel]
(21169,5550,1,1,3,2120.30406),-- [reinforcing_plate]
(21169,2153,1,1,3,24730.02588),-- [rp_tiger'seye_earing]
(21170,1901,1,1,-1,222980),-- [tiger'seye_earing_stone]
(21170,2154,1,1,-1,172845),-- [rp_elven_earing]
(21170,1938,1,1,-1,108529),-- [mithril_banded_mail_material]
(21170,6362,22,41,0,700000),-- [red_sealstone]
(21170,6361,33,63,1,700000),-- [green_sealstone]
(21170,6360,108,211,2,700000),-- [blue_sealstone]
(21170,628,1,1,3,2093.359974),-- [hoplon]
(21170,47,1,1,3,1464.640026),-- [helmet]
(21170,1869,1,1,4,143058.140368),-- [iron_ore]
(21170,1864,1,1,4,286116.280736),-- [stem]
(21170,1880,1,1,4,14305.862064),-- [steel]
(21170,5550,1,1,4,1907.640384),-- [reinforcing_plate]
(21170,2155,1,1,4,22962.764864),-- [rp_elven_ring]
(21170,6035,1,1,4,11921.311584),-- [potion_of_acumen2]
(21171,1870,1,5,-1,684631),-- [coal]
(21171,1865,1,5,-1,684631),-- [varnish]
(21171,1939,1,1,-1,180403),-- [mithril_banded_gaiters_material]
(21171,6362,24,44,0,700000),-- [red_sealstone]
(21171,6361,68,136,1,700000),-- [green_sealstone]
(21171,6360,96,192,2,700000),-- [blue_sealstone]
(21171,83,1,1,3,66.0972),-- [sword_of_magic]
(21171,144,1,1,3,66.0972),-- [sword_of_occult]
(21171,124,1,1,3,48.96528),-- [two-handed_sword]
(21171,2026,1,1,3,2190.90729),-- [two-handed_sword_edge]
(21171,127,1,1,3,48.96528),-- [crimson_sword]
(21171,130,1,1,3,48.96775),-- [elven_sword]
(21171,1870,1,3,4,136504.928575),-- [coal]
(21171,1865,1,1,4,273009.85715),-- [varnish]
(21171,1874,1,1,4,18200.502389),-- [oriharukon_ore]
(21171,2191,1,1,4,36547.711886),-- [rp_gauntlet_of_repose_of_the_soul]
(21172,1825,1,1,-1,172903),-- [rp_oriharukon]
(21172,1902,1,1,-1,245252),-- [elven_earing_beads]
(21172,2145,1,1,-1,172903),-- [rp_mithirl_alloy]
(21172,6362,24,45,0,700000),-- [red_sealstone]
(21172,6361,105,206,1,700000),-- [green_sealstone]
(21172,6360,89,178,2,700000),-- [blue_sealstone]
(21172,88,1,1,3,23.302164),-- [morning_star]
(21172,2031,1,1,3,1266.576573),-- [morning_star_head]
(21172,90,1,1,3,23.302164),-- [goathead_staff]
(21172,2032,1,1,3,1156.201905),-- [goathead_staff_head]
(21172,158,1,1,3,23.302164),-- [tarbar]
(21172,2035,1,1,3,1266.576573),-- [tarbar_head]
(21172,169,1,1,3,23.302164),-- [skull_breaker]
(21172,2036,1,1,3,1266.576573),-- [skull_breaker_head]
(21172,172,1,1,3,23.302164),-- [heavy_bone_club]
(21172,2037,1,1,3,1266.557556),-- [heavy_bone_club_head]
(21172,1871,2,6,4,62564.106297),-- [charcoal]
(21172,1866,1,1,4,166837.616792),-- [suede]
(21172,1877,1,1,4,10010.225302),-- [admantite_nugget]
(21172,2147,1,1,4,17875.572176),-- [rp_blacksmith's_frame]
(21172,1341,60,180,4,139031.479433),-- [bone_arrow]
(21173,1905,1,1,-1,252534),-- [onyxbeast'seye_earing_gemstone]
(21173,1881,1,1,-1,346140),-- [coarse_bone_powder]
(21173,1875,1,1,-1,173070),-- [stone_of_purity]
(21173,6362,22,41,0,700000),-- [red_sealstone]
(21173,6361,137,274,1,700000),-- [green_sealstone]
(21173,6360,56,111,2,700000),-- [blue_sealstone]
(21173,262,1,1,3,93.99576),-- [scallop_jamadhr]
(21173,2053,1,1,3,5390.00424),-- [scallop_jamadhr_edge]
(21173,1872,1,1,4,217269.16134),-- [animal_bone]
(21173,1867,1,1,4,217269.16134),-- [animal_skin]
(21173,1881,1,1,4,21726.77016),-- [coarse_bone_powder]
(21173,1875,1,1,4,10863.38508),-- [stone_of_purity]
(21173,1805,1,1,4,543.02328),-- [rp_soulshot_c]
(21173,2990,1,1,4,12932.80982),-- [rp_chain_boots]
(21173,5164,1,1,4,543.02328),-- [rp_comp_bspiritshot_c]
(21173,6036,1,1,4,5432.6657),-- [potion_of_acumen3]
(21174,1908,1,1,-1,316239),-- [moonstone_earing_wire]
(21174,2163,1,1,-1,170382),-- [rp_earing_of_protection]
(21174,1873,1,3,-1,667898),-- [silver_nugget]
(21174,6362,25,45,0,700000),-- [red_sealstone]
(21174,6361,211,425,1,700000),-- [green_sealstone]
(21174,6360,33,62,2,700000),-- [blue_sealstone]
(21174,281,1,1,3,89.529435),-- [crystallized_ice_bow]
(21174,2074,1,1,3,5589.470565),-- [crystallized_ice_bow_shaft]
(21174,1873,1,1,4,90188.18376),-- [silver_nugget]
(21174,1868,1,3,4,225470.91968),-- [thread]
(21174,1876,1,1,4,45094.09188),-- [mithril_ore]
(21174,1895,1,1,4,64420.32852),-- [metallic_fiber]
(21174,4042,1,1,4,3757.72592),-- [enria]
(21174,2164,1,1,4,17343.81068),-- [rp_ring_of_protection]
(21174,3002,1,1,4,14004.93956),-- [rp_dwarven_chain_gloves]
(21175,440,1,1,-1,1258),-- [robe_of_seal]
(21175,1912,1,1,-1,409204),-- [ring_of_protection_gemstone]
(21175,4590,1,1,-1,12658),-- [dye_s2d2_c]
(21175,6362,25,45,0,700000),-- [red_sealstone]
(21175,6361,268,532,1,700000),-- [green_sealstone]
(21175,227,1,1,2,38.069854),-- [stiletto]
(21175,2083,1,1,2,2794.930146),-- [stiletto_edge]
(21175,242,1,1,2,38.069854),-- [dagger_of_magicflame]
(21175,2084,1,1,2,2794.930146),-- [dagger_of_magicflame_blade]
(21175,1871,1,3,3,80121.356916),-- [charcoal]
(21175,1866,1,1,3,160242.216156),-- [suede]
(21175,1877,1,1,3,9614.602644),-- [admantite_nugget]
(21175,4041,1,1,3,2090.2392),-- [mold_hardener]
(21175,4040,1,1,3,4807.052484),-- [mold_lubricant]
(21175,951,1,1,3,436.959528),-- [scrl_of_ench_wp_c]
(21175,6037,1,3,3,240363.573072),-- [scroll_of_awake]
(21176,4041,1,1,-1,33616),-- [mold_hardener]
(21176,1872,1,11,-1,859080),-- [animal_bone]
(21176,4601,1,1,-1,8591),-- [dye_s3c3_c]
(21176,6362,11,22,0,700000),-- [red_sealstone]
(21176,6361,219,437,1,700000),-- [green_sealstone]
(21176,6360,133,267,2,700000),-- [blue_sealstone]
(21176,326,1,1,3,48.377142),-- [heathen's_book]
(21176,2110,1,1,3,4505.622858),-- [heathen's_book_page]
(21176,1864,4,12,4,57095.68895),-- [stem]
(21176,1865,2,6,4,45676.55116),-- [varnish]
(21176,1866,3,9,4,25375.81983),-- [suede]
(21176,1873,1,1,4,91353.10232),-- [silver_nugget]
(21176,1868,1,3,4,152255.29631),-- [thread]
(21176,2232,1,1,4,1312.73107),-- [rp_drake_leather_mail]
(21176,3012,1,1,4,4260.81036),-- [rp_full_plate_helmet]
(21177,4594,1,1,-1,17584),-- [dye_d2c2_c]
(21177,1806,1,1,-1,10550),-- [rp_soulshot_b]
(21177,1920,1,1,-1,180500),-- [necklace_of_binding_chain]
(21177,6362,13,27,0,700000),-- [red_sealstone]
(21177,6361,314,633,1,700000),-- [green_sealstone]
(21177,6360,148,301,2,700000),-- [blue_sealstone]
(21177,301,1,1,3,17.6528),-- [scorpion]
(21177,2113,1,1,3,1572.085625),-- [scorpion_blade]
(21177,303,1,1,3,17.6528),-- [widow_maker]
(21177,2114,1,1,3,1572.085625),-- [widow_maker_head]
(21177,299,1,1,3,13.77255),-- [orcish_poleaxe]
(21177,2122,1,1,3,1481.7506),-- [orcish_poleaxe_blade]
(21177,1873,1,1,4,97386.731248),-- [silver_nugget]
(21177,1868,1,3,4,243466.595568),-- [thread]
(21177,1876,1,1,4,48693.133072),-- [mithril_ore]
(21177,1895,1,1,4,69561.884448),-- [metallic_fiber]
(21177,4042,1,1,4,4057.567296),-- [enria]
(21177,3034,1,1,4,486.963888),-- [rp_spiritshot_b]
(21177,4944,1,1,4,1170.666768),-- [rp_avadon_breastplate_i]
(21177,4968,1,1,4,280.457712),-- [rp_kris_i]
(21178,4129,1,1,-1,61196),-- [rp_earing_of_black_ore]
(21178,4610,1,1,-1,12566),-- [dye_m3w3_c]
(21178,947,1,1,-1,2262),-- [scrl_of_ench_wp_b]
(21178,6362,13,26,0,700000),-- [red_sealstone]
(21178,6361,391,782,1,700000),-- [green_sealstone]
(21178,6360,73,146,2,700000),-- [blue_sealstone]
(21178,2384,1,1,3,46.513225),-- [shrnoen's_leather_shirts]
(21178,4066,1,1,3,6564.6867),-- [shrnoen's_leather_shirts_fabric]
(21178,2390,1,1,3,28.611825),-- [avadon_leather_mail]
(21178,4068,1,1,3,5043.306675),-- [avadon_leather_mail_lining]
(21178,2388,1,1,3,74.42985),-- [shrnoen's_leather_gaiters]
(21178,4067,1,1,3,9967.451725),-- [shrnoen's_leather_gaiters_texture]
(21178,1872,1,3,4,139188.904008),-- [animal_bone]
(21178,1867,1,1,4,278377.34533),-- [animal_skin]
(21178,1881,1,1,4,27837.965876),-- [coarse_bone_powder]
(21178,1875,1,1,4,13918.982938),-- [stone_of_purity]
(21178,4041,1,1,4,1815.579864),-- [mold_hardener]
(21178,948,1,1,4,521.909808),-- [scrl_of_ench_am_b]
(21178,4162,1,1,4,866.148192),-- [rp_tunic_of_doom]
(21178,5003,1,1,4,159.163984),-- [rp_art_of_battle_axe_i]
(21179,4613,1,1,-1,7498),-- [dye_s4c4_c]
(21179,947,1,1,-1,2174),-- [scrl_of_ench_wp_b]
(21179,1872,1,15,-1,906001),-- [animal_bone]
(21179,6362,11,22,0,700000),-- [red_sealstone]
(21179,6361,415,830,1,700000),-- [green_sealstone]
(21179,6360,7,15,2,700000),-- [blue_sealstone]
(21179,357,1,1,3,25.15185),-- [shrnoen's_breastplate]
(21179,4056,1,1,3,3633.957919),-- [shrnoen's_breastplate_part]
(21179,2376,1,1,3,25.15185),-- [avadon_breastplate]
(21179,4064,1,1,3,3633.957919),-- [avadon_breastplate_part]
(21179,383,1,1,3,40.24296),-- [shrnoen's_gaiters]
(21179,4057,1,1,3,5616.12864),-- [shrnoen's_gaiters_material]
(21179,2379,1,1,3,40.24296),-- [avadon_gaiters]
(21179,4065,1,1,3,5616.165902),-- [avadon_gaiters_material]
(21179,1872,1,3,4,101949.964025),-- [animal_bone]
(21179,1867,2,6,4,76462.57073),-- [animal_skin]
(21179,1881,1,1,4,30584.793785),-- [coarse_bone_powder]
(21179,1875,1,1,4,15292.592315),-- [stone_of_purity]
(21179,4041,1,1,4,1994.482035),-- [mold_hardener]
(21179,4155,1,1,4,712.510435),-- [rp_blue_wolve's_breastplate]
(21179,1343,20,60,4,163848.086675),-- [silver_arrow]
(21180,4052,1,1,-1,271551),-- [earing_of_black_ore_piece]
(21180,5230,1,1,-1,10227),-- [rp_mithril_arrow]
(21180,4053,1,1,-1,328759),-- [ring_of_black_ore_gemstone]
(21180,6362,14,28,0,700000),-- [red_sealstone]
(21180,6361,574,1144,1,700000),-- [green_sealstone]
(21180,2398,1,1,2,30.501009),-- [blue_wolve's_tunic]
(21180,4084,1,1,2,4923.408096),-- [blue_wolve's_tunic_fabric]
(21180,2399,1,1,2,30.501009),-- [tunic_of_doom]
(21180,4085,1,1,2,4923.408096),-- [tunic_of_doom_pattern]
(21180,2403,1,1,2,48.838896),-- [blue_wolve's_hose]
(21180,4086,1,1,2,6647.728698),-- [blue_wolve's_hose_pattern]
(21180,2404,1,1,2,48.838896),-- [hose_of_doom]
(21180,4087,1,1,2,6647.7753),-- [hose_of_doom_pattern]
(21180,1871,1,3,3,188798.808672),-- [charcoal]
(21180,1866,1,3,3,83910.431736),-- [suede]
(21180,1877,1,1,3,15104.120544),-- [admantite_nugget]
(21180,4041,1,1,3,3283.621776),-- [mold_hardener]
(21180,4040,1,1,3,7552.060272),-- [mold_lubricant]
(21180,1830,1,1,3,151038.957),-- [scroll_of_escape_to_castle]
(21181,5230,1,1,-1,10851),-- [rp_mithril_arrow]
(21181,4054,1,1,-1,160289),-- [necklace_of_black_ore_beads]
(21181,4041,1,1,-1,70764),-- [mold_hardener]
(21181,6362,14,27,0,700000),-- [red_sealstone]
(21181,6361,578,1160,1,700000),-- [green_sealstone]
(21181,864,1,1,2,112.69614),-- [earing_of_black_ore]
(21181,4052,1,1,2,14183.47272),-- [earing_of_black_ore_piece]
(21181,926,1,1,2,84.532008),-- [necklace_of_black_ore]
(21181,4054,1,1,2,7890.7104),-- [necklace_of_black_ore_beads]
(21181,895,1,1,2,169.024404),-- [ring_of_black_ore]
(21181,4053,1,1,2,17171.564328),-- [ring_of_black_ore_gemstone]
(21181,1872,1,3,3,228933.690628),-- [animal_bone]
(21181,1867,1,3,3,152622.611798),-- [animal_skin]
(21181,1881,1,1,3,45786.647298),-- [coarse_bone_powder]
(21181,1875,1,1,3,22893.550718),-- [stone_of_purity]
(21181,4041,1,1,3,2985.95735),-- [mold_hardener]
(21181,5230,1,1,3,457.771104),-- [rp_mithril_arrow]
(21181,5276,1,1,3,457.771104),-- [rp_adv_comp_spiritshot_a]
(21182,1876,1,3,-1,736136),-- [mithril_ore]
(21182,5478,1,1,-1,61902),-- [sealed_dark_crystal_leather_mail_pattern]
(21182,6362,11,22,0,700000),-- [red_sealstone]
(21182,6361,512,1023,1,700000),-- [green_sealstone]
(21182,5291,1,1,2,61.078647),-- [sealed_dark_crystal_boots]
(21182,5496,1,1,2,6373.671353),-- [sealed_dark_crystal_boots_lining]
(21182,5296,1,1,2,61.078647),-- [sealed_tallum_boots]
(21182,5497,1,1,2,6373.671353),-- [sealed_tallum_boots_lining]
(21182,5290,1,1,2,61.078647),-- [sealed_dark_crystal_gloves]
(21182,5508,1,1,2,6373.671353),-- [sealed_dark_crystal_gloves_design]
(21182,5295,1,1,2,61.078647),-- [sealed_tallum_gloves]
(21182,5509,1,1,2,6373.671353),-- [sealed_tallum_gloves_design]
(21182,1873,1,1,3,124253.288295),-- [silver_nugget]
(21182,1868,4,12,3,77658.366161),-- [thread]
(21182,1876,1,1,3,62126.888054),-- [mithril_ore]
(21182,1895,1,1,3,88752.209407),-- [metallic_fiber]
(21182,4042,1,1,3,5177.159369),-- [enria]
(21182,5156,1,1,3,414.153237),-- [rp_comp_soulshot_a]
(21182,1344,30,90,3,129430.935477),-- [mithril_arrow]
(21183,1807,1,1,-1,10950),-- [rp_soulshot_a]
(21183,5479,1,1,-1,48593),-- [sealed_tallum_leather_mail_pattern]
(21183,3035,1,1,-1,10950),-- [rp_spiritshot_a]
(21183,6362,14,28,0,700000),-- [red_sealstone]
(21183,6361,687,1380,1,700000),-- [green_sealstone]
(21183,5292,1,1,2,108.0996),-- [sealed_dark_crystal_shield]
(21183,5494,1,1,2,10612.704725),-- [sealed_dark_crystal_shield_fragment]
(21183,5289,1,1,2,75.643225),-- [sealed_dark_crystal_helmet]
(21183,5525,1,1,2,7811.46786),-- [sealed_dark_crystal_helmet_design]
(21183,5294,1,1,2,75.643225),-- [sealed_tallum_bonnet]
(21183,5526,1,1,2,7811.441365),-- [sealed_tallum_bonnet_design]
(21183,1894,1,1,3,21278.91699),-- [crafted_leather]
(21183,4039,1,1,3,20215.005036),-- [mold_glue]
(21183,4041,1,1,3,5273.46189),-- [mold_hardener]
(21183,4044,1,1,3,20215.005036),-- [thons]
(21183,5156,1,1,3,808.611048),-- [rp_comp_soulshot_a]
(21184,5480,1,1,-1,38649),-- [sealed_leather_mail_of_nightmare_fabric]
(21184,729,1,1,-1,957),-- [scrl_of_ench_wp_a]
(21184,1895,1,5,-1,820300),-- [metallic_fiber]
(21184,6362,14,27,0,700000),-- [red_sealstone]
(21184,6361,700,1400,1,700000),-- [green_sealstone]
(21184,5304,1,1,2,39.689052),-- [sealed_tallum_tunic]
(21184,5485,1,1,2,4456.843612),-- [sealed_tallum_tunic_texture]
(21184,5308,1,1,2,24.413844),-- [sealed_dark_crystal_robe]
(21184,5486,1,1,2,3136.141476),-- [sealed_dark_crystal_robe_fabric]
(21184,5305,1,1,2,63.470108),-- [sealed_tallum_hose]
(21184,5489,1,1,2,6995.441908),-- [sealed_tallum_hose_fabric]
(21184,1867,1,3,3,192741.596432),-- [animal_skin]
(21184,1872,1,3,3,128494.127552),-- [animal_bone]
(21184,1882,1,1,3,64247.063776),-- [leather]
(21184,1894,1,1,3,10144.209264),-- [crafted_leather]
(21184,4042,1,1,3,4818.71208),-- [enria]
(21184,729,1,1,3,32.003216),-- [scrl_of_ench_wp_a]
(21184,4987,1,1,3,1199.512944),-- [rp_tunic_of_doom_i]
(21184,8731,1,1,3,2676.927232),-- [general_70_a]
(21184,8741,1,1,3,669.231808),-- [special_70_a]
(21184,8751,1,1,3,66.84216),-- [rare_70_a]
(21184,8761,1,1,3,13.773536),-- [unique_70_a]
(21185,1875,1,1,-1,513582),-- [stone_of_purity]
(21185,5481,1,1,-1,34568),-- [sealed_majestic_leather_mail_fabric]
(21185,5487,1,1,-1,34691),-- [sealed_robe_of_nightmare_fabric]
(21185,6362,11,22,0,700000),-- [red_sealstone]
(21185,6361,612,1227,1,700000),-- [green_sealstone]
(21185,5304,1,1,2,35.497914),-- [sealed_tallum_tunic]
(21185,5485,1,1,2,3986.203834),-- [sealed_tallum_tunic_texture]
(21185,5308,1,1,2,21.835758),-- [sealed_dark_crystal_robe]
(21185,5486,1,1,2,2804.966982),-- [sealed_dark_crystal_robe_fabric]
(21185,5305,1,1,2,56.767706),-- [sealed_tallum_hose]
(21185,5489,1,1,2,6256.727806),-- [sealed_tallum_hose_fabric]
(21185,1873,1,1,3,113778.029204),-- [silver_nugget]
(21185,1868,3,9,3,94814.895588),-- [thread]
(21185,1876,1,1,3,56889.014602),-- [mithril_ore]
(21185,1895,1,1,3,81270.02086),-- [metallic_fiber]
(21185,4042,1,1,3,4740.783404),-- [enria]
(21185,5282,1,1,3,126.302442),-- [rp_adv_comp_bspiritshot_s]
(21185,6671,1,1,3,31604.965196),-- [key_of_treasure_box7]
(21185,8732,1,1,3,2370.391702),-- [general_75_s]
(21185,8742,1,1,3,592.501364),-- [special_75_s]
(21185,8752,1,1,3,59.095638),-- [rare_75_s]
(21186,5488,1,1,-1,46584),-- [sealed_majestic_robe_fabric]
(21186,730,1,1,-1,8621),-- [scrl_of_ench_am_a]
(21186,5480,1,1,-1,46420),-- [sealed_leather_mail_of_nightmare_fabric]
(21186,6362,14,28,0,700000),-- [red_sealstone]
(21186,6361,805,1610,1,700000),-- [green_sealstone]
(21186,5315,1,1,2,89.538834),-- [sealed_shield_of_nightmare]
(21186,5495,1,1,2,9665.951834),-- [sealed_shield_of_nightmare_fragment]
(21186,5312,1,1,2,62.654592),-- [sealed_helm_of_nightmare]
(21186,5527,1,1,2,7610.600074),-- [sealed_helm_of_nightmare_design]
(21186,5317,1,1,2,62.654592),-- [sealed_magestic_circlet]
(21186,5528,1,1,2,7610.600074),-- [sealed_magestic_circlet_design]
(21186,1871,4,12,3,79576.53054),-- [charcoal]
(21186,1866,1,3,3,141469.358199),-- [suede]
(21186,1877,1,1,3,25464.436803),-- [admantite_nugget]
(21186,4041,1,1,3,5535.873798),-- [mold_hardener]
(21186,4040,1,1,3,12732.350826),-- [mold_lubricant]
(21186,729,1,1,3,70.449834),-- [scrl_of_ench_wp_a]
(21187,1868,1,3,-1,886728),-- [thread]
(21187,1873,1,1,-1,354691),-- [silver_nugget]
(21187,1898,1,1,-1,91087),-- [blue_diamond_necklace_gem]
(21187,6362,23,42,0,700000),-- [red_sealstone]
(21187,6360,53,109,1,700000),-- [blue_sealstone]
(21187,25,1,1,2,713.295372),-- [piece_bone_breastplate]
(21187,1926,1,1,2,8818.976021),-- [piece_bone_breastplate_fragment]
(21187,26,1,1,2,461.708982),-- [bronze_breastplate]
(21187,32,1,1,2,1141.287351),-- [piece_bone_gaiters]
(21187,1928,1,1,2,12717.827276),-- [piece_bone_gaiters_fragment]
(21187,34,1,1,2,739.904998),-- [bronze_gaiters]
(21187,1868,1,1,3,261925.83979),-- [thread]
(21187,1873,1,1,3,52385.167958),-- [silver_nugget]
(21187,2176,1,1,3,62661.819642),-- [rp_leather_boots]
(21187,6035,1,1,3,10913.17261),-- [potion_of_acumen2]
(21188,1804,1,1,-1,39326),-- [rp_soulshot_d]
(21188,1926,1,1,-1,99308),-- [piece_bone_breastplate_fragment]
(21188,2151,1,1,-1,273857),-- [rp_necklace_of_devotion]
(21188,6362,21,39,0,700000),-- [red_sealstone]
(21188,6360,72,143,1,700000),-- [blue_sealstone]
(21188,1102,1,1,2,2045.290996),-- [tunic_of_magicpower]
(21188,1105,1,1,2,3281.709004),-- [hose_of_magicpower]
(21188,1867,1,1,3,193604.579046),-- [animal_skin]
(21188,1872,1,1,3,193604.579046),-- [animal_bone]
(21188,1882,1,1,3,32267.285982),-- [leather]
(21188,735,1,1,3,12100.555926),-- [swift_attack_potion]
(21189,1899,1,1,-1,184636),-- [necklace_of_devotion_chain]
(21189,5549,1,1,-1,118167),-- [iron_thread]
(21189,1889,1,1,-1,78778),-- [compound_braid]
(21189,6362,22,41,0,700000),-- [red_sealstone]
(21189,6360,97,190,1,700000),-- [blue_sealstone]
(21189,847,1,1,2,1601.894656),-- [red_cresent_earing]
(21189,910,1,1,2,1201.420992),-- [necklace_of_devotion]
(21189,1899,1,1,2,25905.811256),-- [necklace_of_devotion_chain]
(21189,890,1,1,2,2402.873096),-- [ring_of_devotion]
(21189,1868,1,1,3,265275.913895),-- [thread]
(21189,1873,1,1,3,53055.182779),-- [silver_nugget]
(21189,5549,1,1,3,13263.881319),-- [iron_thread]
(21189,1889,1,1,3,8842.587546),-- [compound_braid]
(21189,2262,1,1,3,2059.434461),-- [rp_elven_bow]
(21190,1061,1,1,-1,881783),-- [healing_potion]
(21190,1900,1,1,-1,159184),-- [enchanted_necklace_chain]
(21190,2153,1,1,-1,226274),-- [rp_tiger'seye_earing]
(21190,6362,24,44,0,700000),-- [red_sealstone]
(21190,6360,128,259,1,700000),-- [blue_sealstone]
(21190,1123,1,1,2,3105.5),-- [blue_buckskin_boots]
(21190,605,1,1,2,3105.5),-- [leather_gauntlet]
(21190,1869,1,1,3,132511.529539),-- [iron_ore]
(21190,1864,1,1,3,265022.614875),-- [stem]
(21190,1880,1,1,3,13251.019693),-- [steel]
(21190,5550,1,1,3,1767.039534),-- [reinforcing_plate]
(21190,2153,1,1,3,20608.353982),-- [rp_tiger'seye_earing]
(21190,6035,1,1,3,11042.442377),-- [potion_of_acumen2]
(21191,1901,1,1,-1,222980),-- [tiger'seye_earing_stone]
(21191,2154,1,1,-1,172845),-- [rp_elven_earing]
(21191,1938,1,1,-1,108529),-- [mithril_banded_mail_material]
(21191,6362,22,41,0,700000),-- [red_sealstone]
(21191,6361,33,63,1,700000),-- [green_sealstone]
(21191,6360,108,211,2,700000),-- [blue_sealstone]
(21191,628,1,1,3,2093.359974),-- [hoplon]
(21191,47,1,1,3,1464.640026),-- [helmet]
(21191,1869,1,1,4,171669.733833),-- [iron_ore]
(21191,1864,1,3,4,171669.733833),-- [stem]
(21191,1880,1,1,4,17166.856278),-- [steel]
(21191,5550,1,1,4,2289.018264),-- [reinforcing_plate]
(21191,2155,1,1,4,27555.657792),-- [rp_elven_ring]
(21192,1870,1,5,-1,684631),-- [coal]
(21192,1865,1,5,-1,684631),-- [varnish]
(21192,1939,1,1,-1,180403),-- [mithril_banded_gaiters_material]
(21192,6362,24,44,0,700000),-- [red_sealstone]
(21192,6361,68,136,1,700000),-- [green_sealstone]
(21192,6360,96,192,2,700000),-- [blue_sealstone]
(21192,83,1,1,3,66.0972),-- [sword_of_magic]
(21192,144,1,1,3,66.0972),-- [sword_of_occult]
(21192,124,1,1,3,48.96528),-- [two-handed_sword]
(21192,2026,1,1,3,2190.90729),-- [two-handed_sword_edge]
(21192,127,1,1,3,48.96528),-- [crimson_sword]
(21192,130,1,1,3,48.96775),-- [elven_sword]
(21192,1870,1,1,4,218407.94591),-- [coal]
(21192,1865,1,1,4,218407.94591),-- [varnish]
(21192,1874,1,1,4,14560.690452),-- [oriharukon_ore]
(21192,2191,1,1,4,29238.067012),-- [rp_gauntlet_of_repose_of_the_soul]
(21192,8317,1,1,4,1559.350716),-- [rp_giants_hammer]
(21193,1825,1,1,-1,172903),-- [rp_oriharukon]
(21193,1902,1,1,-1,245252),-- [elven_earing_beads]
(21193,2145,1,1,-1,172903),-- [rp_mithirl_alloy]
(21193,6362,24,45,0,700000),-- [red_sealstone]
(21193,6361,105,206,1,700000),-- [green_sealstone]
(21193,6360,89,178,2,700000),-- [blue_sealstone]
(21193,88,1,1,3,23.302164),-- [morning_star]
(21193,2031,1,1,3,1266.576573),-- [morning_star_head]
(21193,90,1,1,3,23.302164),-- [goathead_staff]
(21193,2032,1,1,3,1156.201905),-- [goathead_staff_head]
(21193,158,1,1,3,23.302164),-- [tarbar]
(21193,2035,1,1,3,1266.576573),-- [tarbar_head]
(21193,169,1,1,3,23.302164),-- [skull_breaker]
(21193,2036,1,1,3,1266.576573),-- [skull_breaker_head]
(21193,172,1,1,3,23.302164),-- [heavy_bone_club]
(21193,2037,1,1,3,1266.557556),-- [heavy_bone_club_head]
(21193,1871,1,3,4,156410.426705),-- [charcoal]
(21193,1866,1,1,4,208547.50215),-- [suede]
(21193,1877,1,1,4,12513.010055),-- [admantite_nugget]
(21193,2147,1,1,4,22344.06109),-- [rp_blacksmith's_frame]
(21194,1905,1,1,-1,252534),-- [onyxbeast'seye_earing_gemstone]
(21194,1881,1,1,-1,346140),-- [coarse_bone_powder]
(21194,1875,1,1,-1,173070),-- [stone_of_purity]
(21194,6362,22,41,0,700000),-- [red_sealstone]
(21194,6361,137,274,1,700000),-- [green_sealstone]
(21194,6360,56,111,2,700000),-- [blue_sealstone]
(21194,262,1,1,3,93.99576),-- [scallop_jamadhr]
(21194,2053,1,1,3,5390.00424),-- [scallop_jamadhr_edge]
(21194,1872,1,3,4,82769.2668),-- [animal_bone]
(21194,1867,2,6,4,62076.9501),-- [animal_skin]
(21194,1881,1,1,4,24830.78004),-- [coarse_bone_powder]
(21194,1875,1,1,4,12415.39002),-- [stone_of_purity]
(21194,1805,1,1,4,620.865432),-- [rp_soulshot_c]
(21194,6037,1,3,4,186230.8503),-- [scroll_of_awake]
(21194,2994,1,1,4,14779.897308),-- [rp_boots_of_seal]
(21195,1908,1,1,-1,316239),-- [moonstone_earing_wire]
(21195,440,1,1,-1,1106),-- [robe_of_seal]
(21195,6362,25,45,0,700000),-- [red_sealstone]
(21195,6361,211,425,1,700000),-- [green_sealstone]
(21195,6360,33,62,2,700000),-- [blue_sealstone]
(21195,281,1,1,3,89.529435),-- [crystallized_ice_bow]
(21195,2074,1,1,3,5589.470565),-- [crystallized_ice_bow_shaft]
(21195,1873,1,1,4,78914.727419),-- [silver_nugget]
(21195,1868,1,3,4,197286.214907),-- [thread]
(21195,1876,1,1,4,39457.162496),-- [mithril_ore]
(21195,1895,1,1,4,56367.547463),-- [metallic_fiber]
(21195,4042,1,1,4,3288.231017),-- [enria]
(21195,2164,1,1,4,15175.924597),-- [rp_ring_of_protection]
(21195,2228,1,1,4,5361.132494),-- [rp_shining_circlet]
(21195,6036,1,1,4,6576.059607),-- [potion_of_acumen3]
(21196,1911,1,1,-1,282441),-- [earing_of_protection_gemstone]
(21196,2166,1,1,-1,128726),-- [rp_earing_of_binding]
(21196,2167,1,1,-1,193746),-- [rp_ring_of_ages]
(21196,6362,25,45,0,700000),-- [red_sealstone]
(21196,6361,268,532,1,700000),-- [green_sealstone]
(21196,227,1,1,2,38.069854),-- [stiletto]
(21196,2083,1,1,2,2794.930146),-- [stiletto_edge]
(21196,242,1,1,2,38.069854),-- [dagger_of_magicflame]
(21196,2084,1,1,2,2794.930146),-- [dagger_of_magicflame_blade]
(21196,1871,1,1,3,280424.31046),-- [charcoal]
(21196,1866,1,1,3,186949.865072),-- [suede]
(21196,1877,1,1,3,11217.069848),-- [admantite_nugget]
(21196,4041,1,1,3,2438.662888),-- [mold_hardener]
(21196,4040,1,1,3,5608.534924),-- [mold_lubricant]
(21196,951,1,1,3,509.556808),-- [scrl_of_ench_wp_c]
(21197,4041,1,1,-1,36601),-- [mold_hardener]
(21197,1872,1,11,-1,935364),-- [animal_bone]
(21197,4603,1,1,-1,9354),-- [dye_c3s3_c]
(21197,6362,12,24,0,700000),-- [red_sealstone]
(21197,6361,238,476,1,700000),-- [green_sealstone]
(21197,6360,145,291,2,700000),-- [blue_sealstone]
(21197,326,1,1,3,52.679457),-- [heathen's_book]
(21197,2110,1,1,3,4906.320543),-- [heathen's_book_page]
(21197,1869,2,6,4,72526.748024),-- [iron_ore]
(21197,1870,2,6,4,58021.600699),-- [coal]
(21197,1871,3,9,4,48351.277727),-- [charcoal]
(21197,1872,7,21,4,27629.397882),-- [animal_bone]
(21197,1867,1,3,4,128936.852983),-- [animal_skin]
(21197,2232,1,1,4,1667.122685),-- [rp_drake_leather_mail]
(21198,4593,1,1,-1,17584),-- [dye_d2s2_c]
(21198,1806,1,1,-1,10550),-- [rp_soulshot_b]
(21198,1920,1,1,-1,180500),-- [necklace_of_binding_chain]
(21198,6362,13,27,0,700000),-- [red_sealstone]
(21198,6361,314,633,1,700000),-- [green_sealstone]
(21198,6360,148,301,2,700000),-- [blue_sealstone]
(21198,301,1,1,3,17.6528),-- [scorpion]
(21198,2113,1,1,3,1572.085625),-- [scorpion_blade]
(21198,303,1,1,3,17.6528),-- [widow_maker]
(21198,2114,1,1,3,1572.085625),-- [widow_maker_head]
(21198,299,1,1,3,13.77255),-- [orcish_poleaxe]
(21198,2122,1,1,3,1481.7506),-- [orcish_poleaxe_blade]
(21198,1873,1,1,4,97386.731248),-- [silver_nugget]
(21198,1868,1,3,4,243466.595568),-- [thread]
(21198,1876,1,1,4,48693.133072),-- [mithril_ore]
(21198,1895,1,1,4,69561.884448),-- [metallic_fiber]
(21198,4042,1,1,4,4057.567296),-- [enria]
(21198,3034,1,1,4,486.963888),-- [rp_spiritshot_b]
(21198,4944,1,1,4,1170.666768),-- [rp_avadon_breastplate_i]
(21198,4968,1,1,4,280.457712),-- [rp_kris_i]
(21199,4129,1,1,-1,61196),-- [rp_earing_of_black_ore]
(21199,4611,1,1,-1,12566),-- [dye_w3i3_c]
(21199,947,1,1,-1,2262),-- [scrl_of_ench_wp_b]
(21199,6362,13,26,0,700000),-- [red_sealstone]
(21199,6361,391,782,1,700000),-- [green_sealstone]
(21199,6360,73,146,2,700000),-- [blue_sealstone]
(21199,2384,1,1,3,46.513225),-- [shrnoen's_leather_shirts]
(21199,4066,1,1,3,6564.6867),-- [shrnoen's_leather_shirts_fabric]
(21199,2390,1,1,3,28.611825),-- [avadon_leather_mail]
(21199,4068,1,1,3,5043.306675),-- [avadon_leather_mail_lining]
(21199,2388,1,1,3,74.42985),-- [shrnoen's_leather_gaiters]
(21199,4067,1,1,3,9967.451725),-- [shrnoen's_leather_gaiters_texture]
(21199,1872,1,3,4,139189.096368),-- [animal_bone]
(21199,1867,1,1,4,278378.65594),-- [animal_skin]
(21199,1881,1,1,4,27837.633992),-- [coarse_bone_powder]
(21199,1875,1,1,4,13918.816996),-- [stone_of_purity]
(21199,4041,1,1,4,1815.296476),-- [mold_hardener]
(21199,948,1,1,4,522.030908),-- [scrl_of_ench_am_b]
(21199,4163,1,1,4,1382.66394),-- [rp_blue_wolve's_hose]
(21199,8311,1,1,4,159.80538),-- [rp_bone_of_kaim_vanul]
(21200,4613,1,1,-1,8164),-- [dye_s4c4_c]
(21200,4129,1,1,-1,64055),-- [rp_earing_of_black_ore]
(21200,4049,1,1,-1,310449),-- [adamantite_earing_gemstone]
(21200,6362,12,24,0,700000),-- [red_sealstone]
(21200,6361,452,904,1,700000),-- [green_sealstone]
(21200,6360,8,16,2,700000),-- [blue_sealstone]
(21200,357,1,1,3,27.3861),-- [shrnoen's_breastplate]
(21200,4056,1,1,3,3956.764014),-- [shrnoen's_breastplate_part]
(21200,2376,1,1,3,27.3861),-- [avadon_breastplate]
(21200,4064,1,1,3,3956.764014),-- [avadon_breastplate_part]
(21200,383,1,1,3,43.81776),-- [shrnoen's_gaiters]
(21200,4057,1,1,3,6115.01184),-- [shrnoen's_gaiters_material]
(21200,2379,1,1,3,43.81776),-- [avadon_gaiters]
(21200,4065,1,1,3,6115.052412),-- [avadon_gaiters_material]
(21200,1872,1,3,4,111002.850595),-- [animal_bone]
(21200,1867,2,6,4,83252.244334),-- [animal_skin]
(21200,1881,1,1,4,33300.642403),-- [coarse_bone_powder]
(21200,1875,1,1,4,16650.533977),-- [stone_of_purity]
(21200,4041,1,1,4,2171.586753),-- [mold_hardener]
(21200,4155,1,1,4,775.779473),-- [rp_blue_wolve's_breastplate]
(21200,1343,20,60,4,178397.362465),-- [silver_arrow]
(21201,4052,1,1,-1,271551),-- [earing_of_black_ore_piece]
(21201,5230,1,1,-1,10227),-- [rp_mithril_arrow]
(21201,4053,1,1,-1,328759),-- [ring_of_black_ore_gemstone]
(21201,6362,14,28,0,700000),-- [red_sealstone]
(21201,6361,574,1144,1,700000),-- [green_sealstone]
(21201,2398,1,1,2,30.501009),-- [blue_wolve's_tunic]
(21201,4084,1,1,2,4923.408096),-- [blue_wolve's_tunic_fabric]
(21201,2399,1,1,2,30.501009),-- [tunic_of_doom]
(21201,4085,1,1,2,4923.408096),-- [tunic_of_doom_pattern]
(21201,2403,1,1,2,48.838896),-- [blue_wolve's_hose]
(21201,4086,1,1,2,6647.728698),-- [blue_wolve's_hose_pattern]
(21201,2404,1,1,2,48.838896),-- [hose_of_doom]
(21201,4087,1,1,2,6647.7753),-- [hose_of_doom_pattern]
(21201,1871,1,3,3,161827.525055),-- [charcoal]
(21201,1866,1,3,3,71923.388495),-- [suede]
(21201,1877,1,1,3,12946.186155),-- [admantite_nugget]
(21201,4041,1,1,3,2814.457205),-- [mold_hardener]
(21201,4040,1,1,3,6473.291195),-- [mold_lubricant]
(21201,1830,1,1,3,129461.86155),-- [scroll_of_escape_to_castle]
(21201,6036,1,1,3,10788.290345),-- [potion_of_acumen3]
(21202,5230,1,1,-1,10851),-- [rp_mithril_arrow]
(21202,4054,1,1,-1,160289),-- [necklace_of_black_ore_beads]
(21202,4041,1,1,-1,70764),-- [mold_hardener]
(21202,6362,14,27,0,700000),-- [red_sealstone]
(21202,6361,578,1160,1,700000),-- [green_sealstone]
(21202,864,1,1,2,112.69614),-- [earing_of_black_ore]
(21202,4052,1,1,2,14183.47272),-- [earing_of_black_ore_piece]
(21202,926,1,1,2,84.532008),-- [necklace_of_black_ore]
(21202,4054,1,1,2,7890.7104),-- [necklace_of_black_ore_beads]
(21202,895,1,1,2,169.024404),-- [ring_of_black_ore]
(21202,4053,1,1,2,17171.564328),-- [ring_of_black_ore_gemstone]
(21202,1872,4,12,3,66772.25872),-- [animal_bone]
(21202,1867,1,3,3,178059.246928),-- [animal_skin]
(21202,1881,1,1,3,53417.806976),-- [coarse_bone_powder]
(21202,1875,1,1,3,26708.903488),-- [stone_of_purity]
(21202,4041,1,1,3,3483.85584),-- [mold_hardener]
(21202,5230,1,1,3,533.928048),-- [rp_mithril_arrow]
(21203,1876,1,3,-1,801503),-- [mithril_ore]
(21203,5478,1,1,-1,67398),-- [sealed_dark_crystal_leather_mail_pattern]
(21203,4042,1,1,-1,133584),-- [enria]
(21203,6362,12,24,0,700000),-- [red_sealstone]
(21203,6361,557,1114,1,700000),-- [green_sealstone]
(21203,5291,1,1,2,66.503325),-- [sealed_dark_crystal_boots]
(21203,5496,1,1,2,6939.746675),-- [sealed_dark_crystal_boots_lining]
(21203,5296,1,1,2,66.503325),-- [sealed_tallum_boots]
(21203,5497,1,1,2,6939.746675),-- [sealed_tallum_boots_lining]
(21203,5290,1,1,2,66.503325),-- [sealed_dark_crystal_gloves]
(21203,5508,1,1,2,6939.746675),-- [sealed_dark_crystal_gloves_design]
(21203,5295,1,1,2,66.503325),-- [sealed_tallum_gloves]
(21203,5509,1,1,2,6939.746675),-- [sealed_tallum_gloves_design]
(21203,1873,1,1,3,135286.501539),-- [silver_nugget]
(21203,1868,4,12,3,84553.906566),-- [thread]
(21203,1876,1,1,3,67643.041575),-- [mithril_ore]
(21203,1895,1,1,3,96633.215385),-- [metallic_fiber]
(21203,4042,1,1,3,5636.954997),-- [enria]
(21203,5156,1,1,3,451.023342),-- [rp_comp_soulshot_a]
(21203,1344,150,450,3,28184.356596),-- [mithril_arrow]
(21204,1807,1,1,-1,10950),-- [rp_soulshot_a]
(21204,5479,1,1,-1,48593),-- [sealed_tallum_leather_mail_pattern]
(21204,3035,1,1,-1,10950),-- [rp_spiritshot_a]
(21204,6362,14,28,0,700000),-- [red_sealstone]
(21204,6361,687,1380,1,700000),-- [green_sealstone]
(21204,5292,1,1,2,108.0996),-- [sealed_dark_crystal_shield]
(21204,5494,1,1,2,10612.704725),-- [sealed_dark_crystal_shield_fragment]
(21204,5289,1,1,2,75.643225),-- [sealed_dark_crystal_helmet]
(21204,5525,1,1,2,7811.46786),-- [sealed_dark_crystal_helmet_design]
(21204,5294,1,1,2,75.643225),-- [sealed_tallum_bonnet]
(21204,5526,1,1,2,7811.441365),-- [sealed_tallum_bonnet_design]
(21204,1894,1,1,3,21278.91699),-- [crafted_leather]
(21204,4039,1,1,3,20215.005036),-- [mold_glue]
(21204,4041,1,1,3,5273.46189),-- [mold_hardener]
(21204,4044,1,1,3,20215.005036),-- [thons]
(21204,3956,1,1,3,808.611048),-- [rp_blessed_spiritshot_a]
(21205,5480,1,1,-1,38649),-- [sealed_leather_mail_of_nightmare_fabric]
(21205,729,1,1,-1,957),-- [scrl_of_ench_wp_a]
(21205,1895,1,5,-1,820300),-- [metallic_fiber]
(21205,6362,14,27,0,700000),-- [red_sealstone]
(21205,6361,700,1400,1,700000),-- [green_sealstone]
(21205,5297,1,1,2,39.689052),-- [sealed_dark_crystal_leather_mail]
(21205,5478,1,1,2,4456.843612),-- [sealed_dark_crystal_leather_mail_pattern]
(21205,5301,1,1,2,24.413844),-- [sealed_tallum_leather_mail]
(21205,5479,1,1,2,3136.141476),-- [sealed_tallum_leather_mail_pattern]
(21205,5298,1,1,2,63.470108),-- [sealed_legging_of_dark_crystal]
(21205,5482,1,1,2,6995.441908),-- [sealed_legging_of_dark_crystal_design]
(21205,1895,1,1,3,181727.779416),-- [metallic_fiber]
(21205,4040,1,1,3,12720.826633),-- [mold_lubricant]
(21205,4042,1,1,3,10600.877845),-- [enria]
(21205,4043,1,1,3,21201.528909),-- [asofe]
(21205,730,1,1,3,529.987197),-- [scrl_of_ench_am_a]
(21206,1875,1,1,-1,559187),-- [stone_of_purity]
(21206,5481,1,1,-1,37638),-- [sealed_majestic_leather_mail_fabric]
(21206,5487,1,1,-1,37771),-- [sealed_robe_of_nightmare_fabric]
(21206,6362,12,24,0,700000),-- [red_sealstone]
(21206,6361,666,1336,1,700000),-- [green_sealstone]
(21206,5287,1,1,2,28.982671),-- [sealed_dark_crystal_breastplate]
(21206,5520,1,1,2,3328.859027),-- [sealed_dark_crystal_breastplate_pattern]
(21206,5293,1,1,2,17.841337),-- [sealed_tallum_plate_armor]
(21206,5521,1,1,2,2348.975444),-- [sealed_tallum_plate_armor_pattern]
(21206,5288,1,1,2,46.378789),-- [sealed_dark_crystal_gaiters]
(21206,5524,1,1,2,5087.962732),-- [sealed_dark_crystal_gaiters_pattern]
(21206,1873,1,1,3,123881.328256),-- [silver_nugget]
(21206,1868,3,9,3,103234.300032),-- [thread]
(21206,1876,1,1,3,61940.664128),-- [mithril_ore]
(21206,1895,1,1,3,88486.66304),-- [metallic_fiber]
(21206,4042,1,1,3,5161.757056),-- [enria]
(21206,5282,1,1,3,137.517888),-- [rp_adv_comp_bspiritshot_s]
(21206,6671,1,1,3,34411.433344),-- [key_of_treasure_box7]
(21206,8732,1,1,3,2580.878528),-- [general_75_s]
(21206,8742,1,1,3,645.114496),-- [special_75_s]
(21206,8752,1,1,3,64.343232),-- [rare_75_s]
(21207,5488,1,1,-1,46584),-- [sealed_majestic_robe_fabric]
(21207,730,1,1,-1,8621),-- [scrl_of_ench_am_a]
(21207,5480,1,1,-1,46420),-- [sealed_leather_mail_of_nightmare_fabric]
(21207,6362,14,28,0,700000),-- [red_sealstone]
(21207,6361,805,1610,1,700000),-- [green_sealstone]
(21207,5315,1,1,2,89.538834),-- [sealed_shield_of_nightmare]
(21207,5495,1,1,2,9665.951834),-- [sealed_shield_of_nightmare_fragment]
(21207,5312,1,1,2,62.654592),-- [sealed_helm_of_nightmare]
(21207,5527,1,1,2,7610.600074),-- [sealed_helm_of_nightmare_design]
(21207,5317,1,1,2,62.654592),-- [sealed_magestic_circlet]
(21207,5528,1,1,2,7610.600074),-- [sealed_magestic_circlet_design]
(21207,1871,4,12,3,79576.53054),-- [charcoal]
(21207,1866,1,3,3,141469.358199),-- [suede]
(21207,1877,1,1,3,25464.436803),-- [admantite_nugget]
(21207,4041,1,1,3,5535.873798),-- [mold_hardener]
(21207,4040,1,1,3,12732.350826),-- [mold_lubricant]
(21207,729,1,1,3,70.449834),-- [scrl_of_ench_wp_a]
(21208,1871,1,1,-1,790380),-- [charcoal]
(21208,734,1,1,-1,131730),-- [quick_step_potion]
(21208,1897,1,1,-1,188186),-- [necklace_of_wisdom_chain]
(21208,57,365,635,0,700000),-- [adena]
(21208,38,1,1,1,5974.79886),-- [low_boots]
(21208,50,1,1,1,5974.79886),-- [leather_gloves]
(21208,1925,1,1,1,102062.40228),-- [leather_gloves_lining]
(21208,1871,1,1,2,155643.947885),-- [charcoal]
(21208,1866,1,1,2,103762.441692),-- [suede]
(21208,734,1,1,2,25940.610423),-- [quick_step_potion]
(21209,1804,1,1,-1,36013),-- [rp_soulshot_d]
(21209,1898,1,1,-1,92484),-- [blue_diamond_necklace_gem]
(21209,2151,1,1,-1,250789),-- [rp_necklace_of_devotion]
(21209,57,409,734,0,700000),-- [adena]
(21209,625,1,1,1,5372.435016),-- [bone_shield]
(21209,1148,1,1,1,3745.564984),-- [hard_leather_helmet]
(21209,1870,1,1,2,177296.591934),-- [coal]
(21209,1865,1,1,2,177296.591934),-- [varnish]
(21209,734,1,1,2,29549.816132),-- [quick_step_potion]
(21210,1899,1,1,-1,171864),-- [necklace_of_devotion_chain]
(21210,1866,1,1,-1,733287),-- [suede]
(21210,1877,1,1,-1,43997),-- [admantite_nugget]
(21210,57,484,907,0,700000),-- [adena]
(21210,123,1,1,1,97.988852),-- [saber]
(21210,2017,1,1,1,2050.881418),-- [saber_blade]
(21210,5285,1,1,1,97.988852),-- [heavy_sword]
(21210,5531,1,1,1,2591.140878),-- [heavy_sword_edge]
(21210,1871,1,1,2,154328.462934),-- [charcoal]
(21210,1866,1,1,2,102885.641956),-- [suede]
(21210,1877,1,1,2,6173.070858),-- [admantite_nugget]
(21210,2182,1,1,2,18526.824252),-- [rp_scale_gaiters]
(21211,1931,1,1,-1,150011),-- [leather_boots_lining]
(21211,2152,1,1,-1,202039),-- [rp_enchanted_necklace]
(21211,1932,1,1,-1,182156),-- [bone_helmet_design]
(21211,57,495,955,0,700000),-- [adena]
(21211,156,1,1,1,136.333197),-- [hand_axe]
(21211,167,1,1,1,136.333197),-- [scalpel]
(21211,178,1,1,1,136.333606),-- [bone_staff]
(21211,1872,1,1,2,171749.16103),-- [animal_bone]
(21211,1867,1,1,2,171749.16103),-- [animal_skin]
(21211,1881,1,1,2,17174.80438),-- [coarse_bone_powder]
(21211,1875,1,1,2,8587.40219),-- [stone_of_purity]
(21211,5437,1,1,2,3149.47137),-- [rp_heavy_sword]
(21213,2153,1,1,-1,230897),-- [rp_tiger'seye_earing]
(21213,1900,1,1,-1,162437),-- [enchanted_necklace_chain]
(21213,57,626,1255,0,700000),-- [adena]
(21213,275,1,1,1,109.163865),-- [long_bow]
(21213,276,1,1,1,109.163865),-- [elven_bow]
(21213,2024,1,1,1,3852.67227),-- [elven_bow_shaft]
(21213,1864,3,9,2,54087.7134),-- [stem]
(21213,1869,1,1,2,162262.66075),-- [iron_ore]
(21213,1878,1,1,2,64905.0643),-- [braided_hemp]
(21213,1884,1,1,2,99854.0926),-- [cord]
(21213,1061,1,1,2,98340.46895),-- [healing_potion]
(21214,1875,1,1,-1,123331),-- [stone_of_purity]
(21214,1865,1,3,-1,924982),-- [varnish]
(21214,1901,1,1,-1,255520),-- [tiger'seye_earing_stone]
(21214,57,781,1559,0,700000),-- [adena]
(21214,223,1,1,1,52.91724),-- [kukuri]
(21214,238,1,1,1,52.91724),-- [dagger_of_mana]
(21214,239,1,1,1,52.91724),-- [mystic_knife]
(21214,241,1,1,1,52.91724),-- [knife_o'_silenus]
(21214,2028,1,1,1,2337.33104),-- [knife_o'_silenus_edge]
(21214,1865,1,1,2,196722.357194),-- [varnish]
(21214,1870,1,1,2,196722.357194),-- [coal]
(21214,1879,1,1,2,32786.910156),-- [cokes]
(21214,1875,1,1,2,13114.943314),-- [stone_of_purity]
(21214,2189,1,1,2,8782.432142),-- [rp_mithril_tunic]
(21215,1825,1,1,-1,139345),-- [rp_oriharukon]
(21215,1902,1,1,-1,197653),-- [elven_earing_beads]
(21215,2145,1,1,-1,139345),-- [rp_mithirl_alloy]
(21215,57,824,1645,0,700000),-- [adena]
(21215,318,1,1,1,93.890762),-- [crucifix_of_blood]
(21215,2042,1,1,1,4659.109238),-- [crucifix_of_blood_piece]
(21215,1866,1,1,2,112047.747354),-- [suede]
(21215,1871,1,1,2,168071.458602),-- [charcoal]
(21215,5220,1,1,2,6722.93631),-- [reinforcing_agent]
(21215,1885,1,1,2,14005.927812),-- [high_grade_suede]
(21215,1825,1,1,2,12005.12739),-- [rp_oriharukon]
(21215,5473,1,1,2,12004.802532),-- [rp_reinforcing_plate]
(21217,1905,1,1,-1,246339),-- [onyxbeast'seye_earing_gemstone]
(21217,1889,1,1,-1,168824),-- [compound_braid]
(21217,1868,1,11,-1,844121),-- [thread]
(21217,57,1020,2061,0,700000),-- [adena]
(21217,396,1,1,1,346.880611),-- [slamander_skin_mail]
(21217,1952,1,1,1,20366.119389),-- [slamander_skin_mail_texture]
(21217,1868,1,3,2,211938.94854),-- [thread]
(21217,1873,1,1,2,84775.72719),-- [silver_nugget]
(21217,5549,1,1,2,21193.74708),-- [iron_thread]
(21217,1889,1,1,2,14129.41101),-- [compound_braid]
(21217,2161,1,1,2,20576.79063),-- [rp_aquastone_ring]
(21217,2993,1,1,2,16820.37555),-- [rp_dwarven_chain_boots]
(21218,1908,1,1,-1,292039),-- [moonstone_earing_wire]
(21218,2163,1,1,-1,157343),-- [rp_earing_of_protection]
(21218,1909,1,1,-1,416466),-- [aquastone_ring_wire]
(21218,57,1220,2478,0,700000),-- [adena]
(21218,354,1,1,1,187.534332),-- [chain_mail_shirt]
(21218,1959,1,1,1,9814.437954),-- [chain_mail_shirt_material]
(21218,381,1,1,1,300.006504),-- [chain_gaiters]
(21218,1960,1,1,1,19965.02121),-- [chain_gaiters_part]
(21218,1869,1,1,2,145751.293329),-- [iron_ore]
(21218,1864,1,1,2,291503.055015),-- [stem]
(21218,1880,1,1,2,14575.26984),-- [steel]
(21218,5550,1,1,2,1943.213193),-- [reinforcing_plate]
(21218,4043,1,1,2,4858.267161),-- [asofe]
(21218,2213,1,1,2,2263.101024),-- [rp_dwarven_chain_mail_shirt]
(21218,8723,1,1,2,5830.107936),-- [general_46_c]
(21218,8733,1,1,2,1457.526984),-- [special_46_c]
(21218,8743,1,1,2,145.659027),-- [rare_46_c]
(21218,8753,1,1,2,29.506491),-- [unique_46_c]
(21219,1911,1,1,-1,237145),-- [earing_of_protection_gemstone]
(21219,2166,1,1,-1,108082),-- [rp_earing_of_binding]
(21219,1912,1,1,-1,343579),-- [ring_of_protection_gemstone]
(21219,57,1258,2567,0,700000),-- [adena]
(21219,440,1,1,1,233.926298),-- [robe_of_seal]
(21219,1970,1,1,1,15773.073702),-- [robe_of_seal_fabric]
(21219,1871,1,1,2,235452.62048),-- [charcoal]
(21219,1866,1,1,2,156968.686336),-- [suede]
(21219,1877,1,1,2,9418.186624),-- [admantite_nugget]
(21219,4041,1,1,2,2047.574144),-- [mold_hardener]
(21219,4040,1,1,2,4709.093312),-- [mold_lubricant]
(21219,951,1,1,2,427.839104),-- [scrl_of_ench_wp_c]
(21221,1872,1,11,-1,871890),-- [animal_bone]
(21221,1867,1,11,-1,871890),-- [animal_skin]
(21221,4605,1,1,-1,8719),-- [dye_d3s3_c]
(21221,57,1558,3150,0,700000),-- [adena]
(21221,64,1,1,1,429.6901),-- [composite_boots]
(21221,2956,1,1,1,23860.3099),-- [composite_boots_part]
(21221,608,1,1,1,429.6901),-- [mithril_gauntlet]
(21221,1981,1,1,1,23860.3099),-- [mithril_gauntlet_design]
(21221,1872,2,6,2,38631.479279),-- [animal_bone]
(21221,1867,1,1,2,154525.917116),-- [animal_skin]
(21221,1881,1,1,2,15452.508349),-- [coarse_bone_powder]
(21221,1875,1,1,2,7726.462581),-- [stone_of_purity]
(21221,4041,1,1,2,1007.853834),-- [mold_hardener]
(21221,2234,1,1,2,1727.273072),-- [rp_divine_hose]
(21221,6037,1,3,2,115894.437837),-- [scroll_of_awake]
(21221,3955,1,1,2,231.748028),-- [rp_blessed_spiritshot_b]
(21221,5280,1,1,2,231.748028),-- [rp_adv_comp_bspiritshot_b]
(21221,8725,1,1,2,3219.463612),-- [general_52_c]
(21221,8735,1,1,2,804.865903),-- [special_52_c]
(21221,8745,1,1,2,80.444909),-- [rare_52_c]
(21221,8755,1,1,2,16.255707),-- [unique_52_c]
(21221,1342,30,90,2,77262.541745),-- [fine_steel_arrow]
(21222,1806,1,1,-1,9299),-- [rp_soulshot_b]
(21222,1920,1,1,-1,159086),-- [necklace_of_binding_chain]
(21222,4126,1,1,-1,76721),-- [rp_adamantite_earing]
(21222,57,1837,3743,0,700000),-- [adena]
(21222,2497,1,1,1,297.204255),-- [full_plate_shield]
(21222,2966,1,1,1,23484.417705),-- [full_plate_shield_fragment]
(21222,2414,1,1,1,208.039095),-- [full_plate_helmet]
(21222,2959,1,1,1,14845.338945),-- [full_plate_helmet_design]
(21222,1873,1,1,2,57221.847612),-- [silver_nugget]
(21222,1868,1,1,2,286108.815933),-- [thread]
(21222,1876,1,1,2,28610.923806),-- [mithril_ore]
(21222,1895,1,1,2,40872.868902),-- [metallic_fiber]
(21222,4042,1,1,2,2384.173296),-- [enria]
(21222,4126,1,1,2,2360.534184),-- [rp_adamantite_earing]
(21222,4965,1,1,2,164.62953),-- [rp_sprite's_staff_i]
(21222,4183,1,1,2,164.62953),-- [rp_heavy_war_axe]
(21222,8726,1,1,2,3311.586315),-- [general_55_c]
(21222,8736,1,1,2,827.791047),-- [special_55_c]
(21222,8746,1,1,2,82.736892),-- [rare_55_c]
(21222,8756,1,1,2,16.462953),-- [unique_55_c]
(21223,4129,1,1,-1,51501),-- [rp_earing_of_black_ore]
(21223,4049,1,1,-1,249606),-- [adamantite_earing_gemstone]
(21223,4603,1,1,-1,10575),-- [dye_c3s3_c]
(21223,57,1877,3833,0,700000),-- [adena]
(21223,78,1,1,1,7.013753),-- [great_sword]
(21223,4104,1,1,1,1340.499041),-- [great_sword_blade]
(21223,142,1,1,1,7.013753),-- [kshanberk]
(21223,4107,1,1,1,1319.72985),-- [kshanberk_blade]
(21223,148,1,1,1,7.013753),-- [sword_of_valhalla]
(21223,4108,1,1,1,1319.72985),-- [sword_of_valhalla_blade]
(21223,1873,1,1,2,51114.767046),-- [silver_nugget]
(21223,1868,1,1,2,255573.082474),-- [thread]
(21223,1876,1,1,2,25557.195334),-- [mithril_ore]
(21223,1895,1,1,2,36510.54789),-- [metallic_fiber]
(21223,4042,1,1,2,2129.923102),-- [enria]
(21223,4130,1,1,2,2074.595536),-- [rp_ring_of_black_ore]
(21223,4182,1,1,2,147.163798),-- [rp_great_sword]
(21223,8727,1,1,2,2555.60662),-- [general_58_b]
(21223,8737,1,1,2,639.089844),-- [special_58_b]
(21223,8747,1,1,2,63.98426),-- [rare_58_b]
(21223,8757,1,1,2,12.044096),-- [unique_58_b]
(21224,1894,1,1,-1,182410),-- [crafted_leather]
(21224,4039,1,1,-1,173289),-- [mold_glue]
(21224,4613,1,1,-1,7171),-- [dye_s4c4_c]
(21224,57,2056,4180,0,700000),-- [adena]
(21224,91,1,1,1,11.49312),-- [heavy_war_axe]
(21224,4105,1,1,1,2196.5262),-- [heavy_war_axe_head]
(21224,92,1,1,1,11.49312),-- [sprite's_staff]
(21224,4106,1,1,1,2160.48756),-- [sprite's_staff_head]
(21224,1894,1,1,2,5388.115096),-- [crafted_leather]
(21224,4039,1,1,2,5118.901294),-- [mold_glue]
(21224,4041,1,1,2,1335.271665),-- [mold_hardener]
(21224,4044,1,1,2,5118.901294),-- [thons]
(21224,4158,1,1,2,326.079819),-- [rp_doom_plate_armor]
(21224,8728,1,1,2,2559.450647),-- [general_61_b]
(21224,8738,1,1,2,639.922647),-- [special_61_b]
(21224,8748,1,1,2,64.064247),-- [rare_61_b]
(21224,8758,1,1,2,12.716873),-- [unique_61_b]
(21224,1343,10,30,2,219377.576418),-- [silver_arrow]
(21225,4052,1,1,-1,201435),-- [earing_of_black_ore_piece]
(21225,5230,1,1,-1,7586),-- [rp_mithril_arrow]
(21225,4053,1,1,-1,243872),-- [ring_of_black_ore_gemstone]
(21225,57,2256,4571,0,700000),-- [adena]
(21225,2391,1,1,1,27.853632),-- [blue_wolve's_leather_mail]
(21225,4082,1,1,1,4748.146368),-- [blue_wolve's_leather_mail_texture]
(21225,2392,1,1,1,27.853632),-- [leather_mail_of_doom]
(21225,4083,1,1,1,4748.146368),-- [leather_mail_of_doom_design]
(21225,1871,1,3,2,140050.167295),-- [charcoal]
(21225,1866,1,1,2,186733.403705),-- [suede]
(21225,1877,1,1,2,11203.811835),-- [admantite_nugget]
(21225,4041,1,1,2,2435.531605),-- [mold_hardener]
(21225,4040,1,1,2,5602.13495),-- [mold_lubricant]
(21225,1830,1,1,2,112039.95061),-- [scroll_of_escape_to_castle]
(21226,5230,1,1,-1,8862),-- [rp_mithril_arrow]
(21226,4054,1,1,-1,130913),-- [necklace_of_black_ore_beads]
(21226,4052,1,1,-1,235314),-- [earing_of_black_ore_piece]
(21226,57,2634,5340,0,700000),-- [adena]
(21226,79,1,1,1,6.485445),-- [sword_of_damascus]
(21226,4114,1,1,1,1432.64904),-- [sword_of_damascus_blade]
(21226,7883,1,1,1,6.485445),-- [guardians_sword]
(21226,8330,1,1,1,1430.24127),-- [guardians_sword_blade]
(21226,7889,1,1,1,6.485445),-- [tears_of_wizard]
(21226,8336,1,1,1,1432.653355),-- [tears_of_wizard_blade]
(21226,1867,1,3,2,118985.367),-- [animal_skin]
(21226,1872,1,1,2,237970.324764),-- [animal_bone]
(21226,1882,1,1,2,39661.925412),-- [leather]
(21226,1894,1,1,2,6262.538508),-- [crafted_leather]
(21226,4042,1,1,2,2974.736484),-- [enria]
(21226,5230,1,1,2,237.766116),-- [rp_mithril_arrow]
(21226,8314,1,1,2,97.398168),-- [rp_eye_of_soul_i]
(21226,8729,1,1,2,2379.70734),-- [general_64_a]
(21226,8739,1,1,2,595.029144),-- [special_64_a]
(21226,8749,1,1,2,59.33922),-- [rare_64_a]
(21226,8759,1,1,2,11.867844),-- [unique_64_a]
(21227,5549,1,1,-1,712964),-- [iron_thread]
(21227,4077,1,1,-1,320722),-- [doom_shield_fragment]
(21227,5230,1,1,-1,9506),-- [rp_mithril_arrow]
(21227,57,2811,5744,0,700000),-- [adena]
(21227,287,1,1,1,20.86971),-- [hazard_bow]
(21227,4121,1,1,1,4586.13029),-- [hazard_bow_shaft]
(21227,1868,1,3,2,191453.316384),-- [thread]
(21227,1873,1,1,2,76581.264672),-- [silver_nugget]
(21227,5549,1,1,2,19145.238816),-- [iron_thread]
(21227,1889,1,1,2,12763.698816),-- [compound_braid]
(21227,4044,1,1,2,6381.849408),-- [thons]
(21227,5230,1,1,2,255.2616),-- [rp_mithril_arrow]
(21227,8314,1,1,2,104.579904),-- [rp_eye_of_soul_i]
(21227,8730,1,1,2,2127.18),-- [general_67_a]
(21227,8740,1,1,2,531.872352),-- [special_67_a]
(21227,8750,1,1,2,53.218176),-- [rare_67_a]
(21227,8760,1,1,2,10.519872),-- [unique_67_a]
(21228,1807,1,1,-1,9693),-- [rp_soulshot_a]
(21228,5478,1,1,-1,61132),-- [sealed_dark_crystal_leather_mail_pattern]
(21228,3035,1,1,-1,9693),-- [rp_spiritshot_a]
(21228,57,2875,5849,0,700000),-- [adena]
(21228,5287,1,1,1,20.094901),-- [sealed_dark_crystal_breastplate]
(21228,5520,1,1,1,2308.037537),-- [sealed_dark_crystal_breastplate_pattern]
(21228,5293,1,1,1,12.370147),-- [sealed_tallum_plate_armor]
(21228,5521,1,1,1,1628.643164),-- [sealed_tallum_plate_armor_pattern]
(21228,5288,1,1,1,32.156359),-- [sealed_dark_crystal_gaiters]
(21228,5524,1,1,1,3527.697892),-- [sealed_dark_crystal_gaiters_pattern]
(21228,1866,1,1,2,143158.763529),-- [suede]
(21228,1871,1,1,2,214738.340088),-- [charcoal]
(21228,5220,1,1,2,8589.658272),-- [reinforcing_agent]
(21228,1885,1,1,2,17894.991537),-- [high_grade_suede]
(21228,4041,1,1,2,1867.300077),-- [mold_hardener]
(21228,5271,1,1,2,286.347915),-- [rp_adv_comp_soulshot_a]
(21228,8730,1,1,2,2385.843036),-- [general_67_a]
(21228,8740,1,1,2,596.460759),-- [special_67_a]
(21228,8750,1,1,2,59.607117),-- [rare_67_a]
(21228,8760,1,1,2,11.68767),-- [unique_67_a]
(21229,5479,1,1,-1,37315),-- [sealed_tallum_leather_mail_pattern]
(21229,4041,1,1,-1,54837),-- [mold_hardener]
(21229,4044,1,1,-1,210209),-- [thons]
(21229,57,3110,6350,0,700000),-- [adena]
(21229,6324,1,1,1,77.229401),-- [sealed_phoenix's_earing]
(21229,6341,1,1,1,10733.28277),-- [sealed_phoenix's_earing_gemstone]
(21229,6323,1,1,1,57.913519),-- [sealed_phoenix's_necklace]
(21229,6343,1,1,1,8297.229256),-- [sealed_phoenix's_necklace_beads]
(21229,6325,1,1,1,115.827038),-- [sealed_phoenix's_ring]
(21229,6345,1,1,1,14845.518016),-- [sealed_phoenix's_ring_gemstone]
(21229,1894,1,1,2,9077.747721),-- [crafted_leather]
(21229,4039,1,1,2,8623.849185),-- [mold_glue]
(21229,4041,1,1,2,2249.709483),-- [mold_hardener]
(21229,4044,1,1,2,8623.849185),-- [thons]
(21229,730,1,1,2,215.608176),-- [scrl_of_ench_am_a]
(21229,8731,1,1,2,2395.518972),-- [general_70_a]
(21229,8741,1,1,2,598.879743),-- [special_70_a]
(21229,8751,1,1,2,59.89116),-- [rare_70_a]
(21229,8761,1,1,2,11.946375),-- [unique_70_a]
(21230,5480,1,1,-1,32628),-- [sealed_leather_mail_of_nightmare_fabric]
(21230,5481,1,1,-1,32628),-- [sealed_majestic_leather_mail_fabric]
(21230,5487,1,1,-1,32744),-- [sealed_robe_of_nightmare_fabric]
(21230,57,3587,7319,0,700000),-- [adena]
(21230,5292,1,1,1,95.7168),-- [sealed_dark_crystal_shield]
(21230,5494,1,1,1,9397.0203),-- [sealed_dark_crystal_shield_fragment]
(21230,5289,1,1,1,66.9783),-- [sealed_dark_crystal_helmet]
(21230,5525,1,1,1,6916.66488),-- [sealed_dark_crystal_helmet_design]
(21230,5294,1,1,1,66.9783),-- [sealed_tallum_bonnet]
(21230,5526,1,1,1,6916.64142),-- [sealed_tallum_bonnet_design]
(21230,1895,1,1,2,85232.828844),-- [metallic_fiber]
(21230,4040,1,1,2,5966.306811),-- [mold_lubricant]
(21230,4042,1,1,2,4971.940659),-- [enria]
(21230,4043,1,1,2,9943.771419),-- [asofe]
(21230,730,1,1,2,248.591538),-- [scrl_of_ench_am_a]
(21230,8731,1,1,2,2762.201466),-- [general_70_a]
(21230,8741,1,1,2,690.495417),-- [special_70_a]
(21230,8751,1,1,2,69.016572),-- [rare_70_a]
(21230,8761,1,1,2,13.847274),-- [unique_70_a]
(21231,729,1,1,-1,812),-- [scrl_of_ench_wp_a]
(21231,1875,1,1,-1,487115),-- [stone_of_purity]
(21231,5480,1,1,-1,32787),-- [sealed_leather_mail_of_nightmare_fabric]
(21231,57,3602,7359,0,700000),-- [adena]
(21231,5292,1,1,1,96.18192),-- [sealed_dark_crystal_shield]
(21231,5494,1,1,1,9442.68357),-- [sealed_dark_crystal_shield_fragment]
(21231,5289,1,1,1,67.30377),-- [sealed_dark_crystal_helmet]
(21231,5525,1,1,1,6950.275272),-- [sealed_dark_crystal_helmet_design]
(21231,5294,1,1,1,67.30377),-- [sealed_tallum_bonnet]
(21231,5526,1,1,1,6950.251698),-- [sealed_tallum_bonnet_design]
(21231,1872,1,3,2,199842.391552),-- [animal_bone]
(21231,1867,1,3,2,133227.995136),-- [animal_skin]
(21231,1881,1,1,2,39968.55808),-- [coarse_bone_powder]
(21231,1875,1,1,2,19984.27904),-- [stone_of_purity]
(21231,4041,1,1,2,2606.47168),-- [mold_hardener]
(21231,729,1,1,2,33.503232),-- [scrl_of_ench_wp_a]
(21231,8732,1,1,2,2497.985024),-- [general_75_s]
(21231,8742,1,1,2,624.595968),-- [special_75_s]
(21231,8752,1,1,2,62.220288),-- [rare_75_s]
(21236,1061,1,1,-1,784398),-- [healing_potion]
(21236,1900,1,1,-1,141604),-- [enchanted_necklace_chain]
(21236,2153,1,1,-1,201284),-- [rp_tiger'seye_earing]
(21236,57,546,1092,0,700000),-- [adena]
(21236,69,1,1,1,57.082802),-- [bastard_sword]
(21236,125,1,1,1,57.082802),-- [spinebone_sword]
(21236,2021,1,1,1,1785.664764),-- [spinebone_sword_blade]
(21236,126,1,1,1,57.082802),-- [artisan's_sword]
(21236,128,1,1,1,57.08683),-- [knight's_sword]
(21236,1867,1,3,2,117877.019123),-- [animal_skin]
(21236,1872,1,1,2,235754.449743),-- [animal_bone]
(21236,1882,1,1,2,39292.202542),-- [leather]
(21236,2184,1,1,2,18573.328592),-- [rp_mithril_banded_gaiters]
(21237,1933,1,1,-1,174667),-- [dark_hose_fabric]
(21237,2183,1,1,-1,97676),-- [rp_mithril_banded_mail]
(21237,1935,1,1,-1,82942),-- [scale_mail_fragment]
(21237,57,626,1255,0,700000),-- [adena]
(21237,86,1,1,1,32.746078),-- [tomahawk]
(21237,179,1,1,1,32.746078),-- [mace_of_prayer]
(21237,180,1,1,1,32.746078),-- [mace_of_judgment]
(21237,2022,1,1,1,1263.70299),-- [mace_of_judgment_head]
(21237,181,1,1,1,32.746078),-- [mace_of_miracle]
(21237,182,1,1,1,32.746078),-- [doom_hammer]
(21237,183,1,1,1,32.746078),-- [mystic_staff]
(21237,184,1,1,1,32.746078),-- [conjure_staff]
(21237,2023,1,1,1,1005.325855),-- [conjure_staff_head]
(21237,185,1,1,1,32.748609),-- [staff_of_mana]
(21237,1868,1,3,2,135219.311403),-- [thread]
(21237,1873,1,1,2,54087.627825),-- [silver_nugget]
(21237,5549,1,1,2,13521.786036),-- [iron_thread]
(21237,1889,1,1,2,9014.846478),-- [compound_braid]
(21237,2265,1,1,2,1398.321771),-- [rp_spike_club]
(21237,6037,1,1,2,270439.106487),-- [scroll_of_awake]
(21238,1878,1,1,-1,739986),-- [braided_hemp]
(21238,1884,1,3,-1,569220),-- [cord]
(21238,1901,1,1,-1,255520),-- [tiger'seye_earing_stone]
(21238,57,781,1559,0,700000),-- [adena]
(21238,260,1,1,1,265),-- [triple-edged_jamadhr]
(21238,1874,1,1,2,9367.725836),-- [oriharukon_ore]
(21238,1878,1,1,2,56205.943754),-- [braided_hemp]
(21238,1884,1,1,2,86471.125596),-- [cord]
(21238,1889,1,1,2,9367.725836),-- [compound_braid]
(21238,5220,1,1,2,5620.717754),-- [reinforcing_agent]
(21238,2190,1,1,2,10036.84911),-- [rp_mithril_hose]
(21238,1341,20,60,2,234191.912114),-- [bone_arrow]
(21239,1825,1,1,-1,139345),-- [rp_oriharukon]
(21239,1902,1,1,-1,197653),-- [elven_earing_beads]
(21239,2145,1,1,-1,139345),-- [rp_mithirl_alloy]
(21239,57,824,1645,0,700000),-- [adena]
(21239,279,1,1,1,93.89952),-- [strengthening_long_bow]
(21239,2040,1,1,1,5834.10048),-- [strengthening_long_bow_shaft]
(21239,1870,1,1,2,168071.726056),-- [coal]
(21239,1865,1,1,2,168071.726056),-- [varnish]
(21239,1874,1,1,2,11204.756261),-- [oriharukon_ore]
(21239,2145,1,1,2,12004.959515),-- [rp_mithirl_alloy]
(21239,2208,1,1,2,17185.262911),-- [rp_ogre_power_gauntlet]
(21239,6036,1,1,2,5602.569201),-- [potion_of_acumen3]
(21240,1903,1,1,-1,372617),-- [elven_ring_piece]
(21240,1871,1,5,-1,744614),-- [charcoal]
(21240,1866,1,3,-1,744614),-- [suede]
(21240,57,932,1861,0,700000),-- [adena]
(21240,224,1,1,1,53.76128),-- [maingauche]
(21240,2038,1,1,1,3050.23872),-- [maingauche_edge]
(21240,1660,1,1,1,53.76128),-- [cursed_maingauche]
(21240,2044,1,1,1,3050.23872),-- [cursed_maingauche_edge]
(21240,1871,2,6,2,72170.28068),-- [charcoal]
(21240,1866,1,1,2,192453.499748),-- [suede]
(21240,1877,1,1,2,11547.157599),-- [admantite_nugget]
(21240,1341,60,180,2,160378.061973),-- [bone_arrow]
(21241,4469,1,1,-1,14471),-- [dye_s1c1_d]
(21241,1905,1,1,-1,246339),-- [onyxbeast'seye_earing_gemstone]
(21241,1805,1,1,-1,8441),-- [rp_soulshot_c]
(21241,57,1020,2061,0,700000),-- [adena]
(21241,396,1,1,1,346.880611),-- [slamander_skin_mail]
(21241,1952,1,1,1,20366.119389),-- [slamander_skin_mail_texture]
(21241,1872,1,3,2,121108.069957),-- [animal_bone]
(21241,1867,1,1,2,242215.712271),-- [animal_skin]
(21241,1881,1,1,2,24221.69952),-- [coarse_bone_powder]
(21241,1875,1,1,2,12110.84976),-- [stone_of_purity]
(21241,2162,1,1,2,8776.089646),-- [rp_aquastone_necklace]
(21241,2990,1,1,2,14417.556102),-- [rp_chain_boots]
(21241,2206,1,1,2,4793.022744),-- [rp_tempered_mithril_shirt]
(21242,1908,1,1,-1,292039),-- [moonstone_earing_wire]
(21242,2163,1,1,-1,157343),-- [rp_earing_of_protection]
(21242,1909,1,1,-1,416466),-- [aquastone_ring_wire]
(21242,57,1220,2478,0,700000),-- [adena]
(21242,96,1,1,1,27.557894),-- [scythe]
(21242,2062,1,1,1,1905.10684),-- [scythe_edge]
(21242,298,1,1,1,27.557894),-- [orcish_glaive]
(21242,2075,1,1,1,1905.10684),-- [orcish_glaive_blade]
(21242,302,1,1,1,27.557894),-- [body_slasher]
(21242,2076,1,1,1,1905.112638),-- [body_slasher_blade]
(21242,1873,1,1,2,58300.467003),-- [silver_nugget]
(21242,1868,1,1,2,291501.466809),-- [thread]
(21242,1876,1,1,2,29150.01645),-- [mithril_ore]
(21242,1895,1,1,2,41643.066687),-- [metallic_fiber]
(21242,4042,1,1,2,2429.240388),-- [enria]
(21242,2214,1,1,2,3616.512093),-- [rp_dwarven_chain_gaiters]
(21242,8723,1,1,2,5830.00329),-- [general_46_c]
(21242,8733,1,1,2,1457.717874),-- [special_46_c]
(21242,8743,1,1,2,145.858608),-- [rare_46_c]
(21242,8753,1,1,2,28.650798),-- [unique_46_c]
(21243,951,1,1,-1,5797),-- [scrl_of_ench_wp_c]
(21243,2166,1,1,-1,108082),-- [rp_earing_of_binding]
(21243,1911,1,1,-1,237145),-- [earing_of_protection_gemstone]
(21243,57,1258,2567,0,700000),-- [adena]
(21243,398,1,1,1,102.96804),-- [plate_leather]
(21243,1966,1,1,1,6446.93235),-- [plate_leather_fragment]
(21243,399,1,1,1,94.95058),-- [rind_leather_mail]
(21243,1975,1,1,1,5800.00284),-- [rind_leather_mail_design]
(21243,418,1,1,1,164.6561),-- [plate_leather_gaiters]
(21243,1967,1,1,1,9630.82474),-- [plate_leather_gaiters_material]
(21243,419,1,1,1,152.03357),-- [rind_leather_gaiters]
(21243,1976,1,1,1,10737.63178),-- [rind_leather_gaiters_material]
(21243,1873,1,1,2,56508.534733),-- [silver_nugget]
(21243,1868,1,1,2,282543.506283),-- [thread]
(21243,1876,1,1,2,28254.475521),-- [mithril_ore]
(21243,1895,1,1,2,40363.239095),-- [metallic_fiber]
(21243,4042,1,1,2,2354.643704),-- [enria]
(21243,951,1,1,2,256.862653),-- [scrl_of_ench_wp_c]
(21243,8724,1,1,2,4708.871099),-- [general_49_c]
(21243,8734,1,1,2,1177.321852),-- [special_49_c]
(21243,8744,1,1,2,117.815447),-- [rare_49_c]
(21243,8754,1,1,2,23.729613),-- [unique_49_c]
(21244,4601,1,1,-1,7887),-- [dye_s3c3_c]
(21244,1539,1,1,-1,788726),-- [greater_healing_potion]
(21244,1914,1,1,-1,199397),-- [earing_of_binding_gemstone]
(21244,57,1404,2854,0,700000),-- [adena]
(21244,60,1,1,1,119.616525),-- [composite_armor]
(21244,1977,1,1,1,10855.383475),-- [composite_armor_temper]
(21244,1865,1,1,2,133432.516646),-- [varnish]
(21244,1870,1,1,2,133432.516646),-- [coal]
(21244,1879,1,1,2,22238.648344),-- [cokes]
(21244,1875,1,1,2,8895.584654),-- [stone_of_purity]
(21244,4040,1,1,2,2668.612738),-- [mold_lubricant]
(21244,2170,1,1,2,3147.008095),-- [rp_nassen's_earing]
(21244,2970,1,1,2,4731.633973),-- [rp_ring_of_binding]
(21244,8725,1,1,2,3706.545821),-- [general_52_c]
(21244,8735,1,1,2,926.714778),-- [special_52_c]
(21244,8745,1,1,2,92.734136),-- [rare_52_c]
(21244,8755,1,1,2,18.484169),-- [unique_52_c]
(21245,2169,1,1,-1,69443),-- [rp_necklace_of_binding]
(21245,1915,1,1,-1,345683),-- [ring_of_ages_gemstone]
(21245,2170,1,1,-1,92536),-- [rp_nassen's_earing]
(21245,57,1558,3150,0,700000),-- [adena]
(21245,60,1,1,1,132.237567),-- [composite_armor]
(21245,1977,1,1,1,12000.762433),-- [composite_armor_temper]
(21245,1871,1,1,2,135209.754141),-- [charcoal]
(21245,1866,1,1,2,90139.836094),-- [suede]
(21245,1877,1,1,2,5408.282),-- [admantite_nugget]
(21245,4041,1,1,2,1175.809673),-- [mold_hardener]
(21245,4040,1,1,2,2704.141),-- [mold_lubricant]
(21245,2353,1,1,2,220.510407),-- [rp_samurai_longsword]
(21245,4122,1,1,2,6009.338795),-- [rp_maestro_holder]
(21245,8309,1,1,2,155.856854),-- [rp_spell_breaker]
(21245,8725,1,1,2,3755.806018),-- [general_52_c]
(21245,8735,1,1,2,939.07442),-- [special_52_c]
(21245,8745,1,1,2,93.907442),-- [rare_52_c]
(21245,8755,1,1,2,18.683156),-- [unique_52_c]
(21246,1918,1,1,-1,201354),-- [nassen's_earing_gemstone]
(21246,4042,1,1,-1,77488),-- [enria]
(21246,1867,1,13,-1,885576),-- [animal_skin]
(21246,57,1837,3743,0,700000),-- [adena]
(21246,855,1,1,1,175.636134),-- [nassen's_earing]
(21246,1918,1,1,1,12391.556392),-- [nassen's_earing_gemstone]
(21246,119,1,1,1,131.746694),-- [necklace_of_binding]
(21246,1920,1,1,1,9790.284145),-- [necklace_of_binding_chain]
(21246,886,1,1,1,263.454201),-- [ring_of_binding]
(21246,2917,1,1,1,16434.322434),-- [ring_of_binding_gemstone]
(21246,1867,1,1,2,190739.38488),-- [animal_skin]
(21246,1872,1,1,2,190739.38488),-- [animal_bone]
(21246,1882,1,1,2,31789.89748),-- [leather]
(21246,1894,1,1,2,5019.322092),-- [crafted_leather]
(21246,4042,1,1,2,2384.456702),-- [enria]
(21246,4127,1,1,2,3540.881756),-- [rp_adamantite_ring]
(21246,4965,1,1,2,164.652288),-- [rp_sprite's_staff_i]
(21246,4183,1,1,2,164.652288),-- [rp_heavy_war_axe]
(21246,8726,1,1,2,3311.483386),-- [general_55_c]
(21246,8736,1,1,2,827.978042),-- [special_55_c]
(21246,8746,1,1,2,82.754926),-- [rare_55_c]
(21246,8756,1,1,2,17.15128),-- [unique_55_c]
(21247,4613,1,1,-1,6564),-- [dye_s4c4_c]
(21247,4049,1,1,-1,249606),-- [adamantite_earing_gemstone]
(21247,4129,1,1,-1,51501),-- [rp_earing_of_black_ore]
(21247,57,1877,3833,0,700000),-- [adena]
(21247,554,1,1,1,88.050656),-- [shrnoen's_boots]
(21247,4097,1,1,1,9145.449344),-- [shrnoen's_boots_design]
(21247,600,1,1,1,88.050656),-- [avadon_boots]
(21247,4098,1,1,1,9145.449344),-- [avadon_boots_design]
(21247,612,1,1,1,88.050656),-- [shrnoen's_gauntlet]
(21247,4100,1,1,1,9145.449344),-- [shrnoen's_gauntlet_part]
(21247,2464,1,1,1,88.050656),-- [avadon_gloves]
(21247,4073,1,1,1,9145.449344),-- [avadon_gloves_part]
(21247,1872,1,1,2,170382.461206),-- [animal_bone]
(21247,1867,1,1,2,170382.461206),-- [animal_skin]
(21247,1881,1,1,2,17038.171454),-- [coarse_bone_powder]
(21247,1875,1,1,2,8519.085727),-- [stone_of_purity]
(21247,4041,1,1,2,1111.039008),-- [mold_hardener]
(21247,4131,1,1,2,1038.985739),-- [rp_necklace_of_black_ore]
(21247,4173,1,1,2,1589.278581),-- [rp_blue_wolve's_gloves]
(21247,8727,1,1,2,2555.837718),-- [general_58_b]
(21247,8737,1,1,2,638.772763),-- [special_58_b]
(21247,8747,1,1,2,63.839943),-- [rare_58_b]
(21247,8757,1,1,2,13.066655),-- [unique_58_b]
(21248,4050,1,1,-1,322099),-- [adamantite_ring_wire]
(21248,4130,1,1,-1,84394),-- [rp_ring_of_black_ore]
(21248,4051,1,1,-1,201616),-- [adamantite_necklace_chain]
(21248,57,2056,4180,0,700000),-- [adena]
(21248,633,1,1,1,91.624004),-- [shrnoen's_shield]
(21248,4101,1,1,1,11126.113214),-- [shrnoen's_shield_fragment]
(21248,673,1,1,1,91.624004),-- [avadon_shield]
(21248,4439,1,1,1,13236.273544),-- [avadon_shield_fragment]
(21248,503,1,1,1,64.12842),-- [shrnoen's_helmet]
(21248,4102,1,1,1,8620.075154),-- [shrnoen's_helmet_design]
(21248,2415,1,1,1,64.12842),-- [avadon_circlet]
(21248,4072,1,1,1,8620.03324),-- [avadon_circlet_pattern]
(21248,1869,1,1,2,139600.894576),-- [iron_ore]
(21248,1864,1,1,2,279201.341848),-- [stem]
(21248,1880,1,1,2,13959.910536),-- [steel]
(21248,5550,1,1,2,1861.231944),-- [reinforcing_plate]
(21248,4043,1,1,2,4653.303512),-- [asofe]
(21248,4159,1,1,2,395.416736),-- [rp_blue_wolve's_leather_mail]
(21248,8728,1,1,2,2326.875408),-- [general_61_b]
(21248,8738,1,1,2,581.4952),-- [special_61_b]
(21248,8748,1,1,2,58.14952),-- [rare_61_b]
(21248,8758,1,1,2,11.629904),-- [unique_61_b]
(21248,6036,1,1,2,4653.750816),-- [potion_of_acumen3]
(21249,5230,1,1,-1,7586),-- [rp_mithril_arrow]
(21249,4052,1,1,-1,201435),-- [earing_of_black_ore_piece]
(21249,4053,1,1,-1,243872),-- [ring_of_black_ore_gemstone]
(21249,57,2256,4571,0,700000),-- [adena]
(21249,358,1,1,1,22.633608),-- [blue_wolve's_breastplate]
(21249,4078,1,1,1,4091.595561),-- [blue_wolve's_breastplate_part]
(21249,2381,1,1,1,13.930326),-- [doom_plate_armor]
(21249,4081,1,1,1,2760.805383),-- [doom_plate_armor_temper]
(21249,2380,1,1,1,36.208698),-- [blue_wolve's_gaiters]
(21249,4080,1,1,1,5761.826424),-- [blue_wolve's_gaiters_material]
(21249,1871,1,1,2,168059.921611),-- [charcoal]
(21249,1866,1,1,2,112039.849495),-- [suede]
(21249,1877,1,1,2,6722.361496),-- [admantite_nugget]
(21249,4041,1,1,2,1461.306046),-- [mold_hardener]
(21249,4040,1,1,2,3361.180748),-- [mold_lubricant]
(21249,5166,1,1,2,224.00012),-- [rp_comp_bspiritshot_a]
(21249,8729,1,1,2,2240.885411),-- [general_64_a]
(21249,8739,1,1,2,560.295037),-- [special_64_a]
(21249,8749,1,1,2,56.00003),-- [rare_64_a]
(21249,8759,1,1,2,11.200006),-- [unique_64_a]
(21250,4052,1,1,-1,235314),-- [earing_of_black_ore_piece]
(21250,5230,1,1,-1,8862),-- [rp_mithril_arrow]
(21250,4053,1,1,-1,284889),-- [ring_of_black_ore_gemstone]
(21250,57,2634,5340,0,700000),-- [adena]
(21250,171,1,1,1,6.484956),-- [deadman's_glory]
(21250,4116,1,1,1,1429.560294),-- [deadman's_glory_stone]
(21250,175,1,1,1,6.484956),-- [art_of_battle_axe]
(21250,4117,1,1,1,1429.560294),-- [art_of_battle_axe_blade]
(21250,210,1,1,1,6.484956),-- [staff_of_evil_sprit]
(21250,4118,1,1,1,1354.424544),-- [staff_of_evil_sprit_head]
(21250,1871,1,1,2,178478.266995),-- [charcoal]
(21250,1866,1,1,2,118985.51133),-- [suede]
(21250,1877,1,1,2,7139.229822),-- [admantite_nugget]
(21250,4041,1,1,2,1552.071141),-- [mold_hardener]
(21250,4040,1,1,2,3569.614911),-- [mold_lubricant]
(21250,1830,1,1,2,71391.306798),-- [scroll_of_escape_to_castle]
(21250,8729,1,1,2,2379.908511),-- [general_64_a]
(21250,8739,1,1,2,594.8532),-- [special_64_a]
(21250,8749,1,1,2,59.48532),-- [rare_64_a]
(21250,8759,1,1,2,11.897064),-- [unique_64_a]
(21250,1344,20,60,2,111548.854908),-- [mithril_arrow]
(21251,5230,1,1,-1,9506),-- [rp_mithril_arrow]
(21251,4054,1,1,-1,140430),-- [necklace_of_black_ore_beads]
(21251,4053,1,1,-1,305600),-- [ring_of_black_ore_gemstone]
(21251,57,2811,5744,0,700000),-- [adena]
(21251,2398,1,1,1,28.351631),-- [blue_wolve's_tunic]
(21251,4084,1,1,1,4576.460064),-- [blue_wolve's_tunic_fabric]
(21251,2399,1,1,1,28.351631),-- [tunic_of_doom]
(21251,4085,1,1,1,4576.460064),-- [tunic_of_doom_pattern]
(21251,2403,1,1,1,45.397264),-- [blue_wolve's_hose]
(21251,4086,1,1,1,6179.269382),-- [blue_wolve's_hose_pattern]
(21251,2404,1,1,1,45.397264),-- [hose_of_doom]
(21251,4087,1,1,1,6179.3127),-- [hose_of_doom_pattern]
(21251,1866,1,1,2,127635.625799),-- [suede]
(21251,1871,1,3,2,63817.605053),-- [charcoal]
(21251,5220,1,1,2,7658.312139),-- [reinforcing_agent]
(21251,1885,1,1,2,15954.29734),-- [high_grade_suede]
(21251,4041,1,1,2,1664.850465),-- [mold_hardener]
(21251,1830,1,1,2,76581.458618),-- [scroll_of_escape_to_castle]
(21251,8730,1,1,2,2127.101081),-- [general_67_a]
(21251,8740,1,1,2,531.671347),-- [special_67_a]
(21251,8750,1,1,2,53.208704),-- [rare_67_a]
(21251,8760,1,1,2,10.808018),-- [unique_67_a]
(21251,1344,20,60,2,119658.061436),-- [mithril_arrow]
(21252,5478,1,1,-1,61132),-- [sealed_dark_crystal_leather_mail_pattern]
(21252,4053,1,1,-1,311606),-- [ring_of_black_ore_gemstone]
(21252,5230,1,1,-1,9693),-- [rp_mithril_arrow]
(21252,57,2875,5849,0,700000),-- [adena]
(21252,5297,1,1,1,26.797392),-- [sealed_dark_crystal_leather_mail]
(21252,5478,1,1,1,3009.187152),-- [sealed_dark_crystal_leather_mail_pattern]
(21252,5301,1,1,1,16.483824),-- [sealed_tallum_leather_mail]
(21252,5479,1,1,1,2117.470896),-- [sealed_tallum_leather_mail_pattern]
(21252,5298,1,1,1,42.853968),-- [sealed_legging_of_dark_crystal]
(21252,5482,1,1,1,4723.206768),-- [sealed_legging_of_dark_crystal_design]
(21252,10579,1,1,2,11545),-- [sb_improve_combat]
(21252,10583,1,1,2,11545),-- [sb_improve_shield_defence]
(21252,10608,1,1,2,11545),-- [sb_chant_of_combat]
(21252,14214,1,1,2,11545),-- [sb_chant_of_movement1]
(21253,1807,1,1,-1,8408),-- [rp_soulshot_a]
(21253,5479,1,1,-1,37315),-- [sealed_tallum_leather_mail_pattern]
(21253,3035,1,1,-1,8408),-- [rp_spiritshot_a]
(21253,57,3110,6350,0,700000),-- [adena]
(21253,5304,1,1,1,29.057478),-- [sealed_tallum_tunic]
(21253,5485,1,1,1,3262.981318),-- [sealed_tallum_tunic_texture]
(21253,5308,1,1,1,17.874066),-- [sealed_dark_crystal_robe]
(21253,5486,1,1,1,2296.057914),-- [sealed_dark_crystal_robe_fabric]
(21253,5305,1,1,1,46.468262),-- [sealed_tallum_hose]
(21253,5489,1,1,1,5121.560962),-- [sealed_tallum_hose_fabric]
(21253,10580,1,1,2,11642.455968),-- [sb_improve_magic]
(21253,10582,1,1,2,11642.455968),-- [sb_improve_critical]
(21253,10610,1,1,2,11642.455968),-- [sb_chant_of_blood_awakening]
(21253,14215,1,1,2,12064.632096),-- [sb_combat_of_paagrio1]
(21254,5480,1,1,-1,32628),-- [sealed_leather_mail_of_nightmare_fabric]
(21254,729,1,1,-1,808),-- [scrl_of_ench_wp_a]
(21254,1877,1,1,-1,290856),-- [admantite_nugget]
(21254,57,3587,7319,0,700000),-- [adena]
(21254,6324,1,1,1,89.04905),-- [sealed_phoenix's_earing]
(21254,6341,1,1,1,12375.9685),-- [sealed_phoenix's_earing_gemstone]
(21254,6323,1,1,1,66.77695),-- [sealed_phoenix's_necklace]
(21254,6343,1,1,1,9567.0868),-- [sealed_phoenix's_necklace_beads]
(21254,6325,1,1,1,133.5539),-- [sealed_phoenix's_ring]
(21254,6345,1,1,1,17117.5648),-- [sealed_phoenix's_ring_gemstone]
(21254,14216,1,1,2,53696),-- [sb_critical_of_paagrio1]
(21255,4041,1,1,-1,67285),-- [mold_hardener]
(21255,5481,1,1,-1,34721),-- [sealed_majestic_leather_mail_fabric]
(21255,5487,1,1,-1,34844),-- [sealed_robe_of_nightmare_fabric]
(21255,57,3814,7793,0,700000),-- [adena]
(21255,5297,1,1,1,35.65434),-- [sealed_dark_crystal_leather_mail]
(21255,5478,1,1,1,4003.76954),-- [sealed_dark_crystal_leather_mail_pattern]
(21255,5301,1,1,1,21.93198),-- [sealed_tallum_leather_mail]
(21255,5479,1,1,1,2817.32742),-- [sealed_tallum_leather_mail_pattern]
(21255,5298,1,1,1,57.01786),-- [sealed_legging_of_dark_crystal]
(21255,5482,1,1,1,6284.29886),-- [sealed_legging_of_dark_crystal_design]
(21255,1873,1,1,2,114281.750744),-- [silver_nugget]
(21255,1868,3,9,2,95234.662968),-- [thread]
(21255,1876,1,1,2,57140.875372),-- [mithril_ore]
(21255,1895,1,1,2,81629.82196),-- [metallic_fiber]
(21255,4042,1,1,2,4761.771944),-- [enria]
(21255,5282,1,1,2,126.861612),-- [rp_adv_comp_bspiritshot_s]
(21255,6671,1,1,2,31744.887656),-- [key_of_treasure_box7]
(21255,8732,1,1,2,2380.885972),-- [general_75_s]
(21255,8742,1,1,2,595.124504),-- [special_75_s]
(21255,8752,1,1,2,59.357268),-- [rare_75_s]
(21256,1804,1,1,-1,12984),-- [rp_soulshot_d]
(21256,1898,1,1,-1,33344),-- [blue_diamond_necklace_gem]
(21256,1872,1,1,-1,432806),-- [animal_bone]
(21256,57,149,262,0,700000),-- [adena]
(21256,27,1,1,1,337.62267),-- [hard_leather_shirt]
(21256,1927,1,1,1,3824.63334),-- [hard_leather_shirt_pattern]
(21256,33,1,1,1,541.71216),-- [hard_leather_gaiters]
(21256,1929,1,1,1,6186.03183),-- [hard_leather_gaiters_material]
(21256,1867,1,1,2,42614.618235),-- [animal_skin]
(21256,1872,1,1,2,42614.618235),-- [animal_bone]
(21256,1882,1,1,2,7102.4849),-- [leather]
(21256,5153,1,1,2,1278.40846),-- [rp_comp_soulshot_d]
(21256,8294,1,1,2,781.48686),-- [rp_iron_sword]
(21256,735,1,1,2,2663.38331),-- [swift_attack_potion]
(21257,1868,1,1,-1,511527),-- [thread]
(21257,734,1,1,-1,42627),-- [quick_step_potion]
(21257,1897,1,1,-1,60896),-- [necklace_of_wisdom_chain]
(21257,57,122,202,0,700000),-- [adena]
(21257,217,1,1,1,144),-- [shining_knife]
(21257,218,1,1,1,144),-- [throw_knife]
(21257,1868,1,1,2,100731.527675),-- [thread]
(21257,1873,1,1,2,20146.33055),-- [silver_nugget]
(21257,735,1,1,2,4197.141775),-- [swift_attack_potion]
(21259,4613,1,1,-1,7283),-- [dye_s4c4_c]
(21259,4049,1,1,-1,276943),-- [adamantite_earing_gemstone]
(21259,4129,1,1,-1,57142),-- [rp_earing_of_black_ore]
(21259,57,2085,4248,0,700000),-- [adena]
(21259,229,1,1,1,11.674131),-- [kris]
(21259,4109,1,1,1,2196.825869),-- [kris_edge]
(21259,243,1,1,1,11.674131),-- [hell_knife]
(21259,4110,1,1,1,2196.825869),-- [hell_knife_edge]
(21259,1873,1,1,2,62384.21973),-- [silver_nugget]
(21259,1868,1,1,2,311920.18656),-- [thread]
(21259,1876,1,1,2,31192.109865),-- [mithril_ore]
(21259,1895,1,1,2,44560.15695),-- [metallic_fiber]
(21259,4042,1,1,2,2599.4565),-- [enria]
(21259,947,1,1,2,62.478165),-- [scrl_of_ench_wp_b]
(21259,8728,1,1,2,2599.4565),-- [general_61_b]
(21259,8738,1,1,2,649.864125),-- [special_61_b]
(21259,8748,1,1,2,64.75839),-- [rare_61_b]
(21259,8758,1,1,2,12.313215),-- [unique_61_b]
(21261,2169,1,1,-1,29259),-- [rp_necklace_of_binding]
(21261,1914,1,1,-1,92873),-- [earing_of_binding_gemstone]
(21261,2170,1,1,-1,38989),-- [rp_nassen's_earing]
(21261,57,654,1329,0,700000),-- [adena]
(21261,231,1,1,1,10.346928),-- [grace_dagger]
(21261,2106,1,1,1,931.653072),-- [grace_dagger_edge]
(21261,233,1,1,1,10.346928),-- [dark_screamer]
(21261,2107,1,1,1,931.653072),-- [dark_screamer_edge]
(21261,1869,1,1,2,62148.7397),-- [iron_ore]
(21261,1864,1,1,2,124297.69125),-- [stem]
(21261,1880,1,1,2,6214.8316),-- [steel]
(21261,5550,1,1,2,828.54535),-- [reinforcing_plate]
(21261,4043,1,1,2,2071.68115),-- [asofe]
(21261,2231,1,1,2,267.7784),-- [rp_full_plate_armor]
(21261,8725,1,1,2,1726.36565),-- [general_52_c]
(21261,8735,1,1,2,431.53845),-- [special_52_c]
(21261,8745,1,1,2,43.2174),-- [rare_52_c]
(21261,8755,1,1,2,8.68585),-- [unique_52_c]
(21261,1539,1,1,2,13810.9252),-- [greater_healing_potion]
(21262,2169,1,1,-1,39317),-- [rp_necklace_of_binding]
(21262,1914,1,1,-1,124797),-- [earing_of_binding_gemstone]
(21262,2170,1,1,-1,52391),-- [rp_nassen's_earing]
(21262,57,879,1786,0,700000),-- [adena]
(21262,228,1,1,1,17.400236),-- [crystal_dagger]
(21262,2119,1,1,1,1868.599764),-- [crystal_dagger_blade]
(21262,1869,1,1,2,74564.102417),-- [iron_ore]
(21262,1864,1,1,2,149128.204834),-- [stem]
(21262,1880,1,1,2,7456.334123),-- [steel]
(21262,5550,1,1,2,994.110222),-- [reinforcing_plate]
(21262,4043,1,1,2,2485.529284),-- [asofe]
(21262,2231,1,1,2,321.474643),-- [rp_full_plate_armor]
(21262,8726,1,1,2,1726.118387),-- [general_55_c]
(21262,8736,1,1,2,431.593029),-- [special_55_c]
(21262,8746,1,1,2,43.13393),-- [rare_55_c]
(21262,8756,1,1,2,8.626786),-- [unique_55_c]
(21262,1539,1,1,2,16569.772345),-- [greater_healing_potion]
(21263,2169,1,1,-1,55228),-- [rp_necklace_of_binding]
(21263,1914,1,1,-1,175302),-- [earing_of_binding_gemstone]
(21263,2170,1,1,-1,73594),-- [rp_nassen's_earing]
(21263,57,1233,2512,0,700000),-- [adena]
(21263,228,1,1,1,24.439674),-- [crystal_dagger]
(21263,2119,1,1,1,2624.560326),-- [crystal_dagger_blade]
(21263,1869,1,1,2,104739.863676),-- [iron_ore]
(21263,1864,1,1,2,209479.727352),-- [stem]
(21263,1880,1,1,2,10473.879444),-- [steel]
(21263,5550,1,1,2,1396.422216),-- [reinforcing_plate]
(21263,4043,1,1,2,3491.411952),-- [asofe]
(21263,2231,1,1,2,451.574004),-- [rp_full_plate_armor]
(21263,8726,1,1,2,2424.670836),-- [general_55_c]
(21263,8736,1,1,2,606.256812),-- [special_55_c]
(21263,8746,1,1,2,60.59004),-- [rare_55_c]
(21263,8756,1,1,2,12.118008),-- [unique_55_c]
(21263,1539,1,1,2,23275.48566),-- [greater_healing_potion]
(21264,2169,1,1,-1,76366),-- [rp_necklace_of_binding]
(21264,1914,1,1,-1,242396),-- [earing_of_binding_gemstone]
(21264,2170,1,1,-1,101761),-- [rp_nassen's_earing]
(21264,57,1704,3471,0,700000),-- [adena]
(21264,229,1,1,1,9.538587),-- [kris]
(21264,4109,1,1,1,1794.961413),-- [kris_edge]
(21264,243,1,1,1,9.538587),-- [hell_knife]
(21264,4110,1,1,1,1794.961413),-- [hell_knife_edge]
(21264,1869,1,1,2,115861.975602),-- [iron_ore]
(21264,1864,1,1,2,231723.557413),-- [stem]
(21264,1880,1,1,2,11586.118802),-- [steel]
(21264,5550,1,1,2,1544.842093),-- [reinforcing_plate]
(21264,4043,1,1,2,3861.908337),-- [asofe]
(21264,2231,1,1,2,499.326988),-- [rp_full_plate_armor]
(21264,8727,1,1,2,2317.066244),-- [general_58_b]
(21264,8737,1,1,2,579.266561),-- [special_58_b]
(21264,8747,1,1,2,57.887277),-- [rare_58_b]
(21264,8757,1,1,2,11.419939),-- [unique_58_b]
(21264,1539,1,1,2,25747.630744),-- [greater_healing_potion]
(21265,1864,1,3,-1,627198),-- [stem]
(21265,1869,1,1,-1,627198),-- [iron_ore]
(21265,1901,1,1,-1,86630),-- [tiger'seye_earing_stone]
(21265,57,264,530,0,700000),-- [adena]
(21265,83,1,1,1,20.17704),-- [sword_of_magic]
(21265,144,1,1,1,20.17704),-- [sword_of_occult]
(21265,124,1,1,1,14.947296),-- [two-handed_sword]
(21265,2026,1,1,1,668.803278),-- [two-handed_sword_edge]
(21265,127,1,1,1,14.947296),-- [crimson_sword]
(21265,130,1,1,1,14.94805),-- [elven_sword]
(21265,1864,1,1,2,133390.472304),-- [stem]
(21265,1869,1,1,2,66695.236152),-- [iron_ore]
(21265,1878,1,1,2,26678.20444),-- [braided_hemp]
(21265,1884,1,1,2,41043.137648),-- [cord]
(21265,2154,1,1,2,7140.949456),-- [rp_elven_earing]
(21268,1940,1,1,-1,174118),-- [iron_boots_design]
(21268,2156,1,1,-1,93327),-- [rp_elven_necklace]
(21268,2026,1,1,-1,14041),-- [two-handed_sword_edge]
(21268,57,492,986,0,700000),-- [adena]
(21268,278,1,1,1,83.430282),-- [gastraphetes]
(21268,2029,1,1,1,3699.569718),-- [gastraphetes_shaft]
(21268,1867,1,1,2,118145.997732),-- [animal_skin]
(21268,1872,1,1,2,118145.997732),-- [animal_bone]
(21268,1882,1,1,2,19690.999622),-- [leather]
(21268,1894,1,1,2,3109.154552),-- [crafted_leather]
(21268,2186,1,1,2,2963.354331),-- [rp_brigandine]
(21268,6037,1,3,2,59072.998866),-- [scroll_of_awake]
(21268,1341,20,60,2,147682.497165),-- [bone_arrow]
(21269,1825,1,1,-1,94807),-- [rp_oriharukon]
(21269,1902,1,1,-1,134478),-- [elven_earing_beads]
(21269,2145,1,1,-1,94807),-- [rp_mithirl_alloy]
(21269,57,561,1119,0,700000),-- [adena]
(21269,129,1,1,1,63.87616),-- [sword_of_revolution]
(21269,2034,1,1,1,3624.12384),-- [sword_of_revolution_blade]
(21269,1872,1,1,2,182963.082148),-- [animal_bone]
(21269,1867,1,1,2,182963.082148),-- [animal_skin]
(21269,1881,1,1,2,18296.348532),-- [coarse_bone_powder]
(21269,1875,1,1,2,9147.97268),-- [stone_of_purity]
(21269,1825,1,1,2,9801.514492),-- [rp_oriharukon]
(21270,1903,1,1,-1,255201),-- [elven_ring_piece]
(21270,6036,1,1,-1,50998),-- [potion_of_acumen3]
(21270,1902,1,1,-1,155008),-- [elven_earing_beads]
(21270,57,647,1291,0,700000),-- [adena]
(21270,88,1,1,1,14.726056),-- [morning_star]
(21270,2031,1,1,1,800.426842),-- [morning_star_head]
(21270,90,1,1,1,14.726056),-- [goathead_staff]
(21270,2032,1,1,1,730.67437),-- [goathead_staff_head]
(21270,158,1,1,1,14.726056),-- [tarbar]
(21270,2035,1,1,1,800.426842),-- [tarbar_head]
(21270,169,1,1,1,14.726056),-- [skull_breaker]
(21270,2036,1,1,1,800.426842),-- [skull_breaker_head]
(21270,172,1,1,1,14.726056),-- [heavy_bone_club]
(21270,2037,1,1,1,800.414824),-- [heavy_bone_club_head]
(21270,1868,1,1,2,316342.742333),-- [thread]
(21270,1873,1,1,2,63268.715375),-- [silver_nugget]
(21270,5549,1,1,2,15817.074526),-- [iron_thread]
(21270,1889,1,1,2,10544.855441),-- [compound_braid]
(21270,2145,1,1,2,11297.612325),-- [rp_mithirl_alloy]
(21271,1864,1,3,-1,905720),-- [stem]
(21271,1869,1,1,-1,905720),-- [iron_ore]
(21271,1901,1,1,-1,125099),-- [tiger'seye_earing_stone]
(21271,57,383,764,0,700000),-- [adena]
(21271,129,1,1,1,43.59444),-- [sword_of_revolution]
(21271,2034,1,1,1,2473.40556),-- [sword_of_revolution_blade]
(21271,1864,1,1,2,187274.890368),-- [stem]
(21271,1869,1,1,2,93637.445184),-- [iron_ore]
(21271,1878,1,1,2,37455.13248),-- [braided_hemp]
(21271,1884,1,1,2,57622.924416),-- [cord]
(21271,2154,1,1,2,10025.607552),-- [rp_elven_earing]
(21272,1864,1,7,-1,802957),-- [stem]
(21272,1869,1,3,-1,802957),-- [iron_ore]
(21272,1901,1,1,-1,221811),-- [tiger'seye_earing_stone]
(21272,57,679,1355,0,700000),-- [adena]
(21272,129,1,1,1,77.29916),-- [sword_of_revolution]
(21272,2034,1,1,1,4385.70084),-- [sword_of_revolution_blade]
(21272,1864,3,9,2,55342.280884),-- [stem]
(21272,1869,1,1,2,166026.842652),-- [iron_ore]
(21272,1878,1,1,2,66410.818606),-- [braided_hemp]
(21272,1884,1,1,2,102170.427436),-- [cord]
(21272,2154,1,1,2,17775.630422),-- [rp_elven_earing]
(21273,1864,1,19,-1,930725),-- [stem]
(21273,1869,1,9,-1,930725),-- [iron_ore]
(21273,1901,1,1,-1,642766),-- [tiger'seye_earing_stone]
(21273,57,1969,3922,0,700000),-- [adena]
(21273,129,1,1,1,223.98224),-- [sword_of_revolution]
(21273,2034,1,1,1,12708.01776),-- [sword_of_revolution_blade]
(21273,1864,3,9,2,160371.145974),-- [stem]
(21273,1869,2,6,2,120278.571205),-- [iron_ore]
(21273,1878,3,9,2,32074.144505),-- [braided_hemp]
(21273,1884,2,6,2,59213.837813),-- [cord]
(21273,2154,1,1,2,51511.300503),-- [rp_elven_earing]
(21274,4087,1,1,-1,72770),-- [hose_of_doom_pattern]
(21274,6333,1,1,-1,35604),-- [rp_sealed_phoenix's_ring_i]
(21274,4088,1,1,-1,117199),-- [blue_wolve's_helmet_design]
(21274,57,1223,2498,0,700000),-- [adena]
(21274,12341,1,1,1,708.44508),-- [earing_of_black_ore_low]
(21274,4052,1,1,1,5405.234928),-- [earing_of_black_ore_piece]
(21274,12342,1,1,1,531.036144),-- [necklace_of_black_ore_low]
(21274,4054,1,1,1,3007.099584),-- [necklace_of_black_ore_beads]
(21274,12343,1,1,1,1060.20864),-- [ring_of_black_ore_low]
(21274,4053,1,1,1,6543.975624),-- [ring_of_black_ore_gemstone]
(21274,1864,1,1,2,166548.059594),-- [stem]
(21274,1869,1,1,2,83274.029797),-- [iron_ore]
(21274,1878,1,1,2,33309.703385),-- [braided_hemp]
(21274,1884,1,1,2,51245.767874),-- [cord]
(21274,4039,1,1,2,2775.99917),-- [mold_glue]
(21274,5456,1,1,2,30.641177),-- [rp_tallum_glaive_i]
(21274,8730,1,1,2,925.180613),-- [general_67_a]
(21274,8740,1,1,2,231.409486),-- [special_67_a]
(21274,8750,1,1,2,23.323881),-- [rare_67_a]
(21274,8760,1,1,2,4.57331),-- [unique_67_a]
(21274,1343,10,30,2,118962.311713),-- [silver_arrow]
(21275,4087,1,1,-1,73242),-- [hose_of_doom_pattern]
(21275,6333,1,1,-1,35835),-- [rp_sealed_phoenix's_ring_i]
(21275,4088,1,1,-1,117959),-- [blue_wolve's_helmet_design]
(21275,57,1230,2515,0,700000),-- [adena]
(21275,12341,1,1,1,713.04324),-- [earing_of_black_ore_low]
(21275,4052,1,1,1,5440.317584),-- [earing_of_black_ore_piece]
(21275,12342,1,1,1,534.482832),-- [necklace_of_black_ore_low]
(21275,4054,1,1,1,3026.617152),-- [necklace_of_black_ore_beads]
(21275,12343,1,1,1,1067.08992),-- [ring_of_black_ore_low]
(21275,4053,1,1,1,6586.449272),-- [ring_of_black_ore_gemstone]
(21275,1864,1,1,2,167627.835504),-- [stem]
(21275,1869,1,1,2,83813.917752),-- [iron_ore]
(21275,1878,1,1,2,33525.65916),-- [braided_hemp]
(21275,1884,1,1,2,51578.007984),-- [cord]
(21275,4039,1,1,2,2793.99672),-- [mold_glue]
(21275,5456,1,1,2,30.839832),-- [rp_tallum_glaive_i]
(21275,8730,1,1,2,931.178808),-- [general_67_a]
(21275,8740,1,1,2,232.909776),-- [special_67_a]
(21275,8750,1,1,2,23.475096),-- [rare_67_a]
(21275,8760,1,1,2,4.60296),-- [unique_67_a]
(21275,1343,10,30,2,119733.576408),-- [silver_arrow]
(21276,4087,1,1,-1,72350),-- [hose_of_doom_pattern]
(21276,6333,1,1,-1,35399),-- [rp_sealed_phoenix's_ring_i]
(21276,4088,1,1,-1,116524),-- [blue_wolve's_helmet_design]
(21276,57,1216,2484,0,700000),-- [adena]
(21276,12341,1,1,1,704.33958),-- [earing_of_black_ore_low]
(21276,4052,1,1,1,5373.911128),-- [earing_of_black_ore_piece]
(21276,12342,1,1,1,527.958744),-- [necklace_of_black_ore_low]
(21276,4054,1,1,1,2989.673184),-- [necklace_of_black_ore_beads]
(21276,12343,1,1,1,1054.06464),-- [ring_of_black_ore_low]
(21276,4053,1,1,1,6506.052724),-- [ring_of_black_ore_gemstone]
(21276,1864,1,1,2,165588.09693),-- [stem]
(21276,1869,1,1,2,82794.048465),-- [iron_ore]
(21276,1878,1,1,2,33117.710325),-- [braided_hemp]
(21276,1884,1,1,2,50950.39353),-- [cord]
(21276,4039,1,1,2,2759.99865),-- [mold_glue]
(21276,5456,1,1,2,30.464565),-- [rp_tallum_glaive_i]
(21276,8730,1,1,2,919.847985),-- [general_67_a]
(21276,8740,1,1,2,230.07567),-- [special_67_a]
(21276,8750,1,1,2,23.189445),-- [rare_67_a]
(21276,8760,1,1,2,4.54695),-- [unique_67_a]
(21276,1343,10,30,2,118276.627485),-- [silver_arrow]
(21278,5478,1,1,-1,26945),-- [sealed_dark_crystal_leather_mail_pattern]
(21278,729,1,1,-1,356),-- [scrl_of_ench_wp_a]
(21278,4040,1,1,-1,64087),-- [mold_lubricant]
(21278,57,1268,2577,0,700000),-- [adena]
(21278,11957,1,1,1,43.42806),-- [tallum_blade_low]
(21278,5548,1,1,1,536.71891),-- [tallum_blade_edge]
(21278,11952,1,1,1,43.42806),-- [elemental_sword_low]
(21278,5547,1,1,1,536.71891),-- [elemental_sword_edge]
(21278,11954,1,1,1,43.42806),-- [inferno_master_low]
(21278,8331,1,1,1,538.278),-- [inferno_master_blade]
(21278,1865,1,1,2,94651.322115),-- [varnish]
(21278,1870,1,1,2,94651.322115),-- [coal]
(21278,1879,1,1,2,15775.18446),-- [cokes]
(21278,1875,1,1,2,6310.116855),-- [stone_of_purity]
(21278,4040,1,1,2,1892.97045),-- [mold_lubricant]
(21278,6339,1,1,2,728.115255),-- [rp_sealed_majestic_ring_i]
(21278,8730,1,1,2,1051.578465),-- [general_67_a]
(21278,8740,1,1,2,262.948455),-- [special_67_a]
(21278,8750,1,1,2,26.27331),-- [rare_67_a]
(21278,8760,1,1,2,5.16852),-- [unique_67_a]
(21279,5478,1,1,-1,26790),-- [sealed_dark_crystal_leather_mail_pattern]
(21279,729,1,1,-1,354),-- [scrl_of_ench_wp_a]
(21279,4040,1,1,-1,63717),-- [mold_lubricant]
(21279,57,1260,2562,0,700000),-- [adena]
(21279,11957,1,1,1,43.17876),-- [tallum_blade_low]
(21279,5548,1,1,1,533.63786),-- [tallum_blade_edge]
(21279,11952,1,1,1,43.17876),-- [elemental_sword_low]
(21279,5547,1,1,1,533.63786),-- [elemental_sword_edge]
(21279,11954,1,1,1,43.17876),-- [inferno_master_low]
(21279,8331,1,1,1,535.188),-- [inferno_master_blade]
(21279,1865,1,1,2,94105.886482),-- [varnish]
(21279,1870,1,1,2,94105.886482),-- [coal]
(21279,1879,1,1,2,15684.278728),-- [cokes]
(21279,1875,1,1,2,6273.754314),-- [stone_of_purity]
(21279,4040,1,1,2,1882.06206),-- [mold_lubricant]
(21279,6339,1,1,2,723.919434),-- [rp_sealed_majestic_ring_i]
(21279,8730,1,1,2,1045.518662),-- [general_67_a]
(21279,8740,1,1,2,261.433194),-- [special_67_a]
(21279,8750,1,1,2,26.121908),-- [rare_67_a]
(21279,8760,1,1,2,5.138736),-- [unique_67_a]
(21280,5478,1,1,-1,27120),-- [sealed_dark_crystal_leather_mail_pattern]
(21280,729,1,1,-1,358),-- [scrl_of_ench_wp_a]
(21280,4040,1,1,-1,64502),-- [mold_lubricant]
(21280,57,1276,2593,0,700000),-- [adena]
(21280,11957,1,1,1,43.70229),-- [tallum_blade_low]
(21280,5548,1,1,1,540.108065),-- [tallum_blade_edge]
(21280,11952,1,1,1,43.70229),-- [elemental_sword_low]
(21280,5547,1,1,1,540.108065),-- [elemental_sword_edge]
(21280,11954,1,1,1,43.70229),-- [inferno_master_low]
(21280,8331,1,1,1,541.677),-- [inferno_master_blade]
(21280,1865,1,1,2,95265.321776),-- [varnish]
(21280,1870,1,1,2,95265.321776),-- [coal]
(21280,1879,1,1,2,15877.517504),-- [cokes]
(21280,1875,1,1,2,6351.050352),-- [stone_of_purity]
(21280,4040,1,1,2,1905.25008),-- [mold_lubricant]
(21280,6339,1,1,2,732.838512),-- [rp_sealed_majestic_ring_i]
(21280,8730,1,1,2,1058.400016),-- [general_67_a]
(21280,8740,1,1,2,264.654192),-- [special_67_a]
(21280,8750,1,1,2,26.443744),-- [rare_67_a]
(21280,8760,1,1,2,5.202048),-- [unique_67_a]
(21282,5536,1,1,-1,11253),-- [bloody_orchid_head]
(21282,729,1,1,-1,368),-- [scrl_of_ench_wp_a]
(21282,4040,1,1,-1,66152),-- [mold_lubricant]
(21282,57,1309,2658,0,700000),-- [adena]
(21282,11957,1,1,1,44.82414),-- [tallum_blade_low]
(21282,5548,1,1,1,553.97279),-- [tallum_blade_edge]
(21282,11952,1,1,1,44.82414),-- [elemental_sword_low]
(21282,5547,1,1,1,553.97279),-- [elemental_sword_edge]
(21282,11954,1,1,1,44.82414),-- [inferno_master_low]
(21282,8331,1,1,1,555.582),-- [inferno_master_blade]
(21282,1865,1,1,2,97701.271628),-- [varnish]
(21282,1870,1,1,2,97701.271628),-- [coal]
(21282,1879,1,1,2,16283.619131),-- [cokes]
(21282,1875,1,1,2,6513.314705),-- [stone_of_purity]
(21282,4040,1,1,2,1954.105201),-- [mold_lubricant]
(21282,5456,1,1,2,36.117377),-- [rp_tallum_glaive_i]
(21282,8730,1,1,2,1085.515521),-- [general_67_a]
(21282,8740,1,1,2,271.434275),-- [special_67_a]
(21282,8750,1,1,2,27.032638),-- [rare_67_a]
(21282,8760,1,1,2,5.317896),-- [unique_67_a]
(21283,5536,1,1,-1,11326),-- [bloody_orchid_head]
(21283,729,1,1,-1,370),-- [scrl_of_ench_wp_a]
(21283,4040,1,1,-1,66581),-- [mold_lubricant]
(21283,57,1318,2676,0,700000),-- [adena]
(21283,11957,1,1,1,45.1233),-- [tallum_blade_low]
(21283,5548,1,1,1,557.67005),-- [tallum_blade_edge]
(21283,11952,1,1,1,45.1233),-- [elemental_sword_low]
(21283,5547,1,1,1,557.67005),-- [elemental_sword_edge]
(21283,11954,1,1,1,45.1233),-- [inferno_master_low]
(21283,8331,1,1,1,559.29),-- [inferno_master_blade]
(21283,1865,1,1,2,98334.890912),-- [varnish]
(21283,1870,1,1,2,98334.890912),-- [coal]
(21283,1879,1,1,2,16389.222824),-- [cokes]
(21283,1875,1,1,2,6555.55532),-- [stone_of_purity]
(21283,4040,1,1,2,1966.778104),-- [mold_lubricant]
(21283,5456,1,1,2,36.351608),-- [rp_tallum_glaive_i]
(21283,8730,1,1,2,1092.555384),-- [general_67_a]
(21283,8740,1,1,2,273.1946),-- [special_67_a]
(21283,8750,1,1,2,27.207952),-- [rare_67_a]
(21283,8760,1,1,2,5.352384),-- [unique_67_a]
(21284,5536,1,1,-1,11188),-- [bloody_orchid_head]
(21284,729,1,1,-1,365),-- [scrl_of_ench_wp_a]
(21284,4040,1,1,-1,65771),-- [mold_lubricant]
(21284,57,1302,2643,0,700000),-- [adena]
(21284,11957,1,1,1,44.57484),-- [tallum_blade_low]
(21284,5548,1,1,1,550.89174),-- [tallum_blade_edge]
(21284,11952,1,1,1,44.57484),-- [elemental_sword_low]
(21284,5547,1,1,1,550.89174),-- [elemental_sword_edge]
(21284,11954,1,1,1,44.57484),-- [inferno_master_low]
(21284,8331,1,1,1,552.492),-- [inferno_master_blade]
(21284,1865,1,1,2,97138.201464),-- [varnish]
(21284,1870,1,1,2,97138.201464),-- [coal]
(21284,1879,1,1,2,16189.773678),-- [cokes]
(21284,1875,1,1,2,6475.77729),-- [stone_of_purity]
(21284,4040,1,1,2,1942.843338),-- [mold_lubricant]
(21284,5456,1,1,2,35.909226),-- [rp_tallum_glaive_i]
(21284,8730,1,1,2,1079.259498),-- [general_67_a]
(21284,8740,1,1,2,269.86995),-- [special_67_a]
(21284,8750,1,1,2,26.876844),-- [rare_67_a]
(21284,8760,1,1,2,5.287248),-- [unique_67_a]
(21286,5549,1,1,-1,341557),-- [iron_thread]
(21286,1889,1,1,-1,227705),-- [compound_braid]
(21286,6343,1,1,-1,73029),-- [sealed_phoenix's_necklace_beads]
(21286,57,1351,2748,0,700000),-- [adena]
(21286,12224,1,1,1,549.524654),-- [sealed_dark_crystal_boots_low]
(21286,5496,1,1,1,2956.975346),-- [sealed_dark_crystal_boots_lining]
(21286,12231,1,1,1,549.524654),-- [sealed_tallum_boots_low]
(21286,5497,1,1,1,2956.975346),-- [sealed_tallum_boots_lining]
(21286,12221,1,1,1,549.524654),-- [sealed_dark_crystal_gloves_low]
(21286,5508,1,1,1,2956.975346),-- [sealed_dark_crystal_gloves_design]
(21286,12229,1,1,1,549.524654),-- [sealed_tallum_gloves_low]
(21286,5509,1,1,1,2956.975346),-- [sealed_tallum_gloves_design]
(21286,1868,1,1,2,201781.465144),-- [thread]
(21286,1873,1,1,2,40356.398544),-- [silver_nugget]
(21286,5549,1,1,2,10089.099636),-- [iron_thread]
(21286,1889,1,1,2,6726.066424),-- [compound_braid]
(21286,4044,1,1,2,3363.033212),-- [thons]
(21286,5440,1,1,2,37.457896),-- [rp_elysian_i]
(21286,8730,1,1,2,1121.099),-- [general_67_a]
(21286,8740,1,1,2,280.142856),-- [special_67_a]
(21286,8750,1,1,2,27.961528),-- [rare_67_a]
(21286,8760,1,1,2,5.27576),-- [unique_67_a]
(21287,5549,1,1,-1,339589),-- [iron_thread]
(21287,1889,1,1,-1,226392),-- [compound_braid]
(21287,6343,1,1,-1,72608),-- [sealed_phoenix's_necklace_beads]
(21287,57,1343,2732,0,700000),-- [adena]
(21287,12224,1,1,1,546.351155),-- [sealed_dark_crystal_boots_low]
(21287,5496,1,1,1,2939.898845),-- [sealed_dark_crystal_boots_lining]
(21287,12231,1,1,1,546.351155),-- [sealed_tallum_boots_low]
(21287,5497,1,1,1,2939.898845),-- [sealed_tallum_boots_lining]
(21287,12221,1,1,1,546.351155),-- [sealed_dark_crystal_gloves_low]
(21287,5508,1,1,1,2939.898845),-- [sealed_dark_crystal_gloves_design]
(21287,12229,1,1,1,546.351155),-- [sealed_tallum_gloves_low]
(21287,5509,1,1,1,2939.898845),-- [sealed_tallum_gloves_design]
(21287,1868,1,1,2,200618.759384),-- [thread]
(21287,1873,1,1,2,40123.856784),-- [silver_nugget]
(21287,5549,1,1,2,10030.964196),-- [iron_thread]
(21287,1889,1,1,2,6687.309464),-- [compound_braid]
(21287,4044,1,1,2,3343.654732),-- [thons]
(21287,5440,1,1,2,37.242056),-- [rp_elysian_i]
(21287,8730,1,1,2,1114.639),-- [general_67_a]
(21287,8740,1,1,2,278.528616),-- [special_67_a]
(21287,8750,1,1,2,27.800408),-- [rare_67_a]
(21287,8760,1,1,2,5.24536),-- [unique_67_a]
(21288,5549,1,1,-1,343772),-- [iron_thread]
(21288,1889,1,1,-1,229181),-- [compound_braid]
(21288,6343,1,1,-1,73503),-- [sealed_phoenix's_necklace_beads]
(21288,57,1360,2766,0,700000),-- [adena]
(21288,12224,1,1,1,553.089943),-- [sealed_dark_crystal_boots_low]
(21288,5496,1,1,1,2976.160057),-- [sealed_dark_crystal_boots_lining]
(21288,12231,1,1,1,553.089943),-- [sealed_tallum_boots_low]
(21288,5497,1,1,1,2976.160057),-- [sealed_tallum_boots_lining]
(21288,12221,1,1,1,553.089943),-- [sealed_dark_crystal_gloves_low]
(21288,5508,1,1,1,2976.160057),-- [sealed_dark_crystal_gloves_design]
(21288,12229,1,1,1,553.089943),-- [sealed_tallum_gloves_low]
(21288,5509,1,1,1,2976.160057),-- [sealed_tallum_gloves_design]
(21288,1868,1,1,2,203089.509124),-- [thread]
(21288,1873,1,1,2,40618.008024),-- [silver_nugget]
(21288,5549,1,1,2,10154.502006),-- [iron_thread]
(21288,1889,1,1,2,6769.668004),-- [compound_braid]
(21288,4044,1,1,2,3384.834002),-- [thons]
(21288,5440,1,1,2,37.700716),-- [rp_elysian_i]
(21288,8730,1,1,2,1128.3665),-- [general_67_a]
(21288,8740,1,1,2,281.958876),-- [special_67_a]
(21288,8750,1,1,2,28.142788),-- [rare_67_a]
(21288,8760,1,1,2,5.30996),-- [unique_67_a]
(21290,730,1,1,-1,2349),-- [scrl_of_ench_am_a]
(21290,4041,1,1,-1,24508),-- [mold_hardener]
(21290,1875,1,1,-1,187895),-- [stone_of_purity]
(21290,57,1391,2835,0,700000),-- [adena]
(21290,11957,1,1,1,47.74095),-- [tallum_blade_low]
(21290,5548,1,1,1,590.021075);-- [tallum_blade_edge]

INSERT INTO `droplist` VALUES
(21290,11952,1,1,1,47.74095),-- [elemental_sword_low]
(21290,5547,1,1,1,590.021075),-- [elemental_sword_edge]
(21290,11954,1,1,1,47.74095),-- [inferno_master_low]
(21290,8331,1,1,1,591.735),-- [inferno_master_blade]
(21290,1872,1,1,2,138752.735056),-- [animal_bone]
(21290,1867,1,1,2,138752.735056),-- [animal_skin]
(21290,1881,1,1,2,13875.333654),-- [coarse_bone_powder]
(21290,1875,1,1,2,6937.516456),-- [stone_of_purity]
(21290,4041,1,1,2,904.932678),-- [mold_hardener]
(21290,5456,1,1,2,38.494976),-- [rp_tallum_glaive_i]
(21290,8730,1,1,2,1156.35299),-- [general_67_a]
(21290,8740,1,1,2,289.013062),-- [special_67_a]
(21290,8750,1,1,2,28.871232),-- [rare_67_a]
(21290,8760,1,1,2,6.01484),-- [unique_67_a]
(21291,730,1,1,-1,2335),-- [scrl_of_ench_am_a]
(21291,4041,1,1,-1,24367),-- [mold_hardener]
(21291,1875,1,1,-1,186812),-- [stone_of_purity]
(21291,57,1383,2819,0,700000),-- [adena]
(21291,11957,1,1,1,47.46672),-- [tallum_blade_low]
(21291,5548,1,1,1,586.63192),-- [tallum_blade_edge]
(21291,11952,1,1,1,47.46672),-- [elemental_sword_low]
(21291,5547,1,1,1,586.63192),-- [elemental_sword_edge]
(21291,11954,1,1,1,47.46672),-- [inferno_master_low]
(21291,8331,1,1,1,588.336),-- [inferno_master_blade]
(21291,1872,1,1,2,137953.184312),-- [animal_bone]
(21291,1867,1,1,2,137953.184312),-- [animal_skin]
(21291,1881,1,1,2,13795.378233),-- [coarse_bone_powder]
(21291,1875,1,1,2,6897.539612),-- [stone_of_purity]
(21291,4041,1,1,2,899.718081),-- [mold_hardener]
(21291,5456,1,1,2,38.273152),-- [rp_tallum_glaive_i]
(21291,8730,1,1,2,1149.689605),-- [general_67_a]
(21291,8740,1,1,2,287.347649),-- [special_67_a]
(21291,8750,1,1,2,28.704864),-- [rare_67_a]
(21291,8760,1,1,2,5.98018),-- [unique_67_a]
(21292,730,1,1,-1,2364),-- [scrl_of_ench_am_a]
(21292,4041,1,1,-1,24667),-- [mold_hardener]
(21292,1875,1,1,-1,189113),-- [stone_of_purity]
(21292,57,1400,2853,0,700000),-- [adena]
(21292,11957,1,1,1,48.06504),-- [tallum_blade_low]
(21292,5548,1,1,1,594.02644),-- [tallum_blade_edge]
(21292,11952,1,1,1,48.06504),-- [elemental_sword_low]
(21292,5547,1,1,1,594.02644),-- [elemental_sword_edge]
(21292,11954,1,1,1,48.06504),-- [inferno_master_low]
(21292,8331,1,1,1,595.752),-- [inferno_master_blade]
(21292,1872,1,1,2,139652.402656),-- [animal_bone]
(21292,1867,1,1,2,139652.402656),-- [animal_skin]
(21292,1881,1,1,2,13965.300804),-- [coarse_bone_powder]
(21292,1875,1,1,2,6982.499056),-- [stone_of_purity]
(21292,4041,1,1,2,910.800228),-- [mold_hardener]
(21292,5456,1,1,2,38.744576),-- [rp_tallum_glaive_i]
(21292,8730,1,1,2,1163.85074),-- [general_67_a]
(21292,8740,1,1,2,290.887012),-- [special_67_a]
(21292,8750,1,1,2,29.058432),-- [rare_67_a]
(21292,8760,1,1,2,6.05384),-- [unique_67_a]
(21294,5486,1,1,-1,33941),-- [sealed_dark_crystal_robe_fabric]
(21294,5442,1,1,-1,2124),-- [rp_soul_bow_i]
(21294,5489,1,1,-1,75707),-- [sealed_tallum_hose_fabric]
(21294,57,2269,4612,0,700000),-- [adena]
(21294,11957,1,1,1,77.73174),-- [tallum_blade_low]
(21294,5548,1,1,1,960.67139),-- [tallum_blade_edge]
(21294,11952,1,1,1,77.73174),-- [elemental_sword_low]
(21294,5547,1,1,1,960.67139),-- [elemental_sword_edge]
(21294,11954,1,1,1,77.73174),-- [inferno_master_low]
(21294,8331,1,1,1,963.462),-- [inferno_master_blade]
(21294,1869,1,1,2,169431.236205),-- [iron_ore]
(21294,1864,1,3,2,169431.236205),-- [stem]
(21294,1880,1,1,2,16943.013765),-- [steel]
(21294,5550,1,1,2,2258.995265),-- [reinforcing_plate]
(21294,4043,1,1,2,5647.671255),-- [asofe]
(21294,5440,1,1,2,62.617635),-- [rp_elysian_i]
(21294,8730,1,1,2,1882.557085),-- [general_67_a]
(21294,8740,1,1,2,470.547725),-- [special_67_a]
(21294,8750,1,1,2,47.237865),-- [rare_67_a]
(21294,8760,1,1,2,9.886995),-- [unique_67_a]
(21295,5547,1,1,-1,20750),-- [elemental_sword_edge]
(21295,5442,1,1,-1,2259),-- [rp_soul_bow_i]
(21295,5548,1,1,-1,20750),-- [tallum_blade_edge]
(21295,57,2414,4902,0,700000),-- [adena]
(21295,11957,1,1,1,82.66788),-- [tallum_blade_low]
(21295,5548,1,1,1,1021.67618),-- [tallum_blade_edge]
(21295,11952,1,1,1,82.66788),-- [elemental_sword_low]
(21295,5547,1,1,1,1021.67618),-- [elemental_sword_edge]
(21295,11954,1,1,1,82.66788),-- [inferno_master_low]
(21295,8331,1,1,1,1024.644),-- [inferno_master_blade]
(21295,1869,1,3,2,100086.186912),-- [iron_ore]
(21295,1864,1,3,2,300258.560736),-- [stem]
(21295,1880,1,1,2,30025.67784),-- [steel]
(21295,5550,1,1,2,4003.57224),-- [reinforcing_plate]
(21295,4043,1,1,2,10008.707808),-- [asofe]
(21295,10304,1,1,2,1201.294464),-- [sb_transform_saber_toothed_tiger]
(21296,5482,1,1,-1,120055),-- [sealed_legging_of_dark_crystal_design]
(21296,5440,1,1,-1,3369),-- [rp_elysian_i]
(21296,5485,1,1,-1,76488),-- [sealed_tallum_tunic_texture]
(21296,57,3597,7319,0,700000),-- [adena]
(21296,11955,1,1,1,369.855732),-- [carnium_bow_low]
(21296,5535,1,1,1,4584.144268),-- [carnium_bow_shaft]
(21296,1872,4,12,2,74633.468013),-- [animal_bone]
(21296,1867,1,3,2,199022.458401),-- [animal_skin]
(21296,1881,1,1,2,59706.62685),-- [coarse_bone_powder]
(21296,1875,1,1,2,29853.313425),-- [stone_of_purity]
(21296,4041,1,1,2,3893.750055),-- [mold_hardener]
(21296,10304,1,1,2,1791.383256),-- [sb_transform_saber_toothed_tiger]
(21297,5450,1,1,-1,2714),-- [rp_dragon_grinder_i]
(21297,6345,1,1,-1,280279),-- [sealed_phoenix's_ring_gemstone]
(21297,5456,1,1,-1,2714),-- [rp_tallum_glaive_i]
(21297,57,3615,7369,0,700000),-- [adena]
(21297,11951,1,1,1,372.343692),-- [bloody_orchid_low]
(21297,5536,1,1,1,4601.656308),-- [bloody_orchid_head]
(21297,1873,2,6,2,45086.013615),-- [silver_nugget]
(21297,1868,3,9,2,150287.276958),-- [thread]
(21297,1876,1,1,2,90172.450911),-- [mithril_ore]
(21297,1895,1,1,2,128817.665964),-- [metallic_fiber]
(21297,4042,1,1,2,7514.406216),-- [enria]
(21297,10304,1,1,2,1803.186336),-- [sb_transform_saber_toothed_tiger]
(21298,5478,1,1,-1,39651),-- [sealed_dark_crystal_leather_mail_pattern]
(21298,730,1,1,-1,3929),-- [scrl_of_ench_am_a]
(21298,1895,1,3,-1,673616),-- [metallic_fiber]
(21298,57,2327,4743,0,700000),-- [adena]
(21298,12224,1,1,1,948.288516),-- [sealed_dark_crystal_boots_low]
(21298,5496,1,1,1,5102.711484),-- [sealed_dark_crystal_boots_lining]
(21298,12231,1,1,1,948.288516),-- [sealed_tallum_boots_low]
(21298,5497,1,1,1,5102.711484),-- [sealed_tallum_boots_lining]
(21298,12221,1,1,1,948.288516),-- [sealed_dark_crystal_gloves_low]
(21298,5508,1,1,1,5102.711484),-- [sealed_dark_crystal_gloves_design]
(21298,12229,1,1,1,948.288516),-- [sealed_tallum_gloves_low]
(21298,5509,1,1,1,5102.711484),-- [sealed_tallum_gloves_design]
(21298,1873,1,1,2,58034.635828),-- [silver_nugget]
(21298,1868,1,3,2,145087.049892),-- [thread]
(21298,1876,1,1,2,29017.317914),-- [mithril_ore]
(21298,1895,1,1,2,41453.377066),-- [metallic_fiber]
(21298,4042,1,1,2,2418.071466),-- [enria]
(21298,5167,1,1,2,64.44508),-- [rp_comp_bspiritshot_s]
(21298,5380,1,1,2,824.436702),-- [rp_sealed_boots_of_nightmare_i]
(21298,8730,1,1,2,1612.047644),-- [general_67_a]
(21298,8740,1,1,2,403.242072),-- [special_67_a]
(21298,8750,1,1,2,40.508336),-- [rare_67_a]
(21298,8760,1,1,2,8.285796),-- [unique_67_a]
(21298,1344,10,30,2,181358.582204),-- [mithril_arrow]
(21299,5508,1,1,-1,177046),-- [sealed_dark_crystal_gloves_design]
(21299,729,1,1,-1,839),-- [scrl_of_ench_wp_a]
(21299,4041,1,1,-1,65661),-- [mold_hardener]
(21299,57,3724,7603,0,700000),-- [adena]
(21299,11957,1,1,1,127.91583),-- [tallum_blade_low]
(21299,5548,1,1,1,1580.886755),-- [tallum_blade_edge]
(21299,11952,1,1,1,127.91583),-- [elemental_sword_low]
(21299,5547,1,1,1,1580.886755),-- [elemental_sword_edge]
(21299,11954,1,1,1,127.91583),-- [inferno_master_low]
(21299,8331,1,1,1,1585.479),-- [inferno_master_blade]
(21299,1872,1,3,2,154892.866007),-- [animal_bone]
(21299,1867,1,3,2,103262.166656),-- [animal_skin]
(21299,1881,1,1,2,30978.496406),-- [coarse_bone_powder]
(21299,1875,1,1,2,15489.248203),-- [stone_of_purity]
(21299,4041,1,1,2,2020.486974),-- [mold_hardener]
(21299,5157,1,1,2,103.289813),-- [rp_comp_soulshot_s]
(21299,5382,1,1,2,1320.112926),-- [rp_sealed_magestic_boots_i]
(21299,8730,1,1,2,2581.477371),-- [general_67_a]
(21299,8740,1,1,2,645.465337),-- [special_67_a]
(21299,8750,1,1,2,64.508136),-- [rare_67_a]
(21299,8760,1,1,2,13.055218),-- [unique_67_a]
(21299,1344,40,120,2,72605.826953),-- [mithril_arrow]
(21300,1895,1,5,-1,707483),-- [metallic_fiber]
(21300,5509,1,1,-1,174175),-- [sealed_tallum_gloves_design]
(21300,5434,1,1,-1,2751),-- [rp_dragon_slayer_i]
(21300,57,3663,7480,0,700000),-- [adena]
(21300,11946,1,1,1,94.390996),-- [dasparion's_staff_low]
(21300,5543,1,1,1,1167.154464),-- [dasparion's_staff_head]
(21300,11949,1,1,1,94.390996),-- [meteor_shower_low]
(21300,5532,1,1,1,1156.253364),-- [meteor_shower_head]
(21300,11953,1,1,1,94.390996),-- [eye_of_soul_low]
(21300,8341,1,1,1,1154.774824),-- [eye_of_soul_piece]
(21300,11958,1,1,1,94.390996),-- [hammer_of_destroyer_low]
(21300,8346,1,1,1,1156.253364),-- [hammer_of_destroyer_piece]
(21300,1895,1,1,2,87074.879346),-- [metallic_fiber]
(21300,4040,1,1,2,6095.186244),-- [mold_lubricant]
(21300,4042,1,1,2,5079.397122),-- [enria]
(21300,4043,1,1,2,10158.681366),-- [asofe]
(21300,5162,1,1,2,135.4536),-- [rp_comp_spiritshot_s]
(21300,8730,1,1,2,3386.227122),-- [general_67_a]
(21300,8740,1,1,2,846.585),-- [special_67_a]
(21300,8750,1,1,2,84.6585),-- [rare_67_a]
(21300,8760,1,1,2,16.9317),-- [unique_67_a]
(21301,5520,1,1,-1,57484),-- [sealed_dark_crystal_breastplate_pattern]
(21301,5440,1,1,-1,3302),-- [rp_elysian_i]
(21301,5521,1,1,-1,40563),-- [sealed_tallum_plate_armor_pattern]
(21301,57,4396,8976,0,700000),-- [adena]
(21301,11950,1,1,1,453.070422),-- [blood_tornado_low]
(21301,5539,1,1,1,5549.929578),-- [blood_tornado_edge]
(21301,1868,4,12,2,68571.48648),-- [thread]
(21301,1873,1,1,2,109714.44897),-- [silver_nugget]
(21301,5549,1,1,2,27428.52399),-- [iron_thread]
(21301,1889,1,1,2,18285.56499),-- [compound_braid]
(21301,4044,1,1,2,9142.959),-- [thons]
(21301,5167,1,1,2,121.78845),-- [rp_comp_bspiritshot_s]
(21301,5404,1,1,2,1558.53915),-- [rp_sealed_gloves_of_nightmare_i]
(21301,8730,1,1,2,3047.53533),-- [general_67_a]
(21301,8740,1,1,2,761.79558),-- [special_67_a]
(21301,8750,1,1,2,76.25016),-- [rare_67_a]
(21301,8760,1,1,2,15.17943),-- [unique_67_a]
(21301,1344,30,90,2,114285.92847),-- [mithril_arrow]
(21302,729,1,1,-1,799),-- [scrl_of_ench_wp_a]
(21302,1875,1,1,-1,479548),-- [stone_of_purity]
(21302,4041,1,1,-1,62550),-- [mold_hardener]
(21302,57,3552,7232,0,700000),-- [adena]
(21302,11957,1,1,1,121.85784),-- [tallum_blade_low]
(21302,5548,1,1,1,1506.01724),-- [tallum_blade_edge]
(21302,11952,1,1,1,121.85784),-- [elemental_sword_low]
(21302,5547,1,1,1,1506.01724),-- [elemental_sword_edge]
(21302,11954,1,1,1,121.85784),-- [inferno_master_low]
(21302,8331,1,1,1,1510.392),-- [inferno_master_blade]
(21302,1872,1,3,2,160967.013024),-- [animal_bone]
(21302,1867,1,3,2,107311.342016),-- [animal_skin]
(21302,1881,1,1,2,32193.338003),-- [coarse_bone_powder]
(21302,1875,1,1,2,16096.830506),-- [stone_of_purity]
(21302,4041,1,1,2,2099.5585),-- [mold_hardener]
(21302,5162,1,1,2,107.238988),-- [rp_comp_spiritshot_s]
(21302,5382,1,1,2,1371.819223),-- [rp_sealed_magestic_boots_i]
(21302,8731,1,1,2,2235.545289),-- [general_70_a]
(21302,8741,1,1,2,558.80557),-- [special_70_a]
(21302,8751,1,1,2,55.880557),-- [rare_70_a]
(21302,8761,1,1,2,11.628324),-- [unique_70_a]
(21303,5547,1,1,-1,24748),-- [elemental_sword_edge]
(21303,5466,1,1,-1,2694),-- [rp_sword_of_miracle_i]
(21303,5548,1,1,-1,24748),-- [tallum_blade_edge]
(21303,57,3592,7313,0,700000),-- [adena]
(21303,11946,1,1,1,92.413531),-- [dasparion's_staff_low]
(21303,5543,1,1,1,1142.702904),-- [dasparion's_staff_head]
(21303,11949,1,1,1,92.413531),-- [meteor_shower_low]
(21303,5532,1,1,1,1132.030179),-- [meteor_shower_head]
(21303,11953,1,1,1,92.413531),-- [eye_of_soul_low]
(21303,8341,1,1,1,1130.582614),-- [eye_of_soul_piece]
(21303,11958,1,1,1,92.413531),-- [hammer_of_destroyer_low]
(21303,8346,1,1,1,1132.030179),-- [hammer_of_destroyer_piece]
(21303,1872,1,3,2,149211.132531),-- [animal_bone]
(21303,1867,1,3,2,99474.088354),-- [animal_skin]
(21303,1881,1,1,2,29842.152634),-- [coarse_bone_powder]
(21303,1875,1,1,2,14921.076317),-- [stone_of_purity]
(21303,4041,1,1,2,1946.163109),-- [mold_hardener]
(21303,5167,1,1,2,99.358109),-- [rp_comp_bspiritshot_s]
(21303,5406,1,1,2,1271.709923),-- [rp_sealed_magestic_gloves_i]
(21303,8731,1,1,2,2072.484571),-- [general_70_a]
(21303,8741,1,1,2,518.213483),-- [special_70_a]
(21303,8751,1,1,2,51.71054),-- [rare_70_a]
(21303,8761,1,1,2,10.342108),-- [unique_70_a]
(21303,1344,40,120,2,69942.568321),-- [mithril_arrow]
(21304,5542,1,1,-1,36128),-- [halbard_edge]
(21304,5440,1,1,-1,3968),-- [rp_elysian_i]
(21304,5543,1,1,-1,36469),-- [dasparion's_staff_head]
(21304,57,5287,10776,0,700000),-- [adena]
(21304,11946,1,1,1,136.124924),-- [dasparion's_staff_low]
(21304,5543,1,1,1,1683.198816),-- [dasparion's_staff_head]
(21304,11949,1,1,1,136.124924),-- [meteor_shower_low]
(21304,5532,1,1,1,1667.477916),-- [meteor_shower_head]
(21304,11953,1,1,1,136.124924),-- [eye_of_soul_low]
(21304,8341,1,1,1,1665.345656),-- [eye_of_soul_piece]
(21304,11958,1,1,1,136.124924),-- [hammer_of_destroyer_low]
(21304,8346,1,1,1,1667.477916),-- [hammer_of_destroyer_piece]
(21304,1894,1,1,2,13879.8519),-- [crafted_leather]
(21304,4039,1,1,2,13185.637464),-- [mold_glue]
(21304,4041,1,1,2,3439.718652),-- [mold_hardener]
(21304,4044,1,1,2,13185.637464),-- [thons]
(21304,5277,1,1,2,175.698072),-- [rp_adv_comp_spiritshot_s]
(21304,8731,1,1,2,3662.742804),-- [general_70_a]
(21304,8741,1,1,2,915.759648),-- [special_70_a]
(21304,8751,1,1,2,91.69428),-- [rare_70_a]
(21304,8761,1,1,2,18.338856),-- [unique_70_a]
(21304,1344,20,60,2,247232.92086),-- [mithril_arrow]
(21305,730,1,1,-1,6574),-- [scrl_of_ench_am_a]
(21305,4040,1,1,-1,157783),-- [mold_lubricant]
(21305,1877,1,1,-1,315566),-- [admantite_nugget]
(21305,57,3893,7935,0,700000),-- [adena]
(21305,11946,1,1,1,100.229226),-- [dasparion's_staff_low]
(21305,5543,1,1,1,1239.344784),-- [dasparion's_staff_head]
(21305,11949,1,1,1,100.229226),-- [meteor_shower_low]
(21305,5532,1,1,1,1227.769434),-- [meteor_shower_head]
(21305,11953,1,1,1,100.229226),-- [eye_of_soul_low]
(21305,8341,1,1,1,1226.199444),-- [eye_of_soul_piece]
(21305,11958,1,1,1,100.229226),-- [hammer_of_destroyer_low]
(21305,8346,1,1,1,1227.769434),-- [hammer_of_destroyer_piece]
(21305,1871,1,3,2,145645.737432),-- [charcoal]
(21305,1866,1,1,2,194194.074288),-- [suede]
(21305,1877,1,1,2,11651.62992),-- [admantite_nugget]
(21305,4041,1,1,2,2533.12104),-- [mold_hardener]
(21305,4040,1,1,2,5825.81496),-- [mold_lubricant]
(21305,5282,1,1,2,129.381792),-- [rp_adv_comp_bspiritshot_s]
(21305,8731,1,1,2,2697.028872),-- [general_70_a]
(21305,8741,1,1,2,674.16636),-- [special_70_a]
(21305,8751,1,1,2,67.598352),-- [rare_70_a]
(21305,8761,1,1,2,13.446984),-- [unique_70_a]
(21306,5547,1,1,-1,48569),-- [elemental_sword_edge]
(21306,5442,1,1,-1,5287),-- [rp_soul_bow_i]
(21306,5548,1,1,-1,48569),-- [tallum_blade_edge]
(21306,57,7045,14360,0,700000),-- [adena]
(21306,11950,1,1,1,725.531562),-- [blood_tornado_low]
(21306,5539,1,1,1,8887.468438),-- [blood_tornado_edge]
(21306,1865,1,3,2,159728.673824),-- [varnish]
(21306,1870,2,6,2,119796.622112),-- [coal]
(21306,1879,1,1,2,79864.5704),-- [cokes]
(21306,1875,1,1,2,31945.82816),-- [stone_of_purity]
(21306,4040,1,1,2,9583.748448),-- [mold_lubricant]
(21306,6901,1,1,2,479.117376),-- [rp_shining_arrow]
(21306,8731,1,1,2,4436.738976),-- [general_70_a]
(21306,8741,1,1,2,1109.068),-- [special_70_a]
(21306,8751,1,1,2,111.140288),-- [rare_70_a]
(21306,8761,1,1,2,22.414848),-- [unique_70_a]
(21306,1344,100,300,2,59898.077568),-- [mithril_arrow]
(21307,5480,1,1,-1,45013),-- [sealed_leather_mail_of_nightmare_fabric]
(21307,1808,1,1,-1,4458),-- [rp_soulshot_s]
(21307,5481,1,1,-1,45013),-- [sealed_majestic_leather_mail_fabric]
(21307,57,4948,10097,0,700000),-- [adena]
(21307,11957,1,1,1,169.94781),-- [tallum_blade_low]
(21307,5548,1,1,1,2100.351785),-- [tallum_blade_edge]
(21307,11952,1,1,1,169.94781),-- [elemental_sword_low]
(21307,5547,1,1,1,2100.351785),-- [elemental_sword_edge]
(21307,11954,1,1,1,169.94781),-- [inferno_master_low]
(21307,8331,1,1,1,2106.453),-- [inferno_master_blade]
(21307,1868,3,9,2,123464.184746),-- [thread]
(21307,1873,1,1,2,148157.091746),-- [silver_nugget]
(21307,5549,1,1,2,37039.3605),-- [iron_thread]
(21307,1889,1,1,2,24692.907),-- [compound_braid]
(21307,4044,1,1,2,12346.4535),-- [thons]
(21307,5277,1,1,2,164.61938),-- [rp_adv_comp_spiritshot_s]
(21307,8731,1,1,2,3429.687168),-- [general_70_a]
(21307,8741,1,1,2,857.421792),-- [special_70_a]
(21307,8751,1,1,2,85.81223),-- [rare_70_a]
(21307,8761,1,1,2,16.461938),-- [unique_70_a]
(21308,3036,1,1,-1,5924),-- [rp_spiritshot_s]
(21308,5487,1,1,-1,60021),-- [sealed_robe_of_nightmare_fabric]
(21308,1875,1,1,-1,888584),-- [stone_of_purity]
(21308,57,6575,13415,0,700000),-- [adena]
(21308,11946,1,1,1,169.346336),-- [dasparion's_staff_low]
(21308,5543,1,1,1,2093.985024),-- [dasparion's_staff_head]
(21308,11949,1,1,1,169.346336),-- [meteor_shower_low]
(21308,5532,1,1,1,2074.427424),-- [meteor_shower_head]
(21308,11953,1,1,1,169.346336),-- [eye_of_soul_low]
(21308,8341,1,1,1,2071.774784),-- [eye_of_soul_piece]
(21308,11958,1,1,1,169.346336),-- [hammer_of_destroyer_low]
(21308,8346,1,1,1,2074.427424),-- [hammer_of_destroyer_piece]
(21308,1872,5,15,2,59653.14794),-- [animal_bone]
(21308,1867,1,3,2,198843.66074),-- [animal_skin]
(21308,1881,1,1,2,59653.14794),-- [coarse_bone_powder]
(21308,1875,1,1,2,29826.32538),-- [stone_of_purity]
(21308,4041,1,1,2,3890.4335),-- [mold_hardener]
(21308,5282,1,1,2,198.872),-- [rp_adv_comp_bspiritshot_s]
(21308,8731,1,1,2,4142.50376),-- [general_70_a]
(21308,8741,1,1,2,1035.62594),-- [special_70_a]
(21308,8751,1,1,2,103.41344),-- [rare_70_a]
(21308,8761,1,1,2,20.88156),-- [unique_70_a]
(21308,1344,40,120,2,139811.9878),-- [mithril_arrow]
(21309,3036,1,1,-1,6174),-- [rp_spiritshot_s]
(21309,5487,1,1,-1,62556),-- [sealed_robe_of_nightmare_fabric]
(21309,1875,1,1,-1,926118),-- [stone_of_purity]
(21309,57,6853,13982,0,700000),-- [adena]
(21309,11946,1,1,1,176.502876),-- [dasparion's_staff_low]
(21309,5543,1,1,1,2182.476384),-- [dasparion's_staff_head]
(21309,11949,1,1,1,176.502876),-- [meteor_shower_low]
(21309,5532,1,1,1,2162.092284),-- [meteor_shower_head]
(21309,11953,1,1,1,176.502876),-- [eye_of_soul_low]
(21309,8341,1,1,1,2159.327544),-- [eye_of_soul_piece]
(21309,11958,1,1,1,176.502876),-- [hammer_of_destroyer_low]
(21309,8346,1,1,1,2162.092284),-- [hammer_of_destroyer_piece]
(21309,1872,5,15,2,62172.92628),-- [animal_bone]
(21309,1867,9,27,2,34540.74492),-- [animal_skin]
(21309,1881,1,1,2,62172.92628),-- [coarse_bone_powder]
(21309,1875,1,1,2,31086.63588),-- [stone_of_purity]
(21309,4041,1,1,2,4054.89876),-- [mold_hardener]
(21309,5282,1,1,2,207.288),-- [rp_adv_comp_bspiritshot_s]
(21309,8731,1,1,2,4317.46356),-- [general_70_a]
(21309,8741,1,1,2,1079.27952),-- [special_70_a]
(21309,8751,1,1,2,107.78976),-- [rare_70_a]
(21309,8761,1,1,2,21.41976),-- [unique_70_a]
(21309,1344,40,120,2,145718.62728),-- [mithril_arrow]
(21310,5549,1,3,-1,571636),-- [iron_thread]
(21310,5546,1,1,-1,34452),-- [sword_of_miracle_edge]
(21310,5162,1,1,-1,5081),-- [rp_comp_spiritshot_s]
(21310,57,5625,11517,0,700000),-- [adena]
(21310,11957,1,1,1,193.68117),-- [tallum_blade_low]
(21310,5548,1,1,1,2393.667745),-- [tallum_blade_edge]
(21310,11952,1,1,1,193.68117),-- [elemental_sword_low]
(21310,5547,1,1,1,2393.667745),-- [elemental_sword_edge]
(21310,11954,1,1,1,193.68117),-- [inferno_master_low]
(21310,8331,1,1,1,2400.621),-- [inferno_master_blade]
(21310,1868,3,9,2,156344.773849),-- [thread]
(21310,1873,1,1,2,187613.551436),-- [silver_nugget]
(21310,5549,1,1,2,46903.387859),-- [iron_thread]
(21310,1889,1,1,2,31268.777587),-- [compound_braid]
(21310,4044,1,1,2,15634.610272),-- [thons]
(21310,5157,1,1,2,208.632747),-- [rp_comp_soulshot_s]
(21310,8732,1,1,2,3908.652568),-- [general_75_s]
(21310,8742,1,1,2,977.163142),-- [special_75_s]
(21310,8752,1,1,2,97.45054),-- [rare_75_s]
(21311,5549,1,3,-1,527054),-- [iron_thread]
(21311,5546,1,1,-1,31765),-- [sword_of_miracle_edge]
(21311,5162,1,1,-1,4685),-- [rp_comp_spiritshot_s]
(21311,57,5186,10619,0,700000),-- [adena]
(21311,11957,1,1,1,178.57359),-- [tallum_blade_low]
(21311,5548,1,1,1,2206.956115),-- [tallum_blade_edge]
(21311,11952,1,1,1,178.57359),-- [elemental_sword_low]
(21311,5547,1,1,1,2206.956115),-- [elemental_sword_edge]
(21311,11954,1,1,1,178.57359),-- [inferno_master_low]
(21311,8331,1,1,1,2213.367),-- [inferno_master_blade]
(21311,1868,3,9,2,144151.521327),-- [thread]
(21311,1873,1,1,2,172981.662228),-- [silver_nugget]
(21311,5549,1,1,2,43245.415557),-- [iron_thread]
(21311,1889,1,1,2,28830.140901),-- [compound_braid]
(21311,4044,1,1,2,14415.274656),-- [thons]
(21311,5157,1,1,2,192.361581),-- [rp_comp_soulshot_s]
(21311,8732,1,1,2,3603.818664),-- [general_75_s]
(21311,8742,1,1,2,900.954666),-- [special_75_s]
(21311,8752,1,1,2,89.85042),-- [rare_75_s]
(21312,5448,1,1,-1,4041),-- [rp_soul_separator_i]
(21312,6341,1,1,-1,301763),-- [sealed_phoenix's_earing_gemstone]
(21312,729,1,1,-1,1212),-- [scrl_of_ench_wp_a]
(21312,57,5384,10974,0,700000),-- [adena]
(21312,11955,1,1,1,554.484966),-- [carnium_bow_low]
(21312,5535,1,1,1,6872.515034),-- [carnium_bow_shaft]
(21312,1866,1,3,2,89519.913234),-- [suede]
(21312,1871,1,3,2,201419.281158),-- [charcoal]
(21312,5220,1,1,2,16113.48664),-- [reinforcing_agent]
(21312,1885,1,1,2,33569.880193),-- [high_grade_suede]
(21312,4041,1,1,2,3503.007765),-- [mold_hardener]
(21312,1808,1,1,2,179.077527),-- [rp_soulshot_s]
(21312,8731,1,1,2,3729.909115),-- [general_70_a]
(21312,8741,1,1,2,932.390009),-- [special_70_a]
(21312,8751,1,1,2,93.204093),-- [rare_70_a]
(21312,8761,1,1,2,18.850266),-- [unique_70_a]
(21313,730,1,1,-1,8658),-- [scrl_of_ench_am_a]
(21313,1895,1,7,-1,742151),-- [metallic_fiber]
(21313,4042,1,1,-1,173169),-- [enria]
(21313,57,5124,10462,0,700000),-- [adena]
(21313,11955,1,1,1,528.056034),-- [carnium_bow_low]
(21313,5535,1,1,1,6544.943966),-- [carnium_bow_shaft]
(21313,1873,1,1,2,139503.67112),-- [silver_nugget]
(21313,1868,3,9,2,116253.42432),-- [thread]
(21313,1876,1,1,2,69752.054592),-- [mithril_ore]
(21313,1895,1,1,2,99645.541952),-- [metallic_fiber]
(21313,4042,1,1,2,5812.671216),-- [enria]
(21313,5272,1,1,2,155.074656),-- [rp_adv_comp_soulshot_s]
(21313,5380,1,1,2,1981.801536),-- [rp_sealed_boots_of_nightmare_i]
(21313,8730,1,1,2,3875.114144),-- [general_67_a]
(21313,8740,1,1,2,968.559504),-- [special_67_a]
(21313,8750,1,1,2,96.812144),-- [rare_67_a]
(21313,8760,1,1,2,19.274816),-- [unique_67_a]
(21314,6335,1,1,-1,22347),-- [rp_sealed_majestic_necklace_i]
(21314,6341,1,1,-1,160703),-- [sealed_phoenix's_earing_gemstone]
(21314,730,1,1,-1,4842),-- [scrl_of_ench_am_a]
(21314,57,2869,5842,0,700000),-- [adena]
(21314,11950,1,1,1,295.329762),-- [blood_tornado_low]
(21314,5539,1,1,1,3617.670238),-- [blood_tornado_edge]
(21314,1895,1,1,2,68105.16775),-- [metallic_fiber]
(21314,4040,1,1,2,4767.339812),-- [mold_lubricant]
(21314,4042,1,1,2,3972.841658),-- [enria]
(21314,4043,1,1,2,7945.595594),-- [asofe]
(21314,5272,1,1,2,105.968176),-- [rp_adv_comp_soulshot_s]
(21314,8731,1,1,2,2207.08552),-- [general_70_a]
(21314,8741,1,1,2,551.77138),-- [special_70_a]
(21314,8751,1,1,2,55.177138),-- [rare_70_a]
(21314,8761,1,1,2,11.052972),-- [unique_70_a]
(21315,5549,1,1,-1,605496),-- [iron_thread]
(21315,1889,1,1,-1,403664),-- [compound_braid]
(21315,6343,1,1,-1,129462),-- [sealed_phoenix's_necklace_beads]
(21315,57,2990,6088,0,700000),-- [adena]
(21315,11955,1,1,1,307.740276),-- [carnium_bow_low]
(21315,5535,1,1,1,3814.259724),-- [carnium_bow_shaft]
(21315,1868,1,3,2,203243.393899),-- [thread]
(21315,1873,1,1,2,81297.275085),-- [silver_nugget]
(21315,5549,1,1,2,20324.215678),-- [iron_thread]
(21315,1889,1,1,2,13549.752034),-- [compound_braid]
(21315,4044,1,1,2,6774.876017),-- [thons]
(21315,5277,1,1,2,90.309687),-- [rp_adv_comp_spiritshot_s]
(21315,8731,1,1,2,1882.070372),-- [general_70_a]
(21315,8741,1,1,2,470.517593),-- [special_70_a]
(21315,8751,1,1,2,47.010522),-- [rare_70_a]
(21315,8761,1,1,2,9.484579),-- [unique_70_a]
(21315,1344,30,90,2,84684.094534),-- [mithril_arrow]
(21316,5550,1,1,-1,84418),-- [reinforcing_plate]
(21316,4043,1,1,-1,211044),-- [asofe]
(21316,6343,1,1,-1,135372),-- [sealed_phoenix's_necklace_beads]
(21316,57,3124,6369,0,700000),-- [adena]
(21316,11951,1,1,1,321.814542),-- [bloody_orchid_low]
(21316,5536,1,1,1,3977.185458),-- [bloody_orchid_head]
(21316,1869,2,6,2,53130.004037),-- [iron_ore]
(21316,1864,1,3,2,212520.016148),-- [stem]
(21316,1880,1,1,2,21252.156808),-- [steel]
(21316,5550,1,1,2,2833.439849),-- [reinforcing_plate]
(21316,4043,1,1,2,7084.181597),-- [asofe]
(21316,3036,1,1,2,94.279869),-- [rp_spiritshot_s]
(21316,8731,1,1,2,1967.849776),-- [general_70_a]
(21316,8741,1,1,2,491.962444),-- [special_70_a]
(21316,8751,1,1,2,49.273841),-- [rare_70_a]
(21316,8761,1,1,2,9.699575),-- [unique_70_a]
(21316,1344,30,90,2,88550.136056),-- [mithril_arrow]
(21317,5450,1,1,-1,2216),-- [rp_dragon_grinder_i]
(21317,6345,1,1,-1,228933),-- [sealed_phoenix's_ring_gemstone]
(21317,5456,1,1,-1,2216),-- [rp_tallum_glaive_i]
(21317,57,2953,6019,0,700000),-- [adena]
(21317,11950,1,1,1,304.16022),-- [blood_tornado_low]
(21317,5539,1,1,1,3725.83978),-- [blood_tornado_edge]
(21317,1867,1,3,2,147305.746648),-- [animal_skin]
(21317,1872,1,3,2,98203.93402),-- [animal_bone]
(21317,1882,1,1,2,49101.812628),-- [leather]
(21317,1894,1,1,2,7753.06404),-- [crafted_leather]
(21317,4042,1,1,2,3682.628228),-- [enria]
(21317,3957,1,1,2,98.186952),-- [rp_blessed_spiritshot_s]
(21317,8731,1,1,2,2045.870264),-- [general_70_a]
(21317,8741,1,1,2,511.621948),-- [special_70_a]
(21317,8751,1,1,2,51.254824),-- [rare_70_a]
(21317,8761,1,1,2,9.880448),-- [unique_70_a]
(21318,5478,1,1,-1,52600),-- [sealed_dark_crystal_leather_mail_pattern]
(21318,730,1,1,-1,5213),-- [scrl_of_ench_am_a]
(21318,5549,1,1,-1,625522),-- [iron_thread]
(21318,57,3087,6292,0,700000),-- [adena]
(21318,12224,1,1,1,1257.959332),-- [sealed_dark_crystal_boots_low]
(21318,5496,1,1,1,6769.040668),-- [sealed_dark_crystal_boots_lining]
(21318,12231,1,1,1,1257.959332),-- [sealed_tallum_boots_low]
(21318,5497,1,1,1,6769.040668),-- [sealed_tallum_boots_lining]
(21318,12221,1,1,1,1257.959332),-- [sealed_dark_crystal_gloves_low]
(21318,5508,1,1,1,6769.040668),-- [sealed_dark_crystal_gloves_design]
(21318,12229,1,1,1,1257.959332),-- [sealed_tallum_gloves_low]
(21318,5509,1,1,1,6769.040668),-- [sealed_tallum_gloves_design]
(21318,1868,1,3,2,209965.552356),-- [thread]
(21318,1873,1,1,2,83986.13574),-- [silver_nugget]
(21318,5549,1,1,2,20996.427432),-- [iron_thread]
(21318,1889,1,1,2,13997.902296),-- [compound_braid]
(21318,4044,1,1,2,6998.951148),-- [thons]
(21318,5157,1,1,2,93.296628),-- [rp_comp_soulshot_s]
(21318,8731,1,1,2,1944.318768),-- [general_70_a]
(21318,8741,1,1,2,486.079692),-- [special_70_a]
(21318,8751,1,1,2,48.565368),-- [rare_70_a]
(21318,8761,1,1,2,9.798276),-- [unique_70_a]
(21318,1344,30,90,2,87484.972296),-- [mithril_arrow]
(21319,5495,1,1,-1,107187),-- [sealed_shield_of_nightmare_fragment]
(21319,5157,1,1,-1,3137),-- [rp_comp_soulshot_s]
(21319,5502,1,1,-1,119216),-- [sealed_boots_of_nightmare_lining]
(21319,57,3482,7105,0,700000),-- [adena]
(21319,288,1,1,1,18.4851),-- [carnium_bow]
(21319,5535,1,1,1,4446.5149),-- [carnium_bow_shaft]
(21319,1869,2,6,2,59234.470779),-- [iron_ore]
(21319,1864,1,3,2,236937.883116),-- [stem]
(21319,1880,1,1,2,23693.961336),-- [steel]
(21319,5550,1,1,2,3158.992983),-- [reinforcing_plate]
(21319,4043,1,1,2,7898.131299),-- [asofe]
(21319,3036,1,1,2,105.112323),-- [rp_spiritshot_s]
(21319,8731,1,1,2,2193.949392),-- [general_70_a]
(21319,8741,1,1,2,548.487348),-- [special_70_a]
(21319,8751,1,1,2,54.935247),-- [rare_70_a]
(21319,8761,1,1,2,10.814025),-- [unique_70_a]
(21319,1344,30,90,2,98724.262152),-- [mithril_arrow]
(21320,4042,1,1,-1,107055),-- [enria]
(21320,1894,1,1,-1,225378),-- [crafted_leather]
(21320,5503,1,1,-1,108483),-- [sealed_magestic_boots_lining]
(21320,57,3168,6465,0,700000),-- [adena]
(21320,11951,1,1,1,326.455738),-- [bloody_orchid_low]
(21320,5536,1,1,1,4034.544262),-- [bloody_orchid_head]
(21320,1867,1,3,2,158111.176866),-- [animal_skin]
(21320,1872,1,3,2,105407.561715),-- [animal_bone]
(21320,1882,1,1,2,52703.615151),-- [leather]
(21320,1894,1,1,2,8321.78043),-- [crafted_leather]
(21320,4042,1,1,2,3952.762851),-- [enria]
(21320,3036,1,1,2,105.389334),-- [rp_spiritshot_s]
(21320,8731,1,1,2,2195.942538),-- [general_70_a]
(21320,8741,1,1,2,549.151341),-- [special_70_a]
(21320,8751,1,1,2,55.014558),-- [rare_70_a]
(21320,8761,1,1,2,10.605216),-- [unique_70_a]
(21321,1876,1,3,-1,559345),-- [mithril_ore]
(21321,1895,1,3,-1,799064),-- [metallic_fiber]
(21321,6346,1,1,-1,182108),-- [sealed_majestic_ring_gemstrone]
(21321,57,2752,5635,0,700000),-- [adena]
(21321,11950,1,1,1,284.310558),-- [blood_tornado_low]
(21321,5539,1,1,1,3482.689442),-- [blood_tornado_edge]
(21321,1873,1,1,2,91790.00814),-- [silver_nugget]
(21321,1868,1,3,2,229475.45944),-- [thread]
(21321,1876,1,1,2,45895.00407),-- [mithril_ore]
(21321,1895,1,1,2,65564.47971),-- [metallic_fiber]
(21321,4042,1,1,2,3824.4739),-- [enria]
(21321,5167,1,1,2,101.86888),-- [rp_comp_bspiritshot_s]
(21321,8732,1,1,2,1912.23695),-- [general_75_s]
(21321,8742,1,1,2,478.16901),-- [special_75_s]
(21321,8752,1,1,2,48.2999),-- [rare_75_s]
(21322,5272,1,1,-1,2486),-- [rp_adv_comp_soulshot_s]
(21322,5480,1,1,-1,25099),-- [sealed_leather_mail_of_nightmare_fabric]
(21322,5277,1,1,-1,2486),-- [rp_adv_comp_spiritshot_s]
(21322,57,2752,5635,0,700000),-- [adena]
(21322,11955,1,1,1,284.297664),-- [carnium_bow_low]
(21322,5535,1,1,1,3523.702336),-- [carnium_bow_shaft]
(21322,1871,1,1,2,206527.465476),-- [charcoal]
(21322,1866,1,1,2,137684.976984),-- [suede]
(21322,1877,1,1,2,8260.883122),-- [admantite_nugget]
(21322,4041,1,1,2,1795.971922),-- [mold_hardener]
(21322,4040,1,1,2,4130.686444),-- [mold_lubricant]
(21322,5272,1,1,2,91.586242),-- [rp_adv_comp_soulshot_s]
(21322,8732,1,1,2,1721.037724),-- [general_75_s]
(21322,8742,1,1,2,430.504314),-- [special_75_s]
(21322,8752,1,1,2,43.099408),-- [rare_75_s]
(21322,1344,20,60,2,129079.788364),-- [mithril_arrow]
(21323,5481,1,1,-1,24797),-- [sealed_majestic_leather_mail_fabric]
(21323,4042,1,1,-1,92103),-- [enria]
(21323,1894,1,1,-1,193902),-- [crafted_leather]
(21323,57,2719,5567,0,700000),-- [adena]
(21323,11951,1,1,1,280.867216),-- [bloody_orchid_low]
(21323,5536,1,1,1,3471.132784),-- [bloody_orchid_head]
(21323,1867,1,3,2,151144.346532),-- [animal_skin]
(21323,1872,1,3,2,100762.897688),-- [animal_bone]
(21323,1882,1,1,2,50381.448844),-- [leather]
(21323,1894,1,1,2,7955.082224),-- [crafted_leather]
(21323,4042,1,1,2,3778.759016),-- [enria]
(21323,5277,1,1,2,100.657176),-- [rp_adv_comp_spiritshot_s]
(21323,8732,1,1,2,1889.379508),-- [general_75_s]
(21323,8742,1,1,2,472.265744),-- [special_75_s]
(21323,8752,1,1,2,47.163268),-- [rare_75_s]
(21324,4042,1,1,-1,88264),-- [enria]
(21324,5502,1,1,-1,89441),-- [sealed_boots_of_nightmare_lining]
(21324,1808,1,1,-1,2354),-- [rp_soulshot_s]
(21324,57,2610,5333,0,700000),-- [adena]
(21324,11957,1,1,1,89.72307),-- [tallum_blade_low]
(21324,5548,1,1,1,1108.869895),-- [tallum_blade_edge]
(21324,11952,1,1,1,89.72307),-- [elemental_sword_low]
(21324,5547,1,1,1,1108.869895),-- [elemental_sword_edge]
(21324,11954,1,1,1,89.72307),-- [inferno_master_low]
(21324,8331,1,1,1,1112.091),-- [inferno_master_blade]
(21324,1873,1,1,2,78215.208955),-- [silver_nugget]
(21324,1868,1,3,2,195538.250201),-- [thread]
(21324,1876,1,1,2,39107.832291),-- [mithril_ore]
(21324,1895,1,1,2,55868.071486),-- [metallic_fiber]
(21324,4042,1,1,2,3259.099931),-- [enria]
(21324,1808,1,1,2,87.024757),-- [rp_soulshot_s]
(21324,8732,1,1,2,1629.322152),-- [general_75_s]
(21324,8742,1,1,2,407.330538),-- [special_75_s]
(21324,8752,1,1,2,40.550803),-- [rare_75_s]
(21324,1344,30,90,2,81474.308886),-- [mithril_arrow]
(21325,5503,1,1,-1,86488),-- [sealed_magestic_boots_lining]
(21325,3036,1,1,-1,2276),-- [rp_spiritshot_s]
(21325,5514,1,1,-1,86488),-- [sealed_gloves_of_nightmare_design]
(21325,57,2524,5157,0,700000),-- [adena]
(21325,11946,1,1,1,65.068015),-- [dasparion's_staff_low]
(21325,5543,1,1,1,804.57276),-- [dasparion's_staff_head]
(21325,11949,1,1,1,65.068015),-- [meteor_shower_low]
(21325,5532,1,1,1,797.058135),-- [meteor_shower_head]
(21325,11953,1,1,1,65.068015),-- [eye_of_soul_low]
(21325,8341,1,1,1,796.03891),-- [eye_of_soul_piece]
(21325,11958,1,1,1,65.068015),-- [hammer_of_destroyer_low]
(21325,8346,1,1,1,797.058135),-- [hammer_of_destroyer_piece]
(21325,1894,1,1,2,8292.958982),-- [crafted_leather]
(21325,4039,1,1,2,7878.285184),-- [mold_glue]
(21325,4041,1,1,2,2055.217318),-- [mold_hardener]
(21325,4044,1,1,2,7878.285184),-- [thons]
(21325,3036,1,1,2,105.032697),-- [rp_spiritshot_s]
(21325,8732,1,1,2,1969.571296),-- [general_75_s]
(21325,8742,1,1,2,492.392824),-- [special_75_s]
(21325,8752,1,1,2,49.256515),-- [rare_75_s]
(21326,1877,1,1,-1,204838),-- [admantite_nugget]
(21326,4041,1,1,-1,44530),-- [mold_hardener]
(21326,5515,1,1,-1,86488),-- [sealed_magestic_gloves_design]
(21326,57,2524,5157,0,700000),-- [adena]
(21326,11950,1,1,1,260.234352),-- [blood_tornado_low]
(21326,5539,1,1,1,3187.765648),-- [blood_tornado_edge]
(21326,1871,1,1,2,189081.472284),-- [charcoal]
(21326,1866,1,1,2,126054.314856),-- [suede]
(21326,1877,1,1,2,7563.061598),-- [admantite_nugget]
(21326,4041,1,1,2,1644.260798),-- [mold_hardener]
(21326,4040,1,1,2,3781.754996),-- [mold_lubricant]
(21326,3957,1,1,2,83.849678),-- [rp_blessed_spiritshot_s]
(21326,8732,1,1,2,1575.656516),-- [general_75_s]
(21326,8742,1,1,2,394.138326),-- [special_75_s]
(21326,8752,1,1,2,39.458672),-- [rare_75_s]
(21326,1344,20,60,2,118176.032276),-- [mithril_arrow]
(21327,4039,1,1,-1,194325),-- [mold_glue]
(21327,5533,1,1,-1,15991),-- [elysian_head]
(21327,5272,1,1,-1,2591),-- [rp_adv_comp_soulshot_s]
(21327,57,2875,5868,0,700000),-- [adena]
(21327,11957,1,1,1,98.77266),-- [tallum_blade_low]
(21327,5548,1,1,1,1220.71201),-- [tallum_blade_edge]
(21327,11952,1,1,1,98.77266),-- [elemental_sword_low]
(21327,5547,1,1,1,1220.71201),-- [elemental_sword_edge]
(21327,11954,1,1,1,98.77266),-- [inferno_master_low]
(21327,8331,1,1,1,1224.258),-- [inferno_master_blade]
(21327,1894,1,1,2,9440.997174),-- [crafted_leather]
(21327,4039,1,1,2,8968.917888),-- [mold_glue]
(21327,4041,1,1,2,2339.731926),-- [mold_hardener]
(21327,4044,1,1,2,8968.917888),-- [thons]
(21327,5277,1,1,2,119.572929),-- [rp_adv_comp_spiritshot_s]
(21327,8732,1,1,2,2242.229472),-- [general_75_s]
(21327,8742,1,1,2,560.557368),-- [special_75_s]
(21327,8752,1,1,2,56.075355),-- [rare_75_s]
(21328,5534,1,1,-1,15343),-- [soul_bow_shaft]
(21328,5277,1,1,-1,2484),-- [rp_adv_comp_spiritshot_s]
(21328,5537,1,1,-1,15333),-- [soul_separator_head]
(21328,57,2756,5626,0,700000),-- [adena]
(21328,11946,1,1,1,71.019243),-- [dasparion's_staff_low]
(21328,5543,1,1,1,878.160312),-- [dasparion's_staff_head]
(21328,11949,1,1,1,71.019243),-- [meteor_shower_low]
(21328,5532,1,1,1,869.958387),-- [meteor_shower_head]
(21328,11953,1,1,1,71.019243),-- [eye_of_soul_low]
(21328,8341,1,1,1,868.845942),-- [eye_of_soul_piece]
(21328,11958,1,1,1,71.019243),-- [hammer_of_destroyer_low]
(21328,8346,1,1,1,869.958387),-- [hammer_of_destroyer_piece]
(21328,1873,1,1,2,75038.645032),-- [silver_nugget]
(21328,1868,1,3,2,187596.61258),-- [thread]
(21328,1876,1,1,2,37519.322516),-- [mithril_ore]
(21328,1895,1,1,2,53598.966742),-- [metallic_fiber]
(21328,4042,1,1,2,3126.533882),-- [enria]
(21328,5282,1,1,2,83.349812),-- [rp_adv_comp_bspiritshot_s]
(21328,6671,1,1,2,20843.864524),-- [key_of_treasure_box7]
(21328,8732,1,1,2,1563.495924),-- [general_75_s]
(21328,8742,1,1,2,390.644998),-- [special_75_s]
(21328,8752,1,1,2,38.92711),-- [rare_75_s]
(21328,1344,30,90,2,78165.63688),-- [mithril_arrow]
(21329,5162,1,1,-1,2526),-- [rp_comp_spiritshot_s]
(21329,5487,1,1,-1,25594),-- [sealed_robe_of_nightmare_fabric]
(21329,5167,1,1,-1,2526),-- [rp_comp_bspiritshot_s]
(21329,57,2802,5719,0,700000),-- [adena]
(21329,81,1,1,1,3.372642),-- [dragon_slayer]
(21329,5529,1,1,1,959.166264),-- [dragon_slayer_edge]
(21329,151,1,1,1,3.372642),-- [sword_of_miracle]
(21329,5546,1,1,1,1053.552528),-- [sword_of_miracle_edge]
(21329,2500,1,1,1,3.372642),-- [dark_legion's_edge]
(21329,5545,1,1,1,959.163282),-- [dark_legion's_edge_edge]
(21329,1866,1,1,2,155449.41438),-- [suede]
(21329,1871,1,1,2,233173.91058),-- [charcoal]
(21329,5220,1,1,2,9327.02394),-- [reinforcing_agent]
(21329,1885,1,1,2,19431.33504),-- [high_grade_suede]
(21329,4041,1,1,2,2027.6139),-- [mold_hardener]
(21329,960,1,1,2,93.25758),-- [scrl_of_ench_am_s]
(21329,8732,1,1,2,1943.2179),-- [general_75_s]
(21329,8742,1,1,2,485.69898),-- [special_75_s]
(21329,8752,1,1,2,48.5277),-- [rare_75_s]
(21330,5488,1,1,-1,24396),-- [sealed_majestic_robe_fabric]
(21330,1885,1,1,-1,451470),-- [high_grade_suede]
(21330,4041,1,1,-1,47110),-- [mold_hardener]
(21330,57,2671,5451,0,700000),-- [adena]
(21330,11974,1,1,1,44.44532),-- [elysian_low]
(21330,5533,1,1,1,685.75908),-- [elysian_head]
(21330,11970,1,1,1,44.44532),-- [worldtree's_branch_low]
(21330,5544,1,1,1,685.08164),-- [worldtree's_branch_head]
(21330,11969,1,1,1,44.44532),-- [dragon_flame_head_low]
(21330,8342,1,1,1,685.75908),-- [dragon_flame_head_piece]
(21330,11966,1,1,1,44.44532),-- [doom_crusher_low]
(21330,8349,1,1,1,685.61892),-- [doom_crusher_head]
(21330,1866,1,1,2,133357.154112),-- [suede]
(21330,1871,1,1,2,200036.2182),-- [charcoal]
(21330,5220,1,1,2,8001.448728),-- [reinforcing_agent]
(21330,1885,1,1,2,16669.644264),-- [high_grade_suede]
(21330,4041,1,1,2,1739.678304),-- [mold_hardener]
(21330,960,1,1,2,79.873248),-- [scrl_of_ench_am_s]
(21330,8732,1,1,2,1667.110536),-- [general_75_s]
(21330,8742,1,1,2,416.899392),-- [special_75_s]
(21330,8752,1,1,2,41.884752),-- [rare_75_s]
(21330,1344,20,60,2,125022.088464),-- [mithril_arrow]
(21331,5546,1,1,-1,16041),-- [sword_of_miracle_edge]
(21331,1895,1,3,-1,760448),-- [metallic_fiber]
(21331,4042,1,1,-1,88719),-- [enria]
(21331,57,2624,5357,0,700000),-- [adena]
(21331,11968,1,1,1,58.230161),-- [dragon_slayer_low]
(21331,5529,1,1,1,898.627587),-- [dragon_slayer_edge]
(21331,11971,1,1,1,58.230161),-- [sword_of_miracle_low]
(21331,5546,1,1,1,987.054343),-- [sword_of_miracle_edge]
(21331,11964,1,1,1,58.230161),-- [dark_legion's_edge_low]
(21331,5545,1,1,1,898.627587),-- [dark_legion's_edge_edge]
(21331,1873,1,1,2,78618.622292),-- [silver_nugget]
(21331,1868,1,3,2,196547.013699),-- [thread]
(21331,1876,1,1,2,39309.311146),-- [mithril_ore]
(21331,1895,1,1,2,56156.15878),-- [metallic_fiber]
(21331,4042,1,1,2,3275.852257),-- [enria]
(21331,960,1,1,2,78.770668),-- [scrl_of_ench_am_s]
(21331,8732,1,1,2,1637.697144),-- [general_75_s]
(21331,8742,1,1,2,409.424286),-- [special_75_s]
(21331,8752,1,1,2,40.759241),-- [rare_75_s]
(21331,1344,30,90,2,81895.390487),-- [mithril_arrow]
(21332,6342,1,1,-1,135049),-- [sealed_majestic_earing_gemstone]
(21332,5282,1,1,-1,2650),-- [rp_adv_comp_bspiritshot_s]
(21332,6344,1,1,-1,87397),-- [sealed_majestic_necklace_beads]
(21332,57,2939,6000,0,700000),-- [adena]
(21332,11974,1,1,1,48.920294),-- [elysian_low]
(21332,5533,1,1,1,754.804686),-- [elysian_head]
(21332,11970,1,1,1,48.920294),-- [worldtree's_branch_low]
(21332,5544,1,1,1,754.059038),-- [worldtree's_branch_head]
(21332,11969,1,1,1,48.920294),-- [dragon_flame_head_low]
(21332,8342,1,1,1,754.804686),-- [dragon_flame_head_piece]
(21332,11966,1,1,1,48.920294),-- [doom_crusher_low]
(21332,8349,1,1,1,754.650414),-- [doom_crusher_head]
(21332,1894,1,1,2,9654.742156),-- [crafted_leather]
(21332,4039,1,1,2,9171.98172),-- [mold_glue]
(21332,4041,1,1,2,2392.706822),-- [mold_hardener]
(21332,4044,1,1,2,9171.98172),-- [thons]
(21332,959,1,1,2,10.99758),-- [scrl_of_ench_wp_s]
(21332,8732,1,1,2,2292.99543),-- [general_75_s]
(21332,8742,1,1,2,573.240526),-- [special_75_s]
(21332,8752,1,1,2,57.354046),-- [rare_75_s]
(21333,1808,1,1,-1,2541),-- [rp_soulshot_s]
(21333,5503,1,1,-1,96563),-- [sealed_magestic_boots_lining]
(21333,3036,1,1,-1,2541),-- [rp_spiritshot_s]
(21333,57,2813,5760,0,700000),-- [adena]
(21333,11974,1,1,1,46.911122),-- [elysian_low]
(21333,5533,1,1,1,723.804618),-- [elysian_head]
(21333,11970,1,1,1,46.911122),-- [worldtree's_branch_low]
(21333,5544,1,1,1,723.089594),-- [worldtree's_branch_head]
(21333,11969,1,1,1,46.911122),-- [dragon_flame_head_low]
(21333,8342,1,1,1,723.804618),-- [dragon_flame_head_piece]
(21333,11966,1,1,1,46.911122),-- [doom_crusher_low]
(21333,8349,1,1,1,723.656682),-- [doom_crusher_head]
(21333,1864,4,12,2,58640.930296),-- [stem]
(21333,1865,2,6,2,46912.667373),-- [varnish]
(21333,1866,3,9,2,26062.592985),-- [suede]
(21333,1873,1,1,2,93825.334746),-- [silver_nugget]
(21333,1868,1,3,2,156375.55791),-- [thread]
(21333,959,1,1,2,9.223656),-- [scrl_of_ench_wp_s]
(21333,8732,1,1,2,1954.646434),-- [general_75_s]
(21333,8742,1,1,2,488.853768),-- [special_75_s]
(21333,8752,1,1,2,49.192832),-- [rare_75_s]
(21334,5514,1,1,-1,130657),-- [sealed_gloves_of_nightmare_design]
(21334,5480,1,1,-1,34714),-- [sealed_leather_mail_of_nightmare_fabric]
(21334,57,3806,7794,0,700000),-- [adena]
(21334,11967,1,1,1,253.876257),-- [dragon_grinder_low]
(21334,5538,1,1,1,3917.123743),-- [dragon_grinder_edge]
(21334,1869,2,6,2,51935.313846),-- [iron_ore]
(21334,1870,3,9,2,43279.240698),-- [coal]
(21334,1871,3,9,2,37096.759894),-- [charcoal]
(21334,1872,8,24,2,21639.807856),-- [animal_bone]
(21334,1867,1,3,2,115411.683542),-- [animal_skin]
(21334,960,1,1,2,103.878878),-- [scrl_of_ench_am_s]
(21334,6672,1,1,2,21639.807856),-- [key_of_treasure_box8]
(21334,8732,1,1,2,2163.83078),-- [general_75_s]
(21334,8742,1,1,2,541.145202),-- [special_75_s]
(21334,8752,1,1,2,54.002016),-- [rare_75_s]
(21334,1344,40,120,2,81148.529432),-- [mithril_arrow]
(21335,1889,1,1,-1,368264),-- [compound_braid]
(21335,5495,1,1,-1,83881),-- [sealed_shield_of_nightmare_fragment]
(21335,5272,1,1,-1,2455),-- [rp_adv_comp_soulshot_s]
(21335,57,2718,5566,0,700000),-- [adena]
(21335,11976,1,1,1,181.297662),-- [tallum_glaive_low]
(21335,5541,1,1,1,2796.702338),-- [tallum_glaive_edge]
(21335,1868,1,3,2,226624.563792),-- [thread]
(21335,1873,1,1,2,90649.89852),-- [silver_nugget]
(21335,5549,1,1,2,22662.383376),-- [iron_thread]
(21335,1889,1,1,2,15108.377256),-- [compound_braid]
(21335,4044,1,1,2,7554.00612),-- [thons]
(21335,959,1,1,2,9.1254),-- [scrl_of_ench_wp_s]
(21335,8732,1,1,2,1888.592784),-- [general_75_s]
(21335,8742,1,1,2,471.965688),-- [special_75_s]
(21335,8752,1,1,2,47.087064),-- [rare_75_s]
(21336,5502,1,1,-1,109688),-- [sealed_boots_of_nightmare_lining]
(21336,5277,1,1,-1,2887),-- [rp_adv_comp_spiritshot_s]
(21336,5503,1,1,-1,109688),-- [sealed_magestic_boots_lining]
(21336,57,3195,6545,0,700000),-- [adena]
(21336,12265,1,1,1,334.9159),-- [sealed_leather_mail_of_nightmare_low]
(21336,5480,1,1,1,2690.0841),-- [sealed_leather_mail_of_nightmare_fabric]
(21336,12258,1,1,1,334.9159),-- [sealed_majestic_leather_mail_low]
(21336,5481,1,1,1,2690.0841),-- [sealed_majestic_leather_mail_fabric]
(21336,1864,5,15,2,47960.470096),-- [stem]
(21336,1865,3,9,2,39966.910368),-- [varnish]
(21336,1866,3,9,2,22838.361392),-- [suede]
(21336,1873,1,1,2,95920.496056),-- [silver_nugget]
(21336,1868,1,3,2,159867.641472),-- [thread]
(21336,960,1,1,2,95.933376),-- [scrl_of_ench_am_s]
(21336,8732,1,1,2,1998.167864),-- [general_75_s]
(21336,8742,1,1,2,499.653),-- [special_75_s]
(21336,8752,1,1,2,49.743232),-- [rare_75_s]
(21336,1344,40,120,2,74938.623144),-- [mithril_arrow]
(21337,959,1,1,-1,241),-- [scrl_of_ench_wp_s]
(21337,5220,1,1,-1,240694),-- [reinforcing_agent]
(21337,1885,1,1,-1,501446),-- [high_grade_suede]
(21337,57,2968,6057,0,700000),-- [adena]
(21337,12266,1,1,1,310.299632),-- [sealed_robe_of_nightmare_low]
(21337,5487,1,1,1,2501.200368),-- [sealed_robe_of_nightmare_fabric]
(21337,12259,1,1,1,310.299632),-- [sealed_majestic_robe_low]
(21337,5488,1,1,1,2501.200368),-- [sealed_majestic_robe_fabric]
(21337,1866,1,1,2,164577.34818),-- [suede]
(21337,1871,1,1,2,246866.02227),-- [charcoal]
(21337,5220,1,1,2,9874.53369),-- [reinforcing_agent]
(21337,1885,1,1,2,20572.28019),-- [high_grade_suede]
(21337,4041,1,1,2,2146.69602),-- [mold_hardener]
(21337,959,1,1,2,9.82674),-- [scrl_of_ench_wp_s]
(21337,8732,1,1,2,2057.36202),-- [general_75_s]
(21337,8742,1,1,2,514.11717),-- [special_75_s]
(21337,8752,1,1,2,51.81372),-- [rare_75_s]
(21338,6688,1,1,-1,17114),-- [forgotten_blade_edge]
(21338,6689,1,1,-1,16792),-- [basalt_battlehammer_head]
(21338,6690,1,1,-1,17147),-- [piece_of_imperial_staff]
(21338,57,3905,7970,0,700000),-- [adena]
(21338,12352,1,1,1,1198.670013),-- [sealed_majestic_earing_low]
(21338,6342,1,1,1,11037.681897),-- [sealed_majestic_earing_gemstone]
(21338,12350,1,1,1,899.846697),-- [sealed_majestic_necklace_low]
(21338,6344,1,1,1,7142.962365),-- [sealed_majestic_necklace_beads]
(21338,12351,1,1,1,1797.986049),-- [sealed_majestic_ring_low]
(21338,6346,1,1,1,15863.852979),-- [sealed_majestic_ring_gemstrone]
(21338,1869,2,6,2,73088.61518),-- [iron_ore]
(21338,1864,5,15,2,58470.892144),-- [stem]
(21338,1880,1,1,2,29235.446072),-- [steel]
(21338,5550,1,1,2,3897.979616),-- [reinforcing_plate]
(21338,4043,1,1,2,9745.248516),-- [asofe]
(21338,960,1,1,2,116.79564),-- [scrl_of_ench_am_s]
(21338,8732,1,1,2,2436.23726),-- [general_75_s]
(21338,8742,1,1,2,609.134184),-- [special_75_s]
(21338,8752,1,1,2,60.793628),-- [rare_75_s]
(21338,1344,30,90,2,121814.85776),-- [mithril_arrow]
(21339,6691,1,1,-1,13041),-- [angel_slayer_blade]
(21339,6693,1,1,-1,13277),-- [dragon_hunter_axe_blade]
(21339,6694,1,1,-1,13277),-- [saint_spear_blade]
(21339,57,2975,6071,0,700000),-- [adena]
(21339,11973,1,1,1,198.025424),-- [soul_separator_low]
(21339,5537,1,1,1,3055.974576),-- [soul_separator_head]
(21339,1867,1,3,2,148511.48214),-- [animal_skin]
(21339,1872,1,3,2,99007.65476),-- [animal_bone]
(21339,1882,1,1,2,49503.82738),-- [leather]
(21339,1894,1,1,2,7816.473928),-- [crafted_leather]
(21339,4042,1,1,2,3712.977365),-- [enria]
(21339,960,1,1,2,89.065782),-- [scrl_of_ench_am_s]
(21339,8732,1,1,2,1856.298371),-- [general_75_s]
(21339,8742,1,1,2,463.979437),-- [special_75_s]
(21339,8752,1,1,2,46.436006),-- [rare_75_s]
(21339,1344,40,120,2,69614.804831),-- [mithril_arrow]
(21340,960,1,1,-1,2413),-- [scrl_of_ench_am_s]
(21340,5549,1,1,-1,603328),-- [iron_thread]
(21340,1889,1,1,-1,402219),-- [compound_braid]
(21340,57,2975,6071,0,700000),-- [adena]
(21340,12268,1,1,1,963.126999),-- [sealed_shield_of_nightmare_low]
(21340,5495,1,1,1,5637.953658),-- [sealed_shield_of_nightmare_fragment]
(21340,12269,1,1,1,673.837215),-- [sealed_helm_of_nightmare_low]
(21340,5527,1,1,1,4439.114043),-- [sealed_helm_of_nightmare_design]
(21340,12261,1,1,1,673.837215),-- [sealed_magestic_circlet_low]
(21340,5528,1,1,1,4439.13087),-- [sealed_magestic_circlet_design]
(21340,1868,1,3,2,222767.500392),-- [thread]
(21340,1873,1,1,2,89107.151104),-- [silver_nugget]
(21340,5549,1,1,2,22276.787776),-- [iron_thread]
(21340,1889,1,1,2,14851.31764),-- [compound_braid]
(21340,4044,1,1,2,7425.470136),-- [thons]
(21340,959,1,1,2,9.056832),-- [scrl_of_ench_wp_s]
(21340,6672,1,1,2,18563.864024),-- [key_of_treasure_box8]
(21340,8732,1,1,2,1856.273192),-- [general_75_s]
(21340,8742,1,1,2,464.16264),-- [special_75_s]
(21340,8752,1,1,2,46.416264),-- [rare_75_s]
(21341,960,1,1,-1,2527),-- [scrl_of_ench_am_s]
(21341,4042,1,1,-1,105303),-- [enria]
(21341,1876,1,3,-1,631818),-- [mithril_ore]
(21341,57,3115,6359,0,700000),-- [adena]
(21341,11968,1,1,1,69.112648),-- [dragon_slayer_low]
(21341,5529,1,1,1,1066.569816),-- [dragon_slayer_edge]
(21341,11971,1,1,1,69.112648),-- [sword_of_miracle_low]
(21341,5546,1,1,1,1171.522424),-- [sword_of_miracle_edge]
(21341,11964,1,1,1,69.112648),-- [dark_legion's_edge_low]
(21341,5545,1,1,1,1066.569816),-- [dark_legion's_edge_edge]
(21341,1873,1,1,2,103682.999625),-- [silver_nugget]
(21341,1868,1,3,2,259207.251125),-- [thread]
(21341,1876,1,1,2,51841.251875),-- [mithril_ore]
(21341,1895,1,1,2,74058.93125),-- [metallic_fiber]
(21341,4042,1,1,2,4320.063),-- [enria]
(21341,959,1,1,2,10.413375),-- [scrl_of_ench_wp_s]
(21341,8732,1,1,2,2160.0315),-- [general_75_s]
(21341,8742,1,1,2,540.007875),-- [special_75_s]
(21341,8752,1,1,2,54.050375),-- [rare_75_s]
(21342,6707,1,1,-1,41193),-- [sealed_draconic_leather_armor_part]
(21342,6708,1,1,-1,118371),-- [sealed_draconic_leather_gloves_fabric]
(21342,6709,1,1,-1,118371),-- [sealed_draconic_leather_boots_design]
(21342,57,4098,8367,0,700000),-- [adena]
(21342,11974,1,1,1,68.220522),-- [elysian_low]
(21342,5533,1,1,1,1052.593218),-- [elysian_head]
(21342,11970,1,1,1,68.220522),-- [worldtree's_branch_low]
(21342,5544,1,1,1,1051.553394),-- [worldtree's_branch_head]
(21342,11969,1,1,1,68.220522),-- [dragon_flame_head_low]
(21342,8342,1,1,1,1052.593218),-- [dragon_flame_head_piece]
(21342,11966,1,1,1,68.220522),-- [doom_crusher_low]
(21342,8349,1,1,1,1052.378082),-- [doom_crusher_head]
(21342,1871,1,3,2,102323.189157),-- [charcoal]
(21342,1866,2,6,2,51161.779485),-- [suede]
(21342,1877,1,1,2,12278.901039),-- [admantite_nugget]
(21342,4041,1,1,2,2669.310234),-- [mold_hardener]
(21342,4040,1,1,2,6139.265613),-- [mold_lubricant]
(21342,960,1,1,2,122.777916),-- [scrl_of_ench_am_s]
(21342,8732,1,1,2,2557.996521),-- [general_75_s]
(21342,8742,1,1,2,639.406677),-- [special_75_s]
(21342,8752,1,1,2,63.977649),-- [rare_75_s]
(21342,1344,20,60,2,191856.395709),-- [mithril_arrow]
(21343,5515,1,1,-1,158740),-- [sealed_magestic_gloves_design]
(21343,3957,1,1,-1,4177),-- [rp_blessed_spiritshot_s]
(21343,5522,1,1,-1,32009),-- [sealed_armor_of_nightmare_pattern]
(21343,57,4624,9470,0,700000),-- [adena]
(21343,11975,1,1,1,308.463824),-- [soul_bow_low]
(21343,5534,1,1,1,4763.536176),-- [soul_bow_shaft]
(21343,1894,1,1,2,15221.15324),-- [crafted_leather]
(21343,4039,1,1,2,14460.0588),-- [mold_glue]
(21343,4041,1,1,2,3772.21438),-- [mold_hardener]
(21343,4044,1,1,2,14460.0588),-- [thons]
(21343,959,1,1,2,17.3382),-- [scrl_of_ench_wp_s]
(21343,8732,1,1,2,3615.0147),-- [general_75_s]
(21343,8742,1,1,2,903.74054),-- [special_75_s]
(21343,8752,1,1,2,90.42134),-- [rare_75_s]
(21344,6901,1,1,-1,6372),-- [rp_shining_arrow]
(21344,6346,1,1,-1,207463),-- [sealed_majestic_ring_gemstrone]
(21344,4040,1,1,-1,127444),-- [mold_lubricant]
(21344,57,3141,6413,0,700000),-- [adena]
(21344,11967,1,1,1,209.139012),-- [dragon_grinder_low]
(21344,5538,1,1,1,3226.860988),-- [dragon_grinder_edge]
(21344,1871,1,3,2,78427.328685),-- [charcoal]
(21344,1866,1,1,2,156855.058461),-- [suede]
(21344,1877,1,1,2,9411.199224),-- [admantite_nugget]
(21344,4041,1,1,2,2045.965191),-- [mold_hardener]
(21344,4040,1,1,2,4705.599612),-- [mold_lubricant]
(21344,960,1,1,2,94.256385),-- [scrl_of_ench_am_s]
(21344,8732,1,1,2,1960.532808),-- [general_75_s]
(21344,8742,1,1,2,490.133202),-- [special_75_s]
(21344,8752,1,1,2,48.933102),-- [rare_75_s]
(21344,1344,20,60,2,147051.99333),-- [mithril_arrow]
(21345,959,1,1,-1,284),-- [scrl_of_ench_wp_s]
(21345,1894,1,1,-1,249418),-- [crafted_leather]
(21345,4042,1,1,-1,118474),-- [enria]
(21345,57,3504,7154,0,700000),-- [adena]
(21345,11967,1,1,1,233.303211),-- [dragon_grinder_low]
(21345,5538,1,1,1,3599.696789),-- [dragon_grinder_edge]
(21345,1867,1,3,2,194418.10796),-- [animal_skin]
(21345,1872,1,3,2,129611.800614),-- [animal_bone]
(21345,1882,1,1,2,64805.900307),-- [leather]
(21345,1894,1,1,2,10232.553421),-- [crafted_leather]
(21345,4042,1,1,2,4860.452699),-- [enria]
(21345,959,1,1,2,11.804131),-- [scrl_of_ench_wp_s]
(21345,8732,1,1,2,2430.02283),-- [general_75_s]
(21345,8742,1,1,2,607.709227),-- [special_75_s]
(21345,8752,1,1,2,60.648811),-- [rare_75_s]
(21346,6695,1,1,-1,14972),-- [demon_splinter_blade]
(21346,6696,1,1,-1,15502),-- [heavens_divider_edge]
(21346,6697,1,1,-1,14972),-- [arcana_mace_head]
(21346,57,3481,7103,0,700000),-- [adena]
(21346,11976,1,1,1,231.705474),-- [tallum_glaive_low]
(21346,5541,1,1,1,3574.294526),-- [tallum_glaive_edge]
(21346,1864,5,15,2,52133.265108),-- [stem]
(21346,1865,3,9,2,43444.226664),-- [varnish]
(21346,1866,3,9,2,24825.410316),-- [suede]
(21346,1873,1,1,2,104266.047438),-- [silver_nugget]
(21346,1868,1,3,2,173776.906656),-- [thread]
(21346,960,1,1,2,104.280048),-- [scrl_of_ench_am_s]
(21346,8732,1,1,2,2172.018222),-- [general_75_s]
(21346,8742,1,1,2,543.12525),-- [special_75_s]
(21346,8752,1,1,2,54.071136),-- [rare_75_s]
(21346,1344,40,120,2,81458.649162),-- [mithril_arrow]
(21347,6710,1,1,-1,175170),-- [sealed_draconic_leather_helmet_pattern]
(21347,6711,1,1,-1,53504),-- [sealed_major_arcana_robe_part]
(21347,6712,1,1,-1,153746),-- [sealed_major_arcana_gloves_fabric]
(21347,57,5309,10884,0,700000),-- [adena]
(21347,12263,1,1,1,417.933875),-- [sealed_armor_of_nightmare_low]
(21347,5522,1,1,1,3394.566125),-- [sealed_armor_of_nightmare_pattern]
(21347,12262,1,1,1,417.933875),-- [sealed_majestic_platte_armor_low]
(21347,5523,1,1,1,3394.566125),-- [sealed_majestic_platte_armor_pattern]
(21347,1867,4,12,2,73834.843165),-- [animal_skin]
(21347,1872,1,3,2,196892.253465),-- [animal_bone]
(21347,1882,1,1,2,98446.325225),-- [leather]
(21347,1894,1,1,2,15543.947675),-- [crafted_leather]
(21347,4042,1,1,2,7383.524015),-- [enria]
(21347,960,1,1,2,177.05531),-- [scrl_of_ench_am_s]
(21347,8732,1,1,2,3691.563515),-- [general_75_s]
(21347,8742,1,1,2,922.990125),-- [special_75_s]
(21347,8752,1,1,2,92.497505),-- [rare_75_s]
(21348,6704,1,1,-1,105402),-- [sealed_imperial_crusader_boots_design]
(21348,6705,1,1,-1,103241),-- [sealed_imperial_crusader_shield_part]
(21348,6706,1,1,-1,120089),-- [sealed_imperial_crusader_helmet_pattern]
(21348,57,3643,7457,0,700000),-- [adena]
(21348,11973,1,1,1,242.937152),-- [soul_separator_low]
(21348,5537,1,1,1,3749.062848),-- [soul_separator_head]
(21348,1868,1,3,2,303709.211609),-- [thread]
(21348,1873,1,1,2,121483.586787),-- [silver_nugget]
(21348,5549,1,1,2,30370.774376),-- [iron_thread]
(21348,1889,1,1,2,20247.509106),-- [compound_braid]
(21348,4044,1,1,2,10123.754553),-- [thons]
(21348,960,1,1,2,121.342184),-- [scrl_of_ench_am_s]
(21348,8732,1,1,2,2531.060959),-- [general_75_s]
(21348,8742,1,1,2,632.642919),-- [special_75_s]
(21348,8752,1,1,2,63.117507),-- [rare_75_s]
(21349,959,1,1,-1,301),-- [scrl_of_ench_wp_s]
(21349,1875,1,1,-1,501199),-- [stone_of_purity]
(21349,4041,1,1,-1,65374),-- [mold_hardener]
(21349,57,3700,7573,0,700000),-- [adena]
(21349,11967,1,1,1,246.754818),-- [dragon_grinder_low]
(21349,5538,1,1,1,3807.245182),-- [dragon_grinder_edge]
(21349,1872,1,3,2,205620.13485),-- [animal_bone]
(21349,1867,1,3,2,137080.0899),-- [animal_skin]
(21349,1881,1,1,2,41124.02697),-- [coarse_bone_powder]
(21349,1875,1,1,2,20562.218664),-- [stone_of_purity]
(21349,4041,1,1,2,2682.099888),-- [mold_hardener]
(21349,959,1,1,2,12.31074),-- [scrl_of_ench_wp_s]
(21349,8732,1,1,2,2570.072154),-- [general_75_s]
(21349,8742,1,1,2,642.620628),-- [special_75_s]
(21349,8752,1,1,2,64.426206),-- [rare_75_s]
(21350,3957,1,1,-1,2627),-- [rp_blessed_spiritshot_s]
(21350,5522,1,1,-1,20132),-- [sealed_armor_of_nightmare_pattern]
(21350,5157,1,1,-1,2627),-- [rp_comp_soulshot_s]
(21350,57,2914,5954,0,700000),-- [adena]
(21350,11955,1,1,1,300.423792),-- [carnium_bow_low]
(21350,5535,1,1,1,3723.576208),-- [carnium_bow_shaft]
(21350,1865,1,3,2,121264.82544),-- [varnish]
(21350,1870,1,1,2,242529.65088),-- [coal]
(21350,1879,1,1,2,40421.75112),-- [cokes]
(21350,1875,1,1,2,16168.52928),-- [stone_of_purity]
(21350,4040,1,1,2,4850.4732),-- [mold_lubricant]
(21350,5157,1,1,2,107.83584),-- [rp_comp_soulshot_s]
(21350,8732,1,1,2,2021.06616),-- [general_75_s]
(21350,8742,1,1,2,505.37352),-- [special_75_s]
(21350,8752,1,1,2,50.49456),-- [rare_75_s]
(21351,5523,1,1,-1,17614),-- [sealed_majestic_platte_armor_pattern]
(21351,4041,1,1,-1,44975),-- [mold_hardener]
(21351,5220,1,1,-1,206884),-- [reinforcing_agent]
(21351,57,2549,5209,0,700000),-- [adena]
(21351,11951,1,1,1,262.826438),-- [bloody_orchid_low]
(21351,5536,1,1,1,3248.173562),-- [bloody_orchid_head]
(21351,1866,1,1,2,127313.079237),-- [suede]
(21351,1871,1,1,2,190969.851339),-- [charcoal]
(21351,5220,1,1,2,7638.942843),-- [reinforcing_agent]
(21351,1885,1,1,2,15913.960542),-- [high_grade_suede]
(21351,4041,1,1,2,1660.397157),-- [mold_hardener]
(21351,5162,1,1,2,85.088961),-- [rp_comp_spiritshot_s]
(21351,8732,1,1,2,1591.582041),-- [general_75_s]
(21351,8742,1,1,2,398.011752),-- [special_75_s]
(21351,8752,1,1,2,39.987162),-- [rare_75_s]
(21351,1344,20,60,2,119356.098966),-- [mithril_arrow]
(21352,5527,1,1,-1,37659),-- [sealed_helm_of_nightmare_design]
(21352,5162,1,1,-1,1400),-- [rp_comp_spiritshot_s]
(21352,5528,1,1,-1,37659),-- [sealed_magestic_circlet_design]
(21352,57,1553,3172,0,700000),-- [adena]
(21352,12222,1,1,1,281.550233),-- [sealed_dark_crystal_leather_mail_low]
(21352,5478,1,1,1,1630.049344),-- [sealed_dark_crystal_leather_mail_pattern]
(21352,12230,1,1,1,173.075412),-- [sealed_tallum_leather_mail_low]
(21352,5479,1,1,1,1147.014667),-- [sealed_tallum_leather_mail_pattern]
(21352,12228,1,1,1,450.806153),-- [sealed_legging_of_dark_crystal_low]
(21352,5482,1,1,1,2558.504191),-- [sealed_legging_of_dark_crystal_design]
(21352,1869,1,1,2,129223.131516),-- [iron_ore]
(21352,1864,1,1,2,258445.85498),-- [stem]
(21352,1880,1,1,2,12922.190736),-- [steel]
(21352,5550,1,1,2,1722.795544),-- [reinforcing_plate]
(21352,4043,1,1,2,4307.396912),-- [asofe]
(21352,5167,1,1,2,57.535332),-- [rp_comp_bspiritshot_s]
(21352,8732,1,1,2,1076.849228),-- [general_75_s]
(21352,8742,1,1,2,269.31432),-- [special_75_s]
(21352,8752,1,1,2,26.931432),-- [rare_75_s]
(21353,4041,1,1,-1,61305),-- [mold_hardener]
(21353,1875,1,1,-1,470004),-- [stone_of_purity]
(21353,5538,1,1,-1,19338),-- [dragon_grinder_edge]
(21353,57,3477,7097,0,700000),-- [adena]
(21353,11950,1,1,1,358.275078),-- [blood_tornado_low]
(21353,5539,1,1,1,4388.724922),-- [blood_tornado_edge]
(21353,1872,1,3,2,192821.957116),-- [animal_bone]
(21353,1867,1,3,2,128547.843046),-- [animal_skin]
(21353,1881,1,1,2,38564.468442),-- [coarse_bone_powder]
(21353,1875,1,1,2,19282.041674),-- [stone_of_purity]
(21353,4041,1,1,2,2515.048914),-- [mold_hardener]
(21353,6901,1,1,2,289.205594),-- [rp_shining_arrow]
(21353,8732,1,1,2,2410.303346),-- [general_75_s]
(21353,8742,1,1,2,602.67211),-- [special_75_s]
(21353,8752,1,1,2,60.459758),-- [rare_75_s]
(21354,5282,1,1,-1,3106),-- [rp_adv_comp_bspiritshot_s]
(21354,5541,1,1,-1,19163),-- [tallum_glaive_edge]
(21354,6901,1,1,-1,6988),-- [rp_shining_arrow]
(21354,57,3446,7034,0,700000),-- [adena]
(21354,11955,1,1,1,355.148106),-- [carnium_bow_low]
(21354,5535,1,1,1,4401.851894),-- [carnium_bow_shaft]
(21354,1868,4,12,2,58638.06879),-- [thread]
(21354,1873,1,1,2,93821.235822),-- [silver_nugget]
(21354,5549,1,1,2,23455.227516),-- [iron_thread]
(21354,1889,1,1,2,15636.709758),-- [compound_braid]
(21354,4044,1,1,2,7818.517758),-- [thons]
(21354,1808,1,1,2,104.24256),-- [rp_soulshot_s]
(21354,6671,1,1,2,26061.291516),-- [key_of_treasure_box7]
(21354,8732,1,1,2,1954.548),-- [general_75_s]
(21354,8742,1,1,2,488.637),-- [special_75_s]
(21354,8752,1,1,2,48.8637),-- [rare_75_s]
(21354,1344,30,90,2,97730.65758),-- [mithril_arrow]
(21355,5495,1,1,-1,107862),-- [sealed_shield_of_nightmare_fragment]
(21355,5272,1,1,-1,3157),-- [rp_adv_comp_soulshot_s]
(21355,5502,1,1,-1,119967),-- [sealed_boots_of_nightmare_lining]
(21355,57,3502,7147,0,700000),-- [adena]
(21355,11967,1,1,1,233.12061),-- [dragon_grinder_low]
(21355,5538,1,1,1,3596.87939),-- [dragon_grinder_edge]
(21355,1869,1,3,2,97138.592442),-- [iron_ore]
(21355,1864,1,3,2,291415.777326),-- [stem]
(21355,1880,1,1,2,29141.490852),-- [steel]
(21355,5550,1,1,2,3885.734835),-- [reinforcing_plate]
(21355,4043,1,1,2,9713.685483),-- [asofe]
(21355,959,1,1,2,11.728881),-- [scrl_of_ench_wp_s]
(21355,8732,1,1,2,2428.31277),-- [general_75_s]
(21355,8742,1,1,2,607.295394),-- [special_75_s]
(21355,8752,1,1,2,60.382017),-- [rare_75_s]
(21356,5277,1,1,-1,2032),-- [rp_adv_comp_spiritshot_s]
(21356,5503,1,1,-1,77205),-- [sealed_magestic_boots_lining]
(21356,4042,1,1,-1,76189),-- [enria]
(21356,57,2254,4600,0,700000),-- [adena]
(21356,11975,1,1,1,150.035539),-- [soul_bow_low]
(21356,5534,1,1,1,2316.964461),-- [soul_bow_shaft]
(21356,1867,1,3,2,112524.85546),-- [animal_skin]
(21356,1872,1,3,2,75016.42143),-- [animal_bone]
(21356,1882,1,1,2,37508.43403),-- [leather]
(21356,1894,1,1,2,5922.3138),-- [crafted_leather]
(21356,4042,1,1,2,2813.32237),-- [enria]
(21356,960,1,1,2,67.44113),-- [scrl_of_ench_am_s]
(21356,8732,1,1,2,1406.43787),-- [general_75_s]
(21356,8742,1,1,2,351.49781),-- [special_75_s]
(21356,8752,1,1,2,35.28377),-- [rare_75_s]
(21356,1344,10,30,2,210983.99233),-- [mithril_arrow]
(21357,4040,1,1,-1,151216),-- [mold_lubricant]
(21357,5480,1,1,-1,33927),-- [sealed_leather_mail_of_nightmare_fabric]
(21357,1808,1,1,-1,3360),-- [rp_soulshot_s]
(21357,57,3727,7609,0,700000),-- [adena]
(21357,11975,1,1,1,248.13336),-- [soul_bow_low]
(21357,5534,1,1,1,3831.86664),-- [soul_bow_shaft]
(21357,1865,1,3,2,155093.576078),-- [varnish]
(21357,1870,1,3,2,103395.603926),-- [coal]
(21357,1879,1,1,2,51697.972152),-- [cokes]
(21357,1875,1,1,2,20678.984634),-- [stone_of_purity]
(21357,4040,1,1,2,6203.729428),-- [mold_lubricant]
(21357,959,1,1,2,12.253608),-- [scrl_of_ench_wp_s]
(21357,8732,1,1,2,2584.830532),-- [general_75_s]
(21357,8742,1,1,2,646.377822),-- [special_75_s]
(21357,8752,1,1,2,64.67182),-- [rare_75_s]
(21358,5481,1,1,-1,34116),-- [sealed_majestic_leather_mail_fabric]
(21358,3036,1,1,-1,3379),-- [rp_spiritshot_s]
(21358,5487,1,1,-1,34237),-- [sealed_robe_of_nightmare_fabric]
(21358,57,3748,7652,0,700000),-- [adena]
(21358,11973,1,1,1,249.5096),-- [soul_separator_low]
(21358,5537,1,1,1,3850.4904),-- [soul_separator_head]
(21358,1866,1,1,2,187150.95308),-- [suede]
(21358,1871,1,3,2,93575.47654),-- [charcoal]
(21358,5220,1,1,2,11229.19616),-- [reinforcing_agent]
(21358,1885,1,1,2,23393.99322),-- [high_grade_suede]
(21358,4041,1,1,2,2441.00012),-- [mold_hardener]
(21358,960,1,1,2,112.17284),-- [scrl_of_ench_am_s]
(21358,8732,1,1,2,2339.25042),-- [general_75_s]
(21358,8742,1,1,2,584.68852),-- [special_75_s]
(21358,8752,1,1,2,58.56812),-- [rare_75_s]
(21358,1344,20,60,2,175454.70098),-- [mithril_arrow]
(21359,5157,1,1,-1,2165),-- [rp_comp_soulshot_s]
(21359,5523,1,1,-1,16586),-- [sealed_majestic_platte_armor_pattern]
(21359,4042,1,1,-1,81173),-- [enria]
(21359,57,2396,4907,0,700000),-- [adena]
(21359,11973,1,1,1,159.868712),-- [soul_separator_low]
(21359,5537,1,1,1,2467.131288),-- [soul_separator_head]
(21359,1873,1,1,2,71931.638688),-- [silver_nugget]
(21359,1868,1,3,2,179829.515736),-- [thread]
(21359,1876,1,1,2,35965.819344),-- [mithril_ore]
(21359,1895,1,1,2,51379.74192),-- [metallic_fiber]
(21359,4042,1,1,2,2997.221448),-- [enria]
(21359,960,1,1,2,72.070752),-- [scrl_of_ench_am_s]
(21359,8732,1,1,2,1498.401216),-- [general_75_s]
(21359,8742,1,1,2,374.600304),-- [special_75_s]
(21359,8752,1,1,2,37.292424),-- [rare_75_s]
(21359,1344,30,90,2,74929.698168),-- [mithril_arrow]
(21360,1875,1,1,-1,673928),-- [stone_of_purity]
(21360,5527,1,1,-1,120862),-- [sealed_helm_of_nightmare_design]
(21360,5162,1,1,-1,4493),-- [rp_comp_spiritshot_s]
(21360,57,4974,10185,0,700000),-- [adena]
(21360,11973,1,1,1,331.786912),-- [soul_separator_low]
(21360,5537,1,1,1,5120.213088),-- [soul_separator_head]
(21360,1872,4,12,2,69120.904002),-- [animal_bone]
(21360,1867,1,3,2,184322.525478),-- [animal_skin]
(21360,1881,1,1,2,55296.654318),-- [coarse_bone_powder]
(21360,1875,1,1,2,27648.499368),-- [stone_of_purity]
(21360,4041,1,1,2,3606.400878),-- [mold_hardener]
(21360,959,1,1,2,16.532064),-- [scrl_of_ench_wp_s]
(21360,8732,1,1,2,3455.890212),-- [general_75_s]
(21360,8742,1,1,2,864.144762),-- [special_75_s]
(21360,8752,1,1,2,86.448918),-- [rare_75_s]
(21361,5514,1,1,-1,123311),-- [sealed_gloves_of_nightmare_design]
(21361,5481,1,1,-1,32762),-- [sealed_majestic_leather_mail_fabric]
(21361,6901,1,1,-1,7301),-- [rp_shining_arrow]
(21361,57,3592,7357,0,700000),-- [adena]
(21361,12263,1,1,1,282.605516),-- [sealed_armor_of_nightmare_low]
(21361,5522,1,1,1,2295.394484),-- [sealed_armor_of_nightmare_pattern]
(21361,12262,1,1,1,282.605516),-- [sealed_majestic_platte_armor_low]
(21361,5523,1,1,1,2295.394484),-- [sealed_majestic_platte_armor_pattern]
(21361,1869,2,6,2,67396.180938),-- [iron_ore]
(21361,1870,2,6,2,53916.846526),-- [coal]
(21361,1871,3,9,2,44930.787292),-- [charcoal]
(21361,1872,1,3,2,179722.658046),-- [animal_bone]
(21361,1867,1,3,2,119815.105364),-- [animal_skin]
(21361,959,1,1,2,10.804684),-- [scrl_of_ench_wp_s]
(21361,6672,1,1,2,22465.393646),-- [key_of_treasure_box8]
(21361,8732,1,1,2,2246.392028),-- [general_75_s]
(21361,8742,1,1,2,561.843568),-- [special_75_s]
(21361,8752,1,1,2,55.987908),-- [rare_75_s]
(21362,5282,1,1,-1,3561),-- [rp_adv_comp_bspiritshot_s]
(21362,5515,1,1,-1,135323),-- [sealed_magestic_gloves_design]
(21362,6901,1,1,-1,8012),-- [rp_shining_arrow]
(21362,57,3942,8074,0,700000),-- [adena]
(21362,12266,1,1,1,413.217792),-- [sealed_robe_of_nightmare_low]
(21362,5487,1,1,1,3330.782208),-- [sealed_robe_of_nightmare_fabric]
(21362,12259,1,1,1,413.217792),-- [sealed_majestic_robe_low]
(21362,5488,1,1,1,3330.782208),-- [sealed_majestic_robe_fabric]
(21362,1894,1,1,2,11533.957968),-- [crafted_leather]
(21362,4039,1,1,2,10957.350235),-- [mold_glue]
(21362,4041,1,1,2,2858.24318),-- [mold_hardener]
(21362,4044,1,1,2,10957.350235),-- [thons]
(21362,960,1,1,2,131.641484),-- [scrl_of_ench_am_s]
(21362,8732,1,1,2,2739.224852),-- [general_75_s]
(21362,8742,1,1,2,684.806213),-- [special_75_s]
(21362,8752,1,1,2,68.525704),-- [rare_75_s]
(21362,1344,10,30,2,410895.900129),-- [mithril_arrow]
(21363,960,1,1,-1,3078),-- [scrl_of_ench_am_s]
(21363,1894,1,1,-1,270029),-- [crafted_leather]
(21363,4042,1,1,-1,128264),-- [enria]
(21363,57,3795,7746,0,700000),-- [adena]
(21363,12267,1,1,1,966.49809),-- [sealed_boots_of_nightmare_low]
(21363,5502,1,1,1,5998.75191),-- [sealed_boots_of_nightmare_lining]
(21363,12260,1,1,1,966.49809),-- [sealed_magestic_boots_low]
(21363,5503,1,1,1,5998.75191),-- [sealed_magestic_boots_lining]
(21363,12264,1,1,1,966.49809),-- [sealed_gloves_of_nightmare_low]
(21363,5514,1,1,1,5998.75191),-- [sealed_gloves_of_nightmare_design]
(21363,12257,1,1,1,966.49809),-- [sealed_magestic_gloves_low]
(21363,5515,1,1,1,5998.75191),-- [sealed_magestic_gloves_design]
(21363,1867,1,3,2,210484.007),-- [animal_skin]
(21363,1872,1,3,2,140322.37755),-- [animal_bone]
(21363,1882,1,1,2,70161.188775),-- [leather]
(21363,1894,1,1,2,11078.128825),-- [crafted_leather]
(21363,4042,1,1,2,5262.100175),-- [enria]
(21363,959,1,1,2,12.779575),-- [scrl_of_ench_wp_s]
(21363,8732,1,1,2,2630.82975),-- [general_75_s]
(21363,8742,1,1,2,657.927775),-- [special_75_s]
(21363,8752,1,1,2,65.660575),-- [rare_75_s]
(21364,6691,1,1,-1,12779),-- [angel_slayer_blade]
(21364,6693,1,1,-1,13011),-- [dragon_hunter_axe_blade]
(21364,6694,1,1,-1,13011),-- [saint_spear_blade]
(21364,57,2916,5951,0,700000),-- [adena]
(21364,12268,1,1,1,943.780893),-- [sealed_shield_of_nightmare_low]
(21364,5495,1,1,1,5524.705406),-- [sealed_shield_of_nightmare_fragment]
(21364,12269,1,1,1,660.302005),-- [sealed_helm_of_nightmare_low]
(21364,5527,1,1,1,4349.946601),-- [sealed_helm_of_nightmare_design]
(21364,12261,1,1,1,660.302005),-- [sealed_magestic_circlet_low]
(21364,5528,1,1,1,4349.96309),-- [sealed_magestic_circlet_design]
(21364,1868,1,3,2,218296.174564),-- [thread]
(21364,1873,1,1,2,87318.558353),-- [silver_nugget]
(21364,5549,1,1,2,21829.528929),-- [iron_thread]
(21364,1889,1,1,2,14553.019286),-- [compound_braid]
(21364,4044,1,1,2,7276.509643),-- [thons]
(21364,960,1,1,2,87.199489),-- [scrl_of_ench_am_s]
(21364,8732,1,1,2,1819.23807),-- [general_75_s]
(21364,8742,1,1,2,454.588199),-- [special_75_s]
(21364,8752,1,1,2,45.591611),-- [rare_75_s]
(21364,1344,30,90,2,90956.591856),-- [mithril_arrow]
(21365,959,1,1,-1,330),-- [scrl_of_ench_wp_s]
(21365,6688,1,1,-1,17847),-- [forgotten_blade_edge]
(21365,6689,1,1,-1,17511),-- [basalt_battlehammer_head]
(21365,57,4071,8308,0,700000),-- [adena]
(21365,12265,1,1,1,425.813736),-- [sealed_leather_mail_of_nightmare_low]
(21365,5480,1,1,1,3420.186264),-- [sealed_leather_mail_of_nightmare_fabric]
(21365,12258,1,1,1,425.813736),-- [sealed_majestic_leather_mail_low]
(21365,5481,1,1,1,3420.186264),-- [sealed_majestic_leather_mail_fabric]
(21365,1869,2,6,2,84685.16993),-- [iron_ore]
(21365,1870,2,6,2,67748.29407),-- [coal]
(21365,1871,3,9,2,56456.911725),-- [charcoal]
(21365,1872,7,21,2,32260.86652),-- [animal_bone]
(21365,1867,1,3,2,150551.369285),-- [animal_skin]
(21365,959,1,1,2,13.44071),-- [scrl_of_ench_wp_s]
(21365,8732,1,1,2,2822.944415),-- [general_75_s]
(21365,8742,1,1,2,705.637275),-- [special_75_s]
(21365,8752,1,1,2,70.36607),-- [rare_75_s]
(21366,6698,1,1,-1,175150),-- [sealed_sanddragon's_earing_piece]
(21366,6699,1,1,-1,194352),-- [sealed_ring_of_aurakyria_gem]
(21366,6700,1,1,-1,106751),-- [sealed_dragon_necklace_wire]
(21366,57,4396,8972,0,700000),-- [adena]
(21366,12263,1,1,1,345.090056),-- [sealed_armor_of_nightmare_low]
(21366,5522,1,1,1,2802.909944),-- [sealed_armor_of_nightmare_pattern]
(21366,12262,1,1,1,345.090056),-- [sealed_majestic_platte_armor_low]
(21366,5523,1,1,1,2802.909944),-- [sealed_majestic_platte_armor_pattern]
(21366,1894,1,1,2,12835.84337),-- [crafted_leather]
(21366,4039,1,1,2,12193.846396),-- [mold_glue]
(21366,4041,1,1,2,3181.039026),-- [mold_hardener]
(21366,4044,1,1,2,12193.846396),-- [thons]
(21366,960,1,1,2,146.367664),-- [scrl_of_ench_am_s]
(21366,8732,1,1,2,3048.598136),-- [general_75_s]
(21366,8742,1,1,2,762.149534),-- [special_75_s]
(21366,8752,1,1,2,76.187646),-- [rare_75_s]
(21366,1344,20,60,2,228636.121832),-- [mithril_arrow]
(21367,6710,1,1,-1,87307),-- [sealed_draconic_leather_helmet_pattern]
(21367,6711,1,1,-1,26667),-- [sealed_major_arcana_robe_part]
(21367,6712,1,1,-1,76629),-- [sealed_major_arcana_gloves_fabric]
(21367,57,2653,5416,0,700000),-- [adena]
(21367,11975,1,1,1,176.612568),-- [soul_bow_low]
(21367,5534,1,1,1,2727.387432),-- [soul_bow_shaft]
(21367,1895,1,1,2,63086.223094),-- [metallic_fiber]
(21367,4040,1,1,2,4416.174838),-- [mold_lubricant]
(21367,4042,1,1,2,3680.086202),-- [enria]
(21367,4043,1,1,2,7360.172404),-- [asofe]
(21367,960,1,1,2,88.173566),-- [scrl_of_ench_am_s]
(21367,8732,1,1,2,1839.864612),-- [general_75_s]
(21367,8742,1,1,2,460.144642),-- [special_75_s]
(21367,8752,1,1,2,46.050162),-- [rare_75_s]
(21367,1344,10,30,2,276001.11048),-- [mithril_arrow]
(21368,960,1,1,-1,4349),-- [scrl_of_ench_am_s]
(21368,1895,1,7,-1,776557),-- [metallic_fiber]
(21368,4042,1,1,-1,181197),-- [enria]
(21368,57,5359,10941,0,700000),-- [adena]
(21368,11973,1,1,1,356.798728),-- [soul_separator_low]
(21368,5537,1,1,1,5506.201272),-- [soul_separator_head]
(21368,1873,2,6,2,40142.0719),-- [silver_nugget]
(21368,1868,3,9,2,133807.59525),-- [thread]
(21368,1876,1,1,2,80284.55715),-- [mithril_ore]
(21368,1895,1,1,2,114692.2245),-- [metallic_fiber]
(21368,4042,1,1,2,6690.4831),-- [enria]
(21368,959,1,1,2,16.12065),-- [scrl_of_ench_wp_s]
(21368,6672,1,1,2,33452.00215),-- [key_of_treasure_box8]
(21368,8732,1,1,2,3345.24155),-- [general_75_s]
(21368,8742,1,1,2,836.20705),-- [special_75_s]
(21368,8752,1,1,2,83.4967),-- [rare_75_s]
(21369,5528,1,1,-1,114809),-- [sealed_magestic_circlet_design]
(21369,5167,1,1,-1,4268),-- [rp_comp_bspiritshot_s]
(21369,5529,1,1,-1,26345),-- [dragon_slayer_edge]
(21369,57,4725,9675,0,700000),-- [adena]
(21369,11976,1,1,1,315.170583),-- [tallum_glaive_low]
(21369,5541,1,1,1,4861.829417),-- [tallum_glaive_edge]
(21369,1868,4,12,2,88639.962635),-- [thread]
(21369,1873,1,1,2,141824.393235),-- [silver_nugget]
(21369,5549,1,1,2,35455.985054),-- [iron_thread]
(21369,1889,1,1,2,23637.172363),-- [compound_braid]
(21369,4044,1,1,2,11818.812691),-- [thons]
(21369,960,1,1,2,141.794947),-- [scrl_of_ench_am_s]
(21369,8732,1,1,2,2954.589918),-- [general_75_s]
(21369,8742,1,1,2,738.873989),-- [special_75_s]
(21369,8752,1,1,2,73.842097),-- [rare_75_s]
(21369,1344,30,90,2,147733.573071),-- [mithril_arrow]
(21370,5550,1,1,-1,103728),-- [reinforcing_plate]
(21370,4043,1,1,-1,259321),-- [asofe]
(21370,5488,1,1,-1,35032),-- [sealed_majestic_robe_fabric]
(21370,57,3835,7830,0,700000),-- [adena]
(21370,12266,1,1,1,401.18768),-- [sealed_robe_of_nightmare_low]
(21370,5487,1,1,1,3233.81232),-- [sealed_robe_of_nightmare_fabric]
(21370,12259,1,1,1,401.18768),-- [sealed_majestic_robe_low]
(21370,5488,1,1,1,3233.81232),-- [sealed_majestic_robe_fabric]
(21370,1869,1,3,2,106388.161938),-- [iron_ore]
(21370,1864,1,3,2,319164.485814),-- [stem]
(21370,1880,1,1,2,31916.353428),-- [steel]
(21370,5550,1,1,2,4255.735815),-- [reinforcing_plate]
(21370,4043,1,1,2,10638.625887),-- [asofe]
(21370,959,1,1,2,12.845709),-- [scrl_of_ench_wp_s]
(21370,8732,1,1,2,2659.53753),-- [general_75_s]
(21370,8742,1,1,2,665.122266),-- [special_75_s]
(21370,8752,1,1,2,66.131613),-- [rare_75_s]
(21371,6713,1,1,-1,119352),-- [sealed_major_arcana_boots_design]
(21371,6714,1,1,-1,135984),-- [sealed_major_arcana_hood_pattern]
(21371,7579,1,1,-1,18329),-- [draconic_bow_shaft]
(21371,57,4132,8436,0,700000),-- [adena]
(21371,11973,1,1,1,275.129976),-- [soul_separator_low]
(21371,5537,1,1,1,4245.870024),-- [soul_separator_head]
(21371,1894,1,1,2,12066.898272),-- [crafted_leather]
(21371,4039,1,1,2,11463.64769),-- [mold_glue]
(21371,4041,1,1,2,2990.31172),-- [mold_hardener]
(21371,4044,1,1,2,11463.64769),-- [thons]
(21371,960,1,1,2,137.724136),-- [scrl_of_ench_am_s]
(21371,8732,1,1,2,2865.794008),-- [general_75_s]
(21371,8742,1,1,2,716.448502),-- [special_75_s]
(21371,8752,1,1,2,71.692016),-- [rare_75_s]
(21371,1344,10,30,2,429881.835966),-- [mithril_arrow]
(21372,960,1,1,-1,2242),-- [scrl_of_ench_am_s]
(21372,1876,1,3,-1,560482),-- [mithril_ore]
(21372,1895,1,3,-1,800688),-- [metallic_fiber]
(21372,57,2763,5640,0,700000),-- [adena]
(21372,12266,1,1,1,289.053792),-- [sealed_robe_of_nightmare_low]
(21372,5487,1,1,1,2329.946208),-- [sealed_robe_of_nightmare_fabric]
(21372,12259,1,1,1,289.053792),-- [sealed_majestic_robe_low]
(21372,5488,1,1,1,2329.946208),-- [sealed_majestic_robe_fabric]
(21372,1873,1,1,2,91976.412717),-- [silver_nugget]
(21372,1868,1,3,2,229940.811849),-- [thread]
(21372,1876,1,1,2,45987.986415),-- [mithril_ore]
(21372,1895,1,1,2,65697.12345),-- [metallic_fiber]
(21372,4042,1,1,2,3832.295544),-- [enria]
(21372,959,1,1,2,9.237627),-- [scrl_of_ench_wp_s]
(21372,8732,1,1,2,1916.147772),-- [general_75_s]
(21372,8742,1,1,2,479.036943),-- [special_75_s]
(21372,8752,1,1,2,47.947683),-- [rare_75_s]
(21373,959,1,1,-1,453),-- [scrl_of_ench_wp_s]
(21373,1895,1,7,-1,808936),-- [metallic_fiber]
(21373,4040,1,1,-1,226502),-- [mold_lubricant]
(21373,57,5568,11414,0,700000),-- [adena]
(21373,12266,1,1,1,584.012272),-- [sealed_robe_of_nightmare_low]
(21373,5487,1,1,1,4707.487728),-- [sealed_robe_of_nightmare_fabric]
(21373,12259,1,1,1,584.012272),-- [sealed_majestic_robe_low]
(21373,5488,1,1,1,4707.487728),-- [sealed_majestic_robe_fabric]
(21373,1895,1,1,2,149341.72716),-- [metallic_fiber]
(21373,4040,1,1,2,10453.87494),-- [mold_lubricant]
(21373,4042,1,1,2,8711.56245),-- [enria]
(21373,4043,1,1,2,17423.1249),-- [asofe]
(21373,959,1,1,2,20.874045),-- [scrl_of_ench_wp_s]
(21373,8732,1,1,2,4355.781225),-- [general_75_s]
(21373,8742,1,1,2,1088.89743),-- [special_75_s]
(21373,8752,1,1,2,109.15785),-- [rare_75_s]
(21374,6707,1,1,-1,29364),-- [sealed_draconic_leather_armor_part]
(21374,6708,1,1,-1,84378),-- [sealed_draconic_leather_gloves_fabric]
(21374,6709,1,1,-1,84378),-- [sealed_draconic_leather_boots_design]
(21374,57,2916,5970,0,700000),-- [adena]
(21374,11976,1,1,1,194.508405),-- [tallum_glaive_low]
(21374,5541,1,1,1,3000.491595),-- [tallum_glaive_edge]
(21374,1873,1,1,2,97251.988557),-- [silver_nugget]
(21374,1868,1,3,2,243130.203996),-- [thread]
(21374,1876,1,1,2,48626.226882),-- [mithril_ore]
(21374,1895,1,1,2,69465.639654),-- [metallic_fiber]
(21374,4042,1,1,2,4051.95297),-- [enria]
(21374,960,1,1,2,97.228263),-- [scrl_of_ench_am_s]
(21374,8732,1,1,2,2025.976485),-- [general_75_s]
(21374,8742,1,1,2,506.610423),-- [special_75_s]
(21374,8752,1,1,2,51.17277),-- [rare_75_s]
(21375,960,1,1,-1,2285),-- [scrl_of_ench_am_s]
(21375,4040,1,1,-1,114238),-- [mold_lubricant]
(21375,1877,1,1,-1,228476),-- [admantite_nugget]
(21375,57,2811,5754,0,700000),-- [adena]
(21375,12265,1,1,1,294.559918),-- [sealed_leather_mail_of_nightmare_low]
(21375,5480,1,1,1,2365.940082),-- [sealed_leather_mail_of_nightmare_fabric]
(21375,12258,1,1,1,294.559918),-- [sealed_majestic_leather_mail_low]
(21375,5481,1,1,1,2365.940082),-- [sealed_majestic_leather_mail_fabric]
(21375,1871,1,1,2,234334.361266),-- [charcoal]
(21375,1866,1,1,2,156222.771126),-- [suede]
(21375,1877,1,1,2,9373.308986),-- [admantite_nugget]
(21375,4041,1,1,2,2037.58692),-- [mold_hardener]
(21375,4040,1,1,2,4686.85907),-- [mold_lubricant]
(21375,959,1,1,2,9.410542),-- [scrl_of_ench_wp_s]
(21375,8732,1,1,2,1952.892042),-- [general_75_s]
(21375,8742,1,1,2,488.120722),-- [special_75_s]
(21375,8752,1,1,2,48.689326),-- [rare_75_s]
(21376,5544,1,1,-1,27515),-- [worldtree's_branch_head]
(21376,4041,1,1,-1,87314),-- [mold_hardener]
(21376,1875,1,1,-1,669404),-- [stone_of_purity]
(21376,57,4952,10108,0,700000),-- [adena]
(21376,11951,1,1,1,510.306986),-- [bloody_orchid_low]
(21376,5536,1,1,1,6306.693014),-- [bloody_orchid_head]
(21376,1872,4,12,2,68656.883343),-- [animal_bone]
(21376,1867,1,3,2,183085.592703),-- [animal_skin]
(21376,1881,1,1,2,54925.575129),-- [coarse_bone_powder]
(21376,1875,1,1,2,27462.958701),-- [stone_of_purity]
(21376,4041,1,1,2,3582.229218),-- [mold_hardener]
(21376,3036,1,1,2,183.116055),-- [rp_spiritshot_s]
(21376,8732,1,1,2,3432.99819),-- [general_75_s]
(21376,8742,1,1,2,858.078411),-- [special_75_s]
(21376,8752,1,1,2,85.56825),-- [rare_75_s]
(21377,5545,1,1,-1,26960),-- [dark_legion's_edge_edge]
(21377,1808,1,1,-1,4368),-- [rp_soulshot_s]
(21377,5546,1,1,-1,29613),-- [sword_of_miracle_edge]
(21377,57,4847,9892,0,700000),-- [adena]
(21377,12227,1,1,1,659.092728),-- [sealed_dark_crystal_breastplate_low]
(21377,5520,1,1,1,3899.53256),-- [sealed_dark_crystal_breastplate_pattern]
(21377,12233,1,1,1,405.844768),-- [sealed_tallum_plate_armor_low]
(21377,5521,1,1,1,2751.661696),-- [sealed_tallum_plate_armor_pattern]
(21377,12220,1,1,1,1051.682296),-- [sealed_dark_crystal_gaiters_low]
(21377,5524,1,1,1,5960.185952),-- [sealed_dark_crystal_gaiters_pattern]
(21377,1873,1,1,2,145136.73845),-- [silver_nugget]
(21377,1868,4,12,2,90710.631176),-- [thread]
(21377,1876,1,1,2,72568.595418),-- [mithril_ore]
(21377,1895,1,1,2,103669.228146),-- [metallic_fiber]
(21377,4042,1,1,2,6047.496048),-- [enria]
(21377,3957,1,1,2,161.049416),-- [rp_blessed_spiritshot_s]
(21377,8732,1,1,2,3023.748024),-- [general_75_s]
(21377,8742,1,1,2,755.937006),-- [special_75_s]
(21377,8752,1,1,2,75.548462),-- [rare_75_s]
(21377,1344,150,450,2,30237.027854),-- [mithril_arrow]
(21378,1889,1,1,-1,804585),-- [compound_braid]
(21378,5514,1,1,-1,203830),-- [sealed_gloves_of_nightmare_design]
(21378,5282,1,1,-1,5364),-- [rp_adv_comp_bspiritshot_s]
(21378,57,5950,12144,0,700000),-- [adena]
(21378,11973,1,1,1,396.111704),-- [soul_separator_low]
(21378,5537,1,1,1,6112.888296),-- [soul_separator_head]
(21378,1868,3,9,2,165043.032308),-- [thread]
(21378,1873,1,1,2,198051.82573),-- [silver_nugget]
(21378,5549,1,1,2,49512.722732),-- [iron_thread]
(21378,1889,1,1,2,33008.793422),-- [compound_braid]
(21378,4044,1,1,2,16504.396711),-- [thons]
(21378,959,1,1,2,19.630842),-- [scrl_of_ench_wp_s]
(21378,8732,1,1,2,4126.216028),-- [general_75_s]
(21378,8742,1,1,2,1031.554007),-- [special_75_s]
(21378,8752,1,1,2,102.82822),-- [rare_75_s]
(21379,5515,1,1,-1,171095),-- [sealed_magestic_gloves_design]
(21379,6901,1,1,-1,10131),-- [rp_shining_arrow]
(21379,5522,1,1,-1,34500),-- [sealed_armor_of_nightmare_pattern]
(21379,57,4995,10193,0,700000),-- [adena]
(21379,12263,1,1,1,392.063083),-- [sealed_armor_of_nightmare_low]
(21379,5522,1,1,1,3184.436917),-- [sealed_armor_of_nightmare_pattern]
(21379,12262,1,1,1,392.063083),-- [sealed_majestic_platte_armor_low]
(21379,5523,1,1,1,3184.436917),-- [sealed_majestic_platte_armor_pattern]
(21379,1864,5,15,2,74810.101354),-- [stem]
(21379,1865,3,9,2,62341.909322),-- [varnish]
(21379,1866,3,9,2,35623.948184),-- [suede]
(21379,1873,1,1,2,149620.202708),-- [silver_nugget]
(21379,1868,12,36,2,31170.954661),-- [thread]
(21379,960,1,1,2,149.493015),-- [scrl_of_ench_am_s]
(21379,8732,1,1,2,3117.048008),-- [general_75_s]
(21379,8742,1,1,2,779.262002),-- [special_75_s]
(21379,8752,1,1,2,77.831284),-- [rare_75_s]
(21379,1344,40,120,2,116890.249462),-- [mithril_arrow]
(21380,5523,1,1,-1,35175),-- [sealed_majestic_platte_armor_pattern]
(21380,5481,1,1,-1,46347),-- [sealed_majestic_leather_mail_fabric]
(21380,1808,1,1,-1,4591),-- [rp_soulshot_s]
(21380,57,5093,10393,0,700000),-- [adena]
(21380,11974,1,1,1,84.750528),-- [elysian_low]
(21380,5533,1,1,1,1307.639232),-- [elysian_head]
(21380,11970,1,1,1,84.750528),-- [worldtree's_branch_low]
(21380,5544,1,1,1,1306.347456),-- [worldtree's_branch_head]
(21380,11969,1,1,1,84.750528),-- [dragon_flame_head_low]
(21380,8342,1,1,1,1307.639232),-- [dragon_flame_head_piece]
(21380,11966,1,1,1,84.750528),-- [doom_crusher_low]
(21380,8349,1,1,1,1307.371968),-- [doom_crusher_head]
(21380,1869,2,6,2,105935.778108),-- [iron_ore]
(21380,1870,2,6,2,84748.820292),-- [coal]
(21380,1871,3,9,2,70624.01691),-- [charcoal]
(21380,1872,7,21,2,40356.298512),-- [animal_bone]
(21380,1867,1,3,2,188330.217246),-- [animal_skin]
(21380,959,1,1,2,16.813476),-- [scrl_of_ench_wp_s]
(21380,8732,1,1,2,3531.324474),-- [general_75_s]
(21380,8742,1,1,2,882.70749),-- [special_75_s]
(21380,8752,1,1,2,88.023492),-- [rare_75_s]
(21381,3957,1,1,-1,5018),-- [rp_blessed_spiritshot_s]
(21381,5495,1,1,-1,171455),-- [sealed_shield_of_nightmare_fragment]
(21381,5157,1,1,-1,5018),-- [rp_comp_soulshot_s]
(21381,57,5566,11364,0,700000),-- [adena]
(21381,11976,1,1,1,370.570473),-- [tallum_glaive_low]
(21381,5541,1,1,1,5716.429527),-- [tallum_glaive_edge]
(21381,1867,5,15,2,55587.364488),-- [animal_skin]
(21381,1872,1,3,2,185291.704941),-- [animal_bone]
(21381,1882,1,1,2,92645.60748),-- [leather]
(21381,1894,1,1,2,14628.382755),-- [crafted_leather]
(21381,4042,1,1,2,6948.420561),-- [enria]
(21381,960,1,1,2,166.59354),-- [scrl_of_ench_am_s]
(21381,8732,1,1,2,3474.455271),-- [general_75_s]
(21381,8742,1,1,2,868.736313),-- [special_75_s]
(21381,8752,1,1,2,86.726637),-- [rare_75_s]
(21381,1344,40,120,2,130283.008014),-- [mithril_arrow]
(21382,5502,1,1,-1,203124),-- [sealed_boots_of_nightmare_lining]
(21382,5549,1,3,-1,601349),-- [iron_thread]
(21382,1889,1,1,-1,801799),-- [compound_braid]
(21382,57,5929,12104,0,700000),-- [adena]
(21382,12265,1,1,1,620.231032),-- [sealed_leather_mail_of_nightmare_low]
(21382,5480,1,1,1,4981.768968),-- [sealed_leather_mail_of_nightmare_fabric]
(21382,12258,1,1,1,620.231032),-- [sealed_majestic_leather_mail_low]
(21382,5481,1,1,1,4981.768968),-- [sealed_majestic_leather_mail_fabric]
(21382,1868,3,9,2,164471.703564),-- [thread]
(21382,1873,1,1,2,197366.23059),-- [silver_nugget]
(21382,5549,1,1,2,49341.324756),-- [iron_thread]
(21382,1889,1,1,2,32894.527026),-- [compound_braid]
(21382,4044,1,1,2,16447.263513),-- [thons]
(21382,959,1,1,2,19.562886),-- [scrl_of_ench_wp_s]
(21382,8732,1,1,2,4111.932324),-- [general_75_s]
(21382,8742,1,1,2,1027.983081),-- [special_75_s]
(21382,8752,1,1,2,102.47226),-- [rare_75_s]
(21383,5503,1,1,-1,217116),-- [sealed_magestic_boots_lining]
(21383,5162,1,1,-1,5714),-- [rp_comp_spiritshot_s]
(21383,5514,1,1,-1,217116),-- [sealed_gloves_of_nightmare_design]
(21383,57,6337,12938,0,700000),-- [adena]
(21383,12263,1,1,1,497.574258),-- [sealed_armor_of_nightmare_low]
(21383,5522,1,1,1,4041.425742),-- [sealed_armor_of_nightmare_pattern]
(21383,12262,1,1,1,497.574258),-- [sealed_majestic_platte_armor_low]
(21383,5523,1,1,1,4041.425742),-- [sealed_majestic_platte_armor_pattern]
(21383,1864,5,15,2,94932.30272),-- [stem]
(21383,1865,3,9,2,79110.396755),-- [varnish]
(21383,1866,3,9,2,45206.06485),-- [suede]
(21383,1873,4,12,2,21096.308085),-- [silver_nugget]
(21383,1868,12,36,2,39554.981645),-- [thread]
(21383,960,1,1,2,189.85767),-- [scrl_of_ench_am_s]
(21383,8732,1,1,2,3955.368125),-- [general_75_s]
(21383,8742,1,1,2,988.733665),-- [special_75_s]
(21383,8752,1,1,2,98.83002),-- [rare_75_s]
(21383,1344,40,120,2,148332.156465),-- [mithril_arrow]
(21384,4041,1,1,-1,104091),-- [mold_hardener]
(21384,1875,1,1,-1,798032),-- [stone_of_purity]
(21384,5533,1,1,-1,32835),-- [elysian_head]
(21384,57,5890,12060,0,700000),-- [adena]
(21384,12265,1,1,1,617.297058),-- [sealed_leather_mail_of_nightmare_low]
(21384,5480,1,1,1,4958.202942),-- [sealed_leather_mail_of_nightmare_fabric]
(21384,12258,1,1,1,617.297058),-- [sealed_majestic_leather_mail_low]
(21384,5481,1,1,1,4958.202942),-- [sealed_majestic_leather_mail_fabric]
(21384,1872,4,12,2,81849.403138),-- [animal_bone]
(21384,1867,1,3,2,218265.210982),-- [animal_skin]
(21384,1881,1,1,2,65479.440942),-- [coarse_bone_powder]
(21384,1875,1,1,2,32739.924392),-- [stone_of_purity]
(21384,4041,1,1,2,4270.513582),-- [mold_hardener]
(21384,959,1,1,2,19.576416),-- [scrl_of_ench_wp_s]
(21384,8732,1,1,2,4092.286628),-- [general_75_s]
(21384,8742,1,1,2,1023.275578),-- [special_75_s]
(21384,8752,1,1,2,102.368342),-- [rare_75_s]
(21385,5272,1,1,-1,5032),-- [rp_adv_comp_soulshot_s]
(21385,5534,1,1,-1,31083),-- [soul_bow_shaft]
(21385,5277,1,1,-1,5032),-- [rp_adv_comp_spiritshot_s]
(21385,57,5571,11407,0,700000),-- [adena]
(21385,12263,1,1,1,438.213945),-- [sealed_armor_of_nightmare_low]
(21385,5522,1,1,1,3559.286055),-- [sealed_armor_of_nightmare_pattern]
(21385,12262,1,1,1,438.213945),-- [sealed_majestic_platte_armor_low]
(21385,5523,1,1,1,3559.286055),-- [sealed_majestic_platte_armor_pattern]
(21385,1873,3,9,2,27869.648028),-- [silver_nugget]
(21385,1868,4,12,2,104511.084644),-- [thread]
(21385,1876,1,1,2,83608.944084),-- [mithril_ore]
(21385,1895,1,1,2,119441.185044),-- [metallic_fiber]
(21385,4042,1,1,2,6967.507468),-- [enria]
(21385,960,1,1,2,167.247672),-- [scrl_of_ench_am_s]
(21385,8732,1,1,2,3483.562812),-- [general_75_s]
(21385,8742,1,1,2,870.986164),-- [special_75_s]
(21385,8752,1,1,2,87.060432),-- [rare_75_s]
(21385,1344,150,450,2,34836.773652),-- [mithril_arrow]
(21386,5537,1,1,-1,32059),-- [soul_separator_head]
(21386,1877,1,1,-1,467422),-- [admantite_nugget]
(21386,4041,1,1,-1,101613),-- [mold_hardener]
(21386,57,5749,11773,0,700000),-- [adena]
(21386,12266,1,1,1,602.60928),-- [sealed_robe_of_nightmare_low]
(21386,5487,1,1,1,4857.39072),-- [sealed_robe_of_nightmare_fabric]
(21386,12259,1,1,1,602.60928),-- [sealed_majestic_robe_low]
(21386,5488,1,1,1,4857.39072),-- [sealed_majestic_robe_fabric]
(21386,1871,1,3,2,239703.293544),-- [charcoal]
(21386,1866,1,3,2,106534.669036),-- [suede]
(21386,1877,1,1,2,19176.155884),-- [admantite_nugget]
(21386,4041,1,1,2,4168.712832),-- [mold_hardener]
(21386,4040,1,1,2,9588.270084),-- [mold_lubricant]
(21386,959,1,1,2,19.2142),-- [scrl_of_ench_wp_s]
(21386,8732,1,1,2,3995.016464),-- [general_75_s]
(21386,8742,1,1,2,998.754116),-- [special_75_s]
(21386,8752,1,1,2,99.91384),-- [rare_75_s]
(21387,5522,1,1,-1,35740),-- [sealed_armor_of_nightmare_pattern]
(21387,1895,1,7,-1,749613),-- [metallic_fiber]
(21387,4042,1,1,-1,174910),-- [enria]
(21387,57,5163,10575,0,700000),-- [adena]
(21387,12352,1,1,1,1588.748784),-- [sealed_majestic_earing_low]
(21387,6342,1,1,1,14629.634096),-- [sealed_majestic_earing_gemstone]
(21387,12350,1,1,1,1192.680496),-- [sealed_majestic_necklace_low]
(21387,6344,1,1,1,9467.47032),-- [sealed_majestic_necklace_beads]
(21387,12351,1,1,1,2383.098032),-- [sealed_majestic_ring_low]
(21387,6346,1,1,1,21026.368272),-- [sealed_majestic_ring_gemstrone]
(21387,1873,2,6,2,43054.66836),-- [silver_nugget]
(21387,1868,3,9,2,143515.5612),-- [thread]
(21387,1876,1,1,2,86109.33672),-- [mithril_ore]
(21387,1895,1,1,2,123013.39638),-- [metallic_fiber]
(21387,4042,1,1,2,7175.77806),-- [enria]
(21387,959,1,1,2,17.11332),-- [scrl_of_ench_wp_s]
(21387,8732,1,1,2,3587.6853),-- [general_75_s]
(21387,8742,1,1,2,896.81946),-- [special_75_s]
(21387,8752,1,1,2,89.6412),-- [rare_75_s]
(21388,5523,1,1,-1,54064),-- [sealed_majestic_platte_armor_pattern]
(21388,1808,1,1,-1,7056),-- [rp_soulshot_s]
(21388,5527,1,1,-1,189805),-- [sealed_helm_of_nightmare_design]
(21388,57,7810,15997,0,700000),-- [adena]
(21388,12267,1,1,1,1993.73837),-- [sealed_boots_of_nightmare_low]
(21388,5502,1,1,1,12374.51163),-- [sealed_boots_of_nightmare_lining]
(21388,12260,1,1,1,1993.73837),-- [sealed_magestic_boots_low]
(21388,5503,1,1,1,12374.51163),-- [sealed_magestic_boots_lining]
(21388,12264,1,1,1,1993.73837),-- [sealed_gloves_of_nightmare_low]
(21388,5514,1,1,1,12374.51163),-- [sealed_gloves_of_nightmare_design]
(21388,12257,1,1,1,1993.73837),-- [sealed_magestic_gloves_low]
(21388,5515,1,1,1,12374.51163),-- [sealed_magestic_gloves_design]
(21388,1872,5,15,2,78155.049882),-- [animal_bone]
(21388,1867,9,27,2,43419.2313),-- [animal_skin]
(21388,1881,1,1,2,78155.049882),-- [coarse_bone_powder]
(21388,1875,1,1,2,39077.30817),-- [stone_of_purity]
(21388,4041,1,1,2,5097.153294),-- [mold_hardener]
(21388,960,1,1,2,234.546222),-- [scrl_of_ench_am_s]
(21388,8732,1,1,2,4884.717714),-- [general_75_s]
(21388,8742,1,1,2,1221.287814),-- [special_75_s]
(21388,8752,1,1,2,122.258844),-- [rare_75_s]
(21388,1344,40,120,2,183175.396878),-- [mithril_arrow]
(21389,959,1,1,-1,580),-- [scrl_of_ench_wp_s]
(21389,6690,1,1,-1,31391),-- [piece_of_imperial_staff]
(21389,6691,1,1,-1,31331),-- [angel_slayer_blade]
(21389,57,7149,14591,0,700000),-- [adena]
(21389,11968,1,1,1,158.573382),-- [dragon_slayer_low]
(21389,5529,1,1,1,2447.158194),-- [dragon_slayer_edge]
(21389,11971,1,1,1,158.573382),-- [sword_of_miracle_low]
(21389,5546,1,1,1,2687.963466),-- [sword_of_miracle_edge]
(21389,11964,1,1,1,158.573382),-- [dark_legion's_edge_low]
(21389,5545,1,1,1,2447.158194),-- [dark_legion's_edge_edge]
(21389,1864,4,12,2,148668.54852),-- [stem]
(21389,1865,2,6,2,118935.09465),-- [varnish]
(21389,1866,3,9,2,66075.09996),-- [suede]
(21389,1873,4,12,2,29733.88026),-- [silver_nugget]
(21389,1868,10,30,2,56635.67814),-- [thread]
(21389,959,1,1,2,23.87784),-- [scrl_of_ench_wp_s]
(21389,8732,1,1,2,4955.50458),-- [general_75_s]
(21389,8742,1,1,2,1239.08934),-- [special_75_s]
(21389,8752,1,1,2,123.22671),-- [rare_75_s]
(21390,6701,1,1,-1,89988),-- [sealed_imperial_crusader_armor_part]
(21390,6702,1,1,-1,115839),-- [sealed_imperial_crusader_gaiters_pattern]
(21390,6703,1,1,-1,240650),-- [sealed_imperial_crusader_gauntlet_design]
(21390,57,8333,17007,0,700000),-- [adena]
(21390,12352,1,1,1,2558.748663),-- [sealed_majestic_earing_low]
(21390,6342,1,1,1,23561.658747),-- [sealed_majestic_earing_gemstone]
(21390,12350,1,1,1,1920.863547),-- [sealed_majestic_necklace_low]
(21390,6344,1,1,1,15247.770615),-- [sealed_majestic_necklace_beads]
(21390,12351,1,1,1,3838.082499),-- [sealed_majestic_ring_low]
(21390,6346,1,1,1,33863.875929),-- [sealed_majestic_ring_gemstrone]
(21390,1872,5,15,2,83210.028993),-- [animal_bone]
(21390,1867,9,27,2,46227.53745),-- [animal_skin]
(21390,1881,1,1,2,83210.028993),-- [coarse_bone_powder]
(21390,1875,1,1,2,41604.783705),-- [stone_of_purity]
(21390,4041,1,1,2,5426.831331),-- [mold_hardener]
(21390,960,1,1,2,249.716403),-- [scrl_of_ench_am_s]
(21390,8732,1,1,2,5200.655661),-- [general_75_s]
(21390,8742,1,1,2,1300.279311),-- [special_75_s]
(21390,8752,1,1,2,130.166406),-- [rare_75_s]
(21390,1344,40,120,2,195022.971747),-- [mithril_arrow]
(21391,6695,1,1,-1,28824),-- [demon_splinter_blade]
(21391,6696,1,1,-1,29845),-- [heavens_divider_edge]
(21391,6697,1,1,-1,28824),-- [arcana_mace_head]
(21391,57,6703,13681,0,700000),-- [adena]
(21391,11974,1,1,1,111.524267),-- [elysian_low]
(21391,5533,1,1,1,1720.738623),-- [elysian_head]
(21391,11970,1,1,1,111.524267),-- [worldtree's_branch_low]
(21391,5544,1,1,1,1719.038759),-- [worldtree's_branch_head]
(21391,11969,1,1,1,111.524267),-- [dragon_flame_head_low]
(21391,8342,1,1,1,1720.738623),-- [dragon_flame_head_piece]
(21391,11966,1,1,1,111.524267),-- [doom_crusher_low]
(21391,8349,1,1,1,1720.386927),-- [doom_crusher_head]
(21391,1869,2,6,2,100368.65358),-- [iron_ore]
(21391,1870,3,9,2,83640.54465),-- [coal]
(21391,1871,3,9,2,71691.687702),-- [charcoal]
(21391,1872,8,24,2,41820.029994),-- [animal_bone]
(21391,1867,13,39,2,24782.222046),-- [animal_skin]
(21391,960,1,1,2,200.650068),-- [scrl_of_ench_am_s]
(21391,8732,1,1,2,4182.148398),-- [general_75_s]
(21391,8742,1,1,2,1045.415934),-- [special_75_s]
(21391,8752,1,1,2,104.686992),-- [rare_75_s]
(21391,1344,40,120,2,156825.960636),-- [mithril_arrow]
(21392,9630,1,1,-1,88230),-- [oricalcum]
(21392,959,1,1,-1,671),-- [scrl_of_ench_wp_s]
(21392,9991,1,1,-1,39306),-- [sealed_dynasty_earring_gem]
(21392,57,8265,16868,0,700000),-- [adena]
(21392,9452,1,1,1,34.11387),-- [sealed_dynasty_earring]
(21392,9453,1,1,1,25.58151),-- [sealed_dynasty_neckalce]
(21392,9454,1,1,1,51.170805),-- [sealed_dynasty_ring]
(21392,9991,1,1,1,2418.70608),-- [sealed_dynasty_earring_gem]
(21392,9992,1,1,1,1856.294325),-- [sealed_dynasty_neckalce_gem]
(21392,9993,1,1,1,3399.13341),-- [sealed_dynasty_ring_gem]
(21392,1879,1,1,2,114623.20554),-- [cokes]
(21392,1885,1,1,2,57311.60277),-- [high_grade_suede]
(21392,9628,1,1,2,5394.08611),-- [renad]
(21392,9630,1,1,2,3619.65136),-- [oricalcum]
(21392,9629,1,1,2,2990.24029),-- [adamantium]
(21392,9573,1,1,2,4776.01578),-- [general_80_s]
(21392,9574,1,1,2,1193.90618),-- [special_80_s]
(21392,9575,1,1,2,119.46883),-- [rare_80_s]
(21392,9551,1,1,2,5501.82314),-- [ore_of_holy]
(21393,959,1,1,-1,604),-- [scrl_of_ench_wp_s]
(21393,1877,1,1,-1,603958),-- [admantite_nugget]
(21393,4041,1,1,-1,131295),-- [mold_hardener]
(21393,57,7443,15195,0,700000),-- [adena]
(21393,11976,1,1,1,495.55506),-- [tallum_glaive_low]
(21393,5541,1,1,1,7644.44494),-- [tallum_glaive_edge]
(21393,1871,1,3,2,309722.274576),-- [charcoal]
(21393,1866,1,3,2,137654.178744),-- [suede]
(21393,1877,1,1,2,24777.642936),-- [admantite_nugget]
(21393,4041,1,1,2,5386.422528),-- [mold_hardener]
(21393,4040,1,1,2,12389.069736),-- [mold_lubricant]
(21393,959,1,1,2,24.8268),-- [scrl_of_ench_wp_s]
(21393,8732,1,1,2,5161.988256),-- [general_75_s]
(21393,8742,1,1,2,1290.497064),-- [special_75_s]
(21393,8752,1,1,2,129.09936),-- [rare_75_s]
(21394,1808,1,1,-1,5069),-- [rp_soulshot_s]
(21394,5527,1,1,-1,136356),-- [sealed_helm_of_nightmare_design]
(21394,3036,1,1,-1,5069),-- [rp_spiritshot_s]
(21394,57,5623,11476,0,700000),-- [adena]
(21394,11967,1,1,1,374.33205),-- [dragon_grinder_low]
(21394,5538,1,1,1,5775.66795),-- [dragon_grinder_edge]
(21394,1894,1,1,2,16417.24833),-- [crafted_leather]
(21394,4039,1,1,2,15596.123964),-- [mold_glue]
(21394,4041,1,1,2,4068.599634),-- [mold_hardener]
(21394,4044,1,1,2,15596.123964),-- [thons]
(21394,960,1,1,2,187.206576),-- [scrl_of_ench_am_s]
(21394,8732,1,1,2,3899.205624),-- [general_75_s]
(21394,8742,1,1,2,974.801406),-- [special_75_s]
(21394,8752,1,1,2,97.445214),-- [rare_75_s]
(21394,1344,20,60,2,292429.245288),-- [mithril_arrow]
(21395,6901,1,1,-1,14948),-- [rp_shining_arrow]
(21395,10114,1,1,-1,37063),-- [sealed_dynasty_sigil_piece]
(21395,960,1,1,-1,5979),-- [scrl_of_ench_am_s]
(21395,57,7372,15047,0,700000),-- [adena]
(21395,9514,1,1,1,11.310494),-- [sealed_dynasty_blast_plate]
(21395,9515,1,1,1,18.095194),-- [sealed_dynasty_gaiter]
(21395,9530,1,1,1,2009.276932),-- [sealed_dynasty_blast_plate_piece]
(21395,9531,1,1,1,5943.31738),-- [sealed_dynasty_gaiter_piece]
(21395,1879,1,1,2,102210.625608),-- [cokes]
(21395,1885,1,1,2,51105.312804),-- [high_grade_suede]
(21395,9628,1,1,2,4809.958972),-- [renad]
(21395,9630,1,1,2,3227.678272),-- [oricalcum]
(21395,9629,1,1,2,2666.426308),-- [adamantium]
(21395,9573,1,1,2,4258.819656),-- [general_80_s]
(21395,9574,1,1,2,1064.617736),-- [special_80_s]
(21395,9575,1,1,2,106.531516),-- [rare_80_s]
(21395,9548,1,1,2,4906.029128),-- [ore_of_earth]
(21396,3036,1,1,-1,2766),-- [rp_spiritshot_s]
(21396,6342,1,1,-1,140959),-- [sealed_majestic_earing_gemstone]
(21396,4040,1,1,-1,124452),-- [mold_lubricant]
(21396,57,3069,6264,0,700000),-- [adena]
(21396,11946,1,1,1,79.060934),-- [dasparion's_staff_low]
(21396,5543,1,1,1,977.596656),-- [dasparion's_staff_head]
(21396,11949,1,1,1,79.060934),-- [meteor_shower_low]
(21396,5532,1,1,1,968.466006),-- [meteor_shower_head]
(21396,11953,1,1,1,79.060934),-- [eye_of_soul_low]
(21396,8341,1,1,1,967.227596),-- [eye_of_soul_piece]
(21396,11958,1,1,1,79.060934),-- [hammer_of_destroyer_low]
(21396,8346,1,1,1,968.466006),-- [hammer_of_destroyer_piece]
(21396,1871,1,1,2,255286.773236),-- [charcoal]
(21396,1866,1,1,2,170191.330771),-- [suede]
(21396,1877,1,1,2,10211.542264),-- [admantite_nugget]
(21396,4041,1,1,2,2219.842339),-- [mold_hardener]
(21396,4040,1,1,2,5105.771132),-- [mold_lubricant]
(21396,5157,1,1,2,113.243614),-- [rp_comp_soulshot_s]
(21396,8732,1,1,2,2127.553252),-- [general_75_s]
(21396,8742,1,1,2,531.888313),-- [special_75_s]
(21396,8752,1,1,2,53.055079),-- [rare_75_s]
(21397,3036,1,1,-1,2696),-- [rp_spiritshot_s]
(21397,6342,1,1,-1,137412),-- [sealed_majestic_earing_gemstone]
(21397,4040,1,1,-1,121321),-- [mold_lubricant]
(21397,57,2992,6106,0,700000),-- [adena]
(21397,11946,1,1,1,77.064636),-- [dasparion's_staff_low]
(21397,5543,1,1,1,952.912224),-- [dasparion's_staff_head]
(21397,11949,1,1,1,77.064636),-- [meteor_shower_low]
(21397,5532,1,1,1,944.012124),-- [meteor_shower_head]
(21397,11953,1,1,1,77.064636),-- [eye_of_soul_low]
(21397,8341,1,1,1,942.804984),-- [eye_of_soul_piece]
(21397,11958,1,1,1,77.064636),-- [hammer_of_destroyer_low]
(21397,8346,1,1,1,944.012124),-- [hammer_of_destroyer_piece]
(21397,1871,1,1,2,248862.818712),-- [charcoal]
(21397,1866,1,1,2,165908.690682),-- [suede]
(21397,1877,1,1,2,9954.582288),-- [admantite_nugget]
(21397,4041,1,1,2,2163.982938),-- [mold_hardener]
(21397,4040,1,1,2,4977.291144),-- [mold_lubricant]
(21397,5157,1,1,2,110.393988),-- [rp_comp_soulshot_s]
(21397,8732,1,1,2,2074.016184),-- [general_75_s]
(21397,8742,1,1,2,518.504046),-- [special_75_s]
(21397,8752,1,1,2,51.720018),-- [rare_75_s]
(21398,6346,1,1,-1,375006),-- [sealed_majestic_ring_gemstrone]
(21398,5157,1,1,-1,5119),-- [rp_comp_soulshot_s]
(21398,5480,1,1,-1,51685),-- [sealed_leather_mail_of_nightmare_fabric]
(21398,57,5681,11595,0,700000),-- [adena]
(21398,11960,1,1,1,585.376344),-- [halbard_low]
(21398,5542,1,1,1,7170.623656),-- [halbard_edge]
(21398,1895,1,1,2,151890.192336),-- [metallic_fiber]
(21398,4040,1,1,2,10632.305664),-- [mold_lubricant]
(21398,4042,1,1,2,8860.25472),-- [enria]
(21398,4043,1,1,2,17720.50944),-- [asofe]
(21398,5167,1,1,2,236.325456),-- [rp_comp_bspiritshot_s]
(21398,8732,1,1,2,4430.12736),-- [general_75_s]
(21398,8742,1,1,2,1107.53184),-- [special_75_s]
(21398,8752,1,1,2,110.753184),-- [rare_75_s]
(21399,6346,1,1,-1,329100),-- [sealed_majestic_ring_gemstrone]
(21399,5157,1,1,-1,4493),-- [rp_comp_soulshot_s]
(21399,5480,1,1,-1,45358),-- [sealed_leather_mail_of_nightmare_fabric]
(21399,57,4986,10175,0,700000),-- [adena]
(21399,11960,1,1,1,513.751518),-- [halbard_low]
(21399,5542,1,1,1,6293.248482),-- [halbard_edge]
(21399,1895,1,1,2,133296.130696),-- [metallic_fiber]
(21399,4040,1,1,2,9330.722304),-- [mold_lubricant]
(21399,4042,1,1,2,7775.60192),-- [enria]
(21399,4043,1,1,2,15551.20384),-- [asofe]
(21399,5167,1,1,2,207.395016),-- [rp_comp_bspiritshot_s]
(21399,8732,1,1,2,3887.80096),-- [general_75_s]
(21399,8742,1,1,2,971.95024),-- [special_75_s]
(21399,8752,1,1,2,97.195024),-- [rare_75_s]
(21400,5528,1,1,-1,112808),-- [sealed_magestic_circlet_design]
(21400,4042,1,1,-1,157255),-- [enria]
(21400,1876,1,3,-1,943530),-- [mithril_ore]
(21400,57,4652,9494,0,700000),-- [adena]
(21400,11976,1,1,1,309.691473),-- [tallum_glaive_low]
(21400,5541,1,1,1,4777.308527),-- [tallum_glaive_edge]
(21400,1873,1,1,2,154835.8878),-- [silver_nugget]
(21400,1868,3,9,2,129029.58486),-- [thread]
(21400,1876,1,1,2,77417.9439),-- [mithril_ore]
(21400,1895,1,1,2,110596.7181),-- [metallic_fiber]
(21400,4042,1,1,2,6451.45512),-- [enria]
(21400,959,1,1,2,15.43872),-- [scrl_of_ench_wp_s]
(21400,8732,1,1,2,3225.72756),-- [general_75_s]
(21400,8742,1,1,2,806.67312),-- [special_75_s]
(21400,8752,1,1,2,80.57082),-- [rare_75_s]
(21401,5528,1,1,-1,99266),-- [sealed_magestic_circlet_design]
(21401,4042,1,1,-1,138377),-- [enria]
(21401,1876,1,3,-1,830263),-- [mithril_ore]
(21401,57,4094,8354,0,700000),-- [adena]
(21401,11976,1,1,1,272.494404),-- [tallum_glaive_low]
(21401,5541,1,1,1,4203.505596),-- [tallum_glaive_edge]
(21401,1873,1,1,2,136248.26406),-- [silver_nugget]
(21401,1868,3,9,2,113539.937022),-- [thread]
(21401,1876,1,1,2,68124.13203),-- [mithril_ore]
(21401,1895,1,1,2,97319.88537),-- [metallic_fiber]
(21401,4042,1,1,2,5676.975624),-- [enria]
(21401,959,1,1,2,13.585344),-- [scrl_of_ench_wp_s]
(21401,8732,1,1,2,2838.487812),-- [general_75_s]
(21401,8742,1,1,2,709.834224),-- [special_75_s]
(21401,8752,1,1,2,70.898514),-- [rare_75_s]
(21402,5157,1,1,-1,3808),-- [rp_comp_soulshot_s]
(21402,5534,1,1,-1,23519),-- [soul_bow_shaft]
(21402,4044,1,1,-1,285564),-- [thons]
(21402,57,4224,8620,0,700000),-- [adena]
(21402,11975,1,1,1,281.156991),-- [soul_bow_low]
(21402,5534,1,1,1,4341.843009),-- [soul_bow_shaft]
(21402,1868,3,9,2,117154.17224),-- [thread]
(21402,1873,1,1,2,140585.1394),-- [silver_nugget]
(21402,5549,1,1,2,35146.11896),-- [iron_thread]
(21402,1889,1,1,2,23430.96716),-- [compound_braid]
(21402,4044,1,1,2,11715.48358),-- [thons]
(21402,959,1,1,2,13.93476),-- [scrl_of_ench_wp_s]
(21402,8732,1,1,2,2928.95384),-- [general_75_s]
(21402,8742,1,1,2,732.23846),-- [special_75_s]
(21402,8752,1,1,2,72.9916),-- [rare_75_s]
(21403,5157,1,1,-1,4395),-- [rp_comp_soulshot_s]
(21403,5534,1,1,-1,27147),-- [soul_bow_shaft]
(21403,4044,1,1,-1,329609),-- [thons]
(21403,57,4875,9950,0,700000),-- [adena]
(21403,11975,1,1,1,324.519512),-- [soul_bow_low]
(21403,5534,1,1,1,5011.480488),-- [soul_bow_shaft]
(21403,1868,3,9,2,135224.47414),-- [thread]
(21403,1873,1,1,2,162269.52215),-- [silver_nugget]
(21403,5549,1,1,2,40567.18906),-- [iron_thread]
(21403,1889,1,1,2,27045.04801),-- [compound_braid]
(21403,4044,1,1,2,13522.524005),-- [thons]
(21403,959,1,1,2,16.08411),-- [scrl_of_ench_wp_s]
(21403,8732,1,1,2,3380.72674),-- [general_75_s]
(21403,8742,1,1,2,845.181685),-- [special_75_s]
(21403,8752,1,1,2,84.2501),-- [rare_75_s]
(21404,5167,1,1,-1,5086),-- [rp_comp_bspiritshot_s]
(21404,5515,1,1,-1,193288),-- [sealed_magestic_gloves_design]
(21404,6901,1,1,-1,11445),-- [rp_shining_arrow]
(21404,57,5642,11518,0,700000),-- [adena]
(21404,12266,1,1,1,590.19288),-- [sealed_robe_of_nightmare_low]
(21404,5487,1,1,1,4757.30712),-- [sealed_robe_of_nightmare_fabric]
(21404,12259,1,1,1,590.19288),-- [sealed_majestic_robe_low]
(21404,5488,1,1,1,4757.30712),-- [sealed_majestic_robe_fabric]
(21404,1869,2,6,2,117380.510895),-- [iron_ore]
(21404,1870,2,6,2,93904.408716),-- [coal]
(21404,1871,3,9,2,78253.67393),-- [charcoal]
(21404,1872,7,21,2,44716.280718),-- [animal_bone]
(21404,1867,12,36,2,26084.679759),-- [animal_skin]
(21404,959,1,1,2,18.632697),-- [scrl_of_ench_wp_s]
(21404,8732,1,1,2,3912.86637),-- [general_75_s]
(21404,8742,1,1,2,978.033919),-- [special_75_s]
(21404,8752,1,1,2,97.912996),-- [rare_75_s]
(21405,5167,1,1,-1,3634),-- [rp_comp_bspiritshot_s]
(21405,5515,1,1,-1,138112),-- [sealed_magestic_gloves_design]
(21405,6901,1,1,-1,8178),-- [rp_shining_arrow]
(21405,57,4031,8230,0,700000),-- [adena]
(21405,12266,1,1,1,421.716128),-- [sealed_robe_of_nightmare_low]
(21405,5487,1,1,1,3399.283872),-- [sealed_robe_of_nightmare_fabric]
(21405,12259,1,1,1,421.716128),-- [sealed_majestic_robe_low]
(21405,5488,1,1,1,3399.283872),-- [sealed_majestic_robe_fabric]
(21405,1869,2,6,2,83872.840106),-- [iron_ore]
(21405,1870,2,6,2,67098.428694),-- [coal]
(21405,1871,3,9,2,55915.357245),-- [charcoal]
(21405,1872,7,21,2,31951.408984),-- [animal_bone]
(21405,1867,1,3,2,149107.227797),-- [animal_skin]
(21405,959,1,1,2,13.311782),-- [scrl_of_ench_wp_s]
(21405,8732,1,1,2,2795.865743),-- [general_75_s]
(21405,8742,1,1,2,698.868555),-- [special_75_s]
(21405,8752,1,1,2,69.691094),-- [rare_75_s]
(21406,5523,1,1,-1,37932),-- [sealed_majestic_platte_armor_pattern]
(21406,5277,1,1,-1,4950),-- [rp_adv_comp_spiritshot_s]
(21406,5527,1,1,-1,133170),-- [sealed_helm_of_nightmare_design]
(21406,57,5491,11210,0,700000),-- [adena]
(21406,12267,1,1,1,1398.83956),-- [sealed_boots_of_nightmare_low]
(21406,5502,1,1,1,8682.16044),-- [sealed_boots_of_nightmare_lining]
(21406,12260,1,1,1,1398.83956),-- [sealed_magestic_boots_low]
(21406,5503,1,1,1,8682.16044),-- [sealed_magestic_boots_lining]
(21406,12264,1,1,1,1398.83956),-- [sealed_gloves_of_nightmare_low]
(21406,5514,1,1,1,8682.16044),-- [sealed_gloves_of_nightmare_design]
(21406,12257,1,1,1,1398.83956),-- [sealed_magestic_gloves_low]
(21406,5515,1,1,1,8682.16044),-- [sealed_magestic_gloves_design]
(21406,1873,2,6,2,45695.578698),-- [silver_nugget]
(21406,1868,3,9,2,152318.59566),-- [thread]
(21406,1876,1,1,2,91391.157396),-- [mithril_ore]
(21406,1895,1,1,2,130558.858059),-- [metallic_fiber]
(21406,4042,1,1,2,7615.929783),-- [enria]
(21406,959,1,1,2,18.163026),-- [scrl_of_ench_wp_s]
(21406,8732,1,1,2,3807.748665),-- [general_75_s]
(21406,8742,1,1,2,951.829053),-- [special_75_s]
(21406,8752,1,1,2,95.13966),-- [rare_75_s]
(21407,5523,1,1,-1,24314),-- [sealed_majestic_platte_armor_pattern]
(21407,5277,1,1,-1,3173),-- [rp_adv_comp_spiritshot_s]
(21407,5527,1,1,-1,85361),-- [sealed_helm_of_nightmare_design]
(21407,57,3520,7185,0,700000),-- [adena]
(21407,12267,1,1,1,896.66712),-- [sealed_boots_of_nightmare_low]
(21407,5502,1,1,1,5565.33288),-- [sealed_boots_of_nightmare_lining]
(21407,12260,1,1,1,896.66712),-- [sealed_magestic_boots_low]
(21407,5503,1,1,1,5565.33288),-- [sealed_magestic_boots_lining]
(21407,12264,1,1,1,896.66712),-- [sealed_gloves_of_nightmare_low]
(21407,5514,1,1,1,5565.33288),-- [sealed_gloves_of_nightmare_design]
(21407,12257,1,1,1,896.66712),-- [sealed_magestic_gloves_low]
(21407,5515,1,1,1,5565.33288),-- [sealed_magestic_gloves_design]
(21407,1873,1,1,2,117162.87789),-- [silver_nugget]
(21407,1868,3,9,2,97635.488193),-- [thread]
(21407,1876,1,1,2,58581.438945),-- [mithril_ore]
(21407,1895,1,1,2,83687.509155),-- [metallic_fiber]
(21407,4042,1,1,2,4881.756156),-- [enria]
(21407,959,1,1,2,11.682336),-- [scrl_of_ench_wp_s]
(21407,8732,1,1,2,2440.878078),-- [general_75_s]
(21407,8742,1,1,2,610.402056),-- [special_75_s]
(21407,8752,1,1,2,60.967191),-- [rare_75_s]
(21408,5282,1,1,-1,4677),-- [rp_adv_comp_bspiritshot_s]
(21408,5529,1,1,-1,28873),-- [dragon_slayer_edge]
(21408,6901,1,1,-1,10524),-- [rp_shining_arrow]
(21408,57,5188,10592,0,700000),-- [adena]
(21408,11968,1,1,1,115.141829),-- [dragon_slayer_low]
(21408,5529,1,1,1,1776.907743),-- [dragon_slayer_edge]
(21408,11971,1,1,1,115.141829),-- [sword_of_miracle_low]
(21408,5546,1,1,1,1951.759027),-- [sword_of_miracle_edge]
(21408,11964,1,1,1,115.141829),-- [dark_legion's_edge_low]
(21408,5545,1,1,1,1776.907743),-- [dark_legion's_edge_edge]
(21408,1868,3,9,2,143918.699316),-- [thread]
(21408,1873,1,1,2,172702.60221),-- [silver_nugget]
(21408,5549,1,1,2,43175.446764),-- [iron_thread]
(21408,1889,1,1,2,28783.902894),-- [compound_braid]
(21408,4044,1,1,2,14391.951447),-- [thons]
(21408,959,1,1,2,17.118234),-- [scrl_of_ench_wp_s]
(21408,8732,1,1,2,3598.089756),-- [general_75_s]
(21408,8742,1,1,2,899.522439),-- [special_75_s]
(21408,8752,1,1,2,89.66694),-- [rare_75_s]
(21409,5282,1,1,-1,5231),-- [rp_adv_comp_bspiritshot_s]
(21409,5529,1,1,-1,32288),-- [dragon_slayer_edge]
(21409,6901,1,1,-1,11769),-- [rp_shining_arrow]
(21409,57,5802,11844,0,700000),-- [adena]
(21409,11968,1,1,1,128.759697),-- [dragon_slayer_low]
(21409,5529,1,1,1,1987.063299),-- [dragon_slayer_edge]
(21409,11971,1,1,1,128.759697),-- [sword_of_miracle_low]
(21409,5546,1,1,1,2182.594311),-- [sword_of_miracle_edge]
(21409,11964,1,1,1,128.759697),-- [dark_legion's_edge_low]
(21409,5545,1,1,1,1987.063299),-- [dark_legion's_edge_edge]
(21409,1868,3,9,2,160941.32978),-- [thread]
(21409,1873,1,1,2,193129.77805),-- [silver_nugget]
(21409,5549,1,1,2,48282.21662),-- [iron_thread]
(21409,1889,1,1,2,32188.44827),-- [compound_braid]
(21409,4044,1,1,2,16094.224135),-- [thons]
(21409,959,1,1,2,19.14297),-- [scrl_of_ench_wp_s]
(21409,8732,1,1,2,4023.66998),-- [general_75_s]
(21409,8742,1,1,2,1005.917495),-- [special_75_s]
(21409,8752,1,1,2,100.2727),-- [rare_75_s]
(21410,5538,1,1,-1,29251),-- [dragon_grinder_edge]
(21410,5282,1,1,-1,4740),-- [rp_adv_comp_bspiritshot_s]
(21410,5541,1,1,-1,29245),-- [tallum_glaive_edge]
(21410,57,5247,10744,0,700000),-- [adena]
(21410,12352,1,1,1,1614.370707),-- [sealed_majestic_earing_low]
(21410,6342,1,1,1,14865.567783),-- [sealed_majestic_earing_gemstone]
(21410,12350,1,1,1,1211.914983),-- [sealed_majestic_necklace_low]
(21410,6344,1,1,1,9620.153235),-- [sealed_majestic_necklace_beads]
(21410,12351,1,1,1,2421.530511),-- [sealed_majestic_ring_low]
(21410,6346,1,1,1,21365.462781),-- [sealed_majestic_ring_gemstrone]
(21410,1867,5,15,2,52499.19648),-- [animal_skin]
(21410,1872,1,3,2,174997.78436),-- [animal_bone]
(21410,1882,1,1,2,87498.6608),-- [leather]
(21410,1894,1,1,2,13815.6998),-- [crafted_leather]
(21410,4042,1,1,2,6562.39956),-- [enria]
(21410,960,1,1,2,157.3384),-- [scrl_of_ench_am_s]
(21410,8732,1,1,2,3281.43116),-- [general_75_s]
(21410,8742,1,1,2,820.47348),-- [special_75_s]
(21410,8752,1,1,2,81.90852),-- [rare_75_s]
(21410,1344,40,120,2,123045.10744),-- [mithril_arrow]
(21411,5538,1,1,-1,23844),-- [dragon_grinder_edge]
(21411,5282,1,1,-1,3864),-- [rp_adv_comp_bspiritshot_s]
(21411,5541,1,1,-1,23839),-- [tallum_glaive_edge]
(21411,57,4277,8758,0,700000),-- [adena]
(21411,12352,1,1,1,1315.974822),-- [sealed_majestic_earing_low]
(21411,6342,1,1,1,12117.856718),-- [sealed_majestic_earing_gemstone]
(21411,12350,1,1,1,987.907918),-- [sealed_majestic_necklace_low]
(21411,6344,1,1,1,7841.99031),-- [sealed_majestic_necklace_beads]
(21411,12351,1,1,1,1973.941406),-- [sealed_majestic_ring_low]
(21411,6346,1,1,1,17416.328826),-- [sealed_majestic_ring_gemstrone]
(21411,1867,5,15,2,42795.875592),-- [animal_skin]
(21411,1872,1,3,2,142653.295869),-- [animal_bone]
(21411,1882,1,1,2,71326.45932),-- [leather]
(21411,1894,1,1,2,11262.171795),-- [crafted_leather]
(21411,4042,1,1,2,5349.484449),-- [enria]
(21411,960,1,1,2,128.25786),-- [scrl_of_ench_am_s]
(21411,8732,1,1,2,2674.930839),-- [general_75_s]
(21411,8742,1,1,2,668.827017),-- [special_75_s]
(21411,8752,1,1,2,66.769533),-- [rare_75_s]
(21411,1344,40,120,2,100302.927726),-- [mithril_arrow]
(21412,1876,1,5,-1,924871),-- [mithril_ore]
(21412,5545,1,1,-1,38061),-- [dark_legion's_edge_edge]
(21412,1808,1,1,-1,6166),-- [rp_soulshot_s]
(21412,57,6826,13977,0,700000),-- [adena]
(21412,12268,1,1,1,2214.614004),-- [sealed_shield_of_nightmare_low]
(21412,5495,1,1,1,12963.909368),-- [sealed_shield_of_nightmare_fragment]
(21412,12269,1,1,1,1549.42114),-- [sealed_helm_of_nightmare_low]
(21412,5527,1,1,1,10207.297828),-- [sealed_helm_of_nightmare_design]
(21412,12261,1,1,1,1549.42114),-- [sealed_magestic_circlet_low]
(21412,5528,1,1,1,10207.33652),-- [sealed_magestic_circlet_design]
(21412,1873,3,9,2,34149.084573),-- [silver_nugget]
(21412,1868,4,12,2,128058.950179),-- [thread]
(21412,1876,1,1,2,102447.253719),-- [mithril_ore]
(21412,1895,1,1,2,146353.019079),-- [metallic_fiber]
(21412,4042,1,1,2,8537.388113),-- [enria]
(21412,960,1,1,2,204.931002),-- [scrl_of_ench_am_s]
(21412,8732,1,1,2,4268.460117),-- [general_75_s]
(21412,8742,1,1,2,1067.231999),-- [special_75_s]
(21412,8752,1,1,2,106.676412),-- [rare_75_s]
(21412,1344,150,450,2,42686.004807),-- [mithril_arrow]
(21413,1876,1,5,-1,711201),-- [mithril_ore]
(21413,5545,1,1,-1,29268),-- [dark_legion's_edge_edge]
(21413,1808,1,1,-1,4741),-- [rp_soulshot_s]
(21413,57,5249,10748,0,700000),-- [adena]
(21413,12268,1,1,1,1702.972461),-- [sealed_shield_of_nightmare_low]
(21413,5495,1,1,1,9968.861662),-- [sealed_shield_of_nightmare_fragment]
(21413,12269,1,1,1,1191.458885),-- [sealed_helm_of_nightmare_low]
(21413,5527,1,1,1,7849.109177),-- [sealed_helm_of_nightmare_design]
(21413,12261,1,1,1,1191.458885),-- [sealed_magestic_circlet_low]
(21413,5528,1,1,1,7849.13893),-- [sealed_magestic_circlet_design]
(21413,1873,1,1,2,157558.238145),-- [silver_nugget]
(21413,1868,4,12,2,98473.837455),-- [thread]
(21413,1876,1,1,2,78778.87353),-- [mithril_ore]
(21413,1895,1,1,2,112541.458365),-- [metallic_fiber]
(21413,4042,1,1,2,6564.82428),-- [enria]
(21413,960,1,1,2,157.638285),-- [scrl_of_ench_am_s]
(21413,8732,1,1,2,3282.41214),-- [general_75_s]
(21413,8742,1,1,2,820.603035),-- [special_75_s]
(21413,8752,1,1,2,82.011195),-- [rare_75_s]
(21413,1344,150,450,2,32825.10357),-- [mithril_arrow]
(21414,4040,1,1,-1,207354),-- [mold_lubricant]
(21414,1877,1,1,-1,414708),-- [admantite_nugget]
(21414,6344,1,1,-1,151985),-- [sealed_majestic_necklace_beads]
(21414,57,5101,10446,0,700000),-- [adena]
(21414,11974,1,1,1,85.070169),-- [elysian_low]
(21414,5533,1,1,1,1312.571061),-- [elysian_head]
(21414,11970,1,1,1,85.070169),-- [worldtree's_branch_low]
(21414,5544,1,1,1,1311.274413),-- [worldtree's_branch_head]
(21414,11969,1,1,1,85.070169),-- [dragon_flame_head_low]
(21414,8342,1,1,1,1312.571061),-- [dragon_flame_head_piece]
(21414,11966,1,1,1,85.070169),-- [doom_crusher_low]
(21414,8349,1,1,1,1312.302789),-- [doom_crusher_head]
(21414,1871,1,3,2,127602.326264),-- [charcoal]
(21414,1866,2,6,2,63801.39372),-- [suede]
(21414,1877,1,1,2,15312.426728),-- [admantite_nugget]
(21414,4041,1,1,2,3328.768368),-- [mold_hardener]
(21414,4040,1,1,2,7655.982776),-- [mold_lubricant]
(21414,960,1,1,2,153.110432),-- [scrl_of_ench_am_s]
(21414,8732,1,1,2,3189.954392),-- [general_75_s]
(21414,8742,1,1,2,797.373304),-- [special_75_s]
(21414,8752,1,1,2,79.783448),-- [rare_75_s]
(21414,1344,20,60,2,239254.880568),-- [mithril_arrow]
(21415,4040,1,1,-1,209177),-- [mold_lubricant]
(21415,1877,1,1,-1,418353),-- [admantite_nugget]
(21415,6344,1,1,-1,153322),-- [sealed_majestic_necklace_beads]
(21415,57,5146,10537,0,700000),-- [adena]
(21415,11974,1,1,1,85.815998),-- [elysian_low]
(21415,5533,1,1,1,1324.078662),-- [elysian_head]
(21415,11970,1,1,1,85.815998),-- [worldtree's_branch_low]
(21415,5544,1,1,1,1322.770646),-- [worldtree's_branch_head]
(21415,11969,1,1,1,85.815998),-- [dragon_flame_head_low]
(21415,8342,1,1,1,1324.078662),-- [dragon_flame_head_piece]
(21415,11966,1,1,1,85.815998),-- [doom_crusher_low]
(21415,8349,1,1,1,1323.808038),-- [doom_crusher_head]
(21415,1871,1,3,2,128724.02347),-- [charcoal]
(21415,1866,2,6,2,64362.24435),-- [suede]
(21415,1877,1,1,2,15447.03169),-- [admantite_nugget]
(21415,4041,1,1,2,3358.03014),-- [mold_hardener]
(21415,4040,1,1,2,7723.28323),-- [mold_lubricant]
(21415,960,1,1,2,154.45636),-- [scrl_of_ench_am_s]
(21415,8732,1,1,2,3217.99591),-- [general_75_s]
(21415,8742,1,1,2,804.38267),-- [special_75_s]
(21415,8752,1,1,2,80.48479),-- [rare_75_s]
(21415,1344,20,60,2,241358.06739),-- [mithril_arrow]
(21416,5480,1,1,-1,48118),-- [sealed_leather_mail_of_nightmare_fabric]
(21416,1885,1,1,-1,893618),-- [high_grade_suede]
(21416,4041,1,1,-1,93247),-- [mold_hardener]
(21416,57,5276,10804,0,700000),-- [adena]
(21416,11975,1,1,1,351.947979),-- [soul_bow_low]
(21416,5534,1,1,1,5435.052021),-- [soul_bow_shaft]
(21416,1866,2,6,2,65990.263896),-- [suede]
(21416,1871,1,3,2,131980.223688),-- [charcoal]
(21416,5220,1,1,2,15837.73632),-- [reinforcing_agent]
(21416,1885,1,1,2,32994.979896),-- [high_grade_suede]
(21416,4041,1,1,2,3443.065488),-- [mold_hardener]
(21416,960,1,1,2,158.438184),-- [scrl_of_ench_am_s]
(21416,8732,1,1,2,3299.5284),-- [general_75_s]
(21416,8742,1,1,2,824.730048),-- [special_75_s]
(21416,8752,1,1,2,82.412184),-- [rare_75_s]
(21416,1344,100,300,2,49492.621896),-- [mithril_arrow]
(21417,5480,1,1,-1,74982),-- [sealed_leather_mail_of_nightmare_fabric]
(21417,1885,1,3,-1,696251),-- [high_grade_suede]
(21417,4041,1,1,-1,145305),-- [mold_hardener]
(21417,57,8221,16836,0,700000),-- [adena]
(21417,11975,1,1,1,548.447706),-- [soul_bow_low]
(21417,5534,1,1,1,8469.552294),-- [soul_bow_shaft]
(21417,1866,2,6,2,102830.835123),-- [suede]
(21417,1871,1,3,2,205661.196369),-- [charcoal]
(21417,5220,1,1,2,24679.51416),-- [reinforcing_agent]
(21417,1885,1,1,2,51415.180623),-- [high_grade_suede]
(21417,4041,1,1,2,5365.235394),-- [mold_hardener]
(21417,960,1,1,2,246.889917),-- [scrl_of_ench_am_s]
(21417,8732,1,1,2,5141.56545),-- [general_75_s]
(21417,8742,1,1,2,1285.154424),-- [special_75_s]
(21417,8752,1,1,2,128.420667),-- [rare_75_s]
(21417,1344,100,300,2,77123.007873),-- [mithril_arrow]
(21418,3036,1,1,-1,3947),-- [rp_spiritshot_s]
(21418,5528,1,1,-1,106180),-- [sealed_magestic_circlet_design]
(21418,4044,1,1,-1,296030),-- [thons]
(21418,57,4369,8949,0,700000),-- [adena]
(21418,12268,1,1,1,1417.703253),-- [sealed_shield_of_nightmare_low]
(21418,5495,1,1,1,8298.952526),-- [sealed_shield_of_nightmare_fragment]
(21418,12269,1,1,1,991.874605),-- [sealed_helm_of_nightmare_low]
(21418,5527,1,1,1,6534.285121),-- [sealed_helm_of_nightmare_design]
(21418,12261,1,1,1,991.874605),-- [sealed_magestic_circlet_low]
(21418,5528,1,1,1,6534.30989),-- [sealed_magestic_circlet_design]
(21418,1868,3,9,2,121448.318628),-- [thread]
(21418,1873,1,1,2,145738.11993),-- [silver_nugget]
(21418,5549,1,1,2,36434.358012),-- [iron_thread]
(21418,1889,1,1,2,24289.801302),-- [compound_braid]
(21418,4044,1,1,2,12144.900651),-- [thons]
(21418,959,1,1,2,14.445522),-- [scrl_of_ench_wp_s]
(21418,8732,1,1,2,3036.311148),-- [general_75_s]
(21418,8742,1,1,2,759.077787),-- [special_75_s]
(21418,8752,1,1,2,75.66702),-- [rare_75_s]
(21419,3036,1,1,-1,4020),-- [rp_spiritshot_s]
(21419,5528,1,1,-1,108137),-- [sealed_magestic_circlet_design]
(21419,4044,1,1,-1,301486),-- [thons]
(21419,57,4450,9114,0,700000),-- [adena]
(21419,12268,1,1,1,1443.803325),-- [sealed_shield_of_nightmare_low]
(21419,5495,1,1,1,8451.73715),-- [sealed_shield_of_nightmare_fragment]
(21419,12269,1,1,1,1010.135125),-- [sealed_helm_of_nightmare_low]
(21419,5527,1,1,1,6654.582025),-- [sealed_helm_of_nightmare_design]
(21419,12261,1,1,1,1010.135125),-- [sealed_magestic_circlet_low]
(21419,5528,1,1,1,6654.60725),-- [sealed_magestic_circlet_design]
(21419,1868,3,9,2,123686.67024),-- [thread]
(21419,1873,1,1,2,148424.1444),-- [silver_nugget]
(21419,5549,1,1,2,37105.86096),-- [iron_thread]
(21419,1889,1,1,2,24737.47416),-- [compound_braid]
(21419,4044,1,1,2,12368.73708),-- [thons]
(21419,959,1,1,2,14.71176),-- [scrl_of_ench_wp_s]
(21419,8732,1,1,2,3092.27184),-- [general_75_s]
(21419,8742,1,1,2,773.06796),-- [special_75_s]
(21419,8752,1,1,2,77.0616),-- [rare_75_s]
(21420,5533,1,1,-1,30317),-- [elysian_head]
(21420,5157,1,1,-1,4912),-- [rp_comp_soulshot_s]
(21420,5534,1,1,-1,30344),-- [soul_bow_shaft]
(21420,57,5438,11138,0,700000),-- [adena]
(21420,11974,1,1,1,90.686718),-- [elysian_low]
(21420,5533,1,1,1,1399.230342),-- [elysian_head]
(21420,11970,1,1,1,90.686718),-- [worldtree's_branch_low]
(21420,5544,1,1,1,1397.848086),-- [worldtree's_branch_head]
(21420,11969,1,1,1,90.686718),-- [dragon_flame_head_low]
(21420,8342,1,1,1,1399.230342),-- [dragon_flame_head_piece]
(21420,11966,1,1,1,90.686718),-- [doom_crusher_low]
(21420,8349,1,1,1,1398.944358),-- [doom_crusher_head]
(21420,1873,2,6,2,45344.45058),-- [silver_nugget]
(21420,1868,3,9,2,151148.1686),-- [thread]
(21420,1876,1,1,2,90688.90116),-- [mithril_ore]
(21420,1895,1,1,2,129555.63439),-- [metallic_fiber]
(21420,4042,1,1,2,7557.40843),-- [enria]
(21420,959,1,1,2,18.02346),-- [scrl_of_ench_wp_s]
(21420,8732,1,1,2,3778.48965),-- [general_75_s]
(21420,8742,1,1,2,944.51513),-- [special_75_s]
(21420,8752,1,1,2,94.4086),-- [rare_75_s]
(21421,5533,1,1,-1,28459),-- [elysian_head]
(21421,5157,1,1,-1,4611),-- [rp_comp_soulshot_s]
(21421,5534,1,1,-1,28484),-- [soul_bow_shaft]
(21421,57,5104,10455,0,700000),-- [adena]
(21421,11974,1,1,1,85.131053),-- [elysian_low]
(21421,5533,1,1,1,1313.510457),-- [elysian_head]
(21421,11970,1,1,1,85.131053),-- [worldtree's_branch_low]
(21421,5544,1,1,1,1312.212881),-- [worldtree's_branch_head]
(21421,11969,1,1,1,85.131053),-- [dragon_flame_head_low]
(21421,8342,1,1,1,1313.510457),-- [dragon_flame_head_piece]
(21421,11966,1,1,1,85.131053),-- [doom_crusher_low]
(21421,8349,1,1,1,1313.241993),-- [doom_crusher_head]
(21421,1873,2,6,2,42565.43478),-- [silver_nugget]
(21421,1868,3,9,2,141884.7826),-- [thread]
(21421,1876,1,1,2,85130.86956),-- [mithril_ore]
(21421,1895,1,1,2,121615.58549),-- [metallic_fiber]
(21421,4042,1,1,2,7094.23913),-- [enria]
(21421,959,1,1,2,16.91886),-- [scrl_of_ench_wp_s]
(21421,8732,1,1,2,3546.91815),-- [general_75_s]
(21421,8742,1,1,2,886.62883),-- [special_75_s]
(21421,8752,1,1,2,88.6226),-- [rare_75_s]
(21422,5162,1,1,-1,5290),-- [rp_comp_spiritshot_s]
(21422,5538,1,1,-1,32647),-- [dragon_grinder_edge]
(21422,5167,1,1,-1,5290),-- [rp_comp_bspiritshot_s]
(21422,57,5855,11994,0,700000),-- [adena]
(21422,11975,1,1,1,390.627591),-- [soul_bow_low]
(21422,5534,1,1,1,6032.372409),-- [soul_bow_shaft]
(21422,1867,4,12,2,81383.025885),-- [animal_skin]
(21422,1872,1,3,2,217021.839755),-- [animal_bone]
(21422,1882,1,1,2,108510.70118),-- [leather]
(21422,1894,1,1,2,17133.199545),-- [crafted_leather]
(21422,4042,1,1,2,8138.17137),-- [enria]
(21422,959,1,1,2,19.682775),-- [scrl_of_ench_wp_s]
(21422,8732,1,1,2,4069.085685),-- [general_75_s]
(21422,8742,1,1,2,1017.38077),-- [special_75_s]
(21422,8752,1,1,2,101.913035),-- [rare_75_s]
(21423,5162,1,1,-1,5608),-- [rp_comp_spiritshot_s]
(21423,5538,1,1,-1,34609),-- [dragon_grinder_edge]
(21423,5167,1,1,-1,5608),-- [rp_comp_bspiritshot_s]
(21423,57,6207,12714,0,700000),-- [adena]
(21423,11975,1,1,1,414.102953),-- [soul_bow_low]
(21423,5534,1,1,1,6394.897047),-- [soul_bow_shaft]
(21423,1867,4,12,2,86272.575462),-- [animal_skin]
(21423,1872,1,3,2,230060.664906),-- [animal_bone]
(21423,1882,1,1,2,115030.100616),-- [leather]
(21423,1894,1,1,2,18162.574254),-- [crafted_leather]
(21423,4042,1,1,2,8627.118444),-- [enria]
(21423,959,1,1,2,20.86533),-- [scrl_of_ench_wp_s]
(21423,8732,1,1,2,4313.559222),-- [general_75_s]
(21423,8742,1,1,2,1078.505724),-- [special_75_s]
(21423,8752,1,1,2,108.036042),-- [rare_75_s]
(21424,5544,1,1,-1,43821),-- [worldtree's_branch_head]
(21424,5272,1,1,-1,7107),-- [rp_adv_comp_soulshot_s]
(21424,5545,1,1,-1,43872),-- [dark_legion's_edge_edge]
(21424,57,7867,16114,0,700000),-- [adena]
(21424,11976,1,1,1,524.837859),-- [tallum_glaive_low]
(21424,5541,1,1,1,8096.162141),-- [tallum_glaive_edge]
(21424,1873,2,6,2,59045.593376),-- [silver_nugget]
(21424,1868,15,45,2,39363.578736),-- [thread]
(21424,1876,1,1,2,118090.736208),-- [mithril_ore]
(21424,1895,1,1,2,168701.244816),-- [metallic_fiber]
(21424,4042,1,1,2,9840.782048),-- [enria]
(21424,959,1,1,2,23.428288),-- [scrl_of_ench_wp_s]
(21424,6672,1,1,2,49204.360784),-- [key_of_treasure_box8]
(21424,8732,1,1,2,4920.391024),-- [general_75_s]
(21424,8742,1,1,2,1229.98512),-- [special_75_s]
(21424,8752,1,1,2,123.8996),-- [rare_75_s]
(21425,5544,1,1,-1,44556),-- [worldtree's_branch_head]
(21425,5272,1,1,-1,7227),-- [rp_adv_comp_soulshot_s]
(21425,5545,1,1,-1,44609),-- [dark_legion's_edge_edge]
(21425,57,7999,16385,0,700000),-- [adena]
(21425,11976,1,1,1,533.665314),-- [tallum_glaive_low]
(21425,5541,1,1,1,8232.334686),-- [tallum_glaive_edge]
(21425,1873,2,6,2,66707.162457),-- [silver_nugget]
(21425,1868,15,45,2,44471.592777),-- [thread]
(21425,1876,1,1,2,133414.324914),-- [mithril_ore]
(21425,1895,1,1,2,190592.022282),-- [metallic_fiber]
(21425,4042,1,1,2,11117.78484),-- [enria]
(21425,959,1,1,2,26.751603),-- [scrl_of_ench_wp_s]
(21425,8732,1,1,2,5558.89242),-- [general_75_s]
(21425,8742,1,1,2,1389.723105),-- [special_75_s]
(21425,8752,1,1,2,138.745602),-- [rare_75_s]
(21426,6698,1,1,-1,293497),-- [sealed_sanddragon's_earing_piece]
(21426,6699,1,1,-1,325674),-- [sealed_ring_of_aurakyria_gem]
(21426,6700,1,1,-1,178881),-- [sealed_dragon_necklace_wire]
(21426,57,7369,15040,0,700000),-- [adena]
(21426,11975,1,1,1,490.428288),-- [soul_bow_low]
(21426,5534,1,1,1,7573.571712),-- [soul_bow_shaft]
(21426,1873,3,9,2,36780.075875),-- [silver_nugget]
(21426,1868,4,12,2,137924.639105),-- [thread]
(21426,1876,1,1,2,110339.85881),-- [mithril_ore]
(21426,1895,3,9,2,22518.36864),-- [metallic_fiber]
(21426,4042,1,1,2,9194.926765),-- [enria]
(21426,960,1,1,2,220.55137),-- [scrl_of_ench_am_s]
(21426,8732,1,1,2,4597.64779),-- [general_75_s]
(21426,8742,1,1,2,1149.22754),-- [special_75_s]
(21426,8752,1,1,2,115.07028),-- [rare_75_s]
(21426,1344,150,450,2,45974.633825),-- [mithril_arrow]
(21427,6698,1,1,-1,199827),-- [sealed_sanddragon's_earing_piece]
(21427,6699,1,1,-1,221735),-- [sealed_ring_of_aurakyria_gem]
(21427,6700,1,1,-1,121791),-- [sealed_dragon_necklace_wire]
(21427,57,5017,10240,0,700000),-- [adena]
(21427,11975,1,1,1,333.88533),-- [soul_bow_low]
(21427,5534,1,1,1,5156.11467),-- [soul_bow_shaft]
(21427,1873,1,1,2,150250.212959),-- [silver_nugget]
(21427,1868,4,12,2,93906.324561),-- [thread]
(21427,1876,1,1,2,75124.872326),-- [mithril_ore]
(21427,1895,1,1,2,107321.446883),-- [metallic_fiber]
(21427,4042,1,1,2,6260.327976),-- [enria]
(21427,960,1,1,2,150.326547),-- [scrl_of_ench_am_s]
(21427,8732,1,1,2,3130.163988),-- [general_75_s]
(21427,8742,1,1,2,782.540997),-- [special_75_s]
(21427,8752,1,1,2,78.207269),-- [rare_75_s]
(21427,1344,150,450,2,31302.576494),-- [mithril_arrow]
(21428,6701,1,1,-1,56000),-- [sealed_imperial_crusader_armor_part]
(21428,6702,1,1,-1,72087),-- [sealed_imperial_crusader_gaiters_pattern]
(21428,6703,1,1,-1,149756),-- [sealed_imperial_crusader_gauntlet_design]
(21428,57,5187,10587,0,700000),-- [adena]
(21428,11973,1,1,1,345.236088),-- [soul_separator_low]
(21428,5537,1,1,1,5327.763912),-- [soul_separator_head]
(21428,1868,4,12,2,97090.53832),-- [thread]
(21428,1873,1,1,2,155345.35752),-- [silver_nugget]
(21428,5549,1,1,2,38836.215328),-- [iron_thread]
(21428,1889,1,1,2,25890.644816),-- [compound_braid]
(21428,4044,1,1,2,12945.570512),-- [thons]
(21428,960,1,1,2,155.313104),-- [scrl_of_ench_am_s]
(21428,8732,1,1,2,3236.268576),-- [general_75_s]
(21428,8742,1,1,2,809.315248),-- [special_75_s]
(21428,8752,1,1,2,80.881904),-- [rare_75_s]
(21428,1344,30,90,2,161817.894672),-- [mithril_arrow]
(21429,6701,1,1,-1,58474),-- [sealed_imperial_crusader_armor_part]
(21429,6702,1,1,-1,75272),-- [sealed_imperial_crusader_gaiters_pattern]
(21429,6703,1,1,-1,156374),-- [sealed_imperial_crusader_gauntlet_design]
(21429,57,5417,11055,0,700000),-- [adena]
(21429,11973,1,1,1,360.450088),-- [soul_separator_low]
(21429,5537,1,1,1,5562.549912),-- [soul_separator_head]
(21429,1868,4,12,2,101380.73607),-- [thread]
(21429,1873,1,1,2,162209.177712),-- [silver_nugget]
(21429,5549,1,1,2,40552.294428),-- [iron_thread]
(21429,1889,1,1,2,27034.990605),-- [compound_braid]
(21429,4044,1,1,2,13517.303823),-- [thons]
(21429,960,1,1,2,162.374616),-- [scrl_of_ench_am_s]
(21429,8732,1,1,2,3379.230216),-- [general_75_s]
(21429,8742,1,1,2,844.807554),-- [special_75_s]
(21429,8752,1,1,2,84.633939),-- [rare_75_s]
(21429,1344,150,450,2,33793.451037),-- [mithril_arrow]
(21430,6704,1,1,-1,215960),-- [sealed_imperial_crusader_boots_design]
(21430,6705,1,1,-1,211533),-- [sealed_imperial_crusader_shield_part]
(21430,6706,1,1,-1,246054),-- [sealed_imperial_crusader_helmet_pattern]
(21430,57,7481,15268,0,700000),-- [adena]
(21430,12265,1,1,1,782.20854),-- [sealed_leather_mail_of_nightmare_low]
(21430,5480,1,1,1,6282.79146),-- [sealed_leather_mail_of_nightmare_fabric]
(21430,12258,1,1,1,782.20854),-- [sealed_majestic_leather_mail_low]
(21430,5481,1,1,1,6282.79146),-- [sealed_majestic_leather_mail_fabric]
(21430,1873,3,9,2,37336.541375),-- [silver_nugget]
(21430,1868,4,12,2,140011.374965),-- [thread]
(21430,1876,1,1,2,112009.24973),-- [mithril_ore]
(21430,1895,3,9,2,22859.06112),-- [metallic_fiber]
(21430,4042,1,1,2,9334.041745),-- [enria]
(21430,960,1,1,2,223.88821),-- [scrl_of_ench_am_s]
(21430,8732,1,1,2,4667.20807),-- [general_75_s]
(21430,8742,1,1,2,1166.61482),-- [special_75_s]
(21430,8752,1,1,2,116.81124),-- [rare_75_s]
(21430,1344,150,450,2,46670.208725),-- [mithril_arrow]
(21431,6704,1,1,-1,184208),-- [sealed_imperial_crusader_boots_design]
(21431,6705,1,1,-1,180432),-- [sealed_imperial_crusader_shield_part]
(21431,6706,1,1,-1,209877),-- [sealed_imperial_crusader_helmet_pattern]
(21431,57,6381,13023,0,700000),-- [adena]
(21431,12265,1,1,1,667.174616),-- [sealed_leather_mail_of_nightmare_low]
(21431,5480,1,1,1,5358.825384),-- [sealed_leather_mail_of_nightmare_fabric]
(21431,12258,1,1,1,667.174616),-- [sealed_majestic_leather_mail_low]
(21431,5481,1,1,1,5358.825384),-- [sealed_majestic_leather_mail_fabric]
(21431,1873,3,9,2,31847.001606),-- [silver_nugget]
(21431,1868,4,12,2,119426.146938),-- [thread]
(21431,1876,1,1,2,95541.004818),-- [mithril_ore]
(21431,1895,1,1,2,136486.962738),-- [metallic_fiber]
(21431,4042,1,1,2,7961.859486),-- [enria]
(21431,960,1,1,2,191.116044),-- [scrl_of_ench_am_s]
(21431,8732,1,1,2,3980.711574),-- [general_75_s]
(21431,8742,1,1,2,995.286978),-- [special_75_s]
(21431,8752,1,1,2,99.485064),-- [rare_75_s]
(21431,1344,150,450,2,39808.424754),-- [mithril_arrow]
(21432,5534,1,1,-1,47043),-- [soul_bow_shaft]
(21432,1808,1,1,-1,7616),-- [rp_soulshot_s]
(21432,5537,1,1,-1,47011),-- [soul_separator_head]
(21432,57,8447,17245,0,700000),-- [adena]
(21432,11967,1,1,1,562.41108),-- [dragon_grinder_low]
(21432,5538,1,1,1,8677.58892),-- [dragon_grinder_edge]
(21432,1873,2,6,2,70298.82743),-- [silver_nugget]
(21432,1868,15,45,2,46866.04423),-- [thread]
(21432,1876,1,1,2,140597.65486),-- [mithril_ore]
(21432,1895,1,1,2,200853.92918),-- [metallic_fiber]
(21432,4042,1,1,2,11716.3916),-- [enria]
(21432,959,1,1,2,28.19197),-- [scrl_of_ench_wp_s]
(21432,8732,1,1,2,5858.1958),-- [general_75_s]
(21432,8742,1,1,2,1464.54895),-- [special_75_s]
(21432,8752,1,1,2,146.21598),-- [rare_75_s]
(21433,5538,1,1,-1,45528),-- [dragon_grinder_edge]
(21433,5167,1,1,-1,7377),-- [rp_comp_bspiritshot_s]
(21433,5541,1,1,-1,45519),-- [tallum_glaive_edge]
(21433,57,8184,16701,0,700000),-- [adena]
(21433,12263,1,1,1,642.38492),-- [sealed_armor_of_nightmare_low]
(21433,5522,1,1,1,5217.61508),-- [sealed_armor_of_nightmare_pattern]
(21433,12262,1,1,1,642.38492),-- [sealed_majestic_platte_armor_low]
(21433,5523,1,1,1,5217.61508),-- [sealed_majestic_platte_armor_pattern]
(21433,1873,2,6,2,68095.101971),-- [silver_nugget]
(21433,1868,15,45,2,45396.888931),-- [thread]
(21433,1876,1,1,2,136190.203942),-- [mithril_ore]
(21433,1895,1,1,2,194557.566446),-- [metallic_fiber]
(21433,4042,1,1,2,11349.10652),-- [enria]
(21433,959,1,1,2,27.308209),-- [scrl_of_ench_wp_s]
(21433,8732,1,1,2,5674.55326),-- [general_75_s]
(21433,8742,1,1,2,1418.638315),-- [special_75_s]
(21433,8752,1,1,2,141.632406),-- [rare_75_s]
(21434,1877,1,3,-1,631579),-- [admantite_nugget]
(21434,6342,1,1,-1,715346),-- [sealed_majestic_earing_gemstone]
(21434,5282,1,1,-1,14035),-- [rp_adv_comp_bspiritshot_s]
(21434,57,15536,31822,0,700000),-- [adena]
(21434,12265,1,1,1,1628.466286),-- [sealed_leather_mail_of_nightmare_low]
(21434,5480,1,1,1,13080.033714),-- [sealed_leather_mail_of_nightmare_fabric]
(21434,12258,1,1,1,1628.466286),-- [sealed_majestic_leather_mail_low]
(21434,5481,1,1,1,13080.033714),-- [sealed_majestic_leather_mail_fabric]
(21434,1871,4,12,2,161943.435939),-- [charcoal]
(21434,1866,7,21,2,57580.060248),-- [suede]
(21434,1877,1,1,2,51821.796352),-- [admantite_nugget]
(21434,4041,1,1,2,11265.74805),-- [mold_hardener]
(21434,4040,1,1,2,25910.898176),-- [mold_lubricant]
(21434,959,1,1,2,51.896579),-- [scrl_of_ench_wp_s]
(21434,8732,1,1,2,10796.100127),-- [general_75_s]
(21434,8742,1,1,2,2698.944447),-- [special_75_s]
(21434,8752,1,1,2,270.120082),-- [rare_75_s]
(21435,3036,1,1,-1,9095),-- [rp_spiritshot_s]
(21435,5538,1,1,-1,56130),-- [dragon_grinder_edge]
(21435,1877,1,1,-1,818535),-- [admantite_nugget]
(21435,57,10088,20595,0,700000),-- [adena]
(21435,11975,1,1,1,671.602131),-- [soul_bow_low]
(21435,5534,1,1,1,10371.397869),-- [soul_bow_shaft]
(21435,1871,9,27,2,41976.180664),-- [charcoal]
(21435,1866,2,6,2,125928.541992),-- [suede]
(21435,1877,1,1,2,30222.759754),-- [admantite_nugget]
(21435,4041,1,1,2,6570.109062),-- [mold_hardener]
(21435,4040,1,1,2,15111.54117),-- [mold_lubricant]
(21435,960,1,1,2,302.263082),-- [scrl_of_ench_am_s]
(21435,8732,1,1,2,6296.556134),-- [general_75_s]
(21435,8742,1,1,2,1574.21968),-- [special_75_s]
(21435,8752,1,1,2,157.421968),-- [rare_75_s]
(21435,1344,100,300,2,94446.406494),-- [mithril_arrow]
(21436,1894,1,1,-1,744816),-- [crafted_leather]
(21436,5541,1,1,-1,58213),-- [tallum_glaive_edge]
(21436,3957,1,1,-1,9434),-- [rp_blessed_spiritshot_s]
(21436,57,10464,21364,0,700000),-- [adena]
(21436,11973,1,1,1,696.679488),-- [soul_separator_low]
(21436,5537,1,1,1,10751.320512),-- [soul_separator_head]
(21436,1867,4,12,2,145143.457173),-- [animal_skin]
(21436,1872,7,21,2,77409.937913),-- [animal_bone]
(21436,1882,1,1,2,193524.609564),-- [leather]
(21436,1894,1,1,2,30556.764898),-- [crafted_leather]
(21436,4042,1,1,2,14514.392761),-- [enria]
(21436,959,1,1,2,34.812338),-- [scrl_of_ench_wp_s]
(21436,8732,1,1,2,7256.961162),-- [general_75_s]
(21436,8742,1,1,2,1814.475509),-- [special_75_s]
(21436,8752,1,1,2,181.588682),-- [rare_75_s]
(21437,1877,1,1,-1,342037),-- [admantite_nugget]
(21437,4041,1,1,-1,74356),-- [mold_hardener]
(21437,5544,1,1,-1,23432),-- [worldtree's_branch_head]
(21437,57,4216,8604,0,700000),-- [adena]
(21437,11974,1,1,1,70.16881),-- [elysian_low]
(21437,5533,1,1,1,1082.65389),-- [elysian_head]
(21437,11970,1,1,1,70.16881),-- [worldtree's_branch_low]
(21437,5544,1,1,1,1081.58437),-- [worldtree's_branch_head]
(21437,11969,1,1,1,70.16881),-- [dragon_flame_head_low]
(21437,8342,1,1,1,1082.65389),-- [dragon_flame_head_piece]
(21437,11966,1,1,1,70.16881),-- [doom_crusher_low]
(21437,8349,1,1,1,1082.43261),-- [doom_crusher_head]
(21437,1871,1,3,2,105242.258107),-- [charcoal]
(21437,1866,2,6,2,52621.319235),-- [suede]
(21437,1877,1,1,2,12629.192689),-- [admantite_nugget]
(21437,4041,1,1,2,2745.460134),-- [mold_hardener]
(21437,4040,1,1,2,6314.406163),-- [mold_lubricant]
(21437,960,1,1,2,126.280516),-- [scrl_of_ench_am_s]
(21437,8732,1,1,2,2630.970871),-- [general_75_s]
(21437,8742,1,1,2,657.647627),-- [special_75_s]
(21437,8752,1,1,2,65.802799),-- [rare_75_s]
(21437,1344,20,60,2,197329.661859),-- [mithril_arrow]
(21438,4077,1,1,-1,27694),-- [doom_shield_fragment]
(21438,6333,1,1,-1,7068),-- [rp_sealed_phoenix's_ring_i]
(21438,4078,1,1,-1,8993),-- [blue_wolve's_breastplate_part]
(21438,57,244,495,0,700000),-- [adena]
(21438,11930,1,1,1,9.888893),-- [sword_of_damascus_low]
(21438,4114,1,1,1,132.518596),-- [sword_of_damascus_blade]
(21438,11929,1,1,1,9.888893),-- [guardians_sword_low]
(21438,8330,1,1,1,132.295702),-- [guardians_sword_blade]
(21438,11943,1,1,1,9.888893),-- [tears_of_wizard_low]
(21438,8336,1,1,1,132.519023),-- [tears_of_wizard_blade]
(21438,1873,1,1,2,7273.975644),-- [silver_nugget]
(21438,1868,1,1,2,36369.87822),-- [thread]
(21438,1876,1,1,2,3637.014368),-- [mithril_ore]
(21438,1895,1,1,2,5195.689304),-- [metallic_fiber]
(21438,4042,1,1,2,303.102228),-- [enria]
(21438,729,1,1,2,2.017496),-- [scrl_of_ench_wp_a]
(21438,8729,1,1,2,242.471164),-- [general_64_a]
(21438,8739,1,1,2,60.631064),-- [special_64_a]
(21438,8749,1,1,2,6.052488),-- [rare_64_a]
(21438,8759,1,1,2,1.168024),-- [unique_64_a]
(21439,4116,1,1,-1,2781),-- [deadman's_glory_stone]
(21439,5276,1,1,-1,848),-- [rp_adv_comp_spiritshot_a]
(21439,4117,1,1,-1,2781),-- [art_of_battle_axe_blade]
(21439,57,252,511,0,700000),-- [adena]
(21439,11932,1,1,1,30.719619),-- [lancia_low]
(21439,4115,1,1,1,410.280381),-- [lancia_blade]
(21439,1864,1,1,2,34176.672243),-- [stem]
(21439,1865,1,1,2,17088.271932),-- [varnish]
(21439,1866,1,1,2,11392.224081),-- [suede]
(21439,1873,1,1,2,6835.283097),-- [silver_nugget]
(21439,1868,1,1,2,34176.672243),-- [thread]
(21439,5456,1,1,2,6.290571),-- [rp_tallum_glaive_i]
(21439,8729,1,1,2,227.872725),-- [general_64_a]
(21439,8739,1,1,2,57.000276),-- [special_64_a]
(21439,8749,1,1,2,5.648676),-- [rare_64_a]
(21439,8759,1,1,2,1.155411),-- [unique_64_a]
(21439,1343,10,30,2,24411.908745),-- [silver_arrow]
(21440,4040,1,1,-1,13968),-- [mold_lubricant]
(21440,1875,1,1,-1,46559),-- [stone_of_purity]
(21440,4099,1,1,-1,31353),-- [doom_boots_part]
(21440,57,275,563,0,700000),-- [adena]
(21440,12201,1,1,1,45.76971),-- [blue_wolve's_tunic_low]
(21440,4084,1,1,1,448.23737),-- [blue_wolve's_tunic_fabric]
(21440,12192,1,1,1,45.76971),-- [tunic_of_doom_low]
(21440,4085,1,1,1,448.23737),-- [tunic_of_doom_pattern]
(21440,12203,1,1,1,73.27187),-- [blue_wolve's_hose_low]
(21440,4086,1,1,1,605.22105),-- [blue_wolve's_hose_pattern]
(21440,12205,1,1,1,73.27187),-- [hose_of_doom_low]
(21440,4087,1,1,1,605.22105),-- [hose_of_doom_pattern]
(21440,1865,1,1,2,18753.903808),-- [varnish]
(21440,1870,1,1,2,18753.903808),-- [coal]
(21440,1879,1,1,2,3125.627505),-- [cokes]
(21440,1875,1,1,2,1250.251002),-- [stone_of_purity]
(21440,4040,1,1,2,375.047545),-- [mold_lubricant]
(21440,6335,1,1,2,72.16456),-- [rp_sealed_majestic_necklace_i]
(21440,8730,1,1,2,208.375167),-- [general_67_a]
(21440,8740,1,1,2,52.111139),-- [special_67_a]
(21440,8750,1,1,2,5.204175),-- [rare_67_a]
(21440,8760,1,1,2,1.040835),-- [unique_67_a]
(21440,1343,10,30,2,26791.370456),-- [silver_arrow]
(21441,5448,1,1,-1,252),-- [rp_soul_separator_i]
(21441,5494,1,1,-1,14265),-- [sealed_dark_crystal_shield_fragment]
(21441,729,1,1,-1,75),-- [scrl_of_ench_wp_a]
(21441,57,269,546,0,700000),-- [adena]
(21441,11946,1,1,1,6.911711),-- [dasparion's_staff_low]
(21441,5543,1,1,1,85.464024),-- [dasparion's_staff_head]
(21441,11949,1,1,1,6.911711),-- [meteor_shower_low]
(21441,5532,1,1,1,84.665799),-- [meteor_shower_head]
(21441,11953,1,1,1,6.911711),-- [eye_of_soul_low]
(21441,8341,1,1,1,84.557534),-- [eye_of_soul_piece]
(21441,11958,1,1,1,6.911711),-- [hammer_of_destroyer_low]
(21441,8346,1,1,1,84.665799),-- [hammer_of_destroyer_piece]
(21441,1870,1,1,2,18239.901705),-- [coal]
(21441,1865,1,1,2,18239.901705),-- [varnish]
(21441,1874,1,1,2,1215.9804),-- [oriharukon_ore]
(21441,4043,1,1,2,607.9902),-- [asofe]
(21441,4039,1,1,2,607.9902),-- [mold_glue]
(21441,5442,1,1,2,6.78444),-- [rp_soul_bow_i]
(21441,8730,1,1,2,202.685145),-- [general_67_a]
(21441,8740,1,1,2,50.687595),-- [special_67_a]
(21441,8750,1,1,2,5.08833),-- [rare_67_a]
(21441,8760,1,1,2,1.04376),-- [unique_67_a]
(21441,1343,10,30,2,26056.94652),-- [silver_arrow]
(21442,5448,1,1,-1,260),-- [rp_soul_separator_i]
(21442,6341,1,1,-1,19393),-- [sealed_phoenix's_earing_gemstone]
(21442,729,1,1,-1,78),-- [scrl_of_ench_wp_a]
(21442,57,278,563,0,700000),-- [adena]
(21442,11946,1,1,1,7.118874),-- [dasparion's_staff_low]
(21442,5543,1,1,1,88.025616),-- [dasparion's_staff_head]
(21442,11949,1,1,1,7.118874),-- [meteor_shower_low]
(21442,5532,1,1,1,87.203466),-- [meteor_shower_head]
(21442,11953,1,1,1,7.118874),-- [eye_of_soul_low]
(21442,8341,1,1,1,87.091956),-- [eye_of_soul_piece]
(21442,11958,1,1,1,7.118874),-- [hammer_of_destroyer_low]
(21442,8346,1,1,1,87.203466),-- [hammer_of_destroyer_piece]
(21442,1870,1,1,2,17258.6366),-- [coal]
(21442,1865,1,1,2,17258.6366),-- [varnish]
(21442,1874,1,1,2,1150.555195),-- [oriharukon_ore]
(21442,4043,1,1,2,575.308465),-- [asofe]
(21442,4039,1,1,2,575.308465),-- [mold_glue]
(21442,5450,1,1,2,6.42044),-- [rp_dragon_grinder_i]
(21442,8487,1,1,2,9.445455),-- [rp_hammer_of_destroyer_i]
(21442,8730,1,1,2,191.74891),-- [general_67_a]
(21442,8740,1,1,2,47.968095),-- [special_67_a]
(21442,8750,1,1,2,4.81533),-- [rare_67_a]
(21442,8760,1,1,2,0.98776),-- [unique_67_a]
(21442,1343,10,30,2,24655.168685),-- [silver_arrow]
(21443,4077,1,1,-1,129349),-- [doom_shield_fragment]
(21443,3956,1,1,-1,3834),-- [rp_blessed_spiritshot_a]
(21443,4078,1,1,-1,42002),-- [blue_wolve's_breastplate_part]
(21443,57,1140,2309,0,700000),-- [adena]
(21443,12204,1,1,1,188.500962),-- [blue_wolve's_breastplate_low]
(21443,4078,1,1,1,2067.807105),-- [blue_wolve's_breastplate_part]
(21443,12184,1,1,1,116.031201),-- [doom_plate_armor_low]
(21443,4081,1,1,1,1395.250584),-- [doom_plate_armor_temper]
(21443,12193,1,1,1,301.516371),-- [blue_wolve's_gaiters_low]
(21443,4080,1,1,1,2911.893777),-- [blue_wolve's_gaiters_material]
(21443,1872,1,1,2,102952.605825),-- [animal_bone]
(21443,1867,1,1,2,102952.605825),-- [animal_skin]
(21443,1881,1,1,2,10295.427456),-- [coarse_bone_powder]
(21443,1875,1,1,2,5147.713728),-- [stone_of_purity]
(21443,4041,1,1,2,671.498964),-- [mold_hardener]
(21443,5156,1,1,2,102.794076),-- [rp_comp_soulshot_a]
(21443,8729,1,1,2,1029.609495),-- [general_64_a]
(21443,8739,1,1,2,257.318937),-- [special_64_a]
(21443,8749,1,1,2,25.698519),-- [rare_64_a]
(21443,8759,1,1,2,5.006205),-- [unique_64_a]
(21443,1343,10,30,2,110306.72097),-- [silver_arrow]
(21444,4077,1,1,-1,108697),-- [doom_shield_fragment]
(21444,3956,1,1,-1,3222),-- [rp_blessed_spiritshot_a]
(21444,4078,1,1,-1,35296),-- [blue_wolve's_breastplate_part]
(21444,57,958,1940,0,700000),-- [adena]
(21444,12204,1,1,1,158.393732),-- [blue_wolve's_breastplate_low]
(21444,4078,1,1,1,1737.53853),-- [blue_wolve's_breastplate_part]
(21444,12184,1,1,1,97.498786),-- [doom_plate_armor_low]
(21444,4081,1,1,1,1172.402224),-- [doom_plate_armor_temper]
(21444,12193,1,1,1,253.358406),-- [blue_wolve's_gaiters_low]
(21444,4080,1,1,1,2446.808322),-- [blue_wolve's_gaiters_material]
(21444,1872,1,1,2,86514.8985),-- [animal_bone]
(21444,1867,1,1,2,86514.8985),-- [animal_skin]
(21444,1881,1,1,2,8651.63008),-- [coarse_bone_powder]
(21444,1875,1,1,2,4325.81504),-- [stone_of_purity]
(21444,4041,1,1,2,564.28552),-- [mold_hardener]
(21444,5156,1,1,2,86.38168),-- [rp_comp_soulshot_a]
(21444,8729,1,1,2,865.2191),-- [general_64_a]
(21444,8739,1,1,2,216.23466),-- [special_64_a]
(21444,8749,1,1,2,21.59542),-- [rare_64_a]
(21444,8759,1,1,2,4.2069),-- [unique_64_a]
(21444,1343,10,30,2,92694.8346),-- [silver_arrow]
(21445,5460,1,1,-1,1366),-- [rp_dasparion's_staff_i]
(21445,4118,1,1,-1,10349),-- [staff_of_evil_sprit_head]
(21445,1875,1,1,-1,166644),-- [stone_of_purity]
(21445,57,992,2007,0,700000),-- [adena]
(21445,11930,1,1,1,40.204024),-- [sword_of_damascus_low]
(21445,4114,1,1,1,538.764128),-- [sword_of_damascus_blade]
(21445,11929,1,1,1,40.204024),-- [guardians_sword_low]
(21445,8330,1,1,1,537.857936),-- [guardians_sword_blade]
(21445,11943,1,1,1,40.204024),-- [tears_of_wizard_low]
(21445,8336,1,1,1,538.765864),-- [tears_of_wizard_blade]
(21445,1865,1,1,2,73836.191018),-- [varnish]
(21445,1870,1,1,2,73836.191018),-- [coal]
(21445,1879,1,1,2,12306.003826),-- [cokes]
(21445,1875,1,1,2,4922.367918),-- [stone_of_purity]
(21445,4040,1,1,2,1476.760794),-- [mold_lubricant]
(21445,6329,1,1,2,424.35655),-- [rp_sealed_phoenix's_necklace_i]
(21445,8729,1,1,2,984.507196),-- [general_64_a]
(21445,8739,1,1,2,246.042768),-- [special_64_a]
(21445,8749,1,1,2,24.537052),-- [rare_64_a]
(21445,8759,1,1,2,5.04186),-- [unique_64_a]
(21446,1885,1,1,-1,256299),-- [high_grade_suede]
(21446,4119,1,1,-1,13462),-- [demon's_sword_edge]
(21446,5468,1,1,-1,1681),-- [rp_elemental_sword_i]
(21446,57,1221,2470,0,700000),-- [adena]
(21446,11935,1,1,1,49.445664),-- [deadman's_glory_low]
(21446,4116,1,1,1,661.476322),-- [deadman's_glory_stone]
(21446,11938,1,1,1,49.445664),-- [art_of_battle_axe_low]
(21446,4117,1,1,1,661.476322),-- [art_of_battle_axe_blade]
(21446,11934,1,1,1,49.445664),-- [staff_of_evil_sprit_low]
(21446,4118,1,1,1,626.710364),-- [staff_of_evil_sprit_head]
(21446,1866,1,1,2,55059.359308),-- [suede]
(21446,1871,1,1,2,82589.038962),-- [charcoal]
(21446,5220,1,1,2,3303.4971),-- [reinforcing_agent]
(21446,1885,1,1,2,6882.554202),-- [high_grade_suede]
(21446,4041,1,1,2,718.174898),-- [mold_hardener]
(21446,6331,1,1,2,630.350219),-- [rp_sealed_phoenix's_earing_i]
(21446,8729,1,1,2,1101.1657),-- [general_64_a]
(21446,8739,1,1,2,275.291425),-- [special_64_a]
(21446,8749,1,1,2,27.663431),-- [rare_64_a]
(21446,8759,1,1,2,5.640117),-- [unique_64_a]
(21446,1343,10,30,2,117984.264638),-- [silver_arrow]
(21447,5281,1,1,-1,4242),-- [rp_adv_comp_bspiritshot_a]
(21447,4118,1,1,-1,13173),-- [staff_of_evil_sprit_head]
(21447,4052,1,1,-1,112651),-- [earing_of_black_ore_piece]
(21447,57,1260,2556,0,700000),-- [adena]
(21447,12183,1,1,1,795.15921),-- [doom_shield_low]
(21447,4077,1,1,1,7046.63529),-- [doom_shield_fragment]
(21447,12202,1,1,1,556.4742),-- [blue_wolve's_helmet_low]
(21447,4088,1,1,1,5920.12855),-- [blue_wolve's_helmet_design]
(21447,12185,1,1,1,556.4742),-- [doom_helmet_low]
(21447,4089,1,1,1,5920.12855),-- [doom_helmet_pattern]
(21447,1869,1,1,2,93985.86024),-- [iron_ore]
(21447,1870,1,1,2,93985.86024),-- [coal]
(21447,1871,1,1,2,93985.86024),-- [charcoal]
(21447,1872,1,3,2,62657.24016),-- [animal_bone]
(21447,1867,1,1,2,125314.48032),-- [animal_skin]
(21447,5462,1,1,2,34.896032),-- [rp_worldtree's_branch_i]
(21447,8729,1,1,2,1252.956176),-- [general_64_a]
(21447,8739,1,1,2,313.121152),-- [special_64_a]
(21447,8749,1,1,2,31.123488),-- [rare_64_a]
(21447,8759,1,1,2,6.601952),-- [unique_64_a]
(21448,5281,1,1,-1,5348),-- [rp_adv_comp_bspiritshot_a]
(21448,4118,1,1,-1,16605),-- [staff_of_evil_sprit_head]
(21448,57,1059,2148,0,700000),-- [adena]
(21448,12183,1,1,1,668.170812),-- [doom_shield_low]
(21448,4077,1,1,1,5921.274588),-- [doom_shield_fragment]
(21448,12202,1,1,1,467.60424),-- [blue_wolve's_helmet_low]
(21448,4088,1,1,1,4974.67306),-- [blue_wolve's_helmet_design]
(21448,12185,1,1,1,467.60424),-- [doom_helmet_low]
(21448,4089,1,1,1,4974.67306),-- [doom_helmet_pattern]
(21448,1869,1,1,2,78979.630041),-- [iron_ore]
(21448,1870,1,1,2,78979.630041),-- [coal]
(21448,1871,1,1,2,78979.630041),-- [charcoal]
(21448,1872,1,1,2,105306.173388),-- [animal_bone]
(21448,1867,1,1,2,105306.173388),-- [animal_skin]
(21448,5462,1,1,2,29.180385),-- [rp_worldtree's_branch_i]
(21448,8729,1,1,2,1053.187434),-- [general_64_a]
(21448,8739,1,1,2,263.072394),-- [special_64_a]
(21448,8749,1,1,2,26.486811),-- [rare_64_a]
(21448,8759,1,1,2,5.836077),-- [unique_64_a]
(21449,4041,1,1,-1,30535),-- [mold_hardener]
(21449,4040,1,1,-1,70231),-- [mold_lubricant]
(21449,5496,1,1,-1,82334),-- [sealed_dark_crystal_boots_lining]
(21449,57,1389,2824,0,700000),-- [adena]
(21449,11950,1,1,1,142.796808),-- [blood_tornado_low]
(21449,5539,1,1,1,1749.203192),-- [blood_tornado_edge]
(21449,1871,1,1,2,103726.047588),-- [charcoal]
(21449,1866,1,1,2,69150.698392),-- [suede]
(21449,1877,1,1,2,4149.092728),-- [admantite_nugget]
(21449,4041,1,1,2,901.953004),-- [mold_hardener]
(21449,4040,1,1,2,2074.546364),-- [mold_lubricant]
(21449,5448,1,1,2,38.481392),-- [rp_soul_separator_i]
(21449,8730,1,1,2,1152.445084),-- [general_67_a]
(21449,8740,1,1,2,288.065892),-- [special_67_a]
(21449,8750,1,1,2,28.861044),-- [rare_67_a]
(21449,8760,1,1,2,5.808512),-- [unique_67_a]
(21450,5450,1,1,-1,1258),-- [rp_dragon_grinder_i]
(21450,5497,1,1,-1,79631),-- [sealed_tallum_boots_lining]
(21450,5456,1,1,-1,1258),-- [rp_tallum_glaive_i]
(21450,57,1343,2731,0,700000),-- [adena]
(21450,11955,1,1,1,138.1173),-- [carnium_bow_low]
(21450,5535,1,1,1,1711.8827),-- [carnium_bow_shaft]
(21450,1872,1,1,2,121600.00595),-- [animal_bone]
(21450,1867,1,1,2,121600.00595),-- [animal_skin]
(21450,1881,1,1,2,12160.11875),-- [coarse_bone_powder]
(21450,1875,1,1,2,6079.86245),-- [stone_of_purity]
(21450,4041,1,1,2,793.2139),-- [mold_hardener]
(21450,5450,1,1,2,33.8711),-- [rp_dragon_grinder_i]
(21450,8730,1,1,2,1013.37605),-- [general_67_a]
(21450,8740,1,1,2,253.24555),-- [special_67_a]
(21450,8750,1,1,2,25.2064),-- [rare_67_a]
(21450,8760,1,1,2,5.12005),-- [unique_67_a]
(21450,1343,10,30,2,130285.97385),-- [silver_arrow]
(21451,1807,1,1,-1,1522),-- [rp_soulshot_a]
(21451,4080,1,1,-1,23474),-- [blue_wolve's_gaiters_material]
(21451,4041,1,1,-1,9924),-- [mold_hardener]
(21451,57,452,917,0,700000),-- [adena]
(21451,11935,1,1,1,18.359472),-- [deadman's_glory_low]
(21451,4116,1,1,1,245.610131),-- [deadman's_glory_stone]
(21451,11938,1,1,1,18.359472),-- [art_of_battle_axe_low]
(21451,4117,1,1,1,245.610131),-- [art_of_battle_axe_blade]
(21451,11934,1,1,1,18.359472),-- [staff_of_evil_sprit_low]
(21451,4118,1,1,1,232.701322),-- [staff_of_evil_sprit_head]
(21451,1866,1,1,2,20430.000432),-- [suede]
(21451,1871,1,1,2,30645.000648),-- [charcoal]
(21451,5220,1,1,2,1225.796048),-- [reinforcing_agent]
(21451,1885,1,1,2,2553.725192),-- [high_grade_suede]
(21451,4041,1,1,2,266.52064),-- [mold_hardener]
(21451,730,1,1,2,25.558136),-- [scrl_of_ench_am_a]
(21451,8729,1,1,2,408.631832),-- [general_64_a]
(21451,8739,1,1,2,102.133096),-- [special_64_a]
(21451,8749,1,1,2,10.243144),-- [rare_64_a]
(21451,8759,1,1,2,2.088408),-- [unique_64_a]
(21451,1343,10,30,2,43778.302424),-- [silver_arrow]
(21452,1875,1,1,-1,164372),-- [stone_of_purity]
(21452,4081,1,1,-1,24301),-- [doom_plate_armor_temper]
(21452,3035,1,1,-1,3287),-- [rp_spiritshot_a]
(21452,57,981,1985,0,700000),-- [adena]
(21453,4082,1,1,-1,23411),-- [blue_wolve's_leather_mail_texture]
(21453,3956,1,1,-1,2763),-- [rp_blessed_spiritshot_a]
(21453,4083,1,1,-1,23411),-- [leather_mail_of_doom_design]
(21453,57,824,1668,0,700000),-- [adena]
(21454,1884,1,3,-1,758639),-- [cord]
(21454,1889,1,1,-1,164372),-- [compound_braid]
(21454,4084,1,1,-1,42850),-- [blue_wolve's_tunic_fabric]
(21454,57,981,1985,0,700000),-- [adena]
(21455,5156,1,1,-1,2763),-- [rp_comp_soulshot_a]
(21455,4085,1,1,-1,36008),-- [tunic_of_doom_pattern]
(21455,5161,1,1,-1,2763),-- [rp_comp_spiritshot_a]
(21455,57,824,1668,0,700000),-- [adena]
(21456,4086,1,1,-1,70817),-- [blue_wolve's_hose_pattern]
(21456,1884,1,3,-1,928569),-- [cord]
(21456,4039,1,1,-1,100595),-- [mold_glue]
(21456,11935,1,1,0,48.526512),-- [deadman's_glory_low]
(21456,4116,1,1,0,649.180051),-- [deadman's_glory_stone]
(21456,11938,1,1,0,48.526512),-- [art_of_battle_axe_low]
(21456,4117,1,1,0,649.180051),-- [art_of_battle_axe_blade]
(21456,11934,1,1,0,48.526512),-- [staff_of_evil_sprit_low]
(21456,4118,1,1,0,615.060362),-- [staff_of_evil_sprit_head]
(21456,1864,1,1,1,178285.32282),-- [stem]
(21456,1869,1,1,1,89142.842644),-- [iron_ore]
(21456,1878,1,1,1,35657.064564),-- [braided_hemp]
(21456,1884,1,1,1,54856.994524),-- [cord]
(21456,4039,1,1,1,2971.512664),-- [mold_glue]
(21456,5450,1,1,1,32.984588),-- [rp_dragon_grinder_i]
(21456,8729,1,1,1,1188.532572),-- [general_64_a]
(21456,8739,1,1,1,297.22376),-- [special_64_a]
(21456,8749,1,1,1,29.722376),-- [rare_64_a]
(21456,8759,1,1,1,5.799488),-- [unique_64_a]
(21457,4087,1,1,-1,59510),-- [hose_of_doom_pattern]
(21457,5166,1,1,-1,3381),-- [rp_comp_bspiritshot_a]
(21457,4088,1,1,-1,95843),-- [blue_wolve's_helmet_design]
(21457,12341,1,1,0,579.36816),-- [earing_of_black_ore_low]
(21457,4052,1,1,0,4420.414656),-- [earing_of_black_ore_piece]
(21457,12342,1,1,0,434.282688),-- [necklace_of_black_ore_low]
(21457,4054,1,1,0,2459.213568),-- [necklace_of_black_ore_beads]
(21457,12343,1,1,0,867.04128),-- [ring_of_black_ore_low]
(21457,4053,1,1,0,5351.679648),-- [ring_of_black_ore_gemstone]
(21457,1866,1,1,1,45399.926332),-- [suede]
(21457,1871,1,1,1,68099.99998),-- [charcoal]
(21457,5220,1,1,1,2724.044192),-- [reinforcing_agent]
(21457,1885,1,1,1,5675.018412),-- [high_grade_suede]
(21457,4041,1,1,1,592.18352),-- [mold_hardener]
(21457,5456,1,1,1,25.189896),-- [rp_tallum_glaive_i]
(21457,8729,1,1,1,907.941076),-- [general_64_a]
(21457,8739,1,1,1,226.930028),-- [special_64_a]
(21457,8749,1,1,1,22.759292),-- [rare_64_a]
(21457,8759,1,1,1,4.640244),-- [unique_64_a]
(21457,1343,10,30,1,97285.367028),-- [silver_arrow]
(21458,5230,1,1,-1,4024),-- [rp_mithril_arrow]
(21458,4089,1,1,-1,114053),-- [doom_helmet_pattern]
(21458,4041,1,1,-1,26242),-- [mold_hardener]
(21458,12188,1,1,0,592.716023),-- [doom_boots_low]
(21458,4099,1,1,0,5002.533977),-- [doom_boots_part]
(21458,12189,1,1,0,592.716023),-- [blue_wolve's_boots_low]
(21458,4090,1,1,0,5002.533977),-- [blue_wolve's_boots_design]
(21458,12187,1,1,0,592.716023),-- [doom_gloves_low]
(21458,4091,1,1,0,5002.533977),-- [doom_gloves_part]
(21458,12190,1,1,0,592.716023),-- [blue_wolve's_gloves_low]
(21458,4096,1,1,0,5002.533977),-- [blue_wolve's_gloves_fabric]
(21458,1871,1,1,1,81038.626932),-- [charcoal]
(21458,1866,1,1,1,54025.798869),-- [suede]
(21458,1877,1,1,1,3241.550787),-- [admantite_nugget]
(21458,4041,1,1,1,704.722191),-- [mold_hardener]
(21458,4040,1,1,1,1620.704022),-- [mold_lubricant]
(21458,5462,1,1,1,29.97603),-- [rp_worldtree's_branch_i]
(21458,5370,1,1,1,698.584242),-- [rp_sealed_tallum_boots_i]
(21458,8729,1,1,1,1080.56451),-- [general_64_a]
(21458,8739,1,1,1,270.069756),-- [special_64_a]
(21458,8749,1,1,1,26.978427),-- [rare_64_a]
(21458,8759,1,1,1,5.424234),-- [unique_64_a]
(21459,1894,1,1,-1,88983),-- [crafted_leather]
(21459,4090,1,1,-1,113850),-- [blue_wolve's_boots_design]
(21459,5271,1,1,-1,3381),-- [rp_adv_comp_soulshot_a]
(21459,11933,1,1,0,122.33845),-- [bellion_cestus_low]
(21459,4120,1,1,0,1636.66155),-- [bellion_cestus_edge]
(21459,1867,1,1,1,83233.038942),-- [animal_skin]
(21459,1872,1,1,1,83233.038942),-- [animal_bone]
(21459,1882,1,1,1,13872.081708),-- [leather]
(21459,1894,1,1,1,2190.386448),-- [crafted_leather]
(21459,4042,1,1,1,1040.323824),-- [enria]
(21459,5464,1,1,1,23.045148),-- [rp_dark_legion's_edge_i]
(21459,5364,1,1,1,511.657155),-- [rp_sealed_dark_crystal_shield_i]
(21459,8729,1,1,1,832.368798),-- [general_64_a]
(21459,8739,1,1,1,207.955026),-- [special_64_a]
(21459,8749,1,1,1,20.850372),-- [rare_64_a]
(21459,8759,1,1,1,4.115205),-- [unique_64_a]
(21459,1343,10,30,1,89178.138432),-- [silver_arrow]
(21460,4091,1,1,-1,231933),-- [doom_gloves_part]
(21460,5276,1,1,-1,6888),-- [rp_adv_comp_spiritshot_a]
(21460,4096,1,1,-1,231933),-- [blue_wolve's_gloves_fabric]
(21460,57,2055,4158,0,700000),-- [adena]
(21461,4042,1,1,-1,89502),-- [enria]
(21461,1876,1,3,-1,537011),-- [mithril_ore]
(21461,4099,1,1,-1,241083),-- [doom_boots_part]
(21461,57,2136,4322,0,700000),-- [adena]
(21462,5281,1,1,-1,6888),-- [rp_adv_comp_bspiritshot_a]
(21462,4114,1,1,-1,22614),-- [sword_of_damascus_blade]
(21462,5438,1,1,-1,2823),-- [rp_meteor_shower_i]
(21462,57,2055,4158,0,700000),-- [adena]
(21463,4115,1,1,-1,21675),-- [lancia_blade]
(21463,4041,1,1,-1,43205),-- [mold_hardener]
(21463,1875,1,1,-1,331238),-- [stone_of_purity]
(21463,57,1976,3999,0,700000),-- [adena]
(21464,4116,1,1,-1,27632),-- [deadman's_glory_stone]
(21464,5444,1,1,-1,3455),-- [rp_carnium_bow_i]
(21464,4117,1,1,-1,27632),-- [art_of_battle_axe_blade]
(21464,11935,1,1,0,101.69592),-- [deadman's_glory_low]
(21464,4116,1,1,0,1360.472035),-- [deadman's_glory_stone]
(21464,11938,1,1,0,101.69592),-- [art_of_battle_axe_low]
(21464,4117,1,1,0,1360.472035),-- [art_of_battle_axe_blade]
(21464,11934,1,1,0,101.69592),-- [staff_of_evil_sprit_low]
(21464,4118,1,1,0,1288.96817),-- [staff_of_evil_sprit_head]
(21464,1867,1,3,1,124524.651092),-- [animal_skin]
(21464,1872,1,1,1,249049.302184),-- [animal_bone]
(21464,1882,1,1,1,41508.074378),-- [leather]
(21464,1894,1,1,1,6553.748812),-- [crafted_leather]
(21464,4042,1,1,1,3112.966492),-- [enria]
(21464,729,1,1,1,20.541984),-- [scrl_of_ench_wp_a]
(21464,8729,1,1,1,2490.287602),-- [general_64_a]
(21464,8739,1,1,1,622.67889),-- [special_64_a]
(21464,8749,1,1,1,62.05391),-- [rare_64_a]
(21464,8759,1,1,1,13.694656),-- [unique_64_a]
(21465,5446,1,1,-1,3592),-- [rp_bloody_orchid_i]
(21465,4118,1,1,-1,27213),-- [staff_of_evil_sprit_head]
(21465,5220,1,1,-1,262919),-- [reinforcing_agent]
(21465,12341,1,1,0,1501.586625),-- [earing_of_black_ore_low]
(21465,4052,1,1,0,11456.67985),-- [earing_of_black_ore_piece]
(21465,12342,1,1,0,1125.55905),-- [necklace_of_black_ore_low]
(21465,4054,1,1,0,6373.7058),-- [necklace_of_black_ore_beads]
(21465,12343,1,1,0,2247.168),-- [ring_of_black_ore_low]
(21465,4053,1,1,0,13870.300675),-- [ring_of_black_ore_gemstone]
(21465,1874,1,1,1,10786.421376),-- [oriharukon_ore]
(21465,1878,1,1,1,64718.956017),-- [braided_hemp]
(21465,1884,1,1,1,99567.361404),-- [cord]
(21465,1889,1,1,1,10786.421376),-- [compound_braid]
(21465,5220,1,1,1,6472.02393),-- [reinforcing_agent]
(21465,730,1,1,1,134.744715),-- [scrl_of_ench_am_a]
(21465,5370,1,1,1,1394.928621),-- [rp_sealed_tallum_boots_i]
(21465,8729,1,1,1,2157.198723),-- [general_64_a]
(21465,8739,1,1,1,539.406621),-- [special_64_a]
(21465,8749,1,1,1,53.897886),-- [rare_64_a]
(21465,8759,1,1,1,10.694025),-- [unique_64_a]
(21465,1343,10,30,1,231138.945306),-- [silver_arrow]
(21466,4042,1,1,-1,105392),-- [enria]
(21466,4119,1,1,-1,27679),-- [demon's_sword_edge]
(21466,5452,1,1,-1,3455),-- [rp_blood_tornado_i]
(21466,12188,1,1,0,1241.946768),-- [doom_boots_low]
(21466,4099,1,1,0,10482.053232),-- [doom_boots_part]
(21466,12189,1,1,0,1241.946768),-- [blue_wolve's_boots_low]
(21466,4090,1,1,0,10482.053232),-- [blue_wolve's_boots_design]
(21466,12187,1,1,0,1241.946768),-- [doom_gloves_low]
(21466,4091,1,1,0,10482.053232),-- [doom_gloves_part]
(21466,12190,1,1,0,1241.946768),-- [blue_wolve's_gloves_low]
(21466,4096,1,1,0,10482.053232),-- [blue_wolve's_gloves_fabric]
(21466,1867,1,3,1,113204.20656),-- [animal_skin]
(21466,1872,1,1,1,226408.02256),-- [animal_bone]
(21466,1882,1,1,1,37734.73552),-- [leather]
(21466,1894,1,1,1,5957.9928),-- [crafted_leather]
(21466,4042,1,1,1,2829.99776),-- [enria]
(21466,5434,1,1,1,62.88016),-- [rp_dragon_slayer_i]
(21466,5368,1,1,1,1463.81888),-- [rp_sealed_dark_crystal_boots_i]
(21466,8729,1,1,1,2264.07632),-- [general_64_a]
(21466,8739,1,1,1,565.92144),-- [special_64_a]
(21466,8749,1,1,1,56.6312),-- [rare_64_a]
(21466,8759,1,1,1,11.7168),-- [unique_64_a]
(21467,4120,1,1,-1,26575),-- [bellion_cestus_edge]
(21467,5458,1,1,-1,3323),-- [rp_halbard_i]
(21467,4121,1,1,-1,26486),-- [hazard_bow_shaft]
(21467,11933,1,1,0,293.3619),-- [bellion_cestus_low]
(21467,4120,1,1,0,3924.6381),-- [bellion_cestus_edge]
(21467,1864,4,12,1,37424.6215),-- [stem]
(21467,1869,1,1,1,149698.486),-- [iron_ore]
(21467,1878,1,1,1,59879.3944),-- [braided_hemp]
(21467,1884,1,1,1,92121.8872),-- [cord]
(21467,4039,1,1,1,4990.0893),-- [mold_glue]
(21467,5440,1,1,1,55.3476),-- [rp_elysian_i]
(21467,5368,1,1,1,1290.6054),-- [rp_sealed_dark_crystal_boots_i]
(21467,8729,1,1,1,1995.868),-- [general_64_a]
(21467,8739,1,1,1,498.967),-- [special_64_a]
(21467,8749,1,1,1,49.8967),-- [rare_64_a]
(21467,8759,1,1,1,10.0632),-- [unique_64_a]
(21467,1343,30,90,1,71284.7737),-- [silver_arrow]
(21468,5220,1,1,-1,348382),-- [reinforcing_agent]
(21468,5370,1,1,-1,37541),-- [rp_sealed_tallum_boots_i]
(21468,4052,1,1,-1,308357),-- [earing_of_black_ore_piece]
(21468,57,3464,7010,0,700000),-- [adena]
(21469,5460,1,1,-1,4540),-- [rp_dasparion's_staff_i]
(21469,4053,1,1,-1,356108),-- [ring_of_black_ore_gemstone]
(21469,5468,1,1,-1,4540),-- [rp_elemental_sword_i]
(21469,57,3305,6687,0,700000),-- [adena]
(21470,5156,1,1,-1,1625),-- [rp_comp_soulshot_a]
(21470,4114,1,1,-1,5334),-- [sword_of_damascus_blade]
(21470,5161,1,1,-1,1625),-- [rp_comp_spiritshot_a]
(21470,57,480,982,0,700000),-- [adena]
(21470,12188,1,1,1,239.326871),-- [doom_boots_low]
(21470,4099,1,1,1,2019.923129),-- [doom_boots_part]
(21470,12189,1,1,1,239.326871),-- [blue_wolve's_boots_low]
(21470,4090,1,1,1,2019.923129),-- [blue_wolve's_boots_design]
(21470,12187,1,1,1,239.326871),-- [doom_gloves_low]
(21470,4091,1,1,1,2019.923129),-- [doom_gloves_part]
(21470,12190,1,1,1,239.326871),-- [blue_wolve's_gloves_low]
(21470,4096,1,1,1,2019.923129),-- [blue_wolve's_gloves_fabric]
(21470,1866,1,1,2,21814.538384),-- [suede]
(21470,1871,1,1,2,32721.807576),-- [charcoal]
(21470,5220,1,1,2,1308.879474),-- [reinforcing_agent]
(21470,1885,1,1,2,2726.817298),-- [high_grade_suede]
(21470,4041,1,1,2,284.507838),-- [mold_hardener]
(21470,6337,1,1,2,167.800464),-- [rp_sealed_majestic_earing_i]
(21470,5364,1,1,2,268.193904),-- [rp_sealed_dark_crystal_shield_i]
(21470,8730,1,1,2,363.567672),-- [general_67_a]
(21470,8740,1,1,2,90.891918),-- [special_67_a]
(21470,8750,1,1,2,9.083216),-- [rare_67_a]
(21470,8760,1,1,2,1.912256),-- [unique_67_a]
(21471,4115,1,1,-1,11485),-- [lancia_blade]
(21471,1894,1,1,-1,92378),-- [crafted_leather]
(21471,4042,1,1,-1,43879),-- [enria]
(21471,57,1047,2119,0,700000),-- [adena]
(21472,4116,1,1,-1,9668),-- [deadman's_glory_stone]
(21472,5166,1,1,-1,2950),-- [rp_comp_bspiritshot_a]
(21472,4117,1,1,-1,9668),-- [art_of_battle_axe_blade]
(21472,57,880,1780,0,700000),-- [adena]
(21473,5230,1,1,-1,3510),-- [rp_mithril_arrow]
(21473,4118,1,1,-1,10900),-- [staff_of_evil_sprit_head]
(21473,4043,1,1,-1,87759),-- [asofe]
(21473,57,1047,2119,0,700000),-- [adena]
(21474,4039,1,1,-1,73747),-- [mold_glue]
(21474,4119,1,1,-1,9684),-- [demon's_sword_edge]
(21474,5271,1,1,-1,2950),-- [rp_adv_comp_soulshot_a]
(21474,57,880,1780,0,700000),-- [adena]
(21475,4120,1,1,-1,14081),-- [bellion_cestus_edge]
(21475,5276,1,1,-1,4296),-- [rp_adv_comp_spiritshot_a]
(21475,4121,1,1,-1,14034),-- [hazard_bow_shaft]
(21475,12201,1,1,0,211.145724),-- [blue_wolve's_tunic_low]
(21475,4084,1,1,0,2067.817428),-- [blue_wolve's_tunic_fabric]
(21475,12192,1,1,0,211.145724),-- [tunic_of_doom_low]
(21475,4085,1,1,0,2067.817428),-- [tunic_of_doom_pattern]
(21475,12203,1,1,0,338.019228),-- [blue_wolve's_hose_low]
(21475,4086,1,1,0,2792.01762),-- [blue_wolve's_hose_pattern]
(21475,12205,1,1,0,338.019228),-- [hose_of_doom_low]
(21475,4087,1,1,0,2792.01762),-- [hose_of_doom_pattern]
(21475,1871,1,1,1,86530.60944),-- [charcoal]
(21475,1866,1,1,1,57687.16464),-- [suede]
(21475,1877,1,1,1,3461.10336),-- [admantite_nugget]
(21475,4041,1,1,1,752.50944),-- [mold_hardener]
(21475,4040,1,1,1,1730.55168),-- [mold_lubricant]
(21475,5440,1,1,1,32.17968),-- [rp_elysian_i]
(21475,8730,1,1,1,961.53984),-- [general_67_a]
(21475,8740,1,1,1,240.38496),-- [special_67_a]
(21475,8750,1,1,1,23.92848),-- [rare_67_a]
(21475,8760,1,1,1,4.67568),-- [unique_67_a]
(21475,1343,10,30,1,123615.3528),-- [silver_arrow]
(21476,4041,1,1,-1,23547),-- [mold_hardener]
(21476,1875,1,1,-1,180524),-- [stone_of_purity]
(21476,4052,1,1,-1,95871),-- [earing_of_black_ore_piece]
(21476,12204,1,1,0,177.511148),-- [blue_wolve's_breastplate_low]
(21476,4078,1,1,0,1947.25167),-- [blue_wolve's_breastplate_part]
(21476,12184,1,1,0,109.266454),-- [doom_plate_armor_low]
(21476,4081,1,1,0,1313.905936),-- [doom_plate_armor_temper]
(21476,12193,1,1,0,283.937634),-- [blue_wolve's_gaiters_low]
(21476,4080,1,1,0,2742.127158),-- [blue_wolve's_gaiters_material]
(21476,1872,1,1,1,106648.442776),-- [animal_bone]
(21476,1867,1,1,1,106648.442776),-- [animal_skin]
(21476,1881,1,1,1,10664.890509),-- [coarse_bone_powder]
(21476,1875,1,1,1,5332.329676),-- [stone_of_purity]
(21476,4041,1,1,1,695.551413),-- [mold_hardener]
(21476,5442,1,1,1,29.588096),-- [rp_soul_bow_i]
(21476,8730,1,1,1,888.798665),-- [general_67_a]
(21476,8740,1,1,1,222.141877),-- [special_67_a]
(21476,8750,1,1,1,22.191072),-- [rare_67_a]
(21476,8760,1,1,1,4.62314),-- [unique_67_a]
(21477,5281,1,1,-1,4296),-- [rp_adv_comp_bspiritshot_a]
(21477,4053,1,1,-1,138121),-- [ring_of_black_ore_gemstone]
(21477,5438,1,1,-1,1761),-- [rp_meteor_shower_i]
(21477,12201,1,1,0,211.145724),-- [blue_wolve's_tunic_low]
(21477,4084,1,1,0,2067.817428),-- [blue_wolve's_tunic_fabric]
(21477,12192,1,1,0,211.145724),-- [tunic_of_doom_low]
(21477,4085,1,1,0,2067.817428),-- [tunic_of_doom_pattern]
(21477,12203,1,1,0,338.019228),-- [blue_wolve's_hose_low]
(21477,4086,1,1,0,2792.01762),-- [blue_wolve's_hose_pattern]
(21477,12205,1,1,0,338.019228),-- [hose_of_doom_low]
(21477,4087,1,1,0,2792.01762),-- [hose_of_doom_pattern]
(21477,1865,1,1,1,86530.44636),-- [varnish]
(21477,1870,1,1,1,86530.44636),-- [coal]
(21477,1879,1,1,1,14421.84768),-- [cokes]
(21477,1875,1,1,1,5768.6751),-- [stone_of_purity]
(21477,4040,1,1,1,1730.76246),-- [mold_lubricant]
(21477,5448,1,1,1,31.986),-- [rp_soul_separator_i]
(21477,8730,1,1,1,961.49916),-- [general_67_a]
(21477,8740,1,1,1,240.21486),-- [special_67_a]
(21477,8750,1,1,1,23.9895),-- [rare_67_a]
(21477,8760,1,1,1,4.7979),-- [unique_67_a]
(21477,1343,10,30,1,123615.33462),-- [silver_arrow]
(21478,4054,1,1,-1,53336),-- [necklace_of_black_ore_beads]
(21478,1885,1,1,-1,225655),-- [high_grade_suede]
(21478,4041,1,1,-1,23547),-- [mold_hardener]
(21478,12341,1,1,0,618.61674),-- [earing_of_black_ore_low]
(21478,4052,1,1,0,4719.870184),-- [earing_of_black_ore_piece]
(21478,12342,1,1,0,463.702632),-- [necklace_of_black_ore_low]
(21478,4054,1,1,0,2625.809952),-- [necklace_of_black_ore_beads]
(21478,12343,1,1,0,925.77792),-- [ring_of_black_ore_low]
(21478,4053,1,1,0,5714.222572),-- [ring_of_black_ore_gemstone]
(21478,1866,1,1,1,53324.090928),-- [suede]
(21478,1871,1,1,1,79986.136392),-- [charcoal]
(21478,5220,1,1,1,3199.393242),-- [reinforcing_agent]
(21478,1885,1,1,1,6665.511366),-- [high_grade_suede]
(21478,4041,1,1,1,695.602248),-- [mold_hardener]
(21478,5450,1,1,1,29.587752),-- [rp_dragon_grinder_i]
(21478,8730,1,1,1,888.792864),-- [general_67_a]
(21478,8740,1,1,1,222.198216),-- [special_67_a]
(21478,8750,1,1,1,22.190814),-- [rare_67_a]
(21478,8760,1,1,1,4.496178),-- [unique_67_a]
(21479,4077,1,1,-1,248161),-- [doom_shield_fragment]
(21479,5444,1,1,-1,3015),-- [rp_carnium_bow_i]
(21479,4078,1,1,-1,80582),-- [blue_wolve's_breastplate_part]
(21479,57,2194,4439,0,700000),-- [adena]
(21480,5446,1,1,-1,3133),-- [rp_bloody_orchid_i]
(21480,4080,1,1,-1,117952),-- [blue_wolve's_gaiters_material]
(21480,1889,1,1,-1,382283),-- [compound_braid]
(21480,57,2281,4615,0,700000),-- [adena]
(21481,5550,1,1,-1,73555),-- [reinforcing_plate]
(21481,4081,1,1,-1,54372),-- [doom_plate_armor_temper]
(21481,5452,1,1,-1,3015),-- [rp_blood_tornado_i]
(21481,57,2194,4439,0,700000),-- [adena]
(21482,4082,1,1,-1,59949),-- [blue_wolve's_leather_mail_texture]
(21482,5458,1,1,-1,2899),-- [rp_halbard_i]
(21482,4083,1,1,-1,59949),-- [leather_mail_of_doom_design]
(21482,57,2110,4270,0,700000),-- [adena]
(21483,4040,1,1,-1,135041),-- [mold_lubricant]
(21483,1877,1,1,-1,270082),-- [admantite_nugget]
(21483,5364,1,1,-1,55345),-- [rp_sealed_dark_crystal_shield_i]
(21483,11944,1,1,0,325.746792),-- [hazard_bow_low]
(21483,4121,1,1,0,4343.253208),-- [hazard_bow_shaft]
(21483,1871,1,1,1,181313.40119),-- [charcoal]
(21483,1866,1,1,1,120875.45165),-- [suede]
(21483,1877,1,1,1,7252.39287),-- [admantite_nugget]
(21483,4041,1,1,1,1576.74332),-- [mold_hardener]
(21483,4040,1,1,1,3626.42015),-- [mold_lubricant]
(21483,6335,1,1,1,697.54337),-- [rp_sealed_majestic_necklace_i]
(21483,8730,1,1,1,2014.77729),-- [general_67_a]
(21483,8740,1,1,1,503.80618),-- [special_67_a]
(21483,8750,1,1,1,50.55959),-- [rare_67_a]
(21483,8760,1,1,1,10.29089),-- [unique_67_a]
(21483,1343,20,60,1,129508.6135),-- [silver_arrow]
(21484,5460,1,1,-1,3835),-- [rp_dasparion's_staff_i]
(21484,4085,1,1,-1,121974),-- [tunic_of_doom_pattern]
(21484,5468,1,1,-1,3835),-- [rp_elemental_sword_i]
(21484,12201,1,1,0,459.883116),-- [blue_wolve's_tunic_low]
(21484,4084,1,1,0,4503.782052),-- [blue_wolve's_tunic_fabric]
(21484,12192,1,1,0,459.883116),-- [tunic_of_doom_low]
(21484,4085,1,1,0,4503.782052),-- [tunic_of_doom_pattern]
(21484,12203,1,1,0,736.218252),-- [blue_wolve's_hose_low]
(21484,4086,1,1,0,6081.11658),-- [blue_wolve's_hose_pattern]
(21484,12205,1,1,0,736.218252),-- [hose_of_doom_low]
(21484,4087,1,1,0,6081.11658),-- [hose_of_doom_pattern]
(21484,1872,1,3,1,138208.768048),-- [animal_bone]
(21484,1867,1,1,1,276417.536096),-- [animal_skin]
(21484,1881,1,1,1,27641.661229),-- [coarse_bone_powder]
(21484,1875,1,1,1,13821.061566),-- [stone_of_purity]
(21484,4041,1,1,1,1802.807409),-- [mold_hardener]
(21484,6337,1,1,1,1063.300706),-- [rp_sealed_majestic_earing_i]
(21484,8730,1,1,1,2303.510261),-- [general_67_a]
(21484,8740,1,1,1,575.993041),-- [special_67_a]
(21484,8750,1,1,1,57.737875),-- [rare_67_a]
(21484,8760,1,1,1,10.623769),-- [unique_67_a]
(21485,4086,1,1,-1,158443),-- [blue_wolve's_hose_pattern]
(21485,4040,1,1,-1,135041),-- [mold_lubricant]
(21485,5368,1,1,-1,58207),-- [rp_sealed_dark_crystal_boots_i]
(21485,12341,1,1,0,1542.477405),-- [earing_of_black_ore_low]
(21485,4052,1,1,0,11768.664898),-- [earing_of_black_ore_piece]
(21485,12342,1,1,0,1156.209954),-- [necklace_of_black_ore_low]
(21485,4054,1,1,0,6547.272744),-- [necklace_of_black_ore_beads]
(21485,12343,1,1,0,2308.36224),-- [ring_of_black_ore_low]
(21485,4053,1,1,0,14248.012759),-- [ring_of_black_ore_gemstone]
(21485,1865,1,3,1,60437.885667),-- [varnish]
(21485,1870,1,1,1,181313.235834),-- [coal]
(21485,1879,1,1,1,30218.73225),-- [cokes]
(21485,1875,1,1,1,12087.4929),-- [stone_of_purity]
(21485,4040,1,1,1,3626.24787),-- [mold_lubricant]
(21485,6339,1,1,1,1394.905104),-- [rp_sealed_majestic_ring_i]
(21485,8730,1,1,1,2014.441761),-- [general_67_a]
(21485,8740,1,1,1,503.715732),-- [special_67_a]
(21485,8750,1,1,1,50.54004),-- [rare_67_a]
(21485,8760,1,1,1,10.108008),-- [unique_67_a]
(21485,1343,20,60,1,129509.694834),-- [silver_arrow]
(21486,4087,1,1,-1,152379),-- [hose_of_doom_pattern]
(21486,5470,1,1,-1,3548),-- [rp_tallum_blade_i]
(21486,4088,1,1,-1,245413),-- [blue_wolve's_helmet_design]
(21486,12204,1,1,0,425.68653),-- [blue_wolve's_breastplate_low]
(21486,4078,1,1,0,4669.671825),-- [blue_wolve's_breastplate_part]
(21486,12184,1,1,0,262.030065),-- [doom_plate_armor_low]
(21486,4081,1,1,0,3150.85596),-- [doom_plate_armor_temper]
(21486,12193,1,1,0,680.906115),-- [blue_wolve's_gaiters_low]
(21486,4080,1,1,0,6575.849505),-- [blue_wolve's_gaiters_material]
(21486,1866,1,1,1,127874.48184),-- [suede]
(21486,1871,1,1,1,191811.54888),-- [charcoal]
(21486,5220,1,1,1,7672.62888),-- [reinforcing_agent]
(21486,1885,1,1,1,15984.44064),-- [high_grade_suede]
(21486,4041,1,1,1,1667.85696),-- [mold_hardener]
(21486,729,1,1,1,21.21336),-- [scrl_of_ench_wp_a]
(21486,8730,1,1,1,2131.07328),-- [general_67_a]
(21486,8740,1,1,1,532.76832),-- [special_67_a]
(21486,8750,1,1,1,53.20728),-- [rare_67_a]
(21486,8760,1,1,1,10.78056),-- [unique_67_a]
(21487,5428,1,1,-1,7816),-- [rp_sealed_tallum_bonnet_i]
(21487,4089,1,1,-1,351478),-- [doom_helmet_pattern]
(21487,1894,1,1,-1,326320),-- [crafted_leather]
(21487,57,3699,7484,0,700000),-- [adena]
(21488,4044,1,1,-1,295712),-- [thons]
(21488,4090,1,1,-1,398265),-- [blue_wolve's_boots_design]
(21488,5426,1,1,-1,6995),-- [rp_sealed_dark_crystal_helmet_i]
(21488,57,3528,7139,0,700000),-- [adena]
(21489,4040,1,1,-1,25994),-- [mold_lubricant]
(21489,1877,1,1,-1,51987),-- [admantite_nugget]
(21489,6343,1,1,-1,27789),-- [sealed_phoenix's_necklace_beads]
(21489,57,514,1045,0,700000),-- [adena]
(21489,11950,1,1,1,52.8318),-- [blood_tornado_low]
(21489,5539,1,1,1,647.1682),-- [blood_tornado_edge]
(21489,1871,1,1,2,38390.683626),-- [charcoal]
(21489,1866,1,1,2,25593.789084),-- [suede]
(21489,1877,1,1,2,1535.646156),-- [admantite_nugget]
(21489,4041,1,1,2,333.827358),-- [mold_hardener]
(21489,4040,1,1,2,767.823078),-- [mold_lubricant]
(21489,5456,1,1,2,14.242584),-- [rp_tallum_glaive_i]
(21489,8730,1,1,2,426.538518),-- [general_67_a]
(21489,8740,1,1,2,106.617834),-- [special_67_a]
(21489,8750,1,1,2,10.681938),-- [rare_67_a]
(21489,8760,1,1,2,2.149824),-- [unique_67_a]
(21490,5450,1,1,-1,1040),-- [rp_dragon_grinder_i]
(21490,6345,1,1,-1,107412),-- [sealed_phoenix's_ring_gemstone]
(21490,5456,1,1,-1,1040),-- [rp_tallum_glaive_i]
(21490,57,1116,2260,0,700000),-- [adena]
(21491,5478,1,1,-1,19841),-- [sealed_dark_crystal_leather_mail_pattern]
(21491,730,1,1,-1,1966),-- [scrl_of_ench_am_a]
(21491,4041,1,1,-1,20517),-- [mold_hardener]
(21491,57,938,1899,0,700000),-- [adena]
(21492,4040,1,1,-1,56155),-- [mold_lubricant]
(21492,5479,1,1,-1,16614),-- [sealed_tallum_leather_mail_pattern]
(21492,5462,1,1,-1,1040),-- [rp_worldtree's_branch_i]
(21492,57,1116,2260,0,700000),-- [adena]
(21493,5482,1,1,-1,31142),-- [sealed_legging_of_dark_crystal_design]
(21493,5464,1,1,-1,874),-- [rp_dark_legion's_edge_i]
(21493,5485,1,1,-1,19841),-- [sealed_tallum_tunic_texture]
(21493,57,938,1899,0,700000),-- [adena]
(21494,729,1,1,-1,382),-- [scrl_of_ench_wp_a]
(21494,4042,1,1,-1,57282),-- [enria]
(21494,1876,1,1,-1,687390),-- [mithril_ore]
(21494,11955,1,1,0,139.759776),-- [carnium_bow_low]
(21494,5535,1,1,0,1732.240224),-- [carnium_bow_shaft]
(21494,1873,1,1,1,36917.122),-- [silver_nugget]
(21494,1868,1,1,1,184584.807),-- [thread]
(21494,1876,1,1,1,18458.561),-- [mithril_ore]
(21494,1895,1,1,1,26369.3155),-- [metallic_fiber]
(21494,4042,1,1,1,1538.1465),-- [enria]
(21494,6337,1,1,1,473.3685),-- [rp_sealed_majestic_earing_i]
(21494,8730,1,1,1,1025.431),-- [general_67_a]
(21494,8740,1,1,1,256.5585),-- [special_67_a]
(21494,8750,1,1,1,25.696),-- [rare_67_a]
(21494,8760,1,1,1,5.2195),-- [unique_67_a]
(21494,1343,10,30,1,131845.7745),-- [silver_arrow]
(21495,5486,1,1,-1,17090),-- [sealed_dark_crystal_robe_fabric]
(21495,5466,1,1,-1,1070),-- [rp_sword_of_miracle_i]
(21495,5489,1,1,-1,38120),-- [sealed_tallum_hose_fabric]
(21495,11951,1,1,0,117.452202),-- [bloody_orchid_low]
(21495,5536,1,1,0,1451.547798),-- [bloody_orchid_head]
(21495,1873,1,1,1,34125.1218),-- [silver_nugget]
(21495,1868,1,1,1,170625.609),-- [thread]
(21495,1876,1,1,1,17062.68564),-- [mithril_ore]
(21495,1895,1,1,1,24375.19392),-- [metallic_fiber]
(21495,4042,1,1,1,1421.78652),-- [enria]
(21495,6339,1,1,1,656.1324),-- [rp_sealed_majestic_ring_i]
(21495,8730,1,1,1,948.024),-- [general_67_a]
(21495,8740,1,1,1,237.006),-- [special_67_a]
(21495,8750,1,1,1,23.7006),-- [rare_67_a]
(21495,8760,1,1,1,4.74012),-- [unique_67_a]
(21496,6335,1,1,-1,13219),-- [rp_sealed_majestic_necklace_i]
(21496,5494,1,1,-1,72182),-- [sealed_dark_crystal_shield_fragment]
(21496,730,1,1,-1,2864),-- [scrl_of_ench_am_a]
(21496,11946,1,1,0,34.935215),-- [dasparion's_staff_low]
(21496,5543,1,1,0,431.97756),-- [dasparion's_staff_head]
(21496,11949,1,1,0,34.935215),-- [meteor_shower_low]
(21496,5532,1,1,0,427.942935),-- [meteor_shower_head]
(21496,11953,1,1,0,34.935215),-- [eye_of_soul_low]
(21496,8341,1,1,0,427.39571),-- [eye_of_soul_piece]
(21496,11958,1,1,0,34.935215),-- [hammer_of_destroyer_low]
(21496,8346,1,1,0,427.942935),-- [hammer_of_destroyer_piece]
(21496,1873,1,1,1,36917.152052),-- [silver_nugget]
(21496,1868,1,1,1,184585.359222),-- [thread]
(21496,1876,1,1,1,18458.576026),-- [mithril_ore]
(21496,1895,1,1,1,26369.451614),-- [metallic_fiber]
(21496,4042,1,1,1,1538.381768),-- [enria]
(21496,729,1,1,1,10.426988),-- [scrl_of_ench_wp_a]
(21496,8730,1,1,1,1025.454166),-- [general_67_a]
(21496,8740,1,1,1,256.263282),-- [special_67_a]
(21496,8750,1,1,1,25.666432),-- [rare_67_a]
(21496,8760,1,1,1,5.213494),-- [unique_67_a]
(21496,1343,10,30,1,131846.054956),-- [silver_arrow]
(21497,1884,1,3,-1,888675),-- [cord]
(21497,4039,1,1,-1,96273),-- [mold_glue]
(21497,5496,1,1,-1,67718),-- [sealed_dark_crystal_boots_lining]
(21497,11957,1,1,0,39.1401),-- [tallum_blade_low]
(21497,5548,1,1,0,483.72485),-- [tallum_blade_edge]
(21497,11952,1,1,0,39.1401),-- [elemental_sword_low]
(21497,5547,1,1,0,483.72485),-- [elemental_sword_edge]
(21497,11954,1,1,0,39.1401),-- [inferno_master_low]
(21497,8331,1,1,0,485.13),-- [inferno_master_blade]
(21497,1864,1,1,1,155113.9595),-- [stem]
(21497,1869,1,1,1,77556.97975),-- [iron_ore]
(21497,1878,1,1,1,31022.7919),-- [braided_hemp]
(21497,1884,1,1,1,47727.444983),-- [cord]
(21497,4039,1,1,1,2585.337856),-- [mold_glue]
(21497,730,1,1,1,64.696565),-- [scrl_of_ench_am_a]
(21497,5366,1,1,1,419.107504),-- [rp_sealed_shield_of_nightmare_i]
(21497,8730,1,1,1,861.884483),-- [general_67_a]
(21497,8740,1,1,1,215.550019),-- [special_67_a]
(21497,8750,1,1,1,21.460324),-- [rare_67_a]
(21497,8760,1,1,1,3.787116),-- [unique_67_a]
(21498,6337,1,1,-1,30171),-- [rp_sealed_majestic_earing_i]
(21498,5497,1,1,-1,137944),-- [sealed_tallum_boots_lining]
(21498,6339,1,1,-1,45256),-- [rp_sealed_majestic_ring_i]
(21498,57,2339,4736,0,700000),-- [adena]
(21499,5508,1,1,-1,143386),-- [sealed_dark_crystal_gloves_design]
(21499,729,1,1,-1,679),-- [scrl_of_ench_wp_a]
(21499,1895,1,3,-1,873628),-- [metallic_fiber]
(21499,57,2431,4922,0,700000),-- [adena]
(21500,4042,1,1,-1,98055),-- [enria]
(21500,5509,1,1,-1,137944),-- [sealed_tallum_gloves_design]
(21500,5434,1,1,-1,2179),-- [rp_dragon_slayer_i]
(21500,57,2339,4736,0,700000),-- [adena]
(21501,5520,1,1,-1,36486),-- [sealed_dark_crystal_breastplate_pattern]
(21501,5440,1,1,-1,2096),-- [rp_elysian_i]
(21501,5521,1,1,-1,25746),-- [sealed_tallum_plate_armor_pattern]
(21501,57,2250,4554,0,700000),-- [adena]
(21502,730,1,1,-1,6001),-- [scrl_of_ench_am_a]
(21502,1885,1,1,-1,600140),-- [high_grade_suede]
(21502,5432,1,1,-1,27279),-- [rp_sealed_magestic_circlet_i]
(21502,1866,20,60,0,40289.129628),-- [suede]
(21502,1871,9,27,0,134297.09876),-- [charcoal]
(21502,5220,1,1,0,96693.828782),-- [reinforcing_agent]
(21502,1885,4,12,0,22382.987002),-- [high_grade_suede]
(21502,4041,1,1,0,21020.504942),-- [mold_hardener]
(21502,5450,1,1,0,895.28655),-- [rp_dragon_grinder_i]
(21502,8730,1,1,0,26859.419752),-- [general_67_a]
(21502,8740,1,1,0,6714.854938),-- [special_67_a]
(21502,8750,1,1,0,671.362006),-- [rare_67_a]
(21502,8760,1,1,0,134.190076),-- [unique_67_a]
(21502,1343,560,1680,0,61667.337564),-- [silver_arrow]
(21503,5524,1,1,-1,73781),-- [sealed_dark_crystal_gaiters_pattern]
(21503,5442,1,1,-1,2773),-- [rp_soul_bow_i]
(21503,5525,1,1,-1,115718),-- [sealed_dark_crystal_helmet_design]
(21503,11960,1,1,0,304.386642),-- [halbard_low]
(21503,5542,1,1,0,3728.613358),-- [halbard_edge]
(21503,1867,1,3,1,147412.635304),-- [animal_skin]
(21503,1872,1,3,1,98275.193368),-- [animal_bone]
(21503,1882,1,1,1,49137.441936),-- [leather]
(21503,1894,1,1,1,7758.445728),-- [crafted_leather]
(21503,4042,1,1,1,3685.168872),-- [enria]
(21503,5456,1,1,1,82.01644),-- [rp_tallum_glaive_i]
(21503,8730,1,1,1,2456.779248),-- [general_67_a]
(21503,8740,1,1,1,614.34956),-- [special_67_a]
(21503,8750,1,1,1,61.280208),-- [rare_67_a]
(21503,8760,1,1,1,12.689336),-- [unique_67_a]
(21504,5448,1,1,-1,2667),-- [rp_soul_separator_i]
(21504,5526,1,1,-1,111326),-- [sealed_tallum_bonnet_design]
(21504,729,1,1,-1,800),-- [scrl_of_ench_wp_a]
(21504,11955,1,1,0,292.808676),-- [carnium_bow_low]
(21504,5535,1,1,0,3629.191324),-- [carnium_bow_shaft]
(21504,1868,1,3,1,177272.199325),-- [thread]
(21504,1873,1,1,1,70908.87973),-- [silver_nugget]
(21504,5549,1,1,1,17727.034278),-- [iron_thread]
(21504,1889,1,1,1,11818.022852),-- [compound_braid]
(21504,4044,1,1,1,5909.011426),-- [thons]
(21504,5462,1,1,1,65.721693),-- [rp_worldtree's_branch_i]
(21504,5432,1,1,1,671.326672),-- [rp_sealed_magestic_circlet_i]
(21504,8730,1,1,1,1969.794245),-- [general_67_a]
(21504,8740,1,1,1,492.355734),-- [special_67_a]
(21504,8750,1,1,1,49.384097),-- [rare_67_a]
(21504,8760,1,1,1,10.025343),-- [unique_67_a]
(21504,1343,30,90,1,84415.244605),-- [silver_arrow]
(21505,4043,1,1,-1,230869),-- [asofe]
(21505,5366,1,1,-1,37438),-- [rp_sealed_shield_of_nightmare_i]
(21505,5532,1,1,-1,23356),-- [meteor_shower_head]
(21505,11951,1,1,0,281.615796),-- [bloody_orchid_low]
(21505,5536,1,1,0,3480.384204),-- [bloody_orchid_head]
(21505,1869,1,1,1,185986.368396),-- [iron_ore]
(21505,1864,1,3,1,185986.368396),-- [stem]
(21505,1880,1,1,1,18598.475772),-- [steel]
(21505,5550,1,1,1,2479.635702),-- [reinforcing_plate]
(21505,4043,1,1,1,6199.491924),-- [asofe]
(21505,5464,1,1,1,68.856399),-- [rp_dark_legion's_edge_i]
(21505,5430,1,1,1,704.67075),-- [rp_sealed_helm_of_nightmare_i]
(21505,8730,1,1,1,2066.497308),-- [general_67_a]
(21505,8740,1,1,1,516.624327),-- [special_67_a]
(21505,8750,1,1,1,51.541632),-- [rare_67_a]
(21505,8760,1,1,1,10.469394),-- [unique_67_a]
(21506,5450,1,1,-1,3673),-- [rp_dragon_grinder_i]
(21506,5535,1,1,-1,33842),-- [carnium_bow_shaft]
(21506,5456,1,1,-1,3673),-- [rp_tallum_glaive_i]
(21506,57,3943,7984,0,700000),-- [adena]
(21507,5536,1,1,-1,32189),-- [bloody_orchid_head]
(21507,5430,1,1,-1,1946),-- [rp_sealed_helm_of_nightmare_i]
(21507,4041,1,1,-1,82270),-- [mold_hardener]
(21507,57,3762,7615,0,700000),-- [adena]
(21508,4120,1,1,-1,14317),-- [bellion_cestus_edge]
(21508,5444,1,1,-1,1790),-- [rp_carnium_bow_i]
(21508,4121,1,1,-1,14269),-- [hazard_bow_shaft]
(21508,57,1298,2632,0,700000),-- [adena]
(21508,12341,1,1,1,748.51476),-- [earing_of_black_ore_low]
(21508,4052,1,1,1,5710.955216),-- [earing_of_black_ore_piece]
(21508,12342,1,1,1,561.071568),-- [necklace_of_black_ore_low]
(21508,4054,1,1,1,3177.181248),-- [necklace_of_black_ore_beads]
(21508,12343,1,1,1,1120.17408),-- [ring_of_black_ore_low]
(21508,4053,1,1,1,6914.103128),-- [ring_of_black_ore_gemstone]
(21508,1875,1,1,2,5865.551329),-- [stone_of_purity]
(21508,1879,1,1,2,14663.905338),-- [cokes]
(21508,1885,1,1,2,7331.952669),-- [high_grade_suede]
(21508,5550,1,1,2,1173.121072),-- [reinforcing_plate]
(21508,5549,1,1,2,8798.354009),-- [iron_thread]
(21508,5466,1,1,2,32.580693),-- [rp_sword_of_miracle_i]
(21508,6670,1,1,2,14663.905338),-- [key_of_treasure_box6]
(21508,8729,1,1,2,1173.121072),-- [general_64_a]
(21508,8739,1,1,2,293.280268),-- [special_64_a]
(21508,8749,1,1,2,29.338833),-- [rare_64_a]
(21508,8759,1,1,2,5.889379),-- [unique_64_a]
(21509,4091,1,1,-1,128386),-- [doom_gloves_part]
(21509,6333,1,1,-1,32834),-- [rp_sealed_phoenix's_ring_i]
(21509,4096,1,1,-1,128386),-- [blue_wolve's_gloves_fabric]
(21509,57,1127,2304,0,700000),-- [adena]
(21509,12194,1,1,1,230.798464),-- [blue_wolve's_leather_mail_low]
(21509,4082,1,1,1,2386.201536),-- [blue_wolve's_leather_mail_texture]
(21509,12186,1,1,1,230.798464),-- [leather_mail_of_doom_low]
(21509,4083,1,1,1,2386.201536),-- [leather_mail_of_doom_design]
(21509,1869,1,1,2,76794.567802),-- [iron_ore]
(21509,1864,1,1,2,153589.135604),-- [stem]
(21509,1880,1,1,2,7679.351038),-- [steel]
(21509,5550,1,1,2,1023.93697),-- [reinforcing_plate]
(21509,4043,1,1,2,2559.666188),-- [asofe]
(21509,5440,1,1,2,28.550394),-- [rp_elysian_i]
(21509,8730,1,1,2,853.339554),-- [general_67_a]
(21509,8740,1,1,2,213.24677),-- [special_67_a]
(21509,8750,1,1,2,21.500914),-- [rare_67_a]
(21509,8760,1,1,2,4.229688),-- [unique_67_a]
(21509,1343,10,30,2,109706.475078),-- [silver_arrow]
(21510,5508,1,1,-1,81999),-- [sealed_dark_crystal_gloves_design]
(21510,730,1,1,-1,2914),-- [scrl_of_ench_am_a]
(21510,1875,1,1,-1,233152),-- [stone_of_purity]
(21510,57,1383,2812,0,700000),-- [adena]
(21510,11951,1,1,1,142.2302),-- [bloody_orchid_low]
(21510,5536,1,1,1,1757.7698),-- [bloody_orchid_head]
(21510,1865,1,1,2,103304.194552),-- [varnish]
(21510,1870,1,1,2,103304.194552),-- [coal]
(21510,1879,1,1,2,17217.443854),-- [cokes]
(21510,1875,1,1,2,6886.83697),-- [stone_of_purity]
(21510,4040,1,1,2,2066.168234),-- [mold_lubricant]
(21510,5456,1,1,2,38.188618),-- [rp_tallum_glaive_i]
(21510,8730,1,1,2,1147.767114),-- [general_67_a]
(21510,8740,1,1,2,287.00035),-- [special_67_a]
(21510,8750,1,1,2,28.582892),-- [rare_67_a]
(21510,8760,1,1,2,5.622864),-- [unique_67_a]
(21511,1875,1,1,-1,301961),-- [stone_of_purity]
(21511,5539,1,1,-1,15274),-- [blood_tornado_edge]
(21511,5462,1,1,-1,1678),-- [rp_worldtree's_branch_i]
(21511,57,1793,3640,0,700000),-- [adena]
(21511,11946,1,1,1,46.046685),-- [dasparion's_staff_low]
(21511,5543,1,1,1,569.37204),-- [dasparion's_staff_head]
(21511,11949,1,1,1,46.046685),-- [meteor_shower_low]
(21511,5532,1,1,1,564.054165),-- [meteor_shower_head]
(21511,11953,1,1,1,46.046685),-- [eye_of_soul_low]
(21511,8341,1,1,1,563.33289),-- [eye_of_soul_piece]
(21511,11958,1,1,1,46.046685),-- [hammer_of_destroyer_low]
(21511,8346,1,1,1,564.054165),-- [hammer_of_destroyer_piece]
(21511,1872,1,1,2,162171.716226),-- [animal_bone]
(21511,1867,1,1,2,162171.716226),-- [animal_skin]
(21511,1881,1,1,2,16217.30331),-- [coarse_bone_powder]
(21511,1875,1,1,2,8108.432176),-- [stone_of_purity]
(21511,4041,1,1,2,1057.449822),-- [mold_hardener]
(21511,6337,1,1,2,623.759318),-- [rp_sealed_majestic_earing_i]
(21511,8730,1,1,2,1351.551682),-- [general_67_a]
(21511,8740,1,1,2,337.99766),-- [special_67_a]
(21511,8750,1,1,2,33.799766),-- [rare_67_a]
(21511,8760,1,1,2,6.58437),-- [unique_67_a]
(21511,1343,20,60,2,86877.689444),-- [silver_arrow]
(21512,730,1,1,-1,4407),-- [scrl_of_ench_am_a]
(21512,4041,1,1,-1,45985),-- [mold_hardener]
(21512,1875,1,1,-1,352548),-- [stone_of_purity]
(21512,57,2091,4255,0,700000),-- [adena]
(21512,11951,1,1,1,214.992176),-- [bloody_orchid_low]
(21512,5536,1,1,1,2657.007824),-- [bloody_orchid_head]
(21512,1872,1,3,2,63113.582088),-- [animal_bone]
(21512,1867,1,1,2,189341.13186),-- [animal_skin]
(21512,1881,1,1,2,18934.305984),-- [coarse_bone_powder]
(21512,1875,1,1,2,9467.152992),-- [stone_of_purity]
(21512,4041,1,1,2,1234.678392),-- [mold_hardener]
(21512,5462,1,1,2,52.441056),-- [rp_worldtree's_branch_i]
(21512,8730,1,1,2,1577.858832),-- [general_67_a]
(21512,8740,1,1,2,394.464708),-- [special_67_a]
(21512,8750,1,1,2,39.330792),-- [rare_67_a]
(21512,8760,1,1,2,7.71192),-- [unique_67_a]
(21512,1343,20,60,2,101433.341376),-- [silver_arrow]
(21513,5486,1,1,-1,22058),-- [sealed_dark_crystal_robe_fabric]
(21513,5442,1,1,-1,1381),-- [rp_soul_bow_i]
(21513,5489,1,1,-1,49202),-- [sealed_tallum_hose_fabric]
(21513,57,1474,2999,0,700000),-- [adena]
(21513,12224,1,1,1,599.752132),-- [sealed_dark_crystal_boots_low]
(21513,5496,1,1,1,3227.247868),-- [sealed_dark_crystal_boots_lining]
(21513,12231,1,1,1,599.752132),-- [sealed_tallum_boots_low]
(21513,5497,1,1,1,3227.247868),-- [sealed_tallum_boots_lining]
(21513,12221,1,1,1,599.752132),-- [sealed_dark_crystal_gloves_low]
(21513,5508,1,1,1,3227.247868),-- [sealed_dark_crystal_gloves_design]
(21513,12229,1,1,1,599.752132),-- [sealed_tallum_gloves_low]
(21513,5509,1,1,1,3227.247868),-- [sealed_tallum_gloves_design]
(21513,1895,1,1,2,34957.114227),-- [metallic_fiber]
(21513,4040,1,1,2,2446.985763),-- [mold_lubricant]
(21513,4042,1,1,2,2039.177456),-- [enria]
(21513,4043,1,1,2,4078.309605),-- [asofe]
(21513,5464,1,1,2,45.307),-- [rp_dark_legion's_edge_i]
(21513,8730,1,1,2,1359.436535),-- [general_67_a]
(21513,8740,1,1,2,339.847807),-- [special_67_a]
(21513,8750,1,1,2,33.98025),-- [rare_67_a]
(21513,8760,1,1,2,6.841357),-- [unique_67_a]
(21514,4039,1,1,-1,86637),-- [mold_glue]
(21514,5479,1,1,-1,15379),-- [sealed_tallum_leather_mail_pattern]
(21514,5462,1,1,-1,963),-- [rp_worldtree's_branch_i]
(21514,57,1283,2614,0,700000),-- [adena]
(21514,11946,1,1,1,33.033082),-- [dasparion's_staff_low]
(21514,5543,1,1,1,408.457488),-- [dasparion's_staff_head]
(21514,11949,1,1,1,33.033082),-- [meteor_shower_low]
(21514,5532,1,1,1,404.642538),-- [meteor_shower_head]
(21514,11953,1,1,1,33.033082),-- [eye_of_soul_low]
(21514,8341,1,1,1,404.125108),-- [eye_of_soul_piece]
(21514,11958,1,1,1,33.033082),-- [hammer_of_destroyer_low]
(21514,8346,1,1,1,404.642538),-- [hammer_of_destroyer_piece]
(21514,1864,1,1,2,191935.256553),-- [stem]
(21514,1869,1,1,2,95967.4333),-- [iron_ore]
(21514,1878,1,1,2,38386.97332),-- [braided_hemp]
(21514,1884,1,1,2,59056.822038),-- [cord]
(21514,4039,1,1,2,3198.784459),-- [mold_glue]
(21514,5272,1,1,2,42.504877),-- [rp_adv_comp_soulshot_s]
(21514,8730,1,1,2,1066.131502),-- [general_67_a]
(21514,8740,1,1,2,266.727852),-- [special_67_a]
(21514,8750,1,1,2,26.516804),-- [rare_67_a]
(21514,8760,1,1,2,5.849295),-- [unique_67_a]
(21515,5524,1,1,-1,31247),-- [sealed_dark_crystal_gaiters_pattern]
(21515,5442,1,1,-1,1174),-- [rp_soul_bow_i]
(21515,5525,1,1,-1,49008),-- [sealed_dark_crystal_helmet_design]
(21515,57,1563,3192,0,700000),-- [adena]
(21515,11951,1,1,1,161.094416),-- [bloody_orchid_low]
(21515,5536,1,1,1,1990.905584),-- [bloody_orchid_head]
(21515,1873,1,1,2,39019.6404),-- [silver_nugget]
(21515,1868,1,1,2,195097.356504),-- [thread]
(21515,1876,1,1,2,19509.8202),-- [mithril_ore]
(21515,1895,1,1,2,27870.930144),-- [metallic_fiber]
(21515,4042,1,1,2,1625.888808),-- [enria]
(21515,5277,1,1,2,43.543044),-- [rp_adv_comp_spiritshot_s]
(21515,6670,1,1,2,16258.042584),-- [key_of_treasure_box6]
(21515,8730,1,1,2,1083.925872),-- [general_67_a]
(21515,8740,1,1,2,270.981468),-- [special_67_a]
(21515,8750,1,1,2,27.055872),-- [rare_67_a]
(21515,8760,1,1,2,5.495724),-- [unique_67_a]
(21515,1344,10,30,2,121935.31938),-- [mithril_arrow]
(21516,6337,1,1,-1,19666),-- [rp_sealed_majestic_earing_i]
(21516,6345,1,1,-1,146702),-- [sealed_phoenix's_ring_gemstone]
(21516,6339,1,1,-1,29498),-- [rp_sealed_majestic_ring_i]
(21516,57,1894,3856,0,700000),-- [adena]
(21516,11951,1,1,1,194.930232),-- [bloody_orchid_low]
(21516,5536,1,1,1,2409.069768),-- [bloody_orchid_head]
(21516,1873,1,1,2,56636.885492),-- [silver_nugget]
(21516,1868,1,1,2,283185.252854),-- [thread]
(21516,1876,1,1,2,28318.442746),-- [mithril_ore]
(21516,1895,1,1,2,40455.036122),-- [metallic_fiber]
(21516,4042,1,1,2,2359.801446),-- [enria]
(21516,5282,1,1,2,62.729944),-- [rp_adv_comp_bspiritshot_s]
(21516,8731,1,1,2,1311.138369),-- [general_70_a]
(21516,8741,1,1,2,327.681418),-- [special_70_a]
(21516,8751,1,1,2,32.603063),-- [rare_70_a]
(21516,8761,1,1,2,7.428546),-- [unique_70_a]
(21517,5479,1,1,-1,28262),-- [sealed_tallum_leather_mail_pattern]
(21517,5462,1,1,-1,1769),-- [rp_worldtree's_branch_i]
(21517,5478,1,1,-1,40163),-- [sealed_dark_crystal_leather_mail_pattern]
(21517,57,2357,4804,0,700000),-- [adena]
(21517,12222,1,1,1,426.904319),-- [sealed_dark_crystal_leather_mail_low]
(21517,5478,1,1,1,2471.584192),-- [sealed_dark_crystal_leather_mail_pattern]
(21517,12230,1,1,1,262.427916),-- [sealed_tallum_leather_mail_low]
(21517,5479,1,1,1,1739.176381),-- [sealed_tallum_leather_mail_pattern]
(21517,12228,1,1,1,683.540879),-- [sealed_legging_of_dark_crystal_low]
(21517,5482,1,1,1,3879.366313),-- [sealed_legging_of_dark_crystal_design]
(21517,1864,4,12,2,44088.436778),-- [stem]
(21517,1865,2,6,2,35270.59454),-- [varnish]
(21517,1866,1,1,2,117568.519398),-- [suede]
(21517,1873,1,1,2,70541.18908),-- [silver_nugget]
(21517,1868,1,3,2,117568.519398),-- [thread]
(21517,5162,1,1,2,78.215612),-- [rp_comp_spiritshot_s]
(21517,8731,1,1,2,1632.847702),-- [general_70_a]
(21517,8741,1,1,2,408.115124),-- [special_70_a]
(21517,8751,1,1,2,40.65663),-- [rare_70_a]
(21517,8761,1,1,2,8.905738),-- [unique_70_a]
(21518,4041,1,1,-1,28954),-- [mold_hardener]
(21518,5509,1,1,-1,78069),-- [sealed_tallum_gloves_design]
(21518,5462,1,1,-1,1233),-- [rp_worldtree's_branch_i]
(21518,57,1317,2677,0,700000),-- [adena]
(21518,11955,1,1,1,135.354954),-- [carnium_bow_low]
(21518,5535,1,1,1,1677.645046),-- [carnium_bow_shaft]
(21518,1866,1,1,2,59607.885623),-- [suede]
(21518,1871,1,1,2,89411.973365),-- [charcoal]
(21518,5220,1,1,2,3576.594879),-- [reinforcing_agent]
(21518,1885,1,1,2,7450.877005),-- [high_grade_suede]
(21518,4041,1,1,2,777.407202),-- [mold_hardener]
(21518,5462,1,1,2,33.044154),-- [rp_worldtree's_branch_i]
(21518,8730,1,1,2,993.353647),-- [general_67_a]
(21518,8740,1,1,2,248.410877),-- [special_67_a]
(21518,8750,1,1,2,24.928046),-- [rare_67_a]
(21518,8760,1,1,2,4.927637),-- [unique_67_a]
(21518,1343,10,30,2,127731.597565),-- [silver_arrow]
(21519,5448,1,1,-1,1118),-- [rp_soul_separator_i]
(21519,5526,1,1,-1,46659),-- [sealed_tallum_bonnet_design]
(21519,729,1,1,-1,335),-- [scrl_of_ench_wp_a]
(21519,57,1488,3039,0,700000),-- [adena]
(21519,12224,1,1,1,607.000247),-- [sealed_dark_crystal_boots_low]
(21519,5496,1,1,1,3266.249753),-- [sealed_dark_crystal_boots_lining]
(21519,12231,1,1,1,607.000247),-- [sealed_tallum_boots_low]
(21519,5497,1,1,1,3266.249753),-- [sealed_tallum_boots_lining]
(21519,12221,1,1,1,607.000247),-- [sealed_dark_crystal_gloves_low]
(21519,5508,1,1,1,3266.249753),-- [sealed_dark_crystal_gloves_design]
(21519,12229,1,1,1,607.000247),-- [sealed_tallum_gloves_low]
(21519,5509,1,1,1,3266.249753),-- [sealed_tallum_gloves_design]
(21519,1873,1,1,2,44579.3375),-- [silver_nugget]
(21519,1868,1,1,2,222896.6875),-- [thread]
(21519,1876,1,1,2,22289.5062),-- [mithril_ore]
(21519,1895,1,1,2,31842.2446),-- [metallic_fiber]
(21519,4042,1,1,2,1857.6214),-- [enria]
(21519,5282,1,1,2,49.4152),-- [rp_adv_comp_bspiritshot_s]
(21519,8730,1,1,2,1238.3059),-- [general_67_a]
(21519,8740,1,1,2,309.4952),-- [special_67_a]
(21519,8750,1,1,2,30.8845),-- [rare_67_a]
(21519,8760,1,1,2,6.502),-- [unique_67_a]
(21520,4049,1,1,-1,159526),-- [adamantite_earing_gemstone]
(21520,4129,1,1,-1,32915),-- [rp_earing_of_black_ore]
(21520,4050,1,1,-1,188436),-- [adamantite_ring_wire]
(21520,57,1203,2445,0,700000),-- [adena]
(21520,12338,1,1,1,1227.274644),-- [adamantite_earing_low]
(21520,4049,1,1,1,7853.442654),-- [adamantite_earing_gemstone]
(21520,12339,1,1,1,921.385206),-- [adamantite_necklace_low]
(21520,4051,1,1,1,5806.70106),-- [adamantite_necklace_chain]
(21520,12340,1,1,1,1848.48042),-- [adamantite_ring_low]
(21520,4050,1,1,1,9276.716016),-- [adamantite_ring_wire]
(21520,1895,1,1,2,25667.75232),-- [metallic_fiber]
(21520,4040,1,1,2,1796.769408),-- [mold_lubricant]
(21520,4042,1,1,2,1497.352416),-- [enria]
(21520,4043,1,1,2,2994.571104),-- [asofe]
(21520,947,1,1,2,35.972832),-- [scrl_of_ench_wp_b]
(21520,8728,1,1,2,1497.352416),-- [general_61_b]
(21520,8738,1,1,2,374.304672),-- [special_61_b]
(21520,8748,1,1,2,37.44384),-- [rare_61_b]
(21520,8758,1,1,2,7.488768),-- [unique_61_b]
(21520,1832,1,1,2,99818.992224),-- [advanced_antidote]
(21521,4130,1,1,-1,48542),-- [rp_ring_of_black_ore]
(21521,4051,1,1,-1,115966),-- [adamantite_necklace_chain]
(21521,947,1,1,-1,1196),-- [scrl_of_ench_wp_b]
(21521,57,1183,2404,0,700000),-- [adena]
(21521,78,1,1,1,4.407042),-- [great_sword]
(21521,4104,1,1,1,842.293074),-- [great_sword_blade]
(21521,142,1,1,1,4.407042),-- [kshanberk]
(21521,4107,1,1,1,829.2429),-- [kshanberk_blade]
(21521,148,1,1,1,4.407042),-- [sword_of_valhalla]
(21521,4108,1,1,1,829.2429),-- [sword_of_valhalla_blade]
(21521,1868,1,1,2,160591.3517),-- [thread]
(21521,1873,1,1,2,32118.3903),-- [silver_nugget]
(21521,5549,1,1,2,8029.5226),-- [iron_thread]
(21521,1889,1,1,2,5352.9151),-- [compound_braid]
(21521,4044,1,1,2,2676.6075),-- [thons]
(21521,948,1,1,2,200.6331),-- [scrl_of_ench_am_b]
(21521,8728,1,1,2,1338.1538),-- [general_61_b]
(21521,8738,1,1,2,334.6884),-- [special_61_b]
(21521,8748,1,1,2,33.5888),-- [rare_61_b]
(21521,8758,1,1,2,6.5978),-- [unique_61_b]
(21521,1832,1,1,2,89217.5509),-- [advanced_antidote]
(21522,4130,1,1,-1,57851),-- [rp_ring_of_black_ore]
(21522,4051,1,1,-1,138206),-- [adamantite_necklace_chain]
(21522,947,1,1,-1,1425),-- [scrl_of_ench_wp_b]
(21522,57,1409,2865,0,700000),-- [adena]
(21522,78,1,1,1,5.251988),-- [great_sword]
(21522,4104,1,1,1,1003.782836),-- [great_sword_blade]
(21522,142,1,1,1,5.251988),-- [kshanberk]
(21522,4107,1,1,1,988.2306),-- [kshanberk_blade]
(21522,148,1,1,1,5.251988),-- [sword_of_valhalla]
(21522,4108,1,1,1,988.2306),-- [sword_of_valhalla_blade]
(21522,1868,1,1,2,191390.191928),-- [thread]
(21522,1873,1,1,2,38278.181352),-- [silver_nugget]
(21522,5549,1,1,2,9569.455984),-- [iron_thread]
(21522,1889,1,1,2,6379.518184),-- [compound_braid]
(21522,4044,1,1,2,3189.9378),-- [thons]
(21522,948,1,1,2,239.111304),-- [scrl_of_ench_am_b]
(21522,8728,1,1,2,1594.790192),-- [general_61_b]
(21522,8738,1,1,2,398.876256),-- [special_61_b]
(21522,8748,1,1,2,40.030592),-- [rare_61_b]
(21522,8758,1,1,2,7.863152),-- [unique_61_b]
(21522,1832,1,1,2,106328.043256),-- [advanced_antidote]
(21523,4159,1,1,-1,8709),-- [rp_blue_wolve's_leather_mail]
(21523,4070,1,1,-1,110051),-- [hose_of_shrnoen_fabric]
(21523,948,1,1,-1,7686),-- [scrl_of_ench_am_b]
(21523,57,1218,2471,0,700000),-- [adena]
(21523,357,1,1,1,14.22495),-- [shrnoen's_breastplate]
(21523,4056,1,1,1,2055.231313),-- [shrnoen's_breastplate_part]
(21523,2376,1,1,1,14.22495),-- [avadon_breastplate]
(21523,4064,1,1,1,2055.231313),-- [avadon_breastplate_part]
(21523,383,1,1,1,22.75992),-- [shrnoen's_gaiters]
(21523,4057,1,1,1,3176.27328),-- [shrnoen's_gaiters_material]
(21523,2379,1,1,1,22.75992),-- [avadon_gaiters]
(21523,4065,1,1,1,3176.294354),-- [avadon_gaiters_material]
(21523,1864,1,3,2,75674.68986),-- [stem]
(21523,1865,1,1,2,75674.68986),-- [varnish]
(21523,1866,1,1,2,50449.79324),-- [suede]
(21523,1873,1,1,2,30269.875944),-- [silver_nugget]
(21523,1868,1,1,2,151349.37972),-- [thread]
(21523,4160,1,1,2,214.464635),-- [rp_leather_mail_of_doom]
(21523,6670,1,1,2,12612.44831),-- [key_of_treasure_box6]
(21523,8728,1,1,2,1261.244831),-- [general_61_b]
(21523,8738,1,1,2,315.190722),-- [special_61_b]
(21523,8748,1,1,2,31.326295),-- [rare_61_b]
(21523,8758,1,1,2,6.265259),-- [unique_61_b]
(21523,1832,1,1,2,84083.631324),-- [advanced_antidote]
(21524,4159,1,1,-1,9286),-- [rp_blue_wolve's_leather_mail]
(21524,4070,1,1,-1,117344),-- [hose_of_shrnoen_fabric]
(21524,948,1,1,-1,8195),-- [scrl_of_ench_am_b]
(21524,57,1299,2634,0,700000),-- [adena]
(21524,12151,1,1,1,515.581772),-- [shrnoen's_leather_shirts_low]
(21524,4066,1,1,1,3804.706272),-- [shrnoen's_leather_shirts_fabric]
(21524,12165,1,1,1,316.421566),-- [avadon_leather_mail_low]
(21524,4068,1,1,1,2922.96599),-- [avadon_leather_mail_lining]
(21524,12150,1,1,1,825.460494),-- [shrnoen's_leather_gaiters_low]
(21524,4067,1,1,1,5776.863906),-- [shrnoen's_leather_gaiters_texture]
(21524,1869,1,1,2,88025.00568),-- [iron_ore]
(21524,1870,1,1,2,88025.00568),-- [coal]
(21524,1871,1,1,2,88025.00568),-- [charcoal]
(21524,1872,1,3,2,39122.170782),-- [animal_bone]
(21524,1867,1,1,2,117366.512346),-- [animal_skin]
(21524,4161,1,1,2,365.232864),-- [rp_blue_wolve's_tunic]
(21524,8728,1,1,2,1467.245322),-- [general_61_b]
(21524,8738,1,1,2,366.68991),-- [special_61_b]
(21524,8748,1,1,2,36.911832),-- [rare_61_b]
(21524,8758,1,1,2,7.28523),-- [unique_61_b]
(21524,1343,20,60,2,62874.934674),-- [silver_arrow]
(21525,4049,1,1,-1,171939),-- [adamantite_earing_gemstone]
(21525,4129,1,1,-1,35476),-- [rp_earing_of_black_ore]
(21525,4050,1,1,-1,203099),-- [adamantite_ring_wire]
(21525,57,1299,2634,0,700000),-- [adena]
(21525,11915,1,1,1,138.54252),-- [kris_low]
(21525,4109,1,1,1,1363.95748),-- [kris_edge]
(21525,11919,1,1,1,138.54252),-- [hell_knife_low]
(21525,4110,1,1,1,1363.95748),-- [hell_knife_edge]
(21525,1894,1,1,2,3397.463606),-- [crafted_leather]
(21525,4039,1,1,2,3227.597982),-- [mold_glue]
(21525,4041,1,1,2,841.922946),-- [mold_hardener]
(21525,4044,1,1,2,3227.597982),-- [thons]
(21525,947,1,1,2,38.688256),-- [scrl_of_ench_wp_b]
(21525,8728,1,1,2,1613.874554),-- [general_61_b]
(21525,8738,1,1,2,403.50642),-- [special_61_b]
(21525,8748,1,1,2,40.350642),-- [rare_61_b]
(21525,8758,1,1,2,8.009678),-- [unique_61_b]
(21525,1343,10,30,2,138326.987934),-- [silver_arrow]
(21526,5549,1,1,-1,365298),-- [iron_thread]
(21526,1889,1,1,-1,243532),-- [compound_braid]
(21526,4052,1,1,-1,129332),-- [earing_of_black_ore_piece]
(21526,57,1449,2935,0,700000),-- [adena]
(21526,11930,1,1,1,58.731224),-- [sword_of_damascus_low]
(21526,4114,1,1,1,787.042528),-- [sword_of_damascus_blade]
(21526,11929,1,1,1,58.731224),-- [guardians_sword_low]
(21526,8330,1,1,1,785.718736),-- [guardians_sword_blade]
(21526,11943,1,1,1,58.731224),-- [tears_of_wizard_low]
(21526,8336,1,1,1,787.045064),-- [tears_of_wizard_blade]
(21526,1868,1,1,2,215806.53255),-- [thread]
(21526,1873,1,1,2,43161.30651),-- [silver_nugget]
(21526,5549,1,1,2,10790.255994),-- [iron_thread]
(21526,1889,1,1,2,7193.598174),-- [compound_braid]
(21526,4044,1,1,2,3596.65782),-- [thons]
(21526,1807,1,1,2,143.809806),-- [rp_soulshot_a]
(21526,8729,1,1,2,1438.663128),-- [general_64_a]
(21526,8739,1,1,2,359.665782),-- [special_64_a]
(21526,8749,1,1,2,35.881818),-- [rare_64_a]
(21526,8759,1,1,2,7.628418),-- [unique_64_a]
(21527,4040,1,1,-1,64217),-- [mold_lubricant]
(21527,4081,1,1,-1,31646),-- [doom_plate_armor_temper]
(21527,5161,1,1,-1,4281),-- [rp_comp_spiritshot_a]
(21527,57,1273,2578,0,700000),-- [adena]
(21527,12183,1,1,1,802.386192),-- [doom_shield_low]
(21527,4077,1,1,1,7110.680208),-- [doom_shield_fragment]
(21527,12202,1,1,1,561.53184),-- [blue_wolve's_helmet_low]
(21527,4088,1,1,1,5973.93496),-- [blue_wolve's_helmet_design]
(21527,12185,1,1,1,561.53184),-- [doom_helmet_low]
(21527,4089,1,1,1,5973.93496),-- [doom_helmet_pattern]
(21527,1871,1,1,2,86221.05624),-- [charcoal]
(21527,1866,1,1,2,57480.70416),-- [suede]
(21527,1877,1,1,2,3448.732496),-- [admantite_nugget]
(21527,4041,1,1,2,749.617088),-- [mold_hardener]
(21527,4040,1,1,2,1724.50344),-- [mold_lubricant]
(21527,5166,1,1,2,114.966896),-- [rp_comp_bspiritshot_a]
(21527,8729,1,1,2,1149.66896),-- [general_64_a]
(21527,8739,1,1,2,287.280048),-- [special_64_a]
(21527,8749,1,1,2,28.81032),-- [rare_64_a]
(21527,8759,1,1,2,5.762064),-- [unique_64_a]
(21527,1343,10,30,2,123172.898288),-- [silver_arrow]
(21528,4040,1,1,-1,79165),-- [mold_lubricant]
(21528,4081,1,1,-1,39013),-- [doom_plate_armor_temper]
(21528,5161,1,1,-1,5278),-- [rp_comp_spiritshot_a]
(21528,57,1570,3179,0,700000),-- [adena]
(21528,12183,1,1,1,989.178822),-- [doom_shield_low]
(21528,4077,1,1,1,8766.021078),-- [doom_shield_fragment]
(21528,12202,1,1,1,692.25444),-- [blue_wolve's_helmet_low]
(21528,4088,1,1,1,7364.64561),-- [blue_wolve's_helmet_design]
(21528,12185,1,1,1,692.25444),-- [doom_helmet_low]
(21528,4089,1,1,1,7364.64561),-- [doom_helmet_pattern]
(21528,1871,1,1,2,106291.24569),-- [charcoal]
(21528,1866,1,1,2,70860.83046),-- [suede]
(21528,1877,1,1,2,4251.514526),-- [admantite_nugget]
(21528,4041,1,1,2,924.109928),-- [mold_hardener]
(21528,4040,1,1,2,2125.92639),-- [mold_lubricant]
(21528,5166,1,1,2,141.728426),-- [rp_comp_bspiritshot_a]
(21528,8729,1,1,2,1417.28426),-- [general_64_a]
(21528,8739,1,1,2,354.151938),-- [special_64_a]
(21528,8749,1,1,2,35.51667),-- [rare_64_a]
(21528,8759,1,1,2,7.103334),-- [unique_64_a]
(21528,1343,10,30,2,151844.588378),-- [silver_arrow]
(21529,4082,1,1,-1,34211),-- [blue_wolve's_leather_mail_texture]
(21529,5166,1,1,-1,4037),-- [rp_comp_bspiritshot_a]
(21529,4083,1,1,-1,34211),-- [leather_mail_of_doom_design]
(21529,57,1201,2431,0,700000),-- [adena]
(21529,12201,1,1,1,198.380952),-- [blue_wolve's_tunic_low]
(21529,4084,1,1,1,1942.807944),-- [blue_wolve's_tunic_fabric]
(21529,12192,1,1,1,198.380952),-- [tunic_of_doom_low]
(21529,4085,1,1,1,1942.807944),-- [tunic_of_doom_pattern]
(21529,12203,1,1,1,317.584344),-- [blue_wolve's_hose_low]
(21529,4086,1,1,1,2623.22676),-- [blue_wolve's_hose_pattern]
(21529,12205,1,1,1,317.584344),-- [hose_of_doom_low]
(21529,4087,1,1,1,2623.22676),-- [hose_of_doom_pattern]
(21529,1867,1,1,2,108403.127844),-- [animal_skin]
(21529,1872,1,1,2,108403.127844),-- [animal_bone]
(21529,1882,1,1,2,18067.187974),-- [leather]
(21529,1894,1,1,2,2852.800973),-- [crafted_leather]
(21529,4042,1,1,2,1355.088735),-- [enria]
(21529,5230,1,1,2,108.539464),-- [rp_mithril_arrow]
(21529,8729,1,1,2,1084.070988),-- [general_64_a]
(21529,8739,1,1,2,271.017747),-- [special_64_a]
(21529,8749,1,1,2,27.134866),-- [rare_64_a]
(21529,8759,1,1,2,5.294608),-- [unique_64_a]
(21529,1832,1,1,2,90335.608957),-- [advanced_antidote]
(21530,4120,1,1,-1,14136),-- [bellion_cestus_edge]
(21530,5470,1,1,-1,1768),-- [rp_tallum_blade_i]
(21530,4121,1,1,-1,14088),-- [hazard_bow_shaft]
(21530,57,1284,2598,0,700000),-- [adena]
(21530,11933,1,1,1,156.0702),-- [bellion_cestus_low]
(21530,4120,1,1,1,2087.9298),-- [bellion_cestus_edge]
(21530,1874,1,1,2,5791.093324),-- [oriharukon_ore]
(21530,1878,1,1,2,34746.439727),-- [braided_hemp]
(21530,1884,1,1,2,53456.172088),-- [cord]
(21530,1889,1,1,2,5791.093324),-- [compound_braid]
(21530,5220,1,1,2,3474.631951),-- [reinforcing_agent]
(21530,6333,1,1,2,997.320232),-- [rp_sealed_phoenix's_ring_i]
(21530,6670,1,1,2,14477.73331),-- [key_of_treasure_box6]
(21530,8729,1,1,2,1158.170578),-- [general_64_a]
(21530,8739,1,1,2,289.602753),-- [special_64_a]
(21530,8749,1,1,2,28.972297),-- [rare_64_a]
(21530,8759,1,1,2,5.770416),-- [unique_64_a]
(21531,1876,1,1,-1,727098),-- [mithril_ore]
(21531,1895,1,3,-1,519356),-- [metallic_fiber]
(21531,4052,1,1,-1,128713),-- [earing_of_black_ore_piece]
(21531,57,1443,2919,0,700000),-- [adena]
(21531,11944,1,1,1,175.396752),-- [hazard_bow_low]
(21531,4121,1,1,1,2338.603248),-- [hazard_bow_shaft]
(21531,1873,1,1,2,39049.704768),-- [silver_nugget]
(21531,1868,1,1,2,195248.099239),-- [thread]
(21531,1876,1,1,2,19524.852384),-- [mithril_ore]
(21531,1895,1,1,2,27892.464291),-- [metallic_fiber]
(21531,4042,1,1,2,1627.071032),-- [enria]
(21531,1807,1,1,2,130.352507),-- [rp_soulshot_a]
(21531,8729,1,1,2,1301.826666),-- [general_64_a]
(21531,8739,1,1,2,325.244366),-- [special_64_a]
(21531,8749,1,1,2,32.694277),-- [rare_64_a]
(21531,8759,1,1,2,6.369015),-- [unique_64_a]
(21531,1343,10,30,2,139462.321455),-- [silver_arrow]
(21532,4054,1,1,-1,74152),-- [necklace_of_black_ore_beads]
(21532,1894,1,1,-1,132094),-- [crafted_leather]
(21532,4042,1,1,-1,62745),-- [enria]
(21532,57,1492,3025,0,700000),-- [adena]
(21532,11935,1,1,1,60.546192),-- [deadman's_glory_low]
(21532,4116,1,1,1,809.977441),-- [deadman's_glory_stone]
(21532,11938,1,1,1,60.546192),-- [art_of_battle_axe_low]
(21532,4117,1,1,1,809.977441),-- [art_of_battle_axe_blade]
(21532,11934,1,1,1,60.546192),-- [staff_of_evil_sprit_low]
(21532,4118,1,1,1,767.406542),-- [staff_of_evil_sprit_head]
(21532,1867,1,1,2,148270.557621),-- [animal_skin]
(21532,1872,1,1,2,148270.557621),-- [animal_bone]
(21532,1882,1,1,2,24711.814428),-- [leather]
(21532,1894,1,1,2,3901.969314),-- [crafted_leather]
(21532,4042,1,1,2,1853.287398),-- [enria]
(21532,5450,1,1,2,41.118375),-- [rp_dragon_grinder_i]
(21532,8729,1,1,2,1482.564129),-- [general_64_a]
(21532,8739,1,1,2,370.723269),-- [special_64_a]
(21532,8749,1,1,2,37.171011),-- [rare_64_a]
(21532,8759,1,1,2,7.236834),-- [unique_64_a]
(21533,4077,1,1,-1,144198),-- [doom_shield_fragment]
(21533,5470,1,1,-1,1752),-- [rp_tallum_blade_i]
(21533,5348,1,1,-1,6310),-- [rp_sealed_dark_crystal_robe_i]
(21533,57,1270,2576,0,700000),-- [adena]
(21533,12341,1,1,1,732.298035),-- [earing_of_black_ore_low]
(21533,4052,1,1,1,5587.226206),-- [earing_of_black_ore_piece]
(21533,12342,1,1,1,548.915838),-- [necklace_of_black_ore_low]
(21533,4054,1,1,1,3108.346968),-- [necklace_of_black_ore_beads]
(21533,12343,1,1,1,1095.90528),-- [ring_of_black_ore_low]
(21533,4053,1,1,1,6764.307673),-- [ring_of_black_ore_gemstone]
(21533,1871,1,1,2,86078.01318),-- [charcoal]
(21533,1866,1,1,2,57385.250838),-- [suede]
(21533,1877,1,1,2,3443.065758),-- [admantite_nugget]
(21533,4041,1,1,2,748.421118),-- [mold_hardener]
(21533,4040,1,1,2,1721.669802),-- [mold_lubricant]
(21533,5456,1,1,2,31.766136),-- [rp_tallum_glaive_i]
(21533,8729,1,1,2,1147.688586),-- [general_64_a]
(21533,8739,1,1,2,286.990608),-- [special_64_a]
(21533,8749,1,1,2,28.75383),-- [rare_64_a]
(21533,8759,1,1,2,5.750766),-- [unique_64_a]
(21533,1343,10,30,2,122968.629378),-- [silver_arrow]
(21534,4077,1,1,-1,190615),-- [doom_shield_fragment]
(21534,5470,1,1,-1,2316),-- [rp_tallum_blade_i]
(21534,5348,1,1,-1,8341),-- [rp_sealed_dark_crystal_robe_i]
(21534,57,1679,3405,0,700000),-- [adena]
(21534,12341,1,1,1,968.035845),-- [earing_of_black_ore_low]
(21534,4052,1,1,1,7385.838802),-- [earing_of_black_ore_piece]
(21534,12342,1,1,1,725.620146),-- [necklace_of_black_ore_low]
(21534,4054,1,1,1,4108.970856),-- [necklace_of_black_ore_beads]
(21534,12343,1,1,1,1448.69376),-- [ring_of_black_ore_low]
(21534,4053,1,1,1,8941.840591),-- [ring_of_black_ore_gemstone]
(21534,1871,1,1,2,113786.83134),-- [charcoal]
(21534,1866,1,1,2,75857.766894),-- [suede]
(21534,1877,1,1,2,4551.400854),-- [admantite_nugget]
(21534,4041,1,1,2,989.340534),-- [mold_hardener]
(21534,4040,1,1,2,2275.881426),-- [mold_lubricant]
(21534,5456,1,1,2,41.991768),-- [rp_tallum_glaive_i]
(21534,8729,1,1,2,1517.133618),-- [general_64_a]
(21534,8739,1,1,2,379.373904),-- [special_64_a]
(21534,8749,1,1,2,38.00979),-- [rare_64_a]
(21534,8759,1,1,2,7.601958),-- [unique_64_a]
(21534,1343,10,30,2,162552.667914),-- [silver_arrow]
(21535,1876,1,1,-1,759357),-- [mithril_ore]
(21535,1877,1,1,-1,151871),-- [admantite_nugget]
(21535,4052,1,1,-1,134423),-- [earing_of_black_ore_piece]
(21535,57,1504,3050,0,700000),-- [adena]
(21535,11930,1,1,1,61.047124),-- [sword_of_damascus_low]
(21535,4114,1,1,1,818.077328),-- [sword_of_damascus_blade]
(21535,11929,1,1,1,61.047124),-- [guardians_sword_low]
(21535,8330,1,1,1,816.701336),-- [guardians_sword_blade]
(21535,11943,1,1,1,61.047124),-- [tears_of_wizard_low]
(21535,8336,1,1,1,818.079964),-- [tears_of_wizard_blade]
(21535,1876,1,1,2,20391.1506),-- [mithril_ore]
(21535,1880,1,1,2,10195.5753),-- [steel]
(21535,1877,1,1,2,4078.3176),-- [admantite_nugget]
(21535,1881,1,1,2,13594.1733),-- [coarse_bone_powder]
(21535,1882,1,1,2,22656.8826),-- [leather]
(21535,6335,1,1,2,392.1291),-- [rp_sealed_majestic_necklace_i]
(21535,8729,1,1,2,1359.4392),-- [general_64_a]
(21535,8739,1,1,2,339.8598),-- [special_64_a]
(21535,8749,1,1,2,33.8985),-- [rare_64_a]
(21535,8759,1,1,2,6.7797),-- [unique_64_a]
(21535,1343,10,30,2,145651.7943),-- [silver_arrow]
(21536,5446,1,1,-1,2006),-- [rp_bloody_orchid_i]
(21536,4053,1,1,-1,157335),-- [ring_of_black_ore_gemstone]
(21536,5452,1,1,-1,2006),-- [rp_blood_tornado_i]
(21536,57,1454,2949,0,700000),-- [adena]
(21536,11939,1,1,1,177.0771),-- [demon's_sword_low]
(21536,4119,1,1,1,2372.9229),-- [demon's_sword_edge]
(21536,1894,1,1,2,3804.400284),-- [crafted_leather]
(21536,4039,1,1,2,3614.193251),-- [mold_glue]
(21536,4041,1,1,2,942.824556),-- [mold_hardener]
(21536,4044,1,1,2,3614.193251),-- [thons]
(21536,6337,1,1,2,556.017249),-- [rp_sealed_majestic_earing_i]
(21536,6670,1,1,2,18070.901349),-- [key_of_treasure_box6]
(21536,8729,1,1,2,1445.683791),-- [general_64_a]
(21536,8739,1,1,2,361.429061),-- [special_64_a]
(21536,8749,1,1,2,36.152642),-- [rare_64_a]
(21536,8759,1,1,2,7.204566),-- [unique_64_a]
(21537,1874,1,1,-1,246235),-- [oriharukon_ore]
(21537,4043,1,1,-1,123118),-- [asofe]
(21537,4099,1,1,-1,165815),-- [doom_boots_part]
(21537,57,1456,2976,0,700000),-- [adena]
(21537,11944,1,1,1,178.187472),-- [hazard_bow_low]
(21537,4121,1,1,1,2375.812528),-- [hazard_bow_shaft]
(21537,1870,1,1,2,99183.032124),-- [coal]
(21537,1865,1,1,2,99183.032124),-- [varnish]
(21537,1874,1,1,2,6612.24476),-- [oriharukon_ore]
(21537,4043,1,1,2,3306.12238),-- [asofe]
(21537,4039,1,1,2,3306.12238),-- [mold_glue]
(21537,5442,1,1,2,36.651824),-- [rp_soul_bow_i]
(21537,8300,1,1,2,54.125368),-- [rp_inferno_master_i]
(21537,8730,1,1,2,1102.111824),-- [general_67_a]
(21537,8740,1,1,2,275.527956),-- [special_67_a]
(21537,8750,1,1,2,27.488868),-- [rare_67_a]
(21537,8760,1,1,2,5.540392),-- [unique_67_a]
(21538,1874,1,1,-1,301635),-- [oriharukon_ore]
(21538,4043,1,1,-1,150818),-- [asofe]
(21538,4099,1,1,-1,203121),-- [doom_boots_part]
(21538,57,1784,3645,0,700000),-- [adena]
(21538,11944,1,1,1,218.304072),-- [hazard_bow_low]
(21538,4121,1,1,1,2910.695928),-- [hazard_bow_shaft]
(21538,1870,1,1,2,133647.416725),-- [coal]
(21538,1865,1,1,2,133647.416725),-- [varnish]
(21538,1874,1,1,2,8909.92347),-- [oriharukon_ore]
(21538,4043,1,1,2,4454.961735),-- [asofe]
(21538,4039,1,1,2,4454.961735),-- [mold_glue]
(21538,5442,1,1,2,49.37518),-- [rp_soul_bow_i]
(21538,8730,1,1,2,1484.987245),-- [general_67_a]
(21538,8740,1,1,2,371.175045),-- [special_67_a]
(21538,8750,1,1,2,37.031385),-- [rare_67_a]
(21538,8760,1,1,2,7.750755),-- [unique_67_a]
(21539,1807,1,1,-1,5356),-- [rp_soulshot_a]
(21539,4114,1,1,-1,17583),-- [sword_of_damascus_blade]
(21539,3035,1,1,-1,5356),-- [rp_spiritshot_a]
(21539,57,1584,3236,0,700000),-- [adena]
(21539,12201,1,1,1,263.219748),-- [blue_wolve's_tunic_low]
(21539,4084,1,1,1,2577.794956),-- [blue_wolve's_tunic_fabric]
(21539,12192,1,1,1,263.219748),-- [tunic_of_doom_low]
(21539,4085,1,1,1,2577.794956),-- [tunic_of_doom_pattern]
(21539,12203,1,1,1,421.383556),-- [blue_wolve's_hose_low]
(21539,4086,1,1,1,3480.60174),-- [blue_wolve's_hose_pattern]
(21539,12205,1,1,1,421.383556),-- [hose_of_doom_low]
(21539,4087,1,1,1,3480.60174),-- [hose_of_doom_pattern]
(21539,1871,1,1,2,107870.988181),-- [charcoal]
(21539,1866,1,1,2,71914.106411),-- [suede]
(21539,1877,1,1,2,4314.688664),-- [admantite_nugget]
(21539,4041,1,1,2,938.095056),-- [mold_hardener]
(21539,4040,1,1,2,2157.344332),-- [mold_lubricant]
(21539,5448,1,1,2,40.115907),-- [rp_soul_separator_i]
(21539,8730,1,1,2,1198.677016),-- [general_67_a]
(21539,8740,1,1,2,299.669254),-- [special_67_a]
(21539,8750,1,1,2,29.829777),-- [rare_67_a]
(21539,8760,1,1,2,5.828807),-- [unique_67_a]
(21539,1343,10,30,2,154101.656595),-- [silver_arrow]
(21540,1807,1,1,-1,5356),-- [rp_soulshot_a]
(21540,4053,1,1,-1,172185),-- [ring_of_black_ore_gemstone]
(21540,3035,1,1,-1,5356),-- [rp_spiritshot_a]
(21540,57,1584,3236,0,700000),-- [adena]
(21540,11935,1,1,1,64.599888),-- [deadman's_glory_low]
(21540,4116,1,1,1,864.207149),-- [deadman's_glory_stone]
(21540,11938,1,1,1,64.599888),-- [art_of_battle_axe_low]
(21540,4117,1,1,1,864.207149),-- [art_of_battle_axe_blade]
(21540,11934,1,1,1,64.599888),-- [staff_of_evil_sprit_low]
(21540,4118,1,1,1,818.786038),-- [staff_of_evil_sprit_head]
(21540,1894,1,1,2,3784.936896),-- [crafted_leather]
(21540,4039,1,1,2,3595.55526),-- [mold_glue]
(21540,4041,1,1,2,937.978263),-- [mold_hardener]
(21540,4044,1,1,2,3595.55526),-- [thons]
(21540,729,1,1,2,11.962719),-- [scrl_of_ench_wp_a]
(21540,5394,1,1,2,929.890791),-- [rp_sealed_tallum_gloves_i]
(21540,8730,1,1,2,1198.462257),-- [general_67_a]
(21540,8740,1,1,2,299.573442),-- [special_67_a]
(21540,8750,1,1,2,29.991042),-- [rare_67_a]
(21540,8760,1,1,2,6.065604),-- [unique_67_a]
(21540,1343,10,30,2,154099.028466),-- [silver_arrow]
(21541,1874,1,1,-1,272060),-- [oriharukon_ore]
(21541,4043,1,1,-1,136030),-- [asofe]
(21541,4084,1,1,-1,70923),-- [blue_wolve's_tunic_fabric]
(21541,57,1619,3277,0,700000),-- [adena]
(21541,11930,1,1,1,65.632606),-- [sword_of_damascus_low]
(21541,4114,1,1,1,879.526232),-- [sword_of_damascus_blade]
(21541,11929,1,1,1,65.632606),-- [guardians_sword_low]
(21541,8330,1,1,1,878.046884),-- [guardians_sword_blade]
(21541,11943,1,1,1,65.632606),-- [tears_of_wizard_low]
(21541,8336,1,1,1,879.529066),-- [tears_of_wizard_blade]
(21541,1870,1,1,2,100452.93293),-- [coal]
(21541,1865,1,1,2,100452.93293),-- [varnish]
(21541,1874,1,1,2,6696.982368),-- [oriharukon_ore]
(21541,4043,1,1,2,3348.491184),-- [asofe]
(21541,4039,1,1,2,3348.491184),-- [mold_glue]
(21541,5271,1,1,2,134.112696),-- [rp_adv_comp_soulshot_a]
(21541,5392,1,1,2,865.964236),-- [rp_sealed_dark_crystal_gloves_i]
(21541,8729,1,1,2,1339.32437),-- [general_64_a]
(21541,8739,1,1,2,334.921222),-- [special_64_a]
(21541,8749,1,1,2,33.528174),-- [rare_64_a]
(21541,8759,1,1,2,6.849842),-- [unique_64_a]
(21541,1343,10,30,2,143503.468864),-- [silver_arrow]
(21542,1807,1,1,-1,3783),-- [rp_soulshot_a]
(21542,4053,1,1,-1,121630),-- [ring_of_black_ore_gemstone]
(21542,3035,1,1,-1,3783),-- [rp_spiritshot_a]
(21542,57,1125,2280,0,700000),-- [adena]
(21542,11939,1,1,1,136.870182),-- [demon's_sword_low]
(21542,4119,1,1,1,1834.129818),-- [demon's_sword_edge]
(21542,1869,1,1,2,76198.948452),-- [iron_ore]
(21542,1864,1,1,2,152398.246935),-- [stem]
(21542,1880,1,1,2,7619.824839),-- [steel]
(21542,5550,1,1,2,1016.139993),-- [reinforcing_plate]
(21542,4043,1,1,2,2539.824936),-- [asofe]
(21542,3035,1,1,2,101.50899),-- [rp_spiritshot_a]
(21542,8729,1,1,2,1016.139993),-- [general_64_a]
(21542,8739,1,1,2,254.122506),-- [special_64_a]
(21542,8749,1,1,2,25.552263),-- [rare_64_a]
(21542,8759,1,1,2,5.250465),-- [unique_64_a]
(21542,1343,10,30,2,108855.440628),-- [silver_arrow]
(21543,4054,1,1,-1,63772),-- [necklace_of_black_ore_beads]
(21543,1877,1,1,-1,129509),-- [admantite_nugget]
(21543,4041,1,1,-1,28154),-- [mold_hardener]
(21543,57,1284,2601,0,700000),-- [adena]
(21543,11935,1,1,1,31.237596),-- [deadman's_glory_low]
(21543,4116,1,1,1,417.895101),-- [deadman's_glory_stone]
(21543,11938,1,1,1,31.237596),-- [art_of_battle_axe_low]
(21543,4117,1,1,1,417.895101),-- [art_of_battle_axe_blade]
(21543,11934,1,1,1,31.237596),-- [staff_of_evil_sprit_low]
(21543,4118,1,1,1,395.931861),-- [staff_of_evil_sprit_head]
(21543,11941,1,1,1,31.237596),-- [bone_of_kaim_vanul_low]
(21543,8340,1,1,1,417.895101),-- [bone_of_kaim_vanul_head]
(21543,11936,1,1,1,31.237596),-- [star_buster_low]
(21543,8348,1,1,1,417.194856),-- [star_buster_head]
(21543,1871,1,1,2,95637.298175),-- [charcoal]
(21543,1866,1,1,2,63758.142875),-- [suede]
(21543,1877,1,1,2,3825.4718),-- [admantite_nugget]
(21543,4041,1,1,2,831.58055),-- [mold_hardener]
(21543,4040,1,1,2,1912.7359),-- [mold_lubricant]
(21543,3956,1,1,2,127.471),-- [rp_blessed_spiritshot_a]
(21543,8729,1,1,2,1275.213175),-- [general_64_a]
(21543,8739,1,1,2,318.845225),-- [special_64_a]
(21543,8749,1,1,2,31.86775),-- [rare_64_a]
(21543,8759,1,1,2,6.37355),-- [unique_64_a]
(21544,4115,1,1,-1,19727),-- [lancia_blade]
(21544,4041,1,1,-1,39321),-- [mold_hardener]
(21544,1875,1,1,-1,301461),-- [stone_of_purity]
(21544,57,1783,3643,0,700000),-- [adena]
(21544,12341,1,1,1,1033.02591),-- [earing_of_black_ore_low]
(21544,4052,1,1,1,7881.694556),-- [earing_of_black_ore_piece]
(21544,12342,1,1,1,774.335388),-- [necklace_of_black_ore_low]
(21544,4054,1,1,1,4384.830768),-- [necklace_of_black_ore_beads]
(21544,12343,1,1,1,1545.95328),-- [ring_of_black_ore_low]
(21544,4053,1,1,1,9542.160098),-- [ring_of_black_ore_gemstone]
(21544,1872,1,1,2,161903.412132),-- [animal_bone]
(21544,1867,1,1,2,161903.412132),-- [animal_skin]
(21544,1881,1,1,2,16190.482),-- [coarse_bone_powder]
(21544,1875,1,1,2,8095.241),-- [stone_of_purity]
(21544,4041,1,1,2,1055.901),-- [mold_hardener]
(21544,5450,1,1,2,45.051776),-- [rp_dragon_grinder_i]
(21544,5392,1,1,2,1046.749858),-- [rp_sealed_dark_crystal_gloves_i]
(21544,8730,1,1,2,1349.089511),-- [general_67_a]
(21544,8740,1,1,2,337.184386),-- [special_67_a]
(21544,8750,1,1,2,33.788832),-- [rare_67_a]
(21544,8760,1,1,2,6.687373),-- [unique_67_a]
(21545,4054,1,1,-1,64024),-- [necklace_of_black_ore_beads]
(21545,5230,1,1,-1,4334),-- [rp_mithril_arrow]
(21545,4052,1,1,-1,115082),-- [earing_of_black_ore_piece]
(21545,57,1288,2611,0,700000),-- [adena]
(21545,12204,1,1,1,213.072782),-- [blue_wolve's_breastplate_low]
(21545,4078,1,1,1,2337.353655),-- [blue_wolve's_breastplate_part]
(21545,12184,1,1,1,131.156311),-- [doom_plate_armor_low]
(21545,4081,1,1,1,1577.126824),-- [doom_plate_armor_temper]
(21545,12193,1,1,1,340.820181),-- [blue_wolve's_gaiters_low]
(21545,4080,1,1,1,3291.470247),-- [blue_wolve's_gaiters_material]
(21545,1864,1,3,2,87285.899846),-- [stem]
(21545,1865,1,1,2,87285.899846),-- [varnish]
(21545,1866,1,1,2,58190.750805),-- [suede]
(21545,1873,1,1,2,34914.450483),-- [silver_nugget]
(21545,1868,1,3,2,58190.750805),-- [thread]
(21545,6339,1,1,2,671.388209),-- [rp_sealed_majestic_ring_i]
(21545,8729,1,1,2,1163.950833),-- [general_64_a]
(21545,8739,1,1,2,291.100889),-- [special_64_a]
(21545,8749,1,1,2,28.974272),-- [rare_64_a]
(21545,8759,1,1,2,5.885399),-- [unique_64_a]
(21545,1343,10,30,2,124693.948613),-- [silver_arrow]
(21546,4077,1,1,-1,166838),-- [doom_shield_fragment]
(21546,5458,1,1,-1,2027),-- [rp_halbard_i]
(21546,4078,1,1,-1,54175),-- [blue_wolve's_breastplate_part]
(21546,57,1469,2980,0,700000),-- [adena]
(21546,12201,1,1,1,243.018618),-- [blue_wolve's_tunic_low]
(21546,4084,1,1,1,2379.958846),-- [blue_wolve's_tunic_fabric]
(21546,12192,1,1,1,243.018618),-- [tunic_of_doom_low]
(21546,4085,1,1,1,2379.958846),-- [tunic_of_doom_pattern]
(21546,12203,1,1,1,389.043946),-- [blue_wolve's_hose_low]
(21546,4086,1,1,1,3213.47859),-- [blue_wolve's_hose_pattern]
(21546,12205,1,1,1,389.043946),-- [hose_of_doom_low]
(21546,4087,1,1,1,3213.47859),-- [hose_of_doom_pattern]
(21546,1869,1,1,2,99593.287534),-- [iron_ore]
(21546,1870,1,1,2,99593.287534),-- [coal]
(21546,1871,1,1,2,99593.287534),-- [charcoal]
(21546,1872,1,3,2,66395.662359),-- [animal_bone]
(21546,1867,1,3,2,44263.774906),-- [animal_skin]
(21546,729,1,1,2,11.124243),-- [scrl_of_ench_wp_a]
(21546,5394,1,1,2,858.626756),-- [rp_sealed_tallum_gloves_i]
(21546,8729,1,1,2,1327.905007),-- [general_64_a]
(21546,8739,1,1,2,332.079254),-- [special_64_a]
(21546,8749,1,1,2,33.372729),-- [rare_64_a]
(21546,8759,1,1,2,6.592144),-- [unique_64_a]
(21547,5230,1,1,-1,4131),-- [rp_mithril_arrow]
(21547,4085,1,1,-1,53851),-- [tunic_of_doom_pattern]
(21547,5271,1,1,-1,4131),-- [rp_adv_comp_soulshot_a]
(21547,57,1229,2488,0,700000),-- [adena]
(21547,11935,1,1,1,49.822752),-- [deadman's_glory_low]
(21547,4116,1,1,1,666.520946),-- [deadman's_glory_stone]
(21547,11938,1,1,1,49.822752),-- [art_of_battle_axe_low]
(21547,4117,1,1,1,666.520946),-- [art_of_battle_axe_blade]
(21547,11934,1,1,1,49.822752),-- [staff_of_evil_sprit_low]
(21547,4118,1,1,1,631.489852),-- [staff_of_evil_sprit_head]
(21547,1895,1,1,2,26151.096726),-- [metallic_fiber]
(21547,4040,1,1,2,1830.577806),-- [mold_lubricant]
(21547,4042,1,1,2,1525.475754),-- [enria]
(21547,4043,1,1,2,3050.951508),-- [asofe]
(21547,5276,1,1,2,122.047722),-- [rp_adv_comp_spiritshot_a]
(21547,5346,1,1,2,263.763864),-- [rp_sealed_tallum_tunic_i]
(21547,8729,1,1,2,1220.373702),-- [general_64_a]
(21547,8739,1,1,2,305.102052),-- [special_64_a]
(21547,8749,1,1,2,30.503304),-- [rare_64_a]
(21547,8759,1,1,2,6.107562),-- [unique_64_a]
(21548,4086,1,1,-1,62149),-- [blue_wolve's_hose_pattern]
(21548,4044,1,1,-1,88283),-- [thons]
(21548,5549,1,1,-1,264849),-- [iron_thread]
(21548,57,1050,2127,0,700000),-- [adena]
(21548,11933,1,1,1,127.76335),-- [bellion_cestus_low]
(21548,4120,1,1,1,1709.23665),-- [bellion_cestus_edge]
(21548,1868,1,1,2,120357.597125),-- [thread]
(21548,1873,1,1,2,24071.519425),-- [silver_nugget]
(21548,5549,1,1,2,6017.81642),-- [iron_thread]
(21548,1889,1,1,2,4011.962195),-- [compound_braid]
(21548,4044,1,1,2,2005.854225),-- [thons]
(21548,5281,1,1,2,80.18342),-- [rp_adv_comp_bspiritshot_a]
(21548,6670,1,1,2,10029.778615),-- [key_of_treasure_box6]
(21548,5346,1,1,2,173.307835),-- [rp_sealed_tallum_tunic_i]
(21548,8729,1,1,2,802.34169),-- [general_64_a]
(21548,8739,1,1,2,200.712295),-- [special_64_a]
(21548,8749,1,1,2,20.045855),-- [rare_64_a]
(21548,8759,1,1,2,4.05992),-- [unique_64_a]
(21548,1343,10,30,2,85969.82098),-- [silver_arrow]
(21549,6329,1,1,-1,18422),-- [rp_sealed_phoenix's_necklace_i]
(21549,4053,1,1,-1,137396),-- [ring_of_black_ore_gemstone]
(21549,6331,1,1,-1,24469),-- [rp_sealed_phoenix's_earing_i]
(21549,57,1273,2574,0,700000),-- [adena]
(21549,12183,1,1,1,801.047862),-- [doom_shield_low]
(21549,4077,1,1,1,7098.820038),-- [doom_shield_fragment]
(21549,12202,1,1,1,560.59524),-- [blue_wolve's_helmet_low]
(21549,4088,1,1,1,5963.97081),-- [blue_wolve's_helmet_design]
(21549,12185,1,1,1,560.59524),-- [doom_helmet_low]
(21549,4089,1,1,1,5963.97081),-- [doom_helmet_pattern]
(21549,1864,1,3,2,86076.332076),-- [stem]
(21549,1865,1,1,2,86076.332076),-- [varnish]
(21549,1866,1,1,2,57384.221384),-- [suede]
(21549,1873,1,1,2,34430.35759),-- [silver_nugget]
(21549,1868,1,1,2,172152.664152),-- [thread]
(21549,3035,1,1,2,114.782462),-- [rp_spiritshot_a]
(21549,5354,1,1,2,396.481405),-- [rp_sealed_tallum_hose_i]
(21549,8729,1,1,2,1147.82462),-- [general_64_a]
(21549,8739,1,1,2,286.956155),-- [special_64_a]
(21549,8749,1,1,2,28.476565),-- [rare_64_a]
(21549,8759,1,1,2,6.571515),-- [unique_64_a]
(21550,6329,1,1,-1,18791),-- [rp_sealed_phoenix's_necklace_i]
(21550,4053,1,1,-1,140144),-- [ring_of_black_ore_gemstone]
(21550,6331,1,1,-1,24958),-- [rp_sealed_phoenix's_earing_i]
(21550,57,1298,2625,0,700000),-- [adena]
(21550,12183,1,1,1,817.069584),-- [doom_shield_low]
(21550,4077,1,1,1,7240.803216),-- [doom_shield_fragment]
(21550,12202,1,1,1,571.80768),-- [blue_wolve's_helmet_low]
(21550,4088,1,1,1,6083.25592),-- [blue_wolve's_helmet_design]
(21550,12185,1,1,1,571.80768),-- [doom_helmet_low]
(21550,4089,1,1,1,6083.25592),-- [doom_helmet_pattern]
(21550,1864,1,3,2,87797.854788),-- [stem]
(21550,1865,1,1,2,87797.854788),-- [varnish]
(21550,1866,1,1,2,58531.903192),-- [suede]
(21550,1873,1,1,2,35118.96317),-- [silver_nugget]
(21550,1868,1,1,2,175595.709576),-- [thread]
(21550,3035,1,1,2,117.078106),-- [rp_spiritshot_a]
(21550,5354,1,1,2,404.411015),-- [rp_sealed_tallum_hose_i]
(21550,8729,1,1,2,1170.78106),-- [general_64_a]
(21550,8739,1,1,2,292.695265),-- [special_64_a]
(21550,8749,1,1,2,29.046095),-- [rare_64_a]
(21550,8759,1,1,2,6.702945),-- [unique_64_a]
(21551,5460,1,1,-1,2017),-- [rp_dasparion's_staff_i]
(21551,4080,1,1,-1,75921),-- [blue_wolve's_gaiters_material]
(21551,1884,1,5,-1,757104),-- [cord]
(21551,57,1462,2965,0,700000),-- [adena]
(21551,12188,1,1,1,724.892676),-- [doom_boots_low]
(21551,4099,1,1,1,6118.107324),-- [doom_boots_part]
(21551,12189,1,1,1,724.892676),-- [blue_wolve's_boots_low]
(21551,4090,1,1,1,6118.107324),-- [blue_wolve's_boots_design]
(21551,12187,1,1,1,724.892676),-- [doom_gloves_low]
(21551,4091,1,1,1,6118.107324),-- [doom_gloves_part]
(21551,12190,1,1,1,724.892676),-- [blue_wolve's_gloves_low]
(21551,4096,1,1,1,6118.107324),-- [blue_wolve's_gloves_fabric]
(21551,1874,1,1,2,6607.441026),-- [oriharukon_ore]
(21551,1878,1,1,2,39644.123808),-- [braided_hemp]
(21551,1884,1,1,2,60990.919524),-- [cord]
(21551,1889,1,1,2,6607.441026),-- [compound_braid]
(21551,5220,1,1,2,3964.360146),-- [reinforcing_agent]
(21551,730,1,1,2,82.530984),-- [scrl_of_ench_am_a]
(21551,8729,1,1,2,1321.54044),-- [general_64_a]
(21551,8739,1,1,2,330.38511),-- [special_64_a]
(21551,8749,1,1,2,32.907924),-- [rare_64_a]
(21551,8759,1,1,2,6.52935),-- [unique_64_a]
(21551,1343,10,30,2,141585.820662),-- [silver_arrow]
(21552,5460,1,1,-1,1911),-- [rp_dasparion's_staff_i]
(21552,4080,1,1,-1,71939),-- [blue_wolve's_gaiters_material]
(21552,1884,1,5,-1,717399),-- [cord]
(21552,57,1385,2810,0,700000),-- [adena]
(21552,12188,1,1,1,686.863088),-- [doom_boots_low]
(21552,4099,1,1,1,5797.136912),-- [doom_boots_part]
(21552,12189,1,1,1,686.863088),-- [blue_wolve's_boots_low]
(21552,4090,1,1,1,5797.136912),-- [blue_wolve's_boots_design]
(21552,12187,1,1,1,686.863088),-- [doom_gloves_low]
(21552,4091,1,1,1,5797.136912),-- [doom_gloves_part]
(21552,12190,1,1,1,686.863088),-- [blue_wolve's_gloves_low]
(21552,4096,1,1,1,5797.136912),-- [blue_wolve's_gloves_fabric]
(21552,1874,1,1,2,6260.945922),-- [oriharukon_ore]
(21552,1878,1,1,2,37565.180576),-- [braided_hemp]
(21552,1884,1,1,2,57792.547428),-- [cord]
(21552,1889,1,1,2,6260.945922),-- [compound_braid]
(21552,5220,1,1,2,3756.468562),-- [reinforcing_agent]
(21552,730,1,1,2,78.203048),-- [scrl_of_ench_am_a]
(21552,8729,1,1,2,1252.23868),-- [general_64_a]
(21552,8739,1,1,2,313.05967),-- [special_64_a]
(21552,8749,1,1,2,31.182228),-- [rare_64_a]
(21552,8759,1,1,2,6.18695),-- [unique_64_a]
(21552,1343,10,30,2,134161.041014),-- [silver_arrow]
(21553,5346,1,1,-1,7455),-- [rp_sealed_tallum_tunic_i]
(21553,4080,1,1,-1,53208),-- [blue_wolve's_gaiters_material]
(21553,1895,1,1,-1,739065),-- [metallic_fiber]
(21553,57,1025,2078,0,700000),-- [adena]
(21553,12188,1,1,1,508.023389),-- [doom_boots_low]
(21553,4099,1,1,1,4287.726611),-- [doom_boots_part]
(21553,12189,1,1,1,508.023389),-- [blue_wolve's_boots_low]
(21553,4090,1,1,1,4287.726611),-- [blue_wolve's_boots_design]
(21553,12187,1,1,1,508.023389),-- [doom_gloves_low]
(21553,4091,1,1,1,4287.726611),-- [doom_gloves_part]
(21553,12190,1,1,1,508.023389),-- [blue_wolve's_gloves_low]
(21553,4096,1,1,1,4287.726611),-- [blue_wolve's_gloves_fabric]
(21553,1873,1,1,2,27784.737656),-- [silver_nugget]
(21553,1868,1,1,2,138923.282376),-- [thread]
(21553,1876,1,1,2,13892.267352),-- [mithril_ore]
(21553,1895,1,1,2,19846.270176),-- [metallic_fiber]
(21553,4042,1,1,2,1157.638208),-- [enria]
(21553,5462,1,1,2,25.774904),-- [rp_worldtree's_branch_i]
(21553,5348,1,1,2,136.789648),-- [rp_sealed_dark_crystal_robe_i]
(21553,8729,1,1,2,926.069976),-- [general_64_a]
(21553,8739,1,1,2,231.568232),-- [special_64_a]
(21553,8749,1,1,2,23.136528),-- [rare_64_a]
(21553,8759,1,1,2,4.464944),-- [unique_64_a]
(21554,5346,1,1,-1,7455),-- [rp_sealed_tallum_tunic_i]
(21554,4080,1,1,-1,53208),-- [blue_wolve's_gaiters_material]
(21554,1895,1,1,-1,739065),-- [metallic_fiber]
(21554,57,1025,2078,0,700000),-- [adena]
(21554,12188,1,1,1,508.023389),-- [doom_boots_low]
(21554,4099,1,1,1,4287.726611),-- [doom_boots_part]
(21554,12189,1,1,1,508.023389),-- [blue_wolve's_boots_low]
(21554,4090,1,1,1,4287.726611),-- [blue_wolve's_boots_design]
(21554,12187,1,1,1,508.023389),-- [doom_gloves_low]
(21554,4091,1,1,1,4287.726611),-- [doom_gloves_part]
(21554,12190,1,1,1,508.023389),-- [blue_wolve's_gloves_low]
(21554,4096,1,1,1,4287.726611),-- [blue_wolve's_gloves_fabric]
(21554,1873,1,1,2,27784.737656),-- [silver_nugget]
(21554,1868,1,1,2,138923.282376),-- [thread]
(21554,1876,1,1,2,13892.267352),-- [mithril_ore]
(21554,1895,1,1,2,19846.270176),-- [metallic_fiber]
(21554,4042,1,1,2,1157.638208),-- [enria]
(21554,5462,1,1,2,25.774904),-- [rp_worldtree's_branch_i]
(21554,5348,1,1,2,136.789648),-- [rp_sealed_dark_crystal_robe_i]
(21554,8729,1,1,2,926.069976),-- [general_64_a]
(21554,8739,1,1,2,231.568232),-- [special_64_a]
(21554,8749,1,1,2,23.136528),-- [rare_64_a]
(21554,8759,1,1,2,4.464944),-- [unique_64_a]
(21555,4082,1,1,-1,35533),-- [blue_wolve's_leather_mail_texture]
(21555,5354,1,1,-1,14491),-- [rp_sealed_tallum_hose_i]
(21555,4083,1,1,-1,35533),-- [leather_mail_of_doom_design]
(21555,57,1246,2527,0,700000),-- [adena]
(21555,11933,1,1,1,151.68855),-- [bellion_cestus_low]
(21555,4120,1,1,1,2029.31145),-- [bellion_cestus_edge]
(21555,1872,1,1,2,112591.8011),-- [animal_bone]
(21555,1867,1,1,2,112591.8011),-- [animal_skin]
(21555,1881,1,1,2,11259.228975),-- [coarse_bone_powder]
(21555,1875,1,1,2,5629.492325),-- [stone_of_purity]
(21555,4041,1,1,2,734.196625),-- [mold_hardener]
(21555,5466,1,1,2,31.2736),-- [rp_sword_of_miracle_i]
(21555,8300,1,1,2,46.177425),-- [rp_inferno_master_i]
(21555,8729,1,1,2,1125.8496),-- [general_64_a]
(21555,8739,1,1,2,281.4624),-- [special_64_a]
(21555,8749,1,1,2,28.097375),-- [rare_64_a]
(21555,8759,1,1,2,5.619475),-- [unique_64_a]
(21556,4082,1,1,-1,34673),-- [blue_wolve's_leather_mail_texture]
(21556,5354,1,1,-1,14141),-- [rp_sealed_tallum_hose_i]
(21556,4083,1,1,-1,34673),-- [leather_mail_of_doom_design]
(21556,57,1216,2466,0,700000),-- [adena]
(21556,11933,1,1,1,148.0024),-- [bellion_cestus_low]
(21556,4120,1,1,1,1979.9976),-- [bellion_cestus_edge]
(21556,1872,1,1,2,109867.846792),-- [animal_bone]
(21556,1867,1,1,2,109867.846792),-- [animal_skin]
(21556,1881,1,1,2,10986.832362),-- [coarse_bone_powder]
(21556,1875,1,1,2,5493.296974),-- [stone_of_purity]
(21556,4041,1,1,2,716.43407),-- [mold_hardener]
(21556,5466,1,1,2,30.516992),-- [rp_sword_of_miracle_i]
(21556,8300,1,1,2,45.060246),-- [rp_inferno_master_i]
(21556,8729,1,1,2,1098.611712),-- [general_64_a]
(21556,8739,1,1,2,274.652928),-- [special_64_a]
(21556,8749,1,1,2,27.41761),-- [rare_64_a]
(21556,8759,1,1,2,5.483522),-- [unique_64_a]
(21557,4082,1,1,-1,41024),-- [blue_wolve's_leather_mail_texture]
(21557,5470,1,1,-1,1984),-- [rp_tallum_blade_i]
(21557,4083,1,1,-1,41024),-- [leather_mail_of_doom_design]
(21557,57,1438,2917,0,700000),-- [adena]
(21557,12204,1,1,1,237.995628),-- [blue_wolve's_breastplate_low]
(21557,4078,1,1,1,2610.75087),-- [blue_wolve's_breastplate_part]
(21557,12184,1,1,1,146.497494),-- [doom_plate_armor_low]
(21557,4081,1,1,1,1761.601296),-- [doom_plate_armor_temper]
(21557,12193,1,1,1,380.685474),-- [blue_wolve's_gaiters_low]
(21557,4080,1,1,1,3676.469238),-- [blue_wolve's_gaiters_material]
(21557,1876,1,1,2,19498.52454),-- [mithril_ore]
(21557,1880,1,1,2,9749.26227),-- [steel]
(21557,1877,1,1,2,3899.704908),-- [admantite_nugget]
(21557,1881,1,1,2,12999.01636),-- [coarse_bone_powder]
(21557,1882,1,1,2,21664.888076),-- [leather]
(21557,5440,1,1,2,36.119978),-- [rp_elysian_i]
(21557,8729,1,1,2,1299.901636),-- [general_64_a]
(21557,8739,1,1,2,324.871016),-- [special_64_a]
(21557,8749,1,1,2,32.570616),-- [rare_64_a]
(21557,8759,1,1,2,6.472366),-- [unique_64_a]
(21557,1343,10,30,2,139274.668234),-- [silver_arrow]
(21558,4082,1,1,-1,41024),-- [blue_wolve's_leather_mail_texture]
(21558,5470,1,1,-1,1984),-- [rp_tallum_blade_i]
(21558,4083,1,1,-1,41024),-- [leather_mail_of_doom_design]
(21558,57,1438,2917,0,700000),-- [adena]
(21558,12204,1,1,1,237.995628),-- [blue_wolve's_breastplate_low]
(21558,4078,1,1,1,2610.75087),-- [blue_wolve's_breastplate_part]
(21558,12184,1,1,1,146.497494),-- [doom_plate_armor_low]
(21558,4081,1,1,1,1761.601296),-- [doom_plate_armor_temper]
(21558,12193,1,1,1,380.685474),-- [blue_wolve's_gaiters_low]
(21558,4080,1,1,1,3676.469238),-- [blue_wolve's_gaiters_material]
(21558,1876,1,1,2,19498.52454),-- [mithril_ore]
(21558,1880,1,1,2,9749.26227),-- [steel]
(21558,1877,1,1,2,3899.704908),-- [admantite_nugget]
(21558,1881,1,1,2,12999.01636),-- [coarse_bone_powder]
(21558,1882,1,1,2,21664.888076),-- [leather]
(21558,5440,1,1,2,36.119978),-- [rp_elysian_i]
(21558,8729,1,1,2,1299.901636),-- [general_64_a]
(21558,8739,1,1,2,324.871016),-- [special_64_a]
(21558,8749,1,1,2,32.570616),-- [rare_64_a]
(21558,8759,1,1,2,6.472366),-- [unique_64_a]
(21558,1343,10,30,2,139274.668234),-- [silver_arrow]
(21559,6329,1,1,-1,22819),-- [rp_sealed_phoenix's_necklace_i]
(21559,4085,1,1,-1,69006),-- [tunic_of_doom_pattern]
(21559,6331,1,1,-1,30310),-- [rp_sealed_phoenix's_earing_i]
(21559,57,1573,3190,0,700000),-- [adena]
(21559,12188,1,1,1,779.818418),-- [doom_boots_low]
(21559,4099,1,1,1,6581.681582),-- [doom_boots_part]
(21559,12189,1,1,1,779.818418),-- [blue_wolve's_boots_low]
(21559,4090,1,1,1,6581.681582),-- [blue_wolve's_boots_design]
(21559,12187,1,1,1,779.818418),-- [doom_gloves_low]
(21559,4091,1,1,1,6581.681582),-- [doom_gloves_part]
(21559,12190,1,1,1,779.818418),-- [blue_wolve's_gloves_low]
(21559,4096,1,1,1,6581.681582),-- [blue_wolve's_gloves_fabric]
(21559,1864,1,3,2,106622.530437),-- [stem]
(21559,1869,1,1,2,106622.530437),-- [iron_ore]
(21559,1878,1,1,2,42648.916327),-- [braided_hemp]
(21559,1884,1,1,2,65614.049207),-- [cord]
(21559,4039,1,1,2,3554.036424),-- [mold_glue]
(21559,5448,1,1,2,39.297598),-- [rp_soul_separator_i]
(21559,8729,1,1,2,1421.422874),-- [general_64_a]
(21559,8739,1,1,2,355.595338),-- [special_64_a]
(21559,8749,1,1,2,35.463686),-- [rare_64_a]
(21559,8759,1,1,2,7.188585),-- [unique_64_a]
(21559,1343,10,30,2,152317.969087),-- [silver_arrow]
(21560,4086,1,1,-1,93173),-- [blue_wolve's_hose_pattern]
(21560,4040,1,1,-1,79412),-- [mold_lubricant]
(21560,1875,1,1,-1,264705),-- [stone_of_purity]
(21560,57,1573,3190,0,700000),-- [adena]
(21560,12201,1,1,1,260.17494),-- [blue_wolve's_tunic_low]
(21560,4084,1,1,1,2547.97618),-- [blue_wolve's_tunic_fabric]
(21560,12192,1,1,1,260.17494),-- [tunic_of_doom_low]
(21560,4085,1,1,1,2547.97618),-- [tunic_of_doom_pattern]
(21560,12203,1,1,1,416.50918),-- [blue_wolve's_hose_low]
(21560,4086,1,1,1,3440.3397),-- [blue_wolve's_hose_pattern]
(21560,12205,1,1,1,416.50918),-- [hose_of_doom_low]
(21560,4087,1,1,1,3440.3397),-- [hose_of_doom_pattern]
(21560,1865,1,1,2,117284.817933),-- [varnish]
(21560,1870,1,1,2,117284.817933),-- [coal]
(21560,1879,1,1,2,19547.602819),-- [cokes]
(21560,1875,1,1,2,7819.094393),-- [stone_of_purity]
(21560,4040,1,1,2,2345.808216),-- [mold_lubricant]
(21560,5450,1,1,2,43.411301),-- [rp_dragon_grinder_i]
(21560,8729,1,1,2,1563.872144),-- [general_64_a]
(21560,8739,1,1,2,390.968036),-- [special_64_a]
(21560,8749,1,1,2,39.150069),-- [rare_64_a]
(21560,8759,1,1,2,7.457156),-- [unique_64_a]
(21561,4116,1,1,-1,14604),-- [deadman's_glory_stone]
(21561,3956,1,1,-1,4456),-- [rp_blessed_spiritshot_a]
(21561,4117,1,1,-1,14604),-- [art_of_battle_axe_blade]
(21561,57,1318,2693,0,700000),-- [adena]
(21561,12204,1,1,1,219.094228),-- [blue_wolve's_breastplate_low]
(21561,4078,1,1,1,2403.40737),-- [blue_wolve's_breastplate_part]
(21561,12184,1,1,1,134.862794),-- [doom_plate_armor_low]
(21561,4081,1,1,1,1621.696496),-- [doom_plate_armor_temper]
(21561,12193,1,1,1,350.451774),-- [blue_wolve's_gaiters_low]
(21561,4080,1,1,1,3384.487338),-- [blue_wolve's_gaiters_material]
(21561,1865,1,1,2,82265.67213),-- [varnish]
(21561,1870,1,1,2,82265.67213),-- [coal]
(21561,1879,1,1,2,13711.104258),-- [cokes]
(21561,1875,1,1,2,5484.378142),-- [stone_of_purity]
(21561,4040,1,1,2,1645.281662),-- [mold_lubricant]
(21561,5456,1,1,2,30.509376),-- [rp_tallum_glaive_i]
(21561,6670,1,1,2,13711.104258),-- [key_of_treasure_box6]
(21561,8730,1,1,2,914.010056),-- [general_67_a]
(21561,8740,1,1,2,228.502514),-- [special_67_a]
(21561,8750,1,1,2,22.882032),-- [rare_67_a]
(21561,8760,1,1,2,4.449284),-- [unique_67_a]
(21561,1343,10,30,2,117522.434158),-- [silver_arrow]
(21562,5156,1,1,-1,4614),-- [rp_comp_soulshot_a]
(21562,4118,1,1,-1,14328),-- [staff_of_evil_sprit_head]
(21562,5220,1,1,-1,138433),-- [reinforcing_agent]
(21562,57,1364,2788,0,700000),-- [adena]
(21562,12201,1,1,1,226.760124),-- [blue_wolve's_tunic_low]
(21562,4084,1,1,1,2220.734228),-- [blue_wolve's_tunic_fabric]
(21562,12192,1,1,1,226.760124),-- [tunic_of_doom_low]
(21562,4085,1,1,1,2220.734228),-- [tunic_of_doom_pattern]
(21562,12203,1,1,1,363.016028),-- [blue_wolve's_hose_low]
(21562,4086,1,1,1,2998.48962),-- [blue_wolve's_hose_pattern]
(21562,12205,1,1,1,363.016028),-- [hose_of_doom_low]
(21562,4087,1,1,1,2998.48962),-- [hose_of_doom_pattern]
(21562,1866,1,1,2,68151.289752),-- [suede]
(21562,1871,1,1,2,102226.934628),-- [charcoal]
(21562,5220,1,1,2,4089.010653),-- [reinforcing_agent]
(21562,1885,1,1,2,8518.911219),-- [high_grade_suede]
(21562,4041,1,1,2,889.020132),-- [mold_hardener]
(21562,5462,1,1,2,37.814868),-- [rp_worldtree's_branch_i]
(21562,8730,1,1,2,1135.928976),-- [general_67_a]
(21562,8740,1,1,2,283.982244),-- [special_67_a]
(21562,8750,1,1,2,28.361151),-- [rare_67_a]
(21562,8760,1,1,2,5.746377),-- [unique_67_a]
(21563,4042,1,1,-1,67020),-- [enria]
(21563,4119,1,1,-1,17601),-- [demon's_sword_edge]
(21563,5161,1,1,-1,5362),-- [rp_comp_spiritshot_a]
(21563,57,1585,3240,0,700000),-- [adena]
(21563,12204,1,1,1,263.593524),-- [blue_wolve's_breastplate_low]
(21563,4078,1,1,1,2891.55321),-- [blue_wolve's_breastplate_part]
(21563,12184,1,1,1,162.254202),-- [doom_plate_armor_low]
(21563,4081,1,1,1,1951.072368),-- [doom_plate_armor_temper]
(21563,12193,1,1,1,421.630542),-- [blue_wolve's_gaiters_low]
(21563,4080,1,1,1,4071.896154),-- [blue_wolve's_gaiters_material]
(21563,1867,1,1,2,143975.18135),-- [animal_skin]
(21563,1872,1,1,2,143975.18135),-- [animal_bone]
(21563,1882,1,1,2,23996.021348),-- [leather]
(21563,1894,1,1,2,3788.845476),-- [crafted_leather]
(21563,4042,1,1,2,1799.748938),-- [enria]
(21563,5464,1,1,2,39.762996),-- [rp_dark_legion's_edge_i]
(21563,8730,1,1,2,1199.990415),-- [general_67_a]
(21563,8740,1,1,2,300.115946),-- [special_67_a]
(21563,8750,1,1,2,29.822247),-- [rare_67_a]
(21563,8760,1,1,2,6.153797),-- [unique_67_a]
(21563,1343,10,30,2,154258.176137),-- [silver_arrow]
(21564,4120,1,1,-1,16716),-- [bellion_cestus_edge]
(21564,5166,1,1,-1,5101),-- [rp_comp_bspiritshot_a]
(21564,4121,1,1,-1,16660),-- [hazard_bow_shaft]
(21564,57,1508,3082,0,700000),-- [adena]
(21564,12194,1,1,1,308.716096),-- [blue_wolve's_leather_mail_low]
(21564,4082,1,1,1,3191.783904),-- [blue_wolve's_leather_mail_texture]
(21564,12186,1,1,1,308.716096),-- [leather_mail_of_doom_low]
(21564,4083,1,1,1,3191.783904),-- [leather_mail_of_doom_design]
(21564,1868,1,1,2,225993.28272),-- [thread]
(21564,1873,1,1,2,45198.77472),-- [silver_nugget]
(21564,5549,1,1,2,11299.69368),-- [iron_thread]
(21564,1889,1,1,2,7533.12912),-- [compound_braid]
(21564,4044,1,1,2,3766.56456),-- [thons]
(21564,5466,1,1,2,41.95248),-- [rp_sword_of_miracle_i]
(21564,8730,1,1,2,1255.62),-- [general_67_a]
(21564,8740,1,1,2,313.75728),-- [special_67_a]
(21564,8750,1,1,2,31.31664),-- [rare_67_a]
(21564,8760,1,1,2,5.9088),-- [unique_67_a]
(21565,5520,1,1,-1,24990),-- [sealed_dark_crystal_breastplate_pattern]
(21565,5464,1,1,-1,1435),-- [rp_dark_legion's_edge_i]
(21565,5521,1,1,-1,17634),-- [sealed_tallum_plate_armor_pattern]
(21565,57,1533,3116,0,700000),-- [adena]
(21565,11960,1,1,1,157.589712),-- [halbard_low]
(21565,5542,1,1,1,1930.410288),-- [halbard_edge]
(21565,1867,1,1,2,152625.960268),-- [animal_skin]
(21565,1872,1,1,2,152625.960268),-- [animal_bone]
(21565,1882,1,1,2,25437.603664),-- [leather]
(21565,1894,1,1,2,4016.445932),-- [crafted_leather]
(21565,4042,1,1,2,1907.92176),-- [enria]
(21565,5464,1,1,2,42.2855),-- [rp_dark_legion's_edge_i]
(21565,8730,1,1,2,1271.94784),-- [general_67_a]
(21565,8740,1,1,2,317.98696),-- [special_67_a]
(21565,8750,1,1,2,31.798696),-- [rare_67_a]
(21565,8760,1,1,2,6.089112),-- [unique_67_a]
(21566,729,1,1,-1,471),-- [scrl_of_ench_wp_a]
(21566,4044,1,1,-1,141272),-- [thons]
(21566,5549,1,1,-1,423817),-- [iron_thread]
(21566,57,1676,3408,0,700000),-- [adena]
(21566,11955,1,1,1,172.310664),-- [carnium_bow_low]
(21566,5535,1,1,1,2135.689336),-- [carnium_bow_shaft]
(21566,1868,1,1,2,227616.740652),-- [thread]
(21566,1873,1,1,2,45523.164072),-- [silver_nugget]
(21566,5549,1,1,2,11380.791018),-- [iron_thread]
(21566,1889,1,1,2,7587.347394),-- [compound_braid]
(21566,4044,1,1,2,3793.443624),-- [thons]
(21566,5466,1,1,2,42.333432),-- [rp_sword_of_miracle_i]
(21566,8730,1,1,2,1264.481208),-- [general_67_a]
(21566,8740,1,1,2,316.120302),-- [special_67_a]
(21566,8750,1,1,2,31.750074),-- [rare_67_a]
(21566,8760,1,1,2,6.442044),-- [unique_67_a]
(21566,1343,10,30,2,162583.38618),-- [silver_arrow]
(21567,5524,1,1,-1,49929),-- [sealed_dark_crystal_gaiters_pattern]
(21567,5466,1,1,-1,1876),-- [rp_sword_of_miracle_i]
(21567,5525,1,1,-1,78309),-- [sealed_dark_crystal_helmet_design]
(21567,57,2004,4074,0,700000),-- [adena]
(21567,11951,1,1,1,205.934358),-- [bloody_orchid_low]
(21567,5536,1,1,1,2545.065642),-- [bloody_orchid_head]
(21567,1869,1,1,2,149636.751902),-- [iron_ore]
(21567,1864,1,1,2,299273.503804),-- [stem]
(21567,1880,1,1,2,14963.580478),-- [steel]
(21567,5550,1,1,2,1995.112493),-- [reinforcing_plate]
(21567,4043,1,1,2,4988.018013),-- [asofe]
(21567,6335,1,1,2,575.376615),-- [rp_sealed_majestic_necklace_i]
(21567,8730,1,1,2,1662.672671),-- [general_67_a]
(21567,8740,1,1,2,415.786558),-- [special_67_a]
(21567,8750,1,1,2,41.673368),-- [rare_67_a]
(21567,8760,1,1,2,8.524098),-- [unique_67_a]
(21568,6335,1,1,-1,15379),-- [rp_sealed_majestic_necklace_i]
(21568,5526,1,1,-1,61809),-- [sealed_tallum_bonnet_design]
(21568,730,1,1,-1,3332),-- [scrl_of_ench_am_a]
(21568,57,1582,3215,0,700000),-- [adena]
(21568,11951,1,1,1,162.591576),-- [bloody_orchid_low]
(21568,5536,1,1,1,2009.408424),-- [bloody_orchid_head]
(21568,1870,1,1,2,107370.567872),-- [coal]
(21568,1865,1,1,2,107370.567872),-- [varnish]
(21568,1874,1,1,2,7157.858415),-- [oriharukon_ore]
(21568,4043,1,1,2,3579.121468),-- [asofe]
(21568,4039,1,1,2,3579.121468),-- [mold_glue]
(21568,6337,1,1,2,550.634072),-- [rp_sealed_majestic_earing_i]
(21568,8730,1,1,2,1193.168663),-- [general_67_a]
(21568,8740,1,1,2,298.388296),-- [special_67_a]
(21568,8750,1,1,2,29.992638),-- [rare_67_a]
(21568,8760,1,1,2,6.152336),-- [unique_67_a]
(21568,1343,10,30,2,153385.4269),-- [silver_arrow]
(21569,6335,1,1,-1,11646),-- [rp_sealed_majestic_necklace_i]
(21569,5526,1,1,-1,46809),-- [sealed_tallum_bonnet_design]
(21569,730,1,1,-1,2523),-- [scrl_of_ench_am_a]
(21569,57,1198,2435,0,700000),-- [adena]
(21569,11951,1,1,1,123.14141),-- [bloody_orchid_low]
(21569,5536,1,1,1,1521.85859),-- [bloody_orchid_head]
(21569,1870,1,1,2,81313.475328),-- [coal]
(21569,1865,1,1,2,81313.475328),-- [varnish]
(21569,1874,1,1,2,5420.76246),-- [oriharukon_ore]
(21569,4043,1,1,2,2710.526832),-- [asofe]
(21569,4039,1,1,2,2710.526832),-- [mold_glue]
(21569,6337,1,1,2,417.004128),-- [rp_sealed_majestic_earing_i]
(21569,8730,1,1,2,903.606012),-- [general_67_a]
(21569,8740,1,1,2,225.974304),-- [special_67_a]
(21569,8750,1,1,2,22.713912),-- [rare_67_a]
(21569,8760,1,1,2,4.659264),-- [unique_67_a]
(21569,1343,10,30,2,116161.2756),-- [silver_arrow]
(21570,5542,1,1,-1,10630),-- [halbard_edge]
(21570,5464,1,1,-1,1167),-- [rp_dark_legion's_edge_i]
(21570,5543,1,1,-1,10730),-- [dasparion's_staff_head]
(21570,57,1248,2533,0,700000),-- [adena]
(21570,11950,1,1,1,128.154852),-- [blood_tornado_low]
(21570,5539,1,1,1,1569.845148),-- [blood_tornado_edge]
(21570,1872,1,1,2,124147.312934),-- [animal_bone]
(21570,1867,1,1,2,124147.312934),-- [animal_skin]
(21570,1881,1,1,2,12414.67734),-- [coarse_bone_powder]
(21570,1875,1,1,2,6207.33867),-- [stone_of_purity]
(21570,4041,1,1,2,809.570767),-- [mold_hardener]
(21570,6339,1,1,2,716.231385),-- [rp_sealed_majestic_ring_i]
(21570,8730,1,1,2,1034.556445),-- [general_67_a]
(21570,8740,1,1,2,258.706553),-- [special_67_a]
(21570,8750,1,1,2,25.897632),-- [rare_67_a]
(21570,8760,1,1,2,5.39534),-- [unique_67_a]
(21571,729,1,1,-1,461),-- [scrl_of_ench_wp_a]
(21571,4042,1,1,-1,69170),-- [enria]
(21571,4043,1,1,-1,138340),-- [asofe]
(21571,57,1643,3335,0,700000),-- [adena]
(21571,11955,1,1,1,168.72708),-- [carnium_bow_low]
(21571,5535,1,1,1,2091.27292),-- [carnium_bow_shaft]
(21571,1895,1,1,2,31841.79004),-- [metallic_fiber]
(21571,4040,1,1,2,2228.86916),-- [mold_lubricant]
(21571,4042,1,1,2,1857.52464),-- [enria]
(21571,4043,1,1,2,3714.84877),-- [asofe]
(21571,729,1,1,2,12.43162),-- [scrl_of_ench_wp_a]
(21571,8487,1,1,2,60.95504),-- [rp_hammer_of_destroyer_i]
(21571,8730,1,1,2,1238.34976),-- [general_67_a]
(21571,8740,1,1,2,309.58744),-- [special_67_a]
(21571,8750,1,1,2,30.87854),-- [rare_67_a]
(21571,8760,1,1,2,6.21581),-- [unique_67_a]
(21571,1343,10,30,2,159208.54918),-- [silver_arrow]
(21572,5547,1,1,-1,14592),-- [elemental_sword_edge]
(21572,5466,1,1,-1,1589),-- [rp_sword_of_miracle_i]
(21572,5548,1,1,-1,14592),-- [tallum_blade_edge]
(21572,57,1698,3447,0,700000),-- [adena]
(21572,11951,1,1,1,174.41914),-- [bloody_orchid_low]
(21572,5536,1,1,1,2155.58086),-- [bloody_orchid_head]
(21572,1868,1,1,2,230344.648344),-- [thread]
(21572,1873,1,1,2,46068.989935),-- [silver_nugget]
(21572,5549,1,1,2,11517.172151),-- [iron_thread]
(21572,1889,1,1,2,7678.215211),-- [compound_braid]
(21572,4044,1,1,2,3838.95694),-- [thons]
(21572,730,1,1,2,96.124589),-- [scrl_of_ench_am_a]
(21572,5352,1,1,2,148.857514),-- [rp_sealed_majestic_robe_i]
(21572,8730,1,1,2,1279.752757),-- [general_67_a]
(21572,8740,1,1,2,320.013522),-- [special_67_a]
(21572,8750,1,1,2,31.941086),-- [rare_67_a]
(21572,8760,1,1,2,6.327951),-- [unique_67_a]
(21573,6335,1,1,-1,17007),-- [rp_sealed_majestic_necklace_i]
(21573,6341,1,1,-1,122303),-- [sealed_phoenix's_earing_gemstone]
(21573,730,1,1,-1,3685),-- [scrl_of_ench_am_a]
(21573,57,1750,3554,0,700000),-- [adena]
(21573,12225,1,1,1,903.270963),-- [sealed_dark_crystal_shield_low]
(21573,5494,1,1,1,4571.868806),-- [sealed_dark_crystal_shield_fragment]
(21573,12226,1,1,1,632.813696),-- [sealed_dark_crystal_helmet_low]
(21573,5525,1,1,1,3365.109684),-- [sealed_dark_crystal_helmet_design]
(21573,12234,1,1,1,632.813696),-- [sealed_tallum_bonnet_low]
(21573,5526,1,1,1,3365.123155),-- [sealed_tallum_bonnet_design]
(21573,1873,1,1,2,47496.60231),-- [silver_nugget]
(21573,1868,1,3,2,118741.505775),-- [thread]
(21573,1876,1,1,2,23748.301155),-- [mithril_ore]
(21573,1895,1,1,2,33925.974255),-- [metallic_fiber]
(21573,4042,1,1,2,1979.12441),-- [enria]
(21573,5434,1,1,2,44.095305),-- [rp_dragon_slayer_i]
(21573,8730,1,1,2,1319.283855),-- [general_67_a]
(21573,8740,1,1,2,329.72165),-- [special_67_a]
(21573,8750,1,1,2,32.972165),-- [rare_67_a]
(21573,8760,1,1,2,6.753335),-- [unique_67_a]
(21573,1343,10,30,2,169630.665785),-- [silver_arrow]
(21574,5448,1,1,-1,2000),-- [rp_soul_separator_i]
(21574,5494,1,1,-1,113405),-- [sealed_dark_crystal_shield_fragment]
(21574,729,1,1,-1,600),-- [scrl_of_ench_wp_a]
(21574,57,2136,4345,0,700000),-- [adena]
(21574,11960,1,1,1,219.553866),-- [halbard_low]
(21574,5542,1,1,1,2689.446134),-- [halbard_edge]
(21574,1868,1,3,2,199376.20096),-- [thread]
(21574,1873,1,1,2,79750.480384),-- [silver_nugget]
(21574,5549,1,1,2,19937.620096),-- [iron_thread]
(21574,1889,1,1,2,13291.885002),-- [compound_braid]
(21574,4044,1,1,2,6645.735094),-- [thons]
(21574,5466,1,1,2,73.836892),-- [rp_sword_of_miracle_i]
(21574,10305,1,1,2,797.687322),-- [sb_transform_oel_mahum]
(21574,1343,30,90,2,94940.55425),-- [silver_arrow]
(21575,5448,1,1,-1,1127),-- [rp_soul_separator_i]
(21575,5494,1,1,-1,63890),-- [sealed_dark_crystal_shield_fragment]
(21575,729,1,1,-1,338),-- [scrl_of_ench_wp_a]
(21575,57,1203,2448,0,700000),-- [adena]
(21575,11960,1,1,1,123.701886),-- [halbard_low]
(21575,5542,1,1,1,1515.298114),-- [halbard_edge]
(21575,1868,1,1,2,224648.956168),-- [thread]
(21575,1873,1,1,2,44929.700634),-- [silver_nugget]
(21575,5549,1,1,2,11232.538408),-- [iron_thread]
(21575,1889,1,1,2,7488.509938),-- [compound_braid]
(21575,4044,1,1,2,3744.02847),-- [thons]
(21575,5466,1,1,2,41.675816),-- [rp_sword_of_miracle_i]
(21575,10305,1,1,2,449.374016),-- [sb_transform_oel_mahum]
(21575,1343,10,30,2,160463.21655),-- [silver_arrow]
(21576,5450,1,1,-1,1316),-- [rp_dragon_grinder_i]
(21576,5497,1,1,-1,83285),-- [sealed_tallum_boots_lining]
(21576,5456,1,1,-1,1316),-- [rp_tallum_glaive_i]
(21576,57,1405,2858,0,700000),-- [adena]
(21576,11951,1,1,1,144.401082),-- [bloody_orchid_low]
(21576,5536,1,1,1,1784.598918),-- [bloody_orchid_head]
(21576,1873,1,1,2,38154.28234),-- [silver_nugget]
(21576,1868,1,1,2,190770.58179),-- [thread]
(21576,1876,1,1,2,19077.14117),-- [mithril_ore]
(21576,1895,1,1,2,27252.999535),-- [metallic_fiber]
(21576,4042,1,1,2,1589.692605),-- [enria]
(21576,6337,1,1,2,489.231945),-- [rp_sealed_majestic_earing_i]
(21576,8730,1,1,2,1059.79507),-- [general_67_a]
(21576,8740,1,1,2,265.156245),-- [special_67_a]
(21576,8750,1,1,2,26.55712),-- [rare_67_a]
(21576,8760,1,1,2,5.394415),-- [unique_67_a]
(21576,1343,10,30,2,136264.167765),-- [silver_arrow]
(21577,5450,1,1,-1,1270),-- [rp_dragon_grinder_i]
(21577,5497,1,1,-1,80418),-- [sealed_tallum_boots_lining]
(21577,5456,1,1,-1,1270),-- [rp_tallum_glaive_i]
(21577,57,1356,2760,0,700000),-- [adena]
(21577,11951,1,1,1,139.460454),-- [bloody_orchid_low]
(21577,5536,1,1,1,1723.539546),-- [bloody_orchid_head]
(21577,1873,1,1,2,36840.80516),-- [silver_nugget]
(21577,1868,1,1,2,184203.22446),-- [thread]
(21577,1876,1,1,2,18420.40258),-- [mithril_ore]
(21577,1895,1,1,2,26314.80359),-- [metallic_fiber]
(21577,4042,1,1,2,1534.96677),-- [enria]
(21577,6337,1,1,2,472.38993),-- [rp_sealed_majestic_earing_i]
(21577,8730,1,1,2,1023.31118),-- [general_67_a]
(21577,8740,1,1,2,256.02813),-- [special_67_a]
(21577,8750,1,1,2,25.64288),-- [rare_67_a]
(21577,8760,1,1,2,5.20871),-- [unique_67_a]
(21577,1343,10,30,2,131573.21661),-- [silver_arrow]
(21578,5482,1,1,-1,42487),-- [sealed_legging_of_dark_crystal_design]
(21578,5464,1,1,-1,1192),-- [rp_dark_legion's_edge_i]
(21578,5485,1,1,-1,27069),-- [sealed_tallum_tunic_texture]
(21578,57,1588,3238,0,700000),-- [adena]
(21578,11950,1,1,1,163.627632),-- [blood_tornado_low]
(21578,5539,1,1,1,2004.372368),-- [blood_tornado_edge]
(21578,1871,1,1,2,108051.58614),-- [charcoal]
(21578,1866,1,1,2,72034.39076),-- [suede]
(21578,1877,1,1,2,4321.998614),-- [admantite_nugget]
(21578,4041,1,1,2,939.734042),-- [mold_hardener]
(21578,4040,1,1,2,2161.161386),-- [mold_lubricant]
(21578,5277,1,1,2,47.975384),-- [rp_adv_comp_spiritshot_s]
(21578,8730,1,1,2,1200.681232),-- [general_67_a]
(21578,8740,1,1,2,300.170308),-- [special_67_a]
(21578,8750,1,1,2,30.146694),-- [rare_67_a]
(21578,8760,1,1,2,6.159002),-- [unique_67_a]
(21578,1344,10,30,2,135063.996438),-- [mithril_arrow]
(21579,729,1,1,-1,374),-- [scrl_of_ench_wp_a]
(21579,4042,1,1,-1,56029),-- [enria]
(21579,1876,1,1,-1,672353),-- [mithril_ore]
(21579,57,1659,3381,0,700000),-- [adena]
(21579,11955,1,1,1,170.892162),-- [carnium_bow_low]
(21579,5535,1,1,1,2118.107838),-- [carnium_bow_shaft]
(21579,1873,1,1,2,49650.7685),-- [silver_nugget]
(21579,1868,1,1,2,248253.8425),-- [thread]
(21579,1876,1,1,2,24825.203208),-- [mithril_ore]
(21579,1895,1,1,2,35464.679464),-- [metallic_fiber]
(21579,4042,1,1,2,2068.947976),-- [enria]
(21579,5282,1,1,2,55.036768),-- [rp_adv_comp_bspiritshot_s]
(21579,8730,1,1,2,1379.177956),-- [general_67_a]
(21579,8740,1,1,2,344.703968),-- [special_67_a]
(21579,8750,1,1,2,34.39798),-- [rare_67_a]
(21579,8760,1,1,2,7.24168),-- [unique_67_a]
(21580,5486,1,1,-1,20169),-- [sealed_dark_crystal_robe_fabric]
(21580,5466,1,1,-1,1262),-- [rp_sword_of_miracle_i]
(21580,5489,1,1,-1,44988),-- [sealed_tallum_hose_fabric]
(21580,57,1682,3428,0,700000),-- [adena]
(21580,11951,1,1,1,173.221412),-- [bloody_orchid_low]
(21580,5536,1,1,1,2140.778588),-- [bloody_orchid_head]
(21580,1873,1,1,2,45765.053124),-- [silver_nugget]
(21580,1868,1,1,2,228825.742384),-- [thread]
(21580,1876,1,1,2,22882.764944),-- [mithril_ore]
(21580,1895,1,1,2,32689.32366),-- [metallic_fiber]
(21580,4042,1,1,2,1907.056),-- [enria]
(21580,5282,1,1,2,51.013748),-- [rp_adv_comp_bspiritshot_s]
(21580,8730,1,1,2,1271.052824),-- [general_67_a]
(21580,8740,1,1,2,318.001588),-- [special_67_a]
(21580,8750,1,1,2,31.943188),-- [rare_67_a]
(21580,8760,1,1,2,6.197932),-- [unique_67_a]
(21580,1344,10,30,2,143015.850608),-- [mithril_arrow]
(21581,6335,1,1,-1,14337),-- [rp_sealed_majestic_necklace_i]
(21581,5494,1,1,-1,78289),-- [sealed_dark_crystal_shield_fragment]
(21581,730,1,1,-1,3106),-- [scrl_of_ench_am_a]
(21581,57,1839,3749,0,700000),-- [adena]
(21581,11950,1,1,1,189.43974),-- [blood_tornado_low]
(21581,5539,1,1,1,2320.56026),-- [blood_tornado_edge]
(21581,1865,1,1,2,137639.296222),-- [varnish]
(21581,1870,1,1,2,137639.296222),-- [coal]
(21581,1879,1,1,2,22939.830676),-- [cokes]
(21581,1875,1,1,2,9175.807404),-- [stone_of_purity]
(21581,4040,1,1,2,2752.679788),-- [