/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.StringUtil;
import com.l2jserver.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Announcements {
    private static Logger _log = Logger.getLogger(Announcements.class.getName());
    private final List<String> _announcements = new FastList();
    private final List<String> _critAnnouncements = new FastList();
    private final List<EventAnnounce> _eventAnnouncements = new FastList();

    protected Announcements() {
        this.loadAnnouncements();
    }

    public static Announcements getInstance() {
        return SingletonHolder._instance;
    }

    public void loadAnnouncements() {
        this._announcements.clear();
        this._critAnnouncements.clear();
        this.readFromDisk("data/announcements.txt", this._announcements);
        this.readFromDisk("data/critannouncements.txt", this._critAnnouncements);
        if (Config.DEBUG) {
            _log.info("Announcements: Loaded " + (this._announcements.size() + this._critAnnouncements.size()) + " announcements.");
        }
    }

    public void showAnnouncements(L2PcInstance activeChar) {
        CreatureSay cs;
        for (String announce : this._announcements) {
            if (announce.indexOf(37) >= 0) {
                announce = announce.replaceFirst("%server_name%", LoginServerThread.getInstance().getServerName());
            }
            cs = new CreatureSay(0, 10, activeChar.getName(), announce);
            activeChar.sendPacket(cs);
        }
        for (String critAnnounce : this._critAnnouncements) {
            cs = new CreatureSay(0, 18, activeChar.getName(), critAnnounce);
            activeChar.sendPacket(cs);
        }
        Date currentDate = new Date();
        for (EventAnnounce eventAnnounce : this._eventAnnouncements) {
            DateRange validDateRange = eventAnnounce.validDateRange;
            String[] messages = eventAnnounce.messages;
            if (!validDateRange.isValid() || !validDateRange.isWithinRange(currentDate)) continue;
            for (String s : messages) {
                activeChar.sendMessage(s);
            }
        }
    }

    public void addEventAnnouncement(DateRange validDateRange, String ... msg) {
        this._eventAnnouncements.add(new EventAnnounce(validDateRange, msg));
    }

    public void listAnnouncements(L2PcInstance activeChar) {
        String content = HtmCache.getInstance().getHtmForce(activeChar.getHtmlPrefix(), "data/html/admin/announce.htm");
        NpcHtmlMessage adminReply = new NpcHtmlMessage();
        adminReply.setHtml(content);
        StringBuilder replyMSG = StringUtil.startAppend(500, "<br>");
        for (int i = 0; i < this._announcements.size(); ++i) {
            String line = String.valueOf(i);
            StringUtil.append(replyMSG, "<table width=275 border=0 cellspacing=0 cellpadding=0 bgcolor=", i % 2 == 0 ? "333333" : "444444", "><tr><td VALIGN=TOP fixwidth=14><button action=\"bypass -h admin_del_announcement ", line, " -1 \" width=14 height=14 back=L2UI_CH3.Shortcut_Nextv_Down fore=L2UI_CH3.Shortcut_Nextv></td><td VALIGN=TOP fixwidth=14><button action=\"bypass -h admin_del_announcement ", line, " +1 \" width=14 height=14 back=L2UI_CH3.Shortcut_Prevv_Down fore=L2UI_CH3.Shortcut_Prevv></td><td VALIGN=TOP fixwidth=230>", this._announcements.get(i), "</td><td VALIGN=TOP fixwidth=12><button action=\"bypass -h admin_del_announcement ", line, "\" width=12 height=12 back=L2UI.bbs_delete_Down fore=L2UI.bbs_delete></td></tr></table>");
        }
        adminReply.replace((CharSequence)"%announces%", replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void listCritAnnouncements(L2PcInstance activeChar) {
        String content = HtmCache.getInstance().getHtmForce(activeChar.getHtmlPrefix(), "data/html/admin/critannounce.htm");
        NpcHtmlMessage adminReply = new NpcHtmlMessage();
        adminReply.setHtml(content);
        StringBuilder replyMSG = StringUtil.startAppend(500, "<br>");
        for (int i = 0; i < this._critAnnouncements.size(); ++i) {
            String line = String.valueOf(i);
            StringUtil.append(replyMSG, "<table width=275 border=0 cellspacing=0 cellpadding=0 bgcolor=", i % 2 == 0 ? "333333" : "444444", "><tr><td VALIGN=TOP fixwidth=14><button action=\"bypass -h admin_del_critannouncement ", line, " -1 \" width=14 height=14 back=L2UI_CH3.Shortcut_Nextv_Down fore=L2UI_CH3.Shortcut_Nextv></td><td VALIGN=TOP fixwidth=14><button action=\"bypass -h admin_del_critannouncement ", line, " +1 \" width=14 height=14 back=L2UI_CH3.Shortcut_Prevv_Down fore=L2UI_CH3.Shortcut_Prevv></td><td VALIGN=TOP fixwidth=230>", this._critAnnouncements.get(i), "</td><td VALIGN=TOP fixwidth=12><button action=\"bypass -h admin_del_critannouncement ", line, "\" width=12 height=12 back=L2UI.bbs_delete_Down fore=L2UI.bbs_delete></td></tr></table>");
        }
        adminReply.replace((CharSequence)"%critannounces%", replyMSG.toString());
        activeChar.sendPacket(adminReply);
    }

    public void addAnnouncement(String text) {
        this._announcements.add(text);
        this.saveToDisk(false);
    }

    public void delAnnouncement(int line, int updown) {
        this.moveLine(line, updown, false);
    }

    public void addCritAnnouncement(String text) {
        this._critAnnouncements.add(text);
        this.saveToDisk(true);
    }

    public void delCritAnnouncement(int line, int updown) {
        this.moveLine(line, updown, true);
    }

    private void moveLine(int line, int updown, boolean isCritical) {
        List<String> list;
        List<String> list2 = list = isCritical ? this._critAnnouncements : this._announcements;
        if (updown == 0) {
            list.remove(line);
        } else {
            int to = line + updown;
            if (to >= 0 && to < list.size()) {
                list.add(to, list.remove(line));
            } else {
                return;
            }
        }
        this.saveToDisk(isCritical);
    }

    private void readFromDisk(String path, List<String> list) {
        File file = new File(Config.DATAPACK_ROOT, path);
        try (BufferedReader lnr = Util.utf8BufferedReader(file);){
            String line;
            while ((line = lnr.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e1) {
            _log.log(Level.SEVERE, "Error reading announcements: ", e1);
        }
    }

    private void saveToDisk(boolean isCritical) {
        List<String> list;
        String path;
        if (isCritical) {
            path = "data/critannouncements.txt";
            list = this._critAnnouncements;
        } else {
            path = "data/announcements.txt";
            list = this._announcements;
        }
        String FILE_EOL = this.detectEOL(path);
        try (BufferedWriter save = Util.utf8BufferedWriter(path);){
            for (String announce : list) {
                save.write(announce);
                save.write(FILE_EOL);
            }
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "Saving to the announcements file has failed: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectEOL(String file) {
        try (FileInputStream in = new FileInputStream(file);){
            int ch1;
            do {
                if ((ch1 = in.read()) == -1) return System.lineSeparator();
                if (ch1 != 13) continue;
                int ch2 = in.read();
                if (ch2 == 10) {
                    String string = "\r\n";
                    return string;
                }
                String string = "\r";
                return string;
            } while (ch1 != 10);
            String string = "\n";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return System.lineSeparator();
    }

    public void announceToAll(String text) {
        this.announceToAll(text, false);
    }

    public void announceToAll(String text, boolean isCritical) {
        Broadcast.announceToOnlinePlayers(text, isCritical);
    }

    public void announceToAll(SystemMessage sm) {
        Broadcast.toAllOnlinePlayers(sm);
    }

    public void announceToInstance(SystemMessage sm, int instanceId) {
        Broadcast.toPlayersInInstance(sm, instanceId);
    }

    public void handleAnnounce(String command, int lengthToTrim, boolean isCritical) {
        try {
            String text = command.substring(lengthToTrim);
            SingletonHolder._instance.announceToAll(text, isCritical);
        }
        catch (StringIndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    private static class SingletonHolder {
        protected static final Announcements _instance = new Announcements();

        private SingletonHolder() {
        }
    }

    private static class EventAnnounce {
        DateRange validDateRange;
        String[] messages;

        EventAnnounce(DateRange validDateRange, String[] messages) {
            this.validDateRange = validDateRange;
            this.messages = messages;
        }
    }
}

