/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomMsg {
    private static Logger _log = Logger.getLogger(CustomMsg.class.getName());
    private static final DateFormat _dateFormat = new SimpleDateFormat("yy-MM-dd HH:mm");
    public static final int DELETE_OWNER = 1;
    public static final int DELETE_ADMIN = 2;
    private int _msgId;
    private long _msgDate;
    private MsgType _msgType;
    private String _toName;
    private String _toId;
    private String _fromName;
    private String _fromId;
    private String _title;
    private String _message;
    private int _readflg;
    private int _comCount;
    private boolean _isSuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateFormat(long date) {
        DateFormat dateFormat = _dateFormat;
        synchronized (dateFormat) {
            return _dateFormat.format(new Date(date));
        }
    }

    public static int list(List<CustomMsg> msgTable, MsgType msgType, L2PcInstance activeChar, int offset, int limit) {
        String toId;
        int msgTotal = -1;
        switch (msgType) {
            case ANNOUNCE: {
                toId = "SERVER_ALL_MEMBER";
                break;
            }
            case PRIVATE: {
                toId = activeChar.getAccountName2();
                break;
            }
            case CLAN: {
                toId = String.valueOf(activeChar.getClan().getId());
                break;
            }
            case MEMO: {
                toId = activeChar.getAccountName2();
                break;
            }
            default: {
                toId = "";
            }
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            ResultSet result;
            try (Statement statement = con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS msg_id,from_name,title,last_date,com_max,readflg FROM messagez WHERE msg_type=?  AND to_id=?  AND delflg=0 ORDER BY last_date DESC,msg_id DESC LIMIT ?,?");){
                statement.setInt(1, msgType.ordinal());
                statement.setString(2, toId);
                statement.setInt(3, offset);
                statement.setInt(4, limit);
                result = statement.executeQuery();
                while (result.next()) {
                    CustomMsg t = new CustomMsg();
                    t._msgId = result.getInt("msg_id");
                    t._fromName = result.getString("from_name");
                    t._title = result.getString("title");
                    t._msgDate = result.getLong("last_date");
                    t._readflg = result.getInt("readflg");
                    t._comCount = result.getInt("com_max");
                    msgTable.add(t);
                }
            }
            statement = con.createStatement();
            var10_13 = null;
            try {
                result = statement.executeQuery("SELECT FOUND_ROWS()");
                if (result.next()) {
                    msgTotal = result.getInt(1);
                }
            }
            catch (Throwable throwable) {
                var10_13 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var10_13 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable x2) {
                            var10_13.addSuppressed(x2);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on messagez: ", e);
        }
        return msgTotal;
    }

    public CustomMsg load(int msgId) {
        this._msgId = msgId;
        this._isSuccess = false;
        if (this._msgId == 0) {
            return this;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT * FROM messagez WHERE msg_id=? AND delflg=0");){
            statement.setInt(1, this._msgId);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                this._msgDate = result.getLong("msg_date");
                this._msgType = MsgType.enumOf(result.getInt("msg_type"));
                this._toName = result.getString("to_name");
                this._toId = result.getString("to_id");
                this._fromName = result.getString("from_name");
                this._fromId = result.getString("from_id");
                this._title = result.getString("title");
                this._message = result.getString("message");
                this._readflg = result.getInt("readflg");
            }
            this._isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on messagez " + this._msgId + " : ", e);
        }
        return this;
    }

    public static boolean insert(MsgType msgType, String toName, String title, String message, L2PcInstance activeChar) {
        String toId;
        boolean _isSuccess = false;
        String fromName = activeChar.getName();
        String fromId = activeChar.getAccountName2();
        switch (msgType) {
            case ANNOUNCE: {
                toName = "ServerMembers";
                toId = "SERVER_ALL_MEMBER";
                break;
            }
            case PRIVATE: {
                if (toName == null) {
                    return _isSuccess;
                }
                toId = CustomMsg.getIdFromCharName(toName);
                if (toId != null) break;
                return _isSuccess;
            }
            case CLAN: {
                if (activeChar.getClan() == null) {
                    return _isSuccess;
                }
                toName = activeChar.getClan().getName();
                toId = String.valueOf(activeChar.getClan().getId());
                break;
            }
            case MEMO: {
                toName = fromName;
                toId = fromId;
                break;
            }
            default: {
                toName = "";
                toId = "";
            }
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO messagez (msg_date, last_date, msg_type, to_name, to_id, from_name, from_id, title, message) values (?,?,?,?,?,?,?,?,?)");){
            long now = System.currentTimeMillis();
            statement.setLong(1, now);
            statement.setLong(2, now);
            statement.setInt(3, msgType.ordinal());
            statement.setString(4, toName);
            statement.setString(5, toId);
            statement.setString(6, fromName);
            statement.setString(7, fromId);
            statement.setString(8, title);
            statement.setString(9, message);
            statement.executeUpdate();
            _isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while insert messagez to db ", e);
        }
        return _isSuccess;
    }

    public static boolean update(int msgId, String title, String message, L2PcInstance activeChar) {
        boolean isSuccess = false;
        if (msgId == 0) {
            return isSuccess;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE messagez SET last_date=?, title=?, message=? WHERE msg_id=?");){
            long now = System.currentTimeMillis();
            statement.setLong(1, now);
            statement.setString(2, title);
            statement.setString(3, message);
            statement.setInt(4, msgId);
            statement.executeUpdate();
            isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while update messagez to db ", e);
        }
        return isSuccess;
    }

    public static boolean delete(int msgId, int delflg) {
        boolean isSuccess = false;
        if (msgId == 0) {
            return isSuccess;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE messagez SET delflg=? WHERE msg_id=?");){
            statement.setInt(1, delflg);
            statement.setInt(2, msgId);
            statement.executeUpdate();
            isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while delete messagez from db ", e);
        }
        return isSuccess;
    }

    public void setReadFlg(boolean readFlg) {
        this._isSuccess = false;
        if (this._msgId == 0) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE messagez SET readflg=? WHERE msg_id=?");){
            statement.setInt(1, readFlg ? 1 : 0);
            statement.setInt(2, this._msgId);
            statement.executeUpdate();
            this._readflg = readFlg ? 1 : 0;
            this._isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while update messagez to db ", e);
        }
    }

    public static int getPrivateMsgCnt(L2PcInstance activeChar) {
        int ret = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT COUNT(*) FROM messagez WHERE msg_type=2 AND to_id=? AND readflg=0 AND delflg=0");){
            statement.setString(1, activeChar.getAccountName2());
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                ret = result.getInt(1);
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on messagez: ", e);
        }
        return ret;
    }

    private static String getIdFromCharName(String name) {
        String ret = null;
        L2PcInstance pc = L2World.getInstance().getPlayer(name);
        if (pc != null) {
            return pc.getClient().getAccountName();
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT account_name FROM characters WHERE char_name=?");){
            statement.setString(1, name);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                ret = result.getString("account_name");
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on characters : ", e);
        }
        return ret;
    }

    public boolean isOwn(L2PcInstance activeChar) {
        if (this.getMsgType().isMail) {
            return this._toId.equals(activeChar.getAccountName2());
        }
        return this._fromId.equals(activeChar.getAccountName2());
    }

    public int getMsgId() {
        return this._msgId;
    }

    public MsgType getMsgType() {
        return this._msgType;
    }

    public String getDate() {
        return CustomMsg.dateFormat(this._msgDate);
    }

    public String getToName() {
        return this._toName;
    }

    public String getToId() {
        return this._toId;
    }

    public String getFromName() {
        return this._fromName;
    }

    public String getFromId() {
        return this._fromId;
    }

    public String getTitle() {
        return this._title;
    }

    public String getMessage() {
        return this._message;
    }

    public boolean getReadFlg() {
        return this._readflg == 1;
    }

    public int getComCount() {
        return this._comCount;
    }

    public boolean isSuccess() {
        return this._isSuccess;
    }

    public static enum MsgType {
        DEFAULT,
        ANNOUNCE,
        PRIVATE,
        CLAN,
        MEMO,
        QA,
        TRADE,
        EVENT,
        HELLO,
        RECRUIT;

        private String _nameLCase = super.name().toLowerCase();
        private String _caption;
        public boolean isMail;
        public boolean isClanmemberOnly;
        public boolean canComment = true;
        public boolean canReply;
        public boolean canEdit;
        public boolean canPostAdminOnly;
        private static final MsgType[] _values;

        public String toString() {
            return this._nameLCase;
        }

        public String getCaption() {
            return this._caption;
        }

        public static MsgType enumOf(int v) {
            return _values[v];
        }

        public static MsgType enumOf(String v) {
            for (MsgType item : _values) {
                if (!item._nameLCase.equals(v)) continue;
                return item;
            }
            throw new IllegalArgumentException(v);
        }

        static {
            MsgType.MEMO.canComment = false;
            MsgType.PRIVATE.canComment = false;
            MsgType.PRIVATE.canReply = true;
            MsgType.PRIVATE.isMail = true;
            MsgType.TRADE.canReply = true;
            MsgType.RECRUIT.canReply = true;
            MsgType.MEMO.canReply = true;
            MsgType.CLAN.isClanmemberOnly = true;
            MsgType.ANNOUNCE.canPostAdminOnly = true;
            MsgType.ANNOUNCE.canEdit = true;
            MsgType.MEMO.canEdit = true;
            MsgType.CLAN.canEdit = true;
            MsgType.TRADE.canEdit = true;
            MsgType.QA.canEdit = true;
            MsgType.DEFAULT.canEdit = true;
            MsgType.DEFAULT._caption = "&$750;";
            MsgType.ANNOUNCE._caption = "&$748;";
            MsgType.PRIVATE._caption = "&$919;";
            MsgType.CLAN._caption = "&$382;&$387;";
            MsgType.MEMO._caption = "&$403;";
            MsgType.QA._caption = "Q&A&$387;";
            MsgType.TRADE._caption = "&$362;&$387;";
            MsgType.EVENT._caption = "\u30a4\u30d9\u30f3\u30c8\u63b2\u793a\u677f";
            MsgType.HELLO._caption = "\u3042\u3044\u3055\u3064\u63b2\u793a\u677f";
            MsgType.RECRUIT._caption = "\u8840\u76df\u54e1\u52df\u96c6\u63b2\u793a\u677f";
            _values = MsgType.values();
        }
    }
}

