/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.communitybbs.BB.Topic;
import com.l2jserver.gameserver.communitybbs.Manager.PostBBSManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Post {
    private static Logger _log = Logger.getLogger(Post.class.getName());
    private final List<CPost> _post = new FastList();

    public Post(String _PostOwner, int _PostOwnerID, long date, int tid, int _PostForumID, String txt) {
        CPost cp = new CPost();
        cp.postId = 0;
        cp.postOwner = _PostOwner;
        cp.postOwnerId = _PostOwnerID;
        cp.postDate = date;
        cp.postTopicId = tid;
        cp.postForumId = _PostForumID;
        cp.postTxt = txt;
        this._post.add(cp);
        this.insertindb(cp);
    }

    public void insertindb(CPost cp) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("INSERT INTO posts (post_id,post_owner_name,post_ownerid,post_date,post_topic_id,post_forum_id,post_txt) values (?,?,?,?,?,?,?)");){
            ps.setInt(1, cp.postId);
            ps.setString(2, cp.postOwner);
            ps.setInt(3, cp.postOwnerId);
            ps.setLong(4, cp.postDate);
            ps.setInt(5, cp.postTopicId);
            ps.setInt(6, cp.postForumId);
            ps.setString(7, cp.postTxt);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while saving new Post to db " + e.getMessage(), e);
        }
    }

    public Post(Topic t) {
        this.load(t);
    }

    public CPost getCPost(int id) {
        int i = 0;
        for (CPost cp : this._post) {
            if (i++ != id) continue;
            return cp;
        }
        return null;
    }

    public void deleteme(Topic t) {
        PostBBSManager.getInstance().delPostByTopic(t);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("DELETE FROM posts WHERE post_forum_id=? AND post_topic_id=?");){
            ps.setInt(1, t.getForumID());
            ps.setInt(2, t.getID());
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while deleting post: " + e.getMessage(), e);
        }
    }

    private void load(Topic t) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM posts WHERE post_forum_id=? AND post_topic_id=? ORDER BY post_id ASC");){
            ps.setInt(1, t.getForumID());
            ps.setInt(2, t.getID());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    CPost cp = new CPost();
                    cp.postId = rs.getInt("post_id");
                    cp.postOwner = rs.getString("post_owner_name");
                    cp.postOwnerId = rs.getInt("post_ownerid");
                    cp.postDate = rs.getLong("post_date");
                    cp.postTopicId = rs.getInt("post_topic_id");
                    cp.postForumId = rs.getInt("post_forum_id");
                    cp.postTxt = rs.getString("post_txt");
                    this._post.add(cp);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Data error on Post " + t.getForumID() + "/" + t.getID() + " : " + e.getMessage(), e);
        }
    }

    public void updatetxt(int i) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("UPDATE posts SET post_txt=? WHERE post_id=? AND post_topic_id=? AND post_forum_id=?");){
            CPost cp = this.getCPost(i);
            ps.setString(1, cp.postTxt);
            ps.setInt(2, cp.postId);
            ps.setInt(3, cp.postTopicId);
            ps.setInt(4, cp.postForumId);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while saving new Post to db " + e.getMessage(), e);
        }
    }

    public static class CPost {
        public int postId;
        public String postOwner;
        public int postOwnerId;
        public long postDate;
        public int postTopicId;
        public int postForumId;
        public String postTxt;
    }
}

