/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2AdminCommandAccessRight;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AdminTable
extends DocumentParser {
    private static final FastIntObjectMap<L2AccessLevel> _accessLevels = new FastIntObjectMap();
    private static final HashMap<String, L2AdminCommandAccessRight> _adminCommandAccessRights = new HashMap();
    private static final FastMap<L2PcInstance, Boolean> _gmList = new FastMap().shared();
    private int _highestLevel = 0;

    protected AdminTable() {
        this.load();
    }

    @Override
    public synchronized void load() {
        _accessLevels.clear();
        _adminCommandAccessRights.clear();
        this.parseDatapackFile("config/accessLevels.xml");
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + _accessLevels.size() + " Access Levels");
        this.parseDatapackFile("config/adminCommands.xml");
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + _adminCommandAccessRights.size() + " Access Commands");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                Node attr;
                NamedNodeMap attrs;
                StatsSet set;
                if ("access".equalsIgnoreCase(d.getNodeName())) {
                    set = new StatsSet();
                    attrs = d.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        attr = attrs.item(i);
                        set.set(attr.getNodeName(), attr.getNodeValue());
                    }
                    L2AccessLevel level = new L2AccessLevel(set);
                    if (level.getLevel() > this._highestLevel) {
                        this._highestLevel = level.getLevel();
                    }
                    _accessLevels.put(level.getLevel(), (Object)level);
                    continue;
                }
                if (!"admin".equalsIgnoreCase(d.getNodeName())) continue;
                set = new StatsSet();
                attrs = d.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    attr = attrs.item(i);
                    set.set(attr.getNodeName(), attr.getNodeValue());
                }
                L2AdminCommandAccessRight command = new L2AdminCommandAccessRight(set);
                _adminCommandAccessRights.put(command.getAdminCommand(), command);
            }
        }
    }

    public L2AccessLevel getAccessLevel(int accessLevelNum) {
        if (accessLevelNum < 0) {
            return (L2AccessLevel)_accessLevels.get(-1);
        }
        if (!_accessLevels.containsKey(accessLevelNum)) {
            _accessLevels.put(accessLevelNum, (Object)new L2AccessLevel());
        }
        return (L2AccessLevel)_accessLevels.get(accessLevelNum);
    }

    public L2AccessLevel getMasterAccessLevel() {
        return (L2AccessLevel)_accessLevels.get(this._highestLevel);
    }

    public boolean hasAccessLevel(int id) {
        return _accessLevels.containsKey(id);
    }

    public boolean hasAccess(String adminCommand, L2AccessLevel accessLevel) {
        L2AdminCommandAccessRight acar = _adminCommandAccessRights.get(adminCommand);
        if (acar == null) {
            if (accessLevel.getLevel() > 0 && accessLevel.getLevel() == this._highestLevel) {
                acar = new L2AdminCommandAccessRight(adminCommand, true, accessLevel.getLevel());
                _adminCommandAccessRights.put(adminCommand, acar);
                this._log.info(this.getClass().getSimpleName() + ": No rights defined for admin command " + adminCommand + " auto setting accesslevel: " + accessLevel.getLevel() + " !");
            } else {
                this._log.info(this.getClass().getSimpleName() + ": No rights defined for admin command " + adminCommand + " !");
                return false;
            }
        }
        return acar.hasAccess(accessLevel);
    }

    public boolean requireConfirm(String command) {
        L2AdminCommandAccessRight acar = _adminCommandAccessRights.get(command);
        if (acar == null) {
            this._log.info(this.getClass().getSimpleName() + ": No rights defined for admin command " + command + ".");
            return false;
        }
        return acar.getRequireConfirm();
    }

    public List<L2PcInstance> getAllGms(boolean includeHidden) {
        ArrayList<L2PcInstance> tmpGmList = new ArrayList<L2PcInstance>();
        for (Map.Entry entry : _gmList.entrySet()) {
            if (!includeHidden && ((Boolean)entry.getValue()).booleanValue()) continue;
            tmpGmList.add((L2PcInstance)entry.getKey());
        }
        return tmpGmList;
    }

    public static Set<L2PcInstance> getAllGms() {
        return _gmList.keySet();
    }

    public List<String> getAllGmNames(boolean includeHidden) {
        ArrayList<String> tmpGmList = new ArrayList<String>();
        for (Map.Entry entry : _gmList.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) {
                tmpGmList.add(((L2PcInstance)entry.getKey()).getName());
                continue;
            }
            if (!includeHidden) continue;
            tmpGmList.add(((L2PcInstance)entry.getKey()).getName() + " (invis)");
        }
        return tmpGmList;
    }

    public void addGm(L2PcInstance player, boolean hidden) {
        _gmList.put((Object)player, (Object)hidden);
    }

    public void deleteGm(L2PcInstance player) {
        _gmList.remove((Object)player);
    }

    public void showGm(L2PcInstance player) {
        if (_gmList.containsKey((Object)player)) {
            _gmList.put((Object)player, (Object)false);
        }
    }

    public void hideGm(L2PcInstance player) {
        if (_gmList.containsKey((Object)player)) {
            _gmList.put((Object)player, (Object)true);
        }
    }

    public boolean isGmOnline(boolean includeHidden) {
        for (Map.Entry entry : _gmList.entrySet()) {
            if (!includeHidden && ((Boolean)entry.getValue()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void sendListToPlayer(L2PcInstance player) {
        if (this.isGmOnline(player.isGM())) {
            player.sendPacket(SystemMessageId.GM_LIST);
            for (String name : this.getAllGmNames(player.isGM())) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.GM_C1);
                sm.addString(name);
                player.sendPacket(sm);
            }
        } else {
            player.sendPacket(SystemMessageId.NO_GM_PROVIDING_SERVICE_NOW);
        }
    }

    public void broadcastToGMs(L2GameServerPacket packet) {
        for (L2PcInstance gm : this.getAllGms(true)) {
            gm.sendPacket(packet);
        }
    }

    public void broadcastMessageToGMs(String message) {
        for (L2PcInstance gm : this.getAllGms(true)) {
            gm.sendMessage(message);
        }
    }

    public static AdminTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AdminTable _instance = new AdminTable();

        private SingletonHolder() {
        }
    }
}

