/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class CharTemplateTable
extends DocumentParser {
    private static final Logger _log = Logger.getLogger(CharTemplateTable.class.getName());
    private static final Map<ClassId, L2PcTemplate> _charTemplates = new HashMap<ClassId, L2PcTemplate>();
    private int _dataCount = 0;

    protected CharTemplateTable() {
        this.load();
    }

    @Override
    public void load() {
        long started = System.currentTimeMillis();
        _charTemplates.clear();
        this.parseDatapackDirectory("data/stats/chars/baseStats", false);
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _charTemplates.size() + " character templates. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._dataCount + " level up gain records.");
    }

    @Override
    protected void parseDocument() {
        int classId = 0;
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                NamedNodeMap attrs;
                if ("classId".equalsIgnoreCase(d.getNodeName())) {
                    classId = Integer.parseInt(d.getTextContent());
                    continue;
                }
                if ("staticData".equalsIgnoreCase(d.getNodeName())) {
                    StatsSet set = new StatsSet();
                    set.set("classId", classId);
                    ArrayList<Location> creationPoints = new ArrayList<Location>();
                    for (Node nd = d.getFirstChild(); nd != null; nd = nd.getNextSibling()) {
                        if (nd.getNodeName().equals("#text")) continue;
                        if (nd.getChildNodes().getLength() > 1) {
                            for (Node cnd = nd.getFirstChild(); cnd != null; cnd = cnd.getNextSibling()) {
                                if (nd.getNodeName().equalsIgnoreCase("collisionMale")) {
                                    if (cnd.getNodeName().equalsIgnoreCase("radius")) {
                                        set.set("collision_radius", cnd.getTextContent());
                                    } else if (cnd.getNodeName().equalsIgnoreCase("height")) {
                                        set.set("collision_height", cnd.getTextContent());
                                    }
                                }
                                if ("node".equalsIgnoreCase(cnd.getNodeName())) {
                                    attrs = cnd.getAttributes();
                                    creationPoints.add(new Location(this.parseInteger(attrs, "x"), this.parseInteger(attrs, "y"), this.parseInteger(attrs, "z")));
                                    continue;
                                }
                                if ("walk".equalsIgnoreCase(cnd.getNodeName())) {
                                    set.set("baseWalkSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("run".equalsIgnoreCase(cnd.getNodeName())) {
                                    set.set("baseRunSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("slowSwim".equals(cnd.getNodeName())) {
                                    set.set("baseSwimWalkSpd", cnd.getTextContent());
                                    continue;
                                }
                                if ("fastSwim".equals(cnd.getNodeName())) {
                                    set.set("baseSwimRunSpd", cnd.getTextContent());
                                    continue;
                                }
                                if (cnd.getNodeName().equals("#text")) continue;
                                set.set(nd.getNodeName() + cnd.getNodeName(), cnd.getTextContent());
                            }
                            continue;
                        }
                        set.set(nd.getNodeName(), nd.getTextContent());
                    }
                    set.set("basePDef", set.getInt("basePDefchest", 0) + set.getInt("basePDeflegs", 0) + set.getInt("basePDefhead", 0) + set.getInt("basePDeffeet", 0) + set.getInt("basePDefgloves", 0) + set.getInt("basePDefunderwear", 0) + set.getInt("basePDefcloak", 0));
                    set.set("baseMDef", set.getInt("baseMDefrear", 0) + set.getInt("baseMDeflear", 0) + set.getInt("baseMDefrfinger", 0) + set.getInt("baseMDefrfinger", 0) + set.getInt("baseMDefneck", 0));
                    L2PcTemplate ct = new L2PcTemplate(set, creationPoints);
                    _charTemplates.put(ClassId.getClassId(classId), ct);
                    continue;
                }
                if (!"lvlUpgainData".equalsIgnoreCase(d.getNodeName())) continue;
                for (Node lvlNode = d.getFirstChild(); lvlNode != null; lvlNode = lvlNode.getNextSibling()) {
                    if (!"level".equalsIgnoreCase(lvlNode.getNodeName())) continue;
                    attrs = lvlNode.getAttributes();
                    int level = this.parseInteger(attrs, "val");
                    for (Node valNode = lvlNode.getFirstChild(); valNode != null; valNode = valNode.getNextSibling()) {
                        String nodeName = valNode.getNodeName();
                        if (!nodeName.startsWith("hp") && !nodeName.startsWith("mp") && !nodeName.startsWith("cp") || !_charTemplates.containsKey(ClassId.getClassId(classId))) continue;
                        _charTemplates.get(ClassId.getClassId(classId)).setUpgainValue(nodeName, level, Double.parseDouble(valNode.getTextContent()));
                        ++this._dataCount;
                    }
                }
            }
        }
    }

    public L2PcTemplate getTemplate(ClassId classId) {
        return _charTemplates.get(classId);
    }

    public L2PcTemplate getTemplate(int classId) {
        return _charTemplates.get(ClassId.getClassId(classId));
    }

    public static final CharTemplateTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CharTemplateTable _instance = new CharTemplateTable();

        private SingletonHolder() {
        }
    }
}

