/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.templates.L2DoorTemplate;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.util.FastIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DoorTable
extends DocumentParser {
    private static final HashMap<String, FastIntSet> _groups = new HashMap();
    private final FastIntObjectMap<L2DoorInstance> _doors = new FastIntObjectMap();
    private final FastIntObjectMap<StatsSet> _templates = new FastIntObjectMap();
    private final FastIntObjectMap<ArrayList<L2DoorInstance>> _regions = new FastIntObjectMap();

    protected DoorTable() {
        this._log.info("Initializing Door Table");
        this.load();
    }

    @Override
    public void load() {
        this._doors.clear();
        _groups.clear();
        this._regions.clear();
        this.parseDatapackFile("data/doors.xml");
    }

    @Override
    protected void parseDocument() {
        for (Node a = this.getCurrentDocument().getFirstChild(); a != null; a = a.getNextSibling()) {
            if (!"list".equalsIgnoreCase(a.getNodeName())) continue;
            for (Node b = a.getFirstChild(); b != null; b = b.getNextSibling()) {
                if (!"door".equalsIgnoreCase(b.getNodeName())) continue;
                NamedNodeMap attrs = b.getAttributes();
                StatsSet set = new StatsSet();
                set.set("baseHpMax", 1);
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                this.makeDoor(set);
                this._templates.put(set.getInt("id"), (Object)set);
            }
        }
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._doors.size() + " Door Templates for " + this._regions.size() + " regions.");
    }

    public void insertCollisionData(StatsSet set) {
        int height = set.getInt("height");
        String[] pos = set.getString("node1").split(",");
        int nodeX = Integer.parseInt(pos[0]);
        int nodeY = Integer.parseInt(pos[1]);
        pos = set.getString("node2").split(",");
        int posX = Integer.parseInt(pos[0]);
        int posY = Integer.parseInt(pos[1]);
        int collisionRadius = Math.min(Math.abs(nodeX - posX), Math.abs(nodeY - posY));
        if (collisionRadius < 20) {
            collisionRadius = 20;
        }
        set.set("collision_radius", collisionRadius);
        set.set("collision_height", height);
    }

    private void makeDoor(StatsSet set) {
        this.insertCollisionData(set);
        L2DoorTemplate template = new L2DoorTemplate(set);
        L2DoorInstance door = new L2DoorInstance(IdFactory.getInstance().getNextId(), template);
        door.setCurrentHp(door.getMaxHp());
        door.spawnMe(template.getX(), template.getY(), template.getZ());
        this.putDoor(door, MapRegionManager.getInstance().getMapRegionLocId(door));
    }

    public StatsSet getDoorTemplate(int doorId) {
        return (StatsSet)this._templates.get(doorId);
    }

    public L2DoorInstance getDoor(int doorId) {
        return (L2DoorInstance)this._doors.get(doorId);
    }

    public void putDoor(L2DoorInstance door, int region) {
        this._doors.put(door.getId(), (Object)door);
        ArrayList<L2DoorInstance> list = (ArrayList<L2DoorInstance>)this._regions.get(region);
        if (list == null) {
            list = new ArrayList<L2DoorInstance>();
            this._regions.put(region, list);
        }
        list.add(door);
    }

    public static void addDoorGroup(String groupName, int doorId) {
        FastIntSet set = _groups.get(groupName);
        if (set == null) {
            set = new FastIntSet();
            _groups.put(groupName, set);
        }
        set.add(doorId);
    }

    public static FastIntSet getDoorsByGroup(String groupName) {
        return _groups.get(groupName);
    }

    public Collection<L2DoorInstance> getDoors() {
        return this._doors.values();
    }

    public boolean checkIfDoorsBetween(AbstractNodeLoc start, AbstractNodeLoc end, int instanceId) {
        return this.checkIfDoorsBetween(start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ(), instanceId);
    }

    public boolean checkIfDoorsBetween(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        return this.checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, false);
    }

    public boolean checkIfDoorsBetween(int x, int y, int z, int tx, int ty, int tz, int instanceId, boolean doubleFaceCheck) {
        Collection allDoors = instanceId > 0 && InstanceManager.getInstance().getInstance(instanceId) != null ? InstanceManager.getInstance().getInstance(instanceId).getDoors() : (Collection)this._regions.get(MapRegionManager.getInstance().getMapRegionLocId(x, y));
        if (allDoors == null) {
            return false;
        }
        for (L2DoorInstance doorInst : allDoors) {
            if (doorInst.isDead() || doorInst.getOpen() || !doorInst.checkCollision() || doorInst.getX(0) == 0) continue;
            boolean intersectFace = false;
            for (int i = 0; i < 4; ++i) {
                int intersectZ;
                int j = i + 1 < 4 ? i + 1 : 0;
                int denominator = (ty - y) * (doorInst.getX(i) - doorInst.getX(j)) - (tx - x) * (doorInst.getY(i) - doorInst.getY(j));
                if (denominator == 0) continue;
                float multiplier1 = (float)((doorInst.getX(j) - doorInst.getX(i)) * (y - doorInst.getY(i)) - (doorInst.getY(j) - doorInst.getY(i)) * (x - doorInst.getX(i))) / (float)denominator;
                float multiplier2 = (float)((tx - x) * (y - doorInst.getY(i)) - (ty - y) * (x - doorInst.getX(i))) / (float)denominator;
                if (!(multiplier1 >= 0.0f) || !(multiplier1 <= 1.0f) || !(multiplier2 >= 0.0f) || !(multiplier2 <= 1.0f) || (intersectZ = Math.round((float)z + multiplier1 * (float)(tz - z))) <= doorInst.getZMin() || intersectZ >= doorInst.getZMax()) continue;
                if (!doubleFaceCheck || intersectFace) {
                    return true;
                }
                intersectFace = true;
            }
        }
        return false;
    }

    public static DoorTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final DoorTable _instance = new DoorTable();

        private SingletonHolder() {
        }
    }
}

