/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.model.skills.funcs.LambdaConst;
import com.l2jserver.gameserver.model.stats.Stats;
import java.util.ArrayList;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.Node;

public class EnchantItemHPBonusData
extends DocumentParser {
    private final SortedIntObjectArrayMap<ArrayList<Integer>> _armorHPBonuses = new SortedIntObjectArrayMap((Object[])new ArrayList[0]);
    private static final float fullArmorModifier = 1.5f;

    protected EnchantItemHPBonusData() {
        this.load();
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"enchantHP".equals(d.getNodeName())) continue;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (Node e = d.getFirstChild(); e != null; e = e.getNextSibling()) {
                    if (!"bonus".equals(e.getNodeName())) continue;
                    arrayList.add(Integer.valueOf(e.getTextContent()));
                }
                this._armorHPBonuses.put(this.parseInt(d.getAttributes(), "grade"), arrayList);
            }
        }
        if (!this._armorHPBonuses.isEmpty()) {
            ItemTable it = ItemTable.getInstance();
            for (L2Armor l2Armor : it.getAllArmors()) {
                if (l2Armor == null || l2Armor.getCrystalType() == 0) continue;
                switch (l2Armor.getBodyPart()) {
                    case 1: 
                    case 64: 
                    case 256: 
                    case 512: 
                    case 1024: 
                    case 2048: 
                    case 4096: 
                    case 8192: 
                    case 32768: {
                        l2Armor.attach(new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0)));
                        break;
                    }
                }
            }
            for (L2Weapon l2Weapon : it.getAllWeapons()) {
                if (l2Weapon == null || l2Weapon.getCrystalType() == 0) continue;
                switch (l2Weapon.getBodyPart()) {
                    case 256: {
                        l2Weapon.attach(new FuncTemplate(null, null, "EnchantHp", Stats.MAX_HP, 96, new LambdaConst(0.0)));
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void load() {
        this._armorHPBonuses.clear();
        this.parseDatapackFile("data/stats/enchantHPBonus.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._armorHPBonuses.size() + " Enchant HP Bonuses.");
    }

    public final int getHPBonus(L2ItemInstance item) {
        ArrayList values = (ArrayList)this._armorHPBonuses.get(item.getItem().getItemGradeSPlus());
        if (values == null || values.isEmpty() || item.getOlyEnchantLevel() <= 0) {
            return 0;
        }
        int bonus = (Integer)values.get(Math.min(item.getOlyEnchantLevel(), values.size()) - 1);
        if (item.getItem().getBodyPart() == 32768) {
            return (int)((float)bonus * 1.5f);
        }
        return bonus;
    }

    public static final EnchantItemHPBonusData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemHPBonusData _instance = new EnchantItemHPBonusData();

        private SingletonHolder() {
        }
    }
}

