/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.actor.L2Character;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class HitConditionBonus
extends DocumentParser {
    private int frontBonus = 0;
    private int sideBonus = 0;
    private int backBonus = 0;
    private int highBonus = 0;
    private int lowBonus = 0;
    private int darkBonus = 0;
    private int rainBonus = 0;

    protected HitConditionBonus() {
        this.load();
    }

    @Override
    public void load() {
        this.parseDatapackFile("data/stats/hitConditionBonus.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded Hit Condition bonuses.");
        if (Config.DEBUG) {
            this._log.info(this.getClass().getSimpleName() + ": Front bonus: " + this.frontBonus);
            this._log.info(this.getClass().getSimpleName() + ": Side bonus: " + this.sideBonus);
            this._log.info(this.getClass().getSimpleName() + ": Back bonus: " + this.backBonus);
            this._log.info(this.getClass().getSimpleName() + ": High bonus: " + this.highBonus);
            this._log.info(this.getClass().getSimpleName() + ": Low bonus: " + this.lowBonus);
            this._log.info(this.getClass().getSimpleName() + ": Dark bonus: " + this.darkBonus);
            this._log.info(this.getClass().getSimpleName() + ": Rain bonus: " + this.rainBonus);
        }
    }

    @Override
    protected void parseDocument() {
        Node n = this.getCurrentDocument().getFirstChild();
        block18: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            NamedNodeMap attrs = d.getAttributes();
            switch (d.getNodeName()) {
                case "front": {
                    this.frontBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "side": {
                    this.sideBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "back": {
                    this.backBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "high": {
                    this.highBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "low": {
                    this.lowBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "dark": {
                    this.darkBonus = this.parseInteger(attrs, "val");
                    continue block18;
                }
                case "rain": {
                    this.rainBonus = this.parseInteger(attrs, "val");
                }
            }
        }
    }

    public double getConditionBonus(L2Character attacker, L2Character target) {
        double mod = 100.0;
        if (attacker.getZ() - target.getZ() > 50) {
            mod += (double)this.highBonus;
        } else if (attacker.getZ() - target.getZ() < -50) {
            mod += (double)this.lowBonus;
        }
        if (GameTimeController.getInstance().isNight()) {
            mod += (double)this.darkBonus;
        }
        mod = attacker.isBehindTarget() ? (mod += (double)this.backBonus) : (attacker.isInFrontOfTarget() ? (mod += (double)this.frontBonus) : (mod += (double)this.sideBonus));
        return Math.max(mod / 100.0, 0.0);
    }

    public static HitConditionBonus getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final HitConditionBonus _instance = new HitConditionBonus();

        private SingletonHolder() {
        }
    }
}

