/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.base.ClassId;
import java.util.ArrayList;
import java.util.List;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.Node;

public final class SkillLearnData
extends DocumentParser {
    private final SortedIntObjectArrayMap<List<ClassId>> _skillLearn = new SortedIntObjectArrayMap((Object[])new List[0]);

    protected SkillLearnData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._skillLearn.clear();
        this.parseDatapackFile("data/skillLearn.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._skillLearn.size() + " Skill Learn data.");
    }

    @Override
    protected void parseDocument() {
        for (Node node = this.getCurrentDocument().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!"list".equalsIgnoreCase(node.getNodeName())) continue;
            for (Node list_node = node.getFirstChild(); list_node != null; list_node = list_node.getNextSibling()) {
                if (!"npc".equalsIgnoreCase(list_node.getNodeName())) continue;
                ArrayList<ClassId> classIds = new ArrayList<ClassId>();
                for (Node c = list_node.getFirstChild(); c != null; c = c.getNextSibling()) {
                    if (!"classId".equalsIgnoreCase(c.getNodeName())) continue;
                    classIds.add(ClassId.getClassId(Integer.parseInt(c.getTextContent())));
                }
                classIds.trimToSize();
                this._skillLearn.put(this.parseInteger(list_node.getAttributes(), "id").intValue(), classIds);
            }
        }
    }

    public List<ClassId> getSkillLearnData(int npcId) {
        return (List)this._skillLearn.get(npcId);
    }

    public static SkillLearnData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillLearnData _instance = new SkillLearnData();

        private SingletonHolder() {
        }
    }
}

