/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class StaticObjects
extends DocumentParser {
    private static final SortedIntObjectArrayMap<L2StaticObjectInstance> _staticObjects = new SortedIntObjectArrayMap((Object[])new L2StaticObjectInstance[0]);

    protected StaticObjects() {
        this.load();
    }

    @Override
    public void load() {
        _staticObjects.clear();
        this.parseDatapackFile("data/staticObjects.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _staticObjects.size() + " static object templates.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"object".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                StatsSet set = new StatsSet();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                this.addObject(set);
            }
        }
    }

    private void addObject(StatsSet set) {
        L2StaticObjectInstance obj = new L2StaticObjectInstance(IdFactory.getInstance().getNextId(), new L2CharTemplate(new StatsSet()), set.getInt("id"));
        obj.setType(set.getInt("type", 0));
        obj.setName(set.getString("name"));
        obj.setMap(set.getString("texture", "none"), set.getInt("map_x", 0), set.getInt("map_y", 0));
        obj.spawnMe(set.getInt("x"), set.getInt("y"), set.getInt("z"));
        _staticObjects.append(obj.getObjectId(), (Object)obj);
    }

    public L2StaticObjectInstance[] getStaticObjects() {
        return (L2StaticObjectInstance[])_staticObjects.values();
    }

    public static StaticObjects getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final StaticObjects _instance = new StaticObjects();

        private SingletonHolder() {
        }
    }
}

