/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.idfactory;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.idfactory.IdFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Stack;

public class StackIDFactory
extends IdFactory {
    private int _curOID = 0x10000000;
    private int _tempOID = 0x10000000;
    private final Stack<Integer> _freeOIDStack = new Stack();

    protected StackIDFactory() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            int[] tmp_obj_ids = this.extractUsedObjectIDTable();
            if (tmp_obj_ids.length > 0) {
                this._curOID = tmp_obj_ids[tmp_obj_ids.length - 1];
            }
            this._log.info("Max Id = " + this._curOID);
            int N = tmp_obj_ids.length;
            for (int idx = 0; idx < N; ++idx) {
                N = this.insertUntil(tmp_obj_ids, idx, N, con);
            }
            ++this._curOID;
            this._log.info("IdFactory: Next usable Object ID is: " + this._curOID);
            this._initialized = true;
        }
        catch (Exception e) {
            this._log.severe(this.getClass().getSimpleName() + ": Could not be initialized properly:" + e.getMessage());
        }
    }

    private int insertUntil(int[] tmp_obj_ids, int idx, int N, Connection con) throws SQLException {
        int hole;
        int id = tmp_obj_ids[idx];
        if (id == this._tempOID) {
            ++this._tempOID;
            return N;
        }
        if (Config.BAD_ID_CHECKING) {
            for (String check : ID_CHECKS) {
                try (PreparedStatement ps = con.prepareStatement(check);){
                    ps.setInt(1, this._tempOID);
                    ps.setInt(2, id);
                    try (ResultSet rs = ps.executeQuery();){
                        if (!rs.next()) continue;
                        int badId = rs.getInt(1);
                        this._log.severe("Bad ID " + badId + " in DB found by: " + check);
                        throw new RuntimeException();
                    }
                }
            }
        }
        if ((hole = id - this._tempOID) > N - idx) {
            hole = N - idx;
        }
        for (int i = 1; i <= hole; ++i) {
            this._freeOIDStack.push(this._tempOID);
            ++this._tempOID;
        }
        if (hole < N - idx) {
            ++this._tempOID;
        }
        return N - hole;
    }

    public static IdFactory getInstance() {
        return _instance;
    }

    @Override
    public synchronized int getNextId() {
        int id = !this._freeOIDStack.empty() ? this._freeOIDStack.pop() : this._curOID++;
        return id;
    }

    @Override
    public synchronized void releaseId(int id) {
        this._freeOIDStack.push(id);
    }

    @Override
    public int size() {
        return 0x6FFFFFFF - this._curOID + 0x10000000 + this._freeOIDStack.size();
    }
}

