/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class CastleManager
implements InstanceListManager {
    private static final Logger _log = Logger.getLogger(CastleManager.class.getName());
    private final ArrayList<Castle> _castles = new ArrayList(9);
    private final FastIntObjectMap<Long> _castleSiegeDate = new FastIntObjectMap(9).shared();
    private static final int[] _castleCirclets = new int[]{0, 6838, 6835, 6839, 6837, 6840, 6834, 6836, 8182, 8183};

    public final int findNearestCastleIndex(L2Object obj) {
        return this.findNearestCastleIndex(obj, Long.MAX_VALUE);
    }

    public final int findNearestCastleIndex(L2Object obj, long maxDistance) {
        int index = this.getCastleIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this.getCastles().size(); ++i) {
                double distance;
                Castle castle = this.getCastles().get(i);
                if (castle == null || !((double)maxDistance > (distance = castle.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public final Castle getCastleById(int castleId) {
        for (Castle temp : this.getCastles()) {
            if (temp.getResidenceId() != castleId) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastleByOwner(L2Clan clan) {
        for (Castle temp : this.getCastles()) {
            if (temp.getOwnerId() != clan.getId()) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(String name) {
        name = name.trim();
        for (Castle temp : this.getCastles()) {
            if (!temp.getName().equalsIgnoreCase(name)) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(int x, int y, int z) {
        for (Castle temp : this.getCastles()) {
            if (!temp.checkIfInZone(x, y, z)) continue;
            return temp;
        }
        return null;
    }

    public final Castle getCastle(L2Object activeObject) {
        return this.getCastle(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getCastleIndex(int castleId) {
        for (int i = 0; i < this.getCastles().size(); ++i) {
            Castle castle = this.getCastles().get(i);
            if (castle == null || castle.getResidenceId() != castleId) continue;
            return i;
        }
        return -1;
    }

    public final int getCastleIndex(L2Object activeObject) {
        return this.getCastleIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getCastleIndex(int x, int y, int z) {
        for (int i = 0; i < this.getCastles().size(); ++i) {
            Castle castle = this.getCastles().get(i);
            if (castle == null || !castle.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public final ArrayList<Castle> getCastles() {
        return this._castles;
    }

    public boolean hasOwnedCastle() {
        for (Castle castle : this.getCastles()) {
            if (castle.getOwnerId() <= 0) continue;
            return true;
        }
        return false;
    }

    public final void validateTaxes(int sealStrifeOwner) {
        int maxTax;
        switch (sealStrifeOwner) {
            case 1: {
                maxTax = 5;
                break;
            }
            case 2: {
                maxTax = 25;
                break;
            }
            default: {
                maxTax = 15;
            }
        }
        for (Castle castle : this._castles) {
            if (castle.getTaxPercent() <= maxTax) continue;
            castle.setTaxPercent(maxTax);
        }
    }

    public int getCirclet() {
        return this.getCircletByCastleId(1);
    }

    public int getCircletByCastleId(int castleId) {
        if (castleId > 0 && castleId < 10) {
            return _castleCirclets[castleId];
        }
        return 0;
    }

    public void removeCirclet(L2Clan clan, int castleId) {
        for (L2ClanMember member : clan.getMembers()) {
            this.removeCirclet(member, castleId);
        }
    }

    public void removeCirclet(L2ClanMember member, int castleId) {
        if (member == null) {
            return;
        }
        L2PcInstance player = member.getPlayerInstance();
        int circletId = this.getCircletByCastleId(castleId);
        if (circletId != 0) {
            if (player != null) {
                try {
                    L2ItemInstance circlet = player.getInventory().getItemByItemId(circletId);
                    if (circlet != null) {
                        if (circlet.isEquipped()) {
                            player.getInventory().unEquipItemInSlot(circlet.getLocationSlot());
                        }
                        player.destroyItemByItemId("CastleCircletRemoval", circletId, 1L, player, true);
                    }
                    return;
                }
                catch (NullPointerException e) {
                    // empty catch block
                }
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement("DELETE FROM items WHERE owner_id = ? and item_id = ?");){
                ps.setInt(1, member.getObjectId());
                ps.setInt(2, circletId);
                ps.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Failed to remove castle circlets offline for player " + member.getName() + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void loadInstances() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id FROM castle ORDER BY id");){
            while (rs.next()) {
                this.getCastles().add(new Castle(rs.getInt("id")));
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded: " + this.getCastles().size() + " castles");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadCastleData(): " + e.getMessage(), e);
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Castle castle : this._castles) {
            castle.activateInstance();
        }
    }

    public void registerSiegeDate(int castleId, long siegeDate) {
        this._castleSiegeDate.put(castleId, (Object)siegeDate);
    }

    public int getSiegeDates(long siegeDate) {
        int count = 0;
        Iterator i$ = this._castleSiegeDate.values().iterator();
        while (i$.hasNext()) {
            long date = (Long)i$.next();
            if (Math.abs(date - siegeDate) >= 1000L) continue;
            ++count;
        }
        return count;
    }

    public static final CastleManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CastleManager _instance = new CastleManager();

        private SingletonHolder() {
        }
    }
}

