/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Couple;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class CoupleManager {
    private static final Logger _log = Logger.getLogger(CoupleManager.class.getName());
    private FastList<Couple> _couples;

    protected CoupleManager() {
        this.load();
    }

    public void reload() {
        this.getCouples().clear();
        this.load();
    }

    private final void load() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT id FROM mods_wedding ORDER BY id");){
            while (rs.next()) {
                this.getCouples().add((Object)new Couple(rs.getInt("id")));
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded: " + this.getCouples().size() + " couples(s)");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: CoupleManager.load(): " + e.getMessage(), e);
        }
    }

    public final Couple getCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        if (index >= 0) {
            return (Couple)this.getCouples().get(index);
        }
        return null;
    }

    public void createCouple(L2PcInstance player1, L2PcInstance player2) {
        if (player1 != null && player2 != null && player1.getPartnerId() == 0 && player2.getPartnerId() == 0) {
            int _player1id = player1.getObjectId();
            int _player2id = player2.getObjectId();
            Couple _new = new Couple(player1, player2);
            this.getCouples().add((Object)_new);
            player1.setPartnerId(_player2id);
            player2.setPartnerId(_player1id);
            player1.setCoupleId(_new.getId());
            player2.setCoupleId(_new.getId());
        }
    }

    public void deleteCouple(int coupleId) {
        int index = this.getCoupleIndex(coupleId);
        Couple couple = (Couple)this.getCouples().get(index);
        if (couple != null) {
            L2PcInstance player1 = L2World.getInstance().getPlayer(couple.getPlayer1Id());
            L2PcInstance player2 = L2World.getInstance().getPlayer(couple.getPlayer2Id());
            if (player1 != null) {
                player1.setPartnerId(0);
                player1.setMarried(false);
                player1.setCoupleId(0);
            }
            if (player2 != null) {
                player2.setPartnerId(0);
                player2.setMarried(false);
                player2.setCoupleId(0);
            }
            couple.divorce();
            this.getCouples().remove(index);
        }
    }

    public final int getCoupleIndex(int coupleId) {
        int i = 0;
        for (Couple temp : this.getCouples()) {
            if (temp != null && temp.getId() == coupleId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final FastList<Couple> getCouples() {
        if (this._couples == null) {
            this._couples = new FastList();
        }
        return this._couples;
    }

    public static final CoupleManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CoupleManager _instance = new CoupleManager();

        private SingletonHolder() {
        }
    }
}

