/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.InstanceListManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.entity.Fort;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class FortManager
implements InstanceListManager {
    protected static final Logger _log = Logger.getLogger(FortManager.class.getName());
    private List<Fort> _forts;

    public final int findNearestFortIndex(L2Object obj) {
        return this.findNearestFortIndex(obj, Long.MAX_VALUE);
    }

    public final int findNearestFortIndex(L2Object obj, long maxDistance) {
        int index = this.getFortIndex(obj);
        if (index < 0) {
            for (int i = 0; i < this.getForts().size(); ++i) {
                double distance;
                Fort fort = this.getForts().get(i);
                if (fort == null || !((double)maxDistance > (distance = fort.getDistance(obj)))) continue;
                maxDistance = (long)distance;
                index = i;
            }
        }
        return index;
    }

    public final Fort getFortById(int fortId) {
        for (Fort f : this.getForts()) {
            if (f.getResidenceId() != fortId) continue;
            return f;
        }
        return null;
    }

    public final Fort getFortByOwner(L2Clan clan) {
        for (Fort f : this.getForts()) {
            if (f.getOwnerClan() != clan) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(String name) {
        for (Fort f : this.getForts()) {
            if (!f.getName().equalsIgnoreCase(name.trim())) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(int x, int y, int z) {
        for (Fort f : this.getForts()) {
            if (!f.checkIfInZone(x, y, z)) continue;
            return f;
        }
        return null;
    }

    public final Fort getFort(L2Object activeObject) {
        return this.getFort(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getFortIndex(int fortId) {
        for (int i = 0; i < this.getForts().size(); ++i) {
            Fort fort = this.getForts().get(i);
            if (fort == null || fort.getResidenceId() != fortId) continue;
            return i;
        }
        return -1;
    }

    public final int getFortIndex(L2Object activeObject) {
        return this.getFortIndex(activeObject.getX(), activeObject.getY(), activeObject.getZ());
    }

    public final int getFortIndex(int x, int y, int z) {
        for (int i = 0; i < this.getForts().size(); ++i) {
            Fort fort = this.getForts().get(i);
            if (fort == null || !fort.checkIfInZone(x, y, z)) continue;
            return i;
        }
        return -1;
    }

    public final List<Fort> getForts() {
        if (this._forts == null) {
            this._forts = new FastList();
        }
        return this._forts;
    }

    @Override
    public void loadInstances() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT id FROM fort ORDER BY id");){
            while (rs.next()) {
                this.getForts().add(new Fort(rs.getInt("id")));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: loadFortData(): " + e.getMessage(), e);
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded: " + this.getForts().size() + " fortress");
        for (Fort fort : this.getForts()) {
            fort.getSiege().getSiegeGuardManager().loadSiegeGuard();
        }
    }

    @Override
    public void updateReferences() {
    }

    @Override
    public void activateInstances() {
        for (Fort fort : this._forts) {
            fort.activateInstance();
        }
    }

    public static final FortManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final FortManager _instance = new FortManager();

        private SingletonHolder() {
        }
    }
}

