/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionInstance;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ItemAuctionManager {
    private static final Logger _log = Logger.getLogger(ItemAuctionManager.class.getName());
    private final FastIntObjectMap<ItemAuctionInstance> _managerInstances = new FastIntObjectMap();
    private final AtomicInteger _auctionIds = new AtomicInteger(1);

    protected ItemAuctionManager() {
        if (!Config.ALT_ITEM_AUCTION_ENABLED) {
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Disabled by config.");
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement statement = con.createStatement();
             ResultSet rset = statement.executeQuery("SELECT auctionId FROM item_auction ORDER BY auctionId DESC LIMIT 0, 1");){
            if (rset.next()) {
                this._auctionIds.set(rset.getInt(1) + 1);
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed loading auctions.", e);
        }
        File file = new File(Config.DATAPACK_ROOT + "/data/ItemAuctions.xml");
        if (!file.exists()) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Missing ItemAuctions.xml!");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        try {
            Document doc = factory.newDocumentBuilder().parse(file);
            for (Node na = doc.getFirstChild(); na != null; na = na.getNextSibling()) {
                if (!"list".equalsIgnoreCase(na.getNodeName())) continue;
                for (Node nb = na.getFirstChild(); nb != null; nb = nb.getNextSibling()) {
                    if (!"instance".equalsIgnoreCase(nb.getNodeName())) continue;
                    NamedNodeMap nab = nb.getAttributes();
                    int instanceId = Integer.parseInt(nab.getNamedItem("id").getNodeValue());
                    if (this._managerInstances.containsKey(instanceId)) {
                        throw new Exception("Dublicated instanceId " + instanceId);
                    }
                    ItemAuctionInstance instance = new ItemAuctionInstance(instanceId, this._auctionIds, nb);
                    this._managerInstances.put(instanceId, (Object)instance);
                }
            }
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + this._managerInstances.size() + " instance(s).");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed loading auctions from xml.", e);
        }
    }

    public final void shutdown() {
        for (ItemAuctionInstance instance : this._managerInstances.values()) {
            instance.shutdown();
        }
    }

    public final ItemAuctionInstance getManagerInstance(int instanceId) {
        return (ItemAuctionInstance)this._managerInstances.get(instanceId);
    }

    public final int getNextAuctionId() {
        return this._auctionIds.getAndIncrement();
    }

    public static final void deleteAuction(int auctionId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement statement = con.prepareStatement("DELETE FROM item_auction WHERE auctionId=?");){
                statement.setInt(1, auctionId);
                statement.execute();
            }
            statement = con.prepareStatement("DELETE FROM item_auction_bid WHERE auctionId=?");
            var4_7 = null;
            try {
                statement.setInt(1, auctionId);
                statement.execute();
            }
            catch (Throwable throwable) {
                var4_7 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var4_7 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable x2) {
                            var4_7.addSuppressed(x2);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "L2ItemAuctionManagerInstance: Failed deleting auction: " + auctionId, e);
        }
    }

    public static final ItemAuctionManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ItemAuctionManager _instance = new ItemAuctionManager();

        private SingletonHolder() {
        }
    }
}

