/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.interfaces.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class ChanceSkillList
extends FastMap<IChanceSkillTrigger, ChanceCondition> {
    protected static final Logger _log = Logger.getLogger(ChanceSkillList.class.getName());
    private static final long serialVersionUID = 1L;
    private final L2Character _owner;

    public ChanceSkillList(L2Character owner) {
        this.shared();
        this._owner = owner;
    }

    public L2Character getOwner() {
        return this._owner;
    }

    public void onHit(L2Character target, int damage, boolean ownerWasHit, boolean wasCrit) {
        int event;
        if (ownerWasHit) {
            event = 384;
            if (wasCrit) {
                event |= 0x200;
            }
        } else {
            event = 1;
            if (wasCrit) {
                event |= 2;
            }
        }
        this.onEvent(event, damage, target, null, (byte)-1);
    }

    public void onEvadedHit(L2Character attacker) {
        this.onEvent(8192, 0, attacker, null, (byte)-1);
    }

    public void onSkillHit(L2Character target, Skill skill, boolean ownerWasHit) {
        int event;
        if (ownerWasHit) {
            event = 1024;
            if (skill.isBad()) {
                event |= 0x800;
                event |= 0x80;
                event |= 0x100;
            } else {
                event |= 0x1000;
            }
        } else {
            event = 4;
            event |= skill.isMagic() ? 16 : 8;
            event |= skill.isBad() ? 64 : 32;
        }
        this.onEvent(event, 0, target, skill, skill.getElement());
    }

    public void onStart(byte element) {
        this.onEvent(16384, 0, this._owner, null, element);
    }

    public void onActionTime(byte element) {
        this.onEvent(32768, 0, this._owner, null, element);
    }

    public void onExit(byte element) {
        this.onEvent(65536, 0, this._owner, null, element);
    }

    public void onEvent(int event, int damage, L2Character target, Skill skill, byte element) {
        if (this._owner.isDead()) {
            return;
        }
        boolean playable = target instanceof L2Playable;
        FastMap.Entry e = this.head();
        FastMap.Entry end = this.tail();
        while ((e = e.getNext()) != end) {
            if (e.getValue() == null || !((ChanceCondition)e.getValue()).trigger(event, damage, element, playable, skill)) continue;
            if (e.getKey() instanceof Skill) {
                this._owner.makeTriggerCast((Skill)e.getKey(), target);
                continue;
            }
            this.makeCast((AbstractEffect)e.getKey(), target);
        }
    }

    private void makeCast(AbstractEffect effect, L2Character target) {
        try {
            L2Object[] targets;
            L2Character caster;
            if (effect == null || !effect.triggersChanceSkill()) {
                return;
            }
            Skill triggered = SkillData.getInstance().getSkill(effect.getTriggeredChanceId(), effect.getTriggeredChanceLevel());
            if (triggered == null) {
                return;
            }
            L2Character l2Character = caster = triggered.getTargetType() == L2TargetType.SELF ? this._owner : target;
            if (caster == null || caster.isSkillDisabled(triggered)) {
                return;
            }
            if (triggered.getReuseDelay() > 0) {
                caster.disableSkill(triggered, triggered.getReuseDelay());
            }
            if ((targets = triggered.getTargetList(caster, false, target)).length == 0) {
                return;
            }
            this._owner.broadcastPacket(new MagicSkillLaunched(this._owner, triggered.getDisplayId(), triggered.getDisplayLevel(), targets));
            this._owner.broadcastPacket(new MagicSkillUse(this._owner, target, triggered.getDisplayId(), triggered.getDisplayLevel(), 0, 0));
            triggered.activateSkill(caster, targets);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }
}

