/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.TerritoryTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;

public class L2GroupSpawn
extends L2Spawn {
    private final L2NpcTemplate _template;

    public L2GroupSpawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        super(mobTemplate);
        this._template = mobTemplate;
        this.setAmount(1);
    }

    public L2Npc doGroupSpawn() {
        try {
            int newlocz;
            int newlocy;
            int newlocx;
            if (this._template.isType("L2Pet") || this._template.isType("L2Minion")) {
                return null;
            }
            if (this.getX() == 0 && this.getY() == 0) {
                if (this.getLocationId() == 0) {
                    return null;
                }
                int[] p = TerritoryTable.getInstance().getRandomPoint(this.getLocationId());
                newlocx = p[0];
                newlocy = p[1];
                newlocz = p[2];
            } else {
                newlocx = this.getX();
                newlocy = this.getY();
                newlocz = this.getZ();
            }
            L2ControllableMobInstance mob = new L2ControllableMobInstance(IdFactory.getInstance().getNextId(), this._template);
            mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
            if (this.getHeading() == -1) {
                mob.setHeading(Rnd.nextInt(61794));
            } else {
                mob.setHeading(this.getHeading());
            }
            mob.setSpawn(this);
            mob.spawnMe(newlocx, newlocy, newlocz);
            ((L2Npc)mob).onSpawn();
            if (Config.DEBUG) {
                _log.finest("Spawned Mob Id: " + this._template.getId() + " ,at: X: " + mob.getX() + " Y: " + mob.getY() + " Z: " + mob.getZ());
            }
            return mob;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC class not found: " + e.getMessage(), e);
            return null;
        }
    }
}

