/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class L2PetData {
    private final Map<Integer, L2PetLevelData> _levelStats = new HashMap<Integer, L2PetLevelData>();
    private final List<L2PetSkillLearn> _skills = new ArrayList<L2PetSkillLearn>();
    private final int _npcId;
    private final int _itemId;
    private int _load = 20000;
    private int _hungryLimit = 1;
    private int _minlvl = 127;
    private boolean _syncLevel = false;
    private final List<Integer> _food = new ArrayList<Integer>();

    public L2PetData(int npcId, int itemId) {
        this._npcId = npcId;
        this._itemId = itemId;
    }

    public int getNpcId() {
        return this._npcId;
    }

    public int getItemId() {
        return this._itemId;
    }

    public void addNewStat(int level, L2PetLevelData data) {
        if (this._minlvl > level) {
            this._minlvl = level;
        }
        this._levelStats.put(level, data);
    }

    public L2PetLevelData getPetLevelData(int petLevel) {
        return this._levelStats.get(petLevel);
    }

    public int getLoad() {
        return this._load;
    }

    public int getHungryLimit() {
        return this._hungryLimit;
    }

    public boolean isSynchLevel() {
        return this._syncLevel;
    }

    public int getMinLevel() {
        return this._minlvl;
    }

    public List<Integer> getFood() {
        return this._food;
    }

    public void addFood(Integer foodId) {
        this._food.add(foodId);
    }

    public void setLoad(int load) {
        this._load = load;
    }

    public void setHungryLimit(int limit) {
        this._hungryLimit = limit;
    }

    public void setSyncLevel(boolean val) {
        this._syncLevel = val;
    }

    public void addNewSkill(int skillId, int skillLvl, int petLvl) {
        this._skills.add(new L2PetSkillLearn(skillId, skillLvl, petLvl));
    }

    public int getAvailableLevel(int skillId, int petLvl) {
        int lvl = 0;
        for (L2PetSkillLearn temp : this._skills) {
            if (temp.getSkillId() != skillId) continue;
            if (temp.getSkillLvl() == 0) {
                int maxLvl;
                if (petLvl < 70) {
                    lvl = petLvl / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (petLvl - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillData.getInstance().getMaxLevel(temp.getSkillId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > petLvl || temp.getSkillLvl() <= lvl) continue;
            lvl = temp.getSkillLvl();
        }
        return lvl;
    }

    public List<L2PetSkillLearn> getAvailableSkills() {
        return this._skills;
    }

    public static final class L2PetSkillLearn
    extends SkillHolder {
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            super(id, lvl);
            this._minLevel = minLvl;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

