/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.L2RecipeInstance;
import com.l2jserver.gameserver.model.L2RecipeStatInstance;
import com.l2jserver.gameserver.model.StatsSet;

public class L2RecipeList {
    private L2RecipeInstance[] _recipes = new L2RecipeInstance[0];
    private L2RecipeStatInstance[] _statUse = new L2RecipeStatInstance[0];
    private L2RecipeStatInstance[] _altStatChange = new L2RecipeStatInstance[0];
    private final int _id;
    private final int _level;
    private final int _recipeId;
    private final String _recipeName;
    private final int _successRate;
    private final int _itemId;
    private final int _count;
    private int _rareItemId;
    private int _rareCount;
    private int _rarity;
    private final boolean _isDwarvenRecipe;

    public L2RecipeList(StatsSet set, boolean haveRare) {
        this._id = set.getInt("id");
        this._level = set.getInt("craftLevel");
        this._recipeId = set.getInt("recipeId");
        this._recipeName = set.getString("recipeName");
        this._successRate = set.getInt("successRate");
        this._itemId = set.getInt("itemId");
        this._count = set.getInt("count");
        if (haveRare) {
            this._rareItemId = set.getInt("rareItemId");
            this._rareCount = set.getInt("rareCount");
            this._rarity = set.getInt("rarity");
        }
        this._isDwarvenRecipe = set.getBoolean("isDwarvenRecipe");
    }

    public void addRecipe(L2RecipeInstance recipe) {
        int len = this._recipes.length;
        L2RecipeInstance[] tmp = new L2RecipeInstance[len + 1];
        System.arraycopy(this._recipes, 0, tmp, 0, len);
        tmp[len] = recipe;
        this._recipes = tmp;
    }

    public void addStatUse(L2RecipeStatInstance statUse) {
        int len = this._statUse.length;
        L2RecipeStatInstance[] tmp = new L2RecipeStatInstance[len + 1];
        System.arraycopy(this._statUse, 0, tmp, 0, len);
        tmp[len] = statUse;
        this._statUse = tmp;
    }

    public void addAltStatChange(L2RecipeStatInstance statChange) {
        int len = this._altStatChange.length;
        L2RecipeStatInstance[] tmp = new L2RecipeStatInstance[len + 1];
        System.arraycopy(this._altStatChange, 0, tmp, 0, len);
        tmp[len] = statChange;
        this._altStatChange = tmp;
    }

    public int getId() {
        return this._id;
    }

    public int getLevel() {
        return this._level;
    }

    public int getRecipeId() {
        return this._recipeId;
    }

    public String getRecipeName() {
        return this._recipeName;
    }

    public int getSuccessRate() {
        return this._successRate;
    }

    public int getItemId() {
        return this._itemId;
    }

    public int getCount() {
        return this._count;
    }

    public int getRareItemId() {
        return this._rareItemId;
    }

    public int getRareCount() {
        return this._rareCount;
    }

    public int getRarity() {
        return this._rarity;
    }

    public boolean isDwarvenRecipe() {
        return this._isDwarvenRecipe;
    }

    public L2RecipeInstance[] getRecipes() {
        return this._recipes;
    }

    public L2RecipeStatInstance[] getStatUse() {
        return this._statUse;
    }

    public L2RecipeStatInstance[] getAltStatChange() {
        return this._altStatChange;
    }
}

