/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.L2AirShipAI;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.network.serverpackets.ExAirShipInfo;
import com.l2jserver.gameserver.network.serverpackets.ExGetOffAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExMoveToLocationAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExStopMoveAirShip;

public class L2AirShipInstance
extends L2Vehicle {
    public L2AirShipInstance(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2AirShipInstance);
        this.setAI(new L2AirShipAI(new L2Vehicle.AIAccessor()));
    }

    @Override
    public boolean isAirShip() {
        return true;
    }

    public boolean isOwner(L2PcInstance player) {
        return false;
    }

    public int getOwnerId() {
        return 0;
    }

    public boolean isCaptain(L2PcInstance player) {
        return false;
    }

    public int getCaptainId() {
        return 0;
    }

    public int getHelmObjectId() {
        return 0;
    }

    public int getHelmItemId() {
        return 0;
    }

    public boolean setCaptain(L2PcInstance player) {
        return false;
    }

    public int getFuel() {
        return 0;
    }

    public void setFuel(int f) {
    }

    public int getMaxFuel() {
        return 0;
    }

    public void setMaxFuel(int mf) {
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public boolean moveToNextRoutePoint() {
        boolean result = super.moveToNextRoutePoint();
        if (result) {
            this.broadcastPacket(new ExMoveToLocationAirShip(this));
        }
        return result;
    }

    @Override
    public boolean addPassenger(L2PcInstance player) {
        if (!super.addPassenger(player)) {
            return false;
        }
        player.setVehicle(this);
        player.setInVehiclePosition(new Location(0, 0, 0));
        player.broadcastPacket(new ExGetOnAirShip(player, this));
        player.getKnownList().removeAllKnownObjects();
        player.setXYZ(this.getX(), this.getY(), this.getZ());
        player.revalidateZone(true);
        return true;
    }

    @Override
    public void oustPlayer(L2PcInstance player) {
        super.oustPlayer(player);
        Location loc = this.getOustLoc();
        if (player.isOnline()) {
            player.broadcastPacket(new ExGetOffAirShip(player, this, loc.getX(), loc.getY(), loc.getZ()));
            player.getKnownList().removeAllKnownObjects();
            player.setXYZ(loc.getX(), loc.getY(), loc.getZ());
            player.revalidateZone(true);
        } else {
            player.setXYZInvisible(loc.getX(), loc.getY(), loc.getZ());
        }
    }

    @Override
    public boolean deleteMe() {
        if (!super.deleteMe()) {
            return false;
        }
        AirShipManager.getInstance().removeAirShip(this);
        return true;
    }

    @Override
    public void stopMove(Location loc, boolean updateKnownObjects) {
        super.stopMove(loc, updateKnownObjects);
        this.broadcastPacket(new ExStopMoveAirShip(this));
    }

    @Override
    public void updateAbnormalEffect() {
        this.broadcastPacket(new ExAirShipInfo(this));
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new ExAirShipInfo(this));
    }
}

