/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DecoyKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class L2DecoyInstance
extends L2Decoy {
    protected Skill _hateSpamSkill;
    private Future<?> _despawnTask;
    private Future<?> _hateSpamTask;

    public L2DecoyInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int despawnDelay) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2DecoyInstance);
        int skillLevel = this.getTemplate().getDisplayId() - 13070;
        this._hateSpamSkill = SkillData.getInstance().getSkill(5272, skillLevel);
        this._despawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new DespawnTask(), despawnDelay);
        this._hateSpamTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new HateSpam(), 2000L, 5000L);
    }

    protected void stopAllTasks() {
        if (this._hateSpamTask != null) {
            this._hateSpamTask.cancel(true);
            this._hateSpamTask = null;
        }
        if (this._despawnTask != null) {
            this._despawnTask.cancel(false);
            this._despawnTask = null;
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        this.stopAllTasks();
        if (!super.doDie(killer)) {
            return false;
        }
        DecayTaskManager.getInstance().add(this);
        return true;
    }

    @Override
    public DecoyKnownList getKnownList() {
        return (DecoyKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DecoyKnownList(this));
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        this.stopAllTasks();
        super.unSummon(owner);
    }

    protected class HateSpam
    implements Runnable {
        protected HateSpam() {
        }

        @Override
        public void run() {
            try {
                L2DecoyInstance me = L2DecoyInstance.this;
                L2DecoyInstance.this.setTarget(me);
                L2DecoyInstance.this.doCast(L2DecoyInstance.this._hateSpamSkill);
            }
            catch (Throwable e) {
                L2Character._log.log(Level.SEVERE, "Decoy Error: ", e);
            }
        }
    }

    protected class DespawnTask
    implements Runnable {
        protected DespawnTask() {
        }

        @Override
        public void run() {
            L2DecoyInstance.this.unSummon(L2DecoyInstance.this.getOwner());
        }
    }
}

