/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Tower;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import java.util.List;

public class L2FlameTowerInstance
extends L2Tower {
    private int _upgradeLevel = 0;
    private List<Integer> _zoneList;

    public L2FlameTowerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2FlameTowerInstance);
    }

    @Override
    public boolean doDie(L2Character killer) {
        this.enableZones(false);
        return super.doDie(killer);
    }

    @Override
    public boolean deleteMe() {
        this.enableZones(false);
        return super.deleteMe();
    }

    public final void enableZones(boolean state) {
        if (this._zoneList != null && this._upgradeLevel != 0) {
            int maxIndex = this._upgradeLevel * 2;
            for (int i = 0; i < maxIndex; ++i) {
                L2ZoneType zone = ZoneManager.getInstance().getZoneById(this._zoneList.get(i));
                if (zone == null) continue;
                zone.setEnabled(state);
            }
        }
    }

    public final void setUpgradeLevel(int level) {
        this._upgradeLevel = level;
    }

    public final void setZoneList(List<Integer> list) {
        this._zoneList = list;
        this.enableZones(true);
    }
}

