/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.GuardKnownList;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.logging.Logger;

public class L2GuardInstance
extends L2Attackable {
    private static Logger _log = Logger.getLogger(L2GuardInstance.class.getName());

    public L2GuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2GuardInstance);
    }

    @Override
    public final GuardKnownList getKnownList() {
        return (GuardKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new GuardKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return attacker instanceof L2MonsterInstance;
    }

    @Override
    public boolean isMob() {
        return false;
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2GuardAI(new L2Character.AIAccessor());
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/guard/", npcId, val);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this.getObjectId() != player.getTargetId()) {
            player.setTarget(this);
        } else if (interact) {
            if (this.containsTarget(player)) {
                if (Config.DEBUG) {
                    _log.fine(player.getObjectId() + ": Attacked guard " + this.getObjectId());
                }
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else if (!this.canInteract(player)) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
            } else {
                this.broadcastPacket(new SocialAction(this.getObjectId(), Rnd.nextInt(8)));
                player.setLastFolkNPC(this);
                List<Quest> qlsa = this.getTemplate().getEventQuests(QuestEventType.QUEST_START);
                List<Quest> qlst = this.getTemplate().getEventQuests(QuestEventType.ON_FIRST_TALK);
                if (qlsa != null && !qlsa.isEmpty()) {
                    player.setLastQuestNpcObject(this.getObjectId());
                }
                if (qlst != null && qlst.size() == 1) {
                    qlst.get(0).notifyFirstTalk(this, player);
                } else {
                    this.showChatWindow(player, 0);
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public static class L2GuardAI
    extends L2AttackableAI {
        public L2GuardAI(L2Character.AIAccessor accessor) {
            super(accessor);
        }

        public void returnHome() {
            L2GuardInstance npc = (L2GuardInstance)this.getActor();
            ILocational p = npc.getSpawnPoint();
            int x1 = p.getX();
            int y1 = p.getY();
            int z1 = p.getZ();
            if (npc.getX() != x1 || npc.getY() != y1) {
                if (npc.isReturningToSpawnPoint() && npc.isRunning() && npc.isMoving() && npc.getXdestination() == x1 && npc.getYdestination() == y1) {
                    return;
                }
                npc.setisReturningToSpawnPoint(true);
                npc.setRunning();
                this.moveTo(x1, y1, z1);
            } else {
                int h1 = npc.getSpawn().getHeading();
                if (npc.getHeading() != h1) {
                    for (L2PcInstance pc : npc.getKnownList().getKnownPlayers().values()) {
                        if (pc.getKarma() <= 0) continue;
                        return;
                    }
                    npc.setHeading(h1);
                    npc.broadcastPacket(new ValidateLocation(npc));
                    npc.setAI(null);
                }
            }
        }
    }
}

