/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharSummonTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SummonEffectsTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SetSummonRemainTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import gnu.trove.list.array.TIntArrayList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class L2ServitorInstance
extends L2Summon
implements Runnable {
    protected static final Logger log = Logger.getLogger(L2ServitorInstance.class.getName());
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_summon_skills_save (ownerId,ownerClassIndex,summonSkillId,skill_id,skill_level,remaining_time,buff_index) VALUES (?,?,?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT skill_id,skill_level,remaining_time,buff_index FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=? ORDER BY buff_index ASC";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_summon_skills_save WHERE ownerId=? AND ownerClassIndex=? AND summonSkillId=?";
    private float _expMultiplier = 0.0f;
    private ItemHolder _itemConsume;
    private int _lifeTime;
    private int _lifeTimeRemaining;
    private int _consumeItemInterval;
    private int _consumeItemIntervalRemaining;
    protected Future<?> _summonLifeTask;
    private int _referenceSkill;

    public L2ServitorInstance(int objectId, L2NpcTemplate template, L2PcInstance owner) {
        super(objectId, template, owner);
        this.setInstanceType(InstanceType.L2ServitorInstance);
        this.setShowSummonAnimation(true);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this._summonLifeTask == null) {
            this._summonLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, 0L, 5000L);
        }
    }

    public final void cancelLifeTask() {
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(false);
            this._summonLifeTask = null;
        }
    }

    @Override
    public final int getLevel() {
        return this.getTemplate() != null ? (int)this.getTemplate().getLevel() : 0;
    }

    @Override
    public int getSummonType() {
        return 1;
    }

    public void setExpMultiplier(float expMultiplier) {
        this._expMultiplier = expMultiplier;
    }

    public float getExpMultiplier() {
        return this._expMultiplier;
    }

    public void setExpPenalty(float expPenalty) {
        this.setExpMultiplier(expPenalty);
    }

    public void setItemConsume(ItemHolder item) {
        this._itemConsume = item;
    }

    public ItemHolder getItemConsume() {
        return this._itemConsume;
    }

    public void setItemConsumeInterval(int interval) {
        this._consumeItemInterval = this._consumeItemIntervalRemaining = interval;
    }

    public int getItemConsumeInterval() {
        return this._consumeItemInterval;
    }

    public void setLifeTime(int lifeTime) {
        this._lifeTime = this._lifeTimeRemaining = lifeTime;
    }

    public int getLifeTime() {
        return this._lifeTime;
    }

    public int getTotalLifeTime() {
        return this.getLifeTime();
    }

    public void setLifeTimeRemaining(int time) {
        this._lifeTimeRemaining = time;
    }

    public int getLifeTimeRemaining() {
        return this._lifeTimeRemaining;
    }

    public int getTimeRemaining() {
        return this.getLifeTimeRemaining();
    }

    public void decTimeRemaining(int value) {
        this._lifeTimeRemaining -= value;
    }

    public void setReferenceSkill(int skillId) {
        this._referenceSkill = skillId;
    }

    public int getReferenceSkill() {
        return this._referenceSkill;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.cancelLifeTask();
        CharSummonTable.getInstance().removeServitor(this.getOwner());
        return true;
    }

    @Override
    public void doCast(Skill skill) {
        Skill skillToCast;
        int petLevel = this.getLevel();
        int skillLevel = petLevel / 10;
        if (petLevel >= 70) {
            skillLevel += (petLevel - 65) / 10;
        }
        if (skillLevel < 1) {
            skillLevel = 1;
        }
        if ((skillToCast = SkillData.getInstance().getSkill(skill.getId(), skillLevel)) != null) {
            super.doCast(skillToCast);
        } else {
            super.doCast(skill);
        }
    }

    @Override
    public void setRestoreSummon(boolean val) {
        this._restoreSummon = val;
    }

    @Override
    public final void stopSkillEffects(boolean removed, int skillId) {
        List effects;
        super.stopSkillEffects(removed, skillId);
        FastIntObjectMap<List<SummonEffectsTable.SummonEffect>> servitorEffects = SummonEffectsTable.getInstance().getServitorEffects(this.getOwner());
        if (servitorEffects != null && (effects = (List)servitorEffects.get(this.getReferenceSkill())) != null && !effects.isEmpty()) {
            for (SummonEffectsTable.SummonEffect effect : effects) {
                Skill skill = effect.getSkill();
                if (skill == null || skill.getId() != skillId) continue;
                effects.remove(effect);
            }
        }
    }

    @Override
    public void storeMe() {
        if (this._referenceSkill == 0 || this.isDead()) {
            return;
        }
        if (Config.RESTORE_SERVITOR_ON_RECONNECT) {
            CharSummonTable.getInstance().saveSummon(this);
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        block45: {
            if (!Config.SUMMON_STORE_SKILL_COOLTIME) {
                return;
            }
            if (this.getOwner() == null || this.getOwner().isInOlympiadMode()) {
                return;
            }
            List servitorEffects = null;
            FastIntObjectMap servitorEffectsOwner = (FastIntObjectMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId());
            if (servitorEffectsOwner != null && servitorEffectsOwner.containsKey(this.getOwner().getClassIndex()) && (servitorEffects = (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill())) != null) {
                servitorEffects.clear();
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(DELETE_SKILL_SAVE);){
                statement.setInt(1, this.getOwner().getObjectId());
                statement.setInt(2, this.getOwner().getClassIndex());
                statement.setInt(3, this.getReferenceSkill());
                statement.execute();
                int buff_index = 0;
                TIntArrayList storedSkills = new TIntArrayList();
                if (!storeEffects) break block45;
                try (PreparedStatement ps2 = con.prepareStatement(ADD_SKILL_SAVE);){
                    for (BuffInfo info : this.getEffectList().getEffects()) {
                        Skill skill;
                        if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Config.ALT_STORE_DANCES || storedSkills.contains(skill.getReuseHashCode())) continue;
                        storedSkills.add(skill.getReuseHashCode());
                        ps2.setInt(1, this.getOwner().getObjectId());
                        ps2.setInt(2, this.getOwner().getClassIndex());
                        ps2.setInt(3, this.getReferenceSkill());
                        ps2.setInt(4, skill.getId());
                        ps2.setInt(5, skill.getLevel());
                        ps2.setInt(6, info.getTime());
                        ps2.setInt(7, ++buff_index);
                        ps2.execute();
                        if (servitorEffectsOwner == null) {
                            servitorEffectsOwner = new FastIntObjectMap();
                            SummonEffectsTable.getInstance().getServitorEffectsOwner().put(this.getOwner().getObjectId(), (Object)servitorEffectsOwner);
                        }
                        if (!servitorEffectsOwner.containsKey(this.getOwner().getClassIndex())) {
                            servitorEffectsOwner.put(this.getOwner().getClassIndex(), (Object)new FastIntObjectMap());
                        }
                        if (servitorEffects == null) {
                            servitorEffects = new FastList();
                            SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).put(this.getReferenceSkill(), (Object)servitorEffects);
                        }
                        SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                        summonEffectsTable.getClass();
                        servitorEffects.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, info.getTime()));
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not store summon effect data: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreEffects() {
        block61: {
            if (this.getOwner().isInOlympiadMode()) {
                return;
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                Throwable throwable;
                PreparedStatement statement;
                List servitorEffects = null;
                FastIntObjectMap servitorEffectsOwner = (FastIntObjectMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId());
                if (servitorEffectsOwner == null || !servitorEffectsOwner.containsKey(this.getOwner().getClassIndex()) || (servitorEffects = (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill())) == null) {
                    statement = con.prepareStatement(RESTORE_SKILL_SAVE);
                    throwable = null;
                    try {
                        statement.setInt(1, this.getOwner().getObjectId());
                        statement.setInt(2, this.getOwner().getClassIndex());
                        statement.setInt(3, this.getReferenceSkill());
                        try (ResultSet rset = statement.executeQuery();){
                            while (rset.next()) {
                                int effectCurTime = rset.getInt("remaining_time");
                                Skill skill = SkillData.getInstance().getSkill(rset.getInt("skill_id"), rset.getInt("skill_level"));
                                if (skill == null || !skill.hasEffects(EffectScope.GENERAL)) continue;
                                if (servitorEffectsOwner == null) {
                                    servitorEffectsOwner = new FastIntObjectMap();
                                    SummonEffectsTable.getInstance().getServitorEffectsOwner().put(this.getOwner().getObjectId(), (Object)servitorEffectsOwner);
                                }
                                if (!servitorEffectsOwner.containsKey(this.getOwner().getClassIndex())) {
                                    servitorEffectsOwner.put(this.getOwner().getClassIndex(), (Object)new FastIntObjectMap());
                                }
                                if (servitorEffects == null) {
                                    servitorEffects = new FastList();
                                    SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).put(this.getReferenceSkill(), (Object)servitorEffects);
                                }
                                SummonEffectsTable summonEffectsTable = SummonEffectsTable.getInstance();
                                summonEffectsTable.getClass();
                                servitorEffects.add(summonEffectsTable.new SummonEffectsTable.SummonEffect(skill, effectCurTime));
                            }
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (statement != null) {
                            if (throwable != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                statement.close();
                            }
                        }
                    }
                }
                statement = con.prepareStatement(DELETE_SKILL_SAVE);
                throwable = null;
                try {
                    statement.setInt(1, this.getOwner().getObjectId());
                    statement.setInt(2, this.getOwner().getClassIndex());
                    statement.setInt(3, this.getReferenceSkill());
                    statement.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement != null) {
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            statement.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not restore " + this + " active effect data: " + e.getMessage(), e);
            }
            finally {
                List servitorEffects;
                FastIntObjectMap servitorEffectsOwner = (FastIntObjectMap)SummonEffectsTable.getInstance().getServitorEffectsOwner().get(this.getOwner().getObjectId());
                if (servitorEffectsOwner == null || !servitorEffectsOwner.containsKey(this.getOwner().getClassIndex()) || (servitorEffects = (List)SummonEffectsTable.getInstance().getServitorEffects(this.getOwner()).get(this.getReferenceSkill())) == null) break block61;
                for (SummonEffectsTable.SummonEffect se : servitorEffects) {
                    if (se == null) continue;
                    se.getSkill().applyEffects(this, this, false, se.getEffectCurTime());
                }
            }
        }
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        this.cancelLifeTask();
        super.unSummon(owner);
        if (!this._restoreSummon) {
            CharSummonTable.getInstance().removeServitor(owner);
        }
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItem(process, objectId, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItemByItemId(process, itemId, count, reference, sendMessage);
    }

    @Override
    public byte getAttackElement() {
        if (this.getOwner() != null) {
            return this.getOwner().getAttackElement();
        }
        return super.getAttackElement();
    }

    @Override
    public int getAttackElementValue(byte attackAttribute) {
        if (this.getOwner() != null) {
            return this.getOwner().getAttackElementValue(attackAttribute);
        }
        return super.getAttackElementValue(attackAttribute);
    }

    @Override
    public int getDefenseElementValue(byte defenseAttribute) {
        if (this.getOwner() != null) {
            return this.getOwner().getDefenseElementValue(defenseAttribute);
        }
        return super.getDefenseElementValue(defenseAttribute);
    }

    @Override
    public boolean isServitor() {
        return true;
    }

    @Override
    public void run() {
        int newConsumeCountDown;
        int usedtime = 5000;
        int newTimeRemaining = this._lifeTimeRemaining -= usedtime;
        if (this.isDead() || !this.isVisible()) {
            this.cancelLifeTask();
            return;
        }
        if (newTimeRemaining < 0) {
            this.sendPacket(SystemMessageId.SERVITOR_PASSED_AWAY);
            this.unSummon(this.getOwner());
            return;
        }
        if (this._consumeItemInterval > 0 && (newConsumeCountDown = (this._consumeItemIntervalRemaining -= usedtime)) <= 0 && this.getItemConsume().getCount() > 0L && this.getItemConsume().getId() > 0 && !this.isDead()) {
            if (this.destroyItemByItemId("Consume", this.getItemConsume().getId(), this.getItemConsume().getCount(), this, false)) {
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.SUMMONED_MOB_USES_S1);
                msg.addItemName(this.getItemConsume().getId());
                this.sendPacket(msg);
                this._consumeItemIntervalRemaining = this._consumeItemInterval;
            } else {
                this.sendPacket(SystemMessageId.SERVITOR_DISAPPEARED_NOT_ENOUGH_ITEMS);
                this.unSummon(this.getOwner());
            }
        }
        this.sendPacket(new SetSummonRemainTime(this.getLifeTime(), newTimeRemaining));
        this.updateEffectIcons();
    }
}

