/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FeedableBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.Future;

public final class L2TamedBeastInstance
extends L2FeedableBeastInstance {
    private static final boolean AUTO_CHAT = true;
    private static final boolean AUTO_BUFF = true;
    private static final boolean AUTO_DEBUFF = true;
    private static final boolean AUTO_HEAL = true;
    private int _foodSkillId;
    private static final int MAX_DISTANCE_FROM_OWNER = 2000;
    private static final int MAX_DURATION = 1200000;
    private static final int DURATION_CHECK_INTERVAL = 60000;
    private static final int DURATION_INCREASE_INTERVAL = 20000;
    private static final int BUFF_INTERVAL = 5000;
    private int _remainingTime = 1200000;
    protected L2PcInstance _owner;
    public int nameId = -1;
    public String nameParam = null;
    private Future<?> _buffTask = null;
    private Future<?> _durationCheckTask = null;
    protected boolean _isFreyaBeast;
    protected boolean _hasDeBuffSkill;
    protected boolean _hasHealSkill;
    protected long _chatTime;
    protected int _chatIndex;
    protected static int[] AUTO_CHAT_TEXT = new int[]{2029, 2030, 2031, 2032, 2033, 2034, 2035, 2036, 2037, 2038};

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2TamedBeastInstance);
    }

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int foodSkillId, int x, int y, int z) {
        super(objectId, template);
        this._isFreyaBeast = false;
        this.setInstanceType(InstanceType.L2TamedBeastInstance);
        this.setCurrentHp(this.getMaxHp());
        this.setCurrentMp(this.getMaxMp());
        this.setFoodType(foodSkillId);
        this.spawnMe(x, y, z);
        this.setOwner(owner);
        this.startOwnerBuffs();
    }

    public L2TamedBeastInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, int food, int x, int y, int z, boolean isFreyaBeast) {
        super(objectId, template);
        this._isFreyaBeast = isFreyaBeast;
        this.setInstanceType(InstanceType.L2TamedBeastInstance);
        this.setCurrentHp(this.getMaxHp());
        this.setCurrentMp(this.getMaxMp());
        this.setFoodType(food);
        this.spawnMe(x, y, z);
        this.setOwner(owner);
        if (isFreyaBeast) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this._owner);
        }
    }

    public void onReceiveFood() {
        this._remainingTime += 20000;
        if (this._remainingTime > 1200000) {
            this._remainingTime = 1200000;
        }
    }

    public int getRemainingTime() {
        return this._remainingTime;
    }

    public void setRemainingTime(int duration) {
        this._remainingTime = duration;
    }

    public int getFoodType() {
        return this._foodSkillId;
    }

    public void setFoodType(int foodItemId) {
        if (foodItemId > 0) {
            this._foodSkillId = foodItemId;
            if (this._durationCheckTask != null) {
                this._durationCheckTask.cancel(true);
            }
            this._durationCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckDuration(), 60000L, 60000L);
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        List<L2TamedBeastInstance> trainedBeasts;
        if (!super.doDie(killer)) {
            return false;
        }
        this.getAI().stopFollow();
        if (this._buffTask != null) {
            this._buffTask.cancel(true);
        }
        if (this._durationCheckTask != null) {
            this._durationCheckTask.cancel(true);
        }
        if (this._owner != null && (trainedBeasts = this._owner.getTrainedBeasts()) != null) {
            trainedBeasts.remove(this);
        }
        this._buffTask = null;
        this._durationCheckTask = null;
        this._owner = null;
        this._foodSkillId = 0;
        this._remainingTime = 0;
        return true;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !this._isFreyaBeast;
    }

    private boolean canAutoBuff() {
        return true;
    }

    private boolean canAutoDeBuff() {
        return true;
    }

    private boolean canAutoHeal() {
        return true;
    }

    private boolean hasDeBuffSkill() {
        if (this.canAutoDeBuff()) {
            for (Skill skill : this.getSkills().values()) {
                if (!L2TamedBeastInstance.isDeBuffSkill(skill)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasHealSkill() {
        if (this.canAutoHeal()) {
            for (Skill skill : this.getSkills().values()) {
                if (!L2TamedBeastInstance.isHealSkill(skill)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isBuffSkill(Skill skill) {
        return skill.isBuff();
    }

    protected static boolean isDeBuffSkill(Skill skill) {
        return skill.isDebuff();
    }

    protected static boolean isHealSkill(Skill skill) {
        return skill.hasEffectType(L2EffectType.CPHEAL, L2EffectType.HEAL, L2EffectType.HEAL_PERCENT, L2EffectType.MANAHEAL_BY_LEVEL, L2EffectType.MANAHEAL_PERCENT);
    }

    @Override
    public Skill addSkill(Skill newSkill) {
        Skill oldSkill = super.addSkill(newSkill);
        this._hasDeBuffSkill = this.hasDeBuffSkill();
        this._hasHealSkill = this.hasHealSkill();
        return oldSkill;
    }

    public void removeBuffSkills() {
        for (Skill skill : this.getSkills().values()) {
            if (!L2TamedBeastInstance.isBuffSkill(skill)) continue;
            this.removeSkill(skill.getId());
        }
    }

    public static void useSkill(L2Character activeChar, Skill skill, L2Object[] targets) {
        if (!activeChar.isPlayer()) {
            return;
        }
        L2PcInstance player = activeChar.getActingPlayer();
        L2Object target = player.getTarget();
        switch (skill.getId()) {
            case 2188: 
            case 2189: {
                break;
            }
            case 8362: {
                L2TamedBeastInstance beast;
                if (!(target instanceof L2TamedBeastInstance) || (beast = (L2TamedBeastInstance)target).getOwner() != player) break;
                beast.deleteMe();
                break;
            }
            case 8378: {
                List<L2TamedBeastInstance> trainedBeasts = player.getTrainedBeasts();
                if (trainedBeasts == null) break;
                for (L2TamedBeastInstance beast : trainedBeasts) {
                    beast.deleteMe();
                }
                break;
            }
            case 8363: {
                int size;
                double AVOID_RADIUS = 64.0;
                double AVOID_ANGLE = 0.5235987755982988;
                List<L2TamedBeastInstance> trainedBeasts = player.getTrainedBeasts();
                if (trainedBeasts == null || (size = trainedBeasts.size()) < 2 || !trainedBeasts.contains(target)) break;
                int ownerX = player.getX();
                int ownerY = player.getY();
                int ownerZ = player.getZ();
                double angle = target == player ? Util.convertHeadingToRadian(player.getHeading()) : Math.atan2(target.getY() - ownerY, target.getX() - ownerX);
                angle -= 0.5235987755982988 * (double)size / 2.0;
                for (L2TamedBeastInstance beast : trainedBeasts) {
                    if (!beast.isVisible() || beast.isDead() || beast.isMovementDisabled() || beast.isMoving()) continue;
                    int x = ownerX + (int)(64.0 * Math.cos(angle));
                    int y = ownerY + (int)(64.0 * Math.sin(angle));
                    int z = ownerZ;
                    if (x != beast.getX() && y != beast.getY()) {
                        beast.setXYZ(x, y, z);
                        player.sendPacket(new ValidateLocation(beast));
                    }
                    beast.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, player);
                    angle += 0.5235987755982988;
                }
                break;
            }
            case 8364: {
                L2TamedBeastInstance beast;
                if (!(target instanceof L2TamedBeastInstance) || (beast = (L2TamedBeastInstance)target).getOwner() != player) break;
                beast.castBeastSkills();
                break;
            }
            default: {
                throw new RuntimeException("useSkill(" + activeChar + "," + skill + "," + (targets.length == 0 ? "EMPTY" : targets[0]) + ")");
            }
        }
    }

    private void castBeastSkills() {
        if (this._owner == null) {
            return;
        }
        int delay = 100;
        boolean done = false;
        for (Skill skill : this.getSkills().values()) {
            if (!L2TamedBeastInstance.isBuffSkill(skill) || this.isSkillDisabled(skill)) continue;
            final Skill _skill = skill;
            ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                @Override
                public void run() {
                    L2TamedBeastInstance.this.sitCastAndFollow(_skill, L2TamedBeastInstance.this._owner);
                }
            }, delay);
            delay += 100 + skill.getHitTime();
            done = true;
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                L2TamedBeastInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, L2TamedBeastInstance.this._owner);
            }
        }, delay);
        if (!done) {
            this._owner.sendMessage("\u6761\u4ef6\u304c\u5408\u308f\u306a\u3044\u305f\u3081\u3001\u80fd\u529b\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002");
        }
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    private void setOwner(L2PcInstance owner) {
        if (owner != null) {
            this._owner = owner;
            this.setTitle(owner.getName());
            this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, owner));
            owner.addTrainedBeast(this);
            this.getAI().startFollow(this._owner, 100);
            this._hasDeBuffSkill = this.hasDeBuffSkill();
            this._hasHealSkill = this.hasHealSkill();
        } else {
            this.deleteMe();
        }
    }

    public void startOwnerBuffs() {
        if (this.canAutoBuff()) {
            if (this._buffTask != null) {
                this._buffTask.cancel(true);
            }
            this._buffTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckOwnerBuffs(), 30000L, 5000L);
        }
    }

    @Override
    public boolean deleteMe() {
        if (this._buffTask != null) {
            this._buffTask.cancel(true);
        }
        this._durationCheckTask.cancel(true);
        this.stopHpMpRegeneration();
        if (this._owner != null && this._owner.getTrainedBeasts() != null) {
            this._owner.getTrainedBeasts().remove(this);
        }
        this.setTarget(null);
        this._buffTask = null;
        this._durationCheckTask = null;
        this._owner = null;
        this._foodSkillId = 0;
        this._remainingTime = 0;
        return super.deleteMe();
    }

    public void onOwnerGotAttacked(L2Character attacker) {
        block10: {
            double HPRatio;
            block11: {
                if (this._owner == null || !this._owner.isOnline()) {
                    this.deleteMe();
                    return;
                }
                if (!this._owner.isInsideRadius(this, 2000, true, true)) {
                    if (!this.isMoving()) {
                        this.getAI().startFollow(this._owner);
                    }
                    return;
                }
                if (!this._hasDeBuffSkill && !this._hasHealSkill) {
                    return;
                }
                if (this._owner.isDead()) {
                    return;
                }
                if (this.isCastingNow()) {
                    return;
                }
                HPRatio = this._owner.getCurrentHp() / (double)this._owner.getMaxHp();
                if (!(HPRatio >= 0.8)) break block11;
                if (attacker == null || this.getCurrentHp() != (double)this.getMaxHp()) break block10;
                for (Skill skill : this.getSkills().values()) {
                    if (!L2TamedBeastInstance.isDeBuffSkill(skill) || this.isSkillDisabled(skill) || Rnd.get(3) >= 1 || attacker.isAffectedBySkill(skill.getId())) continue;
                    this.sitCastAndFollow(skill, attacker);
                    break block10;
                }
                break block10;
            }
            if (HPRatio < 0.5) {
                int chance = 1;
                if (HPRatio < 0.25) {
                    chance = 2;
                }
                for (Skill skill : this.getSkills().values()) {
                    if (Rnd.get(5) >= chance || !L2TamedBeastInstance.isHealSkill(skill) || this.isSkillDisabled(skill)) continue;
                    this.sitCastAndFollow(skill, this._owner);
                    break;
                }
            }
        }
    }

    protected void sitCastAndFollow(Skill skill, L2Character target) {
        this.stopMove(null);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        this.setTarget(target);
        this.doCast(skill);
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, this._owner);
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null || !this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
        } else if (interact) {
            if (this.isAutoAttackable(player) && Math.abs(player.getZ() - this.getZ()) < 100) {
                player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
            } else {
                player.sendPacket(ActionFailed.STATIC_PACKET);
            }
        }
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2TamedBeastAI(new L2Character.AIAccessor());
    }

    protected class L2TamedBeastAI
    extends L2AttackableAI {
        public L2TamedBeastAI(L2Character.AIAccessor accessor) {
            super(accessor);
        }

        @Override
        protected void onEvtArrived() {
            L2PcInstance owner;
            super.onEvtArrived();
            if (this.getIntention() == CtrlIntention.AI_INTENTION_FOLLOW && (owner = L2TamedBeastInstance.this.getOwner()) == this.getFollowTarget() && owner.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                double AVOID_ANGLE = 0.5235987755982988;
                List<L2TamedBeastInstance> trainedBeasts = owner.getTrainedBeasts();
                int size = trainedBeasts.size();
                if (size >= 2) {
                    L2TamedBeastInstance beast = (L2TamedBeastInstance)this.getActor();
                    double distance = Math.max(64.0, owner.calculateDistance(beast, false, false));
                    int index = trainedBeasts.indexOf(beast);
                    double angle = Util.convertHeadingToRadian(owner.getHeading()) + Math.PI - 0.5235987755982988 * (double)size / 2.0 + 0.5235987755982988 * (double)index;
                    int x = owner.getX() + (int)(distance * Math.cos(angle));
                    int y = owner.getY() + (int)(distance * Math.sin(angle));
                    int z = owner.getZ();
                    if (x != beast.getX() && y != beast.getY()) {
                        beast.setXYZ(x, y, z);
                        owner.sendPacket(new ValidateLocation(beast));
                    }
                }
            }
        }
    }

    protected class CheckOwnerBuffs
    implements Runnable {
        private final int _numBuffs;
        private final int _limitBuffs;

        protected CheckOwnerBuffs() {
            int totalBuffsAvailable = 0;
            for (Skill skill : L2TamedBeastInstance.this.getSkills().values()) {
                if (!L2TamedBeastInstance.isBuffSkill(skill)) continue;
                ++totalBuffsAvailable;
            }
            int limitBuffs = totalBuffsAvailable >= 3 ? totalBuffsAvailable * 2 / 3 : totalBuffsAvailable;
            this._numBuffs = totalBuffsAvailable;
            this._limitBuffs = limitBuffs;
        }

        @Override
        public void run() {
            L2PcInstance owner = L2TamedBeastInstance.this.getOwner();
            if (owner == null || !owner.isOnline()) {
                L2TamedBeastInstance.this.deleteMe();
                return;
            }
            if (!L2TamedBeastInstance.this.isInsideRadius(owner, 2000, true, true)) {
                L2TamedBeastInstance.this.getAI().startFollow(owner);
                return;
            }
            if (owner.isDead()) {
                return;
            }
            if (L2TamedBeastInstance.this.isCastingNow()) {
                return;
            }
            int totalBuffsOnOwner = 0;
            int i = 0;
            int rand = Rnd.get(this._numBuffs);
            Skill buffToGive = null;
            for (Skill skill : L2TamedBeastInstance.this.getSkills().values()) {
                if (!L2TamedBeastInstance.isBuffSkill(skill)) continue;
                if (owner.isAffectedBySkill(skill.getId())) {
                    ++totalBuffsOnOwner;
                } else if (i == rand && !L2TamedBeastInstance.this.isSkillDisabled(skill)) {
                    buffToGive = skill;
                }
                ++i;
            }
            if (buffToGive != null && totalBuffsOnOwner < this._limitBuffs) {
                L2TamedBeastInstance.this.sitCastAndFollow(buffToGive, owner);
            } else {
                L2TamedBeastInstance.this.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, L2TamedBeastInstance.this.getOwner());
            }
        }
    }

    protected class CheckDuration
    implements Runnable {
        protected CheckDuration() {
        }

        @Override
        public void run() {
            L2TamedBeastInstance _tamedBeast = L2TamedBeastInstance.this;
            int foodTypeSkillId = _tamedBeast.getFoodType();
            L2PcInstance owner = _tamedBeast.getOwner();
            L2ItemInstance item = null;
            if (_tamedBeast._isFreyaBeast) {
                item = owner.getInventory().getItemByItemId(foodTypeSkillId);
                if (item != null && item.getCount() >= 1L) {
                    owner.destroyItem("BeastMob", item, 1L, (L2Object)_tamedBeast, true);
                    _tamedBeast.broadcastPacket(new SocialAction(_tamedBeast.getObjectId(), 3));
                } else {
                    _tamedBeast.deleteMe();
                }
            } else {
                _tamedBeast.setRemainingTime(_tamedBeast.getRemainingTime() - 60000);
                if (foodTypeSkillId == 2188) {
                    item = owner.getInventory().getItemByItemId(6643);
                } else if (foodTypeSkillId == 2189) {
                    item = owner.getInventory().getItemByItemId(6644);
                }
                if (item != null && item.getCount() >= 1L) {
                    L2Object oldTarget = owner.getTarget();
                    owner.setTarget(_tamedBeast);
                    L2Object[] targets = new L2Object[]{_tamedBeast};
                    owner.callSkill(SkillData.getInstance().getSkill(foodTypeSkillId, 1), targets);
                    owner.setTarget(oldTarget);
                } else if (_tamedBeast.getRemainingTime() < 900000) {
                    _tamedBeast.setRemainingTime(-1);
                }
                if (_tamedBeast.getRemainingTime() <= 0) {
                    _tamedBeast.deleteMe();
                }
            }
            long now = System.currentTimeMillis();
            if (now > L2TamedBeastInstance.this._chatTime) {
                int chatIndex;
                L2TamedBeastInstance.this._chatTime = now + (long)(Rnd.get(30000, 120000) * _tamedBeast.getOwner().getTrainedBeasts().size());
                while ((chatIndex = Rnd.get(AUTO_CHAT_TEXT.length)) == L2TamedBeastInstance.this._chatIndex) {
                }
                L2TamedBeastInstance.this._chatIndex = chatIndex;
                _tamedBeast.broadcastPacket(new NpcSay((L2Npc)_tamedBeast, 0, AUTO_CHAT_TEXT[chatIndex]));
            }
        }
    }
}

