/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.knownlist.NpcKnownList;

public class AttackableKnownList
extends NpcKnownList {
    public AttackableKnownList(L2Attackable activeChar) {
        super(activeChar);
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (object instanceof L2Character) {
            this.getActiveChar().getAggroList().remove(object);
        }
        if (this.getActiveChar().hasAI() && this.getKnownPlayers().isEmpty() && !this.getActiveChar().isWalker()) {
            this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
        return true;
    }

    @Override
    public L2Attackable getActiveChar() {
        return (L2Attackable)this._activeObject;
    }

    @Override
    public int getDistanceToForgetObject(L2Object object) {
        return this.getDistanceToWatchObject(object) * 3 / 2;
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2Character)) {
            return 0;
        }
        if (object.isPlayable()) {
            return object.getKnownList().getDistanceToWatchObject(this.getActiveObject());
        }
        return this.getActiveChar().getTemplate().getKnownRange();
    }
}

