/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.status;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.CharStat;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;

public class CharStatus {
    protected static final Logger _log = Logger.getLogger(CharStatus.class.getName());
    protected final L2Character _activeChar;
    private double _currentHp = 0.0;
    private double _currentMp = 0.0;
    private Set<L2Character> _StatusListener;
    private Future<?> _regTask;
    protected byte _flagsRegenActive = 0;
    private boolean _hpReduced;
    protected static final byte REGEN_FLAG_CP = 4;
    private static final byte REGEN_FLAG_HP = 1;
    private static final byte REGEN_FLAG_MP = 2;

    public CharStatus(L2Character activeChar) {
        this._activeChar = activeChar;
    }

    public final void addStatusListener(L2Character object) {
        if (object == this.getActiveChar()) {
            return;
        }
        this.getStatusListener().add(object);
    }

    public final void removeStatusListener(L2Character object) {
        this.getStatusListener().remove(object);
    }

    public final Set<L2Character> getStatusListener() {
        if (this._StatusListener == null) {
            this._StatusListener = new FastSet().shared();
        }
        return this._StatusListener;
    }

    public void reduceCp(int value) {
    }

    public void reduceHp(double value, L2Character attacker) {
        this.reduceHp(value, attacker, true, false, false);
    }

    public void reduceHp(double value, L2Character attacker, boolean isHpConsumption) {
        this.reduceHp(value, attacker, true, false, isHpConsumption);
    }

    public void reduceHp(double value, L2Character attacker, boolean awake, boolean isDOT, boolean isHPConsumption) {
        L2PcInstance attackerPlayer;
        if (this.getActiveChar().isDead()) {
            return;
        }
        if (this.getActiveChar().isInvul() && !isDOT && !isHPConsumption) {
            return;
        }
        if (attacker != null && (attackerPlayer = attacker.getActingPlayer()) != null && attackerPlayer.isGM() && !attackerPlayer.getAccessLevel().canGiveDamage()) {
            return;
        }
        if (!isDOT && !isHPConsumption) {
            this.getActiveChar().stopEffectsOnDamage(awake);
            if (this.getActiveChar().isStunned() && Rnd.get(10) == 0) {
                this.getActiveChar().stopStunning(true);
            }
        }
        if (value > 0.0) {
            this._hpReduced = true;
            this.setCurrentHp(Math.max(this.getCurrentHp() - value, 0.0));
        }
        if (this.getActiveChar().getCurrentHp() < 0.5 && this.getActiveChar().isMortal()) {
            this.getActiveChar().abortAttack();
            this.getActiveChar().abortCast();
            if (Config.DEBUG) {
                _log.fine("char is dead.");
            }
            this.getActiveChar().doDie(attacker);
        }
    }

    public void reduceMp(double value) {
        this.setCurrentMp(Math.max(this.getCurrentMp() - value, 0.0));
    }

    public final synchronized void startHpMpRegeneration() {
        if (this._regTask == null && !this.getActiveChar().isDead()) {
            if (Config.DEBUG) {
                _log.fine("HP/MP regen started");
            }
            int period = Formulas.getRegeneratePeriod(this.getActiveChar());
            this._regTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new RegenTask(), period, period);
        }
    }

    public final synchronized void stopHpMpRegeneration() {
        if (this._regTask != null) {
            L2Npc npc;
            List<Quest> eventQuests;
            if (Config.DEBUG) {
                _log.fine("HP/MP regen stop");
            }
            this._regTask.cancel(false);
            this._regTask = null;
            this._flagsRegenActive = 0;
            boolean hpReduced = this._hpReduced;
            this._hpReduced = false;
            if (hpReduced && this.getActiveChar().isNpc() && (eventQuests = (npc = (L2Npc)this.getActiveChar()).getTemplate().getEventQuests(QuestEventType.ON_REGENERATE)) != null) {
                ThreadPoolManager.getInstance().executeTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Quest quest : eventQuests) {
                            quest.notifyRegenerate(npc);
                        }
                    }
                });
            }
        }
    }

    public double getCurrentCp() {
        return 0.0;
    }

    public void setCurrentCp(double newCp) {
    }

    public final double getCurrentHp() {
        return this._currentHp;
    }

    public final void setCurrentHp(double newHp) {
        this.setCurrentHp(newHp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentHp(double newHp, boolean broadcastPacket) {
        boolean hpWasChanged;
        int currentHp = (int)this.getCurrentHp();
        double maxHp = this.getActiveChar().getStat().getMaxHp();
        CharStatus charStatus = this;
        synchronized (charStatus) {
            if (this.getActiveChar().isDead()) {
                return false;
            }
            if (newHp >= maxHp) {
                this._currentHp = maxHp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFE);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentHp = newHp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 1);
                this.startHpMpRegeneration();
            }
        }
        boolean bl = hpWasChanged = (double)currentHp != this._currentHp;
        if (hpWasChanged && broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
        return hpWasChanged;
    }

    public final void setCurrentHpMp(double newHp, double newMp) {
        boolean hpOrMpWasChanged = this.setCurrentHp(newHp, false);
        if (hpOrMpWasChanged |= this.setCurrentMp(newMp, false)) {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    public final double getCurrentMp() {
        return this._currentMp;
    }

    public final void setCurrentMp(double newMp) {
        this.setCurrentMp(newMp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setCurrentMp(double newMp, boolean broadcastPacket) {
        boolean mpWasChanged;
        int currentMp = (int)this.getCurrentMp();
        int maxMp = this.getActiveChar().getStat().getMaxMp();
        CharStatus charStatus = this;
        synchronized (charStatus) {
            if (this.getActiveChar().isDead()) {
                return false;
            }
            if (newMp >= (double)maxMp) {
                this._currentMp = maxMp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive & 0xFFFFFFFD);
                if (this._flagsRegenActive == 0) {
                    this.stopHpMpRegeneration();
                }
            } else {
                this._currentMp = newMp;
                this._flagsRegenActive = (byte)(this._flagsRegenActive | 2);
                this.startHpMpRegeneration();
            }
        }
        boolean bl = mpWasChanged = (double)currentMp != this._currentMp;
        if (mpWasChanged && broadcastPacket) {
            this.getActiveChar().broadcastStatusUpdate();
        }
        return mpWasChanged;
    }

    protected void doRegeneration() {
        CharStat charstat = this.getActiveChar().getStat();
        if (this.getCurrentHp() < (double)charstat.getMaxRecoverableHp()) {
            this.setCurrentHp(this.getCurrentHp() + Formulas.calcHpRegen(this.getActiveChar()), false);
        }
        if (this.getCurrentMp() < (double)charstat.getMaxRecoverableMp()) {
            this.setCurrentMp(this.getCurrentMp() + Formulas.calcMpRegen(this.getActiveChar()), false);
        }
        if (!this.getActiveChar().isInActiveRegion()) {
            if (this.getCurrentHp() == (double)charstat.getMaxRecoverableHp() && this.getCurrentMp() == (double)charstat.getMaxMp()) {
                this.stopHpMpRegeneration();
            }
        } else {
            this.getActiveChar().broadcastStatusUpdate();
        }
    }

    public L2Character getActiveChar() {
        return this._activeChar;
    }

    class RegenTask
    implements Runnable {
        RegenTask() {
        }

        @Override
        public void run() {
            try {
                CharStatus.this.doRegeneration();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

