/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.templates;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.NpcRace;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.Sex;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.templates.L2CharTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.drops.DropListScope;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.util.UnmodifiableArrayList;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class L2NpcTemplate
extends L2CharTemplate
implements IIdentifiable {
    private static final Logger _log = Logger.getLogger(L2NpcTemplate.class.getName());
    private int _id;
    private int _displayId;
    private byte _level;
    private String _type;
    private String _name;
    private boolean _usingServerSideName;
    private String _title;
    private boolean _usingServerSideTitle;
    private StatsSet _parameters;
    private NpcRace _race;
    private Sex _sex;
    private int _chestId;
    private int _rhandId;
    private int _lhandId;
    private int _weaponEnchant;
    private double _expRate;
    private double _sp;
    private double _raidPoints;
    private boolean _unique;
    private boolean _attackable;
    private boolean _targetable;
    private boolean _undying;
    private boolean _showName;
    private boolean _flying;
    private boolean _canMove;
    private boolean _noSleepMode;
    private boolean _passableDoor;
    private boolean _hasSummoner;
    private boolean _canBeSown;
    private int _corpseTime;
    private AIType _aiType;
    private int _aggroRange;
    private int _clanHelpRange;
    private int _knownRange;
    private int _dodge;
    private boolean _isChaos;
    private boolean _isAggressive;
    private int _soulShot;
    private int _spiritShot;
    private int _soulShotChance;
    private int _spiritShotChance;
    private int _minSkillChance;
    private int _maxSkillChance;
    private int _primarySkillId;
    private int _shortRangeSkillId;
    private int _shortRangeSkillChance;
    private int _longRangeSkillId;
    private int _longRangeSkillChance;
    private Skill[] _skills;
    private Map<AISkillScope, List<Skill>> _aiSkillLists;
    private int[] _clans;
    private int[] _enemyClans;
    private Map<DropListScope, List<IDropItem>> _dropLists;
    private double _collisionRadiusGrown;
    private double _collisionHeightGrown;
    private List<L2MinionData> _minions = L2NpcTemplate.emptyArrayList();
    private List<ClassId> _teachInfo = L2NpcTemplate.emptyArrayList();
    private final FastMap<QuestEventType, List<Quest>> _questEvents = new FastMap();

    public L2NpcTemplate(StatsSet set) {
        super(set);
    }

    @Override
    public void set(StatsSet set) {
        super.set(set);
        this._id = set.getInt("id");
        this._displayId = set.getInt("displayId", this._id);
        this._level = set.getByte("level", (byte)70);
        this._type = StringIntern.intern(set.getString("type", "L2Npc"));
        this._name = StringIntern.intern(set.getString("name", ""));
        this._usingServerSideName = set.getBoolean("usingServerSideName", false);
        this._title = StringIntern.intern(set.getString("title", ""));
        this._usingServerSideTitle = set.getBoolean("usingServerSideTitle", false);
        this._race = set.getEnum("race", NpcRace.class, NpcRace.ETC);
        this._sex = set.getEnum("sex", Sex.class, Sex.ETC);
        this._chestId = set.getInt("chestId", 0);
        this._rhandId = set.getInt("rhandId", 0);
        this._lhandId = set.getInt("lhandId", 0);
        this._weaponEnchant = set.getInt("weaponEnchant", 0);
        this._expRate = set.getDouble("expRate", 0.0);
        this._sp = set.getDouble("sp", 0.0);
        this._raidPoints = set.getDouble("raidPoints", 0.0);
        this._unique = set.getBoolean("unique", false);
        this._attackable = set.getBoolean("attackable", true);
        this._targetable = set.getBoolean("targetable", true);
        this._undying = set.getBoolean("undying", true);
        this._showName = set.getBoolean("showName", true);
        this._flying = set.getBoolean("flying", false);
        this._canMove = set.getBoolean("canMove", true);
        this._noSleepMode = set.getBoolean("noSleepMode", false);
        this._passableDoor = set.getBoolean("passableDoor", false);
        this._hasSummoner = set.getBoolean("hasSummoner", false);
        this._canBeSown = set.getBoolean("canBeSown", false);
        this._corpseTime = set.getInt("corpseTime", Config.DEFAULT_CORPSE_TIME);
        this._aiType = set.getEnum("aiType", AIType.class, AIType.FIGHTER);
        this._aggroRange = set.getInt("aggroRange", 0);
        this._clanHelpRange = set.getInt("clanHelpRange", 0);
        this._dodge = set.getInt("dodge", 0);
        this._isChaos = set.getBoolean("isChaos", false);
        this._isAggressive = L2NpcTemplate.isAggressiveType(this._type, set.getBoolean("isAggressive", true));
        this._soulShot = set.getInt("soulShot", 0);
        this._spiritShot = set.getInt("spiritShot", 0);
        this._soulShotChance = set.getInt("shotShotChance", 0);
        this._spiritShotChance = set.getInt("spiritShotChance", 0);
        this._minSkillChance = set.getInt("minSkillChance", 7);
        this._maxSkillChance = set.getInt("maxSkillChance", 15);
        this._primarySkillId = set.getInt("primarySkillId", 0);
        this._shortRangeSkillId = set.getInt("shortRangeSkillId", 0);
        this._shortRangeSkillChance = set.getInt("shortRangeSkillChance", 0);
        this._longRangeSkillId = set.getInt("longRangeSkillId", 0);
        this._longRangeSkillChance = set.getInt("longRangeSkillChance", 0);
        this._collisionRadiusGrown = set.getDouble("collisionRadiusGrown", 0.0);
        this._collisionHeightGrown = set.getDouble("collisionHeightGrown", 0.0);
        this._knownRange = 300;
        if (this._knownRange < this._aggroRange) {
            this._knownRange = this._aggroRange;
        }
        if (this._knownRange < this._clanHelpRange) {
            this._knownRange = this._clanHelpRange;
        }
        this._isAggressive = L2NpcTemplate.isAggressiveType(this._type, this._isAggressive);
        if (this._aggroRange == 0) {
            this._isAggressive = false;
        }
        if (!this._isAggressive) {
            this._aggroRange = 0;
        }
        if (InstanceType.isType(this._type, InstanceType.L2Attackable) && !L2NpcTemplate.canMove(this)) {
            this._canMove = false;
        }
        if (Arrays.binarySearch(Config.NON_MOVE_MONSTERS, this._id) >= 0) {
            this._canMove = false;
        }
    }

    public static boolean isAggressiveType(String type, boolean isAggressive) {
        return InstanceType.isTypes(type, InstanceType.L2ControllableMobInstance, InstanceType.L2FestivalMonsterInstance, InstanceType.L2FriendlyMobInstance) ? true : (InstanceType.isTypes(type, InstanceType.L2MonsterInstance, InstanceType.L2GuardInstance) ? isAggressive : false);
    }

    public static final boolean canMove(L2NpcTemplate template) {
        return !(template._aiType == AIType.CORPSE || template.getBaseMoveSpeed(MoveType.WALK) <= 1.0f && template.getBaseMoveSpeed(MoveType.RUN) <= 1.0f);
    }

    public static final boolean isNoRndWalk(L2NpcTemplate template) {
        return !template.canMove() || template.getAIType() == AIType.CORPSE || template.getBaseMoveSpeed(MoveType.WALK) <= 1.0f;
    }

    @Override
    public int getId() {
        return this._id;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public byte getLevel() {
        return this._level;
    }

    public String getType() {
        return this._type;
    }

    public boolean isType(String type) {
        return this.getType().equalsIgnoreCase(type);
    }

    public String getName() {
        return this._name;
    }

    public boolean isUsingServerSideName() {
        return this._usingServerSideName;
    }

    public String getTitle() {
        return this._title;
    }

    public boolean isUsingServerSideTitle() {
        return this._usingServerSideTitle;
    }

    public boolean hasParameters() {
        return this._parameters != null;
    }

    public StatsSet getParameters() {
        return this._parameters;
    }

    public void setParameters(StatsSet set) {
        this._parameters = set;
    }

    public NpcRace getRace() {
        return this._race;
    }

    public Sex getSex() {
        return this._sex;
    }

    public int getChestId() {
        return this._chestId;
    }

    public int getRHandId() {
        return this._rhandId;
    }

    public int getLHandId() {
        return this._lhandId;
    }

    public int getWeaponEnchant() {
        return this._weaponEnchant;
    }

    public double getExpRate() {
        return this._expRate;
    }

    public double getSP() {
        return this._sp;
    }

    public double getRaidPoints() {
        return this._raidPoints;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public boolean isAttackable() {
        return this._attackable;
    }

    public boolean isTargetable() {
        return this._targetable;
    }

    public boolean isUndying() {
        return this._undying;
    }

    public boolean isShowName() {
        return this._showName;
    }

    public boolean isFlying() {
        return this._flying;
    }

    public boolean canMove() {
        return this._canMove;
    }

    public void setCanMove(boolean value) {
        this._canMove = value;
    }

    public boolean isNoSleepMode() {
        return this._noSleepMode;
    }

    public boolean isPassableDoor() {
        return this._passableDoor;
    }

    public boolean hasSummoner() {
        return this._hasSummoner;
    }

    public boolean canBeSown() {
        return this._canBeSown;
    }

    public int getCorpseTime() {
        return this._corpseTime;
    }

    public AIType getAIType() {
        return this._aiType;
    }

    public int getAggroRange() {
        return this._aggroRange;
    }

    public int getClanHelpRange() {
        return this._clanHelpRange;
    }

    public int getKnownRange() {
        return this._knownRange;
    }

    public int getDodge() {
        return this._dodge;
    }

    public boolean isChaos() {
        return this._isChaos;
    }

    public boolean isAggressive() {
        return this._isAggressive;
    }

    public int getSoulShot() {
        return this._soulShot;
    }

    public int getSpiritShot() {
        return this._spiritShot;
    }

    public int getSoulShotChance() {
        return this._soulShotChance;
    }

    public int getSpiritShotChance() {
        return this._spiritShotChance;
    }

    public int getMinSkillChance() {
        return this._minSkillChance;
    }

    public int getMaxSkillChance() {
        return this._maxSkillChance;
    }

    public int getPrimarySkillId() {
        return this._primarySkillId;
    }

    public int getShortRangeSkillId() {
        return this._shortRangeSkillId;
    }

    public int getShortRangeSkillChance() {
        return this._shortRangeSkillChance;
    }

    public int getLongRangeSkillId() {
        return this._longRangeSkillId;
    }

    public int getLongRangeSkillChance() {
        return this._longRangeSkillChance;
    }

    @Override
    public Skill[] getSkills() {
        return this._skills;
    }

    public void setSkills(ArrayList<Skill> skills) {
        this._skills = skills != null && skills.size() > 0 ? skills.toArray(Skill.EMPTY_SKILL_LIST) : Skill.EMPTY_SKILL_LIST;
    }

    public List<Skill> getAISkills(AISkillScope aiSkillScope) {
        List<Skill> aiSkills = this._aiSkillLists.get((Object)aiSkillScope);
        return aiSkills != null ? aiSkills : Collections.emptyList();
    }

    public void setAISkillLists(EnumMap<AISkillScope, List<Skill>> aiSkillLists) {
        Map<Object, Object> map = this._aiSkillLists = aiSkillLists != null && !aiSkillLists.isEmpty() ? Collections.unmodifiableMap(aiSkillLists) : Collections.emptyMap();
        if (aiSkillLists != null) {
            for (Map.Entry<AISkillScope, List<Skill>> e : aiSkillLists.entrySet()) {
                e.setValue(new UnmodifiableArrayList(e.getValue()));
            }
        }
    }

    public int[] getClans() {
        return this._clans;
    }

    public void setClans(int[] clans) {
        this._clans = clans;
    }

    public boolean isClan(int[] clans) {
        int[] clanSet = this._clans;
        if (clanSet == null || clans == null) {
            return false;
        }
        if (clanSet == clans) {
            return true;
        }
        for (int clanId : clans) {
            if (!Util.contains(clanSet, clanId)) continue;
            return true;
        }
        return false;
    }

    public int[] getEnemyClans() {
        return this._enemyClans;
    }

    public void setEnemyClans(int[] enemyClans) {
        this._enemyClans = enemyClans;
    }

    public boolean isEnemyClan(int[] clans) {
        int[] enemyClans = this._enemyClans;
        if (enemyClans == null || clans == null) {
            return false;
        }
        if (enemyClans == clans) {
            return true;
        }
        for (int clanId : clans) {
            if (!Util.contains(enemyClans, clanId)) continue;
            return true;
        }
        return false;
    }

    public String getClanNames() {
        return NpcData.getInstance().toClanNames(this._clans);
    }

    public String getEnemyClanNames() {
        return NpcData.getInstance().toClanNames(this._enemyClans);
    }

    public Map<DropListScope, List<IDropItem>> getDropLists() {
        return this._dropLists;
    }

    public void setDropLists(Map<DropListScope, List<IDropItem>> dropLists) {
        this._dropLists = dropLists != null ? Collections.unmodifiableMap(dropLists) : null;
    }

    public List<IDropItem> getDropList(DropListScope dropListScope) {
        Map<DropListScope, List<IDropItem>> dropLists = this._dropLists;
        return dropLists != null ? dropLists.get((Object)dropListScope) : null;
    }

    public List<ItemHolder> calculateDrops(DropListScope dropListScope, L2Character victim, L2Character killer) {
        List<IDropItem> dropList = this.getDropList(dropListScope);
        if (dropList == null) {
            return null;
        }
        ArrayList<ItemHolder> calculatedDrops = null;
        for (IDropItem dropItem : dropList) {
            List<ItemHolder> drops = dropItem.calculateDrops(victim, killer);
            if (drops == null || drops.isEmpty()) continue;
            if (calculatedDrops == null) {
                calculatedDrops = new ArrayList<ItemHolder>(drops.size());
            }
            calculatedDrops.addAll(drops);
        }
        return calculatedDrops;
    }

    public double getCollisionRadiusGrown() {
        return this._collisionRadiusGrown;
    }

    public double getCollisionHeightGrown() {
        return this._collisionHeightGrown;
    }

    public static boolean isAssignableTo(Class<?> sub, Class<?> clazz) {
        if (clazz.isInterface()) {
            Class<?>[] interfaces;
            for (Class<?> interface1 : interfaces = sub.getInterfaces()) {
                if (!clazz.getName().equals(interface1.getName())) continue;
                return true;
            }
        } else {
            do {
                if (!sub.getName().equals(clazz.getName())) continue;
                return true;
            } while ((sub = sub.getSuperclass()) != null);
        }
        return false;
    }

    public static boolean isAssignableTo(Object obj, Class<?> clazz) {
        return L2NpcTemplate.isAssignableTo(obj.getClass(), clazz);
    }

    private static final <T> List<T> emptyArrayList() {
        return Collections.emptyList();
    }

    public void addQuestEvent(QuestEventType eventType, Quest q) {
        ArrayList<Quest> quests = (ArrayList<Quest>)this._questEvents.get((Object)eventType);
        if (quests == null) {
            quests = new ArrayList<Quest>();
            this._questEvents.put((Object)eventType, quests);
        }
        if (!eventType.isMultipleRegistrationAllowed() && !quests.isEmpty()) {
            _log.warning("Quest event not allowed in multiple quests.  Skipped addition of Event Type \"" + (Object)((Object)eventType) + "\" for NPC \"" + this._name + "\" and quest \"" + q.getName() + "\".");
        } else {
            quests.add(q);
        }
        int i = quests.size() - 1;
        while (--i >= 0) {
            if (!((Quest)quests.get(i)).getName().equals("L2AttackableAIScript")) continue;
            quests.add((Quest)quests.remove(i));
        }
        if (eventType == QuestEventType.ON_SPAWN && !q.getName().equals("L2AttackableAIScript")) {
            boolean hasOnSpawn;
            try {
                q.getClass().getDeclaredMethod("onSpawn", L2Npc.class);
                hasOnSpawn = true;
            }
            catch (NoSuchMethodException | SecurityException e) {
                hasOnSpawn = false;
            }
            if (hasOnSpawn) {
                boolean done = false;
                for (L2Spawn spawn : SpawnTable.getInstance().getSpawns(this._id)) {
                    L2Npc npc = spawn.getLastSpawn();
                    if (npc == null || !npc.isVisible()) continue;
                    done = true;
                    q.onSpawn(npc);
                }
                if (!done) {
                    for (L2Object o : L2World.getInstance().getVisibleObjects()) {
                        if (!o.isNpc() || o.getId() != this._id) continue;
                        q.onSpawn((L2Npc)o);
                    }
                }
            }
        }
    }

    public void removeQuest(Quest q) {
        for (Map.Entry entry : this._questEvents.entrySet()) {
            if (!((List)entry.getValue()).contains(q)) continue;
            Iterator it = ((List)entry.getValue()).iterator();
            while (it.hasNext()) {
                Quest q1 = (Quest)it.next();
                if (q1 != q) continue;
                it.remove();
            }
            if (!((List)entry.getValue()).isEmpty()) continue;
            this._questEvents.remove(entry.getKey());
        }
    }

    public void addMinionData(L2MinionData minion) {
        if (this._minions == Collections.EMPTY_LIST) {
            this._minions = new ArrayList<L2MinionData>();
        }
        this._minions.add(minion);
    }

    public boolean canTeach(ClassId classId) {
        if (classId.level() == 3) {
            return this._teachInfo.contains(classId.getParent());
        }
        return this._teachInfo.contains(classId);
    }

    public Map<QuestEventType, List<Quest>> getEventQuests() {
        return this._questEvents;
    }

    public List<Quest> getEventQuests(QuestEventType EventType2) {
        return (List)this._questEvents.get((Object)EventType2);
    }

    public List<L2MinionData> getMinionData() {
        return this._minions;
    }

    public int getNpcId() {
        return this.getId();
    }

    public List<ClassId> getTeachInfo() {
        return this._teachInfo;
    }

    public void setTeachInfo(List<ClassId> teachInfo) {
        this._teachInfo = teachInfo;
    }
}

