/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.transform;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.transform.TransformLevelData;
import com.l2jserver.gameserver.model.holders.AdditionalItemHolder;
import com.l2jserver.gameserver.model.holders.AdditionalSkillHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jp.sf.l2j.arrayMaps.SortedIntDoubleArrayMap;
import jp.sf.l2j.arrayMaps.SortedIntFloatArrayMap;
import jp.sf.l2j.arrayMaps.SortedIntIntArrayMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class TransformTemplate {
    private final double _collisionRadius;
    private final double _collisionHeight;
    private final L2WeaponType _baseAttackType;
    private final int _baseAttackRange;
    private final double _baseRandomDamage;
    private List<SkillHolder> _skills;
    private List<AdditionalSkillHolder> _additionalSkills;
    private List<AdditionalItemHolder> _additionalItems;
    private SortedIntIntArrayMap _baseDefense;
    private SortedIntDoubleArrayMap _baseStats;
    private SortedIntFloatArrayMap _baseSpeed;
    private ExBasicActionList _list;
    private final FastIntObjectMap<TransformLevelData> _data = new FastIntObjectMap(100);

    public TransformTemplate(StatsSet set) {
        this._collisionRadius = set.getDouble("radius", 0.0);
        this._collisionHeight = set.getDouble("height", 0.0);
        this._baseAttackType = L2WeaponType.findByName(set.getString("attackType", "FIST"));
        this._baseAttackRange = set.getInt("range", 40);
        this._baseRandomDamage = set.getDouble("randomDamage", 0.0);
        this.addSpeed(MoveType.WALK, set.getFloat("walk", 0.0f));
        this.addSpeed(MoveType.RUN, set.getFloat("run", 0.0f));
        this.addSpeed(MoveType.SLOW_SWIM, set.getFloat("waterWalk", 0.0f));
        this.addSpeed(MoveType.FAST_SWIM, set.getFloat("waterRun", 0.0f));
        this.addSpeed(MoveType.SLOW_FLY, set.getFloat("flyWalk", 0.0f));
        this.addSpeed(MoveType.FAST_FLY, set.getFloat("flyRun", 0.0f));
        this.addStats(Stats.POWER_ATTACK, set.getDouble("pAtk", 0.0));
        this.addStats(Stats.MAGIC_ATTACK, set.getDouble("mAtk", 0.0));
        this.addStats(Stats.POWER_ATTACK_RANGE, set.getInt("range", 0));
        this.addStats(Stats.POWER_ATTACK_SPEED, set.getInt("attackSpeed", 0));
        this.addStats(Stats.CRITICAL_RATE, set.getInt("critRate", 0));
        this.addStats(Stats.STAT_STR, set.getInt("str", 0));
        this.addStats(Stats.STAT_INT, set.getInt("int", 0));
        this.addStats(Stats.STAT_CON, set.getInt("con", 0));
        this.addStats(Stats.STAT_DEX, set.getInt("dex", 0));
        this.addStats(Stats.STAT_WIT, set.getInt("wit", 0));
        this.addStats(Stats.STAT_MEN, set.getInt("men", 0));
        this.addDefense(6, set.getInt("chest", 0));
        this.addDefense(11, set.getInt("legs", 0));
        this.addDefense(1, set.getInt("head", 0));
        this.addDefense(12, set.getInt("feet", 0));
        this.addDefense(10, set.getInt("gloves", 0));
        this.addDefense(0, set.getInt("underwear", 0));
        this.addDefense(23, set.getInt("cloak", 0));
        this.addDefense(8, set.getInt("rear", 0));
        this.addDefense(9, set.getInt("lear", 0));
        this.addDefense(13, set.getInt("rfinger", 0));
        this.addDefense(14, set.getInt("lfinger", 0));
        this.addDefense(4, set.getInt("neck", 0));
    }

    private void addSpeed(MoveType type, float val) {
        if (this._baseSpeed == null) {
            this._baseSpeed = new SortedIntFloatArrayMap();
        }
        this._baseSpeed.put(type.ordinal(), val);
    }

    public float getBaseMoveSpeed(MoveType type) {
        if (this._baseSpeed == null || !this._baseSpeed.containsKey(type.ordinal())) {
            return 0.0f;
        }
        return this._baseSpeed.get(type.ordinal());
    }

    private void addDefense(int type, int val) {
        if (this._baseDefense == null) {
            this._baseDefense = new SortedIntIntArrayMap();
        }
        this._baseDefense.put(type, val);
    }

    public int getDefense(int type) {
        if (this._baseDefense == null || !this._baseDefense.containsKey(type)) {
            return 0;
        }
        return this._baseDefense.get(type);
    }

    private void addStats(Stats stats, double val) {
        if (this._baseStats == null) {
            this._baseStats = new SortedIntDoubleArrayMap();
        }
        this._baseStats.put(stats.ordinal(), val);
    }

    public double getStats(Stats stats) {
        if (this._baseStats == null || !this._baseStats.containsKey(stats.ordinal())) {
            return 0.0;
        }
        return this._baseStats.get(stats.ordinal());
    }

    public double getCollisionRadius() {
        return this._collisionRadius;
    }

    public double getCollisionHeight() {
        return this._collisionHeight;
    }

    public L2WeaponType getBaseAttackType() {
        return this._baseAttackType;
    }

    public int getBaseAttackRange() {
        return this._baseAttackRange;
    }

    public double getBaseRandomDamage() {
        return this._baseRandomDamage;
    }

    public void addSkill(SkillHolder holder) {
        if (this._skills == null) {
            this._skills = new ArrayList<SkillHolder>();
        }
        this._skills.add(holder);
    }

    public List<SkillHolder> getSkills() {
        return this._skills != null ? this._skills : Collections.emptyList();
    }

    public void addAdditionalSkill(AdditionalSkillHolder holder) {
        if (this._additionalSkills == null) {
            this._additionalSkills = new ArrayList<AdditionalSkillHolder>();
        }
        this._additionalSkills.add(holder);
    }

    public List<AdditionalSkillHolder> getAdditionalSkills() {
        return this._additionalSkills != null ? this._additionalSkills : Collections.emptyList();
    }

    public void addAdditionalItem(AdditionalItemHolder holder) {
        if (this._additionalItems == null) {
            this._additionalItems = new ArrayList<AdditionalItemHolder>();
        }
        this._additionalItems.add(holder);
    }

    public List<AdditionalItemHolder> getAdditionalItems() {
        return this._additionalItems != null ? this._additionalItems : Collections.emptyList();
    }

    public void setBasicActionList(ExBasicActionList list) {
        this._list = list;
    }

    public ExBasicActionList getBasicActionList() {
        return this._list;
    }

    public boolean hasBasicActionList() {
        return this._list != null;
    }

    public void addLevelData(TransformLevelData data) {
        this._data.put(data.getLevel(), (Object)data);
    }

    public TransformLevelData getData(int level) {
        return (TransformLevelData)this._data.get(level);
    }
}

