/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.gameserver.datatables.ClassListData;
import com.l2jserver.gameserver.model.base.ClassId;

public final class ClassInfo {
    private final ClassId _classId;
    private final String _className;
    private final String _classServName;
    private final ClassId _parentClassId;

    public ClassInfo(ClassId classId, String className, String classServName, ClassId parentClassId) {
        this._classId = classId;
        this._className = className;
        this._classServName = classServName;
        this._parentClassId = parentClassId;
    }

    public ClassId getClassId() {
        return this._classId;
    }

    public String getClassName() {
        return this._className;
    }

    public static String getClassName(int id) {
        return ClassListData.getInstance().getClass(id).getClassName();
    }

    public static String toHtm(int id) {
        return ClassInfo.toHtmW(id);
    }

    public static String toHtmW(int id) {
        return "<FSTRING>" + (1811000 + id) + "</FSTRING>";
    }

    public static String toHtmN(int id) {
        int classClientId = id;
        if (classClientId >= 0 && classClientId <= 57) {
            classClientId += 247;
        } else if (classClientId >= 88 && classClientId <= 118) {
            classClientId += 1071;
        } else if (classClientId >= 123 && classClientId <= 136) {
            classClientId += 1438;
        } else {
            return null;
        }
        return "&$" + classClientId + ";";
    }

    public String toHtm() {
        return ClassInfo.toHtm(this.getClassId().getId());
    }

    public String toHtmW() {
        return ClassInfo.toHtmW(this.getClassId().getId());
    }

    public String toHtmN() {
        return ClassInfo.toHtmN(this.getClassId().getId());
    }

    public String getClientCode() {
        return this.toHtm();
    }

    public String getEscapedClientCode() {
        return this.toHtm();
    }

    public String getClassServName() {
        return this._classServName;
    }

    public ClassId getParentClassId() {
        return this._parentClassId;
    }
}

